<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_opencast', language 'de', version '3.10'.
 *
 * @package     block_opencast
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesspolicies'] = 'Zugriffsrechte';
$string['acl_settingcontrolafter'] = 'Sichtbarkeit von Episoden nach der Verarbeitung ändern';
$string['acl_settingcontrolafter_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen die Sichtbarkeit einer Opencast Episode nach der Verarbeitung der Episode ändern';
$string['acl_settingcontrolgroup'] = 'Beschränkung der Sichtbarkeit auf Gruppen erlauben';
$string['acl_settingcontrolgroup_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen nicht nur die Sichtbarkeit einer Opencast Episode für alle Teilnehmer/innen ändern, sondern die Sichtbarkeit auch auf Gruppen einschränken.';
$string['acl_settingheader'] = 'Sichtbarkeit von Episoden ändern';
$string['aclgroupdeleted'] = 'Zugriff für das Video \'{$a->title}\' wurde eingeschränkt';
$string['aclnothingtobesaved'] = 'Es wurden keine Änderungen an der Sichtbarkeit vorgenommen.';
$string['aclrolesadded'] = 'Die Sichtbarkeit wurde geändert, so dass Teilnehmer/innen dieses Kurses Zugriff auf das folgendes Video haben: {$a->title}<br />Laden Sie diese Seite nach einiger Zeit neu, um den aktuellen Status der Sichtbarkeit zu sehen.';
$string['aclrolesaddedgroup'] = 'Die Sichtbarkeit wurde geändert, so dass Teilnehmer/innen der gewählten Gruppe Zugriff auf das folgendes Video haben: {$a->title}<br />Laden Sie diese Seite nach einiger Zeit neu, um den aktuellen Status der Sichtbarkeit zu sehen.';
$string['aclroleschangeerror'] = 'Es ist ein Fehler während der Sichtbarkeitsänderung für folgendes Video aufgetreten: {$a->title}<br />Einige Änderungen wurden möglicherweise nicht gespeichert. Sollte das Problem wiederholt auftreten, wenden Sie an Ihren Support.';
$string['aclrolesdeleted'] = 'Die Sichtbarkeit wurde geändert, so dass keine Teilnehmer/innen mehr Zugriff auf das folgendes Video haben: {$a->title}<br />Laden Sie diese Seite nach einiger Zeit neu, um den aktuellen Status der Sichtbarkeit zu sehen.';
$string['aclrolesname'] = 'Rollen';
$string['aclrolesnamedesc'] = 'Der Platzhalter [COURSEID] kann im Rollennamen verwendet werden und wird automatisch ersetzt.';
$string['actions'] = 'kommagetrennte Liste von Aktionen';
$string['addcatalog'] = 'Neues Metadatum hinzufügen';
$string['additional_settings'] = 'Zusätzliche Funktionen';
$string['addlti_addbuttonexplanation'] = 'Die Videos, die zu diesem Kurs hinzugefügt werden bzw. in diesem verfügbar sind, werden den Teilnehmer/innen nicht automatisch angezeigt.</br>Hier können Sie eine Opencast-Serien-Aktivität zum Kurs hinzufügen, welche den Teilnehmer/innen alle sichtbaren Videos anbietet.';
$string['addlti_addbuttontitle'] = 'Opencast-LTI-Serien-Aktivität zum Kurs hinzufügen';
$string['addlti_addbuttontitlereturncourse'] = 'Aktivität hinzufügen und zurück zum Kurs';
$string['addlti_addbuttontitlereturnoverview'] = 'Aktivität hinzufügen und zurück zur Übersicht';
$string['addlti_defaulttitle'] = 'Opencast Videos';
$string['addlti_errornotenabledorworking'] = 'Die \'Opencast-Serien-Aktivität zum Kurs hinzufügen\' Funktion ist entweder nicht aktiviert oder funktioniert nicht.';
$string['addlti_formltiavailability'] = 'Voraussetzungen der Opencast-Serien-Aktivität';
$string['addlti_formltiintro'] = 'Beschreibung der Opencast-Serien-Aktivität';
$string['addlti_formltisection'] = 'Kursabschnitt der Opencast-Serien-Aktivität';
$string['addlti_formltititle'] = 'Titel der Opencast-Serien-Aktivität';
$string['addlti_header'] = 'Videos zur Verfügung stellen (LTI)';
$string['addlti_modulecreated'] = 'Die Serien-Aktivität \'{$a}\' wurde zum Kurs hinzugefügt.';
$string['addlti_moduleexists'] = 'Es gibt bereits eine Opencast-Serien-Aktivität in diesem Kurs. Es ist nicht notwendig eine zweite hinzuzufügen.';
$string['addlti_modulenotcreated'] = 'Die Serien-Aktivität \'{$a}\' konnte nicht zum Kurs hinzugefügt werden. Versuchen Sie es erneut oder kontaktieren Sie Ihren Support.';
$string['addlti_noemptytitle'] = 'Sie müssen einen Namen für die Opencast-Serien-Aktivität angeben oder den standardmäßigen Namen "{$a}" verwenden.';
$string['addlti_settingavailability'] = 'Voraussetzungen zur LTI-Serien-Aktivität';
$string['addlti_settingavailability_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen die Voraussetzungen für die Aktivität setzen, wenn die Opencast LTI-Serien-Aktivität zum Kurs hinzugefügt wird.';
$string['addlti_settingavailability_note'] = 'Bitte beachten Sie: Diese Funktion steht nur zur Verfügung, wenn Voraussetzungen in Moodle auf der {$a} Einstellungsseite aktiviert sind.';
$string['addlti_settingdefaulttitle'] = 'Standard-Titel der LTI-Serien-Aktivität.';
$string['addlti_settingdefaulttitle_desc'] = 'Der standardmäßige Titel der LTI-Aktivität wird verwendet, wenn eine neue Opencast LTI-Serien-Aktivität angelegt wird.';
$string['addlti_settingenabled'] = '"LTI-Serien-Aktivität hinzufügen" aktivieren';
$string['addlti_settingenabled_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen eine Opencast LTI-Serien-Aktivität zum Kurs hinzufügen. Diese LTI-Serien-Aktivität wird die Opencast-Serie des Kurses anzeigen.';
$string['addlti_settingheader'] = 'Opencast LTI-Serien-Aktivität zum Kurs hinzufügen';
$string['addlti_settingintro'] = 'Beschreibung zur LTI-Serien-Aktivität';
$string['addlti_settingintro_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen eine Beschreibung zur Opencast LTI-Serien-Aktivität hinzufügen. Diese Beschreibung wird auf der Kursseite angezeigt werden.';
$string['addlti_settingpreconfiguredtool'] = 'Vorkonfiguriertes LTI-Serien-Tool';
$string['addlti_settingpreconfiguredtool_desc'] = 'Das vorkonfiguriertes LTI-Serien-Tool wird verwendet, wenn eine neue Opencast LTI-Serien-Aktivität zum Kurs hinzugefügt wird.';
$string['addlti_settingpreconfiguredtool_notools'] = 'Kein vorkonfiguriertes LTI-Tool gefunden. Legen Sie zuerst ein Opencast LTI-Serien-Tool über die Einstellungsseite unter {$a} an.';
$string['addlti_settingsection'] = 'Kursabschnitt der LTI-Serien-Aktivität';
$string['addlti_settingsection_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen den Kursabschnitt wählen, zu welchem die Opencast LTI-Serien-Aktivität hinzugefügt wird.';
$string['addlti_viewbuttonexplanation'] = 'Eine Opencast-Serien-Aktivität, die alle verfügbaren Videos im Kurs anzeigt, wurde bereits hinzugefügt.';
$string['addlti_viewbuttontitle'] = 'Opencast-Serien-Aktivität im Kurs anzeigen';
$string['addltiepisode_addbuttontitlereturncourse'] = 'Aktivität hinzufügen und zurück zum Kurs';
$string['addltiepisode_addbuttontitlereturnoverview'] = 'Aktivität hinzufügen und zurück zur Übersicht';
$string['addltiepisode_addicontitle'] = 'Opencast-Einzelvideo-Aktivität zum Kurs hinzufügen';
$string['addltiepisode_defaulttitle'] = 'Opencast Einzelvideo';
$string['addltiepisode_errorepisodeuuidnotvalid'] = 'Die vorliegende UUID des Einzelvideos ist nicht gültig';
$string['addltiepisode_errornotenabledorworking'] = 'Die \'Opencast-Einzelvideo-Aktivität zum Kurs hinzufügen\' Funktion ist entweder nicht aktiviert oder funktioniert nicht.';
$string['addltiepisode_explanation'] = 'Zusätzlich können Sie in der obenstehenden Tabelle Aktivitäten für Opencast Einzelvideos zu Ihrem Kurs hinzufügen um Ihren Teilnehmer/innen ein einzelnes Video bereitzustellen.';
$string['addltiepisode_formltiavailability'] = 'Voraussetzungen der Opencast-Einzelvideo-Aktivität';
$string['addltiepisode_formltiintro'] = 'Beschreibung der Opencast-Einzelvideo-Aktivität';
$string['addltiepisode_formltisection'] = 'Kursabschnitt der Opencast-Einzelvideo-Aktivität';
$string['addltiepisode_formltititle'] = 'Titel der Opencast-Einzelvideo-Aktivität';
$string['addltiepisode_modulecreated'] = 'Die Einzelvideo-Aktivität \'{$a}\' wurde zum Kurs hinzugefügt.';
$string['addltiepisode_moduleexists'] = 'Es gibt bereits eine Opencast-Einzelvideo-Aktivität in diesem Kurs. Es ist nicht notwendig eine zweite hinzuzufügen.';
$string['addltiepisode_modulenotcreated'] = 'Die Einzelvideo-Aktivität \'{$a}\' konnte nicht zum Kurs hinzugefügt werden. Versuchen Sie es erneut oder kontaktieren Sie Ihren Support.';
$string['addltiepisode_noemptytitle'] = 'Sie müssen einen Namen für die Opencast-Einzelvideo-Aktivität angeben oder den standardmäßigen Namen "{$a}" verwenden.';
$string['addltiepisode_settingavailability'] = 'Voraussetzungen zur LTI-Einzelvideo-Aktivität';
$string['addltiepisode_settingavailability_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen die Voraussetzungen für die Aktivität setzen, wenn die Opencast LTI-Einzelvideo-Aktivität zum Kurs hinzugefügt wird.';
$string['addltiepisode_settingenabled'] = '"LTI-Einzelvideo-Aktivität hinzufügen" aktivieren';
$string['addltiepisode_settingenabled_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen eine Opencast LTI-Einzelvideo-Aktivität zum Kurs hinzufügen. Diese LTI-Einzelvideo-Aktivität wird eine einzelne Opencast Episode anzeigen.';
$string['addltiepisode_settingheader'] = 'Opencast LTI-Einzelvideo-Aktivität zum Kurs hinzufügen';
$string['addltiepisode_settingintro'] = 'Beschreibung zur LTI-Einzelvideo-Aktivität';
$string['addltiepisode_settingintro_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen eine Beschreibung zur Opencast LTI-Einzelvideo-Aktivität hinzufügen. Diese Beschreibung wird auf der Kursseite angezeigt werden.';
$string['addltiepisode_settingpreconfiguredtool'] = 'Vorkonfiguriertes LTI-Einzelvideo-Tool';
$string['addltiepisode_settingpreconfiguredtool_desc'] = 'Das vorkonfiguriertes LTI-Einzelvideo-Tool wird verwendet, wenn eine neue Opencast LTI-Einzelvideo-Aktivität zum Kurs hinzugefügt wird.';
$string['addltiepisode_settingpreconfiguredtool_notools'] = 'Kein vorkonfiguriertes LTI-Tool gefunden. Legen Sie zuerst ein Opencast LTI-Einzelvideo-Tool über die Einstellungsseite unter {$a} an.';
$string['addltiepisode_settingsection'] = 'Kursabschnitt der LTI-Einzelvideo-Aktivität';
$string['addltiepisode_settingsection_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen den Kursabschnitt wählen, zu welchem die Opencast LTI-Einzelvideo-Aktivität hinzugefügt wird.';
$string['addltiepisode_viewicontitle'] = 'Opencast-Einzelvideo-Aktivität im Kurs anzeigen';
$string['addrole'] = 'Neue Rolle hinzufügen';
$string['addvideo'] = 'Video hinzufügen';
$string['adhocfiledeletion'] = 'Videodatei in Moodle löschen';
$string['adminchoice_noconnection'] = '– Workflows konnten nicht ermittelt werden –';
$string['adminchoice_noworkflow'] = '-- kein Workflow --';
$string['allowunassign'] = 'Erlauben, die Zuordnung zum Kurs aufzuheben';
$string['allowunassigndesc'] = 'Die Zuordnung einer Serie löschen, um die Sichtbarkeit in Datei-Browser und Kurs-Listen zu kontrollieren. Dieses Feature steht nur zur Verfügung, wenn Episoden unabhängig von einer Serie in Opencast möglich sind. Bitte fragen Sie vor der Aktivierung den Administrator Ihres Opencast-Systems.';
$string['appearance_overview_settingheader'] = 'Überblicksseite';
$string['appearance_overview_settingshowenddate'] = 'Enddatum anzeigen';
$string['appearance_overview_settingshowenddate_desc'] = 'Wenn diese Option aktiv ist, wird in der Tabelle verfügbarer Videos auf der Überblicksseite eine Spalte enthalten sein, welche das Enddatum der Opencast Episoden ausgibt.';
$string['appearance_overview_settingshowlocation'] = 'Raum anzeigen';
$string['appearance_overview_settingshowlocation_desc'] = 'Wenn diese Option aktiv ist, wird in der Tabelle verfügbarer Videos auf der Überblicksseite eine Spalte enthalten sein, welche den Raum der Opencast Episoden ausgibt.';
$string['appearance_overview_settingshowpublicationchannels'] = 'Publikationskanäle anzeigen';
$string['appearance_overview_settingshowpublicationchannels_desc'] = 'Wenn diese Option aktiv ist, wird in der Tabelle verfügbarer Videos auf der Überblicksseite eine Spalte enthalten sein, welche die Publikationskanäle der Opencast Episoden ausgibt. Dieselbe Information wird auch auf der Seite, auf der Opencast Episoden gelöscht werden, ausgegeben werden.';
$string['appearance_settings'] = 'Erscheinungsbild';
$string['backupopencastvideos'] = 'Opencast Videos in diesem Kurs einbeziehen';
$string['blocksettings'] = 'Einstellungen für einen Opencast-Block';
$string['changevisibility'] = 'Sichtbarkeit ändern';
$string['changevisibility_group'] = 'Das Video ist für alle Teilnehmer/innen ausgewählter Gruppen sichtbar. Bitte klicken, um die Sichtbarkeit zu ändern.';
$string['changevisibility_header'] = 'Sichtbarkeit für {$a->title} ändern';
$string['changevisibility_hidden'] = 'Das Video ist für Teilnehmer/innen nicht sichtbar. Bitte klicken, um die Sichtbarkeit zu ändern.';
$string['changevisibility_mixed'] = 'Der Sichtbarkeitsstatus des Videos ist ungültig. Bitte klicken, um die richtige Sichtbarkeit auszuwählen.';
$string['changevisibility_visible'] = 'Das Video ist für alle Teilnehmer/innen des Kurses sichtbar. Bitte klicken, um die Sichtbarkeit zu ändern.';
$string['connection_failure'] = 'Der Opencast Server kann nicht erreicht werden.';
$string['contributor'] = 'Mitwirkende';
$string['created'] = 'Erstellt am';
$string['createdby'] = 'Hochgeladen von';
$string['createseriesforcourse'] = 'Neue Serie anlegen';
$string['creator'] = 'Vortragende(r)';
$string['cronsettings'] = 'Einstellungen für das Hochladen';
$string['date'] = 'Startdatum';
$string['deleteaclgroup'] = 'Video aus dieser Liste löschen.';
$string['deletedraft'] = 'Eine Episode vor der Übertragung nach Opencast löschen';
$string['deletedraftdesc'] = 'Sie sind im Begriff, dieses Video vor der Übertragung nach Opencast zu löschen.<br />Es wird aus der Warteschlange entfernt und nicht verarbeitet werden. Bitte fahren Sie nicht fort, es sei denn, Sie sind sich absolut sicher.';
$string['deleteevent'] = 'Eine Episode in Opencast löschen';
$string['deleteeventdesc'] = 'Sie sind im Begriff, dieses Video dauerhaft und irreversibel aus Opencast zu löschen.<br />Alle eingebetteten Links zu diesem Video werden ungültig. Bitte fahren Sie nicht fort, es sei denn, Sie sind sich absolut sicher.';
$string['deletegroupacldesc'] = 'Sie sind im Begriff, den Zugang zu diesem Video aus diesem Kurs zu löschen.<br />Wenn der Zugang gelöscht ist, wird das Video nicht im Datei-Browser und in der Übersicht der verfügbaren Videos angezeigt. Bereits eingebettete Videos sind davon nicht betroffen.<br />Das Video wird in Opencast nicht gelöscht.';
$string['deleteworkflow'] = 'Bevor eine Episode gelöscht wird, Workflow starten';
$string['deleteworkflowdesc'] = 'Bevor ein Video gelöscht wird, kann ein Workflow definiert werden, der die Verbindungen der Episode zu den verschiedenen Publikationskanälen kappt.';
$string['deleting'] = 'Wird gelöscht';
$string['description'] = 'Beschreibung';
$string['dodeleteaclgroup'] = 'Videozugriff aus diesem Kurs löschen';
$string['dodeletedraft'] = 'Video vor der Übertragung nach Opencast löschen';
$string['dodeleteevent'] = 'Video endgültig löschen';
$string['duplicateworkflow'] = 'Workflow zum Duplizieren von Opencast Videos';
$string['duplicateworkflowdesc'] = 'Dieser Workflow wird benötigt um Opencast Videos von einem Kurs in einen anderen zu importieren. Solange kein Workflow gesetzt ist, ist es nicht möglich Opencast Videos zu importieren.';
$string['duration'] = 'Dauer';
$string['editseriesforcourse'] = 'Serie bearbeiten';
$string['emptyvideouploaderror'] = 'Sie müssen entweder ein Präsentator-Video oder ein Präsentations-Video hochladen.';
$string['enableopencaststudiolink'] = 'Link zu Opencast Studio anzeigen';
$string['enableopencaststudiolink_desc'] = 'Wenn diese Option aktiv ist, wird im Block sowie auf der Überblicksseite ein Button für die Aufnahme mit Opencast Studio angezeigt werden.
Opencast Studio muss auf Ihrem Opencast Admin Node laufen und die folgenden LTI Einstellungen müssen ausgefüllt sein.';
$string['errorgetblockvideos'] = 'Liste kann nicht geladen werden (Error: {$a})';
$string['eventdeleted'] = 'Das Video wurde gelöscht.';
$string['eventdeletedfailed'] = 'Löschen der Episode fehlgeschlagen';
$string['eventdeletionstarted'] = 'Das Video wird in Kürze gelöscht.';
$string['eventuploadfailed'] = 'Hochladen fehlgeschlagen';
$string['eventuploadsucceeded'] = 'Hochladen erfolgreich';
$string['failedtransferattempts'] = 'Fehlgeschlagene Übertragungsversuche: {$a}';
$string['form_seriesid'] = 'Serien-ID';
$string['form_seriestitle'] = 'Serientitel';
$string['gotooverview'] = 'Zum Überblick...';
$string['group_name_empty'] = 'Das Feld für den Gruppennamen darf nicht leer sein, wenn eine Gruppe angelegt werden soll.';
$string['groupcreation'] = 'Gruppe anlegen';
$string['groupcreationdesc'] = 'Falls ausgewählt, wird eine Gruppe während des Uploads angelegt.';
$string['groupname'] = 'Gruppenname';
$string['groupnamedesc'] = 'Gruppe, zu der das Video hinzugefügt wird. Wichtig: Die Länge des Gruppennamens ist auf 128 Bytes beschränkt. Sie können die Platzhalter [COURSEID] und [COURSENAME] nutzen, die automatisch ersetzt werden.';
$string['haction'] = 'Aktionen';
$string['heading_actions'] = 'Aktionen';
$string['heading_delete'] = 'Löschen';
$string['heading_permanent'] = 'Endgültig';
$string['heading_role'] = 'Rolle';
$string['hend_date'] = 'Enddatum';
$string['hlocation'] = 'Ort';
$string['hprovide'] = 'Bereitstellen';
$string['hpublished'] = 'Veröffentlicht';
$string['hstart_date'] = 'Anfangsdatum';
$string['htitle'] = 'Titel';
$string['hvisibility'] = 'Sichtbarkeit';
$string['hworkflow_state'] = 'Status';
$string['importvideos_errornotenabledorworking'] = 'Die \'Videos importieren\' Funktion ist entweder nicht aktiviert oder funktioniert nicht.';
$string['importvideos_importbuttontitle'] = 'Videos importieren';
$string['importvideos_importepisodecleanupfailed'] = 'Mindestens eine der bestehenden Opencast-Einzelvideo-Aktivitäten in diesem Kurs konnte nicht angepasst werden. Bitte versuchen Sie es nochmals oder kontaktieren Sie den Moodle Administrator.';
$string['importvideos_importheading'] = 'Videos aus einem anderen Kurs importieren';
$string['importvideos_importjobcreated'] = 'Der Import der ausgewählten Videos in diesen Kurs wurde in die Warteschlange gestellt. Der Import wird im Hintergrund durchgeführt werden. Sie müssen nicht auf dieser Seiten warten bis der Import abgeschlossen ist. Sobald der Import angestoßen wurde, werden die Videos im Abschnitt <em>Videos, die in diesem Kurs verfügbar sind</em> erscheinen.';
$string['importvideos_importjobcreationfailed'] = 'Mindestens eines der Videos konnte nicht in diesen Kurs importiert werden. Bitte versuchen Sie es nochmals oder kontaktieren Sie den Moodle Administrator.';
$string['importvideos_importseriescleanupfailed'] = 'Mindestens eine der bestehenden Opencast-Einzelvideo-Aktivitäten in diesem Kurs konnte nicht angepasst werden. Bitte versuchen Sie es nochmals oder kontaktieren Sie den Moodle Administrator.';
$string['importvideos_processingexplanation'] = 'Diese Videos werden in Opencast dupliziert und dann in diesem Kurs verfügbar gemacht werden.';
$string['importvideos_progressbarstep'] = 'Schritt {$a->current} von {$a->last}';
$string['importvideos_sectionexplanation'] = 'In diesem Abschnitt können Sie existierende Videos von anderen Moodle Kursen in diesen Moodle Kurs importieren.';
$string['importvideos_settingcoreenabled'] = 'Video Import innerhalb des Moodle Core Kursimports ermöglichen';
$string['importvideos_settingcoreenabled_desc'] = 'Wenn aktiviert können Trainer/innen existierende Videos von anderen Moodle Kursen in ihre Moodle Kurse mit Hilfe des Moodle Core Kursimports importieren. Innerhalb des Kursimports gibt es dann eine zusätzliche Option mit der die Videos die innerhalb des Opencast Blocks hochgeladen wurden importiert werden können. Mit dieser Funktionalität können die Trainer/innen alle Videos von einem anderen Kursen per Stapelverarbeitung importieren, aber sie können kein einzelnen Videos davon auswählen.<br />Die Videos werden von einem Moodle Ad-hoc task in Opencast dupliziert und tauchen auf der Opencast Videos Übersichtsseite nach kurzer Verzögerung auf.';
$string['importvideos_settingenabled'] = 'Video-Import ermöglichen';
$string['importvideos_settingenabled_desc'] = 'Wenn aktiviert können Trainer/innen existierende Videos von anderen Moodle Kursen in ihre Moodle Kurse importieren. Sie müssen über diese Einstellung hinaus noch einen Workflow festlegen mit welchem die Videos dupliziert werden und eine oder beide der folgenden Einstellungen zum manuellen Import oder zum Import innerhalb des Moodle Core Kursimports aktivieren. Falls Sie keine dieser folgenden Einstellungen aktivieren wird auch diese Einstellung hier keine Auswirkung haben.';
$string['importvideos_settinghandleepisodeenabled'] = 'Opencast-Einzelvideo-Aktivitäten während des Video Imports anpassen';
$string['importvideos_settinghandleepisodeenabled_desc'] = 'Wenn aktiviert können Trainer/innen Opencast-Einzelvideo-Aktivitäten, welche von der "Opencast LTI-Einzelvideo-Aktivität zum Kurs hinzufügen" Funktion erzeugt wurden und sich auf zu importierenden Videos beziehen, anpassen lassen. Dies ist insbesondere hilfreich um Aktivitäten, welche aus einem anderen Kurs importiert wurden aber welche weiterhin auf die Videos im anderen Kurs verweisen, anzupassen. Die Einzelvideo-Aktivitäten werden von einem Moodle Ad-hoc task behandelt und sind nach kurzer Verzögerung angepasst.<br />Bitte beachten Sie dass dieser Mechanismus darauf angewiesen ist dass der Opencast Duplizier Workflow ein Workflow Instance Configuration Field namens \'duplicate_media_package_1_id\' setzt welches die Episode ID des duplizierten Videos enthält. Falls der Workflow diese Configuration Field nicht setzt wird diese Funktion stets fehlschlagen.<br />Bitte beachten Sie auch dass diese Funktion die Opencast API >=1.1.0 benötigt. Falls diese API Version nicht bereitsteht wird diese Einstellung keine Auswirkung haben.';
$string['importvideos_settinghandleseriesenabled'] = 'Opencast-Serien-Aktivitäten während des Video Imports anpassen';
$string['importvideos_settinghandleseriesenabled_desc'] = 'Wenn aktiviert können Trainer/innen Opencast-Serien-Aktivitäten, welche von der "Opencast LTI-Serien-Aktivität zum Kurs hinzufügen" Funktion erzeugt wurden und sich auf zu importierenden Videos beziehen, anpassen lassen. Dies ist insbesondere hilfreich um Aktivitäten, welche aus einem anderen Kurs importiert wurden aber welche weiterhin auf die Serie des anderen Kurs verweisen, anzupassen. Die Serien-Aktivitäten werden direkt nach dem Abschluss des Importassistenten angepasst sein.';
$string['importvideos_settingheader'] = 'Videos aus einem anderen Kurs importieren';
$string['importvideos_settingmanualenabled'] = 'Manuellen Video-Import ermöglichen';
$string['importvideos_settingmanualenabled_desc'] = 'Wenn aktiviert können Trainer/innen existierende Videos von anderen Moodle Kursen in ihre Moodle Kurse mit Hilfe eines eigenen Opencast Importassistenten importieren. Diese Funktionalität wird auf der Opencast Übersichts-Seite angeboten. Mit dieser Funktionalität können die Trainer/innen alle Videos oder eine Teilmenge der Videos von einem anderen Kursen per Stapelverarbeitung importieren.<br />Die Videos welche im Importassistenten ausgewählt wurden werden von einem Moodle Ad-hoc task in Opencast dupliziert und tauchen auf der Opencast Videos Übersichtsseite nach kurzer Verzögerung auf.<br />Bitte beachten Sie dass es hierzu zwei Rechte block/opencast:manualimporttarget und block/opencast:manualimportsource gibt, mit welchem gesteuert wird welche Rollen aus welchen Kursen in welche Kurse Videos importieren dürfen. Standardmäßig sind diese Rechte der Rolle Manager und Trainer zugewiesen, welche die Funktion dann nutzen können sobald sie hier aktiviert ist.';
$string['importvideos_settings'] = 'Funktionen zum Import von Videos';
$string['importvideos_wizardstep1heading'] = 'Quellkurs auswählen';
$string['importvideos_wizardstep1intro'] = 'Wählen Sie den Quellkurs, von dem die Videos importiert werden sollen, aus der folgenden Kursliste aus.<br />Es stehen Ihnen alle Kurse, aus denen Sie Videos importieren dürfen, zur Auswahl.';
$string['importvideos_wizardstep1sourcecourse'] = 'Videos von diesem Kurs importieren';
$string['importvideos_wizardstep1sourcecoursenone'] = 'Es gibt keinen Kurs außer diesem Kurs von dem Sie Videos importieren dürfen.';
$string['importvideos_wizardstep2coursevideos'] = 'Diese Videos importieren';
$string['importvideos_wizardstep2coursevideosnone'] = 'Im ausgewählten Kurs gibt es keine Videos';
$string['importvideos_wizardstep2coursevideosnoneselected'] = 'Sie müssen mindestens ein Video zum Import auswählen';
$string['importvideos_wizardstep2heading'] = 'Videos auswählen';
$string['importvideos_wizardstep2intro'] = 'Wählen Sie die Videos, welche Sie aus dem Quellkurs in diesen Kurs importieren möchten, aus.<br />Sie können alle Videos auswählen welche im Quellkurs fertig verarbeitet wurden.';
$string['importvideos_wizardstep3episodemoduleexplanation'] = 'In diesem Kurs existiert mindestens eine Opencast-Einzelvideo-Aktivität, welche sich auf ein Video aus dem Sie die Videos nun importieren, bezieht. Nach dem Import wird diese angepasst werden so dass sie auf das Video in diesem Kurs zeigt.';
$string['importvideos_wizardstep3episodemodulelabel'] = 'Ja, existierende Opencast-Einzelvideo-Aktivitäten für die importierten Videos anpassen';
$string['importvideos_wizardstep3episodemodulesubheading'] = 'Existierende Opencast-Einzelvideo-Aktivität(en) anpassen';
$string['importvideos_wizardstep3heading'] = 'Opencast-Aktivitäten in diesem Kurs anpassen';
$string['importvideos_wizardstep3intro'] = 'In diesem Kurs existieren Opencast-Aktivitäten welche sich auf die zu importierenden Videos beziehen. Diese Aktivitäten werden nach dem Video Import angepasst werden.<br /><strong>Falls Sie sich unsicher sind ob Sie diese Anpassung benötigen, akzeptieren Sie bitte die Voreinstellungen.</strong>';
$string['importvideos_wizardstep3seriesmoduleexplanation'] = 'In diesem Kurs existiert mindestens eine Opencast-Serien-Aktivität, welche sich auf die Serie des Kurses aus dem Sie die Videos nun importieren, bezieht. Nach dem Import wird dies angepasst werden so dass nur noch die Opencast-Serien-Aktivität, welche alle (schon existierenden wie auch jetzt importierten) Videos in diesem Kurs anzeigt, verbleibt.';
$string['importvideos_wizardstep3seriesmodulelabel'] = 'Ja, existierende Opencast-Serien-Aktivitäten für die importierten Videos anpassen';
$string['importvideos_wizardstep3seriesmodulesubheading'] = 'Existierende Opencast-Serien-Aktivität(en) anpassen';
$string['importvideos_wizardstep3skipintro'] = 'In diesem Kurs existieren keine Opencast-Aktivitäten welche sich auf die zu importierenden Videos beziehen.<br />Es muss nichts angepasst werden, bitte gehen Sie zum nächsten Schritt weiter.';
$string['importvideos_wizardstep4coursevideosnone'] = 'Es wurde kein Video zum Import ausgewählt';
$string['importvideos_wizardstep4heading'] = 'Zusammenfassung';
$string['importvideos_wizardstep4intro'] = 'Prüfen Sie bitte, dass die Zusammenfassung des Video-Imports Ihrem Bedarf entspricht.';
$string['importvideos_wizardstep4sourcecoursenone'] = 'Es wurde kein Quellkurs zum Import ausgewählt';
$string['importvideos_wizardstepbuttontitlecontinue'] = 'Weiter';
$string['importvideos_wizardstepbuttontitlerunimport'] = 'Videos importieren und zurück zur Übersicht';
$string['invalidacldata'] = 'Ungültige ACL-Daten';
$string['language'] = 'Sprache';
$string['license'] = 'Lizenz';
$string['limituploadjobs'] = 'Uploads durch den Cron-Job begrenzen';
$string['limituploadjobsdesc'] = 'Anzahl der Uploads begrenzen, die von einem Cron-Job vorgenommen werden können. Der Cron-Job kann hier eingestellt werden: {$a}';
$string['limitvideos'] = 'Anzahl von Videos';
$string['limitvideosdesc'] = 'Maximale Anzahl von Videos, die in diesem Block angezeigt werden';
$string['location'] = 'Raum';
$string['lticonsumerkey'] = 'Consumer Key';
$string['lticonsumerkey_desc'] = 'Der LTI Consumer Key für die Opencast Studio Integration';
$string['lticonsumersecret'] = 'Consumer Secret';
$string['lticonsumersecret_desc'] = 'Das LTI Consumer Secret für die Opencast Studio Integration';
$string['ltimodule_settings'] = 'Funktionen zum Anlegen von Opencast Aktivitäten';
$string['metadata'] = 'Metadaten';
$string['metadata_autocomplete_noselectionstring'] = 'Kein {$a} angegeben!';
$string['metadata_autocomplete_placeholder'] = '{$a} eingeben';
$string['metadataexplanation'] = 'Beim Hochladen existierender Videodateien nach Opencast können Sie mehrere Metadaten Felder befüllen. Diese werden zusammen mit dem Video gespeichert werden.';
$string['missingevent'] = 'Anlegen des Termins fehlgeschlagen';
$string['missinggroup'] = 'Fehlende Gruppe in Opencast';
$string['missingseries'] = 'Fehlende Serie in Opencast';
$string['missingseriesassignment'] = 'Fehlende Serienzuweisung';
$string['morevideos'] = 'Weitere Videos...';
$string['mstatecreatingevent'] = 'Hochladen...';
$string['mstatecreatinggroup'] = 'Opencast-Gruppe anlegen...';
$string['mstatecreatingseries'] = 'Opencast-Serie anlegen...';
$string['mstatereadytoupload'] = 'Bereit zur Übertragung';
$string['mstatetransferred'] = 'Übertragen';
$string['mstateunknown'] = 'Status unbekannt';
$string['mstateuploaded'] = 'Es werden Post-Upload-Aufgaben verarbeitet...';
$string['noseriesid'] = 'Die Serien-ID ist bisher nicht festgelegt.';
$string['nothingtodisplay'] = 'In diesem Abschnitt sehen Sie die Videos, welche in diesem Kurs hochgeladen wurden.<br />Aktuell wurden in diesem Kurs noch keine Videos hochgeladen.';
$string['notpublished'] = 'Nicht veröffentlicht';
$string['novideosavailable'] = 'Keine Videos';
$string['ocstatecapturing'] = 'Aufzeichnen';
$string['ocstatefailed'] = 'Fehlgeschlagen';
$string['ocstateneedscutting'] = 'Schnitt erforderlich';
$string['ocstateprocessing'] = 'Wird verarbeitet';
$string['ocstatesucceeded'] = 'Erfolgreich';
$string['offerchunkuploadalternative'] = 'Standard Dateiauswahl als Alternative anbieten';
$string['offerchunkuploadalternative_desc'] = 'Wenn diese Einstellung aktiviert ist, wird eine Checkbox mit der Beschriftung \'{$a}\' unterhalb des Chunk-Upload Formularelements angezeigt werden. Sobald die Checkbox aktiviert wird, wird das Chunk-Upload Formularelement verborgen und die standardmäßige Moodle Dateiauswahl wird angezeigt werden, welches den Zugriff auf alle Moodle Repositories ermöglicht.';
$string['opencast:addinstance'] = 'Neuen Block \'Opencast Videos\' hinzufügen';
$string['opencast:addlti'] = 'Opencast LTI-Serien-Aktivität zum Kurs hinzufügen';
$string['opencast:addltiepisode'] = 'Opencast LTI-Einzelvideo-Aktivität zum Kurs hinzufügen';
$string['opencast:addvideo'] = 'Neues Video zum Block \'Opencast Videos\' hinzufügen';
$string['opencast:createseriesforcourse'] = 'In Opencast eine neue Serie für einen Moodle-Kurs anlegen';
$string['opencast:defineseriesforcourse'] = 'Existierende Opencast-Serie mit einem Moodle-Kurs verbinden';
$string['opencast:deleteevent'] = 'Video (Episode) endgültig in Opencast löschen';
$string['opencast:manualimportsource'] = 'Videos manuell von diesem Kurs importieren';
$string['opencast:manualimporttarget'] = 'Videos manuell von anderen Kursen importieren';
$string['opencast:myaddinstance'] = 'Neuen Block \'Opencast Videos\' im Dashboard hinzufügen';
$string['opencast:unassignevent'] = 'Zuweisung eines Videos im Kurs aufheben, in dem es hochgeladen wurde.';
$string['opencast:viewunpublishedvideos'] = 'Alle Videos auf dem Opencast-Server ansehen, auch wenn sie noch nicht veröffentlicht sind.';
$string['opencaststudiointegration'] = 'Opencast Studio Integration';
$string['overview'] = 'Überblick';
$string['planned'] = 'Geplant';
$string['pluginname'] = 'Opencast Videos';
$string['presentation'] = 'Präsentations-Video';
$string['presentationdesc'] = 'Nutzen Sie das Präsentations-Video falls Sie eine Video Datei mit der Aufzeichnung einer Folienpräsentation or einem Screencast vorliegen haben.';
$string['presentationfile'] = 'Präsentations Datei';
$string['presenter'] = 'Präsentator-Video';
$string['presenterdesc'] = 'Nutzen Sie das Präsentator-Video falls Sie eine Video Datei mit der Aufzeichnung eines Redners oder einen Film vorliegen haben.';
$string['presenterfile'] = 'Präsentator Datei';
$string['privacy:metadata:block_opencast_uploadjob'] = 'Information zu Video-Uploads';
$string['privacy:metadata:block_opencast_uploadjob:courseid'] = 'ID des Kurses, in dem das Video hochgeladen wird';
$string['privacy:metadata:block_opencast_uploadjob:fileid'] = 'ID der Datei/des Videos, das hochgeladen wird';
$string['privacy:metadata:block_opencast_uploadjob:opencasteventid'] = 'ID der Opencast-Episode, die durch den Upload angelegt wird';
$string['privacy:metadata:block_opencast_uploadjob:status'] = 'Status des Upload-Prozesses';
$string['privacy:metadata:block_opencast_uploadjob:timecreated'] = 'Datum des Uploads';
$string['privacy:metadata:block_opencast_uploadjob:timemodified'] = 'Datum der letzten Modifizierung des Uploads';
$string['privacy:metadata:block_opencast_uploadjob:userid'] = 'ID der Person, die das Video hochgeladen hat';
$string['privacy:metadata:core_files'] = 'Der Block \'Opencast Videos\' speichert Dateien (Videos), die von einer Person hochgeladen werden.';
$string['privacy:metadata:opencast'] = 'Der Block \'Opencast Videos\' interagiert mit einer Opencast-Instanz, mit der Daten ausgetauscht werden.';
$string['privacy:metadata:opencast:file'] = 'Die ausgewählte Datei wird nach Opencast hochgeladen.';
$string['processdelete'] = 'Löschen verarbeiten';
$string['processepisodecleanup'] = 'Opencast LTI-Einzelvideos nach Kursimport bereinigen';
$string['processupload'] = 'Upload verarbeiten';
$string['publisher'] = 'Herausgeber';
$string['publishtoengage'] = 'Zum Engage Player veröffentlichen';
$string['publishtoengagedesc'] = 'Diese Option wählen, um das Video nach dem Upload zum Engage Player zu veröffentlichen. Der eingestellte Workflow muss dies unterstützen.';
$string['recordvideo'] = 'Video aufnehmen';
$string['restoreopencastvideos'] = 'Opencast Videos wiederherstellen';
$string['reuseexistingupload'] = 'Bereits existierende Uploads nutzen';
$string['reuseexistinguploaddesc'] = 'Falls aktiviert, werden Videos mit demselben content hash nur einmal nach Opencast hochgeladen. Dies spart Speicherplatz und Rechenleistung, aber es könnte Probleme verursachen, wenn Sie mit spezifischen Zugangsrichtlinien zu Opencast-Serien arbeiten.';
$string['rights'] = 'Rechte';
$string['rightsHolder'] = 'Rechte';
$string['rolename'] = 'Rollenname';
$string['series_already_exists'] = 'Dieser Kurs wurde bereits einer Serie zugewiesen.';
$string['series_does_not_exist'] = 'Die diesem Kurs zugewiesene Serie ist nicht gültig. Bitte kontaktieren Sie den Administrator.';
$string['series_does_not_exist_admin'] = 'Die Serie mit dem identifier \'{$a}\' konnte nicht von Opencast abgerufen werden.';
$string['series_name_empty'] = 'Serienname darf nicht leer sein.';
$string['seriescreated'] = 'Die Serie wurde angelegt';
$string['seriesidnotvalid'] = 'Die Serie gibt es nicht.';
$string['seriesidsaved'] = 'Die Serien-ID wurde gespeichert.';
$string['seriesidunset'] = 'Die Serien-ID wurde entfernt.';
$string['seriesname'] = 'Serienname';
$string['seriesnamedesc'] = 'Serie, zu der das Video hinzugefügt wird. Sie können die Platzhalter [COURSEID] und [COURSENAME] nutzen, die automatisch ersetzt werden.';
$string['seriesnotcreated'] = 'Serie konnte nicht angelegt werden.';
$string['setting_permanent'] = 'Ist permanent';
$string['settings'] = 'Opencast Videos';
$string['source'] = 'Quelle';
$string['startDate'] = 'Datum';
$string['startTime'] = 'Zeit';
$string['subjects'] = 'Betreff';
$string['submit'] = 'Änderungen speichern';
$string['title'] = 'Titel';
$string['type'] = 'Medientyp';
$string['updatemetadata'] = 'Metadaten für dieses Video aktualisieren';
$string['updatemetadatasaved'] = 'Metadaten wurden aktualisiert.';
$string['upload'] = 'Datei hochladen';
$string['uploadexplanation'] = 'Sie haben die Möglichkeit eine "Präsentator" Videodatei und / oder eine "Präsentation" Videodatei hochzuladen.<br />In den meisten Fällen werden Sie nur eine Datei hochladen, Opencast wäre aber auch in der Lage zwei Videodateien gleichzeitig anzunehmen und in einem Medienpaket zu verarbeiten.';
$string['uploadfileextensions'] = 'Akzeptierte Dateitypen';
$string['uploadfileextensionsdesc'] = 'Kommaseparierte Liste der akzeptierten Dateitypen (die Dateitypen müssen in der <a href="{$a}">Liste der Dateitypen</a> existieren). Falls die Einstellung leer gelassen wird, werden alle Dateitypen der Dateitypgruppe \'Video\' zugelassen (Details siehe wieder in der <a href="{$a}">Liste der Dateitypen</a>).';
$string['uploadingeventfailed'] = 'Anlegen einer Episode fehlgeschlagen';
$string['uploadjobssaved'] = 'Das Video wurde erfolgreich hochgeladen.<br />Das Video ist nun zur Übertragung nach Opencast bereit. Sie müssen nicht auf dieser Seite warten bis diese Übertragung abgeschlossen ist.';
$string['uploadprocessingexplanation'] = 'Diese Videos werden in Opencast verarbeitet und dann im Kurs verfügbar sein.';
$string['uploadqueuetoopencast'] = 'Warteschlange zur Übertragung nach Opencast';
$string['uploadqueuetoopencastexplanation'] = 'In diesem Abschnitt sehen Sie die Videos, welche von Ihnen oder jemand anderes in diesen Moodle Kurs hochgeladen wurde. Diese Videos stehen nun in der Warteschlage zur Übertragung nach Opencast.<br />Die Übertragung geschieht automatisiert im Hintergrund auf dem Moodle Server. Sie müssen nicht auf dieser Seite warten bis diese Übertragung abgeschlossen ist.';
$string['uploadrecordvideos'] = 'Videos hochladen oder aufnehmen';
$string['uploadrecordvideosexplanation'] = 'In diesem Abschnitt können Sie existierende Videodateien nach Moodle hochladen. Darüber hinaus können Sie Videos direkt mit Opencast Studio aufzeichnen.';
$string['uploadvideos'] = 'Videos hochladen';
$string['uploadvideosexplanation'] = 'In diesem Abschnitt können Sie existierende Videodateien nach Moodle hochladen.';
$string['uploadworkflow'] = 'Nach Upload Workflow starten';
$string['uploadworkflowdesc'] = 'Den eindeutigen Kurznamen des Workflows einrichten, der nach dem erfolgreichen Hochladen eines Videos nach Opencast gestartet werden soll.
Wenn leer gelassen, wird der Standard-Workflow (ng-schedule-and-upload) genutzt. Fragen Sie nach weiteren Workflows, die eventuell vom Opencast-Administrator angelegt wurden.';
$string['usedefaultfilepicker'] = 'Standardmäßige Dateiauswahl nutzen um auf alle Repositories zuzugreifen';
$string['videodraftdeletionsucceeded'] = 'Das Video wurde erfolgreich gelöscht';
$string['videodraftnotdeletable'] = 'Das Video kann nicht mehr vor der Übertragung nach Opencast gelöscht werden da sein Verarbeitungsstatus bereits "{$a}" ist';
$string['videodraftnotfound'] = 'Das Video welches vor der Übertragung nach Opencast gelöscht werden sollte wurde nicht gefunden';
$string['videonotfound'] = 'Video nicht gefunden';
$string['videosavailable'] = 'Videos, die in diesem Kurs verfügbar sind';
$string['videostoupload'] = 'Videos, die nach Opencast hochgeladen werden können';
$string['visibility'] = 'Sichtbarkeit des Videos';
$string['visibility_group'] = 'Allen Kursteilnehmer/innen ausgewählter Gruppen Zugang zum Video erlauben';
$string['visibility_hide'] = 'Alle Teilnehmer/innen am Zugang zum Video hindern';
$string['visibility_show'] = 'Allen Teilnehmer/innen den Zugang zum Video erlauben';
$string['workflow_not_existing'] = 'Dieser Workflow existiert nicht.';
$string['workflownotdefined'] = 'Der Workflow für das Aktualisieren von Metadaten ist nicht definiert.';
$string['workflowrolesdesc'] = 'Dieser Workflow wird in Gang gesetzt, wenn temporäre ACL-Regeln gelöscht oder hinzugefügt werden. Falls nicht gesetzt, ist es nicht möglich, die Sichtbarkeit von hochgeladenen Videos über den Block \'Opencast Videos\' zu ändern.';
$string['workflowrolesname'] = 'Workflow, um die ACL-Regeln zu ändern';
$string['worklowisrunning'] = 'Es läuft zur Zeit ein Workflow ab. Sie können die Sichtbarkeit momentan nicht ändern.';
$string['wrongmimetypedetected'] = 'Ein ungültiger MIME-Type wurde beim Upload von Video {$a->filename} aus Kurs {$a->coursename} genutzt.
Nur Video-Dateien sind erlaubt!';
