<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_aardvark', language 'es_mx', version '3.10'.
 *
 * @package     theme_aardvark
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['android'] = 'URL de Google Play Store';
$string['androiddesc'] = 'Escriba la URL de la página de Google Play Store, por ejemplo:https://play.google.com/store/apps/developer?id=micolegio';
$string['apple'] = 'URL de Apple App Store';
$string['appledesc'] = 'Escriba la URL de su página de Apple App Store; por ejemplo:https://itunes.apple.com/gb/artist/mi-colegio/id123456789';
$string['basicheading'] = 'Configuraciones Básicas';
$string['basicheadingdesc'] = 'Personalizar elementos básicos del tema.';
$string['ceop'] = 'CEOP (Child Exploitation & Online Protection)';
$string['ceopaus'] = 'Habilitar Australia';
$string['ceopdesc'] = 'Habilitar reportar al CEOP (Child Exploitation & Online Protection)';
$string['ceopnone'] = 'Deshabilitado';
$string['ceopuk'] = 'Habilitar Reino Unido';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Aardvark</h2>
<p><img class=img-polaroid src="aardvark/pix/screenshot.jpg" /></p>
</div>
<div class="well">
<h3>Acerca de</h3>
<p>Aardvark (Oso hormiguero) es el tema original basado en \'menubar\' para Moodle.</p>
<p>Aardvark ha evolucionado con los años conforme el núcleo de Moodle ha integrado muchas de las características que hicieron tan popular a Aardvark, incluyendo el menú personalizado y menú del usuario.</p>
<p>El tema posee una apariencia plana simple con inspiración tomada de la Interfaz del Usuario Plana y diseño de material de Google.</p>
<h3>Padres</h3>
<p>Many of the core elements of this theme are based upon the Bootstrap and Clean themes.</p>
<h3>Theme Credits</h3>
<p>Autor: Shaun Daubney (Newbury College)<br>
With contributions and parent code from Bas Brands, David Scotson, Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans.<br>
Website: <a href="www.newbury-college.ac.uk">Newbury College</a>
</p>
<h3>Reporte problemas:</h3>
<p><a href="https://moodle.org/plugins/view.php?plugin=theme_aardvark">https://moodle.org/plugins/view.php?plugin=theme_aardvark</a></p>
<h3>More information</h3>
<p><a href="aardvark/README.txt">Change log, licenses and version info</a></p>
</div></div>';
$string['configtitle'] = 'Aardvark (Oso hormiguero)';
$string['copyright'] = 'Copyright (Derecho de Autor)';
$string['copyrightdesc'] = 'El nombre de su organización';
$string['copyrightlink'] = 'Enlace al copyright';
$string['copyrightlinkdesc'] = 'La URL del sitio web principal de su organización (ejemplo http://www.micolegio.edu.mx).';
$string['credit'] = 'Basado en un tema original creado por Shaun Daubney';
$string['customcss'] = 'CSS personalizado';
$string['customcssdesc'] = 'Las reglas CSS que añada en esta área se reflejarán en todas las páginas, haciendo más fácil la personalización de este tema.';
$string['customfooter'] = 'Pié de página personalizado';
$string['customfooterdesc'] = 'El contenido de esta área de texto se mostrará en la primer área/zona del pie de página de todas las páginas.';
$string['disclaimer'] = 'Nota legal';
$string['disclaimerdesc'] = 'El contenido de esta área-de-texto será mostrado en la segunda área/zona del pie de página de cada página.';
$string['facebook'] = 'URL de Facebook';
$string['facebookdesc'] = 'Escriba la URL de su página de Facebook (ejemplos: http://www.facebook.com/UNAMPage ; http://www.facebook.com/ipn.mx ; http://www.facebook.com/UAMXochimilco ; http://www.facebook.com/UniversidaddelValledeMexico ).';
$string['flickr'] = 'URL de Flickr';
$string['flickrdesc'] = 'Escriba la URL de su página de Flickr (ejemplo: http://www.flickr.com/myicolegio)';
$string['footeroptdesc'] = 'Personalizar elementos básicos del pie de página de tema.';
$string['footeroptheading'] = 'Pie de página';
$string['frontpageheading'] = 'Portada';
$string['frontpageheadingdesc'] = 'Personalizar elementos de la portada del tema, tales como alertas a usuarios y fecha.';
$string['generalalert'] = 'Alerta general';
$string['generalalertdesc'] = 'Esto mostrará una alerta en su portada del sitio, para advertirles a sus usuarios acerca de un evento o situación particular.';
$string['googleplus'] = 'URL para Google+';
$string['googleplusdesc'] = 'Escriba la URL de su perfil de Google+ (por ejemplo;//plus.google.com/107817105228930159735)';
$string['instagram'] = 'URL de instagram';
$string['instagramdesc'] = 'Escriba la URL de su página de Instagram (via web.stagram). (ejemplo https://www.instagram.com/micolegio/)';
$string['linkedin'] = 'URL para Linkedln';
$string['linkedindesc'] = 'Escriba la URL para su perfil en Linkednl (por ejemplo: http://www.linkedin.com/compañía/micolegio)';
$string['maincolor'] = 'Color principal';
$string['maincolordesc'] = 'Cambiar el color principal del tema. Esto incluye el color al pasar el ratón encima del menú, encima de la URL y botones.';
$string['pinterest'] = 'URL de Pinterest';
$string['pinterestdesc'] = 'Ingrese la URL de su página de Pinterest. (por ejemplo http://pinterest.com/mi_escuela)';
$string['pluginname'] = 'Aardvark (Oso Hormiguero)';
$string['region-side-post'] = 'Derecha';
$string['region-side-pre'] = 'Izquierda';
$string['sitelogo'] = 'Logo del sitio';
$string['sitename'] = 'Mostrar el nombre del sitio junto con logo pequeño';
$string['sitenamedesc'] = 'Si no hay un logo pequeño, el nombre del sitio siempre se muestra en la barra de navegación. Si se configura un logo pequeño, puede mostarse con o sin el nombre del sitio.';
$string['snapchat'] = 'URL de Snapchat';
$string['snapchatdesc'] = 'Escriba la URL de su perfil de Snapchat. (ejemplo https://www.snapchat.com/add/micolegio)';
$string['socialiconsheading'] = 'Íconos sociales';
$string['socialiconsheadingdesc'] = 'Personalizar íconos de redes sociales.';
$string['twitter'] = 'URL de Twitter';
$string['twitterdesc'] = 'Escriba la URL de su canal de Twitter (ejemplos:  https://twitter.com/UNAM_MX ;  https://twitter.com/IPN_MX ; https://twitter.com/uamx ; https://twitter.com/UVMMEXICO)';
$string['website'] = 'URL del sitio web';
$string['websitedesc'] = 'Escriba la URL de su página web principal (por ejemplo: http://http://www.iztacala.unam.mx/)';
$string['wikipedia'] = 'URL de Wikipedia';
$string['wikipediadesc'] = 'Escriba la URL de su página en la Wikipedia (ejemplos: http://es.wikipedia.org/wiki/UNAM , http://es.wikipedia.org/wiki/IPN , http://es.wikipedia.org/wiki/Universidad_Autónoma_Metropolitana)';
$string['youtube'] = 'URL de YouTube';
$string['youtubedesc'] = 'Escriba la URL de su canal de YouTube  (por ejemplo: http://www.youtube.com/user/unam)';
