<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'enrol_ldap', language 'sr_lt', version '3.10'.
 *
 * @package     enrol_ldap
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['assignrole'] = 'Dodeljivanje uloge \'{$a->role_shortname}\' korisniku \'{$a->user_username}\' na kursu \'{$a->course_shortname}\' (id {$a->course_id})';
$string['assignrolefailed'] = 'Nije uspelo dodeljivanje uloge \'{$a->role_shortname}\' korisniku \'{$a->user_username}\' na kursu \'{$a->course_shortname}\' (id {$a->course_id})';
$string['autocreate'] = '<p>Kursevi se mogu kreirati automatski ako postoje upisi na kurs koji još uvek ne postoji na Moodleu</p><p>Ukoliko koristite automatsko kreiranje kurseva, preporučuje se da odgovarajućim ulogama uklonite sledeće mogućnosti: moodle/course:changeidnumber, moodle/course:changeshortname, moodle/course:changefullname i moodle/course:changesummary, kako biste sprečili promene gore navedenih polja kursa (broj, skraćeni naziv, pun naziv and rezime kursa).</p>';
$string['autocreate_key'] = 'Automatsko kreiranje';
$string['autocreation_settings'] = 'Podešavanja automatskog kreiranja kursa';
$string['autoupdate_settings'] = 'Podešavanje za automatsko ažuriranje kursa';
$string['autoupdate_settings_desc'] = '<p>Izaberite polja koja će biti ažurirana u toku zakazanog procesa \'Sinhronizuj LDAP upise\'.</p><p>Kada je izabrano najmanje jedno polje doći će do ažuriranja.</p>';
$string['bind_dn'] = 'Ako želite da koristite veznog korisnika za pretragu korisnika, navedite to ovde. Nešto kao \'cn=ldapuser,ou=public,o=org\\';
$string['bind_dn_key'] = 'Jedinstveno prepoznatljivo ime veznog korisnika';
$string['bind_pw'] = 'Lozinka za veznog korisnika.';
$string['bind_pw_key'] = 'Lozinka';
$string['bind_settings'] = 'Podešavanja vezivanja';
$string['cannotcreatecourse'] = 'Nije moguće kreiranje kursa: nedostaju neophodni podaci u LDAP zapisu!';
$string['cannotupdatecourse'] = 'Nije moguće ažurirati kurs: nedostaju neophodni podaci iz LDAP zapisa! ID broj kursa: \'{$a->idnumber}\'';
$string['cannotupdatecourse_duplicateshortname'] = 'Nije moguće ažurirati kurs: duplikat skraćenog naziva. Preskače se kurs sa id brojem \'{$a->idnumber}\'...';
$string['category'] = 'Kategorija za automatski kreirane kurseve.';
$string['category_key'] = 'Kategorija';
$string['contexts'] = 'LDAP konteksti';
$string['couldnotfinduser'] = 'Nije bilo moguće pronaći korisnika \'{$a}\', preskače se';
$string['course_fullname'] = 'Opciono: LDAP atribut iz kog će se preuzeti puni naziv kursa';
$string['course_fullname_key'] = 'Puno ime';
$string['course_fullname_updateonsync'] = 'Ažuriraj pun naziv tokom sinhronizacije';
$string['course_fullname_updateonsync_key'] = 'Ažuriraj pun naziv';
$string['course_idnumber'] = 'LDAP atribut iz koga se preuzima ID broj kursa. Obično \'cn\' ili \'uid\'.';
$string['course_idnumber_key'] = 'ID broj';
$string['course_search_sub'] = 'Traži članstvo u grupama u potkontekstima';
$string['course_search_sub_key'] = 'Pretraži potkontekste';
$string['course_settings'] = 'Podešavanja upisa kursa';
$string['course_shortname'] = 'Opciono: LDAP atribut iz kog će se preuzeti skraćeni naziv kursa';
$string['course_shortname_key'] = 'Skraćeni naziv';
$string['course_shortname_updateonsync'] = 'Ažuriraj skraćen naziv tokom sinhronizacije';
$string['course_shortname_updateonsync_key'] = 'Ažuriraj skraćen naziv';
$string['course_summary'] = 'Opciono: LDAP atribut iz kog se će se preuzeti rezime kursa';
$string['course_summary_key'] = 'Резиме';
$string['course_summary_updateonsync'] = 'Ažuriraj rezime tokom sinhronizacije';
$string['course_summary_updateonsync_key'] = 'Ažuriraj rezime';
$string['coursenotexistskip'] = 'Kurs \'{$a}\' ne postoji, a automatsko kreiranje kurseva je onemogućeno, preskače se';
$string['courseupdated'] = 'Kurs sa id brojem \'{$a->idnumber}\' uspešno je ažuriran.';
$string['courseupdateskipped'] = 'Kurs sa id brojem \'{$a->idnumber}\' ne zahteva ažuriranje. Preskače se...';
$string['createcourseextid'] = 'KREIRAJ korisnika upisanog na nepostojeći kurs \'{$a->courseextid}\'';
$string['createnotcourseextid'] = 'Korisnik je upisan na nepostojeći kurs \'{$a->courseextid}\'';
$string['creatingcourse'] = 'Kreiranje kursa \'{$a}\'...';
$string['duplicateshortname'] = 'Kreiranje kursa nije uspelo. Nađen je duplikat skraćenog naziva. Preskače se kurs sa identifikacionim brojem \'{$a->idnumber}\'...';
$string['editlock'] = 'Zaključajte vrednosti';
$string['emptyenrolment'] = 'Prazan upis za ulogu \'{$a->role_shortname}\' na kursu \'{$a->course_shortname}\'';
$string['enrolname'] = 'LDAP';
$string['enroluser'] = 'Upiši korisnika \'{$a->user_username}\' na kurs \'{$a->course_shortname}\' (id {$a->course_id})';
$string['enroluserenable'] = 'Omogućen je upis za korisnika \'{$a->user_username}\' na kursu \'{$a->course_shortname}\' (id {$a->course_id})';
$string['explodegroupusertypenotsupported'] = 'ldap_explode_group() ne podržava izabrani tip korisnika: {$a}';
$string['extcourseidinvalid'] = 'Eksterni identifikator kursa je neispravan!';
$string['extremovedsuspend'] = 'Onemogućen je upis za korisnika \'{$a->user_username}\' na kursu \'{$a->course_shortname}\' (id {$a->course_id})';
$string['extremovedsuspendnoroles'] = 'Onemogućen je upis i uklonjena uloga za korisnika \'{$a->user_username}\' na kursu \'{$a->course_shortname}\' (id {$a->course_id})';
$string['extremovedunenrol'] = 'Ispiši korisnika \'{$a->user_username}\' sa kursa \'{$a->course_shortname}\' (id {$a->course_id})';
$string['failed'] = 'Neuspešno!';
$string['general_options'] = 'Opšta podešavanja';
$string['group_memberofattribute'] = 'Naziv atributa koji određuje kojim grupama pripada dati korisnik ili grupa (npr. memberOf, groupMembership itd.)';
$string['group_memberofattribute_key'] = 'Atribut \'Član grupe\'';
$string['host_url'] = 'Navedite glavni LDAP u URL-obliku kao \'ldap://ldap.domen.rs/\' ili \'ldaps://ldap.domen.rs/\'';
$string['host_url_key'] = 'URL servera';
$string['idnumber_attribute'] = 'Ako članstvo u grupi sadrži jedinstvena prepoznatljiva imena (DN) navedite iste atribute koje ste koristili za mapiranje korisničkog \'ID broja\' u podešavanjima LDAP provere identiteta.';
$string['idnumber_attribute_key'] = 'ID broj atribut';
$string['ldap:manage'] = 'Upravljanje LDAP instancama upisa';
$string['ldap_encoding'] = 'Navedite kodni raspored koji koristi LDAP server. Najverovatnije utf-8, dok MS AD v2 obično koristi cp1252, cp1250 itd.';
$string['ldap_encoding_key'] = 'LDAP kodni raspored';
$string['memberattribute'] = 'Atribut LDAP član';
$string['memberattribute_isdn'] = 'Ako članstvo u grupi sadrži jedinstvena prepoznatljiva imena (DN) morate ovde da ih navedete. Takođe, morate da konfigurišete i preostala podešavanja u ovoj sekciji.';
$string['memberattribute_isdn_key'] = 'Atribut člana koristi dn';
$string['nested_groups'] = 'Da li želite da za upis koristite ugnežđene grupe (grupe unutar grupa)?';
$string['nested_groups_key'] = 'Ugnežđene grupe';
$string['nested_groups_settings'] = 'Podešavanja ugnežđenih grupa';
$string['nosuchrole'] = 'Nema takve uloge: \'{$a}\'';
$string['objectclass'] = 'objectClass koja se koristi za traženje kursa. Obično \'group\' ili \'posixGroup\'.';
$string['objectclass_key'] = 'Klasa objekta';
$string['ok'] = 'U redu!';
$string['opt_deref'] = 'Ako članstvo u grupi sadrži jedinstvena prepoznatljiva imena (DN) navedite kako će se u toku pretraživanja rukovati alijasima. Izaberite jednu od sledećih vrednosti: Ne\' (LDAP_DEREF_NEVER) ili \'Da\' (LDAP_DEREF_ALWAYS).';
$string['opt_deref_key'] = 'Dereferеnciraj alijase (pogledaj svojstva primarnih objekata)';
$string['phpldap_noextension'] = 'PHP LDAP modul izgleda nije prisutan. Molimo proverite da li je instaliran i omogućen, ukoliko želite da koristite ovaj dodatak za upis.';
$string['pluginname'] = 'LDAP upisi';
$string['pluginname_desc'] = '<p>Možete koristiti LDAP server za kontrolu vaših upisa. Podrazumeva se da stablo vašeg LDAP-a sadrži grupe koje se preslikavaju na kurseve, kao i da će svaka od tih grupa/kurseva imati zapise o članstvu preslikane na polaznike.</p>
<p>Pretpostavlja se da su kursevi definisani kao grupe u LDAP-u, gde svaka grupa ima višestruka polja za članstvo (<em>member</em> ili <em>memberUid</em>) koja sadrže jedinstvenu identifikaciju (uniqueidentification) korisnika.</p>
<p>Da biste koristili LDAP upis, vaši korisnici <strong>moraju</strong> imati ispravno idnumber polje. LDAP grupe moraju imati taj idnumber u poljima članova kako bi korisnik bio upisan na kurs. Ovo će obično raditi ako već koristite LDAP proveru identiteta.</p>
<p>Upisi će biti ažurirani kada se korisnik prijavi na sistem. Možete pokrenuti i skript za sinhronizaciju upisa. Pogledajte na <em>enrol/ldap/enrol_ldap_sync.php</em>.</p>
<p>Ovaj dodatak, takođe, može biti podešen tako da automatski kreira nove kurseve kada se nove grupe pojave u LDAP-u.</p>';
$string['pluginnotenabled'] = 'Dodatak nije omogućen!';
$string['privacy:metadata'] = 'Dodatak za upise iz LDAP-a ne čuva nikakve lične podatke.';
$string['role_mapping'] = '<p>Za svaku ulogu morate da navedete sve LDAP kontekste u kojima se nalaze grupe koje predstavljaju kurseve. Razdvojite različite kontekste sa znakom tačka-zarez (;).</p><p>Takođe morate da navedete atribut koji Vaš LDAP koristi za čuvanje članova grupe. To je obično \'member\' ili \'memberUid\'</p>';
$string['role_mapping_attribute'] = 'LDAP atribut korisnika za {$a}';
$string['role_mapping_context'] = 'LDAP konteksti za {$a}';
$string['role_mapping_key'] = 'Mapiraj uloge iz LDAP-a';
$string['roles'] = 'Mapiranje uloga';
$string['server_settings'] = 'Podešavanja LDAP servera';
$string['synccourserole'] = '== Sinhronizacija kursa \'{$a->idnumber}\' za ulogu \'{$a->role_shortname}\'';
$string['syncenrolmentstask'] = 'Sinhronizacija LDAP upisa';
$string['template'] = 'Opciono: automatski kreirani kursevi mogu da kopiraju svoja podešavanja iz šablona za kurseve.';
$string['template_key'] = 'Šablon';
$string['unassignrole'] = 'Uklanjanje uloge \'{$a->role_shortname}\' korisniku \'{$a->user_username}\' sa kursa \'{$a->course_shortname}\' (id {$a->course_id})';
$string['unassignrolefailed'] = 'Nije uspelo uklanjanje uloge \'{$a->role_shortname}\' korisniku \'{$a->user_username}\' sa kursa \'{$a->course_shortname}\' (id {$a->course_id})';
$string['unassignroleid'] = 'Uklanjanje id uloge \'{$a->role_id}\' korisniku čiji je id \'{$a->user_id}\'';
$string['updatelocal'] = 'Ažuriraj lokalne podatke';
$string['user_attribute'] = 'Ako članstvo u grupi sadrži jedinstvena prepoznatljiva imena (DN) navedite atribut koji se koristi za imenovanje/pretraživanje korisnika. Ako koristite LDAP proveru identiteta, ova vrednost treba da se poklapa sa atributom navedenim u mapiranju \'ID broj\' u LDAP dodatku za proveru identiteta.';
$string['user_attribute_key'] = 'ID broj atribut';
$string['user_contexts'] = 'Ako članstvo u grupi sadrži jedinstvena prepoznatljiva imena (DN) navedite spisak konteksta u kojima se nalaze korisnici. Razdvojite različite kontekste sa \';\'. Na primer: \'ou=users,o=org; ou=others,o=org\'.';
$string['user_contexts_key'] = 'Kontekst';
$string['user_search_sub'] = 'Ako članstvo u grupi sadrži jedinstvena prepoznatljiva imena (DN) odredite da li će se korisnici tražiti i u potkontekstima.';
$string['user_search_sub_key'] = 'Pretraži potkontekste';
$string['user_settings'] = 'Podešavanja pretrage korisnika';
$string['user_type'] = 'Ako atribut članstva u grupi sadrži jedinstvena prepoznatljiva imena, navedite kako su korisnici smešteni u LDAP-u.';
$string['user_type_key'] = 'Tip korisnika';
$string['version'] = 'Verzija LDAP protokola koju koristi Vaš server.';
$string['version_key'] = 'Verzija';
