<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hotpot', language 'no', version '3.10'.
 *
 * @package     hotpot
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abandoned'] = 'Forlatt';
$string['abandonhotpot'] = 'Dine resultater så langt vil bli lagret, men du kan ikke fortsette på eller starte denne aktiviteten på nytt seinere.';
$string['activitycloses'] = 'Aktivitet stenger';
$string['activitygrade'] = 'Aktivitetskarakter';
$string['activityopens'] = 'Aktivitet åpnger';
$string['added'] = 'Lagt til';
$string['addquizchain'] = 'Legg til testkjede';
$string['addquizchain_help'] = 'Skal alle prøver i en sammenlenket kjede legges til?

**Nei**
: bare en prøve blir lagt til kurset

**Ja**
: dersom kildefila er en **prøvefil**, vil den bli behandlet som starten  på en kjede av prøver og alle prøvene i kjeden blir lagt til kurset med de samme innstllingene. Hver prøve i kjeden må ha lenke til neste fil i kjeden.

Hvis kildefila er en **mappe**, vil alle gjenkjennbare prøver i mappen bli lagt til kurset som en kjede av prøver med identiske innstillinger.

Hvis kildefila er en **elementfil**, slik som en Hot Potatoes mash-fil eller index.html, vil prøver angitt i elementfila bli lagt til kurset som en kjede av prøver med identiske innstillinger.';
$string['allowpaste'] = 'Tillat liming';
$string['allowpaste_help'] = 'Hvis denne innstillingene';
$string['allowreview'] = 'Se over er tillatt';
$string['allowreview_help'] = 'Dersom aktivert vil studenter kunne se over prøveforsøkene etter at prøven er stengt.';
$string['analysisreport'] = 'Elementanalyse';
$string['attempted'] = 'Forsøkt';
$string['attemptlimit'] = 'Maks antall forsøk';
$string['attemptlimit_help'] = 'Maksimum antall forsøk en student får på denne Hot Pot aktiviteten.';
$string['attemptnumber'] = 'Forsøk nummer';
$string['attempts'] = 'Forsøk';
$string['attemptscore'] = 'Forsøksresultat';
$string['attemptsunlimited'] = 'Ubegrenset antall forsøk';
$string['average'] = 'Gjennomsnitt';
$string['averagescore'] = 'Gjennomsnittlig resultat';
$string['bodystyles'] = 'Justering';
$string['bodystylesbackground'] = 'Bakgrunnsfarge og bilde';
$string['bodystylescolor'] = 'Tekstfarge';
$string['bodystylesfont'] = 'Teksttype og størrelse';
$string['bodystylesmargin'] = 'Venstre og høyre marg';
$string['cacherecords'] = 'HotPot mellomlagrede poster';
$string['canrestarthotpot'] = 'Dine resultater så langt vil bli lagret og du kan gjøre "{$a}" på nytt seinere.';
$string['canresumehotpot'] = 'Dine resultater så langt vil bli lagret og du kan fortsette med "{$a}" seinere.';
$string['checks'] = 'Kontroller';
$string['checksomeboxes'] = 'Vennligst kryss av noe';
$string['clearcache'] = 'Slett HotPot mellomlageret';
$string['cleardetails'] = 'Slett HotPot detaljer';
$string['clearedcache'] = 'HotPot mellomlager er nå slettet';
$string['cleareddetails'] = 'HotPot detaljene er nå slettet';
$string['clickreporting'] = 'Slå på klikk-logging';
$string['clickreporting_help'] = 'Dersom aktivert vil en separat oppføring lagres hver gang et hint, ide eller sjekk svaret-knappen brukes. Dette lar læreren se en meget detaljert rapport over status for spørsmålet for hvert klikk. Normalt lagres det bare en oppføring pr. forsøk på spørsmålet.';
$string['clicktrailreport'] = 'Klikk forsøk';
$string['closed'] = 'Denne aktiviteten er stengt';
$string['clues'] = 'Tips';
$string['completed'] = 'Fullført';
$string['configbodystyles'] = 'Som standard vil Moodles design overstyre HotPot designet. Imidlertidig, kan HotPot-designet brukes om du velger et av alternativene her.';
$string['configenablecache'] = 'Vedlikehold av mellomlageret av HotPot-prøver kan øke ytelsen dramatisk - de leveres studentene langt raskere.';
$string['configenablecron'] = 'Angi klokkeslett i din tidssone for når HotPot cron-skriptet skal kjøre';
$string['configenablemymoodle'] = 'Denne innstillingen styrer hvorvidt HotPot skal være med på Min Moodle-side eller ikke.';
$string['configenableobfuscate'] = 'Hindrer javascriptkoden å legge til en mediespiller som gjør det vanskeligere å bestemme mediets filnavn og å gjette hva fila inneholder.';
$string['configenableswf'] = 'Tillat inkludering av SWF-filer i HotPot-aktiviteter. Dersom aktiv vil denne innstillingen overstyre filter_mediaplugin_enable_swf.';
$string['configfile'] = 'Konfigurasjonsfil';
$string['configframeheight'] = 'Når en prøve vises i en ramme, vil denne verdien angi høyden (i pixler) på toppteksten som inneholder Moodles navigasjonselementer.';
$string['configlocation'] = 'Plassering av konfigurasjonsfil';
$string['configlockframe'] = 'Dersom denne innstillingen er aktiv vil navigasjonsrammen (hvis i bruk) bli låst slik at den ikke kan endre størrelse, rulle eller vise noen rammekant.';
$string['configmaxeventlength'] = 'Hvis en HotPot har både åpnings- og stengetid angitt og differansen mellom disse to er større enn antall dager angitt her, vil to separate kalenderhendelser bli lagt til kurskalenderen. For kortere perioder, eller når bare en av tidene er angitt, vil det kun vises en kalenderhendelse. Hvis ingen av delene er angitt lages det  ingen kalenderhendelse.';
$string['configstoredetails'] = 'Hvis denne innstillingen er aktivert vil XML-detaljene fra forsøket bli lagret i HotPot-prøvens informasjonstabell. Dette åpner for at prøveforsøk kan omberegnes senere når det er behov for oppdatering av vurderingsskalaer etc. Likevel - aktivering av dette valget vil gjøre at hotpot_details-tabellen vil vokse meget raskt.';
$string['confirmdeleteattempts'] = 'Vil du virkelig slette disse forsøkene?';
$string['confirmstop'] = 'Er du sikker på at du vil navigere bort fra denne siden?';
$string['correct'] = 'Riktig';
$string['couldnotinsertsubmissionform'] = 'Kunne ikke legge til innsendingsskjemaet';
$string['d_index'] = 'Diskrimineringsindeks';
$string['delay1'] = 'Forsinkelse 1';
$string['delay1_help'] = 'Minimum forsinkelse mellom første og andre forsøk';
$string['delay1summary'] = 'Tidsforsinkelsen mellom første og andre forsøk';
$string['delay2'] = 'Forsinkelse 2';
$string['delay2_help'] = 'Minimum forsinkelse etter andre forsøk.';
$string['delay2summary'] = 'Tidsforsinkelse mellom senere forsøk';
$string['delay3'] = 'Forsinkelse 3';
$string['delay3_help'] = 'Innstillngen angir forsinkelsen mellom prøveforsøkene og returnerer kontrollen til Moodle.

**Bruk angitt tid (i sekunder)**
: kontrollen blir returnert til Moodle etter angitt antall sekunder.

**Bruk innstillinger i kilde/mal-fila**
: kontrollen blir returnert til Moodle etter antall sekunder angitt i kildefila eller malfila for dette formatet.

**Vent til studenten klikker OK**
: kontrollen blir returnert til Moodle etter at studenten klikker OK-knappen i fullføringsmeldingen i prøven.

**Ikke fortsett automatisk**
: kontrollen vil ikke returneres til Moodle etter at prøven er ferdig. Studenten kan fritt navigere vekk fra prøvesiden.

Merk - prøveresultatene blir alltid returnert til Moodle straks prøva er ferdig eller avbrutt, helt uavhengig av disse innstillingene.';
$string['delay3afterok'] = 'Vent til studenten klikker OK';
$string['delay3disable'] = 'Ikke fortsett automatisk';
$string['delay3specific'] = 'Bruk en spesifisert forsinkelse';
$string['delay3summary'] = 'Tidsforsinkelse etter ferdig prøve';
$string['delay3template'] = 'Bruk innstillinger i kilde/mal-fila';
$string['deleteallattempts'] = 'Slett alle forsøk';
$string['deleteattempts'] = 'Slett forsøk';
$string['detailsrecords'] = 'Poster med HotPot-detaljer';
$string['duration'] = 'Varighet';
$string['enablecache'] = 'Aktiver HotPot mellomlager';
$string['enablecron'] = 'Aktiver HotPot cron';
$string['enablemymoodle'] = 'Vis HotPot på Min Moodle-siden';
$string['enableobfuscate'] = 'Aktiver avvisning av mediaspillerkode';
$string['enableswf'] = 'Tillat inkludering av SWF-filer i HotPot aktiviteter';
$string['entry_attempts'] = 'Forsøk';
$string['entry_dates'] = 'Datoer';
$string['entry_grading'] = 'Karaktersetting';
$string['entry_title'] = 'Bruk elementnavnet som tittel';
$string['entrycm'] = 'Forrige aktivitet';
$string['entrycm_help'] = 'Denne innstillingen angir en Moodle aktivitet og  laveste karakter som godtas før denne Prøverapporten kan åpnes.

Læreren kan velge en bestemt aktivitet, eller en av følgende generelle innstillinger:

* Tidligere aktivitet i dette kurset
* Tidligere aktivitet i denne seksjonen
* Tidligere Hotpot i dette kurset
* Tidligere Hotport i denne seksjonen';
$string['entrycmcourse'] = 'Forrige aktivitet i dette kurset';
$string['entrycmsection'] = 'Tidligere aktivitet i denne kursseksjonen';
$string['entrycompletionwarning'] = 'Før du begynner denne aktiviteten, må du se på {$a}.';
$string['entrygrade'] = 'Karakter på tidligere aktivitet';
$string['entrygradewarning'] = 'Du kan ikke begynne på denne aktiviteten før du oppnår {$a->entrygrade}% på {$a->entryactivity}. Gjeldende karakter for denne aktiviteten er {$a->usergrade}%';
$string['entryhotpotcourse'] = 'Tidligere Hotpot i dette kurset';
$string['entryhotpotsection'] = 'Tidligere Hotpot i denne kursseksjonen';
$string['entryoptions'] = 'Innstillinger for åpningssiden';
$string['entryoptions_help'] = 'Disse valgene aktiverer/deaktiverer visningen av elementer på Hotpots åpningsside.

**Elementnavn som tittel**
: Dersom avmerket, vil elementnavnet bli vist som tittel på åpningssiden.

**Vurdering**
: Dersom avmerket, vil Hotpots informasjon om karaktersetting vises på åpningssiden.

**Datoer**
: Hvis avmerket, vil Hotpots åpne/lukke-datoer vises på åpningssiden.

**Forsøk**
: Hvis avmerket vises en tabell på åpningssiden med oversikt over brukerens tidligere forsøk. Forsøk som kan gjenopptas vises med en "Fortsett"-knapp i høyre kolonne.';
$string['entrypage'] = 'Vis åpningsside';
$string['entrypage_help'] = 'Skal studentene få se en startside før Hotpot-aktiviteten åpnes?

**Ja**
: studentene vil bli vist en startside før Hotpot-aktiviteten åpnes. Startsidens innhold defineres i Hotpot´s innstillinger.

**Nei**
: studentene får ingen startside og åpner Hotpot-aktiviteten direkte.

OBS! Læreren vil alltid se startsiden, siden den gir tilgang til rapporter og skjermbildet for å redigere Quizzen.';
$string['entrypagehdr'] = 'Åpningsside';
$string['entrytext'] = 'Skriv inn tekst på siden';
$string['event_attempt_reviewed'] = 'HotPot-forsøk gjennomgått';
$string['event_attempt_reviewed_description'] = 'Brukeren med id "{$a->userid}" gjennomgikk et forsøk i en "hotpot" aktivitet i kurset med id "{$a->cmid}"';
$string['event_attempt_reviewed_explanation'] = 'En bruker har nettopp gjennomgått et HotPot-forsøk';
$string['event_attempt_started'] = 'HotPot-forsøk startet';
$string['event_attempt_started_description'] = 'Brukeren med id "{$a->userid}" startet et forsøk i en "hotpot" aktivitet i kurset med id "{$a->cmid}"';
$string['event_attempt_started_explanation'] = 'En bruker har nettopp startet et HotPot-forsøk';
$string['event_attempt_submitted'] = 'HotPot-forsøk levert';
$string['event_attempt_submitted_description'] = 'Brukeren med id "{$a->userid}" leverte et forsøk i en "hotpot" aktivitet i kurset med id "{$a->cmid}"';
$string['event_attempt_submitted_explanation'] = 'En bruker har nettopp levert et HotPot-forsøk';
$string['event_base'] = 'HotPot-hendelse oppdaget';
$string['event_base_description'] = 'Brukeren med id "{$a->userid}" startet en hendelse i en "hotpot" aktivitet i kurset med id "{$a->cmid}"';
$string['event_base_explanation'] = 'En hendelse ble oppdaget av HotPot-modulen';
$string['event_report_viewed'] = 'HotPot-rapport vist';
$string['event_report_viewed_description'] = 'Brukeren med id "{$a->userid}" viste en forsøksrapport "hotpot" aktivitet i kurset med id "{$a->cmid}"';
$string['event_report_viewed_explanation'] = 'En bruker har nettopp sett en rapport om forsøk i en HotPot-aktivitet';
$string['exit_areyouok'] = 'Hallo, er du fortsatt der?';
$string['exit_attemptscore'] = 'Karakteren du fikk på dette forsøket var {$a}';
$string['exit_course'] = 'Kurs';
$string['exit_course_text'] = 'Gå tilbake til kursets hovedside';
$string['exit_encouragement'] = 'Oppmuntring';
$string['exit_excellent'] = 'Utmerket!';
$string['exit_feedback'] = 'Tilbakemelding på utgangssiden';
$string['exit_feedback_help'] = 'Disse valgene aktiverer og deaktiverer visningen av tilbakemeldingselementer i en Hotpots utgangsside.

**Elementnavn som tittel**
: dersom avmerket vil elementnavnet bli vist som sidetittel på utgangssiden.

**Oppmuntring**
: dersom avmerket vil det vises oppmuntrende respons på utgangssiden. Hva som vises avhenger av resultatet:

: **&gt; 90%**: Utmerket!
: **&gt; 60%**: Godt jobbet
: **&gt; 0%**: Godt forsøk
: **= 0%**: Føler du deg bra?

**Elementets poeng**
: dersom avmerket vil poengsummen for elementforsøket du nettopp avsluttet bli vist på utgangssiden.

**Elementpoeng**
: dersom avmerket vil Hotpot-poengsummen vises på utgangssiden.

I tillegg, hvis elementvurderingsmetoden er høyest vil det vises en melding om de siste forsøkene var tilsvarende eller bedre enn tidligere forsøk.';
$string['exit_goodtry'] = 'Godt forsøk!';
$string['exit_grades'] = 'Karakterer';
$string['exit_grades_text'] = 'Se på karakterene dine så langt i dette kurset';
$string['exit_hotpotgrade'] = 'Karakteren din for denne aktiviteten er {$a}';
$string['exit_hotpotgrade_average'] = 'Din gjennomsnittlige karakter så langt for denne aktiviteten er {$a}';
$string['exit_hotpotgrade_highest'] = 'Din høyeste karakter så langt for denne aktiviteten er {$a}';
$string['exit_hotpotgrade_highest_equal'] = 'Du tangerte din tidligere bestekarakter for denne aktiviteten!';
$string['exit_hotpotgrade_highest_previous'] = 'Din beste karakter til nå for denne aktiviteten var {$a}';
$string['exit_hotpotgrade_highest_zero'] = 'Du har ennå ikke oppnådd bedre karakter enn {$a} for denne aktiviteten.';
$string['exit_index'] = 'Oversikt';
$string['exit_index_text'] = 'Gå til aktivitetsoversikten';
$string['exit_links'] = 'Lenke for utgangsside';
$string['exit_links_help'] = 'Disse valgene aktiverer/deaktiverer visningingen av bestemte navigasjonslenker på utgangssiden i en HotPot.

**Prøv igjen**
: Dersom det er åpnet for flere forsøk og studenten har noen forsøk igjen, vises det en lenke som lar de prøve en gang til.

**Meny**
: Dersom avmerket vises det en lenke til menysiden for HotPot.

**Kurs**
: Dersom avmerket vises det en lenke til kurssiden.

**Karakterer**
: Dersom avmerket vises en lenke til karakterboka i kurset.';
$string['exit_next'] = 'Neste';
$string['exit_next_text'] = 'Prøv neste aktivitet';
$string['exit_noscore'] = 'Fullføringen av denne aktiviten var vellykket!';
$string['exit_retry'] = 'Prøv igjen';
$string['exit_retry_text'] = 'Prøv denne aktiviteten en gang til';
$string['exit_welldone'] = 'Godt jobba!';
$string['exit_whatnext_0'] = 'Hva vil du gjøre nå?';
$string['exit_whatnext_1'] = 'Velg skjebnen din ...';
$string['exit_whatnext_default'] = 'Vennligst velg en av følgende:';
$string['exitcm'] = 'Neste aktivitet';
$string['exitcm_help'] = 'Denne innstillingen angir hvilken Moodle-aktivitet det skal ledes til når inneværende aktivitet er fullført.

Læreren ka velge en bestemt aktivitet, eller en av følgende generelle innstillinger:

* Neste aktivitet i kurset
* Neste aktivitet i denne seksjonen
* Neste Hotpot i dette kurset
* Neste Hotpot i denne seksjonen

Hvis andre utgangssider er deaktivert vil studenten føres rett til neste aktivitet. Ellers vil studenten få vist en lenke som tar dem til neste aktivitet når de er klare.';
$string['exitcmcourse'] = 'Neste aktivitet i dette kurset';
$string['exitcmsection'] = 'Neste aktivitet i denne kursseksjonen';
$string['exitgrade'] = 'Neste aktivitetskarakter';
$string['exithotpotcourse'] = 'Neste Hotpot i dette kurset';
$string['exithotpotsection'] = 'Neste Hotpot i denne kursseksjonen';
$string['exitoptions'] = 'Innstillinger for utgangsside';
$string['exitpage'] = 'Vis utgangsside';
$string['exitpage_help'] = 'Skal det vises en utgangsside etter at HotPot-quizzen er fullført?

**Ja**
: studentene får da en utgangsside når HotPot er fullført. Innholdet på denne siden bestemmes av innstillingene for HotPot sin utgangsside og hvilken tekst og lenker som skal vises.

**Nei**
: studentene får ingen utgangsside og blir i stedet ledet til neste aktivitet eller tilbake til kurssiden.';
$string['exitpagehdr'] = 'Utgangsside';
$string['exittext'] = 'Rediger sideteksten';
$string['feedbackdiscuss'] = 'Diskuter denne prøven i et forum';
$string['feedbackformmail'] = 'Tilbakemeldingsskjema';
$string['feedbackmoodleforum'] = 'Moodle forum';
$string['feedbackmoodlemessaging'] = 'Moodle melding';
$string['feedbacknone'] = 'Ingen';
$string['feedbacksendmessage'] = 'Send en melding til læreren din';
$string['feedbackwebpage'] = 'Webside';
$string['firstattempt'] = 'Første forsøk';
$string['forceplugins'] = 'Tving hjelpeprogrammer';
$string['forceplugins_help'] = 'Dersom aktivert vil Moodlekompatible mediaspillere vise filer som avi, mpeg, mpg, mp3, mov og wmv. Dersom deaktivert vil ikke Moodle endre  innstillingene for mediaspillere for prøven.';
$string['frameheight'] = 'Rammehøyde';
$string['giveup'] = 'Gi opp';
$string['grademethod'] = 'Vurderingsmetode';
$string['grademethod_help'] = 'Denne innstillingen bestemmer hvordan HotPot skal beregne karakteren basert på forsøkene som er gjort.

**Beste resultat**
: karakteren blir da satt til det beste av forsøkene.

**Gjennomsnitt av forsøk**
: kararakteren blir et gjennomsnitt av alle forsøkene som er gjort.

**Første forsøk**
: karakteren blir bestemt ut fra første forsøk.

**Siste forsøk**
: karakteren blir bestemt ut fra  det siste forsøket.';
$string['gradeweighting'] = 'Karaktervekting';
$string['gradeweighting_help'] = 'Karakterer for denne Hotpot-aktiviteten vil bli skalert til denne verdien i Moodles karakterbok.';
$string['highestscore'] = 'Høyste score';
$string['hints'] = 'Hint';
$string['hotpot:addinstance'] = 'Legg til en ny HotPot-aktivitet';
$string['hotpot:attempt'] = 'Forsøk en Hotpot-aktivitet og send resultatene';
$string['hotpot:deleteallattempts'] = 'Slett alle brukeres forsøk en HotPot-aktivitet';
$string['hotpot:deletemyattempts'] = 'Slett dine egne forsøk på HotPot-aktiviter';
$string['hotpot:ignoretimelimits'] = 'Ignorer tidsfrister på HotPot-aktiviter';
$string['hotpot:manage'] = 'Rediger innstillingene på en HotPot-aktivitet';
$string['hotpot:preview'] = 'Forhåndsvis en HotPot-aktivitet';
$string['hotpot:reviewallattempts'] = 'Vis alle brukeres forsøk på en HotPot-aktivitet';
$string['hotpot:reviewmyattempts'] = 'Se dine egne forsøk på en HotPot-aktivitet';
$string['hotpot:view'] = 'Vis åpningssiden på en Hotpot-aktivitet';
$string['hotpotname'] = 'HotPot aktivtetsnavn';
$string['ignored'] = 'Ignored';
$string['inprogress'] = 'in progress';
$string['isgreaterthan'] = 'er større enn';
$string['islessthan'] = 'er mindre enn';
$string['lastaccess'] = 'Siste tilgang';
$string['lastattempt'] = 'Sist forsøkt';
$string['lockframe'] = 'Lås felt';
$string['maxeventlength'] = 'Maksimalt antall dager for en enkelt kalenderhendelse';
$string['mediafilter_hotpot'] = 'Hotpot mediafilter';
$string['mediafilter_moodle'] = 'Moodle standard mediafilter';
$string['migratingfiles'] = 'Slår sammen Hot Potatoes quizfiler';
$string['migratinglogs'] = 'Migrerer Hot Potatoes logger';
$string['missingsourcetype'] = 'HotPot-posten mangler kildetype';
$string['modulename'] = 'Hotpot';
$string['modulename_help'] = 'HotPot-modulen tillater lærere å distribuere interaktivt materiale til studentene sine via Moodle og se rapporter for studentenes svar og resultater.

En enkelt HotPot-aktivitet består av en valgfri startside, en enkel elæringspoppgave, og en valgfri avslutningsside. Elæringsoppgaven kan være en statisk eller interaktiv webside som viser tekst, lyd eller bilde til studentene og som lagrer svarene deres. Elæringsoppgaven lages på lærerens datamaskin ved hjelp av at forfatterprogram og blir så lastet opp til Moodle.

En HotPot-aktivitet kan innholde oppgaver fra følgende programmer:

* Hot Potatoes (version 6)
* Quedoc
* Xerte
* iSpring
* eller en HTML-editor';
$string['modulenameplural'] = 'Hotpot-er';
$string['nameadd'] = 'Navn';
$string['nameadd_help'] = 'Navnet kan være angitt tekst læreren skriver inn, eller kan også genereres automatisk.

**Hent fra kildefilen**
: navnet blir hentet ut fra kildefilen.

**Bruk filnavnet på kildefilen**
: navnet på kildefilen blir brukt som navn.

**Bruk stien til kildefilen**
: stien til kildefilen blir da brukt som navn. Slasher (/) blir erstattet med mellomrom.

**Angitt tekst**
: lærerens angitte tekst blir brukt som navn.';
$string['nameedit'] = 'Navn';
$string['nameedit_help'] = 'Den teksten som skal vises til studentene';
$string['navigation'] = 'Navigasjon';
$string['navigation_embed'] = 'Innebygd nettside';
$string['navigation_frame'] = 'Moodle navigasjonsramme';
$string['navigation_give_up'] = 'A single "Give Up" button';
$string['navigation_help'] = 'Denne innstillingen bestemmer hvordan navigeringen i prøven skal foregå:

* Moodle navigasjon - Da vises Moodles navigasjonselementer på toppen av samme side som prøven.
* Moodle ramme - Da vises Moodles navigasjonselementer i en egen ramme over prøven.
* Inkludert IFRAME - Moodles navigasjonselementer vises i samme vindu som prøven og prøven blir innebygd med en IFRAME.
* Hot Potatoes sine prøveknapper - Prøven vises med navigasjonsknapper (hvis de finnes) definert i prøven.
* En enkelt "Jeg gir opp" knapp - Prøven vises med en enkelt knapp "Jeg gir opp" på toppen av siden.
* Ingenting - Prøven vises uten noen navigasjonselementer. Når prøven er besvart korrekt vil (avhengig av "Vis neste prøve"-innstillingene) Moodle enten returnere til kurssiden eller vise neste prøve.';
$string['navigation_moodle'] = 'Standard Moodle navigasjonselementer (topp og side)';
$string['navigation_none'] = 'None';
$string['navigation_original'] = 'Standard navigasjonshjelp';
$string['navigation_topbar'] = 'Moodle navigasjonselementer i toppen av siden (ingen sideelementer)';
$string['noactivity'] = 'Ingen aktivitet';
$string['nohotpots'] = 'Fant ingen HotPot';
$string['nomoreattempts'] = 'Beklager, du har ingen flere forsøk på denne aktiviteten.';
$string['noresponses'] = 'No information about individual questions and responses was found.';
$string['noreview'] = 'Beklager, du har ikke tillatelse til å se detaljene fra forsøkene på denne prøven.';
$string['noreviewafterclose'] = 'Beklager, men denne quizzen er nå stengt. Du har ikke lenger tillatelse til å se detaljene fra dette quiz-forsøket.';
$string['noreviewbeforeclose'] = 'Beklager, du har ikke tillatelse til å se detaljene fra dette Quiz-forsøket før {$a}';
$string['nosourcefilesettings'] = 'Hotpot-oppføringen mangler informasjon fra kildefila.';
$string['notattemptedyet'] = 'Ikke forsøkt ennå';
$string['notavailable'] = 'Beklager, denne aktiviteten er ikke tilgjengelig for deg akkurat nå.';
$string['outputformat'] = 'Output format';
$string['outputformat_best'] = 'best';
$string['outputformat_help'] = 'Denne innstillingen angnir hvilket format som prøven skal vises i.

* Beste - Den beste innstillingen for nettleseren
* v6+ - Dra og slipp-format for v6+ nettlesere
* v6 - Format for v6 nettlesere';
$string['outputformat_hp_6_jcloze_html'] = 'JCloze HP6 html: Standard';
$string['outputformat_hp_6_jcloze_html_dropdown'] = 'JCloze HP6 html: Rottmeier listemeny';
$string['outputformat_hp_6_jcloze_html_findit_a'] = 'JCloze HP6 html: Rottmeier FindIt (a)';
$string['outputformat_hp_6_jcloze_html_findit_b'] = 'JCloze HP6 html: Rottmeier FindIt (b)';
$string['outputformat_hp_6_jcloze_html_jgloss'] = 'JCloze HP6 html: Rottmeier JGloss';
$string['outputformat_hp_6_jcloze_xml_anctscan'] = 'JCloze from HP6 xml: ANCT-Scan';
$string['outputformat_hp_6_jcloze_xml_dropdown'] = 'JCloze from HP6 xml: Rottmeier DropDown';
$string['outputformat_hp_6_jcloze_xml_findit_a'] = 'JCloze from HP6 xml: Rottmeier FindIt (a)';
$string['outputformat_hp_6_jcloze_xml_findit_b'] = 'JCloze from HP6 xml: Rottmeier FindIt (b)';
$string['outputformat_hp_6_jcloze_xml_jgloss'] = 'JCloze from HP6 xml: Rottmeier JGloss';
$string['outputformat_hp_6_jcloze_xml_v6'] = 'JCloze from HP6 xml: Standard';
$string['outputformat_hp_6_jcloze_xml_v6_autoadvance'] = 'JCloze (v6) fra HP6 xml (Auto-advance)';
$string['outputformat_hp_6_jcross_html'] = 'JCross HP6 html';
$string['outputformat_hp_6_jcross_xml_v6'] = 'JCross from HP6 xml';
$string['outputformat_hp_6_jmatch_html'] = 'JMatch from html';
$string['outputformat_hp_6_jmatch_html_sort'] = 'JMatch Sort from html';
$string['outputformat_hp_6_jmatch_xml_flashcard'] = 'JMatch from HP6 xml: Flashcard';
$string['outputformat_hp_6_jmatch_xml_jmemori'] = 'JMatch from HP6 xml: Rottmeier JMemori';
$string['outputformat_hp_6_jmatch_xml_sort'] = 'JMatch Sort from xml';
$string['outputformat_hp_6_jmatch_xml_v6'] = 'JMatch from HP6 xml: Standard';
$string['outputformat_hp_6_jmatch_xml_v6_plus'] = 'JMatch from HP6 xml: Drag and Drop';
$string['outputformat_hp_6_jmix_html'] = 'JMix from HP6 html';
$string['outputformat_hp_6_jmix_xml_v6'] = 'JMix from HP6 xml: Standard';
$string['outputformat_hp_6_jmix_xml_v6_plus'] = 'JMix from HP6 xml: Drag and Drop';
$string['outputformat_hp_6_jmix_xml_v6_plus_deluxe'] = 'JMix (v6+ with prefix, suffix with distractors) from xml';
$string['outputformat_hp_6_jmix_xml_v6_plus_keypress'] = 'JMix from HP6 xml: Drag and Drop with key press';
$string['outputformat_hp_6_jquiz_html'] = 'JQuiz HP6 html';
$string['outputformat_hp_6_jquiz_xml_v6'] = 'JQuiz from HP6 xml: Standard';
$string['outputformat_hp_6_jquiz_xml_v6_autoadvance'] = 'JQuiz from HP6 xml: Auto-advance';
$string['outputformat_hp_6_jquiz_xml_v6_exam'] = 'JQuiz from HP6 xml: Exam';
$string['outputformat_hp_6_rhubarb_html'] = 'WebRhubarb (v6) from html';
$string['outputformat_hp_6_rhubarb_xml'] = 'WebRhubarb (v6) from xml';
$string['outputformat_hp_6_sequitur_html'] = 'WebSequitur (v6) from html';
$string['outputformat_hp_6_sequitur_html_incremental'] = 'WebSequitur (v6) from html, incremental scoring';
$string['outputformat_hp_6_sequitur_xml'] = 'WebSequitur (v6) from xml';
$string['outputformat_hp_6_sequitur_xml_incremental'] = 'WebSequitur (v6) from xml, incremental scoring';
$string['outputformat_html_ispring'] = 'iSpring HTML-fil';
$string['outputformat_html_xerte'] = 'Xerte HTML-fil';
$string['outputformat_html_xhtml'] = 'Standard HTML-fil';
$string['outputformat_qedoc'] = 'Qedoc fil';
$string['overviewreport'] = 'Oversikt';
$string['penalties'] = 'Straffepoeng';
$string['percent'] = 'Prosent';
$string['pluginadministration'] = 'HotPot administrasjon';
$string['pluginname'] = 'Hot Potatoes-kviss';
$string['pressoktocontinue'] = 'Klikk OK for å fortsette eller Avbryt for å bli på gjeldende side';
$string['questionshort'] = 'Q-{$a}';
$string['quizname_help'] = 'hjelpetekst for Quizzens tittel';
$string['quizzes'] = 'Quizzer';
$string['responses'] = 'Svar';
$string['responsesreport'] = 'Responser';
$string['reviewafterattempt'] = 'Tillat gjennomgang etter forsøket';
$string['reviewafterclose'] = 'Tillat gjennomgang etter at HotPot stenger';
$string['reviewduringattempt'] = 'Tillat gjennomgang under forsøker';
$string['reviewoptions'] = 'Gjennomgangsvalg';
$string['score'] = 'Poeng';
$string['scoresreport'] = 'Score';
$string['selectattempts'] = 'Velg forsøk';
$string['showerrormessage'] = 'Hotpot feil: {$a}';
$string['sourcefile'] = 'Navn på kildefil';
$string['sourcefile_help'] = 'Denne innstillingen spesifiserer filen som inneholder det som  skal vises til studentene.

Vanligvis vil kildefilen ha blitt laget utenfor Moodle, og så lastet opp til filområdet i et kurs. Det kan være en html-fil, eller det kan være en annen filtype som har blitt laget av forfatterverktøy som Hot Potatoes eller Qedoc.

Kildefilen kan spesifiseres som en mappe og sti i Moodles filområde, eller som en url begynnende med http:// eller https://

For materiale fra Qedoc, må kildefilen være URLen til en Qedoc-modul som har blitt lastet opp til Qudoc-serveren, f.eks. http://www.qedoc.net/library/ABCDE_123.zip

For informasjon om opplasting av Qedoc-moduler, se [Qedoc dokumentasjon: Uploading_modules](http://www.qedoc.org/en/index.php?title=Uploading_modules)';
$string['sourcefilenotfound'] = 'Kildefil ikke funnet (eller tom): {$a}';
$string['status'] = 'Status';
$string['stopbutton'] = 'Vis stopp-knapp';
$string['stopbutton_help'] = 'Dersom denne innstillingen er aktivert, vil det legges til en STOPP-knapp i Quizzen.

Hvis studenten klikker på stopp-knappen, blir resultatet så langt returnert til Moodle og status for quizz-forsøket satt til avbrutt.

Teksten som vises på stopp-knappen kan være en av de forhåndsdefinerte frasene fra Moodles språkpakker, eller læreren kan angi egen knappetekst.';
$string['stopbutton_langpack'] = 'Fra språkpakke';
$string['stopbutton_specific'] = 'Bruk angitt tekst';
$string['stoptext'] = 'Tekst på STOPP-knappen';
$string['storedetails'] = 'Lagre rene XML-detaljer fra Hotpot Quiz-forsøk';
$string['studentfeedback'] = 'Studentilbakemelding';
$string['studentfeedback_help'] = 'Dersom aktivert, vil det vises en lenke til et sprettopp-vindu som vises hver gang studenten klikker på "Sjekk dette svaret"-knappen. Tilbakemeldingsvinduet lar studentene sende en tilbakemelding til læreren på fire mulige måter:

* Webside (krever en URL til en webside, f.eks http://myserver.com/cgi-bin/formmail.pl)
* Moodle forum - Forumoversikten for kurset vises
* Moodles meldingssystem - Da vises Moodles meldingsvindu. Har kurset flere lærere blir studenten bedt om å velge lærer før meldingsvinduet vises.';
$string['submits'] = 'Besvarelser';
$string['subplugintype_hotpotattempt'] = 'Utdataformat';
$string['subplugintype_hotpotattempt_plural'] = 'Utdataformater';
$string['subplugintype_hotpotreport'] = 'Rapport';
$string['subplugintype_hotpotreport_plural'] = 'Rapporter';
$string['subplugintype_hotpotsource'] = 'Kildefil';
$string['subplugintype_hotpotsource_plural'] = 'Kildefiler';
$string['textsourcefile'] = 'Hent fra kildefil';
$string['textsourcefilename'] = 'Bruk filnavn';
$string['textsourcefilepath'] = 'Bruk filsti';
$string['textsourcequiz'] = 'Hent fra Kviss';
$string['textsourcespecific'] = 'Spesifikk tekst';
$string['timeclose'] = 'TIlgjengelig til';
$string['timedout'] = 'Tiden utløpt';
$string['timelimit'] = 'Tidsgrense';
$string['timelimit_help'] = 'Denne innstillingen spesifiserer maksimal varighet på et enkelt forsøk.

**Bruk innstillinger i kilde- eller malfil**
: Tidsgrensen hentes fra kilde eller mal-filen for dette utdataformatet

** Bruke spesifisert tid**
: Tidsgrensen spesifisert i innstillingene for HotPot-quizen vil brukes. Dette valget overstyrer tidsgrenser satt i kilde-,konfigurasjons- eller malfil for dette utdataformatet

** Deaktiver**
: Ingen tidsgrense for forsøk i denne quizen

Merk at dersom et forsøk gjenopptas, vil klokka fortsette fra der det forrige forsøket sluttet.';
$string['timelimitexpired'] = 'Tidsgrensen for dette forsøket er passert';
$string['timelimitspecific'] = 'Bruk angitt tid';
$string['timelimitsummary'] = 'Tidsbegrensning for ett forsøk';
$string['timelimittemplate'] = 'Bruk innstillinger fra kilde/mal-fil';
$string['timeopen'] = 'Tilgjengelig fra';
$string['timeopenclose'] = 'Åpnings- og lukningstider';
$string['timeopenclose_help'] = 'Du kan angi tidsperioden for når quizzen skal være tilgjengelig for brukerne. Før og etter angitte tidspunkt vil quizzen være utilgjengelig.';
$string['title'] = 'Tittel';
$string['title_help'] = 'Denne innstillingen bestemmer tittelen som skal vises på websiden.

**HotPot aktivitetsnavn**
: Navnet på denne HotPot-aktiviteten vil bli vist som tittel på websiden

**Hent fra kildefil**
: Navnet, hvis definert i kildefilen vil bli vist som tittel på websiden.

**Bruk navnet på kildefilen**
: Navnet på kildefilen (uten mappenavn) vil bli vist som tittel på websiden

**Bruk kildefilstien**
: Navnet på kildefilen (inkludert mappenavn) vil bli vist som tittel på websiden';
$string['toolsindex'] = 'HotPot verktøyindeks';
$string['unitname_help'] = 'hjelpetekst for elementnavn';
$string['unrecognizedsourcefile'] = 'Beklager, HotPot-modulen kunne ikke finne kildefiletypen: {$a}';
$string['updated'] = 'Oppdatert';
$string['updatinggrades'] = 'Oppdaterer HotPot-karakterer';
$string['usefilters'] = 'Bruk filtrering';
$string['usefilters_help'] = 'Dersom denne innstillingen er aktivert, vil innholdet filtreres i Moodles filtere før de sendes til nettleseren.';
$string['useglossary'] = 'Bruk ordbok';
$string['useglossary_help'] = 'Hvis denne innstillingen er aktivert vil innholdet bli sendt gjennom Moodles autolenkefilter før det vises i nettleseren.

Merk at denne innstillingen overstyrer portaladministratorens innstillinger (aktivert/deaktivert) på dette filteret.';
$string['usemediafilter'] = 'Bruk mediafilter';
$string['usemediafilter_help'] = 'Denne innstillingen spesifiserer mediafilteret som skal brukes.

**Ingen**
:Innholdet vil ikke gå gjennom noe mediafilter

**Moodles standard mediafilter**
:Inhholdet vil gå gjennom Moodles standard mediafilter. Dette filterer søker etter lenker for vanlige lyd- og videofiler og konverter disse lenkene til passende mediaspillere

**HotPot mediafilter**
:Innholdet vil gå gjennomfilter som oppdager lenker bilder, lyd og video når det er brukt klammeparenteser. F.eks. <code>[url player width height options]</code>

**UTL**
:Den relative eller absolutte utlen til mediafilen.

**Spiller** (valgfritt)
: Navnet på spilleren som skal brukes for å vise innholdet. Standardverdien er "moodle". Standardversjonen av HotPot-modulen har også med følgende spillere:
**dew** en mp3-spiller
**dyer** en mp3-spiller  laget av Bernard Dyer
**hbs** en mp3-spiller fra Half-Baked Software
**image** setter inn et bilde på websiden
**link** setter inn en lenke til en annen webside

**Bredde** (valgfritt)
:Den påkrevde bredden for spilleren.

**Høyde** (valgfritt)
: Den påkrevde høyden for spilleren. Dersom denne er tom, brukes samme verdi som for bredden

**Valg** (valgfritt)
: en kommaseparert liste med valg for spilleren. Hvert valg kan være en enkelt av/på-bryter, eller et navnepar
: **navn=verdi
: **navn="en verdi med mellomrom"';
$string['viewreports'] = 'Vis rapporter for {$a} brukere';
$string['views'] = 'Visninger';
$string['weighting'] = 'Vekting';
$string['wrong'] = 'Feil';
$string['zeroduration'] = 'Ingen tidsbegrensning';
$string['zeroscore'] = 'Ingen skår';
