<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'ar', version '3.10'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.blog.errorloadentries'] = 'خطأ عند تحميل مدخلات المدونة.';
$string['addon.blog.showonlyyourentries'] = 'إظهار مدخلاتك فقط';
$string['addon.calendar.calendarevent'] = 'حَدَث التقويم';
$string['addon.calendar.calendarevents'] = 'أحداث التقويم';
$string['addon.calendar.calendarreminders'] = 'تذكيرات التقويم';
$string['addon.calendar.currentmonth'] = 'الشهر الحالي';
$string['addon.calendar.defaultnotificationtime'] = 'الوقت الافتراضي للإشعار';
$string['addon.calendar.errorloadevent'] = 'خطأ في تحميل الحدث';
$string['addon.calendar.errorloadevents'] = 'خطأ عند تحميل الأحداث.';
$string['addon.calendar.noevents'] = 'لا توجد أي أحداث';
$string['addon.calendar.reminders'] = 'التذكيرات';
$string['addon.calendar.setnewreminder'] = 'ضع تذكيراً جديداً';
$string['addon.competency.errornocompetenciesfound'] = 'لا يوجد أي قدرات موجودة';
$string['addon.competency.nocompetencies'] = 'لا يوجد أي قدرات';
$string['addon.coursecompletion.complete'] = 'مكتمل';
$string['addon.coursecompletion.couldnotloadreport'] = 'لا يمكن تحميل تقرير إكمال المقرر، الرجاء المحاولة في وقت آخر';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'تهيئة الأجهزة';
$string['addon.messages.contactlistempty'] = 'قائمة الاتصال فارغة';
$string['addon.messages.contactname'] = 'اسم عنوان الاتصال';
$string['addon.messages.deletemessage'] = 'حذف الرسالة';
$string['addon.messages.deletemessageconfirmation'] = 'هل أنت متأكد من رغبتك في حذف هذه الرسالة؟ سيتم حذفها فقط من ماضي رسائلك وسبقى مرئية من جهة المستخدم الذي أرسلها أو تلقاها.';
$string['addon.messages.errordeletemessage'] = 'خطأ عند حذف الرسالة';
$string['addon.messages.errorwhileretrievingcontacts'] = 'خطأ عند استرجاع عناوين الاتصال من المخدم.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'خطأ عند استرجاع المناقشات من المخدم.';
$string['addon.messages.errorwhileretrievingmessages'] = 'خطأ عند استرجاع الرسائل من المخدم.';
$string['addon.messages.errorwhileretrievingusers'] = 'خطأ عند استرجاع المستخدمين من المخدم.';
$string['addon.messages.messagenotsent'] = 'لم يتم إرسال الرسالة، يرجي المحاولة لاحقا';
$string['addon.messages.newmessages'] = 'الرسائل الجديدة';
$string['addon.messages.nousersfound'] = 'لا يوجد مستخدمين';
$string['addon.messages.showdeletemessages'] = 'إظهار حذف الرسائل';
$string['addon.messages.type_blocked'] = 'محظور';
$string['addon.messages.type_offline'] = 'غير متصل';
$string['addon.messages.type_online'] = 'متصل';
$string['addon.messages.type_search'] = 'نتائج البحث';
$string['addon.messages.type_strangers'] = 'رسائل أخرى';
$string['addon.messages.useentertosenddescdesktop'] = 'عند تعطيله، يمكنك استعمال Ctrl+Enter لإرسال الرسالة.';
$string['addon.messages.useentertosenddescmac'] = 'عند تعطيله، يمكنك استعمال Cmd+Enter لإرسال الرسالة.';
$string['addon.messages.warningconversationmessagenotsent'] = 'تعذر إرسال الرسالة/الرسائل إلى المحادثة {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'تعذر إرسال الرسالة/الرسائل إلى المستخدم {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'يرجى قبول بيان التسليم.';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'لا يمكنك إضافة التسليم في التطبيق أو تحريره لأن بيان التسليم تعذر استرجاعه من الموقع.';
$string['addon.mod_assign.cannotgradefromapp'] = 'بعض طرق منح العلامات غير مدعومة حتى الآن من قبل التطبيق ولا يمكن تعديلها.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'لا يمكنك إجراء التسليم من التطبيق لأن بيان التسليم تعذر استرجاعه من الموقع.';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'لا يمكنك إضافة التسليم أو تحريره من التطبيق لأن بعض الملاحق لا تزال غير مدعومة لأغراض التحرير.';
$string['addon.mod_assign.errorshowinginformation'] = 'لا يمكن عرض معلومات التسليم.';
$string['addon.mod_assign.feedbacknotsupported'] = 'هذه الإفادة غير مدعومة من قبل التطبيق وقد لا تحتوي على كل المعلومات.';
$string['addon.mod_assign.gradenotsynced'] = 'العلامة غير مُزامَنة';
$string['addon.mod_assign.notallparticipantsareshown'] = 'المشاركون الذين لم يقدموا التسليم غير ظاهرين.';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'هناك {{count}} من المسودات.';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'هناك {{count}} من المشاركين.';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'هناك {{count}} من التسليمات التي بحاجة إلى تقييم.';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'هناك {{count}} من الواجبات المسلَّمة.';
$string['addon.mod_assign.numberofteamscountdescription'] = 'هناك {{count}} من الفِرق.';
$string['addon.mod_assign.submissionnotsupported'] = 'هذا التسليم غير مدعوم من قبل التطبيق وقد لا يحتوي على كل المعلومات.';
$string['addon.mod_assign.syncblockedusercomponent'] = 'علامة المستخدم';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'علامة التسليم قد تم تعديلها في الموقع.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'تسليم المستخدم قد تم تعديله في الموقع.';
$string['addon.mod_chat.confirmloss'] = 'هل أنت متأكد؟ يمكن فقدان ماضي المحادثة.';
$string['addon.mod_chat.errorwhileconnecting'] = 'خطأ عند الاتصال بالدردشة';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'خطأ عند الحصول على معلومات الدردشة';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'خطأ عند الحصول على مستخدمي الدردشة';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'خطأ عند استرجاع الرسائل من المخدم.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'خطأ عند إرسال الرسالة';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'ينبغي أن تكون متصلاً بالإنترنت لإرسال الرسائل.';
$string['addon.mod_chat.nosessionsfound'] = 'لم يتم العثور على أي جلسات';
$string['addon.mod_chat.showincompletesessions'] = 'إظهار الجلسات غير المكتملة';
$string['addon.mod_choice.errorgetchoice'] = 'خطأ عند جلب بيانات الاختيار.';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% من المستخدمين إختاروا الخيار: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'استجابتك الأخيرة تنبغي مزامنتها قبل تضمينها في النتائج.';
$string['addon.mod_data.edittagsnotsupported'] = 'عذراً، تحرير الوسوم غير مدعوم من قبل التطبيق.';
$string['addon.mod_data.errorapproving'] = 'خطأ عند الموافقة على المصطلح أو إلغاء الموافقة عليه.';
$string['addon.mod_data.errordeleting'] = 'خطأ عند حذف المصطلح.';
$string['addon.mod_data.gettinglocation'] = 'جلب الموقع';
$string['addon.mod_data.locationnotenabled'] = 'الموضع غير مُمَكَّن';
$string['addon.mod_data.locationpermissiondenied'] = 'قد تم رفض منح الصلاحية للوصول إلى موضعك.';
$string['addon.mod_data.mylocation'] = 'موضعي';
$string['addon.mod_data.searchbytagsnotsupported'] = 'عذراً، البحث في الوسوم غير مدعوم من قبل التطبيق.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'لا يمكن إكمال الإفادة مع استعمال CAPTCHA بدون الاتصال بالإنترنت، أو إذا لم تتم تهيئته أو إن الموقع مغلق.';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = 'هناك {{count}} من الإجابات المسلَّمة.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'قد تم حفظ هذه الإفادة لتسليمها لاحقاً.';
$string['addon.mod_feedback.questionscountdescription'] = 'هناك {{count}} من الأسئلة.';
$string['addon.mod_folder.emptyfilelist'] = 'لا يوجد أي ملفات ليتم إظهارها';
$string['addon.mod_forum.errorgetforum'] = 'خطأ عند جلب بيانات المنتدى.';
$string['addon.mod_forum.errorgetgroups'] = 'خطأ عند جلب إعدادات المجموعة.';
$string['addon.mod_forum.errorposttoallgroups'] = 'تعذر إنشاء مناقشة جديدة في كل المجموعات.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'لا توجد مناقشات بعد في هذا المنتدى.';
$string['addon.mod_forum.group'] = 'مجموعة';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} من المناقشات';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} من الردود';
$string['addon.mod_forum.refreshdiscussions'] = 'تنشيط المناقشات';
$string['addon.mod_forum.refreshposts'] = 'تنشيط المنشورات';
$string['addon.mod_glossary.browsemode'] = 'استعراض المصطلحات';
$string['addon.mod_glossary.byalphabet'] = 'أبجدياً';
$string['addon.mod_glossary.byauthor'] = 'التجميع طبقا للمؤلف';
$string['addon.mod_glossary.bycategory'] = 'التجميع حسب التصنيف';
$string['addon.mod_glossary.bynewestfirst'] = 'الأحدث أولا';
$string['addon.mod_glossary.byrecentlyupdated'] = 'تم تحديثه مؤخرا';
$string['addon.mod_glossary.bysearch'] = 'بحث';
$string['addon.mod_glossary.cannoteditentry'] = 'لا يمكن تحرير المصطلح';
$string['addon.mod_glossary.entriestobesynced'] = 'المصطلحات المزمعة مزامنتها';
$string['addon.mod_glossary.entrypendingapproval'] = 'هذا المصطلح ينتظر الموافقة.';
$string['addon.mod_glossary.errorloadingentries'] = 'وقع خطأ عند تحميل المصطلحات.';
$string['addon.mod_glossary.errorloadingentry'] = 'وقع خطأ عند تحميل المصطلح.';
$string['addon.mod_glossary.errorloadingglossary'] = 'وقع خطأ عند تحميل المسرد.';
$string['addon.mod_glossary.noentriesfound'] = 'لم يتم العثور على أي مصطلحات.';
$string['addon.mod_glossary.searchquery'] = 'عبارة البحث';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'تنزيل ملف H5P';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'خطأ عند جلب بيانات نشاط H5P';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'رزمة H5P غير منزلة. عليك تنزيلها لتتمكن من استعمالها.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'لقد تم تعديل رزمة H5P منذ آخر تنزيل لها. عليك تنزيلها مجدداً لتتمكن من استعمالها.';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'ينبغي أن تكون متصلاً بالإنترنت لمعاينة رزمة H5P .';
$string['addon.mod_h5pactivity.viewattempt'] = 'معاينة المحاولة {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'اظهر الوصف';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'هذا الدرس يحتوي على قفزة عشوائية إلى صفحة محتوى. لا يمكن محاولته من التطبيق حتى يتم الشروع به من مستعرض الويب.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'لم يعد بالإمكان مراجعة هذه المحاولة لأن محاولة أخرى قد تم إنهاؤها.';
$string['addon.mod_lesson.finishretakeoffline'] = 'تم إنهاء هذه المحاولة بدون الاتصال بالإنترنت.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'تمت مزامنة محاولة جرت بدون الاتصال. هل ترغب بمراجعتها؟';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'تم إنهاء المحاولة في الموقع.';
$string['addon.mod_lti.errorgetlti'] = 'خطأ عند جلب بيانات الوحدة.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'عنوان رابط الإطلاق غير صحيح.';
$string['addon.mod_lti.launchactivity'] = 'إطلاق النشاط';
$string['addon.mod_page.errorwhileloadingthepage'] = 'خطأ عند تحميل محتوى الصفحة.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'يمكنك محاولة هذا الاختبار في التطبيق، ولكن ستضطر إلى تسليمها عبر المستعرض للأسباب الآتية:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'محاولة هذا الاختبار لا يمكن تسليمها للأسباب التالية:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'لم تتم مزامنة هذه المحاولة منذ {{$a}}. إذا قمت بإكمال هذه المحاولة من جهاز آخر منذ ذلك الحين، فقد تخسر بياناتك.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'وقع خطأ عند حفظ الإجابات. هل أنت متأكد من رغبتك في ترك الاختبار؟';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'لا يمكن محاولة هذا الاختبار من التطبيق لأن سلوك الأسئلة غير مدعوم من قبل التطبيق:';
$string['addon.mod_quiz.errordownloading'] = 'خطأ عن تنزيل البيانات المطلوبة';
$string['addon.mod_quiz.errorgetattempt'] = 'خطأ عند جلب بيانات المحاولة.';
$string['addon.mod_quiz.errorgetquestions'] = 'خطأ عند جلب الأسئلة.';
$string['addon.mod_quiz.errorgetquiz'] = 'خطأ عند الحصول على بيانات الاختبار';
$string['addon.mod_quiz.errorparsequestions'] = 'وقع خطأ عند قراءة الأسئلة. لطفاً، حاول هذا الاختبار في مستعرض الويب.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'لا يمكن محاولة هذا الاختبار من التطبيق لأنه يضم فقط أسئلة غير مدعومة في التطبيق:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'لا يمكن محاولة هذا الاختبار من التطبيق لأن فيه قواعد وصول غير مدعومة من قبل التطبيق:';
$string['addon.mod_quiz.errorsaveattempt'] = 'وقع خطأ عند حفظ بيانات المحاولة.';
$string['addon.mod_quiz.finishnotsynced'] = 'منتهٍ ولكنه غير مُزامَن';
$string['addon.mod_quiz.opentoc'] = 'إفتح التنقل المنبثق';
$string['addon.mod_quiz.warningattemptfinished'] = 'تم إهمال المحاولة التي جرت بدون الاتصال بالإنترنت نظراً لإكمالها عبر الموقع مباشرة أو لأنه لم يتم العثور عليها.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'بعض المحاولات التي جرت بدون الاتصال بالإنترنت تم إهمالها نظراً لتعديل الأسئلة عبر الموقع مباشرة.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'المحاولة لم يتم إنهاؤها بسبب إهمال بعض الأسئلة التي كانت بدون الاتصال بالإنترنت. لطفاً، راجع إجاباتك ثم أعد تسليم المحاولة.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'هذا الاختبار يحتوي على أسئلة غير مدعومة من قبل التطبيق:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'خطأ عند تحميل المحتوى.';
$string['addon.mod_resource.openthefile'] = 'فتح';
$string['addon.mod_scorm.cannotcalculategrade'] = 'لا يمكن حساب العلامة.';
$string['addon.mod_scorm.dataattemptshown'] = 'هذه البيانات تعود المحاولة المرقمة {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'وقع خطأ عند إنشاء محاولة جديدة بدون الاتصال. يرجى المحاولة مجدداً.';
$string['addon.mod_scorm.errordownloadscorm'] = 'خطأ عن تنزيل الحزمة التعليمية: "{{name}}"';
$string['addon.mod_scorm.errorgetscorm'] = 'خطأ عند جلب بيانات سكورم.';
$string['addon.mod_scorm.errorinvalidversion'] = 'عذراً، التطبيق يدعم سكورم، الإصدار 1.2 فقط.';
$string['addon.mod_scorm.errornotdownloadable'] = 'تنزيل حزم سكورم معطل. يرجى التواصل مع المشرف على موقعك.';
$string['addon.mod_scorm.errornovalidsco'] = 'حزمة سكورم لا تحتوي على مكون محتوى قابل للمشاركة مرئي ليتم تحميله.';
$string['addon.mod_scorm.errorpackagefile'] = 'عذراً، التطبيق يدعم فقط رزم ZIP.';
$string['addon.mod_scorm.errorsyncscorm'] = 'وقع خطأ عند المزامنة. يرجى المحاولة مجدداً.';
$string['addon.mod_scorm.offlineattemptnote'] = 'هذه المحاولة تحتوي بيانات لم تتم مزامنتها بعد.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'لا يمكن إرسال هذه المحاولة لأنك تجاوزت العدد الأقصى من المحاولات.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'لم يتم تنزيل حزمة سكورم هذه. سيتم تنزيلها تلقائياً عندما تفتحها.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'تم تحديث حزمة سكورم هذه منذ آخر تنزيل لها. سيتم تنزيلها تلقائياً عندما تفتحها.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'تم التخلص من بعض البيانات التي بدون الاتصال للمحاولة {{number}} لعدم إمكانية إحتسابها كمحاولة جديدة.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'تعذرت مزامنة بعض المحاولات مع الموقع لأن آخر محاولة مع الاتصال غير منتهية حتى الآن. لطفاً، أنهِ المحاولة ذات الاتصال بالإنترنت أولاً.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'عذراً، وقع خطأ عند تسليم استبيانك. يرجى المحاولة مجدداً.';
$string['addon.mod_survey.errorgetsurvey'] = 'خطأ عند جلب بيانات الاستبيان';
$string['addon.mod_survey.results'] = 'النتائج';
$string['addon.mod_url.accessurl'] = 'الوصول إلى الرابط';
$string['addon.mod_url.pointingtourl'] = 'عنوان الرابط الذي يشير إليه المورد.';
$string['addon.mod_wiki.errorloadingpage'] = 'وقع خطأ عند تحميل الصفحة.';
$string['addon.mod_wiki.errornowikiavailable'] = 'لا يوجد أي محتوى في الويكي بعد.';
$string['addon.mod_wiki.gowikihome'] = 'إذهب إلى الصفحة الأولى في الويكي';
$string['addon.mod_wiki.subwiki'] = 'ويكي فرعي';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'العنوان ينبغي أن لا يكون فارغاً';
$string['addon.mod_wiki.viewpage'] = 'معاينة الصفحة';
$string['addon.mod_wiki.wikipage'] = 'صفحة الويكي';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'استراتيجية التقييم {{$a}} غير مدعومة';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'عليك إدخال العنوان.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'تم تعديل التسليم في الموقع.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'تم تعديل التقييم في الموقع.';
$string['addon.notes.warningnotenotsent'] = 'تعذرت إضافة الملاحظات إلى المساق {{course}}. {{error}}';
$string['addon.notifications.errorgetnotifications'] = 'خطأ في الحصول على الإشعارات';
$string['addon.notifications.notifications'] = 'الإشعارات';
$string['addon.notifications.playsound'] = 'تشغيل الصوت';
$string['addon.notifications.therearentnotificationsyet'] = 'لا توجد إشعارات';
$string['addon.privatefiles.couldnotloadfiles'] = 'تعذر تحميل قائمة الملفات.';
$string['addon.privatefiles.emptyfilelist'] = 'ليس هناك ملفات لإظهارها.';
$string['addon.privatefiles.erroruploadnotworking'] = 'للأسف، ليس بالإمكان حاليًا رفع الملفات إلى موقعك.';
$string['addon.storagemanager.deletecourse'] = 'تفريف كل بيانات المساق';
$string['addon.storagemanager.deletecourses'] = 'تفريف كل بيانات المساقات';
$string['addon.storagemanager.deletedatafrom'] = 'تفريغ البيانات من {{name}}';
$string['addon.storagemanager.info'] = 'الملفات المخزونة في جهازك تجعل التطبيق أسرع وتتيح له العمل بدون الاتصال بالإنترنت. يمكنك تفريغ الملفات بأمان إذا كنت بحاجة إلى مساحة الخزن التي تشغلها.';
$string['addon.storagemanager.managestorage'] = 'إدارة المخزون';
$string['addon.storagemanager.storageused'] = 'مخزون الملفات المستعمل:';
$string['appstoredescription'] = 'ملحوظة: تطبيق نظام مودل الرسمي هذا سيعمل فقط مع مواقع نظم التعلم الإلكتروني مودل التي تم إعدادها للسماح بذلك. إذا صادفتك أي مشاكل في الاتصال، من فضلك تواصل مع مشرفك لموقع مودل.

إذا كان موقع مودل الخاص بك قد تمت تهيئته بشكل صحيح، ستتمكن من استعمال هذا التطبيق في:

- تصفح محتوى مقرراتك حتى لو كنت غير متصل بالإنترنت
- استلام إشعارات فورية للرسائل والأحداث الأخرى
- العثور بسرعة على زملائك في المقررات الدراسية والتواصل معهم
- رفع الصور والملفات الصوتية والفيديوية وأي ملفات أخرى من جهازك الجوال
- معاينة علاماتك في المقررات الدراسية
- وأكثر!

من فضلك راجع https://docs.moodle.org/en/Mobile_app للإطلاع على آخر المعلومات الخاصة بالتطبيق.

نحن نُقدِّر حقاً أي تعقيبات جيدة بشأن الأداء حالياً، وملاحظاتك بشأن ما تريد لهذا التطبيق أن يقوم به أيضاً!

يتطلب التطبيق الحصول على الصلاحيات الآتية:
تسجيل الصوت - لتسجيل الأصوات ورفعها إلى مودل
قراءة وتعديل محتويات بطاقة الخزن الدائم لجهاز جوالك - يتم تنزيل المحتوى إلى بطاقة الخزن الدائم ليتسنى لك مشاهدتها بدون الاتصال بالإنترنت
الوصول إلى الشبكة - لتتمكن من الاتصال بموقع مودل الخاص بك والتحقق من هذا الاتصال لاتخاذ القرار بشأن الانتقال إلى نمط التشغيل بدون الاتصال
التشغيل عند البدء - لتتلقى الإشعارات محلياً حتى وإن كان التطبيق شغالاً في الخلفية
منع الجهاز من الخمول - لتتلقى دفعات الإشعارات في أي وقت';
$string['core.browser'] = 'المستعرض';
$string['core.cannotconnect'] = 'لا يمكن الاتصال';
$string['core.cannotconnecttrouble'] = 'تواجهنا صعوبات في الاتصال بموقعك.';
$string['core.cannotconnectverify'] = '<strong>يرجى التحقق من صحة العنوان.</strong>';
$string['core.cannotdownloadfiles'] = 'تنزيل الملفات معطل. يرجى التواصل مع المشرف على موقعك.';
$string['core.cannotopeninapp'] = 'قد لا يعمل هذا الملف كما هو متوقع في هذا الجهاز. هل ترغب بفتحه على أي حال؟';
$string['core.cannotopeninappdownload'] = 'قد لا يعمل هذا الملف كما هو متوقع في هذا الجهاز. هل ترغب بتنزيله على أي حال؟';
$string['core.captureaudio'] = 'تسجيل الصوت';
$string['core.capturedimage'] = 'الصورة الملتقطة.';
$string['core.captureimage'] = 'إلتقط صورة';
$string['core.capturevideo'] = 'تسجيل الفيديو';
$string['core.clearsearch'] = 'إخلاء البحث';
$string['core.clearstoreddata'] = 'إخلاء المخزون {{$a}}';
$string['core.clicktoseefull'] = 'أنقر لمشاهدة المحتويات الكاملة.';
$string['core.comments.commentsnotworking'] = 'لا يمكن جلب التعليقات';
$string['core.comments.warningcommentsnotsent'] = 'تعذرت مزامنة التعليقات. {{error}}';
$string['core.confirmcanceledit'] = 'هل أنت متأكد من رغبتك في مغادرة هذه الصفحة؟ سيتم فقدان كل التغييرات.';
$string['core.confirmgotabroot'] = 'هل أنت متأكد من رغبتك في العودة إلى {{name}}؟';
$string['core.confirmgotabrootdefault'] = 'هل أنت متأكد من رغبتك في الذهاب إلى الصفحة الرئيسية للتبويب الحالي؟';
$string['core.confirmleaveunknownchanges'] = 'هل أنت متأكد من رغبتك في مغادرة هذه الصفحة؟ إن كانت لديك تغييرات غير محفوظة سيتم فقدانها.';
$string['core.confirmloss'] = 'هل أنت متأكد؟ سيتم فقدان كل التغييرات.';
$string['core.confirmopeninbrowser'] = 'هل ترغب بفتحها من مستعرض الويب؟';
$string['core.contenteditingsynced'] = 'المحتوى الذي تقوم بتحريره قد تمت مزامته.';
$string['core.contentlinks.chooseaccount'] = 'أختر الحساب';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'إختر حساباً لتفتح به الرابط.';
$string['core.contentlinks.confirmurlothersite'] = 'الرابط يعود لموقع آخر. هل تريد فتحه؟';
$string['core.contentlinks.errornoactions'] = 'تعذر العثور على إجراء لاتخاذه مع هذا الرابط.';
$string['core.contentlinks.errornosites'] = 'تعذر العثور على أي موقع لمعالجة هذا الرابط.';
$string['core.contentlinks.errorredirectothersite'] = 'عنوان رابط إعادة التوجيه لا يمكنه الإشارة إلى موقع مختلف.';
$string['core.copiedtoclipboard'] = 'تم نسخ النص في الحافظة';
$string['core.copytoclipboard'] = 'إنسخ إلى الحافظة';
$string['core.course.activitydisabled'] = 'قامت مؤسستك بتعطيل هذا النشاط في تطبيق الجوال.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'قامت مؤسستك بتنصيب ملحق ليس مدعوماً بعد.';
$string['core.course.activitynotyetviewablesiteupgradeneeded'] = 'تنصيب مودل لمنظمتك بحاجة إلى تحديث.';
$string['core.course.allsections'] = 'كل الأقسام';
$string['core.course.aria:sectionprogress'] = 'تقدم المقطع:';
$string['core.course.askadmintosupport'] = 'تواصل مع المشرف على الموقع وأبلغه برغبتك في استعمال هذا النشاط في تطبيق الجوال لمودل.';
$string['core.course.availablespace'] = 'لديك حالياً ما يقارب {{available}} من المساحة الخالية.';
$string['core.course.cannotdeletewhiledownloading'] = 'لا يمكن حذف الملفات خلال تنزيل النشاط. لطفاً، إنتظر ريثما يكتمل التنزيل.';
$string['core.course.confirmdeletemodulefiles'] = 'هل أنت متأكد من رغبتك في حذف هذه الملفات؟';
$string['core.course.confirmdeletestoreddata'] = 'هل أنت متأكد من رغبتك في حذف البيانات المخزونة؟';
$string['core.course.confirmdownload'] = 'أنت على وشك تنزيل {{size}}.{{availableSpace}} هل أنت متأكد من رغبتك في المتابعة؟';
$string['core.course.confirmdownloadunknownsize'] = 'لم يكن بالإمكان حساب حجم التنزيل.{{availableSpace}} هل أنت متأكد من رغبتك في المتابعة؟';
$string['core.course.confirmdownloadzerosize'] = 'أنت على وشك الشروع بالتنزيل.{{availableSpace}} هل أنت متأكد من رغبتك في المتابعة؟';
$string['core.course.confirmlimiteddownload'] = 'أنت متصل حالياً بالشبكة اللاسلكية.';
$string['core.course.confirmpartialdownloadsize'] = 'أنت على وشك تنزيل ما حجمه <strong>على الأقل</strong> {{size}}.{{availableSpace}}. هل أنت متأكد من رغبتك في المتابعة؟';
$string['core.course.contents'] = 'المحتويات';
$string['core.course.couldnotloadsectioncontent'] = 'تعذر تحميل محتوى المقطع. يرجى المحاولة مرة أخرى لاحقاً.';
$string['core.course.couldnotloadsections'] = 'لم يتم تحميل كل الأقسام، من فضلك حاول مرة أخرى لاحقاَ';
$string['core.course.downloadcoursesprogressdescription'] = 'تنزيل المساقات: تم تنزيل {{count}} من أصل {{total}}.';
$string['core.course.downloadsectionprogressdescription'] = 'تنزيل المقطع: تم تنزيل {{count}} من أصل {{total}}.';
$string['core.course.errordownloadingcourse'] = 'خطأ عند تنزيل المساق.';
$string['core.course.errordownloadingsection'] = 'خطأ عن تنزيل الأقسام';
$string['core.course.errorgetmodule'] = 'خطأ عند جلب بيانات النشاط.';
$string['core.course.insufficientavailablequota'] = 'تعذر على جهازك تخصيص مساحة لخزن هذا التنزيل. قد يكون محتفظاً بالمساحة من أجل تحديثات النظام أو التطبيقات. يرجى إخلاء بعض من مساحة الخزن أولاً.';
$string['core.course.insufficientavailablespace'] = 'أنت على وشك تنزيل ما حجمه {{size}}. هذا من شأنه أن يترك جهازك بمساحة لا تكفيه للعمل بشكل إعتيادي. يرجى إخلاء بعض من مساحة الخزن أولاً.';
$string['core.course.manualcompletionnotsynced'] = 'الإكمال اليدوي غير مُزامَن.';
$string['core.course.nocontentavailable'] = 'لا يتوفر أي محتوى حالياً.';
$string['core.course.refreshcourse'] = 'تنشيط المساق';
$string['core.course.useactivityonbrowser'] = 'لا زال بإمكانك استعمله عبر مستعرض الويب في جهازك.';
$string['core.course.warningmanualcompletionmodified'] = 'لقد تم في الموقع تعديل الإكمال اليدوي لنشاط ما.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'بعض تأشيرات الإكمال اليدوي للمساق \'{{name}}\' قد تم حذفها. {{error}}';
$string['core.coursenogroups'] = 'لستَ عضواً في أي مجموعة لهذا المساق.';
$string['core.courses.cannotretrievemorecategories'] = 'لا يمكن جلب التصنيفات ذات المستوى الأعمق من {{$a}}.';
$string['core.courses.confirmselfenrol'] = 'هل أنت متأكد من رغبتك في الانضمام إلى هذا المساق؟';
$string['core.courses.downloadcourses'] = 'تنزيل المساقات';
$string['core.courses.enrolme'] = 'ضُمني';
$string['core.courses.errorloadcategories'] = 'وقع خطأ عند تحميل التصنيفات.';
$string['core.courses.errorloadcourses'] = 'وقع خطأ عند تحميل المساقات.';
$string['core.courses.errorloadplugins'] = 'تعذر تحميل الملاحق المطلوبة من قبل هذا المساق بشكل صحيح. يرجى إعادة تحميل التطبيق للمحاولة مجدداً.';
$string['core.courses.errorsearching'] = 'وقع خطأ عند البحث.';
$string['core.courses.errorselfenrol'] = 'وقع خطأ عند إجراء الانضمام الذاتي.';
$string['core.courses.filtermycourses'] = 'ترشيح مساقاتي';
$string['core.courses.notenrollable'] = 'لا يمكنك الانضمام إلى هذا المساق.';
$string['core.courses.password'] = 'مفتاح الانضمام';
$string['core.courses.searchcoursesadvice'] = 'يمكنك استعمال زر البحث عن المساقات للعثور على المساقات التي تسمح بدخول الضيوف أو الانضمام إلى المساقات التي تسمح لك بدخولها.';
$string['core.courses.selfenrolment'] = 'الانضمام الذاتي';
$string['core.courses.totalcoursesearchresults'] = 'إجمالي المساقات: {{$a}}';
$string['core.currentdevice'] = 'الجهاز الحالي';
$string['core.datastoredoffline'] = 'تم خزن البيانات في الجهاز لتعذر إرسالها. سيتم إرسالها تلقائياً لاحقاً.';
$string['core.deletedoffline'] = 'محذوف بدون الاتصال';
$string['core.deleting'] = 'يجري الحذف';
$string['core.desktop'] = 'سطح المكتب';
$string['core.dfdaymonthyear'] = 'MM-DD-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'تجاهل';
$string['core.dismiss'] = 'صرف النظر';
$string['core.downloaded'] = 'مُنَزَّل';
$string['core.downloading'] = 'يتم التنزيل';
$string['core.editor.hidetoolbar'] = 'إخفاء شريط الأدوات';
$string['core.editor.toggle'] = 'تبديل المحرر';
$string['core.emptysplit'] = 'هذه الصفحة ستظهر فارغة إذا كانت اللوحة اليسرى خالية أو قيد التحميل.';
$string['core.errorchangecompletion'] = 'وقع خطأ عند تغيير حالة الإكمال. يرجى المحاولة مجدداً.';
$string['core.errordeletefile'] = 'وقع خطأ عند حذف الملف. يرجى المحاولة مجدداً.';
$string['core.errordownloading'] = 'خطأ عن تنزيل الملف';
$string['core.errordownloadingsomefiles'] = 'وقع خطأ عند تنزيل الملفات. بعض الملفات قد تكون مفقودة.';
$string['core.errorfileexistssamename'] = 'ملف بهذا الاسم موجود مسبقاً.';
$string['core.errorinvalidform'] = 'يحتوي النموذج على بيانات خاطئة. يرجى التحقق من أن كل الحقول المطلوبة مملوءة وأن بياناتها صحيحة.';
$string['core.errorinvalidresponse'] = 'تم تلقي استجابة خاطئة. يرجى التواصل مع مشرف موقعك إذا استمر هذا الخطأ بالظهور مراراً.';
$string['core.errorloadingcontent'] = 'خطأ عند تحميل المحتوى.';
$string['core.errorofflinedisabled'] = 'التصفح بدون الاتصال بالإنترنت مُعطل في موقعك. عليك الاتصال بالإنترنت لاستعمال التطبيق.';
$string['core.erroropenfilenoapp'] = 'وقع خطأ عند فتح الملف: لم يتم العثور على أي تطبيق يفتح هذا النوع من الملفات.';
$string['core.erroropenfilenoextension'] = 'وقع خطأ عند فتح الملف: الملف لا يحتوي على امتداد.';
$string['core.erroropenpopup'] = 'هذا النشاط يحاول فتح نافذة منبثقة. هذا غير مدعوم في التطبيق.';
$string['core.errorrenamefile'] = 'وقع خطأ عند إعادة تسمية الملف: يرجى المحاولة مجدداً.';
$string['core.errorsomedatanotdownloaded'] = 'إذا قمت بتنزيل هذا النشاط، يرجى ملاحظة أن بعض البيانات لا يتم تنزيلها خلال هذه عملية لأسباب تتعلق بالأداء وأسلوب التعامل مع البيانات.';
$string['core.errorsync'] = 'وقع خطأ عند المزامنة. يرجى المحاولة مجدداً';
$string['core.errorsyncblocked'] = 'لا يمكن مزامنة {{$a}} هذا الآن بسبب عملية لا تزال جارية. يرجى المحاولة لاحقاً. إذا تمادت المشكلة، حاول إعادة تشغيل التطبيق.';
$string['core.errorurlschemeinvalidscheme'] = 'من المفترض استعمال عنوان الرابط هذا في تطبيق آخر: {{$a}}.';
$string['core.errorurlschemeinvalidsite'] = 'لا يمكن فتح رابط الموقع هذا في هذا التطبيق.';
$string['core.filenameexist'] = 'اسم الملف موجود مسبقاً: {{$a}}';
$string['core.fileuploader.audio'] = 'صوتي';
$string['core.fileuploader.camera'] = 'الكاميرا';
$string['core.fileuploader.confirmuploadfile'] = 'أنت على وشك رفع ما حجمه {{size}}. هل أنت متأكد من رغبتك في المتابعة؟';
$string['core.fileuploader.confirmuploadunknownsize'] = 'لم يكن ممكناً حساب حجم ما مطلوب رفعه. هل أنت متأكد من رغبتك في المتابعة؟';
$string['core.fileuploader.errorcapturingaudio'] = 'خطأ في التقاط الصوت';
$string['core.fileuploader.errorcapturingimage'] = 'خطأ في التقاط الصورة';
$string['core.fileuploader.errorcapturingvideo'] = 'خطأ في التقاط الفيديو';
$string['core.fileuploader.errorgettingimagealbum'] = 'خطأ عند جلب الصورة من الألبوم.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'لابد أن تكون متصل بالأنترنت لكي يتم رفع الملفات';
$string['core.fileuploader.errornoapp'] = 'ليس لديك تطبيق منصب لتنفيذ هذا الإجراء.';
$string['core.fileuploader.errorreadingfile'] = 'خطأ في قراءة الملف';
$string['core.fileuploader.errorwhileuploading'] = 'وقع خطأ في أثناء رفع الملف.';
$string['core.fileuploader.file'] = 'ملف';
$string['core.fileuploader.fileuploaded'] = 'الملف الذي تم رفعه';
$string['core.fileuploader.maxbytesfile'] = 'الملف {{$a.file}} كبير الحجم. أقصى حجم يمكنك رفعه هو {{$a.size}}.';
$string['core.fileuploader.photoalbums'] = 'ألبومات الصور';
$string['core.fileuploader.readingfile'] = 'يتم قراءة الملف';
$string['core.fileuploader.readingfileperc'] = 'قراءة الملف: {{$a}}%';
$string['core.fileuploader.selectafile'] = 'إختر الملف';
$string['core.fileuploader.uploadafile'] = 'إرفع ملف';
$string['core.fileuploader.uploading'] = 'يتم الرفع';
$string['core.fileuploader.uploadingperc'] = 'جارٍ الرفع: {{$a}}%';
$string['core.fileuploader.video'] = 'فيديو';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.h5p.errorgetemail'] = 'خطأ عند الحصول على البريد الالكتروني للمستخدم. يرجى التحقق من اتصالك ثم المحاولة مجدداً.';
$string['core.h5p.offlinedisabled'] = 'الموقع لا يسمح بتنزيل حزم H5P.';
$string['core.h5p.play'] = 'تشغيل H5P';
$string['core.hasdatatosync'] = '{{$a}} هذا لديه بيانات بدون الاتصال تُفترض مزامنتها.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.iframehelp'] = 'هل هذا المحتوى عاطل؟';
$string['core.image'] = 'الصورة';
$string['core.imageviewer'] = 'معاين الصور';
$string['core.ioscookieshelp'] = 'قد يتطلب المحتوى المضمن تمكين ملفات تعريف الارتباط ليعمل. يرجى الذهاب إلى إعدادات تطبيقات iOS، ثم تمكين \'السماح بالتعقب عبر المواقع\' ثم حاول مجددًا.';
$string['core.lastdownloaded'] = 'آخر تنزيل';
$string['core.lastsync'] = 'آخر تزامن';
$string['core.loadmore'] = 'تحميل المزيد';
$string['core.login.authenticating'] = 'مصادقة';
$string['core.login.changepasswordbutton'] = 'إفتح صفحة تغيير كلمة المرور';
$string['core.login.changepasswordhelp'] = 'إن كانت لديك صعوبات في تغيير كلمة مرورك، يرجى الاتصال مع مشرف موقعك. "مشرفو الموقع" هم الأشخاص الذين يديرون مودل في مدرستك، جامعتك، شركتك أو منظمتك التعليمية. إذا لم تكن تعرف كيفية الاتصال بهم، لطفاً، تواصل مع معلمك/مدربك.';
$string['core.login.changepasswordinstructions'] = 'لا يمكنك تغيير كلمة مرورك في التطبيق. يرجى النقر على الزر التالي لفتح الموقع بمستعرض الويب لتغيير كلمة مرورك من هناك. خذ بالحسبان أن عليك إغلاق المستعرض بعد تغيير كلمة المرور لأنه لن تتم إعادة توجيهك إلى التطبيق.';
$string['core.login.changepasswordlogoutinstructions'] = 'إن كنت تفضل تبديل الموقع أو تسجيل الخروج، يرجى النقر على الزر الآتي:';
$string['core.login.changepasswordreconnectinstructions'] = 'أنقر الزر الآتي لإعادة الاتصال مع الموقع. (خذ بنظر الاعتبار أنك إن لم تنجح في تغيير كلمة مرورك، فستُعاد إلى الشاشة السابقة).';
$string['core.login.confirmdeletesite'] = 'هل أنت متأكد من رغبتك في حذف الموقع {{sitename}}؟';
$string['core.login.connect'] = 'دخول';
$string['core.login.connecttomoodle'] = 'بيانات الدخول';
$string['core.login.connecttomoodleapp'] = 'أنت تحاول الاتصال مع موقع عادي لمودل. يرجى تنزيل تطبيق مودل الرسمي للوصول إلى هذا الموقع.';
$string['core.login.connecttoworkplaceapp'] = 'أنت تحاول الاتصال مع نظام مودل لموقع العمل. يرجى تنزيل تطبيق مودل لموقع العمل للوصول إلى هذا الموقع.';
$string['core.login.contactyouradministrator'] = 'تواصل مع مشرف موقعك للمزيد من المساعدة.';
$string['core.login.contactyouradministratorissue'] = 'لطفاً، إلتمس من مشرف موقعك فحص المشكلة الآتية: {{$a}}';
$string['core.login.credentialsdescription'] = 'من فضلك قم بإدخال اسم المستخدم وكلمة المرور للدخول إلى';
$string['core.login.emailconfirmsentnoemail'] = '<p>رسالة بريد الكتروني ينبغي أن تكون قد أرسلت إلى عنوانك.</p><p>هي تتضمن معلومات بسيطة لإكمال عملية تسجيلك.</p><p>إن كنت لا تزال تواجه صعوبات، تواصل مع المشرف على موقعك.</p>';
$string['core.login.emailnotmatch'] = 'عنوانا البريد الالكتروني ليسا متطابقين';
$string['core.login.erroraccesscontrolalloworigin'] = 'لقد تم رفض طلب cross-origin الذي تحاول تنفيذه. يرجى التحقق من الأمر في https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = 'وقع خطأ عند حذف الموقع. لطفاً، حاول مجدداً.';
$string['core.login.errorexampleurl'] = 'عنوان الرابط https://campus.example.edu هو مجرد مثال، وليس عنواناً لموقع حقيقي. <strong>لطفاً، استعمل عنوان موقع مدرستك أو منظمتك.</strong>';
$string['core.login.errorqrnoscheme'] = 'عنوان الرابط هذا ليس عنوان صحيح لتسجيل الدخول.';
$string['core.login.errorupdatesite'] = 'وقع خطأ عند تحديث ترميز الموقع.';
$string['core.login.faqcannotconnectanswer'] = 'يرجى التواصل مع مشرف موقعك.';
$string['core.login.faqcannotconnectquestion'] = 'لقد أدخلت عنوان موقعي بشكل صحيح ولكنني لا زلت غير قادر على الاتصال.';
$string['core.login.faqcannotfindmysiteanswer'] = 'هل أدخلت الاسم بشكل صحيح؟ من الممكن أيضاً أن لا يكون موقعك مذكوراً في دليل المواقع العمومية لدينا. إذا كنت لا تزال غير قادر على العثور عليه، يرجى إدخال عنوان رابط موقعك بدلاً من اسمه.';
$string['core.login.faqcannotfindmysitequestion'] = 'لا يمكنني العثور على موقعي.';
$string['core.login.faqsetupsiteanswer'] = 'قم بزيارة {{$link}} لمعرفة الخيارات المختلفة عندك لإنشاء موقع مودل الخاص بك.';
$string['core.login.faqsetupsitelinktitle'] = 'إبدأ';
$string['core.login.faqsetupsitequestion'] = 'أريد إعداد موقع مودل الخاص بي.';
$string['core.login.faqtestappanswer'] = 'لاختبار التطبيق في موقع تجريبي لمودل، أدخل "معلم" أو "طالب" في حقل "موقعك" م انقر على زر "الاتصال بموقعك".';
$string['core.login.faqtestappquestion'] = 'أريد فقط إختبار التطبيق، ماذا يمكنني أن أفعل؟';
$string['core.login.faqwhatisurlanswer'] = '<p>لكل منظمة عنوانها أو رابطها الفريد لموقع مودل. للعثور على العنوان:</p><ol><li>إفتح مستعرض الويب واذهب إلى صفحة تسجيل الدخول في موقع مودل العائد لك.</li><li>في أعلى الصفحة، عند شريط العناوين ستجد عنوان رابط موقعك. مثلاً "campus.example.edu".<br>{{$image}}</li><li>إنسخ العنوان (لا تنسخ كلمة /login وما بعدها)، إلصقها في تطبيق مودل ثم انقر "الاتصال بموقعك"</li><li>يمكنك الآن تسجيل الدخول إلى موقعك باستعمال اسم المستخدم وكلمة المرور.</li></ol>';
$string['core.login.faqwhatisurlquestion'] = 'ما هو عنوان موقعي؟ كيف يمكنني العثور على عنوان رابط موقعي؟';
$string['core.login.faqwhereisqrcode'] = 'أين يمكنني العثور على ترميز QR؟';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>إن كانت منظمتك قد مكَّنته، ستجد ترميز QR في الموقع عند نهاية صفحة ملفك الشخصي.</p>{{$image}}';
$string['core.login.findyoursite'] = 'إبحث عن موقعك';
$string['core.login.helpmelogin'] = '<p>هناك آلاف عديدة من مواقع مودل حول العالم. هذا التطبيق يمكنه الاتصال مع مواقع مودل التي تم فيها حصرياً تمكين التطبيق من الوصول إليها.</p><p>إذا لم تكن قادراً على الاتصال بموقعك لمودل، فعليك التواصل مع المشرف على الموقع ومطالبته بقراءة <a href="http://docs.moodle.org/en/Mobile_app" target="_blank">http://docs.moodle.org/en/Mobile_app</a></p><p>لاختبار التطبيق في موقع مودل من النوع التجريبي لأي من <i>المعلم</i> أو <i>الطالب</i> في حقل <i>عنوان الموقع</i> والنقر على <b>زر الاتصال</b>.</p>';
$string['core.login.invalidaccount'] = 'يرجى مراجعة تفاصيل تسجيل الدخول الخاصة بك أو الطلب من مسؤول موقع الويب الخاص بك للتحقق من تكوين موقع.';
$string['core.login.invalidmoodleversion'] = '<p>إصدار مودل غير صالح. تطبيق مودل يدعم فقط أنظمة مودل {{$a}} وما بعدها.</p>
<p>يمكنك التواصل مع المشرف على نظامك ومطالبته بترقية النظام.</p>
<p>"مشرفو الموقع" هم الأشخاص الذين يديرون موقع مودل في مدرستك/جامعتك/شركتك أو منظمتك التعليمية. إذا لم تكن تعرف كيفية الاتصال بهم، يرجى الاتصال بمعلمك/مدربك.</p>';
$string['core.login.invalidsite'] = 'رابط عنوان الموقع غير صالح.';
$string['core.login.invalidtime'] = 'وقت غير صالح';
$string['core.login.invalidvaluemax'] = 'القيمة العظمى هي {{$a}}';
$string['core.login.invalidvaluemin'] = 'القيمة الصغرى هي {{$a}}';
$string['core.login.localmobileunexpectedresponse'] = 'عملية فحص المزايا الإضافية لتطبيق جوال مودل أعادت نتائج غير متوقعة. ستُمنح تفويض استعمال خدمة الجوال القياسية.';
$string['core.login.loggedoutssodescription'] = 'ينبغي عليك التفويض مرة أخرى. عليك دخول الموقع عبر نافذة المستعرض.';
$string['core.login.loginbutton'] = 'دخول';
$string['core.login.logininsiterequired'] = 'أنت بحاجة إلى تسجيل الدخول إلى الموقع عبر نافذة المتصفح.';
$string['core.login.mobileservicesnotenabled'] = 'الوصول إلى تطبيق الجوال غير مُمَكَّن في موقعك. يرجى التواصل مع المشرف على موقعك إن كنت تعتقد بضرورة تمكينه.';
$string['core.login.notloggedin'] = 'عليك تسجيل دخولك.';
$string['core.login.onboardingcreatemanagecourses'] = 'إنشاء وإدارة مساقاتك';
$string['core.login.onboardingenrolmanagestudents'] = 'ضم طلبتك وإدارتهم';
$string['core.login.onboardinggetstarted'] = 'إبدأ مع مودل';
$string['core.login.onboardingialreadyhaveasite'] = 'عندي مسبقاً موقع مودل';
$string['core.login.onboardingimalearner'] = 'أنا متعلم';
$string['core.login.onboardingimaneducator'] = 'أنا معلم';
$string['core.login.onboardingineedasite'] = 'أنا بحاجة إلى موقع مودل';
$string['core.login.onboardingprovidefeedback'] = 'توفير إفادة موقوتة';
$string['core.login.onboardingtoconnect'] = 'للاتصال مع تطبيق مودل ينبغي أن يكون لديك موقع لمودل';
$string['core.login.onboardingwelcome'] = 'مرحباً بك في تطبيق مودل!';
$string['core.login.or'] = 'أو';
$string['core.login.passwordrequired'] = 'كلمة المرور مطلوبة';
$string['core.login.recaptchachallengeimage'] = 'صورة اختبار reCAPTCHA';
$string['core.login.recaptchaexpired'] = 'انتهت مهلة التحقق. أجب على سؤال الأمان مجدداً.';
$string['core.login.recaptchaincorrect'] = 'إجابة سؤال الأمان غير صحيحة.';
$string['core.login.reconnect'] = 'إعادة الدخول';
$string['core.login.reconnectdescription'] = 'ترميز مصادقتك غير صالح أو منته الصلاحية. ينبغي عليك إعادة الاتصال مع الموقع.';
$string['core.login.reconnectssodescription'] = 'ترميز مصادقتك غير صالح أو منته الصلاحية. ينبغي عليك إعادة الاتصال مع الموقع. عليك تسجيل الدخول إلى الموقع عبر نافذة المستعرض.';
$string['core.login.searchby'] = 'البحث حسب:';
$string['core.login.selectsite'] = 'لطفاً، إختر موقعك';
$string['core.login.signupplugindisabled'] = '{{$a}} غير مُمَكَّن';
$string['core.login.signuprequiredfieldnotsupported'] = 'نموذج التسجيل يحتوي على حقل مخصص إجباري غير مدعوم في التطبيق. يرجى إنشاء حسابك باستعمال مستعرض الويب.';
$string['core.login.siteaddress'] = 'موقعك';
$string['core.login.sitebadgedescription'] = 'هناك {{count}} من الإشعارات غير المقروءة.';
$string['core.login.sitehasredirect'] = 'موقعك يحتوي على إعادة توجيه تستعمل بروتوكول HTTP واحدة على الأقل. يتعذر على التطبيق متابعة إعادات التوجيه، وقد تكون هذه المشكلة التي تمنع التطبيق من الاتصال مع موقعك.';
$string['core.login.siteinmaintenance'] = 'موقعك هو في وضع الصيانة';
$string['core.login.sitepolicynotagreederror'] = 'لم تتم الموافقة على سياسة الموقع';
$string['core.login.siteurl'] = 'رابط الموقع';
$string['core.login.siteurlrequired'] = 'رابط الموقع مطلوب.. مثل <i>http://www.yourmoodlesite.org</i>';
$string['core.login.stillcantconnect'] = 'أما زلت غير قادر على الاتصال؟';
$string['core.login.usernamerequired'] = 'اسم المستخدم مطلوب';
$string['core.login.visitchangepassword'] = 'هل ترغب في زيارة الموقع لتغيير كلمة المرور؟';
$string['core.login.webservicesnotenabled'] = 'موقع استضافتك قد لا يكون أجرى التمكين لخدمات الويب. يرجى التواصل مع مشرفك لطلب المساعدة.';
$string['core.login.youcanstillconnectwithcredentials'] = 'لا زال بإمكانك الاتصال مع الموقع عبر إدخال اسم المستخدم وكلمة المرور.';
$string['core.login.yourenteredsite'] = 'اتصل بموقعك';
$string['core.lostconnection'] = 'فقدنا الاتصال تحتاج إلى إعادة الاتصال. المميز الخاص بك هو الآن غير صالح';
$string['core.mainmenu.changesite'] = 'تغيير الموقع';
$string['core.mainmenu.website'] = 'الموقع';
$string['core.needhelp'] = 'أتحتاج إلى المساعدة؟';
$string['core.networkerroriframemsg'] = 'هذا المحتوى غير متاح بدون الاتصال. يرجى الاتصال بالإنترنت ثم المحاولة مجدداً.';
$string['core.networkerrormsg'] = 'لم يتم تمكين الشبكة أو أنها لا تعمل.';
$string['core.nooptionavailable'] = 'لا يتوفر أي خيار';
$string['core.nopasswordchangeforced'] = 'لا يمكنك المتابعة بدون تغيير كلمة مرورك.';
$string['core.nopermissionerror'] = 'عذراً، ولكنك لا تمتلك حالية الصلاحيات للقيام بذلك.';
$string['core.notapplicable'] = 'غير متاح';
$string['core.notsent'] = 'غير مرسَل';
$string['core.nummore'] = '{{$a}} أخرى';
$string['core.openfile'] = 'إفتح الملف';
$string['core.openfullimage'] = 'أنقر هنا لعرض الصورة بحجمها الكامل';
$string['core.openinbrowser'] = 'إفتحه بالمتصفح';
$string['core.openmodinbrowser'] = 'إفتح {{$a}} بالمتصفح';
$string['core.opensecurityquestion'] = 'فتح سؤال الأمان';
$string['core.opensettings'] = 'فتح الإعدادات';
$string['core.openwith'] = 'الفتح باستعمال...';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.play'] = 'تشغيل';
$string['core.pulltorefresh'] = 'اسحب للأسفل ليتم التحديث';
$string['core.qrscanner'] = 'ماسح QR';
$string['core.question.cannotdeterminestatus'] = 'يتعذر تقرير الحالة';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'موقعك لا يدعم إرفاق الملفات بالإجابات بعد.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'موقعك لا يدعم تحرير الملفات المضمنة بعد.';
$string['core.question.errorquestionnotsupported'] = 'نوع الأسئلة هذا غير مدعوم من قبل التطبيق: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'أنقر للتحديد ثم أنقر للإفلات.';
$string['core.question.questionmessage'] = 'السؤال {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'ستتم إعادة توجيهك إلى الموقع';
$string['core.removefiles'] = 'إزالة الملفات {{$a}}';
$string['core.requireduserdatamissing'] = 'يفتقر هذا المستخدم إلى بعض البيانات في ملفه الشخصي. يرجى إدخال البيانات في موقعك ثم المحاولة مجدداً.<br>{{$a}}';
$string['core.retry'] = 'إعادة المحاولة';
$string['core.scanqr'] = 'إمسح ترميز QR';
$string['core.scrollbackward'] = 'الانتقال للخلف';
$string['core.scrollforward'] = 'الانتقال للأمام';
$string['core.searching'] = 'يتم البحث';
$string['core.settings.about'] = 'حول';
$string['core.settings.appsettings'] = 'إعدادات التطبيق';
$string['core.settings.appversion'] = 'إصدار التطبيق';
$string['core.settings.cannotsyncloggedout'] = 'لا يمكن مزامنة هذا الموقع لأنك سجلت خروجك منه. يرجى المحاولة مجدداً عندما تكون داخلاً فيه.';
$string['core.settings.cannotsyncoffline'] = 'لا يمكن إجراء المزامنة بدون الاتصال.';
$string['core.settings.cannotsyncwithoutwifi'] = 'لا يمكن المزامنة لأن الإعدادات الحالية تسمح بالمزامنة فقط عند الاتصال بالشبكة اللاسلكية. يرجى الاتصال بالشبكة اللاسلكية.';
$string['core.settings.colorscheme'] = 'نظام الألوان';
$string['core.settings.colorscheme-dark'] = 'غامق';
$string['core.settings.colorscheme-light'] = 'فاتح';
$string['core.settings.colorscheme-system'] = 'إفتراضي النظام';
$string['core.settings.colorscheme-system-notice'] = 'الوضع الافتراضي للنظام سيعتمد على ما يقدمه جهازك من دعم.';
$string['core.settings.compilationinfo'] = 'معلومات التجميع';
$string['core.settings.copyinfo'] = 'إنسخ معلومات الجهاز إلى الحافظة';
$string['core.settings.cordovadevicemodel'] = 'طراز جهاز كوردوفا';
$string['core.settings.cordovadeviceosversion'] = 'إصدار نظام تشغيل جهاز كوردوفا';
$string['core.settings.cordovadeviceplatform'] = 'منصة جهاز كوردوفا';
$string['core.settings.cordovadeviceuuid'] = 'المُعرَّف العام الفريد لجهاز كوردوفا';
$string['core.settings.cordovaversion'] = 'إصدار كوردوفا';
$string['core.settings.debugdisplaydescription'] = 'عند تمكينه، بلاغات الأخطاء ستعرض المزيد من البيانات عنه إن أمكن.';
$string['core.settings.deletesitefiles'] = 'هل أنت متأكد أنك تريد حذف الملفات التي تم تنزيلها من هذا الموقع والبيانات المخبأة \'{{sitename}}\'؟ لن تكون قادراً على استعمال التطبيق في وضع عدم الاتصال بالإنترنت.';
$string['core.settings.deletesitefilestitle'] = 'حذف ملفات الموقع';
$string['core.settings.deviceinfo'] = 'معلومات الجهاز';
$string['core.settings.deviceos'] = 'نظام تشغيل الجهاز';
$string['core.settings.displayformat'] = 'تنسيق العرض';
$string['core.settings.enabledownloadsection'] = 'تفعيل تنزيل الأقسام';
$string['core.settings.enablefirebaseanalytics'] = 'تمكين تحليلات Firebase';
$string['core.settings.enablefirebaseanalyticsdescription'] = 'عند تمكينه، سيقوم التطبيق بجمع بيانات الاستعمال اللامشخصنة.';
$string['core.settings.enablerichtexteditor'] = 'تمكين محرر النصوص';
$string['core.settings.enablerichtexteditordescription'] = 'عند تمكينه، سيكون محرر النصوص متاحاً عند إدخال المحتوى.';
$string['core.settings.enablesyncwifi'] = 'السماح بالمزامنة فقط عند الاتصال بالشبكة اللاسلكية';
$string['core.settings.entriesincache'] = '{{$a}} من الإدخالات في الخبء';
$string['core.settings.errordeletesitefiles'] = 'خطأ عند حذف ملفات الموقع.';
$string['core.settings.errorsyncsite'] = 'خطأ عند مزامنة بيانات الموقع. يرجى التحقق من اتصالك بالإنترنت ثم حاول مجدداً.';
$string['core.settings.estimatedfreespace'] = 'المساحة الفارغة المُقدَّرة';
$string['core.settings.filesystemroot'] = 'جذر نظام الملفات';
$string['core.settings.fontsize'] = 'حجم النص';
$string['core.settings.forcedsetting'] = 'هذا الإعداد مفروض من قبل إعدادات موقعك.';
$string['core.settings.helpusimprove'] = 'ساعدنا في تحسين التطبيق';
$string['core.settings.ioscookies'] = 'السماح بالتعقب عبر المواقع';
$string['core.settings.ioscookiesdescription'] = 'قد يتطلب المحتوى المضمن من الموقع تمكين ملفات تعريف الارتباط عبر المواقع ليعمل. لتمكينها، يرجى الذهاب إلى إعدادات تطبيقات iOS، ثم تمكين \'السماح بالتعقب عبر المواقع\'.';
$string['core.settings.localnotifavailable'] = 'إشعارات محلية موجودة';
$string['core.settings.locationhref'] = 'عنوان رابط معاينة الويب';
$string['core.settings.navigatorlanguage'] = 'لغة التنقل';
$string['core.settings.navigatoruseragent'] = 'وكيل المستخدم للتنقل';
$string['core.settings.networkstatus'] = 'حالة الاتصال بالإنترنت';
$string['core.settings.opensourcelicenses'] = 'إفتح رُخَص المصدر';
$string['core.settings.privacypolicy'] = 'سياسة الخصوصية';
$string['core.settings.publisher'] = 'الناشر';
$string['core.settings.pushid'] = 'مُعرَّف دفق الإشعارات';
$string['core.settings.reportinbackground'] = 'أبلغ عن الأخطاء تلقائياً';
$string['core.settings.screen'] = 'معلومات الشاشة';
$string['core.settings.showdownloadoptions'] = 'إظهار خيارات التنزيل';
$string['core.settings.siteinfo'] = 'معلومات الموقع';
$string['core.settings.spaceusage'] = 'المساحة المستخدمة';
$string['core.settings.spaceusagehelp'] = 'حذف المعلومات المخزنة للموقع سيزيل كل بياناته التي بدون الاتصال. تلك البيانات هي ما يسمح لك باستعمال التطبيق بدون الاتصال بالإنترنت.';
$string['core.settings.synchronization'] = 'تزامن';
$string['core.settings.synchronizenow'] = 'زامن الأن';
$string['core.settings.synchronizenowhelp'] = 'عملية مزامنة الموقع سترسل كل التغييرات التي قيد الانتظار وكل النشاطات التي جرت بدون الاتصال والمخزونة في الجهاز مع مزامنة بعض البيانات الأخرى مثل الرسائل والإشعارات.';
$string['core.settings.syncsettings'] = 'إعدادات المزامنة';
$string['core.settings.wificonnection'] = 'إتصال الشبكة اللاسلكية';
$string['core.sharedfiles.chooseaccountstorefile'] = 'إختر حساباً لخزن الملف فيه.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'هناك ملف بنفس التسمية. هل ترغب باستبدال الملف الموجود أم إعادة تسميته إلى "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'ليست هناك مواقع مخزنة. لطفاً، أضف موقعاً قبل مشاركة الملفات مع التطبيق.';
$string['core.sharedfiles.nosharedfiles'] = 'لا توجد ملفات مشتركة مخزونة في هذا الموقع.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'ليست لديك ملفات لرفعها هنا. إن كنت ترغب برفع ملف من تطبيق آخر، حدد موضعه ثم انقر زر \'إفتحه في\'.';
$string['core.sharedfiles.rename'] = 'إعادة التسمية';
$string['core.sharedfiles.replace'] = 'استبدال';
$string['core.sharedfiles.sharedfiles'] = 'الملفات المشتركة';
$string['core.sharedfiles.successstorefile'] = 'تم خزن الملف بنجاح. إختر الملف الذي تريد رفعه إلى ملفاتك الخاصة أو استعماله في نشاط ما.';
$string['core.sizetb'] = '&nbsp;تيرا بايت';
$string['core.sorry'] = 'عذراً..';
$string['core.storingfiles'] = 'يجري خزن الملفات';
$string['core.tablet'] = 'الجهاز اللوحي';
$string['core.tag.errorareanotsupported'] = 'منطقة الوسوم هذه غير مدعومة من قبل التطبيق.';
$string['core.tag.tagareabadgedescription'] = 'هناك {{count}} من العناصر.';
$string['core.tag.warningareasnotsupported'] = 'بعض مناطق الوسوم غير معروضة لأنها غير مدعومة من قبل التطبيق.';
$string['core.thereisdatatosync'] = 'هناك {{$a}} بلا اتصال مطلوبة مزامنتها.';
$string['core.toggledelete'] = 'تبديل أزرار الحذف';
$string['core.tryagain'] = 'حاول مجدداً';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'عجباً';
$string['core.unexpectederror'] = 'خطأ غير متوقع. الرجاء الإغلاق وإعادة فتح التطبيق للمحاولة مرة أخرى';
$string['core.unicodenotsupported'] = 'بعض الرموز التعبيرية غير مدعومة في هذا الموقع. ستتم إزالة هذا النوع من الحروف عند إرسال الرسالة.';
$string['core.unicodenotsupportedcleanerror'] = 'تم العثور على نصوص فارغة عند تنظيف حروف يونيكود.';
$string['core.unknown'] = 'غير معروف';
$string['core.unzipping'] = 'يجري فك الضغط';
$string['core.updaterequired'] = 'يتطلب تحديث التطبيق';
$string['core.updaterequireddesc'] = 'لطفاً، قم بتحديث التطبيق إلى الإصدار {{$a}}';
$string['core.user.contact'] = 'جهة اتصال';
$string['core.user.detailsnotavailable'] = 'تفاصيل هذا المستخدم غير متاحة لك.';
$string['core.user.errorloaduser'] = 'خطأ عند تحميل المستخدم.';
$string['core.user.sendemail'] = 'البريد الالكتروني';
$string['core.user.userwithid'] = 'المستخدم ذو المُعرَّف {{id}}';
$string['core.viewcode'] = 'معاينة الترميز';
$string['core.vieweditor'] = 'معاينة المحرر';
$string['core.viewembeddedcontent'] = 'معاينة المحتوى المضمن';
$string['core.warningofflinedatadeleted'] = 'لقد تم حذف البيانات بدون الاتصال من {{component}} \'{{name}}\'. {{error}}';
$string['core.whoissiteadmin'] = '"مشرفو الموقع" هم الأشخاص الذين يديرون مودل في مدرستك، جامعتك، شركتك أو منظمتك التعليمية. إذا لم تكن تعرف كيفية الاتصال بهم، لطفاً، يرجى الاتصال بمعلمك/مدربك.';
$string['core.whoops'] = 'يا للعبوس!';
$string['core.whyisthishappening'] = 'لماذا يحدث هذا؟';
$string['core.wsfunctionnotavailable'] = 'وظيفة خدمة الويب غير متاحة.';
$string['core.youreoffline'] = 'أنت غير متصل';
$string['core.youreonline'] = 'عُدتَ متصلاً';
$string['pluginname'] = 'جُمل لغة جوال مودل';
