<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'nl', branch 'MOODLE_37_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Toegang geweigerd';
$string['accounts'] = 'Gebruikers';
$string['addcategory'] = 'Categorie toevoegen';
$string['additionalhtml'] = 'Bijkomende HTML';
$string['additionalhtml_desc'] = 'Met deze instelling kun je HTML opgeven die je op elke pagina wil laten zien. Je kunt HTML opgeven die tussen de HEAD-tag van de pagina gezet wordt, onmiddellijk nadat de BODY-tag geopend wordt of vlak voor de BODY-tag gesloten wordt. <br />Hierdoor kun je aangepaste headers en footers op elke pagina zetten of kun je heel gemakkelijk ondersteuning voor diensten zoals Google Analytics toevoegen, onafhankelijk van je gekozen thema.';
$string['additionalhtmlfooter'] = 'Voor BODY gesloten wordt';
$string['additionalhtmlfooter_desc'] = 'De inhoud die je hier plaatst zal op elke pagina gezet worden voor de BODY tag gesloten wordt.';
$string['additionalhtmlhead'] = 'In HEAD';
$string['additionalhtmlhead_desc'] = 'De inhoud hier zal onderaan in de HEAD-tag geplaatst worden voor elke pagina.';
$string['additionalhtml_heading'] = 'Bijkomende HTML om op elke pagina toe te voegen.';
$string['additionalhtmltopofbody'] = 'Wanneer de BODY-tag opent';
$string['additionalhtmltopofbody_desc'] = 'De inhoud die hier geplaatst wordt zal op elke pagina gezet worden, vlak na het openen van de BODY-tag';
$string['admincategory'] = 'Categorie: {$a}';
$string['adminseesall'] = 'Beheerders zien alles';
$string['adminseesallevents'] = 'Beheerders zien alle gebeurtenissen';
$string['adminseesownevents'] = 'Beheerders zien niet alle gebeurtenissen';
$string['advancedfeatures'] = 'Geavanceerd';
$string['agedigitalconsentverification'] = 'Verificatie van digitale meerderjarigheid';
$string['agedigitalconsentverification_desc'] = 'Maakt verificatie van het digitale meerderjarigheid mogelijk voordat de aanmeldingspagina voor gebruikers van zelfregistratie wordt weergegeven. Dit beschermt uw site tegen minderjarigen die zich aanmelden zonder toestemming van de ouder / voogd. <a target="_blank" href="{$a}"> Ondersteuningscontact </a> worden verstrekt aan minderjarigen voor verdere hulp.';
$string['ageofdigitalconsentmap'] = 'Digitale meerderjarigheid';
$string['ageofdigitalconsentmap_desc'] = 'De standaard leeftijd van digitale meerderjarigheid en de leeftijd in elk land waar dit afwijkt van de standaardinstelling, kunnen hier worden opgegeven. Voer elke leeftijd in op een nieuwe regel met de indeling: landcode, leeftijd (gescheiden door een komma). De standaardleeftijd wordt aangegeven met * in plaats van de landcode. Landcodes zijn zoals gespecificeerd in ISO 3166-2.';
$string['allcountrycodes'] = 'Alle landcodes';
$string['allowattachments'] = 'Bijlagen toestaan';
$string['allowbeforeblock'] = 'Lijst met toegelaten adressen zal eerst verwerkt worden';
$string['allowbeforeblockdesc'] = 'Standaard zal de lijst met geblokkeerde adressen eerst verwerkt worden. Als deze optie is ingeschakeld, dan zullen de toegelaten adressen verwerkt worden vóór de lijst met geblokkeerde adressen.';
$string['allowblockstodock'] = 'Sta toe dat blokken het zijpaneel gebruiken';
$string['allowcategorythemes'] = 'Categoriethema\'s toestaan';
$string['allowcohortthemes'] = 'Site-groepthema\'s toestaan';
$string['allowcoursethemes'] = 'Cursusthema\'s toestaan';
$string['allowedemaildomains'] = 'Toegestane e-maildomeinen';
$string['allowediplist'] = 'Lijst met toegelaten IP\'s';
$string['allowemailaddresses'] = 'E-maildomeinen toestaan';
$string['allowframembedding'] = 'Frame-embedding toestaan';
$string['allowframembedding_help'] = 'Indien ingeschakeld mag deze site ingebed worden in frames op een andere site. Dit wordt aangeraden wanneer je de "Publiceer als LTI"-aanmeldings-plugin gebruikt. In alle andere gevallen wordt het inschakelen van deze functie afgeraden om beveiligingsredenen.<br />Merk op dat voor de mobiele app deze instelling altijd genegeerd wordt en inbedden in frame altijd toegestaan is.';
$string['allowguestmymoodle'] = 'Gasttoegang tot Mijn startpagina toestaan';
$string['allowindexing'] = 'Indexering door zoekrobots toestaan';
$string['allowindexing_desc'] = 'Dit bepaalt of zoekrobots toegang hebben tot je site. "Overal" zal zoekrobots toestaan overal te zoeken, inclusief login en aanmeldingspagina\'s. Dit betekent dat sites met Aanmelden verplicht toch nog zullen geïndexeerd worden. Om het risico op spam dat voortvloeit uit het doorzoekbaar zijn van de aanmeldpagina te verminderen, kun je best "Overal, behalve login en aanmeldpagina\'s" aanduiden. "Nergens" zal zoekrobots zeggen om geen enkele pagina te indexeren. Merk op dat het enkel gaat om een tag in de header van de site. Het is aan de zoekrobots om deze tag te respecteren.';
$string['allowindexingeverywhere'] = 'Overal';
$string['allowindexingexceptlogin'] = 'Overal, behalve login en aanmeldpagina\'s';
$string['allowindexingnowhere'] = 'Nergens';
$string['allowobjectembed'] = 'EMBED en OBJECT tags toestaan';
$string['allowthemechangeonurl'] = 'Verandering van thema toestaan via de URL';
$string['allowuserblockhiding'] = 'Gebruikers mogen blokken verbergen';
$string['allowusermailcharset'] = 'Gebruikers mogen tekenset kiezen';
$string['allowuserswitchrolestheycantassign'] = 'Gebruikers zonder het recht om rollen toe te wijzen toelaten om de rol wijzigen schakelaar op de cursuspagina te gebruiken';
$string['allowuserthemes'] = 'Gebruikersthema\'s toestaan';
$string['alternativefullnameformat'] = 'Alternatieve format voor volledige naam';
$string['alternativefullnameformat_desc'] = 'Hier bepaal je hoe de namen van gebruikers worden getoond aan gebruikers die de mogelijkheid \'viewfullnames\' hebben (standaard voor gebruikers die manager, leraar of leraar zonder bewerken zijn). De mogelijke plaatshouders zijn dezelfde als die gebruikt kunnen worden voor de \'Volledige naam opmaak"-instelling.';
$string['always'] = 'Altijd';
$string['appearance'] = 'Uiterlijk';
$string['aspellpath'] = 'Pad naar aspell';
$string['authentication'] = 'Authenticatie';
$string['authpreventaccountcreation'] = 'Verhinder het aanmaken van een account bij het authenticeren';
$string['authpreventaccountcreation_help'] = 'Wanneer een gebruiker authenticeert, wordt er automatisch een gebruikersaccount aangemaakt als die nog niet bestaat. Als je een externe databank gebruikt, zoals LDAP, en je wil het aanmelden beperken tot gebruikers die al een account hebben, dan moet je deze optie inschakelen. Nieuwe accounts zullen dan manueel of via gebruikers uploaden moeten aangemaakt worden. Merk op dat deze instelling niet van toepassing is op MNET authenticatie. ';
$string['authsettings'] = 'Beheer authenticatie';
$string['autolang'] = 'Taal automatisch detecteren';
$string['autologinguests'] = 'Gasten automatisch inloggen';
$string['availablelicenses'] = 'Beschikbare licenties';
$string['availableto'] = 'Beschikbaar voor';
$string['backgroundcolour'] = 'Transparant';
$string['backups'] = 'Back-ups';
$string['backup_shortname'] = 'Gebruik de cursusnaam in de bestandsnaam van de back-up';
$string['backup_shortnamehelp'] = 'Gebruik de cursusnaam als deel van de bestandsnaam van de back-up.';
$string['badwordsconfig'] = 'Geef je lijst te censureren woorden in, gescheiden door komma\'s';
$string['badwordsdefault'] = 'Je aangepaste lijst is leeg. Er zal een standaardlijst uit het talenpakket gebruikt worden';
$string['badwordslist'] = 'Aangepaste lijst te censureren woorden';
$string['blockediplist'] = 'Lijst met geblokkeerde IP\'s';
$string['blockinstances'] = 'In gebruik';
$string['blockmultiple'] = 'Meer';
$string['blockprotect'] = 'Bescherm blok';
$string['blockprotect_help'] = 'Als je een bepaald type blok beschermt, dan zal niemand exemplaren van dit blok kunnen toevoegen of verwijderen. (Je kunt de bescherming natuurlijk opheffen als je exemplaren van dit blok moet bewerken.)

Dit wordt vooral gebruikt om het navigatie- en instellingenblok te beschermen. Die zijn erg moeilijk terug te zetten zijn indien ze per ongeluk verwijderd worden.';
$string['blocksettings'] = 'Beheer blokken';
$string['blockunprotect'] = 'Onbeschermd';
$string['bloglevel'] = 'Zichtbaarheid blogs';
$string['bookmarkadded'] = 'Bladwijzer toegevoegd';
$string['bookmarkalreadyexists'] = 'Bladwijzer bestaat al';
$string['bookmarkdeleted'] = 'Bladwijzer verwijderd';
$string['bookmarkthispage'] = 'Bladwijzer maken';
$string['cacheapplication'] = 'Toepassingscache';
$string['cacheapplicationhelp'] = 'Items in de cache worden door alle gebruikers gedeeld en vervallen na een welbepaalde ttl (time to live)';
$string['cachejs'] = 'Cache Javascript';
$string['cachejs_help'] = 'Het cachen en comprimeren van Javascript verbetert de performantie van het laden van pagina\'s aanzienlijk. Het wordt dan ook sterk aangeraden in te schakelen op productieservers. Ontwikkelaars kunnen deze instelling best uitschakelen.';
$string['cacherequest'] = 'Vraag cache';
$string['cacherequesthelp'] = 'Gebruikersspecifieke cache die vervalt wanneer de vraag afgerond is. Ontworpen om zones waar we statische opslag gebruiken te vervangen.';
$string['cachesession'] = 'Sessie cache';
$string['cachesessionhelp'] = 'Gebruikersspecifieke cache die vervalt wanneer de sessie van de gebruiker eindigt. Ontworpen om de sessiebelasting te verlagen';
$string['cachesettings'] = 'Cache instellingen';
$string['caching'] = 'Caching';
$string['calendarexportsalt'] = 'Kalender export beveiliging';
$string['calendarsettings'] = 'Kalender';
$string['calendartype'] = 'Kalendertype';
$string['calendartype_desc'] = 'Kies een kalendertype voor de hele site. Deze instelling kan overschreven worden in de cursusinstellingen of door gebruikers in hun profiel.';
$string['calendar_weekend'] = 'Weekend';
$string['cannotdeletemodfilter'] = 'Je kunt de filter \'{$a->filter}\' niet verwijderen omdat die deel uitmaakt van de module \'{$a->module}\'.';
$string['cannotuninstall'] = '{$a} kan niet verwijderd worden;';
$string['categoryemail'] = 'E-mail';
$string['cfgwwwrootslashwarning'] = 'Je hebt $CFG->wwwroot fout ingesteld in het bestand config.php. Je hebt een \'/\' aan het einde van je pad gezet. Verwijder dit.';
$string['cfgwwwrootwarning'] = 'Je hebt $CFG->wwwroot fout ingesteld in het bestand config.php. Het pad komt niet overeen met de URL die je bebruikt om toegang te krijgen tot deze pagina.';
$string['change'] = 'wijzig';
$string['checkboxno'] = 'Nee';
$string['checkboxyes'] = 'Ja';
$string['choosefiletoedit'] = 'Kies een te bewerken bestand uit bovenstaande lijst';
$string['cleanup'] = 'Opschonen';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'j';
$string['cliincorrectvalueerror'] = 'Fout, waarde "{$a->value}" voor de optie "{$a->option}" is niet juist';
$string['cliincorrectvalueretry'] = 'Foute waarde. Probeer opnieuw';
$string['clistatusdisabled'] = 'Status: uitgeschakeld';
$string['clistatusenabled'] = 'Status: ingeschakeld';
$string['clistatusenabledlater'] = 'status: CLI onderhoudsmodus zal ingeschakeld worden op {$a}';
$string['clitypevalue'] = 'type waarde';
$string['clitypevaluedefault'] = 'type waarde, druk op Enter om de standaardwaarde te gebruiken ({$a})';
$string['cliunknowoption'] = 'Onherkenbare opties:
{$a}
gebruik --help optie.';
$string['cliupgradedefault'] = 'Nieuwe instelling: {$a}';
$string['cliupgradedefaultheading'] = 'Nieuwe standaardwaarden instellen';
$string['cliupgradedefaultverbose'] = 'Nieuwe instelling: {$a->name}, Standaardwaarde: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Upgrade via commandovenster van {$a->oldversion} naar {$a->newversion} gelukt.';
$string['cliupgradenoneed'] = 'Geen upgrade nodig voor de geïnstalleerde versie {$a}. Toch bedankt voor het bezoek!';
$string['cliyesnoprompt'] = 'typ j (ja) of n (nee)';
$string['commentsperpage'] = 'Commentaren per pagina';
$string['commonactivitysettings'] = 'Algemene instellingen';
$string['commonfiltersettings'] = 'Algemene filterinstellingen';
$string['commonsettings'] = 'Algemene instellingen';
$string['componentinstalled'] = 'Onderdeel geïnstalleerd';
$string['computedfromlogs'] = 'Berekend uit logs sinds {$a}';
$string['condifmodeditdefaults'] = 'Er worden standaardwaarden gebruikt in het instellingenformulier wanneer je een nieuwe bron of activiteit maakt.';
$string['confeditorhidebuttons'] = 'Kies de knoppen die in de HTML-editor verborgen moeten zijn.';
$string['configallcountrycodes'] = 'Dit is de lijst van landen die op verschillende plaatsen geselecteerd zijn, bijvoorbeeld in een gebruikersprofiel. Als die leeg is (standaardinstelling) dan wordt de lijst in countries.php in het standaard Engelstalig taalpkakket gebruikt. Dat is de lijst van ISO-3166-1. Je kunt ook een kommagescheiden lijst met codes geven, bijvoorbeeld \'GB, FR, ES\'. Als je nieuwe , niet-standaardcodes hier toevoegt, dan moet je ze ook toevoegen in countries.php in \'en\' een in je taalpakket.';
$string['configallowassign'] = 'Je kunt mensen met de rollen aan de linkerkant toestaan om sommige rollen uit de kolom aan anderen te geven.';
$string['configallowattachments'] = 'Door deze instelling in te schakelen sta je toe dat bestanden als bijlage verstuurd kunnen worden met e-mails die gegenereerd worden door allerlei functies op deze site, zoals badges.';
$string['configallowblockstodock'] = 'Indien dit ingeschakeld is en ondersteund wordt door het gekozen thema, dan kunnen gebruikers blokken verplaatsen naar een speciaal paneel.';
$string['configallowcategorythemes'] = 'Als je dit inschakelt, dan kunnen thema\'s op categorieniveau gekozen worden. Die keuze wordt dan doorgetrokken naar alle onderliggende categorieën en cursussen, tenzij daar een eigen thema ingesteld is. WAARSCHUWING: het inschakelen van categoriethema\'s kan de performantie negatief beïnvloeden.';
$string['configallowcohortthemes'] = 'Als je dit inschakelt, dan kunnen thema\'s best ingesteld worden op site-groepniveau. Dit heeft gevolgen voor alle gebruikers met slechts één site-groep of meer dan één maar met hetzelfde thema.';
$string['configallowcoursethemes'] = 'Als je dit inschakelt, dan kan elke cursus zijn eigen thema instellen. De thema\'s van de cursussen zullen alle andere thema\'s overschrijven (site, gebruiker of sessiethema\'s)';
$string['configallowedemaildomains'] = 'Maak een lijst van alle e-maildomeinen die getoond mogen worden in het "van"-gedeelte van verzonden mail. De standaardinstelling "leeg" zal het niet-beantwoordenadres gebruiken voor alle uitgaande mail. Het gebruik van jokertekens is toegestaan, bv *.voorbeeld.com zal alle e-mails verstuurd vanaf een subdomein van voorbeeld.com toestaan, maar niet voorbeeld.com. Daarvoor is een aparte regel nodig.';
$string['configallowemailaddresses'] = 'Als je nieuwe e-mailadressen wil beperken tot bepaalde domeinen, zet ze dan hier in een lijst met een spatie als scheidingsteken. Alle andere domeinen zullen niet geaccepteerd worden. Om subdomeinen toe te staan, kun je de domeinnaam laten vooraf gaan door een ".".bv .onzeschool.be onzeschool.be.';
$string['configallowguestmymoodle'] = 'Indien ingeschakeld kunnen gasten "Mijn startpagina" bezoeken, anders worden gasten naar de site startpagina gestuurd.';
$string['configallowobjectembed'] = 'Als standaard beveiligingsmaatregel kunnen gewone gebruikers geen multimedia (zoals Flash) in teksten insluiten door gebruik te maken van EMBED en OBJECT tags in hun HTML (hoewel het veilig ingesloten kan worden met de mediaplugins filter). Als je deze tags toch wil laten gebruiken, dan kun je deze optie inschakelen';
$string['configallowoverride'] = 'Je kunt toestaan om mensen met rollen aan de linkerkant sommige rollen te overschrijven';
$string['configallowoverride2'] = 'Kies welke rol(len) overschreven kan worden door een andere rol in de linker kolom.<br /> Merk op dat deze instelling enkel geldt voor gebruikers waarvan de mogelijkheid  moodle/role:override of de mogelijkheid moodle/role:safeoverride toegelaten is.';
$string['configallowswitch'] = 'Selecteer naar welke rollen een gebruiker mag schakelen, gebaseerd op de rollen die hij al heeft. Bovenop de instellingen in deze tabel heeft een gebruiker ook de mogelijkheid moodle/role:switchroles nodig om zijn rol te kunnen omschaklen. <br />Merk op dat het alleen mogelijlk is te schakelen naar rollen die de moodle/course:view mogelijkheid hebben en die niet de mogelijkheid moodle/site:doanything hebben. Daarom kunnen sommige kolommen in deze tabel uitgeschakeld zijn.';
$string['configallowthemechangeonurl'] = 'Als je deze instelling inschakelt, dan kan het thema gewijzigd worden door het volgende toe te voegen: <br /> ofwel ?theme=themename aan gelijk welke Moodle URL (vb: mymoodlesite.com/?theme=afterburner ) of <br />&theme=themename aan elke interne  Moodle URL (vb: mymoodlesite.com/course/view.php?id=2&theme=afterburner ).';
$string['configallowuserblockhiding'] = 'Wil je gebruikers toelaten om blokken te verbergen of te tonen? Deze functie gebruikt Javascript en cookies om de status van elk samenklapbaar blok te bewaren en heeft enkel gevolg voor het beeld van de individuele gebruiker.';
$string['configallowusermailcharset'] = 'Door dit in te schakelen, kan elke gebruiker van de site zijn eigen tekenset kiezen voor berichten.';
$string['configallowuserswitchrolestheycantassign'] = 'Standaard is moodle/role:assign vereist om gebruikers toe te laten de schakelaar om van rol te wisselen te gebruiken. Deze instelling inschakelen verwijdert deze vereiste, waardoor de mogelijke rollen in het rolmenu alleen nog bepaald worden door de instellingen in de "Toewijzen van rollen toestaan"-tabel.
Het is aangewezen in dde "Toewijzen van rollen toestaan"-tabel gebruikers niet het recht te geven rollen toe te wijzen met meer mogelijkheden dan hun eigen rol.';
$string['configallowuserthemes'] = 'Als je dit inschakelt, dan kunnen gebruikers hun eigen thema kiezen. Gebruikersthema\'s gaan boven sitethema\'s (maar niet boven cursusthema\'s)';
$string['configallowview'] = 'Selecteer de rollen die een gebruiker te zien krijgt, op kan filteren enz., gebaseerd op de rollen die ze al hebben.';
$string['configallusersaresitestudents'] = 'Moeten ALLE gebruikers als leerlingen beschouwd worden voor activiteiten op de startpagina van de site? Als je hier "Ja" kiest, dan zullen alle bevestigde accounts hier als leerling kunnen meedoen aan alle activiteiten. Als je hier "Nee" kiest, dan zullen alleen gebruikers die minstens van één cursus lid zijn kunnen meedoen aan die startpagina-activiteiten.';
$string['configauthenticationplugins'] = 'Kies de authenticatieplugins die je wenst te gebruiken en rangschik ze in volgorde, zodat diegene met het meeste kans op succes heeft, bovenaan staat.';
$string['configautolang'] = 'Detecteer de standaardtaal uit de browserinstelling. Indien uitgeschakeld, wordt de standaardtaal van de site gebruikt.';
$string['configautologinguests'] = 'Moeten bezoekers automatisch als gast aangemeld worden als ze cursussen met toegangsrecht voor gasten binnengaan ?';
$string['configbloglevel'] = 'Met deze instelling kun je het niveau beperken waarop gebruikers blogs op deze site kunnen zien. Merk op dat ze een maximum zetten voor wie KIJKT, niet voor wie berichten post of de mogelijke types berichten die gepost kunnen worden. Blogs kunnen ook uitgeschakeld worden als je ze niet wil.';
$string['configcalendarcustomexport'] = 'Aangepast datumbereik inschakelen voor het exporteren van de kalender';
$string['configcalendarexportsalt'] = 'Deze willekeurige tekst wordt gebruikt om de beveiliging van authenticatie-tokens te verbeteren. Deze tokens worden gebruikt bij het exporteren van kalenders. Alle huidige tokens worden ongeldig als je deze tekst wijzigt.';
$string['configcookiehttponly'] = 'Schakelt nieuwe PHP 5.2.0-mogelijkheid in - browsers moeten cookies alleen met echte http-requests verzenden, cookies zouden niet toegankelijk mogen zijn voor script-talen. Dit wordt niet in alle browsers ondersteund en het is mogelijk dat het nog niet compatibel is met alle huidige code. Het helpt sommige types van XSS-aanvallen te voorkomen.';
$string['configcookiesecure'] = 'Als de server alleen https-verbindingen aanvaardt, dan is het aangeraden om het versturen van secure cookies in te schakelen. Als dit ingeschakeld is, zorg er dan voor dat de webserver geen http:// toelaat of zet een permanente redirectie op naar een https://-adres en stuur bij voorkeur HST-headers. Wanneer het <em>wwwroot</em> niet begint met https://, dan wordt deze instelling automatisch uitgeschakeld.';
$string['configcountry'] = 'Als je hier een land invult, wordt dit land als standaard geselecteerd bij nieuwe gebruikersaccounts. Laat dit veld gewoon leeg om gebruikers te dwingen een land te kiezen.';
$string['configcoursegraceperiodafter'] = 'Classificeer eerdere cursussen als in uitvoering voor dit aantal dagen na de einddatum van de cursus.';
$string['configcoursegraceperiodbefore'] = 'Classificeer toekomstige cursussen als in uitvoering voor dit aantal  dagen voorafgaand aan de startdatum van de cursus.';
$string['configcourseoverviewfilesext'] = 'Een kommagescheiden lijst van toegestane bestandsextenties voor cursusafbeeldingen.';
$string['configcourseoverviewfileslimit'] = 'Het maximaal aantal bestanden dat naast een cursussamenvatting getoond kan worden op de pagina met de cursussenlijst. Het eerste afbeeldingsbestand dat toegevoegd wordt, wordt gebruikt als cursusafbeelding in het cursusoverzicht op de startpagina van de gebruiker. Bijkomende bestanden worden enkel getoond op de pagina met de cursussenlijst.';
$string['configcourserequestnotify'] = 'Geef de gebruikersnaam van de gebruiker die een melding moeten krijgen wanneer er een nieuwe cursus aangevraagd wordt.';
$string['configcourserequestnotify2'] = 'Gebruikers die een melding zullen krijgen als er een nieuwe cursus wordt aangevraagd. Alleen gebruikers die een cursus kunnen goedkeuren, worden hier getoond.';
$string['configcoursesperpage'] = 'Geef het maximale aantal te tonen cursussen per pagina in een cursuslijst';
$string['configcourseswithsummarieslimit'] = 'Het maximale aantal te tonen cursussen in een cursuslijst met samenvattingen voor terug te vallen op een eenvoudigere lijst.';
$string['configcronclionly'] = 'Cron via het web laten lopen kan beveiligde informatie vrijgeven over gebruikers van je site aan anonieme gebruikers. Je kunt cron best alleen vanaf de command prompt laten starten of beveiligen met een wachtwoord.';
$string['configcronremotepassword'] = 'Dit betekent dat het script cron.php niet vanuit een webbrowser gestart kan worden zonder het wachtwoord te geven via volgende URL: <pre>
https://site.voorbeeld.com/admin/cron.php?password=opensesame
</pre> Als dit leeg gelaten wordt, is er geen wachtwoord nodig.';
$string['configcurlcache'] = 'Levenduur van cURL-cache in sekonden.';
$string['configcustommenuitems'] = 'Je kunt hier een aangepast menu laten tonen door thema\'s. Elke lijn bestaat uit wat menu tekst, een URL (optioneel), een tooltip titel (optioneel) en een taalcode of komma-gescheiden lijst met codes (optioneel, om de lijn aan gebruikers van een bepaalde taal te tonen), gescheiden door pipe tekens ( | ). Je kunt de structuur opgeven met liggende streepjes en scheidingen kunnen gemaakt worden door een lijn met één of meer #-tekens in te voegen waar je dit wenst. Bijvoorbeeld:
<pre>
Moodle community|https://moodle.org
-Moodle free support|https://moodle.org/support
-Moodle Docs|https://docs.moodle.org|Moodle Docs
-German Moodle Docs|https://docs.moodle.org/de|Documentation in German|de
-###
-Moodle development|https://moodle.org/development
Moodle.com|https://moodle.com/
</pre>';
$string['configcustomusermenuitems'] = 'Je kunt de inhoud van het gebruikersmenu configureren (uitgezonderd de link om af te melden, die wordt automatisch toegevoegd). Elke lijn wordt gescheiden door een verticale lijn of pipe (|)  en bestaat uit 1) een string in het formaat "taalstringnaam, componentnaam" of als platte tekst, 2) een URL en 3) een icoontje als een pix-icoon (in de pix-map met als structuur  [subfoldername]/[iconname], vb. i/publish) of als URL.
Je kunt scheidingen maken waar je wil door een regel met één of meer #-tekens in te voegen.';
$string['configdbsessions'] = 'Als dit ingeschakeld is, dan zal de databank gebruikt worden om informatie over de sessies te bewaren. Merk op dat het wijzigen van deze instelling alle gebruikers zal afmelden (jij inbegrepen).
Indien je MySQL gebruikt, zorg er dan voor dat \'max_allowed_packet\' in my.cnf (of my.ini) minstens 4M is. Andere sessiedrivers kunnen juist geconfigureerd worden in config.php - raadpleeg config-dist.php voor meer informatie. Deze optie verdwijnt als je een sessiedriver opgeeft in je config.php-bestand.';
$string['configdebug'] = 'Als je dit aan zet zullen er meer PHP-fouten op het scherm worden weergegeven. Dit is alleen maar handig voor ontwikkelaars van de applicatie.';
$string['configdebugdisplay'] = 'Als je dit inschakelt, dan gaat de foutmelding naar de HTML pagina. Dit is handig, maar het breekt XHTML, JS, Cookies en HTTP-headers in het algemeen. Als je dit uitschakelt, dan zal de output naar je serverlogs weggeschreven worden, wat een betere foutopsporing mogelijk maakt. De PHP-instelling error_log controleert naar welk logbestand dit gaat.';
$string['configdebugpageinfo'] = 'Schakel in als je paginainformatie onderaan de pagina wil zien';
$string['configdebugsmtp'] = 'Schakel het tonen van foutopsporingsinformatie tijdens het sturen van e-mailberichten naar de SMTP-server. Om dit te doen werken moeten \'Foutopsporingsmeldingen\' op \'ontwikkelaar\' gezet worden.';
$string['configdebugvalidators'] = 'Schakel dit in als je links naar externe paginavalidators wil zien onderaan elke pagina. Het is mogelijk dat je een nieuwe gebruikersaccount moet maken <em>w3cvalidator</em>, en gasttoegang moet inschakelen. Deze wijzigingen kunnen ongeauthenticeerde toegang tot de server mogelijk maken, schakel dit niet in op productiesites!';
$string['configdefaulthomepage'] = 'Dit bepaalt de eerste link in de navigatie voor aangemelde gebruikers';
$string['configdefaultrequestcategory'] = 'Cursussen die door gebruikers aangevraagd worden zullen automatisch in deze categorie gezet worden.';
$string['configdefaultrequestedcategory'] = 'Standaardcategorie om aangevraagde cursussen te plaatsen nadat ze goedgekeurd zijn.';
$string['configdefaultuserroleid'] = 'Alle aangemelde gebruikers zullen de rechten krijgen van de rol die je hier op siteniveau opgeeft. Deze rol is bijkomend bij andere rollen die je misschien al gegeven hebt. De standaardrol is de rol van geauthenticeerde gebruiker.
Merk op dat dit geen conflict geeft met andere rollen die je gebruikers al hebben - het zorgt er alleen voor dat alle gebruikers mogelijkheden krijgen op site-niveau, die niet kunnen toegewezen worden op cursusniveau  (vb het posten van blogs, beheren van eigen kalender enz.)';
$string['configdeleteincompleteusers'] = 'Na deze periode zal elke account zonder voornaam, achternaam of e-mailadres verwijderd worden.';
$string['configdeleteunconfirmed'] = 'Voor sommige authenticatiemethodes, zoals e-mailgebaseerde zelfregistratie, is dit de periode waarbinnen gebruikers moeten reageren op de bevestigingsmail voor de nieuwe account. Na deze periode zullen oude, niet-bevestigde accounts verwijderd worden.';
$string['configdenyemailaddresses'] = 'Om e-mailadressen van bepaalde domeinen te weigeren, kun je ze hier op dezelfde manier opnemen. Alle andere domeinen zullen aanvaard worden. Om subdomeinen te weigeren, geef je de domeinnaam, voorafgegaan door een \'.\' bv <strong>hotmail.com yahoo.co.uk; .live.com</strong>';
$string['configdisableuserimages'] = 'Schakel het wijzigen van het profielprentje uit voor alle gebruikers.';
$string['configdisplayloginfailures'] = 'Dit zal informatie aan gebruikers tonen over mislukte aanmeldingen.';
$string['configdndallowtextandlinks'] = 'Slepen en neerzetten van teksten en links inschakelen of uitschakelen, samen met het slepen en neerzetten van bestanden. Merk op dat het slepen van tekst in Firefox of tussen verschillende browsers onbetrouwbaar is en kan resulteren in geen of verminkte gegevens die geuploaded worden.';
$string['configdoclang'] = 'Deze taal zal gebruikt worden voor links naar documentatiepagina\'s.';
$string['configdocroot'] = 'Bepaalt het pad naar Moodle Docs voor contextgevoelige hulp via de link \'MoodleDocs voor deze pagina\' onderaan elke pagina. Als dit veld leeg gelaten wordt, dan wordt er geen link getoond.';
$string['configdoctonewwindow'] = 'Als je dit aanzet zullen links naar Moodle Docs geopend worden in een nieuw venster.';
$string['configeditordictionary'] = 'Deze waarde zal gebruikt worden als aspell geen woordenlijst heeft voor de eigen taal van een gebruiker.';
$string['configeditorfontlist'] = 'Kies de lettertypes die in het dropdownmenu van de editor zouden moeten verschijnen';
$string['configemailchangeconfirmation'] = 'Als een gebruiker zijn e-mailadres wil wijzigen, moet die dat dan bevestigen via een bevestigingsmail? Deze optie inschakelen is nuttig op sites waar gebruikers zelf accounts kunnen aanmaken en wijzigen en waarbij die accounts gebruikt kunnen worden voor het versturen van spam.';
$string['configemailfromvia'] = 'Voeg informatie toe in het "van"-gedeelte van een uitgaande e-mail. Deze informeert de ontvanger van waaruit deze e-mail vandaan kwam en helpt ook tegen ontvangers die per ongeluk antwoorden op een  niet-beantwoorden e-mailadres.';
$string['configemailsubjectprefix'] = 'Alle uitgaande e-mail is een tekst die moet worden voorafgegaan aan de onderwerpregel.';
$string['configenableactivitychooser'] = 'De activiteitskiezer is een dialoogvenster met een korte beschrijving van elke activiteit en bron. Indien uitgeschakeld worden afzonderlijke bron- en activiteitsrolmenu\'s  getoond.';
$string['configenableblogs'] = 'Hiermee geef je alle gebruikers op de site hun eigen blog.';
$string['configenablecalendarexport'] = 'Exporteren of abonneren op kalenders inschakelen';
$string['configenablecomments'] = 'Commentaren inschakelen';
$string['configenablecourserequests'] = 'Hiermee kan elke gebruiker aanvragen om een nieuwe cursus aan te maken.';
$string['configenabledevicedetection'] = 'Maakt het detecteren van telefoons, smartphones, tabletcomputers of andere standaardapparatuur (desktops, laptops enz) mogelijk voor het toepassen van thema\'s en andere functies.';
$string['configenablemobilewebservice'] = 'Schakel de mobiele service in voor de officiële Moodle app of voor andere toepassingen die dat nodig hebben. Lees voor meer informatie {$a}';
$string['configenablerssfeeds'] = 'Met deze instelling maak je RSS-feeds mogelijk voor functies over de hele site, zoals blogs, databanken, forums en woordenlijsten. Merk op dat RSS ook moet ingeschakeld worden op het niveau van de activiteitsmodule.';
$string['configenablerssfeedsdisabled'] = 'Dit is niet beschikbaar omdat RSS voor heel de site is uitgeschakeld. Om RSS in te schakelen ga je naar Configureer variabelen onder Beheer Configuratie.';
$string['configenablerssfeedsdisabled2'] = 'RSS-feeds zijn uitgeschakeld op site-niveau. Je moet ze inschakelen bij geavanceerd in het site-beheer.';
$string['configenablesafebrowserintegration'] = 'Hiermee voeg je de keuze "Safe exam browser vereist\' toe aan het browserbeveiligingsveld op de instellingenpagina van een test. Kijk op http://www.safeexambrowser.org/ voor meer informatie.';
$string['configenablestats'] = 'Als je hier \'ja\' kiest, zal de cron van Moodle de logbestanden verwerken en statistieken aanmaken. Afhankelijk van de hoeveelheid verkeer op je site, kan dit wel even duren. Als je dit inschakelt kun je interessante grafieken en statistieken zien over elke cursus of over de hele site.';
$string['configenabletrusttext'] = 'Moodle zal altijd tekst, afkomstig van gebruikers, grondig opschonen. Zo worden gevaarlijke scripts, media enz., die een beveiligingsrisico kunnen zijn, verwijderd. Het vertrouwde inhoudsysteem is een manier om het voor bepaalde gebruikers toch mogelijk te maken om geavanceerde functies in hun cursusmateriaal te gebruiken. Om dit systeem in te schakelen, moet je eerst hier de instelling inschakelen en dan het Vertrouwde Inhoud-recht toekennen aan een specifieke Moodle rol. Teksten die gemaakt of geüpload worden door gebruikers met die rol, zullen als vertrouwd gemarkeerd worden en zullen niet opgeschoond worden voor ze getoond worden.';
$string['configenablewebservices'] = 'Webservices maken het mogelijk dat andere systemen aanmelden in deze Moodle-installatie en acties uitvoeren. Voor extra veiligheid moet dit uitgeschakeld worden tenzij je het echt gebruikt.';
$string['configenablewsdocumentation'] = 'Schakel het automatisch genereren van web services documentatie in. Een gebruiker kan toegang krijgen tot zijn eigen documentatie op zijn beveiligingssleutelpagina {$a}. Dit toont enkel de documentatie voor de ingeschakelde protocols.';
$string['configerrorlevel'] = 'Kies hoeveel PHP-waarschuwingen je wilt dat Moodle laat zien. \'Normaal\' is meestal de beste keuze.';
$string['configexportlookahead'] = 'Aantal dagen vooruit kijken tijdens export';
$string['configexportlookback'] = 'Aantal dagen terug kijken tijdens export';
$string['configextendedusernamechars'] = 'Schakel deze optie in om het mogelijk te maken dat gelijk welke karakters in de gebruikersnaam gebruikt kunnen worden (merk op dat deze instelling geen invloed heeft op de voornaam of achternaam). De standaardinstelling is "false", wat ervoor zorgt dat alleen alfanumerieke kleine tekens gebruikt kunnen worden en underscore (_), liggend streepje (-), punt (.) en het at-symbool (@).';
$string['configextramemorylimit'] = 'Sommige scripts, zoals zoeken, back-up en terugzetten en crom hebben meer geheugen nodig. Zet dit hoger voor grote sites.';
$string['configfilterall'] = 'Filter alle strings: koppen, titels, navigatiebalk enz. inbegrepen. Dit is meestal slechts nuttig wanneer je de multilang-filter gebruikt. Anders zal het alleen maar een extra belasting op je server veroorzaken zonder meerwaarde.';
$string['configfiltermatchoneperpage'] = 'Automatische link-filters zullen slechts één link per pagina genereren, namelijk de eerste overeenkomst die gevonden wordt op de hele pagina. Alle andere overeenkomsten worden genegeerd.';
$string['configfiltermatchonepertext'] = 'Automatische link-filters zullen slechts één link voor het eerste overeenkomstige  tekstonderdeel op de pagina genereren. Alle andere overeenkomsten worden genegeerd. Deze instelling wordt genegeerd als de instelling één per pagina ingeschakeld is.';
$string['configfilteruploadedfiles'] = 'Verwerk alle geüploade HTML- en tekstbestanden met de gekozen filters voor ze getoond worden, enkel geüploade HTML-bestanden of niets.';
$string['configforcelogin'] = 'Standaard kunnen de startpagina van de site en de lijst van cursussen (maar niet de cursussen zelf) bekeken worden door iedereen, zonder zich aan te melden op de site. Als je wil afdwingen dat er moet aangemeld worden voor er maar iets van de site te zien is, dan kan dat door deze instelling aan te zetten.';
$string['configforceloginforprofiles'] = 'Schakel deze optie in om gebruikers te dwingen zich aan te melden met een echte (niet gast-) account voor ze de pagina\'s met gebruikersprofielen kunnen zien. Standaard staat deze instelling ingeschakeld.
Als je deze optie uitschakeld, dan zou het kunnen dat sommige gebruikers advertenties (spam) of andere ongepaste inhoud in hun profiel zetten, dat dan zichtbaar is voor de hele wereld.';
$string['configfrontpage'] = 'De hierboven gekozen items zullen op de startpagina van de site getoond worden.';
$string['configfrontpagecourselimit'] = 'Maximaal aantal cursussen';
$string['configfrontpagecourselimithelp'] = 'Het maximaal aantal te tonen cursussen op de startpagina in de cursussenlijst.';
$string['configfrontpageloggedin'] = 'De hierboven gekozen items zullen op de startpagina van de site getoond worden, wanneer een gebruiker aangemeld is.';
$string['configfullnamedisplay'] = 'Deze instelling bepaalt hoe de volledige namen getoond worden. De standaardwaarde, "Taal", laat het over aan de string "fullnamedisplay" in het huidige taalpakket. Sommige talen hebben verschillende conventies voor het tonen van namen.

Voor de meeste eentalige sites is de beste instelling de standaardinstelling, nl "voornaam + achternaam", maar je kunt ervoor kiezen de achternaam te verbergen. Er kunnen plaatshouders gebruikt worden, zoals firstname, lastname, firstnamephonetic, lastnamephonetic, middlename en alternatename.';
$string['configgeoipfile'] = 'Plaats van het GeoLite2 City binair data bestand. Dit bestand is geen deel van de Moodle-distributie en moet apart verkregen worden van  <a href="https://www.maxmind.com/">MaxMind</a>. Je kunt ofwel een commerciële versie bekomen of de gratis versie gebruiken. Je zult moeten registreren om het City databankbestand te kunnen downloaden, wat je kan doen op <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/" >https://dev.maxmind.com/geoip/geoip2/geolite2/</a>. Eens je geregistreerd hebt en heb bestand gedownload hebt, kun je het unzippen in de map "{$a}" op je server.';
$string['configgetremoteaddrconf'] = 'Als je server zich achter een reverse proxy bevindt, dan kun je deze instelling gebruiken om te specifiëren welke HTTP headers vertrouwd kunnen worden dat ze het IP-adres van de client bevatten. De headers worden in volgorde gelezen. De eerste die gevonden wordt, word gebruikt.';
$string['configgradebookroles'] = 'Deze instelling bepaalt wie er in de cijferlijsten verschijnt. Gebruikers moeten minstens één van deze rollen hebben om in de cijferlijsten voor die cursus te verschijnen.';
$string['configgradeexport'] = 'Kies welke formaten je wil om je punten te exporteren. De gekozen plugins worden dan ingesteld en gebruiken een "laatst geëxporteerd veld" voor elk cijfer. Dit kan er bijvoorbeeld voor zorgen dat geëxporteerde records geïdentificeerd worden als nieuw of aangepast. Als je niet zeker bent van deze instelling, laat dan alles staan zonder vinkje.';
$string['confighiddenuserfields'] = 'Kies welke velden van de gebruikersinformatie je wil verbergen voor andere gebruikers dan leraren en beheerders. Hierdoor kun je de privacy van je gebruikers vergroten. Gebruik de Ctrl-toets om meerdere velden te selecteren.';
$string['configidnumber'] = 'Deze optie specificeert of (a) de gebruikers helemaal niet worden gevraagd om een leerlingnummer, (b) gebruikers wel worden gevraagd om een leerlingnummer maar dit leeg kunnen laten of (c) gebruikers worden gevraagd om het leerlingnummer en dit niet leeg kunnen laten. Als het leerlingnummer wordt opgegeven dan wordt dit getoond in het profiel.';
$string['configintro'] = 'Op deze pagina kun je een aantal variabelen voor de configuratie instellen die Moodle kunnen helpen om goed werken op jouw server. Maak je er niet teveel zorgen over, de standaardwaarden werken meestal prima en je kunt later altijd nog op deze pagina terugkomen en deze instellingen opnieuw wijzigen.';
$string['configintroadmin'] = 'Op deze pagina configureer je de account van de beheerder die de volledige controle over de site zal hebben. Geef de beheerder een veilige gebruikersnaam en wachtwoord en een geldig e-mailadres. Je kunt later beheerderaccounts bijmaken.';
$string['configintrosite'] = 'Op deze pagina configureer je de startpagina en de naam van deze nieuwe site. Je kunt deze instellingen later bijwerken door de beheermenu\'s te gebruiken.';
$string['configiplookup'] = 'Wanneer je op een IP-adres klikt (zoals 33.54.123.43), bijvoorbeeld in de logs, dan krijg je  een kaart te zien met een goede gok van waar dat IP-adres gelegen is. Er zijn verschillende plugins waaruit je kunt kiezen, elk met zijn voor-en nadelen.';
$string['configkeeptagnamecase'] = 'Schakel in om hoofdletters in tag-namen te behouden zoals ze door de gebruikers bij aanmaken ingegeven zijn.';
$string['configlang'] = 'Kies een standaardtaal voor de gehele site. Gebruikers kunnen deze instelling later eventueel wijzigen in hun profiel.';
$string['configlanglist'] = 'Indien je dit vak leeg laat, zullen alle talen die geïnstalleerd zijn op je site getoond worden in het taal selectiemenu. Je kunt het keuzemenu voor talen inkorten door een lijst in te geven met de gewenste talen, gescheiden door komma\'s. Bijvoorbeeld:en,es_es,fr,it,nl.
Wat ook kan is om een andere naam te tonen dan de naam van het taalpakket. Je doet dit door volgende opmaak te gebruiken: naamcode|getoonde taalnaam. Bijvoorbeeld: en_kids|English,de_kids|Deutsch.';
$string['configlangmenu'] = 'Kies of je de gebruiker een taalkeuze wil laten maken op de startpagina, de aanmeldpagina enz. Dit neemt de mogelijkheid niet weg dat de gebruiker een taal kan kiezen in zijn eigen profiel.';
$string['configlangstringcache'] = 'Maakt een cache van alle taalstrings in gecompileerde bestanden in de datamap. Als je Moodle vertaalt of je wijzigt strings in de broncode van Moodle, dan wil je dit waarschijnlijk uitschakelen. Laat het anders aanstaan voor performantie.';
$string['configlatinexcelexport'] = 'Kies de encoding voor Excel export';
$string['configlocale'] = 'Kies een sitebrede \'locale\' - dit zal de opmaak en taal van data van alle gebruikte taalpakketten beïnvloeden (de namen van de dagen in de kalender worden niet gewijzigd). Deze \'locale\' moet al geïnstalleerd zijn op je besturingssysteem. (Bijvoorbeeld en_US.UTF8 of es_ES.UTF8). Voor de meeste installaties MOET DIT VELD LEEG GELATEN WORDEN.';
$string['configloginhttps'] = 'Als je dit inschakelt gebruikt Moodle een veilige https-verbinding voor de inlogpagina (zodat de aanmelding veilig gebeurt), en keert dan terug naar de gewone http-URL voor de snelheid. OPGELET: deze instelling VEREIST dat https ingeschakeld is op de webserver - indien dat niet het geval is KUN JE JEZELF UITSLUITEN VAN TOEGANG TOT JE SITE.';
$string['configloglifetime'] = 'Dit specificeert de lengte van de periode waarin logs van gebruikersactiviteit worden bewaard. Logs die ouder zijn worden automatisch verwijderd. Het is verstandig om de logs zo lang mogelijk te bewaren, je kunt ze immers altijd nog nodig hebben. Maar als je een zeer drukke server hebt en prestatieproblemen ondervindt, kun je de periode misschien beter minder lang maken. Waardes lager dan 30 worden niet aangeraden omdat statistieken dan niet correct meer werken.';
$string['configlookahead'] = 'Aantal dagen vooruit kijken';
$string['configmailnewline'] = 'Karakters voor een nieuwe regel, gebruikt in e-mailberichten. CRLF is vereist volgens RFC 822bis. Sommige mailservers converteren automatisch LF naar CRLF, andere mailservers doen een foute conversie van CRLF naar CRCRLF. Nog andere servers verwerpen e-mails die alleen maar LF als regeleinde hebben (qmail bijvoorbeeld). Probeer deze instelling te wijzigen als je problemen hebt met onverstuurde e-mails of met dubbele nieuwe regels.';
$string['configmaxbytes'] = 'Dit bepaalt de maximale grootte van geüploade bestanden in heel de site. De instelling is beperkt door de PHP-instelling upload_max_filesize en de Apache-instelling LimitRequestBody. Anderzijds beperkt maxbytes de grootte die gekozen kan worden op cursus- of activiteitsniveau. Als je kiest voor site uploadlimiet, dan zal de limiet van de serverinstellingen gebruikt worden.';
$string['configmaxconsecutiveidentchars'] = 'Wachtwoorden mogen niet meer dan dit aantal opeenvolgende identieke tekens hebben. Gebruik 0 om deze controle uit te schakelen.';
$string['configmaxeditingtime'] = 'Dit bepaalt hoe lang mensen de tijd hebben om hun forumbijdrage, feedback en dergelijke te wijzigen. Meestal is 30 minuten een goede tijd.';
$string['configmaxevents'] = 'Aantal gebeurtenissen vooruit kijken';
$string['configmaxusersperpage'] = 'Het maximaal aantal te tonen gebruikers in de gebruikersselector in cursus, groep, webservice, enz.';
$string['configmessaging'] = 'Indien ingeschakeld kunnen gebruikers berichten sturen naar andere gebruikers op de site.';
$string['configmessagingallowemailoverride'] = 'Sta gebruikers toe om berichten via e-mail te laten verzenden naar een andere e-mailadres dan dat wat in hun profiel is ingesteld.';
$string['configmessagingallusers'] = 'Indien ingeschakeld, kunnen gebruikers de lijst van alle gebruikers op de site toe zien om iemand te selecteren om een bericht te sturen en wanneer hun berichtvoorkeuren toestaan om berichten te ontvangen van iedereen van de site. Indien uitgeschakeld kunnen gebruikers enkel de lijst van gebruikers in hun cursussen zien en hebben ze slechts twee opties in hun berichtvoorkeuren - enkel berichten van hun contactpersonen ontvangen of van iedereen in hun cursussen.';
$string['configmessagingdefaultpressenter'] = 'Of \'Gebruik Enter om te versturen\' standaard is ingesteld in de berichteninstellingen van gebruikers.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Gelezen en ongelezen meldingen kunnen worden verwijderd om ruimte te besparen. Hoelang nadat een melding is gemaakt, mag deze worden verwijderd?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Gelezen notificaties kunnen gewist worden om ruimte te besparen. Hoe lang nadat de melding gelezen is mag die verwijderd worden?';
$string['configminpassworddigits'] = 'Minimaal aantal cijfers voor wachtwoorden';
$string['configminpasswordlength'] = 'Minimaal aantal tekens voor wachtwoorden';
$string['configminpasswordlower'] = 'Minimaal aantal kleine letters voor wachtwoorden';
$string['configminpasswordnonalphanum'] = 'Minimaal aantal niet-alfanumerieke tekens voor wachtwoorden.';
$string['configminpasswordupper'] = 'Minimaal aantal hoofdletters voor wachtwoorden';
$string['configmodchooserdefault'] = 'Moet de activiteitskiezer standaard aan de gebruikers getoond worden?';
$string['configmycoursesperpage'] = 'Het maximale aantal cursussen dat in een cursuslijst van een gebruiker mogen getoond worden.';
$string['configmymoodleredirect'] = 'Deze instelling dwingt een verwijzing af naar de map /my voor niet-beheerders bij het aanmelden en vervangt het broodkruimelmenu door /my';
$string['configmypagelocked'] = 'Deze instelling verhindert dat de standaardpagina gewijzigd wordt door niet-beheerders';
$string['confignavcourselimit'] = 'Beperkt het aantal cursussen getoond aan de gebruiker wanneer ze niet ingelogd zijn of wanneer ze bij geen enkele cursus aangemeld zijn.';
$string['confignavshowallcourses'] = 'Deze instelling bepaalt of gebruikers die aangemeld zijn in cursussen de lijst met alle cursussen kunnen zien in de navigatie, naast "Mijn cursussen" (de lijst met alle cursussen waarin ze aangemeld zijn).';
$string['confignavshowcategories'] = 'Toon cursuscategorieën in de navigatiebalk en navigatieblokken. Dit doet zich niet voor met cursussen waarin de gebruiker aangemeld is, die zullen getoond worden onder mijn cursussen zonder categorieën.';
$string['confignoreplyaddress'] = 'Soms verzendt Moodle e-mails voor een gebruiker (bijvoorbeeld bij forumberichten) Het e-mailadres dat je hier instelt wordt gebruikt als "From"-adres voor die gebruikers die ervoor gekozen hebben dat andere gebruikers niet rechtstreeks op hun mail mogen kunnen antwoorden (bijvoorbeeld wanneer een gebruiker zijn e-mailadres privé wil houden)';
$string['confignotifyloginfailures'] = 'Als er mislukte aanmeldingen gelogd worden, dan kunnen er e-mailnotificaties verstuurd worden naar deze geselecteerde gebruikers. Hiervoor moet er een interne logstore ingeschakeld worden (vb Sandaard Logstore).';
$string['confignotifyloginthreshold'] = 'Als notificaties over mislukte aanmeldingen verzonden moeten worden, hoeveel aanmeldingspogingen  door één gebruiker of vanaf één IP-adres zijn het melden waard?';
$string['confignotloggedinroleid'] = 'Gebruikers die niet aangemeld zijn bij de site zullen behandeld worden alsof ze binnen de site deze rol gekregen hebben.
Gast is meestal wat je hier wil, maar het is mogelijlk dat je hier een rol wil creëren die meer of minder beperkend is. Zaken zoals het posten van berichten zullen altijd vereisen dat de gebruiker met een account is aangemeld.';
$string['configopentogoogle'] = 'Als je deze instelling inschakelt, dan zal Google als gast toegelaten worden tot je site. Mensen die jouw site binnenkomen via Google zullen automatisch als gast aangemeld zijn. Merk op dat dit alleen toegang zal geven tot cursussen waar toegang voor gasten toegelaten is.';
$string['configoverride'] = 'Gedefinieerd in config.php';
$string['configpasswordpolicy'] = 'Deze instelling maakt dat Moodle controleert of wachtwoorden voldoen aan een wachtwoordenbeleid.Gebruik onderstaande instellingen om je beleid op te maken. Het inschakelen van deze instelling heeft geen invloed op bestaande gebruikers tot zij hun wachtwoord (al dan niet gedwongen) wijzigen.';
$string['configpasswordresettime'] = 'Dit bepaalt hoeveel tijd gebruikers hebben om te klikken op de link in de reset wachtwoord e-mail voor die verloopt.
30 minuten is gewoonlijk een goede waarde.';
$string['configpathtodu'] = 'Pad naar du. Waarschijnlijk iets als /usr/bin/du. Als je dit invult, dan zullen pagina\'s die mapinhoud tonen veel sneller openen bij mappen met veel bestanden in.';
$string['configpathtophp'] = 'Pad naar PHP CLI. Meestal iets als /usr/bin/php. Als je dit ingeeft, dan kunnen cron scripts uitgevoerd worden vanaf de webinterface van de beheerder';
$string['configperfdebug'] = 'Als je dit inschakelt wordt er informatie over de performantie getoond onderaan de pagina. Je moet hiervoor het standaard thema gebruiken.';
$string['configprofileroles'] = 'Lijst met rollen die zichtbaar zijn op gebruikersprofielen en deelnemerspagina.';
$string['configprofilesforenrolledusersonly'] = 'Om misbruik door spammers te vermijden worden profielbeschrijvingen van gebruikers die in geen enkele cursus aangemeld zijn, verborgen. Nieuwe gebruikers moeten in minstens één cursus aangemeld zijn voor zij een profielbeschrijving kunnen toevoegen.';
$string['configprotectusernames'] = 'Indien ingeschakeld, zal het formulier voor vergeten wachtwoorden geen hints tonen die het zouden mogelijk maken een gebruikersnaam of e-mailadres te raden.';
$string['configproxybypass'] = 'Kommagescheiden lijst of (gedeeltelijke) hostnamen of IP-adressen die de proxyserver zouden moeten negeren (vb., 192.168., .mijndomein.com)';
$string['configproxyhost'] = 'Als deze <b>server</b> een proxyserver (zoals bijvoorbeeld een firewall) nodig heeft om op het internet te komen, vul hier dan de hostname en de poort van de proxy in. Laat het veld leeg als dit niet het geval is.';
$string['configproxypassword'] = 'Wachtwoord nodig om door een proxy op het internet te komen, leeg indien geen wachtwoord (PHP cURL extentie nodig).';
$string['configproxyport'] = 'Als deze server een proxyserver gebruikt, zet dan hier de gebruikte poort.';
$string['configproxytype'] = 'Type web proxy (PHP5 en cURL extentie nodig voor SOCKS5 ondersteuning).';
$string['configproxyuser'] = 'Gebruikersnaam nodig om door een proxy op het internet te komen, leeg indien geen wachtwoord (PHP cURL extentie nodig).';
$string['configrecaptchaprivatekey'] = 'Tekenreeks (geheime sleutel), nodig om je Moodle server te laten communiceren met de recaptcha-server. ReCAPTCHA-sleutels kun je verkrijgen via  <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = 'Tekenreeks (site sleutel), nodig om je Moodle server te laten communiceren met de recaptcha-server. ReCAPTCHA-sleutels kun je verkrijgen via  <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestcategoryselection'] = 'De selectie van een categorie toestaan bij het aanvragen van een cursus.';
$string['configrequestedstudentname'] = 'Woord voor leerling, gebruikt in aangevraagde cursussen';
$string['configrequestedstudentsname'] = 'Woord voor leerlingen, gebruikt in aangevraagde cursussen';
$string['configrequestedteachername'] = 'Woord voor leraar, gebruikt in aangevraagde cursussen';
$string['configrequestedteachersname'] = 'Woord voor leraren, gebruikt in aangevraagde cursussen';
$string['configreverseproxyignore'] = 'Als uw server zich achter meerdere reverse proxy\'s bevindt die aan de X-Forwarded-For-header worden toegevoegd, moet u een door komma\'s gescheiden lijst van IP-adressen of subnetten van de reverse proxy\'s opgeven die moeten worden genegeerd om het juiste IP-adres van de gebruiker te vinden.';
$string['configsectioninterface'] = 'Interface';
$string['configsectionmail'] = 'E-mail';
$string['configsectionmaintenance'] = 'Onderhoud';
$string['configsectionmisc'] = 'Varia';
$string['configsectionoperatingsystem'] = 'Besturingssysteem';
$string['configsectionpermissions'] = 'Rechten';
$string['configsectionrequestedcourse'] = 'Cursusaanvragen';
$string['configsectionsecurity'] = 'Beveiliging';
$string['configsectionstats'] = 'Statistieken';
$string['configsectionuser'] = 'Gebruiker';
$string['configsecureforms'] = 'Moodle kan een extra beveiliging toepassen wanneer het gegevens aanneemt van webformulieren. Als je dit inschakelt, dan wordt de variable HTTP_REFERER vergeleken met het huidige formulieradres. In zeldzame gevallen kan dit problemen veroorzaken als de gebruiker een firewall gebruikt (zoals Zonealarm) die geconfigureerd is om HTTP_REFERER uit het webverkeer te filteren. Het symptoom is: vastgeraken op een formulier. Als je gebruikers problemen hebben met de inlogpagina (bijvoorbeeld) dan zou je kunnen overwegen om deze instelling uit te zetten, hoewel dit je site meer blootstelt aan brute kracht-aanvallen op je wachtwoord. Bij twijfel laat je deze instelling op \'ja\' staan.';
$string['configsessioncookie'] = 'Met deze instelling kun je de naam van de cookie die gebruikt wordt voor Moodlesessies, aanpassen. Deze instelling is optioneel en enkel nuttig om te verhinderen dat cookies in conflict komen wanneer meer dan één exemplaar van Moodle binnen dezelfde website draait.';
$string['configsessioncookiedomain'] = 'Hiermee kun je het domein wijzigen waarvan de Moodle-cookies afkomstig zijn. Dit is nuttig voor aanpassingen van Moodle die sessie-informatie van Moodle moeten delen met een webapplicatie op een ander subdomein (v.b. authenticatie of aanmeldingsplugins). <strong> WAARSCHUWING: laat deze instelling leeg (= standaardinstelling) - een verkeerde waarde zal aanmelding op de site onmogelijk maken.</strong>';
$string['configsessioncookiepath'] = 'Als het nodig is dat je de standaardlocatie naar waar browsers de Moodle cookies sturen wijzigt, dan kun je hier een subdirectory van je website instellen. Normaal gezien is de standaard \'/\' goed.';
$string['configsessiontimeout'] = 'Als mensen die ingelogd zijn op deze site voor een lange tijd niets doen (ze laden geen nieuwe pagina\'s) worden ze automatisch uitgelogd (hun sessie is beëindigd). Deze variabele geeft aan hoe lang deze tijd moet zijn.';
$string['configshowcommentscount'] = 'Toon aantal commentaren. Het zal één extra query kosten om commentaarlinks te tonen';
$string['configshowicalsource'] = 'Toon broninformatie voor iCal-gebeurtenissen.';
$string['configshowsiteparticipantslist'] = 'Al deze site leerlingen en site leraren zullen op de site deelnemerslijst getoond worden. Wie heeft het recht om deze lijs te zien?';
$string['configsitedefaultlicense'] = 'Standaard site licentie';
$string['configsitedefaultlicensehelp'] = 'Standaarlicentie die gebruikt zal worden voor het tonen van inhoud op deze site.';
$string['configsitemailcharset'] = 'Deze instelling bepaalt de standaard tekenset voor alle e-mail die door de site verstuurd wordt.';
$string['configsitemaxcategorydepth'] = 'Maximale categoriediepte';
$string['configsitemaxcategorydepthhelp'] = 'Dit specificeert de maximale diepte van getoonde onderliggende categorieën of combolijsten. Diepere categorieën zullen verschijnen als links en gebruikers kunnen ze uitvergroten via AJAX.';
$string['configslasharguments'] = '\'Slash arguments\' (die gebruik maken van <em>PATH_INFO</em> zijn vereist om SCORM-pakketten en bronnen die uit meerdere bestanden bestaan correct te tonen. Als je webserver dit niet ondersteunt en je kunt dit niet configureren, dan kan deze instelling uitgeschakeld worden. Het zal er voor zorgen dat een aantal zaken niet goed werken.<br />Opmerking: het gebruik van \'slash arguments\' zal een vereiste worden in toekomstige Moodle-versies.';
$string['configsmartpix'] = 'Met deze optie ingeschakeld worden icoontjes opgehaald door een PHP-script dat eerst het huidige thema doorzoekt, dan alle bovenliggende thema\'s en dan de Moodle/pix map. Hierdoor is het niet nodig de afbeeldingsbestanden te dupliceren over de verschillende thema\'s. Het heeft wel een kleine performantiekost.';
$string['configsmtpauthtype'] = 'Dit bepaalt het authenticatietype dat je gebruikt voor je smtp-server';
$string['configsmtphosts'] = 'Geef de volledige naam van één of meer lokale SMTP-servers die Moodle moet gebruiken om mail te versturen (bijvoorbeeld: \'mail.a.com\' of \'mail.a.com;mail.b.com\'). Om een niet standaard poort op te geven (anders dan poort 25), kun je de notatie [server]:[poort] gebruiken (bijvoorbeeld mail.a.com:587).
Voor beveiligde verbindingen wordt gewoonlijk poort 465 gebruikt met SSL, poort 587 wordt gebruikt met TLS, specificeer het beveiligingsprotocol onderaan indien nodig. Als je dit veld leeg laat gebruikt Moodle de standaard PHP-methode voor het versturen van mail.';
$string['configsmtpmaxbulk'] = 'Maximaal aantal verstuurde berichten per SMTP-sessie. Het groeperen van berichten kan het versturen van e-mails versnellen. Een waarde kleiner dan 2 zal er voor zorgen dat er voor elke e-mail een nieuwe SMTP-sessie gestart wordt.';
$string['configsmtpsecure'] = 'Als de smtp-server beveiligde verbindingen vereist, specificeer dan het protocol type.';
$string['configsmtpuser'] = 'Als je hierboven een SMTP-server hebt ingevuld en deze server authenticatie nodig heeft, vul hier dan de gebruikersnaam en het wachtwoord in.';
$string['configstartwday'] = 'Begin van de week';
$string['configstatsfirstrun'] = 'Hiermee stel je in hoever terug in de tijd dat de logs moeten herwerkt worden tijdens de <b>eerste keer</b> dat de crontaak de statistieken probeert te verwerken. Als je wel wat verkeer hebt en je server is een shared host, dan is het waarschijnlijk geen goed idee om te ver terug te gaan. Het erg zware proces zou wel eens lang kunnen lopen. (merk op voor deze instelling: 1 maand is 28 dagen. Op de grafieken en in de rapporten is een maand een kalendermaand.)';
$string['configstatsmaxruntime'] = 'Het verwerken van statistieken is een erg belastende taak. Gebruik dus de combinatie van dit veld en het volgende om aan te geven wanneer en hoe lang het proces zal lopen.';
$string['configstatsmaxruntime2'] = 'Het berekenen van statistieken kan voor je server een zeer belastende taak zijn. Specificeer een maximale tijd dat de server mag werken aan de statistieken van één dag. Het maximale aantal verwerkte dagen per cron cyclus is 31.';
$string['configstatsmaxruntime3'] = 'Specificeer de maximale toegelaten tijd om de statistieken voor één dag te berekenen. Hou er rekening mee dat het verwerken van de statistieken een grote belasting voor je server kan betekenen. Het maximale aantal dagen, berekend in één cron, kun je met de volgende instelling kiezen.';
$string['configstatsruntimedays'] = 'Specificeer het maximale aantal dagen die verwerkt mogen worden in één statistiek-berekeningscyclus. Wanneer de statistieken up-to-date zijn, zal er slechts één dag verwerkt worden. Pas deze waarde aan, rekening houdend met de belasting van je server. Maak ze kleiner als de cron-taak korter moet.';
$string['configstatsruntimestart'] = 'Op welk tijdstip moet de crontaak die de statistieken verwerk starten? Geef verschillende tijden op als er meerdere Moodles op één fysieke machine staan.';
$string['configstatsuserthreshold'] = 'Deze instelling geeft het minimaal aantal aangemelde gebruikers die een cursus moet hebben om in de statistiekenberekeningen opgenomen te worden.';
$string['configstrictformsrequired'] = 'Indien ingeschakeld moeten gebruikers meer invullen in een formulier dan alleen een spatie of nieuwe regel.';
$string['configstripalltitletags'] = 'Schakel deze optie uit om HTML-tags toe te laten in activiteits- en bronnamen.';
$string['configsupportemail'] = 'Dit e-mailadres zal gepubliceerd worden aan sitegebruikers als het e-mailadres dat ze kunnen contacteren om algemene hulp te krijgen (zoals bij het creëren van een nieuwe account). Als dit veld leeg gelaten wordt, dan wordt er zo geen e-mailadres aangeboden.';
$string['configsupportname'] = 'Dit is de naam van een persoon of dienst die de algemene hulp aanbiedt.';
$string['configsupportpage'] = 'Deze URL zal gepubliceerd worden aan sitegebruikers als de plaats waar naartoe  te gaan als ze algemene hulp nodig hebben (bijvoorbeeld wanneer nieuwe gebruikers hun eigen accounts aanmaken). Als dit veld leeggelaten wordt, dan wordt er geen link aangeboden.';
$string['configtempdatafoldercleanup'] = 'Verwijder tijdelijke bestanden van de data-map die ouder zijn dan de geselecteerde tijd.';
$string['configthemedesignermode'] = 'Normaal gezien worden alle thema-afbeeldingen en stijlbestanden voor de performantie lange tijd gecached in browsers en op de server. Als je een thema aan het ontwerpen bent of je ontwikkelt code, dan wil je deze instelling waarschijnlijk inschakelen, zodat je geen gecachede versie te zien krijgt. Let op: dit zal je site trager maken voor alle gebruikers! Het alternatief is dat je de thema cache handmatig leegmaakt vanop de thema selectie pagina.';
$string['configthemelist'] = 'Laat dit leeg om gelijk welk geldig thema te gebruiken. Geef hier een door komma\'s gescheiden lijst met thema-namen als je het thema-menu wil inkorten. Bijvoorbeeld: standard,orangewhite. Let op: geen spaties!';
$string['configtimezone'] = 'Hier kun je de standaardtijdzone instellen - elke gebruiker kan deze instelling voor zichzelf wijzigen in zijn profiel. Cron-taken en andere serverinstellingen zullen deze tijdzone gebruiken. Je moet deze instelling aanpassen als de foutmelding "ongeldige tijdzone" wordt getoond.';
$string['configuseblogassociations'] = 'Moeten gebruikers hun blogs kunnen organiseren door blogitems te associëren met cursussen en cursusmodules?';
$string['configuseexternalyui'] = 'In de plaats van gebruik te maken va lokale bestanden, gebruik de bestanden van  de Yahoo servers. WAARSCHUWING: hiervoor moet je server een verbinding met het internet hebben of AJAX zal niet werken. Deze instelling is niet compatibel met sites die https gebruiken.';
$string['configuserquota'] = 'Het maximale aantal bytes dat een gebruiker kan bewaren in zijn eigen bestandenzone. {$a->bytes} bytes == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'Indien ingeschakeld zal de korte naam voor de site gebruikt worden in de navigatie in plaats van \'Site pagina\'s\'';
$string['configusetags'] = 'Tags functionaliteit over de hele site inschakelen?';
$string['configvariables'] = 'Configureer variabelen';
$string['configverifychangedemail'] = 'Schakelt verificatie in van gewijzigde e-mail-adressen wanneer je toegelaten en verboden domeinen gebruikt. Als deze instelling is uitgeschakeld, dan worden de domeinen enkel opgelegd voor het aanmaken van nieuwe gebruikers.';
$string['configvisiblecourses'] = 'Toon cursussen in verborgen categorieën';
$string['configwarning'] = 'Wees voorzichtig met het veranderen van deze instellingen. Vreemde waarden kunnen problemen opleveren.';
$string['configyuicomboloading'] = 'Deze opties schakelen gecombineerde bestands laadoptimalisaties in voor YUI bibliotheken. Deze instelling zou ingeschakeld moeten zijn op productieservers voor performantie.';
$string['confirmation'] = 'Bevestiging';
$string['confirmcontextlock'] = '{$a->contextname} is momenteel niet vergrendeld. Als je deze vergrendelt, worden verdere wijzigingen voorkomen. Weet je zeker dat je wilt doorgaan?';
$string['confirmcontextunlock'] = '{$a->contextname} is momenteel vergrendeld. Als je het niet vergrendelt, kunnen gebruikers wijzigingen aanbrengen. Weet je zeker dat je wilt doorgaan ??';
$string['confirmdeletecomments'] = 'Je gaat notities verwijderen. Ben je zeker?';
$string['confirmed'] = 'Bevestigd';
$string['contextlockappliestoadmin'] = 'Context vergrendelen is van toepassing op beheerders';
$string['contextlockappliestoadmin_desc'] = 'Met deze instelling kunnen beheerders wijzigingen aanbrengen in elke context die is vergrendeld.';
$string['contextlocking'] = 'Context vergrendelen';
$string['contextlocking_desc'] = 'Met deze instelling kun enkel lezen toegang instellen voor geselecteerde categorieën, cursussen, activiteiten en blokken binnen de site.';
$string['cookiehttponly'] = 'Enkel http cookies';
$string['cookiesecure'] = 'Enkel secure cookies';
$string['country'] = 'Standaard landinstelling';
$string['coursecontact'] = 'Cursus beheerders';
$string['coursecontact_desc'] = 'Deze instelling maakt het mogelijk te controleren wie je toont in de cursusbeschrijving. Gebruikers moeten minstens één van deze rollen in een cursus hebben om getoond te worden in de cursusbeschrijving van een bepaalde cursus.';
$string['coursecontactduplicates'] = 'Toon alle cursus contact rollen';
$string['coursecontactduplicates_desc'] = 'Indien ingeschakeld, zullen gebruikers met meer dan een van de geselecteerde contactrollen voor de cursus worden weergegeven in de cursusbeschrijving met elk van hun rollen. Anders worden ze weergegeven met slechts één rol (de waarde die als hoogste wordt vermeld in \'Definieer rollen\' in het sitebeheer).';
$string['course_customfield'] = 'Cursus vrije velden';
$string['coursegraceperiodafter'] = 'Bedenkperiode voor eerdere cursussen';
$string['coursegraceperiodbefore'] = 'Bedenkperiode voor toekomstige cursussen';
$string['courselistshortnames'] = 'Toon uitgebreide cursusnamen';
$string['courselistshortnames_desc'] = 'Toon zowel korte als volledige namen tijdens het tonen van lijsten van cursussen of tijdens het verwijzen naar cursussen op beheerschermen. Wanneer je deze instelling inschakelt, wordt  de taalstring \'courseextendednamedisplay\' gebruikt en kun je door die aan te passen via \'Taalpakket aanpassen\', kiezen wat getoond wordt.';
$string['coursemgmt'] = 'Beheer cursussen en categorieën';
$string['courseoverview'] = 'Cursusoverzicht';
$string['courserequestnotify'] = 'Melding cursusaanvragen';
$string['courserequestnotifyemail'] = 'Gebruiker {$a->user} vroeg een nieuwe cursus aan op {$a->link}';
$string['courserequests'] = 'Cursusaanvragen';
$string['courserequestspending'] = 'Cursusaanvragen';
$string['courses'] = 'Cursussen';
$string['coursesperpage'] = 'Cursussen per pagina';
$string['courseswithsummarieslimit'] = 'Limiet van cursussen met samenvatting';
$string['creatornewroleid'] = 'De rol van de cursusaanmaker in nieuwe cursussen';
$string['creatornewroleid_help'] = 'Als de gebruiker het recht nog niet heeft om de nieuwe cursus te beheren, dan zal de gebruiker automatisch aangemeld worden met deze rol.';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'Cron enkel via command prompt';
$string['cronerrorclionly'] = 'Sorry, internettoegang tot deze pagina is door de beheerder uitgeschakeld.';
$string['cronerrorpassword'] = 'Sorry, maar je kon geen geldig wachtwoord ingeven om deze pagina te bezoeken.';
$string['cron_help'] = 'Het cron.php onderhoudsscript helpt sommige Moodle modules om taken te doen volgens een planning, zoals het versturen van forumberichten. Er is een mechanisme vereist om er voor te zorgen dat het script regelmatig loopt - bij voorkeur elke minuut.';
$string['croninfrequent'] = 'De tijd tussen de laatste twee runs van het cron-onderhoudsscript bedroeg meer dan {$a} seconden. We raden aan dit te configureren om vaker te worden uitgevoerd.';
$string['cronremotepassword'] = 'Cron wachtwoord voor toegang op afstand';
$string['cronwarning'] = 'Het onderhoudsscript <a href="cron.php">cron.php</a> heeft minstens 24 uur niet gelopen.';
$string['cronwarningcli'] = 'Het cli/cron.php onderhoudsscript heeft minstens 24 uur niet gelopen.';
$string['ctyperequired'] = 'De ctype PHP-extentie is nu vereist in Moodle om de performantie te verhogen en om multi-talencompatibiliteit mogelijk te maken.';
$string['curlcache'] = 'cURL cache TTL';
$string['curlrequired'] = 'De cURL PHP-extentie is nu vereist in Moodle om te kunnen communiceren met Moodle bewaarplaats';
$string['curlsecurityallowedport'] = 'cURL toegestane poortenlijst';
$string['curlsecurityallowedportsyntax'] = 'Lijst met poortnummers waarnaar cURL kan verbinden. Enkel natuurlijke getallen zijn zijn geldig. Zet elk getal op een nieuwe lijn. Indien je dit leeg laat, zijn alle getallen toegestaan. Indien ingesteld moeten in nagenoeg alle gevallen zowel 443 als 80 opgegeven worden als standaard poorten voor HTTPS en HTTP.';
$string['curlsecurityblockedhosts'] = 'cURL lijst voor geblokkeerde hosts';
$string['curlsecurityblockedhostssyntax'] = 'Zet elk item op een nieuwe regel. Geldige waarden zijn ofwel volledig IPv4 of IPv6 adressen (zoals 192.168.10.1, 0: 0: 0: 0: 0: 0: 0: 1, :: 1, fe80: :) die overeenstemmen met een enkele host; of CIDR notatie (zoals 231.54.211.0/20 of FE80 :: / 64); of een reeks IP-adressen (zoals 231.3.56.10-20 of FE80 :: 1111-BBBB), waar het bereik van toepassing is op de laatste groep van het adres; of domeinnamen (zoals localhost of example.com); of wildcard domeinnamen (zoals  * .example.com of *.sub.example.com). Lege regels zijn niet toegestaan.';
$string['curlsecurityurlblocked'] = 'De URL is geblokkeerd.';
$string['curltimeoutkbitrate'] = 'Te gebruiken bitrate bij het berekenen van cURL timeouts (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Deze instelling wordt gebruikt om een juiste timeout te berekenen bij het uitvoeren van lange cURL requests. Als deel van de berekening wordt een HTTP HEAD request gemaakt om de grootte van de inhoud te bepalen. Als je dit op 0 zet, wordt de request niet gedaan.';
$string['currenttheme'] = 'Dit thema';
$string['customcheck'] = 'Andere controles';
$string['custommenu'] = 'Aangepast menu';
$string['custommenuitems'] = 'Aangepast menu items';
$string['customusermenuitems'] = 'Gebruikersmenu-items';
$string['datarootsecurityerror'] = '<p><strong>BEVEILIGINGSWAARSCHUWING!</strong></p><p>Je dataroot map staat op de verkeerde plaats en is bereikbaar vanaf het internet. Dit betekent dat al je bestanden voor iedereen beschikbaar zijn en dat sommige bestanden gebruikt kunnen worden door een hacker om toegang tot je site te krijgen als beheerder!</p>
<p>Je <em>moet</em> de dataroot map ({$a}) verplaatsen naar een andere plaats die buiten je publieke webmap is en de <code>$CFG->dataroot</code>-instelling in je config.php aanpassen.</p>';
$string['datarootsecuritywarning'] = 'De configuratie van je site zou onveilig kunnen zijn. Zorg er voor dat je dataroot map ({$a}) niet toegankelijk is vanaf het internet.';
$string['dbsessions'] = 'Gebruik databank voor sessie-informatie';
$string['debug'] = 'Foutopsporingsmeldingen';
$string['debugall'] = 'E_ALL: toon alle zinnige feedback';
$string['debugdeveloper'] = 'ONTWIKKELAAR: extra Moodle debugberichten voor ontwikkelaars';
$string['debugdisplay'] = 'Toon meldingen voor foutopsporing';
$string['debugging'] = 'Fouten opsporen';
$string['debugminimal'] = 'MINIMAL: toon enkel fatale fouten';
$string['debugnone'] = 'GEEN: toon geen foutopsporingsmeldingen';
$string['debugnormal'] = 'NORMAAL: toon fouten, waarschuwingen en opmerkingen';
$string['debugpageinfo'] = 'Toon paginainformatie';
$string['debugsmtp'] = 'Foutopsporing voor versturen van e-mail';
$string['debugstringids'] = 'Toon oorsprong van taalstrings';
$string['debugstringids_desc'] = 'Wanneer deze optie is ingeschakeld, dan zal de string-component en de string-id naast elke string getoond worden wanneer je de parameter ?strings=1 toevoegt aan de URL.';
$string['debugvalidators'] = 'Toon validatorlinks';
$string['defaultcity'] = 'Standaard stad';
$string['defaultcity_help'] = 'Wanneer je nieuwe gebruikersaccounts aanmaakt, dan zal de stad die je hier opgeeft als standaardinstelling gebruikt worden';
$string['defaultformatnotset'] = 'Fout bij het bepalen van de standaard cursusopmaak. Controleer je instellingen.';
$string['defaulthomepage'] = 'Startpagina voor gebruikers';
$string['defaultrequestcategory'] = 'Standaardcategorie voor cursusaanvragen';
$string['defaultsettinginfo'] = 'Standaard: {$a}';
$string['defaultuserroleid'] = 'Standaardrol voor alle gebruikers';
$string['deleteincompleteusers'] = 'Verwijder onvolledig ingestelde accounts na';
$string['deleteunconfirmed'] = 'Verwijder niet-bevestigde gebruikers na';
$string['deleteuser'] = 'Verwijder gebruiker';
$string['density'] = 'Dichtheid';
$string['denyemailaddresses'] = 'Verboden e-maildomeinen';
$string['development'] = 'Ontwikkeling';
$string['devicedetectregex'] = 'Regular expressions voor de bepaling van het apparaat';
$string['devicedetectregex_desc'] = '<p>Moodle kan toestellen detecteren van het type standaard (desktops, laptops, enz.), mobiel (smart phones en kleine palmtop toestellen), tablet (iPad, Android tablets) en verouderd (Internet Explorer 6 gebruikers). De thema-kiezer kan gebruikt worden om een apart thema te kiezen voor elk type toestel. Deze instelling maakt regular expressions mogelijk om die toestellen te detecteren (deze gaan voor op de standaard types).</p><p>Je zou bijvoorbeeld de expressie \'/(MIDP-1.0|Maemo|Windows CE)/\' kunnen gebruiken om een veelgebruikt smart phone type te detecteren en de waarde \'smart phone\' teruggeven. Dit voegt \'Smart phone\' toe aan de thema-kiezer dat je dan de mogelijkheid geeft een thema toe te wijzen om te gebruiken op die toestellen. Andere telefoons gebruiken dan nog steeds het thema geselecteerd voor het mobiel toestel.</p>';
$string['devicedetectregexexpression'] = 'Regular expressions';
$string['devicedetectregexvalue'] = 'Teruggegeven waarde';
$string['devicetype'] = 'Toesteltype';
$string['devlibdirpresent'] = 'Mappen met ontwikkelbibliotheken, vooral  <em>/vendor</em> en <em>/node_modules</em>, mogen niet op publieke sites staan. Zie het <a href="{$a->moreinfourl}">beveiligingsrapport</a> voor meer details.';
$string['disableuserimages'] = 'Schakel gebruikersfoto\'s uit';
$string['displayerrorswarning'] = 'Het inschakelen van de PHP-instelling <em>display_errors</em> is niet aangewezen op productie-sites omdat sommige foutmeldingen gevoelige informatie over de server kunnen vrijgeven.';
$string['displayloginfailures'] = 'Toon loginfouten';
$string['dndallowtextandlinks'] = 'Slepen en neerzetten';
$string['doclang'] = 'Taal voor docs';
$string['docroot'] = 'Startpagina Moodle Docs';
$string['doctonewwindow'] = 'Open in nieuw venster';
$string['doesnotfit'] = 'Instellingen tonen e-mails';
$string['doesnotfitdetail'] = 'Toon instellingen voor e-mail die Moodle verlaat.';
$string['download'] = 'Download';
$string['durationunits'] = 'duur units';
$string['edithelpdocs'] = 'Bewerk helpbestanden';
$string['editlang'] = '<b>Bewerk</b>';
$string['editorbackgroundcolor'] = 'Achtergrondkleur';
$string['editordictionary'] = 'Editor woordenboek';
$string['editorfontfamily'] = 'Lettertypefamilie';
$string['editorfontlist'] = 'Lettertypelijst';
$string['editorfontsize'] = 'Lettertypegrootte';
$string['editorhidebuttons'] = 'Verborgen knoppen';
$string['editorkillword'] = 'Word-document opschonen';
$string['editorspelling'] = 'Editor spelling';
$string['editorspellinghelp'] = 'Inschakelen of uitschakelen van spellingscontrole. Wanneer je dit inschakelt, moet <strong>aspell</strong> op de server geïnstalleerd zijn.';
$string['editstrings'] = 'Bewerk woorden en zinnen';
$string['emailchangeconfirmation'] = 'Bevestiging van wijziging e-mailadres';
$string['emailfromvia'] = 'E-mail via-informatie';
$string['emailsubjectprefix'] = 'Tekst als voorvoegsel bij e-mailonderwerp';
$string['emoticonalt'] = 'Alternatieve tekst';
$string['emoticoncomponent'] = 'Afbeeldingscomponent';
$string['emoticonimagename'] = 'Afbeeldingsnaam';
$string['emoticons'] = 'Emoticons';
$string['emoticons_desc'] = 'Dit formulier bepaalt de emoticons (of smileys) die op jouw site gebruikt worden. Om een rij van de tabel te verwijderen kun je het formulier bewaren met een lege waarde in elk vereist veld. Om een nieuw emoticon te registreren kun je de lege velden invullen op de laatste rij. Om alle velden terug op standaardinstellingen te zetten volg je bovenstaande link.

* Tekst (vereist) - Deze tekst zal vervangen worden door de afbeelding van het emoticon. Deze tekst moet minstens twee tekens lang zijn.
* Afbeeldingsnaam (vereist) - De bestandsnaam van het emoticon zonder de extentie, relatief ten opzichte van de component pix map.
* Afbeeldingscomponent (vereist) - De component die het icoon levert.
* Alternatieve tekst (optioneel) - Identificatiestring en component van de alternatieve tekst voor het emoticon;';
$string['emoticonsreset'] = 'Zet de instellingen voor emoticons terug op standaardinstellingen';
$string['emoticontext'] = 'Tekst';
$string['emptysettingvalue'] = 'Leeg';
$string['enableactivitychooser'] = 'Activiteitskiezer inschakelen';
$string['enableblogs'] = 'Blogs inschakelen';
$string['enablecalendarexport'] = 'Kalenderexport inschakelen';
$string['enablecomments'] = 'Commentaren inschakelen';
$string['enablecourserequests'] = 'Cursusaanvragen inschakelen';
$string['enabled'] = 'Ingeschakeld';
$string['enabledevicedetection'] = 'Toesteldetectie inschakelen';
$string['enableglobalsearch'] = 'Globaal zoeken inschakelen';
$string['enableglobalsearch_desc'] = 'Indien ingeschakeld zullen gegevens geïndexeerd en gesynchroniseerd worden door een geplande taak.';
$string['enablegravatar'] = 'Gravatar inschakelen';
$string['enablegravatar_help'] = 'Als je dit inschakelt, zal Moodle proberen een gebruikersprofielfoto van Gravatar te halen als de gebruiker nog geen afbeelding geüpload heeft.';
$string['enablemobilewebservice'] = 'Webservices voor mobiele toestellen inschakelen';
$string['enablerecordcache'] = 'Record cache inschakelen';
$string['enablerssfeeds'] = 'RSS-feeds inschakelen';
$string['enablesafebrowserintegration'] = 'Schakel Safe Exam Browser integratie in';
$string['enablesearchareas'] = 'Zoekgebied inschakelen';
$string['enablestats'] = 'Statistieken inschakelen';
$string['enabletrusttext'] = 'Vertrouwde Inhoud inschakelen';
$string['enablewebservices'] = 'Webservices inschakelen';
$string['enablewsdocumentation'] = 'Documentatie Webservices';
$string['enrolinstancedefaults'] = 'Aanmeldingsstandaarden';
$string['enrolinstancedefaults_desc'] = 'Standaard aanmeldingsinstellingen in nieuwe cursussen.';
$string['enrolmultipleusers'] = 'Gebruikers aanmelden';
$string['environment'] = 'Omgeving';
$string['environmenterrortodo'] = 'Je moet all de problemen over de installatie-omgeving die hierboven gevonden zijn, oplossen. Ga pas dan verder met het installeren van deze Moodleversie.';
$string['environmenterrorupgrade'] = 'Waarschuwing: je moet eerst alle hierboven gemelde omgevingsproblemen oplossen voor je verder gaat met de upgrade van Moodle! Upgraden zonder deze vereiste omgeving kan problemen zoals gegevensverlies veroorzaken. Ben je er zeker van dat je verder wil doen met deze upgrade?';
$string['environmentmariadbwrongdbtype'] = 'Fout <code>$CFG->dbtype</code>: je moet dit wijzigen in je <code>config.php</code> -bestand, van \'<code>mysql</code>\' naar \'<code>mariadb</code>\'.';
$string['environmentmustfixsetting'] = 'PHP-instelling moet gewijzigd worden';
$string['environmentok'] = 'Je server voldoet aan alle minimumeisen';
$string['environmentrecommendcustomcheck'] = 'Als deze test faalt, dan wijst dat op een mogelijk probleem';
$string['environmentrecommendinstall'] = 'wordt aangeraden om te installeren of in te schakelen';
$string['environmentrecommendversion'] = 'je kunt betere versie {$a->needed} gebruiken en je gebruikt nu versie {$a->current}';
$string['environmentrequirecustomcheck'] = 'Deze test moet OK zijn';
$string['environmentrequireinstall'] = 'moet geïnstalleerd/ingeschakeld zijn';
$string['environmentrequireversion'] = 'versie {$a->needed} is vereist en je gebruikt nu versie {$a->current}';
$string['environmentsettingok'] = 'aanbevolen instelling gedetecteerd';
$string['environmentshouldfixsetting'] = 'PHP-instelling zou gewijzigd moeten worden.';
$string['environmentxmlerror'] = 'Fout bij het lezen van de omgevingsdata ({$a->error_code})';
$string['errordeletingconfig'] = 'Er is een fout opgetreden bij het verwijderen van de configuratierecords voor plugin \'{$a}\'';
$string['errorsetting'] = 'Kon instelling niet bewaren';
$string['errorwithsettings'] = 'Sommige instellingen zijn door een fout niet gewijzigd.';
$string['eventshandlersinuse'] = 'Volgende plugins op jouw systeem gebruiken Events 1 API deprecated handlers: \'{$a}\'. Update ze naar Events 2 API.
Zie https://docs.moodle.org/dev/Event_2#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Iedereen die kan \'{$a}\'';
$string['exceptions'] = 'uitzonderingen';
$string['execpathnotallowed'] = 'Uitvoerbare en lokale paden uitschakelen in config.php';
$string['experimental'] = 'Experimenteel';
$string['experimentalsettings'] = 'Experimentele instellingen';
$string['extendedusernamechars'] = 'Uitgebreide tekenset in gebruikersnamen toestaan';
$string['extramemorylimit'] = 'Extra PHP memory limit';
$string['fatalsessionautostart'] = '<p>Ernstige configuratiefout gevonden. Waarschuw je serverbeheerder.</p><p>Om goed te functioneren moet de beheerder de PHP-instellingen aanpassen.</p><p><code>session.auto_start</code> moet op<code>off</code> gezet worden.</p><p>Deze instelling kan gewijzigd worden door het bestand <code>php.ini</code>, Apache/IIS <br />-configuratie of het bestand <code>.htaccess</code> op de server aan te passen.</p>';
$string['fileconversioncleanuptask'] = 'Verwijder tijdelijke records van bestandsconversies.';
$string['filecreated'] = 'Nieuw bestand aangemaakt';
$string['filestoredin'] = 'Bewaar bestand in map';
$string['filestoredinhelp'] = 'Bestandslocatie';
$string['filterall'] = 'Filter alle strings';
$string['filtermatchoneperpage'] = 'Filter maakt één koppeling per pagina';
$string['filtermatchonepertext'] = 'Filter maakt één koppeling per tekst';
$string['filters'] = 'Filters';
$string['filtersettings'] = 'Beheer filters';
$string['filtersettingsgeneral'] = 'Algemene filterinstellingen';
$string['filteruploadedfiles'] = 'Gebruik de filters in geüploade bestanden';
$string['forceclean'] = 'Inhoud overal opschonen';
$string['forceclean_desc'] = 'Inhoud die aan de site toegevoegd wordt, wordt gewoonlijk opgeschoond voor het getoond wordt om zo alles te verwijderen dat een beveiligingsrisico zou kunnen zijn. Op sommige plaatsen gebeurt dit echter niet, zoals bij activiteitsbeschrijvingen, paginabronnen of HTML-blokken om scripts, media, inline frames en dergelijke toe te staan. Als dit wordt ingeschakeld, wordt ALLE inhoud opgeschoond. Dit kan als gevolg hebben dat bestaande inhoud niet goed meer getoond wordt.';
$string['forcelogin'] = 'Verplicht aanmelden';
$string['forceloginforprofileimage'] = 'Verplicht gebruikers aan te melden om gebruikersfoto\'s te zien';
$string['forceloginforprofileimage_help'] = 'Indien ingeschakeld moeten gebruikers aangemeld zijn om profielfoto\'s van gebruikers te zien. De standaard gebruikersfoto zal gebruikt worden in alle e-mailmeldingen.';
$string['forceloginforprofiles'] = 'Verplicht aanmelden voor profielen';
$string['forcetimezone'] = 'Verplicht standaard tijdzone';
$string['formatuninstallwithcourses'] = 'Er zijn {$a->count} cursussen die {$a->format} gebruiken. De opmaak ervan zal gewijzigd worden naar {$a->defaultformat} (standaard cursusopmaak voor deze site). Sommige opmaakspecifieke data kunnen verloren gaan. Weet je zeker dat je verder wil gaan?';
$string['frontpage'] = 'Startpagina';
$string['frontpagebackup'] = 'Back-up startpagina';
$string['frontpagedefaultrole'] = 'Standaardrol voor startpagina';
$string['frontpagefilters'] = 'Startpagina filters';
$string['frontpageloggedin'] = 'Startpagina-items als aangemeld';
$string['frontpageoverrides'] = 'Startpagina rechten overschrijven';
$string['frontpagequestions'] = 'Vragen startpagina';
$string['frontpagerestore'] = 'Restore startpagina';
$string['frontpageroles'] = 'Rollen startpagina';
$string['frontpagesettings'] = 'Instellingen startpagina';
$string['fullnamedisplay'] = 'Volledige naam opmaak';
$string['fullnamedisplayprivate'] = 'Volledige naam opmaak - privé';
$string['gdrequired'] = 'De GD-extentie is vereist door Moodle voor conversie van afbeeldingen';
$string['generalsettings'] = 'Algemene instellingen';
$string['geoipfile'] = 'GeoLite2 City MaxMind DB';
$string['getremoteaddrconf'] = 'IP-adres in de logs';
$string['globalsearch'] = 'Globaal zoeken';
$string['globalsearchmanage'] = 'Beheer globaal zoeken';
$string['googlemapkey3'] = 'Google Maps API V3 sleutel';
$string['googlemapkey3_help'] = 'Je moet een speciale sleutel ingeven om Google Maps voor IP-adreslocalisatie te kunnen gebruiken. Die kun je gratis verkrijgen op <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Ga naar de eerste ontbrekende string';
$string['gradebook'] = 'Cijferlijst';
$string['gradebookroles'] = 'Rollen in cijferlijst';
$string['gradeexport'] = 'Primaire cijferexportmethode';
$string['gravatardefaulturl'] = 'Gravatar standaard afbeeldings URL';
$string['gravatardefaulturl_help'] = 'Gravatar heeft een standaard afbeelding nodig om te tonen als het geen afbeelding voor een bepaalde gebruiker kan vinden. Geef een volledige URL voor een afbeelding. Als je deze instelling leeg laat, dan zal Moodle proberen de meest geschikte afbeelding voor de pagina die je aan het bekijken bent te kiezen. Merk ook op dat Gravatar een aantal codes heeft waarmee <a href="https://en.gravatar.com/site/implement/images/#default-image">standaardafbeeldingen gegenereerd kunnen worden</a> .';
$string['groupenrolmentkeypolicy'] = 'Beleid voor aanmeldingssleutel groepen';
$string['groupenrolmentkeypolicy_desc'] = 'Indien ingeschakeld worden de aanmeldingssleutels voor groepen gecontroleerd tegen het wachtwoordbeleid zoals opgegeven in de instellingen hierboven.';
$string['guestroleid'] = 'Rol voor gasten';
$string['guestroleid_help'] = 'Deze rol wordt automatisch toegewezen aan de gastgebruiker. Deze rol wordt ook tijdelijk toegewezen aan niet aangemelde gebruikers als ze een cursus openen via de gastaanmeldingsplugin.';
$string['helpadminseesall'] = 'Zien beheerders alle gebeurtenissen van alle cursuskalender of alleen van diegene waarin ze zelf aangemeld zijn? Onafhankelijk van deze instellingen zullen site-beheerders altijd de gebeurtenissen van elke cursus kunnen beheren door eerst naar de cursus te navigeren en daar de cursuskalender te bewerken.';
$string['helpcalendarcustomexport'] = 'Aangepast datumbereikoptie inschakelen in kalenderexport. Kalenderexport moet ingeschakeld zijn voor dit kan werken.';
$string['helpexportlookahead'] = 'Hoeveel dagen moet de kalender in de toekomst kijken naar gebeurtenissen voor de aangepaste exportfunctie?';
$string['helpexportlookback'] = 'Hoeveel dagen in het verleden moet de calender kijken voor de aangepaste exportfunctie?';
$string['helpforcetimezone'] = 'Je kunt je gebruikers elk hun eigen tijdzone laten kiezen of een tijdzone opleggen voor iedereen.';
$string['helpshowicalsource'] = 'Schakel deze instelling in als de iCal inschrijvingsnaam en link wil tonen voor geïmporteerde gebeurtenissen.';
$string['helpsitemaintenance'] = 'Voor upgrades en ander onderhoud';
$string['helpstartofweek'] = 'Welke dag start de week in de kalender?';
$string['helpupcominglookahead'] = 'Hoeveel dagen is de standaardinstelling om kalender vooruit te laten kijken naar aankomende activiteiten?';
$string['helpupcomingmaxevents'] = 'Hoeveel aankomende activiteiten worden er maximaal getoond aan de gebruikers?';
$string['helpweekenddays'] = 'Welke dagen van de week worden als "weekend" beschouwd en dus in een andere kleur getoond?';
$string['hiddenuserfields'] = 'Verberg gebruikersvelden';
$string['hidefromall'] = 'Verberg voor alle gebruikers';
$string['hidefromnone'] = 'Verberg voor niemand';
$string['hidefromstudents'] = 'Verberg voor leerlingen';
$string['htmleditor'] = 'HTML-editor';
$string['htmleditorsettings'] = 'Instellingen HTML-editor';
$string['htmlsettings'] = 'HTML-instellingen';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP Security';
$string['hubs'] = 'Hubs';
$string['iconvrequired'] = 'Het installeren van de ICONV-extentie is vereist.';
$string['ignore'] = 'Negeer';
$string['includemoduleuserdata'] = 'Ook gebruikersdata van modules';
$string['incompatibleblocks'] = 'Niet-compatibele blokken';
$string['incompleteunicodesupport'] = 'De huidige opzet van MySQL of MariaDB gebruikt \'utf8\'. Deze tekenset ondersteunt geen tekens van vier bytes, waaronder sommige emoji. Gebruik van deze tekens zal leiden tot een foutmelding bij het updaten van een record en informatie die naar de database wordt gezonden, kan verloren gaan. Overweeg de instellingen te wijzigen naar \'utf8mb4\'. Zie de documentatie voor aanvullende informatie.';
$string['indexdata'] = 'indexeer gegevens';
$string['indexinginfo'] = 'De aangeraden manier om de inhoud van je site te indexeren is door gebruik te maken van de geplande taak "Globaal zoeken indexeren".';
$string['installhijacked'] = 'De installatie moet worden voltooid vanaf het oorspronkelijk IP-adres';
$string['installsessionerror'] = 'Kan geen PHP-sessie initialiseren. Controleer of je browser cookies accepteerd.';
$string['intlrecommended'] = 'Intl-extentie wordt gebruikt om de ondersteuning van internationalisering te verbeteren, zoals sorteren op basis van de ingestelde locale.';
$string['intlrequired'] = 'De intl-extentie is vereist om internationaliseringsondersteuning te verbeteren, zoals het sorteren volgens locale regels en internationale domeinnamen';
$string['invalidagedigitalconsent'] = 'De digitale meerderjarigheid is ongeldig: {$a}';
$string['invalidforgottenpasswordurl'] = 'De URL voor vergeten wachtwoord is geen geldige URL.';
$string['invalidsection'] = 'Ongeldige sectie';
$string['invaliduserchangeme'] = 'De gebruikersnaam "changeme" kan niet als gebruikersnaam gebruikt worden. Kies een andere.';
$string['ipblocked'] = 'Deze site is nu niet beschikbaar.';
$string['ipblocker'] = 'IP blokkeren';
$string['ipblockersyntax'] = 'Zet elk item op één lijn. Geldige items zijn volledige IP-adressen (zoals <b>192.168.0.1</b>, die overeenkomen met één enkele machine; gedeeltelijke IP-adressen (zoals <b>192.168</b>) die overeenkomen met alle IP-adressen die met die nummers beginnen: of CIDR notatie van IP-adressen (zoals <b>231.3.56.10/20</b>) waar een bereik van toepassing is op het laatste deel van het adres. Domeinnamen (zoals voorbeeld.com) worden niet ondersteund. Lege regels worden genegeerd en tekst die volgt na een \'#"-teken wordt genegeerd.';
$string['iplookup'] = 'IP-adres opzoeken';
$string['iplookupgeoplugin'] = 'De <a href="http://www.geoplugin.com">geoPlugin</a> service wordt gebruikt om geografische informatie op te zoeken. Voor meer accurate resultatien kun je beter een lokale kopie van de MaxMind GeoLite databank installeren.';
$string['iplookupinfo'] = 'Standaard gebruikt Moodle de gratis  NetGeo (The Internet Geographic Database) server om de plaats van IP-adressen op te zoeken. Jammer genoeg wordt deze databank niet meer onderhouden en kan  <em>foute</em> data weergeven.
Het is dan ook aangeraden om een lokale kopie van de gratis GeoLite City database van MaxMind te installeren.<br />
IP-adreslocatie wordt dan getoond op een eenvoudige kaart of op een kaart van Google Maps. Merk op dat je hiervoor een Google account nodig hebt en een gratis Google Maps API sleutel moet aanvragen om de interactieve kaarten in te schakelen.';
$string['iplookupmaxmindnote'] = 'Dit product bevat GeoLite2 data gemaakt door  MaxMind en beschikbaar van <a href="https://www.maxmind.com/">https://www.maxmind.com/</a>.';
$string['ishttpswarning'] = 'Je site gebruikt geen HTTPS. Voor een betere beveiliging en voor een verbeterde integratie met andere systemen wordt sterk aangeraden om jouw site naar HTTPS om te schakelen.';
$string['keeptagnamecase'] = 'Hoofdletters tag-namen behouden';
$string['lang'] = 'Standaardtaal';
$string['langcache'] = 'Cache taalmenu';
$string['langcache_desc'] = 'Cache het taalmenu. Indien ingeschakeld wordt de lijst met beschikbare talen gecached. De cache wordt automatisch ververst wanneer je een taalpakket installeert of verwijderd met de ingebouwde taalbeheerfuncties. Als je manueel een nieuw taalpakket installeert, dan moet je de functie cache leegmaken gebruiken om de cache lijst te verversen.';
$string['langlist'] = 'Talen in taalmenu';
$string['langmenu'] = 'Toon taalmenu';
$string['langpackwillbeupdated'] = 'Opmerking: tijdens de upgrade zal Moodle proberen updates te downloaden voor je geïnstalleerde taalpakketten.';
$string['langstringcache'] = 'Cache alle taalstrings';
$string['languagesettings'] = 'Instellingen';
$string['latinexcelexport'] = 'Excel encoding';
$string['legacyfilesaddallowed'] = 'Cursusbestanden toevoegen volgens verouderd systeem toestaan';
$string['legacyfilesaddallowed_help'] = 'Toestaan om nog nieuwe cursusbestanden en mappen toe te voegen als een cursus nog bestanden gebruikt volgens het oude systeem.';
$string['legacyfilesinnewcourses'] = 'Standaard cursusbestanden in nieuwe cursussen';
$string['legacyfilesinnewcourses_help'] = 'Standaard zijn de verouderde cursusbestanden alleen beschikbaar in geüpgrade cursussen. Merk op dat sommige functies zoals back-up/terugzetten van afzonderlijke activiteiten niet compatibel zijn met deze instelling.';
$string['libcurlwarning'] = 'Er werd geconstateerd dat libcurl geen CURLOPT_PROTOCOL ondersteuning heeft. Een up-to-date libcurl installatie wordt aanbevolen om veiligheidsredenen.';
$string['licensesettings'] = 'Licentieinstellingen';
$string['linkadmincategories'] = 'Link beheercategorieën';
$string['linkadmincategories_help'] = 'Indien ingeschakeld zullen beheerinstellingscategorieën als links getoond worden in de navigatie en zullen die je naar de beheercategorieënpagina\'s brengen.';
$string['linkcoursesections'] = 'Altijd naar cursussecties linken';
$string['linkcoursesections_help'] = 'Probeer altijd een link te maken naar cursussecties. Cursussecties worden gewoonlijk getoond als links als de cursusopmaak één sectie per pagina toont. Als deze instelling is ingeschakeld, dan zal er altijd een link getoond worden.';
$string['loading'] = 'Laden';
$string['localetext'] = 'Locale voor de site';
$string['localstringcustomization'] = 'Taalpakket aanpassen voor lokaal gebruik';
$string['location'] = 'Plaats';
$string['locationsettings'] = 'Locatie-instellingen';
$string['locked'] = 'Geblokkeerd';
$string['lockoutduration'] = 'Duur geblokkeerde account';
$string['lockoutduration_desc'] = 'De geblokkeerde account wordt automatisch terug vrijgegeven na deze tijd.';
$string['lockoutemailbody'] = 'Je account {$a->username} op {$a->sitename} is geblokkeerd na meerdere mislukte pogingen om aan te melden.

Om je account onmiddellijk vrij te geven ga je naar volgend adres:

{$a->link}

In de meeste e-mailprogramma\'s zou dit als een blauwe link moeten verschijnen, waarop je gewoon kunt klikken. Als dat niet werkt, kopieer en plak de link dan in de adresbalk van je webbrowser.

Als je meer hulp nodig hebt, neem dan contact op met je site-beheerder, {$a->admin}';
$string['lockoutemailsubject'] = 'Je account op {$a} is geblokkeerd';
$string['lockouterrorunlock'] = 'Ongeldige deblokkeerinformatie gegeven.';
$string['lockoutthreshold'] = 'Duur blokkering account';
$string['lockoutthreshold_desc'] = 'Kies het aantal mislukte loginpogingen waardoor een account geblokkeerd zal worden. Deze functie kan misbruikt worden voor denial of service-aanvallen.';
$string['lockoutwindow'] = 'Observatievenster geblokkeerde accounts';
$string['lockoutwindow_desc'] = 'Observatietijd voor blokkeringsduur. Als er geen mislukte aanmeldingen zijn na deze tijd, dan wordt de teller terug op nul gezet.';
$string['log'] = 'Logs';
$string['logguests'] = 'Log gasttoegang';
$string['logguests_help'] = 'Deze instelling maakt het mogelijk om activiteiten van de gast account en van niet aangemelde gebruikers te loggen. Voor sites met hoge belasting kan het nodig zijn deze instelling uit te schakelen voor om performantieredenen. Anders is het goed om dit ingeschakeld te laten op productiesites.';
$string['loginhttps'] = 'Gebruik HTTPS voor logins';
$string['loginpageautofocus'] = 'Autofocus loginformulier';
$string['loginpageautofocus_help'] = 'Deze functie inschakelen verhoogt het gebruiksgemak op de loginpagina, maar het automatisch focussen van velden wordt gezien als een toegankelijkheidsprobleem.';
$string['loginpasswordautocomplete'] = 'Wachtwoord aanvullen uitschakelen op loginformulier';
$string['loginpasswordautocomplete_help'] = 'Indien ingeschakeld kunnen gebruikers hun wachtwoord niet bewaren in hun browser.';
$string['loglifetime'] = 'Logs bijhouden';
$string['logo'] = 'Logo';
$string['logocompact'] = 'Klein logo';
$string['logocompact_desc'] = 'Een kleine versie van hetzelfde logo als hierboven, zoals een embleem, schild of icoon. De afbeelding moet duidelijk zijn, zelfs wanneer ze erg klein is. Aanvaarde bestandsformaten: PNG en JPG';
$string['logo_desc'] = 'Een volledig logo wordt gebruikt als decoratie door enkele thema\'s (zoals Core thema\'s). Deze afbeelding kan een heel hoge resolutie hebben, omdat die naar beneden zal worden geschaald voor gebruik (en in de cache geplaatst voor prestatie). Logo\'s die breder zijn dan ze hoog zijn geven meestal betere resultaten. Aanvaarde formaten: PNG en JPG.';
$string['logossettings'] = 'Logo\'s';
$string['logstorenotrequired'] = 'Log store niet vereist';
$string['logstoressupported'] = 'Log stores die dit rapport ondersteunen';
$string['longtimewarning'] = '<b>Opgelet: dit proces kan lang duren</b>';
$string['mailnewline'] = 'Nieuwe regel karakters in e-mail';
$string['maintenancemode'] = 'In onderhoudsmodus';
$string['maintenancemodeisscheduled'] = 'De site wordt binnen {$a->min} minuten en {$a->sec} in onderhoudsmodus gezet.';
$string['maintenancemodeisscheduledlong'] = 'Deze site zal worden overgeschakeld naar onderhoudsmodus  over {$a->hour} uur {$a->min} mins {$a->sec} secs';
$string['maintfileopenerror'] = 'Fout bij het openen van de onderhoudsbestanden!';
$string['maintinprogress'] = 'Onderhoud bezig...';
$string['managecontextlock'] = 'Vergrendel deze context';
$string['managecontextlocklocked'] = '{$a->contextname} en alle onderliggende items zijn nu vergrendeld.';
$string['managecontextlockunlocked'] = '{$a->contextname} en alle onderliggende items zijn nu ontgrendeld.';
$string['managecontextunlock'] = 'Ontgrendel deze context';
$string['managecustomfields'] = 'Beheer vrij veld types';
$string['manageformats'] = 'Beheer cursusopmaak';
$string['manageformatsgotosettings'] = 'Standaardopmaak kan gewijzigd worden in {$a}';
$string['managelang'] = '<b>Beheer</b>';
$string['managelicenses'] = 'Beheer licenties';
$string['manageqbehaviours'] = 'Beheer gedrag van vragen';
$string['manageqtypes'] = 'Beheer vraagtypes';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Release kandidaat';
$string['maturity200'] = 'Stabiele versie';
$string['maturity50'] = 'Alfa';
$string['maturityallowunstable'] = 'Hint: misschien wil je dit script met de --allow-unstable optie laten lopen';
$string['maturitycoreinfo'] = 'Je site draait momenteel op de ontwikkelcode van de onstabiele  versie "{$a}"';
$string['maturitycorewarning'] = 'De Moodleversie die je gaat installeren of upgraden bevat onstabiele "{$a}"-ontwikkelingscode en die is niet geschikt voor de meeste productiesites. Als dit niet is wat je wil, zorg er dan voor dat je update van een STABLE branch van de Moodle code. Zie Moodle Docs voor meer details.';
$string['maxbytes'] = 'Maximale grootte voor bestandsupload';
$string['maxconsecutiveidentchars'] = 'Opeenvolgende identieke tekens';
$string['maxeditingtime'] = 'Maximale tijd om berichten te bewerken';
$string['maxtimelimit'] = 'Maximum tijdslimiet';
$string['maxtimelimit_desc'] = 'Geef hier een waarde in seconden om de PHP uitvoertijd die Moodle toestaat zonder dat er iets getoond wordt op het scherm. 0 betekent dat de standaardbeperkingen gebruikt worden. Als je een front-endserver hebt met zijn eigen tijdslimiet, zet deze waarde dan lager, zodat je PHP-fouten in de logs krijgt. Niet van toepassing op CLI-scripts.';
$string['maxusersperpage'] = 'Maximaal aantal gebruikers per pagina';
$string['mbstringrecommended'] = 'Als je site andere talen dan die uit de Latin1 tekenset gebruikt, dan is het installeren van de optionele MBSTRING library ten zeerste aangeraden om de performantie van de site te verhogen.';
$string['mbstringrequired'] = 'Het installeren van de MBSTRING-bibliotheek is nodig om de site-performantie te verbeteren, vooral als je site andere talen dan met het latijnse schrift ondersteunt.';
$string['mediapluginavi'] = 'Gebruik .avi-filter';
$string['mediapluginflv'] = 'Gebruik .flv-filter';
$string['mediapluginimg'] = 'Het automatisch insluiten van gelinkte afbeeldingen inschakelen';
$string['mediapluginmov'] = 'Gebruik .mov-filter';
$string['mediapluginmp3'] = 'Gebruik .mp3-filter';
$string['mediapluginmpg'] = 'Gebruik .mpg-filter';
$string['mediapluginogg'] = 'Schakel .ogg-filter in';
$string['mediapluginogv'] = 'Schakel .ogv-filter in';
$string['mediapluginram'] = 'Gebruik .ram-filter';
$string['mediapluginrm'] = 'Gebruik .rm-filter';
$string['mediapluginrpm'] = 'Gebruik .rpm-filter';
$string['mediapluginswf'] = 'Gebruik .swf-filter';
$string['mediapluginswfnote'] = 'Het is niet veilig om gewone gebruikers toe te laten swf flash bestanden te gebruiken in hun webpagina\'s.';
$string['mediapluginwmv'] = 'Gebruik .wmv-filter';
$string['mediapluginyoutube'] = 'Youtube linkfilter inschakelen';
$string['messaging'] = 'Berichtensysteem inschakelen';
$string['messagingallowemailoverride'] = 'Notificatie e-mail overschrijven';
$string['messagingallusers'] = 'Sta berichten toe van iedereen op de site';
$string['messagingcategory'] = 'Berichten';
$string['messagingdefaultpressenter'] = 'Gebruik standaard de enter toets op je toetsenbord om een bericht te versturen.';
$string['messagingdeleteallnotificationsdelay'] = 'Verwijder alle meldingen';
$string['messagingdeletereadnotificationsdelay'] = 'Verwijder meldingen voor gelezen';
$string['messagingssettings'] = 'Instellingen berichten';
$string['minpassworddigits'] = 'Tekens';
$string['minpasswordlength'] = 'Wachtwoordlengte';
$string['minpasswordlower'] = 'Kleine letters';
$string['minpasswordnonalphanum'] = 'Niet-alfanumerieke tekens';
$string['minpasswordupper'] = 'Hoofdletters';
$string['misc'] = 'Andere';
$string['mnetrestore_extusers'] = '<strong>Opmerking:</strong> Dit back-upbestand bevat Moodle Netwerk accounts, die zullen teruggezet worden als deel van dit proces';
$string['mnetrestore_extusers_admin'] = '<strong>Opmerking:</strong> Dit back-upbestand komt blijkbaar van een andere Moodle-installatie en bevat Moodle Network accounts. Tijdens het terugzetten ervan zal Moodle proberen om die gebruikers aan de juiste Moodle Netwerk server te koppelen. Diegene die niet gekoppeld kunnen worden, zullen met interne aanmelding in plaats van mnet aangemaakt worden. Het logscherm van het terugzetten zal je hierover informeren.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Opmerking:</strong> Dit back-upbestand komt blijkbaar van een andere Moodle-installatie en bevat Moodle Netwerk accounts die mogelijk niet teruggezet kunnen worden. Deze operatie wordt niet ondersteund. Als je er zeker van bent dat dit bestand op deze Moodle installatie werd gemaakt of je kunt er zeker van zijn dat alle nodige Moodle Netwerk Hosts geconfigureerd zijn, dan kun je toch proberen deze back-up terug te zetten.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Opmerking:</strong> Dit back-upbestand komt blijkbaar van een andere Moodle-installatie en bevat Moodle Network accounts. Je hebt niet het recht om zo een back-up terug te zetten. Contacteer je sitebeheerder of zet deze cursus terug zonder gebruikersgegevens.';
$string['mnetrestore_extusers_switchuserauth'] = 'Moodle Netwerkgebruiker  {$a->username} (komt van {$a->mnethosturl}) is ombeschakeld naar een lokale  {$a->auth} geauthenticeerde gebruiker.';
$string['mobilenotconfiguredwarning'] = 'De Moodle app is niet ingeschakeld.';
$string['modchooserdefault'] = 'Activiteitskiezer standaard';
$string['modeditdefaults'] = 'Standaardwaarden voor activiteitsinstellingen';
$string['modsettings'] = 'Beheer activiteiten';
$string['modulesecurity'] = 'Moduleveiligheid';
$string['moodleapp'] = 'Moodle app';
$string['moodleapp_help'] = '<p>Als je een account hebt op een Moodle site, dan kun je toegang krijgen tot al je cursussen op je mobiele toestellen met een Pro of Premium app plan.</p>
<a href="https://moodle.com/mobile-app">Installeer de Moodle app</a><br />
<a href="https://apps.moodle.com">Moodle Apps Portaal-site</a>';
$string['moodlebrandedapp'] = 'Branded Moodle app';
$string['moodlebrandedapp_help'] = '<p>De Branded Moodle app heeft alle functionaliteit van de gratis moodle app voor Moodle, maar met jouw huisstijl toegevoegd.</p>
<a href="https://moodle.com/branded-app">Over de Branded Moodle app</a>';
$string['moodlebrandedappreference'] = 'Je kunt ook een  <a href="https://moodle.com/branded-app">Branded Moodle app</a>, aangepast aan je huisstijl bekomen.';
$string['moodleorghubname'] = 'Moodle';
$string['moodlepartners'] = 'Moodle Partners';
$string['moodlepartners_help'] = '<p>Moodle Partners zijn door Moodle HQ gecertificeerde dienstverleners die hoge kwaliteits Moodle dienstverlening leveren voor de online leeromgeving van jouw organisatie.</p>
<a href="https://moodle.com/about-partners/">Over onze Partners</a><br />
<a href="https://moodle.com/partners">Moodle Partner zoeken</a>';
$string['moodleservices'] = 'Moodle services';
$string['moodleservices_help'] = 'Haal het beste uit je Moodle leeromgeving door gebruik te maken van volgende Moodle services:';
$string['multilangforceold'] = 'Forceer oude multilang syntax: <span> zonder de class="multilang" en <lang>';
$string['mustenablestats'] = 'Op deze server zijn Statistieken nog uitgeschakeld';
$string['mycoursesperpage'] = 'Maximaal aantal cursussen';
$string['mydashboard'] = 'Standaard startpagina van het systeem';
$string['mymoodle'] = 'Mijn startpagina';
$string['mymoodleredirect'] = 'Mijn Moodle verplichten';
$string['mypage'] = 'Standaard "Mijn startpagina"';
$string['mypagelocked'] = 'Blokkeer standaardpagina';
$string['myprofile'] = 'Standaard profielpagina';
$string['navadduserpostslinks'] = 'Voeg links toe om gebruikersberichten te zien';
$string['navadduserpostslinks_help'] = 'Indien ingeschakeld zullen er twee links toegevoegd worden bij elke gebruiker in de navigatie om discussies te zien die zij gestart hebben en berichten die de gebruikers geplaatst heeft in forums over heel de site of in bepaalde cursussen.';
$string['navcourselimit'] = 'Cursuslimiet';
$string['navigationupgrade'] = 'Deze upgrade introduceert twee nieuwe navigatieblokken die volgende blokken zal vervangen: Beheer, cursussen, activiteiten en deelnemers. Als je op deze blokken speciale rechten had toegepast, dan moet je controleren of alles wel werkt zoals je wil.';
$string['navshowallcourses'] = 'Toon alle cursussen';
$string['navshowcategories'] = 'Toon cursuscategorieën';
$string['navshowfrontpagemods'] = 'Toon startpagina-activiteiten in de navigatie';
$string['navshowfrontpagemods_help'] = 'Indien ingeschakeld worden activiteiten op de startpagina getoond in de navigatie onder site pagina\'s';
$string['navshowfullcoursenames'] = 'Toon volledige cursusnamen';
$string['navshowfullcoursenames_help'] = 'Indien dit is ingeschakeld zullen cursussen met hun volledige naam, eerder dan met hun korte naam, in het navigatieblok getoond worden.';
$string['navshowmycoursecategories'] = 'Toon mijn cursuscategorieën';
$string['navshowmycoursecategories_help'] = 'Indien ingeschakeld worden cursus in de Mijn cursussen vertakking in categorieën getoond.';
$string['navsortmycoursessort'] = 'Sorteer mijn cursussen';
$string['navsortmycoursessort_help'] = 'Bepaalt hoe de cursussen op de Mijn cursussen-tak van de navigatie gesorteerd zullen worden. (de volgorde in Instellingen > Site beheer > Cursussen > Cursussen toevoegen/bewerken) of alfabetisch volgens cursusinstelling.';
$string['never'] = 'Nooit';
$string['neverdeleteruns'] = 'Nooit verwijderen';
$string['newestdocindexed'] = 'Nieuwste geïndexeerde document';
$string['nobookmarksforuser'] = 'Je hebt geen bladwijzers.';
$string['nodatabase'] = 'Geen databank';
$string['nohttpsformobilewarning'] = 'Aangeraden wordt om HTTPS in te schakelen met een geldig certificaat. De Moodle app zal altijd eerst proberen een beveiligde verbinding te gebruiken.';
$string['nomissingstrings'] = 'Geen ontbrekende woorden of zinnen';
$string['none'] = 'Geen';
$string['nonewsettings'] = 'Er zijn geen nieuwe instellingen toegevoegd tijdens deze upgrade';
$string['nonexistentbookmark'] = 'De bladwijzer die je vroeg, bestaat niet.';
$string['noreplyaddress'] = 'Geen antwoordadres';
$string['noreplydomain'] = 'Niet beantwoorden en domein';
$string['noreplydomaindetail'] = 'Instellingen voor niet beantwoorden en geconfigureerde domeinen';
$string['noresults'] = 'Geen resultaten gevonden';
$string['noroles'] = 'Geen rollen';
$string['nosupportedlogstore'] = 'Geen ondersteunde logstore gevonden';
$string['notifications'] = 'Meldingen';
$string['notifyloginfailures'] = 'Loginfouten mailen naar';
$string['notifyloginthreshold'] = 'Minimaal aantal fouten voor e-mailnotificatie';
$string['notloggedinroleid'] = 'Rol voor bezoekers';
$string['numberofmissingstrings'] = 'Aantal ontbrekende woorden of zinnen: {$a}';
$string['numberofstrings'] = 'Aantal woorden/zinnen: {$a->strings}<br />Ontbrekend: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'De refresh token voor één van de OAuth diensten {$a->issuer} op je site {$a->siteurl} is verlopen. Dit zal de functionaliteit van plugins die van deze service gebruik maken beperken. Bezoek om dit probleem op te lossen  de OAuth 2 Services-configuratiepagina en klik op het icoon "Verbind systeemaccount" in de tabel rij voor deze dienst. Zorg ervoor dat je iedere keer inlogt met behulp van het zelfde service-account voor het OAuth systeem.';
$string['oauthrefreshtokenexpiredshort'] = 'OAuth refresh token verlopen voor {$a->issuer} op jouw site  {$a->siteurl}.';
$string['onlynoreply'] = 'Enkel wanneer het van een niet-beantwoordenadres komt';
$string['opcacherecommended'] = 'PHP opcode caching verbetert de performantie en vermindert de geheugenvereisten. De OPcache-extentie wordt aanbevolen en volledig ondersteund.';
$string['opensslrecommended'] = 'Het installeren van de OpenSSL bibliotheek is sterk aangeraden -- het maakt Moodle Networking mogelijk.';
$string['opensslrequired'] = 'De OpenSSL PHP-extentie wordt nu door Moodle vereist om sterkere cryptografische diensten te kunnen leveren.';
$string['opentogoogle'] = 'Open voor Google';
$string['optionalmaintenancemessage'] = 'Optionele onderhoudsboodschap';
$string['order1'] = 'Eerste';
$string['order2'] = 'Tweede';
$string['order3'] = 'Derde';
$string['order4'] = 'Vierde';
$string['outgoingmailconfig'] = 'Configuratie uitgaande mail';
$string['overridetossl'] = 'HTTPS voor logins wordt niet meer gebruikt. De hele site wordt nu over SSL gestuurd. Om deze waarschuwing op te lossen, moet je je wwwroot in config.php wijzigen naar https://';
$string['pageinfodebugsummary'] = 'Deze pagina is: {$a}';
$string['passwordchangelogout'] = 'Afmelden na wijzigen van wachtwoord';
$string['passwordchangelogout_desc'] = 'Indien ingeschakeld zullen na het wijzigen van het wachtwoord alle browsersessies beëindigd worden, behalve het de sessie waarin het wachtwoord is gewijzigd. (Deze instelling heeft geen invloed op wijzigen van het wachtwoord via het in bulk uploaden van gebruikers.)';
$string['passwordchangetokendeletion'] = 'Verwijder toegangstokens van webservice na wijzigen wachtwoord';
$string['passwordchangetokendeletion_desc'] = 'Indien ingeschakeld worden alle webservicetokens van de gebruiker verwijderd bij het wijzigen van een wachtwoord.';
$string['passwordpolicy'] = 'Wachtwoordbeleid';
$string['passwordresettime'] = 'Maximumtijd om een wachtwoordreset te valideren';
$string['passwordreuselimit'] = 'Wachtwoord rotatielimiet';
$string['passwordreuselimit_desc'] = 'Aantal keer dat een gebruiker zijn wachtwoord moet wijzigen voor ze eenzelfde wachtwoord opnieuw mogen gebruiken. Versleutelde versies van de oude wachtwoorden worden bewaard in de lokale databank. Deze functie kan niet compatibel zijn met externe authenticatieplugins.';
$string['pathtodot'] = 'Pad naar dot';
$string['pathtodot_help'] = 'Pad naar dot. Waarschijnlijk iets als /usr/bin/dot. Op Windows is het iets zoals C:\\Program Files (x86)\\Graphviz2.38\\bin\\dot.exe. Op Mac is het iets zoals /opt/local/bin/dot. Dit maakt het mogelijk om grafische bestanden te maken van DOT-bestanden. Je hebt ook het uitvoerbare bestand dot nodig en je moet hier opgeven waar het op je server te vinden is.';
$string['pathtodu'] = 'Pad naar du';
$string['pathtogs'] = 'Pad naar ghostscript';
$string['pathtogs_help'] = 'Op de meeste Linux-servers mag dit blijven staan als \'/usr/bin/gs\'. Op een Windows-server zal het eerder iets zijn als \'c:\\gs\\bin\\gswin32c.exe\' (zorg er voor dat er geen spaties voorkomen in het pad - kopieer indien nodig de bestanden \'gswin32c.exe\' en \'gsdll32.dll\' naar een nieuwe map zonder spatie in het pad)';
$string['pathtopgdump'] = 'Pad naar pg_dump';
$string['pathtopgdumpdesc'] = 'Je moet dit enkel ingeven als je meer dan één pg_dump op je systeem hebt (bijvoorbeeld als je meer dan één versie van postgresql geïnstalleerd hebt)';
$string['pathtopgdumpinvalid'] = 'Ongeldig pad naar pg_dump - ofwel verkeerd pad of niet uitvoerbaar';
$string['pathtophp'] = 'Pad naar PHP CLI';
$string['pathtopsql'] = 'Pad naar psql';
$string['pathtopsqldesc'] = 'Dit is enkel nodig als je meer dan één psql op je systeem hebt (bijvoorbeeld als je meer dan één versie van postgresql geïnstalleerd hebt)';
$string['pathtopsqlinvalid'] = 'Ongeldig pad naar psql - ofwel verkeerd pad ofwel niet uitvoerbaar';
$string['pathtopython'] = 'Pad naar Python';
$string['pathtopythondesc'] = 'Pad naar je executable Python binary (zowel Python 2 als Python 3 kunnen gebruikt worden).';
$string['pathtosassc'] = 'Pad naar SassC';
$string['pathtosassc_help'] = 'Door de locatie van het SassC-binaire bestand op te geven, wordt de SASS-compiler omgeschakeld van Moodle\'s PHP-implementatie naar SassC. Zie https://github.com/sass/sassc voor meer informatie.';
$string['pcreunicodewarning'] = 'Het wordt sterk aangeraden om de PCRE PHP-extentie te gebruiken die compatibel is met Unicode tekens';
$string['perfdebug'] = 'Performantie-informatie';
$string['performance'] = 'Prestaties';
$string['pgcluster'] = 'PostgreSQL Cluster';
$string['pgclusterdescription'] = '<pre>PostgeSQL versie/cluster parameter voor operaties via commandprompt. Als je slechts één PostgreSQL op je systeem hebt of je weet niet wat dit is, laat dit veld dan leeg.</pre>';
$string['phpfloatproblem'] = 'Onverwacht probleem gevonden bij het behandelen van PHP float numbers - {$a}';
$string['pleaserefreshregistration'] = 'Je site is geregistreerd bij moodle.org. Je registratie is het laatst bijgewerkt op {$a}.<br />De site-registratietaak houdt je registratie up-to-date. Je kunt op elk moment ook manueel je registratie bijwerken.';
$string['pleaserefreshregistrationnewdata'] = 'De registratie-informatie is gewijzigd. Bevestig deze door op de "Registratie aanpassen"-knop te klikken.';
$string['pleaserefreshregistrationunknown'] = 'Je site is geregistreerd, maar de registratiedatum is onbekend. Update je registratie door de \'Update registratie\'-knop te gebruiken of door je te verzekeren dat de \'Site registratie\' geplande taak is ingesteld, zodat je registratie automatisch wordt aangepast.';
$string['plugin'] = 'Module';
$string['plugins'] = 'Plugins';
$string['pluginscheck'] = 'Controle plugin-afhankelijkheden';
$string['pluginscheckfailed'] = 'Afhankelijkheidscontrole mislukt voor {$a->pluginlist}';
$string['pluginschecktodo'] = 'Je moet eerst alle pluginvereisten oplossen voor je verder kunt gaan met het installeren van deze Moodleversie!';
$string['pluginsoverview'] = 'Overzicht plugins';
$string['pluginsoverviewsee'] = 'Zie <a href="{$a->url}">pluginoverzichtspagina</a> voor meer details.';
$string['policysettings'] = 'Beleidsinstellingen';
$string['privacyandpolicies'] = 'Privacy en beleid';
$string['privacy:metadata'] = 'De beheer-plugin bewaart geen persoonlijke gegevens.';
$string['privacysettings'] = 'Privacy-instellingen';
$string['profilecategory'] = 'Categorie';
$string['profilecategoryname'] = 'Categorienaam (moet uniek zijn)';
$string['profilecategorynamenotunique'] = 'Deze categorienaam is al in gebruik';
$string['profilecommonsettings'] = 'Algemene instellingen';
$string['profileconfirmcategorydeletion'] = 'Er is/zijn {$a} veld(en) in deze categorie die naar de bovenliggende categorie verplaats zullen worden (of lager als ze in de bovenste categorie zijn).<br />Wil je nog steeds deze categorie verwijderen?';
$string['profileconfirmfielddeletion'] = 'Er is/zijn {$a} gebruikersrecord(s) voor dit veld die verwijderd zullen worden.<br />Wil je nog steeds dit veld verwijderen?';
$string['profilecreatecategory'] = 'Maak een nieuwe profielcategorie';
$string['profilecreatefield'] = 'Maak een nieuw profielveld';
$string['profilecreatenewcategory'] = 'Nieuwe categorie maken ...';
$string['profilecreatenewfield'] = 'Nieuw "{$a}" profielveld maken';
$string['profiledefaultcategory'] = 'Andere velden';
$string['profiledefaultchecked'] = 'Standaard gecontroleerd';
$string['profiledefaultdata'] = 'Standaardwaarde';
$string['profiledeletecategory'] = 'Categorie verwijderen...';
$string['profiledeletefield'] = 'Veld "{$a}" verwijderen...';
$string['profiledescription'] = 'Veldbeschrijving';
$string['profiledscript'] = 'Dit script is al geprofiled';
$string['profiledscriptview'] = 'Bekijk profiling-informatie voor dit script';
$string['profileeditcategory'] = 'Bewerk categorie: {$a}';
$string['profileeditfield'] = 'Bewerk profielveld: {$a}';
$string['profilefield'] = 'Profielveld';
$string['profilefieldcolumns'] = 'Kolommen';
$string['profilefieldispassword'] = 'Is dit een wachtwoordveld?';
$string['profilefieldlink'] = 'Link';
$string['profilefieldlink_help'] = 'Om tekst om te vormen in een link, geef je een URL in die $$ bevat, waar $$ vervangen zal worden door de tekst. Om bijvoorbeeld een Twitter ID om te zetten in een link, typ je https://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Link doel';
$string['profilefieldmaxlength'] = 'Maximale lengte';
$string['profilefieldrows'] = 'Rijen';
$string['profilefields'] = 'Profielvelden';
$string['profilefieldsize'] = 'Schermgrootte';
$string['profileforceunique'] = 'Moeten de gegevens uniek zijn?';
$string['profileinvaliddata'] = 'Ongeldige waarde';
$string['profilelocked'] = 'Is dit veld geblokkeerd?';
$string['profilemenudefaultnotinoptions'] = 'De standaardwaarde is niet één van deze opties';
$string['profilemenunooptions'] = 'Geen menuopties voorzien';
$string['profilemenuoptions'] = 'Menuopties (één per lijn)';
$string['profilemenutoofewoptions'] = 'Je moet minstens 2 opties geven';
$string['profilename'] = 'Naam';
$string['profilenofieldsdefined'] = 'Er zijn nog geen velden gedefinieerd';
$string['profilerequired'] = 'Is dit veld vereist?';
$string['profileroles'] = 'Rollen voor zichtbaar profiel';
$string['profilesforenrolledusersonly'] = 'Profielen alleen voor aangemelde gebruikers';
$string['profileshortname'] = 'Korte naam (moet uniek zijn)';
$string['profileshortnameinvalid'] = 'De korte naam mag alleen alphanumerieke tekens (letters en cijfers) of een underscore (_) bevatten.';
$string['profileshortnamenotunique'] = 'Deze korte naam is al in gebruik';
$string['profilesignup'] = 'Tonen op inschrijvingspagina?';
$string['profilespecificsettings'] = 'Specifieke instellingen';
$string['profilevisible'] = 'Voor wie is dit veld zichtbaar?';
$string['profilevisibleall'] = 'Zichtbaar voor iedereen';
$string['profilevisible_help'] = '<p>Elk eigen profielveld kan drie mogelijke instellingen hebben voor wie het veld kan zien: onzichtbaar, iedereen of gebruiker. Deze keuze wordt gemaakt door een beheerder die privégegevens van de gebruikers wil bewaren. \'Gebruiker\' wordt meestal gekozen wanneer dat veld gevoelige informatie bevat, terwijl \'iedereen\' gekozen wordt voor andere informatie.</p>';
$string['profilevisiblenone'] = 'Niet zichtbaar';
$string['profilevisibleprivate'] = 'Zichtbaar voor gebruiker';
$string['profiling'] = 'Profiling';
$string['profilingallowall'] = 'Continu profilen';
$string['profilingallowall_help'] = 'Als je deze instelling inschakelt, dan kun je altijd gebruik maken van de PROFILEALL parameter (PGC) om profiling in te schakelen voor alle uitgevoerde scripts tijdens de duur van je Moodlesessie. Analoog kun je de PROFILEALLSTOP parameter gebruiken om het te stoppen';
$string['profilingallowme'] = 'Selectief profilen';
$string['profilingallowme_help'] = 'Als je deze instelling inschakelt, dan kun je gebruik maken van de PROFILEME parameter (PGC) om profiling in te schakelen voor een script. Analoog kun je de DONTPROFILEME parameter gebruiken om het te stoppen';
$string['profilingautofrec'] = 'Automatisch profilen';
$string['profilingautofrec_help'] = 'Door deze instelling te configureren, zullen sommige requests (willekeurig, gebaseerd op de opgegeven frequentie - 1 van N) er uitgekozen worden en automatisch geprofiled worden, waarbij de resultaten voor verdere analyse bewaard worden. Merk op dat deze manier van profilen de include/exclude instellingen bekijkt. Zet dit op 0 om automatisch profilen uit te schakelen.';
$string['profilingenabled'] = 'Profilen inschakelen';
$string['profilingenabled_help'] = 'Als je deze instelling inschakelt, dan zal profiling op deze site mogelijk zijn en zul je het gedrag ervan kunnen bepalen met onderstaande opties.';
$string['profilingexcluded'] = 'Profilen uitsluiten';
$string['profilingexcluded_help'] = 'Lijst met URL\'s (kommagescheiden, absoluut wwwroot overslaan, aanroepbaar) die uitgesloten zullen worden van diegene die met de \'Profile deze\' instelling gedefinieerd worden.';
$string['profilingimportprefix'] = 'Profiling import prefix';
$string['profilingimportprefix_desc'] = 'Om gemakkelijker terug te vinden krijgen alle profiling runs de hier opgegeven waarde als prefix.';
$string['profilingincluded'] = 'Profile deze';
$string['profilingincluded_help'] = 'Lijst met URL\'s (kommagescheiden, absoluut wwwroot overslaan, aanroepbaar) die automatisch geprofiled zullen worden. Voorbeelden: /index.php,/course/view.php. Ook het jokerteken * wordt aanvaard op elke plaats. Voorbeelden: /mod/forum/*,/mod/*/viep.php';
$string['profilinglifetime'] = 'Profile runs behouden';
$string['profilinglifetime_help'] = 'Bepaal hoe lang je informatie over oude profile runs wil behouden. Oude runs zullen automatisch verwijderd worden. Merk op dat dit niet zal gebeuren voor runs die als \'reference run\' gemarkeerd worden.';
$string['profilingslow'] = 'Profiel langzame pagina\'s';
$string['profilingslow_help'] = 'Door een minimumtijd in seconden in te stellen, worden alle pagina\'s geprofileerd. Alleen profielen die langzamer zijn dan een bestaand profiel voor hetzelfde script blijven behouden. Stel in op 0 om uit te schakelen. Merk op dat dit de uitsluitingsinstellingen waarneemt.';
$string['protectusernames'] = 'Bescherm gebruikersnamen';
$string['proxybypass'] = 'Proxy bypass hosts';
$string['proxyhost'] = 'Proxyserver';
$string['proxypassword'] = 'Proxy wachtwoord';
$string['proxyport'] = 'Proxy poort';
$string['proxytype'] = 'Proxy type';
$string['proxyuser'] = 'Proxy gebruikersnaam';
$string['purgecaches'] = 'Alle caches leegmaken';
$string['purgecachesconfirm'] = 'Moodle kan thema\'s cachen, javascript, taalstrings, gefilterde tekst, rss-feeds en veel andere stukken berekende gegevens. Het leegmaken van deze caches zal alle gegevens verwijderen van de server en zal browsers forceren om de gegevens te verversen, zodat je er zeker kan van zijn dat de meest recente waardes die je huidige code produceert, getoond worden. Er is geen gevaar verbonden aan het verwijderen van caches, maar je server kan trager lijken tot je server en de clients de nieuwe informatie berekend en gecached hebben.';
$string['purgecachesfinished'] = 'Alle caches zijn leeggemaakt.';
$string['purgecachesnoneselected'] = 'Selecteer één of meer caches om leeg te maken';
$string['purgecachespage'] = 'Caches leegmaken';
$string['purgefiltercache'] = 'Tekstfilters';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Taalstrings';
$string['purgemuc'] = 'Alle MUC-caches';
$string['purgeothercaches'] = 'Alle bestand en diverse caches';
$string['purgeselectedcaches'] = 'Maak geselecteerde caches leeg';
$string['purgeselectedcachesfinished'] = 'De geselecteerde caches zijn leeggemaakt.';
$string['purgethemecache'] = 'Thema\'s';
$string['query'] = 'Zoekopdracht';
$string['question'] = 'Vragen';
$string['questionbehaviours'] = 'Gedrag vragen';
$string['questioncwqpfscheck'] = 'Eén of meer willekeurige vragen in een test zijn insgesteld om vragen te kiezen uit gedeelde en niet gedeelde vragencategorieën. Er is een meer gedetailleerd rapport <a href="{$a->reporturl}">hier</a> en je kunt de Moodle Docs-pagina <a href="{$a->docsurl}">hier</a> bekijken.';
$string['questioncwqpfsok'] = 'Goed. Er zijn geen willekeurige vragen in je testen die opgemaakt zijn om vragen uit zowel gedeelde als niet gedeelde vragencategorieën te kiezen.';
$string['questiontype'] = 'Vraagtype';
$string['questiontypes'] = 'Vraagtypes';
$string['quizattemptsupgradedmessage'] = 'In Moodle 2.1 was eer een grote upgrade van de vragen. Het was toen mogelijk om delen van de databankupgrade uit te stellen tot later. Voor je kunt upgraden naar Moodle 2.7 moet deze upgrade volledig uitgevoerd zijn.';
$string['recaptchaprivatekey'] = 'ReCAPTCHA geheime sleutel';
$string['recaptchapublickey'] = 'ReCAPTCHA site-sleutel';
$string['register'] = 'Registreer je site';
$string['registermoodlenet'] = '<p>We zouden graag contact met je kunnen opnemen als er belangrijke zaken te melden zijn over jouw Moodle site! </p><p>Door te registreren</p><ul><li>kun je inschrijvingen om belangrijke berichten zoals beveiligingswaarschuwingen en nieuwe Moodle releases te krijgen</li><li>krijg je toegang tot ons systeem om push-meldingen te activeren vanaf jouw Moodle-site via de gratis<a href="https://download.moodle.org/mobile/">Moodle Mobile app</a>.</li><li>draag je bij aan onze <a href="https://moodle.net/stats/">Moodle statistics</a> van de internationale community, die ons helpt om Moodle en onze community sites te verbeteren</li><li>kan je optioneel je site laten opnemen op de  <a href="https://moodle.net/sites/">lijst met geregistreerde sites</a> in jouw land.</li></ul>';
$string['registermoodleorg'] = 'Wanneer je je site registreert';
$string['registermoodleorgli1'] = 'Je wordt toegevoegd aan een laag-volume mailinglijst voor belangrijke berichten in verband met veiligheidsproblemen en nieuwe Moodleversies.';
$string['registermoodleorgli2'] = 'Statistieken over je site zullen aan {$a} van de wereldwijde Moodlegemeenschap toegevoegd worden.';
$string['registerwithmoodleorg'] = 'Registreer je site';
$string['registration'] = 'Registratie';
$string['registration_help'] = 'Door te registreren:

* krijg je beveiligingsmeldingen
* kun je de mobile app push-meldingen activeren voor jouw site
* draag je bij aan onze Moodle-statistieken over de wereldwijde gebruikersgemeenschap';
$string['registrationwarning'] = 'Je site is nog niet geregistreerd.';
$string['registrationwarningcontactadmin'] = 'Je site is nog niet geregistreerd. Gelieve contact op te nemen met je sitebeheerder.';
$string['releasenoteslink'] = 'Bekijk de online <a target="_new" href="{$a}">Release Notes</a> voor informatie over deze versie van Moodle.';
$string['rememberusername'] = 'Gebruikersnaam onthouden';
$string['rememberusername_desc'] = 'Schakel dit in als je permanente cookies wil bewaren met de gebruikersnaam tijdens het aanmelden. Permanente cookies kunnen een privacyprobleem stellen als ze niet met zorg gebruikt worden.';
$string['reportsmanage'] = 'Beheer rapporten';
$string['requestcategoryselection'] = 'Categorieselectie inschakelen';
$string['requiredentrieschanged'] = 'Opmerking: na upgraden is de instellinge  \'Vereiste items voor bekijken\' nu verplicht in volgende database activiteiten:<br />{$a->text}<br/>';
$string['requiremodintro'] = 'Beschrijving van de activiteit vereist';
$string['requiremodintro_desc'] = 'Schakel deze optie in als je je gebruikers wil dwingen om een beschrijving te geven bij elke activiteit.';
$string['requires'] = 'Vereist';
$string['restorecourse'] = 'Cursus terugzetten';
$string['restorernewroleid'] = 'De rol in cursussen van degene die een back-up terugzet';
$string['restorernewroleid_help'] = 'Als de gebruiker nog geen toestemming heeft om de pas teruggezette cursus te beheren, dan krijgt de gebruiker automatisch deze rol en wordt aangemeld indien nodig. Selecteer "Geen" als u niet wil dat diegenen die de cursus hebben teruggezet nog wijzigingen mogen aanbrengen.';
$string['resultfilter'] = 'Filter op resultaat';
$string['reverseproxy'] = 'Reverse proxy';
$string['reverseproxyignore'] = 'Negeer reverse proxies';
$string['riskconfig'] = 'Gebruikers zouden de configuratie en het gedrag van de site kunnen wijzigen';
$string['riskconfigshort'] = 'Configuratierisico';
$string['riskdataloss'] = 'Gebruikers zouden grote hoeveelheden inhoud of informatie kunnen vernietigen';
$string['riskdatalossshort'] = 'Risico op dataverlies';
$string['riskmanagetrust'] = 'Gebruikers kunnen vertrouwelijke instellingen van anderen wijzigen';
$string['riskmanagetrustshort'] = 'Beheer vertrouwensrelaties';
$string['riskpersonal'] = 'Gebruikers kunnen toegang krijgen tot privé-informatie van andere gebruikers';
$string['riskpersonalshort'] = 'Privacy-risico';
$string['riskspam'] = 'Gebruikers kunnen spam sturen naar sitegebruikers of anderen';
$string['riskspamshort'] = 'Spam-risico';
$string['riskxss'] = 'Gebruikers kunnen bestanden en teksten toevoegen die  cross-site scripting (XSS) mogelijk maken.';
$string['riskxssshort'] = 'XSS-risico';
$string['roleswithexceptions'] = '{$a->roles}, met {$a->exceptions}';
$string['rssglobaldisabled'] = 'Uitgeschakeld op site-niveau';
$string['save'] = 'Bewaar';
$string['savechanges'] = 'Bewaar wijzigingen';
$string['scssinvalid'] = 'SCSS code is niet geldig, mislukt met: {$a}';
$string['search'] = 'Zoek';
$string['searchablecourses'] = 'Doorzoekbare cursussen';
$string['searchallavailablecourses'] = 'Doorzoekbare cursussen';
$string['searchallavailablecoursesdesc'] = 'Indien ingesteld om alleen binnen ingeschreven cursussen te zoeken, worden cursusinformatie en cursusinhoud alleen doorzocht in cursussen waarin de gebruiker is aangemeld. Anders worden cursusinformatie en cursusinhoud doorzocht in alle cursussen waartoe de gebruiker toegang heeft, zoals cursussen waarvoor gasttoegang is ingeschakeld.';
$string['searchallavailablecourses_desc'] = 'Soms werkt de zoekfunctie niet wanneer je zeer grote aantallen cursussen doorzoekt. Doorzoek alleen aangemelde cursussen wanneer je het aantal doorzochte cursussen moet verminderen.';
$string['searchallavailablecourses_off'] = 'Zoek alleen binnen aangemelde cursussen';
$string['searchallavailablecourses_on'] = 'Zoek binnen alle cursussen waartoe de gebruiker toegang heeft';
$string['searchalldeleted'] = 'Alle geïndexeerde inhoud is verwijderd';
$string['searchareadisabled'] = 'Zoekzone uitgeschakeld';
$string['searchareaenabled'] = 'Zoekzone ingeschakeld';
$string['searchareas'] = 'Zoekzones';
$string['searchdefaultcategory'] = 'Standaard zoek categorieën';
$string['searchdefaultcategory_desc'] = 'Resultaten van de geselecteerde zoekgebiedcategorie worden standaard weergegeven.';
$string['searchdeleteindex'] = 'Verwijder alle geïndexeerde inhoud';
$string['searchdisplay'] = 'Weergave-opties voor zoekresultaten';
$string['searchenablecategories'] = 'Resultaten tonen in gescheiden categorieën';
$string['searchenablecategories_desc'] = 'Indien ingeschakeld worden zoekresultaten in gescheiden categorieën getoond.';
$string['searchengine'] = 'Zoekmachine';
$string['searchhideallcategory'] = 'Verberg categorie Alle resultaten';
$string['searchhideallcategory_desc'] = 'Indien aangevinkt, zal de categorie met alle resultaten worden verborgen op het scherm met zoekresultaten.';
$string['searchincludeallcourses'] = 'Voeg alle zichtbare cursussen toe';
$string['searchincludeallcourses_desc'] = 'Indien ingeschakeld, bevatten de zoekresultaten cursusinformatie (naam en samenvatting) die zichtbaar is voor de gebruiker, zelfs als ze geen toegang hebben tot de cursusinhoud.';
$string['searchindexactions'] = 'Index acties';
$string['searchindexdeleted'] = 'Index verwijderd';
$string['searchindextime'] = 'Limiet op indexeringstijd';
$string['searchindextime_desc'] = 'Wanneer er veel nieuwe inhoud geïndexeerd moet worden, zal deze geplande taak stoppen nadat deze tijd verstreken is. Er wordt verder gegaan de volgende keer dat de taak loopt.';
$string['searchindexupdated'] = 'Inhoud zoekmachine is aangepast';
$string['searchindexwhendisabled'] = 'Indexeer wanneer uitgeschakeld';
$string['searchindexwhendisabled_desc'] = 'Staat de geplande taak toe om een zoekindex op te bouwen zelfs wanneer zoeken is uitgeschakeld. Dit is nuttig als de de index wil opbouwen voor die zoekmogelijkheden verschijnen voor de leerlingen.';
$string['searchinsettings'] = 'Zoek in instellingen';
$string['searchlastrun'] = 'Laatst gelopen (keren; # docs,  # records, # genegeerd)';
$string['searchnotavailable'] = 'Zoeken is niet beschikbaar';
$string['searchoptions'] = 'Zoekopties';
$string['searchpartial'] = '(nog niet volledig geïndexeerd)';
$string['searchreindexed'] = 'Alle site-inhoud is opnieuw geïndexeerd';
$string['searchreindexindex'] = 'Indexeer alle site-inhoud opnieuw';
$string['searchresults'] = 'Zoekresultaten';
$string['searchsetupinfo'] = 'Zoek instellen';
$string['searchupdateindex'] = 'Pas geïndexeerde inhoud aan';
$string['sectionerror'] = 'Sectiefout!';
$string['secureforms'] = 'Gebruik bijkomende formulierbeveiliging';
$string['security'] = 'Veiligheid';
$string['selectdevice'] = 'Selecteer toestel';
$string['selectsearchengine'] = 'Selecteer zoekmachine';
$string['selecttheme'] = 'Selecteer thema voor {$a} toestel';
$string['server'] = 'Server';
$string['serverchecks'] = 'Servercontroles';
$string['serverlimit'] = 'Serverlimiet';
$string['sessionautostartwarning'] = '<p>Belangrijke configuratiefout gedetecteerd, waarschuw de systeembeheerder.</p><p> Moodle vereist dat de beheerder de php-instellingen wijzigt om goed te kunnen werken.</p><p><code>session.auto_start</code> moet ingesteld zijn op <code>off</code>.</p><p>Deze instelling kan gewijzigd worden door <code>php.ini</code>, Apache/IIS <br />configuratie of het <code>.htaccess</code> bestand op de server te wijzigen.</p>';
$string['sessioncookie'] = 'Cookie prefix';
$string['sessioncookiedomain'] = 'Cookie domein';
$string['sessioncookiepath'] = 'Cookie pad';
$string['sessionhandling'] = 'Sessie afhandeling';
$string['sessiontimeout'] = 'Timeout';
$string['settingdependenton'] = 'Deze instelling is mogelijk verborgen, dit is vanwege de waarde bij <strong>{$a}</strong>.';
$string['settingfileuploads'] = 'Het uploaden van bestanden is vereist voor het normaal functioneren van Moodle. Schakel het in in je PHP-configuratie.';
$string['settingmemorylimit'] = 'Onvoldoende geheugen gedetecteerd. Zet de geheugenlimiet hoger in je PHP-instellingen.';
$string['settingsafemode'] = 'Moodle is niet volledig compatibel met safe mode. Vraag je serverbeheerder om het uit te schakelen. Moodle draaien met safe mode ingeschakeld wordt niet ondersteund - je kunt je aan verschillende problemen verwachten.';
$string['setupsearchengine'] = 'Zoekmachine instellen';
$string['showcommentscount'] = 'Toon aantal commentaren';
$string['showdetails'] = 'Toon details';
$string['showuseridentity'] = 'Toon de identiteit van de gebruiker';
$string['showuseridentity_desc'] = 'Bij het selecteren of het zoeken naar gebruikers, en bij het tonen van lijsten van gebruikers, kunnen deze velden getoond worden in aanvulling op hun naam. De velden worden alleen getoond aan gebruikers die beschikken over de moodle/site:viewuseridentity capability; normaal gezien leraren en managers. (Deze optie is het meest zinvol als u één of twee velden kiest die verplicht zijn in uw instelling.)';
$string['simplexmlrequired'] = 'De SimpleXML PHP-extentie is nu vereist voor Moodle.';
$string['sitemailcharset'] = 'Tekenset';
$string['sitemaintenance'] = 'De site is in onderhoud en is op dit ogenblik niet beschikbaar';
$string['sitemaintenancemode'] = 'Onderhoudsmodus';
$string['sitemaintenanceoff'] = 'De onderhoudsmodus is uitgeschakeld en de site loopt nu terug normaal';
$string['sitemaintenanceon'] = 'Je site is nu in onderhoudsmodus (alleen beheerders kunnen inloggen of gebruik maken van de site)';
$string['sitemaintenanceoncli'] = 'Je site loopt in CLI onderhoudsmodus. Toegang via de webinterface is niet mogelijk.';
$string['sitemaintenancewarning'] = 'Je site is nu in onderhoudsmodus (alleen beheerders kunnen inloggen of gebruik maken van de site). Om terug te keren naar normale werking: <a href="maintenance.php">onderhoudsmodus uitschakelen</a>';
$string['sitemaintenancewarning2'] = 'Je site is in onderhoudsmodus (enkel beheerders kunnen inloggen). <a href="{$a}">Schakel onderhoudsmodus uit</a> om de site terug normaal te laten werken';
$string['sitemenubar'] = 'Site-navigatie';
$string['sitepolicies'] = 'Site beveiligingsinstellingen';
$string['sitepolicy'] = 'URL voor site afspraken';
$string['sitepolicyguest'] = 'Site reglement URL voor gasten';
$string['sitepolicyguest_help'] = 'De URL die alle gasten moeten zien voor ze de site gebruiken. Merk op dat deze instelling enkel effect zal hebben als het beheer  van het site-beleid op standaardinstellingen staat (core).';
$string['sitepolicyhandler'] = 'Beheerder sitereglement';
$string['sitepolicyhandlercore'] = 'Standaard (kern)';
$string['sitepolicyhandler_desc'] = 'Dit bepaalt hoe beleid en toestemmingen van gebruikers worden beheerd. De standaard (kern) beheerder maakt het mogelijk om een site-beleid voor gebruikers en voor gasten afzonderlijk te specificeren. De beleidsbeheerder maakt het mogelijk om site, privacy en ander beleid in te stellen. Het maakt het ook mogelijk om gebruikerstoestemmingen te bekijken en, indien nodig, toestemmingen te geven voor minderjarigen.';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitepolicy_help'] = 'De URL voor het site-beleid die alle gebruikers moeten zien en mee akkoord gaan om toegang te krijgen tot de site. Merk op dat al deze instellingen enkel een effect zullen hebben als het site beleidsbeheer op standaard staat (core).';
$string['sitesectionhelp'] = 'Indien gekozen wordt er een onderwerpsectie getoond op de startpagina van de site';
$string['sixtyfourbitswarning'] = 'Er is gedetecteerd dat uw site geen 64-bits PHP-versie gebruikt. Het wordt aanbevolen dat u uw site bijwerkt om toekomstige compatibiliteit te garanderen.';
$string['slasharguments'] = 'Gebruik slash arguments';
$string['slashargumentswarning'] = 'Je kunt best het gebruik van  "slash arguments" inschakelen. Het wordt een vereiste instelling in de toekomst. Meer details in de documentatie op  <a href="https://docs.moodle.org/en/admin/environment/slasharguments">Using slash arguments</a>.';
$string['smartpix'] = 'Slim afbeeldingen zoeken';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'SMTP auth type';
$string['smtpdetail'] = 'Simple Mail Transfer Protocol (SMTP) instellingen voor het versturen van e-mail';
$string['smtphosts'] = 'SMTP hosts';
$string['smtpmaxbulk'] = 'SMTP-sessie limiet';
$string['smtppass'] = 'SMTP wachtwoord';
$string['smtpsecure'] = 'SMTP beveiliging';
$string['smtpuser'] = 'SMTP gebruikersnaam';
$string['soaprecommended'] = 'Het installeren van de optionele SOAP-extentie is nuttig voor webservices en sommige modules uit contrib.';
$string['sort_fullname'] = 'Volledige naam cursus';
$string['sort_idnumber'] = 'ID-nummer cursus';
$string['sort_shortname'] = 'Korte naam cursus';
$string['sort_sortorder'] = 'Sorteervolgorde';
$string['spellengine'] = 'spellingscorrector';
$string['spelllanguagelist'] = 'Taallijst voor spelling';
$string['splrequired'] = 'De SPL PHP-extentie is nu vereist voor Moodle';
$string['stats'] = 'Statistieken';
$string['statsfirstrun'] = 'Maximaal verwerkingsinterval';
$string['statsmaxruntime'] = 'Maximale verwerktijd';
$string['statsmoodleorg'] = 'statistieken';
$string['statsruntimedays'] = 'Aantal te verwerken dagen';
$string['statsruntimestart'] = 'Start om';
$string['statsuserthreshold'] = 'Gebruikermarge';
$string['stickyblocks'] = 'Permanent blok';
$string['stickyblockscourseview'] = 'Cursuspagina';
$string['stickyblocksduplicatenotice'] = 'Als je hier een blok toevoegt dat al op een bepaalde pagina staat, krijg je er twee.<br />Alleen het vastgezette blok zul je niet kunnen bewerken, het tweede zul je wel kunnen bewerken.';
$string['stickyblocksmymoodle'] = 'Mijn Moodle';
$string['stickyblockspagetype'] = 'Te configureren paginatype';
$string['strictformsrequired'] = 'Strikte validatie van vereiste velden';
$string['stripalltitletags'] = 'Verwijder HTML-tags van alle activiteitsnamen';
$string['supportcontact'] = 'Helpdesk';
$string['supportemail'] = 'E-mail helpdesk';
$string['supportname'] = 'Naam helpdesk';
$string['supportpage'] = 'URL helpdesk';
$string['suspenduser'] = 'Schors gebruikersaccount';
$string['switchlang'] = 'Wissel map voor taalbestanden';
$string['systempaths'] = 'Systeempaden';
$string['tablenosave'] = 'Wijzigingen in bovenstaande tabel worden automatisch bewaard.';
$string['tablesnosave'] = 'Wijzigingen in bovenstaande tabellen worden automatisch bewaard.';
$string['tabselectedtofront'] = 'Moet bij tabellen met tabs de nu geselecteerde tab vooraan gezet worden?';
$string['tabselectedtofronttext'] = 'Breng de rij van de geselecteerde tab naar voor';
$string['task_adhoc_concurrency_limit'] = 'Limiet van lopende niet geplande taken';
$string['task_adhoc_concurrency_limit_desc'] = 'Het aantal niet geplande taken dat tegelijkertijd mag worden uitgevoerd. Als de limiet hoog is, dan zou het kunnen dat geplande taken niet regelmatig lopen wanneer er veel niet geplande taken zijn. Een instelling van 0 schakelt het verwerken van niet geplande taken volledig uit.';
$string['task_adhoc_max_runtime'] = 'De levensduur van een niet geplande taak';
$string['task_adhoc_max_runtime_desc'] = 'De levensduur van een niet geplande taak voordat deze vrij komt. Het advies is een korte levensduur aan te houden omdat er geen limiet is aan het aantal niet geplande taken die in de wachtrij kunnen staan. Wanneer de levensduur te hoog is en je hebt een groot aantal niet geplande taken, dan zullen de geplande taken niet regelmatig draaien.';
$string['taskadmintitle'] = 'Taken';
$string['taskanalyticscleanup'] = 'Analytics opruimen';
$string['taskautomatedbackup'] = 'Automatische backups';
$string['taskbackupcleanup'] = 'Backuptabellen en logs leeg maken';
$string['taskbadgescron'] = 'Badges toekennen';
$string['taskbadgesmessagecron'] = 'Achtergrond proces voor het sturen van badge notificaties';
$string['taskblogcron'] = 'Externe blogs synchroniseren';
$string['taskcachecleanup'] = 'Verwijder verlopen cache-items';
$string['taskcachecron'] = 'Achtergrondbewerkingen voor cache';
$string['taskcalendarcron'] = 'Stuur kalendermeldingen';
$string['taskcheckforupdates'] = 'Controleer op updates';
$string['taskcompletiondaily'] = 'Voltooiing als begonnen gemarkeerd.';
$string['taskcompletionregular'] = 'Bereken algemene voltooiingsgegevens';
$string['taskcontextcleanup'] = 'Contexts opruimen';
$string['taskcreatecontexts'] = 'Ontbrekende contexts maken';
$string['task_dbstats'] = 'Databank';
$string['taskdeletecachetext'] = 'Oude tekst cache records verwijderen';
$string['taskdeleteincompleteusers'] = 'Onvolledige gebruikersaccounts verwijderen';
$string['taskdeleteunconfirmedusers'] = 'Onbevestigde gebruikersaccounts verwijderen';
$string['task_duration'] = 'Tijdsduur';
$string['taskeventscron'] = 'Achtergrondprocessen voor gebeurtenissen';
$string['taskfiletrashcleanup'] = 'Bestanden in prullenbak opruimen';
$string['taskglobalsearchindex'] = 'Globaal zoeken indexeren';
$string['taskglobalsearchoptimize'] = 'Globaal zoeken index optimalisatie';
$string['taskgradecron'] = 'Achtergrondprocessen voor cijferlijst';
$string['taskgradehistorycleanup'] = 'Achtergrond proces voor het opschonen van cijferlijst historische tabellen';
$string['tasklegacycron'] = 'Verouderde cronverwerking voor plugins';
$string['tasklogcleanup'] = 'Taaklogs opruimen';
$string['tasklogging'] = 'Taaklog configuratie';
$string['task_logmode'] = 'Wanneer te loggen';
$string['task_logmode_all'] = 'Bewaar de log output van alle taken';
$string['task_logmode_desc'] = 'Je kunt kiezen wanneer u wilt dat taakregistratie plaatsvindt. Standaard worden logs altijd vastgelegd. Je kunt het loggen volledig uitschakelen of alleen logboektaken wijzigen die mislukken.';
$string['task_logmode_failonly'] = 'Bewaar alleen de logs van taken die mislukken';
$string['task_logmode_none'] = 'Niets loggen';
$string['task_logretainruns'] = 'Runs behouden';
$string['task_logretainruns_desc'] = 'Het aantal runs van elke taak dat behouden moet blijven. Deze instelling werkt samen met de instelling \'Bewaarperiode\': wat het eerst wordt bereikt, is van toepassing.';
$string['task_logretention'] = 'Bewaarperiode';
$string['task_logretention_desc'] = 'De maximale periode dat logboeken moeten worden bewaard. Deze instelling werkt samen met de instelling \'runs behouden\': wat het eerst wordt bereikt, is van toepassing';
$string['tasklogs'] = 'Taaklogs';
$string['taskmessagingcleanup'] = 'Achtergrondprocessen voor berichten';
$string['taskpasswordresetcleanup'] = 'Opruimen van pogingen om wachtwoorden opnieuw in te stellen';
$string['taskplagiarismcron'] = 'Achtergrondprocessen voor verouderde cron in plagiaatplugins';
$string['taskportfoliocron'] = 'Achtergrondprocessen voor portfolioplugins';
$string['taskprocessing'] = 'Taakverwerking';
$string['taskquestioncron'] = 'Achtergrondprocessen voor het opruimen van oude voorvertoningen van vragen';
$string['taskquestionstatscleanupcron'] = 'Achtergrondprocessen voor het opruimen van oude vraagstatistieken cache';
$string['taskrefreshsystemtokens'] = 'Vernieuw OAuth tokens voor service-accounts';
$string['taskregistrationcron'] = 'Site-registratie';
$string['task_result'] = 'Resultaat';
$string['task_result:failed'] = 'Mislukt';
$string['task_scheduled_concurrency_limit'] = 'Gelijktijdigheidsbeperking geplande taken';
$string['task_scheduled_concurrency_limit_desc'] = 'Het aantal geplande taken dat tegelijk mogen draaien. Als je het limiet hoog instelt, kan dit een zwaardere belasting hebben op je server en invloed hebben op de ervaringen. Wanneer je 0 instelt zal het proces van geplande taken uitgeschakeld worden.';
$string['task_scheduled_max_runtime'] = 'De levensduur van een geplande taak';
$string['task_scheduled_max_runtime_desc'] = 'De levensduur van een geplande taak voordat deze vrij komt.';
$string['tasksendfailedloginnotifications'] = 'Rapport voor mislukte aanmeldingen verzonden';
$string['tasksendnewuserpasswords'] = 'Nieuwe gebruikerswachtwoorden verstuurd';
$string['tasksessioncleanup'] = 'Oude sessies opgeruimd';
$string['task_starttime'] = 'Startuur';
$string['taskstatscron'] = 'Achtergrondprocessen voor statistieken';
$string['task_stats:dbreads'] = '{$a} leest';
$string['task_stats:dbwrites'] = '{$a} schrijft';
$string['tasktagcron'] = 'Achtergrondprocessen voor tags';
$string['tasktempfilecleanup'] = 'Verwijder oude tijdelijke bestanden';
$string['tasktype'] = 'Type';
$string['task_type:adhoc'] = 'Niet gepland';
$string['task_type:scheduled'] = 'Gepland';
$string['tempdatafoldercleanup'] = 'Opschonen van tijdelijke bestanden, ouder dan';
$string['testoutgoingmailconf'] = 'Test configuratie uitgaande mail';
$string['testoutgoingmailconf_errorcommunications'] = 'Moodle kon niet communiceren met je mailserver. Controleer de configuratie voor uitgaande mail.';
$string['testoutgoingmailconf_message'] = 'Dit is een testbericht om te bevestigen dat je de e-mailinstellingen van je Moodle site succesvol hebt geconfigureerd.';
$string['testoutgoingmailconf_sendtest'] = 'Verzend een testbericht';
$string['testoutgoingmailconf_sentmail'] = 'Moodle heeft het testbericht succesvol naar de mailserver verzonden.<br />Van: {$a->fromemail}<br />Aan: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a}: testbericht';
$string['testoutgoingmailconf_toemail'] = 'E-mailadres ontvanger';
$string['testoutgoingmaildetail'] = 'Bewaar de configuratie voordat je de test uitvoert.<br />{$a}';
$string['testsiteupgradewarning'] = 'Je gebruikt nu de {$a} test site. Je kunt beter de command line tool gebruiken om te upgraden';
$string['themedesignermode'] = 'Thema ontwerpermodus';
$string['themedesignermodewarning'] = 'Themaontwerpmodus is ingeschakeld. Dit zou nooit mogen ingeschakeld zijn op productiesites, omdat de performantie hierdoor behoorlijk kan verlagen.';
$string['themelist'] = 'Thema lijst';
$string['themenoselected'] = 'Geen thema gekozen';
$string['themeresetcaches'] = 'Maak themacaches leeg';
$string['themeselect'] = 'Wijzig thema';
$string['themeselector'] = 'Kies thema';
$string['themesettings'] = 'Thema instellingen';
$string['therewereerrors'] = 'Er waren fouten in je gegevens';
$string['thirdpartylibrary'] = 'Bibliotheek';
$string['thirdpartylibrarylocation'] = 'Plaats';
$string['thirdpartylibs'] = 'Externe bibliotheken';
$string['timezone'] = 'Standaard tijdzone';
$string['timezoneforced'] = 'Dit is opgelegd door de sitebeheerder';
$string['timezoneinvalid'] = 'Ongeldige tijdzone "{$a}"';
$string['timezoneisforcedto'] = 'Iedereen gebruikt';
$string['timezonenotforced'] = 'Gebruikers kunnen hun eigen tijdzone kiezen';
$string['timezonephpdefault'] = 'Standaard PHP tijdzone ({$a})';
$string['timezoneserver'] = 'Server tijdzone ({$a})';
$string['tlswarning'] = 'Er is geen PHP / cURL uitbreiding met TLSv1.2 steun gedetecteerd. Sommige diensten kunnen niet werken. Het wordt sterk aanbevolen om uw TLS-bibliotheken te upgraden.';
$string['tokenduration'] = 'Duur van door gebruiker gecreëerd token';
$string['tokenduration_desc'] = 'Tijd die een door gebruikers gecreëerd web service token geldig is (bijvoorbeeld via de mobiele app) .';
$string['tokenizerrecommended'] = 'Het installeren van de optionnele PHP Tokenizer extentie wordt aangeraden -- het verbetert de Moodle Networking functionnaliteit';
$string['tools'] = 'Beheertools';
$string['toolsmanage'] = 'Beheer beheertools';
$string['unattendedoperation'] = 'Automatische installatie';
$string['unbookmarkthispage'] = 'Verwijder de bladwijzer naar deze pagina';
$string['unicoderequired'] = 'Je moet al je data als Unicode (UTF-8) bewaren. Nieuwe installaties moeten geïnstalleerd worden met Unicode als standaard tekenset voor de databank. Als je upgrade, moet je het UTF-8 migratieproces laten lopen (zie pagina Beheer).';
$string['uninstallplugin'] = 'Verwijder';
$string['unlockaccount'] = 'Deblokkeer account';
$string['unoconvwarning'] = 'De versie van unoconv die u hebt geïnstalleerd, wordt niet ondersteund.';
$string['unsettheme'] = 'Zet thema uit';
$string['unsupported'] = 'Niet ondersteund';
$string['unsupporteddbfileformat'] = 'Je database heeft tabellen die Antelope als bestandsformaat gebruiken. Volledige ondersteuning van UTF-8 in MySQL en MariaDB vereisen het Barracuda bestandsformaat. Gelieve de tabellen naar het Barracuda bestandsformaat te converteren. Zie de documentatie <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support">MySQL full unicode support</a >voor meer informatie.';
$string['unsupporteddbfilepertable'] = 'Voor volledige ondersteuning van UTF-8 vereisen zowel MySQL als MariaDB dat je de MySQL-instelling \'innodb_file_per_table\' op \'ON\' instelt. Zie de documentatie voor aanvullende informatie.';
$string['unsupporteddblargeprefix'] = 'Voor volledige ondersteuning van UTF-8 vereisen zowel MySQL als MariaDB dat je de MySQL-instelling \'innodb_large_prefix\' op \'ON\' instelt. Zie de documentatie voor aanvullende informatie.';
$string['unsupporteddbstorageengine'] = 'De database storage engine wordt niet meer ondersteund.';
$string['unsupporteddbtablerowformat'] = 'Je databanktabellen gebruiken Antilope als bestandsformaat. Je wordt aangeraden om ze te converteren naar Barracuda bestandsformaat. Je vindt documentatie op <a href="https://docs.moodle.org/en/cli">Administration via command line</a> met details over een tool om InnoDB-tabellen om te zetten naar Barracuda.';
$string['unsupportedphpversion7'] = 'PHP versie 7 is niet ondersteund.';
$string['unsupportedphpversion71'] = 'PHP-versie 7.1 wordt niet ondersteund.';
$string['unsupportedphpversion72'] = 'PHP-versie 7.2 wordt niet ondersteund.';
$string['unsupportedphpversion73'] = 'PHP-versie 7.3 wordt niet ondersteund.';
$string['unsupportedphpversion74'] = 'PHP versie 7.4 wordt niet ondersteund.';
$string['unsuspenduser'] = 'Activeer gebruikersaccount';
$string['updateaccounts'] = 'Update bestaande accounts';
$string['updateautocheck'] = 'Automatisch controleren op beschikbare updates';
$string['updateautocheck_desc'] = 'Indien ingeschakeld, wordt er automatisch gecontroleerd op beschikbare updates zowel voor Moodle-code als voor alle aanvullende plug-ins. Als er een nieuwe update beschikbaar is, wordt een melding gestuurd naar de site-beheerders.';
$string['updateavailable'] = 'Er is een nieuwere Moodle versie beschikbaar!';
$string['updateavailabledetailslink'] = 'Zie {$a->url} voor meer details';
$string['updateavailableforplugin'] = 'Er is een nieuwere versie voor een aantal van uw plugins beschikbaar!';
$string['updateavailableinstall'] = 'Installeer deze update';
$string['updateavailableinstallall'] = 'Installeer beschikbare updates ({$a})';
$string['updateavailableinstallallhead'] = 'Installeren beschikbare updates';
$string['updateavailable_moreinfo'] = 'Meer info ...';
$string['updateavailablenot'] = 'Uw Moodle-code is up-to-date!';
$string['updateavailablerecommendation'] = 'Je kunt best je site upgraden naar de laatste versie om alle beveiligingsupdates en bugfixes te krijgen.';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Versie {$a}';
$string['updatecomponent'] = 'Update component';
$string['updateminmaturity'] = 'Vereiste code-maturiteit';
$string['updateminmaturity_desc'] = 'Enkel meldingen geven over beschikbare updates als de beschikbare code minstens het geselecteerde maturiteitsniveau heeft. Updates voor plugins die hun maturiteitsniveau hebben niet geven, worden altijd gemeld, ongeacht deze instelling.';
$string['updatenotificationfooter'] = 'Je Moodlesite {$a->siteurl} is geconfigureerd om automatisch te controleren op beschikbare updates. Je ontvangt dit bericht als site-beheerder. Je kunt het automatisch controleren van updates uitschakelen in Site-beheer / Server / Updatemeldingen of dit bericht aanpassen via je persoonlijke voorkeuren voor berichten.';
$string['updatenotifications'] = 'Update meldingen';
$string['updatenotificationsubject'] = 'Er zijn Moodle updates beschikbaar voor {$a->siteurl}.';
$string['updatenotifybuilds'] = 'Stuur melding bij nieuwe versies';
$string['updatenotifybuilds_desc'] = 'Indien ingeschakeld wordt de beschikbaarheid van een update van de Moodle-code als er een nieuwe build van de huidige versie beschikbaar is. Builds zijn voortdurende verbeteringen van een bepaalde Moodleversie. Ze worden gewoonlijk elke week gebouwd; Indien uitgeschakeld wordt als beschikbare update alleen gerapporteerd als er een nieuwe Moodleversie beschikbaar is. Controles voor plugins worden niet beïnvloed door deze instelling.';
$string['upgradeerror'] = 'Onbekende fout bij het upgraden van {$a->plugin} naar versie {$a->version}. Kan niet verder gaan.';
$string['upgradeforumread'] = 'Vanaf Moodle 1.5 kun je bijhouden of forumberichten al gelezen zijn of niet.<br /> Om deze functie te kunnen gebruiken moet je <a href="{$a}">je tabellen upgraden</a>.';
$string['upgradeforumreadinfo'] = 'Vanaf Moodle 1.5 kun je bijhouden of forumberichten al gelezen zijn of niet.<br /> Om deze functie te kunnen gebruiken moet je je tabellen upgraden met alle niet gelezen/gelezen informatie voor de bestaande berichten. Afhankelijk van de grootte van je site kan dit lang duren (uren) en kan je databank behoorlijk belasten. Het is dus aangeraden dit te doen tijdens een rustige periode. Je site zal blijven werken tijdens deze upgrade en je gebruikers zullen er weinig hinder van ondervinden. Als je dit proces start moet je het laten aflopen (laat je browser-venster open). Geen paniek als je het proces toch zou stoppen door je venster te sluiten: je kunt terug opnieuw beginnen .<br /><br />Wil je het upgrade-proces nu starten?';
$string['upgradekeyreq'] = 'Upgrade-sleutel vereist';
$string['upgradekeyset'] = 'Upgrade-sleutel (leeg laten om er geen in te stellen)';
$string['upgradelogs'] = 'Om volledige functionaliteit te verkrijgen, moeten je oude logbestanden geüpgraded worden. <a href="{$a}">Meer informatie</a>';
$string['upgradelogsinfo'] = 'Sommige wijzigingen hebben invloed op de manier waarop de logs worden opgeslagen. Om al je oude logs per activiteit te kunnen bekijken, moeten je oude logs geüpdated worden. Afhankelijk van je site kan dit lang duren (zelfs enkele uren) en voor lange sites kan dat de databank zwaar belasten. Als je het proces start, dan zou je het moeten laten aflopen (door het browservenster open te laten). Maak je geen zorgen, terwijl je de logs upgradet, zal de site blijven werken voor je gebruikers.<br /><br />Wil je je logs nu upgraden?';
$string['upgradepluginsfirst'] = 'Je kunt best de beschikbare updates eerst installeren';
$string['upgradepluginsinfo'] = 'Plugins aan het updaten';
$string['upgradepluginsinfo_help'] = 'Er zijn updates beschikbaar voor sommige van je plugins. Je moet ze allemaal installeren voor je Moodle upgrade. Als je site nog geen automatische updates ondersteunt, moet je de nieuwe plugins manueel op je server installeren.';
$string['upgradesettings'] = 'Nieuwe instellingen';
$string['upgradesettingsintro'] = 'Onderstaande instellingen werden toegevoegd sinds je laatste Moodle upgrade. Wijzig de standaardinstellingen waar nodig en klik op de "Bewaar instellingen"-knop onderaan deze pagina.';
$string['upgradestalefiles'] = 'Gemengde Moodleversies gedetecteerd, upgrade kan niet verder gaan.';
$string['upgradestalefilesinfo'] = 'Het Moodle updateproces is gepauseerd, omdat er PHP scripts van minstens 2 Moodleversies gedetecteerd zijn in je Moodlemap.

Dit kan grote problemen opleveren, dus om verder te gaan moet je er voor zorgen dat de Moodlemap enkel bestanden van één enkele versie bevat.

Je kunt het volgende doen om je Moodlemap op te schonen:

*hernoem je huidige Moodlemap naar "moodle_oud"
*maak een nieuwe Moodlemap met enkel bestanden van een standaard Moodleversie, die je download of via Git bekomt.
*verplaats het oorspronkelijke config.php-bestand en alle niet-standaard plugins van je moodle_oud map naar je nieuwe Moodlemap

Wanneer je een propere Moodlemap hebt, ververs dan de pagina om de upgrade verder te zetten.

Deze waarschuwing wordt gewoonlijk veroorzaakt door een standaard Moodlepakket te unzippen over een vorige versie van Moodle. Terwijl dit kan voor kleine updates, wordt het ten zeerste afgerade voor grote Moodle upgrades.

Deze waarschuwing kan ook veroorzaakt worden door een onvolledige checkout van Git, waarbij je gewoonlijk moet wachten tot de update operatie klaar is of het juiste opschoonscript te laten lopen en de operatie opnieuw te proberen.

Je kunt meer informatie vinden in de upgrade documentatie op <a href="{$a}">{$a}</a>';
$string['upgradestart'] = 'Moodledatabank nu bijwerken';
$string['upgradesure'] = '<p>De bestanden op je Moodleserver zijn gewijzigd en je gaat zo dadelijk je server automatisch upgraden naar versie: </p>
<p><strong>{$a}</strong></p>
<p>Als je dit doet, kun je niet meer terug. Merk op dat het proces lang kan duren</p>
<p>Ben je er er zeker van dat je deze server naar die versie wil upgraden?</p>';
$string['upgradetimedout'] = 'Er is een time-out opgetreden. Herstart de upgrade.';
$string['upgradingdata'] = 'Bezig met het upgraden van de gegevens';
$string['upgradinglogs'] = 'Bezig met upgraden van logs';
$string['upgradingversion'] = 'Upgraden naar nieuwe versie';
$string['upwards'] = 'hoger';
$string['useblogassociations'] = 'Associaties inschakelen';
$string['useexternalyui'] = 'Gebruik online YUI-libraries';
$string['user'] = 'Gebruiker';
$string['userbulk'] = 'Gebruikers in bulk beheren';
$string['userbulkdownload'] = 'Exporteer gebruikers als';
$string['userdefaultpreferences'] = 'Standaardvoorkeuren gebruiker';
$string['userimagesdisabled'] = 'Afbeeldingen voor gebruikersprofielen uitgeschakeld';
$string['userlist'] = 'Lijst';
$string['userpolicies'] = 'Gebruikersregels';
$string['userpreference'] = 'Gebruikersvoorkeur';
$string['userquota'] = 'Gebruikersquotum';
$string['users'] = 'Gebruikers';
$string['usesitenameforsitepages'] = 'Gebruik site naam voor site pagina\'s';
$string['usetags'] = 'Tags functionaliteit inschakelen';
$string['validateemptylineerror'] = 'Lege lijnen zijn niet geldig';
$string['validateerror'] = 'Deze waarde is niet geldig';
$string['validateerrorlist'] = 'Volgende items zijn niet geldig: {$a}';
$string['validateiperror'] = 'Deze IP-adressen zijn niet geldig: {$a}';
$string['verifychangedemail'] = 'Beperk toegelaten domeinen bij het wijzigen van e-mailadres';
$string['warningcurrentsetting'] = 'Foute waarde: {$a}';
$string['warningiconvbuggy'] = 'Je versie van de iconv bibliotheek ondersteunt de //IGNORE modifier niet. Je moet de mbstring extentie installeren die in de plaats gebruikt kan worden om strings te zuiveren van ongeldige UTF-8 tekens';
$string['webproxy'] = 'Web proxy';
$string['webproxyinfo'] = 'Vul onderstaande opties in als je Moodle server niet rechtstreeks op internet kan. Internettoegang is nodig voor de download van geografische informatie, taalpakketten, RSS-feeds, tijdzones enz.<br /><em>Je kunt best de PHP cURL extentie installeren.</em>';
$string['xmlrpcrecommended'] = 'De XMLRPC-extentie is nuttig voor de web services en Moodle Netwerk';
$string['yuicomboloading'] = 'YUI combo aan het laden';
$string['ziprequired'] = 'De ZIP-PHP-extentie is nu vereist voor Moodle. Info-ZIP en PclZip worden niet meer gebruikt.';
