<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_zebra', language 'sr_cr', branch 'MOODLE_27_STABLE'
 *
 * @package   theme_zebra
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['backgroundurl'] = 'URL адреса позадине';
$string['backgroundurldesc'] = '<p>Унесите URL адресу ваше слике позадине.</p><p>Можете да користите Moodle Output формат путање (у односу на тему), пуну или релативну путању.</p>';
$string['bodybgcolor'] = 'Боја позадине тела странице';
$string['bodybgcolordesc'] = '<p>Главна боја позадине странице.</p><p>Ово се примењује на HTML таг <code>&lt;body&gt;</code>.</p>';
$string['branding'] = 'Сакриј логотипе у подножју странице';
$string['brandingdesc'] = '<p>Сакриј брендиране логотипе у подножју странице.</p><p>Ово су линкови ка сајтовима који су спонзори или су директно допринели развоју ове теме. Детаљније информације о теми могу се наћи када се она изабере у селектору тема.</p>';
$string['calcourse'] = 'Календар догађаја на курсу';
$string['calcoursedesc'] = '<p>Подешава боју која се користи за представљање догађаја на курсу у календару.</p>';
$string['calglobal'] = 'Календар глобалних догађаја';
$string['calglobaldesc'] = '<p>Подешава боју која се користи за представљање глобалних догађаја у календару.</p>';
$string['calgroup'] = 'Календар групних догађаја';
$string['calgroupdesc'] = '<p>Подешава боју која се користи за представљање групних догађаја у календару.</p>';
$string['callink'] = 'Линк ка календару';
$string['callinkdesc'] = '<p> Прикажи датум са линком ка календару на крају прилагођеног менија.</p>';
$string['caluser'] = 'Календар корисничких догађаја';
$string['caluserdesc'] = '<p>Подешава боју која се користи за представљање корисничких догађаја у календару.</p>';
$string['calweekend'] = 'Боја за дане викенда у календару';
$string['calweekenddesc'] = '<p>Одређује боју фонта који се користи за дане викенда у календару.</p>';
$string['cfmaxversion'] = 'Максимална верзија Internet Explorera';
$string['cfmaxversiondesc'] = '<p>Напомена: <a href="#admin-usecf"><code>usecf</code></a> мора бити укључено да би ово радило.</p><p>Ово је максимална верзија Internet Explorera која ће од корисника тражити да инсталирају Chrome Frame. Новије верзије ово неће тражити.</p>';
$string['choosereadme'] = '<div class="clearfix"> <h2>Zebra</h2> <hr> <h3>О графичкој теми</h3> <p>Zebra је адаптивна тема, првенствено намењена мобилним уређајима, која користи CSS3 како би реорганизовала структуру странице и прилагодила њен приказ сваком уређају.</p>
<p>Zebra, на страници за подешавање теме, такође обезбеђује велики број опција за прилагођавање, укључујући боје, логотипе, адаптивна подешавања, као и опције за прилагођени CSS и JavaScript.</p>
<h3>Матичне теме</h3> <p>Ова тема је изграђена на теми Base, али користи прилагођени прелом странице и док. Ова, као и све друге теме укључене у основни пакет Moodlea, објављене су под лиценцом <a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>.</p> <p>Основни прелом странице (<a href="http://iyware.com/antioch">antioch</a>), дизајнираo је Danny Wahl @<a href="http://iyware.com">iyWare</a> независно од Moodlea 2.0, и може се користити самостално, такође под лиценцом GNU General Public License v3.</p> <h3>Остале компоненте</h3>
<p>Ова тема користи друге библиотеке отвореног кôда и права над тим библиотекама припадају њиховим ауторима. Више информације можете наћи на страници <a href="../admin/settings.php?section=themesettingzebra">Подешавања теме Zebra</a>.</p> <h3>Форм о теми:</h3>
<p><a href="https://moodle.org/mod/forum/discuss.php?d=217191">https://moodle.org/mod/forum/discuss.php?d=217191</a></p> <h3>URL адреса теме:</h3> <p><a href="https://moodle.org/plugins/view.php?plugin=theme_zebra">http://moodle.org/plugins/view.php?plugin=theme_zebra</a></p> <h3>Тема – Заслуге (аутор теме)</h3> <p><a href="http://iyware.com">Danny Wahl</a></p> <h3>Не заборавите да прилагодите своја подешавања!</h3> <a href="../admin/settings.php?section=themesettingzebra">Zebra Theme Settings</a> </div> </div>';
$string['colorscheme'] = 'Схема боја';
$string['colorschemedesc'] = '<p>Градијенти и светле површине.</p><p>Напомена: Сафари 4 не прихвата фиксну висину градијента, тако да ће увек приказати као "ниједан"..</p>';
$string['colorsinfo'] = 'Општа подешавања боја';
$string['colorsinfodesc'] = '<p>Промените подешавања за боје странице.</p><p>Можете да користите било који важећи тип боје, као <code>red</code>, <code>#FF0000</code>, <code>rgb(0, 255, 255)</code>, или <code>rgba(0, 255, 255, 1.0)</code>.</p>';
$string['columnbgcolor'] = 'Боја позадине колона';
$string['columnbgcolordesc'] = '<p>Боја позадине колоне(а).</p><p>Ово се примењује на различите елементе зависно од тренутног приказа (молимо вас, погледајте pagelayout.css за више информација), али генерално, тиче се подручја блокова ("region-pre" и "region-post").</p>';
$string['columninfo'] = 'Подешавања распореда елемената странице';
$string['columninfodesc'] = '<p>Промените распоред елемената странице. Да бисте тестирали своја подешавања једноставно промените величину прозора вашег веб читача или окрените свој телефон/таблет.</p><figure style="float: left;"><img src="../theme/image.php?theme=zebra&image=core/one_column&component=theme"/><figcaption><ul><li>горе: <code>region-main</code></li><li>у средини: <code>region-pre</code></li><li>доле: <code>region-post</code></li></ul></figcaption></figure><figure style="float: left;"><img src="../theme/image.php?theme=zebra&image=core/two_columns&component=theme"/><figcaption><ul><li>горе лево: <code>region-pre</code></li><li>доле лево: <code>region-post</code></li><li>десно: <code>region-main</code></li></ul></figcaption></figure><figure style="float: left;"><img src="../theme/image.php?theme=zebra&image=core/three_columns&component=theme"/><figcaption><ul><li>лево: <code>region-pre</code></li><li>централно: <code>region-main</code></li><li>десно: <code>region-post</code></li></ul </figcaption></figure><br style="clear: left;" />';
$string['colwidth'] = 'Ширина ступца';
$string['colwidthdesc'] = '<p>Ширина колона То је <code>region-pre</code> и <code>region-post</code>.</p>';
$string['compatinfo'] = 'Подешавања компатибилности веб читача';
$string['compatinfodesc'] = '<p>Разна подешавања која имају за циљ да покушају да побољшају компатибилност веб читача са овом темом, како би корисници имали што конзистентније графичко окружење за рад.</p>';
$string['contentbgcolor'] = 'Боја позадине странице';
$string['contentbgcolordesc'] = '<p>Боја позадине садржаја.</p><p>Ово се примењује на различите елементе у зависности од тренутног приказа (погледајте pagelayout.css за више детаља), али генерално то је садржај странице. Ово се, такође, односи на боју линкова прилагођеног менија.</p>';
$string['criticalfontcolor'] = 'Боја слова критичних обавештења';
$string['criticalfontcolordesc'] = '<p>Одређује боју фонта који се користе за ствари које генеришу критична обавештење. Обично, то је <code>.statuscritical</code>, <code>.red</code>, и <code>.notifyproblem</code>.</p>';
$string['customcss'] = 'Прилагођени CSS';
$string['customcssdesc'] = '<p>Овде унесите прилагођени CSS .</p><p>CSS који се овде унесе је последње што се позива приликом учитавања странице, и не сме бити преписан тј. замењен од стране било ког другог правила. Ако се ваша правила не приказују, покушајте следеће:<ol><li>проверите вашу синтаксу</li><li>додајте <code>!important</code> вашем правилу </li><li>ручно додајте правило</li></ol></p>';
$string['customjs'] = 'Прилагођени JavaScript';
$string['customjsdesc'] = '<p>Унесите овде прилагођени JavaScript.</p><p>JS који се овде упише појављује се у подножју странице. Унети текст биће уоквирен <code>script</code> ознакама (таговима).</p>';
$string['dateformat'] = 'Формат датума';
$string['dateformatdesc'] = '<p>Напомена: ово захтева да <a href="#admin-callink"><code>callink</code></a> буде омогућен.</p><p>Подесите формат за приказ датума у прилагођеном менију. За више информација о функцији date() погледајте документацију на php.net <a href="http://php.net/manual/en/function.date.php" title="PHP: date - Manual">овде</a>.</p>';
$string['donate'] = 'Донирај путем PayPala';
$string['donatedesc'] = '<p style="text-align:center;">Ако сматрате да је ова тема корисна молимо вас да донирате извесну суму новца како бисте помогли њен даљи развој.<br/><br/><a href="https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=danny%40iywahl%2ecom&lc=US&item_name=iyWare&item_number=Zebra%202%20&currency_code=USD" style="background: url(data:image/png;base64,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) no-repeat scroll 8px 4px #234B6F; padding: 8px 22px 12px 54px; color:#fff; border-radius:4px;box-shadow:1px 1px 1px rgba(0, 0, 0, 0.2), 0 1px 0 rgba(255, 255, 255, 0.2) inset;text-align:center;text-shadow:0 1px 1px rgba(0, 0, 0, 0.3);text-decoration:none;">Донирај</a></p>';
$string['fontcolor'] = 'Боја слова';
$string['fontcolordesc'] = '<p>Примарна боја слова и натписа.</p><p>Ово се примењује на свe натписe и фонтовe који немају одређену класу која мења боју, као што су класе <code>.warning</code> или <code>.notifysuccess</code>. Ово се, такође, примењује на боју позадине "датума" y прилагођеном менију.</p>';
$string['footerbgcolor'] = 'Боја позадине подножја странице';
$string['footerbgcolordesc'] = '<p>Боја позадине подножја странице</p><p>Коришћење опције <code>transparent</code> проузроковаће да подножје странице прикаже вредност за <code>contentbgcolor</code>, а не <code>bodybgcolor</code>. Ово треба да буде подешено на исту вредност као и <code>bodybgcolor</code> за ефекат транспаренције</p>';
$string['headeralt'] = 'Алтернативни текст';
$string['headeraltdesc'] = '<p>Текст који се користи уместо назива сајта.</p><p>Сугестија: користите размак (<code>&amp;nbsp;</code>) ако желите да ништа не буде приказано.</p>';
$string['headerbgcolor'] = 'Боја позадине заглавља';
$string['headerbgcolordesc'] = '<p>Боја позадине заглавља</p>';
$string['headerinfo'] = 'Подешавања заглавља';
$string['headerinfodesc'] = '<p>Промените подешавања за регион заглавља.</p>';
$string['homeicon'] = 'Прикажи иконицу за почетну страницу';
$string['homeicondesc'] = '<p>Прикажи иконицу за почетну страницу на почетку прилагођеног менија.</p>';
$string['hovercolor'] = 'Боја лебдећег линка';
$string['hovercolordesc'] = '<p>Боја лебдећег линка.</p><p>Ово се примењује на све линкове (унутар и изван садржаја странице), као и на прилагођени мени.</p>';
$string['linkcolor'] = 'Боја линкова';
$string['linkcolordesc'] = '<p>Боја линкова и менија.</p><p>Ово се примењује на све линкове (унутар и изван садржаја странице), осим на прилагођени мени и његову позадину, са изузетком "датума".</p>';
$string['logourl'] = 'URL адреса логотипа';
$string['logourldesc'] = '<p>Унесите URL адресу вашег логотипа.</p><p>Ово се може урадити на један од три начина:<ul><li><p>Moodle Output формат путање (у односу на тему):</p><p><code>logo/companylogo</code></p></li><li><p>Пуна путања:</p><p><code>http://domain.com/theme/image.php?theme=zebra&image=logo&rev=1&component=theme</code><br /><code>http://domain.com/path/to/image.jpg</code></p></li><li><p>Релативна путања:</p><p><code>/path/to/file/companylogo.png</code></p></li></ul></p>';
$string['menucolorscheme'] = 'Схема боја менија';
$string['menucolorschemedesc'] = '<p>Градијент менија.</p>';
$string['menuhome'] = 'Почетна страница';
$string['menumyhome'] = 'Моја почетна страница';
$string['menutoday'] = 'Данашњи датум';
$string['miscinfo'] = 'Остала. подешавања';
$string['miscinfodesc'] = '<p>Промените подешавања за разне ствари.</p>';
$string['moodlecolorsinfo'] = 'Подешавања боја Moodlea';
$string['moodlecolorsinfodesc'] = '<p>Промените специфичне боје које су дефинисане у основном пакету Moodlea, а изван су општих боја горе дефинисаних. Ово укључује ствари попут <code>.notifysuccess</code> и боја за различите типове догађаја у календару. Ово вероватно не треба прилагођавати осим ако имате специфичан конфликт са горњим општим подешавањима боја.</p>';
$string['notes'] = 'Белешке о теми';
$string['notesdesc'] = '<p>Да бисте применили било које подешавање једноставно кликните на дугме "Сачувај промене" на дну ове странице.</p><p>Уколико режим за дизајнирање теме није укључен, можда ће бити неопходно да одете на администраторску страницу <a href="purgecaches.php">Обриши све записе из кеш меморије</a> како бисте освежили изглед графичке теме са новим подешавањим.</p>';
$string['okfontcolor'] = 'ОК/Добра боја фонта';
$string['okfontcolordesc'] = '<p>Одређује боју фонта који се користе за ствари које функционишу као чување подешавања итд.... Специфични примери су <code>.green</code> и <code>.notifysuccess</code>.</p>';
$string['pagemaxwidth'] = 'Максимална ширина странице';
$string['pagemaxwidthdesc'] = '<p>Максимална ширина за садржај странице.</p>';
$string['pluginname'] = 'Zebra';
$string['region-side-post'] = 'Десно';
$string['region-side-pre'] = 'Лево';
$string['schemedark'] = 'Тамна';
$string['schemeinfo'] = 'Подешавања схеме боја';
$string['schemeinfodesc'] = '<p>Промените подешавања за схему боја странице.</p>';
$string['schemelight'] = 'Светла';
$string['schemenone'] = 'Ниједна';
$string['seriousfontcolor'] = 'Боја фонта у важним порукама';
$string['seriousfontcolordesc'] = '<p>Одређује боју фонта који се користе за ствари које генеришу важна обавештење. Обично, то је <code>.statusserious</code>.</p>';
$string['simplelogin'] = 'Користити основни образац за пријаву';
$string['simplelogindesc'] = '<p>Ако омогућите ову опцију, она ће поједноставити прелом странице за пријаву тако што неће приказати заглавље и  подножје странице, навигациону траку, језички и прилагођени мени. Ова опција може да се користи за оне сајтове који захтевају проверу идентитета пре него што се дозволи приступ овим ставкама.</p>';
$string['threecolmin'] = 'Минимална ширина за три ступца';
$string['threecolmindesc'] = '<p>Минимална ширина за прелом странице са три ступца. Редослед приказа је:</p>';
$string['twocolmin'] = 'Минимална ширина за два ступца';
$string['twocolmindesc'] = '<p>Минимална ширина за прелом странице са два ступца.</p>';
$string['useautohide'] = 'Укључи CSS за аутоматско сакривање';
$string['useautohidedesc'] = '<p>Укључите CSS правила за аутоматско сакривање иконица за кориснике који су у режиму уређивања.</p><p>Прочитајте више о овоме <a href="http://moodle.org/mod/forum/discuss.php?d=197470">овде</a> или <a href="http://www.moodlenews.com/2012/a-moodle-administrators-dream-come-true-autohide-for-moodle-2-2/"> овде </a>.</p>';
$string['usecf'] = 'Затражите од корисника да инсталирају Google Chrome Frame';
$string['usecfdesc'] = '<p>Google <a href="http://code.google.com/chrome/chromeframe/">Chrome Frame</a> је додатак за Internet Explorer који инсталира Chromium Rendering engine (механизам за визуализацију) на старијим веб читачима и омогућава им да користе савремене веб технологије.</p>';
$string['userespond'] = 'Укључи respond.js у подножје странице';
$string['useresponddesc'] = '<p><a href="https://github.com/scottjehl/Respond#readme">Respond.js</a> ће покушати да анализира (парсира) <code>@media</code> упите у CSS-у и да их понуди веб читачима који их не подржавају у изворном облику (као IE8 и старије верзије).</p>';
$string['userpic'] = 'Прикажи слику корисника';
$string['userpicdesc'] = '<p>Прикажи слику корисничког профила у заглављу</p>';
$string['warningfontcolor'] = 'Боја фонта у упозорењима';
$string['warningfontcolordesc'] = '<p>Одређује боју фонта који се користе за ствари које генеришу упозорења. Обично, то је <code>.statuswarning</code>.</p>';
