<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'competency', language 'cs', branch 'MOODLE_37_STABLE'
 *
 * @package   competency
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allchildrenarecomplete'] = 'Všichni potomci jsou dokončeni';
$string['competencies'] = 'Kompetence';
$string['competenciesarenotenabled'] = 'Kompetencí nejsou povoleny.';
$string['competenciessettings'] = 'Nastavení kompetencí';
$string['completeplanstask'] = 'Dokončit studijní plány, které mají termín';
$string['coursecompetencyoutcome_complete'] = 'Dokončit kompetenci';
$string['coursecompetencyoutcome_evidence'] = 'Připojit evidenci';
$string['coursecompetencyoutcome_none'] = 'Nedělat nic';
$string['coursecompetencyoutcome_recommend'] = 'Odeslat ke kontrole';
$string['coursemodulecompetencyoutcome_complete'] = 'Dokončit kompetenci';
$string['coursemodulecompetencyoutcome_evidence'] = 'Připojit evidenci';
$string['coursemodulecompetencyoutcome_none'] = 'Nedělat nic';
$string['coursemodulecompetencyoutcome_recommend'] = 'Odeslat ke kontrole';
$string['deletecompetencyratings'] = 'Odstranit hodnocení kompetence';
$string['duplicateditemname'] = '{$a} (kopie)';
$string['enablecompetencies'] = 'Povolit kompetence';
$string['enablecompetencies_desc'] = 'Kompetence umožňují uživatelům, aby byli posuzováni podle učebních plánů.';
$string['errorcannotchangeapastduedate'] = 'Datum splnění vypršelo, nemůže být změněno.';
$string['errorcannotsetduedateinthepast'] = 'Datum splnění nelze nastavit do minulosti.';
$string['errorcannotsetduedatetoosoon'] = 'Datum splnění je příliš brzo.';
$string['errorcompetencyrule'] = 'Pravidlo kompetence kurzu "{$a}" je neznámé';
$string['errorcoursecompetencyrule'] = 'Pravidlo kompetence kurzu "{$a}" je neznámé';
$string['errorinvalidcourse'] = 'Neplatný kurz.';
$string['errornocompetency'] = '{$a} kompetence nelze nalézt';
$string['errorplanstatus'] = 'Neznámý stav "{$a}" studijního plánu';
$string['errorscalealreadyused'] = 'Škálu nelze změnit, protože je již používána.';
$string['errorscaleconfiguration'] = 'Škálu je nutné nakonfigurovat výběrem výchozí a dosažitelné položky.';
$string['errorusercomptencystatus'] = 'Neznámý stav "{$a}"  kompetence uživatele';
$string['eventcompetencycreated'] = 'Kompetence vytvořena.';
$string['eventcompetencydeleted'] = 'Kompetence odstraněna.';
$string['eventcompetencyframeworkcreated'] = 'Kompetenční rámec vytvořen.';
$string['eventcompetencyframeworkdeleted'] = 'Kompetenční rámec odstraněn.';
$string['eventcompetencyframeworkupdated'] = 'Kompetenční rámec aktualizován.';
$string['eventcompetencyframeworkviewed'] = 'Kompetenční rámec zobrazen.';
$string['eventcompetencyupdated'] = 'Kompetence aktualizována.';
$string['eventcompetencyviewed'] = 'Kompetence zobrazena.';
$string['eventevidencecreated'] = 'Evidence vytvořena.';
$string['eventplanapproved'] = 'Plán schválen.';
$string['eventplancompleted'] = 'Plán dokončen.';
$string['eventplancreated'] = 'Plán vytvořen.';
$string['eventplandeleted'] = 'Plán odstraněn.';
$string['eventplanreopened'] = 'Plán znovuotevřen.';
$string['eventplanreviewrequestcancelled'] = 'Žádost o revizi plánu zrušen.';
$string['eventplanreviewrequested'] = 'Požadována revize plánu.';
$string['eventplanreviewstarted'] = 'Zahájena revize plánu.';
$string['eventplanreviewstopped'] = 'Revize plánu zastavena.';
$string['eventplanunapproved'] = 'Plán nebyl schválen.';
$string['eventplanunlinked'] = 'Učení plán byl odpojen.';
$string['eventplanupdated'] = 'Učení plán aktualizován.';
$string['eventplanviewed'] = 'Učení plán zobrazen.';
$string['eventtemplatecreated'] = 'Vytvořena šablona studijního plánu.';
$string['eventtemplatedeleted'] = 'Šablona studijního plánu odstraněna.';
$string['eventtemplateupdated'] = 'Šablona studijního plánu aktualizována.';
$string['eventtemplateviewed'] = 'Šablona studijního plánu zobrazena.';
$string['eventusercompetencyplanviewed'] = 'Kompetenční plán uživatele zobrazen.';
$string['eventusercompetencyrated'] = 'Hodnoceny kompetence uživatele.';
$string['eventusercompetencyratedincourse'] = 'Kompetence uživatele hodnoceny v kurzu.';
$string['eventusercompetencyratedinplan'] = 'Kompetence uživatele hodnoceny ve studijním plánu.';
$string['eventusercompetencyreviewrequestcancelled'] = 'Požadavek revize kompetence uživatele zrušen.';
$string['eventusercompetencyreviewrequested'] = 'Požadována revize kompetence uživatele.';
$string['eventusercompetencyreviewstarted'] = 'Revize kompetence uživatele zahájena.';
$string['eventusercompetencyreviewstopped'] = 'Revize kompetence uživatele zastavena.';
$string['eventusercompetencyviewed'] = 'Kompetence uživatele zobrazena.';
$string['eventusercompetencyviewedincourse'] = 'Kompetence uživatele zobrazena v kurzu.';
$string['eventusercompetencyviewedinplan'] = 'Kompetence uživatele zobrazena ve studijním plánu.';
$string['eventuserevidencecreated'] = 'Evidence předchozího studia vytvořena.';
$string['eventuserevidencedeleted'] = 'Evidence předchozího studia odstraněna.';
$string['eventuserevidenceupdated'] = 'Evidence předchozího studia aktualizována.';
$string['evidence_competencyrule'] = 'Bylo splněno pravidlo kompetence.';
$string['evidence_coursecompleted'] = 'Kurz "{$a}" byl dokončen.';
$string['evidence_coursemodulecompleted'] = 'Byla dokončena aktivita "{$a}".';
$string['evidence_courserestored'] = 'Hodnocení bylo obnoveno spolu s "{$a}".';
$string['evidence_evidenceofpriorlearninglinked'] = 'Evidence předchozího studia "{$a}" byla připojena.';
$string['evidence_evidenceofpriorlearningunlinked'] = 'Evidence předchozího studia "{$a}" byla odpojena.';
$string['evidence_manualoverride'] = 'Hodnocení kompetence bylo nastaveno manuálně.';
$string['evidence_manualoverrideincourse'] = 'Hodnocení kompetence bylo nastaveno manuálně v kurzu "{$a}".';
$string['evidence_manualoverrideinplan'] = 'Hodnocení kompetence bylo nastaveno manuálně ve studijním plánu "{$a}".';
$string['invalidevidencedesc'] = 'Neplatný popis evidence';
$string['invalidgrade'] = 'Neplatné hodnocení';
$string['invalidpersistenterror'] = 'Chyba: {$a}';
$string['invalidplan'] = 'Neplatný studijní plán';
$string['invalidtaxonomy'] = 'Neplatná taxonomie: {$a}';
$string['invalidurl'] = 'Neplatné URL. Přesvěčte se, že začíná "http: //" nebo "https: //".';
$string['nouserplanswithcompetency'] = 'tuto kompetenci neobsahuje žádný studijní plán.';
$string['planstatusactive'] = 'Aktivní';
$string['planstatuscomplete'] = 'Dokončeno';
$string['planstatusdraft'] = 'Návrh';
$string['planstatusinreview'] = 'V revizi';
$string['planstatuswaitingforreview'] = 'Čekání na revizi';
$string['pointsrequiredaremet'] = 'Jsou-li splněny požadované body';
$string['privacy:evidence:action:complete'] = 'Splnění kompetence, pokud není hodnocena';
$string['privacy:evidence:action:log'] = 'Akce přihlášení';
$string['privacy:evidence:action:override'] = 'Přepsat hodnocení kompetence';
$string['privacy:metadata:competency'] = 'Záznam o kompetencích';
$string['privacy:metadata:competency_coursecomp'] = 'Záznam o kompetencích spojených s kurzem';
$string['privacy:metadata:competency_coursecompsetting'] = 'Záznam o nastavení kompetence v kurzu';
$string['privacy:metadata:competency_evidence'] = 'Zápis evidence ovlivňující stav kompetence';
$string['privacy:metadata:competency_framework'] = 'Záznam o rámcích kompetencí';
$string['privacy:metadata:competency_modulecomp'] = 'Záznam o kompetencích spojených s modulem';
$string['privacy:metadata:competency_plan'] = 'Přehled studijních plánů';
$string['privacy:metadata:competency_plancomp'] = 'Záznam o kompetencích ve studijního plánu';
$string['privacy:metadata:competency_relatedcomp'] = 'Záznam o vztahu mezi kompetencemi';
$string['privacy:metadata:competency_template'] = 'Zápis šablon studijního plánu';
$string['privacy:metadata:competency_templatecohort'] = 'Záznam o globálních skupinách spojených s šablonou studijního plánu';
$string['privacy:metadata:competency_templatecomp'] = 'Záznam o kompetencích v šabloně studijního plánu';
$string['privacy:metadata:competency_usercomp'] = 'Záznam o stavu kompetencí uživatele';
$string['privacy:metadata:competency_usercompcourse'] = 'Záznam o stavu kompetencí uživatele v kurzu';
$string['privacy:metadata:competency_usercompplan'] = 'Záznam o stavu kompetencí ve studijním plánu';
$string['privacy:metadata:competency_userevidence'] = 'Záznam evidence předchozího studia';
$string['privacy:metadata:competency_userevidencecomp'] = 'Záznam o kompetencích spojených s evidencí předchozího studia';
$string['privacy:metadata:core_comments'] = 'Komentáře ke studijním plánům a kompetencím';
$string['privacy:metadata:evidence:action'] = 'Typ opatření provedených s evidencí';
$string['privacy:metadata:evidence:actionuserid'] = 'Uživatel provádí akci';
$string['privacy:metadata:evidence:desca'] = 'Volitelné parametry popisu předkládané evidence';
$string['privacy:metadata:evidence:desccomponent'] = 'Součást popisu předkládané evidence';
$string['privacy:metadata:evidence:descidentifier'] = 'Identifikátor popisu předkládané evidence';
$string['privacy:metadata:evidence:grade'] = 'Známka spojená s evidencí';
$string['privacy:metadata:evidence:note'] = 'Nelokalizovaná poznámka připojená k evidenci';
$string['privacy:metadata:evidence:url'] = 'Adresa URL přidružená k evidenci';
$string['privacy:metadata:plan:description'] = 'Popis studijního plánu';
$string['privacy:metadata:plan:duedate'] = 'Datum plnění studijního plánu';
$string['privacy:metadata:plan:name'] = 'Název studijního plánu';
$string['privacy:metadata:plan:reviewerid'] = 'ID recenzenta studijního plánu';
$string['privacy:metadata:plan:status'] = 'Stav studijního plánu';
$string['privacy:metadata:plan:userid'] = 'ID uživatele, vlastníka studijního plánu';
$string['privacy:metadata:timecreated'] = 'Čas vytvoření záznamu';
$string['privacy:metadata:timemodified'] = 'Čas úpravy záznamu';
$string['privacy:metadata:usercomp:grade'] = 'Známka udělená pro kompetenci';
$string['privacy:metadata:usercomp:proficiency'] = 'Zda je dosaženo kvalifikace';
$string['privacy:metadata:usercomp:reviewerid'] = 'ID recenzenta';
$string['privacy:metadata:usercomp:status'] = 'Stav kompetence';
$string['privacy:metadata:usercomp:userid'] = 'ID uživatele, držitele kompetence';
$string['privacy:metadata:userevidence:description'] = 'Popis evidence';
$string['privacy:metadata:userevidence:name'] = 'Název evidence předchozího studia';
$string['privacy:metadata:userevidence:url'] = 'Adresa URL přidružená k evidenci';
$string['privacy:metadata:usermodified'] = 'Uživatel, který záznam vytvořil nebo upravil';
$string['privacy:path:plans'] = 'Učební plán';
$string['privacy:path:relatedtome'] = 'Související se mnou';
$string['privacy:path:userevidence'] = 'Evidence předchozího studia';
$string['pushcourseratingstouserplans'] = 'Hodnocení z kurzů vnutit do individuálních studijních plánů';
$string['pushcourseratingstouserplans_desc'] = 'Výchozí hodnota nastavení kurzu pro aktualizaci individuálních studijních plánů, jsou-li hodnoceny kompetence kurzu.';
$string['syncplanscohorts'] = 'Synchronizace plánů ze šablony studijního plánu globálních skupin';
$string['taxonomy_behaviour'] = 'Chování';
$string['taxonomy_competency'] = 'Kompetence';
$string['taxonomy_concept'] = 'Pojem';
$string['taxonomy_domain'] = 'Oblast';
$string['taxonomy_indicator'] = 'Ukazatel';
$string['taxonomy_level'] = 'Úroveň';
$string['taxonomy_outcome'] = 'Výstup';
$string['taxonomy_practice'] = 'Praxe';
$string['taxonomy_proficiency'] = 'Odbornost';
$string['taxonomy_skill'] = 'Dovednost';
$string['taxonomy_value'] = 'Hodnota';
$string['usercommentedonacompetency'] = '{$a->fullname} komentář kompetence "{$a->competency}":

{$a->comment}

Prohlédnout na: {$a->url}';
$string['usercommentedonacompetencyhtml'] = '<p>{$a->fullname} komentář kompetence "{$a->competency}":</p>
<div>{$a->comment}</div>
<p>Prohlédnout na: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonacompetencysmall'] = '{$a->fullname} komentář kompetence "{$a->competency}".';
$string['usercommentedonacompetencysubject'] = '{$a} komentář kompetence.';
$string['usercommentedonaplan'] = '{$a->fullname} komentář k studijnímu plánu "{$a->plan}":

{$a->comment}

Prohlédnout na: {$a->url}';
$string['usercommentedonaplanhtml'] = '<p>{$a->fullname} komentář k studijnímu plánu "{$a->plan}":</p>
<div>{$a->comment}</div>
<p>Prohlédnout na: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonaplansmall'] = '{$a->fullname} komentář k studijnímu  plánu "{$a->plan}".';
$string['usercommentedonaplansubject'] = '{$a} komentář k studijnímu plánu.';
$string['usercompetencystatus_idle'] = 'Nečinný';
$string['usercompetencystatus_inreview'] = 'V revizi';
$string['usercompetencystatus_waitingforreview'] = 'Čekání na revizi';
$string['userplans'] = 'Studijní plány';
