<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'scorm', language 'sr_lt', branch 'MOODLE_37_STABLE'
 *
 * @package   scorm
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activation'] = 'Aktivacija';
$string['activityloading'] = 'Bićete automatski preusmereni na ovu aktivnost za';
$string['activityoverview'] = 'Imate SCORM pakete na koje treba obratiti pažnju';
$string['activitypleasewait'] = 'Aktivnost se učitava, molimo sačekajte...';
$string['adminsettings'] = 'Administratorska podešavanja';
$string['advanced'] = 'Parametri';
$string['aicchacpkeepsessiondata'] = 'Podaci o AICC HACP sesiji';
$string['aicchacpkeepsessiondata_desc'] = 'Vremenski period, u danima, tokom kojeg će se održavati spoljna AICC HACP sesija (velike vrednosti će ispuniti tabelu sa starim podacima, ali to može biti korisno prilikom otklanjanja grešaka)';
$string['aicchacptimeout'] = 'Vreme isteka AICC HACP sesije';
$string['aicchacptimeout_desc'] = 'Vremenski period, u minutima, tokom kojeg spoljna AICC HACP sesija može da ostane otvorena';
$string['aiccuserid'] = 'AICC prenos numeričkog korisničkog identifikatora';
$string['aiccuserid_desc'] = 'AICC standard za korisnička imena je u poređenju sa Moodleom veoma restriktivan, i dozvoljava samo alfanumeričke oznake, crtu i donju crtu. Tačke, razmaci i simbol @ nisu dopušteni. Ukoliko je omogućeno, AICC paketu se umesto korisničkih imena prosleđuje ID broj korisnika.';
$string['aliasonly'] = 'Prilikom izbora imsmanifest.xml  datoteke iz repozitorijuma morate da koristite alijas/prečicu za tu datoteku.';
$string['allowapidebug'] = 'Aktiviraj API za otklanjanje grešaka i praćenje (podesite masku za hvatanje sa apidebugmask)';
$string['allowtypeaicchacp'] = 'Omogući spoljni AICC HACP';
$string['allowtypeaicchacp_desc'] = 'Ako je omogućeno, ovo će dozvoliti spoljnu AICC HACP komunikaciju, a da se pri tome ne traži prijava korisnika  za slanje zahteve iz spoljnog AICC paketa';
$string['allowtypeexternal'] = 'Omogući spoljašnji tip paketa';
$string['allowtypeexternalaicc'] = 'Omogući direktni AICC URL';
$string['allowtypeexternalaicc_desc'] = 'Ako je omogućeno ovo će dozvoliti direktan url pristup jednostavnom AICC paketu';
$string['allowtypelocalsync'] = 'Omogući preuzeti tip paketa';
$string['apidebugmask'] = 'Maska za hvatanje API sistema za otklanjanje grešaka - koristi jednostavan regularni izraz na <username>:<activityname> npr. admin:.* će otkloniti greške samo za admin korisnika';
$string['areacontent'] = 'Datoteke sadržaja';
$string['areapackage'] = 'Datoteka paketa';
$string['asset'] = 'Element';
$string['assetlaunched'] = 'Element - Pregledano';
$string['attempt'] = 'Покушај';
$string['attempt1'] = '1 pokušaj';
$string['attempts'] = 'Pokušaji';
$string['attemptsmanagement'] = 'Upravljanje pokušajima';
$string['attemptstatusall'] = 'Контролни панел и улазна страница';
$string['attemptstatusentry'] = 'Samo ulazna stranica';
$string['attemptstatusmy'] = 'Samo \'Kontrolni panel\'';
$string['attemptsx'] = '{$a} pokušaj(a)';
$string['attr_error'] = 'Neadekvatne vrednosti za atribut ({$a->attr}) u oznaci {$a->tag}.';
$string['autocommit'] = 'Automatski predaj';
$string['autocommitdesc'] = 'Automatski čuvaj SCORM podatke ako ih SCORM paket ne čuva.';
$string['autocommit_help'] = 'Ako je ovo podešavanje uključeno, SCORM podaci se automatski čuvaju u bazi. Ovo je korisno za SCORM objekte koji ne čuvaju svoje podatke redovno.';
$string['autocontinue'] = 'Automatski nastavak';
$string['autocontinuedesc'] = 'Ako je ova opcija omogućena, naredni objekti učenja se automatski pokreću. U suprotnom mora se upotrebiti dugme \'Nastavi\'.';
$string['autocontinue_help'] = 'Ako je ova opcija omogućena, naredni objekti učenja se automatski pokreću. U suprotnom mora se upotrebiti dugme \'Nastavi\'.';
$string['averageattempt'] = 'Prosečni broj pokušaja';
$string['badarchive'] = 'Morate obezbediti validnu zip datoteku';
$string['badimsmanifestlocation'] = 'Datoteka imsmanifest.xml je pronađena ali nije u korenu Vaše zip datoteke, molimo ponovo zapakujte Vaš SCORM paket';
$string['badmanifest'] = 'Ima grešaka u manifestu: pogledajte izveštaj o greškama';
$string['browse'] = 'Pregled';
$string['browsed'] = 'Pretraženo';
$string['browsemode'] = 'Režim pregleda';
$string['browserepository'] = 'Pretraga repozitorijuma';
$string['calculatedweight'] = 'Izračunati ponder';
$string['calendarend'] = '{$a} se zatvara';
$string['calendarstart'] = '{$a} se otvara';
$string['cannotaccess'] = 'Ne možete pozvati ovaj skript na taj način';
$string['cannotfindsco'] = 'Nije bilo moguće naći SCO';
$string['chooseapacket'] = 'Izaberi ili ažuriraj SCORM paket';
$string['closebeforeopen'] = 'Naveli ste datum zatvaranja pre datuma otvaranja.';
$string['collapsetocwinsize'] = 'Skupi sadržaj kada je veličina prozora ispod';
$string['collapsetocwinsizedesc'] = 'Ovo podešavanje vam dozvoljava da odredite veličinu prozora ispod koje sadržaj treba automatski da se skupi.';
$string['compatibilitysettings'] = 'Podešavanja kompatibilnosti';
$string['completed'] = 'Završeno';
$string['completionscorerequired'] = 'Zahtevaj minimalni rezultat';
$string['completionscorerequireddesc'] = 'Minimalan rezultat od {$a} je potreban za završetak';
$string['completionscorerequired_help'] = 'Ako je omogućeno, ovo podešavanje tražiti od korisnik da ima barem minimalan rezultat kako bi ova SCORM aktivnost bila obeležena kao završena, isto kao i bilo koji drugi uslov za završetak aktivnosti.';
$string['completionstatusallscos'] = 'Zahtevaj sve deljive objekte sadržaja da bi se vratio kompletan status';
$string['completionstatusallscos_help'] = 'Neki SCORM paketi sadrže višestruke komponente ili deljive objekte sadržaja ("scos") - kada je to omogućeno svi deljivi objekti sadržaja u okviru paketa moraju vraćati relevantan lesson_status da bi se ova aktivnost označila kao ispunjena.';
$string['completionstatus_completed'] = 'Završeno';
$string['completionstatus_passed'] = 'Položen';
$string['completionstatusrequired'] = 'Zahtevaj status';
$string['completionstatusrequireddesc'] = 'Polaznik mora da postigne najmanje jedan od sledećih statusa: {$a}';
$string['completionstatusrequired_help'] = 'Izbor jednog ili više statusa zahtevaće od korisnika da ispuni  najmanje jedan od označenih statusa, kako bi ova SCORM aktivnost bila obeležena kao završena, isto kao i bilo koji drugi uslovi za završetak aktivnosti.';
$string['confirmloosetracks'] = 'UPOZORENjE: Izgleda da je paket promenjen ili modifikovan. Ako je struktura paketa promenjena, podaci o nekim aktivnostima korisnika se mogu izgubiti tokom procesa ažuriranja.';
$string['contents'] = 'Sadržaj';
$string['coursepacket'] = 'Paket kursa';
$string['coursestruct'] = 'Struktura kursa';
$string['crontask'] = 'Obrada SCORM aktivnosti u pozadini';
$string['currentwindow'] = 'Trenutno otvoren prozor';
$string['datadir'] = 'Грешка система датотека: није могуће креирати директоријум за податке курса';
$string['defaultdisplaysettings'] = 'Podrazumevana podešavanja prikaza';
$string['defaultgradesettings'] = 'Podrazumevana podešavanja ocene';
$string['defaultothersettings'] = 'Ostala podrazumevana podešavanja';
$string['deleteallattempts'] = 'Obriši sve pokušaje pregleda SCORM  paketa';
$string['deleteattemptcheck'] = 'Da li ste sigurni da želite da potpuno obrišete ove pokušaje?';
$string['deleteselected'] = 'Obriši izdvojene pokušaje';
$string['deleteuserattemptcheck'] = 'Da li ste sigurni da želite da potpuno obrišete sve svoje pokušaje?';
$string['details'] = 'Prati detalje';
$string['directories'] = 'Prikaz linkova direktorijuma';
$string['disabled'] = 'Onemogućeno';
$string['display'] = 'Prikaži paket';
$string['displayactivityname'] = 'Prikaži naziv aktivnosti';
$string['displayactivityname_help'] = 'Ova opcija odeđuje da li treba prikazati naziv aktivnosti iznad SCORM plejera';
$string['displayattemptstatus'] = 'Prikaži status pokušaja';
$string['displayattemptstatusdesc'] = 'Da li se rezime pokušaja korisnika pojavljuje u bloku za pregled kurseva na \'Kontrolnom panelu\' i/ili na ulaznoj stranici SCORM  paketa.';
$string['displayattemptstatus_help'] = 'Ovaj parametar omogućava da rezime korisnikovih pokušaja bude prikazan u bloku za pregled kurseva na \'Kontrolnom panelu\' i/ili SCORM ulaznoj stranici.';
$string['displaycoursestructure'] = 'Prikaži strukturu kursa na ulaznoj stranici';
$string['displaycoursestructuredesc'] = 'Ako je omogućena ova opcija, sadržaj se prikazuje na ulaznoj stranici SCORM paketa.';
$string['displaycoursestructure_help'] = 'Ako je omogućena ova opcija, sadržaj se prikazuje na ulaznoj stranici SCORM paketa.';
$string['displaydesc'] = 'Da li prikazati SCORM paket u novom prozoru.';
$string['displaysettings'] = 'Podešavanja prikaza';
$string['dnduploadscorm'] = 'dodaj SCORM paket';
$string['domxml'] = 'DOMXML eksterna biblioteka';
$string['duedate'] = 'Krajnji rok';
$string['element'] = 'Element';
$string['enter'] = 'Uđi';
$string['entercourse'] = 'Uđi u SCORM kurs';
$string['errorlogs'] = 'Zapis o greškama';
$string['eventattemptdeleted'] = 'Pokušaj obrisan';
$string['eventinteractionsviewed'] = 'Interakcije prikazane';
$string['eventreportviewed'] = 'Izveštaj prikazan';
$string['eventscolaunched'] = 'SCORM pokrenut';
$string['eventscorerawsubmitted'] = 'Neobrađeni rezultat predatog SCORM paketa';
$string['eventstatussubmitted'] = 'Status predatog SCORM paketa';
$string['eventtracksviewed'] = 'Zapisi prikazani';
$string['eventuserreportviewed'] = 'Izveštaj o korisniku prikazan';
$string['everyday'] = 'Svakodnevno';
$string['everytime'] = 'Pri svakom korišćenju';
$string['exceededmaxattempts'] = 'Dostigli ste maksimalan broj pokušaja';
$string['exit'] = 'Izađi iz SCORM kursa';
$string['exitactivity'] = 'Izađi iz aktivnosti';
$string['expired'] = 'Oprostite, ova aktivnost je zatovrena {$a} i nije više dostupna';
$string['external'] = 'Ažuriraj vremensko usklađivanje eksternih paketa';
$string['failed'] = 'Nepoložen';
$string['finishscorm'] = 'Ako ste završili sa pregledom ovog resursa, {$a}';
$string['finishscormlinkname'] = 'kliknite ovde za povratak na početnu stranicu kursa';
$string['firstaccess'] = 'Prvi pristup';
$string['firstattempt'] = 'Prvi pokušaj';
$string['floating'] = 'Plutajuća';
$string['forceattemptalways'] = 'Uvek';
$string['forceattemptoncomplete'] = 'Kada je prethodni pokušaj završen, položen ili nepoložen';
$string['forcecompleted'] = 'Prinudni završetak';
$string['forcecompleteddesc'] = 'Ovaj parametar definiše podrazumevanu vrednost za prinudni završetak';
$string['forcecompleted_help'] = 'Ako je ova opcija omogućena, status trenutnih pokušaja se prinudno označava kao "završeno". Ovo podešavanje je primenjivo samo za SCORM 1.2 pakete.';
$string['forcejavascript'] = 'Primoraj korisnike da omoguće JavaScript';
$string['forcejavascript_desc'] = 'Ako je ova opcija omogućena (preporučeno), ona će sprečiti pristup SCORM objektima kada u korisnikovom veb čitaču JavaScript nije podržan/omogućen. Ako je JavaScript onemogućen korisnik će moći da vidi SCORM, ali API komunikacija će biti neuspešna, a informacije o oceni neće biti sačuvane.';
$string['forcejavascriptmessage'] = 'Da biste videli ovaj objekat neophodan je JavaScript, pa vas molimo da ga omogućite u svom veb čitaču i pokušate ponovo.';
$string['forcenewattempts'] = 'Prinudni novi pokušaj';
$string['forcenewattempts_help'] = 'Postoje 3 opcije:

* Ne - Ako je prethodni pokušaj završen, položen ili nepoložen, polaznik će biće ponuđena opcija da uđe u režim pregleda ili da započne novi pokušaj.
* Kada je prethodni pokušaj završen, položen ili nepoložen - ovo se oslanja na SCORM paket koji podešava status kao \'završen\', \'položen\' ili \'nepoložen\'.
* Uvek - Svaki ponovni ulazak u SCORM aktivnost će generisati novi pokušaj i polaznik neće biti vraćen na istu tačku koju je dosegnuo u svom prethodnom pokušaju.';
$string['found'] = 'Manifest je nađen';
$string['frameheight'] = 'Visina okvira ili prozora.';
$string['framewidth'] = 'Širina okvira ili prozora.';
$string['fromleft'] = 'Od leve ivice';
$string['fromtop'] = 'Od gornje ivice';
$string['fullscreen'] = 'Popuni ceo ekran';
$string['general'] = 'Opšti podaci';
$string['gradeaverage'] = 'Prosečna ocena';
$string['gradeforattempt'] = 'Ocena za pokušaj';
$string['gradehighest'] = 'Najviša ocena';
$string['grademethod'] = 'Metod ocenjivanja';
$string['grademethoddesc'] = 'Metod ocenjivanja definiše kako se određuje ocena za pojedinačni pokušaj.';
$string['grademethod_help'] = 'Način ocenjivanja definiše način kako će se ocenjivati pojedinačni pokušaji:

Postoje 4 načina ocenjivanja:

* Objekti učenja - broj završenih objekata učenja
* Najviša ocena - najviša ocena dobijena za sve završene objekte učenja
* Prosečna ocena - srednja vrednost svih rezultata
* Zbirna ocena - suma svih rezultata';
$string['gradereported'] = 'Izveštaj o ocenama';
$string['gradescoes'] = 'Objekti za učenje';
$string['gradesettings'] = 'Podešavanja ocene';
$string['gradesum'] = 'Konačna ocena';
$string['height'] = 'Visina';
$string['hidden'] = 'Sakriveno';
$string['hidebrowse'] = 'Onemogući mod prikaza';
$string['hidebrowsedesc'] = 'Režim pregleda dozvoljava polaznicima da pregledaju aktivnost pre nego što pokušaju da je reše.';
$string['hidebrowse_help'] = 'Režim pregleda omogućava polaznicima da pregledaju aktivnost pre neko što pokušaju da je reše. Ako je režim pregleda onemogućen, onda će dugme za pregled biti sakriveno.';
$string['hideexit'] = 'Sakrij link za izlaz';
$string['hidereview'] = 'Sakrij dugme za pregled';
$string['hidetoc'] = 'Prikaz strukture kursa u plejeru';
$string['hidetocdesc'] = 'Ovo podešavanje određuje kako će sadržaj biti prikazan u SCORM plejeru.';
$string['hidetoc_help'] = 'Kako se prikazuje sadržaj u SCORM plejeru.';
$string['highestattempt'] = 'Najbolji pokušaj';
$string['identifier'] = 'Identifikator pitanja';
$string['incomplete'] = 'Nepotpuno';
$string['indicator:cognitivedepth'] = 'SCORM - kognitivni aspekt';
$string['indicator:cognitivedepth_help'] = 'Ovaj indikator se zasniva na kognitivnoj dubini koju je polaznik postigao u okviru aktivnosti \'SCORM\'.';
$string['indicator:socialbreadth'] = 'SCORM - socijalni aspekt';
$string['indicator:socialbreadth_help'] = 'Ovaj indikator se zasniva na obimu socijalnih interakcija koji je polaznik postigao u okviru aktivnosti \'SCORM\'.';
$string['info'] = 'Informacije';
$string['interactions'] = 'Interakcije';
$string['invalidactivity'] = 'SCORM aktivnost je neispravna';
$string['invalidhacpsession'] = 'Neispravna HACP sesija';
$string['invalidmanifestname'] = 'Mogu biti izabrane samo imsmanifest.xml ili .zip datoteke';
$string['invalidmanifestresource'] = 'UPOZORENjE: Sledeći resursi su navedeni u vašoj manifest datoteci ali nisu mogle biti pronađeni:';
$string['invalidstatus'] = 'Nevalidni status';
$string['invalidurl'] = 'Navedena je neispravna URL adresa';
$string['invalidurlhttpcheck'] = 'Navedena je neispravna URL adresa. Poruka o grešci:<pre>{$a->cmsg}</pre>';
$string['last'] = 'Poslednji put pristupljeno dana';
$string['lastaccess'] = 'Poslednji pristup';
$string['lastattempt'] = 'Poslednji završeni pokušaj';
$string['lastattemptlock'] = 'Zaključaj nakon završnog pokušaja';
$string['lastattemptlockdesc'] = 'Ako je omogućena ova opcija, polaznik neće moći da pokrene SCORM plejer nakon što iskoristi sve dozvoljene pokušaje.';
$string['lastattemptlock_help'] = 'Ako je omogućena ova opcija, polaznik neće moći da pokrene SCORM plejer nakon što iskoristi sve dozvoljene pokušaje.';
$string['location'] = 'Prikaži lokacionu liniju';
$string['masteryoverride'] = 'Rezultat vičnosti se prepisuje preko statusa';
$string['masteryoverridedesc'] = 'Ovo podešavanje postavlja podrazumevano ponašanje za postavku prepisivanja rezultata vičnosti';
$string['masteryoverride_help'] = 'Ako je ovo podešavanje omogućeno i dat je rezultat vičnosti, kad se pozove LMSFinish i postavi se sirov rezultat status će biti preračunat korišćenjem sirovog rezultata i rezultata vičnosti i on će biti prepisan preko bilo kog statusa dobijenog od SCORM paketa (uključujući "nije završen").';
$string['max'] = 'Najbolji rezultat';
$string['maximumattempts'] = 'Broj pokušaja';
$string['maximumattemptsdesc'] = 'Ovaj parametar definiše podrazumevani maksimalan broj dozvoljenih pokušaja za aktivnost';
$string['maximumattempts_help'] = 'Ovo podešavanje omogućava ograničenje broja pokušaja. Primenjivo je samo za SCORM 1.2 i AICC pakete.';
$string['maximumgradedesc'] = 'Ovaj parametar definiše podrazumevanu maksimalnu ocenu za aktivnost';
$string['menubar'] = 'Prikaži liniju menija';
$string['min'] = 'Najlošiji rezultat';
$string['missing_attribute'] = 'Nedostaje atribut {$a->attr} u oznaci {$a->tag}';
$string['missingparam'] = 'Neophodan parametar nedostaje ili je pogrešan';
$string['missing_tag'] = 'Nedostaje oznaka {$a->tag}';
$string['mode'] = 'Režim rada';
$string['modulename'] = 'SCORM paket';
$string['modulename_help'] = 'SCORM i AICC predstavljaju skup datoteka koje su pakovane prema dogovorenom standardu za objekte učenja. Modul aktivnosti SCORM omogućava da se SCORM ili AICC paketi postave kao zip arhive i dodaju na kurs.

Sadržaj paketa se obično prikazuje na nekoliko stranica zajedno sa navigacijom. Postoje različite opcije za prikazivanje sadržaja u iskačućem prozoru, sa tabelom sadržaja, sa navigacionim dugmadima itd, SCORM aktivnosti obično sadrže pitanja, sa ocenama koje se beleže u knjigu ocena.

SCORM aktivnosti mogu da se koriste:

* za prikazivanje multimedijalnog sadržaja i animacija
* kao sredstvo za procenu';
$string['modulenameplural'] = 'SCORM paketi';
$string['myaiccsessions'] = 'Moje AICC sesije';
$string['myattempts'] = 'Moji pokušaji';
$string['nav'] = 'Prikaži navigaciju';
$string['navdesc'] = 'Ovo podešavanje određuje da li treba prikazati ili sakriti dugmad za navigaciju, kao i njihov položaj.';
$string['nav_help'] = 'Ovo podešavanje određuje da li treba prikazati ili sakriti dugmad za navigaciju, kao i njihov položaj.

Postoje tri mogućnosti:

* Ne - dugmad za navigaciju se ne prikazuju
* Ispod sadržaja - dugmad za navigaciju se prikazuju ispod sadržaja SCORM paketa
* Plutajuća dugmad - dugmad za navigaciju se prikazuju kao plutajuća dugmad; položaj  dugmadi za navigaciju, od vrha i sleva, određen je od strane paketa.';
$string['navigation'] = 'Navigacija';
$string['navpositionleft'] = 'Pozicija dugmadi za navigaciju u odnosu na levu ivicu prozora, u pikselima.';
$string['navpositiontop'] = 'Pozicija dugmadi za navigaciju u odnosu na gornju ivicu prozora, u pikselima.';
$string['networkdropped'] = 'SCORM plejer je otkrio da je vaša internet veza nepouzdana ili da je u prekidu. Ako nastavite sa ovom  SCORM aktivnošću, vaše napredovanje možda neće biti sačuvano.<br />
Najbolje će biti da sada napustite ovu aktivnost i ponovo je pokrenete kada budete uspostavili pouzdanu internet vezu.';
$string['newattempt'] = 'Počni novi pokušaj';
$string['next'] = 'Nastavak';
$string['noactivity'] = 'Nema podataka za izveštaj';
$string['noattemptsallowed'] = 'Broj dozvoljenih pokušaja';
$string['noattemptsmade'] = 'Broj pokušaja koji ste imali';
$string['no_attributes'] = 'Oznaka {$a->tag} mora imati atribute';
$string['no_children'] = 'Oznaka {$a->tag} mora imati potomke';
$string['nolimit'] = 'Neograničeni broj pokušaja';
$string['nomanifest'] = 'Nekorektno pakovanje datoteke - nedostaje imsmanifest.xml ili AICC struktura';
$string['noprerequisites'] = 'Nažalost, niste ispunili dovoljno preduslova za pristup ovoj aktivnosti.';
$string['noreports'] = 'Nema izveštaja za prikaz';
$string['normal'] = 'Normalno';
$string['noscriptnoscorm'] = 'Vaš veb čitač ne podržava Javascript ili je u njegovim podešavanjima isključena podrška za Javascript. SCORM paket možda neće moći da bude prikazan ili da sačuva podatke ispravno.';
$string['notattempted'] = 'Nije pokušavano';
$string['not_corr_type'] = 'Neslaganje tipova za oznaku {$a->tag}';
$string['notopenyet'] = 'Oprostite, ali ova aktivnost nije dostupna do {$a}';
$string['objectives'] = 'Ciljevi';
$string['openafterclose'] = 'Naveli ste datum otvaranja nakon datuma zatvaranja';
$string['optallstudents'] = 'svi korisnici';
$string['optattemptsonly'] = 'samo korisnici sa pokušajima';
$string['options'] = 'Opcije (onemogućeno u nekim veb čitačima)';
$string['optionsadv'] = 'Opcije (napredne)';
$string['optionsadv_desc'] = 'Ako je potvrđeno, širina i visina će biti prikazani u obrascu kao napredna podešavanja.';
$string['optnoattemptsonly'] = 'samo korisnici bez pokušaja';
$string['organization'] = 'Organizacija';
$string['organizations'] = 'Organizacije';
$string['othersettings'] = 'Dodatna podešavanja';
$string['package'] = 'Paket';
$string['packagedir'] = 'Greška u sistema datoteka: nije moguće kreirati direktorijum paketa';
$string['packagefile'] = 'Nije navedena datoteka s paketom';
$string['packagehdr'] = 'Paket';
$string['package_help'] = 'Datoteka paketa je zip (ili pif) arhiva koja sadrži datoteke SCORM/AICC kursa.';
$string['packageurl'] = 'jedinstvena adresa resursa';
$string['packageurl_help'] = 'Ovo podešavanje omogućava da se navede URL adresa SCORM paketa, umesto da se datoteka bira na uobičajeni način putem birača datoteka.';
$string['page-mod-scorm-x'] = 'Bilo koja stranica modula SCORM';
$string['pagesize'] = 'Veličina stranice';
$string['passed'] = 'Položeno';
$string['php5'] = 'PHP 5 (DOMXML izvorna biblioteka)';
$string['pluginadministration'] = 'Administracija SCORM/AICC paketa';
$string['pluginname'] = 'SCORM paket';
$string['popup'] = 'Novi prozor';
$string['popuplaunched'] = 'Ovaj SCORM paket pokrenut je u iskačućem prozoru. Ako se završili sa pregledom ovog resursa kliknite ovde za povratak na stranicu kursa.';
$string['popupmenu'] = 'U padajućem meniju';
$string['popupopen'] = 'Otvori paket u novom prozoru';
$string['popupsblocked'] = 'Izgleda da su iskačući prozori blokirani, što sprečava da SCORM modul bude pokrenut. Molimo, proverite podešavanja svog Web čitača, pre nego što pokušate ponovo.';
$string['position_error'] = 'Oznaka {$a->tag} ne može biti podređena oznaci {$a->parent}';
$string['preferencespage'] = 'Podešavanja samo za ovu stranicu';
$string['preferencesuser'] = 'Parametri za ovaj izveštaj';
$string['prev'] = 'Prethodni';
$string['privacy:metadata:aicc:data'] = 'Lični podaci koji se prenose sa AICC/SCORM podsistema.';
$string['privacy:metadata:aicc:externalpurpose'] = 'Ovaj dodatak šalje podatke van sistema koristeći AICC HACP.';
$string['privacy:metadata:aicc_session:lessonstatus'] = 'Status lekcije koji treba pratiti';
$string['privacy:metadata:aicc_session:scormmode'] = 'Mod elementa koji treba pratiti';
$string['privacy:metadata:aicc_session:scormstatus'] = 'Status elementa koji treba pratiti';
$string['privacy:metadata:aicc_session:sessiontime'] = 'Vreme sesije koje treba pratiti';
$string['privacy:metadata:aicc_session:timecreated'] = 'Vreme kada je praćeni element kreiran';
$string['privacy:metadata:attempt'] = 'Broj pokušaja';
$string['privacy:metadata:scoes_track:element'] = 'Naziv elementa koji treba pratiti';
$string['privacy:metadata:scoes_track:value'] = 'Vrednost datog elementa';
$string['privacy:metadata:scorm_aicc_session'] = 'Informacije o sesiji AICC HACP-a';
$string['privacy:metadata:scorm_scoes_track'] = 'Praćeni podaci za SCO-e koji pripadaju aktivnosti';
$string['privacy:metadata:timemodified'] = 'Vreme kada je praćeni element poslednji put izmenjen';
$string['privacy:metadata:userid'] = 'Identifikator korisnika koji je pristupio SCORM aktivnosti';
$string['protectpackagedownloads'] = 'Zaštiti paket od preuzimanja.';
$string['protectpackagedownloads_desc'] = 'Ako je ova opcija omogućena SCORM paket može da se preuzme samo ukoliko korisnik ima sposobnost course:manageactivities. Ako je opcija onemogućena, SCORM paket može uvek da se preuzme (putem mobilnog uređaja ili na drugi način).';
$string['raw'] = 'Neobrađeni rezultat';
$string['regular'] = 'Regularni manifest';
$string['report'] = 'Izveštaj';
$string['reportcountallattempts'] = '{$a->nbattempts} pokušaja for {$a->nbusers} korisnika, od ukupno {$a->nbresults} rezultata';
$string['reportcountattempts'] = '{$a->nbresults} rezultata ({$a->nbusers} korisnika)';
$string['reports'] = 'Izveštaji';
$string['repositorynotsupported'] = 'Овај репозиторијум не подржава директно повезивање са imsmanifest.xml датотеком.';
$string['response'] = 'Odgovor';
$string['result'] = 'Rezultat';
$string['results'] = 'Rezultati';
$string['review'] = 'Pregled';
$string['reviewmode'] = 'Režim prikaza';
$string['rightanswer'] = 'Tačan odgovor';
$string['scoes'] = 'Objekti za učenje';
$string['score'] = 'Rezultat';
$string['scorm:addinstance'] = 'Додај нови SCORM  пакет';
$string['scormclose'] = 'Dostupno do';
$string['scormcourse'] = '(SCORM) kurs za učenje';
$string['scorm:deleteownresponses'] = 'Obriši svoje pokušaje';
$string['scorm:deleteresponses'] = 'Obriši SCORM pokušaje';
$string['scormloggingoff'] = 'API izveštavanje je isključeno';
$string['scormloggingon'] = 'API izveštavanje je uključeno';
$string['scormopen'] = 'Datum od kog će biti dostupno:';
$string['scormresponsedeleted'] = 'Obrisani pokušaji korisnika';
$string['scorm:savetrack'] = 'Sačuvaj zapise';
$string['scorm:skipview'] = 'Preskakanje pregleda';
$string['scormstandard'] = 'Režim SCORM standarda';
$string['scormstandarddesc'] = 'Kada je onemogućeno, Moodle dozvoljava SCORM 1.2 paketima da čuvaju više podataka nego što specifikaija dopušta, i koristi Moodle podešavanja za formata punog imena kada prosleđuju korisničko ime SCORM paketu.';
$string['scormtype'] = 'Tip';
$string['scormtype_help'] = 'Ovo podešavanje određuje kako će paket biti uključen u kurs. Postoje 4 mogućnosti:

* Postavljeni paket - omogućava da SCORM paket bude izabran putem birača datoteka
* Eksterni SCORM manifest - omogućava da bude navedena URL adresa za imsmanifest.xml. Napomena: ako URL adresa ima različit naziv domena od Vašeg sajta, onda je bolja opcija "Preuzeti paket",  s obzirom da ocene neće biti sačuvane.
* Preuzeti paket - omogućava da bude navedena URL adresa paketa. Paket će biti raspakovan i sačuvan lokalno, i ažuriran kada se eksterni SCORM paket promeni
* Eksterni AICC URL - ovaj URL je početni za pojedinačnu AICC aktivnost. Pseudo paket će biti konstruisan oko nje.';
$string['scorm:viewreport'] = 'Pregled izveštaja';
$string['scorm:viewscores'] = 'Pregled rezultata';
$string['scrollbars'] = 'Dozvoli izlistavanje prozora';
$string['search:activity'] = 'SCORM paket - informacije o aktivnosti';
$string['selectall'] = 'Izaberi sve';
$string['selectnone'] = 'Poništi izbor svega';
$string['show'] = 'Prikaži';
$string['sided'] = 'Sa strane';
$string['skipview'] = 'Polaznik preskače stranicu sa strukturom sadržaja';
$string['skipviewdesc'] = 'Ovaj parametar definiše podrazumevanu vrednost koja određuje kada će biti preskočena struktura sadržaja za stranicu';
$string['skipview_help'] = 'Ovo podešavanje određuje da li stranica sa strukturom sadržaja treba uvek da bude preskočena (neprikazana). Ako paket sadrži samo jedan objekat učenja, stranica sa strukturom sadržaja može uvek biti preskočena.';
$string['slashargs'] = 'UPOZORENJE: sleš argumenti nisu dozvoljeni na ovom sajtu i objekti možda neće funkcionisati kako se očekuje!';
$string['stagesize'] = 'Veličina nivoa';
$string['stagesize_help'] = 'Ova dva podešavanja određuju širinu i visinu oktvira/prozora za objekte učenja.';
$string['started'] = 'Započeto dana';
$string['status'] = 'Status';
$string['statusbar'] = 'Prikaži statusnu liniju';
$string['student_response'] = 'Odgovor';
$string['subplugintype_scormreport'] = 'Izveštaj';
$string['subplugintype_scormreport_plural'] = 'Izveštaji';
$string['suspended'] = 'Suspendovano';
$string['syntax'] = 'Sintaksna greška';
$string['tag_error'] = 'Nepoznata oznaka ({$a->tag}) sa ovim sadržajem: {$a->value}';
$string['time'] = 'Vreme';
$string['title'] = 'Naslov';
$string['toc'] = 'Sadržaj';
$string['toolbar'] = 'Prikaži traku sa alatkama';
$string['too_many_attributes'] = 'Oznaka {$a->tag} ima jako puno karakteristika';
$string['too_many_children'] = 'Oznaka {$a->tag} ima jako puno potomaka';
$string['totaltime'] = 'Vreme';
$string['trackcorrectcount'] = 'Ispravi prebrajanje';
$string['trackcorrectcount_help'] = 'Broj tačnih rezultata za pitanje';
$string['trackid'] = 'ID';
$string['trackid_help'] = 'Ovo je identifikator koji je postavio vaš SCORM paket za ovo pitanje: SCORM specifikacija ne dopušta da se koristi ceo tekst pitanja.';
$string['trackingloose'] = 'UPOZORENJE: Podaci o praćenju ovog SCORM paketa biće izgubljeni!';
$string['tracklatency'] = 'Latencija';
$string['tracklatency_help'] = 'Vreme proteklo između trenutka kada je ineterakcija postala dostupna polazniku i trenutka prvog odgovora';
$string['trackpattern'] = 'Obrazac';
$string['trackpattern_help'] = 'Ovako bi trebalo da glasi tačan odgovor na ovo pitanje; ne prikazuje odgovore polaznika.';
$string['trackresponse'] = 'Odgovor';
$string['trackresponse_help'] = 'Ovo je odgovor koji je dao polaznik na ovo pitanje';
$string['trackresult'] = 'Rezultat';
$string['trackresult_help'] = 'Rezultat na osnovu odgovora polaznika i tačnog odgovora';
$string['trackscoremax'] = 'Maksimalan skor';
$string['trackscoremax_help'] = 'Maksimalna vrednost u opsegu za neobrađeni rezultat';
$string['trackscoremin'] = 'Minimalan skor';
$string['trackscoremin_help'] = 'Minimalna vrednost u opsegu za neobrađeni rezultat';
$string['trackscoreraw'] = 'Neobrađeni rezultat';
$string['trackscoreraw_help'] = 'Broj koji odražava postignuće polaznika u odnosu na opseg ograničen minimalnom i maksimalnom vrednošću';
$string['tracksuspenddata'] = 'Suspenduj podatke';
$string['tracksuspenddata_help'] = 'Obezbeđuje prostor za skladištenje i preuzimanje podataka između sesija polaznika';
$string['tracktime'] = 'Vreme';
$string['tracktime_help'] = 'Vreme kada je započet pokušaj';
$string['tracktype'] = 'Tip';
$string['tracktype_help'] = 'Tip pitanja, na primer "izbor" ili "kratak odgovor"';
$string['trackweight'] = 'Težina';
$string['trackweight_help'] = 'Težina dodeljena pitanju prilikom izračunavanja rezultata.';
$string['type'] = 'Tip';
$string['typeaiccurl'] = 'URL adresa eksternog AICC paketa';
$string['typeexternal'] = 'Eksterni SCORM manifest';
$string['typelocal'] = 'Postavljeni paket';
$string['typelocalsync'] = 'Preuteti paket';
$string['undercontent'] = 'Ispod sadržaja';
$string['unziperror'] = 'Došlo je do greške prilikom raspakivanja paketa';
$string['updatefreq'] = 'Učestalost automatskog ažuriranja';
$string['updatefreqdesc'] = 'Ovaj parametar definiše podrazumevanu vrednost koja određuje učestalost automatskog ažuriranja aktivnosti';
$string['updatefreq_error'] = 'Učestalost automatskog ažuriranja se može podesiti samo onda kada se paket eksterno hostuje';
$string['updatefreq_help'] = 'Ovo omogućava da se eksterni paket automatski preuzme i ažurira';
$string['validateascorm'] = 'Proveri ispravnost SCORM paketa';
$string['validation'] = 'Rezultat provere ispravnosti';
$string['validationtype'] = 'Ovo svojstvo određuje DOMXML biblioteku koja se koristi za validaciju SCORM manifesta. Ako niste sigurni koju vrednost treba da postavite, ostavite trenutno aktivni izbor.';
$string['value'] = 'Vrednost';
$string['versionwarning'] = 'Verzija manifesta je starija od 1.3, upozorenje na oznaci {$a->tag}';
$string['viewallreports'] = 'Prikaži izveštaj za {$a} pokušaja';
$string['viewalluserreports'] = 'Prikaži izveštaj za {$a} korisnika';
$string['whatgrade'] = 'Ocenjivanje pokušaja';
$string['whatgradedesc'] = 'Da li se u knjigu ocena upisuje najveća, prosečna, ili ocena prvog odnosno poslednje završenog pokušaj, ukoliko su dozvoljeni višestruki pokušaji.';
$string['whatgrade_help'] = 'Ako su dozvoljeni višestruki pokušaji, ova podešavanje određuje da li će u knjigu ocena biti upisana najveća, srednja, ili ocena prvog odnosno poslednje završenog pokušaja.
Opcija za poslednje završeni pokušaj ne uključuje one koji imaju status neuspelog pokušaja.

Rad sa višestrukim pokušajima

* Opcija za početak novog pokušaja biće prikazana kao polje za potvrdu iznad dugmeta za ulazak, na stranici sa strukturom sadržaja. Proverite da li ste obezbedili pristup toj stranici, ako želite da dozvolite višestruke pokušaje.
* Neki SCORM paketi pametno postupaju sa novim pokušajima, ali većina ne. Ovo znači da ako korisnik nastavi sa prethodnim pokušajem, a SCORM nema sopstvenu logiku za izbegavanje prepisivanja preko prethodnog pokušaja, novi pokušaj će zameniti stari, čak iako je stari pokušaj bio obeležen sa \'završen\' ili \'položio\'.
* Podešavanja "Prinudni završetak", "Prinudni novi pokušaj" i "Zaključaj nakon poslednjeg pokušaja" takođe pružaju dodatne mogućnosti za rad sa višestrukim pokušajima.';
$string['width'] = 'Širina';
$string['window'] = 'Prozor';
$string['youmustselectastatus'] = 'Morate odabrati status koji će se zahtevati';
