<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_oauth2', language 'sr_lt', branch 'MOODLE_37_STABLE'
 *
 * @package   auth_oauth2
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accountexists'] = 'Na ovom sajtu već postoji korisnik sa ovim korisničkim imenom. Ako je ovo vaš nalog, prijavite se na sistem tako što ćete uneti korisničko ime i lozinku, i to dodati kao povezanu prijavu na stranici sa vašim parametrima.';
$string['alreadylinked'] = 'Ovaj eksterni nalog je već povezan sa nalogom na ovom sajtu';
$string['auth_oauth2description'] = 'Provera identiteta bazirana na OAuth 2 standardu';
$string['auth_oauth2settings'] = 'Podešavanja OAuth 2 provere identiteta.';
$string['confirmaccountemail'] = 'Poštovana/i {$a->fullname},

Zatraženo je otvaranje korisničkog naloga na sajtu \'{$a->sitename}\' koristeći vašu adresu e-pošte.

Da biste potvrdili svoj novi nalog, molimo vas idite na sledeću veb adresu

{$a->link}

U većini programa za elektronsku poštu, ovo bi trebalo da se pojavi kao plavo obojeni link na koji je potrebno samo kliknuti. Ako ta opcija ne funkcioniše, kopirajte navedenu adresu u adresnu liniju na vrhu prozora vašeg veb čitača.

Ukoliko vam je potrebna tehnička pomoć, molimo vas da kontaktirate administratora,
{$a->admin}

Ukoliko niste zatražili da vam se otvori novi korisnički nalog moguće je da neko drugi pokušava da vam kompromituje nalog. U tom slučaju molimo odmah kontaktirajte administratora.';
$string['confirmaccountemailsubject'] = '{$a}: potvrda naloga';
$string['confirmationinvalid'] = 'Link za potvrdu je ili nevažeći ili je istekao. Pokrenite postupak prijavljivanja ponovo kako biste generisali novu e-poruku za potvrdu.';
$string['confirmationpending'] = 'Ovaj nalog čeka potvrdu putem e-poruke.';
$string['confirmlinkedloginemail'] = 'Poštovana/i{$a->fullname},

Kreiran je zahtev za povezivanje {$a->issuername} prijave na sistem {$a->linkedemail} za vaš korisnički nalog na sajtu \'{$a->sitename}\' koristeći vašu adresu e-pošte.

Da biste potvrdili ovaj zahtev i povezali ove prijave na sistem, molimo vas idite na sledeću veb adresu

{$a->link}

U većini programa za elektronsku poštu, ovo bi trebalo da se pojavi kao plavo obojeni link na koji je potrebno samo kliknuti. Ako ta opcija ne funkcioniše, kopirajte navedenu adresu u adresnu liniju na vrhu prozora vašeg veb čitača.

Ukoliko vam je potrebna tehnička pomoć, molimo vas da kontaktirate administratora,
{$a->admin}

Ukoliko niste zatražili da vam se otvori novi korisnički nalog moguće je da neko drugi pokušava da vam kompromituje nalog. U tom slučaju molimo odmah kontaktirajte administratora.';
$string['confirmlinkedloginemailsubject'] = '{$a}: potvrda povezane prijave na sistem';
$string['createaccountswarning'] = 'Ovaj dodatak za proveru identiteta dozvoljava korisnicima da kreiraju naloge na vašem sajtu. Ako koristite ovaj dodatak poželjno bi bilo da omogućite podešavanje "authpreventaccountcreation".';
$string['createnewlinkedlogin'] = 'Poveži novi nalog ({$a})';
$string['emailconfirmlink'] = 'Poveži svoj nalog';
$string['emailconfirmlinksent'] = '<p>Pronađen je nalog, koji već postoji, sa ovom adresom e-pošte, ali još uvek nije povezan.</p>
<p>Nalozi moraju biti povezani pre nego što budete mogli da se prijavite na sistem.</p>
<p>Trebalo bi da je poslata poruka na vašu e-adresu<b>{$a}</b></p>
<p>Ona sadrži jednostavna uputstva kako da povežete svoje naloge.</p>
<p>Ukoliko i dalje budete imali poteškoća, kontaktirajte administratora sajta.</p>';
$string['emailpasswordchangeinfo'] = 'Poštovana/i {$a->firstname},

Neko (verovatno vi) je zatražio novu lozinku za vaš korisnički nalog  na sajtu \'{$a->sitename}\'.

Međutim, vaša lozinka se ne može resetovati zato što svoj nalog koristite za prijavu na drugi sajt.

Molimo vas, da se prijavite kao i pre, koristeći link na stranici za prijavu.
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Informacije o promeni lozinke';
$string['info'] = 'Eksterni nalog';
$string['issuer'] = 'OAuth 2 Servis';
$string['issuernologin'] = 'Ovaj davalac identiteta se ne može koristiti za prijavu na sistem';
$string['linkedlogins'] = 'Povezane prijave na sistem';
$string['linkedloginshelp'] = 'Pomoć za povezane prijave na sistem';
$string['loginerror_authenticationfailed'] = 'Proces provere identiteta nije uspeo.';
$string['loginerror_cannotcreateaccounts'] = 'Nalog sa vašom adresom e-pošte nije bilo moguće pronaći.';
$string['loginerror_invaliddomain'] = 'Adresa e-pošte nije dozvoljena na ovom sajtu.';
$string['loginerror_nouserinfo'] = 'Nisu dobijene nikakve korisničke informacije. Moguće da OAuth 2 servis nije ispravno konfigurisan.';
$string['loginerror_userincomplete'] = 'Dobijene korisničke informacije ne sadrža korisničko ime i adresu e-pošte. Moguće da OAuth 2 servis nije ispravno konfigurisan.';
$string['noissuersavailable'] = 'Nijedan od konfigurisanih OAuth2 servisa vam ne dozvoljava da povežete naloge za prijavu';
$string['notenabled'] = 'Nažalost, OAuth 2 dodatak za proveru identiteta nije omogućen';
$string['notloggedindebug'] = 'Pokušaj prijave na sistem nije uspeo. Razlog: {$a}';
$string['notwhileloggedinas'] = 'Ne može se upravljati povezanim prijavama dok ste prijavljeni kao drugi korisnik.';
$string['oauth2:managelinkedlogins'] = 'Upravljanje sopstvenim povezanim nalozima za prijavu';
$string['plugindescription'] = 'Ovaj dodatak za proveru identiteta prikazuje spisak konfigurisanih davalaca identiteta na stranici za prijavu na Moodle. Izbor davaoca identiteta omogućava korisnicima da se prijave na sistem sa svojim akreditivima dobijenim od OAuth 2 davaoca.';
$string['pluginname'] = 'OAuth 2';
$string['privacy:metadata:auth_oauth2'] = 'OAuth 2 provera identiteta';
$string['privacy:metadata:auth_oauth2:authsubsystem'] = 'Ovaj dodatak je povezan sa podsistemom za proveru identiteta.';
$string['privacy:metadata:auth_oauth2:confirmtoken'] = 'Token za potvrdu.';
$string['privacy:metadata:auth_oauth2:confirmtokenexpires'] = 'Vremenska oznaka kada ističe token za potvrdu.';
$string['privacy:metadata:auth_oauth2:email'] = 'Eksterna adresa elektronske pošte koja se mapira na ovaj nalog.';
$string['privacy:metadata:auth_oauth2:issuerid'] = 'ID oznaka OAuth 2 davaoca identiteta za ovu OAuth 2 prijavu na sistem';
$string['privacy:metadata:auth_oauth2:tableexplanation'] = 'OAuth 2 nalozi vezani za korisnikov Moodle nalog.';
$string['privacy:metadata:auth_oauth2:timecreated'] = 'Vremenska oznaka kada je korisnički nalog povezan sa OAuth 2 pristupom.';
$string['privacy:metadata:auth_oauth2:timemodified'] = 'Vremenska oznaka kada je ovaj zapis izmenjen.';
$string['privacy:metadata:auth_oauth2:userid'] = 'Identifikator korisničkog naloga za vezanog za OAuth 2 pristup.';
$string['privacy:metadata:auth_oauth2:usermodified'] = 'Identifikator korisnika koji je izmenio ovaj nalog.';
$string['privacy:metadata:auth_oauth2:username'] = 'Eksterno korisničko ime koja se mapira na ovaj nalog.';
