<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'analytics', language 'no', branch 'MOODLE_37_STABLE'
 *
 * @package   analytics
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['analysablenotused'] = 'Analyserbare {$a->analysableid} ikke benyttet: {$a->errors}';
$string['analysablenotvalidfortarget'] = 'Analyserbare {$a->analysableid} er ikke gyldig for dette målet: {$a->result}';
$string['analysisinprogress'] = 'Analyseres fortsatt av en tidligere kjøring';
$string['analytics'] = 'Analyser';
$string['analyticslogstore'] = 'Loggtabeller benyttet til analyse';
$string['analyticslogstore_help'] = 'Loggtabeller som blir benyttet til API-et for analyse av brukerens aktivitet';
$string['analyticssettings'] = 'Analyseinnstillinger';
$string['analyticssiteinfo'] = 'Portalinformasjon';
$string['defaultpredictionsprocessor'] = 'Standard forventingsprosessor';
$string['defaultpredictoroption'] = 'Standard prosessor ({$a})';
$string['defaulttimesplittingmethods'] = 'Standard tidsdelingsmetode for modellevaluering';
$string['defaulttimesplittingmethods_help'] = 'Tidsdelingsmetoden deler kursets varighet i deler; spådomsmotoren vil løpe på slutten av disse delene. Modellevalueringsprosessen vil gjenkjennes gjennom disse tidsdelingsmetodene med mindre en bestemt tidsbruddsmetode er spesifisert (evnen til å spesifisere en tidsoppdelingsmetode er bare tilgjengelig ved evaluering av modeller ved hjelp av kommandolinjeskriptet).';
$string['disabledmodel'] = 'Deaktivert modell';
$string['erroralreadypredict'] = 'Filen {$a} har allerede blitt brukt til å generere forventninger.';
$string['errorcannotreaddataset'] = 'Kan ikke lese datasettfilen {$a}';
$string['errorcannotwritedataset'] = 'Kan ikke skrive i datasettfilen {$a}';
$string['errorexportmodelresult'] = 'Maksinlæringsmodellen kan ikke eksporteres.';
$string['errorimport'] = 'Feil ved import av tildelt JSON-fil.';
$string['errorimportmissingclasses'] = 'Følgende analysekomponenter er ikke tilgjengelig på dette portalen: {$a->missingclasses}.';
$string['errorimportmissingcomponents'] = 'Den angitte modellen krever at følgende moduler skal installeres: {$a}. Vær oppmerksom på at versjonene ikke nødvendigvis må samsvare med versjoner som er installert i systemet. Å installere den samme eller en nyere versjon av modulen vil være nok i de fleste tilfeller.';
$string['errorimportversionmismatches'] = 'Versjonen av følgende komponenter er forskjellig fra versjonen som er installert på denne portalen:  {$a}. Du kan bruke "Ignorer versjonsfeil" alternativet å ignorere disse forskjellene.';
$string['errorinvalidindicator'] = 'Ugyldig {$a} indikator';
$string['errorinvalidtarget'] = 'Ugyldig {$a} mål';
$string['errorinvalidtimesplitting'] = 'Ugylig tidsdeling. Vennligst forsikre deg om at du legger inn det fulle klassenavnet.';
$string['errornoexportconfig'] = 'Det var et porblem med eksport av modellkonfigurasjonen.';
$string['errornoexportconfigrequirements'] = 'Kun ikke-statiske modeller med tidsdelingsmetoder kan eksporteres.';
$string['errornoindicators'] = 'Denne modellen har ingen indikatorer.';
$string['errornopredictresults'] = 'Ingen resultater fra prediksjonsprosessoren. Sjekk innholdet i resultatet for mer informasjon.';
$string['errornoroles'] = 'Student- eller lærerrollene har ikke blitt definert. Gjør dette på analyseinnstillingssiden.';
$string['errornotarget'] = 'Denne modellen har ikke noe mål';
$string['errornotimesplittings'] = 'Modellen har ingen tidsdelingsmetode.';
$string['errorpredictioncontextnotavailable'] = 'Denne prediksjonskonteksten er ikke lenger tilgjengelig.';
$string['errorpredictionformat'] = 'Feil prediksjonsberegnings format';
$string['errorpredictionnotfound'] = 'Prediksjon ikke funnet';
$string['errorpredictionsprocessor'] = 'Prediksjonsprosessor feil: {$a}';
$string['errorpredictwrongformat'] = 'Returverdiene fra prediksjonsprosessoren kan ikke dekodes: "{$a}"';
$string['errorprocessornotready'] = 'Den valgte prediksjonsprosessoren er ikke klar: {$a}';
$string['errorsamplenotavailable'] = 'Det predikerte utvalget er ikke lenger tilgjengelig';
$string['errorunexistingmodel'] = 'Ikke-eksisterende modell {$a}';
$string['errorunexistingtimesplitting'] = 'Den valgte tidsdelingsmetoden er ikke tilgjengelig';
$string['errorunknownaction'] = 'Ukjent handling';
$string['eventinsightsviewed'] = 'Innsikt vist';
$string['eventpredictionactionstarted'] = 'Prediksjonsprosessen har startet';
$string['fixedack'] = 'Anerkjente';
$string['insightinfomessage'] = 'Systemet har generert et innsiktsresultat for deg: {$a}';
$string['insightinfomessageaction'] = '{$a->text}: {$a->url}';
$string['insightinfomessagehtml'] = 'Systemet genererte et innsiktsresultat for deg';
$string['insightmessagesubject'] = 'Nytt innsiktsresultat for "{$a}"';
$string['invalidanalysablefortimesplitting'] = 'Det kan ikke analyseres ved bruk av  {$a} metoden for tidssplitting.';
$string['invalidtimesplitting'] = 'Modellen med ID  {$a} trenger en tidssplittingsmetode før den kan benyttes til øving.';
$string['levelinstitution'] = 'Utdanningsnivå';
$string['levelinstitutionisced0'] = 'Lavere enn grunnskole';
$string['levelinstitutionisced1'] = 'Grunnskole';
$string['levelinstitutionisced2'] = 'Videregående opplæring';
$string['levelinstitutionisced3'] = 'Høyere videregående opplæring';
$string['levelinstitutionisced4'] = 'Etterutdanning (kan være bedrifts- eller organisasjonsintern opplæring)';
$string['levelinstitutionisced5'] = 'Kortvarig høyere utdanning (kan være bedrifts- eller organisasjonsintern opplæring)';
$string['levelinstitutionisced6'] = 'Bachelor eller tilsvarende';
$string['levelinstitutionisced7'] = 'Master eller tilsvarende';
$string['levelinstitutionisced8'] = 'Doktorgrad eller tilsvarende';
$string['modeinstruction'] = 'Undervisningsmetode';
$string['modeinstructionblendedhybrid'] = 'Blandet, både nett og klasserom';
$string['modeinstructionfacetoface'] = 'Ansikt til ansikt';
$string['modeinstructionfullyonline'] = 'Nettundervisning';
$string['modeloutputdir'] = 'Utdata-mappe for resultater';
$string['modeloutputdirinfo'] = 'Mappe hvor prediksjonsprosessoren lagrer all evalueringsinformasjon. Nyttig for debugging og forskning.';
$string['modeltimelimit'] = 'Tidsgrense pr. model for analyse';
$string['modeltimelimitinfo'] = 'Denne innstillingen begrenser hvor mye tid hver modell kan bruke på å analysere portalinnholdet.';
$string['nocourses'] = 'Ingen kurs å analysere';
$string['nodata'] = 'Ingen data å analysere';
$string['noevaluationbasedassumptions'] = 'Modeller basert på antakelser kan ikke evalueres.';
$string['noinsights'] = 'Ingen innsiktsresultater funnet';
$string['noinsightsmodel'] = 'Denne modellen kan ikke generere noe innsiktsresultater';
$string['nonewdata'] = 'Ingen nye data er tilgjengelige';
$string['nonewranges'] = 'Ingen nye prediksjoner ennå';
$string['nonewtimeranges'] = 'Ingen nye tidsintervaller; ingenting å predikere.';
$string['nopredictionsyet'] = 'Ingen prediksjoner tilgjengelig ennå';
$string['noranges'] = 'Ingen prediksjoner ennå';
$string['notrainingbasedassumptions'] = 'Modeller basert på antakelser trenger ikke øvelse';
$string['notuseful'] = 'Ikke brukbar';
$string['novaliddata'] = 'Ingen gyldige data er tilgjengelige';
$string['novalidsamples'] = 'Det er ingen tilgjengelige gyldige prøver.';
$string['onlycli'] = 'Tillat kun start av analyseprosesser fra kommandolinja';
$string['onlycliinfo'] = 'Analyseprosesser slik som evalueringsmodeller, trening av maskinlæringsalgoritmer eller å hente ut prediksjoner, kan ta noe tid. De vil kjøre som cron-jobber eller de kan tvinges via kommandolinja. Deaktiver denne innstillingen hvis du ønsker at portaladministrator skal kunne kjøre disse prosessene manuelt via webgrensesnittet.';
$string['percentonline'] = 'Prosent nettbasert';
$string['percentonline_help'] = 'Dersom organisasjonen din tilbyr blandet opplæring, hvor stor andel av studentenes arbeid er nettbasert i Moodle? Legg inn et tall mellom 0 og 100.';
$string['predictionsprocessor'] = 'Prediksjonsprosessor';
$string['predictionsprocessor_help'] = 'En prediksjonsprosesser er en maskinlærings-backend som prosesserer datasettet som genereres ved å kalkulere modellens indikatorer og mål. Alle trenede algoritmer og prediksjoner vil bli slettet hvis du bytter til en annen prediksjonsprosessor.';
$string['privacy:metadata:analytics:indicatorcalc'] = 'Indikatorberegninger';
$string['privacy:metadata:analytics:indicatorcalc:contextid'] = 'Konteksten';
$string['privacy:metadata:analytics:indicatorcalc:endtime'] = 'Beregning sluttid';
$string['privacy:metadata:analytics:indicatorcalc:indicator'] = 'Klassen for indikatorkalkulatoren';
$string['privacy:metadata:analytics:indicatorcalc:sampleid'] = 'Eksempel ID-en';
$string['privacy:metadata:analytics:indicatorcalc:sampleorigin'] = 'Originaltabellen for prøven';
$string['privacy:metadata:analytics:indicatorcalc:starttime'] = 'Beregning starttid';
$string['privacy:metadata:analytics:indicatorcalc:timecreated'] = 'Når forventningen ble gjort';
$string['privacy:metadata:analytics:indicatorcalc:value'] = 'Den beregnede verdien';
$string['privacy:metadata:analytics:predictionactions'] = 'Forventningshandlinger';
$string['privacy:metadata:analytics:predictionactions:actionname'] = 'Handlingsnavnet';
$string['privacy:metadata:analytics:predictionactions:predictionid'] = 'ForventningsID';
$string['privacy:metadata:analytics:predictionactions:timecreated'] = 'Når forventingshandlingen be utført';
$string['privacy:metadata:analytics:predictionactions:userid'] = 'Brukeren som utførte handlingen';
$string['privacy:metadata:analytics:predictions'] = 'Forventninger';
$string['privacy:metadata:analytics:predictions:calculations'] = 'Indikatorkalkulasjoner';
$string['privacy:metadata:analytics:predictions:contextid'] = 'Konteksten';
$string['privacy:metadata:analytics:predictions:modelid'] = 'ModellIDen';
$string['privacy:metadata:analytics:predictions:prediction'] = 'Forventningsverdien';
$string['privacy:metadata:analytics:predictions:predictionscore'] = 'Forventningsverdi';
$string['privacy:metadata:analytics:predictions:rangeindex'] = 'Indeksen for tidsdelingsmetoden';
$string['privacy:metadata:analytics:predictions:sampleid'] = 'Eksempel-D';
$string['privacy:metadata:analytics:predictions:timecreated'] = 'Når forventningen ble utført';
$string['privacy:metadata:analytics:predictions:timeend'] = 'Beregning sluttid';
$string['privacy:metadata:analytics:predictions:timestart'] = 'Beregening starttid';
$string['processingsitecontents'] = 'Behandler portalinnhold';
$string['successfullyanalysed'] = 'Vellykket analysering';
$string['timesplittingmethod'] = 'Tidsdelingsmetoder';
$string['timesplittingmethod_help'] = 'Tidssplitting-metoden deler kursforløpet opp i mindre deler; og prediksjonsprosessoren vil kjøre ved slutten av hver del. Det anbefales at du kun aktiverer tidssplittingsmetoder du er interessert i å benytte. Evalueringsprosessen vil gjenkjenne via alle aktiverte tidssplittingsmetoder så hvis du aktiverer mange tidssplittingsmetoder vil evalueringsprosessen bli langsommere.';
$string['typeinstitution'] = 'Organisasjonstype';
$string['typeinstitutionacademic'] = 'Akademisk';
$string['typeinstitutionngo'] = 'NGO';
$string['typeinstitutiontraining'] = 'Bedrift';
$string['viewdetails'] = 'Vis detaljer';
$string['viewinsight'] = 'Vis innsikt';
$string['viewinsightdetails'] = 'Vis innsiktsdetaljer';
$string['viewprediction'] = 'Vis prediksjonsdetaljer';
