<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_certification', language 'pt_br', branch 'MOODLE_37_STABLE'
 *
 * @package   tool_certification
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Ações';
$string['active'] = 'Ativo';
$string['activecertifications'] = 'Certificações ativas';
$string['afterallocationdate'] = 'Após a data de alocação';
$string['aftercompletion'] = 'Após a conclusão';
$string['afterduedate'] = 'Após a data de entrega';
$string['afterpreviouscertexpdate'] = 'Após a data de expiração da certificação anterior';
$string['afterstartdate'] = 'Após a data de início';
$string['allocateusers'] = 'Alocar usuários';
$string['allocationdate'] = 'Data de alocação';
$string['allocationdateisonorafter'] = 'Data de alocação em ou após';
$string['allocationenddate'] = 'Data de término da alocação';
$string['allocationfor'] = 'Alocação para \'{$a}\\';
$string['allocationsource'] = 'Fonte de alocação';
$string['allocationstartdate'] = 'Data de início da alocação';
$string['allocationwindowenddate'] = 'Data de término';
$string['allocationwindowenddate_help'] = 'Data de término da janela de alocação';
$string['allocationwindowstartdate'] = 'Data de início';
$string['allocationwindowstartdate_help'] = 'Data de início da janela de alocação';
$string['archive'] = 'Arquivo';
$string['archived'] = 'Arquivado';
$string['archivedcertifications'] = 'Certificações arquivadas';
$string['archivedconfirmation'] = 'Tem certeza de que deseja arquivar a certificação \'{$a}\'? A certificação arquivada não estará mais disponível para gerentes ou alunos e pode ser visualizada apenas em relatórios de históricos.';
$string['archivedon'] = 'Arquivado em';
$string['autocreategroups'] = 'Adicionar a grupos de cursos';
$string['autocreategroupsasinprogram'] = 'Conforme definido no programa';
$string['autocreategroupscertification'] = 'Crie grupos para esta certificação';
$string['autocreategroups_help'] = 'Quando os usuários estão inscritos nos cursos do programa, eles podem ser adicionados automaticamente ao mesmo grupo. No caso em que "para esta certificação" for selecionado, um grupo separado para esta certificação será usado e será diferente das outras certificações usando o mesmo programa.';
$string['basic'] = 'Básico';
$string['calendarduedate'] = 'Data de entrega da certificação {$a}';
$string['calendarexpirydate'] = 'Data de expiração da certificação {$a}';
$string['cannotallocateuser'] = 'Não é possível alocar usuário para certificação {$a}';
$string['certification:allocateuser'] = 'Permissão para alocar usuário';
$string['certification:edit'] = 'Permissão para editar';
$string['certificationfullname'] = 'Nome completo da certificação';
$string['certificationfullname_help'] = 'Nome completo da certificação';
$string['certificationidnumber'] = 'Número de  ID da certificação';
$string['certificationidnumber_help'] = 'O ID  number de uma certificação é usado apenas ao fazer a correspondência com sistemas externos e não é exibido em nenhum lugar do site. Se a certificação tiver um código oficial, poderá ser inserido aqui, caso contrário o campo poderá ser deixado em branco.';
$string['certificationname'] = 'Nome da certificação';
$string['certificationnamewithlink'] = 'Nome da certificação com link';
$string['certificationprogress'] = 'Progresso da certificação';
$string['certificationrules'] = 'Regras da certificação';
$string['certifications'] = 'Certificações';
$string['certificationstatus'] = 'Status de certificação';
$string['certificationtags'] = 'Tags de certificação';
$string['certificationtags_help'] = 'Tags para esta certificação';
$string['certification:view'] = 'Permissão para visualizar';
$string['certified'] = 'Certificado';
$string['certifiedby'] = 'Certificado por';
$string['certifiedcertificationslink'] = '<a href="{$a->href}">Certificações certificadas:{$a->count}</a>';
$string['certifieddate'] = 'Data da certificação';
$string['certifieddateisonorafter'] = 'Data da certificação em ou após';
$string['certifiedtype'] = 'Tipo de certificado';
$string['certify'] = 'Certificar';
$string['certifyexpirydate'] = 'Data de expiração';
$string['certifyexpirydate_help'] = 'Selecione uma data de expiração para este usuário certificado entre \'Padrão\' (mostra a configuração de certificação atual), \'Nunca\' ou uma data personalizada.';
$string['certifyuser'] = 'Certificar usuário';
$string['conditioncertificationcertified'] = 'Certificação certificada';
$string['conditioncertificationexpired'] = 'Certificação expirada';
$string['conditioncertificationnotcertified'] = 'Certificação não certificada';
$string['conditioncertificationoverdue'] = 'Certificação vencida';
$string['conditioncertificationstatus'] = 'Status de certificação';
$string['conditioncertificationstatusdescription'] = 'Usuários com status';
$string['conditioncertificationstatusdescriptionnegated'] = 'Usuários com status  \'{$a->status}\' na certificação  \'{$a->fullname}\\';
$string['conditioncertificationsuspended'] = 'Certificação suspensa';
$string['conditionuserallocated'] = 'Usuários alocados para certificação';
$string['conditionuserallocateddescription'] = 'Usuários alocados para certificação {$a}';
$string['conditionusernotallocated'] = 'Usuários não alocados para certificação';
$string['conditionusernotallocateddescription'] = 'Usuários não alocados para certificação {$a}';
$string['confirmdeletecertification'] = 'Você tem certeza que deseja deletar a certificação \'{$a}\' e dados associados? Essa ação não pode ser desfeita.';
$string['confirmdeleteuserallocation'] = 'Tem certeza de que deseja excluir completamente a alocação do usuário \'{$a}\' e os dados associados? Essa ação não pode ser desfeita.';
$string['confirmduplicate'] = 'Uma cópia da configuração da certificação será criada e você poderá alterar o programa e outras propriedades. Nenhuma alocação de usuário será transferida para a cópia';
$string['dateoverrided'] = 'Data substituída';
$string['dayssinceallocation'] = 'Dias desde a alocação';
$string['daystakingcertification'] = 'Dias fazendo a certificação';
$string['default'] = 'Padrão';
$string['deleteuserallocation'] = 'Excluir alocação de usuário';
$string['duedate'] = 'Data de entrega';
$string['duedate_help'] = 'Data até a qual a certificação deve ser concluída';
$string['duedateisonorafter'] = 'Data de entrega em ou após';
$string['duplicate'] = 'Duplicado';
$string['dynamic'] = 'Dinâmico';
$string['dynamicrules'] = 'Regras dinâmicas';
$string['dynamicrulesplugincheck'] = 'Visualizar a lista de regras dinâmicas é impossível sem o plugin tool_dynamicrules';
$string['dynamicrulewarningdeallocation'] = 'Os usuários só podem ser desalocados se tiverem sido alocados por outra regra dinâmica; as alocações manuais não serão afetadas.';
$string['editcertification'] = 'Editar certificação \'{$a}\\';
$string['editcertificationname'] = 'Editar nome da certificação';
$string['editcertificationsettings'] = 'Editar configurações de certificação';
$string['editcontent'] = 'Editar conteúdo';
$string['editdetails'] = 'Editar Detalhes';
$string['enddate'] = 'Data de término';
$string['entitycertification'] = 'Certificação';
$string['entitycertificationusers'] = 'Alocação e conclusão de usuários de certificação';
$string['errorallocatinguserintorelatedprogram'] = 'Não é possível alocar o usuário para o programa relacionado';
$string['errorallocationsourcenotfound'] = 'Fonte de alocação não encontrada';
$string['erroralreadycertified'] = 'Usuário já certificado nesta certificação com esta data de início.';
$string['errorcantdeletecertification'] = 'Não é possível excluir a certificação';
$string['errorcantdeletenotarchivedcertification'] = 'Não é possível excluir uma certificação não arquivada';
$string['errorcantmanageusers'] = 'Não pode gerenciar usuários';
$string['errorcantrestorecertification'] = 'Não é possível restaurar a certificação';
$string['errorevaluatinguserallocationstatus'] = 'Erro ao avaliar o status de alocação de usuário';
$string['erroridnumberuniquetenant'] = 'Esse ID number já é usado em outra certificação';
$string['errorinvalidcertification'] = 'Certificação inválida';
$string['errorinvaliddate'] = 'Data inválida';
$string['errorinvalidexpirydate'] = 'Data inválida na certificação, certificado expirado';
$string['errorinvalidtimecertified'] = 'O tempo  certificado não pode estar no futuro.';
$string['errormissingassociatedprogram'] = 'Programa associado ausente';
$string['errornopermissionmanagecertifications'] = 'Sem permissão para gerenciar certificações';
$string['errornopermissionviewreports'] = 'Sem permissão para ver relatórios';
$string['errorreporttypedoesnotexist'] = 'O tipo de relatório não existe';
$string['erroruseralreadyallocatedincertification'] = 'Usuário já alocado à certificação';
$string['erroruseralreadyallocatedinprogram'] = 'Usuário já alocado ao programa';
$string['errorusernotinsametenant'] = 'Usuário não está no mesmo tenant';
$string['eventcertificationcompleted'] = 'Certificação concluída';
$string['eventcertificationcreated'] = 'Certificação criada';
$string['eventcertificationdeleted'] = 'Certificação deletada';
$string['eventcertificationupdated'] = 'Certificação atualizada';
$string['eventuserdeallocated'] = 'Usuário desalocado';
$string['eventuserupdated'] = 'Alocação de usuário atualizada';
$string['expired'] = 'Expirado';
$string['expiredcertificationslink'] = '<a href="{$a->href}">Certificações expiradas: {$a->count}</a>';
$string['expireddateisonorafter'] = 'Data de expiração em ou após';
$string['expirydate'] = 'Data de expiração';
$string['expirydate_help'] = 'Data de expiração da certificação';
$string['futureallocation'] = 'Alocação futura';
$string['idnumber'] = 'ID number';
$string['lessthanaday'] = 'Menos de um dia';
$string['manageprograms'] = 'Gerenciar programas';
$string['manual'] = 'Manual';
$string['markcertificationcompletednotice'] = 'Marque a certificação como concluída sem aguardar a conclusão do programa';
$string['messageprovider:certificationcompleted'] = 'Certificação concluída';
$string['messageprovider:certificationuserallocated'] = 'Usuário alocado';
$string['messageprovider:certificationuserdeallocated'] = 'Usuário desalocado';
$string['missingcertification'] = 'Certificação ausente';
$string['missingfullname'] = 'Nome completo ausente';
$string['missingprogram'] = 'Programa ausente';
$string['never'] = 'Nunca';
$string['newcertification'] = 'Nova certificação';
$string['newvaluefor'] = 'Novo valor para';
$string['notificationmsgcertificationcompleted'] = 'Parabéns! Você concluiu a certificação \'{$a}\'.';
$string['notificationmsgcertificationuserallocated'] = 'Você foi alocado à certificação \'{$a}\'.';
$string['notificationmsgcertificationuserdeallocated'] = 'Você foi desalocado da certificação \'{$a}\'.';
$string['notificationsubjectcertificationcompleted'] = 'Certificação \'{$a}\' concluída';
$string['notificationsubjectcertificationuserallocated'] = 'Alocado à certificação \'{$a}\\';
$string['notificationsubjectcertificationuserdeallocated'] = 'Desalocado da certificação \'{$ a}\\';
$string['notset'] = 'Não configurado';
$string['nousersselected'] = 'Por favor, selecione pelo menos um usuário';
$string['ongoingcertificationslink'] = '<a href="{$a->href}">Certificações em andamento: {$a->count}</a>';
$string['open'] = 'Aberto';
$string['outcomeallocation'] = 'Alocar usuários à certificações';
$string['outcomedeallocation'] = 'Desalocar usuários de certificações';
$string['outcomedeallocationdescription'] = 'Desalocar usuários de certificações {$a}';
$string['overdue'] = 'Vencidas';
$string['overduecertificationslink'] = '<a href="{$a->href}">Certificações atrasadas: {$a->count}</a>';
$string['pluginname'] = 'Certificações';
$string['previouscertexpirydate'] = 'Data de expiração da certificação anterior';
$string['privacy:metadata:certification_completions'] = 'Informações sobre a conclusão da certificação.';
$string['privacy:metadata:certification_completions:certificationid'] = 'A certificação que o usuário concluiu.';
$string['privacy:metadata:certification_completions:certifiedby'] = 'O usuário que gerou a certificação';
$string['privacy:metadata:certification_completions:expirydate'] = 'A data de expiração desta certificação concluída.';
$string['privacy:metadata:certification_completions:revokedby'] = 'O usuário que revogou a certificação';
$string['privacy:metadata:certification_completions:timecertified'] = 'A hora em que o usuário concluiu a certificação.';
$string['privacy:metadata:certification_completions:timecreated'] = 'A hora em que o registro de conclusão foi criado.';
$string['privacy:metadata:certification_completions:userid'] = 'O usuário que concluiu a certificação.';
$string['privacy:metadata:certification_users'] = 'Informações sobre a alocação de certificação do usuário.';
$string['privacy:metadata:certification_users:certificationid'] = 'A certificação alocada para.';
$string['privacy:metadata:certification_users:status'] = 'Se o usuário foi suspenso da certificação.';
$string['privacy:metadata:certification_users:timemodified'] = 'O tempo modificado da alocação do usuário.';
$string['privacy:metadata:certification_users:userid'] = 'O usuário alocado.';
$string['program'] = 'Programa';
$string['programcourse'] = 'Cursos do programa';
$string['progressreport'] = 'Relatório de progresso';
$string['recertduedaterelative'] = 'Data de entrega';
$string['recertexpirydate'] = 'Data de expiração';
$string['recertgraceperiod'] = 'período de carência';
$string['recertification'] = 'Recertificação';
$string['recertificationprogram'] = 'Programa de recertificação';
$string['recertstartdaterelative'] = 'Data de início';
$string['reg_wpcertifications'] = 'Número de certificações ({$a})';
$string['reportactivecerts'] = 'Relatório do sistema para certificações ativas';
$string['reportarchivedcerts'] = 'Relatório do sistema para certificações arquivadas';
$string['reportbuilderactivecertifications'] = 'A visualização da lista de certificações ativas é impossível sem o plugin tool_reportbuilder';
$string['reportbuilderarchivedcertifications'] = 'A visualização da lista de certificações arquivadas é impossível sem o plugin tool_reportbuilder';
$string['reportbuilderdynamicrules'] = 'A visualização da lista de regras dinâmicas é impossível sem o plugin tool_reportbuilder';
$string['reportbuilderuserallocations'] = 'A visualização da lista de alocações de usuários é impossível sem o plugin tool_reportbuilder';
$string['reportbuilderuserlist'] = 'A visualização da lista de usuários é impossível sem o plugin tool_reportbuilder';
$string['reportcertificationprogress'] = 'Relatório do sistema para o progresso da certificação';
$string['reportcertsusers'] = 'Relatório de sistema para usuários da certificação';
$string['reportusercerts'] = 'Relatório de sistema para a lista de certificações do usuário';
$string['requirerecertification'] = 'Exigir recertificação';
$string['restore'] = 'Restaurar';
$string['revokecertification'] = 'Revogar certificação';
$string['revoked'] = 'Revogada';
$string['revokedby'] = 'Revogada por';
$string['revokedon'] = 'Revogado em';
$string['revokewarning'] = 'Tem certeza de que deseja revogar a certificação de \'{$a}\'? Os prêmios que possam ter sido dados após a conclusão não serão revogados.';
$string['rolemanager'] = 'Gerente de certificação';
$string['rolemanagerdescription'] = 'Permite criar e gerenciar certificações dentro do tenant atual e alocar usuários à elas';
$string['selectadifferentprogram'] = 'Selecionar um programa diferente';
$string['selectcertificationcondition'] = 'Certificação';
$string['selectcertificationcondition_help'] = 'Selecione a certificação onde essa condição será aplicada';
$string['selectcertificationoutcome'] = 'Certificação';
$string['selectcertificationoutcome_help'] = 'Selecione a certificação onde esta ação será aplicada';
$string['selectdate'] = 'Selecionar a data';
$string['selectprogram'] = 'Selecionar o programa';
$string['selectprogram_help'] = 'Selecionar um programa a ser associado a esta certificação';
$string['startdate'] = 'Data de início';
$string['startdate_help'] = 'Data em que a certificação começa';
$string['status'] = 'Estado';
$string['suspended'] = 'Suspensa';
$string['suspendeddateisonorafter'] = 'Data de suspensão a partir de';
$string['tagarea_tool_certification'] = 'Certificações';
$string['tags'] = 'Marcadores';
$string['timecreated'] = 'Criado em';
$string['timemodified'] = 'Modificado pela última vez em';
$string['timesuspended'] = 'Suspenso em';
$string['toomanycertificationstoshow'] = 'Muitas certificações para mostrar';
$string['uponcompletion'] = 'Após a conclusão';
$string['userallocation'] = 'Alocação de usuário';
$string['usercompletion'] = 'Conclusão do usuário';
$string['userduedate'] = 'Data de entrega';
$string['userduedate_help'] = 'Selecione a data de entrega da certificação para este usuário.';
$string['users'] = 'Usuários';
$string['userstartdate'] = 'Data de início';
$string['userstartdate_help'] = 'Selecione a data em que este usuário poderá iniciar a certificação. Esta data será aplicada apenas a este usuário.';
$string['userstatus'] = 'Estado';
$string['userstatus_help'] = 'O estado suspenso oculta essa certificação para esse usuário, enquanto o estado Padrão irá mostrá-la.';
