<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_xp', language 'pt_br', branch 'MOODLE_37_STABLE'
 *
 * @package   block_xp
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Ações';
$string['activityoresourceis'] = 'A atividade ou recurso é {$a}';
$string['addacondition'] = 'Adicione uma condição';
$string['addarule'] = 'Adicione uma regra';
$string['addinstructions'] = 'Adicionar mais informações';
$string['addrulesformhelp'] = 'A última coluna define a quantidade de pontos de experiência ganhos quando um critério é satisfeito.';
$string['admindefaultrulesintro'] = 'As regras a seguir serão utilizadas como padrão para cursos onde o bloco for adicionado.';
$string['admindefaultsettingsintro'] = 'As configurações abaixo serão utilizadas como padrões quando o bloco for adicionado novamente a um curso.';
$string['admindefaultvisualsintro'] = 'As configurações seguintes serão utilizadas como padrões quando o bloco for adicionado novamente a um curso.';
$string['anonymity'] = 'Anonimato';
$string['anonymity_help'] = 'Esta configuração controla se os participantes podem ver o nome e o avatar uns dos outros.';
$string['awardaxpwhen'] = '<strong>{$a}</strong> pontos de experiência são ganhos quando:';
$string['basexp'] = 'Algorítmo base';
$string['blockappearance'] = 'Aparência do bloco';
$string['cachedef_filters'] = 'Filtros de nível';
$string['cachedef_ruleevent_eventslist'] = 'Lista de alguns eventos';
$string['cannotshowblockconfig'] = 'Normalmente mostro as configurações de aparência aqui, mas não consegui encontrar seu bloco. Para alterar a aparência do bloco, volte [aqui]({$a}) (ou onde você adicionou o bloco), ative o modo de edição e clique na opção "Configurar" na lista suspensa do bloco. Se você não conseguir encontrar o bloco, adicione-o novamente ao seu curso.';
$string['cannotshowblockconfigsys'] = 'Normalmente, mostro as configurações de aparência aqui, mas não consegui encontrar seu bloco. Pode estar faltando na
 [página inicial]({$a->fp}) e no [painel]({$a->mysys}) de seus usuários, ou presente em ambos. Para editar as configurações aqui, verifique se elas aparecem apenas em uma delas.';
$string['changelevelformhelp'] = 'Se você alterar o número de níveis, os emblemas customizados de níveis serão temporariamente desabilitados para prevenir níveis sem emblemas. Se você alterar o número de níveis vá para a página \'Visuais\' para re-habilitar os emblemas customizados uma vez que tenha salvo esse formulário.';
$string['cheatguard'] = 'Proteção contra fraude';
$string['clicktoselectcm'] = 'Clique para selecionar uma atividade ou recurso';
$string['cmselector'] = 'Seletor de módulo de curso';
$string['coefxp'] = 'Coeficiente do algorítmo';
$string['colon'] = '{$a->a}: {$a->b}';
$string['configdescription'] = 'Introdução';
$string['configdescription_help'] = 'Uma pequena introdução exibida no bloco, abaixo do nível do estudante. Os estudantes têm a capacidade de ignorar a mensagem e, nesse caso, eles não a verão novamente.';
$string['configheader'] = 'Configurações';
$string['configrecentactivity'] = 'Mostrar recompensas recentes';
$string['configrecentactivity_help'] = 'Quando ativado, o bloco exibirá uma pequena lista de eventos recentes que recompensaram o estudante com pontos.';
$string['configtitle'] = 'Título';
$string['configtitle_help'] = 'O título do bloco';
$string['congratulationsyouleveledup'] = 'Parabéns!';
$string['coolthanks'] = 'Muito bom, obrigado!';
$string['courselog'] = 'Log do curso';
$string['coursereport'] = 'Relatório do curso';
$string['courserules'] = 'Regras do curso';
$string['courseselectedcolon'] = 'Curso selecionado:';
$string['coursesettings'] = 'Configurações do curso';
$string['coursevisuals'] = 'Visuais do curso';
$string['customizelevels'] = 'Customizar os níveis';
$string['dangerzone'] = 'Zona de perigo';
$string['defaultlevels'] = 'Níveis padrões';
$string['defaultrules'] = 'Regras padrões';
$string['defaultrulesformhelp'] = 'Essas são as regras padrão fornecidas pelo plugin, elas dão pontos de experiência automaticamente e ignoram alguns eventos redundantes. Regras personalizadas têm precedência sobre elas.';
$string['defaultsettings'] = 'Configurações padrões';
$string['defaultvisuals'] = 'Visual padrão';
$string['deletecondition'] = 'Condição de exclusão';
$string['deleterule'] = 'Regra de exclusão';
$string['description'] = 'Descrição';
$string['difference'] = 'Diferença';
$string['discoverlevelupplus'] = 'Descubra o Level Up! Plus';
$string['dismissnotice'] = 'Ignorar aviso';
$string['displayeveryone'] = 'Exibir todos';
$string['displaynneighbours'] = 'Exibir {$a} vizinhos';
$string['displayoneneigbour'] = 'Exibir um vizinho';
$string['displayparticipantsidentity'] = 'Exibir a identidade dos participantes';
$string['displayrank'] = 'Mostrar classificação';
$string['displayrelativerank'] = 'Mostrar uma classificação relativa';
$string['editinstructions'] = 'Editar informação';
$string['enablecheatguard'] = 'Ativar proteção contra fraude';
$string['enablecheatguard_help'] = 'A proteção contra fraude oferece um mecanismo simples e barato para evitar que os estudantes abusem do sistema usando técnicas óbvias, como atualizar a mesma página indefinidamente ou repetir a mesma ação repetidas vezes.';
$string['enableinfos'] = 'Habilitar a página de informações';
$string['enableinfos_help'] = 'Quando setado para \'Não\', os estudantes não serão capazes de ver a página de informações.';
$string['enableladder'] = 'Habilitar o ranking';
$string['enableladder_help'] = 'Quando setado para \'Não\', os estudantes não serão capazes de ver o ranking.';
$string['enablelevelupnotif'] = 'Habilitar notificações de mudança de nível';
$string['enablelevelupnotif_help'] = 'Quando setado para \'Sim\', os estudantes verão um popup parabenizando-os pelo novo nível alcançado.';
$string['enablelogging'] = 'Habilitar logging';
$string['enablexpgain'] = 'Habilitar ganho de XP';
$string['enablexpgain_help'] = 'Quando setado para \'Não\', ninguém ganhará pontos de experiência no curso. Isso é útil para congelar a experiência ganha, ou para habilitar por um certo período de tempo.

Por favor, note que isto pode ser controlado de forma mais precisa usando a capacidade \'block/xp:earnxp\'.';
$string['entersearchterm'] = 'Digite um termo de pesquisa';
$string['errorformvalues'] = 'Existem alguns erros nos valores do formulário, por favor, resolva-os.';
$string['errorlevelsincorrect'] = 'O número mínimo de níveis é 2';
$string['errornotalllevelsbadgesprovided'] = 'Nem todos os emblemas de níveis foram informados. Faltando: {$a}';
$string['errorunknownevent'] = 'Erro: evento desconhecido';
$string['errorunknownmodule'] = 'Erro: módulo desconhecido';
$string['errorxprequiredlowerthanpreviouslevel'] = 'A experiência necessária é menor ou igual ao nível anterior.';
$string['eventis'] = 'O evento é {$a}';
$string['eventname'] = 'Nome do evento';
$string['eventproperty'] = 'Propriedades do evento';
$string['eventtime'] = 'Data do evento';
$string['event_user_leveledup'] = 'Usuário subiu de nível';
$string['filtermodules'] = 'Módulos de filtro';
$string['for1day'] = 'Por um dia';
$string['for1month'] = 'Por um mês';
$string['for1week'] = 'Por uma semana';
$string['for3days'] = 'Por 3 dias';
$string['forever'] = 'Para sempre';
$string['forthewholesite'] = 'Para todo o site';
$string['give'] = 'dar';
$string['gotofullladder'] = 'Ir para o ranking completo';
$string['hideparticipantsidentity'] = 'Ocultar identidade dos participantes';
$string['hiderank'] = 'Ocultar classificação';
$string['incourses'] = 'Em cursos';
$string['ineffective'] = 'Ineficaz';
$string['infos'] = 'Informação';
$string['instructions'] = 'Mais Informações';
$string['invalidxp'] = 'Valor de XP inválido';
$string['keeplogs'] = 'Manter logs';
$string['ladder'] = 'Ranking';
$string['ladderadditionalcols'] = 'Colunas adicionais';
$string['ladderadditionalcols_help'] = 'Essa configuração determina quais colunas adicionais são exibidas no ranking. Pressione a tecla CTRL ou CMD enquanto clica para selecionar mais de uma coluna ou para desmarcar uma coluna selecionada.';
$string['ladderempty'] = 'O ranking está vazio, volte mais tarde!';
$string['level'] = 'Nível';
$string['levelbadges'] = 'Emblemas de nível';
$string['levelbadgesformhelp'] = 'Nome dos arquivos [nivel].[extensão do arquivo], por exemplo: 1.png, 2.jpg, etc... O tamanho recomendado da imagem é 100x100.';
$string['levelcount'] = 'Quantidade de níveis';
$string['leveldesc'] = 'Descrição do nível';
$string['leveldesc_help'] = 'Uma descrição breve do nível, isto é exibido na pagina de informações junto com o próprio nível. Você pode utilizar isto para descrever uma recompensa para os estudantes que alcançam o nível, para incluir instruções de como atingir este nível, ou para descrever o nível de maneira divertida (por exemplo, _Diz-se que somente as almas mais destemidas conseguem atingir este nível_), etc.';
$string['levelname'] = 'Nome do nível';
$string['levelname_help'] = 'Um nome de nível curto para exibição ao invés do padrão _Nível #1_, _Nível #2_, etc. que algumas vezes é exibido. Se você dar nome a alguns níveis, nós recomendamos que você dê nome a todos!';
$string['levels'] = 'Níveis';
$string['levelswillbereset'] = 'Atenção! Ao salvar este formulário os níveis de todos serão recalculados!';
$string['levelup'] = 'Passou de nível!';
$string['levelupplus'] = 'Passou de nível! Plus';
$string['levelx'] = 'Nível #{$a}';
$string['likenotice'] = '<strong>Você gosta do plugin?</strong> Por favor, aguarde um momento para <a href="{$a->moodleorg}" target="_blank">adicioná-lo aos seus favoritos</a> em Moodle.org e <a href="{$a->github}" target="_blank">marque-o com uma estrela no GitHub</a>.';
$string['limitparticipants'] = 'Limite de participantes';
$string['limitparticipants_help'] = 'Esta configuração controla quem é exibido no placar. Vizinhos são os participantes classificados acima e abaixo do usuário atual. Por exemplo, ao escolher \'Exibir 2 vizinhos\', somente os dois participantes classificados diretamente acima e abaixo do usuário atual serão exibidos.';
$string['logging'] = 'Logging';
$string['maxactionspertime'] = 'Max. ações no intervalo de tempo';
$string['maxactionspertime_help'] = 'O número máximo de ações que contarão para ganho de pontos de experiência durante o intervalo de tempo fornecido. Qualquer ação subsequente será ignorada. Quando este valor está vazio ou é igual a zero, não é aplicado.';
$string['movecondition'] = 'Condição de movimento';
$string['moverule'] = 'Regra de movimento';
$string['navinfos'] = 'Informações';
$string['navladder'] = 'Ranking';
$string['navlevels'] = 'Níveis';
$string['navlog'] = 'Log';
$string['navpromo'] = 'Plus';
$string['navreport'] = 'Relatório';
$string['navrules'] = 'Regras';
$string['navsettings'] = 'Configurações';
$string['navvisuals'] = 'Visuais';
$string['participant'] = 'Participante';
$string['participatetolevelup'] = 'Participe do curso para ganhar pontos de experiência e passar de nível!';
$string['perpagecolon'] = 'Por página:';
$string['pickaconditiontype'] = 'Escolha um tipo de condição';
$string['pluginname'] = 'Level up!';
$string['pointsintimelinker'] = 'por';
$string['pointsrequired'] = 'Pontos requeridos';
$string['privacy:metadata:log'] = 'Armazena um log de eventos';
$string['privacy:metadata:log:eventname'] = 'O nome do evento';
$string['privacy:metadata:log:time'] = 'A data em que aconteceu';
$string['privacy:metadata:log:userid'] = 'O usuário que ganhou os pontos';
$string['privacy:metadata:log:xp'] = 'Os pontos atribuídos para o evento';
$string['privacy:metadata:prefintro'] = 'Registra se o usuário descartou a introdução do bloco';
$string['privacy:metadata:prefladderpagesize'] = 'O tamanho de página preferido do usuário ao visualizar o ranking';
$string['privacy:metadata:preflevelup'] = 'Registra se o usuário deve ver a notificação de aumento de nível';
$string['privacy:metadata:prefnotices'] = 'Registra se o usuário fechou o aviso de suporte';
$string['privacy:metadata:prefseenpromo'] = 'Registra quando o usuário visualizou a página promocional';
$string['privacy:metadata:xp'] = 'Armazena os pontos e o nível dos usuários';
$string['privacy:metadata:xp:lvl'] = 'O nível do usuário';
$string['privacy:metadata:xp:userid'] = 'O usuário';
$string['privacy:metadata:xp:xp'] = 'Os pontos do usuário';
$string['privacy:path:addon'] = 'Add-on';
$string['privacy:path:level'] = 'Nível';
$string['privacy:path:logs'] = 'Logs';
$string['progress'] = 'Progresso';
$string['progressbar'] = 'Barra de progresso';
$string['promocontactintro'] = 'Contacte-nos para mais informações. Nós não mordemos e nós respondemos rapidamente!';
$string['promocontactus'] = 'Entrar em contato';
$string['promoemailusat'] = 'Nos envie um e-mail em _levelup@branchup.tech_.';
$string['promoerrorsendingemail'] = 'Ai! Não foi possível enviar a mensagem ... envie um e-mail diretamente para: {$a}. Obrigado!';
$string['promoifpreferemailusat'] = 'Psiu! Se preferir, envie-nos um e-mail diretamente para  _{$a}_.';
$string['promointro'] = 'O add-on para _Level up! _ que libera todo o seu potencial!';
$string['promoyourmessagewassent'] = 'Obrigado, sua mensagem foi enviada. Nós entraremos em contato com você em breve';
$string['property:action'] = 'Ação do evento';
$string['property:component'] = 'Componente do evento';
$string['property:crud'] = 'CRUD do evento';
$string['property:eventname'] = 'Nome do evento';
$string['property:target'] = 'Alvo do evento';
$string['rank'] = 'Classificação';
$string['ranking'] = 'Ranking';
$string['ranking_help'] = 'A classificação é a posição absoluta do usuário atual no ranking. A classificação relativa é a diferença de os pontos de experiência entre um usuário e seus vizinhos.';
$string['reallydeleteuserstate'] = 'Excluir um usuário é útil apenas para removê-lo do ranking. Para outras razões, nós recomendamos definir seus pontos para 0. Note que excluí-los não o impede de ganhar pontos no futuro.

Importante! Quando utilizar o _Level up!_ para todo o site, excluir usuários fará com que eles desapareçam do relatório e não será possível atribuir pontos a eles. Entretanto, se você estiver usando o _Level up!_ para cursos específicos, o estudante ainda pode aparecer no relatório se estiver inscrito no curso.

Você realmente deseja excluir os pontos deste usuário?';
$string['reallyresetallcoursestodefaults'] = 'Você deseja realmente redefinir todas as regras de cursos para as regras padrão? Esta ação não pode ser desfeita.';
$string['reallyresetcourserulestodefaults'] = 'Você deseja realmente redefinir todas as regras de cursos para as regras padrão? Esta ação não pode ser desfeita.';
$string['reallyresetdata'] = 'Deseja realmente zerar os níveis e pontos de todos neste curso?';
$string['reallyresetgroupdata'] = 'Deseja realmente zerar os níveis e pontos  para todos neste grupo?';
$string['reallyreverttopluginsdefaults'] = 'Deseja realmente redefinir as regras padrão para os padrões sugeridos pelo plugin? Esta ação não pode ser desfeita.';
$string['recentrewards'] = 'Recompensas recentes';
$string['requires'] = 'Requer';
$string['resetallcoursestodefaults'] = 'Redefinir todos os cursos para os padrões';
$string['resetallcoursestodefaultsintro'] = 'Clique no botão abaixo para redefinir todos os cursos para os padrões acima';
$string['resetcoursedata'] = 'Resetar os dados do curso';
$string['resetcourserulestodefaults'] = 'Redefinir as regras do curso para os padrões';
$string['resetgroupdata'] = 'Redefinir as informações do grupo';
$string['reverttopluginsdefaults'] = 'Redefinir para os padrões do plugin';
$string['reverttopluginsdefaultsintro'] = 'Use o botão abaixo se desejar reverter os padrões acima para os padrões do plugin. Isto não afeta as regras dos cursos existentes';
$string['reward'] = 'Recompensa';
$string['rule'] = 'Regra';
$string['rulecm'] = 'Atividade ou recurso';
$string['rulecmdesc'] = 'A atividade ou recurso é \'{$a->contextname}\'.';
$string['rulecmdescwithcourse'] = 'A atividade ou recurso é: \'{$a->contextname}\' em \'{$a->coursename}\'.';
$string['rulecm_help'] = 'Essa condição é atendida quando o evento ocorre na atividade ou recurso especificado.';
$string['rule:contains'] = 'contêm';
$string['rule:eq'] = 'é igual a';
$string['rule:eqs'] = 'é estritamente igual a';
$string['ruleevent'] = 'Evento específico';
$string['ruleeventdesc'] = 'O evento é \'{$a->eventname}';
$string['rule:gt'] = 'é maior que';
$string['rule:gte'] = 'é maior ou igual a';
$string['rule:lt'] = 'é menor que';
$string['rule:lte'] = 'é menor ou igual a';
$string['ruleproperty'] = 'Propriedades do evento';
$string['rulepropertydesc'] = 'A propriedade \'{$a->property}\' {$a->compare} \'{$a->value}\'.';
$string['rule:regex'] = 'matches the regex';
$string['ruleset'] = 'Conjunto de condições';
$string['ruleset:all'] = 'TODAS as condições são verdadeiras';
$string['ruleset:any'] = 'Quaisquer das condições são verdadeiras';
$string['ruleset:none'] = 'Nenhuma das condições é verdadeira';
$string['rulesformhelp'] = '<p>Este plugin é feito usando os eventos para atribuir pontos por ações executadas pelos estudantes. Você pode usar o formulário abaixo para adicionar suas próprias regras e visualizar as padrões.</p>
<p>É aconselhável verificar o <a href="{$a->log}">log</a> do plugin para identificar quais eventos são disparados conforme você executa ações no curso, e também ler mais sobre esses eventos: <a href="{$a->list}">lista de todos os eventos</a>, <a href="{$a->doc}">documentação para desenvolvedores</a>.</p>
<p>Finalmente, por favor, note que o plugin sempre ignora:
<ul>
    <li>Ações executadas por administradores, visitantes ou usuários não logados.</li>
    <li>Ações executadas por usuários que não tem a capacidade <em>block/xp:earnxp</em>.</li>
    <li>Ações repetidas em um curto espaço de tempo, para prevenir trapaças.</li>
    <li>E os eventos que o nível educacional não é igual a <em>Participar</em>.</li>
</ul>
</p>';
$string['searchandselectcourse'] = 'Pesquise e selecione um curso';
$string['searchandselectmodule'] = 'Pesquise e selecione uma atividade ou recurso';
$string['send'] = 'Enviar';
$string['shortcode:xpbadge'] = 'O emblema que corresponde ao nível do usuário atual';
$string['shortcode:xpiflevel'] = 'Exibe o conteúdo quando o nível atual do usuário corresponde.';
$string['shortcode:xpiflevel_help'] = 'Consulte os exemplos abaixo para formatar este shortcode. Quando um nível é estritamente especificado, o conteúdo será exibido independentemente das outras regras. As regras _maior que_ and _menor que_ devem corresponder ao conteúdo a ser exibido. Tenha cuidado pois isso pode, às vezes, resultar em conteúdo nunca exibido! Observe que os professores ou usuários com recursos de edição, sempre verão tudo.

```
[xpiflevel 1 3 5]
    Exibido se o nível do usuário for exatamente 1, 3 ou 5.
[/xpiflevel]

[xpiflevel >3]
    Exibido se o nível do usuário for maior que 3.
[/xpiflevel]

[xpiflevel >=3]
    Exibido se o nível do usuário for maior ou igual a 3.
[/xpiflevel]

[xpiflevel >=10 <20 30]
    Exibido se o nível do usuário for maior ou igual a 10 E é estritamente menor que 20  OU é exatamente igual a 30.
[/xpiflevel]

[xpiflevel <=10 >=20]
    Nunca exibido porque o nível do usuário nunca pode ser menor ou igual a 10 E mais ou igual a 20.
[/xpiflevel]
```

Note que estes códigos de acesso NÃO PODEM ser aninhados uns dentro dos outros.';
$string['shortcode:xpladder'] = 'Exibe uma parte do ranking.';
$string['shortcode:xpladder_help'] = 'Por padrão, uma parte do ranking próxima do usuário será exibida.

```
[xpladder]
```

Para exibir os 10 primeiros estudantes ao invés dos vizinhos do usuário, insira o parâmetro `top`. Você pode também setar o número de usuários que você gostaria de exibir, como `top=20`.

```
[xpladder top]
[xpladder top=15]
```

Um link para o ranking todo será automaticamente exibido abaixo da tabela. Se você não quiser que o link apareça, adicione o argumento `hidelink`.

```
[xpladder hidelink]
```

Por padrão, a tabela não inclui a coluna de progresso, que mostra a barra de progresso. Se essa coluna foi selecionada nas colunas adicionais dentro das configurações do ranking, você pode utilizar o argurmento `withprogress` para exibi-la.

```
[xpladder withprogress]
```

Note que quando um curso utiliza grupos, o ranking vai fazer o malhor chute de qual grupo exibir o ranking.';
$string['shortcode:xpprogressbar'] = 'Barra de progresso do usuário atual para o próximo nível.';
$string['someoneelse'] = 'Outra pessoa';
$string['somethinghappened'] = 'Algo aconteceu';
$string['taskcollectionloggerpurge'] = 'Limpar registros de log';
$string['timebetweensameactions'] = 'Tempo requerido entre ações idênticas';
$string['timebetweensameactions_help'] = 'O tempo mínimo requerido antes de uma ação idêntica seja aceita novamente. Uma ação é considerada idêntica se foi realizada no mesmo contexto e objeto. Por exemplo, ler um post de um fórum será considerado idêntico se o mesmo post é lido novamente. Quando este valor está vazio ou é igual a zero, isto não é aplicado.';
$string['timeformaxactions'] = 'Intervalo de tempo para max. ações';
$string['timeformaxactions_help'] = 'O intervalo de tempo (em segundos) durante o qual o usuário não deve exceder um número máximo de ações.';
$string['tinytimedays'] = '{$a}d';
$string['tinytimehours'] = '{$a}h';
$string['tinytimeminutes'] = '{$a}m';
$string['tinytimenow'] = 'agora';
$string['tinytimeolderyearformat'] = '%b %Y';
$string['tinytimeseconds'] = '{$a}s';
$string['tinytimeweeks'] = '{$a}semanas';
$string['tinytimewithinayearformat'] = '%b %e';
$string['total'] = 'Total';
$string['unknowneventa'] = 'Evento desconhecido ({$a})';
$string['updateandpreview'] = 'Atualizar e visualizar';
$string['urlaccessdeprecated'] = 'O acesso através deste URL está obsoleto, por favor, atualize seus links.';
$string['usealgo'] = 'Usar o algoritmo';
$string['usecustomlevelbadges'] = 'Usar emblemas de níveis customizados';
$string['usecustomlevelbadges_help'] = 'Quando setado para sim, você deve fornecer uma imagem para cada nível.';
$string['value'] = 'Valor';
$string['valuessaved'] = 'Os valores foram salvos com sucesso.';
$string['viewtheladder'] = 'Visualizar o ranking';
$string['visualsintro'] = 'Carregue imagens para personalizar a aparência dos níveis.';
$string['wewillreplyat'] = 'Vamos responder em: _ {$a} _.';
$string['when'] = 'Quando';
$string['wherearexpused'] = 'Onde os pontos são usados?';
$string['wherearexpused_desc'] = 'Quando escolher \'Em cursos\', os pontos de experiência ganhos apenas serão computados no curso no qual o bloco foi adicionado. Quando escolher \'Para todo o site\', um usuário irá "subir de nível" em todo o site ao invés de apenas por curso, todas as experiências obtidas ao longo do site será usadas.';
$string['whoops'] = 'Ooops!';
$string['xp'] = 'Pontos de experiência';
$string['xp:addinstance'] = 'Adicionar um novo bloco de XP';
$string['xp:earnxp'] = 'Ganhando pontos de experiência';
$string['xpgaindisabled'] = 'Ganho de XP desabilitado';
$string['xp:manage'] = 'Gerenciar todos os aspectos dos pontos de experiência';
$string['xp:myaddinstance'] = 'Adicionar o bloco ao meu painel';
$string['xprequired'] = 'XP necessário';
$string['xptogo'] = '[[{$a}]] para ir';
$string['xp:view'] = 'Visualizar o bloco e páginas relacionadas';
$string['youreachedlevel'] = 'Você alcançou o nível:';
$string['youreachedlevela'] = 'Você alcançou o nível {$a}!';
$string['yourmessage'] = 'Sua mensagem';
$string['yourownrules'] = 'Suas prórpias regras';
