<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'plagiarism_urkund', language 'no', branch 'MOODLE_37_STABLE'
 *
 * @package   plagiarism_urkund
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allowallsupportedfiles'] = 'Tillat alle støttede filtyper';
$string['allowallsupportedfiles_help'] = 'Dette lar læreren begrense hvilke filtyper som skal sendes til URKUND for behandling. Det forhindrer ikke studentene fra å laste opp andre filtyper til innleveringen.';
$string['assessmentresubmitted'] = 'Innlevering sendt inn på nytt';
$string['attempts'] = 'Gjennomførte forsøk';
$string['cannotupgradeunprocesseddata'] = '<h1>Kan ikke oppgradere til denne versjonen pga ubehandlede data. Vennligst gå tilbake til en tidligere versjon av modulen og fjern gamle hendelser.</h1><p>Denne versjonen avhenger av nye hendelses API i Moodle, men installasjonen har ubehandlede hendelser relatert til gammelt API.</p>
 Du bør tilbakestille til en eldre versjon av URKUND-modulen, sette portalen i vedlikeholdsmodus, kjøre cron og forsikre deg om at alle gamle hendelser kjøres ferdig. Deretter kan du oppgradere modulen til siste versjon.</p>
 <p>Mer informasjon: <a href="https://docs.moodle.org/en/Plagiarism_Prevention_URKUND_Settings#Installation_failed_due_to_unprocessed_data">URKUND installasjon mislyktes på grunn av ubehandlede data</a></p>';
$string['charcount'] = 'Minste antall tegn';
$string['confirmresetall'] = 'Dette vil tilbakestille alle filer med status: {$a}';
$string['cronwarning'] = 'Vedlikeholdsskriptet <a href="../../admin/cron.php">cron.php</a> har ikke kjørt på minst 30 minutter  - Cron må konfigureres for at URKUND skal fungere skikkelig.';
$string['debugfilter'] = 'Filtrer filer etter';
$string['defaultsdesc'] = 'Følgende innstillinger er standardinnstillinger ved aktivering av URKUND som en aktivitetsmodul';
$string['defaultupdated'] = 'Standardverdier oppdatert';
$string['deletedwarning'] = 'Denne filen ble ikke funnet, den kan ha blitt slettet av brukeren';
$string['errorcode_3'] = 'Feilkode 3 - mindre 450 tegn OG20 ord';
$string['errorcode_4'] = 'Feilkode 4 - Dokumentet rakk ikke fristen (skjer kun dersom kursfunksjonen innenfor Urkund web innboks har en frist)';
$string['errorcode_5001'] = 'Feilkode 5001 - Analysen hr brukt for lang tid (dette vil skje automatisk hvis ikke analysen er ferdig innen 2 timer. Hvis dette skjer vil vi manuelt prøve en ny analyse som vil få mer tid til å bli ferdig.)';
$string['errorcode_7001'] = 'Feilkode 7001 - Dokumentet kunne ikke indekseres. Det betyr at en feil oppstod ved uthenting av tekst fra dokumentet. Dette vil vanligvis oppstå dersom det er tegn som er Unicode-inkompatible i dokumentet.';
$string['errorcode_unknown'] = 'Feil {$a} - En feil har oppstått';
$string['explainerrors'] = 'Denne siden viser alle filer med en feilmelding. <br /> Når filer slettes fra dennes siden, de vil ikke lengre kunne leveres på nytt og elever og lærere vil ikke lengre se feilmeldingen';
$string['file'] = 'Fil';
$string['filedeleted'] = 'Fil slettet fra kø';
$string['filereset'] = 'En fil har blitt tilbakestilt for ny gransking av URKUND';
$string['fileresubmitted'] = 'Fil lagt i køen for ny levering';
$string['filesresubmitted'] = '{$a} filer sendt inn på nytt';
$string['filter30'] = 'Ekskluder eldre enn 30 dager';
$string['filter7'] = 'Ekskluder eldre enn 7 dager';
$string['filter90'] = 'Ekskluder eldre enn 90 dager';
$string['getallscores'] = 'Hent alle resultater';
$string['getscore'] = 'Hent resultat';
$string['getscores'] = 'Hent resultater';
$string['heldevents'] = 'Gjennomførte hendelser';
$string['heldeventsdescription'] = 'Dette er hendelser som ikke ble fullført på første gjennomgang og er satt i kø for ny gjennomgang. Disse hindrer påfølgende hendelser fra å gjennomføres og kan ha behov for ytterligere granskning. Noen av disse hendelsene kan være urelatert til URKUND.';
$string['id'] = 'ID';
$string['identifier'] = 'Identifikator';
$string['module'] = 'Modul';
$string['modulenotfound'] = 'Kunne ikke finne modul for {$a->module} med id {$a->modid}.';
$string['name'] = 'Navn';
$string['nofilter'] = 'Ingen filter';
$string['noreceiver'] = 'Ingen mottaksadresse ble spesifisert';
$string['optout'] = 'Ikke lagre i URKUND';
$string['pending'] = 'Filen venter på levering til URKUND';
$string['pluginname'] = 'URKUND plagitatkontrollmodul';
$string['previouslysubmitted'] = 'Tidligere innsendt som';
$string['privacy:metadata:plagiarism_urkund_client:email'] = 'Bruker e-post';
$string['processing'] = 'Filen er blitt sendt til URKUND, venter på at analyse skal bli tilgjengelig';
$string['receivernotvalid'] = 'Ikke en gyldig mottaksadresse';
$string['regenerationrequested'] = 'Alle rapporter har blitt merket for regenerering. Det kan ta noetid før oppdaterte rapporter er tilgjengelige.';
$string['report'] = 'rapportere';
$string['restrictcontent'] = 'Lever inn vedlagte filer og online tekst';
$string['restrictcontentfiles'] = 'Lever kun inn vedlagte filer';
$string['restrictcontent_help'] = 'URKUND kan behandle opplastede filer og online tekst fra foruminnlegg eller innleveringsoppgaver. Du kan bestemme hvilke komponenter som skal sendes til URKUND.';
$string['restrictcontentno'] = 'Lever inn alt';
$string['restrictcontenttext'] = 'Lever kun inn online tekst';
$string['restrictfiles'] = 'Tiltyper for innlevering';
$string['resubmit'] = 'Lever på nytt';
$string['resubmitall'] = 'Send inn alle med statu: {$a} på nytt';
$string['resubmitclose'] = 'Send inn alle på nytt etter sluttdato';
$string['resubmitdue'] = 'Send inn alle på nytt etter innleveringsfristen';
$string['resubmittourkund'] = 'Regenerer alle URKUND-rapporter';
$string['savedconfigfailed'] = 'Feil brukernavn / passord, URKUND har blitt deaktivert, prøv igjen.';
$string['savedconfigsuccess'] = 'Innstillinger for plagiatkontroll lagret';
$string['scoreavailable'] = 'Filen har blitt gransket av URKUND, og en rapport er tilgjengelig';
$string['scorenotavailableyet'] = 'Filen har ennå ikke blitt gransket av URKUND';
$string['sendfiles'] = 'Send filer fra kø';
$string['showall'] = 'Vis alle feil';
$string['showwhencutoff'] = 'Etter aktivitetens sluttdato';
$string['showwhendue'] = 'Etter aktivitetens frist';
$string['similarity'] = 'URKUND';
$string['status'] = 'Status';
$string['studentdisclosure'] = 'Brukeravsløring';
$string['studentdisclosuredefault'] = 'Alle filer som lastes opp vil bli gransket av plagiatkontrolltjenesten URKUND. Hvis du vil forhindre at dokumentet ditt blir brukt som en analysekilde for andre organisasjoner kan du klikke på "Lagre ikke i URKUND"-lenken som vises etter at rapporten har blitt generert.';
$string['studentdisclosure_help'] = 'Alle brukere vil få se denne teksten på opplastingssiden';
$string['studentemailcontent'] = 'Filen du sendte inn til {$a->modulename} i {$a->coursename} har blitt gransket av plagiatkontrollverktøyet URKUND. {$a->modulelink}

Om du vil forhindre at dokumentet brukes som en analysekilde for andre organisasjoner kan du klikke på denne lenken for at teksten ikke skal lagres i URKUND. {$a->optoutlink}';
$string['studentemailcontentnoopt'] = 'Filen du sendte inn til $a->modulename} i {$a->coursename} har nå blitt behandlet av plagiatkontrollmodulen URKUND. {$a->modulelink}';
$string['studentemailsubject'] = 'Fil behandlet av URKUND';
$string['submitondraft'] = 'Lever fil ved opplasting';
$string['submitonfinal'] = 'Lever inn fil når en elev levere inn oppgaven';
$string['timesubmitted'] = 'Innleveringstidspunkt';
$string['toolarge'] = 'Denne filen er for stor for URKUND';
$string['unknownwarning'] = 'En feil oppstod når filen skulles sendes inn til URKUND';
$string['unknownwarninggetscore'] = 'Det oppstod en feil ved henting av score for denne filen fr URKUND';
$string['unsupportedfiletype'] = 'Denne filtypen støttes ikke av URKUND';
$string['updateallowedfiletypes'] = 'Oppdater tillatte filtyper og slett urkund-oppføringer tilknyttet slettede aktiviteter.';
$string['urkund'] = 'URKUND plagiatkontroll-plugin';
$string['urkund_advanceditems'] = 'Innstillinger som skal regnes som avanserte';
$string['urkund_advanceditems_help'] = 'Innstillinger som regnes som avanserte vil vises som avanserte i modulens innstillinger. De vil også skjules fra lærere som ikke har rettigheten \'urkund:advancedsettings\'.';
$string['urkund:advancedsettings'] = 'Tillater læreren å vise avanserte modulinnstillinger fra URKUND';
$string['urkund_api'] = 'URKUND integrasjonsadresse';
$string['urkund_api_help'] = 'Dette er adressen til URKUND API';
$string['urkunddebug'] = 'Debugging';
$string['urkunddefaults'] = 'Standarder for URKUND';
$string['urkunddefaults_assign'] = 'Standard innleveringsinnstillinger';
$string['urkunddefaults_forum'] = 'Standard foruminnstillinger';
$string['urkunddefaults_hsuforum'] = 'Standard hsuforuminnstillinger';
$string['urkunddefaults_workshop'] = 'Standrd workshopinnstillinger';
$string['urkund_draft_submit'] = 'Når skal filen sendes inn til URKUND';
$string['urkund:enable'] = 'Tillater læreren å aktivere/deaktivere URKUND inne i en aktivitet';
$string['urkund_enableoptout'] = 'Vis avslagslenke';
$string['urkund_enableoptoutdesc'] = 'Deaktivering av denne innstillingen vil fjerne valget studentene har for å tilgjengeliggjøre innholdet av tekstene sine i bruk for søk i andre innleveringen. Ved å deaktivere denne innstillingen bekrefter du at du vil ta ansvaret foropphavsretten til studentenes innleveringer og at dette er i henhold til gjeldende lover.';
$string['urkund_enableplugin'] = 'Aktiver URKUND for {$a}';
$string['urkundexplain'] = 'For mer informasjon om denne modulen se: <a href="http://www.urkund.com/int/en/" target="_blank">http://www.urkund.com/int/en/</a>';
$string['urkundfiles'] = 'Filer i URKUND';
$string['urkund_hidefilename'] = 'Skjul innleveringens filnavn';
$string['urkund_hidefilenamedesc'] = 'Aktivering av dette vil sende et generisk filnavn til URKUND slik at studentene ikke kan se filnavnet eller noen kilder som har likheter med en eksisterende innlevering.';
$string['urkund_lang'] = 'Språk';
$string['urkund_lang_help'] = 'Språkkode fra URKUND';
$string['urkund_password'] = 'Passord';
$string['urkund_password_help'] = 'Passord fra URKUND for å få tilgang til APIet';
$string['urkund_receiver'] = 'Mottakeradresse';
$string['urkund_receiver_help'] = 'Dette er den unike adressen fra URKUND som læreren skal bruke';
$string['urkund:resetfile'] = 'Tillat læreren å sende inn filen på nytt til URKUND etter en feil.';
$string['urkund:resubmitallfiles'] = 'Tillater at læreren sender inn igjen alle filene til URKUND';
$string['urkund_resubmit_on_close'] = 'Send inn på nytt ved avslutning';
$string['urkund:resubmitonclose'] = 'Tillater at læreren sender inn igjen alle filene til URKUND etter fristen/sluttdatoen';
$string['urkund_resubmit_on_close_desc'] = 'Send inn oppgaver til URKUND etter innleveringsperioden er utløpt.';
$string['urkund_resubmit_on_close_help'] = 'Aktivering av dette valget vil gjøre at innleveringer blir sendt inn igjen til URKUND når innleveringsperioden utløper.';
$string['urkund_show_student_report'] = 'Vis likhetsrapporten til eleven';
$string['urkund_show_student_report_help'] = 'Likhetsrapporten viser hvilke deler av innleveringen som er plagiat, og stedet der URKUND først fant dette innholdet.';
$string['urkund_show_student_score'] = 'Vis likhetsscore til eleven';
$string['urkund_show_student_score_help'] = 'Likhetsscoren er andelen av innleveringen som har likheter med andres innhold.';
$string['urkund_studentemail'] = 'Send studentepost';
$string['urkund_studentemail_help'] = 'Dette vil sende en epost til eleven når en fil har blitt gransket for at de skal få vite at en rapport er tilgjengelig. Eposten inneholder også "Ikke lagre i URKUND"-lenken.';
$string['urkund_username'] = 'Brukernavn';
$string['urkund_username_help'] = 'Brukernavn for tilgang til URKUND APIet';
$string['urkund:viewreport'] = 'Tillat at læreren får se fullstendig rapport fra URKUND';
$string['useurkund'] = 'Slå på URKUND';
$string['waitingevents'] = 'Det er {$a->countallevents} ventende hendelser i cron og {$a->countheld} venter på ny levering.';
