<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_amos', language 'no', branch 'MOODLE_36_STABLE'
 *
 * @package   local_amos
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['about'] = '<p> AMOS er et sentralt lagringssted for Moodle språkstrenger og deres historie. Den sporer tillegg av engelske strenger i Moodle-koden, samler oversettelser, håndterer vanlige oversettelsesoppgaver og genererer språkpakker som skal distribueres på Moodle-servere. </ P><p> Se <a href="https://docs.moodle.org/dev/AMOS_manual"> AMOS-dokumentasjon </a> for mer informasjon. </ p>';
$string['amos'] = 'AMOS verktøykasse for oversettelse';
$string['amos:changecontriblang'] = 'Endre språk for bidragsstrenger';
$string['amos:commit'] = 'Sjekk inn mellomlagrede strenger til kjernefilene';
$string['amos:execute'] = 'Kjør valgt AMOScript';
$string['amos:importfile'] = 'Importer strenger fra opplastet fil';
$string['amos:importstrings'] = 'Importer strenger (inkludert de engelske) direkte til hovedrepositoriet.';
$string['amos:manage'] = 'Administrere AMOS-portal';
$string['amos:stage'] = 'Bruk AMOS oversettelsesverktøy og mellomlagre språkstrengene';
$string['amos:stash'] = 'Lagre gjeldende mellomlager i permanent lager';
$string['amos:usegoogle'] = 'Bruk Google Translator';
$string['commitbutton'] = 'Bidra';
$string['commitmessage'] = 'Send melding';
$string['commitstage'] = 'Sjekk inn mellomlagrede språkstrenger';
$string['commitstage_help'] = 'Lagre alle mellomlagrede oversettelser i AMOS sine kjernefiler. Mellomlageret blir automatisk sjekket for feil før innsjekking og bare innsjekkbare strenger blir lagret. Dette betyr at det KUN lagres strenger som er merket med grønt. Mellomlageret tømmes når innsjekkingen er fullført.';
$string['committableall'] = 'alle språk';
$string['committablenone'] = 'ingen tilgang til språk - vennligst kontakt AMOS administratoren';
$string['componentsall'] = 'Alle';
$string['componentsnone'] = 'Ingen';
$string['componentsstandard'] = 'Standard';
$string['confirmaction'] = 'Dette kan ikke angres. Er du sikker?';
$string['contribaccept'] = 'Godta';
$string['contribactions'] = 'Oversettelsesbidrag';
$string['contribactions_help'] = 'Avhengig av dine rettigheter ,og hvordan arbeidsflyten er satt opp, kan noen av handlingene under være tilgjengelige:

* Legg til - kopier oversettelsen inn i mellom lageret, endrer ikke dine bidrag.
* Tildel meg - angi deg selv som redaktør og ansvarlig for å se over oversettelser og godkjenne dem.
* Fratre - angir "ingen" som tildeler av oppgaver.
* Start gjennomgang - tildeler siste oversettelsesbidrag til deg selv, setter status "under gjennomgang" og kopierer oversettelsesbidraget inn i ditt mellomlager.
* Godta - merker bidraget som godkjent.
* Avslå - merker bidraget som avvist, vennligst bruk kommentarfeltet og gi en begrunnelse.

Bidragsyteren blir informert via e-post hver gang status for bidragene endres.';
$string['contribapply'] = 'Legg til';
$string['contribassignee'] = 'Tildeler';
$string['contribassigneenone'] = '-';
$string['contribassigntome'] = 'Tildel til meg';
$string['contribauthor'] = 'Forfatter';
$string['contribclosedno'] = 'Skjul gjennomgåtte bidrag';
$string['contribclosedyes'] = 'Vis gjennomgåtte bidrag';
$string['contribcomponents'] = 'Komponenter';
$string['contribid'] = 'ID';
$string['contribincomingnone'] = 'Ingen inngående bidrag';
$string['contribincomingsome'] = 'Inngående bidrag ({$a})';
$string['contriblanguage'] = 'Språk';
$string['contribreject'] = 'Avslå';
$string['contribresign'] = 'Fratre';
$string['contribstartreview'] = 'Start gjennomgang';
$string['contribstatus'] = 'Status';
$string['contribstatus0'] = 'Ny';
$string['contribstatus10'] = 'Under gjennomgang';
$string['contribstatus20'] = 'Avvist';
$string['contribstatus30'] = 'Godkjent';
$string['contribstatus_help'] = 'Arbeidsflyten på oversettelsesbidrag består av følgende faser:

* Ny - bidraget er levert men ikke gjennomgått ennå.
* Under gjennomgang - oversettelsesbidraget er tildelt en språkpakkeadministrator og er mellomlagret for gjennomgang.
* Avvist - språkpakkeadministratoren har avvist bidraget og har muligens skrevet en begrunnelse
* Godkjent - bidraget er godkjent av språkpakkeadminstratoren.';
$string['contribstrings'] = 'Språkstrenger';
$string['contribstringseq'] = '{$a->orig} nye';
$string['contribstringsnone'] = '{$a->orig} (alle er allerede oversatt i språkpakken)';
$string['contribstringssome'] = '{$a->orig} ({$a->same} av dem har allerede en nyere oversettelse';
$string['contribsubject'] = 'Emne';
$string['contribsubmittednone'] = 'Ingen innsendte bidrag';
$string['contribsubmittedsome'] = 'Dine bidrag ({$a})';
$string['contribtimemodified'] = 'Endret';
$string['contributions'] = 'Oversettelsesbidrag';
$string['diff'] = 'Sammenlign';
$string['diffmode1'] = 'Engelske strenger er blitt endret med oversattede har ikke.';
$string['diffmode2'] = 'Engelske strenger er ikke blitt endret, men oversattede har.';
$string['diffmode3'] = 'Enten engelske eller oversattede strenger er blitt endret (men ikke begge)';
$string['diffmode4'] = 'Både engelske og oversattede strenger er blitt endret.';
$string['diffprogress'] = 'Sammenlign valgte grener';
$string['diffprogressdone'] = 'Totalt {$a} forskjeller funnet';
$string['diffstrings'] = 'Sammenlign strenger i to grener';
$string['diffversions'] = 'Versjoner';
$string['err_exception'] = 'Feil: {$a}';
$string['err_invalidlangcode'] = 'Ugyldig språkkode';
$string['err_parser'] = 'Parsing feil: {$a}';
$string['filtercmp'] = 'Komponenter';
$string['filtercmp_desc'] = 'Vis strenger for disse komponentene';
$string['filterlng'] = 'Språk';
$string['filterlng_desc'] = 'Vis oversettelser i disse språkene';
$string['filtermis'] = 'Diverse';
$string['filtermis_desc'] = 'Vis tilleggsbetingelser på språkstrenger';
$string['filtermisfglo'] = 'vis bare grålistede';
$string['filtermisfhlp'] = 'vis bare hjelp-strenger';
$string['filtermisfmis'] = 'vis bare manglende eller utdaterte strenger';
$string['filtermisfstg'] = 'vis bare mellomlagrede strenger';
$string['filtermisfwog'] = 'uten grålistede strenger';
$string['filtersid'] = 'Streng-indentifikator';
$string['filtersid_desc'] = 'Nøkkelen i strengmatrisen';
$string['filtertxt'] = 'Underordnet streng';
$string['filtertxtcasesensitive'] = 'store og små bokstaver';
$string['filtertxt_desc'] = 'Strengen må inneholde en tekst';
$string['filtertxtregex'] = 'regex';
$string['filterver'] = 'Versjoner';
$string['filterver_desc'] = 'Vis strenger fra disse Moodle-versjonene';
$string['found'] = 'Funnet: {$a->found} &nbsp;&nbsp;&nbsp; Mangler: {$a->missing} ({$a->missingonpage})';
$string['foundinfo'] = 'Antall strenger funnet';
$string['foundinfo_help'] = 'Viser det totale antall rader i oversettelsestabellen, antall manglende oversettelser og antall manglende oversettelser på gjeldende side.';
$string['gotofirst'] = 'gå til første side';
$string['gotoprevious'] = 'gå til forrige side';
$string['greylisted'] = 'Grålistede strenger';
$string['greylisted_help'] = 'Av hensyn til arv (tidligere versjoner), må en Moodle språkpakke inneholde språkstrenger som ikke lenger er i bruk og ennå kke slettet. Disse strengene er grålistet. Straks det er bekreftet at grålistede strenger ikke brukes noe sted lenger, blir de slettet fra språkpakken.

Dersom du ser at grålistede strenger fortsatt brukes i Moodle, vennligst post en melding i forumet i "Translating Moodle"-kurset på denne portalen. Ut over dette kan du spare mye tid på å overse de grålistede strengene og heller fokusere på de andre.';
$string['importfile'] = 'Importér oversatte strenger fra fil';
$string['importfile_help'] = 'Dersom du har oversatt strenger lokalt på egen pc kan du mellomlagre dem via dette skjemaet.

* Fila må være en gyldig Moodle PHP definisjonsfil. Se på `/lang/en/` på din egen Moodle-installasjon for eksempler.
* Filnavnet må samsvare med en av de engelske definisjonsfilene (eks: moodle.php, assignment.php etc)

Alle strenger i fila vil bli mellomlagret for valgt versjon og språk.';
$string['language'] = 'Språk';
$string['languages'] = 'Språk';
$string['languagesall'] = 'Alle';
$string['languagesnone'] = 'Ingen';
$string['log'] = 'Logg';
$string['logfilterbranch'] = 'Versjoner';
$string['logfiltercommithash'] = 'git hash';
$string['logfiltercommitmsg'] = 'Melding ved innsjekking inneholder';
$string['logfiltercommits'] = 'Innsjekkingsfilter';
$string['logfiltercommittedafter'] = 'Innsjekket etter';
$string['logfiltercommittedbefore'] = 'Innsjekket før';
$string['logfiltercomponent'] = 'Komponenter';
$string['logfilterlang'] = 'Språk';
$string['logfiltershow'] = 'Vis filtrerte innsjekkinger og strenger';
$string['logfiltersource'] = 'Kilde';
$string['logfiltersourceamos'] = 'amos (Webbasert oversetter)';
$string['logfiltersourcecommitscript'] = 'commitscript (AMOS skriptet i innsjekkingsmeldingen)';
$string['logfiltersourcegit'] = 'git (git speiler Moodles kildekode og 1.x pakker)';
$string['logfiltersourcerevclean'] = 'revclean (revers oppryddingsprosess)';
$string['logfilterstringid'] = 'Streng-identifikator';
$string['logfilterstrings'] = 'Strengfilter';
$string['logfilterusergrp'] = 'Innsjekker';
$string['logfilterusergrpor'] = 'eller';
$string['maintainers'] = 'Oversettere';
$string['markuptodate'] = 'Merk oversettelsen som oppdatert';
$string['markuptodate_help'] = 'AMOS har oppdaget at strengen kan være utdatert siden den engelske versjonen er modifisert etter at strengen ble oversatt. Se gjennom oversettelsen. Dersom du finner den oppdatert klikker du på avkrysningsboksen. Hvis ikke redigerer du den.';
$string['merge'] = 'Slå sammen';
$string['mergestrings'] = 'Slå sammen strenger fra en annen gren';
$string['mergestrings_help'] = 'Dette vil samle opp og mellomlagre alle strenger fra kildegrenen som ikke er oversatt ennå i målgrenen - og blir brukt der. Du kan bruke dette verktøyet til å kopiere oversatte strenger inn i alle andre versjoner av pakken. Bare språkpakkeadministratorer kan bruke dette verktøyet.';
$string['newlanguage'] = 'Nytt språk';
$string['nodiffs'] = 'Ingen forskjeller funnet';
$string['nofiletoimport'] = 'Vennligst oppgi en fil å importere fra.';
$string['nologsfound'] = 'Fant ingen strenger, vennligst endre filteret.';
$string['nostringsfound'] = 'Fant ingen strenger';
$string['nostringsfoundonpage'] = 'Fant ingen strenger på side {$a}';
$string['nostringtoimport'] = 'Fant ingen gyldige strenger i fila. Sjekk at fila har korrekt filnavn og er korrekt formatert.';
$string['nothingtomerge'] = 'Kildegrenen inneholder ingen nye strenger som mangler i målgrenen. Ingenting å slå sammen.';
$string['numofcommitsabovelimit'] = 'Fant {$a->found} bidrag som samsvarte med innsjekkingsfilteret {$a->limit} nylig endrede';
$string['numofcommitsunderlimit'] = 'Fant {$a->found} bidrag som samsvarte med innsjekkingsfilteret';
$string['numofmatchingstrings'] = 'Innenfor dette, {$a->strings} modifiseringer i {$a->commits}';
$string['outdatednotcommitted'] = 'Utdaterte strenger';
$string['outdatednotcommitted_help'] = 'AMOS oppdaget at strengen kan være utdatert siden den engelske versjonen er oppdatert etter oversettelsen. Vennligst se over oversettelsen.';
$string['ownstashactions'] = 'Handliger for lokalt mellomlager';
$string['ownstashactions_help'] = '* Legg til - kopierer oversatte strenger fra lokalt mellomlager inn i brukerens mellomlage og lar det lokale mellomlageret forbli som det er.
* Pop - flytter oversatte strenger fra lokalt mellomlager til brukerens mellomlager og tømmer det lokale mellomlageret etterpå. (Dette blir som Legg til og tøm)
* Tøm - sletter alle strengene i lokalt mellomlager.
* Send - åpner et skjema for innsending av lokalt mellomlager til de offisielle oversetterne slik at de kan ta med dine bidrag i den offisielle språkpakken.';
$string['ownstashes'] = 'Dine lokale mellomlagre';
$string['ownstashes_help'] = 'Dette er en liste over alle dine lokale mellomlagre';
$string['ownstashesnone'] = 'Fant ingen egne lokale mellomlagre';
$string['placeholder'] = 'Plassholdere';
$string['placeholder_help'] = 'Plassholdere er spesielle uttrykk som `{$a}` or `{$a->etellerannet}` i strengen. Utrykkene erstattes med en verdi når strengen vises.

Det er viktig å kopiere disse plassholderne nøyaktig slik de står i den originale strengen. Ikke prøv å oversette uttrykkene eller bytt orientering høyre-venstre.';
$string['pluginclasscore'] = 'Kjerne undersystemer';
$string['pluginclassnonstandard'] = 'Moduler som ikke er standard';
$string['pluginclassstandard'] = 'Standard moduler';
$string['pluginname'] = 'AMOS';
$string['presetcommitmessage'] = 'Oversettelsesbidrag #{$a->id} av {$a->author}';
$string['presetcommitmessage2'] = 'Flettet manglende strenger fra {$a->source} til {$a->target}-versjonen.';
$string['privileges'] = 'Dine privelegier';
$string['privilegesnone'] = 'Du har bare lese-rettigheter til offentlig informasjon.';
$string['requestactions'] = 'Handling';
$string['requestactions_help'] = '* Legg til - kopierer oversatte strenger fra hent-forespørselen inn i ditt mellomlager. Dersom strengen allerede finnes blir den overskrevet med den hentede.
* Skjul - blokkerer hent-forespørsler så de ikke vises for deg mer.';
$string['savefilter'] = 'Lagre filterinnstillinger';
$string['sourceversion'] = 'Kildeversjon';
$string['stage'] = 'Innsjekking';
$string['stageactions'] = 'Innsjekkingshandlinger';
$string['stageactions_help'] = '* Endre mellomlagrede strenger - modifiserer filterinnstillingene for oversetter slik at bare mellomlagrede strenger vises.
* Fjern strenger som ikke kan sjekkes inn - Fjerner alle strenger fra mellomlageret som du ikke har tillatelse til å sjekke inn. Mellomlageret blir automatisk rensket for ikke tillatte strenger før det sjekkes inn.
* klargjør databasen - fjerner alle oversettelser som enten ikke modifiserer eksisterende oversettelse eller er eldre enn siste oversettelse i språkpakken.  Mellomlageret blir automatisk klargjort før det sjekkes inn.
* Fjern alt fra mellomlageret - sletter mellomlageret og alle oversettelser lagret der går tapt.';
$string['stageedit'] = 'Endre mellomlagrede strenger';
$string['stageprune'] = 'Fjern strenger som ikke kan sjekkes inn';
$string['stagerebase'] = 'Oppdater basen';
$string['stagestringsnocommit'] = 'Det er {$a->staged} mellomlagrede strenger';
$string['stagestringsnone'] = 'Det er ingen mellomlagrede strenger';
$string['stagestringssome'] = 'Det er {$a->staged} mellomlagrede strenger, {$a->committable} av dem kan sjekkes inn';
$string['stagetranslation'] = 'Oversettelse';
$string['stagetranslation_help'] = 'Viser mellomlagrede oversettelser som skal sjekkes inn. Bakgrunnsfargene for hver streng betyr:

* Grønn - du har modifisert en streng eller lagt til en manglende oversettelse som du har tillatelse til å sjekke inn.
* Gul - Du har endret en streng og du har lov til å sjekke endringen.
* Blå - du har modifisert en streng eller lagt til en manglende oversettelse du ikke har tillatelse til å sjekke inn i gjeldende språkpakke.
* Ingen farge - mellomlagret oversettelse er den samme som gjeldende og vil derfor ikke bli sjekket inn.';
$string['stageunstageall'] = 'Fjern alt fra innsjekkingen';
$string['stashactions_help'] = 'Et lokalt mellomlager er et øyeblikksbilde av gjeldende mellomlager. Lokale mellomlagre kan sendes inn til den offisielle administratoren av språkpakken for godkjenning. Godkjente strenger legges inn i språkpakken.';
$string['stashapply'] = 'Legg til';
$string['stashautosave'] = 'Automatisk lagrede sikkerhetskopier av lokale mellomlagre';
$string['stashautosave_help'] = 'Dette lokale mellomlageret inneholder den mest oppdaterte versjonen av mellomlageret ditt. Du kan bruke den som en sikkerhetskopi for de tilfellene hvor alle strenger blir fjernet fra mellomlageret f.eks. ved et uhell. Bruk "Legg til"- handlingen til å kopiere alle lokalt mellomlagrede strenger tilbake til mellomlageret. (Dette vil overskrive samsvarende strenger som ligger i mellomlageret fra før)';
$string['stashcomponents'] = '<span>Komponenter:</span> {$a}';
$string['stashdrop'] = 'Drop';
$string['stashes'] = 'Lokale mellomlagre';
$string['stashlanguages'] = '<span>Språk:</span> {$a}';
$string['stashpop'] = 'Pop';
$string['stashpush'] = 'Overfør alle mellomlagrede strenger til et nytt lokalt mellomlager';
$string['stashstrings'] = '<span>Antall strenger:</span> {$a}';
$string['stashsubmit'] = 'Send til oversettere';
$string['stashsubmitdetails'] = 'Innsendingsinformasjon';
$string['stashsubmitmessage'] = 'Melding';
$string['stashsubmitsubject'] = 'Emne';
$string['stashtitle'] = 'Tittel på lokal innsjekking';
$string['stringhistory'] = 'Historie';
$string['strings'] = 'Strenger';
$string['submitting'] = 'Sender et bidrag';
$string['submitting_help'] = 'Dette vil sende oversatte strenger til de offisielle språkoversetterne. De kan legge til oversettelsen du har gjort i eget mellomlager, gjennomgå og eventuelt sjekke inn. Vennligst legg ved en melding til oversetterne som beskriver hva du har gjort og hvorfor du ønsker at din oversettelse skal brukes.';
$string['targetversion'] = 'Målversjon';
$string['translatortool'] = 'Oversetter';
$string['translatortranslation'] = 'Oversettelse';
$string['translatortranslation_help'] = 'Klikk på feltet for å gjøre det til en tekstredigerer. Skriv inn oversettelsen og klikk på utsiden av feltet for å mellomlagre oversettelsen. Bakgrunnsfargen på feltene betyr:

* Grønn - strengen er allerede oversatt og du har tillatelse til å modifisere oversettelsen og sjekke den inn.
* Gul - strengen kan sjekkes inn, men kan være utdatert. Den engelske versjon kan være endret siden denne strengen ble oversatt.
* Rød - strengen er ikke oversatt og du har tillatelse til å oversette og sjekke inn oversettelsen.
* Blå - du har modifisert oversettelsen og den er nå mellomlagret. Ikke glem å sjekke inn mellomlagrede oversettelser før du logger ut!
* Ingen farge - selv om du kan mellomlagre oversettelsen tillates du ikke å sjekke inn for dette språket. Du vil bare kunne eksportere mellomlageret til en fil.';
$string['typecontrib'] = 'Moduler som ikke er standard';
$string['typecore'] = 'Kjerne undersystemer';
$string['typestandard'] = 'Standard moduler';
$string['version'] = 'Versjon';
