<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_progress', language 'no', branch 'MOODLE_31_STABLE'
 *
 * @package   block_progress
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activity_completion'] = 'aktivitetsfullføring';
$string['addallcurrentitems'] = 'Legg til alle aktiviteter og ressurser';
$string['answered'] = 'besvart';
$string['assessed'] = 'gjennomført';
$string['assign'] = 'Innlevering';
$string['assignment'] = 'Innlevering';
$string['attempted'] = 'forsøkt';
$string['attempted_colour'] = '#33CC00';
$string['attempted_colour_descr'] = 'HTML fargekoder for elementer som er forsøkt';
$string['attempted_colour_title'] = 'Fargekode for forsøkt';
$string['awarded'] = 'tildelt';
$string['bigbluebuttonbn'] = 'Big Blue Button';
$string['book'] = 'Bok';
$string['cachedef_cachedlogs'] = 'Framdriftsvisning mellomlagring av loggforespørsler';
$string['certificate'] = 'Kursbevis';
$string['chat'] = 'Prat';
$string['choice'] = 'Gallup';
$string['completed'] = 'fullført';
$string['config_default_title'] = 'Din fremdrift';
$string['config_group'] = 'Synlig bare for grupper';
$string['config_header_action'] = 'Handling';
$string['config_header_expected'] = 'Forventet utført';
$string['config_header_icon'] = 'Ikon';
$string['config_header_locked'] = 'Låst til fullføringsdato';
$string['config_header_monitored'] = 'Overvåket';
$string['config_icons'] = 'Bruk ikoner i fremdriftsindikatoren';
$string['config_now'] = 'Bruk';
$string['config_orderby'] = 'Ordne elementene etter';
$string['config_orderby_course_order'] = 'Rekkefølge i kurset';
$string['config_orderby_due_time'] = '"Forventet utført" dag-tid';
$string['config_percentage'] = 'Vis prosent til studenter';
$string['config_title'] = 'Alternativ tittel';
$string['data'] = 'Database';
$string['feedback'] = 'Feedback';
$string['finished'] = 'avsluttet';
$string['flashcardtrainer'] = 'Flashcard trainer';
$string['folder'] = 'Mappe';
$string['forum'] = 'Forum';
$string['futureNotAttempted_colour'] = '#3366FF';
$string['futurenotattempted_colour_descr'] = 'HTML fargekode for framtidige elementer som ennå ikke er forsøkt';
$string['futurenotattempted_colour_title'] = 'Fremtidige ikke-forsøkt fargekode';
$string['glossary'] = 'Ordbok';
$string['graded'] = 'vurdert';
$string['hotpot'] = 'Hot Potatoes';
$string['how_group_works'] = 'Hvordan synlige grupper fungerer';
$string['how_group_works_help'] = '<p>Ved å velge grupper begrenses visningen av denne blokket til kun denne gruppen.</p>';
$string['how_ordering_works'] = 'How ordering works';
$string['how_ordering_works_help'] = '<p>There are two ways items in the Progress Bar can be ordered.</p>
<ul>
    <li><em>"Expected by" date-time</em> (default)<br />
    The due dates or manually set dates of activities/resources are used to order items shown in the Progress Bar.
    </li>
    <li><em>Ordering in course</em><br />
    Activities/resources are presented in the same order as they are on the course page. When this option is used, time-related aspects are disabled.
    </li>
</ul>';
$string['hsuforum'] = 'Avansert forum';
$string['imscp'] = 'IMS innholdspakke';
$string['journal'] = 'Journal';
$string['lastonline'] = 'Sist pålogget';
$string['lesson'] = 'Leksjon';
$string['marked'] = 'karaktersatt';
$string['mouse_over_prompt'] = 'Hold musen over fremdriftsindikatoren for mer informasjon';
$string['no_blocks'] = 'Det er ingen blokk for framdriftsvisning i dette kurset.';
$string['no_events_config_message'] = 'Det er ingen registrere aktiviteter eller ressurser å følge fremdriften på. Lag noen aktiviteter/ressurser og eller konfigurer denne blokken.';
$string['no_events_message'] = 'Det er ingen aktiviteter/ressurser som følges. Bruk konfigurasjonsinnstillingene til å angi hva som skal følges.';
$string['notAttempted_colour'] = '#FF3300';
$string['notattempted_colour_descr'] = 'HTML fargekode for gjeldende elementer som ikke er forsøkt';
$string['notattempted_colour_title'] = 'Ikke-forsøkt fargekode';
$string['no_visible_events_message'] = 'Ingen av de overvåkede elementene er synlige for studenter.';
$string['now_indicator'] = 'NÅ';
$string['overview'] = 'Studentoversikt';
$string['page'] = 'Side';
$string['passed'] = 'godkjent';
$string['passedscorm'] = 'godkjent';
$string['pluginname'] = 'Framdriftsindikator';
$string['posted_to'] = 'sendt til';
$string['progress'] = 'Fremdrift';
$string['progress:addinstance'] = 'Legg til en ny fremdriftsblokk';
$string['progressbar'] = 'Fremdriftsindikator';
$string['progress:myaddinstance'] = 'Legg til en blokk for framdriftsvisning på Min startside';
$string['progress:overview'] = 'Studentoversikten viser fremdriften for alle studentene';
$string['questionnaire'] = 'Questionnaire';
$string['quiz'] = 'Quiz';
$string['recordingsbn'] = 'BBB opptak';
$string['resource'] = 'Fil';
$string['responded_to'] = 'besvart til';
$string['scorm'] = 'SCORM';
$string['selectitemstobeadded'] = 'Velg aktiviteter/ressurser';
$string['submitted'] = 'sendt';
$string['time_expected'] = 'Forventet';
$string['turnitintool'] = 'Turnitin verktøy';
$string['url'] = 'URL';
$string['viewed'] = 'sett';
$string['what_actions_can_be_monitored'] = 'Hvilke handlinger skal overvåkes?';
$string['what_actions_can_be_monitored_help'] = '<p>Forskjellige aktiviteter og ressurser kan overvåkes.</p><p>Fordi aktiviteter og ressurser brukes forskjellig vil det variere hva som overvåkes i hver modul. F.eks. vil en for innleveringer kunne overvåke innlevering av besvarelser, quizer kan overvåkes på forsøkene, forum kan overvåkes på posting av innlegg, Gallup kan overvåkes på besvarelser og en kan også overvåke om ressurser er vist.</p>
<p>For innleverings- og quizmodulene vil vurderingen basere seg på modulenes innstillinger i karakterboka for godkjent karakter.
<a href="http://docs.moodle.org/en/Grade_items#Activity-based_grade_items" target="_blank">More help...</a></p>';
$string['what_does_monitored_mean'] = 'Hva betyr overvåkning i denne sammenhengen?';
$string['what_does_monitored_mean_help'] = '<p>Hensikten med blokken er å oppmuntre studentene tll å bruke tiden effektivt. Hver student kan overvåke egen progresjon når de fullfører aktivitetene og ressursene du har laget.</p>
<p>På innstillingssiden ser du alle aktivitetene du kan overvåke listet opp. Aktivieteter blir kun overvåket og vises som små firkanter i framdriftsindikatoren når du velger "Ja" for å overvåke aktiviteten.</p>';
$string['what_expected_by_means'] = 'Hva betyr forventet fullført innen?';
$string['what_expected_by_means_help'] = '<p><em>Forventet fullført innen</em> dato/tid er aktuell når relatert aktivitet/ressurs forventes fullført (vist, innsendt, postet osv...)</p>
<p>Hvis det allerede er en tidsfrist knyttet til aktiviteten (f.eks. en innleveringsfrist), kan denne fristen brukes som forventet fullført innen. Dette gjelder såfremt "Låst til tidsfrist" er merket av. Fjerner du avmerkingen kan du skrive inn en annen tidsfrist og den vil ikke ha noen betydning for aktivitetens tidsfrist.</p>
<p>Når du første gang viser innstillingssiden for fremdriftsindikatoren, eller du oppretter en ny aktivitet og går tilbake til innstillingssiden, vil det bli utført en kvalifisert gjetning på fullføringstidspunkt for den nye aktiviteten/ressursen.
<ul>
<li>For en aktivtet med en eksisterende frist, vil denne fristen bli benyttet.</li>
<li>Hvis det ikke er noen aktivitetsfrist, men kursformatet er uke-formatet, vil slutten av denne uka bli brukt som tidsfrist.</li>
<li>For en aktivitet/ressurs i noe annet enn ukeformatet, vil slutten av gjeldende uke bli benyttet (Rett for midnatt søndag).</li>
</ul>
</p>
<p>Straks forventet dato/tid er angitt, vil den være avhengig av en gitt frist eller annen informasjon for aktiviteten/ressursen.</p>';
$string['what_locked_means'] = 'Hva betyr "låst til deadline"?';
$string['what_locked_means_help'] = '<p>Når en aktivitet har en frist angitt i innstillingene, kan en bruke denne fristen eller angi en annen frist for visningen i framdriftsvisningen.</p>
<p>For å låse framdriftsvisning til aktivitietens frist må den være aktivert i aktiviteten. Hvis fristen er låst, vil endring av frist i aktivitetsinnstillingene automatisk endre tilsvarende frist i framdriftsvisningen.</p>
<p>Når en aktivitet ikke er låst til en frist, vil endring av frist i framdriftsvisningen ikke ha noen effekt på selve aktiviteten.</p>';
$string['why_display_now'] = 'Hvorfor ønsker du å skjule/vise NÅ-indikatoren?';
$string['why_display_now_help'] = '<p>Ikke alle kurs er fokusert på fullføring av aktiviteter innen en bestemt frist. Noen kurs har kanskje helt åpen påmelding og fri progresjon.</p>
<p>For å bruke framdriftsvisningen som verktøy i slike kurs, kan du angi forventet-datoer langt inn i fremtiden og angi NÅ-innstillingen til "Nei".</p>';
$string['why_set_the_title'] = 'Hvorfor vil du ønske å angi en tittel på blokken?';
$string['why_set_the_title_help'] = '<p>Det kan settes opp flere instanser av framdriftsvisningen i samme kurs. Du kan f.eks. bruke forskjellige framdriftsvisninger for å overvåke forskjellige utvalg av aktiviteter og ressurser. For eksempel kan du spore innleveringer i en blokk og quizer i en annen. I slike tilfeller kan du overstyre standard tittel og angi en mer passende blokktittel for hver instans.</p>';
$string['why_show_precentage'] = 'Hvorfor vise framdrift i prosent til studentene?';
$string['why_show_precentage_help'] = '<p>Det er mulig å vise en %-total av framdriften til studentene.</p>
<p>Denne beregnes på bakgrunn av antall fullførte elementer delt på antall elementer osm vises i framdriftsvisningen.</p>
<p>Framdriftsprosenten vises når de beveger musen over et element i framdriftsvisningen.</p>';
$string['why_use_icons'] = 'Hvorfor bruke ikoner?';
$string['why_use_icons_help'] = '<p>Du ønsker kanskje å legge til avkrysnings og x-ikoner i framdriftsvisningen for å gjøre visningen mer visuelt tilgjengelig for studenter som er fargeblinde.</p>
<p>Det kan også gi mening for å gjøre visningen mer intuitiv hvis du antar at farger ikke er nok. Det kan være kulturelle og personlige årsaker til dette.</p>';
$string['wiki'] = 'Wiki';
$string['workshop'] = 'Workshop';
