<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'zoom', language 'cs', branch 'MOODLE_37_STABLE'
 *
 * @package   zoom
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Akce';
$string['addtocalendar'] = 'Přidat do kalendáře';
$string['allmeetings'] = 'Všechny schůzky';
$string['alternative_hosts'] = 'Alternativní hostitelé';
$string['alternative_hosts_help'] = 'Možnost alternativní hostitelé umožňuje naplánovat schůzky a určit další uživatele na stejném účtu (s licencí PRO) pro spuštění schůzky nebo webináře, pokud vy sami nebudete moci. Tento uživatel obdrží e-mail s oznámením, že byl přidán jako alternativní hostitel, s odkazem na zahájení schůzky. Oddělte více e-mailů čárkou (bez mezer).';
$string['apikey'] = 'Zoom API klíč';
$string['apisecret'] = 'Zoom API secret';
$string['apiurl'] = 'Zoom API url';
$string['audio_both'] = 'VoIP a telefon';
$string['audio_telephony'] = 'Pouze telefon';
$string['audio_voip'] = 'Pouze VoIP';
$string['cachedef_sessions'] = 'Informace od Zoomu o protokolu žádosti';
$string['cachedef_zoomid'] = 'Identifikátor uživatele Zoomu';
$string['calendardescriptionintro'] = '\\nDescription:\\n{\\$a}';
$string['calendardescriptionURL'] = 'URL pozvánky na schůzku: {$a}.';
$string['calendariconalt'] = 'Ikona kalendáře';
$string['clickjoin'] = 'Potvrdili jste připojení ke schůzce';
$string['connectionfailed'] = 'Připojení se nezdařilo:';
$string['connectionok'] = 'Připojení funguje.';
$string['connectionstatus'] = 'Stav připojení';
$string['defaultsettings'] = 'Výchozí nastavení Zoom schůzky';
$string['defaultsettings_help'] = 'Tato nastavení definují výchozí hodnoty pro všechny nové schůzky Zoom a webináře.';
$string['downloadical'] = 'Stáhnout iCal';
$string['duration'] = 'Doba trvání (minut)';
$string['endtime'] = 'Čas ukončení';
$string['err_duration_nonpositive'] = 'Doba trvání musí být kladná hodnota.';
$string['err_duration_too_long'] = 'Doba trvání nesmí přesáhnout 150 hodin.';
$string['err_invalid_password'] = 'Heslo obsahuje neplatné znaky.';
$string['err_long_timeframe'] = 'Požadovaný časový rámec je příliš dlouhý, jsou zobrazeny výsledky v rozsahu posledního měsíce.';
$string['errorwebservice'] = 'Chyba webové služby Zoom: {$a}.';
$string['errorwebservice_notfound'] = 'Zdroj neexistuje: {$a}';
$string['err_password'] = 'Heslo může obsahovat pouze následující znaky: [a-z A-Z 0-9 @ - _ *]. Maximálně 10 znaků.';
$string['err_password_required'] = 'Heslo je označeno jako povinné, ale pole hesla je prázdné.';
$string['err_start_time_past'] = 'Počáteční datum nemůže být v minulosti.';
$string['export'] = 'Export';
$string['firstjoin'] = 'První možnost připojit se';
$string['firstjoin_desc'] = 'První uživatel může připojit nejdříve (minuty před začátkem).';
$string['getmeetingreports'] = 'Získat zprávu o schůzce Zoom';
$string['invalid_status'] = 'Stav je neplatný, zkontrolujte databázi.';
$string['join'] = 'Připojit se';
$string['joinbeforehost'] = 'Povolit ostatním připojit se ke schůzce před hostitelem';
$string['join_meeting'] = 'Připojit se ke schůzce';
$string['jointime'] = 'Čas připojení';
$string['leavetime'] = 'Čas opuštění';
$string['licensesnumber'] = 'Počet licencí';
$string['lowlicenses'] = 'Pokud počet vašich licencí překročí požadované, pak při vytváření každé nové aktivity uživatelem bude přiřazena licence PRO snížením stavu jiného uživatele. Tato možnost je účinná, pokud je počet aktivních licencí PRO vyšší než 5.';
$string['maskparticipantdata'] = 'Skrýt data účastníků';
$string['maskparticipantdata_help'] = 'Zabrání zobrazení dat účastníků v záznamech (užitečné pro weby, které pseudonymizují data účastníků, např. pro HIPAA).';
$string['meeting_finished'] = 'Dokončení';
$string['meeting_nonexistent_on_zoom'] = 'Na Zoomu nenalezen';
$string['meeting_not_started'] = 'Nespuštěno';
$string['meetingoptions'] = 'Možnosti schůzky';
$string['meetingoptions_help'] = '*Připojit se před hostitelem* umožňuje účastníkům připojit se ke schůzce dříve, než se hostitel připojí, nebo když se hostitel nemůže zúčastnit schůzky.';
$string['meeting_started'] = 'Probíhá';
$string['meeting_time'] = 'Čas zahájení';
$string['modulename'] = 'Schůzka přes Zoom';
$string['modulename_help'] = 'Zoom je platforma pro videokonference a webové konference, která oprávněným uživatelům umožňuje pořádat online schůzky.';
$string['modulenameplural'] = 'Schůzky Zoom';
$string['newmeetings'] = 'Nové schůzky';
$string['nomeetinginstances'] = 'Pro tuto schůzku nebyly nalezeny žádné relace.';
$string['noparticipants'] = 'Pro tuto relaci nebyl v tuto chvíli nalezen žádný účastník.';
$string['nosessions'] = 'Pro zadaný rozsah nebyly nalezeny žádné relace.';
$string['nozooms'] = 'Žádné schůzky';
$string['off'] = 'Vypnuto';
$string['oldmeetings'] = 'Uzavřené schůzky';
$string['on'] = 'Zapnuto';
$string['option_audio'] = 'Možnosti zvuku';
$string['option_authenticated_users'] = 'Pouze ověření uživatelé';
$string['option_host_video'] = 'Video hostitele';
$string['option_jbh'] = 'Povolit připojení před hostitelem';
$string['option_mute_upon_entry'] = 'Ztlumit zvuk po vstupu';
$string['option_mute_upon_entry_help'] = 'Automaticky ztlumit všechny účastníky, když se připojí ke schůzce. Hostitel určuje, zda účastníci mohou následně sami aktivovat mikrofon.';
$string['option_participants_video'] = 'Video účastníků';
$string['option_proxyhost'] = 'Použít proxy server';
$string['option_proxyhost_desc'] = 'Proxy server nastavený jako \'<code>&lt;hostname&gt;:&lt;port&gt;</code>" se používá pouze pro komunikaci se Zoomem. Chcete-li použít výchozí nastavení proxy serveru Moodle, ponechte prázdné. Tuto možnost je třeba nastavit pouze v případě, že nechcete v Moodle nastavit globální proxy.';
$string['option_waiting_room'] = 'Povolit čekárnu';
$string['participantdatanotavailable'] = 'Podrobnosti nejsou k dispozici';
$string['participantdatanotavailable_help'] = 'Údaje o účastnících nejsou pro tuto relaci Zoomu k dispozici (např. z důvodu dodržování předpisů HIPAA).';
$string['participants'] = 'Účastníci';
$string['password'] = 'Heslo';
$string['passwordprotected'] = 'Chráněno heslem';
$string['pluginadministration'] = 'Spravovat schůzku';
$string['pluginname'] = 'Schůzka přes Zoom';
$string['privacy:metadata:zoom_meeting_details'] = 'Tabulka databáze, která ukládá informace o každé instanci schůzky.';
$string['privacy:metadata:zoom_meeting_details:topic'] = 'Název schůzky, které se uživatel zúčastnil.';
$string['privacy:metadata:zoom_meeting_participants'] = 'Tabulka databáze, která ukládá informace o účastnících schůzky.';
$string['privacy:metadata:zoom_meeting_participants:duration'] = 'Délka účasti uživatele';
$string['privacy:metadata:zoom_meeting_participants:join_time'] = 'Čas, kdy se účastník připojil ke schůzce';
$string['privacy:metadata:zoom_meeting_participants:leave_time'] = 'Čas, kdy účastník opustil schůzku';
$string['privacy:metadata:zoom_meeting_participants:name'] = 'Jméno účastníka';
$string['privacy:metadata:zoom_meeting_participants:user_email'] = 'E-mail účastníka';
$string['recurringmeeting'] = 'Opakovaná schůzka';
$string['recurringmeeting_help'] = 'Nemá žádné koncové datum.';
$string['recurringmeetinglong'] = 'Opakovaná schůzka (schůzka bez koncového data nebo času)';
$string['redefinelicenses'] = 'Předefinování licencí';
$string['report'] = 'Zprávy';
$string['reportapicalls'] = 'Oznámení o vyčerpání počtu volání rozhraní API';
$string['requirepassword'] = 'Vyžadovat heslo schůzky';
$string['resetapicalls'] = 'Obnovení počtu dostupných volání rozhraní API';
$string['search:activity'] = 'Zoom - informace o aktivitě';
$string['sessions'] = 'Relace';
$string['start'] = 'Začátek';
$string['starthostjoins'] = 'Spuštění videa při připojení hostitele';
$string['start_meeting'] = 'Zahájit schůzku';
$string['startpartjoins'] = 'Spuštění videa, když se účastník připojí';
$string['starttime'] = 'Čas zahájení';
$string['start_time'] = 'Kdy';
$string['status'] = 'Status';
$string['title'] = 'Název';
$string['topic'] = 'Téma';
$string['unavailable'] = 'V tuto chvíli nelze připojit.';
$string['updatemeetings'] = 'Aktualizace nastavení schůzky ze Zoomu';
$string['usepersonalmeeting'] = 'Použít osobní ID schůzky {$a}';
$string['waitingroom'] = 'Čekárna povolena';
$string['webinar'] = 'Webinář';
$string['webinar_already_false'] = '<p><b>Tento modul byl již nastaven jako schůzka, nikoli jako webinář. Toto nastavení nelze po vytvoření schůzky přepnout.</b></p>';
$string['webinar_already_true'] = '<p><b>Tento modul byl již nastaven jako webinář, nikoli jako schůzka. Toto nastavení nelze po vytvoření webináře přepnout </b> </p>';
$string['webinar_help'] = 'Tato možnost je k dispozici pouze pro předem autorizované účty na Zoomu.';
$string['zoom:addinstance'] = 'Přidání nové schůzky přes Zoom';
$string['zoomerr'] = 'Při připojení přes Zoom došlo k chybě.';
$string['zoomerr_apikey_missing'] = 'Klíč rozhraní API pro Zoom nebyl nalezen.';
$string['zoomerr_apisecret_missing'] = 'Tajný klíč rozhraní API Zoomu nebyl nalezen.';
$string['zoomerr_id_missing'] = 'Je nutné zadat ID course_module nebo ID instance.';
$string['zoomerr_licensesnumber_missing'] = 'Bylo nalezeno nastavení Zoomu, ale číslo licence nebylo nalezeno';
$string['zoomerr_maxretries'] = 'Pokusili jsme se spojit {$a->maxretries} krát, ale nezdařilo se: {$a->response}';
$string['zoomerr_meetingnotfound'] = 'Tuto schůzku nelze v aplikaci Zoom najít. Můžete ji <a href="{$a->recreate}">znovu vytvořit zde</a> nebo <a href="{$a->delete}">ji odstranit</a>.';
$string['zoomerr_meetingnotfound_info'] = 'Tuto schůzku nelze v aplikaci Zoom najít. Máte-li dotazy, obraťte se na hostitele schůzky.';
$string['zoomerr_usernotfound'] = 'V aplikaci Zoom nelze najít váš účet. Pokud používáte Zoom poprvé, musíte si založit účet na Zoomu <a href="{$a}" target="_blank">{$a}</a> (nebo potvrdit zprávu zaslanou zřizovatelem). Po aktivaci účtu na Zoomu znovu načtěte tuto stránku a pokračujte v nastavování schůzky. Jinak se ujistěte, že váš e-mail na Zoom odpovídá vašemu e-mailu v tomto systému.';
$string['zoomurl'] = 'URL domovské stránky Zoom';
$string['zoom:view'] = 'Zobrazení schůzek přes Zoom';
