<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'it', branch 'MOODLE_37_STABLE'
 *
 * @package   editor_tinymce
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Indirizzo';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'Inserisci/modifica ancora';
$string['advanced:backcolor_desc'] = 'Seleziona colore sfondo';
$string['advanced:block'] = 'Formato';
$string['advanced:blockquote'] = 'Citazione';
$string['advanced:blockquote_desc'] = 'Citazione';
$string['advanced:bold_desc'] = 'Grassetto (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Inserisci/rimuovi elenco puntato';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'Inserisci carattere speciale';
$string['advanced:cleanup_desc'] = 'Pulisci codice';
$string['advanced:clipboard_msg'] = 'In Mozilla Firefox non sono disponibili le funzioni Copia/Taglia/Incolla. Desideri maggiori informazioni su questo argomento?';
$string['advanced:code'] = 'Codice';
$string['advanced:code_desc'] = 'Modifica sorgente HTML';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'Copia';
$string['advanced:custom1_desc'] = 'La tua descrizione personalizzata';
$string['advanced:cut_desc'] = 'Taglia';
$string['advanced:dd'] = 'Descrizione definizione';
$string['advanced:div'] = 'DIV';
$string['advanced_dlg:'] = '';
$string['advanced_dlg:about_author'] = 'Autore';
$string['advanced_dlg:about_general'] = 'Informazioni';
$string['advanced_dlg:about_help'] = 'Aiuto';
$string['advanced_dlg:about_license'] = 'Licenza';
$string['advanced_dlg:about_loaded'] = 'Plugin caricati';
$string['advanced_dlg:about_plugin'] = 'Plugin';
$string['advanced_dlg:about_plugins'] = 'Plugins';
$string['advanced_dlg:about_title'] = 'Informazioni su TinyMCE';
$string['advanced_dlg:about_version'] = 'Versione';
$string['advanced_dlg:accessibility_help'] = 'Aiuto sull\'accessibilità';
$string['advanced_dlg:accessibility_usage_title'] = 'Uso generale';
$string['advanced_dlg:anchor_invalid'] = 'Per favore specifica un nome valido per il segnalibro.';
$string['advanced_dlg:anchor_name'] = 'Nome ancora';
$string['advanced_dlg:anchor_title'] = 'Inserisci/modifica ancora';
$string['advanced_dlg:charmap_title'] = 'Seleziona carattere speciale';
$string['advanced_dlg:charmap_usage'] = 'Per navigare, usa i i tasti freccia destra e freccia sinistra.';
$string['advanced_dlg:code_title'] = 'Editor sorgente HTML';
$string['advanced_dlg:code_wordwrap'] = 'A capo automatico';
$string['advanced_dlg:colorpicker_color'] = 'Colore:';
$string['advanced_dlg:colorpicker_name'] = 'Nome:';
$string['advanced_dlg:colorpicker_named_tab'] = 'Per nome';
$string['advanced_dlg:colorpicker_named_title'] = 'Colori per nome';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Tavolozza';
$string['advanced_dlg:colorpicker_palette_title'] = 'Tavolozza dei colori';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Selettore';
$string['advanced_dlg:colorpicker_picker_title'] = 'Selettore colori';
$string['advanced_dlg:colorpicker_title'] = 'Seleziona un colore';
$string['advanced_dlg:image_align'] = 'Allineamento';
$string['advanced_dlg:image_align_baseline'] = 'Alla base';
$string['advanced_dlg:image_align_bottom'] = 'In basso';
$string['advanced_dlg:image_align_left'] = 'A sinistra';
$string['advanced_dlg:image_align_middle'] = 'Al centro';
$string['advanced_dlg:image_align_right'] = 'A destra';
$string['advanced_dlg:image_align_textbottom'] = 'Al testo in basso';
$string['advanced_dlg:image_align_texttop'] = 'Al testo in alto';
$string['advanced_dlg:image_align_top'] = 'In alto';
$string['advanced_dlg:image_alt'] = 'Descrizione immagine';
$string['advanced_dlg:image_border'] = 'Bordo';
$string['advanced_dlg:image_dimensions'] = 'Dimensioni';
$string['advanced_dlg:image_hspace'] = 'Spaziatura orizzontale';
$string['advanced_dlg:image_list'] = 'Elenco immagini';
$string['advanced_dlg:image_src'] = 'URL immagine';
$string['advanced_dlg:image_title'] = 'Inserisci/modifica immagine';
$string['advanced_dlg:image_vspace'] = 'Spaziatura verticale';
$string['advanced_dlg:invalid_color_value'] = 'Colore non valido';
$string['advanced_dlg:link_is_email'] = 'L\'URL inserito sembra essere un indirizzo email. Desideri aggiungere il prefisso mailto: ?';
$string['advanced_dlg:link_is_external'] = 'L\'URL inserito sembra essere un link esterno. Desideri aggiungere il prefisso http://?';
$string['advanced_dlg:link_list'] = 'Elenco link';
$string['advanced_dlg:link_target'] = 'Target';
$string['advanced_dlg:link_target_blank'] = 'Apri link in una nuova finestra';
$string['advanced_dlg:link_target_same'] = 'Apri link nella stessa finestra';
$string['advanced_dlg:link_title'] = 'Inserisci/modifica link';
$string['advanced_dlg:link_titlefield'] = 'Titolo';
$string['advanced_dlg:link_url'] = 'URL del link';
$string['advanced:dt'] = 'Definizione termine';
$string['advanced:fontdefault'] = 'Famiglia carattere';
$string['advanced:font_size'] = 'Dimensione carattere';
$string['advanced:forecolor_desc'] = 'Seleziona colore testo';
$string['advanced:h1'] = 'Intestazione 1';
$string['advanced:h2'] = 'Intestazione 2';
$string['advanced:h3'] = 'Intestazione 3';
$string['advanced:h4'] = 'Intestazione 4';
$string['advanced:h5'] = 'Intestazione 5';
$string['advanced:h6'] = 'Intestazione 6';
$string['advanced:help_desc'] = 'Aiuto';
$string['advanced:help_shortcut'] = 'Premi ALT-F10 per la barra degli strumenti. Premi ALT-0 per l\'help';
$string['advanced:hr_desc'] = 'Inserisci riga orizzontale';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'Inserisci/modifica immagine';
$string['advanced:image_props_desc'] = 'Proprietà immagine';
$string['advanced:indent_desc'] = 'Aumenta rientro';
$string['advanced:italic_desc'] = 'Corsivo (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'Centra';
$string['advanced:justifyfull_desc'] = 'Giustifica';
$string['advanced:justifyleft_desc'] = 'Allinea a sinistra';
$string['advanced:justifyright_desc'] = 'Allinea a destra';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'Inserisci/modifica link';
$string['advanced:more_colors'] = 'Altri colori...';
$string['advanced:newdocument'] = 'Sei sicuro di voler eliminare tutti i contenuti?';
$string['advanced:newdocument_desc'] = 'Nuovo documento';
$string['advanced:numlist_desc'] = 'Inserisci/rimuovi elenco numerato';
$string['advanced:outdent_desc'] = 'Riduci rientro';
$string['advanced:paragraph'] = 'Paragrafo';
$string['advanced:paste_desc'] = 'Incolla';
$string['advanced:path'] = 'Percorso';
$string['advanced:pre'] = 'Preformattato';
$string['advanced:redo_desc'] = 'Ripristina (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Rimuovi formattazione';
$string['advanced:rich_text_area'] = 'Area rich text';
$string['advanced:samp'] = 'Esempio codice';
$string['advanced:shortcuts_desc'] = 'Aiuto sull\'accessibilità';
$string['advanced:striketrough_desc'] = 'Barrato';
$string['advanced:style_select'] = 'Stili';
$string['advanced:sub_desc'] = 'Pedice';
$string['advanced:sup_desc'] = 'Apice';
$string['advanced:toolbar'] = 'Barra degli strumenti';
$string['advanced:toolbar_focus'] = 'Vai ai pulsanti della barra degli strumenti - Alt+Q, Vai all\'editor - Alt-Z, Vai al percorso dell\'elemento - Alt-X';
$string['advanced:underline_desc'] = 'Sottolineato (Ctrl+U)';
$string['advanced:undo_desc'] = 'Annulla (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Togli link';
$string['advanced:visualaid_desc'] = 'Visualizza/nascondi linee guida/elementi invisibili';
$string['advhr:advhr_desc'] = 'Inserisci riga orizzontale';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:normal'] = 'Normale';
$string['advhr_dlg:noshade'] = 'Senza ombreggiatura';
$string['advhr_dlg:size'] = 'Altezza';
$string['advhr_dlg:width'] = 'Larghezza';
$string['advhr_dlg:widthunits'] = 'Unità';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage_dlg:align'] = 'Allineamento';
$string['advimage_dlg:align_baseline'] = 'Alla base';
$string['advimage_dlg:align_bottom'] = 'In basso';
$string['advimage_dlg:align_left'] = 'A sinistra';
$string['advimage_dlg:align_middle'] = 'In mezzo';
$string['advimage_dlg:align_right'] = 'A destra';
$string['advimage_dlg:align_textbottom'] = 'In basso al testo';
$string['advimage_dlg:align_texttop'] = 'In alto al testo';
$string['advimage_dlg:align_top'] = 'In alto';
$string['advimage_dlg:alt'] = 'Descrizione immagine';
$string['advimage_dlg:alt_image'] = 'Immagine alternativa';
$string['advimage_dlg:border'] = 'Bordo';
$string['advimage_dlg:classes'] = 'Classi';
$string['advimage_dlg:constrain_proportions'] = 'Mantieni proporzioni';
$string['advimage_dlg:dialog_title'] = 'Inserisci/modifica immagine';
$string['advimage_dlg:dimensions'] = 'Dimensioni';
$string['advimage_dlg:example_img'] = 'Anteprima aspetto immagine';
$string['advimage_dlg:general'] = 'Generale';
$string['advimage_dlg:height'] = 'Altezza';
$string['advimage_dlg:hspace'] = 'Spaziatura orizzontale';
$string['advimage_dlg:id'] = 'ID';
$string['advimage_dlg:image_list'] = 'Lista immagini';
$string['advimage_dlg:langcode'] = 'Codice lingua';
$string['advimage_dlg:langdir'] = 'Direzione testo';
$string['advimage_dlg:list'] = 'Lista immagini';
$string['advimage_dlg:long_desc'] = 'Descrizione del collegamento';
$string['advimage_dlg:ltr'] = 'Sinistra verso destra';
$string['advimage_dlg:map'] = 'Mappa immagine';
$string['advimage_dlg:misc'] = 'Impostazioni varie';
$string['advimage_dlg:missing_alt'] = 'Sei sicuro di continuare senza includere una descrizione dell\'immagine? Senza di essa l\'immagine può non essere accessibile ad utenti con disabilità, o per coloro che usano un browser testuale oppure che hanno disabilitato la visualizzazione delle immagini nel loro browser.';
$string['advimage_dlg:mouseout'] = 'su mouse out';
$string['advimage_dlg:mouseover'] = 'su mouse over';
$string['advimage_dlg:preview'] = 'Anteprima';
$string['advimage_dlg:rtl'] = 'Destra verso sinistraa';
$string['advimage_dlg:src'] = 'URL immagine';
$string['advimage_dlg:style'] = 'Stile';
$string['advimage_dlg:swap_image'] = 'Sostituisci immagine';
$string['advimage_dlg:tab_advanced'] = 'Avanzate';
$string['advimage_dlg:tab_appearance'] = 'Aspetto';
$string['advimage_dlg:tab_general'] = 'Generale';
$string['advimage_dlg:title'] = 'Titolo';
$string['advimage_dlg:vspace'] = 'Spaziatura verticale';
$string['advimage_dlg:width'] = 'Larghezza';
$string['advimage:image_desc'] = 'Inserisci/modifica immagine';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink_dlg:accesskey'] = 'Tasto accessibilità';
$string['advlink_dlg:advanced_props'] = 'Proprietà avanzate';
$string['advlink_dlg:advanced_tab'] = 'Avanzate';
$string['advlink_dlg:anchor_names'] = 'Ancore';
$string['advlink_dlg:classes'] = 'Classi';
$string['advlink_dlg:encoding'] = 'Codifica carattere target';
$string['advlink_dlg:event_props'] = 'Eventi';
$string['advlink_dlg:events_tab'] = 'Eventi';
$string['advlink_dlg:general_props'] = 'Proprietà generali';
$string['advlink_dlg:general_tab'] = 'Generale';
$string['advlink_dlg:height'] = 'Altezza';
$string['advlink_dlg:id'] = 'ID';
$string['advlink_dlg:is_email'] = 'L\'URL inserito sembra essere un indirizzo email. Desideri aggiungere il prefisso mailto: ?';
$string['advlink_dlg:is_external'] = 'L\'URL inserito sembra essere un link esterno. Desideri aggiungere il prefisso http://?';
$string['advlink_dlg:langcode'] = 'Codice lingua';
$string['advlink_dlg:langdir'] = 'Direzione del testo';
$string['advlink_dlg:link_list'] = 'Elenco link';
$string['advlink_dlg:list'] = 'Elenco link';
$string['advlink_dlg:ltr'] = 'Sinistra verso destra';
$string['advlink_dlg:mime'] = 'Tipo MIME del target';
$string['advlink_dlg:popup'] = 'Popup Javascript';
$string['advlink_dlg:popup_dependent'] = 'Dipendente (solo Mozilla/Firefox)';
$string['advlink_dlg:popup_location'] = 'Visualizza barra navigazione';
$string['advlink_dlg:popup_menubar'] = 'Visualizza barra menu';
$string['advlink_dlg:popup_name'] = 'Nome finestra';
$string['advlink_dlg:popup_opts'] = 'Opzioni';
$string['advlink_dlg:popup_position'] = 'Posizione (X/Y)';
$string['advlink_dlg:popup_props'] = 'Proprietà popup';
$string['advlink_dlg:popup_resizable'] = 'Rendi la finestra ridimensionabile';
$string['advlink_dlg:popup_return'] = 'Inserisci \'return false\'';
$string['advlink_dlg:popup_scrollbars'] = 'Visualizza barre di scorrimento';
$string['advlink_dlg:popup_size'] = 'Dimensioni';
$string['advlink_dlg:popup_statusbar'] = 'Visualizza barra di stato';
$string['advlink_dlg:popup_tab'] = 'Popup';
$string['advlink_dlg:popup_toolbar'] = 'Visualizza barre strumenti';
$string['advlink_dlg:popup_url'] = 'URL Popup';
$string['advlink_dlg:rel'] = 'Relazione da pagina a target';
$string['advlink_dlg:rev'] = 'Relazione da target a pagina';
$string['advlink_dlg:rtl'] = 'Destra verso sinistra';
$string['advlink_dlg:style'] = 'Stile';
$string['advlink_dlg:tabindex'] = 'Indice tabulazione';
$string['advlink_dlg:target'] = 'Target';
$string['advlink_dlg:target_blank'] = 'Apri in una nuova finestra';
$string['advlink_dlg:target_langcode'] = 'Lingua target';
$string['advlink_dlg:target_name'] = 'Nome target';
$string['advlink_dlg:target_parent'] = 'Apri nella finestra/frame genitore';
$string['advlink_dlg:target_same'] = 'Apri in questa finestra/frame';
$string['advlink_dlg:target_top'] = 'Apri nella cornice superiore (sostituisce tutte le cornici)';
$string['advlink_dlg:title'] = 'Inserisci/modifica link';
$string['advlink_dlg:titlefield'] = 'Titolo';
$string['advlink_dlg:url'] = 'URL link';
$string['advlink_dlg:width'] = 'Larghezza';
$string['advlink:link_desc'] = 'Inserisci/modifica link';
$string['advlist:circle'] = 'Cerchio';
$string['advlist:def'] = 'Default';
$string['advlist:disc'] = 'Disco';
$string['advlist:lower_alpha'] = 'Minuscolo';
$string['advlist:lower_greek'] = 'Greco minuscolo';
$string['advlist:lower_roman'] = 'Numero romano minuscolo';
$string['advlist:square'] = 'Quadrato';
$string['advlist:types'] = 'Caratteri';
$string['advlist:upper_alpha'] = 'Maiuscolo';
$string['advlist:upper_roman'] = 'Numero romano maiuscolo';
$string['aria:rich_text_area'] = 'Area rich text';
$string['autosave:restore_content'] = 'Ripristinare contenuto salvato automaticamente';
$string['autosave:unload_msg'] = 'I cambiamenti effettuati saranno persi se si abbandona la pagina corrente.';
$string['autosave:warning_message'] = 'Ripristinando il contenuto salvato, si perderà tutto il testo presente nell\'editor.

Sei sicuro di ripristinare il contenuto salvato?.';
$string['availablebuttons'] = 'Pulsanti disponibili';
$string['colors:000000'] = 'Nero';
$string['colors:000080'] = 'Blu scuro';
$string['colors:0000FF'] = 'Blu';
$string['colors:003300'] = 'Verde scuro';
$string['colors:003366'] = 'Azzurro scuro';
$string['colors:008000'] = 'Verde';
$string['colors:008080'] = 'Verde azzurro';
$string['colors:00CCFF'] = 'Blu cielo';
$string['colors:00FF00'] = 'Giallo verde';
$string['colors:00FFFF'] = 'Acquamarina';
$string['colors:333300'] = 'Verde oliva scuro';
$string['colors:333333'] = 'Grigio scuro';
$string['colors:333399'] = 'Indaco';
$string['colors:3366FF'] = 'Blu reale';
$string['colors:339966'] = 'Verde mare';
$string['colors:33CCCC'] = 'Turchese';
$string['colors:666699'] = 'Grigio blu';
$string['colors:800000'] = 'Bordeaux';
$string['colors:800080'] = 'Viola';
$string['colors:808000'] = 'Verde oliva';
$string['colors:808080'] = 'Grigio';
$string['colors:993300'] = 'Arancione scuro';
$string['colors:993366'] = 'Marrone';
$string['colors:999999'] = 'Grigio medio';
$string['colors:99CC00'] = 'Giallo verde';
$string['colors:99CCFF'] = 'Blu cielo chiaro';
$string['colors:C0C0C0'] = 'Argento';
$string['colors:CC99FF'] = 'Prugna';
$string['colors:CCFFCC'] = 'Verde chiaro';
$string['colors:CCFFFF'] = 'Turchese chiaro';
$string['colors:FF0000'] = 'Rosso';
$string['colors:FF00FF'] = 'Magenta';
$string['colors:FF6600'] = 'Arancio';
$string['colors:FF9900'] = 'Ambra';
$string['colors:FF99CC'] = 'Rosa';
$string['colors:FFCC00'] = 'Oro';
$string['colors:FFCC99'] = 'Pesca';
$string['colors:FFFF00'] = 'Giallo';
$string['colors:FFFF99'] = 'Giallo chiaro';
$string['colors:FFFFFF'] = 'Bianco';
$string['common:apply'] = 'Applica';
$string['common:browse'] = 'Sfoglia';
$string['common:cancel'] = 'Annulla';
$string['common:class_name'] = 'Classe';
$string['common:clipboard_msg'] = 'Copia/taglia/incolla non è disponibile in Mozilla e Firefox.Desideri avere maggiori informazioni su questo problema?';
$string['common:clipboard_no_support'] = 'Al momento non è supportato dal tuo browser in uso, usa le scorciatoie da tastiera.';
$string['common:close'] = 'Chiudi';
$string['common:edit_confirm'] = 'Vuoi usare la modalità WYSIWYG per questa area di testo?';
$string['common:insert'] = 'Inserisci';
$string['common:invalid_data'] = 'Errore: sono stati inseriti valori non validi, evidenziati in rosso.';
$string['common:invalid_data_min'] = '{#field} deve essere un numero maggiore di {#min}';
$string['common:invalid_data_number'] = '{#field} deve essere un numero';
$string['common:invalid_data_size'] = '{#field} deve essere un numero o una percentuale';
$string['common:more_colors'] = 'Altri colori...';
$string['common:not_set'] = '-- Non impostato --';
$string['common:popup_blocked'] = 'Spiacente, il blocco delle popup ha disabilitato una finestra che fornisce funzionalità all\'applicazione. Per poter utilizzare appieno lo strumento devi disabilitare il blocco delle popup.';
$string['common:update'] = 'Aggiorna';
$string['common:value'] = '(valore)';
$string['contextmenu:align'] = 'Allineamento';
$string['contextmenu:center'] = 'Centra';
$string['contextmenu:full'] = 'Giustifica';
$string['contextmenu:left'] = 'Allinea a sinistra';
$string['contextmenu:right'] = 'Allinea a destra';
$string['customconfig'] = 'Configurazione personalizzata';
$string['customconfig_desc'] = 'Configurazione avanzata TinyMCE in formato JSON, ad esempio {"option1" : "value2", "option2" : "value2"}. Le opzioni definite tramite queste impostazioni prevalgono sulle opzioni standard e del plugin.';
$string['customtoolbar'] = 'Editor toolbar';
$string['customtoolbar_desc'] = 'Ciascuna linea contiene un elenco separato da virgole con i nomi dei pulsanti. Per separare gruppi di pulsanti è possibile utilizzare "wrap". Le linee vuote saranno ignorate.Per l\'elenco di pulsanti di default di TinyMCE: <a href="{$a}" target="_blank">{$a}</a>. <br />La prima riga di pulsanti viene sempre visualizzata, la visibilità delle altre righe è a scelta.';
$string['directionality:ltr_desc'] = 'Direzione da sinistra a destra';
$string['directionality:rtl_desc'] = 'Direzione da destra a sinistra';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions_dlg:cool'] = 'Fico';
$string['emotions_dlg:cry'] = 'Piango';
$string['emotions_dlg:desc'] = 'Faccina';
$string['emotions_dlg:embarassed'] = 'Imbarazzato';
$string['emotions_dlg:foot_in_mouth'] = 'Piede in bocca';
$string['emotions_dlg:frown'] = 'Triste';
$string['emotions_dlg:innocent'] = 'Santarellino';
$string['emotions_dlg:kiss'] = 'Bacio';
$string['emotions_dlg:laughing'] = 'Risatona';
$string['emotions_dlg:money_mouth'] = 'Bocca danarosa';
$string['emotions_dlg:sealed'] = 'Bocca sigillata';
$string['emotions_dlg:smile'] = 'Sorridente';
$string['emotions_dlg:surprised'] = 'Sorpreso';
$string['emotions_dlg:title'] = 'Inserisci faccina';
$string['emotions_dlg:tongue_out'] = 'Lingua di fuori';
$string['emotions_dlg:undecided'] = 'Indeciso';
$string['emotions_dlg:usage'] = 'Per navigare usa i tasti freccia destra e freccia sinistra.';
$string['emotions_dlg:wink'] = 'Occhiolino';
$string['emotions_dlg:yell'] = 'Arrabbiato';
$string['emotions:emotions_desc'] = 'Faccine';
$string['fontselectlist'] = 'Elenco font disponibili';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'Proprietà Documento';
$string['fullpage_dlg:active_color'] = 'Colore \'Active\'';
$string['fullpage_dlg:add'] = 'Aggiungi nuovo elemento';
$string['fullpage_dlg:add_base'] = 'Elemento Base';
$string['fullpage_dlg:add_comment'] = 'Nodo Commento';
$string['fullpage_dlg:add_link'] = 'Elemento Link';
$string['fullpage_dlg:add_meta'] = 'Elemento Meta';
$string['fullpage_dlg:add_script'] = 'Elemento Script';
$string['fullpage_dlg:add_style'] = 'Elemento Stile';
$string['fullpage_dlg:add_title'] = 'Elemento Titolo';
$string['fullpage_dlg:advanced_props'] = 'Avanzate';
$string['fullpage_dlg:advanced_tab'] = 'Avanzate';
$string['fullpage_dlg:appearance_bgprops'] = 'Proprietà sfondo';
$string['fullpage_dlg:appearance_linkprops'] = 'Colori collegamenti';
$string['fullpage_dlg:appearance_marginprops'] = 'Margini';
$string['fullpage_dlg:appearance_style'] = 'Proprietà stili e fogli di stile';
$string['fullpage_dlg:appearance_tab'] = 'Aspetto';
$string['fullpage_dlg:appearance_textprops'] = 'Proprietà testo';
$string['fullpage_dlg:author'] = 'Autore';
$string['fullpage_dlg:base_element'] = 'Elemento Base';
$string['fullpage_dlg:bgcolor'] = 'Colore sfondo';
$string['fullpage_dlg:bgimage'] = 'Immagine sfondo';
$string['fullpage_dlg:bottom_margin'] = 'Margine inferiore';
$string['fullpage_dlg:charset'] = 'Set caratteri';
$string['fullpage_dlg:comment_element'] = 'Commento';
$string['fullpage_dlg:content'] = 'Contenuto';
$string['fullpage_dlg:copyright'] = 'Copyright';
$string['fullpage_dlg:defer'] = 'Defer';
$string['fullpage_dlg:doctypes'] = 'Doctype';
$string['fullpage_dlg:encoding'] = 'Codifica carattere';
$string['fullpage_dlg:fontface'] = 'Famiglia carattere';
$string['fullpage_dlg:font_face'] = 'Tipo carattere';
$string['fullpage_dlg:fontsize'] = 'Dimensione carattere';
$string['fullpage_dlg:font_size'] = 'Dimensione carattere';
$string['fullpage_dlg:general_props'] = 'Generale';
$string['fullpage_dlg:head_elements'] = 'Elementi Intestazione';
$string['fullpage_dlg:hover_color'] = 'Colore Hover';
$string['fullpage_dlg:href'] = 'HREF';
$string['fullpage_dlg:hreflang'] = 'HREF lang';
$string['fullpage_dlg:info'] = 'Informazioni';
$string['fullpage_dlg:langcode'] = 'Codice lingua';
$string['fullpage_dlg:langdir'] = 'Direzione testo';
$string['fullpage_dlg:langprops'] = 'Lingua e codifica';
$string['fullpage_dlg:language'] = 'Linguaggio';
$string['fullpage_dlg:left_margin'] = 'Margine sinistro';
$string['fullpage_dlg:link_color'] = 'Colore collegamento';
$string['fullpage_dlg:link_element'] = 'Elemento Link';
$string['fullpage_dlg:ltr'] = 'Sinistra verso destra';
$string['fullpage_dlg:media'] = 'Media';
$string['fullpage_dlg:meta_description'] = 'Descrizione';
$string['fullpage_dlg:meta_element'] = 'Elemento Meta';
$string['fullpage_dlg:meta_index_follow'] = 'Indicizza e segui i link';
$string['fullpage_dlg:meta_index_nofollow'] = 'Indicizza e non seguire i link';
$string['fullpage_dlg:meta_keywords'] = 'Parole chiave';
$string['fullpage_dlg:meta_noindex_follow'] = 'Non indicizzare ma seguire collegamenti';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Non indicizzare e non seguire collegamenti';
$string['fullpage_dlg:meta_props'] = 'Informazioni Metatag';
$string['fullpage_dlg:meta_robots'] = 'Robots';
$string['fullpage_dlg:meta_tab'] = 'Generale';
$string['fullpage_dlg:meta_title'] = 'Titolo';
$string['fullpage_dlg:movedown'] = 'Sposta in basso l\'elemento selezionato';
$string['fullpage_dlg:moveup'] = 'Sposta in alto l\'elemento selezionato';
$string['fullpage_dlg:name'] = 'Nome';
$string['fullpage_dlg:properties'] = 'Proprietà';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'Rimuovi l\'elemento selezionato';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'Margine destro';
$string['fullpage_dlg:rtl'] = 'Destra verso sinistra';
$string['fullpage_dlg:script_element'] = 'Elemento Script';
$string['fullpage_dlg:src'] = 'Sorgente';
$string['fullpage_dlg:style'] = 'Stile';
$string['fullpage_dlg:style_element'] = 'Elemento Style';
$string['fullpage_dlg:stylesheet'] = 'Fogli di stile';
$string['fullpage_dlg:target'] = 'Target';
$string['fullpage_dlg:textcolor'] = 'Colore';
$string['fullpage_dlg:text_color'] = 'Colore testo';
$string['fullpage_dlg:title'] = 'Proprietà Documento';
$string['fullpage_dlg:title_element'] = 'Elemento Titolo';
$string['fullpage_dlg:top_margin'] = 'Margine superiore';
$string['fullpage_dlg:type'] = 'Tipo';
$string['fullpage_dlg:value'] = 'Valore';
$string['fullpage_dlg:visited_color'] = 'Colore \'Visited\'';
$string['fullpage_dlg:xml_pi'] = 'Dichiarazione XML';
$string['fullscreen:desc'] = 'Attiva/disattiva modalità a tutto schermo';
$string['iespell:download'] = 'ieSpell non rilevato. Installarlo ora?';
$string['iespell:iespell_desc'] = 'Controllo ortografico';
$string['insertdatetime:date_fmt'] = '%Y-%m-%d';
$string['insertdatetime:day_long'] = 'Domenica,Lunedì,Martedì,Mercoledì,Giovedì,Venerdì,Sabato,Domenica';
$string['insertdatetime:day_short'] = 'Dom,Lun,Mar,Mer,Gio,Ven,Sab,Dom';
$string['insertdatetime:insertdate_desc'] = 'Inserisci data';
$string['insertdatetime:inserttime_desc'] = 'Inserisci ora';
$string['insertdatetime:months_long'] = 'Gennaio,Febbraio,Marzo,Aprile,Maggio,Giugno,Luglio,Agosto,Settembre,Ottobre,Novembre,Dicembre';
$string['insertdatetime:months_short'] = 'Gen,Feb,Mar,Apr,Mag,Giu,Lug,Ago,Set,Ott,Nov,Dic';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Attiva/Disattiva posizionamento assoluto';
$string['layer:backward_desc'] = 'Porta sullo sfondo';
$string['layer:content'] = 'Nuovo layer...';
$string['layer:forward_desc'] = 'Porta in rilievo';
$string['layer:insertlayer_desc'] = 'Inserisci nuovo layer';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'Inserisci/modifica media incorporato';
$string['media_dlg:advanced'] = 'Avanzate';
$string['media_dlg:align'] = 'Allineamento';
$string['media_dlg:align_bottom'] = 'Basso';
$string['media_dlg:align_bottom_left'] = 'Basso a sinistra';
$string['media_dlg:align_bottom_right'] = 'Basso a destra';
$string['media_dlg:align_center'] = 'Centro';
$string['media_dlg:align_left'] = 'Sinistra';
$string['media_dlg:align_right'] = 'Destra';
$string['media_dlg:align_top'] = 'Alto';
$string['media_dlg:align_top_left'] = 'Alto a sinistra';
$string['media_dlg:align_top_right'] = 'Alto a destra';
$string['media_dlg:altsource1'] = 'Sorgente alternativo 1';
$string['media_dlg:altsource2'] = 'Sorgente alternativo 2';
$string['media_dlg:audio'] = 'Audio HTML5';
$string['media_dlg:autogotourl'] = 'Vai automaticamante all\'URL';
$string['media_dlg:autohref'] = 'Auto HREF';
$string['media_dlg:autostart'] = 'Avvio automatico';
$string['media_dlg:balance'] = 'Bilanciamento';
$string['media_dlg:base'] = 'Base';
$string['media_dlg:baseurl'] = 'URL base';
$string['media_dlg:bgcolor'] = 'Sfondo';
$string['media_dlg:cache'] = 'Cache';
$string['media_dlg:captioningid'] = 'ID sottotitolo';
$string['media_dlg:center'] = 'Centra';
$string['media_dlg:class_name'] = 'Classe';
$string['media_dlg:console'] = 'Console';
$string['media_dlg:constrain_proportions'] = 'Mantieni proporzioni';
$string['media_dlg:controller'] = 'Controller';
$string['media_dlg:controls'] = 'Controlli';
$string['media_dlg:correction'] = 'Nessuna correzione';
$string['media_dlg:currentmarker'] = 'Indicatore corrente';
$string['media_dlg:currentposition'] = 'Posizione corrente';
$string['media_dlg:defaultframe'] = 'Frame predefinito';
$string['media_dlg:embeddedaudio'] = 'Audio incorporato';
$string['media_dlg:embedded_audio_options'] = 'Opzioni audio incorporato';
$string['media_dlg:enabled'] = 'Abilitato';
$string['media_dlg:enablejavascript'] = 'Abilita JavaScript';
$string['media_dlg:endtime'] = 'Tempo fine';
$string['media_dlg:file'] = 'File/URL';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Opzioni Flash';
$string['media_dlg:flashvars'] = 'Flash vars';
$string['media_dlg:fullscreen'] = 'Schermo intero';
$string['media_dlg:general'] = 'Generale';
$string['media_dlg:hidden'] = 'Nascosto';
$string['media_dlg:href'] = 'HREF';
$string['media_dlg:hspace'] = 'H-Space';
$string['media_dlg:html5_audio_options'] = 'Opzioni audio';
$string['media_dlg:html5_video_options'] = 'Opzioni video HTML5';
$string['media_dlg:id'] = 'ID';
$string['media_dlg:iframe'] = 'Iframe';
$string['media_dlg:imagestatus'] = 'Stato immagine';
$string['media_dlg:invokeurls'] = 'Chiama URL';
$string['media_dlg:kioskmode'] = 'Modalità chiosco';
$string['media_dlg:list'] = 'Lista';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Riproduzione ciclica';
$string['media_dlg:maintainaspect'] = 'Mantieni rapporto di forma';
$string['media_dlg:menu'] = 'Visualizza menu';
$string['media_dlg:mute'] = 'Muto';
$string['media_dlg:name'] = 'Nome';
$string['media_dlg:nojava'] = 'No java';
$string['media_dlg:numloop'] = 'Numero cicli';
$string['media_dlg:play'] = 'Esecuzione automatica';
$string['media_dlg:playcount'] = 'Conteggio esecuzioni';
$string['media_dlg:playeveryframe'] = 'Esegui tutti i frame';
$string['media_dlg:poster'] = 'Poster';
$string['media_dlg:prefetch'] = 'Precaricamento';
$string['media_dlg:preload'] = 'Preload';
$string['media_dlg:preload_auto'] = 'Lascia decidere al browser dell\'utente';
$string['media_dlg:preload_metadata'] = 'Preload dei metadati del video';
$string['media_dlg:preload_none'] = 'Non effettuare prelaod';
$string['media_dlg:preview'] = 'Anteprima';
$string['media_dlg:progress'] = 'Avanzamento';
$string['media_dlg:qt_options'] = 'Opzioni Quicktime';
$string['media_dlg:qtsrc'] = 'Sorgente QT';
$string['media_dlg:qtsrcchokespeed'] = 'Velocità cursore';
$string['media_dlg:qt_stream_warn'] = 'Le risorse rstp \'streamed\' devono essere aggiunte al campo sorgente QT nel tab Avanzate. Al campo sorgente andrebbe anche aggiunta  una versione non \'streamed\'.';
$string['media_dlg:quality'] = 'Qualità';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Velocità';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Opzioni Real Media Player';
$string['media_dlg:salign'] = 'SAlign';
$string['media_dlg:scale'] = 'Scalatura';
$string['media_dlg:scriptcallbacks'] = 'Script callback';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Opzioni Shockwave';
$string['media_dlg:shuffle'] = 'Shuffle';
$string['media_dlg:size'] = 'Dimensioni';
$string['media_dlg:sound'] = 'Suono';
$string['media_dlg:source'] = 'Sorgente';
$string['media_dlg:starttime'] = 'Ora inizio';
$string['media_dlg:stretchtofit'] = 'Adatta dimensioni';
$string['media_dlg:swstretchhalign'] = 'Adatta H-Align';
$string['media_dlg:swstretchstyle'] = 'Adatta stile';
$string['media_dlg:swstretchvalign'] = 'Adatta V-Align';
$string['media_dlg:target'] = 'Target';
$string['media_dlg:targetcache'] = 'Target cache';
$string['media_dlg:title'] = 'Inserisci/modifica media incorporato';
$string['media_dlg:type'] = 'Tipo';
$string['media_dlg:uimode'] = 'Modalità UI';
$string['media_dlg:video'] = 'Video HTML5';
$string['media_dlg:volume'] = 'Volume';
$string['media_dlg:vspace'] = 'V-Space';
$string['media_dlg:windowlessvideo'] = 'Video senza finestra';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = 'WMode';
$string['media_dlg:wmp_options'] = 'Opzioni Windows Media Player';
$string['media:edit'] = 'Modifica media incorporato';
$string['nonbreaking:nonbreaking_desc'] = 'Inserisci un non-breaking space';
$string['pagebreak:desc'] = 'Inserisci interruzione di pagina per la stampa';
$string['paste_dlg:text_linebreaks'] = 'Mantieni interruzioni di riga';
$string['paste_dlg:text_title'] = 'Premere CTRL+V sulla tastiera per incollare il testo nella finestra.';
$string['paste_dlg:word_title'] = 'Premere CTRL+V sulla tastiera per incollare il testo nella finestra.';
$string['paste:paste_text_desc'] = 'Incolla come testo semplice';
$string['paste:paste_word_desc'] = 'Incolla da Word';
$string['paste:plaintext_mode'] = 'La funzione incolla è ora in modalità testo semplice. Clicca di nuovo per tornare alla modalità incolla normale. Dopo aver eseguito la funzione incolla la modalità tornerà in modalità normale.';
$string['paste:plaintext_mode_stick'] = 'La funzione incolla è ora in modalità testo semplice. Clicca di nuovo per tornare alla modalità incolla normale.';
$string['paste:selectall_desc'] = 'Seleziona tutto';
$string['pluginname'] = 'TinyMCE HTML editor';
$string['preview:preview_desc'] = 'Anteprima';
$string['print:print_desc'] = 'Stampa';
$string['privacy:metadata'] = 'Il plugin editor HTML "TinyMCE" non memorizza dati personali.';
$string['save:cancel_desc'] = 'Elimina tutte le modifiche';
$string['save:save_desc'] = 'Salva';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace_dlg:allreplaced'] = 'Tutte le occorrenze del criterio di ricerca sono state sostituite.';
$string['searchreplace_dlg:direction'] = 'Direzione';
$string['searchreplace_dlg:down'] = 'In giù';
$string['searchreplace_dlg:findnext'] = 'Trova successivo';
$string['searchreplace_dlg:findwhat'] = 'Trova:';
$string['searchreplace_dlg:mcase'] = 'Maiuscole/minuscole';
$string['searchreplace_dlg:notfound'] = 'Ricerca completata. Nessun risultato trovato.';
$string['searchreplace_dlg:replace'] = 'Sostituisci';
$string['searchreplace_dlg:replaceall'] = 'Sostituisci tutto';
$string['searchreplace_dlg:replace_title'] = 'Trova/sostituisci';
$string['searchreplace_dlg:replacewith'] = 'Sostituisci con:';
$string['searchreplace_dlg:searchnext_desc'] = 'Trova successivo';
$string['searchreplace_dlg:search_title'] = 'Trova';
$string['searchreplace_dlg:up'] = 'In alto';
$string['searchreplace:replace_desc'] = 'Trova/sostituisci';
$string['searchreplace:search_desc'] = 'Trova';
$string['settings'] = 'Impostazioni generali';
$string['simple:bold_desc'] = 'Grassetto (Ctrl+B)';
$string['simple:bullist_desc'] = 'Aggiungi/rimuovi elenco puntato';
$string['simple:cleanup_desc'] = 'Pulisci codice disordinato';
$string['simple:italic_desc'] = 'Corsivo (Ctrl+I)';
$string['simple:numlist_desc'] = 'Aggiungi/rimuovi elenco numerato';
$string['simple:redo_desc'] = 'Ripristina (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Barrato';
$string['simple:underline_desc'] = 'Sottolineato (Ctrl+U)';
$string['simple:undo_desc'] = 'Annulla (Ctrl+Z)';
$string['spellchecker:desc'] = 'Attiva/disattiva controllo ortografico';
$string['spellchecker:ignore_word'] = 'Ignora parola';
$string['spellchecker:ignore_words'] = 'Ignora tutto';
$string['spellchecker:langs'] = 'Lingue';
$string['spellchecker:learn_word'] = 'Impara parola';
$string['spellchecker:menu'] = 'Impostazioni controllo ortografico';
$string['spellchecker:no_mpell'] = 'Nessun errore rilevato.';
$string['spellchecker:no_sug'] = 'Nessun suggerimento';
$string['spellchecker:sug'] = 'Suggerimenti';
$string['spellchecker:wait'] = 'Attendere prego...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'Modifica stile CSS';
$string['style_dlg:apply'] = 'Applica';
$string['style_dlg:background'] = 'Sfondo';
$string['style_dlg:background_attachment'] = 'Allegato';
$string['style_dlg:background_color'] = 'Colore sfondo';
$string['style_dlg:background_hpos'] = 'Posizione orizzontale';
$string['style_dlg:background_image'] = 'Immagine sfondo';
$string['style_dlg:background_repeat'] = 'Ripetizione';
$string['style_dlg:background_tab'] = 'Sfondo';
$string['style_dlg:background_vpos'] = 'Posizione verticale';
$string['style_dlg:block'] = 'Blocco';
$string['style_dlg:block_display'] = 'Visualizzazione';
$string['style_dlg:block_letterspacing'] = 'Spaziatura caratteri';
$string['style_dlg:block_tab'] = 'Blocco';
$string['style_dlg:block_text_align'] = 'Allineamento testo';
$string['style_dlg:block_text_indent'] = 'Indentazione testo';
$string['style_dlg:block_vertical_alignment'] = 'Allineamento verticale';
$string['style_dlg:block_whitespace'] = 'Spazio bianco';
$string['style_dlg:block_wordspacing'] = 'Spaziatura parole';
$string['style_dlg:border'] = 'Bordo';
$string['style_dlg:border_tab'] = 'Bord0';
$string['style_dlg:bottom'] = 'Inferiore';
$string['style_dlg:box'] = 'Riquadro';
$string['style_dlg:box_clear'] = 'Clear';
$string['style_dlg:box_float'] = 'Float';
$string['style_dlg:box_height'] = 'Altezza';
$string['style_dlg:box_tab'] = 'Box';
$string['style_dlg:box_width'] = 'Larghezza';
$string['style_dlg:bullet_image'] = 'Immagine elenco puntato';
$string['style_dlg:clip'] = 'Clip';
$string['style_dlg:color'] = 'Colore';
$string['style_dlg:height'] = 'Altezza';
$string['style_dlg:left'] = 'Sinistro';
$string['style_dlg:list'] = 'Elenco';
$string['style_dlg:list_tab'] = 'Liste';
$string['style_dlg:list_type'] = 'Tipo';
$string['style_dlg:margin'] = 'Margine';
$string['style_dlg:overflow'] = 'Overflow';
$string['style_dlg:padding'] = 'Padidng';
$string['style_dlg:placement'] = 'Posizionamento';
$string['style_dlg:position'] = 'Posizione';
$string['style_dlg:positioning_tab'] = 'Posizionamento';
$string['style_dlg:positioning_type'] = 'Tipo';
$string['style_dlg:right'] = 'Destro';
$string['style_dlg:same'] = 'Uguale per tutti';
$string['style_dlg:style'] = 'Stile';
$string['style_dlg:text'] = 'Testo';
$string['style_dlg:text_blink'] = 'Lampeggiante';
$string['style_dlg:text_case'] = 'Tipo';
$string['style_dlg:text_color'] = 'Colore';
$string['style_dlg:text_decoration'] = 'Decorazione';
$string['style_dlg:text_font'] = 'Carattere';
$string['style_dlg:text_lineheight'] = 'Altezza linea';
$string['style_dlg:text_none'] = 'Nessuno';
$string['style_dlg:text_overline'] = 'Sopralineato';
$string['style_dlg:text_props'] = 'Testo';
$string['style_dlg:text_size'] = 'Dimensione';
$string['style_dlg:text_striketrough'] = 'Barrato';
$string['style_dlg:text_style'] = 'Stile';
$string['style_dlg:text_tab'] = 'Testo';
$string['style_dlg:text_underline'] = 'Sottolineato';
$string['style_dlg:text_variant'] = 'Variante';
$string['style_dlg:text_weight'] = 'Spessore';
$string['style_dlg:title'] = 'Modifica stile CSS';
$string['style_dlg:toggle_insert_span'] = 'Inserisci span alla selezione';
$string['style_dlg:top'] = 'Superiore';
$string['style_dlg:visibility'] = 'Visibilità';
$string['style_dlg:width'] = 'Larghezza';
$string['style_dlg:zindex'] = 'Z-index';
$string['subplugintype_tinymce'] = 'Plugin';
$string['subplugintype_tinymce_plural'] = 'Plugin';
$string['table:cell'] = 'Cella';
$string['table:cell_desc'] = 'Proprietà cella';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = 'Colonna';
$string['table:col_after_desc'] = 'Inserisci colonna dopo';
$string['table:col_before_desc'] = 'Inserisci colonna prima';
$string['table:copy_row_desc'] = 'Copia riga';
$string['table:cut_row_desc'] = 'Taglia riga';
$string['table:del'] = 'Elimina tabella';
$string['table:delete_col_desc'] = 'Elimina colonna';
$string['table:delete_row_desc'] = 'Elimina riga';
$string['table:desc'] = 'Inserisci/modifica tabella';
$string['table_dlg:advanced_props'] = 'Proprietà avanzate';
$string['table_dlg:advanced_tab'] = 'Avanzate';
$string['table_dlg:align'] = 'Allineamento';
$string['table_dlg:align_bottom'] = 'In basso';
$string['table_dlg:align_default'] = 'Predefinito';
$string['table_dlg:align_left'] = 'A sinistra';
$string['table_dlg:align_middle'] = 'Centra';
$string['table_dlg:align_right'] = 'A destra';
$string['table_dlg:align_top'] = 'In alto';
$string['table_dlg:bgcolor'] = 'Colore sfondo';
$string['table_dlg:bgimage'] = 'Immagine sfondo';
$string['table_dlg:border'] = 'Bordo';
$string['table_dlg:bordercolor'] = 'Colore bordo';
$string['table_dlg:caption'] = 'Didascalia tabella';
$string['table_dlg:cell_all'] = 'Aggiorna tutte le celle della tabella';
$string['table_dlg:cell_cell'] = 'Aggiorna cella corrente';
$string['table_dlg:cell_col'] = 'Aggiorna tutte le celle nella colonna';
$string['table_dlg:cell_limit'] = 'Avete superato il numero massimo di celle pari a {$cells}.';
$string['table_dlg:cellpadding'] = 'Padding celle';
$string['table_dlg:cell_row'] = 'Aggiorna tutte le celle della riga';
$string['table_dlg:cellspacing'] = 'Spaziatura celle';
$string['table_dlg:cell_title'] = 'Proprietà cella';
$string['table_dlg:cell_type'] = 'Tipo cella';
$string['table_dlg:colgroup'] = 'Gruppo colonne';
$string['table_dlg:col_limit'] = 'Avete superato il numero massimo di colonne pari a {$cols}.';
$string['table_dlg:cols'] = 'Colonne';
$string['table_dlg:frame'] = 'Cornice';
$string['table_dlg:frame_all'] = 'tutte';
$string['table_dlg:frame_cols'] = 'colonne';
$string['table_dlg:frame_groups'] = 'gruppi';
$string['table_dlg:frame_none'] = 'nessuna';
$string['table_dlg:frame_rows'] = 'righe';
$string['table_dlg:general_props'] = 'Proprietà generali';
$string['table_dlg:general_tab'] = 'Generale';
$string['table_dlg:height'] = 'Altezza';
$string['table_dlg:id'] = 'ID';
$string['table_dlg:langcode'] = 'Lingua';
$string['table_dlg:langdir'] = 'Direzione testo';
$string['table_dlg:ltr'] = 'Sinistra verso destra';
$string['table_dlg:merge_cells_title'] = 'Unisci celle';
$string['table_dlg:mime'] = 'Tipo MIME del target';
$string['table_dlg:missing_scope'] = 'Sei sicuro di proseguire senza aver specificato un ambito per la cella di questo valore intestazione di questa tabella? Senza questo valore per alcuni utenti con disabilità potrebbe essere difficoltoso capire il contenuto o i dati visualizzati tramite la tabella.';
$string['table_dlg:row_all'] = 'Aggiorna tutte le righe della tabella';
$string['table_dlg:row_even'] = 'Aggiorna righe pari della tabella';
$string['table_dlg:rowgroup'] = 'Gruppo righe';
$string['table_dlg:row_limit'] = 'Avete superato il numero massimo di righe pari a {$rows}.';
$string['table_dlg:row_odd'] = 'Aggiorna righe dispari della tabella';
$string['table_dlg:row_row'] = 'Aggiorna riga corrente';
$string['table_dlg:rows'] = 'Righe';
$string['table_dlg:row_title'] = 'Proprietà riga';
$string['table_dlg:rowtype'] = 'Tipo riga';
$string['table_dlg:rtl'] = 'Da destra verso sinistra';
$string['table_dlg:rules'] = 'Regole';
$string['table_dlg:rules_above'] = 'sopra';
$string['table_dlg:rules_below'] = 'sotto';
$string['table_dlg:rules_border'] = 'bordo';
$string['table_dlg:rules_box'] = 'box';
$string['table_dlg:rules_hsides'] = 'hsides';
$string['table_dlg:rules_lhs'] = 'lhs';
$string['table_dlg:rules_rhs'] = 'rhs';
$string['table_dlg:rules_void'] = 'void';
$string['table_dlg:rules_vsides'] = 'vsides';
$string['table_dlg:scope'] = 'Scope';
$string['table_dlg:style'] = 'Stile';
$string['table_dlg:summary'] = 'Riassunto';
$string['table_dlg:tbody'] = 'Corpo tabella';
$string['table_dlg:td'] = 'Dati';
$string['table_dlg:tfoot'] = 'Pedice tabella';
$string['table_dlg:th'] = 'Intestazione';
$string['table_dlg:thead'] = 'Intestazione tabella';
$string['table_dlg:title'] = 'Inserisci/Modifica tabella';
$string['table_dlg:valign'] = 'Allineamento verticale';
$string['table_dlg:width'] = 'Larghezza';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'Unisci celle';
$string['table:paste_row_after_desc'] = 'Incolla riga dopo';
$string['table:paste_row_before_desc'] = 'Incolla riga prima';
$string['table:props_desc'] = 'Proprietà tabella';
$string['table:row'] = 'Riga';
$string['table:row_after_desc'] = 'Inserisci riga dopo';
$string['table:row_before_desc'] = 'Inserisci riga prima';
$string['table:row_desc'] = 'Proprietà riga';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'Separa celle';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['template:desc'] = 'Inserisci contenuto da modello predefinito';
$string['template_dlg:cdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:day_long'] = 'Domenica,Lunedì,Martedì,Mercoledì,Giovedì,Venerdì,Sabato,Domenica';
$string['template_dlg:day_short'] = 'Dom,Lun,Mar,Mer,Gio,Ven,Sab,Dom';
$string['template_dlg:desc'] = 'Inserisci contenuto da modello predefinito';
$string['template_dlg:desc_label'] = 'Descrizione';
$string['template_dlg:label'] = 'Modello';
$string['template_dlg:mdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:months_long'] = 'Gennaio,Febbraio,Marzo,Aprile,Maggio,Giugno,Luglio,Agosto,Settembre,Ottobre,Novembre,Dicembre';
$string['template_dlg:months_short'] = 'Gen,Feb,Mar,Apr,Mag,Giu,Lug,Ago,Set,Ott,Nov,Dic';
$string['template_dlg:preview'] = 'Anteprima';
$string['template_dlg:select'] = 'Seleziona un modello';
$string['template_dlg:title'] = 'Modelli';
$string['template_dlg:warning'] = 'Attenzione: aggiornare un modello con un altro differente può causare perdita di dati.';
$string['visualblocks:desc'] = 'Visualizza/nascondi elementi block';
$string['visualchars:desc'] = 'Attiva/disattiva caratteri di controllo visuale.';
$string['wordcount:words'] = 'Parole:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'Abbreviazione';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'Acronimo';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'Inserisci/modifica attributi';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'Citazione';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'Eliminazione';
$string['xhtmlxtras_dlg:attribs_title'] = 'Inserisci/modifica attributi';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Attributi';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Attributi';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Eventi';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'Tasto di accesso';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Citazione';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Classe';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Data/ora';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Lingua';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Direzione del testo';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Stile';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'Indice tabulazione';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Titolo';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'Da sinistra verso destra';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'Da destra verso sinistra';
$string['xhtmlxtras_dlg:events_tab'] = 'Eventi';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Elemento attributi';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Elemento eventi';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Impostazioni generali';
$string['xhtmlxtras_dlg:general_tab'] = 'Generale';
$string['xhtmlxtras_dlg:insert_date'] = 'Inserisci data/ora corrente';
$string['xhtmlxtras_dlg:option_ltr'] = 'Da sinistra verso destra';
$string['xhtmlxtras_dlg:option_rtl'] = 'da destra verso sinistra';
$string['xhtmlxtras_dlg:remove'] = 'Rimuovi';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Elemento abbreviazione';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Elemento acronimo';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Elemento citazione';
$string['xhtmlxtras_dlg:title_del_element'] = 'Elemento eliminazione';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Elemento inserimento';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'Inserimento';
