<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'sr_lt', branch 'MOODLE_37_STABLE'
 *
 * @package   lesson
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Kontrola pristupa';
$string['actionaftercorrectanswer'] = 'Akcija nakon tačnog odgovora';
$string['actionaftercorrectanswer_help'] = 'Nakon što se tačno odgovori na pitanje, postoje 3 opcije za prelazak na sledeću stranicu:

* Normalno - prati se putanja lekcije
* Prikaži neprikazanu stranicu - stranice se prikazuju nasumično, s tim da se nijedna stranica ne ponavlja tj. ne prikazuje se dvaput
* Prikaži stranicu sa neodgovorenim pitanjem - stranice se prikazuju nasumično, s tim da se ponavaljaju stranice sa pitanjima na koje polaznik još nije dao tačan odgovor';
$string['actions'] = 'Akcije';
$string['activitylink'] = 'Link do sledeće aktivnosti';
$string['activitylink_help'] = 'Ukoliko želite da na kraju lekcije prikažete link ka drugoj aktivnosti na kursu, izaberite aktivnost iz padajuće liste.';
$string['activitylinkname'] = 'Idi na {$a}';
$string['activityoverview'] = 'Približava se rok za završetak lekcija';
$string['addabranchtable'] = 'Dodaj stranicu sa sadržajem';
$string['addanendofbranch'] = 'Dodaj kraj grane';
$string['addanewpage'] = 'Dodaj novu stranicu';
$string['addaquestionpage'] = 'Dodaj stranicu sa pitanjem';
$string['addaquestionpagehere'] = 'Dodaj ovde stranicu sa pitanjem';
$string['addbranchtable'] = 'Dodaj stranicu sa sadržajem';
$string['addcluster'] = 'Dodaj grupu pitanja';
$string['addedabranchtable'] = 'Dodata je stranica sa sadržajem';
$string['addedanendofbranch'] = 'Dodat je kraj grane';
$string['addedaquestionpage'] = 'Dodata je stranica sa pitanjem';
$string['addedcluster'] = 'Dodata je grupa pitanja';
$string['addedendofcluster'] = 'Dodat je kraj grupe pitanja';
$string['addendofbranch'] = 'Dodaj kraj grane';
$string['addendofcluster'] = 'Dodaj kraj grupe pitanja';
$string['addessay'] = 'Kreiraj stranicu sa esejskim pitanjem';
$string['additionalattemptsremaining'] = 'Završeno. Možete ponovo da pokušate ovu lekciju.';
$string['addmatching'] = 'Kreiraj stranicu sa pitanjem sparivanja';
$string['addmultichoice'] = 'Kreiraj stranicu sa pitanjem višestrukog izbora';
$string['addnewgroupoverride'] = 'Dodaj izmenu za grupu';
$string['addnewuseroverride'] = 'Dodaj izmenu za korisnika';
$string['addnumerical'] = 'Kreiraj stranicu sa numeričkim pitanjem';
$string['addpage'] = 'Dodaj stranicu';
$string['addshortanswer'] = 'Kreiraj stranicu sa pitanjem kratak odgovor';
$string['addtruefalse'] = 'Kreiraj stranicu sa pitanjem tačno/netačno';
$string['allotheranswers'] = 'Svi drugi odgovori';
$string['allotheranswersjump'] = 'Prelaz svih drugih odgovora';
$string['allotheranswersscore'] = 'Rezultat svih drugih odgovora';
$string['allowofflineattempts'] = 'Dozvoli oflajn pristup lekciji pomoću mobilne aplikacija';
$string['allowofflineattempts_help'] = 'Ako je omogućena ova opcija, korisnik mobilne aplikacije može da preuzme lekciju i pristupi joj u oflajn režimu.
Svi mogući odgovori, kao i tačni odgovori biće, takođe preuzeti.
Napomena: nije moguće pristupiti lekciji u oflajn režimu ako ona ima vremensko ograničenje.';
$string['anchortitle'] = 'Početak glavnog sadržaja';
$string['and'] = 'i';
$string['answer'] = 'Odgovor';
$string['answeredcorrectly'] = 'je tačno odgovorilo';
$string['answersfornumerical'] = 'Odgovori za numerička pitanja treba da budu uklopljeni parovi minimalnih i maksimalnih vrednosti';
$string['arrangebuttonshorizontally'] = 'Da li da dugmad na stranici sa sadržajem budu postavljena horizontalno?';
$string['attempt'] = 'Pokušaj: {$a}';
$string['attemptheader'] = 'Pokušaj';
$string['attempts'] = 'Pokušaji';
$string['attemptsdeleted'] = 'Obrisani pokušaji';
$string['attemptsremaining'] = 'Broj pokušaja koji vam je preostao: {$a}';
$string['available'] = 'Datum od kog će biti dostupno:';
$string['averagescore'] = 'Prosečan broj bodova';
$string['averagetime'] = 'Prosečno vreme';
$string['branch'] = 'Sadržaj';
$string['branchtable'] = 'Sadržaj';
$string['cancel'] = 'Odustani';
$string['cannotfindanswer'] = 'Greška: nije pronađen odgovor';
$string['cannotfindattempt'] = 'Greška: nije pronađen pokušaj';
$string['cannotfindessay'] = 'Greška: nije pronađen esej';
$string['cannotfindfirstgrade'] = 'Greška: nije moguće pronaći ocene';
$string['cannotfindfirstpage'] = 'Nije moguće naći prvu stranu';
$string['cannotfindgrade'] = 'Nije moguće naći dosje sa ocenama';
$string['cannotfindnewestgrade'] = 'Greška: nije moguće naći najnoviju ocenu';
$string['cannotfindnextpage'] = 'Rezervna kopija lekcije: Sledeća strana nije pronađena!';
$string['cannotfindpagerecord'] = 'Dodaj kraj grane: zapis o strani nije pronađen';
$string['cannotfindpages'] = 'Nije moguće naći stranice lekcije';
$string['cannotfindpagetitle'] = 'Potvrda brisanja: nije pronađen naslov strane';
$string['cannotfindpreattempt'] = 'Zapis o prethodnom pokušaju nije pronađen!';
$string['cannotfindrecords'] = 'Greška: nisu pronađeni slogovi u tabeli lesson';
$string['cannotfindtimer'] = 'Greška: nije moguće pronaći zapise iz tabele lesson_timer';
$string['cannotfinduser'] = 'Greška: nisu pronađeni slogovi u tabeli lesson_timer';
$string['canretake'] = '{$a} može ponovo da pogleda lekciju';
$string['casesensitive'] = 'Koristi regularne izraze';
$string['casesensitive_help'] = 'Označite polje za potvrdu ako želite da koristite regularne izraze za analizu odgovora';
$string['checkbranchtable'] = 'Proveri stranicu sa sadržajem';
$string['checkedthisone'] = 'je izabralo ovaj odgovor.';
$string['checknavigation'] = 'Proveri navigaciju';
$string['checkquestion'] = 'Proveri pitanje';
$string['classstats'] = 'Statistički pregled rezultata svih učesnika kursa';
$string['clicktodownload'] = 'Kliknite na sledeći link da biste preuzeli datoteku.';
$string['closebeforeopen'] = 'Nije moguće ažurirati lekciju. Postavili ste da je datum zatvaranja lekcije pre datuma njenog otvaranja.';
$string['cluster'] = 'Grupa pitanja';
$string['clusterjump'] = 'Još neprikazano pitanje iz grupe pitanja';
$string['clustertitle'] = 'Grupa pitanja';
$string['collapsed'] = 'Skupljeno';
$string['comments'] = 'Vaši komentari';
$string['completed'] = 'Završeno';
$string['completederror'] = 'Završite lekciju';
$string['completethefollowingconditions'] = 'Morate da ispunite sledeće uslove u lekciji <b>{$a}</b> da biste mogli da nastavite.';
$string['completionendreached'] = 'Neophodno je stići do kraja';
$string['completionendreached_desc'] = 'Polaznik mora da stigne do stranice ”Kraj lekcije” da bi završio ovu aktivnost';
$string['completiontimespent'] = 'Polaznik mora na ovoj aktivnosti da provede najmanje';
$string['completiontimespentdesc'] = 'Polaznik mora na ovoj aktivnosti da provede najmanje {$a}';
$string['completiontimespentgroup'] = 'Zahtevaj vreme provedeno na lekciji';
$string['conditionsfordependency'] = 'Uslovi zavisnosti';
$string['configintro'] = 'Vrednosti ovde podešene definišu podrazumevane vrednosti koje se koriste u obrascu za podešavanja kada se kreira nova lekcija. Podešavanja označena kao napredna  prikazuju se samo kada se klikne na link \'Prikaži više...\'.';
$string['configmaxanswers'] = 'Podrazumevani maksimalan broj odgovora po strani';
$string['configmediaclose'] = 'Prikazuje dugme za zatvaranje na iskačućem prozoru koji sadrži link ka multimedijalnoj datoteci';
$string['configmediaheight'] = 'Određuje visinu iskačućeg prozora koji prikazuje link ka multimedijalnoj datoteci';
$string['configmediawidth'] = 'Određuje širinu iskačućeg prozora koji prikazuje link ka multimedijalnoj datoteci';
$string['configpassword_desc'] = 'Da li je lozinka neophodna da bi se pristupilo lekciji.';
$string['configslideshowbgcolor'] = 'Boja pozadine za slajd-šou ukoliko je uključen';
$string['configslideshowheight'] = 'Određuje visinu za slajd-šou ukoliko je omogućen';
$string['configslideshowwidth'] = 'Određuje širinu za slajd-šou ukoliko je omogućen';
$string['configtimelimit_desc'] = 'Ako je postavljeno vremensko ograničenje prikazuje se upozorenje na početku lekcije i tokom čitanja lekcije prisutna je štoperica koja prikazuje preostalo vreme. Ako je ovo podešavanje postavljeno na nulu nema vremenskog ograničenja.';
$string['confirmdelete'] = 'Obriši stranicu';
$string['confirmdeletionofthispage'] = 'Potvrdi brisanje ove stranice';
$string['congratulations'] = 'Čestitamo - stigli ste do kraja lekcije';
$string['continue'] = 'Nastavi';
$string['continuetoanswer'] = 'Nastavite da biste promenili odgovore.';
$string['continuetonextpage'] = 'Idite na sledeću stranicu';
$string['correctanswerjump'] = 'Tačan odgovor vodi do';
$string['correctanswerscore'] = 'Broj bodova koji se dobija za tačan odgovor';
$string['correctresponse'] = 'Povratne informacije za tačan odgovor';
$string['createaquestionpage'] = 'Kreiraj stranicu sa pitanjem';
$string['credit'] = 'Bodovi';
$string['customscoring'] = 'Prilagođeno bodovanje';
$string['customscoring_help'] = 'Ako je ova opcija omogućena. onda se svakom odgovoru može dodeliti numerička vrednost (pozitivna ili negativna)';
$string['deadline'] = 'Krajnji rok';
$string['defaultessayresponse'] = 'Predavač će oceniti vaš esej.';
$string['deleteallattempts'] = 'Obriši sve pokušaje prolaska kroz lekciju';
$string['deletedefaults'] = 'Obrisano {$a} x podrazumevano za lekciju';
$string['deletedpage'] = 'Stranica je obrisana';
$string['deletepagenamed'] = 'Obriši stranicu: {$a}';
$string['deleting'] = 'Brisanje';
$string['deletingpage'] = 'Brisanje stranice: {$a}';
$string['dependencyon'] = 'Zavisno od';
$string['dependencyon_help'] = 'Ovo podešavanje dopušta da pristup ovoj lekciji zavisi od rezultata polaznika u drugoj lekciji istog kursa. Može se koristiti bilo koja kombinacija sledećih uslova: utrošenog vremena (vreme koje je polaznik potrošio da bi uradio lekciju), završenosti (da li je polaznik završio navedenu lekciju) i dobijene ocene (da li je polaznik dobio ocenu veću od navedene).';
$string['description'] = 'Opis';
$string['detailedstats'] = 'Detaljna statistika';
$string['didnotanswerquestion'] = 'Niste odgovorili na ovo pitanje.';
$string['didnotreceivecredit'] = 'Niste dobili bodove';
$string['disabled'] = 'Onemogućeno';
$string['displaydefaultfeedback'] = 'Koristi podrazumevane povratne informacije';
$string['displaydefaultfeedback_help'] = 'Ako je ova opcija omogućena, onda će, u situaciji kada za neko pitanje ne postoji povratna informacija, biti prikazana podrazumevana povratna informacija: "Tačan odgovor" odnosno "Pogrešan odgovor"';
$string['displayinleftmenu'] = 'Prikaži u meniju?';
$string['displayleftif'] = 'Minimalna ocena za prikaz menija';
$string['displayleftif_help'] = 'Ovo podešavanje određuje da li polaznik mora da dobije određenu ocenu kako bi video meni lekcije. Ovo podešavanje tera polaznika da prođe kroz celu lekciju prilikom prvog pokušaja. Tek nakon što polaznik dobije potrebnu ocenu može da koristi meni sa leve strane za pregled lekcije.';
$string['displayleftmenu'] = 'Prikaži meni';
$string['displayleftmenu_help'] = 'Ako je ova opcija omogućena, biće prikazan meni koji korisnicima daje mogućnost da se kreću kroz stranice lekcije.';
$string['displayofgrade'] = 'Prikaz ocena (samo za polaznike)';
$string['displayreview'] = 'Obezbedite mogućnost za ponovni pokušaj';
$string['displayreview_help'] = 'Ako je ova opcija omogućena, u situaciji kada polaznik pogrešno odgovori na pitanje, biće mu ponuđeno da pokuša ponovo da odgovori (bez mogućnosti da dobije poen) ili da nastavi sa lekcijom. Ako student izabere da nastavi dalje sa sledećim pitanjem, onda će biti praćen izabrani (pogrešan) odgovor. Standardno, prelazi za pogrešne odgovore su podešeni na "ova stranica" i imaju rezultat 0, pa se preporučuje da prelaz za pogrešan odgovor podesite na neku drugu stranicu, kako biste izbegli zabunu kod svojih polaznika.';
$string['displayscorewithessays'] = '<p>Osvojili ste {$a->score} od maksimalnih {$a->tempmaxgrade} bodova za pitanja koja se automatski ocenjuju.</p>
<p>Vaš {$a->essayquestions} odgovor na pitanja  u formi eseja biće uskoro pregledan i ocenjen, a ocena će kasnije biti dodata<br />u vaš finalni rezultat.</p>
<p>Vaša trenutna ocena bez eseja je {$a->score} od {$a->grade}</p>';
$string['displayscorewithoutessays'] = 'Vaš rezultat je {$a->score} (od mogućih {$a->grade}).';
$string['duplicatepagenamed'] = 'Duplikat stranice: {$a}';
$string['edit'] = 'Uredi';
$string['editbranchtable'] = 'Uređivanje stranice sa sadržajem';
$string['editcluster'] = 'Uređivanje grupe pitanja';
$string['editendofbranch'] = 'Uređivanje stranice kraj grane';
$string['editendofcluster'] = 'Uređivanje stranice kraj grupe pitanja';
$string['editessay'] = 'Uređivanje stranice sa esejskim pitanjem';
$string['editingquestionpage'] = 'Uređivanje stranice sa pitanjem tipa: {$a}';
$string['editlessonsettings'] = 'Uredi podešavanja lekcije';
$string['editmatching'] = 'Uređivanje stranice sa pitanjem sparivanja';
$string['editmultichoice'] = 'Uređivanje stranice sa pitanjem višestrukog  izbora';
$string['editnumerical'] = 'Uređivanje stranice sa numeričkim pitanjem';
$string['editoverride'] = 'Uredi izmenu';
$string['editpage'] = 'Uredi sadržaj stranice';
$string['editpagecontent'] = 'Uredi sadržaj stranice';
$string['editquestion'] = 'Uređivanje stranice sa pitanjem';
$string['editshortanswer'] = 'Uređivanje stranice sa pitanjem kratak odgovor';
$string['edittruefalse'] = 'Uređivanje stranice sa pitanjem tačno/netačno';
$string['email'] = 'E-pošta';
$string['emailallgradedessays'] = 'Pošalji SVE ocenjene eseje';
$string['emailgradedessays'] = 'Pošalji ocenjene eseje e-poštom';
$string['emailsuccess'] = 'E-pošta je uspešno poslata';
$string['emptypassword'] = 'Polje za lozinku ne može biti prazno';
$string['enabled'] = 'Omogućeno';
$string['endofbranch'] = 'Kraj grane';
$string['endofcluster'] = 'Kraj grupe pitanja';
$string['endofclustertitle'] = 'Kraj grupe pitanja';
$string['endoflesson'] = 'Kraj lekcije';
$string['enteredthis'] = 'je odabralo/unelo ovaj odgovor';
$string['enterpassword'] = 'Molimo unesite lozinku:';
$string['eolstudentoutoftime'] = 'Upozorenje! Isteklo vam je vreme za ovu lekciju. Vaš poslednji odgovor možda nije uračunat ako je dat nakon što je vreme isteklo.';
$string['eolstudentoutoftimenoanswers'] = 'Niste odgovorili ni na jedno pitanje. Vaša ocena za ovu lekciju je 0.';
$string['essay'] = 'Esej';
$string['essayemailmessage2'] = '<p>Esej:<blockquote>{$a->question}</p><p>Vaš odgovor:<em>{$a->response}</em></p><p>Komentar ocenjivača:<em>{$a->comment}</em></p><p>Dobili ste {$a->earned} od maksimalnih {$a->outof} za ovaj esej.</p><p>Vaša ocena za lekciju {$a->lesson} je promenjena na {$a→newgrade}%.</p>';
$string['essayemailmessagesmall'] = '<p>Osvojili ste {$a->earned} od {$a->outof} poena za ovo esejsko pitanje.</p><p>Vaša ocena za lekciju {$a->lesson} je promenjena i sada je  {$a->newgrade}%.</p>';
$string['essayemailsubject'] = 'Ocena dostupna za pitanje lekcije';
$string['essaynotgradedyet'] = 'Ovaj esej još nije ocenjen';
$string['essayresponses'] = 'Esejski odgovori';
$string['essays'] = 'Eseji';
$string['essayscore'] = 'Rezultat eseja';
$string['eventcontentpageviewed'] = 'Stranica sa sadržajem prikazana';
$string['eventessayassessed'] = 'Esej ocenjen';
$string['eventessayattemptviewed'] = 'Esej prikazan';
$string['eventlessonended'] = 'Lekcija završena';
$string['eventlessonrestarted'] = 'Lekcija ponovo započeta';
$string['eventlessonresumed'] = 'Lekcija nastavljena';
$string['eventlessonstarted'] = 'Lekcija započeta';
$string['eventoverridecreated'] = 'Izmena podešavanja lekcije kreirana';
$string['eventoverridedeleted'] = 'Izmena podešavanja lekcije obrisana';
$string['eventoverrideupdated'] = 'Izmena podešavanja lekcije ažurirana';
$string['eventpagecreated'] = 'Stranica kreirana';
$string['eventpagedeleted'] = 'Stranica obrisana';
$string['eventpagemoved'] = 'Stranica premeštena';
$string['eventpageupdated'] = 'Stranica ažurirana';
$string['eventquestionanswered'] = 'Odgovoreno na pitanje';
$string['eventquestionviewed'] = 'Pitanje prikazano';
$string['false'] = 'Pogrešno';
$string['fileformat'] = 'Format datoteke';
$string['finalwrong'] = 'Ne baš.';
$string['finish'] = 'Završi';
$string['firstanswershould'] = 'Prvi odgovor bi trebalo do vodi na stranicu "Tačno"';
$string['firstwrong'] = 'Pogrešno ste odgovorili na pitanje. Da li želite da pokušate ponovo? (ako sada tačno odgovorite na pitanje, to se neće računati u vaš konačan rezultat.)';
$string['flowcontrol'] = 'Kontrola toka lekcije';
$string['fractionsaddwrong'] = 'Pozitivne ocene koje ste odabrali u zbiru ne daju 100%<br />Naime njihov zbir je {$a}%<br />Da li želite da se vratite nazad i ispravite pitanje?';
$string['fractionsnomax'] = 'Jedan od odgovora treba da nosi 100% ocene, tako da je <br />moguće dobiti maksimalnu ocenu za ovo pitanje.<br />Da li želite da se vratite nazad i ispravite ovo pitanje?';
$string['full'] = 'Prošireno';
$string['general'] = 'Opšta podešavanja';
$string['gotoendoflesson'] = 'Idi na kraj lekcije';
$string['grade'] = 'Ocena';
$string['gradebetterthan'] = 'Ocena viša od (%)';
$string['gradebetterthanerror'] = 'Osvojite ocenu veću od {$a} procenata';
$string['graded'] = 'Ocenjeno';
$string['gradeessay'] = 'Oceni odgovore na esejski tip pitanja({$a->notgradedcount} još nije ocenjeno, a {$a->notsentcount} nije poslato)';
$string['gradeis'] = 'Ocena je {$a}';
$string['gradeoptions'] = 'Opcije za ocenjivanje';
$string['groupoverrides'] = 'Izmene za grupe';
$string['groupoverridesdeleted'] = 'Izmene za grupe obrisane';
$string['groupsnone'] = 'Ne postoje grupe kojima možete pristupiti.';
$string['handlingofretakes'] = 'Tretman ponovnih pokušaja';
$string['handlingofretakes_help'] = 'Ako su ponovni pokušaji dozvoljeni, ovo podešavanje određuje da li je ocena za lekciju jednaka prosečnoj oceni svih pokušaja ili najvećoj oceni.';
$string['havenotgradedyet'] = 'Još nije ocenjeno.';
$string['here'] = 'ovde';
$string['highscore'] = 'Najbolji rezultat';
$string['hightime'] = 'Najduže vreme';
$string['importcount'] = 'Uvozi se {$a} pitanja';
$string['importquestions'] = 'Uvoz pitanja';
$string['importquestions_help'] = 'Ovo svojstvo omogućava da pitanja u različitim formatima, budu uvezena putem tekstualne datoteke.';
$string['inactiveoverridehelp'] = '* Polaznik nema ispravnu grupu ili ulogu da bi mogao da vidi/pokuša lekciju';
$string['indicator:cognitivedepth'] = 'Lekcija - kognitivni aspekt';
$string['indicator:cognitivedepth_help'] = 'Ovaj indikator se zasniva na kognitivnoj dubini koju je polaznik postigao u okviru aktivnosti \'Lekcija\'.';
$string['indicator:socialbreadth'] = 'Lekcija - socijalni aspekt';
$string['indicator:socialbreadth_help'] = 'Ovaj indikator se zasniva na obimu socijalnih interakcija koji je polaznik postigao u okviru aktivnosti \'Lekcija\'.';
$string['insertedpage'] = 'Stranica je umetnuta';
$string['invalidfile'] = 'Neispravna datoteka';
$string['invalidid'] = 'Nije prosleđen ID modula ili lekcije';
$string['invalidlessonid'] = 'ID lekcije nije bio tačan';
$string['invalidoverrideid'] = 'Neispravna ID oznaka izmene';
$string['invalidpageid'] = 'Neispravan ID stranice';
$string['jump'] = 'Prelaz';
$string['jumps'] = 'Prelazi';
$string['jumps_help'] = 'Svaki odgovor (za stranicu sa pitanjem) ili opis (za stranicu sa sadržajem) ima odgovarajući prelaz. Prelaz može biti relativan, kao na primer "tekuća stranica" ili "sledeća stranica", ili apsolutan tj. prelaz na bilo koju stranicu u lekciji.';
$string['jumpsto'] = 'Prelazi na <em>{$a}</em>';
$string['leftduringtimed'] = 'Napustili ste lekciju koja je vremenski ograničena.<br />Pritisnite taster za nastavak da biste pogledali lekciju od početka.';
$string['leftduringtimednoretake'] = 'Napustili ste lekciju koja je vremenski ograničena i nije Vam <br /> dozvoljeno da nastavite ili počnete lekciju iz početka.';
$string['leftduringtimedsession'] = 'Izašli ste tokom lekcije koja ima vremensko ograničenje.';
$string['lesson:addinstance'] = 'Dodaj novu lekciju';
$string['lessonclosed'] = 'Ova lekcija je zatvorena dana {$a}.';
$string['lessoncloses'] = 'Lekcija se zatvara';
$string['lessoncloseson'] = 'Vreme zatvaranja lekcije: {$a}';
$string['lesson:edit'] = 'Uredi lekciju';
$string['lessoneventcloses'] = '{$a} se zatvara';
$string['lessoneventopens'] = '{$a} se otvara';
$string['lessonformating'] = 'Formatiranje lekcije';
$string['lesson:grade'] = 'Oceni esejska pitanja u lekciji';
$string['lesson:manage'] = 'Upravljanje lekcijom';
$string['lesson:manageoverrides'] = 'Upravljanje izmenama podešavanja lekcije';
$string['lessonmenu'] = 'Meni lekcije';
$string['lessonname'] = 'Lekcija: {$a}';
$string['lessonnotready'] = 'Ova lekcija još nije spremna za korišćenje. Molimo kontaktirajte svog {$a}.';
$string['lessonnotready2'] = 'Ova lekcija još nije spremna za korišćenje';
$string['lessonopen'] = 'Ova lekcija će biti dostupna od {$a}.';
$string['lessonopens'] = 'Lekcija se otvara';
$string['lessonpagelinkingbroken'] = 'Nije pronađena prva stranica. Mora da je došlo do prekida linkova između stranica lekcije. Molimo kontaktirajte administratora.';
$string['lessonstats'] = 'Statistika lekcije';
$string['lesson:view'] = 'Pregledaj aktivnost lekcije';
$string['lesson:viewreports'] = 'Prikaži izveštaje o lekciji';
$string['linkedmedia'] = 'Povezani mediji';
$string['loginfail'] = 'Pogrešna prijava, molimo pokušajte ponovo...';
$string['lowscore'] = 'Naslabiji rezultat';
$string['lowtime'] = 'Najkraće vreme';
$string['manualgrading'] = 'Oceni eseje';
$string['matchesanswer'] = 'Poklapa se sa odgovorom';
$string['matching'] = 'Sparivanje';
$string['matchingpair'] = 'Sparivanje para {$a}';
$string['maxgrade'] = 'Maksimalna ocena';
$string['maxgrade_help'] = 'Ovo podešavanje određuje najveću ocenu za lekciju. Ukoliko je vrednost podešena na 0 lekcija se neće pojaviti na stranici sa ocenama.';
$string['maximumnumberofanswersbranches'] = 'Maksimalan broj odgovora';
$string['maximumnumberofanswersbranches_help'] = 'Ova vrednost određuje maksimalni broj odgovora koji se mogu koristiti u lekciji. Ako se koriste samo TAČNO/NETAČNO pitanja tada je razumno postaviti ovu vrednost na 2. Podešavanje se može promeniti bilo kada, pošto utiče samo na način prikaza podataka nastavniku, ne i na same podatke.';
$string['maximumnumberofattempts'] = 'Maksimalan broj pokušaja';
$string['maximumnumberofattempts_help'] = 'Ovo podešavanje određuje maksimalan broj dozvoljenih pokušaja za svako pitanje. Ukoliko se netačni odgovori ponavljaju, kada se dostigne maksimalan broj pokušaja, biće prikazana sledeća stranica lekcije.';
$string['maximumnumberofattemptsreached'] = 'Dostignut je maksimalan broj pokušaja - prelazi se na sledeću stranicu';
$string['mediaclose'] = 'Прикажи дугме за затварање';
$string['mediafile'] = 'Povezana multimedija';
$string['mediafile_help'] = 'Multimedijalna datoteka se može postaviti radi korišćenja u okviru lekcije. Link "Kliknite ovde za prikaz" će se tada prikazivati u bloku pod naslovom "Povezana multimedija" na svakoj stranici lekcije.';
$string['mediafilepopup'] = 'Kliknite ovde za prikaz';
$string['mediaheight'] = 'Visina iskačućeg prozora';
$string['mediawidth'] = 'Širina iskačućeg prozora';
$string['messageprovider:graded_essay'] = 'Obaveštenje o ocenjenom eseju';
$string['minimumnumberofquestions'] = 'Minimalan broj pitanja';
$string['minimumnumberofquestions_help'] = 'Ova podešavanje određuje najmanji broj pitanja koji će se koristiti za izračunavanje ocene za aktivnost.';
$string['missingname'] = 'Molimo unesite nadimak';
$string['modattempts'] = 'Dozvolite polaznicima pregled';
$string['modattempts_help'] = 'Ako je ova opcija omogućena, polaznici će moći ponovo da pogledaju lekciju od početka.';
$string['modattemptsnoteacher'] = 'Polaznički pregled funkcioniše samo za polaznike';
$string['modulename'] = 'Lekcija';
$string['modulename_help'] = 'Modul \'Lekcija\' omogućava predavaču da  prezentuje sadržaj i/ili praktične aktivnosti na interesantan i fleksibilan način. Predavač može da koristi lekciju kako bi kreirao linearni niz stranica sa sadržajem ili instrukcije koje nude različite putanje ili opcije za korisnika. U oba slučaj predavači mogu da povećaju angažman polaznika i da obezbede razumevanje gradiva, tako što će na kraju stranice dodati različite tipove pitanja, uključujući višestruki izbor, sparivanje, kratak odgovor i dr. Zavisno od izabranog odgovora, kao i od toga kako je predavač organizovao lekciju, polaznici mogu da napreduju na sledeću stranicu, budu vraćeni na prethodnu ili preusmereni na neku drugu stranicu lekcije.

Lekcije mogu da se ocenjuju, a ocene upisuju u knjigu ocena.

Lekcija može da se koristi:

* za samostalno učenje novih sadržaja
* za scenarija ili simulacije/vežbe donošenje odluka
* za ispravku naučenog gradiva, sa različitim setovima pitanja u zavisnosti od odgovora datih na početna pitanja';
$string['modulenameplural'] = 'Lekcije';
$string['move'] = 'Premesti stranicu';
$string['movedpage'] = 'Stranica je premeštena';
$string['movepagehere'] = 'Ovde premesti stranicu';
$string['movepagenamed'] = 'Premesti stranicu: {$a}';
$string['moving'] = 'Premeštanje stranice: {$a}';
$string['multianswer'] = 'Višestruki odgovor';
$string['multianswer_help'] = 'Označite ukoliko postoji više tačnih osgovora.';
$string['multichoice'] = 'Višestruki izbor';
$string['multipleanswer'] = 'Višestruki odgovor';
$string['nameapproved'] = 'Naziv je odobren';
$string['namereject'] = 'Nažalost, Vaše ime je odbijeno.<br />Molimo pokušajte sa drugim imenom.';
$string['new'] = 'novo';
$string['nextpage'] = 'Sledeća stranica';
$string['noanswer'] = 'Na jedno ili više pitanja nije dat odgovor. Molimo vratite se nazad i dajte svoj odgovor.';
$string['noattemptrecordsfound'] = 'Nema zabeleženih pokušaja: nije data nijedna ocena';
$string['nobranchtablefound'] = 'Nije pronađena nijedna stranica sa sadržajem';
$string['noclose'] = 'Nema datuma zatvaranja lekcije';
$string['nocommentyet'] = 'Još nema komentara.';
$string['nocoursemods'] = 'Nije pronađena nijedna aktivnost';
$string['nocredit'] = 'Bez bodova';
$string['nodeadline'] = 'Bez roka';
$string['noessayquestionsfound'] = 'U ovoj lekciji nisu pronađena pitanja koja zahtevaju odgovor u formi eseja.';
$string['nohighscores'] = 'Nema najboljih rezultata';
$string['nolessonattempts'] = 'Nije bilo pokušaja da se prođe kroz ovu lekciju.';
$string['nolessonattemptsgroup'] = 'Nije bilo pokušaja da se prođe kroz ovu lekciju od strane članova grupe  {$a}.';
$string['none'] = '';
$string['nooneansweredcorrectly'] = 'Niko nije tačno odgovorio.';
$string['nooneansweredthisquestion'] = 'Niko nije odgovorio na ovo pitanje.';
$string['noonecheckedthis'] = 'Niko nije izabrao ovaj odgovor.';
$string['nooneenteredthis'] = 'Niko nije ovo pokušao.';
$string['noonehasanswered'] = 'Niko još nije odgovorio na esejsko pitanje.';
$string['noonehasansweredgroup'] = 'Niko u grupi {$a} još nije odgovorio na esejsko pitanje';
$string['noopen'] = 'Nema datuma otvaranja lekcije';
$string['nooverridedata'] = 'Morate da izmenite barem jedno od podešavanja lekcija.';
$string['noretake'] = 'Nije Vam dozvoljeno da ponovo pokušate ovu lekciju.';
$string['normal'] = 'Normalno - pratite putanju lekcije';
$string['notcompleted'] = 'Nije završeno';
$string['notdefined'] = 'Nije definisano';
$string['notenoughsubquestions'] = 'Nije definisano dovoljno potpitanja!<br />Da li želite da se vratite nazad i ispravite pitanje?';
$string['notenoughtimespent'] = 'Završili ste ovu lekciju za {$a->timespent}, što je manje od {$a->timerequired}, vremena koje je potrebno da se ova lekcija prouči na adekvatan način. Moraćete ponovo da uradite lekciju.';
$string['notgraded'] = 'Nije ocenjeno';
$string['notitle'] = 'Nema naslova';
$string['notyetcompleted'] = 'Lekcija je započeta ali nije završena';
$string['numberofcorrectanswers'] = 'Broj tačnih odgovora: {$a}';
$string['numberofcorrectanswersheader'] = 'Broj tačnih odgovora';
$string['numberofcorrectmatches'] = 'Broj tačnih podudaranja: {$a}';
$string['numberofpagestoshow'] = 'Broj stranica koje treba prikazati';
$string['numberofpagestoshow_help'] = 'Ovo podešavanje određuje broj stranica prikazanih u lekciji. Podešavanje je primenjivo samo za lekcije kod kojih se stranice prikazuju nasumičnim redosledom (kada je podešavanje "Akcija nakon tačnog odgovora" postavljeno na "Prikaži neprikazanu stranicu" ili "Prikaži stranicu sa neodgovorenim pitanjem"). Ako je vrednost podešena na 0, onda se prikazuju sve stranice.';
$string['numberofpagesviewed'] = 'Broj pregledanih stranica: {$a}';
$string['numberofpagesviewedheader'] = 'Broj pitanja na koje je dat odgovor';
$string['numberofpagesviewednotice'] = 'Broj pitanja na koje je dat odgovor: {$a->nquestions} (Trebalo bi ih biti bar {$a->minquestions})';
$string['numerical'] = 'Brojčani';
$string['offlinedatamessage'] = 'Ovoj lekciji ste pristupili koristeći mobilni uređaj. Podaci na ovom sajtu poslednji put su sačuvani pre {$a}. Proverite da nemate neki nesačuvani pokušaj pristupa lekciji.';
$string['ongoing'] = 'Prikaz trenutnog rezultata';
$string['ongoingcustom'] = 'Do sada ste osvojili {$a->score} od maksimalno {$a->currenthigh} bodova.';
$string['ongoing_help'] = 'Ako je ova opcija omogućena, na svakoj stranica će biti prikazan trenutni broj poena od ukupnog broja koje je polaznik do tada mogao da postigne.';
$string['ongoingnormal'] = 'Tačno ste odgovorili na {$a->correct} od {$a->viewed} pitanja koja ste videli.';
$string['onpostperpage'] = 'Samo jedna poruka po oceni';
$string['openafterclose'] = 'Naveli ste datum otvaranja nakon datuma zatvaranja';
$string['options'] = 'Opcije';
$string['or'] = 'ILI';
$string['ordered'] = 'Poređano';
$string['other'] = 'Ostalo';
$string['outof'] = 'Od {$a}';
$string['override'] = 'Izmena';
$string['overridedeletegroupsure'] = 'Da li ste sigurni da želite da obrišete izmenu podešavanja za grupu {$a}?';
$string['overridedeleteusersure'] = 'Da li ste sigurni da želite da obrišete izmenu podešavanja za korisnika {$a}?';
$string['overridegroup'] = 'Izmeni podešavanja za grupu';
$string['overridegroupeventname'] = '{$a->lesson} - {$a→group}';
$string['overrides'] = 'Izmene';
$string['overrideuser'] = 'Izmeni podešavanja za korisnika';
$string['overrideusereventname'] = '{$a->lesson} - Izmena';
$string['overview'] = 'Pregled';
$string['overview_help'] = 'Lekcija se sastoji od određenog broja stranica i, opciono, stranica sa sadržajem (tabelom grananja). Stranica sadrži  proizvoljnu količinu teksta i odgovarajućih ilustracija, i obično se završava pitanjem. Uz svaki odgovor na pitanje vezan je tzv. prelaz. Prelazi mogu biti relativni, kao na primer “tekuća stranica” ili “sledeća stranica”, ili apsolutni kada se tačno navodi neka od stranica unutar lekciji. Stranica sa sadržajem (tabela grananja) je stranica koja sadrži niz linkova ka drugim stranicama lekcije, kao na primer "Tabela sadržaja".';
$string['page'] = 'Stranica: {$a}';
$string['pageanswers'] = 'Stranica sa pitanjima';
$string['pagecontents'] = 'Sadržaj stranice';
$string['page-mod-lesson-edit'] = 'Stranica za uređivanje lekcije';
$string['page-mod-lesson-view'] = 'Prikaži ili pregledaj stranicu lekcije';
$string['page-mod-lesson-x'] = 'Bilo koja stranica lekcije';
$string['pageresponses'] = 'Stranica sa odgovorima';
$string['pages'] = 'Stranice';
$string['pagetitle'] = 'Naslov stranice';
$string['password'] = 'Lozinka';
$string['passwordprotectedlesson'] = '{$a} je lekcija zaštićena lozinkom.';
$string['pleasecheckoneanswer'] = 'Izaberite jedan odgovor';
$string['pleasecheckoneormoreanswers'] = 'Izaberite jedan ili više odgovora';
$string['pleaseenteryouranswerinthebox'] = 'Unesite svoj odgovor u polje za unos';
$string['pleasematchtheabovepairs'] = 'Spojite parove';
$string['pluginadministration'] = 'Administracija lekcije';
$string['pluginname'] = 'Lekcija';
$string['pointsearned'] = 'Osvojeni poeni';
$string['postprocesserror'] = 'Došlo je do greške tokom naknadne obrade!';
$string['postsuccess'] = 'Uspešno poslato';
$string['practice'] = 'Lekcija za vežbanje';
$string['practice_help'] = 'Lekcija za vežbu se ne prikazuje u dnevniku ocena.';
$string['preprocesserror'] = 'Došlo je do greške u toku prethodne obrade!';
$string['prerequisiteisobsolete'] = 'Opcija za lekciju preduslov je uklonjena. Molimo vas da umesto toga koristite opcije za ograničenje pristupa.';
$string['prerequisitelesson'] = 'Lekcija preduslov';
$string['preview'] = 'Pregled';
$string['previewlesson'] = 'Pregled {$a}';
$string['previewpagenamed'] = 'Pogledaj stranicu: {$a}';
$string['previouspage'] = 'Prethodna stranica';
$string['privacy:metadata:attempts'] = 'Zapis o pokušaju pregleda stranice';
$string['privacy:metadata:attempts:answerid'] = 'Identifikator odgovora';
$string['privacy:metadata:attempts:correct'] = 'Da li je pokušaj bio ispravan';
$string['privacy:metadata:attempts:pageid'] = 'Identifikator stranice';
$string['privacy:metadata:attempts:retry'] = 'Broj pokušaja';
$string['privacy:metadata:attempts:timeseen'] = 'Vreme kada je napravljen pokušaj';
$string['privacy:metadata:attempts:useranswer'] = 'Detalji o korisnikovom odgovoru';
$string['privacy:metadata:attempts:userid'] = 'Identifikator korisnika';
$string['privacy:metadata:branch'] = 'Zapis o pregledanim stranicama';
$string['privacy:metadata:branch:flag'] = 'Da li je sledeća stranica nasumično sračunata';
$string['privacy:metadata:branch:nextpageid'] = 'Identifikator sledeće stranice';
$string['privacy:metadata:branch:pageid'] = 'Identifikator stranice';
$string['privacy:metadata:branch:retry'] = 'Broj pokušaja';
$string['privacy:metadata:branch:timeseen'] = 'Vreme kada je stranica pregledana';
$string['privacy:metadata:branch:userid'] = 'Identifikator korisnika';
$string['privacy:metadata:grades'] = 'Zapis o ocenama za svaku lekciju';
$string['privacy:metadata:grades:completed'] = 'Datum kada je ocena data';
$string['privacy:metadata:grades:grade'] = 'Data ocena';
$string['privacy:metadata:grades:userid'] = 'ID oznaka korisnika';
$string['privacy:metadata:overrides'] = 'Zapis izmena po lekciji';
$string['privacy:metadata:overrides:available'] = 'Vreme kada se lekcija može pokušati';
$string['privacy:metadata:overrides:deadline'] = 'Rok za završetak lekcije.';
$string['privacy:metadata:overrides:maxattempts'] = 'Maksimalan broj pokušaja';
$string['privacy:metadata:overrides:password'] = 'Lozinka za pristup lekciji';
$string['privacy:metadata:overrides:retake'] = 'Da li je dozvoljeno ponovo pokušati lekciju';
$string['privacy:metadata:overrides:review'] = 'Da li je dozvoljeno ponovo pokušati odgovoriti na pitanje';
$string['privacy:metadata:overrides:timelimit'] = 'Vremensko ograničenje za završetak lekcije, u sekundama.';
$string['privacy:metadata:overrides:userid'] = 'ID oznaka korisnika';
$string['privacy:metadata:timer'] = 'Zapis o pokušaju prolaska kroz lekciju';
$string['privacy:metadata:timer:completed'] = 'Da li je pokušaj završen';
$string['privacy:metadata:timer:lessontime'] = 'Poslednji trenutak kada smo zabeležili aktivnost';
$string['privacy:metadata:timer:starttime'] = 'Datum početka pokušaja';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'Poslednji trenutak kada smo zabeležili aktivnost iz mobilne aplikacije';
$string['privacy:metadata:timer:userid'] = 'ID oznaka korisnika';
$string['privacy:metadata:userpref:lessonview'] = 'Željeni režim prikaza prilikom uređivanja lekcija';
$string['privacy:path:essayanswers'] = 'Esejski odgovori';
$string['privacy:path:essayresponses'] = 'Esejski odgovori';
$string['privacy:path:pages'] = 'Stranice';
$string['processerror'] = 'Došlo je do greške u toku obrade!';
$string['progressbar'] = 'Traka napredovanja kroz lekciju';
$string['progressbar_help'] = 'Ako je ova opcija omogućena, na dnu stranice biće prikazana traka koja prikazuje približan procenat završenosti lekcije (napredovanje polaznika kroz lekciju).';
$string['progressbarteacherwarning'] = 'Traka napredovanja kroz lekciju se ne prikazuje za {$a}';
$string['progressbarteacherwarning2'] = 'Nećete videti traku napredovanja zato što možete da uređujete ovu lekciju';
$string['progresscompleted'] = 'Završili ste {$a}% lekcije';
$string['qtype'] = 'Vrsta stranice';
$string['question'] = 'Pitanje';
$string['questionoption'] = 'Pitanje';
$string['questiontype'] = 'Tip pitanja';
$string['randombranch'] = 'Nasumično odabrana stranica sa sadržajem';
$string['randompageinbranch'] = 'Nasumično odabrano pitanje unutar stranice sa sadržajem';
$string['rank'] = 'Rang';
$string['rawgrade'] = 'Neobrađena ocena';
$string['receivedcredit'] = 'Dobijeni bodovi';
$string['redisplaypage'] = 'Osvežavanje prikaza stranice';
$string['removeallgroupoverrides'] = 'Obriši sve izmene za grupe';
$string['removealluseroverrides'] = 'Obriši sve izmene za korisnike';
$string['report'] = 'Izveštaj';
$string['reports'] = 'Izveštaji';
$string['response'] = 'Povratne informacije';
$string['retakesallowed'] = 'Ponovni pregled lekcije je dozvoljen';
$string['retakesallowed_help'] = 'Ako je ova opcija omogućena, polaznik može više puta da pogleda lekciju.';
$string['returnto'] = 'Vrati se na {$a}';
$string['returntocourse'] = 'Vrati se na kurs';
$string['reverttodefaults'] = 'Vrati lekciju na standardna podešavanja';
$string['review'] = 'Pregled';
$string['reviewlesson'] = 'Pregled lekcije';
$string['reviewquestionback'] = 'Da, voleo/la bih da ponovo pokušam';
$string['reviewquestioncontinue'] = 'Ne, želim da pređem na sledeće pitanje';
$string['sanitycheckfailed'] = 'Provera nije uspela. Pokušaj je obrisan.';
$string['save'] = 'Sačuvaj';
$string['savechanges'] = 'Sačuvaj promene';
$string['savechangesandeol'] = 'Sačuvaj sve promene i idi na kraj lekcije.';
$string['saveoverrideandstay'] = 'Sačuvaj i unesi drugu izmenu';
$string['savepage'] = 'Sačuvaj stranicu';
$string['score'] = 'Rezultat';
$string['score_help'] = 'Rezultat se koristi samo kada je prilagođeno bodovanje omogućeno. Svakom odgovoru zatim može biti data numerička vrednost (pozitivna ili negativna).';
$string['scores'] = 'Rezultati';
$string['search:activity'] = 'Lekcija - informacije o aktivnosti';
$string['secondpluswrong'] = 'Nije baš. Da li želite da pokušate ponovo?';
$string['selectaqtype'] = 'Odaberite tip pitanja';
$string['sent'] = 'Poslato';
$string['shortanswer'] = 'Kratak odgovor';
$string['showanunansweredpage'] = 'Prikaži stranicu sa neodgovorenim pitanjem';
$string['showanunseenpage'] = 'Prikaži neprikazanu stranicu';
$string['singleanswer'] = 'Jedan odgovor';
$string['skip'] = 'Preskoči navigaciju';
$string['slideshow'] = 'Slajd-šou';
$string['slideshowbgcolor'] = 'Boja pozadine za slajd-šou';
$string['slideshowheight'] = 'Slajd-šou - visina';
$string['slideshow_help'] = 'Ako je ovo podešavanje omogućeno, lekcija se prikazuje kao slajd-šou, sa fiksnom širinom i visinom.';
$string['slideshowwidth'] = 'Slajd-šou - širina';
$string['startlesson'] = 'Počnite lekciju';
$string['studentattemptlesson'] = '{$a->attempt} pokušaj korisnika {$a->lastname}, {$a->firstname}';
$string['studentname'] = '{$a} Ime';
$string['studentoneminwarning'] = 'Upozorenje: imate manje od jednog minuta da završite lekciju.';
$string['studentoutoftimeforreview'] = 'Pažnja: vaše vreme za pregled ove lekcije je isteklo';
$string['studentresponse'] = 'Odgovor polaznika {$a}';
$string['submit'] = 'Pošalji';
$string['submitname'] = 'Pošalji ime';
$string['teacherjumpwarning'] = 'U ovoj lekciji se koriste {$a->cluster} ili {$a->unseen} prelaz između stranica. Prelaz "Sledeća stranica" će se koristiti umesto njih tokom ovog prikaza. Za testiranje ovih prelaza prijavite se na sistem u ulozi polaznika.';
$string['teacherongoingwarning'] = 'Trenutni rezultat tokom pregleda lekcije se prikazuje samo polaznicima. Prijavite se na sistem kao polaznik kako biste testirali ovu mogućnost.';
$string['teachertimerwarning'] = 'Merač vremena mogu da vide samo polaznici. Kako biste testirali merač vremena prijavite se na sistem u ulozi polaznika.';
$string['thatsthecorrectanswer'] = 'Tačan odgovor';
$string['thatsthewronganswer'] = 'Pogrešan odgovor';
$string['thefollowingpagesjumptothispage'] = 'Sledeće stranice vode do ove stranice';
$string['thispage'] = 'Ova stranica';
$string['timeisup'] = 'Време је истекло';
$string['timelimit'] = 'Vremensko ograničenje';
$string['timelimit_help'] = 'Ako je ova opcija omogućena, na početku lekcije biće prikazano upozorenje o vremenskom ograničenju i tajmer. Odgovori dati nakon isteka vremena se neće ocenjivati.';
$string['timelimitwarning'] = 'Imate na raspolaganju {$a} za završetak lekcije';
$string['timeremaining'] = 'Preostalo vreme';
$string['timespenterror'] = 'Provedite bar {$a} minuta pregledajući sadržaj lekcije';
$string['timespentminutes'] = 'Potrošeno vreme (u minutima)';
$string['timetaken'] = 'Potrošeno vreme';
$string['totalpagesviewedheader'] = 'Broj pregledanih stranica';
$string['true'] = 'Tačno';
$string['truefalse'] = 'Tačno/netačno';
$string['unabledtosavefile'] = 'Nije moguće sačuvati datoteku koji ste poslali.';
$string['unknownqtypesnotimported'] = 'Broj pitanja, sa nepodržanim tipom pitanja, koja nisu uvezena: {$a}';
$string['unseenpageinbranch'] = 'Još neprikazano pitanje unutar stranice sa sadržajem';
$string['unsupportedqtype'] = 'Tip pitanja koji nije podržan {$a}!';
$string['updatedpage'] = 'Stranica je ažurirana';
$string['updatefailed'] = 'Ažuriranje nije uspelo';
$string['updatepagenamed'] = 'Ažuriraj stranicu: {$a}';
$string['usemaximum'] = 'Koristi maksimalnu vrednost';
$string['usemean'] = 'Koristi prosečnu vrednost';
$string['usepassword'] = 'Lekcija zaštićena lozinkom';
$string['usepassword_help'] = 'Ukoliko je uključeno, za pristup lekciji neophodna je lozinka';
$string['useroverrides'] = 'Izmene za korisnike';
$string['useroverridesdeleted'] = 'Izmene za korisnike obrisane';
$string['usersnone'] = 'Nijedan polaznik nema pristup ovoj lekciji';
$string['viewessayanswers'] = 'Pogledaj esejske odgovore';
$string['viewgrades'] = 'Prikaz ocena';
$string['viewreports'] = 'Prikaz {$a->attempts} kompletnih pokušaja polaznika {$a->student}';
$string['viewreports2'] = 'Pogledaj {$a} završenih pokušaja';
$string['warning'] = 'Upozorenje';
$string['welldone'] = 'Bravo!';
$string['whatdofirst'] = 'Šta želite prvo da uradite?';
$string['wronganswerjump'] = 'Stranica koja će se prikazati nakon pogrešnog odgovora';
$string['wronganswerscore'] = 'Broj bodova koji nosi pogrešan odgovor';
$string['wrongresponse'] = 'Povratne informacije za pogrešan odgovor';
$string['xattempts'] = '{$a} pokušaj(a)';
$string['youhaveseen'] = 'Već ste videli više od jedne stranice ove lekcije.<br /> Želite li početi od poslednje stranice koju ste videli?';
$string['youranswer'] = 'Vaš odgovor';
$string['yourcurrentgradeis'] = 'Vaša trenutna ocena je {$a}';
$string['yourcurrentgradeisoutof'] = 'Vaša trenutna ocena je {$a->grade} od mogućih {$a->total}';
$string['youshouldview'] = 'Trebalo bi da odgovorite na barem: {$a}';
