<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodleorg', language 'nl', branch 'MOODLE_26_STABLE'
 *
 * @package   local_moodleorg
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutstatistics'] = 'Moodle kan gratis gedownload worden en registratie is vrijwillig. We hebben daarom niet alle informatie van iedereen die Moodle gebruikt. Met wat we wel weten genereren we automatisch een aantal interessante statistieken en cijfers voor onze statistiekenpagina.';
$string['aboutstatisticsheading'] = 'Moodle in cijfers';
$string['aboutstatisticstitle'] = 'Moodle.org: Moodle statistieken';
$string['activeusers24hours'] = 'Geregistreerde gebruikers in de laatste 24 uur:';
$string['activeuserspastmonth'] = 'Geregistreerde bezoekers in de laatste maand:';
$string['browsegittitle'] = 'Blader in onze broncode';
$string['cachedef_frontpagecolumn'] = 'Kollomen startpagina';
$string['cachedef_usefulposts'] = 'Nuttige forumberichten';
$string['communities'] = 'Gemeenschappen';
$string['communitiesmy'] = 'Mijn gemeenschappen';
$string['community'] = 'Gemeenschap';
$string['communityadministration'] = 'Community-beheer';
$string['communitycurrent'] = 'Huidige gemeenschap';
$string['communityenrolme'] = 'Wordt lid van deze gemeenschap';
$string['communityenrolmentoptions'] = 'Lid worden van een gemeenschap';
$string['communityintro'] = 'Moodle heeft een grote en diverse gebruikersgemeenschap met meer dan <a href="http://moodle.org/userpics">{$a->usercount} geregistreerde gebruikers</a>  alleen al op deze site, die meer dan <a href="http://download.moodle.org/langpack/">{$a->langcount} talen spreke languages</a> en uit <a href="http://moodle.org/sites">{$a->countrycount} landen </a>komen  (we hebben <a href="http://moodle.org/stats">meer statistieken</a>).';
$string['communityjoinbyyourself'] = 'Voeg jezelf toe';
$string['communityjoinbyyourselfas'] = 'Voeg jezelf toe als {$a->rolename}';
$string['communitynoguestaccess'] = 'Gasten kunnen niet in deze zone. Meldt jezelf aan.';
$string['communitynotenrollable'] = 'Je kunt jezelf geen lid maken van deze gemeenschap. Neem contact op met de beheerder.';
$string['communitysomeallowguest'] = 'Sommige gemeenschappen laten gasten toe';
$string['communityunenrolme'] = 'Verlaat gemeenschap {$a}';
$string['conferencecenter'] = 'Moodle conferentiecentrum';
$string['connectedsites'] = 'Sommige Moodle-sites zijn verbonden met Moodle.org via Moodle netwerk.Je kunt daar onmiddellijk aanmelden als je hier aangemeld bent.';
$string['donations'] = 'Moodle gebruiken is volledig vrij van elke financiële verplichting. Nochthans hebben vele gebruikers iets geschonken aan het project om de ontwikkelaars te helpen betalen die het allemaal mogelijk maken.';
$string['donationsmoney'] = 'Je kunt ook rechtstreeks geld schenken aan het fonds. Dit geld wordt gebruikt om jouw wensen op de roadmap om te zetten in functionaliteit die we allemaal kunnen gebruiken. Een donatie te maken via kredietkaart in kan in tal van munteenheden via de Paypal-knop onderaan.<br /><br />Donateurs die meer dan $10 schenken kunnen hun naam gedurende één jaar op deze pagina zetten. Denk er aan om op de "Ga verder"-knop te klikken na de betaling om het formulier te krijgen waar je kunt bewerken hoe jouw naam verschijnt.';
$string['donationsservices'] = 'Als je nood hebt aan een Moodle service, zoals hosting, ondersteuning, installatie, aangepaste code, cursusontwikkeling of consulting, contacteer dan je locale geauthoriseerde <a href="http://moodle.com/">Moodle Partner van moodle.com</a> (je kunt hun reclamebanners op deze site terugvinden). Partners dragen een vast percentage van hun inkomen gegenereerd met Moodle bij aan het Moodle trust ontwikkelingsfonds. Op die manier wint iedereen.';
$string['donationstitle'] = 'Donaties';
$string['donationstrust'] = 'Moodle heeft een ontwikkelingsfonds dat door de Moodle Trust beheerd wordt en dat programmeurs inhuurt om aan Moodle te werken en dat ook bijdraagt voor de kosten gegenereerd door bijvoorbeeld moodle.org.';
$string['downloadcore'] = 'Onze belangrijkste distributiemethode is via deze standaard pakketten. Er zitten een aantal modules in die door het hoofd ontwikkelingsteam onderhouden worden en zijn gemakkelijk te installeren op nagenoeg elk platvorm waarop PHP en een databank geïnstalleerd staan.';
$string['downloadcoretitle'] = 'Standaard Moodle-pakketten';
$string['downloadintro'] = 'Moodle is open bron onder de <a href="http://docs.moodle.org/dev/License">GPL licentie</a>. Alles wat we maken gratis  voor jou beschikbaar om te downloaden en te gebruiken.';
$string['downloadlang'] = 'In de huidige versies van Moodle is het toevoegen van taalondersteuning geautomatiseerd vanuit het beheermenu van je site. Voor sommige oudere versies van Moodle moeten taalpakketten handmatig gedownload worden.';
$string['downloadlangtitle'] = 'Taalpakketten';
$string['downloadmac'] = 'Als je nog geen webserver klaar hebt, kunnen deze alles-in-één-pakketten  het je  heel gemakkelijk maken om Moodle op gelijk welke Applecomputer met Mac OS X te installeren';
$string['downloadmactitle'] = 'Moodle voor Mac OS X';
$string['downloadmodules'] = 'Blader door onze databank met extra modules en plugins die aan je Moodlesite kunnen toegevoegd worden om extra functionalliteit buiten de standaardmodules toe te voegen.';
$string['downloadmodulestitle'] = 'Modules en plugins';
$string['downloadthemes'] = 'Hoe Moodle er uit ziet kan heel sterk aangepast worden door een ander thema te gebruiken. We hebben een databank met thema\'s die ander Moodlegebruikers gemaakt en gedeeld hebben.';
$string['downloadthemestitle'] = 'Thema\'s';
$string['downloadviagitcvs'] = 'Andere manieren om Moodle te bekomen: <a href="http://docs.moodle.org/en/Git_for_Administrators">downloaden via Git</a> or <a href="http://docs.moodle.org/22/en/CVS_for_Administrators">downloaden via CVS</a>';
$string['downloadwin'] = 'Als je nog geen webserver klaar hebt, kunnen deze alles-in-één-pakketten  het je  heel gemakkelijk maken om Moodle op gelijk welke Windowscomputer te installeren.';
$string['downloadwintitle'] = 'Moodle voor Windows';
$string['erroradminonly'] = 'Enkel beheerders hebben toegang tot deze interface.';
$string['erroralreadyvoted'] = 'Je hebt al gestemd voor {$a}';
$string['errormaxmessages'] = 'Sorry, maar je mag niet meer dan 3 berichten verzenden';
$string['errornomainnews'] = 'Kon geen nieuwsforum vinden of maken voor deze site';
$string['errorsendingmail'] = 'Er is een fout opgetreden bij het versturen van het bericht. Probeer later opnieuw of contacteer de sitebeheerder';
$string['events'] = 'Hoewel we ons specialiseren in online leren, is het toch ook wel leuk om eens samen in één kamer te zitten! Neem een kijkje naar deze links voor meer informatie over onze conferentie (we noemen ze MoodleMoots) en andere evenementen';
$string['eventstitle'] = 'Evenementen';
$string['feed_events'] = 'Gebeurtenissen';
$string['feed_events_more'] = 'Meer kalenderitems';
$string['feed_news'] = 'Aankondigingen';
$string['feed_news_more'] = 'Bekijk alle aankondigingen';
$string['feed_resources'] = 'Bronnen';
$string['feed_useful'] = 'Nuttige berichten';
$string['feed_useful_more'] = 'Meer berichten';
$string['focusbox_community'] = 'Gemeenschapsdiscussies';
$string['focusbox_community_text'] = 'Doe mee en deel oplossingen en ideeën met Moodlers wereldwijd.';
$string['focusbox_community_viewall'] = 'Alle gemeenschappen';
$string['focusbox_future'] = 'Bepaal mee de toekomst van Moodle';
$string['focusbox_future_crowdfund'] = 'Crowdfunding-projecten';
$string['focusbox_future_gdf'] = 'Ontwikkelaarsdiscussies';
$string['focusbox_future_research'] = 'Moodle research';
$string['focusbox_future_roadmap'] = 'Roadmap';
$string['focusbox_future_text'] = 'Zoek de volgende stap en maak mee het verschil.';
$string['focusbox_settingup'] = 'Installatie';
$string['focusbox_settingup_community'] = 'Ondersteuning door de gemeenschap';
$string['focusbox_settingup_download'] = 'Gratis download';
$string['focusbox_settingup_hosting'] = 'Hosting';
$string['focusbox_settingup_install'] = 'Installatie';
$string['focusbox_settingup_own'] = 'Zelf doen';
$string['focusbox_settingup_partner'] = 'Via een Moodle Partner';
$string['focusbox_settingup_plugins'] = 'Plugins';
$string['focusbox_settingup_support'] = 'Commerciële ondersteuning';
$string['focusbox_teaching'] = 'Les geven met Moodle';
$string['focusbox_teaching_books'] = 'Boeken';
$string['focusbox_teaching_courses'] = 'Cursussen en inhoud';
$string['focusbox_teaching_docs'] = 'Documentatie';
$string['focusbox_teaching_text'] = 'Verken de mogelijkheden van Moodle en bekijk beschikbare informatiebronnen';
$string['focusbox_theproject'] = 'Het Moodleproject';
$string['focusbox_theproject_about'] = 'Over Moodle';
$string['focusbox_theproject_devs'] = 'Ontwikkelaars';
$string['focusbox_theproject_hq'] = 'Moodle HQ';
$string['focusbox_theproject_partners'] = 'Moodle partners';
$string['focusbox_theproject_stats'] = 'Statistieken';
$string['focusbox_theproject_text'] = 'Meer weten over het Moodle-project en onze open samenwerkingsvenootschappen';
$string['focusbox_uptodate'] = 'Blijf up-to-date';
$string['focusbox_uptodate_buzz'] = 'Moodle buzz';
$string['focusbox_uptodate_planet'] = 'Planet Moodle';
$string['focusbox_uptodate_security'] = 'Beveiligingsaankondigingen';
$string['focusbox_uptodate_social'] = 'Sociale media';
$string['focusbox_uptodate_text'] = 'Laatste Moodle-nieuws, updates en inzichten wereldwijd.';
$string['generaldeveloperforum'] = 'Algemeen ontwikkelaarsforum';
$string['graphpopulation'] = 'Moodle populatiegrafiek';
$string['graphregistrationmap'] = 'Moodle registratiekaart';
$string['graphregistrationmapdesc'] = 'Top 10 van geregistreerde sites in {$a} landen';
$string['graphusersites'] = 'Moodlegebruikers vergeleken met sites';
$string['heroslide_community_description'] = 'Welkom bij de Moodle-gemeenschap. Ontdek de waarde van open samenwerken door één van de grootste open source teams ter wereld.';
$string['heroslide_community_headline'] = 'Gestuurd door de gemeenschap, wereldwijde ondersteuning.';
$string['heroslide_community_slidecontrol'] = 'Ondersteund door een wereldwijde gemeenschap.';
$string['heroslide_global_description'] = 'Moodle wordt gebruikt door organisaties en instituten, grote en kleine, met miljoenen gebruikers over heel de wereld en is beschikbaar in meer dan 100 talen.';
$string['heroslide_global_headline'] = 'De motor van leeromgevingen over heel de wereld';
$string['heroslide_global_slidecontrol'] = 'De motor van leeromgevingen over heel de wereld';
$string['heroslide_link_demo'] = 'Demo';
$string['heroslide_link_features'] = 'Mogelijkheden';
$string['heroslide_link_forums'] = 'Community forums';
$string['heroslide_link_sites'] = 'Geregistreerde sites';
$string['heroslide_link_stats'] = 'Statistieken';
$string['heroslide_link_stories'] = 'Lees meer';
$string['heroslide_power_description'] = 'Het gratis leerplatform dat effectief online lesgeven  en leerervaringen in een privaat samenwerkingsverband mogelijk maakt.';
$string['heroslide_power_headline'] = 'Krachtig. Veilig. Open Source';
$string['heroslide_power_slidecontrol'] = 'Robuust open source leerplatform';
$string['heroslide_story_headline'] = 'Overal lesgeven en leren verbeteren';
$string['heroslide_story_slidecontrol'] = 'Moodle-verhalen van over heel de wereld';
$string['jobs'] = 'Bezoek onze databank met jobs voor informatie over Moodle-gerelateerd werk over heel de wereld';
$string['logoinfo'] = 'De naam Moodle™ is een geregistreerd handelsmerk van de Moodle Trust.

Als je de naam en/of het logo wil gebruiken om Moodle diensten (vb Moodle hosting, Moodle ondersteuning, Moodle certifiering, Moodle training, Moodle consulting,  Moodle aanpassingen, Moodle cursusontwerp, Moodle thema-ontwerp, Moodle integraties, Moodle installatie enz) of als naam van een software-pakket, dan moet je toestemming vragen en krijgen van de Moodle Trust via de [moodle.com helpdesk](http://moodle.com/helpdesk/), in overeenstemming met normale handelsmerkbeperkingen.

Er zijn geen beperkingen over hoe je de naam in andere contexten gebruikt (bijvoorbeeld als je Moodle enkel gebruikt om cursussen aan te bieden, dan kun je de naam vrij gebruiken om er naar te verwijzen). Als je niet zeker weet of jouw gebruik van de naam legitiem is, leg je vraag dan voor via de [moodle.com helpdesk](http://moodle.com/helpdesk/). We zullen je helpen met een officiële toestemming of met het verbeteren van je verwoording.';
$string['logotitle'] = 'Moodle logo';
$string['moodlepartner_corporate'] = 'Bedrijfstraining';
$string['moodlepartner_other'] = 'Andere sectoren';
$string['moodlepartner_school'] = 'School';
$string['moodlepartner_university'] = 'Universiteit';
$string['networkinfo'] = 'Volgende Moodle-sites zijn verbonden met moodle.org door gebruik te maken van Moodle networking, zodat je rechtstreeks van hieruit daar kunt aanmelden.';
$string['networktitle'] = 'Verbonden sites';
$string['newregistrations'] = 'Nieuwe registraties';
$string['newstitle'] = 'Aankondigingen';
$string['noenrolledcoursesyet'] = 'Je bent nog bij geen enkele cursus van deze site aangemeld';
$string['partnerslogan'] = 'Het Moodle-project wordt wereldwijd ondersteund door 60 gecertificeerde Moodle partners. <br/><a href="http://moodle.com/partners/about/">Leer meer </a> over het Moodle Partner programma en <a href="http://moodle.com/partners">vind een Moodle Partner</a> in jouw buurt.';
$string['permalink'] = 'Permanente link';
$string['pluginname'] = 'Moodle.org site';
$string['popularissues'] = 'Meest populaire items';
$string['recentlyratedposts'] = 'Recent beoordeelde berichten';
$string['recentpart'] = 'Deze pagina toont enkele mensen die vandaag moodle.org gebruiken.';
$string['registeredsites'] = 'Het is niet nodig dat instituten iemand er van op de hoogte brengen dat ze Moodle gebruiken, omdat Moodle open bronsoftware is. Sommige Moodle sites hebben er voor gekozen zich bij ons te registreren en we houden daarvan een bij.';
$string['registeredsitestitle'] = 'Geregistreerde sites';
$string['registereduserslastday'] = 'Nieuwe gebruikers in de laatste 24 uur';
$string['registereduserstotal'] = 'Totaal aantal geregistreerde gebruikers';
$string['registrationgraphalt'] = 'Alle Moodleregistraties ooit';
$string['registrationgraphdesc'] = 'We doen regalmatig <a href="http://docs.moodle.org/en/Usage">bulk tests van sites</a> om na te gaan of ze nog bestaan. Je kunt dus af en toe zien dat het aantal sites vermindert.';
$string['registrationslast6months'] = 'Registraties in de afgelopen 6 maand';
$string['registrationstotal'] = 'Alle huidige registraties';
$string['resources_buzz'] = 'Buzz';
$string['resources_courses'] = 'Cursussen';
$string['resources_jobs'] = 'Jobs';
$string['resources_plugins'] = 'Plugins';
$string['roadmap'] = 'Moodle roadmap';
$string['rssdescription'] = 'Recente of als nuttig beoordeelde forumberichten van moodle.org';
$string['rsstitle'] = 'Moodle.org forumberichten';
$string['searchmoodleorg'] = 'Doorzoek moodle.org';
$string['securitytitle'] = 'Beveiligingsaankondigingen';
$string['shop'] = 'Zoek je een manier om duidelijk te maken dat je een deel bent van onze gemeenschap? Neem dan een kijkje in onze shop. We hebben T-shirts, mokken en allerlei andere hebbedingetjes.';
$string['social-facebook-moodle'] = 'Officiële Moodle-pagina op Facebook';
$string['social-googleplus-community'] = 'Officiële Moodle-gemeenschapspagina om Google+';
$string['social-googleplus-moodle'] = 'Officiële Moodle-pagina op Google+';
$string['socialinfo'] = 'We zijn op verschillende sociale mediapagina\'s vertegenwoordigd om te helpen Moodle bekend te maken en om het laatste nieuws en gebeurtenissen in de Moodle-wereld te verspreiden.
Volg ons om up-to-date te blijven en om anderen uit de gemeenschap te ontmoeten.';
$string['social-linkedin-moodle'] = 'Officiële Moodle-pagina op LinkedIn';
$string['socialtitle'] = 'Sociale media';
$string['social-twitter-moodle'] = 'Officiële Moodle-aankondigingen, geaggregeerd Moodle-nieuws van Planet Moodle en Moodle buzz en nuttige forumberichten';
$string['social-twitter-moodledev'] = 'Moodle ontwikkelingsnieuws en updates';
$string['social-twitter-moodlehq'] = 'Tweets van Moodle HQ';
$string['social-twitter-moodlejobs'] = 'Moodle-gerelateerde werkaanbiedingen';
$string['social-twitter-moodlenet'] = 'Gedeelde Moodle-cursussen en inhoud';
$string['social-twitter-moodleplugins'] = 'Recente nieuwe Moodle add-ons';
$string['social-twitter-moodleresearch'] = 'Nieuws en updates van de jaarlijkse Moodle Research Conferentie en Moodle-gerelateerde research';
$string['social-twitter-moodlesecurity'] = 'Moodle beveiligingsaankondigingen';
$string['social-twitter-moodlesites'] = 'Statusupdates van de sites en services van het Moodle HQ netwerk';
$string['social-twitter-moodlethemes'] = 'Recente nieuwe Moodle thema\'s';
$string['social-youtube-moodle'] = 'Officiëel Moodle-kanaal op YouTube';
$string['statscountries'] = 'Landen';
$string['statscourses'] = 'Cursussen';
$string['statsenrolments'] = 'Aanmeldingen';
$string['statsposts'] = 'Forumberichten';
$string['statsquestions'] = 'Testvragen';
$string['statsresources'] = 'Bronnen';
$string['statsteachers'] = 'Leraren';
$string['statsusers'] = 'Gebruikers';
$string['supportbooks'] = 'We houden een lijst bij van de vele Moodle boeken die er te koop zijn.';
$string['supportcommercial'] = 'De  <a href="http://moodle.com/">Moodle Partners</a> zijn een wereldwijde groep van geautoriseerde ondersteunende firma\'s die er zich toe verbonden hebben om het open bron Moodle project financieel te steunen. Ze voorzien in een hele reeks optionele commerciële diensten voor Moodlegebruikers over heel de wereld:';
$string['supportdocs1'] = 'Moodle Docs is een goede plaats om te beginnen, vooral onze pagina\'s met veel gestelde vragen.';
$string['supportdocs2'] = 'Een aangename manier om relevante documentatie te vinden is de link "Hulp uit Moodle Docs voor deze pagina" te volgen die onderaan elke pagina van je Moodle site staat.';
$string['supportdocsfaq'] = 'Veelgestelde vragen';
$string['supportdocslang'] = 'Moodle Docs in andere talen';
$string['supportforums'] = 'Onze gebruikersgemeenschap communiceert vooral via forums in "cursussen" op deze Moodlegebaseerde site. Je moet je "aanmelden" in een cursus om berichten te kunnen posten (aanmelden is volledig gratis).';
$string['supportforumsenglish'] = 'De belangrijkste ondersteunings- en ontwikkelingsdiscussies tussen gebruikers en ontwikkelaars zijn in het Engels en hier te vinden:';
$string['supportforumsenglishname'] = 'Moodle gebruiken';
$string['supportforumslang'] = 'Het belangrijkste forum om te kletsen in het Nederlands is hier:';
$string['supportforumslangname'] = 'Moodle lounge';
$string['supportforumslangurl'] = 'http://moodle.org/course/view.php?id=13';
$string['supportforumslist'] = 'We hebben nog vele ander forums, in vele talen:';
$string['supportforumslistname'] = 'Lijst met alle forums';
$string['supportintro'] = 'Je bent niet alleen! Er zijn vele manieren om hulp met Moodle te krijgen als je die nodig hebt.';
$string['top10countriesbyregistration'] = 'Top 10 landen volgens aantal registraties';
$string['top10sitesbycourses'] = 'Top 10 sites per aantal cursussen';
$string['top10sitesbyusers'] = 'Top 10 sites per aantal gebruikers';
$string['url-about'] = 'http://docs.moodle.org/en/About_Moodle';
$string['url-features'] = 'http://docs.moodle.org/en/Features';
$string['url-install'] = 'http://docs.moodle.org/en/Installation';
$string['url-standards'] = 'http://docs.moodle.org/en/Standards';
$string['url-userdocs'] = 'http://docs.moodle.org/en/';
$string['versionsused'] = 'Gebruikte versies';
