<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'analytics', language 'de', branch 'MOODLE_37_STABLE'
 *
 * @package   analytics
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['analysablenotused'] = 'Analyse-Objekt {$a->analysableid} nicht genutzt: {$a->errors}';
$string['analysablenotvalidfortarget'] = 'Analyse-Objekt {$a->analysableid} ist für dieses Ziel nicht gültig: {$a->result}';
$string['analysisinprogress'] = 'Wird noch von einer vorherigen Ausführung analysiert';
$string['analytics'] = 'Analytics';
$string['analyticslogstore'] = 'Verwendeter Log-Speicher';
$string['analyticslogstore_help'] = 'Der Log-Speicher, der von der Analytics-API genutzt wird, um die Nutzeraktivitäten auszuwerten.';
$string['analyticssettings'] = 'Analytics-Einstellungen';
$string['analyticssiteinfo'] = 'Website-Informationen';
$string['defaultpredictionsprocessor'] = 'Standard-Prozessor für Vorhersagen';
$string['defaultpredictoroption'] = 'Standard-Prozessor {$a}';
$string['disabledmodel'] = 'Deaktiviertes Modell';
$string['erroralreadypredict'] = 'Die Datei {$a} wurde bereits zur Vorhersage genutzt.';
$string['errorcannotreaddataset'] = 'Die Datensatzdatei {$a} kann nicht gelesen werden.';
$string['errorcannotwritedataset'] = 'Die Datensatzdatei {$a} kann nicht geschrieben werden.';
$string['errorexportmodelresult'] = 'Das Machine-Learning-Modell kann nicht exportiert werden.';
$string['errorimport'] = 'Fehler beim Importieren der bereitgestellten JSON-Datei.';
$string['errorimportmissingclasses'] = 'Die folgenden Analytics-Modelle sind auf dieser Website nicht verfügbar: {$a->missingclasses}.';
$string['errorimportmissingcomponents'] = 'Das angegebene Modell erfordert die Installation der folgenden Plugins: {$a}. Beachten Sie, dass die Versionen nicht unbedingt mit den auf Ihrer Website installierten Versionen übereinstimmen müssen. Die Installation der gleichen oder einer neueren Version des Plugins sollte in den meisten Fällen in Ordnung sein.';
$string['errorimportversionmismatches'] = 'Die Version der folgenden Komponenten unterscheidet sich von der auf dieser Seite installierten Version: {$a}. Sie können die Option \'Versionsfehler ignorieren\' verwenden, um diese Unterschiede zu ignorieren.';
$string['errorinvalidindicator'] = 'Ungültiger Indikator {$a}';
$string['errorinvalidtarget'] = 'Ungültiges Ziel {$a}';
$string['errorinvalidtimesplitting'] = 'Ungültige Zeitaufteilung. Stellen Sie sicher, dass Sie die Klasse mit voll qualifizierten Klassennamen hinzufügen.';
$string['errornoexportconfig'] = 'Es gab ein Problem beim Export der Modellkonfiguration.';
$string['errornoindicators'] = 'Dieses Modell beinhaltet keine Indikatoren.';
$string['errornopredictresults'] = 'Der Vorhersage-Prozessor hat keine Ergebnisse ausgegeben. Überprüfen Sie die Inhalte des Ausgabeverzeichnisses für weitere Informationen.';
$string['errornoroles'] = 'Die Rollen von Teilnehmer/innen oder Trainer/innen wurden noch nicht definiert. Definieren Sie diese Rollen in den Analytics-Einstellungen.';
$string['errornotarget'] = 'Dieses Modell hat kein Ziel.';
$string['errornotimesplittings'] = 'Dieses Modell hat keine Zeitaufteilungsmethode.';
$string['errorpredictioncontextnotavailable'] = 'Der Vorhersagenkontext ist nicht mehr verfügbar.';
$string['errorpredictionformat'] = 'Falsches Format zur Vorhersagenberechnung';
$string['errorpredictionnotfound'] = 'Vorhersage nicht gefunden';
$string['errorpredictionsprocessor'] = 'Vorhersagen-Prozessorfehler: {$a}';
$string['errorpredictwrongformat'] = 'Die Ausgabe des Vorhersagen-Prozessors kann nicht entschlüsselt werden: "{$a}"';
$string['errorprocessornotready'] = 'Der ausgewählte Vorhersagen-Prozessor ist nicht bereit: {$a}';
$string['errorsamplenotavailable'] = 'Das vorhergesagte Beispiel ist nicht mehr verfügbar.';
$string['errorunexistingmodel'] = 'Nicht vorhandenes Modell {$a}';
$string['errorunexistingtimesplitting'] = 'Die gewählte Zeitaufteilungsmethode ist nicht verfügbar.';
$string['errorunknownaction'] = 'Unbekannter Vorgang';
$string['eventinsightsviewed'] = 'Betrachtete Einschätzungen';
$string['eventpredictionactionstarted'] = 'Vorhersageprozess gestartet';
$string['fixedack'] = 'Anerkannt';
$string['insightinfomessage'] = 'Das System hat einige Einschätzungen für Sie erstellt: {$a}';
$string['insightinfomessageaction'] = '{$a->text}: {$a->url}';
$string['insightinfomessagehtml'] = 'Das System hat eine Einschätzung für Sie erstellt.';
$string['insightmessagesubject'] = 'Neue Einschätzung für "{$a}"';
$string['invalidanalysablefortimesplitting'] = 'Die Analyse kann mit der Zeitaufteilungsmethode {$a} nicht vorgenommen werden.';
$string['invalidtimesplitting'] = 'Das Modell mit der ID {$a} braucht eine Zeitaufteilungsmethode, bevor es für das Training verwendet werden kann.';
$string['levelinstitution'] = 'Schulstufe';
$string['levelinstitutionisced0'] = 'Früherziehung (Vorschule)';
$string['levelinstitutionisced1'] = 'Primarstufe';
$string['levelinstitutionisced2'] = 'Sekundarstufe I';
$string['levelinstitutionisced3'] = 'Sekundarstufe II';
$string['levelinstitutionisced4'] = 'Post-Sekundarausbildung (auch Schulungen in Unternehmen und Organisationen, aber ohne Hochschule)';
$string['levelinstitutionisced5'] = 'Kurzfristige Hochschulausbildung (auch Schulungen in Unternehmen und Orhanisationen)';
$string['levelinstitutionisced6'] = 'Bachelor (oder vergleichbar)';
$string['levelinstitutionisced7'] = 'Master (oder vergleichbar)';
$string['levelinstitutionisced8'] = 'Doktor (oder vergleichbar)';
$string['modeinstruction'] = 'Modi des Unterrichtens';
$string['modeinstructionblendedhybrid'] = 'Blended oder Hybrid';
$string['modeinstructionfacetoface'] = 'Face to Face';
$string['modeinstructionfullyonline'] = 'Vollständig online';
$string['modeloutputdir'] = 'Ausgabeverzeichnis';
$string['modeloutputdirinfo'] = 'Verzeichnis, in dem die Vorhersagen-Prozessoren alle Evaluationsinformationen speichern. Dies ist hilfreich für die Fehlerbehebung und Auswertung.';
$string['modeltimelimit'] = 'Analysezeitlimit pro Modell';
$string['modeltimelimitinfo'] = 'Diese Option begrenzt die Zeit, die jedes Modell für die Analyse von Website-Inhalten benötigen darf.';
$string['nocourses'] = 'Keine Kurse zum Analysieren';
$string['nodata'] = 'Keine Daten zum Analysieren';
$string['noevaluationbasedassumptions'] = 'Auf Annahmen basierte Modelle können nicht evaluiert werden.';
$string['noinsights'] = 'Keine Ergebnisse vorhanden';
$string['noinsightsmodel'] = 'Dieses Modell erzeugt keine Einschätzungen.';
$string['nonewdata'] = 'Keine neuen Daten verfügbar';
$string['nonewranges'] = 'Keine neuen Vorhersagen';
$string['nonewtimeranges'] = 'Keine neue Zeitaufteilung. Es ist nichts vorherzusagen.';
$string['nopredictionsyet'] = 'Noch keine Vorhersagen verfügbar';
$string['noranges'] = 'Noch keine Vorhersagen';
$string['notrainingbasedassumptions'] = 'Auf Annahmen basierende Modelle benötigen kein Training.';
$string['notuseful'] = 'Nicht hilfreich';
$string['novaliddata'] = 'Keine gültigen Daten verfügbar';
$string['novalidsamples'] = 'Kein gültiges Beispiel vorhanden';
$string['onlycli'] = 'Analytics-Prozesse nur über die Befehlszeile ausführen';
$string['onlycliinfo'] = 'Analytics-Prozesse wie das Auswerten von Modellen, das Trainieren von Machine-Learning-Algorithmen oder das Treffen von Vorhersagen können sehr viel Zeit in Anspruch nehmen. Diese Prozesse werden als Cron-Tasks ausgeführt und können über die Befehlszeile aktiviert werden. Deaktivieren Sie die Einstellung, wenn Manager/innen der Website diese Prozesse auch manuell über das Webinterface ausführen können sollen.';
$string['percentonline'] = 'Prozent online';
$string['percentonline_help'] = 'Wenn Ihre Organisation gemischte oder hybride Kurse anbietet: wie viel Zeit wird online in Moodle durchgeführt? Geben Sie eine Zahl zwischen 0 und 100 ein.';
$string['predictionsprocessor'] = 'Vorhersagen-Prozessor';
$string['predictionsprocessor_help'] = 'Ein Vorhersagen-Prozessor ist ein Tool (Machine-Learning-Backend), das Datensätze verarbeitet, die aus Indikatoren und Zielen von Modellen berechnet werden. Jedes Modell kann einen anderen Vorhersagen-Prozessor nutzen. Der ausgewählte Vorhersagen-Prozessor wird bereits bei der Installation eingerichtet.';
$string['privacy:metadata:analytics:indicatorcalc'] = 'Indikatorberechnungen';
$string['privacy:metadata:analytics:indicatorcalc:contextid'] = 'Der Kontext';
$string['privacy:metadata:analytics:indicatorcalc:endtime'] = 'Endzeitpunkt für Berechnungen';
$string['privacy:metadata:analytics:indicatorcalc:indicator'] = 'Indikator-Berechnungs-Class';
$string['privacy:metadata:analytics:indicatorcalc:sampleid'] = 'Beispiel-ID';
$string['privacy:metadata:analytics:indicatorcalc:sampleorigin'] = 'Originäre Tabelle für Beispiel';
$string['privacy:metadata:analytics:indicatorcalc:starttime'] = 'Startzeitpunkt für Berechnungen';
$string['privacy:metadata:analytics:indicatorcalc:timecreated'] = 'Wann die Vorhersage erfolgt';
$string['privacy:metadata:analytics:indicatorcalc:value'] = 'Berechneter Wert';
$string['privacy:metadata:analytics:predictionactions'] = 'Vorhersageaktivitäten';
$string['privacy:metadata:analytics:predictionactions:actionname'] = 'Aktionsbezeichnung';
$string['privacy:metadata:analytics:predictionactions:predictionid'] = 'Die Vorhersage-ID';
$string['privacy:metadata:analytics:predictionactions:timecreated'] = 'Wann die Vorhersage ausgeführt wird';
$string['privacy:metadata:analytics:predictionactions:userid'] = 'Nutzer, der Aktion ausführt';
$string['privacy:metadata:analytics:predictions'] = 'Vorhersagen';
$string['privacy:metadata:analytics:predictions:calculations'] = 'Indikatorberechnungen';
$string['privacy:metadata:analytics:predictions:contextid'] = 'Der Kontext';
$string['privacy:metadata:analytics:predictions:modelid'] = 'Modell-ID';
$string['privacy:metadata:analytics:predictions:prediction'] = 'Die Vorhersage';
$string['privacy:metadata:analytics:predictions:predictionscore'] = 'Das Vorhersageergebnis';
$string['privacy:metadata:analytics:predictions:rangeindex'] = 'Index der Zeiteinteilungsmethode';
$string['privacy:metadata:analytics:predictions:sampleid'] = 'Beispiel-ID';
$string['privacy:metadata:analytics:predictions:timecreated'] = 'Wann die Vorhersage erstellt wurde';
$string['privacy:metadata:analytics:predictions:timeend'] = 'Endzeitpunkt für Berechnung';
$string['privacy:metadata:analytics:predictions:timestart'] = 'Startzeitpunkt für Berechnungen';
$string['processingsitecontents'] = 'Inhalte der Website werden verarbeitet.';
$string['successfullyanalysed'] = 'Erfolgreich analysiert';
$string['timesplittingmethod'] = 'Zeitaufteilungsmethode';
$string['timesplittingmethod_help'] = 'Eine Zeitaufteilungsmethode unterteilt die Kursdauer in Zeitabschnitte. Die Vorhersage-Engine läuft jeweils am Ende dieser Zeitabschnitte. Aktivieren Sie nur die Zeitaufteilungsmethoden, die Sie wirklich verwenden möchten. Der Bewertungsprozess wird für alle aktivierten Zeitaufteilungsmethoden wiederholt, d.h. je mehr Zeitaufteilungsmethoden vorhanden sind, desto langsamer wird der Bewertungsprozess.';
$string['typeinstitution'] = 'Institutionstyp';
$string['typeinstitutionacademic'] = 'Akademisch';
$string['typeinstitutionngo'] = 'Nichtregierungsorganisation (NGO)';
$string['typeinstitutiontraining'] = 'Firmenschulung';
$string['viewdetails'] = 'Details anzeigen';
$string['viewinsight'] = 'Einschätzung anzeigen';
$string['viewinsightdetails'] = 'Einschätzungsdetails anzeigen';
$string['viewprediction'] = 'Details zur Vorhersage anzeigen';
