<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'sr_cr', branch 'MOODLE_37_STABLE'
 *
 * @package   lti
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Прихвати';
$string['accepted'] = 'Прихваћено';
$string['accept_grades'] = 'Прихвати оцене алата';
$string['accept_grades_admin'] = 'Прихвати оцене алата';
$string['accept_grades_admin_help'] = 'Наведите да ли провајдер алата може да додаје, ажурира. чита и брише оцене повезане са инстанцама овог алата.

Неки провајдери подржавају могућност слања оцена назад у Moodle на основу акција које су предузете у оквиру алата, стварајући на тај начин доживљај веће интегрисаности Moodlea и екстерног алата.';
$string['accept_grades_help'] = 'Наведите да ли провајдер алата може да додаје, ажурира, чита и брише оцене повезане са инстанцама овог типа алата.

Неки провајдери подржавају могућност слања оцена назад у Moodle на основу акција које су предузете у оквиру алата, стварајући на тај начин доживљај веће интегрисаности Moodlea и екстерног алата.

Имајте у виду да се ова подешавања могу изменити у конфигурацији алата.';
$string['action'] = 'Акција';
$string['activate'] = 'Активирај';
$string['activatetoadddescription'] = 'Мораћете да активирате овај алат да бисте могли да додате опис.';
$string['active'] = 'Активан';
$string['activity'] = 'Активност';
$string['addnewapp'] = 'Омогући екстерну апликацију';
$string['addserver'] = 'Додај нови поуздани сервер';
$string['addtype'] = 'Додај преконфигурисан алат';
$string['allow'] = 'Дозволи';
$string['allowsetting'] = 'Дозволи да алат унутар Moodlea  сачува 8K подешавања';
$string['always'] = 'Увек';
$string['autoaddtype'] = 'Додај алат';
$string['automatic'] = 'Аутоматски, на основу URL адресе алата';
$string['baseurl'] = 'Основна URL адреса/назив алата за пријаву';
$string['basiclti'] = 'LTI';
$string['basicltiactivities'] = 'LTI активности';
$string['basiclti_base_string'] = 'LTI OAuth основни стринг';
$string['basiclti_endpoint'] = 'Крајња тачка покретања LTI алата';
$string['basicltifieldset'] = 'Прилагођени пример скупа поља';
$string['basiclti_in_new_window'] = 'Ваша активност је отворена у новом прозору';
$string['basiclti_in_new_window_open'] = 'Отвори у новом прозору';
$string['basicltiintro'] = 'Опис активности';
$string['basicltiname'] = 'Назив активности';
$string['basiclti_parameters'] = 'Параметри покретања LTI алата';
$string['basicltisettings'] = 'Основна LTI подешавања';
$string['cancel'] = 'Откажи';
$string['cancelled'] = 'Отказано';
$string['cannot_delete'] = 'Не можете да обришете ову конфигурацију алата';
$string['cannot_edit'] = 'Не можете да уредите ову конфигурацију алата';
$string['capabilities'] = 'Могућности';
$string['capabilities_help'] = 'Одаберите оне способности које желите да понудите пружаоцу алата. Може се одабрати више од једне способности.';
$string['capabilitiesrequired'] = 'Овај алат захтева приступ следећим подацима како би био активиран:';
$string['cleanaccesstokens'] = 'Уклањање истеклих токена за приступ екстерном алату';
$string['click_to_continue'] = '<a href="{$a->link}" target="_top">Кликни за наставак</a>';
$string['clientidadmin'] = 'ID ознака клијента';
$string['clientidadmin_help'] = 'ID ознака клијента је јединствена вредност која се користи за идентификацију алата. Креира се аутоматски за сваки алат који користи JWT сигурносни профил уведен у LTI верзији 1.3. ID ознака треба да буде део детаљних информација које се прослеђује провајдеру алата како би он могао да конфигурише везу на свом крају.';
$string['comment'] = 'Коментар';
$string['configpassword'] = 'Подразумевана лозинка удаљеног алата';
$string['configpreferheight'] = 'Стандардна преферирана висина';
$string['configpreferwidget'] = 'Постави додатак за подразумевано покретање';
$string['configpreferwidth'] = 'Стандардна преферирана ширина';
$string['configresourceurl'] = 'Подразумевана URL адреса ресурса';
$string['configtoolurl'] = 'Подразумевана URL адреса удаљеног алата';
$string['configtypes'] = 'Омогући LTI  апликације';
$string['configured'] = 'Конфигурисано';
$string['confirmtoolactivation'] = 'Да ли сте сигурни да желите да активирате овај алат?';
$string['contentitem'] = 'Порука Ставке-Садржаја';
$string['contentitem_help'] = 'Ако је означено, приликом додавања екстерног алата биће доступна опција \'Изабери садржај\'.';
$string['courseactivitiesorresources'] = 'Активности и ресурси курса';
$string['courseid'] = 'ID број курса';
$string['courseinformation'] = 'Информације о курсу';
$string['courselink'] = 'Иди на курс';
$string['coursemisconf'] = 'Курс је погрешно конфигурисан';
$string['course_tool_types'] = 'Алати курса';
$string['createdon'] = 'Креирано дана';
$string['curllibrarymissing'] = 'PHP Curl екстензија је неопходна за Екстерни алат.';
$string['custom'] = 'Прилагођени параметри';
$string['custom_config'] = 'Коришћење прилагођене конфигурације алата';
$string['custom_help'] = 'Наменски прилагођени параметри су подешавања које користи провајдер алата. На пример, прилагођени параметри се могу користити за приказ одређених ресурса од стране провајдера. Сваки пареметар треба унети у засебан ред користећи следећи формат: "name=value"; for example, "chapter=3".

Најсигурније је не мењати ово поље, осим ако то не учини сам провајдер алата.';
$string['custominstr'] = 'Прилагођени параметри';
$string['debuglaunch'] = 'Опција за отклањање грешака';
$string['debuglaunchoff'] = 'Нормално покретање';
$string['debuglaunchon'] = 'Покретање са отклањањем грешака';
$string['default'] = 'Подразумевано';
$string['default_launch_container'] = 'Подразумевани иницијални контејнер';
$string['default_launch_container_help'] = 'Иницијални контејнер утиче на приказ алата приликом његовог покретања унутар курса. Неки контејнери пружају већи број могућности, док други обезбеђују већи степен интеграције са Moodleom.

* **Подразумевано** - користи иницијални контејнер наведен у конфигурације алата.
* **Уметнуто** - алат се приказује унутар постојећег прозора Moodlea, на начин сличан већини других типова активности.
* **Уметнуто, без блокова** - алат се приказује унутар постојећег прозора Moodlea, али само са навигационом траком на врху странице.
* **Нови прозор** - Алат се отвара у новом прозору, заузимајући сав његов раположив простор.
      Зависно од веб читача, алат ће се отворити у новој картици читача или у искачућем прозору. Постоји могућност да веб читач неће дозволити отварање новог прозора.';
$string['delegate'] = 'Делегирај предавачу';
$string['delete'] = 'Обриши';
$string['delete_confirmation'] = 'Да ли сте сигурни да желите да обришете овaj преконфигурисани алат?';
$string['deletetype'] = 'Обриши преконфигурисани алат';
$string['display_description'] = 'Прикажи опис активности приликом њеног покретања';
$string['display_description_help'] = 'Ако је изабрана ова опција, опис активности (горе наведен) биће приказан изнад садржаја екстерног алата.

Опис се може користити како би се пружиле додатне инструкције онима који покрећу алат, али није неопходан.

Опис се никада не приказује када се екстерни алат покреће у новом прозору.';
$string['display_name'] = 'Прикажи назив активности када се покрене';
$string['display_name_help'] = 'Ако је изабрана ова опција, назив активности (горе наведен) биће приказан изнад садржаја екстерног алата.

Могуће је да провајдер алата, такође, може да прикаже наслов. Ова опција спречава да наслов активности буде приказан двапут.

Наслов се никада не приказује ако се иницијални контејнер алата покреће у новом прозору.';
$string['domain_mismatch'] = 'Домен URL адресе алата се не поклапа са конфигурацијом алата.';
$string['donot'] = 'Немој слати';
$string['donotaccept'] = 'Немој прихватити';
$string['donotallow'] = 'Немој дозволити';
$string['duplicateregurl'] = 'Ова URL адреса за пријаву се већ користи';
$string['editdescription'] = 'Кликните овде како бисте описали овај алат';
$string['edittype'] = 'Уреди преконфигурисани алат';
$string['embed'] = 'Угради';
$string['embed_no_blocks'] = 'Угради, без блокова';
$string['enableemailnotification'] = 'Пошаљи обавештења е-поштом';
$string['enableemailnotification_help'] = 'Ако је омогућена ова опција, полазници ће е-поштом добити обавештење када буде оцењена њихова активност у оквиру екстерног алата..';
$string['enterkeyandsecret'] = 'Унесите свој кориснички кључ и дељени тајни кључ';
$string['enterkeyandsecret_help'] = 'Ако сте добили кориснички кључ и/или дељени тајни кључ унесите их овде';
$string['errorbadurl'] = 'URL адреса није исправна URL адреса алата односно кертриџа';
$string['errorincorrectconsumerkey'] = 'Кориснички кључ је нетачан.';
$string['errorinvaliddata'] = 'Неисправни подаци: {$a}';
$string['errorinvalidmediatype'] = 'Неисправни тип медија: {$a}';
$string['errorinvalidresponseformat'] = 'Неисправан формат одговора Ставке-Садржаја';
$string['errormisconfig'] = 'Погрешно  конфигурисан алат. Замолите свог Moodle администратора да поправи конфигурацију алата.';
$string['errortooltypenotfound'] = 'Није пронађен тип LTI  алата';
$string['existing_window'] = 'Постојећи прозор';
$string['extensions'] = 'LTI проширени сервиси';
$string['external_tool_type'] = 'Преконфигурисан алат';
$string['external_tool_type_help'] = '* ** Аутоматски, на основу URL адресе алата** - Најбоља конфигурација алата се бира аутоматски. Ако URL адреса алата није препозната, можда ће бити потребно да ручно унесете податке о конфигурацији алата.
* **Специфичан преконфигурисани алат** - Приликом комуникације са провајдером екстерног алата користиће се конфигурација за наведени алат. Ако се испостави да URL адреса алата не припада провајдеру, биће приказано упозорење. Није увек неопходно да  унесете URL адреса алата.
* **Прилагођена конфигурација** - Кориснички кључ као и дељени тајни кôд морају се унети ручно. Оба кључа се могу добити од провајдера. Међутим, не захтевају сви алати кориснички кључ и дељени тајни кôд. У том случају ова поља можете оставити празна.

### Уређивање преконфигурисаног алата

У падајућем менија за \'Преконфигурисани алат\' доступне су три иконице:

* **Додај** - креирајте конфигурацију алата на нивоу курса. Све инстанце екстерног алата на овом курсу моћи ће да користе конфигурацију алата.
* **Уреди** - изаберите алат на нивоу курса из падајућег менија, а затим кликните на ову иконицу. Могу се уређивати детаљи конфигурације алата.
* **Обриши** - уклоните изабрани алат на нивоу курса.';
$string['external_tool_types'] = 'Преконфигурисани алати';
$string['failedtoconnect'] = 'Moodle није могао да успостави комуникацију са"{$a}" системом';
$string['failedtocreatetooltype'] = 'Креирање новог алата није успело. Молимо, проверите URL адресу и покушајте поново.';
$string['failedtodeletetoolproxy'] = 'Покушај да се обрише пријава за алата није успео. Можда ћете морати да посетите "Управљање пријавама за екстерне алате" и ручно је обришете.';
$string['filter_basiclti_configlink'] = 'Конфигуриши своје префериране сајтове и њихове лозинке';
$string['filter_basiclti_password'] = 'Лозинка је обавезна';
$string['filterconfig'] = 'LTI администрација';
$string['filtername'] = 'LTI';
$string['fixexistingconf'] = 'Искористите постојећу конфигурацију за погрешно конфигурисану инстанцу';
$string['fixnew'] = 'Нова конфигурација';
$string['fixnewconf'] = 'Дефиниши нову конфигурацију за погрешно конфигурисану инстанцу';
$string['fixold'] = 'Користи постојећу';
$string['forced_help'] = 'Ово подешавање је постављено као обавезно у конфигурацији алата на нивоу курса или сајта. Не можете да га мењате у овом интерфејсу.';
$string['force_ssl'] = 'Обавезан SSL';
$string['force_ssl_help'] = 'Избором ове опције, свако покретање алата овог провајдера ће обавезно користити SSL протокол.

Осим тога, и сви захтеви веб сервиса провајдера алата ће користити SSL протокол.

Ако се користи ова опција, проверите да ли овај Moodle сајт и провајдер алата подржавају SSL протокол.';
$string['generaltool'] = 'Општи алат';
$string['global_tool_types'] = 'Глобални преконфигурисани алати';
$string['grading'] = 'Усмеравање оцена';
$string['icon_url'] = 'Иконица URL адресе';
$string['icon_url_help'] = 'URL адресe иконице, омогућава да се измени иконица која се појављује на списку курсева за ова активност. Уместо да користите подразумевану LTI иконицу, може се дефинисати иконица која одражава тип активности.';
$string['id'] = 'ID';
$string['indicator:cognitivedepth'] = 'LTI - когнитивни аспект';
$string['indicator:cognitivedepth_help'] = 'Овај индикатор се заснива на когнитивној дубини коју је полазник постигао у оквиру активности \'LTI\'.';
$string['indicator:socialbreadth'] = 'LTI - социјални аспект';
$string['indicator:socialbreadth_help'] = 'Овај индикатор се заснива на обиму социјалних интеракција који је полазник постигао у оквиру активности \'LTI\'.';
$string['initiatelogin'] = 'URL адреса за покретање пријаве';
$string['initiatelogin_help'] = 'URL адреса алата којој ће бити послат захтев за покретање пријаве. Ова URL адреса је неопходна како би порука могла да буде успешно послата алату.';
$string['invalidid'] = 'LTI ID је погрешан';
$string['jwtsecurity'] = 'LTI 1.3';
$string['launch_in_moodle'] = 'Покрени алат унутар Moodlea';
$string['launchinpopup'] = 'Иницијални контејнер';
$string['launch_in_popup'] = 'Покрени алат у искачућем прозору';
$string['launchinpopup_help'] = 'Иницијални контејнер утиче на приказ алата приликом његовог покретања унутар курса. Неки контејнери пружају већи број могућности, док други обезбеђују већи степен интеграције са Moodleom.

* **Подразумевано** - користи контејнер покретања наведен у конфигурацији алата.
* **Уметнуто** - алат се приказује унутар постојећег прозора Moodlea, на начин сличан већини других типова активности.
* **Уметнуто, без блокова** - алат се приказује унутар постојећег прозора Moodlea, али само са навигационом траком на врху странице.
* **Нови прозор** - Алат се отвара у новом прозору, заузимајући сав његов раположив простор.
      Зависно од веб читача, алат ће се отворити у новој картици читача или у искачућем прозору. Постоји могућност да веб читач неће дозволити отварање новог прозора.';
$string['launchoptions'] = 'Опције за покретање';
$string['launch_url'] = 'URL адреса алата';
$string['launch_url_help'] = 'URL адреса алата означава веб адресу екстерног алата, и може да садржи додатне информације, као што је ресурс који ће бити приказан.
Ако нисте сигурни шта да упишете као URL адресу, молимо вас потражите више информације код провајдера алата.

Такође, можете унети URL адресу кертриџа ако је имате, и остатак обрасца ће се аутоматски попунити.

Ако сте изабрали преконфигурисани алат, можда нећете морати да упишете URL адресу алата. То ће највероватније бити случај, ако се линк алата користи само за улазак на систем провајдера, а не за одлазак на неки одређени ресурс.';
$string['leaveblank'] = 'Оставите празно ако вам нису потребни';
$string['lti'] = 'LTI';
$string['lti:addcoursetool'] = 'Додај за курс специфична подешавања алата';
$string['lti:addinstance'] = 'Додај нови екстерни алат';
$string['lti:admin'] = 'Будите администратор када се алат покрене';
$string['lti_administration'] = 'Уреди преконфигурисани алат';
$string['lti_errormsg'] = 'Алат је вратио следећу поруку о грешци: "{$a}"';
$string['lti:grade'] = 'Погледај оцене добијене од екстерног алата';
$string['lti_launch_error'] = 'Дошло је до грешке приликом покретања екстерног алата:';
$string['lti_launch_error_tool_request'] = '<p> Да бисте послали захтев администратору да заврши конфигурисање алата, кликните<a href="{$a->admin_request_url}" target="_top">овде</a>. </p>';
$string['lti_launch_error_unsigned_help'] = '<p>Ова грешка може бити резултат недостатка корисничког кључа и дељеног тајног кључа за провајдера алата.</p>
<p> Ако имате кориснички кључ и дељени тајни кључ, можете их унети приликом уређивања инстанце екстерног алата (проверите да ли су видљиве напредне опције).</p>
</p>Алтернативно, можете да <a href="{$a->course_tool_editor}"> креирате конфигурацију алата на нивоу курса </a>.</p>';
$string['lti:manage'] = 'Буди инструктор кад се покрене алат';
$string['lti:requesttooladd'] = 'Захтевај да се алат подеси на нивоу сајта';
$string['ltisettings'] = 'LTI подешавања';
$string['lti_tool_request_added'] = 'Захтев за конфигурисање алата је успешно послат. Можда ћете морати да се обратите администратору да бисте довршили конфигурисање.';
$string['lti_tool_request_existing'] = 'Конфигурација алата за домен алата је већ послата.';
$string['ltiunknownserviceapicall'] = 'API позив LTI непознатог сервиса.';
$string['ltiversion'] = 'LTI верзија';
$string['ltiversion_help'] = 'Верзија LTI која се користи за потписивање порука и захтева за услугама: LTI 1.0/1.1 и LTI 2.0 користе OAuth 1.0A сигурносно профил; LTI 1.3.0 користи JWTs.';
$string['lti:view'] = 'Покрени активности екстерног алата';
$string['main_admin'] = 'Општа помоћ';
$string['main_admin_help'] = 'Екстерни алати дозвољавају корисницима Moodlea да неприметно ступају у интеракцију са ресурсима који се налазе на удаљеним сајтовима.
Користећи специјалне протоколе удаљени алат ће имати приступ општим информацијама о кориснику који је покренуо алат. На пример, назив институције, ID ознак курса, ID ознака корисника, и друге информације, као што су име корисника или његова е-адреса.

Алати приказани на овој страници су подељени у три категорије:

* **Активни** - ове провајдере алата је администратор одобрио и конфигурисао. Они могу да се користе унутар било ког курса на овом сајту. Ако су унети кориснички кључ и дељени тајни кључ, успостављена је поуздана веза између овог сајта и удаљеног алата, што обезбеђује безбедан канал комуникације.
* **На чекању** - ови провајдери алата су увезени, али их администратор још увек није конфигурисао. Предавачи и даље могу да користе алате ових провајдера ако имају кориснички кључ и дељени тајни кључ, или ако они нису потребни.
* **Одбијени** - ови провајдери алата су означени као они које администратор не намерава да учини доступним на овом сајту. Предавачи и даље могу да користе алате ових провајдера ако имају кориснички кључ и дељени тајни кључ, или ако они нису потребни.';
$string['manage_external_tools'] = 'Управљање алатима';
$string['manage_tool_proxies'] = 'Управљање пријавама за екстерне алате';
$string['manage_tools'] = 'Управљање преконфигурисаним алатима';
$string['manuallyaddtype'] = 'Алтернативно, можете <a href="{$a}">ручно да конфигуришете алат</a>';
$string['miscellaneous'] = 'Разно';
$string['misconfiguredtools'] = 'Откривене су погрешно конфигурисане инстанце алата';
$string['missingparameterserror'] = 'Страница је погрешно конфигурисана: "{$a}"';
$string['module_class_type'] = 'Тип Moodle модула';
$string['modulename'] = 'Екстерни алат';
$string['modulename_help'] = 'Екстерни алати дозвољавају корисницима Moodlea да ступају у интеракцију са ресурсима и активностима за учење на другим веб сајтовима. На пример, екстерни алат може да обезбеди приступ новом типу активности или образовним материјалима које нуде издавачи.

Како бисте подесили инстанцу екстерног алата, неопходно је да провајдер алата подржава LTI (Learning Tools Interoperability) стандард.
Ако пронађете провајдера алата који подржава LTI стандард, он треба да обезбеди упутство о томе како да се конфигурише инстанца екстерног алата. Додатно, биће доступни за употребу и типови алата које конфигурисао администратор сајта.

Екстерни алати се разликују од ресурса \'URL адреса\' на неколико начина:
* **Контекст** - екстерни алати имају приступ информацијама о кориснику који је покренуо алат, као што је назив институције и курса, име корисника и др.
* **Дубока интеграција** - екстерни алати подржавају читање, ажурирање и брисање оцена које су повезане са инстанцом активности. За будућа издања планира се већи степен интеграције.
* **Безбедност** - конфигурације екстерног алата креирају поуздану везу између Moodlea и провајдера алата, што омогућава безбедну комуникацију између њих.';
$string['modulenameplural'] = 'Екстерни алати';
$string['modulenamepluralformatted'] = 'LTI инстанце';
$string['name'] = 'Назив';
$string['never'] = 'Никада';
$string['new_window'] = 'Нови прозор';
$string['noattempts'] = 'Још није било покушаја у оквиру ове инстанце алата';
$string['no_lti_configured'] = 'Не постоје активни екстерни алати који су конфигурисани';
$string['no_lti_pending'] = 'Нема екстерних алата на чекању.';
$string['no_lti_rejected'] = 'Нема одбијених екстерних алата.';
$string['noltis'] = 'Не постоје инстанце екстерних алата';
$string['no_lti_tools'] = 'Не постоје конфигурисани екстерни алати';
$string['noprofileservice'] = 'Није пронађен сервис профила';
$string['noservers'] = 'Нису пронађени сервери';
$string['no_tp_accepted'] = 'Не постоје прихваћене пријаве за екстерне алате.';
$string['no_tp_cancelled'] = 'Не постоје отказане пријаве за екстерне алате';
$string['no_tp_configured'] = 'Не постоје нерегистроване пријаве за екстерне алате, које су конфигурисане.';
$string['no_tp_pending'] = 'Не постоје пријаве за екстерне алате на чекању.';
$string['no_tp_rejected'] = 'Не постоје одбијене  пријаве за екстерне алате.';
$string['notypes'] = 'Тренутно не постоје подешавања LTI алата у Moodleu. Кликните горњи линк за инсталацију како бисте их додали.';
$string['noviewusers'] = 'Нису пронађени корисници који имају овлашћења да користе овај алат';
$string['oauthsecurity'] = 'LTI 1.0/1.1';
$string['opensslconfiginvalid'] = 'LTI 1.3 захтева да исправна openssl.cnf  датотека буде конфигурисана и доступна вашем веб серверу. Обратите се администратору сајта да конфигурише и омогући openssl за овај сајт.';
$string['optionalsettings'] = 'Опциона подешавања';
$string['organization'] = 'Информације о организацији';
$string['organizationdescr'] = 'Опис организације';
$string['organizationid'] = 'ID организације';
$string['organizationid_help'] = 'Јединствени идентификатор ове инстанце Moodlea. Обично се користи DNS назив организације.

Ако ово поље остане празно, користиће се назив сервера овог Moodle сајта, као подразумевана вредност.';
$string['organizationurl'] = 'URL адреса организације';
$string['organizationurl_help'] = 'Основна URL адреса ове инстанце Moodlea';
$string['pagesize'] = 'Број завршених активности на екстерном алату приказаних по страници';
$string['parameter'] = 'Параметри алата';
$string['parameter_help'] = 'Параметри алата су подешавања захтевана за пренос од стране пружаоца алата у прихваћеном посреднику алата.';
$string['password'] = 'Дељени тајни кључ';
$string['password_admin'] = 'Дељени тајни кључ';
$string['password_admin_help'] = 'Дељени тајни кључ може да се посматра као лозинка која се користи за проверу идентитета приликом приступа алату. Њега треба да обезбеди провајдер алата заједно са корисничким кључем.

Алати који не траже безбедну комуникацију са Moodeom и не пружају додатне сервисе (као што је извештај о оценама), не морају да захтевају дељени тајни кључ.';
$string['password_help'] = 'За претходно конфигурисане алате, није неопходно да се овде унесе дељени тајни кључ, пошто ће он већ бити обезбеђен као део процеса конфигурације.

Ово поље треба попунити ако се креира веза ка провајдеру алата који није претходно конфигурисан. Ако провајдер алата треба да се користи више пута на овом курсу, додавање конфигурације алата је добра идеја.

Дељени тајни кључ може да се посматра као лозинка која се користи за проверу идентитета приликом приступа алату. Кôд треба да обезбеди провајдер алата заједно са корисничким кључем.

Алати који не траже безбедну комуникацију са Moodeom и не пружају додатне сервисе (као што је извештај о оценама), не морају да захтевају дељени тајни кључ.';
$string['pending'] = 'Не чекању';
$string['pluginadministration'] = 'Администрација екстерних алата';
$string['pluginname'] = 'Екстерни алат';
$string['preferheight'] = 'Преферирана висина';
$string['preferwidget'] = 'Преферирано покретање додатка';
$string['preferwidth'] = 'Преферирана ширина';
$string['press_to_submit'] = 'Притисните да бисти покренули ову активност';
$string['privacy'] = 'Приватност';
$string['privacy:metadata:coursefullname'] = 'Пуно назив курса којем корисник приступа кроз LTI Consumer';
$string['privacy:metadata:courseid'] = 'Идентификатор курса којем корисник приступа кроз LTI Consumer';
$string['privacy:metadata:courseidnumber'] = 'Идентификациони број курса којем корисник приступа кроз LTI Consumer';
$string['privacy:metadata:courseshortname'] = 'Кратки назив курса којем корисник приступа кроз LTI Consumer';
$string['privacy:metadata:createdby'] = 'Корисник који је креирао запис';
$string['privacy:metadata:email'] = 'Адреса е-поште корисника који приступа LTI кориснику сервиса';
$string['privacy:metadata:externalpurpose'] = 'LTI корисник сервиса пружа информације о кориснику и контекст LTI провајдеру алата';
$string['privacy:metadata:firstname'] = 'Име корисника који приступа LTI кориснику сервиса';
$string['privacy:metadata:fullname'] = 'Име и презиме корисника који приступа LTI кориснику сервиса';
$string['privacy:metadata:lastname'] = 'Презиме корисника који приступа LTI кориснику сервиса';
$string['privacy:metadata:lti_submission'] = 'Завршена активности на екстерном LTI алату';
$string['privacy:metadata:lti_submission:datesubmitted'] = 'Временска ознака показује када је завршена активност на екстерном алату';
$string['privacy:metadata:lti_submission:dateupdated'] = 'Временска ознака показује када је измењена активност на екстерном алату';
$string['privacy:metadata:lti_submission:gradepercent'] = 'Оцена за корисника као проценат';
$string['privacy:metadata:lti_submission:originalgrade'] = 'Оригинална оцена за корисника';
$string['privacy:metadata:lti_submission:userid'] = 'ID ознака корисника који завршио LTI активност';
$string['privacy:metadata:lti_tool_proxies'] = 'LTI проксији';
$string['privacy:metadata:lti_tool_proxies:name'] = 'Назив LTI проксија';
$string['privacy:metadata:lti_types'] = 'LTI типови';
$string['privacy:metadata:lti_types:name'] = 'Назив LTI типа';
$string['privacy:metadata:role'] = 'Улога на курсу за корисника који приступа LTI кориснику сервиса';
$string['privacy:metadata:timecreated'] = 'Време када је запис креиран';
$string['privacy:metadata:timemodified'] = 'Време када је запис измењен';
$string['privacy:metadata:userid'] = 'ID ознака корисника који приступа LTI кориснику сервиса';
$string['privacy:metadata:useridnumber'] = 'ID број корисника који приступа LTI кориснику сервиса';
$string['privacy:metadata:username'] = 'Корисничко име корисника који приступа LTI кориснику сервиса';
$string['publickey'] = 'Јавни кључ';
$string['publickey_help'] = 'Јавни кључ  (у PEM формату) који обезбеђује алат како би се омогућила провера потписа долазних порука и захтева за услугама.';
$string['quickgrade'] = 'Дозволи брзо оцењивање';
$string['quickgrade_help'] = 'Ако је омогућена ова опција, више алата може да се оцењује на једној страници. Додајте оцене и коментаре а затим кликните на дугме "Сачувај све моје повратне информације" како бисте сачували све промене на тој страници.';
$string['redirect'] = 'Бићете преусмерени за неколико секунди. Ако се то не догоди притисните дугме.';
$string['redirectionuris'] = 'Јединствени индентификатор(и) ресурса (URI) за преусмеравање';
$string['redirectionuris_help'] = 'Списак јединствених индентификатора ресурса (по један у сваком реду) које алат користи приликом креирања захтева за ауторизацију. Најмање један URI мора бити регистрован како би порука могла да буде успешно послата алату.';
$string['register'] = 'Пријави се';
$string['registertype'] = 'Конфигуришите пријаву за нови екстерни алат';
$string['register_warning'] = 'Изгледа да је страници за пријаву потребно време како би се отворила. Ако се страница не појави, проверите да ли сте унели исправну URL адресу у конфигурационим подешавањима. Ако Moodle користи https протокол, проверите да алат који конфигуришете подржава https протокол, као и да ли у URL адреси користите https.';
$string['registrationname'] = 'Назив провајдера алата';
$string['registrationname_help'] = 'Унесите назив провајдера алата  за који се пријављујете.';
$string['registration_options'] = 'Опције за пријаву';
$string['registrationurl'] = 'URL адреса за пријаву';
$string['registrationurl_help'] = 'URL адреса за пријаву треба да буде доступна од стране провајдера алата као адреса на коју треба да се пошаље захтев за пријаву.';
$string['reject'] = 'Одбиј';
$string['rejected'] = 'Одбијено';
$string['resource'] = 'Ресурс';
$string['resourcekey'] = 'Кориснички кључ';
$string['resourcekey_admin'] = 'Кориснички кључ';
$string['resourcekey_admin_help'] = 'Кориснички кључ може да се посматра као корисничко име које се користи за проверу идентитета приликом приступа алату. 
Провајдер алата може користити кључ како би обезбедио јединствену идентификацију Moodle сајта са којег корисници покрећу алат.

Кориснички кључ мора да обезбеди провајдер алата. Начин добијања кључа се разликује међу провајдерима. То може бити аутоматизовани процес или може захтевати дијалог са провајдером алата.

Алати који не траже безбедну комуникацију са Moodeom и не пружају додатне сервисе (као што је извештај о оценама), не морају да захтевају кориснички кључ.';
$string['resourcekey_help'] = 'За претходно конфигурисане алате, није неопходно да се овде унесе кључ ресурса, пошто ће он већ бити обезбеђен као део процеса конфигурације.

Ово поље треба попунити ако се креира веза ка провајдеру алата који није претходно конфигурисан. Ако провајдер алата треба да се користи више пута на овом курсу, додавање конфигурације алата је добра идеја.

Кориснички кључ може да се посматра као корисничко име које се користи за проверу идентитета приликом приступа алату. 
Провајдер алата може користити кључ како би обезбедио јединствену идентификацију Moodle сајта са којег корисници покрећу алат.

Кориснички кључ мора да обезбеди провајдер алата. Начин добијања кључа се разликује међу провајдерима. То може бити аутоматизовани процес или може захтевати дијалог са провајдером алата.

Алати који не траже безбедну комуникацију са Moodeom и не пружају додатне сервисе (као што је извештај о оценама), не морају да захтевају кориснички кључ.';
$string['resourceurl'] = 'URL адреса ресурса';
$string['return_to_course'] = 'Кликни на <a href="{$a->link}" target="_top">here</a> за повратак на курс';
$string['saveallfeedback'] = 'Сачувај све моје повратне информације';
$string['search:activity'] = 'Екстерни алат - информације о активности';
$string['secure_icon_url'] = 'Безбедна иконица URL адресе';
$string['secure_icon_url_help'] = 'Слично иконици URL адресе, али се користи ако се сајту приступа путем SSL протокола. Главна намена овог поља је да спречи веб читач да шаље упозорења о небезбедној слици.';
$string['secure_launch_url'] = 'Безбедна URL адреса алата';
$string['secure_launch_url_help'] = 'Иако слична обичној, безбедна URL адреса алата се користи ако је неопходан виши ниво безбедности. Moodle ће користити безбедну URL адресу алата уколико се Moodle сајту приступа преко SSL протокола, или ако је конфигурација алата подешена тако да се он увек покреће путем SSL-а.

URL адреса алата се може, такође, подесити као https адреса, како би се екстерни алат приморао на покретање путем SSL протокола. У том случају ово поље може остати празно.';
$string['selectcontent'] = 'Изабери садржај';
$string['send'] = 'Пошаљи';
$string['services'] = 'Сервиси';
$string['services_help'] = 'Изаберите оне сервисе које желите да понудите провајдеру алата. Може се изабрати више од једног сервиса.';
$string['setupoptions'] = 'Опције за подешавање';
$string['share_email'] = 'Подели е-адресу корисника са провајдером алата';
$string['share_email_admin'] = 'Подели е-адресу корисника са провајдером алата';
$string['share_email_admin_help'] = 'Наведите да ли е-адресу корисника који покреће алат треба делити са провајдером..
Провајдер може да тражи е-адресе корисника који су покренули алат како би разликовао кориснике са истим именом или како би корисницима слао е-пошту зависно од акција унутар алата.';
$string['share_email_help'] = 'Наведите да ли е-адресу корисника који покреће алат треба делити са провајдером.

Провајдер може да тражи е-адресе корисника који су покренули алат како би разликовао кориснике са истим именом или како би корисницима слао е-пошту зависно од акција унутар алата.

Имајте у виду да се ово подешавање може изменити у конфигурацији алата.';
$string['share_name'] = 'Подели име корисника са провајдером алата';
$string['share_name_admin'] = 'Подели име корисника са провајдером алата';
$string['share_name_admin_help'] = 'Наведите да ли треба да се дели пуно име корисника, који покреће алат, са провајдером алата.
Провајдер може да тражи име корисника који је покренуо алат, како би приказао смислене информације унутар алата.';
$string['share_name_help'] = 'Наведите да ли треба да се дели пуно име корисника који покреће алат са провајдером алата.

Провајдер може да тражи име корисника који је покренуо алат, како би приказао смислене информације унутар алата.

Имајте у виду да се ово подешавање може изменити у конфигурацији алата.';
$string['share_roster'] = 'Дозволи алату приступ списку учесника курса';
$string['share_roster_admin'] = 'Алат може да приступи списку учесника курса';
$string['share_roster_admin_help'] = 'Наведите да ли алат може да приступи списку учесника уписаних на курсеве у оквиру којих је овај алат покренут.';
$string['share_roster_help'] = 'Наведите да ли алат може да приступи списку учесника уписаних на овај курс.

Имајте у виду да се ово подешавање може изменити у конфигурацији алата.';
$string['show_in_course_activity_chooser'] = 'Прикажи у бирачу активности и као преконфигурисани алат';
$string['show_in_course_lti1'] = 'Коришћење подешавања алата';
$string['show_in_course_lti1_help'] = 'Овај алат може бити приказан у бирачу активности, како би предавч могао да га изабере и дода на курс. Алтернативно, алат може бити приказан у падајућем менију преконфигурисаног алата приликом додавања екстерног алата на курс. Осим тога, могуће је да се конфигурација алата користи само ако се унесе тачна URL адреса алата, приликом додавања екстерног алата на курс.';
$string['show_in_course_lti2'] = 'Коришћење подешавања алата';
$string['show_in_course_lti2_help'] = 'Овај алат може бити приказан у бирачу активности, како би предавач могао да га изабере и дода на курс или у падајућем менију преконфигурисаног алата приликом додавања екстерног алата на курс.';
$string['show_in_course_no'] = 'Не приказуј; користи само када је унета одговарајућу URL адреса';
$string['show_in_course_preconfigured'] = 'Прикажи као преконфигурисани алат приликом додавања екстерног алата';
$string['size'] = 'Параметри величине';
$string['submission'] = 'Завршна активност на екстерном алату';
$string['submissions'] = 'Завршене активности на екстерном алату';
$string['submissionsfor'] = 'Завршене активности на екстерном алату за {$a}';
$string['subplugintype_ltiresource'] = 'Ресурс LTI сервиса';
$string['subplugintype_ltiresource_plural'] = 'Ресурси LTI сервиса';
$string['subplugintype_ltiservice'] = 'LTI сервис';
$string['subplugintype_ltiservice_plural'] = 'LTI сервиси';
$string['subplugintype_ltisource'] = 'LTI извор';
$string['subplugintype_ltisource_plural'] = 'LTI извори';
$string['successfullycreatedtooltype'] = 'Нови алат успешно креиран!';
$string['successfullyfetchedtoolconfigurationfromcontent'] = 'Успешно преузета конфигурација алата од стране изабраног садржаја.';
$string['toggle_debug_data'] = 'Укључи/искључи податке о отклањању грешака';
$string['tool_config_not_found'] = 'За ову URL адресу није пронађена конфигурација алата.';
$string['tooldescription'] = 'Опис алата';
$string['tooldescription_help'] = 'Опис алата који ће бити приказан предавачима на списку активности.

Он треба да опише чему служи алат, шта ради као и да пружи све додатне информације које предавач треба да зна.';
$string['tooldetailsaccesstokenurl'] = 'URL адреса токена за приступ';
$string['tooldetailsauthrequesturl'] = 'URL адреса захтева за проверу идентитета';
$string['tooldetailsclientid'] = 'ID ознака клијента';
$string['tooldetailsdeploymentid'] = 'ID ознака покретања алата';
$string['tooldetailsmailtosubject'] = 'Конфигурација LTI алата';
$string['tooldetailsmodalemail'] = 'Адреса е-поште';
$string['tooldetailsmodallink'] = 'Погледајте детаље о конфигурацији';
$string['tooldetailsmodaltitle'] = 'Детаљи о конфигурацији алата';
$string['tooldetailsplatformid'] = 'ID ознака платформе';
$string['tooldetailspublickeyseturl'] = 'URL адреса скупа јавних кључева';
$string['toolisbeingused'] = 'Овај алат је искоришћен {$a} пут/a';
$string['toolisnotbeingused'] = 'Овај алат још није коришћен';
$string['toolproxy'] = 'Пријаве за екстерне алате';
$string['toolproxy_help'] = 'Пријава за екстерни алат омогућава администратору Moodle сајта да конфигурише екстерне алате из проксија алата добијеног од провајдера алата који подржава LTI 2.0 стандард. URL адреса за пријаву коју обезбеђује провајдер алата је све што је неопходно како би се започео процес пријављивања. Својства и сервиси који се нуде провајдеру алата су изабрани када се конфигурише нова пријава.

Пријаве за алате који су приказани на овој страници су разврстане у четири категорије:

* **Конфигурисано** - Ове пријаве за алате су подешене али процес пријаве још увек није започет.
* **На чекању** - Процес пријаве за ове алатке је започео али није завршен. Отворите и сачувајте  подешавања како бисте пријаву вратили назад у категорију \'Конфигурисано\'.
* **Прихваћено** - Ове пријаве за алате су одобрене; ресурси наведени у проксију алата ће се појавити страници са преконфигурисаним алатима са почетним статусом \'На чекању\'.
* **Одбијено** - Ове пријаве за алате су оне које су одбијене током процеса пријављивања. Отворите и сачувајте  подешавања како бисте пријаву вратили назад у категорију \'Конфигурисано\', тако да процес пријаве да почне испочетка.';
$string['toolproxyregistration'] = 'Пријава за екстерни алат';
$string['toolregistration'] = 'Пријава за екстерни алат';
$string['tool_settings'] = 'Подешавања алата';
$string['toolsetup'] = 'Конфигурација екстерног алата';
$string['tooltypeadded'] = 'Преконфигурисани алат додат';
$string['tooltypedeleted'] = 'Преконфигурисани алат обрисан';
$string['tooltypenotdeleted'] = 'Није могуће обрисати преконфигурисани алат';
$string['tooltypes'] = 'Алати';
$string['tooltypeupdated'] = 'Преконфигурисани алат ажуриран';
$string['toolurl'] = 'URL адреса алата';
$string['toolurl_contentitemselectionrequest'] = 'URL адреса за Избор садржаја';
$string['toolurl_contentitemselectionrequest_help'] = 'URL адреса за Избор садржаја ће се користити за покретање странице за избор садржаја од провајдера алата. Ако је празно, користиће се URL адреса алата';
$string['toolurl_help'] = 'URL адреса алата се користи како би се URL адреса упарила са исправном конфигурацијом алата. Употреба префикса http(s), на почетку адресу, није обавезна.

Осим тога, основна URL адреса се користи као URL адреса алата ако ова није наведена у инстанци екстерног алата.

На пример, основна URL адреса за *tool.com* треба да одговара некој од следећих адреса:

* tool.com
* tool.com/quizzes
* tool.com/quizzes/quiz.php?id=10
* www.tool.com/quizzes

Основна URL адреса за *www.tool.com/quizzes* треба да одговара некој од следећих адреса:

* www.tool.com/quizzes
* tool.com/quizzes
* tool.com/quizzes/take.php?id=10

Основна URL адреса за *quiz.tool.com* треба да одговара некој од следећих адреса:

* quiz.tool.com
* quiz.tool.com/take.php?id=10

Уколико постоје две различите конфигурације алата за исти домен, користиће се она са најпрецизнијом адресом.

Можете, такође, да уметнете URL адресу кертриџа ако је имате, и детаљне информације о алату ће се аутоматски попунити.';
$string['toolurlplaceholder'] = 'URL адреса алата...';
$string['typename'] = 'Назив алата';
$string['typename_help'] = 'Назив алата се користи за идентификацију провајдера алата унутар Moodlea. Назив који се унесе биће видљив предавачима када додају екстерне алате унутар курса.';
$string['types'] = 'Типови';
$string['unabletocreatetooltype'] = 'Није могуће креирати алат';
$string['unabletofindtooltype'] = 'Није могуће пронаћи алат за {$a->id}';
$string['unknownstate'] = 'Непознати статус';
$string['update'] = 'Ажурирај';
$string['useraccountinformation'] = 'Информације о корисничком налогу';
$string['userpersonalinformation'] = 'Личне информације о кориснику';
$string['using_tool_cartridge'] = 'Коришћење кертриџа алата';
$string['using_tool_configuration'] = 'Коришћење конфигурације алата';
$string['validurl'] = 'Исправна URL адреса мора почети са http(s)://';
$string['viewsubmissions'] = 'Приказ завршених активности и екран за оцењивање';
