<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_adaptable', language 'es', branch 'MOODLE_37_STABLE'
 *
 * @package   theme_adaptable
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutme'] = 'Sobre mí';
$string['actingasrole'] = 'Actualmente estás actuando como un rol diferente';
$string['activebreadcrumb'] = 'Color de fondo de la ruta de navegación activa';
$string['activebreadcrumbdesc'] = 'Establece el color de fondo de la ruta de navegación activa.';
$string['activitiesheading'] = 'Actividades';
$string['alertaccess'] = 'Visibilidad de la Alerta';
$string['alertaccessadmins'] = 'Visible para administradores';
$string['alertaccessdesc'] = 'Establece la visibilidad de la Alerta según su tipo. Nota: Si se usa "Añadir restricción por campo personalizado" necesitrás añadir el campo personalizado de usuario.';
$string['alertaccessglobal'] = 'Visible para todo el mundo';
$string['alertaccessprofile'] = 'Añadir restricción por campo personalizado';
$string['alertaccessusers'] = 'Visible para usuarios';
$string['alertannounce'] = 'Anuncio';
$string['alertannouncedesc'] = 'Muestra un anuncio en la zona de alerta.';
$string['alertbackgroundcolorinfo'] = 'Color de fondo de la información';
$string['alertbackgroundcolorinfodesc'] = 'Color de fondo de los cuadros de información';
$string['alertbackgroundcolorsuccess'] = 'Color de fondo del aviso';
$string['alertbackgroundcolorsuccessdesc'] = 'Color de fondo de los cuadros de avisos';
$string['alertbackgroundcolorwarning'] = 'Color de fondo de la advertencia';
$string['alertbackgroundcolorwarningdesc'] = 'Color de fondo de los cuadros de advertencia';
$string['alertbordercolorinfo'] = 'Color del borde';
$string['alertbordercolorinfodesc'] = 'Color de borde de los cuadros de alerta';
$string['alertbordercolorsuccess'] = 'Color de borde de los avisos';
$string['alertbordercolorsuccessdesc'] = 'Color de borde de los cuadros de avisos';
$string['alertbordercolorwarning'] = 'Color de borde de la advertencia';
$string['alertbordercolorwarningdesc'] = 'Color de borde de los cuadros de advertencia';
$string['alertcolorinfo'] = 'Color de información';
$string['alertcolorinfodesc'] = 'Color del icono de los cuadros de información';
$string['alertcolorsheading'] = 'Personalizar los cuadros de alerta superiores';
$string['alertcolorsheadingdesc'] = 'Establecer colores e iconos.';
$string['alertcolorsuccess'] = 'Color del aviso';
$string['alertcolorsuccessdesc'] = 'Color del icono de los cuadros de avisos';
$string['alertcolorwarning'] = 'Color de advertencia';
$string['alertcolorwarningdesc'] = 'Color del icono de los cuadros de advertencia';
$string['alertcount'] = 'Contador de Alertas';
$string['alertcountdesc'] = 'Número de alertas a crear a continuación.';
$string['alertdesc'] = 'Introduce y personaliza el texto de las Alertas mostradas en la parte superior de la pantalla. Es posible crear más de una para mostrarse a diferentes tipos de usuarios. También existe la opción de mostrar las alertas en la página inicial y en las páginas de los cursos.';
$string['alertdisabled'] = 'Desactivado';
$string['alertdisabledesc'] = 'Desactivar esta alerta.';
$string['alerthiddencourse'] = 'Advertencia de curso oculto';
$string['alerthiddencoursedesc'] = 'Mostrar una alerta en la página del curso si este está oculto';
$string['alerthiddencoursetext-1'] = 'Este curso está oculto y los estudiantes no pueden acceder a él.';
$string['alerthiddencoursetext-2'] = 'Haga clic aquí para actualizar la configuración';
$string['alerticoninfo'] = 'Icono de información';
$string['alerticoninfodesc'] = 'Establecer los<a href="http://fortawesome.github.io/Font-Awesome/icons/"> Iconos de Font Awesome</a> que serán utilizados en los cuadros de información. Introduzca el nombre del icono sin el prefijo fa-.';
$string['alerticonsuccess'] = 'Icono de aviso';
$string['alerticonsuccessdesc'] = 'Establecer los<a href="http://fortawesome.github.io/Font-Awesome/icons/"> Iconos de Font Awesome</a> que serán utilizados en los cuadros de aviso de. Introduzca el nombre del icono sin el prefijo fa-.';
$string['alerticonwarning'] = 'Icono de advertencia';
$string['alerticonwarningdesc'] = 'Establecer los<a href="http://fortawesome.github.io/Font-Awesome/icons/"> Iconos de Font Awesome</a> que serán utilizados en los cuadros de advertencia. Introduzca el nombre del icono sin el prefijo fa-.';
$string['alertinfo'] = 'Info';
$string['alertinfodesc'] = 'Muestra información en la zona de alerta.';
$string['alertkeyvalue'] = 'Clave de identificación de la Alerta';
$string['alertkeyvalue_details'] = 'Esta clave identifica la alerta y permite el control de la eliminación de la alerta en la pantalla por parte del usuario. Si se cambia la clave, los usuarios volverán a ver la alerta de nuevo.';
$string['alertprofilefield'] = 'Campo de usuario personalizado Nombre=Valor (opcional)';
$string['alertprofilefielddesc'] = 'Añade una regla de acceso usando un campo de perfil personalizado. Ejemplo: "usertype=alumno"';
$string['alertsettings'] = 'Alerta {$a}';
$string['alertsettingscourse'] = 'Configuración de las alertas del curso';
$string['alertsettingsgeneral'] = 'Configuración Alertas';
$string['alertsettingsheading'] = 'Personalizar las Alertas';
$string['alerttext'] = 'Texto de la Alerta';
$string['alerttextdesc'] = 'Introduce el texto a mostrar en la alerta.';
$string['alerttype'] = 'Tipo de Alerta';
$string['alerttypedesc'] = 'Selecciona el tipo de alerta: info (azul), aviso (amarillo) o anuncio (verde)';
$string['alertwarning'] = 'Aviso';
$string['alertwarningdesc'] = 'Muestra un aviso en la zona de alerta.';
$string['analyticscount'] = 'Número de campos de perfil';
$string['analyticscountdesc'] = 'Número de campos personalizados a introducir en el área inferior.';
$string['analyticsprofilefield'] = 'Nombre del campo personalizado del perfíl Field Name=Value (opcional)';
$string['analyticsprofilefielddesc'] = 'Añade una regla de acceso usando un campo de perfil personalizado. Ejemplo: usertype=alumno';
$string['analyticssettings'] = 'Analítica Web';
$string['analyticssettingsdesc'] = 'Puedes configurar múltiples códigos para Google Analytics y enlazarlos con diversos campos personalizados.';
$string['analyticssettingsheading'] = 'Configurar Google Analytics';
$string['analyticstext'] = 'Analytics ID';
$string['analyticstextdesc'] = 'Introducir la ID de Google Analytics.';
$string['anonymizega'] = 'Anonimizar la IP del usuario';
$string['anonymizegadesc'] = 'Anonimizar la IP del usuario remitido a Google Analytics';
$string['answered'] = 'Respondido';
$string['attempted'] = 'Intentado';
$string['backcolor'] = 'Color de fondo';
$string['backcolordesc'] = 'Establece el color de fondo de la plantilla.';
$string['bcustyle'] = 'Estilo BCU';
$string['beta'] = 'VERSIÓN EN DESARROLLO. NO USAR EN SITIOS EN PRODUCCIÓN';
$string['blockbackgroundcolor'] = 'Color de fondo de los bloques';
$string['blockbackgroundcolordesc'] = 'Establece el color de fondo de los bloques.';
$string['blockbordercolor'] = 'Color del borde de los bloques';
$string['blockbordercolordesc'] = 'Establece el color del borde de los bloques.';
$string['blockheaderbackgroundcolor'] = 'Color del texto de los encabezados de los bloques';
$string['blockheaderbackgroundcolordesc'] = 'Establece el color del texto de los encabezados de los bloques.';
$string['blockheaderborderbottom'] = 'Grueso del borde inferior de los bloques';
$string['blockheaderborderbottomdesc'] = 'Establece el grosor del borde inferior de los bloques.';
$string['blockheaderborderleft'] = 'Grueso del borde izquierdo de los bloques';
$string['blockheaderborderleftdesc'] = 'Establece el grosor del borde izquierdo de los bloques.';
$string['blockheaderborderright'] = 'Grueso del borde derecho de los bloques';
$string['blockheaderborderrightdesc'] = 'Establece el grosor del borde derecho de los bloques.';
$string['blockheaderbordertop'] = 'Grueso del borde superior de los bloques';
$string['blockheaderbordertopdesc'] = 'Establece el grosor del borde superior de los bloques.';
$string['blockheaderbordertopstyle'] = 'Estilo del borde de los bloques';
$string['blockheaderbordertopstyledesc'] = 'Establece el estilo del borde de los bloques laterales.';
$string['blockheaderbottomradius'] = 'Radio de las esquinas inferiores de los bloques laterales';
$string['blockheaderbottomradiusdesc'] = 'Radio de las esquinas inferiores de los bloques laterales. Valor más alto es igual a efecto redondeado.';
$string['blockheadercolor'] = 'Color de fondo de la cabecera de los bloques';
$string['blockheadercolordesc'] = 'Establece el color de fondo de la cabecera de los bloques.';
$string['blockheadertopradius'] = 'Radio de las esquinas superiores de los bloques laterales';
$string['blockheadertopradiusdesc'] = 'Radio de las esquinas superiores de los bloques laterales. Valor más alto es igual a efecto redondeado.';
$string['blockicons'] = 'Mostrar iconos en los bloques';
$string['blockiconsdesc'] = 'Mostrar / Ocultar un icono relacionado con el tipo de bloque al lado del encabezamiento.';
$string['blockiconsheadersize'] = 'Tamaño del icono de cabecera de bloque';
$string['blockiconsheadersizedesc'] = 'Fijar el tamaño de la fuente del icono que se usa en la cabecera de los bloques de moodle. Seleccione un valor de la lista.';
$string['blocklayoutbuilder'] = 'Creador de regiones para bloques';
$string['blocklayoutbuilderdesc'] = 'A continuación puedes crear tu propia distribución de regiones para los bloques de moodle en la página principal.
Para añadir contenido a estas regiones necesitarás <strong>Activar edición en la página principal de Moodle</strong>.
Entonces podrás arrastras y soltar los bloques en las regiones creadas.';
$string['blocklayoutlayoutcheck'] = 'Comprueba la distribución';
$string['blocklayoutlayoutcheckdesc'] = 'Utiliza esta opción para ver la distribución creada y comprobar el número de bloques que has utilizado.';
$string['blocklayoutlayoutcount1'] = 'Puedes crear un máximo de';
$string['blocklayoutlayoutcount2'] = 'regiones para bloques. Ahora estás usando:';
$string['blocklayoutlayoutrow'] = 'Filas de regiones para bloques';
$string['blocklayoutlayoutrowdesc'] = 'Añade / establece la distribución de filas de las regiones para bloques de la página principal.';
$string['blockmainborderbottom'] = 'Grueso del borde inferior del bloque central';
$string['blockmainborderbottomdesc'] = 'Establece el grosor del borde inferior del bloque central.';
$string['blockmainborderleft'] = 'Grueso del borde izquierdo del bloque central';
$string['blockmainborderleftdesc'] = 'Establece el grosor del borde izquierdo del bloque central.';
$string['blockmainborderright'] = 'Grueso del borde derecho del bloque central';
$string['blockmainborderrightdesc'] = 'Establece el grosor del borde derecho del bloque central.';
$string['blockmainbordertop'] = 'Grueso del borde superior del bloque central';
$string['blockmainbordertopdesc'] = 'Establece el grosor del borde superior del bloque central.';
$string['blockmainbordertopstyle'] = 'Estilo del borde del bloque central';
$string['blockmainbordertopstyledesc'] = 'Establece el estilo del borde de los bloques centrales.';
$string['blockmainbottomradius'] = 'Radio de las esquinas inferiores de los bloques centrales';
$string['blockmainbottomradiusdesc'] = 'Radio de las esquinas inferiores de los bloques centrales. Valor más alto es igual a efecto redondeado.';
$string['blockmaintopradius'] = 'Radio de las esquinas superiores de los bloques centrales';
$string['blockmaintopradiusdesc'] = 'Radio de las esquinas superiores de los bloques centrales. Valor más alto es igual a efecto redondeado.';
$string['blockregionbackground'] = 'Color de fondo de las regiones para bloques';
$string['blockregionbackgrounddesc'] = 'Establece el color de fondo del contenedor del constructor de bloques de la página principal.';
$string['blocksettings'] = 'Bloques';
$string['blockside'] = 'Posición de los bloques';
$string['blocksidedesc'] = 'Mostrar los bloques en la columna derecha o izquierda.';
$string['breadcrumb'] = 'Ruta de navegación';
$string['breadcrumbbackgroundcolor'] = 'Color de fondo de la ruta de navegación';
$string['breadcrumbbackgroundcolordesc'] = 'Seleccionar el color de fondo de la ruta de navegación';
$string['breadcrumbdisplay'] = 'Visualización de la ruta de navegación';
$string['breadcrumbdisplaydesc'] = 'Establezca la visualización de lo que debería estar en el área de la ruta de exploración en un curso';
$string['breadcrumbhome'] = 'Inicio de la ruta de navegación';
$string['breadcrumbhomedesc'] = 'Muestra el inicio de la ruta de navegación como icono o como texto.';
$string['breadcrumbhomeicon'] = 'Icono';
$string['breadcrumbhometext'] = 'Texto';
$string['breadcrumbseparator'] = 'Separador de la ruta de navegación';
$string['breadcrumbseparatordesc'] = 'Establece el icono de  <a href="http://fortawesome.github.io/Font-Awesome/icons/" target="_blank">Font Awesome Icon</a> para ser usado como separador de los elementos de laruta de navegación. Introducir el nombre del icono sin el prefijo fa-.';
$string['breadcrumbtextcolor'] = 'Color del texto de la ruta de navegación';
$string['breadcrumbtextcolordesc'] = 'Establece el color del texto de la ruta de navegación.';
$string['breadcrumbtitle'] = 'Nombre del curso en la guía de exploración';
$string['breadcrumbtitledesc'] = 'Establece el modo de visualización del título del curso en la guía de exploración.';
$string['bs4all'] = 'Muy pequeño - Muy grande';
$string['bs4extralarge'] = 'Muy grande únicamente';
$string['bs4large'] = 'Grande - Muy grande';
$string['bs4medium'] = 'Mediano - Muy grande';
$string['bs4none'] = 'Ninguno';
$string['bs4small'] = 'Pequeño - Muy grande';
$string['buttoncancelbackgroundcolor'] = 'Color de fondo del botón Cancelar';
$string['buttoncancelbackgroundcolordesc'] = 'Color de fondo del botón Cancelar. Introduce <i>transparent</i> para transparencia.';
$string['buttoncancelcolor'] = 'Color del botón Cancelar.';
$string['buttoncancelcolordesc'] = 'Elegir el color del botón Cancelar.';
$string['buttoncolor'] = 'Colores de los botones';
$string['buttoncolorcancel'] = 'Color del botón cancelar';
$string['buttoncolordesc'] = 'El color de los botones principales.';
$string['buttoncolordesccancel'] = 'Color de fondo para el botón cancelar. <br>Escriba el nivel de transparencia en la caja para transparencia.';
$string['buttoncolordescscnd'] = 'Color para los botones secundarios utilizados en todo el sitio';
$string['buttoncolorscnd'] = 'Color del botón secundario';
$string['buttondesc'] = 'personaliza a forma y colores de los botones utilizados en la plantilla.';
$string['buttondropshadow'] = 'Efecto sombra bajo el botón';
$string['buttondropshadowdesc'] = 'Mostrar efecto sombra (sombreado) bajo el botón';
$string['buttonhovercolor'] = 'Color Hover de los botones';
$string['buttonhovercolorcancel'] = 'Color del botón cancelar (al pasar el puntero)';
$string['buttonhovercolordesc'] = 'Color del botón al pasar el cursor por encima.';
$string['buttonhovercolordesccancel'] = 'Color al que cambia el botón cancelar al pasar el puntero sobre el.<br/>Escriba el nivel de transparencia en la caja de transparencia.';
$string['buttonhovercolordescscnd'] = 'Color al que cambia el botón cancelar al pasar el puntero sobre el.';
$string['buttonhovercolorscnd'] = 'Color del botón secundario (al pasar el puntero)';
$string['buttonlogincolor'] = 'Color del botón Entrar';
$string['buttonlogincolordesc'] = 'Color del botón Entrar.';
$string['buttonloginheight'] = 'Altura del botón Entrar';
$string['buttonloginheightdesc'] = 'Altura del botón Entrar. Solo si se utiliza el formulario de entrada en la cabecera.';
$string['buttonloginhovercolor'] = 'Color Hover del botón Entrar';
$string['buttonloginhovercolordesc'] = 'Color del botón Entrar al pasar el cursos por encima.';
$string['buttonloginmargintop'] = 'Margen superior del botón Entrar';
$string['buttonloginmargintopdesc'] = 'Permite posicionar el botón Entrar si se han cambiado los valores indicados anteriormente.';
$string['buttonloginpadding'] = 'Separación del texto del botón Entrar';
$string['buttonloginpaddingdesc'] = 'Separación alrededor del texto del botón Entrar. Número más alto = Botón más grande.';
$string['buttonlogintextcolor'] = 'Color del texto del botón Entrar';
$string['buttonlogintextcolordesc'] = 'Color del texto del botón Entrar.';
$string['buttonradius'] = 'Radio de las esquinas';
$string['buttonradiusdesc'] = '0 = esquinas cuadradas. Un valor más alto es igual a esquinas más redondeadas.';
$string['buttonsettings'] = 'Botones';
$string['buttonsettingsheading'] = 'Personalizar los botones.';
$string['buttontextcolor'] = 'Color del texto de los botones';
$string['buttontextcolorcancel'] = 'Color de texto del botón cancelar';
$string['buttontextcolordesc'] = 'Color del texto de los botones.';
$string['buttontextcolordesccancel'] = 'Color del texto usado en los botones cancelar.';
$string['buttontextcolordescscnd'] = 'Color del texto usado en los botones secundarios.';
$string['buttontextcolorscnd'] = 'Color de texto del botón secundario';
$string['cachedef_userdata'] = 'El tiempo para guardar una sesión de un usuario específico.';
$string['categoryhavecustomheader'] = 'Encabezado para la categoría personalizada';
$string['categoryhavecustomheaderdesc'] = 'Seleccione las categorías de nivel superior que tendrán un encabezado personalizado. Para seleccionar más de uno o deseleccionar una categoría, use la tecla \'Ctrl\'. Guarde y actualice la página para actualizarla Nota: Las subcategorías de los seleccionados heredarán los valores de configuración.';
$string['categoryheaderbgimage'] = 'Imágen de fondo para la categoría \'{$a->name}\' con id \'{$a->id}\'';
$string['categoryheaderbgimagedesc'] = 'Establezca la imágen de fondo en el encabezado para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\'. El tamaño mínimo es 1600x180px (recomendado 1900x180px). La imágen cubrirá completamente el encabezado.';
$string['categoryheaderbgimagedescchildren'] = 'Establezca la imágen de fondo para el encabezado de la categoría \'{$a->name}\' con id \'{$a->id}\' y su hija \'{$a->children}\'. El tamaño mínimo es 1600x180px (recomendado 1900x180px). La imágen cubrirá completamente el encabezado.';
$string['categoryheadercustomcss'] = 'CSS personalizado para la categoría \'{$a->name}\' con id \'{$a->id}\'';
$string['categoryheadercustomcssdesc'] = 'Establézca un CSS personalizado para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\'. Esto generará CSS para el selector de tema con el prefijo \'.category-{$a->id}\'. Si el CSS no parece aplicarse, verifique el archivo de registro PHP.';
$string['categoryheadercustomcssdescchildren'] = 'Establézca un CSS personalizado para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\' y su hija \'{$a->children}\'. Esto generará CSS para el selector de tema con el prefijo \'.category-{$a->id}\' y todas sus hijas ids. Si el CSS no parece aplicarse, verifique el archivo de registro PHP.';
$string['categoryheadercustomtitle'] = 'Título personalizado para la categoría \'{$a->name}\' con id \'{$a->id}\'';
$string['categoryheadercustomtitledesc'] = 'Establezca un título personalizado en el encabezado para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\'. Si está en blanco, se le presentará lo que ha sido configurado por los ajustes \'Título del sitio\' y \'Texto del título del sitio\' en páginas que no son del curso o en páginas del curso cuando \'Habilitar encabezado\' está \'desactivado\'. Cuando se llena en páginas vinculadas a categorías que no son del curso, esto reemplazará el título del sitio. Cuando se complete en las páginas del curso, aparecerá sobre el título según lo establecido por la configuración \'Habilitar encabezado\'. Pero en los móviles, cualquier \'título\' solo aparecerá dependiendo de la configuración de \'Título del sitio adaptable\' se encuentra en blanco.';
$string['categoryheadercustomtitledescchildren'] = 'Establezca un título personalizado en el encabezado para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\' y su hija \'{$a->children}\'. Si está en blanco, se le presentará lo que ha sido configurado por los ajustes \'Título del sitio\' y \'Texto del título del sitio\' en páginas que no son del curso o en páginas del curso cuando \'Habilitar encabezado\' está \'desactivado\'. Cuando se llena en páginas vinculadas a categorías que no son del curso, esto reemplazará el título del sitio. Cuando se complete en las páginas del curso, aparecerá sobre el título según lo establecido por la configuración \'Habilitar encabezado\'. Pero en los móviles, cualquier \'título\' solo aparecerá dependiendo de la configuración de \'Título del sitio adaptable\' se encuentra en blanco.';
$string['categoryheaderheader'] = 'Configuración para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\'';
$string['categoryheaderheaderdesc'] = 'Establezca la configuración para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\'';
$string['categoryheaderheaderdescchildren'] = 'Establezca la configuración para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\' y su hija  \'{$a->children}\'.';
$string['categoryheaderlogo'] = 'Logo de la categoría \'{$a->name}\' con id \'{$a->id}\'';
$string['categoryheaderlogodesc'] = 'Establezca el logo en el encabezado para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\'. Tamaño recomendado 200px by 80px.';
$string['categoryheaderlogodescchildren'] = 'Establezca el logo en el encabezado para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\' y su hija \'{$a->children}\'. Tamaño recomendado 200px by 80px.';
$string['categoryheaderssettings'] = 'Encabezaos de categoría';
$string['categoryheaderssettingsdesc'] = 'Establecer configuraciones para los encabezados dentro de una categoría.';
$string['categoryheaderssettingsheading'] = 'Cambie el encabezado de una o más categorías de nivel superior e inferiores.';
$string['choosereadme'] = '<div class = "clearfix">
<div class = "well">
<h2> Adaptable </h2>
<p> <img class = "img-polaroid" src = "adaptable / pix / screenshot.png" /> < / p>
</div>
<div class = "well">
<h3> Acerca de </h3>
<p> Adaptable es un tema receptivo de 2 columnas de Moodle altamente personalizable y basado en el popular tema BCU. La versión 2 utiliza
Boost como tema base y, por lo tanto, Bootstrap 4. </p>
<p> El tema está licenciado bajo la GPL (GNU General Public License). Puede encontrar una copia completa de la licencia <a href="http://www.gnu.org/licenses/" target="_HERE"> en blanco </a> </p>
<br>
<h4> ¡Modifíquelo! - ¡Mejoralo!
- ¡Compártelo! </h4> <br>
<h3> Créditos </h3> Jeremy Hopkins (Universidad de Coventry) <br>
 <p> Este tema ha sido desarrollado por: <br>

 Fernando Acedo (<a href="https://3-bits.com" target="_blank"> 3-bits.com </a>) </p>
Manoj Solanki ( Coventry University) <br>
<br>
<h2> Otros créditos </h2>
<p> En el desarrollo de la versión 2 también han colaborado: <br>
Gareth J. Barnard (http://moodle.org/user/ profile.php? id = 442195)
Stuart Lamour
Alistair Spark (University College London)
<br>
<p> entre muchos otros desarrolladores, evaluadores, traductores y voluntarios (Ver <a href = "adaptable / README.txt" target = "_ blank "> README.txt </a>) </p>
<br>
<h3> Informe de errores </h3>
 <p> Puede informar errores (y, por favor, <b> SOLAMENTE </b> errores) en nuestros <a href = "https: // gitlab.com / 3bits / moodle-theme_adaptable2 "target =" _ blank "> repositorio </a> </p>
<br>
<h3> Soporte técnico </h3>
<p> Puede hacer sus preguntas en el foro de moodle: </p>
<ul>
<li> inglés: <a href = "https://moodle.org/mod/forum/discuss.php?d=340404" target = "_blank"> https://moodle.org/mod/forum/discuss.php?d=340404 </a>
<li> Español: <a href = "https://moodle.org/mod/forum /discuss.php?d=326804 "target =" _blank "> https://moodle.org/mod/forum/discuss.php?d=326804 </a>
<li> Català: <a href =" https: //moodle.org/mod/forum/discuss.php?d=340406 "target =" _blank "> https://moodle.org/mod/forum/discuss.php?d=340406 </a>
</ ul >
 <br>
<h3> Demo </h3>
<p> Puede ver una versión demo <a href="https://adaptable.ws/demo" target="_blank"> AQUÍ </a> </p>
</div>
</div>';
$string['colordesc'] = 'Puedes seleccionar los colores que desees para ser usados por la plantilla. Usa la notación HEX estándar. También puedes usar como valores <i>transparent</i> e <i>inherited.</i>';
$string['colorsettings'] = 'Colores';
$string['colorsettingsheading'] = 'Modifica los principales colores utilizados en la plantilla.';
$string['commonlyusedar'] = 'Actividades y recursos de uso común';
$string['commonlyusedardesc'] = 'Use este cuadro para especificar la lista de nombres de actividad / recurso (separados por comas) que desea ver en la parte superior del selector de módulos. Los posibles nombres actuales son {$a}.';
$string['commonlyusedartitle'] = 'Actividades y recursos de uso común';
$string['configtitle'] = 'Adaptable';
$string['contributed'] = 'Contribuido';
$string['course'] = 'Curso';
$string['coursepageactivitybottomblockregionheading'] = 'Región tras el bloque de actividad del curso personalizada';
$string['coursepageactivitybottomblockregionheadingdesc'] = 'Una región que aparece tras el bloque de actividades del curso.';
$string['coursepageblockactivitybottomenabled'] = 'Habilitar región tras el bloque de actividad en página del curso';
$string['coursepageblockactivitybottomenableddesc'] = 'Habilitar esta región en todas las páginas de curso.';
$string['coursepageblocklayoutbuilder'] = 'Regiones de Bloques de Página de Curso';
$string['coursepageblocklayoutbuilderdesc'] = 'Abajo puede definir su propia distribución de bloques para la página de curso.
Para añadir contenido a esta regiones deberá <strong>habilitar la edición en la página del curso de Moodle</strong>.
¡Entonces podrá arrastrar y soltar bloques en las regiones que haya creado!';
$string['coursepageblocklayoutlayoutbottomrow'] = 'Región de bloques en la fila inferior de la página de Curso';
$string['coursepageblocklayoutlayoutbottomrowdesc'] = 'Añadir / fijar distribución de una fila de bloques en la página de Curso.';
$string['coursepageblocklayoutlayouttoprow'] = 'Región de bloques en la fila superior de la página de Curso';
$string['coursepageblocklayoutlayouttoprowdesc'] = 'Añadir / fijar distribución de una fila de bloques en la página de Curso.';
$string['coursepageblockregionsettings'] = 'Constructor de regiones de bloques en la página de Curso';
$string['coursepageblocksenabled'] = 'Habilitar regiones de bloques personalizadas en página de Curso';
$string['coursepageblocksenableddesc'] = 'Puede habilitar / deshabilitar regiones de bloques personalizados (superiores e inferiores) en la página de Curso.
Luego podrá arrastrar y soltar bloques en las regiones que haya creado';
$string['coursepageblocksliderenabled'] = 'Habilitar región de bloque presentaciones personalizado en página de Curso';
$string['coursepageblocksliderenableddesc'] = 'Habilitar esta región en todas las páginas de curso.';
$string['coursepageheaderhidesitetitle'] = 'Ocultar título del sitio en páginas de curso';
$string['coursepageheaderhidesitetitledesc'] = 'Ocultar título del sitio, logotipo y barra de búsqueda en páginas de curso. Utilice esto junto con el tamaño de cabecera de página para mostrar una cabecera más compacta en páginas relacionadas con cursos.';
$string['coursepagenewssliderblockregionheading'] = 'Región de bloque de noticias personalizado';
$string['coursepagenewssliderblockregionheadingdesc'] = 'Una región de bloque personalizada diseñada para usar con el control deslizante de noticias que forma parte de la IU Adaptable. Esta región aparece encima de las actividades del curso en una página del curso. Para agregar un bloque deslizante de noticias, primero instale el <strong> <a href="https://moodle.org/plugins/block_news_slider"> control deslizante de noticias de UI adaptable </a> </ strong> y configúrelo para que aparezca en la región "región del deslizador de la página del curso" en todas las páginas del curso.';
$string['coursepagesidebarinfooterenabled'] = 'Desplazar barra lateral al pie en páginas de Cursos';
$string['coursepagesidebarinfooterenableddesc'] = 'Distribución ancha de la página de curso desplazando la barra lateral a pie de página.';
$string['coursepagesidebarinfooterenabledsection'] = 'Opciones comunes';
$string['coursepagesidebarinfooterenabledsectiondesc'] = 'Opciones comunes para la mayoría de los formatos de curso.';
$string['courses'] = 'Cursos';
$string['coursesectionactivityassignbgcolor'] = 'Color de fondo de asignación de actividad';
$string['coursesectionactivityassignbgcolordesc'] = 'Establezca el color de fondo de asignación de actividad';
$string['coursesectionactivityassignleftbordercolor'] = 'color de visualización del borde izquierdo de asignación de actividad';
$string['coursesectionactivityassignleftbordercolordesc'] = 'Establece el color del borde izquierdo.';
$string['coursesectionactivitybordercolor'] = 'Color del borde inferior Sección del curso Actividad';
$string['coursesectionactivitybordercolordesc'] = 'Establece el Color del borde inferior';
$string['coursesectionactivityborderstyle'] = 'Estilo del borde inferior de Curso Sección Actividad';
$string['coursesectionactivityborderstyledesc'] = 'Establece estilo del borde inferior de Curso Sección Actividad';
$string['coursesectionactivityborderwidth'] = 'Ancho del borde inferior de curso Sección Actividad';
$string['coursesectionactivityborderwidthdesc'] = 'Establecer el ancho del borde que aparece en la parte inferior de una actividad de la sección del curso.';
$string['coursesectionactivitycolors'] = 'Opciones de actividad de la sección del curso';
$string['coursesectionactivityforumbgcolor'] = 'Color de fondo de la actividad del foro';
$string['coursesectionactivityforumbgcolordesc'] = 'Establece el color de fondo de la actividad del foro';
$string['coursesectionactivityforumleftbordercolor'] = 'Color de visualización del borde izquierdo de la actividad del foro';
$string['coursesectionactivityforumleftbordercolordesc'] = 'Establece el color del borde izquierdo.';
$string['coursesectionactivityfurtherinformation'] = 'Página del curso más información';
$string['coursesectionactivityfurtherinformationassign'] = 'Mostrar información de asignación';
$string['coursesectionactivityfurtherinformationassigndesc'] = 'Mostrar información de asignación, como fecha de vencimiento, estado de envío. Para maestros / administradores, muestre la cantidad de presentaciones.';
$string['coursesectionactivityfurtherinformationchoice'] = 'Mostrar información de elección';
$string['coursesectionactivityfurtherinformationchoicedesc'] = 'Mostrar información de elección, como el estado de envío. Para maestros / administradores, muestre la cantidad de presentaciones.';
$string['coursesectionactivityfurtherinformationdata'] = 'Mostrar información de la base de datos';
$string['coursesectionactivityfurtherinformationdatadesc'] = 'Mostrar información de datos, como el estado de envío. Para maestros / administradores, muestre la cantidad de presentaciones.';
$string['coursesectionactivityfurtherinformationfeedback'] = 'Mostrar información de comentarios';
$string['coursesectionactivityfurtherinformationfeedbackdesc'] = 'Mostrar información de comentarios, como el estado de envío. Para maestros / administradores, muestre la cantidad de presentaciones.';
$string['coursesectionactivityfurtherinformationlesson'] = 'Mostrar información de la lección';
$string['coursesectionactivityfurtherinformationlessondesc'] = 'Mostrar información de la lección, como el estado de envío. Para maestros / administradores, muestre la cantidad de presentaciones.';
$string['coursesectionactivityfurtherinformationquiz'] = 'Mostrar información del cuestionario';
$string['coursesectionactivityfurtherinformationquizdesc'] = 'Mostrar información de la prueba, como el estado de envío. Para maestros / administradores, muestre la cantidad de presentaciones.';
$string['coursesectionactivityheadingcolour'] = 'Curso Sección Actividad Título Color';
$string['coursesectionactivityheadingcolourdesc'] = 'El color de las actividades en las que se puede hacer clic que se muestran en la página de inicio del curso.';
$string['coursesectionactivityiconsize'] = 'Tamaño del icono de la actividad de la sección del curso';
$string['coursesectionactivityiconsizedesc'] = 'Establezca el tamaño del icono para actividades / recursos (por ejemplo, un valor de 16px lo establecerá en 16px x 16px)';
$string['coursesectionactivityleftborderwidth'] = 'Curso Sección Actividad Ancho del borde izquierdo';
$string['coursesectionactivityleftborderwidthdesc'] = 'Establezca el ancho del borde que aparece a la izquierda de una actividad de la sección del curso.';
$string['coursesectionactivitymarginbottom'] = 'Intervalo de actividad del margen inferior.';
$string['coursesectionactivitymarginbottomdesc'] = 'Espaciado del margen inferior entre actividades.';
$string['coursesectionactivitymargintop'] = 'Espaciado de actividad del margen superior';
$string['coursesectionactivitymargintopdesc'] = 'Espaciado de margen superior entre actividades';
$string['coursesectionactivityquizbgcolor'] = 'Color de fondo de actividad de prueba';
$string['coursesectionactivityquizbgcolordesc'] = 'Establezca el color de fondo de la actividad Prueba.';
$string['coursesectionactivityquizleftbordercolor'] = 'Actividad de prueba color de visualización del borde izquierdo';
$string['coursesectionactivityquizleftbordercolordesc'] = 'Establece el color del borde izquierdo.';
$string['coursesectionactivityuseadaptableicons'] = 'Usar conjunto de iconos del tema "Adaptable"';
$string['coursesectionactivityuseadaptableiconsdesc'] = 'Active esto para usar iconos del tema Adaptable. Si está desactivado, asegúrese de eliminar los directorios adaptable/pix_plugins y adaptable/pix_core/fpara usar los iconos predeterminados de Moodle.';
$string['coursesectionbgcolor'] = 'Antecedentes de la sección del curso';
$string['coursesectionbgcolordesc'] = 'Establece el color de fondo de la sección del curso.';
$string['coursesectionbordercolor'] = 'Color del borde de la sección';
$string['coursesectionbordercolordesc'] = 'Establece el color del borde de la sección del curso.';
$string['coursesectionborderradius'] = 'Radio del borde de la sección';
$string['coursesectionborderradiusdesc'] = 'Establece el radio del borde de las esquinas de la sección del curso.';
$string['coursesectionborderstyle'] = 'Estilo del borde de la sección del curso';
$string['coursesectionborderstyledesc'] = 'Establece el estilo del borde de la sección del curso.';
$string['coursesectionborderwidth'] = 'Grueso del borde de la sección';
$string['coursesectionborderwidthdesc'] = 'Establece el grueso del borde de la sección del curso.';
$string['coursesectionheaderbg'] = 'Color de fondo de la cabecera';
$string['coursesectionheaderbgdesc'] = 'Establece el color de fondo de la cabecera de la sección del curso.';
$string['coursesectionheaderbordercolor'] = 'Color del borde inferior de la cabecera';
$string['coursesectionheaderbordercolordesc'] = 'Establece el color del borde inferior de la cabecera de la sección del curso.';
$string['coursesectionheaderborderradiusbottom'] = 'Radio de las esquinas del borde inferior de la cabecera';
$string['coursesectionheaderborderradiusbottomdesc'] = 'Establece el radio de las esquinas del borde inferior de la cabecera de la sección del curso.';
$string['coursesectionheaderborderradiustop'] = 'Radio de las esquinas del borde superior de la cabecera';
$string['coursesectionheaderborderradiustopdesc'] = 'Establece el radio de las esquinas del borde superior de la cabecera de la sección del curso.';
$string['coursesectionheaderborderstyle'] = 'Estilo del borde inferior de la cabecera';
$string['coursesectionheaderborderstyledesc'] = 'Establece el estilo del borde inferior de la cabecera de la sección del curso.';
$string['coursesectionheaderborderwidth'] = 'Grueso del borde inferior de la cabecera';
$string['coursesectionheaderborderwidthdesc'] = 'Establece el grueso del borde inferior de la cabecera de la sección del curso.';
$string['coursesections'] = 'Secciones del curso';
$string['coursesettings'] = 'Secciones del curso';
$string['coursesettingsdesc'] = 'Personalice algunos de los formatos de curso más utilizados en Moodle para adaptarlos al diseño principal.';
$string['coursesettingsheading'] = 'Configuración de las secciones del curso.';
$string['coursetitlefullname'] = 'Nombre completo del curso';
$string['coursetitlemaxwidth'] = 'Ancho máximo del título del curso';
$string['coursetitlemaxwidthdesc'] = 'Establece el ancho máximo del área donde se muestra el título del curso.';
$string['coursetitlepaddingleft'] = 'Separación izquierda del título del curso';
$string['coursetitlepaddingleftdesc'] = 'Permite ajustar la separación, en píxeles, de la parte izquierda del título del curso.';
$string['coursetitlepaddingtop'] = 'Separación superior del título del curso';
$string['coursetitlepaddingtopdesc'] = 'Permite ajustar la separación, en píxeles, de la parte superior del título del curso.';
$string['coursetitleshortname'] = 'Nombre corto / código del curso';
$string['covbkcolor'] = 'Color de fondo en los bloques estilo Coventry';
$string['covbkcolordesc'] = 'Establece el color de superposición de los bloques cuando se ha seleccionado el estilo Coventry.';
$string['coventrystyle'] = 'Estilo Coventry';
$string['covfontcolor'] = 'Color del texto en los bloques estilo Coventry';
$string['covfontcolordesc'] = 'Establece el color del texto en los bloques estilo Coventry.';
$string['covhidebutton'] = 'Mostrar el botón del curso en los bloques estilo Coventry';
$string['covhidebuttondesc'] = 'Mostrar / ocultar el botón del curso cuando se utiliza el estilo Coventry.';
$string['currentcolor'] = 'Color de realce de la sección actual';
$string['currentcolordesc'] = 'Establece el color de realce de la sección actual.';
$string['customcoursesubtitle'] = 'Título del curso personalizado';
$string['customcoursesubtitledesc'] = 'Nombre del campo personalizado del perfil de usuario para el título del curso.';
$string['customcoursetitle'] = 'Título del curso personalizado';
$string['customcoursetitledesc'] = 'Nombre del campo personalizado del perfil de usuario para el título del curso.';
$string['customcss'] = 'CSS personalizado';
$string['customcssdesc'] = 'Introduce las reglas CSS personalizadas.';
$string['customcssjssettings'] = 'CSS y JS personalizado';
$string['customfields'] = 'Campos Personalizados';
$string['customfontheadername'] = 'Fuente de encabezado personalizado';
$string['customfontheadernamedesc'] = 'Ingrese el nombre de la fuente de Encabezado personalizado solo si seleccionó Personalizado; en el menú desplegable Fuente de encabezado.';
$string['customfontname'] = 'Fuente principal personalizada';
$string['customfontnamedesc'] = 'Ingrese el nombre de la fuente principal personalizada solo si seleccionó Personalizar en el menú desplegable Fuente principal';
$string['customfonttitlename'] = 'Fuente de título personalizado';
$string['customfonttitlenamedesc'] = 'Ingrese el nombre de la Fuente de título personalizada solo si seleccionó Personalizado en el menú desplegable Fuente de título.';
$string['dangericoncolor'] = 'Color del icono de advertencia';
$string['dangericoncolordesc'] = 'Establezca el color del icono de advertencia / peligro utilizado principalmente en los campos obligatorios.';
$string['dashblocklayoutbuilder'] = 'Region de Bloques del Tablero de Control';
$string['dashblocklayoutbuilderdesc'] = 'A continuación podrá crear su propio diseño para las regiones de bloques en el tablero de control.
Para agregar contenido a estas regiones necesitará <strong> activar la edición de la página en el panel de control de Moodle. <strong> ¡Entonces podrá comenzar a arrastrar/soltar bloques en las regiones que cree!';
$string['dashblocklayoutlayoutrow'] = 'Fila del tablero de control';
$string['dashblocklayoutlayoutrowdesc'] = 'Agregar/establecer el diseño para la fila de bloques en el tablero de control.';
$string['dashblocksabovecontent'] = 'Mostrar el contenido principal anterior';
$string['dashblocksbelowcontent'] = 'Mostrar a continuación el contenido principal';
$string['dashblocksenabled'] = 'Habilitar regiones de bloques personalizadas en el Panel de control.';
$string['dashblocksenableddesc'] = 'Puede habilitar/deshabilitar las regiones de bloques personalizadas en el tablero de control.
A continuación podrá arrastrar y soltar bloques en las regiones que ha creado.';
$string['dashblocksposition'] = 'Posición de región de bloque personalizada';
$string['dashblockspositiondesc'] = 'Cuando las regiones de bloque personalizadas están habilitadas para la página del panel, elija la posición.';
$string['dashboardblockregionsettings'] = 'Constructor de regiones de bloques en el tablero de control';
$string['defaultzoom'] = 'Zoom predeterminado';
$string['defaultzoomdesc'] = 'El tamaño de pantalla predeterminado cuando se habilita el zoom está desactivado o el usuario no ha hecho ninguna preferencia. Elija entre pantalla completa y ancho fijo.';
$string['deprecated'] = 'VERSIÓN DESACTUALIZADA DE MOODLE. NO PUEDE USAR EL TEMA ADAPTABLE EN ESTE SITIO';
$string['disablecustommenu'] = 'Desactivar el menú personalizado de Moodle';
$string['disablecustommenudesc'] = 'Desactiva el menú personalizado de Moodle en la barra de navegación (seguirá funcionando en otras plantillas instaladas)';
$string['disabled'] = 'Desactivado';
$string['disablemenuscoursepages'] = 'Desactivar menús en las páginas de los cursos';
$string['disablemenuscoursepagesdesc'] = 'Activando esta opción los menús solo se mostrarán en las páginas del sitio, la página inicial, el Área Personal, etc. y no se mostrará en las páginas de los cursos.';
$string['discardbuttontext'] = 'Cancelar';
$string['displayeditingbuttontext'] = 'Edición de texto del botón';
$string['displayeditingbuttontextdesc'] = 'Mostrar u ocultar el texto en el botón de edición. Nota: Solo se aplica al botón de edición del curso.';
$string['displaygrades'] = 'Mostrar calificaciones';
$string['displaygradesdesc'] = 'Mostrar el elemento calificaciones en el menú';
$string['displaylogin'] = 'Mostrar';
$string['displayloginbox'] = 'Caja de entrada';
$string['displayloginbutton'] = 'Botón';
$string['displaylogindesc'] = 'Selecciona como mostrar la caja de entrada en la pantalla (cuando se activa aqui abajo)';
$string['displayloginno'] = 'Sin cuadro de inicio de sesión';
$string['displayparticipants'] = 'Mostrar participantes';
$string['displayparticipantsdesc'] = 'Mostrar el elemento Participantes en el menú';
$string['dividingline'] = 'Línea divisora de la cabecera';
$string['dividingline2'] = 'Línea divisora del pie de página';
$string['dividingline2desc'] = 'Establece el color de la línea divisora del pie de página.';
$string['dividinglinedesc'] = 'Establece el color de la línea divisora de la cabecera.';
$string['draft'] = 'No publicado para estudiantes';
$string['due'] = 'Debido {$a}';
$string['editfont'] = 'Color del texto de los botones de <i>Edición</i> y <i>Personalizar esta página</i>';
$string['editfontdesc'] = 'establece el color del texto de los botones de <i>Edición</i> y <i>Personalizar esta página</i>';
$string['edithorizontalpadding'] = 'Espaciado horizontal de los botones de edición';
$string['editoffbk'] = 'Color de fondo de los botones de edición y personalización desactivados';
$string['editoffbkdesc'] = 'Establece el color de fondo de los botones de edición y personalización cuando están desactivados.';
$string['editonbk'] = 'Color de fondo de los botones de edición y personalización activados';
$string['editonbkdesc'] = 'Establece el color de fondo de los botones de edición y personalización cuando están activados.';
$string['editsettingsbutton'] = 'Editar configuración y visualización de botones';
$string['editsettingsbuttondesc'] = 'Configure aquí lo que debe aparecer en la barra de navegación para editar la configuración. Tenga en cuenta que estas opciones no se aplican a las páginas para las que no hay configuraciones relacionadas, como la página del tablero.';
$string['editsettingsbuttonshowbutton'] = 'Mostrar solo el botón de edición. P.ej. Botón "Activar edición" en la página del curso.';
$string['editsettingsbuttonshowcog'] = 'Mostrar solo el icono de configuración de edición (icono de engranaje / rueda dentada).';
$string['editsettingsbuttonshowcogandbutton'] = 'Mostrar icono de configuración de edición y engranaje. Tenga en cuenta que esto ocupa más espacio en la navegación.';
$string['editverticalpadding'] = 'Espaciado vertical de los botones de edición';
$string['emoticonsize'] = 'Tamaño del emoticono';
$string['emoticonsizedesc'] = 'Establece el ancho y alto de los emoticonos de moodle.';
$string['enablealert'] = 'Activar Alerta {$a}';
$string['enablealertcoursepages'] = 'Activar Alertas en las páginas de los cursos';
$string['enablealertcoursepagesdesc'] = 'Activar las alertas también en las páginas de los cursos.';
$string['enablealertdesc'] = 'Activar la alerta {$a}.';
$string['enablealerts'] = 'Activar / Desactivar Alertas';
$string['enablealertsdesc'] = 'Activar / desactivar alertas en el sitio.';
$string['enablealertstriptags'] = 'Eliminar etiquetas HTML del texto de la Alerta';
$string['enablealertstriptagsdesc'] = 'Si se activa, se eliminarán las etiquetas HTML del texto. Si está desactivado, se permitirá introducir etiquetas HTML por ejemplo para añadir enlaces.';
$string['enableanalytics'] = 'Activar Google Analytics';
$string['enableanalyticsdesc'] = 'Activar Google Analytics en el sitio.';
$string['enableavailablecourses'] = 'Mostrar el texto "Cursos Disponibles"';
$string['enableavailablecoursesdesc'] = 'Mostrar el texto <i>Cursos Disponibles</i> sobre el listado de cursos en la página inicial.';
$string['enablebadges'] = 'Insignias';
$string['enablebadgesdesc'] = 'Mostrar el enlace de las insignias del usuario.';
$string['enableblog'] = 'Blogs del usuario';
$string['enableblogdesc'] = 'Mostrar el enlace a los blogs del usuario.';
$string['enablecalendar'] = 'Calendario';
$string['enablecalendardesc'] = 'Mostrar el enlace al calendario del usuario.';
$string['enablecompetencieslink'] = 'Enlace de competencias';
$string['enablecompetencieslinkdesc'] = 'Mostrar el enlace de competencias en el menú \'Este curso\'. Nota: \'core_competency|habilitado\' debe marcarse.';
$string['enablecoursesectionsdesc'] = 'Muestre un submenú en el menú \'Este curso\' que contiene enlaces a cada sección mostrada.';
$string['enabledtabbedprofileeditprofilelink'] = 'Habilitar el enlace de edición de perfil';
$string['enabledtabbedprofileeditprofilelinkdesc'] = 'Habilite el enlace de edición de perfil con pestañas. Nota: cuando está habilitado, solo se mostrará si el usuario que está viendo tiene permiso para editar el perfil.';
$string['enabledtabbedprofileuserpreferenceslink'] = 'Habilitar enlace de preferencias';
$string['enabledtabbedprofileuserpreferenceslinkdesc'] = 'Habilite el enlace de preferencias de usuario del perfil con pestañas.';
$string['enableeditprofile'] = 'Editar perfil';
$string['enableeditprofiledesc'] = 'Mostrar el enlace para editar el perfil del usuario.';
$string['enableeventsdesc'] = 'Mostrar un enlace al calendario';
$string['enablefeed'] = 'Mis opiniones';
$string['enablefeeddesc'] = 'Mostrar el enlace a la página "Opiniones" - Nota: esta opción requiere el <a href="https://moodle.org/plugins/report_myfeedback" target="blank">plugin My Feedback</a> instalado';
$string['enablegrades'] = 'Calificaciones';
$string['enablegradesdesc'] = 'Mostrar el enlace de las calificaciones del usuario.';
$string['enableheading'] = 'Mostrar nombre del curso';
$string['enableheadingdesc'] = 'Establece el modo de visualización del título del curso en la cabecera.';
$string['enablehelp'] = 'Enlace de ayuda';
$string['enablehelpdesc'] = 'Añade un enlace de ayuda en la barra de navegación.';
$string['enablehomedesc'] = 'Mostrar enlace a Inicio';
$string['enablehomeredirect'] = 'Activar redirect=0';
$string['enablehomeredirectdesc'] = 'Activa la opción redirect=0 para redirigir a la página inicial del sitio. Está opción puede utilizarse en sitios que tienen el Área Personal como página inicial por defecto. Desactivada previene redirigir a los usuarios a la página inicial y ser redirigidos al Área Personal';
$string['enablemenus'] = 'Activar Menús';
$string['enablemenusdesc'] = 'Por motivos de rendimiento, se recomienda no activarlo si no se utilizan los menús.';
$string['enablemy'] = 'Panel';
$string['enablemydesc'] = 'Mostrar el enlace a Panel';
$string['enablemyhomedesc'] = 'Mostrar un enlace a {$a}';
$string['enablemysitesdesc'] = 'Mostrar las actividades del curso';
$string['enablemysitesrestriction'] = 'Restrinja el menú desplegable de cursos del usuario a un campo de perfil personalizado';
$string['enablemysitesrestrictiondesc'] = 'Restrinja el menú desplegable con los cursos de un usuario por campo de perfil personalizado. Por ejemplo, usertype = staff';
$string['enablenavbarwhenloggedout'] = 'Habilitar la barra de navegación cuando cierre sesión';
$string['enablenavbarwhenloggedoutdesc'] = 'Muestra la barra de navegación incluso cuando está desconectado. Limitado solo al menú Ayuda y Herramientas.';
$string['enablenote'] = 'Notificaciones';
$string['enablenotedesc'] = 'Mostrar el enlace página de notificaciones.';
$string['enableposts'] = 'Mis entradas';
$string['enablepostsdesc'] = 'Mostrar el enlace a las entradas en los foros realizadas por el usuario.';
$string['enablepref'] = 'Preferencias';
$string['enableprefdesc'] = 'Mostrar el enlace a las preferencias del usuario.';
$string['enableprivatefiles'] = 'Archivos privados';
$string['enableprivatefilesdesc'] = 'Mostrar el enlace a los archivos privados del usuario.';
$string['enableprofile'] = 'Perfil usuario';
$string['enableprofiledesc'] = 'Mostrar el enlace del perfil de usuario.';
$string['enablesavecanceloverlay'] = 'Habilite Guardar / Cancelar superposición en las páginas de configuración';
$string['enablesavecanceloverlaydesc'] = 'Muestre una superposición de botón Guardar / Cancelar en la parte superior de una página de configuración para que sea más fácil guardar la configuración.';
$string['enablesearchbox'] = 'Activar cuadro de búsqueda';
$string['enablesearchboxdesc'] = 'Mostrar el cuadro de búsqueda en la parte superior de la pantalla.';
$string['enableshowhideblocks'] = 'Activar Mostrar/Ocultar bloques';
$string['enableshowhideblocksdesc'] = 'Permite a los usuarios mostrar / ocultar los bloques laterales.';
$string['enableshowhideblockstext'] = 'Mostrar texto para Mostrar Ocultar bloques';
$string['enableshowhideblockstextdesc'] = 'Muestra el texto al lado del botón.';
$string['enabletabbedprofile'] = 'Habilitar perfil con pestañas';
$string['enabletabbedprofiledesc'] = 'Habilite la funcionalidad de perfil con pestañas.';
$string['enablethiscoursedesc'] = 'Mostrar un menú desplegable con actividades del curso actual.';
$string['enableticker'] = 'Mostrar los anuncios en la página principal';
$string['enabletickerc'] = 'Mostrar la barra de anuncios en las páginas internas';
$string['enabletickercdesc'] = 'Muestra la barra de anuncios en las páginas internas de moodle.';
$string['enabletickerdesc'] = 'Muestra la barra de anuncios en la página principal.';
$string['enabletickermy'] = 'Mostrar la barra de anuncios en Mi Área personal / Panel de control';
$string['enabletickermydesc'] = 'Muestra la barra de anuncios en Mi Área personal / Panel de control.';
$string['enabletoolsmenus'] = 'Activar menús de herramientas';
$string['enabletoolsmenusdesc'] = 'Por razones de rendimiento se recomienda dejarlo desactivado si no se utilizan.';
$string['enablezoom'] = 'Activar Zoom';
$string['enablezoomdesc'] = 'Permite a los usuarios cambiar entre pantalla completa o ancho fijo de pantalla.';
$string['enablezoomshowtext'] = 'Mostrar texto para Activar zoom';
$string['enablezoomshowtextdesc'] = 'Muestra el texto al lado del botón.';
$string['events'] = 'Eventos';
$string['expandable'] = 'Expandible';
$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'Carga el archivo favicon.ico que se muestra en la pestaña del navegador.';
$string['feedbackavailable'] = 'Comentarios disponibles';
$string['fontblockheadercolor'] = 'Color de fuente para el encabezado de los bloques';
$string['fontblockheadercolordesc'] = 'Establezca el color de fuente para el encabezado de los bloques, use código html hexadecimal.';
$string['fontblockheadersize'] = 'Tamaño de fuente para el encabezado de los bloques';
$string['fontblockheadersizedesc'] = 'Establezca el tamaño de fuente para el encabezado de los bloques. Seleccione un valor de la lista.';
$string['fontblockheaderweight'] = 'Grosor de fuente para los encabezados de bloques';
$string['fontblockheaderweightdesc'] = 'Establezca el grosor de fuente usado en los encabezados de los bloques. Seleccione un valor entre 100 y 900 dependiendo del tipo de fuente seleccionada.';
$string['fontcolor'] = 'Color de la fuente principal';
$string['fontcolordesc'] = 'Establece el color de la fuente principal.';
$string['fontdesc'] = 'Selecciona la fuente de <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> para el texto, los encabezamientos y el título. Selecciona también el juego de caracteres a usar (latín está incluido por defecto) e introduce el valor correcto para el grueso de fuente utilizado o no se mostrará.';
$string['fontheadercolor'] = 'Color de la fuente de encabezamientos';
$string['fontheadercolordesc'] = 'Establece el color de la fuente de los encabezamientos utilizados en la plantilla.';
$string['fontheadername'] = 'Fuente encabezamientos';
$string['fontheadernamedesc'] = 'Establece la fuente de los encabezamientos utilizados en la plantilla. Selecciona default o una fuente de <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a>.';
$string['fontheaderweight'] = 'Grueso de la fuente de encabezamientos';
$string['fontheaderweightdesc'] = 'Establece el grueso de la fuente de los encabezamientos. Introducir un valor entre 100 y 900 dependiendo de la fuente utilizada.';
$string['fontname'] = 'Fuente principal';
$string['fontnamedesc'] = 'Establece la fuente principal. Selecciona defecto o una fuente de <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a>.';
$string['fontsettings'] = 'Fuentes';
$string['fontsettingsheading'] = 'Establece las fuentes utilizadas por la plantilla.';
$string['fontsize'] = 'Tamaño de la fuente principal';
$string['fontsizedesc'] = 'Selecciona el tamaño de la fuente principal usada en todo el sitio (en porcentaje).';
$string['fontsubset'] = 'Juego de caracteres de Google Fonts';
$string['fontsubsetdesc'] = 'Seleccionar el juego de caracteres de Google Fonts a usar además del latín ya incluido por defecto. Se aplicará a toda las fuentes seleccionadas.';
$string['fonttitlecolor'] = 'Color de la fuente del título del sitio';
$string['fonttitlecolorcourse'] = 'Color de la fuente del título del curso';
$string['fonttitlecolorcoursedesc'] = 'Establece el color de la fuente usada en el título del curso.';
$string['fonttitlecolordesc'] = 'Establece el color de la fuente del título del sitio situado en la cabecera.';
$string['fonttitlename'] = 'Fuente del título del sitio';
$string['fonttitlenamedesc'] = 'Establece la fuente del título del sitio situado en la cabecera. Selecciona default o una fuente de <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a>.';
$string['fonttitlesize'] = 'Tamaño de la fuente del título del sitio';
$string['fonttitlesizedesc'] = 'Tamaño de la fuente del título del sitio situado en la cabecera. Introducir un valor decimal, por ejemplo: 24px';
$string['fonttitleweight'] = 'Grueso de la fuente del título del sitio';
$string['fonttitleweightdesc'] = 'Establece el grueso de la fuente del título del sitio. Introducir un valor entre 100 y 900 dependiendo de la fuente utilizada.';
$string['fontweight'] = 'Grueso de la fuente principal';
$string['fontweightdesc'] = 'Establece el grueso de la fuente principal. Introducir un valor entre 100 y 900 dependiendo de la fuente utilizada.';
$string['footerbkcolor'] = 'Color de fondo del pie de página superior';
$string['footerbkcolordesc'] = 'Establece el color de fondo del pie de página superior.';
$string['footerblocksplacement'] = 'Páginas donde mostrar los bloques del pie de página';
$string['footerblocksplacement1'] = 'Todo el sitio';
$string['footerblocksplacement2'] = 'Página Inicial';
$string['footerblocksplacement3'] = 'Nunca';
$string['footerblocksplacementdesc'] = 'Definir los lugares donde se deben mostrar los bloques del pie de página. Todo el sitio es la opción por defecto.';
$string['footercontent'] = 'Contenido del bloque del pie de página';
$string['footercontentdesc'] = 'Agregar contenido a la sección de pie de página';
$string['footerdesc'] = 'Añade el titulo del bloque del pie de página';
$string['footerheader'] = 'Titulo del bloque del pie de página';
$string['footerlayoutrow'] = 'Creador de regiones para los bloques del pie de página';
$string['footerlayoutrowdesc'] = 'Utiliza esta opción para ver la distribución creada y comprobar el número de bloques del pie de página que has utilizado.';
$string['footerlinkcolor'] = 'Color de los enlaces del pie de página';
$string['footerlinkcolordesc'] = 'Establece el color de los enlaces del pie de página.';
$string['footersettings'] = 'Pie de Página';
$string['footersettingsheading'] = 'Establezca el contenido que debe aparecer en el pie de página. Vea el diseño <a href="./../theme/adaptable/pix/layout.png" target="_blank"> aquí </a>';
$string['footertextcolor'] = 'Color de texto del pie de página superior';
$string['footertextcolor2'] = 'Color del texto del pie de página inferior';
$string['footertextcolor2desc'] = 'Establece el color del texto del pie de página inferior.';
$string['footertextcolordesc'] = 'Establece el color de texto en el pie de página superior.';
$string['footnote'] = 'Texto del bloque del pie de página';
$string['footnotedesc'] = 'Añadir texto al pie de página.';
$string['forumbodybackgroundcolor'] = 'Fondo del cuerpo de la publicación del foro';
$string['forumbodybackgroundcolordesc'] = 'Color de fondo para una publicación en el foro';
$string['forumheaderbackgroundcolor'] = 'Fondo del encabezado de la publicación del foro';
$string['forumheaderbackgroundcolordesc'] = 'Color de fondo para una publicación en el foro';
$string['frnt-footer'] = 'Los bloques de esta área solo serán visibles para los administradores.';
$string['frontpagealertsettings'] = 'Alertas';
$string['frontpageblockregionsettings'] = 'Creador de regiones para bloques';
$string['frontpageblocksenabled'] = 'Activa las regiones para bloques en la página principal';
$string['frontpageblocksenableddesc'] = 'Activa o desactiva las regiones para bloques de la página principal.
Puedes arrastrar y soltar los bloques en las regiones creadas.';
$string['frontpageblocksettings'] = 'Bloques promocionales';
$string['frontpagecoursesettings'] = 'Cursos';
$string['frontpagedesc'] = 'Configurar la forma en que los cursos son mostrados en la página inicial.';
$string['frontpagemarketenabled'] = 'Activar los bloques promocionales';
$string['frontpagemarketenableddesc'] = 'Activar los bloques promocionales en la pagina de inicio.';
$string['frontpagemarketoption'] = 'Estilo de los bloques promocionales';
$string['frontpagemarketoptiondesc'] = 'Establecer los bloques promocionales tipo Coventry. Configurar el color de esta opción en la página de colores.';
$string['frontpagenumbertiles'] = 'Cantidad de mosaicos de curso por fila';
$string['frontpagenumbertilesdesc'] = 'Número de mosaicos de curso para mostrar por fila en la lista de cursos de la página principal';
$string['frontpagerenderer'] = 'Bloques de cursos';
$string['frontpagerendererdefaultimage'] = 'Imagen por defecto para los cursos';
$string['frontpagerendererdefaultimagedesc'] = 'Sube la imagen que se utilizará por defecto en los cursos que no dispongan de ella.  (solo se aplica en el estilo "Bloques Superpuestos")';
$string['frontpagerendererdesc'] = 'Configurar la forma en que los cursos son mostrados en la página inicial.';
$string['frontpagerendereroption1'] = 'Bloques';
$string['frontpagerendereroption2'] = 'Bloques sin incrustar';
$string['frontpagerendereroption3'] = 'Por defecto';
$string['frontpagerendereroption4'] = 'Tipo Coventry';
$string['frontpagesettingsheading'] = 'Página Inicial';
$string['frontpageslidersettings'] = 'Presentación diapositivas';
$string['frontpagetickersettings'] = 'Anuncios';
$string['frontpagetiles1'] = '1 azulejo';
$string['frontpagetiles2'] = '2 azulejos';
$string['frontpagetiles3'] = '3 azulejos';
$string['frontpagetiles4'] = '4 azulejos';
$string['frontpagetiles6'] = '6 azulejos';
$string['fullscreen'] = 'Pantalla completa';
$string['fullscreenwidth'] = 'Ancho de pantalla completa';
$string['fullscreenwidthdesc'] = 'Establece el ancho máximo de la pantalla en modo pantalla completa / zoom.';
$string['gdprbutton'] = 'Botón de resumen de retención de datos';
$string['gdprbuttondesc'] = 'Mostrar el botón Resumen de retención de datos en el pie de página.';
$string['genericsettingsdescription'] = 'Introduce tu propio código CSS y Javascript.';
$string['genericsettingsheading'] = 'Introduce tu propio código CSS y Javascript';
$string['googleanalyticssettings'] = 'Google Analytics';
$string['googleanalyticssettingsdesc'] = 'Puedes añadir múltiples códigos de Google Analytics y enlazarlos a campos de perfíl de usuario.';
$string['googleanalyticssettingsheading'] = 'Configurar Google analytics en tu sitio.';
$string['header2searchbox'] = 'Encabezado 2 cuadro de búsqueda ampliable';
$string['header2searchboxdesc'] = 'Expanda y contraiga la funcionalidad en el cuadro de búsqueda cuando use el encabezado 2.';
$string['headerbgimage'] = 'Imagen de fondo';
$string['headerbgimagedesc'] = 'Establezca una imagen de fondo en la cabecera. El tamaño mínimo es 1600 x 180 px (se recomienda 1900 x 180 px). La imagen cubre el encabezado completamente. Puede agregar un color en \'Color de fondo del encabezado superior\' o usar <i> transparente </i> para mostrar la imagen de fondo. En ese caso midifique el color de texto para que se presente correctamente en la imagen.';
$string['headerbkcolor'] = 'Color de fondo de la parte superior de la cabecera';
$string['headerbkcolor2'] = 'Color de fondo de la parte inferior de la cabecera';
$string['headerbkcolor2desc'] = 'Establece el color de fondo del encabezado inferior. Tenga en cuenta que esto también establece el color para el fondo en el estilo de encabezado 2.';
$string['headerbkcolordesc'] = 'Establece el color de fondo de la parte superior de la cabecera.';
$string['headerdesc'] = 'Mostrar Alertas para avisar a los usuarios, controlar la barra de navegación, mostrar el título del sitio o el logo son algunas de las opciones de la cabecera.';
$string['headernavbarhelpheading'] = 'Enlaces de ayuda y opciones';
$string['headernavbarhelpheadingdesc'] = 'Opciones para enlaces del menú de ayuda.';
$string['headernavbarmycoursesheading'] = 'Menú de mis cursos';
$string['headernavbarmycoursesheadingdesc'] = 'Todas las opciones para la opción de menú Mis cursos (Mis sitios) que muestra la lista de cursos del usuario actual';
$string['headernavbarstylingheading'] = 'Estilo de barra de navegación';
$string['headernavbarstylingheadingdesc'] = 'Opciones de estilo para el menú de navegación principal.';
$string['headernavbarthiscourseheading'] = 'Este menú del curso';
$string['headernavbarthiscourseheadingdesc'] = 'En este menú, el alumno puede acceder directamente a todas las actividades del curso y a la lista de participantes y sus calificaciones.';
$string['headersettings'] = 'Cabecera';
$string['headersettingsheading'] = 'Personalización de la cabecera.';
$string['headerstyle'] = 'Estilo de encabezado';
$string['headerstyle1'] = 'Encabezado 1 (encabezado original de 3 filas)';
$string['headerstyle2'] = 'Encabezado 2 (encabezado de 2 filas)';
$string['headerstyledesc'] = 'Elige el estilo del encabezado. El encabezado 1 se refiere al encabezado adaptable original de 3 filas. El encabezado 2 es un encabezado mínimo de 2 filas. Tenga en cuenta que cuando use el Encabezado 2, para la configuración "Usar cuadro de búsqueda o iconos sociales", esto siempre usará un cuadro de búsqueda.';
$string['headerstyleheading'] = 'Configuración de estilo de encabezado';
$string['headerstyleheadingdesc'] = 'Adaptable admite dos estilos de encabezado, el encabezado original de tres filas y un nuevo encabezado simplificado de dos filas.
Tenga en cuenta que si cambia al encabezado de dos filas, <strong> NO </strong> podrá: <br />
<ol> <li> Mostrar iconos sociales en el encabezado </li> <li> Mostrar el logotipo del sitio en dispositivos móviles </li> </ol>';
$string['headertextcolor'] = 'Color de texto y enlaces de la parte superior de la cabecera';
$string['headertextcolor2'] = 'Color del texto y enlaces de la parte inferior de la cabecera';
$string['headertextcolor2desc'] = 'Establece el color de texto y enlaces de la parte inferior de la cabecera.';
$string['headertextcolordesc'] = 'Establece el color de texto y enlaces de la parte superior de la cabecera.';
$string['help'] = 'Ayuda';
$string['helplinkscount'] = 'Número de enlaces de ayuda';
$string['helplinkscountdesc'] = 'Establezca el número de enlaces de ayuda que desea agregar a la barra de navegación principal.';
$string['helplinktitle'] = 'Titúlo del enlace de ayuda \'{$a->number}\'';
$string['helplinktitledesc'] = 'El título para el enlace de ayuda \'{$a->number}\' en la barra de navegación. Si está vacío el valor predeterminado es \'Ayuda {$a->number}\'.';
$string['helpprofilefield'] = 'Campo personalizado para la ayuda (opcional)';
$string['helpprofilefielddesc'] = 'Añade una regla de acceso usando un campo de perfil personalizado. Ejemplo: usertype=alumno';
$string['helptarget'] = 'Nueva ventana de ayuda';
$string['helptargetdesc'] = 'Abrir la ayuda en la misma ventana o en una nueva.';
$string['helptitle'] = 'Ayuda por perfil';
$string['hiddencourses'] = 'Cursos ocultos';
$string['hide'] = 'Ocultar';
$string['hidealertsmobile'] = 'Ocultar Alertas';
$string['hidealertsmobiledesc'] = 'Oculta las alertas de la parte superior de la pantalla (si están activadas)';
$string['hideblocks'] = 'Ocultar bloques';
$string['hidebreadcrumbmobile'] = 'Ocultar ruta de navegación';
$string['hidebreadcrumbmobiledesc'] = 'Oculta la ruta de navegación.';
$string['hidecoursetitlemobile'] = 'Oculta el título del curso';
$string['hidecoursetitlemobiledesc'] = 'Oculta el título del curso y del sitio';
$string['hidefootersocial'] = 'Mostrar iconos sociales';
$string['hidefootersocialdesc'] = 'Mostrar iconos sociales en el pie de página, después de los bloques.';
$string['hideheadermobile'] = 'Ocultar la cabecera';
$string['hideheadermobiledesc'] = 'Oculta la cabecera, logo, iconos sociales y búsqueda.';
$string['hideinforum'] = 'Ocultar Menús de Ayuda y Herramientas en los foros';
$string['hideinforumdesc'] = 'Si se utiliza un ancho fijo de pantalla es posible que los menús salten a la línea inferior. Activando esta opción se ocultan los menús en las páginas de foros.';
$string['hidelogomobile'] = 'Ocultar logo';
$string['hidelogomobiledesc'] = 'Ocultar el logo.';
$string['hidepagefootermobile'] = 'Ocultar pie de página';
$string['hidepagefootermobiledesc'] = 'Oculta el pie de página.';
$string['hideslidermobile'] = 'Ocultar la presentación de diapositivas en dispositivos móviles';
$string['hideslidermobiledesc'] = 'Ocultar eliminará el presentador de diapositivas de la página inicial en dispositivos móviles';
$string['hidesocialmobile'] = 'Ocultar los iconos sociales';
$string['hidesocialmobiledesc'] = 'Oculta los iconos sociales (si están activados)';
$string['home'] = 'Inicio';
$string['homebk'] = 'Imagen de fondo';
$string['homebkdesc'] = 'Carga la imagen de fondo para la plantilla.';
$string['infobox'] = 'Cuadro informativo 1';
$string['infobox2'] = 'Cuadro informativo 2';
$string['infobox2desc'] = 'Añade el código HTML del cuadro informativo 2 (ver el archivo <a href="./../theme/adaptable/README.txt" target="_blank">README</a> para más ejemplos)';
$string['infoboxdesc'] = 'Añade el código HTML del cuadro informativo 1 (ver el archivo <a href="./../theme/adaptable/README.txt" target="_blank">README</a> para más ejemplos)';
$string['infoboxfullscreen'] = 'Cuadros informativos a ancho completo';
$string['infoboxfullscreendesc'] = 'Marca está opción para mostrar los cuadros informativos a ancho completo de pantalla.';
$string['infoiconcolor'] = 'Color del icono de ayuda';
$string['infoiconcolordesc'] = 'Establezca el color del icono de información / ayuda utilizado por la información sobre herramientas.';
$string['introboxbackgroundcolor'] = 'Color de fondo de la caja de ingreso';
$string['introboxbackgroundcolordesc'] = 'Color de fondo para el cuadro de introducción (descripción de la actividad resaltada) utilizado en foros y otras actividades';
$string['invalidcategorycss'] = 'Categoría inválida CSS personalizado para la categoría \'{$a->topcatname}\' con id \'{$a->topcatid}\': \'{$a->css}\'.';
$string['invalidcategorygeneratedcss'] = 'Categoría inválida CSS generado personalizado:\'{$a->css}\'.';
$string['jssection'] = 'Javascript personalizado';
$string['jssectiondesc'] = 'Introduce el código Javascript personalizado.';
$string['jssectionrestricted'] = 'Sección Javascript Condicional';
$string['jssectionrestricteddashboardonly'] = 'Incluir Javascript solo en la página del Panel';
$string['jssectionrestricteddashboardonlydesc'] = 'Mostrar el javascript solo en la página del tablero. De lo contrario, esto se muestra en todo el sitio.';
$string['jssectionrestricteddesc'] = 'Agregue código javascript al sitio condicionalmente en función de un campo de perfil personalizado. Este javascript solo aparecerá si se cumple esta condición.';
$string['jssectionrestrictedprofilefield'] = 'Campo de perfil personalizado de la sección Javascript';
$string['jssectionrestrictedprofilefielddesc'] = 'Muestre el javascript arriba SOLAMENTE cuando el usuario coincida con este valor de campo de perfil personalizado, por ejemplo: facultad = fbl.';
$string['jumpto'] = 'Salta a...';
$string['layoutaddcontent'] = 'Añade contenido a los bloques promocionales:';
$string['layoutaddcontentdesc1'] = 'Has configurado';
$string['layoutaddcontentdesc2'] = 'bloques promocionales. Si estás conforme con la distribución añade el contenido de los bloques promocionales.
Si no estás conforme, usa el creador de regiones para bloques promocionales para realizar cambios<br />';
$string['layoutcheck'] = 'Comprueba la distribución';
$string['layoutcheckdesc'] = 'Utiliza esta opción para ver la distribución creada y comprobar el número de bloques que has utilizado.';
$string['layoutcount1'] = 'Puedes crear un máximo de';
$string['layoutcount2'] = 'regiones para bloques. Ahora estás usando:';
$string['layoutdesc'] = 'Configuración de la disposición por defecto.';
$string['layoutmobilesettings'] = 'Configuración móvil';
$string['layoutmobilesettingsdesc'] = 'Configuración especifica para dispositivos móviles.';
$string['layoutsettings'] = 'Disposición';
$string['layoutsettingsheading'] = 'Controlar las diferentes disposiciones de la plantilla.';
$string['leftblocks'] = 'Izquierda';
$string['linkcolor'] = 'Color enlace';
$string['linkcolordesc'] = 'Establece el color de los enlaces.';
$string['linkhover'] = 'Color sobre enlace';
$string['linkhoverdesc'] = 'Establece el color cuando pasa el cursor sobre los enlaces.';
$string['linksmenu'] = 'Menú de enlaces';
$string['loadingcolor'] = 'Color del cargador';
$string['loadingcolordesc'] = 'Color del cargador situado en la parte superior de la página.';
$string['loadtime'] = 'Página cargada en';
$string['loginbgimage'] = 'Imagen de fondo';
$string['loginbgimagedesc'] = 'Agregue una imagen de fondo a la página de tamaño completo.';
$string['loginbgopacity'] = 'Encabezado de página de inicio de sesión, barra de navegación, cuadro de inicio de sesión y opacidad de fondo del pie de página cuando hay una imagen de fondo';
$string['loginbgopacitydesc'] = 'Opacidad de fondo de inicio de sesión para el encabezado, barra de navegación, cuadro de inicio de sesión y pie de página cuando hay una imagen de fondo';
$string['loginbgstyle'] = 'Estilo de fondo de inicio de sesión';
$string['loginbgstyledesc'] = 'Seleccione el estilo de la imagen cargada.';
$string['logindesc'] = 'Personalice la página de inicio de sesión agregando un fondo de imagen y textos encima y debajo del cuadro de inicio de sesión.';
$string['loginfooter'] = 'Pie de página de inicio de sesión';
$string['loginfooterdesc'] = 'Mostrar el pie de página de inicio de sesión.';
$string['loginheader'] = 'Encabezado de página de inicio de sesión';
$string['loginheaderdesc'] = 'Mostrar el encabezado de la página de inicio de sesión.';
$string['loginplaceholder'] = 'Usuario';
$string['loginsettings'] = 'Página de inicio de sesión';
$string['loginsettingsheading'] = 'Personaliza la página de inicio de sesión.';
$string['logintextboxbottom'] = 'Cuadro de texto inferior';
$string['logintextboxbottomdesc'] = 'Agregue un texto personalizado debajo del cuadro de inicio de sesión.';
$string['logintextboxtop'] = 'Cuadro de texto superior';
$string['logintextboxtopdesc'] = 'Agregue un texto personalizado sobre el cuadro de inicio de sesión.';
$string['logintextbutton'] = 'Entrar';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Sube el archivo con la imagen del logo (170px x 100px max.). Formatos admitidos: .png, .jpg y .gif';
$string['maincolor'] = 'Color principal';
$string['maincolordesc'] = 'Establece el color principal del sitio.';
$string['maincoursepage'] = 'Página del curso principal';
$string['market'] = 'Bloque promocional';
$string['marketblockbordercolor'] = 'Color del borde de los bloques promocionales';
$string['marketblockbordercolordesc'] = 'Establece el color del borde de los bloques promocionales.';
$string['marketblocksbackgroundcolor'] = 'Color de fondo de la región de los bloques promocionales.';
$string['marketblocksbackgroundcolordesc'] = 'Establece el color de fondo de la región de los bloques promocionales.';
$string['marketdesc'] = 'Agregue html para el bloque de marketing (consulte el archivo <a href="./../theme/adaptable/README.txt" target="_blank"> README </a> para obtener información adicional y sugerencias).';
$string['marketingbuilderdesc'] = 'Utiliza esta opción para ver la distribución creada y comprobar el número de bloques promocionales que has utilizado.';
$string['marketingbuilderheading'] = 'Creador de regiones para bloques promocionales';
$string['marketingdesc'] = 'Hay dos cuadros de información de ancho completo con diferentes estilos que puede usar.
Además de esto, hay un generador de diseño que le permite decidir cuántos bloques necesita y definir su propio diseño, consulte <a href = "./../ theme / adaptable / README.txt" target = "_ blank" > Archivo README </a> que viene con este tema.';
$string['marketingsettings'] = 'Bloques promocionales';
$string['marketingsettingsheading'] = 'Personaliza los bloques promocionales que aparecen en la página de inicio. Ver la distribución <a href="./../theme/adaptable/pix/layout.png" target="_blank">aqui</a>';
$string['marketlayoutrow'] = 'Filas de regiones para bloques promocionales';
$string['marketlayoutrowdesc'] = 'Añade / establece la distribución de filas de las regiones para bloques promocionales de la página principal.';
$string['menubkcolor'] = 'Color de fondo del menú principal';
$string['menubkcolordesc'] = 'Establece el color de fondo del menú principal.';
$string['menubordercolor'] = 'Color de la línea divisoria de la barra de navegación';
$string['menubordercolordesc'] = 'Establece el color de la linea divisoria de la barra de navegación.';
$string['menufontcolor'] = 'Color de texto del menú principal';
$string['menufontcolordesc'] = 'Establece el color del texto del menú principal.';
$string['menufontpadding'] = 'Separación entre los ítems de la barra de navegación';
$string['menufontpaddingdesc'] = 'Establece la separación entre los ítems de la barra de navegación.';
$string['menufontsize'] = 'Tamaño de fuente de la barra de navegación';
$string['menufontsizedesc'] = 'Establece el tamaño de fuente de la barra de navegación.';
$string['menuhovercolor'] = 'Color hover del menú principal';
$string['menuhovercolordesc'] = 'Establece el color hover delú men principal';
$string['menuoverrideprofilefield'] = 'Nombre del campo personalizado';
$string['menuoverrideprofilefielddefault'] = 'topmenusettings';
$string['menuoverrideprofilefielddesc'] = 'El nombre del campo de perfil "list" usado por la anulación por usuario.';
$string['menusdesc'] = '';
$string['menusession'] = 'Almacenar los detalles de acceso en la sesión';
$string['menusessiondesc'] = 'Se aconseja activar esta opción para optimizar el rendimiento en caso de utilizar varios menús. Mantener desactivado para pruebas.';
$string['menusessionttl'] = 'Tiempo (minutos) de almacenamiento del acceso a los menús por sesión';
$string['menusessionttldesc'] = 'Número de minutos antes de reiniciar la sesión.';
$string['menusettings'] = 'Menús de cabecera';
$string['menusettingsheading'] = 'Personaliza los menús de la cabecera superior.';
$string['menusheading'] = 'Configurar Navegación para los menús de la parte superior de la cabecera';
$string['menusheadingvisibility'] = 'Configuración para la visibilidad del menú superior';
$string['menusheadingvisibilitydesc'] = 'La siguiente configuración permite controlar donde mostrar los menús y opcionalmente permitir a los usuarios su personalización.';
$string['menuslinkicon'] = 'Ícono de menú de enlaces';
$string['menuslinkicondesc'] = 'Elija un icono impresionante de fuente personalizada.';
$string['menuslinkright'] = 'Mostrar el menú de enlaces en la parte superior derecha';
$string['menuslinkrightdesc'] = 'Si está seleccionado, se mostrará el enlace a los menús en la parte superior derecha, junto al menú de mensajes';
$string['menustitledesc'] = 'Los menús de herramientas (en la barra de navegación) y los menús superiores (encabezado superior) pueden restringirse según los campos de perfil personalizados (opcional). Para agregar una restricción, ingrese el nombre del campo de perfil y el valor esperado. La estructura del menú sigue el formato común de Moodle:
<pre>
comunidad de Moodle | https: //moodle.org -
Soporte gratuito de Moodle | https: //moodle.org/support
- Desarrollo de Moodle | https: //moodle.org/development
- Moodle Docs | http: //docs.moodle.org | Moodle Docs
--German Moodle Docs | http: //docs.moodle.org/de | Documentación en alemán | de
Moodle.com | http: //moodle.com/
</pre>';
$string['menuuseroverride'] = 'Permitir anulación de usuario';
$string['menuuseroverridedesc'] = 'Esta configuración se puede usar para dar a los usuarios control sobre dónde aparecen los menús a través de un campo de perfil personalizado. Para usar esta opción, deberá crear un campo de perfil personalizado en el formato de "lista" con valores en el orden correspondiente:
<pre> 1. Todo el sitio (el primer elemento de la lista será para la visibilidad del menú en todo el sitio)
2. Solo páginas de inicio (el segundo elemento de la lista establecerá la visibilidad solo para el sitio / páginas de inicio)
3. Oculto (el tercer valor en la lista ocultará los menús por completo) </pre> Nota: Los usuarios tendrán que cerrar sesión en Moodle y volver a iniciarla para que este cambio surta efecto. Es posible que desee agregar una nota que explique esto en el campo de perfil personalizado.
 NO debe usar la opción "Desactivar menús en las páginas del curso" junto con la configuración del campo de perfil, en su lugar use el valor predeterminado para su entrada "Solo páginas de inicio" al configurar su lista de campos de perfil.';
$string['messagepopupbackground'] = 'Color de fondo para mensajes emergentes.';
$string['messagepopupbackgrounddesc'] = 'Establezca el color de fondo para los mensajes emergentes.';
$string['messagepopupcolor'] = 'Color de texto para mensajes emergentes.';
$string['messagepopupcolordesc'] = 'Establezca el color de texto para los mensajes emergentes.';
$string['messagingbackgroundcolor'] = 'Color de fondo de la ventana principal de mensajes';
$string['messagingbackgroundcolordesc'] = 'Establezca el color de fondo para la ventana de chat principal de mensajes.';
$string['mobilemenubkcolor'] = 'Color de fondo del menú para móvil';
$string['mobilemenubkcolordesc'] = 'Establece el color de fondo del menú principal en móviles (colapsado)';
$string['mobilesettings'] = 'Configuración para dispositivos móviles';
$string['mobilesettingsheading'] = 'Configura la plantilla para ser visualizada en dispositivos móviles.';
$string['mobileslidebartabbkcolor'] = 'Color de fondo de la pestaña de la barra lateral';
$string['mobileslidebartabbkcolordesc'] = 'El color de fondo de la barra lateral en dispositivos móviles (contraído)';
$string['mobileslidebartabiconcolor'] = 'Color del icono de la pestaña de la barra lateral';
$string['mobileslidebartabiconcolordesc'] = 'El color del icono de la barra lateral en dispositivos móviles (contraído)';
$string['moodledocs'] = 'Mostrar enlace a Moodle Docs';
$string['moodledocsdesc'] = 'Mostrar un enlace a Moodle Docs en el pie de página.';
$string['more'] = 'Más';
$string['msgbadgecolor'] = 'Color de fondo del marcador de mensajes.';
$string['msgbadgecolordesc'] = 'Establece el color de fondo del marcador de mensajes en la cabecera (donde se muestra el número de mensajes no leidos)';
$string['myblogs'] = 'Mis Blogs';
$string['mycoursesmenulimit'] = 'Límite del menú Mis Cursos';
$string['mycoursesmenulimitdesc'] = 'Ajuste el número máximo de cursos que aparecerán en el menú Mis Cursos. 0 mostrará todos los cursos.';
$string['mysites'] = 'Mis Cursos';
$string['mysitesdisabled'] = 'Desactivado';
$string['mysitesexclude'] = 'Mostrar excluyendo los cursos ocultos';
$string['mysitesinclude'] = 'Mostrar incluyendo los cursos ocultos';
$string['mysitesmaxlength'] = 'Longitud máxima del título del curso en "Mis Cursos"';
$string['mysitesmaxlengthdesc'] = 'Ajusta la longitud máxima del título del curso a mostrar en "Mis Cursos". La longitud dependerá del tamaño y de la fuente usada.';
$string['mysitesmenudisplay'] = 'Pantalla del menú Mis cursos';
$string['mysitesmenudisplaydesc'] = 'Elija qué texto mostrar para un elemento del menú y al pasar el mouse sobre él.';
$string['mysitesmenudisplayfullnamefullnameonhover'] = 'Mostrar el título completo del curso y el título completo al pasar el mouse sobre él.';
$string['mysitesmenudisplayfullnamenohover'] = 'Mostrar el título completo del curso y sin texto al pasar el mouse.';
$string['mysitesmenudisplayshortcodefullnameonhover'] = 'Mostrar código corto y nombre completo del curso al pasar el ratón.';
$string['mysitesmenudisplayshortcodenohover'] = 'Mostrar código corto y sin texto al pasar el mouse.';
$string['mysitessortoverride'] = 'Activar el orden personalizado de "Mis Cursos"';
$string['mysitessortoverridedesc'] = 'Use campos de perfil personalizados o cadenas genéricas (año, etc.) para contraer cursos anteriores en el submenú';
$string['mysitessortoverridefield'] = 'Campo personalizado o texto para filtrar "Mis Cursos"';
$string['mysitessortoverridefielddesc'] = 'Lista con delimitación por comas de los campos o textos a comprobar en el nombre corto de curso.';
$string['mysitessortoverrideoff'] = 'Mostrar lista de cursos.';
$string['mysitessortoverrideprofilefields'] = 'Muestra los cursos coincidentes con un campo personalizado en una lista. El resto son mostrados en un submenú.';
$string['mysitessortoverrideprofilefieldscohort'] = 'Muestra los cursos coincidentes con un campo de perfil y los cohortes en primer lugar. El resto son mostrados en un submenú.';
$string['mysitessortoverridestrings'] = 'Muestra todos los cursos en los que está matriculado el alumno en una lista. El resto son mostrados en un submenú.';
$string['narrow'] = 'Estrecho';
$string['navbarcachetime'] = 'Caché de la barra de navegación';
$string['navbarcachetimedesc'] = 'El tiempo, en minutos, que se guarda la barra de navegación.';
$string['navbardesc'] = 'Controlar los diferentes elementos a mostrar en la barra de navegación.';
$string['navbardisplayicons'] = 'Mostrar iconos';
$string['navbardisplayiconsdesc'] = 'Mostrar iconos junto a los encabezados del menú principal';
$string['navbardisplaysubmenuarrow'] = 'Mostrar flecha de submenú';
$string['navbardisplaysubmenuarrowdesc'] = 'Muestra la flecha del submenú (hacia abajo) cuando un encabezado del menú tiene opciones de submenú.';
$string['navbardropdownborderradius'] = 'Radio del borde del menú desplegable';
$string['navbardropdownborderradiusdesc'] = 'Controla el radio del borde para los menús desplegables (por ejemplo, esquinas redondeadas).';
$string['navbardropdownhovercolor'] = 'Color de desplazamiento del fondo del menú desplegable';
$string['navbardropdownhovercolordesc'] = 'Color de fondo del menú desplegable al pasar el cursor sobre los elementos del menú.';
$string['navbardropdowntextcolor'] = 'Color del texto del menú desplegable';
$string['navbardropdowntextcolordesc'] = 'Color del texto del elemento del menú desplegable.';
$string['navbardropdowntexthovercolor'] = 'Color de texto del estado seleccionado para el menú desplegable.';
$string['navbardropdowntransitiontime'] = 'Tiempo de transición de la barra de navegación';
$string['navbardropdowntransitiontimedesc'] = 'Tiempo de efecto de transición de la barra de navegación en segundos. Proporciona un efecto de animación de desvanecimiento al pasar el mouse sobre un menú que tiene submenús.';
$string['navbarlinksettingsdesc'] = 'Le permite controlar los enlaces que aparecen en la barra de navegación.';
$string['navbarlinksettingsheading'] = 'Personaliza los enlaces en la barra de navegación';
$string['navbarlinkssettings'] = 'Enlaces de barra de navegación';
$string['navbarmenusettings'] = 'Menú de herramientas de la barra de navegación';
$string['navbarmenusettingsdesc'] = 'Le permite agregar un menú a la barra de navegación.';
$string['navbarmenusettingsheading'] = 'Personaliza el menú en la barra de navegación. Vea el diseño <a href="./../theme/adaptable/pix/layout.png" target="_blank"> aquí </a>';
$string['navbarsettings'] = 'Barra de navegación de encabezado';
$string['navbarsettingsheading'] = 'Personalizar la barra de navegación';
$string['navbarstyles'] = 'Estilos de barra de navegación';
$string['navbarstylesdesc'] = 'Le permite controlar los estilos de los elementos que aparecen en la barra de navegación.';
$string['navbarstylesheading'] = 'Personaliza los estilos de la barra de navegación';
$string['newmenu'] = 'Menú superior desplegable';
$string['newmenu1trigger'] = 'Menú principal desplegable 1 palabra de activación';
$string['newmenu1triggerdesc'] = 'Establecer una palabra de activación del menú desplegable 1 superior. Se pueden usar íconos impresionantes de fuentes';
$string['newmenu2trigger'] = 'Menú superior menú desplegable 2 palabra de activación';
$string['newmenu2triggerdesc'] = 'Establezca una palabra de activación del menú desplegable 2 superior. Se pueden usar íconos impresionantes de fuentes';
$string['newmenudesc'] = 'Configure los enlaces que se mostrarán debajo del menú de encabezado superior.';
$string['newmenufield'] = 'Nombre del campo personalizado del perfíl Field Name=Value (opcional)';
$string['newmenufielddesc'] = 'Añade una regla de acceso usando un campo de perfil personalizado. Ejemplo: usertype=alumno';
$string['newmenuheading'] = 'Menú principal';
$string['newmenurequirelogin'] = 'Requerir inicio de sesión';
$string['newmenurequirelogindesc'] = 'Si está habilitado, este menú solo será visible para los usuarios registrados';
$string['newmenutitle'] = 'Título del menú superior';
$string['newmenutitledefault'] = 'Menú';
$string['newmenutitledesc'] = 'El título de la lista desplegable que aparecerá en el encabezado de su sitio';
$string['newstickercount'] = 'Número de secciones de teletipo de noticias';
$string['newstickercountdesc'] = 'Defina múltiples secciones de ticker de noticias con reglas de acceso para dirigirse a diferentes audiencias';
$string['nextactivity'] = 'Próxima actividad';
$string['nextsection'] = 'Siguiente sección';
$string['noenrolments'] = 'No se encontraron inscripciones.';
$string['nostyle'] = 'Sin estilo';
$string['notanswered'] = 'No contestado';
$string['notattempted'] = 'No intentado';
$string['notcontributed'] = 'No contribuido';
$string['notsubmitted'] = 'No presentado';
$string['overdue'] = 'Atrasado';
$string['pageheaderheight'] = 'Altura del encabezado de página';
$string['pageheaderheightdesc'] = 'Establezca la altura del área del encabezado principal (que contiene el logotipo y los títulos)';
$string['passwordplaceholder'] = 'Contraseña';
$string['pastcourses'] = 'Cursos Pasados';
$string['people'] = 'Participantes';
$string['piwikenabled'] = 'Habilitado';
$string['piwikenableddesc'] = 'Habilite el seguimiento de Matomo para Moodle.';
$string['piwikimagetrack'] = 'Seguimiento de imagen';
$string['piwikimagetrackdesc'] = 'Habilite el seguimiento de imágenes para Moodle para navegadores con JavaScript deshabilitado.';
$string['piwiksettings'] = 'Análisis de Matomo (antes Piwik)';
$string['piwiksettingsdesc'] = 'Generar URL limpia para el seguimiento avanzado.';
$string['piwiksettingsheading'] = 'Configurar Matomo';
$string['piwiksiteid'] = 'Identificación del sitio';
$string['piwiksiteiddesc'] = 'Ingrese su ID de sitio.';
$string['piwiksiteurl'] = 'URL de Matomo';
$string['piwiksiteurldesc'] = 'Ingrese su URL de Matomo Analytics sin http (s) o una barra inclinada final';
$string['piwiktrackadmin'] = 'Administradores de seguimiento';
$string['piwiktrackadmindesc'] = 'Habilitar el seguimiento de usuarios administradores (no recomendado)';
$string['pluginname'] = 'Adaptable';
$string['previousactivity'] = 'Actividad previa';
$string['previoussection'] = 'Sección previa';
$string['privacy:metadata'] = 'Adaptable no almacena ningún dato de usuario individual.';
$string['properties'] = 'Configuración de importación / exportación';
$string['propertiesdesc'] = 'En esta sección, puede importar / exportar la configuración actual del tema Adaptable (propiedades) en formato JSON. También puede ver todas las configuraciones actuales en esta instalación de Moodle.';
$string['propertiesexport'] = 'Exportar propiedades como una cadena JSON';
$string['propertiesproperty'] = 'Propiedad';
$string['propertiesreturn'] = 'Regreso';
$string['propertiessub'] = 'Configuración actual del tema';
$string['propertiesvalue'] = 'Valor';
$string['putpropertiesadded'] = 'Adicional:';
$string['putpropertieschanged'] = 'Cambiado:';
$string['putpropertiesdesc'] = 'Pegue la cadena JSON y \'Guardar cambios\'. ¡Advertencia! No valida los valores de configuración y realiza una \'Purga de todas las memorias caché\'.';
$string['putpropertiesfrom'] = 'desde';
$string['putpropertiesheading'] = 'Importar configuraciones de tema';
$string['putpropertiesignorecti'] = 'Ignorando todas las configuraciones de imagen del título del curso.';
$string['putpropertiesignored'] = 'Ignorado';
$string['putpropertiesname'] = 'Importar propiedades';
$string['putpropertiesreportfiles'] = 'Recuerde cargar los siguientes archivos a su configuración:';
$string['putpropertiessettingsreport'] = 'Informe de configuración:';
$string['putpropertiesunchanged'] = 'Sin alterar:';
$string['putpropertiesvalue'] = '->';
$string['putpropertyour'] = 'Nuestro';
$string['putpropertyproperties'] = 'Propiedades';
$string['putpropertyreport'] = 'Informe:';
$string['putpropertyversion'] = 'versión:';
$string['region-course-bottom-a'] = 'Página del curso región inferior 5';
$string['region-course-bottom-b'] = 'Página del curso región inferior 6';
$string['region-course-bottom-c'] = 'Página del curso, región inferior 7';
$string['region-course-bottom-d'] = 'Página del curso, región inferior 8';
$string['region-course-section-a'] = 'Actividad de la página del curso final región inferior';
$string['region-course-tab-one-a'] = 'Pestaña página del curso región 1';
$string['region-course-tab-two-a'] = 'Pestaña página del curso región 2';
$string['region-course-top-a'] = 'Página principal del curso región 1';
$string['region-course-top-b'] = 'Página superior del curso región 2';
$string['region-course-top-c'] = 'Página superior del curso región 3';
$string['region-course-top-d'] = 'Página superior del curso región 4';
$string['region-frnt-footer'] = 'Pie de página';
$string['region-frnt-market-a'] = 'Región de la página 1';
$string['region-frnt-market-b'] = 'Región de la página 2';
$string['region-frnt-market-c'] = 'Región de la página 3';
$string['region-frnt-market-d'] = 'Región de la página 4';
$string['region-frnt-market-e'] = 'Región de la página 5';
$string['region-frnt-market-f'] = 'Región de la página 6';
$string['region-frnt-market-g'] = 'Región de la página 7';
$string['region-frnt-market-h'] = 'Región de la página 8';
$string['region-frnt-market-i'] = 'Región de la página 9';
$string['region-frnt-market-j'] = 'Región de la página 10';
$string['region-frnt-market-k'] = 'Página región 11';
$string['region-frnt-market-l'] = 'Región de la página 12';
$string['region-frnt-market-m'] = 'Página región 13';
$string['region-frnt-market-n'] = 'Página región 14';
$string['region-frnt-market-o'] = 'Región de la página 15';
$string['region-frnt-market-p'] = 'Página región 16';
$string['region-frnt-market-q'] = 'Página región 17';
$string['region-frnt-market-r'] = 'Región de la página 18';
$string['region-frnt-market-s'] = 'Región de la página 19';
$string['region-frnt-market-t'] = 'Región de la página 20';
$string['regionmaincolor'] = 'Color principal de la región';
$string['regionmaincolordesc'] = 'Establezca el color de fondo para el área de contenido principal.';
$string['region-middle'] = 'Medio';
$string['region-my-tab-one-a'] = 'Región de pestaña de página del Panel 1';
$string['region-my-tab-two-a'] = 'Pestaña de página del panel región 2';
$string['region-news-slider-a'] = 'Región del control deslizante de la página del curso';
$string['region-side-post'] = 'Derecha';
$string['region-side-pre'] = 'Izquierda';
$string['rendereroverlaycolor'] = 'Color de superposiciónSuperpuesto de color';
$string['rendereroverlaycolordesc'] = 'El color de la superposición, cuando se selecciona el renderizador "Tiles w / overlay".';
$string['rendereroverlayfontcolor'] = 'Color de fuente superpuesta';
$string['rendereroverlayfontcolordesc'] = 'El color de la fuente, al pasar el mouse sobre un curso con el renderizador "Tiles w / overlay" habilitado.';
$string['reopened'] = 'Reabierto';
$string['responsivealerts'] = 'Alertas';
$string['rightblocks'] = 'Lado derecho';
$string['savebuttontext'] = 'Guardar cambios';
$string['searchboxpadding'] = 'Cuadro de búsqueda acolchado';
$string['searchboxpaddingdesc'] = 'Establezca el relleno encima del cuadro de búsqueda (si se usa en lugar de los iconos sociales) <br /> Por ejemplo, 5px 10px 5px 10px (arriba, derecha, abajo, izquierda). <br> Puede configurar los iconos sociales debajo de <a href = "./ ../admin/settings.php?section=theme_adaptable_social">Header Social </a> página de configuración </strong>';
$string['searchcourses'] = 'Buscar Cursos';
$string['sectionheadingcolor'] = 'Color del texto del encabezado de sección';
$string['sectionheadingcolordesc'] = 'Establecer el color para el texto de los encabezados de sección';
$string['selectionbackground'] = 'Color de fondo de selección';
$string['selectionbackgrounddesc'] = 'Establezca el color de fondo cuando se selecciona un texto en la pantalla.';
$string['selectiontext'] = 'Color de texto de la selección';
$string['selectiontextdesc'] = 'Establezca el color del texto cuando se selecciona un texto en la pantalla.';
$string['settingsalertbox'] = 'Cuadro de alerta';
$string['settingsanalytics'] = 'Analítica';
$string['settingsblockicons'] = 'Iconos';
$string['settingsborders'] = 'Bordes';
$string['settingsbreadcrumbcolors'] = 'Colores de la ruta de navegación';
$string['settingscolors'] = 'Colores';
$string['settingsfonts'] = 'Fuentes';
$string['settingsfootercolors'] = 'Colores del pie de página';
$string['settingsforumheading'] = 'Foro';
$string['settingsheadercolors'] = 'Colores cabecera';
$string['settingsinfoboxcolors'] = 'Colores cuadro informativo principal';
$string['settingsmaincolors'] = 'Colores principales';
$string['settingsmarketingcolors'] = 'Colores bloques moodle';
$string['settingsmessagescolors'] = 'Colores para los mensajes emergentes';
$string['settingsmobilecolors'] = 'Colores móviles';
$string['settingsnavbarcolors'] = 'Colores de la barra de navegación';
$string['settingsoverlaycolors'] = 'Colores bloques cursos';
$string['settingssecondinfoboxcolors'] = 'Colores cuadro informativo secundario';
$string['settingssmallscreen'] = 'Apariencia de bloque de pantalla pequeña';
$string['settingstopicsweeks'] = 'Temas / Semanas';
$string['show'] = 'Mostrar';
$string['showblocks'] = 'Mostrar bloques';
$string['showfooterblocks'] = 'Mostrar bloques en el pie de página';
$string['showfooterblocksdesc'] = 'Mostrar / Ocultar los bloques personalizables del pie de página.';
$string['showusername'] = 'Mostrar nombre de usuario';
$string['showusernamedesc'] = 'Mostrar el nombre de usuario en el menú del usuario en la barra de navegación.';
$string['showyourprogress'] = 'Mostrar la etiqueta \'Tu progreso\'';
$string['showyourprogressdesc'] = 'Muestra / oculta la etiqueta \'Tu progreso\' en la parte superior del contenido del curso. Esta etiqueta es solo para fines informativos y se puede ocultar.';
$string['sidebarnotlogged'] = 'Mostrar barra lateral cuando no está registrado';
$string['sidebarnotloggeddesc'] = 'Mostrar la barra lateral de bloques cuando el usuario no está conectado';
$string['side-post1'] = 'barra lateral en pie de página';
$string['sitelinkslabel'] = 'Enlaces del sitio';
$string['sitetitle'] = 'Mostrar título del sitio';
$string['sitetitlecoursesdisabled'] = 'Desactivado - muestra solo el título del curso en las páginas del curso';
$string['sitetitlecoursesenabled'] = 'Activado - muestra el nombre del sitio y el título del cursos en las páginas del curso';
$string['sitetitlecustom'] = 'Usar nombre del sitio personalizado (introducir el texto en el siguiente campo)';
$string['sitetitledefault'] = 'Usar el nombre del sitio Moodle';
$string['sitetitledesc'] = 'Muestre el título predeterminado del sitio Moodle en <a href="./../admin/settings.php?section=frontpagesettings" target="_blank"> Configuración de la página principal </a> o ingrese un título de sitio personalizado en el cuadro de texto abajo. Si agrega una imagen de logotipo, entonces el título no se muestra.';
$string['sitetitlemaxwidth'] = 'Longitud máxima del nombre del sitio';
$string['sitetitlemaxwidthdesc'] = 'Establece la longitud máxima de caracteres del nombre del sitio. La longitud final dependerá de la fuente, tamaño y resolución de pantalla.';
$string['sitetitleoff'] = 'Desactivar el nombre del sitio';
$string['sitetitlepaddingleft'] = 'Separación izquierda del nombre del sitio';
$string['sitetitlepaddingleftdesc'] = 'Permite ajustar la separación, en píxeles, de la parte izquierda del nombre del sitio.';
$string['sitetitlepaddingtop'] = 'Separación superior del nombre del sitio';
$string['sitetitlepaddingtopdesc'] = 'Permite ajustar la separación, en píxeles, de la parte superior del nombre del sitio.';
$string['sitetitletext'] = 'Nombre del sitio';
$string['sitetitletextdesc'] = 'Título del sitio que se muestra en el encabezado. Puede usar cualquier etiqueta HTML y aplicar estilos en línea. Se recomienda usar una etiqueta h1 HTML alrededor del título, en lugar de la etiqueta p que se agrega por defecto cuando escribe algo en este campo.';
$string['slider2h3bgcolor'] = 'Color de fondo H3 del estilo de presentación 2';
$string['slider2h3bgcolordesc'] = 'Establece el color de fondo de la etiqueta H3 cuando se utiliza el estilo de presentación 2.';
$string['slider2h3color'] = 'Color del texto H3 del estilo de presentación 2';
$string['slider2h3colordesc'] = 'Establece el color del texto de la etiqueta H3 cuando se utiliza el estilo de presentación 2.';
$string['slider2h4bgcolor'] = 'Color de fondo H4 del estilo de presentación 2';
$string['slider2h4bgcolordesc'] = 'Establece el color de fondo de la etiqueta H4 cuando se utiliza el estilo de presentación 2.';
$string['slider2h4color'] = 'Color del texto H4 del estilo de presentación 2';
$string['slider2h4colordesc'] = 'Establece el color del texto de la etiqueta H4 cuando se utiliza el estilo de presentación 2.';
$string['slidercaption'] = 'Texto de la diapositiva';
$string['slidercaptiondesc'] = 'Añade un texto a la diapositiva.';
$string['slidercount'] = 'Número de dispositivas';
$string['slidercountdesc'] = 'Establece el número de diapositivas a mostrar en la página principal y <strong>haz clic en Guardar</strong> para introducir la información del resto de campos.';
$string['sliderenabled'] = 'Activar la presentación de diapositivas';
$string['sliderenableddesc'] = 'Activa la presentación de diapositivas en la página principal.';
$string['sliderfullscreen'] = 'Presentación de diapositivas en ancho completo';
$string['sliderfullscreendesc'] = 'Muestra la presentación de diapositivas en todo el ancho de la pantalla.';
$string['sliderh3color'] = 'Color del texto H3 del estilo de presentación 1';
$string['sliderh3colordesc'] = 'Establece el color del texto de la etiqueta H3 cuando se utiliza el estilo de presentación 1.';
$string['sliderh4color'] = 'Color del texto H4 del estilo de presentación 1';
$string['sliderh4colordesc'] = 'Establece el color del texto de la etiqueta H4 cuando se utiliza el estilo de presentación 1.';
$string['sliderimage'] = 'Imagen de la diapositiva';
$string['sliderimagedesc'] = 'Añade una imagen a la diapositiva.';
$string['slidermarginbottom'] = 'Margen inferior de la presentación de diapositivas';
$string['slidermarginbottomdesc'] = 'Establece el margen inferior de la presentación de diapositivas.';
$string['slidermargintop'] = 'Margen superior de la presentación de diapositivas';
$string['slidermargintopdesc'] = 'Establece el margen superior de la presentación de diapositivas.';
$string['slideroption2'] = 'Seleccionar tipo de presentación de diapositivas';
$string['slideroption2a'] = 'Color de fondo de las flechas de la presentación de diapositivas tipo 2';
$string['slideroption2adesc'] = 'Establece el color de fondo de las flechas de la presentación de diapositivas cuando se utiliza el estilo de presentación 2.';
$string['slideroption2color'] = 'Color de fondo de la presentación de diapositivas tipo 2';
$string['slideroption2colordesc'] = 'Establece el color de fondo de la diapositiva cuando se utiliza el estilo de presentación 2.';
$string['slideroption2desc'] = 'Selecciona el tipo de presentación de diapositivas <strong>y pulsar Guardar</strong>para mostrar los colores del estilo seleccionado.';
$string['slideroption2snippet'] = '<p>Ejemplo HTML para el texto de las diapositivas:</p>
<pre>
&#x3C;div class=&#x22;span6 col-sm-6&#x22;&#x3E;
&#x3C;h3&#x3E;Hecho a mano&#x3C;/h3&#x3E; &#x3C;h4&#x3E;pixels y código para la comunidad Moodle&#x3C;/h4&#x3E;
&#x3C;a href=&#x22;#&#x22; class=&#x22;submit&#x22;&#x3E;Por favor, haz Adaptable uno de tus temas favoritos&#x3C;/a&#x3E;
</pre>';
$string['slideroption2submitcolor'] = 'Color de fondo del enlace del estilo de presentación 2';
$string['slideroption2submitcolordesc'] = 'Establece el color de fondo del texto del enlace cuando se utiliza el estilo de presentación 2.';
$string['sliderstyle1'] = 'Pase de diapositivas estilo 1';
$string['sliderstyle2'] = 'Pase de diapositivas estilo 2';
$string['slidersubmitbgcolor'] = 'Color del botón del estilo de presentación 1';
$string['slidersubmitbgcolordesc'] = 'Establece el color del botón cuando se utiliza el estilo de presentación 1.';
$string['slidersubmitcolor'] = 'Color del texto del botón del estilo de presentación 1';
$string['slidersubmitcolordesc'] = 'Establece el color del texto del botón cuando se utiliza el estilo de presentación 1.';
$string['sliderurl'] = 'URL de la diapositiva';
$string['sliderurldesc'] = 'Añade una URL a enlazar desde la diapositiva.';
$string['slideshowdesc'] = 'Sube imágenes, añade enlaces y descripciones en las dispositivas de la presentación de la página de inicio.';
$string['slideshowsettings'] = 'Presentación de diapositivas';
$string['slideshowsettingsheading'] = 'Personaliza la presentación de diapositivas de la página de inicio';
$string['smallscreenhidebreadcrumb'] = 'Ocultar la navegación de barra de navegación';
$string['smallscreenhidebreadcrumbdesc'] = 'Oculta la navegación de barra de navegación en dispositivos de pantalla pequeña.';
$string['smallscreenhidesidebar'] = 'Esconder barra lateral';
$string['smallscreenhidesidebardesc'] = 'Ocultar barra lateral en dispositivos de pantalla pequeña';
$string['smallscreenshowsearchicon'] = 'Mostrar icono de búsqueda';
$string['smallscreenshowsearchicondesc'] = 'Mostrar icono de búsqueda en dispositivos de pantalla pequeña.';
$string['socialheading'] = 'Configuración de los iconos de redes sociales';
$string['socialicondesc'] = 'Selecciona el icono de Font Awesome. Por ejemplo: fa-facebook';
$string['socialiconlist'] = 'Lista de iconos sociales';
$string['socialiconlistdesc'] = 'Introducir una lista delimitada por comas para configurar los iconos de redes sociales que necesites usando el formato: url|titulo|icono';
$string['socialorsearch'] = 'Mostrar cuadro de búsqueda o iconos sociales';
$string['socialorsearchdesc'] = 'Puedes mostrar los iconos sociales o el cuadro de búsqueda en la cabecera. <br />
    <strong>Puedes configurar los iconos sociales en la sección "Redes sociales"</strong>.';
$string['socialorsearchnone'] = 'Ninguno';
$string['socialorsearchsearch'] = 'Mostrar cuadro de búsqueda';
$string['socialorsearchsocial'] = 'Nostrar iconos de redes sociales';
$string['socialpaddingtop'] = 'Ajustar la separación debajo los iconos sociales (altera la posición vertical)';
$string['socialpaddingtopdesc'] = 'Este será el mínimo de 15 px (establecido usando el margen) más este valor.';
$string['socialsearchicon'] = 'Buscar en Moodle';
$string['socialsearchicondesc'] = 'Muestra el cuadro de búsqueda al lado de los iconos sociales.';
$string['socialsettings'] = 'Redes sociales';
$string['socialsize'] = 'Configurar tamaño de los iconos sociales';
$string['socialsizedesc'] = 'Para una mejor vista, el tamaño debe ser 5px mayor que el tamaño real deseado.';
$string['socialsizemobile'] = 'Configurar tamaño de los iconos sociales en móviles';
$string['socialsizemobiledesc'] = 'Para una mejor vista, el tamaño debe ser 5px mayor que el tamaño real deseado.';
$string['socialtarget'] = 'Formato de apertura de la ventana de enlaces sociales';
$string['socialtargetdesc'] = 'Abrir la red social en la misma venta o en una nueva';
$string['socialtitledesc'] = '<pre>Puedes desactivar la búsqueda y activar los iconos de redes sociales en su lugar.
Para configurar los iconos, introduce una lista delimitada en el campo "Lista de iconos sociales".
El formato debe ser:

url|titulo|icono

Ejemplo:

http://localhost/moodle/course/search.php|Buscar en Moodle|fa-search
http://facebook.com/|Facebook|fa-facebook-square
http://twitter.com/|Twitter|fa-twitter-square
http://instagram.com|Instagram|fa-instagram
http://example.com|Mi Web|fa-globe

El listado de iconos se encuentra en: <a href="http://fortawesome.github.io/Font-Awesome/icons">http://fortawesome.github.io/Font-Awesome/icons</a>Font-Awesome</pre>';
$string['socialwall'] = 'Formato Social Wall';
$string['socialwallactionlinkcolor'] = 'Color de los enlaces de acción';
$string['socialwallactionlinkcolordesc'] = 'Establece el color de los enlaces de acción.';
$string['socialwallactionlinkhovercolor'] = 'Color hover de los enlaces de acción';
$string['socialwallactionlinkhovercolordesc'] = 'Establece el color hover de los enlaces de acción.';
$string['socialwallbackgroundcolor'] = 'Color de fondo';
$string['socialwallbackgroundcolordesc'] = 'Establece el color de fondo.';
$string['socialwallbordercolor'] = 'Color del borde';
$string['socialwallbordercolordesc'] = 'Establece el color del borde de las secciones.';
$string['socialwallbordertopstyle'] = 'Estilo del borde';
$string['socialwallbordertopstyledesc'] = 'Establece el estilo del borde de las secciones.';
$string['socialwallborderwidth'] = 'Grueso del borde';
$string['socialwallborderwidthdesc'] = 'Establece el grueso del borde de las secciones.';
$string['socialwalldesc'] = 'Personaliza el estilo del <a href="https://moodle.org/plugins/format_socialwall">Formato de curso SocialWall</a> (si se utiliza en el sitio)';
$string['socialwallheading'] = 'Formato Social Wall';
$string['socialwallsectionradius'] = 'Radio del borde';
$string['socialwallsectionradiusdesc'] = 'Establece el borde del radio de las secciones.';
$string['standard'] = 'stándar';
$string['standardscreenwidth'] = 'Ancho de pantalla estándar.';
$string['standardscreenwidthdesc'] = 'Establece el ancho del tema cuando está en modo de pantalla estándar / sin zoom.';
$string['standardview'] = 'Vista estándar';
$string['stickynavbar'] = 'Fijar la barra de navegación';
$string['stickynavbardesc'] = 'Fijar la barra de navegación a la parte superior de la página.';
$string['stylecover'] = 'Cubrir';
$string['stylestretch'] = 'Tramo';
$string['submitted'] = 'Presentado';
$string['tabbedlayoutcoursepage'] = 'Página del curso Diseño tabulado';
$string['tabbedlayoutcoursepagedesc'] = 'Use un diseño con pestañas para la página del curso. Esto muestra todo el contenido en pestañas, con el contenido del curso en una pestaña y le permite adaptar el contenido en otras pestañas. Use esta configuración para configurar el orden de las pestañas.';
$string['tabbedlayoutcoursepagelink'] = 'Página del curso Diseño del archivo con fichas Enlace del curso';
$string['tabbedlayoutcoursepagelinkdesc'] = 'Tenga un enlace de pestaña a la página del curso en las pestañas del curso.';
$string['tabbedlayoutcoursepagetabcolorselected'] = 'Color de pestaña seleccionado para la página del curso';
$string['tabbedlayoutcoursepagetabcolorselecteddesc'] = 'Elija el color para la pestaña seleccionada actualmente.';
$string['tabbedlayoutcoursepagetabcolorunselected'] = 'Color de pestaña no seleccionado para la página del curso';
$string['tabbedlayoutcoursepagetabcolorunselecteddesc'] = 'Elija el color para cualquier otra pestaña.';
$string['tabbedlayoutcoursepagetabpersistencetime'] = 'Página de inicio del curso Pestaña tiempo de persistencia';
$string['tabbedlayoutcoursepagetabpersistencetimedesc'] = 'La pestaña de la página de inicio del curso persiste en la pestaña seleccionada cuando se actualiza durante un período de inactividad. Establezca el período de inactividad aquí. Por ejemplo, configure en 30 para que la primera pestaña se seleccione después de 30 minutos de inactividad';
$string['tabbedlayoutdashboard'] = 'Diseño de pestañas de la página del Panel';
$string['tabbedlayoutdashboarddesc'] = 'Use un diseño con pestañas para la página Panel. Esto muestra todo el contenido en pestañas, con el contenido del curso en una pestaña y le permite adaptar el contenido en otras pestañas. Use esta configuración para configurar el orden de las pestañas.';
$string['tabbedlayoutdashboardtab1condition'] = 'Pestaña 1 Restricción de campo de perfil personalizado (opcional)';
$string['tabbedlayoutdashboardtab1conditiondesc'] = 'Agregue una regla de acceso para mostrar la pestaña 1 usando un campo de perfil personalizado, por ejemplo: showtab1 = true';
$string['tabbedlayoutdashboardtab2condition'] = 'Pestaña 2 Restricción de campo de perfil personalizado (opcional)';
$string['tabbedlayoutdashboardtab2conditiondesc'] = 'Agregue una regla de acceso para mostrar la Pestaña 2 usando un campo de perfil personalizado, por ejemplo: showtab2 = true';
$string['tabbedlayoutdashboardtabcolorselected'] = 'Color de pestaña seleccionado para el Panel';
$string['tabbedlayoutdashboardtabcolorselecteddesc'] = 'Elija el color para la pestaña seleccionada actualmente.';
$string['tabbedlayoutdashboardtabcolorunselected'] = 'Color de pestaña no seleccionado para el Panel';
$string['tabbedlayoutdashboardtabcolorunselecteddesc'] = 'Elija el color para cualquier otra pestaña.';
$string['tabbedlayoutheading'] = 'Diseño con pestañas adaptable';
$string['tabbedlayouttablabelcourse'] = 'Contenido del curso';
$string['tabbedlayouttablabelcourse1'] = 'Pestaña 1';
$string['tabbedlayouttablabelcourse2'] = 'Pestaña 2';
$string['tabbedlayouttablabeldashboard'] = 'Contenido del Panel';
$string['tabbedlayouttablabeldashboard1'] = 'Pestaña 1';
$string['tabbedlayouttablabeldashboard2'] = 'Pestaña 2';
$string['targetnewwindow'] = 'Nueva ventana';
$string['targetsamewindow'] = 'Misma ventana';
$string['thiscourse'] = 'Este curso';
$string['ticker'] = 'Anuncios';
$string['tickerdefault'] = 'No hay anuncios para mostrar';
$string['tickerdesc'] = 'Aquí puedes configurar los anuncios de la página de inicio de tu moodle.
    Solo debes introducir una lista tipo HTML e incluir enlaces.
    Nota: No debes añadir etiquetas ul en la lista, solo li. Los editores de Moodle tienden a añadir etiquetas ul en las listas.
    Si no funciona correctamente, cambia a modo HTML y comprueba que solo hay etiquetas li:
    <pre>
    &lt;li&gt;Anuncio 1.....&lt;/li&gt;
    &lt;li&gt;Anuncio 2.....&lt;/li&gt;
    </pre>
    <br>
    Puedes controlar diferentes secciones de anuncios dependiendo de un campo de perfil de usuario personalizado y así mostrar diferentes anuncios a diferentes perfiles.';
$string['tickerfullscreen'] = 'Ancho de pantalla completa';
$string['tickersettings'] = 'Anuncios';
$string['tickersettingsheading'] = 'Configura los anuncios de la página de inicio. Ver posición <a href="./adaptable/pix/layout.png" target="_blank"> aquí</a>';
$string['tickertext'] = 'Texto de la barra de anuncios';
$string['tickertextdesc'] = 'Añade el texto a mostrar en la barra de anuncios en formato de lista. Ver el archivo <a href="adaptable/README.txt">README.txt</a> para más información.';
$string['tickertextprofilefield'] = 'Nombre del campo personalizado del perfíl Field Name=Value (opcional)';
$string['tickertextprofilefielddesc'] = 'Añade una regla de acceso usando un campo de perfil personalizado. Ejemplo: "usertype=alumno"';
$string['tickerwidth'] = 'Ancho de la barra de anuncios';
$string['tickerwidthdesc'] = 'Usa este valor para cambiar el ancho de la barra de anuncios al 100%.';
$string['tilesbordercolor'] = 'Color del borde de los bloques de cursos';
$string['tilesbordercolordesc'] = 'establece el color del borde de los bloques de cursos.';
$string['tilescontactstitle'] = 'Mostrar el rol de los contactos del curso';
$string['tilescontactstitledesc'] = 'Muestra / Oculta el rol del contacto en el curso. Si no se muestra, se mostrará una imagen para cada contacto.';
$string['tilesshowallcontacts'] = 'Mostrar todos los contactos del curso';
$string['tilesshowallcontactsdesc'] = 'Muestra todos los contactos del curso o solo el principal.';
$string['tilesshowcontacts'] = 'Mostrar los contactos del curso';
$string['tilesshowcontactsdesc'] = 'Muestra / Oculta los contactos del curso.';
$string['toolsmenu'] = 'Menú de herramientas desplegable';
$string['toolsmenu2'] = '2º Menu Herramientas';
$string['toolsmenu2desc'] = 'Puedes configurar los items de los menús de herramientas. Cada línea consiste en: titulo del item, enlace  (opcional), indicador de función (opcional) y el código de idioma o una lista de códigos separada por comas (opcional, para mostrar el item dependiendo del idioma del usuario) separado por una linea vertical (|). También pueden añadirse sub-items usando guiones. Por ejemplo:
<pre>
Moodle community|https://moodle.org
-Moodle free support|https://moodle.org/support
-Moodle development|https://moodle.org/development
--Moodle Docs|http://docs.moodle.org|Moodle Docs
--Moodle Docs en español|http://docs.moodle.org/es|Documentación en español|es
Moodle.com|http://moodle.com/
</pre>';
$string['toolsmenudesc'] = 'Añade un menú desplegable en la barra de navegación.';
$string['toolsmenufield'] = 'Nombre del campo personalizado del perfíl Field Name=Value (opcional)';
$string['toolsmenufielddesc'] = 'Añade una regla de acceso usando un campo de perfil personalizado. Ejemplo: usertype=student';
$string['toolsmenuheading'] = 'Menús herramientas (en la barra de navegación)';
$string['toolsmenuheadingdesc'] = 'Puedes configurar los enlaces a mostrar en el menú de herramientas (en la barra de navegación).
 este formato es similar al usado por los menús personalizados de moodle pero permite añadir los iconos Font Awesome:
<pre>
&lt;span class=&quot;fa fa-video-camera&quot;&gt;&lt;/span&gt; Record Screen|http://google.co.uk|Record Screen
&lt;span class=&quot;fa fa-picture-o&quot;&gt;&lt;/span&gt; ThinkStock|http://google.co.uk|ThinkStock
&lt;span class=&quot;fa fa-clock-o&quot;&gt;&lt;/span&gt; Exam Clock|http://google.co.uk|Exam Clock
</pre><br />';
$string['toolsmenulabel'] = 'Menú Herramientas';
$string['toolsmenulabel2'] = 'Herramientas 2';
$string['toolsmenuscount'] = 'Número de menús de herramientas';
$string['toolsmenuscountdesc'] = 'Establece el número de menús de herramientas que quieres a la barra de navegación.';
$string['toolsmenutitle'] = 'Título menú de herramientas';
$string['toolsmenutitledefault'] = 'Herramientas';
$string['toolsmenutitledesc'] = 'Añade el título a mostrar en la barra de navegación.';
$string['topicsweeks'] = 'Formato de curso Temas/Semanas';
$string['topicsweeksdesc'] = 'Establecer estilos para el formato de curso Temas/Semanas';
$string['topmenufontsize'] = 'Tamaño fuente menú superior';
$string['topmenufontsizedesc'] = 'Establece el tamaño de la fuente usada en el menú superior.';
$string['topmenuscount'] = 'Número de menús superiores';
$string['topmenuscountdesc'] = 'Establece el número de menús superiores que quieres añadir en la cabecera.';
$string['usermenu'] = 'Menú del Usuario';
$string['usernameposition'] = 'Posición del nombre de usuario';
$string['usernamepositiondesc'] = 'Establezca la posición del userame, \'Izquierda\' o \'Derecha\'';
$string['usernav'] = 'Barra de usuario';
$string['usernavdesc'] = 'Permite personalizar los elementos que aparecen Allows you to control all of the elements that appear in the user navigation dropdown.';
$string['usernavheading'] = 'Personalizar el menu de usuario';
$string['usernodescription'] = 'El usuario aún no ha actualizado su descripción.';
$string['usernointerests'] = 'El usuario aún no ha actualizado sus intereses.';
$string['usersettings'] = 'Usuario';
$string['usersettingsdesc'] = 'Establecer ajustes para el usuario.';
$string['usersettingsheading'] = 'Controlar aspectos del usuario';
$string['xofyanswered'] = '{$a->completed} de {$a->participants} Respondido';
$string['xofyattempted'] = '{$a->completed} de {$a->participants} Intento';
$string['xofycontributed'] = '{$a->completed} de {$a->participants} Contribuido';
$string['xofysubmitted'] = '{$a->completed} de {$a->participants} Enviado';
$string['xungraded'] = '{$a} Sin clasificar';
