<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodleorg', language 'el', branch 'MOODLE_26_STABLE'
 *
 * @package   local_moodleorg
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutstatistics'] = 'Το Moodle είναι δωρεάν για να το κατεβάσει κανείς και η καταχώρηση είναι προαιρετική, οπότε δεν έχουμε πλήρη δεδομένα για όλους όσους το χρησιμοποιούν. Πάντως, από τις πληροφορίες που συλλέγουμε, δημιουργούμε αυτόματα κάποιες ενδιαφέρουσες γραφικές παραστάσεις και αριθμούς στην σελίδα στατιστικών μας.';
$string['aboutstatisticsheading'] = 'Στατιστικά Moodle';
$string['aboutstatisticstitle'] = 'Moodle.org: Στατιστικά Moodle';
$string['activeusers24hours'] = 'Καταχωρημένοι χρήστες που είχαν πρόσβαση στις τελευταίες 24 ώρες:';
$string['activeuserspastmonth'] = 'Καταχωρημένοι χρήστες που είχαν πρόσβαση τον περασμένο μήνα:';
$string['browsegittitle'] = 'Περιηγηθείτε στον πηγαίο κώδικά μας';
$string['cachedef_frontpagecolumn'] = 'Στήλες αρχικής σελίδας';
$string['cachedef_usefulposts'] = 'Χρήσιμες αναρτήσεις';
$string['communities'] = 'Κοινότητες';
$string['communitiesmy'] = 'Οι κοινότητές μου';
$string['community'] = 'Κοινότητα';
$string['communityadministration'] = 'Διαχείριση κοινότητας';
$string['communitycurrent'] = 'Τρέχουσα κοινότητα';
$string['communityenrolme'] = 'Γίνετε μέλος αυτής της κοινότητας';
$string['communityenrolmentoptions'] = 'Ένταξη σε μια κοινότητα';
$string['communityintro'] = 'Το Moodle έχει μια μεγάλη και ποικίλη κοινότητα με πάνω από <a href="http://moodle.org/userpics">{$a->usercount} καταχωρημένους χρήστες</a> σε αυτόν τον ιστότοπο Moodle μόνο, μιλάει πάνω από <a href="http://download.moodle.org/langpack/">{$a->langcount} γλώσσες</a> σε <a href="http://moodle.org/sites">{$a->countrycount} χώρες</a> (έχουμε <a href="http://moodle.org/stats">κι άλλα στατιστικά</a>).';
$string['communityjoinbyyourself'] = 'Ενταχθείτε μόνοι σας';
$string['communityjoinbyyourselfas'] = 'Ενταχθείτε μόνοι σας ως {$a->rolename}';
$string['communitynoguestaccess'] = 'Οι επισκέπτες δεν μπορούν να έχουν πρόσβαση σε αυτή την περιοχή κοινότητας. Παρακαλούμε, προσπαθήστε να συνδεθείτε.';
$string['communitynotenrollable'] = 'Δεν μπορείτε να γίνετε μέλος αυτής της κοινότητας μόνος σας. Παρακαλούμε, επικοινωνήστε με τον συντονιστή της κοινότητάς σας.';
$string['communitysomeallowguest'] = 'Κάποιες κοινότητες ίσως επιτρέπουν πρόσβαση επισκέπτη';
$string['communityunenrolme'] = 'Αποχωρήστε από την κοινότητα {$a}';
$string['conferencecenter'] = 'Συνεδριακό κέντρο Moodle';
$string['connectedsites'] = 'Κάποιοι ιστότοποι Moodle έχουν συνδεθεί με το moodle.org χρησιμοποιώντας το Moodle Networking, ώστε να μπορείτε να συνδεθείτε απευθείας σε αυτούς, μόλις αυθεντικοποιηθείτε εδώ.';
$string['donations'] = 'Το Moodle είναι εντελώς απαλλαγμένο από οικονομικές υποχρεώσεις, ωστόσο πολλοί στην κοινότητα έχουν δωρίσει κάτι στο έργο μας για να βοηθήσουν να πληρωθούν οι προγραμματιστές που το κάνουν να συμβεί.';
$string['donationsmoney'] = 'Μπορείτε επίσης να συνεισφέρετε χρήματα απευθείας στο ταμείο μέσω δωρεάς μετρητών. Όλα αυτά τα χρήματα χρησιμοποιούνται για να μετατρέψουν τις επιθυμίες στον χάρτη πορείας εργασιών σε πραγματικά χαρακτηριστικά που μπορούμε όλοι να χρησιμοποιήσουμε. Για να κάνετε μια δωρεά χρησιμοποιώντας μια πιστωτική κάρτα στα περισσότερα σημαντικά νομίσματα, κάντε κλικ στο κουμπί Paypal παρακάτω.<br /><br />Οι δωρητές άνω των $10 μπορούν να προσθέσουν το όνομά τους σε αυτή τη σελίδα για ένα έτος. Παρακαλούμε, μην ξεχάσετε να πατήσετε το πλήκτρο «συνέχεια» μετά την πληρωμή για να δείτε τη φόρμα όπου μπορείτε να επεξεργαστείτε τον τρόπο εμφάνισης της καταχώρησής σας.';
$string['donationsservices'] = 'Εάν χρειάζεστε υπηρεσίες Moodle όπως φιλοξενία, υποστήριξη, εγκατάσταση, προσαρμοσμένη κωδικοποίηση, ανάπτυξη μαθημάτων ή συμβουλευτικές υπηρεσίες, παρακαλούμε, επικοινωνήστε με τον τοπικό εξουσιοδοτημένο <a href="http://moodle.com/">Συνεργάτη Moodle από το moodle.com</a> (θα δείτε τα διαφημιστικά πανό στο περιβάλλον του ιστοτόπου). Οι συνεργάτες συνεισφέρουν ένα σταθερό ποσοστό όλων των κερδών τους στο ταμείο ανάπτυξης του Moodle Trust (καταπίστευμα ή εμπίστευμα), οπότε όλοι κερδίζουν.';
$string['donationstitle'] = 'Δωρεές';
$string['donationstrust'] = 'Το Moodle διαθέτει ένα ταμείο ανάπτυξης που το διαχειρίζεται το Moodle Trust (καταπίστευμα ή εμπίστευμα), το οποίο αναθέτει σε προγραμματιστές να εργάζονται στο Moodle και υποστηρίζει επίσης δαπάνες όπως το moodle.org.';
$string['downloadcore'] = 'Η κύρια μέθοδος διανομής μας είναι μέσω αυτών των βασικών πακέτων πυρήνα. Περιέχουν έναν αριθμό αρθρωμάτων που διατηρούνται από έναν πυρήνα βασικών προγραμματιστών και είναι κατάλληλα για εγκατάσταση σε σχεδόν οποιαδήποτε πλατφόρμα όπου έχετε ήδη εγκαταστήσει την PHP και μια βάση δεδομένων.';
$string['downloadcoretitle'] = 'Τυπικά πακέτα του Moodle';
$string['downloadintro'] = 'Το Moodle είναι ανοικτού κώδικα υπό την <a href="http://docs.moodle.org/dev/License">άδεια GPL</a>. Όλα όσα παράγουμε είναι διαθέσιμα για να μπορείτε να τα κατεβάζετε και να τα χρησιμοποιείτε δωρεάν.';
$string['downloadlang'] = 'Στις τρέχουσες εκδόσεις του Moodle, η προσθήκη υποστήριξης για νέες γλώσσες έχει αυτοματοποιηθεί από το μενού διαχείρισης μέσα στον ιστότοπό σας. Ωστόσο, για μερικές παλαιότερες εκδόσεις του Moodle, τα νέα πακέτα γλωσσών πρέπει να ληφθούν χειροκίνητα.';
$string['downloadlangtitle'] = 'Πακέτα γλώσσας';
$string['downloadmac'] = 'Αν δεν έχετε ήδη δημιουργήσει έναν εξυπηρετητή ιστού, αυτά τα όλα-σε-ένα πακέτα καθιστούν πολύ εύκολη την εγκατάσταση του Moodle σε οποιονδήποτε υπολογιστή της Apple με Mac OS X.';
$string['downloadmactitle'] = 'Moodle για Mac OS X';
$string['downloadmodules'] = 'Περιηγηθείτε στην περιεκτική μας βάση δεδομένων για ακόμη περισσότερα αρθρώματα και πρόσθετα/επεκτάσεις που μπορούν να προστεθούν στον ιστότοπο Moodle για να του δώσουν επιπλέον λειτουργικότητες πέρα από τα βασικά πακέτα.';
$string['downloadmodulestitle'] = 'Πρόσθετα';
$string['downloadthemes'] = 'Η εμφάνιση ενός ιστοτόπου Moodle μπορεί να αλλάξει δραματικά χρησιμοποιώντας ένα διαφορετικό αισθητικό θέμα. Διατηρούμε μια βάση δεδομένων με θέματα που έχουν δημιουργήσει και διαμοιράζονται οι χρήστες του Moodle.';
$string['downloadthemestitle'] = 'Αισθητικά θέματα';
$string['downloadviagitcvs'] = 'Άλλοι τρόποι για να κατεβάσετε το Moodle είναι οι <a href="http://docs.moodle.org/en/Git_for_Administrators">λήψεις μέσω Git</a> ή <a href="http://docs.moodle.org/22/en/CVS_for_Administrators">λήψη μέσω CVS</a>.';
$string['downloadwin'] = 'Αν δεν έχετε ήδη δημιουργήσει έναν εξυπηρετητή ιστού, αυτά τα πακέτα όλα-σε-ένα καθιστούν πολύ εύκολη την εγκατάσταση του Moodle σε οποιονδήποτε υπολογιστή που χρησιμοποιεί Microsoft Windows.';
$string['downloadwintitle'] = 'Moodle για Windows';
$string['erroradminonly'] = 'Μόνο οι διαχειριστές μπορούν να έχουν πρόσβαση σε αυτήν τη διεπαφή.';
$string['erroralreadyvoted'] = 'Έχετε ήδη ψηφίσει για {$a}';
$string['errormaxmessages'] = 'Λυπούμαστε, αλλά δεν μπορείτε να αποστείλετε περισσότερα από 3 μηνύματα.';
$string['errornomainnews'] = 'Αδυναμία εύρεσης ή δημιουργίας ενός κύριου φόρουμ ανακοινώσεων για τον ιστότοπο';
$string['errorsendingmail'] = 'Παρουσιάστηκε σφάλμα κατά την αποστολή του μηνύματος. Παρακαλούμε, προσπαθήστε ξανά αργότερα, ή επικοινωνήστε με τον διαχειριστή του ιστοτόπου.';
$string['events'] = 'Παρόλο που ειδικευόμαστε στην ηλεκτρονική μάθηση, είναι ακόμα ωραίο να συγκεντρωθούμε σε ένα δωμάτιο! Δείτε αυτούς τους συνδέσμους για περισσότερες πληροφορίες σχετικά με τα συνέδρια μας (τα ονομάζουμε MoodleMoots) και άλλα γεγονότα.';
$string['eventstitle'] = 'Γεγονότα';
$string['feed_events'] = 'Γεγονότα';
$string['feed_events_more'] = 'Περισσότερες καταχωρήσεις ημερολογίου';
$string['feed_news'] = 'Ανακοινώσεις';
$string['feed_news_more'] = 'Δείτε όλες τις ανακοινώσεις';
$string['feed_resources'] = 'Πόροι';
$string['feed_useful'] = 'Χρήσιμες αναρτήσεις';
$string['feed_useful_more'] = 'Περισσότερες αναρτήσεις';
$string['focusbox_community'] = 'Φόρουμ υποστήριξης και κοινότητας';
$string['focusbox_community_text'] = 'Λάβετε υποστήριξη και μοιραστείτε ιδέες, στην δική σας γλώσσα.';
$string['focusbox_community_viewall'] = 'Όλες οι κοινότητες';
$string['focusbox_future'] = 'Βοηθήστε να διαμορφωθεί το μέλλον του Moodle';
$string['focusbox_future_crowdfund'] = 'Πληθοχρηματοδοτούμενα έργα';
$string['focusbox_future_gdf'] = 'Συζητήσεις προγραμματιστών';
$string['focusbox_future_research'] = 'Έρευνα Moodle';
$string['focusbox_future_roadmap'] = 'Χάρτης πορείας εργασίας';
$string['focusbox_future_text'] = 'Βρείτε τι έρχεται και βοηθήστε να κάνουμε τη διαφορά.';
$string['focusbox_settingup'] = 'Εγκατάσταση';
$string['focusbox_settingup_community'] = 'Υποστήριξη κοινότητας';
$string['focusbox_settingup_download'] = 'Δωρεάν λήψη';
$string['focusbox_settingup_hosting'] = 'Φιλοξενία';
$string['focusbox_settingup_install'] = 'Εγκατάσταση';
$string['focusbox_settingup_own'] = 'Μόνος σας';
$string['focusbox_settingup_partner'] = 'Μέσω ενός Συνεργάτη Moodle';
$string['focusbox_settingup_plugins'] = 'Πρόσθετα';
$string['focusbox_settingup_support'] = 'Εμπορική υποστήριξη';
$string['focusbox_teaching'] = 'Διδασκαλία με το Moodle';
$string['focusbox_teaching_books'] = 'Βιβλία';
$string['focusbox_teaching_courses'] = 'Μαθήματα και περιεχόμενο';
$string['focusbox_teaching_docs'] = 'Τεκμηρίωση';
$string['focusbox_teaching_text'] = 'Εξερευνήστε την μεγάλη ποικιλία χαρακτηριστικών και διαθέσιμων πόρων του Moodle.';
$string['focusbox_theproject'] = 'Το έργο Moodle';
$string['focusbox_theproject_about'] = 'Πληροφορίες Moodle';
$string['focusbox_theproject_devs'] = 'Προγραμματιστές';
$string['focusbox_theproject_hq'] = 'Επιτελείο Moodle HQ';
$string['focusbox_theproject_partners'] = 'Συνεργάτες Moodle';
$string['focusbox_theproject_stats'] = 'Στατιστικά';
$string['focusbox_theproject_text'] = 'Μάθετε περισσότερα για το έργο Moodle και τις ανοικτές συνεργασίες μας.';
$string['focusbox_uptodate'] = 'Ενημερωθείτε';
$string['focusbox_uptodate_buzz'] = 'Moodle φήμες';
$string['focusbox_uptodate_planet'] = 'Πλανήτης Moodle';
$string['focusbox_uptodate_security'] = 'Ανακοινώσεις ασφάλειας';
$string['focusbox_uptodate_social'] = 'Κοινωνικά μέσα';
$string['focusbox_uptodate_text'] = 'Τελευταία νέα, ενημερώσεις και γενική εικόνα του Moodle ανά τον κόσμο.';
$string['generaldeveloperforum'] = 'Γενικό φόρουμ προγραμματιστών';
$string['graphpopulation'] = 'Γραφική παράσταση πληθυσμού Moodle';
$string['graphregistrationmap'] = 'Χάρτης καταχωρήσεων Moodle';
$string['graphregistrationmapdesc'] = 'Λίστα με τους 10 κορυφαίους καταχωρημένους ιστοτόπους σε {$a} χώρες';
$string['graphusersites'] = 'Σύγκριση χρηστών ανά ιστότοπο Moodle';
$string['heroslide_community_description'] = 'Καλώς ορίσατε στην κοινότητα του Moodle! Ανακαλύψτε την αξία μιας ανοικτής, συνεργατικής προσπάθειας μιας από τις μεγαλύτερες ομάδες ανοικτού λογισμικού στον κόσμο.';
$string['heroslide_community_headline'] = 'Καθοδηγείται από την κοινότητα· υποστηρίζεται από όλους.';
$string['heroslide_community_slidecontrol'] = 'Υποστηρίζεται από μια παγκόσμια κοινότητα';
$string['heroslide_global_description'] = 'Διαθέσιμο σε πάνω από 100 γλώσσες, το Moodle το εμπιστεύονται οργανισμοί και ιδρύματα, μεγάλα και μικρά, με εκατομμύρια χρήστες σε όλο τον κόσμο.';
$string['heroslide_global_headline'] = 'Παρέχει μαθησιακά περιβάλλοντα σε όλο τον κόσμο';
$string['heroslide_global_slidecontrol'] = 'Παρέχει μαθησιακά περιβάλλοντα σε όλο τον κόσμο';
$string['heroslide_link_demo'] = 'Δοκιμαστικό';
$string['heroslide_link_features'] = 'Χαρακτηριστικά';
$string['heroslide_link_forums'] = 'Τα φόρουμ κοινότητας';
$string['heroslide_link_sites'] = 'Καταχωρημένοι ιστότοποι';
$string['heroslide_link_stats'] = 'Στατιστικά';
$string['heroslide_link_stories'] = 'Διαβάστε περισσότερα';
$string['heroslide_power_description'] = 'Η παγκόσμια ελεύθερη μαθησιακή πλατφόρμα που σας βοηθά να δημιουργήσετε διδακτικές και μαθησιακές εμπειρίες εντός σύνδεσης σε ένα συνεργατικό, ιδιωτικό περιβάλλον.';
$string['heroslide_power_headline'] = 'Δυνατότητες. Ασφάλεια. Ανοικτός κώδικας.';
$string['heroslide_power_slidecontrol'] = 'Ισχυρή μαθησιακή πλατφόρμα ανοικτού κώδικα';
$string['heroslide_story_description'] = '«Η πρωτοπορία στην μάθηση με αξιοποίηση των δυνατοτήτων της τεχνολογίας μας δίνει τη δυνατότητα να διευκολύνουμε την ανακάλυψη, τη δημιουργικότητα και τις ευκαιρίες των μαθητών» καθηγητής Darrell Evans, αντιπρύτανης του Πανεπιστημίου Monash (Αυστραλία)';
$string['heroslide_story_headline'] = 'Βελτίωση της διδασκαλίας και της μάθησης παντού';
$string['heroslide_story_slidecontrol'] = 'Ιστορίες σχετικά με το Moodle από όλο τον κόσμο';
$string['jobs'] = 'Επισκεφτείτε την βάση δεδομένων μας ευκαιριών εργασίας για πληροφορίες σε σχετικές με το Moodle θέσεις σε όλο τον κόσμο.';
$string['logoinfo'] = 'Το όνομα Moodle™ είναι σήμα κατατεθέν του Moodle Trust (καταπίστευμα ή εμπίστευμα). Αν σκοπεύετε να χρησιμοποιήσετε το όνομα ή/και το λογότυπο για να διαφημίσετε γενικές υπηρεσίες Moodle (π.χ. φιλοξενία Moodle, υποστήριξη Moodle, πιστοποίηση Moodle, εκπαίδευση Moodle, συμβουλευτικές υπηρεσίες Moodle, προσαρμογή Moodle, ανάπτυξη μαθημάτων Moodle, σχεδίαση αισθητικών θεμάτων Moodle, ενσωματώσεις Moodle, εγκαταστάσεις Moodle κλπ.) ή ως όνομα ενός πακέτου λογισμικού, τότε πρέπει να ζητήσετε και να λάβετε άμεση άδεια γραπτώς από το Moodle Trust μέσω του helpdesk [moodle.com] (http://moodle.com/helpdesk/), σύμφωνα με τους συνήθεις περιορισμούς των εμπορικών σημάτων. Δεν υπάρχουν περιορισμοί σχετικά με τον τρόπο χρήσης του ονόματος σε άλλα περιβάλλοντα (για παράδειγμα, αν χρησιμοποιείτε Moodle μόνο για να παρέχετε μαθήματα τότε μπορείτε χρησιμοποιήστε το όνομα ελεύθερα για να το αναφέρετε.) Αν δεν είστε σίγουροι για μια συγκεκριμένη περίπτωση, παρακαλούμε να μας ρωτήσετε μέσω της [υπηρεσίας υποστήριξης moodle.com] (http://moodle.com/helpdesk/). Θα είμαστε στην ευχάριστη θέση είτε να σας παρέχουμε επίσημη άδεια γραπτώς είτε να σας βοηθήσουμε να διορθώσετε τη διατύπωσή σας.';
$string['logotitle'] = 'Λογότυπο Moodle';
$string['moodlepartner_corporate'] = 'Εταιρική κατάρτιση';
$string['moodlepartner_other'] = 'Άλλοι τομείς';
$string['moodlepartner_school'] = 'Σχολείο';
$string['moodlepartner_university'] = 'Πανεπιστήμιο';
$string['networkinfo'] = 'Οι ακόλουθοι ιστότοποι Moodle έχουν συνδεθεί στο moodle.org με χρήση τεχνολογίας δικτύωσης Moodle κι έτσι μπορείτε να συνδεθείτε κατευθείαν από εδώ.';
$string['networktitle'] = 'Συνδεδεμένοι ιστότοποι';
$string['newregistrations'] = 'Νέες καταχωρήσεις';
$string['newstitle'] = 'Ανακοινώσεις';
$string['noenrolledcoursesyet'] = 'Δεν έχετε εγγραφεί ακόμη σε κανένα μάθημα σε αυτόν τον ιστότοπο';
$string['partnerslogan'] = 'Το έργο Moodle υποστηρίζεται από 60 πιστοποιημένους Συνεργάτες Moodle σε όλο τον κόσμο.<br/><a href="http://moodle.com/partners/about/">Μάθετε περισσότερα</a> για το πρόγραμμά μας συνεργασίας και <a href="http://moodle.com/partners">βρείτε έναν Συνεργάτη Moodle</a> κοντά σας.';
$string['permalink'] = 'Μόνιμος σύνδεσμος';
$string['pluginname'] = 'Ιστότοπος Moodle.org';
$string['popularissues'] = 'Πιο δημοφιλή θέματα';
$string['recentlyratedposts'] = 'Πρόσφατα αξιολογημένες αναρτήσεις';
$string['recentpart'] = 'Αυτή η σελίδα εμφανίζει μερικούς από τους ανθρώπους που χρησιμοποιούν το moodle.org σήμερα.';
$string['registeredsites'] = 'Οι οργανισμοί δεν απαιτείται να ενημερώσουν κανέναν όταν χρησιμοποιούν το Moodle, διότι το Moodle είναι ανοικτού κώδικα. Πάντως, κάποιοι ιστότοποι Moodle έχουν επιλέξει να καταχωρηθούν σε μας και διατηρούμε μια λίστα με αυτούς.';
$string['registeredsitestitle'] = 'Καταχωρημένοι ιστότοποι';
$string['registereduserslastday'] = 'Νέοι χρήστες τις τελευταίες 24 ώρες:';
$string['registereduserstotal'] = 'Σύνολο καταχωρημένων χρηστών:';
$string['registrationgraphalt'] = 'Όλες οι καταχωρήσεις Moodle οποτεδήποτε';
$string['registrationgraphdesc'] = 'Εκτελούμε <a href="http://docs.moodle.org/en/Usage">τακτικούς μαζικούς ελέγχους ιστοτόπων</a> για να βεβαιωθούμε ότι υπάρχουν ακόμη, οπότε περιστασιακά μπορεί να δείτε μείωση στο πλήθος τους.';
$string['registrationslast6months'] = 'Καταχωρήσεις τους τελευταίους 6 μήνες';
$string['registrationstotal'] = 'Όλες οι τρέχουσες καταχωρήσεις';
$string['resources_buzz'] = 'Φήμες';
$string['resources_courses'] = 'Μαθήματα';
$string['resources_jobs'] = 'Εργασίες';
$string['resources_plugins'] = 'Πρόσθετα';
$string['roadmap'] = 'Χάρτης πορείας εργασίας Moodle';
$string['rssdescription'] = 'Πρόσφατες ή αξιολογημένες ως χρήσιμες αναρτήσεις σε φόρουμ από το moodle.org';
$string['rsstitle'] = 'Αναρτήσεις φόρουμ στο moodle.org';
$string['searchmoodleorg'] = 'Αναζήτηση στο moodle.org';
$string['securitytitle'] = 'Ανακοινώσεις ασφάλειας';
$string['shop'] = 'Ψάχνετε κάποιο τρόπο να δείξετε ότι είστε μέλος της κοινότητάς μας; Δείτε το κατάστημα μας για πουκάμισα, κούπες και πολλά άλλα πράγματα.';
$string['social-facebook-moodle'] = 'Επίσημη σελίδα του Moodle στο Facebook';
$string['social-googleplus-community'] = 'Επίσημη σελίδα της κοινότητας του Moodle στο Google+';
$string['social-googleplus-moodle'] = 'Επίσημη σελίδα του Moodle στο Google+';
$string['socialinfo'] = 'Βρισκόμαστε σε διάφορους ιστοτόπους κοινωνικών μέσων ενημέρωσης για να βοηθήσουμε στην ευαισθητοποίηση σχετικά με το έργο του Moodle και να μοιραστούμε τα τελευταία νέα και γεγονότα στον κόσμο του Moodle. Ακολουθήστε μας για να είστε ενημερωμένοι και να συναντήσετε άλλους στην κοινότητα!';
$string['social-linkedin-moodle'] = 'Επίσημη σελίδα του Moodle στο LinkedIn';
$string['socialtitle'] = 'Κοινωνικά μέσα';
$string['social-twitter-moodle'] = 'Επίσημες ανακοινώσεις Moodle, συγκεντρωμένα νέα για το Moodle από τον Πλανήτη Moodle και τις Φήμες Moodle, και χρήσιμες αναρτήσεις φόρουμ';
$string['social-twitter-moodledev'] = 'Νέα και ενημερώσεις ανάπτυξης του Moodle';
$string['social-twitter-moodlehq'] = 'Τιτιβίσματα (Tweets) από το επιτελείο του Moodle';
$string['social-twitter-moodlejobs'] = 'Προσφορά εργασίας σχετικής με Moodle';
$string['social-twitter-moodlenet'] = 'Κοινόχρηστα μαθήματα και περιεχόμενο Moodle';
$string['social-twitter-moodleplugins'] = 'Πρόσφατες κυκλοφορίες πρόσθετων Moodle';
$string['social-twitter-moodleresearch'] = 'Νέα και ενημερώσεις σχετικά με την ετήσια Διάσκεψη Έρευνας Moodle και την γενικότερη έρευνα σχετικά με το Moodle';
$string['social-twitter-moodlesecurity'] = 'Ανακοινώσεις ασφάλειας Moodle';
$string['social-twitter-moodlesites'] = 'Ενημερώσεις κατάστασης για το δίκτυο ιστοτόπων και υπηρεσιών του επιτελείου Moodle HQ';
$string['social-twitter-moodlethemes'] = 'Πρόσφατες κυκλοφορίες αισθητικών θεμάτων Moodle';
$string['social-youtube-moodle'] = 'Επίσημο κανάλι Moodle στο YouTube';
$string['statscountries'] = 'Χώρες';
$string['statscourses'] = 'Μαθήματα';
$string['statsenrolments'] = 'Εγγραφές';
$string['statsposts'] = 'Αναρτήσεις φόρουμ';
$string['statsquestions'] = 'Ερωτήσεις κουίζ';
$string['statsresources'] = 'Πόροι';
$string['statsteachers'] = 'Διδάσκοντες';
$string['statsusers'] = 'Χρήστες';
$string['supportbooks'] = 'Διατηρούμε μια λίστα πολλών βιβλίων για το Moodle που είναι διαθέσιμα για αγορά.';
$string['supportcommercial'] = 'Οι Συνεργάτες Moodle είναι Πάροχοι Υπηρεσιών Moodle σε όλο τον κόσμο, που μπορούν να σας βοηθήσουν με την Moodle υλοποίηση σας.';
$string['supportdocs1'] = 'Το Moodle Docs είναι ένα πολύ καλό μέρος για να ξεκινήσετε· ειδικά οι σελίδες μας με συχνές ερωτήσεις (FAQ).';
$string['supportdocs2'] = 'Ένας καλός τρόπος για να αποκτήσετε πρόσβαση σε σχετική τεκμηρίωση είναι να χρησιμοποιήσετε το σύνδεσμο «Αρχεία βοήθειας του Moodle για αυτή τη σελίδα» στο κάτω μέρος κάθε σελίδας στον δικό σας ιστότοπο Moodle.';
$string['supportdocsfaq'] = 'Συχνές ερωτήσεις (FAQ)';
$string['supportdocslang'] = 'Τα Moodle Docs σε άλλες γλώσσες';
$string['supportforums'] = 'Η κοινότητα των χρηστών μας επικοινωνεί ως επί το πλείστον μέσω των φόρουμ μέσα σε «μαθήματα» σε αυτόν τον ιστότοπο με βάση το Moodle. Πρέπει να «εγγραφείτε» στο μάθημα για να αναρτήσετε σε φόρουμ (η εγγραφή είναι εντελώς δωρεάν).';
$string['supportforumsenglish'] = 'Η κύρια υποστήριξη και οι συζητήσεις προγραμματιστών μεταξύ χρηστών και προγραμματιστών βρίσκονται εδώ στα αγγλικά:';
$string['supportforumsenglishname'] = 'Χρήση Moodle';
$string['supportforumslang'] = 'Το κύριο φόρουμ στα αγγλικά για κοινωνικές σχέσεις μεταξύ χρηστών Moodle είναι εδώ:';
$string['supportforumslangname'] = 'Moodle Lounge (σαλόνι)';
$string['supportforumslangurl'] = 'http://moodle.org/course/view.php?id=55';
$string['supportforumslist'] = 'Έχουμε πολλά άλλα φόρουμ επίσης, σε πολλές γλώσσες:';
$string['supportforumslistname'] = 'Λίστα με όλα τα μαθήματα';
$string['supportintro'] = 'Δεν είστε μόνος σας! Υπάρχουν πολλοί και διάφοροι τρόποι να βρείτε βοήθεια για το Moodle αν χρειαστεί.';
$string['top10countriesbyregistration'] = 'Οι 10 κορυφαίες χώρες σε καταχωρήσεις';
$string['top10sitesbycourses'] = 'Οι 10 κορυφαίοι ιστότοποι σε μαθήματα';
$string['top10sitesbyusers'] = 'Οι 10 κορυφαίοι ιστότοποι σε χρήστες';
$string['url-about'] = 'http://docs.moodle.org/en/About_Moodle';
$string['url-features'] = 'http://docs.moodle.org/en/Features';
$string['url-install'] = 'http://docs.moodle.org/en/Installation';
$string['url-standards'] = 'http://docs.moodle.org/en/Standards';
$string['url-userdocs'] = 'http://docs.moodle.org/en/';
$string['versionsused'] = 'Χρησιμοποιούμενες εκδόσεις';
