<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'feedback', language 'el', branch 'MOODLE_37_STABLE'
 *
 * @package   feedback
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add_item'] = 'Προσθήκη ερώτησης';
$string['add_pagebreak'] = 'Προσθήκη μιας αλλαγής σελίδας';
$string['adjustment'] = 'Ρύθμιση/προσαρμογή';
$string['after_submit'] = 'Μετά την υποβολή';
$string['allowfullanonymous'] = 'Επιτρέπεται πλήρης ανωνυμία';
$string['analysis'] = 'Ανάλυση';
$string['anonymous'] = 'Ανώνυμα';
$string['anonymous_edit'] = 'Καταγραφή ονομάτων χρηστών';
$string['anonymous_entries'] = 'Ανώνυμες καταχωρήσεις ({$a})';
$string['anonymous_user'] = 'Ανώνυμος χρήστης';
$string['answerquestions'] = 'Απαντήστε στις ερωτήσεις';
$string['append_new_items'] = 'Προσάρτηση νέων στοιχείων';
$string['autonumbering'] = 'Αυτόματη αρίθμηση ερωτήσεων';
$string['autonumbering_help'] = 'Ενεργοποιεί και απενεργοποιεί τους αυτόματους αριθμούς για κάθε ερώτηση';
$string['average'] = 'Μέσος όρος';
$string['bold'] = 'Έντονο';
$string['calendarend'] = '{$a} κλείνει';
$string['calendarstart'] = '{$a} ανοίγει';
$string['cannotaccess'] = 'Μπορείτε να έχετε πρόσβαση σε αυτή την ανατροφοδότηση μόνο μέσα από ένα μάθημα.';
$string['cannotsavetempl'] = 'Η αποθήκευση υποδειγμάτων δεν επιτρέπεται';
$string['captcha'] = 'Captcha';
$string['captchanotset'] = 'Το Captcha δεν έχει ρυθμιστεί.';
$string['check'] = 'Πολλαπλών επιλογών - πολλαπλών απαντήσεων';
$string['checkbox'] = 'Πολλαπλών επιλογών - επιτρέπονται οι πολλαπλές απαντήσεις (επιλέξτε κουτάκια)';
$string['check_values'] = 'Πιθανές αποκρίσεις';
$string['choosefile'] = 'Επιλέξτε ένα αρχείο';
$string['chosen_feedback_response'] = 'Επιλεγμένη απόκριση ανατροφοδότησης';
$string['closebeforeopen'] = 'Έχετε ορίσει ημερομηνία λήξης πριν από την ημερομηνία έναρξης.';
$string['completed'] = 'Ολοκληρώθηκε';
$string['completed_feedbacks'] = 'Απαντήσεις που έχουν υποβληθεί';
$string['completedon'] = 'Ολοκληρώθηκε στις {$a}';
$string['complete_the_form'] = 'Απαντήστε στις ερωτήσεις';
$string['completionsubmit'] = 'Εμφάνιση ως ολοκληρωμένου αν η ανατροφοδότηση υποβληθεί';
$string['configallowfullanonymous'] = 'Αν οριστεί σε «ναι», οι χρήστες μπορούν να ολοκληρώσουν μια δραστηριότητα ανατροφοδότησης στην αρχική σελίδα χωρίς να απαιτείται να συνδεθούν.';
$string['confirmdeleteentry'] = 'Σίγουρα θέλετε να διαγράψετε αυτή την καταχώρηση;';
$string['confirmdeleteitem'] = 'Σίγουρα θέλετε να διαγράψετε αυτό το στοιχείο;';
$string['confirmdeletetemplate'] = 'Σίγουρα θέλετε να διαγράψετε αυτό το υπόδειγμα;';
$string['confirmusetemplate'] = 'Σίγουρα θέλετε να χρησιμοποιήσετε αυτό το υπόδειγμα;';
$string['continue_the_form'] = 'Συνεχίστε την απάντηση των ερωτήσεων';
$string['count_of_nums'] = 'Πλήθος αριθμών';
$string['courseid'] = 'Αναγνωριστικό μαθήματος';
$string['creating_templates'] = 'Αποθήκευση αυτών των ερωτήσεων ως ένα νέο υπόδειγμα';
$string['delete_entry'] = 'Διαγραφή καταχώρησης';
$string['delete_item'] = 'Διαγραφή ερώτησης';
$string['delete_old_items'] = 'Διαγραφή παλαιών στοιχείων';
$string['delete_pagebreak'] = 'Διαγραφή (μη αυτόματης) αλλαγής σελίδας';
$string['delete_template'] = 'Διαγραφή υποδείγματος';
$string['delete_templates'] = 'Διαγραφή υποδείγματος...';
$string['depending'] = 'Εξαρτήσεις';
$string['depending_help'] = 'Είναι πιθανό να εμφανιστεί ένα στοιχείο ανάλογα με την αξία ενός άλλου στοιχείου.<br />
<strong>Να ένα παράδειγμα.</strong><br />
<ul>
<li>Αρχικά, δημιουργήστε ένα στοιχείο από το οποίο θα εξαρτηθεί ένα άλλο στοιχείο.</li>
<li>Στη συνέχεια, προσθέστε μια αλλαγή σελίδας.</li>
<li>Στη συνέχεια, προσθέστε τα στοιχεία που εξαρτώνται από την αξία του στοιχείου που δημιουργήθηκε πριν. Επιλέξτε το στοιχείο από τη λίστα με την ταμπέλα «Στοιχείο εξάρτησης» και πληκτρολογήστε την απαιτούμενη τιμή στο πλαίσιο κειμένου με την ταμπέλα «Τιμή εξάρτησης».</li>
</ul>
<strong>Η δομή του στοιχείου πρέπει να είναι κάπως έτσι.</strong>
<ol>
<li>Στοιχείο 1: Έχετε ένα αυτοκίνητο; A: ναι / όχι</li>
<li>Αλλαγή σελίδας</li>
<li>Στοιχείο 2: Ποιο χρώμα είναι το αυτοκίνητό σας;<br/>
(αυτό το στοιχείο εξαρτάται από το στοιχείο 1 με τιμή = ναι)</li>
<li>Στοιχείο 3: Γιατί δεν έχετε αυτοκίνητο;<br />
(αυτό το στοιχείο εξαρτάται από το στοιχείο 1 με τιμή = όχι)</li>
<li> ... άλλα στοιχεία </li>
</ol>';
$string['dependitem'] = 'Στοιχείο εξάρτησης';
$string['dependvalue'] = 'Τιμή εξάρτησης';
$string['description'] = 'Περιγραφή';
$string['do_not_analyse_empty_submits'] = 'Να μην αναλύονται κενές υποβολές εργασιών';
$string['downloadresponseas'] = 'Κάντε λήψη όλων των αποκρίσεων ως:';
$string['dropdown'] = 'Πολλαπλών επιλογών - επιτρέπεται μια απάντηση (πτυσσόμενο μενού)';
$string['dropdownlist'] = 'Πολλαπλών επιλογών - μια απάντηση (πτυσσόμενο μενού)';
$string['dropdownrated'] = 'Πτυσσόμενο μενού (βαθμολογημένο)';
$string['dropdown_values'] = 'Απαντήσεις';
$string['drop_feedback'] = 'Διαγραφή από αυτό το μάθημα';
$string['edit_item'] = 'Επεξεργασία ερώτησης';
$string['edit_items'] = 'Επεξεργασία ερωτήσεων';
$string['email_notification'] = 'Ενεργοποίηση αποστολής ειδοποιήσεων (μέσω ηλε.ταχυδρομείου) για υποβολές εργασιών';
$string['email_notification_help'] = 'Αν ενεργοποιηθεί, οι διδάσκοντες θα λαμβάνουν ειδοποίηση για κάθε υποβολή ανατροφοδότησης.';
$string['emailteachermail'] = 'Ο/Η {$a->username} έχει ολοκληρώσει την ακόλουθη δραστηριότητα ανατροφοδότησης: «{$a->feedback}» Μπορείτε να τη δείτε εδώ: {$a->url}';
$string['emailteachermailhtml'] = 'Ο/Η {$a->username} έχει ολοκληρώσει την ακόλουθη δραστηριότητα ανατροφοδότησης: <i>«{$a->feedback}»</i><br /><br /> Μπορείτε να τη δείτε <a href="{$a->url}">εδώ</a>.';
$string['entries_saved'] = 'Οι απαντήσεις σας σώθηκαν. Ευχαριστούμε.';
$string['eventresponsedeleted'] = 'Η απόκριση διαγράφηκε';
$string['eventresponsesubmitted'] = 'Η απόκριση υποβλήθηκε';
$string['export_questions'] = 'Εξαγωγή ερωτήσεων';
$string['export_to_excel'] = 'Εξαγωγή σε Excel';
$string['feedback:addinstance'] = 'Προσθήκη νέας ανατροφοδότησης';
$string['feedbackclose'] = 'Επιτρέπονται απαντήσεις μέχρι';
$string['feedback:complete'] = 'Ολοκληρώστε μια ανατροφοδότηση';
$string['feedbackcompleted'] = 'Ο/Η χρήστης {$a->username} ολοκλήρωσε την ανατροφοδότηση {$a->feedbackname}';
$string['feedback:createprivatetemplate'] = 'Δημιουργία ιδιωτικού υποδείγματος';
$string['feedback:createpublictemplate'] = 'Δημιουργία δημόσιου υποδείγματος';
$string['feedback:deletesubmissions'] = 'Διαγραφή ολοκληρωμένων υποβολών';
$string['feedback:deletetemplate'] = 'Διαγραφή υποδείγματος';
$string['feedback:edititems'] = 'Επεξεργασία στοιχείων';
$string['feedback_is_not_for_anonymous'] = 'Η ανατροφοδότηση δεν επιτρέπεται σε ανώνυμους χρήστες';
$string['feedback_is_not_open'] = 'Η ανατροφοδότηση δεν είναι ανοιχτή';
$string['feedback:mapcourse'] = 'Αντιστοίχιση μαθημάτων σε καθολικές ανατροφοδοτήσεις (ιστοτόπου)';
$string['feedbackopen'] = 'Επιτρέπονται απαντήσεις από';
$string['feedback:receivemail'] = 'Λήψη ειδοποιήσεων ηλε.ταχυδρομείου';
$string['feedback:view'] = 'Εμφάνιση μιας ανατροφοδότησης';
$string['feedback:viewanalysepage'] = 'Εμφάνιση της σελίδας ανάλυσης μετά την υποβολή';
$string['feedback:viewreports'] = 'Εμφάνιση αναφορών';
$string['file'] = 'Αρχείο';
$string['filter_by_course'] = 'Φιλτράρισμα βάσει μαθήματος';
$string['handling_error'] = 'Ένα σφάλμα συνέβη στο χειρισμό ενεργειών του αρθρώματος ανατροφοδότησης';
$string['hide_no_select_option'] = 'Απόκρυψη της επιλογής «Δεν έχει επιλεγεί»';
$string['horizontal'] = 'Οριζόντια';
$string['importfromthisfile'] = 'Εισαγωγή από αυτό το αρχείο';
$string['import_questions'] = 'Εισαγωγή ερωτήσεων';
$string['import_successfully'] = 'Εισαγωγή επιτυχημένη';
$string['indicator:cognitivedepth'] = 'Βάθος κατανόησης Ανατροφοδότησης';
$string['indicator:cognitivedepth_help'] = 'Αυτός ο δείκτης βασίζεται στο βάθος κατανόησης που επιτεύχθηκε από τον μαθητή σε μια δραστηριότητα Ανατροφοδότησης.';
$string['indicator:socialbreadth'] = 'Κοινωνικό εύρος Ανατροφοδότησης';
$string['indicator:socialbreadth_help'] = 'Αυτός ο δείκτης βασίζεται στο κοινωνικό εύρος που επιτεύχθηκε από τον μαθητή σε μια δραστηριότητα Ανατροφοδότησης.';
$string['info'] = 'Πληροφορίες';
$string['infotype'] = 'Τύπος πληροφοριών';
$string['insufficient_responses'] = 'ανεπαρκείς αποκρίσεις';
$string['insufficient_responses_for_this_group'] = 'Δεν υπάρχουν αρκετές αποκρίσεις για αυτή την ομάδα';
$string['insufficient_responses_help'] = 'Για να είναι ανώνυμη η ανατροφοδότηση, πρέπει να υπάρξουν τουλάχιστον 2 αποκρίσεις.';
$string['item_label'] = 'Ταμπέλα';
$string['item_name'] = 'Ερώτηση';
$string['label'] = 'Ταμπέλα';
$string['labelcontents'] = 'Περιεχόμενα';
$string['mapcourse'] = 'Αντιστοίχιση ανατροφοδότησης σε μάθημα';
$string['mapcourse_help'] = 'Από προεπιλογή, οι φόρμες ανατροφοδότησης που δημιουργούνται στην αρχική σας σελίδα είναι διαθέσιμες σε ολόκληρο τον ιστότοπο και θα εμφανίζονται σε όλα τα μαθήματα χρησιμοποιώντας το μπλοκ ανατροφοδότησης. Μπορείτε να αναγκάσετε τη φόρμα ανατροφοδότησης να εμφανιστεί κάνοντάς την αυτοκόλλητο μπλοκ ή να περιορίσετε τα μαθήματα στα οποία θα εμφανιστεί μια φόρμα ανατροφοδότησης με την αντιστοίχιση της σε συγκεκριμένα μαθήματα.';
$string['mapcourseinfo'] = 'Αυτή είναι μια ανατροφοδότησης με εύρος σε όλο τον ιστότοπο που είναι διαθέσιμη σε όλα τα μαθήματα με τη χρήση του μπλοκ ανατροφοδότησης. Μπορείτε πάντως να περιορίσετε τα μαθήματα στα οποία θα εμφανίζεται αντιστοιχίζοντάς τα. Αναζητήστε το μάθημα και αντιστοιχήστε το σε αυτήν την ανατροφοδότηση.';
$string['mapcoursenone'] = 'Δεν αντιστοιχήθηκαν μαθήματα. Η ανατροφοδότηση είναι διαθέσιμη σε όλα τα μαθήματα';
$string['mapcourses'] = 'Αντιστοίχιση ανατροφοδότησης σε μαθήματα';
$string['mappedcourses'] = 'Μαθήματα που αντιστοιχήθηκαν';
$string['mappingchanged'] = 'Η αντιστοίχιση μαθημάτων έχει αλλάξει';
$string['maximal'] = 'Μέγιστο';
$string['messageprovider:message'] = 'Υπενθύμιση ανατροφοδότησης';
$string['messageprovider:submission'] = 'Ειδοποιήσεις ανατροφοδότησης';
$string['minimal'] = 'Ελάχιστο';
$string['mode'] = 'Λειτουργία';
$string['modulename'] = 'Ανατροφοδότηση';
$string['modulename_help'] = 'Το άρθρωμα δραστηριότητας ανατροφοδότησης επιτρέπει σε ένα διδάσκοντα να δημιουργήσει μια προσαρμοσμένη έρευνα για τη συλλογή (σχολίων) ανατροφοδότησης από τους συμμετέχοντες χρησιμοποιώντας μια ποικιλία τύπων ερωτήσεων, συμπεριλαμβανομένων των πολλαπλών επιλογών, ναι/όχι ή εισαγωγή κειμένου.

Τα σχόλια ανατροφοδότησης μπορεί να είναι ανώνυμα αν το επιθυμείτε και τα αποτελέσματα μπορούν να παρουσιαστούν σε όλους τους συμμετέχοντες ή να περιοριστούν μόνο στους διδάσκοντες. Οποιεσδήποτε δραστηριότητες ανατροφοδότησης στην αρχική σελίδα ιστοτόπου ενδέχεται επίσης να ολοκληρωθούν από μη εγγεγραμμένους χρήστες.

Οι δραστηριότητες ανατροφοδότησης μπορούν να χρησιμοποιηθούν:

* Για αξιολογήσεις μαθημάτων, συμβάλλοντας στη βελτίωση του περιεχομένου των μελλοντικών συμμετεχόντων
* Για να επιτρέπουν σε συμμετέχοντες να εγγραφούν σε μαθήματα, εκδηλώσεις κλπ.
* Για έρευνες επισκεπτών για επιλογές μαθημάτων, σχολικές πολιτικές κλπ.
* Για έρευνες κατά του εκφοβισμού στις οποίες οι μαθητές μπορούν να αναφέρουν περιστατικά ανώνυμα';
$string['modulename_link'] = 'άρθρωμα/ανατροφοδότηση/εμφάνιση';
$string['modulenameplural'] = 'Ανατροφοδοτήσεις';
$string['move_item'] = 'Μετακίνηση αυτής της ερώτησης';
$string['multichoice'] = 'Πολλαπλών επιλογών';
$string['multichoiceoption'] = '<span class="weight">({$a->weight}) </span>{$a->name}';
$string['multichoicerated'] = 'Πολλαπλών επιλογών (βαθμολογημένη)';
$string['multichoicetype'] = 'Τύπος πολλαπλής επιλογής';
$string['multichoice_values'] = 'Τιμές πολλαπλής επιλογής';
$string['multiplesubmit'] = 'Επιτρέπονται πολλαπλές υποβολές';
$string['multiplesubmit_help'] = 'Αν ενεργοποιηθεί για ανώνυμες έρευνες, οι χρήστες μπορούν να υποβάλουν ανατροφοδότηση απεριόριστες φορές.';
$string['name'] = 'Όνομα';
$string['name_required'] = 'Απαιτείται όνομα';
$string['next_page'] = 'Επόμενη σελίδα';
$string['no_handler'] = 'Δεν υπάρχει χειριστής ενέργειας για';
$string['no_itemlabel'] = 'Καμία ταμπέλα';
$string['no_itemname'] = 'Χωρίς itemname';
$string['no_items_available_yet'] = 'Δεν έχουν ρυθμιστεί ερωτήσεις ακόμα';
$string['non_anonymous'] = 'Το όνομα του χρήστη θα καταγραφεί και θα εμφανίζεται με τις απαντήσεις';
$string['non_anonymous_entries'] = 'Χωρίς ανώνυμες καταχωρήσεις ({$a})';
$string['non_respondents_students'] = 'Μαθητές που δεν απάντησαν ({$a})';
$string['not_completed_yet'] = 'Δεν έχουν ολοκληρωθεί ακόμα';
$string['no_templates_available_yet'] = 'Δεν υπάρχουν διαθέσιμα υποδείγματα ακόμα';
$string['not_selected'] = 'Δεν έχουν επιλεχθεί';
$string['not_started'] = 'Δεν ξεκίνησαν';
$string['numberoutofrange'] = 'Αριθμός εκτός εύρους';
$string['numeric'] = 'Αριθμητική απάντηση';
$string['numeric_range_from'] = 'Αρχή εύρους';
$string['numeric_range_to'] = 'Τέλος εύρους';
$string['of'] = 'από';
$string['oldvaluespreserved'] = 'Όλες οι παλιές ερωτήσεις και οι εκχωρηθείσες τιμές θα διατηρηθούν';
$string['oldvalueswillbedeleted'] = 'Οι τρέχουσες ερωτήσεις και όλες οι αποκρίσεις θα διαγραφούν.';
$string['only_one_captcha_allowed'] = 'Μόνο ένα captcha επιτρέπεται σε μια ανατροφοδότηση';
$string['openafterclose'] = 'Έχετε ορίσει ημερομηνία έναρξης μετά την ημερομηνία λήξης';
$string['overview'] = 'Επισκόπηση';
$string['page'] = 'Σελίδα';
$string['page_after_submit'] = 'Μήνυμα ολοκλήρωσης';
$string['pagebreak'] = 'Διαχωριστής σελίδας';
$string['page-mod-feedback-x'] = 'Σελίδα οποιουδήποτε αρθρώματος ανατροφοδότησης';
$string['pluginadministration'] = 'Διαχείριση ανατροφοδότησης';
$string['pluginname'] = 'Ανατροφοδότηση';
$string['position'] = 'Θέση';
$string['previous_page'] = 'Προηγούμενη σελίδα';
$string['privacy:metadata:completed'] = 'Ένα ιστορικό των υποβολών στην ανατροφοδότηση';
$string['privacy:metadata:completed:anonymousresponse'] = 'Εάν η υποβολή πρόκειται να χρησιμοποιηθεί ανώνυμα.';
$string['privacy:metadata:completed:timemodified'] = 'Πότε τροποποιήθηκε τελευταία η υποβολή.';
$string['privacy:metadata:completedtmp'] = 'Ένα ιστορικό των υποβολών που βρίσκονται ακόμη σε εξέλιξη.';
$string['privacy:metadata:completed:userid'] = 'Το αναγνωριστικό του χρήστη που ολοκλήρωσε τη δραστηριότητα ανατροφοδότησης.';
$string['privacy:metadata:value'] = 'Ένα ιστορικό απαντήσεων σε μια ερώτηση.';
$string['privacy:metadata:valuetmp'] = 'Ένα ιστορικό της απάντησης σε μια ερώτηση σε μια υποβολή που βρίσκεται σε εξέλιξη.';
$string['privacy:metadata:value:value'] = 'Η επιλεγμένη απάντηση.';
$string['public'] = 'Δημόσιο';
$string['question'] = 'Ερώτηση';
$string['questionandsubmission'] = 'Ρυθμίσεις ερώτησης και υποβολής';
$string['questions'] = 'Ερωτήσεις';
$string['questionslimited'] = 'Εμφάνιση μόνο των {$a} πρώτων ερωτήσεων, δείτε ξεχωριστά τις απαντήσεις ή κατεβάστε τα δεδομένα του πίνακα για πλήρη προβολή.';
$string['radio'] = 'Πολλαπλών επιλογών - μια απάντηση';
$string['radio_values'] = 'Αποκρίσεις';
$string['ready_feedbacks'] = 'Έτοιμες ανατροφοδοτήσεις';
$string['required'] = 'Απαιτείται';
$string['resetting_data'] = 'Επαναρχικοποίηση αποκρίσεων ανατροφοδότησης';
$string['resetting_feedbacks'] = 'Επαναρχικοποίηση ανατροφοδοτήσεων';
$string['response_nr'] = 'Αριθμός απόκρισης';
$string['responses'] = 'Αποκρίσεις';
$string['responsetime'] = 'Χρόνος αποκρίσεων';
$string['save_as_new_item'] = 'Αποθήκευση ως νέα ερώτηση';
$string['save_as_new_template'] = 'Αποθήκευση ως νέο υπόδειγμα';
$string['save_entries'] = 'Υποβολή των απαντήσεών σας';
$string['save_item'] = 'Αποθήκευση ερώτησης';
$string['saving_failed'] = 'Η αποθήκευση απέτυχε';
$string['search:activity'] = 'Ανατροφοδότηση - πληροφορίες δραστηριότητας';
$string['search_course'] = 'Αναζήτηση μαθήματος';
$string['searchcourses'] = 'Αναζήτηση μαθημάτων';
$string['searchcourses_help'] = 'Αναζητήστε τον κωδικό ή το όνομα των μαθημάτων που θέλετε να συσχετίσετε με αυτή την ανατροφοδότηση.';
$string['selected_dump'] = 'Τα επιλεγμένα ευρετήρια της μεταβλητής $SESSION εμφανίζονται παρακάτω:';
$string['send'] = 'Αποστολή';
$string['send_message'] = 'Αποστολή μηνύματος';
$string['show_all'] = 'Εμφάνιση όλων';
$string['show_analysepage_after_submit'] = 'Εμφάνιση σελίδας ανάλυσης';
$string['show_entries'] = 'Εμφάνιση αποκρίσεων';
$string['show_entry'] = 'Εμφάνιση απόκρισης';
$string['show_nonrespondents'] = 'Εμφάνιση όσων δεν αποκρίθηκαν';
$string['site_after_submit'] = 'Ο ιστότοπος μετά την υποβολή';
$string['sort_by_course'] = 'Ταξινόμηση βάσει μαθήματος';
$string['started'] = 'Ξεκίνησε';
$string['startedon'] = 'Ξεκίνησε στις {$a}';
$string['subject'] = 'Θέμα';
$string['switch_item_to_not_required'] = 'Εναλλαγή σε: δεν απαιτείται απάντηση';
$string['switch_item_to_required'] = 'Εναλλαγή σε: απαιτείται απάντηση';
$string['template'] = 'Υπόδειγμα';
$string['template_deleted'] = 'Το υπόδειγμα διαγράφηκε';
$string['templates'] = 'Υποδείγματα';
$string['template_saved'] = 'Το υπόδειγμα αποθηκεύτηκε';
$string['textarea'] = 'Μακρύτερες απαντήσεις κειμένου';
$string['textarea_height'] = 'Αριθμός γραμμών';
$string['textarea_width'] = 'Πλάτος';
$string['textfield'] = 'Μικρές απαντήσεις κειμένου';
$string['textfield_maxlength'] = 'Μέγιστος αποδεκτός αριθμός χαρακτήρων';
$string['textfield_size'] = 'Πλάτος πεδίου κειμένου';
$string['there_are_no_settings_for_recaptcha'] = 'Δεν υπάρχουν ρυθμίσεις για το captcha';
$string['this_feedback_is_already_submitted'] = 'Έχετε ολοκληρώσει ήδη αυτή την δραστηριότητα.';
$string['typemissing'] = 'Λείπει η τιμή του «type» (τύπος)';
$string['update_item'] = 'Αποθήκευση των αλλαγών στην ερώτηση';
$string['url_for_continue'] = 'Σύνδεση με την επόμενη δραστηριότητα';
$string['url_for_continue_help'] = 'Μετά την υποβολή της ανατροφοδότησης, ένα πλήκτρο συνέχειας εμφανίζεται, που οδηγεί στη σελίδα του μαθήματος. Μπορείτε να ορίσετε εδώ άλλο URL στο οποίο θα οδηγεί το κουμπί συνέχειας.';
$string['use_one_line_for_each_value'] = 'Χρήση μιας γραμμής για κάθε απάντηση!';
$string['use_this_template'] = 'Χρήση αυτού του υποδείγματος';
$string['using_templates'] = 'Χρήση ενός υποδείγματος';
$string['vertical'] = 'Κάθετα';
