<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'el', branch 'MOODLE_37_STABLE'
 *
 * @package   badges
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Ενέργειες';
$string['activate'] = 'Ενεργοποίηση πρόσβασης';
$string['activatesuccess'] = 'Ενεργοποιήθηκε επιτυχώς η πρόσβαση στα διακριτικά';
$string['addalignment'] = 'Προσθέστε εξωτερικές δεξιότητες ή πρότυπα';
$string['addbackpack'] = 'Προσθήκη σακιδίου';
$string['addbadge'] = 'Προσθήκη διακριτικών';
$string['addbadgecriteria'] = 'Προσθήκη κριτηρίων διακριτικού';
$string['addbadge_help'] = 'Επιλέξτε όλα τα διακριτικά που θέλετε να προστεθούν στα προαπαιτούμενα αυτού του διακριτικού. Κρατήστε πατημένο το πλήκτρο CTRL για να επιλέξετε πολλαπλά αντικείμενα.';
$string['addcohort'] = 'Προσθήκη συνόλου χρηστών';
$string['addcohort_help'] = 'Επιλέξτε όλα τα σύνολα χρηστών που πρέπει να προστεθούν σε αυτή την απαίτηση διακριτικού. Κρατήστε το πλήκτρο CTRL για να επιλέξετε πολλά στοιχεία.';
$string['addcompetency'] = 'Προσθήκη προσόντος';
$string['addcompetency_help'] = 'Επιλέξτε όλα τα προσόντα που πρέπει να προστεθούν σε αυτή την απαίτηση διακριτικού. Κρατήστε πατημένο το πλήκτρο CTRL για να επιλέξετε πολλά στοιχεία μαζί.';
$string['addcourse'] = 'Προσθήκη μαθημάτων';
$string['addcourse_help'] = 'Επιλέξτε όλα τα μαθήματα που πρέπει να προστεθούν σε αυτή την απαίτηση διακριτικού. Κρατήστε πατημένο το πλήκτρο CTRL για να επιλέξετε πολλά στοιχεία.';
$string['addcriteria'] = 'Προσθήκη κριτηρίων';
$string['addcriteriatext'] = 'Για να ξεκινήσετε να προσθέτετε κριτήρια, επιλέξτε μια από τις επιλογές του πτυσσόμενου μενού';
$string['addedtobackpack'] = 'Προστέθηκε διακριτικό στο σακίδιο';
$string['addrelated'] = 'Προσθήκη σχετικού διακριτικού';
$string['addtobackpack'] = 'Προσθήκη στο σακίδιο';
$string['adminonly'] = 'Σε αυτή τη σελίδα έχουν πρόσβαση μόνο οι διαχειριστές.';
$string['after'] = 'μετά την ημερομηνία έκδοσης.';
$string['aggregationmethod'] = 'Μέθοδος συνάθροισης';
$string['alignment'] = 'Εναρμόνιση';
$string['all'] = 'Όλα';
$string['allmethod'] = 'Ικανοποιηθούν όλα τα επιλεγμένα κριτήρια';
$string['allmethodactivity'] = 'Ολοκληρωθούν όλες οι επιλεγμένες δραστηριότητες';
$string['allmethodbadges'] = 'Όλα τα επιλεγμένα διακριτικά έχουν απονεμηθεί';
$string['allmethodcohort'] = 'Συμμετοχή σε όλα τα επιλεγμένα σύνολα χρηστών';
$string['allmethodcompetencies'] = 'Όλα τα επιλεγμένα προσόντα έχουν ολοκληρωθεί';
$string['allmethodcourseset'] = 'Ολοκληρωθούν όλα τα επιλεγμένα μαθήματα';
$string['allmethodmanual'] = 'Όλοι οι επιλεγμένοι ρόλοι απονέμουν το διακριτικό';
$string['allmethodprofile'] = 'Όλα τα επιλεγμένα πεδία προφίλ έχουν ολοκληρωθεί';
$string['allowcoursebadges'] = 'Ενεργοποίηση διακριτικών μαθήματος';
$string['allowcoursebadges_desc'] = 'Να επιτρέπεται η δημιουργία και απονομή διακριτικών στο πλαίσιο μαθήματος.';
$string['allowexternalbackpack'] = 'Σύνδεση σε εξωτερικά σακίδια';
$string['allowexternalbackpack_desc'] = 'Αν ενεργοποιηθεί, οι χρήστες μπορούν να συνδεθούν σε ένα εξωτερικό σακίδιο και να μοιραστούν τα διακριτικά τους από αυτόν τον ιστότοπο. Οι χρήστες μπορούν επίσης να επιλέξουν να εμφανίσουν οποιεσδήποτε δημόσιες συλλογές διακριτικών από το εξωτερικό σακίδιό τους στη σελίδα προφίλ τους σε αυτόν τον ιστότοπο. Συνιστάται να αφήσετε αυτήν την επιλογή απενεργοποιημένη αν ο ιστότοπός σας δεν είναι προσβάσιμος από το Διαδίκτυο.';
$string['any'] = 'Οποιοδήποτε';
$string['anymethod'] = 'Ικανοποιηθεί οποιαδήποτε από τις επιλεγμένες συνθήκες';
$string['anymethodactivity'] = 'Ολοκληρωθεί οποιαδήποτε από τις επιλεγμένες δραστηριότητες';
$string['anymethodbadges'] = 'Οποιαδήποτε από τα επιλεγμένα διακριτικά έχουν απονεμηθεί';
$string['anymethodcohort'] = 'Συμμετοχή σε οποιοδήποτε από τα επιλεγμένα σύνολα χρηστών';
$string['anymethodcompetencies'] = 'Οποιαδήποτε από τις επιλεγμένες ικανότητες έχει ολοκληρωθεί';
$string['anymethodcourseset'] = 'Ολοκληρωθεί οποιοδήποτε από τα επιλεγμένα μαθήματα';
$string['anymethodmanual'] = 'Οποιοσδήποτε από τους επιλεγμένους ρόλους μπορεί να απονείμει το διακριτικό';
$string['anymethodprofile'] = 'Έχει ολοκληρωθεί οποιοδήποτε από τα επιλεγμένα πεδία προφίλ';
$string['apiversion'] = 'Έκδοση API που υποστηρίζεται';
$string['archivebadge'] = 'Θέλετε να διαγράψετε το διακριτικό «{$a}», αλλά να διατηρηθούν τα διακριτικά που έχουν εκδοθεί;';
$string['archiveconfirm'] = 'Διαγραφή και διατήρηση εκδοθέντων διακριτικών';
$string['archivehelp'] = '<p>Αυτή η επιλογή σημαίνει ότι το διακριτικό θα επισημανθεί ως «σε απόσυρση» και δεν θα εμφανίζεται πλέον στη λίστα των διακριτικών. Οι χρήστες δεν θα έχουν πλέον τη δυνατότητα να κερδίσουν αυτό το διακριτικό, ωστόσο οι υπάρχοντες αποδέκτες του διακριτικού θα εξακολουθήσουν να εμφανίζουν αυτό το διακριτικό στη σελίδα του προφίλ τους και να το προωθούν στα εξωτερικά σακίδια (με διακριτικά) τους.</p><p>Αν θέλετε οι χρήστες σας να διατηρήσουν την πρόσβαση στα κερδισμένα διακριτικά τους, είναι σημαντικό να επιλέξετε αυτή την επιλογή αντί να διαγράψετε πλήρως τα διακριτικά.</p>';
$string['attachment'] = 'Προσθήκη διακριτικού στο μήνυμα';
$string['attachment_help'] = 'Αν ενεργοποιηθεί, στο μήνυμα ηλε.ταχυδρομείου προς τον αποδέκτη, θα επισυναφθεί για λήψη, ένα αρχείο του εκδοθέντος διακριτικού. (Για να χρησιμοποιήσετε αυτή την επιλογή θα πρέπει να είναι ενεργοποιημένα τα συνημμένα στις «Ρυθμίσεις εμφάνισης ηλε.ταχυδρομείου» στη Διαχείριση ιστοτόπου / Εξυπηρετητής / Ηλε.ταχυδρομείο / Ρυθμίσεις εξερχόμενων μηνυμάτων ηλε.ταχυδρομείου.)';
$string['award'] = 'Απονομή διακριτικού';
$string['awardedtoyou'] = 'Εκδόθηκαν σε μένα';
$string['awardoncron'] = 'Η πρόσβαση στο διακριτικό ενεργοποιήθηκε με επιτυχία. Είναι πιθανό το διακριτικό να απονεμηθεί συγχρόνως σε πολλούς χρήστες. Για να διασφαλιστεί η απόδοση του ιστοτόπου, αυτή η ενέργεια θα χρειαστεί κάποιο χρόνο για να γίνει η επεξεργασία της.';
$string['awards'] = 'Παραλήπτες';
$string['backpackapiurl'] = 'Διεύθυνση URL API Σακιδίου';
$string['backpackavailability'] = 'Εξωτερική επαλήθευση διακριτικού';
$string['backpackavailability_help'] = 'Για να μπορούν οι αποδέκτες του διακριτικού να αποδείξουν ότι κέρδισαν τα διακριτικά τους από εσάς, μια εξωτερική υπηρεσία σακιδίου (με διακριτικά) πρέπει να έχει πρόσβαση στον ιστότοπό σας και να επαληθεύει τα διακριτικά που εκδίδονται από αυτήν. Προς το παρόν, ο ιστότοπός σας δεν φαίνεται να είναι προσβάσιμος, πράγμα που σημαίνει ότι τα διακριτικά που έχετε ήδη εκδώσει ή πρόκειται να εκδώσετε στο μέλλον δεν μπορούν να εξακριβωθούν.<br /> ** Γιατί βλέπω αυτό το μήνυμα;<br /> ** Ίσως το firewall σας να εμποδίζει την πρόσβαση από χρήστες εκτός του δικτύου σας, ο ιστότοπός σας να προστατεύεται με κωδικό πρόσβασης ή να εκτελείτε τον ιστότοπο σε υπολογιστή που δεν είναι διαθέσιμος από το Διαδίκτυο (όπως μηχανή τοπικής ανάπτυξης).<br /> ** Πρόκειται για πρόβλημα;<br /> ** Θα πρέπει να διορθώσετε αυτό το ζήτημα σε οποιαδήποτε τοποθεσία παραγωγής όπου σχεδιάζετε να εκδίδετε διακριτικά, διαφορετικά οι αποδέκτες δεν θα μπορούν να αποδείξουν ότι κέρδισαν τα διακριτικά τους από εσάς. Αν ο ιστότοπός σας δεν είναι ακόμα σε λειτουργία, μπορείτε να δημιουργήσετε και να εκδώσετε δοκιμαστικά διακριτικά, εφόσον ο ιστότοπος θα είναι προσβάσιμος πριν ξεκινήσετε τη λειτουργία του.<br /> ** Τι γίνεται αν δεν μπορώ να κάνω ολόκληρο τον ιστότοπό μου δημόσια προσβάσιμο;<br /> ** Η μόνη απαιτούμενη διεύθυνση URL για την επαλήθευση είναι η διεύθυνση [your-site-url]/badges/assertion.php. Έτσι εάν μπορείτε να τροποποιήσετε το firewall σας για να επιτρέψετε την εξωτερική πρόσβαση σε αυτό το αρχείο, η επαλήθευση του διακριτικού θα εξακολουθήσει να λειτουργεί.';
$string['backpackbadges'] = 'Έχετε {$a->totalbadges} διακριτικό/-ά που εμφανίζεται/-ονται από {$a->totalcollections} συλλογή/-ές. <a href="mybackpack.php">Αλλαγή ρυθμίσεων σακιδίου</a>.';
$string['backpackbadgessettings'] = 'Αλλαγή ρυθμίσεων σακιδίου';
$string['backpackbadgessummary'] = 'Έχετε {$a->totalbadges} διακριτικό/-ά που εμφανίζεται/-ονται από {$a->totalcollections} συλλογή/-ές.';
$string['backpackcannotsendverification'] = 'Αδυναμία αποστολής μηνύματος επαλήθευσης με ηλε.ταχυδρομείο';
$string['backpackconnection'] = 'Σύνδεση σακιδίου';
$string['backpackconnectioncancelattempt'] = 'Σύνδεση με τη χρήση διαφορετικής διεύθυνσης ηλε.ταχυδρομείου';
$string['backpackconnectionconnect'] = 'Σύνδεση στο σακίδιο';
$string['backpackconnection_help'] = 'Η σύνδεση σε ένα σακίδιο σας επιτρέπει να μοιράζεστε τα σήματα σας από αυτόν τον ιστότοπο και να εμφανίζετε δημόσιες συλλογές διακριτικών από το σακίδιο σας, στη σελίδα του προφίλ σας σε αυτόν τον ιστότοπο.';
$string['backpackconnectionnottested'] = 'Η σύνδεση δεν μπορεί να δοκιμαστεί για αυτό το σακίδιο για διακριτικά επειδή το υποστηρίζουν μόνο σακίδια OBv2.0.';
$string['backpackconnectionok'] = 'Η σύνδεση σακιδίου για διακριτικά δημιουργήθηκε με επιτυχία';
$string['backpackconnectionresendemail'] = 'Επανάληψη αποστολής με ηλε.ταχυδρομείο του μηνύματος επαλήθευσης';
$string['backpackconnectionunexpectedmessage'] = 'Το σακίδιο επέστρεψε το σφάλμα: «{$a}».';
$string['backpackconnectionunexpectedresult'] = 'Παρουσιάστηκε πρόβλημα σύνδεσης με το σακίδιό σας. Παρακαλούμε ελέγξτε τα στοιχεία σύνδεσης και δοκιμάστε ξανά.';
$string['backpackdetails'] = 'Ρυθμίσεις σακιδίου';
$string['backpackemail'] = 'Διεύθυνση ηλε.ταχυδρομείου';
$string['backpackemail_help'] = 'Η συνδεδεμένη με το σακίδιο (με τα διακριτικά) σας διεύθυνση ηλε.ταχυδρομείου. Όσο είστε συνδεδεμένος/-η, όποια διακριτικά σάς απονεμηθούν σε αυτόν τον ιστότοπο θα συσχετιστούν με αυτή τη διεύθυνση.';
$string['backpackemailverificationpending'] = 'Σε αναμονή επιβεβαίωσης';
$string['backpackemailverifyemailbody'] = 'Γεια σας,

Μια νέα σύνδεση στο σακίδιο σας με διακριτικά ζητήθηκε από τον ιστότοπο «{$a->sitename}» με χρήση της διεύθυνσής σας ηλε.ταχυδρομείου.

Για να επιβεβαιώσετε και να ενεργοποιήσετε την σύνδεση στο σακίδιό σας, παρακαλούμε πηγαίνετε στο

{$a->link}

Στα περισσότερα προγράμματα ηλε.ταχυδρομείου, αυτό θα εμφανιστεί ως ένας μπλε σύνδεσμος στον οποίο μπορείτε απλώς να κάνετε κλικ. Αν αυτό δεν λειτουργεί, τότε μπορείτε να κάνετε αποκοπή κι επικόλληση της διεύθυνσης στην γραμμή διευθύνσεων στο πάνω μέρος του περιηγητή ιστού σας.

Αν χρειάζεστε βοήθεια, παρακαλούμε επικοινωνήστε με τον διαχειριστή του ιστοτόπου,
{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: επαλήθευση διεύθυνσης ηλε.ταχυδρομείου από την υπηρεσία Σακιδίου για διακριτικά';
$string['backpackemailverifypending'] = 'Ένα μήνυμα επαλήθευσης στάλθηκε μέσω ηλε.ταχυδρομείου στο <strong>{$a}</strong>. Κάντε κλικ στο σύνδεσμο επαλήθευσης στο μήνυμα για να ενεργοποιήσετε τη σύνδεση με το Σακίδιο (με τα διακριτικά) σας.';
$string['backpackemailverifysuccess'] = 'Ευχαριστούμε για την επαλήθευση της διεύθυνσης ηλε.ταχυδρομείου σας. Έχετε τώρα συνδεθεί με το σακίδιο (με τα διακριτικά) σας.';
$string['backpackemailverifytokenmismatch'] = 'Το κουπόνι στο σύνδεσμο στον οποίο πατήσατε δεν αντιστοιχεί στο αποθηκευμένο κουπόνι. Βεβαιωθείτε ότι κάνατε κλικ στο σύνδεσμο στο πιο πρόσφατο μήνυμα ηλε.ταχυδρομείου που λάβατε.';
$string['backpackimport'] = 'Ρυθμίσεις εισαγωγής διακριτικού';
$string['backpackimport_help'] = 'Αφού η σύνδεση με το σακίδιο (με τα διακριτικά) εγκατασταθεί με επιτυχία, τα διακριτικά από το σακίδιό σας μπορούν να εμφανίζονται στην σελίδα των διακριτικών σας και στην σελίδα του προφίλ σας. Εδώ μπορείτε να επιλέξετε συλλογές διακριτικών από το σακίδιό σας που θα θέλατε να εμφανίζονται στο προφίλ σας.';
$string['backpackneedsupdate'] = 'Το σακίδιο που είναι συνδεδεμένο σε αυτό το προφίλ δεν ταιριάζει με το σακίδιο για τον ιστότοπο. Θα πρέπει να αποσυνδέσετε και να επανασυνδέσετε το σακίδιο.';
$string['backpacksettings'] = 'Ρυθμίσεις σακιδίου';
$string['backpackweburl'] = 'Διεύθυνση URL σακιδίου';
$string['badgedetails'] = 'Λεπτομέρειες διακριτικού';
$string['badgeimage'] = 'Εικόνα';
$string['badgeimage_help'] = 'Αυτή είναι μια εικόνα που θα χρησιμοποιηθεί όταν το διακριτικό εκδοθεί. Για να προσθέσετε μια νέα εικόνα, περιηγηθείτε και επιλέξτε μια εικόνα (σε μορφότυπο JPG ή PNG) και μετά κάντε κλικ στην «Αποθήκευση αλλαγών». Η εικόνα θα περικοπεί σε τετράγωνο και θα αλλάξει το μέγεθός της ώστε να ταιριάζει με τις προδιαγραφές της εικόνας διακριτικού.';
$string['badgeprivacysetting'] = 'Ρυθμίσεις απορρήτου διακριτικών';
$string['badgeprivacysetting_help'] = 'Τα διακριτικά που κερδίζετε μπορούν να εμφανίζονται στην σελίδα προφίλ του λογαριασμού σας. Αυτή η ρύθμιση επιτρέπει να ορίζεται αυτόματα η ορατότητα των διακριτικών που μόλις απονεμήθηκαν. Μπορείτε επίσης να ελέγχετε τις ρυθμίσεις απορρήτου κάθε διακριτικού στη σελίδα των διακριτικών σας.';
$string['badgeprivacysetting_str'] = 'Αυτόματη εμφάνιση διακριτικών που αποκτήθηκαν στην σελίδα προφίλ μου';
$string['badges'] = 'Διακριτικά';
$string['badgesalt'] = 'Salt (εμπλουτισμός κατατεμαχισμού με μη-μυστική, τυχαία τιμή, παρομοιάζεται με αλάτι) για τον κατατεμαχισμό της διεύθυνσης ηλε.ταχυδρομείου του αποδέκτη.';
$string['badgesalt_desc'] = 'Η χρήση μιας σύνοψης κατακερματισμού (hash, μη αντιστρεπτή αντιστοίχιση) επιτρέπει στις υπηρεσίες σακιδίου (με διακριτικά) να επαληθεύουν την αυθεντικότητα της ταυτότητας ενός αποδέκτη διακριτικού χωρίς να αποκαλύπτουν την διεύθυνση ηλε.ταχυδρομείου του. Αυτή η ρύθμιση πρέπει να χρησιμοποιεί μόνο αριθμούς και γράμματα. Σημείωση: για να είναι εφικτή η επαλήθευση του αποδέκτη, παρακαλούμε αποφύγετε να αλλάξετε αυτή τη ρύθμιση, από τη στιγμή που θα ξεκινήσετε να εκδίδετε διακριτικά.';
$string['badgesdisabled'] = 'Τα διακριτικά δεν έχουν ενεργοποιηθεί σε αυτή τη σελίδα.';
$string['badgesearned'] = 'Αριθμός διακριτικών που αποκτήθηκαν: {$a}';
$string['badgesettings'] = 'Ρυθμίσεις διακριτικών';
$string['badgestatus_0'] = 'Μη διαθέσιμα στους χρήστες';
$string['badgestatus_1'] = 'Διαθέσιμο σε χρήστες';
$string['badgestatus_2'] = 'Μη διαθέσιμα στους χρήστες';
$string['badgestatus_3'] = 'Διαθέσιμο σε χρήστες';
$string['badgestatus_4'] = 'Αρχειοθετημένα';
$string['badgestoearn'] = 'Αριθμός διαθέσιμων διακριτικών: {$a}';
$string['badgesview'] = 'Διακριτικά μαθήματος';
$string['badgeurl'] = 'Σύνδεσμος εκδιδόμενου διακριτικού';
$string['balignment'] = 'Εναρμονίσεις ({$a})';
$string['bawards'] = 'Αποδέκτες ({$a})';
$string['bcriteria'] = 'Κριτήρια';
$string['bdetails'] = 'Επεξεργασία λεπτομερειών';
$string['bendorsement'] = 'Έγκριση';
$string['bmessage'] = 'Μήνυμα';
$string['boverview'] = 'Επισκόπηση';
$string['brelated'] = 'Σχετικά διακριτικά ({$a})';
$string['bydate'] = 'ολοκλήρωση μέχρι';
$string['claim'] = 'Παραλαβή';
$string['claimcomment'] = 'Σχόλιο έγκρισης';
$string['claimid'] = 'Διεύθυνση URL παραλαβής';
$string['clearsettings'] = 'Εκκαθάριση ρυθμίσεων';
$string['completioninfo'] = 'Το διακριτικό αυτό εκδόθηκε για ολοκλήρωση:';
$string['completionnotenabled'] = 'Η ολοκλήρωση του μαθήματος δεν είναι ενεργοποιημένη για αυτό το μάθημα, κι έτσι δεν μπορεί να συμπεριληφθεί στα κριτήρια του διακριτικού. Η ολοκλήρωση του μαθήματος μπορεί να ενεργοποιηθεί από τις ρυθμίσεις του μαθήματος.';
$string['configenablebadges'] = 'Εάν ενεργοποιηθεί, αυτό το χαρακτηριστικό σας επιτρέπει να δημιουργείτε διακριτικά και να τα απονέμετε στους χρήστες του ιστοτόπου.';
$string['configuremessage'] = 'Μήνυμα διακριτικού';
$string['connect'] = 'Σύνδεση';
$string['connected'] = 'Συνδεδεμένος';
$string['connecting'] = 'Γίνεται σύνδεση...';
$string['contact'] = 'Επικοινωνία';
$string['contact_help'] = 'Μια διεύθυνση ηλε.ταχυδρομείου συνδεδεμένη με τον εκδότη του διακριτικού.';
$string['copyof'] = 'Αντίγραφο από {$a}';
$string['coursebadges'] = 'Διακριτικά';
$string['coursebadgesdisabled'] = 'Τα διακριτικά μαθήματος δεν είναι ενεργοποιημένα σε αυτόν τον ιστότοπο';
$string['coursecompletion'] = 'Οι χρήστες πρέπει να ολοκληρώσουν αυτό το μάθημα.';
$string['create'] = 'Νέο διακριτικό';
$string['createbutton'] = 'Δημιουργία διακριτικού';
$string['creatorbody'] = '<p>Ο/Η {$a->user} έχει ολοκληρώσει όλες τις απαιτήσεις και του απονεμήθηκε το διακριτικό. Δείτε το διακριτικό που έχει εκδοθεί στο {$a->link} </p>';
$string['creatorsubject'] = 'Το «{$a}» απονεμήθηκε!';
$string['criteria_0'] = 'Το διακριτικό απονέμεται όταν...';
$string['criteria_1'] = 'Ολοκλήρωση δραστηριότητας';
$string['criteria_1_help'] = 'Επιτρέπει σε ένα διακριτικό να απονεμηθεί σε χρήστες με βάση την ολοκλήρωση ενός συνόλου από δραστηριότητες μέσα σε ένα μάθημα.';
$string['criteria_2'] = 'Χειροκίνητη έκδοση από (χρήστη/ες με επιλεγμένο/ους) ρόλο';
$string['criteria_2_help'] = 'Επιτρέπει σε ένα διακριτικό να απονέμεται μη αυτόματα από χρήστες που έχουν συγκεκριμένο ρόλο μέσα στον ιστότοπο ή στο μάθημα.';
$string['criteria_3'] = 'Κοινωνική συμμετοχή';
$string['criteria_3_help'] = 'Κοινωνικός';
$string['criteria_4'] = 'Ολοκλήρωση μαθήματος';
$string['criteria_4_help'] = 'Επιτρέπει σε ένα διακριτικό να απονέμεται σε χρήστες που έχουν ολοκληρώσει ένα μάθημα. Αυτό το κριτήριο μπορεί να έχει επιπρόσθετες παραμέτρους όπως ελάχιστο βαθμό ή ημερομηνία ολοκλήρωσης του μαθήματος.';
$string['criteria_5'] = 'Ολοκλήρωση ενός συνόλου μαθημάτων';
$string['criteria_5_help'] = 'Επιτρέπει σε ένα διακριτικό να απονέμεται σε χρήστες που έχουν ολοκληρώσει ένα σύνολο από μαθήματα. Αυτό το κριτήριο μπορεί να έχει επιπρόσθετες παραμέτρους όπως ελάχιστο βαθμό ή ημερομηνία ολοκλήρωσης του μαθήματος.';
$string['criteria_6'] = 'Ολοκλήρωση προφίλ';
$string['criteria_6_help'] = 'Επιτρέπει σε ένα διακριτικό να απονέμεται σε χρήστες που έχουν συμπληρώσει συγκεκριμένα πεδία στο προφίλ τους. Μπορείτε να διαλέξετε από τα έτοιμα ή τα προσαρμοσμένα πεδία προφίλ που είναι διαθέσιμα στους χρήστες.';
$string['criteria_7'] = 'Διακριτικά που έχουν (ήδη) απονεμηθεί';
$string['criteria_7_help'] = 'Επιτρέπει την απονομή ενός διακριτικού σε χρήστες με βάση  άλλα διακριτικά που τους έχουν (ήδη) απονεμηθεί.';
$string['criteria_8'] = 'Συμμετοχή σε σύνολο/α χρηστών';
$string['criteria_8_help'] = 'Επιτρέπει την απονομή ενός διακριτικού σε χρήστες με βάση την συμμετοχή τους σε σύνολα χρηστών';
$string['criteria_9'] = 'Προσόντα';
$string['criteria_9_help'] = 'Επιτρέπει την απονομή ενός διακριτικού σε χρήστες με βάση τα προσόντα που έχουν ολοκληρώσει.';
$string['criteriacreated'] = 'Τα κριτήρια διακριτικού δημιουργήθηκαν με επιτυχία';
$string['criteriadeleted'] = 'Τα κριτήρια διακριτικού διαγράφηκαν με επιτυχία';
$string['criteria_descr'] = 'Στους χρήστες απονέμεται αυτό το διακριτικό όταν ολοκληρώσουν την ακόλουθη απαίτηση:';
$string['criteria_descr_0'] = 'Στους χρήστες απονέμεται αυτό το διακριτικό όταν ολοκληρώσουν <strong>{$a}</strong> από τις απαιτήσεις της λίστας.';
$string['criteria_descr_1'] = 'Να έχουν ολοκληρωθεί <strong>{$a}</strong> από τις ακόλουθες δραστηριότητες:';
$string['criteria_descr_2'] = 'Αυτό το διακριτικό πρέπει να απονέμεται από χρήστες με <strong>{$a}</strong> από τους εξής ρόλους:';
$string['criteria_descr_4'] = 'Οι χρήστες πρέπει να έχουν ολοκληρώσει το μάθημα';
$string['criteria_descr_5'] = 'Να έχουν ολοκληρωθεί <strong>{$a}</strong> από τα ακόλουθα μαθήματα.';
$string['criteria_descr_6'] = 'Να έχουν συμπληρωθεί <strong>{$a}</strong> από τα παρακάτω πεδία προφίλ χρήστη:';
$string['criteria_descr_7'] = 'Να έχουν απονεμηθεί στον χρήστη <strong>{$a}</strong> από τα παρακάτω διακριτικά:';
$string['criteria_descr_8'] = 'Συμμετοχή σε <strong>{$a}</strong> από τα ακόλουθα σύνολα χρηστών:';
$string['criteria_descr_9'] = '<strong>{$a}</strong> από τις ακόλουθες ικανότητες πρέπει να ολοκληρωθούν:';
$string['criteria_descr_bydate'] = 'μέχρι <em>{$a}</em>';
$string['criteria_descr_grade'] = 'με ελάχιστο βαθμό <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Ολοκλήρωση <strong>{$a}</strong> από:';
$string['criteria_descr_short1'] = 'Ολοκλήρωση <strong>{$a}</strong> από:';
$string['criteria_descr_short2'] = 'Απονομή <strong>{$a}</strong> από:';
$string['criteria_descr_short4'] = 'Ολοκλήρωση μαθήματος';
$string['criteria_descr_short5'] = 'Ολοκλήρωση <strong>{$a}</strong> από:';
$string['criteria_descr_short6'] = 'Ολοκλήρωση <strong>{$a}</strong> από:';
$string['criteria_descr_short7'] = 'Ολοκλήρωση <strong>{$a}</strong> από:';
$string['criteria_descr_short8'] = 'Συμμετοχή σε <strong>{$a}</strong> σύνολα χρηστών από:';
$string['criteria_descr_short9'] = 'Ολοκληρώστε <strong>{$a}</strong> από:';
$string['criteria_descr_single_1'] = 'Πρέπει να έχει ολοκληρωθεί η ακόλουθη δραστηριότητα:';
$string['criteria_descr_single_2'] = 'Αυτό το διακριτικό πρέπει να απονέμεται από χρήστη με τον εξής ρόλο:';
$string['criteria_descr_single_4'] = 'Οι χρήστες πρέπει να έχουν ολοκληρώσει το μάθημα';
$string['criteria_descr_single_5'] = 'Το παρακάτω μάθημα πρέπει να έχει ολοκληρωθεί:';
$string['criteria_descr_single_6'] = 'Το παρακάτω πεδίο προφίλ χρήστη πρέπει να έχει συμπληρωθεί:';
$string['criteria_descr_single_7'] = 'Πρέπει να έχει απονεμηθεί (στο χρήστη) το ακόλουθο σήμα:';
$string['criteria_descr_single_8'] = 'Απαιτείται συμμετοχή στο παρακάτω σύνολο χρηστών:';
$string['criteria_descr_single_9'] = 'Πρέπει να ολοκληρωθούν τα ακόλουθα προσόντα:';
$string['criteria_descr_single_short1'] = 'Ολοκλήρωση:';
$string['criteria_descr_single_short2'] = 'Απονέμεται από:';
$string['criteria_descr_single_short4'] = 'Ολοκλήρωση του μαθήματος';
$string['criteria_descr_single_short5'] = 'Ολοκλήρωση:';
$string['criteria_descr_single_short6'] = 'Ολοκλήρωση:';
$string['criteria_descr_single_short7'] = 'Ολοκλήρωση:';
$string['criteria_descr_single_short8'] = 'Συμμετοχή σε:';
$string['criteria_descr_single_short9'] = 'Ολοκλήρωση:';
$string['criteriasummary'] = 'Περίληψη κριτηρίων';
$string['criteriaupdated'] = 'Τα κριτήρια διακριτικού ενημερώθηκαν με επιτυχία';
$string['criterror'] = 'Ζητήματα τρεχουσών παραμέτρων';
$string['criterror_help'] = 'Αυτό το σύνολο από πεδία δείχνει όλες τις παραμέτρους που είχαν αρχικά προστεθεί σε αυτή την απαίτηση του διακριτικού αλλά δεν είναι πια διαθέσιμες. Συνιστάται να αποεπιλέξετε τέτοιες παραμέτρους για να βεβαιωθείτε ότι οι χρήστες στο μέλλον θα μπορούν να λαμβάνουν αυτό το διακριτικό.';
$string['currentimage'] = 'Τρέχουσα εικόνα';
$string['currentstatus'] = 'Τρέχουσα κατάσταση:';
$string['dateawarded'] = 'Ημερομηνία έκδοσης';
$string['dateearned'] = 'Ημερομηνία: {$a}';
$string['day'] = 'Ημέρα/ες';
$string['deactivate'] = 'Απενεργοποίηση πρόσβασης';
$string['deactivatesuccess'] = 'Η πρόσβαση στα διακριτικά απενεργοποιήθηκε με επιτυχία.';
$string['defaultissuercontact'] = 'Διεύθυνση ηλε.ταχυδρομείου εκδότη διακριτικού';
$string['defaultissuercontact_desc'] = 'Μια διεύθυνση ηλε.ταχυδρομείου που συσχετίζεται με τον εκδότη διακριτικού. Για ένα σακίδιο Open Badges v2.0, αυτό χρησιμοποιείται για τον έλεγχο ταυτότητας κατά την έκδοση διακριτικών σε ένα σακίδιο.';
$string['defaultissuername'] = 'Όνομα εκδότη διακριτικού';
$string['defaultissuername_desc'] = 'Ονομασία του εκδίδοντος φορέα ή αρχής.';
$string['defaultissuerpassword'] = 'Κωδικός πρόσβασης εκδότη διακριτικού';
$string['defaultissuerpassword_help'] = 'Απαιτείται ένας λογαριασμός στον ιστότοπο του σακιδίου με τη διεύθυνση ηλε.ταχυδρομείου όπως καθορίζεται στη ρύθμιση διεύθυνση ηλε.ταχυδρομείου εκδότη διακριτικού στη Διαχείριση ιστοτόπου / Διακριτικά / Ρυθμίσεις διακριτικών. Ο κωδικός πρόσβασης για τον λογαριασμό θα πρέπει να εισαχθεί εδώ.';
$string['delbadge'] = 'Θα θέλατε να διαγράψετε το διακριτικό «{$a}» και να διαγραφούν και όλα τα διακριτικά που έχουν εκδοθεί;';
$string['delconfirm'] = 'Διαγραφή και εξάλειψη όλων των διακριτικών που έχουν εκδοθεί';
$string['delcritconfirm'] = 'Σίγουρα θέλετε διαγραφή αυτού του κριτηρίου;';
$string['deletehelp'] = '<p>Πλήρης διαγραφή ενός διακριτικού σημαίνει πως όλες εγγραφές πληροφοριών και κριτηρίων του θα διαγραφούν μόνιμα.
Οι χρήστες στους οποίους απονεμήθηκε αυτό το διακριτικό δεν θα μπορούν πλέον να έχουν πρόσβαση σε αυτό και να το εμφανίζουν στις σελίδες προφίλ τους.</p><p>Σημείωση: Οι χρήστες στους οποίους απονεμήθηκε αυτό το διακριτικό και το έχουν ήδη προωθήσει στο εξωτερικό σακίδιο (με τα διακριτικά) τους, θα μπορούν ακόμη να το έχουν στα εξωτερικά σακίδιά τους.
Όμως, δεν θα μπορούν να έχουν πρόσβαση σε κριτήρια και σελίδες αποδεικτικών κατά τη σύνδεση σε αυτόν τον ιστότοπο.</p>';
$string['delexternalbackpackconfirm'] = 'Διαγραφή σακιδίου ιστοτόπου «{$a}»;';
$string['delparamconfirm'] = 'Σίγουρα θέλετε διαγραφή αυτής της παραμέτρου;';
$string['description'] = 'Περιγραφή';
$string['disconnect'] = 'Αποσύνδεση';
$string['donotaward'] = 'Αυτή τη στιγμή, αυτό το διακριτικό δεν είναι ενεργό κι έτσι δεν μπορεί να απονεμηθεί σε χρήστες. Αν θέλετε να το απονέμετε, παρακαλούμε αλλάξτε την κατάστασή του σε ενεργή.';
$string['editsettings'] = 'Επεξεργασία ρυθμίσεων';
$string['enablebadges'] = 'Ενεργοποίηση διακριτικών';
$string['endorsement'] = 'Έγκριση';
$string['error:backpackdatainvalid'] = 'Τα δεδομένα που επέστρεψαν από το σακίδιο ήταν άκυρα.';
$string['error:backpackemailnotfound'] = 'Η διεύθυνση ηλε.ταχυδρομείου «{$a}» δεν είναι συνδεδεμένη με ένα σακίδιο (με διακριτικά). Πρέπει να <a href="http://backpack.openbadges.org">δημιουργήσετε ένα σακίδιο (με τα διακριτικά σας)</a> για αυτό τον λογαριασμό ή να συνδεθείτε με άλλη διεύθυνση ηλε.ταχυδρομείου.';
$string['error:backpackloginfailed'] = 'Δεν μπορέσατε να συνδεθείτε με ένα εξωτερικό σακίδιο (με διακριτικά) για το εξής λόγο: {$a}';
$string['error:backpacknotavailable'] = 'Ο ιστότοπός σας δεν είναι προσβάσιμος από το Διαδίκτυο, έτσι όποια διακριτικά εκδόθηκαν από αυτόν τον ιστότοπο δεν μπορούν να επαληθευτούν από εξωτερικές υπηρεσίες σακιδίου (με διακριτικά).';
$string['error:backpackproblem'] = 'Υπήρξε ένα πρόβλημα κατά τη σύνδεση με τον πάροχο υπηρεσίας σακιδίου (με διακριτικά). Παρακαλούμε προσπαθήστε πάλι αργότερα.';
$string['error:badgeawardnotfound'] = 'Δεν μπορεί να επαληθευτεί το διακριτικό αυτό που έχει απονεμηθεί. Το διακριτικό αυτό ίσως έχει ανακληθεί.';
$string['error:badgenotfound'] = 'Το διακριτικό δεν βρέθηκε';
$string['error:badjson'] = 'Η προσπάθεια σύνδεσης επέστρεψε μη έγκυρα δεδομένα.';
$string['error:cannotact'] = 'Αδυναμία ενεργοποίησης διακριτικού.';
$string['error:cannotawardbadge'] = 'Αδυναμία απονομής διακριτικού σε χρήστη.';
$string['error:cannotdeletecriterion'] = 'Αυτό το κριτήριο δεν μπορεί να διαγραφεί.';
$string['error:cannotrevokebadge'] = 'Αδυναμία ανάκλησης διακριτικού από χρήστη.';
$string['error:clone'] = 'Αδυναμία αντιγραφής διακριτικού.';
$string['error:connectionunknownreason'] = 'Η σύνδεση ήταν μη επιτυχής αλλά δεν δόθηκε κάποια αιτιολόγηση.';
$string['error:duplicatename'] = 'Υπάρχει ήδη διακριτικό στο σύστημα με αυτό το όνομα.';
$string['error:externalbadgedoesntexist'] = 'Το διακριτικό δεν βρέθηκε πουθενά';
$string['error:guestuseraccess'] = 'Αυτή τη στιγμή έχετε πρόσβαση επισκέπτη. Για να δείτε διακριτικά χρειάζεται να συνδεθείτε με τον λογαριασμό χρήστη σας.';
$string['error:invalidbadgeurl'] = 'Άκυρος μορφότυπος διεύθυνσης URL εκδότη. Η διεύθυνση URL πρέπει να έχει πρόθεμα http: // ή https: //.';
$string['error:invalidcriteriatype'] = 'Μη έγκυρος τύπος κριτηρίων.';
$string['error:invalidexpiredate'] = 'Η ημερομηνία λήξης πρέπει να είναι στο μέλλον.';
$string['error:invalidexpireperiod'] = 'Η περίοδος λήξης δεν μπορεί να είναι αρνητική ή 0.';
$string['error:invalidparambadge'] = 'Το διακριτικό δεν υπάρχει.';
$string['error:invalidparamcohort'] = 'Το σύνολο χρηστών δεν υπάρχει.';
$string['error:noactivities'] = 'Δεν υπάρχουν δραστηριότητες με ενεργοποιημένα κριτήρια ολοκλήρωσης.';
$string['error:noassertion'] = 'Το Persona δεν επέστρεψε κανένα ισχυρισμό. Ίσως κλείσατε το παράθυρο διαλόγου πριν ολοκληρωθεί η διαδικασία σύνδεσης.';
$string['error:nobadges'] = 'Δεν υπάρχουν διακριτικά μαθήματος ή ιστοτόπου με ενεργοποιημένη πρόσβαση για να προστεθούν ως κριτήρια.';
$string['error:nocohorts'] = 'Καθόλου σύνολα χρηστών';
$string['error:nocourses'] = 'Η ολοκλήρωση μαθήματος δεν είναι ενεργοποιημένη για κανένα από τα μαθήματα στον ιστότοπο, οπότε δεν μπορεί να εμφανιστεί κανένα. Η ολοκλήρωση μαθήματος μπορεί να ενεργοποιηθεί στις ρυθμίσεις του μαθήματος.';
$string['error:nogroups'] = '<p>Δεν υπάρχουν δημόσιες συλλογές από διακριτικά διαθέσιμες στο σακίδιό σας.</p>
<p>Μόνο δημόσιες συλλογές εμφανίζονται.<a href="https://backpack.openbadges.org">Επισκεφτείτε το σακίδιό σας</a> για να δημιουργήσετε μερικές δημόσιες συλλογές.</p>';
$string['error:nogroupslink'] = '<p>Εμφανίζονται μόνο δημόσιες συλλογές. <a href="{$a}" target="_blank" rel="nofollow">Επισκεφθείτε το σακίδιό σας</a> για να δημιουργήσετε δημόσιες συλλογές.</p>';
$string['error:nogroupssummary'] = '<p>Δεν υπάρχουν δημόσιες συλλογές διακριτικών στο σακίδιό σας.</p>';
$string['error:nopermissiontoview'] = 'Δεν έχετε δικαίωμα να εμφανίσετε τους αποδέκτες του διακριτικού';
$string['error:nosuchbadge'] = 'Το διακριτικό με id (αναγνωριστικό) {$a} δεν υπάρχει.';
$string['error:nosuchcohort'] = 'Προειδοποίηση: Αυτό το σύνολο χρηστών δεν είναι πλέον διαθέσιμο.';
$string['error:nosuchcourse'] = 'Προειδοποίηση: Αυτό το μάθημα δεν είναι πλέον διαθέσιμο.';
$string['error:nosuchfield'] = 'Προειδοποίηση: Αυτό το πεδίο προφίλ χρήστη δεν είναι πλέον διαθέσιμο.';
$string['error:nosuchmod'] = 'Προειδοποίηση: Αυτή η δραστηριότητα δεν είναι πλέον διαθέσιμη.';
$string['error:nosuchrole'] = 'Προειδοποίηση: Αυτός ο ρόλος δεν είναι πλέον διαθέσιμος.';
$string['error:nosuchuser'] = 'Ο χρήστης με αυτή τη διεύθυνση ηλε.ταχυδρομείου δεν έχει έναν λογαριασμό στον τρέχοντα πάροχο υπηρεσίας σακιδίου (με διακριτικά).';
$string['error:notifycoursedate'] = 'Προσοχή: Τα διακριτικά που σχετίζονται με ολοκλήρωση μαθήματος ή δραστηριότητας δεν θα εκδοθούν μέχρι την ημερομηνία έναρξης του μαθήματος.';
$string['error:parameter'] = 'Προειδοποίηση: Τουλάχιστον μία παράμετρος πρέπει να επιλεγεί για να εξασφαλιστεί σωστή ροή εργασίας έκδοσης διακριτικών.';
$string['error:personaneedsjs'] = 'Προς το παρόν, η Javascript είναι απαραίτητη για να συνδεθείτε στο σακίδιο (με τα διακριτικά) σας. Αν μπορείτε ενεργοποιήστε την Javascript και ξαναφορτώστε τη σελίδα.';
$string['error:relatedbadgedoesntexist'] = 'Δεν υπάρχει δημόσιο διακριτικό με αυτό το αναγνωριστικό';
$string['error:requesterror'] = 'Το αίτημα σύνδεσης απέτυχε (κωδικός σφάλματος {$a}).';
$string['error:requesttimeout'] = 'Το αίτημα σύνδεσης έληξε πριν ολοκληρωθεί.';
$string['error:save'] = 'Αδυναμία αποθήκευσης του διακριτικού.';
$string['error:userdeleted'] = '{$a->user} (Αυτός ο χρήστης δεν υπάρχει πια στο {$a->site})';
$string['eventbadgearchived'] = 'Το διακριτικό αρχειοθετήθηκε';
$string['eventbadgeawarded'] = 'Το διακριτικό απονεμήθηκε';
$string['eventbadgecreated'] = 'Το διακριτικό δημιουργήθηκε';
$string['eventbadgecriteriacreated'] = 'Τα κριτήρια διακριτικού δημιουργήθηκαν';
$string['eventbadgecriteriadeleted'] = 'Τα κριτήρια διακριτικού διαγράφηκαν';
$string['eventbadgecriteriaupdated'] = 'Τα κριτήρια διακριτικού ενημερώθηκαν';
$string['eventbadgedeleted'] = 'Το διακριτικό διαγράφηκε';
$string['eventbadgedisabled'] = 'Το διακριτικό απενεργοποιήθηκε';
$string['eventbadgeduplicated'] = 'Δημιουργήθηκε αντίγραφο διακριτικού';
$string['eventbadgeenabled'] = 'Το διακριτικό ενεργοποιήθηκε';
$string['eventbadgelistingviewed'] = 'Η λίστα διακριτικών προβλήθηκε';
$string['eventbadgerevoked'] = 'Το διακριτικό ανακλήθηκε';
$string['eventbadgeupdated'] = 'Το διακριτικό ενημερώθηκε';
$string['eventbadgeviewed'] = 'Το διακριτικό προβλήθηκε';
$string['evidence'] = 'Αποδεικτικό';
$string['existingrecipients'] = 'Υπάρχοντες αποδέκτες διακριτικών';
$string['existsinbackpack'] = 'Το διακριτικό υπάρχει ήδη στο σακίδιο';
$string['expired'] = 'Έληξε';
$string['expiredate'] = 'Το διακριτικό αυτό λήγει στις {$a}.';
$string['expireddate'] = 'Το διακριτικό αυτό έληξε στις {$a}.';
$string['expireperiod'] = 'Το διακριτικό αυτό λήγει {$a} μέρες(α) αφού εκδοθεί.';
$string['expireperiodh'] = 'Το διακριτικό αυτό λήγει {$a} ώρες(α) αφού εκδοθεί.';
$string['expireperiodm'] = 'Το διακριτικό αυτό λήγει {$a} λεπτά(ό) αφού εκδοθεί.';
$string['expireperiods'] = 'Το διακριτικό αυτό λήγει {$a} δευτερόλεπτα(ο) αφού εκδοθεί.';
$string['expirydate'] = 'Ημερομηνία λήξης';
$string['expirydate_help'] = 'Κατ\' επιλογή, τα διακριτικά μπορούν να λήγουν σε μια συγκεκριμένη ημερομηνία ή μπορεί να υπολογίζεται η ημερομηνία με βάση την ημερομηνία που εκδόθηκε το διακριτικό σε κάποιον χρήστη.';
$string['externalbadges'] = 'Τα διακριτικά μου από άλλους ιστοτόπους';
$string['externalbadges_help'] = 'Αυτή η περιοχή εμφανίζει διακριτικά από το εξωτερικό σας σακίδιο.';
$string['externalbadgesp'] = 'Διακριτικά από άλλους ιστοτόπους:';
$string['externalconnectto'] = 'Για να εμφανίσετε τα διακριτικά σας, πρέπει να <a href="{$a}">συνδεθείτε με ένα σακίδιο</a>.';
$string['fixed'] = 'Σταθερή ημερομηνία';
$string['hidden'] = 'Σε απόκρυψη';
$string['hiddenbadge'] = 'Δυστυχώς, ο ιδιοκτήτης του διακριτικού δεν έχει κάνει την πληροφορία αυτή διαθέσιμη.';
$string['imageauthoremail'] = 'Διεύθυνση ηλε.ταχυδρομείου του δημιουργού της εικόνας';
$string['imageauthoremail_help'] = 'Εάν έχει οριστεί, η διεύθυνση ηλε.ταχυδρομείου του δημιουργού της εικόνας του διακριτικού εμφανίζεται στη σελίδα του διακριτικού.';
$string['imageauthorname'] = 'Όνομα του δημιουργού της εικόνας';
$string['imageauthorname_help'] = 'Εάν έχει οριστεί, το όνομα του δημιουργού της εικόνας του διακριτικού εμφανίζεται στη σελίδα του διακριτικού.';
$string['imageauthorurl'] = 'Η διεύθυνση ιστού του δημιουργού της εικόνας';
$string['imageauthorurl_help'] = 'Εάν έχει οριστεί, εμφανίζεται στη σελίδα του διακριτικού ένας σύνδεσμος προς τον ιστότοπο του δημιουργού της εικόνας του διακριτικού. Η διεύθυνση ιστού πρέπει να έχει ένα πρόθεμα http: // ή https: //.';
$string['imagecaption'] = 'Λεζάντα εικόνας';
$string['imagecaption_help'] = 'Εάν έχει οριστεί, εμφανίζεται μια λεζάντα εικόνας στη σελίδα του διακριτικού.';
$string['invalidurl'] = 'Μη έγκυρη διεύθυνση ιστού';
$string['issuancedetails'] = 'Λήξη διακριτικού';
$string['issuedbadge'] = 'Πληροφορίες διακριτικού που εκδόθηκε';
$string['issuerdetails'] = 'Στοιχεία εκδότη';
$string['issueremail'] = 'Διεύθυνση ηλε.ταχυδρομείου';
$string['issueremail_help'] = 'Μια διεύθυνση επικοινωνίας ηλε.ταχυδρομείου του οργανισμού που εκδίδει την έγκρισή του.';
$string['issuername'] = 'Όνομα εκδότη';
$string['issuername_endorsement'] = 'Όνομα εγκρίνοντος';
$string['issuername_endorsement_help'] = 'Το όνομα αυτού που δίνει την έγκριση';
$string['issuername_help'] = 'Ονομασία του εκδίδοντος φορέα ή αρχής.';
$string['issuerurl'] = 'Διεύθυνση URL εκδότη';
$string['issuerurl_help'] = 'Ο ιστότοπος του οργανισμού που εκδίδει την έγκρισή του. Η διεύθυνση URL πρέπει να έχει ένα πρόθεμα http: // ή https: //.';
$string['language'] = 'Γλώσσα';
$string['language_help'] = 'Η γλώσσα που χρησιμοποιείται στη σελίδα του διακριτικού.';
$string['listbackpacks'] = 'Λίστα σακιδίων';
$string['localbadges'] = 'Τα διακριτικά μου από τον ιστότοπο {$a}';
$string['localbadgesh'] = 'Τα διακριτικά μου από αυτόν τον ιστότοπο';
$string['localbadgesh_help'] = 'Όλα τα διακριτικά που απονέμονται μέσα από αυτόν τον ιστότοπο ολοκληρώνοντας μαθήματα, δραστηριότητες μαθημάτων, και άλλα προαπαιτούμενα. Μπορείτε να διαχειριστείτε τα διακριτικά σας εδώ κάνοντάς τα δημόσια ή ιδιωτικά για την σελίδα προφίλ σας. Μπορείτε να κάνετε λήψη όλων των διακριτικών σας ή κάθε διακριτικού ξεχωριστά και να τα αποθηκεύσετε στον υπολογιστή σας. Ληφθέντα διακριτικά μπορούν να προστεθούν στο εξωτερικό σας σακίδιο (με τα διακριτικά) σας.';
$string['localbadgesp'] = 'Διακριτικά από {$a}:';
$string['localconnectto'] = 'Για να μοιραστείτε αυτά τα διακριτικά έξω από αυτόν τον ιστότοπο, πρέπει να <a href="{$a}">συνδεθείτε με μια υπηρεσία σακιδίου (με διακριτικά)</a>.';
$string['makeprivate'] = 'Κάνε ιδιωτικό';
$string['makepublic'] = 'Κάνε δημόσιο';
$string['managebackpacks'] = 'Διαχείριση σακιδίων';
$string['managebadges'] = 'Διαχείριση διακριτικών';
$string['message'] = 'Σώμα μηνύματος';
$string['messagebody'] = '<p>Σας έχει απονεμηθεί το διακριτικό «%badgename%»!</p>
<p>Περισσότερες πληροφορίες για αυτό το διακριτικό μπορούν να βρεθούν στην %badgelink% σελίδα πληροφοριών διακριτικού.</p>
<p>Μπορείτε να διαχειριστείτε και να κάνετε λήψη του διακριτικού από την {$a} σελίδα σας.</p>';
$string['messagesubject'] = 'Συγχαρητήρια! Μόλις κερδίσατε ένα διακριτικό!';
$string['method'] = 'Το κριτήριο ικανοποιείται όταν...';
$string['mingrade'] = 'Απαιτείται ελάχιστος βαθμός';
$string['month'] = 'Μήνας (-ες)';
$string['mybackpack'] = 'Οι ρυθμίσεις του σακιδίου (με τα διακριτικά) μου';
$string['mybadges'] = 'Τα διακριτικά μου';
$string['never'] = 'Ποτέ';
$string['newbadge'] = 'Προσθήκη νέου διακριτικού';
$string['newimage'] = 'Νέα εικόνα';
$string['noalignment'] = 'Αυτό το διακριτικό δεν έχει καθορισμένα πρότυπα ή εξωτερικές δεξιότητες.';
$string['noawards'] = 'Το διακριτικό δεν απονεμήθηκε ακόμη';
$string['nobackpack'] = 'Δεν υπάρχει υπηρεσία σακιδίου συνδεδεμένη με αυτόν τον λογαριασμό.<br />';
$string['nobackpackbadges'] = 'Δεν υπάρχουν καθόλου διακριτικά στις συλλογές που επιλέξατε. <a href="mybackpack.php">Προσθέστε περισσότερες συλλογές</a>.';
$string['nobackpackbadgessummary'] = 'Δεν υπάρχουν διακριτικά στις συλλογές που έχετε επιλέξει.';
$string['nobackpackcollections'] = 'Δεν επιλέχθηκαν καθόλου συλλογές διακριτικών. <a href="mybackpack.php">Προσθήκη συλλογών</a>.';
$string['nobackpackcollectionssummary'] = 'Δεν έχουν επιλεγεί συλλογές διακριτικών.';
$string['nobackpacks'] = 'Δεν υπάρχουν διαθέσιμα σακίδια';
$string['nobadges'] = 'Δεν υπάρχουν διαθέσιμα διακριτικά';
$string['nocompetencies'] = 'Δεν έχουν επιλεγεί προσόντα.';
$string['nocriteria'] = 'Δεν έχουν οριστεί κριτήρια για αυτό το διακριτικό ακόμη.';
$string['noendorsement'] = 'Αυτό το διακριτικό δεν έχει κάποια έγκριση.';
$string['noexpiry'] = 'Αυτό το διακριτικό δεν έχει ημερομηνία λήξης.';
$string['noparamstoadd'] = 'Δεν υπάρχουν καθόλου επιπρόσθετες παράμετροι διαθέσιμες για να προστεθούν σε αυτή την απαίτηση του διακριτικού.';
$string['norelated'] = 'Αυτό το διακριτικό δεν έχει κανένα σχετικό διακριτικό.';
$string['notacceptedrole'] = 'Ο ρόλος που σας έχει ανατεθεί αυτή τη στιγμή δεν είναι ανάμεσα στους ρόλους που μπορούν να εκδόσουν χειροκίνητα αυτό το διακριτικό.<br /> Αν θα θέλατε να δείτε χρήστες που έχουν ήδη κερδίσει αυτό το διακριτικό, μπορείτε να επισκεφτείτε τη σελίδα {$a}.';
$string['notconnected'] = 'Χωρίς σύνδεση';
$string['notealignment'] = 'Μπορούν να προσδιοριστούν εξωτερικές δεξιότητες ή πρότυπα με τα οποία εναρμονίζεται το σήμα. Οποιαδήποτε πρότυπα ή εξωτερικές δεξιότητες εμφανίζονται στη σελίδα σήματος.';
$string['noteendorsement'] = 'Μια έγκριση από τρίτο μέρος μπορεί να χρησιμοποιηθεί για να προσθέσει αξία στο διακριτικό. Για παράδειγμα, ένα διακριτικό που εκδίδεται από ένα διδάσκοντα μπορεί να εγκριθεί από το σχολείο/τη σχολή ή ένα διακριτικό που έχει εκδοθεί από έναν τοπικό φορέα πιστοποίησης μπορεί να εγκριθεί από τον εθνικό φορέα πιστοποίησης.';
$string['noterelated'] = 'Τα διακριτικά με μια σύνδεση μπορεί να επισημαίνονται ως σχετικά. Για παράδειγμα, διακριτικά με τα ίδια κριτήρια που εμφανίζονται σε διαφορετικές γλώσσες μπορούν να επισημαίνονται ως σχετικά. Οποιαδήποτε σχετικά διακριτικά εμφανίζονται στη σελίδα του διακριτικού.';
$string['nothingtoadd'] = 'Δεν υπάρχουν διαθέσιμα κριτήρια για προσθήκη.';
$string['notification'] = 'Ειδοποίηση δημιουργού διακριτικού';
$string['notification_help'] = 'Αυτή η ρύθμιση διαχειρίζεται ειδοποιήσεις που στέλνονται σε ένα δημιουργό διακριτικού για να ειδοποιηθεί ότι το διακριτικό έχει εκδοθεί.

Είναι διαθέσιμες οι ακόλουθες επιλογές:

* **ΠΟΤΕ** - Να μην αποστέλλονται ειδοποιήσεις.
* **ΚΑΘΕ ΦΟΡΑ** - Να αποστέλλεται μια ειδοποίηση κάθε φορά που το διακριτικό απονέμεται.
* **ΗΜΕΡΗΣΙΩΣ** - Να αποστέλλονται ειδοποιήσεις μία φορά την ημέρα.
* **ΕΒΔΟΜΑΔΙΑΙΑ** - Να αποστέλλονται ειδοποιήσεις μία φορά την εβδομάδα.
* **ΜΗΝΙΑΙΑ** - Να αποστέλλονται ειδοποιήσεις μία φορά τον μήνα.';
$string['notifydaily'] = 'Καθημερινά';
$string['notifyevery'] = 'Κάθε φορά';
$string['notifymonthly'] = 'Μηνιαία';
$string['notifyweekly'] = 'Εβδομαδιαία';
$string['numawards'] = 'Αυτό το διακριτικό έχει εκδοθεί σε <a href="{$a->link}">{$a->count}</a> χρήστες(-η).';
$string['numawardstat'] = 'Αυτό το διακριτικό έχει εκδοθεί σε {$a} χρήστες(η).';
$string['openbadgesv1'] = 'Open Badges v1.0';
$string['openbadgesv2'] = 'Open Badges v2.0';
$string['overallcrit'] = 'από τα επιλεγμένα κριτήρια ικανοποιούνται.';
$string['personaconnection'] = 'Συνδεθείτε με την διεύθυνση ηλ. ταχυδρομείου σας';
$string['personaconnection_help'] = 'Το Persona είναι ένα σύστημα για πιστοποίηση του εαυτού σας σε όλο τον Παγκόσμιο Ιστό, με χρήση μιας διεύθυνσης ηλ. ταχυδρομείου που σας ανήκει. Η υπηρεσία σακιδίου (με διακριτικά) Open Badges χρησιμοποιεί το Persona ως ένα σύστημα αυθεντικοποίησης, κι έτσι για να μπορέσετε να συνδεθείτε με ένα σακίδιο θα χρειαστείτε έναν λογαριασμό Persona.

Για περισσότερες πληροφορίες επισκεφτείτε <a href="https://login.persona.org/about">https://login.persona.org/about</a>.';
$string['potentialrecipients'] = 'Ενδεχόμενοι αποδέκτες του διακριτικού';
$string['preferences'] = 'Προτιμήσεις διακριτικών';
$string['privacy:metadata:backpack'] = 'Ιστορικό σακιδίων χρηστών';
$string['privacy:metadata:backpack:backpackuid'] = 'Μοναδικό αναγνωριστικό του σακιδίου';
$string['privacy:metadata:backpack:email'] = 'Η διεύθυνση ηλε.ταχυδρομείου που συσχετίζεται με αυτό το σακίδιο';
$string['privacy:metadata:backpack:externalbackpackid'] = 'Το αναγνωριστικό του σακιδίου';
$string['privacy:metadata:backpack:userid'] = 'Το αναγνωριστικό του χρήστη του σακιδίου';
$string['privacy:metadata:badge'] = 'Μια συλλογή από διακριτικά';
$string['privacy:metadata:badge:timecreated'] = 'Πότε δημιουργήθηκε το διακριτικό';
$string['privacy:metadata:badge:timemodified'] = 'Πότε τροποποιήθηκε τελευταία το διακριτικό';
$string['privacy:metadata:badge:usercreated'] = 'Το αναγνωριστικό του χρήστη που δημιούργησε το διακριτικό';
$string['privacy:metadata:badge:usermodified'] = 'Το αναγνωριστικό του χρήστη που τροποποίησε το διακριτικό';
$string['privacy:metadata:criteriamet'] = 'Μια συλλογή από κριτήρια που ικανοποιήθηκαν';
$string['privacy:metadata:criteriamet:datemet'] = 'Η ημερομηνία ικανοποίησης των κριτηρίων';
$string['privacy:metadata:criteriamet:userid'] = 'Το αναγνωριστικό του χρήστη που ικανοποίησε τα κριτήρια';
$string['privacy:metadata:external:backpacks'] = 'Πληροφορίες που ανταλλάσσονται όταν οι χρήστες υποβάλουν τα διακριτικά τους σε ένα εξωτερικό σακίδιο';
$string['privacy:metadata:external:backpacks:badge'] = 'Το όνομα του διακριτικού';
$string['privacy:metadata:external:backpacks:description'] = 'Περιγραφή του διακριτικού';
$string['privacy:metadata:external:backpacks:image'] = 'Η εικόνα του διακριτικού';
$string['privacy:metadata:external:backpacks:issuer'] = 'Ορισμένες πληροφορίες σχετικά με τον εκδότη';
$string['privacy:metadata:external:backpacks:url'] = 'Η διεύθυνση URL του Moodle όπου μπορεί κανείς να δει το διακριτικό που έχει εκδοθεί.';
$string['privacy:metadata:issued'] = 'Ένα ιστορικό των διακριτικών που έχουν απονεμηθεί';
$string['privacy:metadata:issued:dateexpire'] = 'Η ημερομηνία κατά την οποία λήγει το διακριτικό';
$string['privacy:metadata:issued:dateissued'] = 'Η ημερομηνία του διακριτικού';
$string['privacy:metadata:issued:userid'] = 'Το αναγνωριστικό του χρήστη που απένειμε το διακριτικό';
$string['privacy:metadata:manualaward'] = 'Ένα ιστορικό χειροκίνητων διακριτικών';
$string['privacy:metadata:manualaward:datemet'] = 'Η ημερομηνία απονομής του διακριτικού στο χρήστη';
$string['privacy:metadata:manualaward:issuerid'] = 'Το αναγνωριστικό του χρήστη που απένειμε το διακριτικό';
$string['privacy:metadata:manualaward:issuerrole'] = 'Ο ρόλος του χρήστη που απένειμε το διακριτικό';
$string['privacy:metadata:manualaward:recipientid'] = 'Το αναγνωριστικό του χρήστη που χειροκίνητα απένειμε ένα διακριτικό';
$string['recipientdetails'] = 'Στοιχεία αποδέκτη';
$string['recipientidentificationproblem'] = 'Αδυναμία εύρεσης αποδέκτη αυτού του διακριτικού μεταξύ των υπαρχόντων χρηστών.';
$string['recipients'] = 'Αποδέκτες διακριτικού';
$string['recipientvalidationproblem'] = 'Ο τρέχων χρήστης δεν μπορεί να επαληθευτεί ως αποδέκτης αυτού του διακριτικού.';
$string['relatedbages'] = 'Σχετικά διακριτικά';
$string['relative'] = 'Σχετική ημερομηνία';
$string['requiredbadge'] = 'Τουλάχιστον ένα διακριτικό πρέπει να προστεθεί στο κριτήριο διακριτικού.';
$string['requiredcohort'] = 'Τουλάχιστον ένα σύνολο χρηστών πρέπει να προστεθεί στο κριτήριο συνόλου χρηστών.';
$string['requiredcompetency'] = 'Πρέπει να προστεθεί τουλάχιστον ένα προσόν στο κριτήριο του προσόντος.';
$string['requiredcourse'] = 'Τουλάχιστον ένα μάθημα πρέπει να προστεθεί στο κριτήριο μαθήματος.';
$string['reviewbadge'] = 'Αλλαγές στην πρόσβαση διακριτικού';
$string['reviewconfirm'] = '<p>Αυτό θα κάνει το διακριτικό σας ορατό στους χρήστες και θα τους επιτρέψει να ξεκινήσουν να το αποκτούν.</p>
<p>Είναι πιθανό κάποιοι χρήστες να ικανοποιούν ήδη τα κριτήρια του διακριτικού και θα τους απονεμηθεί αμέσως μόλις το ενεργοποιήσετε.</p>
<p>Από τη στιγμή που ένα διακριτικό έχει εκδοθεί θα γίνει <strong>κλειδωμένο</strong> - συγκεκριμένες ρυθμίσεις που συμπεριλαμβάνουν τα κριτήρια και τις ρυθμίσεις λήξης, δεν μπορούν πια να αλλάξουν.</p>
<p>Είστε σίγουροι ότι θέλετε να ενεργοποιήσετε την πρόσβαση στο διακριτικό «{$a}»;</p>';
$string['revoke'] = 'Ανάκληση διακριτικού';
$string['save'] = 'Αποθήκευση';
$string['searchname'] = 'Αναζήτηση με βάση το όνομα';
$string['selectaward'] = 'Παρακαλούμε επιλέξτε τον ρόλο που θα θέλατε να χρησιμοποιήσετε για να απονείμετε αυτό το διακριτικό:';
$string['selectgroup_end'] = 'Εμφανίζονται μόνο δημόσιες συλλογές. <a href="{$a}">Επισκεφθείτε το σακίδιο σας</a> για να δημιουργήσετε νέες δημόσιες συλλογές.';
$string['selectgroup_start'] = 'Επιλέξτε συλλογές από το σακίδιο (με τα διακριτικά) σας για να εμφανιστούν σε αυτόν τον ιστότοπο:';
$string['selecting'] = 'Με τα επιλεγμένα διακριτικά...';
$string['setup'] = 'Δημιουργία σύνδεσης';
$string['signinwithyouremail'] = 'Σύνδεση με την διεύθυνση ηλ. ταχυδρομείου σας';
$string['sitebackpack'] = 'Ενεργό εξωτερικό σακίδιο';
$string['sitebackpack_help'] = 'Το εξωτερικό σακίδιο στο οποίο μπορούν να συνδεθούν οι χρήστες από αυτόν τον ιστότοπο. Έχετε υπόψη ότι η αλλαγή αυτής της ρύθμισης μετά τη σύνδεση των χρηστών στα σακίδια τους θα απαιτήσει από τον κάθε χρήστη να μεταβεί στη σελίδα ρυθμίσεων του σακιδίου τους και να κάνει αποσύνδεση και επανασύνδεση.';
$string['sitebackpackverify'] = 'Σύνδεση σακιδίου';
$string['sitebackpackwarning'] = 'Δεν ήταν δυνατή η σύνδεση με σακίδιο.<br/><br/> Επιβεβαιώστε ότι η ρύθμιση «Διεύθυνση ηλε.ταχυδρομείου εκδότη διακριτικού» περιλαμβάνει την έγκυρη διεύθυνση για έναν λογαριασμό στον ιστότοπο του σακιδίου.<br/><br/>
Επιβεβαιώστε ότι ο «Κωδικός πρόσβασης εκδότη διακριτικού» στη σελίδα <a href="{$a->url}">ρυθμίσεις ιστοτόπου σακιδίου</a>, είναι ο σωστός κωδικός για το λογαριασμό στον ιστότοπο σακιδίου. <br/><br/>
Το σακίδιο επιστρέφει: «{$a->warning}»';
$string['sitebadges'] = 'Διακριτικά ιστοτόπου';
$string['sitebadges_help'] = 'Τα διακριτικά ιστοτόπου μπορούν να απονέμονται σε χρήστες μόνο για δραστηριότητες σχετικές με τον ιστότοπο. Αυτές συμπεριλαμβάνουν ολοκλήρωση ενός συνόλου από μαθήματα ή μέρη του προφίλ χρήστη. Τα διακριτικά ιστοτόπου μπορούν επίσης να εκδίδονται χειροκίνητα από έναν χρήστη σε έναν άλλο. Διακριτικά για δραστηριότητες σχετικές με μάθημα πρέπει να δημιουργούνται σε επίπεδο μαθήματος. Μπορείτε να βρείτε τα διακριτικά μαθήματος στην επιλογή του μενού (πλοήγησης) Διακριτικά κάτω από τη διαχείριση του μαθήματος.';
$string['status'] = 'Κατάσταση διακριτικού';
$string['status_help'] = 'Η κατάσταση ενός διακριτικού καθορίζει τη συμπεριφορά του στο σύστημα:

* **ΔΙΑΘΕΣΙΜΟ** - Σημαίνει ότι αυτό το διακριτικό μπορεί να αποκτηθεί από τους χρήστες. Όσο ένα διακριτικό είναι διαθέσιμο στους χρήστες, δεν είναι δυνατή η τροποποίηση των κριτηρίων του.

* **ΜΗ ΔΙΑΘΕΣΙΜΟ** - Σημαίνει ότι αυτό το διακριτικό δεν είναι διαθέσιμο στους χρήστες και δεν μπορεί να αποκτηθεί ή να εκδοθεί χειροκίνητα. Αν τέτοιο διακριτικό δεν έχει εκδοθεί ποτέ πριν, τότε τα κριτήριά του μπορούν να αλλάξουν.<br />
Από τη στιγμή που ένα διακριτικό έχει εκδοθεί σε τουλάχιστον ένα χρήστη, αυτόματα γίνεται **ΚΛΕΙΔΩΜΕΝΟ**. Τα κλειδωμένα διακριτικά μπορούν ακόμη να αποκτηθούν από χρήστες αλλά δεν είναι πλέον δυνατή η αλλαγή των κριτηρίων τους. Αν χρειάζεται να τροποποιήσετε λεπτομέρειες ή κριτήρια ενός κλειδωμένου διακριτικού, μπορείτε να δημιουργήσετε ένα αντίγραφο του διακριτικού και να κάνετε (εκεί) όλες τις απαιτούμενες αλλαγές.

*Γιατί κλειδώνουμε τα διακριτικά;*

Θέλουμε να εξασφαλίσουμε ότι όλοι οι χρήστες ικανοποιούν τα ίδια κριτήρια για να αποκτήσουν ένα διακριτικό. Προς το παρόν δεν είναι δυνατή η ανάκληση διακριτικών. Αν επιτρέπαμε να τροποποιούνται οι απαιτήσεις των διακριτικών οποτεδήποτε, τότε το πιο πιθανό είναι ότι θα καταλήγαμε με χρήστες που θα είχαν το ίδιο διακριτικό για την ικανοποίηση εντελώς διαφορετικών απαιτήσεων.';
$string['statusmessage_0'] = 'Αυτό το διακριτικό δεν είναι προς το παρόν διαθέσιμο σε χρήστες. Ενεργοποιήστε την πρόσβαση αν θέλετε χρήστες να το αποκτήσουν.';
$string['statusmessage_1'] = 'Αυτό το διακριτικό είναι προς το παρόν διαθέσιμο σε χρήστες. Απενεργοποιήστε την πρόσβαση αν θέλετε να κάνετε οποιεσδήποτε αλλαγές.';
$string['statusmessage_2'] = 'Αυτό το διακριτικό δεν είναι προς το παρόν διαθέσιμο σε χρήστες και τα κριτήριά του είναι κλειδωμένα. Ενεργοποιήστε την πρόσβαση αν θέλετε χρήστες να το αποκτήσουν.';
$string['statusmessage_3'] = 'Αυτό το διακριτικό είναι προς το παρόν διαθέσιμο σε χρήστες και τα κριτήριά του είναι κλειδωμένα.';
$string['statusmessage_4'] = 'Αυτό το διακριτικό είναι προς το παρόν αρχειοθετημένο.';
$string['subject'] = 'Θέμα μηνύματος';
$string['targetcode'] = 'Κώδικας';
$string['targetcode_help'] = 'Ένα μοναδικό αναγνωριστικό συμβολοσειράς για την αναφορά της εξωτερικής δεξιότητας ή του προτύπου μέσα στο πλαίσιό της/του.';
$string['targetdescription'] = 'Περιγραφή';
$string['targetdescription_help'] = 'Σύντομη περιγραφή της εξωτερικής δεξιότητας ή του προτύπου.';
$string['targetframework'] = 'Πλαίσιο';
$string['targetframework_help'] = 'Το όνομα του πλαισίου του προτύπου ή της εξωτερικής δεξιότητας.';
$string['targetname'] = 'Όνομα';
$string['targetname_help'] = 'Η εξωτερική δεξιότητα ή το πρότυπο με το οποίο είναι εναρμονισμένο το διακριτικό.';
$string['targeturl'] = 'Διεύθυνση URL';
$string['targeturl_help'] = 'Ένας σύνδεσμος προς μια σελίδα που περιγράφει την εξωτερική δεξιότητα ή το πρότυπο. Η διεύθυνση URL θα πρέπει να έχει ένα πρόθεμα http:// ή https://.';
$string['testbackpack'] = 'Δοκιμή σακιδίου για διακριτικά «{$a}»';
$string['testsettings'] = 'Δοκιμή ρυθμίσεων';
$string['type'] = 'Τύπος';
$string['variablesubstitution'] = 'Αντικατάσταση μεταβλητών σε μηνύματα.';
$string['variablesubstitution_help'] = 'Σε ένα μήνυμα διακριτικού, συγκεκριμένες μεταβλητές μπορούν να παρεμβάλλονται στο θέμα και/ή στο σώμα ενός μηνύματος, έτσι ώστε να αντικατασταθούν με πραγματικές τιμές όταν το μήνυμα αποσταλεί. Οι μεταβλητές πρέπει να παρεμβάλλονται στο κείμενο ακριβώς όπως εμφανίζονται παρακάτω:
<br /> %badgename% : Αυτό θα αντικατασταθεί από το πλήρες όνομα του διακριτικού.
<br /> %username% : Αυτό θα αντικατασταθεί από το πλήρες όνομα του αποδέκτη.
<br /> %badgelink% :Αυτό θα αντικατασταθεί από την δημόσια URL διεύθυνση με πληροφορίες σχετικές με το
εκδιδόμενο διακριτικό.';
$string['version'] = 'Έκδοση';
$string['version_help'] = 'Το πεδίο έκδοσης μπορεί να χρησιμοποιηθεί για να παρακολουθείται η εξέλιξη του διακριτικού. Εάν έχει οριστεί, η έκδοση εμφανίζεται στη σελίδα του διακριτικού.';
$string['viewbadge'] = 'Εμφάνιση διακριτικού που εκδόθηκε';
$string['visible'] = 'Ορατό';
$string['warnexpired'] = '(Το διακριτικό αυτό έληξε!)';
$string['year'] = 'Έτος/η';
