<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'hub', language 'ru', branch 'MOODLE_37_STABLE'
 *
 * @package   hub
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addscreenshots'] = 'Добавить снимки экрана';
$string['advertise'] = 'Разместите информацию о Вашем курсе, чтобы желающие могли присоединиться';
$string['advertised'] = 'Для присоединившихся людей';
$string['advertiseon'] = 'Поделитесь этим курсом на {$a}';
$string['advertiseonhub'] = 'Поделитесь этим курсом для присоединившихся людей.';
$string['advertiseonmoodleorg'] = 'Разместить информацию об этом курсе на moodle.org';
$string['advertisepublication_help'] = 'Этот курс будет указан на Moodle.net как курс, на который люди могут записаться и быть его участником. На сайте должна быть включена самостоятельная регистрация на основе электронной почты и в этом курсе необходимо разрешить самостоятельную запись.';
$string['all'] = 'Все';
$string['allowglobalsearch'] = 'Опубликовать этот узел и разрешить глобальный поиск по всем курсам';
$string['allowpublicsearch'] = 'Опубликовать этот узел, чтобы люди могли присоединиться к нему';
$string['audience'] = 'Аудитория';
$string['audienceadmins'] = 'Администраторы Moodle';
$string['audienceeducators'] = 'Преподаватели';
$string['audience_help'] = 'Выберите предполагаемую аудиторию для курса.';
$string['audiencestudents'] = 'Студенты';
$string['badgesnumber'] = 'Количество значков ({$a})';
$string['badurlformat'] = 'Некорректный формат URL';
$string['cannotsearchcommunity'] = 'Извините, но у Вас недостаточно прав для просмотра этой страницы';
$string['community'] = 'Сообщество';
$string['communityremoved'] = 'Ссылка на этот курс была удалена из Вашего списка';
$string['completeregistration'] = 'Завершенная регистрация в Moodle.net';
$string['confirmregistration'] = 'Подтверждение регистрации';
$string['contactable'] = 'Публичная связь';
$string['contactable_help'] = 'Если выбрать «Да», то в каталоге будет отображаться Ваш адрес электронной почты.';
$string['contactemail'] = 'Адрес электронной почты контактного лица';
$string['contactname'] = 'Имя контактного лица';
$string['contactphone'] = 'Телефон';
$string['contactphone_help'] = 'Ваш номер телефона будет будет виден только администратору каталога и не будет опубликован.';
$string['continue'] = 'Продолжить';
$string['contributornames'] = 'Другие авторы';
$string['contributornames_help'] = 'Вы можете использовать это поле, чтобы перечислить имена тех, кто внес вклад в разработку курса.';
$string['coursemap'] = 'Карта курса';
$string['coursename'] = 'Название';
$string['courseprivate'] = 'Личный';
$string['coursepublic'] = 'Общедоступный';
$string['coursepublished'] = 'Этот курс был успешно опубликован на «{$a}».';
$string['courseshortname'] = 'Краткое название';
$string['courseshortname_help'] = 'Введите краткое название своего курса. Оно не обязательно должно быть уникальным.';
$string['coursesnumber'] = 'Количество курсов ({$a})';
$string['courseunpublished'] = 'Курс «{$a->courseshortname}» более не опубликован в каталоге «{$a->hubname}».';
$string['courseurl'] = 'URL курса';
$string['courseurl_help'] = 'Это - адрес Вашего курса. Этот адрес отображается как гиперссылка в результатах поиска.';
$string['creatorname'] = 'Автор';
$string['creatorname_help'] = 'Автор - это создатель курса.';
$string['creatornotes'] = 'Примечания автора';
$string['creatornotes_help'] = 'Примечания создателя - руководство для учителей по использованию курса.';
$string['deletescreenshots'] = 'Удалить эти снимки экрана';
$string['deletescreenshots_help'] = 'Удалить все текущие загруженные скриншоты.';
$string['demourl'] = 'URL демонстрации';
$string['demourl_help'] = 'Введите адрес демонстрациионной версии своего курса. По умолчанию это адрес Вашего курса. Он отображается как гиперссылка в результатах поиска.';
$string['description'] = 'Описание';
$string['description_help'] = 'Текст описания будут отображаться в списке курсов в Moodle.net';
$string['detectednotexistingpublication'] = 'В каталоге «{$a->hubname}» присутствует курс, который больше не существует. Сообщите администрации этого каталога, что следует удалить публикацию № {$a->id}.';
$string['downloadable'] = 'Загружаемый';
$string['educationallevel'] = 'Образовательный уровень';
$string['educationallevel_help'] = 'Выберите уровень образования, которому более всего соответствует курс.';
$string['edulevelassociation'] = 'Ассоциация';
$string['edulevelcorporate'] = 'Корпоративное';
$string['edulevelgovernment'] = 'Руководство';
$string['edulevelother'] = 'Другое';
$string['edulevelprimary'] = 'Начальное';
$string['edulevelsecondary'] = 'Среднее';
$string['eduleveltertiary'] = 'Высшее';
$string['emailalert'] = 'Уведомления по электронной почте';
$string['emailalert_help'] = 'Если этот параметр включен, то администратор каталога сможет отправлять Вам электронные письма о вопросах безопасности и других важных новостях.';
$string['enrollable'] = 'Зарегистрированный';
$string['errorbadimageheightwidth'] = 'Размер изображения не должен превышать {$a->width} X {$a->height}';
$string['errorcourseinfo'] = 'Произошла ошибка при извлечении метаданных курса из узла ({$a}). Попробуйте снова извлечь метаданные курса из узла, позже перезагрузив эту страницу. Вы также можете решить продолжить процесс регистрации с метаданными по умолчанию.';
$string['errorcoursepublish'] = 'Во время публикации курса произошла ошибка ({$a}). Попробуйте снова позже.';
$string['errorcoursewronglypublished'] = 'Moodle.net вернул сообщение об ошибке публикации. Позже попробуйте снова.';
$string['errorcron'] = 'Во время обновления регистрационной информации в каталоге «{$a->hubname}» произошла ошибка ({$a->errormessage})';
$string['errorcronnoxmlrpc'] = 'Чтобы обновить регистрационную информацию необходимо включить XML-RPC';
$string['errorhublisting'] = 'Произошла ошибка получения списка каталога  Moodle. Пожалуйста, попробуйте снова позже. ({$a})';
$string['errorlangnotrecognized'] = 'Системе Moodle не известен указанный код языка. Свяжитесь с {$a}';
$string['errorotherhubsnotsupported'] = 'Эту страницу больше нельзя использовать для регистрации на сайтах, отличных от Moodle.net';
$string['errorregistration'] = 'Во время регистрации произошла ошибка, пожалуйста, попробуйте еще раз позже. ({$a})';
$string['errorregistrationupdate'] = 'Во время обновления регистрации произошла ошибка ({$a})';
$string['errorunpublishcourses'] = 'В связи с непредвиденной ошибкой не удалось удалить курсы из Moodle.net. Попробуйте повторить операцию позже (рекомендуется) или свяжитесь с администратором Moodle.net.';
$string['errorws'] = '{$a}';
$string['errorwstokenreset'] = '{$a}. Регистрационный токен на этом сайте был сброшен. Вы можете снова зарегистрировать свой сайт.';
$string['existingscreenshotnumber'] = 'Созданные скриншоты - {$a}. Вы сможете видеть эти скриншоты на странице только после того, как администратор Moodle.net откроет Ваш курс.';
$string['existingscreenshots'] = 'Существующие снимки экрана';
$string['forceunregister'] = 'Да, очистить регистрационные данные';
$string['forceunregisterconfirmation'] = 'Не удалось получить доступ к каталогу «{$a}». Возможно, этот каталог временно недоступен. Если Вы точно не уверены, что хотите удалить эту регистрацию только локально, отмените операцию и позже попробуйте снова.';
$string['geolocation'] = 'Геолокация';
$string['geolocation_help'] = 'В будущем мы сможем обеспечить поиск, основанный на местоположении. Если Вы хотите задать место расположения своего курса, используйте значения широты/долготы, (например: -31.947884, 115.871285). Одним из способов определения местоположения является использование Google Maps.';
$string['hub'] = 'Каталог';
$string['imageurl'] = 'URL изображения';
$string['imageurl_help'] = 'Это изображение будет отображаться в каталоге. Оно должно быть быть всегда доступным из каталога. Максимальный размер изображения {$a->width} X {$a->height}.';
$string['information'] = 'Информация';
$string['issuedbadgesnumber'] = 'Количество выданных значков ({$a})';
$string['language'] = 'Язык';
$string['language_help'] = 'Основной язык этого курса';
$string['lasttimechecked'] = 'Время последней проверки';
$string['licence'] = 'Лицензия';
$string['licence_help'] = 'Укажите лицензию, под которой Вы хотите распространять Ваш курс';
$string['logourl'] = 'URL логотипа';
$string['mobilenotificationsenabled'] = 'Мобильные уведомления включены ({$a})';
$string['mobileservicesenabled'] = 'Мобильные сервисы включены ({$a})';
$string['modulenumberaverage'] = 'Среднее число модулей в курсах ({$a})';
$string['moodleorg'] = 'Moodle';
$string['mustselectsubject'] = 'Необходимо указать тематику';
$string['name'] = 'Название';
$string['name_help'] = 'Это название будет показано в списке курсов.';
$string['neverchecked'] = 'Никогда не проверялся';
$string['next'] = 'Далее';
$string['no'] = 'Нет';
$string['nocheckstatusfromunreghub'] = 'Этот сайт не зарегистрирован в каталоге, поэтому статус не может быть проверен.';
$string['nohubselected'] = 'Каталог не выбран';
$string['none'] = 'Ни один';
$string['nosearch'] = 'Не опубликовывать каталог и курсы';
$string['notregisteredonhub'] = 'Ваш администратор должен зарегистрировать этот сайт на Moodle.net, прежде чем Вы сможете поделиться своим курсом.';
$string['notregisteredonmoodleorg'] = 'Вашему администратору необходимо зарегистрировать этот сайт на сайте moodle.org.';
$string['operation'] = 'Действия';
$string['orenterprivatehub'] = 'Или укажите URL частного каталога';
$string['participantnumberaverage'] = 'Среднее число участников ({$a})';
$string['policyagreed'] = 'Уведомление о конфиденциальности и соглашение об обработке данных';
$string['policyagreeddesc'] = 'Я согласен с <a href="{$a}" target="_blank">Уведомлением о конфиденциальности и соглашением об обработке данных</a> для Moodle.net';
$string['postaladdress'] = 'Почтовый адрес';
$string['postaladdress_help'] = 'Почтовый адрес этого сайта или лица, представляющего этот сайт.';
$string['postsnumber'] = 'Количество сообщений ({$a})';
$string['previousregistrationdeleted'] = 'Предыдущая регистрационная информация была удалена из каталога «{$a}». Вы можете перезапустить процесс регистрации. Спасибо';
$string['prioritise'] = 'Расставить приоритеты';
$string['privacy'] = 'Конфиденциальность';
$string['privacy_help'] = 'Некоторые каталоги опубликовывают список зарегистрированных сайтов. В этом случае Вы можете выбрать, следует ли выводить Ваш сайт в этом списке.';
$string['private'] = 'Частный';
$string['privatehuburl'] = 'URL частного каталога';
$string['publicationinfo'] = 'Опубликованная информация о курсе';
$string['publichub'] = 'Общественный каталог';
$string['publish'] = 'Опубликовать';
$string['publishcourse'] = 'Опубликовать курс «{$a}»';
$string['publishcourseon'] = 'Опубликовать в каталоге «{$a}»';
$string['publishedon'] = 'Курс опубликован';
$string['publisheremail'] = 'Адрес электронной почты издателя';
$string['publisheremail_help'] = 'Если указать адрес электронной почты того, кто опубликовал курс, администратор каталога сможет сообщить ему о любых изменениях в статусе опубликованного курса.';
$string['publishername'] = 'Издатель';
$string['publishername_help'] = 'Издатель - человек или организация, являющиеся официальным издателем курса. Если Вы не издаете курс от чьего-то имени, то издателем будете Вы.';
$string['publishon'] = 'Опубликовать в';
$string['publishonspecifichub'] = 'Опубликовать в другом каталоге';
$string['questionsnumber'] = 'Количество вопросов ({$a})';
$string['readvertiseon'] = 'Обновить регистрационную информацию в каталоге «{$a}»';
$string['registeredactiveuserdevices'] = 'Число активных пользователей с зарегистрированными мобильными устройствами, которые получают уведомления ({$a})';
$string['registeredcourses'] = 'Зарегистрированные курсы';
$string['registeredmoodleorg'] = 'Moodle ({$a})';
$string['registeredon'] = 'Где зарегистрирован ваш сайт';
$string['registeredsites'] = 'Зарегистрированные сайты';
$string['registereduserdevices'] = 'Число пользователей с зарегистрированными мобильными устройствами ({$a})';
$string['registermoochtips'] = 'Зарегистрируйте свой сайт в Moodle, чтобы получать  предупреждения о безопасности и иметь доступ к Moodle.net - нашей платформе распространения курсов.';
$string['registersite'] = 'Зарегистрироваться в каталоге «{$a}»';
$string['registerwith'] = 'Зарегистироваться в каталоге';
$string['registerwithmoodleorg'] = 'Зарегистрируйте свой сайт';
$string['registrationconfirmed'] = 'Регистрация сайта подтверждена';
$string['registrationconfirmedon'] = 'Спасибо за регистрацию вашего сайта. Регистрационная информация будет поддерживаться в актуальном состоянии запланированной задачей «Регистрация сайта».';
$string['registrationinfo'] = 'Регистрационная информация';
$string['registrationupdated'] = 'Регистрационная информация обновлена.';
$string['registrationupdatedfailed'] = 'Произошла ошибка обновления регистрационной информации.';
$string['removefromhub'] = 'Убрать из Moodle.net';
$string['renewregistration'] = 'Обновить регистрацию';
$string['resourcesnumber'] = 'Количество ресурсов ({$a})';
$string['restartregistration'] = 'Перезапустить процесс регистрации';
$string['roleassignmentsnumber'] = 'Количество назначений ролей ({$a})';
$string['screenshots'] = 'Снимки экрана';
$string['screenshots_help'] = 'Снимки экрана курса будут отображаться в результатах поиска.';
$string['search'] = 'Поиск';
$string['selecthub'] = 'Выберите каталог';
$string['selecthubforadvertise'] = 'Выберите каталог для размещения ссылки';
$string['selecthubforsharing'] = 'Выберите каталог для загрузки курса';
$string['selecthubinfo'] = 'Общественный каталог - это сервер, в котором перечислены курсы. Вы можете опубликовать информацию о курсах только в тех каталогах, в которых зарегистрирован этот сайт Moodle. Если необходимого Вам каталога нет в этом списке, свяжитесь с администратором этого сайта.';
$string['sendfollowinginfo'] = 'Дополнительная информация';
$string['sendfollowinginfo_help'] = 'Следующая информация отправляется только для вклада в общую статистику. Она не будет обнародована ни на одном сайте.';
$string['sendingcourse'] = 'Загрузка курса';
$string['sendingsize'] = 'Пожалуйста, подождите. Идет загрузка файла курса в каталог ({$a->total} Мб)...';
$string['sent'] = '...завершено';
$string['settings'] = 'Настройки';
$string['settingsupdated'] = 'Настройки были обновлены';
$string['share'] = 'Поделиться курсом с другими людьми, предоставив возможность его скачать.';
$string['shared'] = 'Для желающих скачать';
$string['shareon'] = 'Загрузить этот курс в каталог «{$a}»';
$string['shareonhub'] = 'Загрузить этот курс в каталог';
$string['sharepublication_help'] = 'Резервная копия этого курса будет доступна на Moodle.net. Желающие смогут его восстановить и использовать на своем собственном сайте.';
$string['siteadmin'] = 'Администратор';
$string['siteadmin_help'] = 'Полное имя администратора сайта.';
$string['sitecommnews'] = 'Обновления о новостях и возможностях Moodle';
$string['sitecommnews_help'] = 'У вас есть возможность подписаться на наш небольшой список рассылки, включающий информационный бюллетень о происходящем в сообществе Moodle.';
$string['sitecommnewsno'] = 'Нет, я не хочу получать электронные письма от Moodle HQ';
$string['sitecommnewsyes'] = 'Да, пожалуйста включите меня в обновления регулярного электронного информационного бюллетеня Moodle';
$string['sitecountry'] = 'Страна';
$string['sitecountry_help'] = 'Страна, в которой находится Ваша организация.';
$string['sitecreated'] = 'Сайт создан';
$string['sitedesc'] = 'Описание';
$string['sitedesc_help'] = 'Предоставьте некоторую информацию о том, как вы используете Moodle.';
$string['siteemail'] = 'Адрес электронной почты администратора';
$string['siteemail_help'] = 'Адрес электронной почты необходим, чтобы из штаб-квартиры Moodle могли связаться с Вами в случае необходимости. Он также может использоваться для других целей, которые вы разрешите ниже. Рекомендуется ввести адрес электронной почты, связанный с должностью (например: sitemanager@example.com), а не личный адрес.';
$string['sitegeolocation'] = 'Геолокация';
$string['sitegeolocation_help'] = 'Возможно, то в будущем мы внедрим поиск по каталогам на основе географического положения. Если Вы хотите указать расположение вашего сайта, укажите здесь широту и долготу (например:  -31.947884, 115.871285). Координаты можно узнать, например, с помощью Google Maps.';
$string['sitelang'] = 'Язык';
$string['sitelang_help'] = 'Какой основной язык используется на вашем сайте Moodle?';
$string['sitename'] = 'Название';
$string['sitename_help'] = 'Название сайта, которое будет отображаться в списке сайтов, если в каталоге это разрешено.';
$string['sitephone'] = 'Телефон';
$string['sitephone_help'] = 'Ваш номер телефона будет будет виден только администратору каталога.';
$string['siteprivacy'] = 'Список сайтов';
$string['siteprivacy_help'] = 'Вы можете опубликовать свой сайт в списке зарегистрированных сайтов со ссылкой на сайт или без неё.';
$string['siteprivacylinked'] = 'Показать название моего сайта со ссылкой';
$string['siteprivacynotpublished'] = 'Не показывать мой сайт в списке';
$string['siteprivacypublished'] = 'Отображать только имя моего сайта';
$string['siteregconfcomment'] = 'Ваш сайт требует окончательного подтверждения на {$a} (во избежание спама на {$a})';
$string['siteregistrationcontact'] = 'Показать форму для связи';
$string['siteregistrationcontact_help'] = 'Если вы разрешите, то другие люди из нашего сообщества Moodle (которые нуждаются в учетной записи входа в систему) смогут связаться с вами через форму на нашем сайте сообщества Moodle. Тем не менее, они никогда не смогут увидеть ваш адрес электронной почты.';
$string['siteregistrationemail'] = 'Уведомления о важных проблемах безопасности и технических вопросах.';
$string['siteregistrationemail_help'] = 'Вы можете подписаться для получения по электронной почте важных новостей (по вопросам безопасности или новым релизам).';
$string['siteregistrationupdated'] = 'Регистрационная информация обновлена';
$string['siterelease'] = 'Релиз Moodle';
$string['siterelease_help'] = 'Номер релиза системы Moodle на этом сайте';
$string['sitereleasenum'] = 'Релиз Moodle ({$a})';
$string['siteupdatedcron'] = 'Обновлена регистрационная информация в каталоге «{$a}»';
$string['siteupdatesend'] = 'Обновление регистрационной информации в каталогах завершено';
$string['siteupdatesstart'] = 'Начинается обновление регистрационной информации в каталогах...';
$string['siteurl'] = 'Адрес сайта';
$string['siteurl_help'] = 'Это адрес этого сайта. Если настройки конфиденциальности позволяют пользователям каталога видеть адреса сайтов, то отображаться будет именно этот.';
$string['siteversion'] = 'Версия Moodle';
$string['siteversion_help'] = 'Номер версии системы Moodle, установленной на этом сайте.';
$string['skipregistration'] = 'Пропустить';
$string['specifichubregistrationdetail'] = 'Вы можете также зарегистрироваться в других каталогах.';
$string['statistics'] = 'Конфиденциальность статистики';
$string['status'] = 'Список узлов';
$string['statuspublished'] = 'В списке';
$string['statusunpublished'] = 'Не в списке';
$string['subject'] = 'Тематика';
$string['subject_help'] = 'Выберите основную тематику, которую охватывает курс.';
$string['tags'] = 'Теги';
$string['tags_help'] = 'Теги помогают в дальнейшем классифицировать Ваш курс и упростить его поиск. Используйте простые, значащие слова и отделяйте их запятой. Пример: математика, алгебра, геометрия.';
$string['trustme'] = 'Доверять';
$string['type'] = 'Опубликован';
$string['unknownstatus'] = 'Неизвестен';
$string['unlistedurl'] = 'Адрес узла не в списке';
$string['unprioritise'] = 'Без проиритета';
$string['unpublish'] = 'Убрать из каталога';
$string['unpublishalladvertisedcourses'] = 'Удалить все курсы, которые были опубликованы на Moodle.net для присоединившихся людей.';
$string['unpublishalluploadedcourses'] = 'Убрать из Moodle.net все курсы, предназначенные для скачивания';
$string['unpublishconfirmation'] = 'Вы действительно собираетесь убрать курс «{$a->courseshortname}» из каталога «{$a->hubname}»?';
$string['unpublishcourse'] = 'Остановить публикацию {$a}';
$string['unregister'] = 'Убрать сайт из каталога';
$string['unregisterconfirmation'] = 'Вы собираетесь убрать этот сайт из каталога «{$a}». Как только Вы отключитесь от этого каталога, Вы не сможете управлять курсами, которые Вы там оставите. Вы уверены, что хотите удалить сайт из каталога?';
$string['unregisterexplained'] = 'Если сайт с URL {$a} зарегистрирован на Moodle.net, его регистрация будет удалена.';
$string['unregisterfrom'] = 'Убрать сайт из каталога «{$a}»';
$string['unregistrationerror'] = 'Во время попытки удаления сайта из каталога произошла ошибка: {$a}';
$string['untrustme'] = 'Не доверять';
$string['update'] = 'Обновить';
$string['updatesite'] = 'Обновить регистрационную информацию в каталоге «{$a}»';
$string['updatestatus'] = 'Проверить сейчас.';
$string['uploaded'] = 'Загруженный';
$string['url'] = 'URL каталога';
$string['urlalreadyregistered'] = 'Похоже, что Ваш сайт уже зарегистрирован в этом каталоге, а значит что-то пошло не так. Свяжитесь с администратором каталога, чтобы он сбросил Вашу регистрацию и Вы смогли бы попробовать снова.';
$string['usedifferentemail'] = 'Использовать другой адрес электронной почты';
$string['usersnumber'] = 'Количество пользователей ({$a})';
$string['warning'] = 'ПРЕДУПРЕЖДЕНИЕ';
$string['wrongtoken'] = 'В процессе регистрации произошла неизвестная ошибка (может быть проблемы с сетью?). Пожалуйста, попробуйте снова.';
$string['wrongurlformat'] = 'Некорректный формат URL';
$string['xmlrpcdisabledcommunity'] = 'На этом сервере не включено расширение XML-RPC языка PHP. Вы не можете осуществлять поиск и загрузку курсов.';
$string['xmlrpcdisabledpublish'] = 'На этом сервере не включено расширение XML-RPC языка PHP. Вы не можете опубликовывать курсы и управлять ими.';
$string['xmlrpcdisabledregistration'] = 'На сервере не включено расширение XML-RPC языка PHP. Пока Вы его не включите, будет невозможно удалить или обновить регистрационные данные.';
