<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'customcert', language 'ru', branch 'MOODLE_37_STABLE'
 *
 * @package   customcert
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcertpage'] = 'Добавить страницу';
$string['addelement'] = 'Добавить элемент';
$string['awardedto'] = 'Награждается';
$string['cannotverifyallcertificates'] = 'У Вас нет права для проверки всех сертификатов на этом сайте.';
$string['certificate'] = 'Сертификат';
$string['code'] = 'Код';
$string['copy'] = 'Копировать';
$string['coursetimereq'] = 'Необходимые минуты в курсе';
$string['coursetimereq_help'] = 'Введите минимальное время (в минутах), которое студент должен провести в курсе для возможности получить сертификат.';
$string['createtemplate'] = 'Создать шаблон';
$string['customcert:addinstance'] = 'Добавлять новый экземпляр сертификата';
$string['customcert:manage'] = 'Управлять сертификатом';
$string['customcert:manageemailothers'] = 'Управлять настройками электронной почты других пользователей';
$string['customcert:manageemailstudents'] = 'Управлять настройками электронной почты студентов';
$string['customcert:manageemailteachers'] = 'Управлять настройками электронной почты преподавателей';
$string['customcert:manageprotection'] = 'Управлять настройками защиты';
$string['customcert:managerequiredtime'] = 'Управлять необходимыми настройками времени';
$string['customcert:manageverifyany'] = 'Управлять настройками проверки';
$string['customcert:receiveissue'] = 'Получать сертификат';
$string['customcertsettings'] = 'Пользовательские настройки сертификата';
$string['customcert:verifyallcertificates'] = 'Проверять все сертификаты на этом сайте';
$string['customcert:verifycertificate'] = 'Подтверждать сертификат';
$string['customcert:view'] = 'Просматривать сертификат';
$string['customcert:viewallcertificates'] = 'Просматривать все сертификаты';
$string['customcert:viewreport'] = 'Просматривать отчет по курсу';
$string['deletecertpage'] = 'Удалить страницу сертификата';
$string['deleteconfirm'] = 'Подтверждение удаления';
$string['deleteelement'] = 'Удалить элемент';
$string['deleteelementconfirm'] = 'Вы уверены, что хотите удалить элемент?';
$string['deleteissueconfirm'] = 'Вы уверены, что хотите отменить выдачу сертификата?';
$string['deleteissuedcertificates'] = 'Удалить выданные сертификаты';
$string['deletepageconfirm'] = 'Вы уверены, что хотите удалить страницу сертификата?';
$string['deletetemplateconfirm'] = 'Вы уверены, что хотите удалить шаблон сертификата?';
$string['description'] = 'Описание';
$string['duplicate'] = 'Дублировать';
$string['duplicateconfirm'] = 'Подтверждение дубликата';
$string['duplicatetemplateconfirm'] = 'Вы уверены, что хотите продублировать этот шаблон сертификата?';
$string['editcustomcert'] = 'Редактировать сетрификат';
$string['editelement'] = 'Редактировать элемент';
$string['edittemplate'] = 'Редактировать шаблон';
$string['elementname'] = 'Название элемента';
$string['elementname_help'] = 'Оно будет использовано для идентификации этого элемента в процессе редактирования сертификата. Например, на странице сертификата может быть несколько изображений и Вам будет необходимо отличать их друг от друга при редактировании. Примечание: название не будет отображаться на PDF.';
$string['elementplugins'] = 'Плагины элементов';
$string['elements'] = 'Элементы';
$string['elements_help'] = 'Это список элементов, которые будут отображены на сертификате. Обратите внимание, что элементы отображаются в данном порядке. Порядок отображения может быть изменен при помощи стрелок, расположенных рядом с каждым элементом.';
$string['elementwidth'] = 'Ширина';
$string['elementwidth_help'] = 'Укажите ширину элемента - «0» означает, что ширина не ограничена.';
$string['emailnonstudentbody'] = 'Во вложении сертификат «{$a->certificatename}»  курса «{$a->coursefullname}». Получатель - {$a->userfullname}.';
$string['emailnonstudentbodyplaintext'] = 'В приложении сертификат «{$a->certificatename}» пользователя {$a->userfullname} для курса «{$a->coursefullname}».';
$string['emailnonstudentcertificatelinktext'] = 'Посмотреть отчет по сертификатам';
$string['emailnonstudentgreeting'] = 'Привет';
$string['emailnonstudentsubject'] = '{$a->coursename}: {$a->certificatename}';
$string['emailothers'] = 'Отправить эл. почту другим';
$string['emailothers_help'] = 'При выбранном параметре на указанные здесь адреса (разделенные запятой) будут высланы электронные письма с копией сертификата (когда он станет доступным).';
$string['emailstudentbody'] = 'Во вложении Ваш сертификат «{$a->certificatename}» курса «{$a->coursefullname}».';
$string['emailstudentbodyplaintext'] = 'В приложении Ваш сертификат «{$a->certificatename}» за курс «{$a->coursefullname}».';
$string['emailstudentcertificatelinktext'] = 'Просмотреть сертификат';
$string['emailstudentgreeting'] = 'Уважаемый (ая) {$a}';
$string['emailstudents'] = 'Отправить эл. почту студентам';
$string['emailstudents_help'] = 'При выбранном параметре студент получит письмо с копией сертификата (когда он станет доступным).';
$string['emailstudentsubject'] = '{$a->coursename}: {$a->certificatename}';
$string['emailteachers'] = 'Отправить эл. почту учителям';
$string['emailteachers_help'] = 'При выбранном параметре учителя получат письма с копией сертификата (когда он станет доступным).';
$string['exampledata'] = 'Пример {$a}:';
$string['exampledatawarning'] = 'Некоторые из этих значений могут быть просто примером того, как можно размещать элементы.';
$string['font'] = 'Шрифт';
$string['fontcolour'] = 'Цвет';
$string['fontcolour_help'] = 'Цвет шрифта.';
$string['font_help'] = 'Шрифт, используемый при создании данного элемента.';
$string['fontsize'] = 'Размер';
$string['fontsize_help'] = 'Размер шрифта в пунктах.';
$string['getcustomcert'] = 'Скачать сертификат';
$string['height'] = 'Высота';
$string['height_help'] = 'Это высота (в мм) сертификата в формате PDF. Для справки, высота листа формата А4 равна 297 мм, а высота листа формата Letter - 279 мм.';
$string['invalidcode'] = 'Введен недопустимый код.';
$string['invalidcolour'] = 'Выбран недопустимый цвет, пожалуйста введите допустимое для HTML название цвета (шестизначный или трехзначный шестнадцатеричный цвет).';
$string['invalidelementwidth'] = 'Введите положительное число.';
$string['invalidheight'] = 'Высота должна быть равна числу больше 0.';
$string['invalidmargin'] = 'Отступ должен быть равен числу больше 0.';
$string['invalidposition'] = 'Выберите положительное число для позиции {$a}.';
$string['invalidwidth'] = 'Ширина должна быть равна числу больше 0.';
$string['landscape'] = 'Альбомная';
$string['leftmargin'] = 'Левый отступ';
$string['leftmargin_help'] = 'Это левое поле сертификата PDF в мм.';
$string['listofissues'] = 'Получатели: {$a}';
$string['load'] = 'Загрузить';
$string['loadtemplate'] = 'Загрузить шаблон';
$string['loadtemplatemsg'] = 'Вы уверены, что хотите загрузить этот шаблон? Данное действие удалит все существующие страницы и элементы для этого сертификата.';
$string['managetemplates'] = 'Управление шаблонами';
$string['managetemplatesdesc'] = 'Эта ссылка переведет Вас на новую страницу, где Вы сможете управлять шаблонами, используемыми в пользовательских сертификатах элементов курса .';
$string['modify'] = 'Изменить';
$string['modulename'] = 'Сертификат';
$string['modulename_help'] = 'Этот модуль позволяет динамическое создание сертификатов в формате PDF.';
$string['modulenameplural'] = 'Сертификаты';
$string['mycertificates'] = 'Мои сертификаты';
$string['mycertificatesdescription'] = 'Это сертификаты, которые Вы получили по электронной почте или загрузили вручную.';
$string['name'] = 'Название';
$string['nametoolong'] = 'Вы превысили максимальную длину названия';
$string['nocustomcerts'] = 'Для данного курса нет сертификатов';
$string['noimage'] = 'Нет изображения';
$string['norecipients'] = 'Нет получателей';
$string['notemplates'] = 'Нет шаблонов';
$string['notissued'] = 'Не выдано';
$string['notverified'] = 'Не подтверждено';
$string['options'] = 'Опции';
$string['page'] = 'Страница {$a}';
$string['pluginadministration'] = 'Управление сертификатом';
$string['pluginname'] = 'Сертификат';
$string['portrait'] = 'Книжная';
$string['posx'] = 'Позиция X';
$string['posx_help'] = 'Это положение (в мм) от верхнего левого угла, в котором должна находиться опорная точка элемента в направлении X.';
$string['posy'] = 'Позиция Y';
$string['posy_help'] = 'Это положение (в мм) от верхнего левого угла, в котором должна находиться опорная точка элемента в направлении Y.';
$string['preventcopy'] = 'Защитить от копирования';
$string['preventcopy_desc'] = 'Включить защиту от копирования.';
$string['preventmodify'] = 'Запретить редактирование';
$string['preventmodify_desc'] = 'Включить защиту от редактирования.';
$string['preventprint'] = 'Защитить от печати';
$string['preventprint_desc'] = 'Включить защиту от печати.';
$string['print'] = 'Печать';
$string['privacy:metadata:customcert_issues'] = 'Список выданных сертификатов';
$string['privacy:metadata:customcert_issues:code'] = 'Код, который принадлежит сертификату';
$string['privacy:metadata:customcert_issues:customcertid'] = 'Идентификационный номер сертификата';
$string['privacy:metadata:customcert_issues:emailed'] = 'Был ли отправлен сертификат по электронной почте или нет';
$string['privacy:metadata:customcert_issues:timecreated'] = 'Время выдачи сертификата';
$string['privacy:metadata:customcert_issues:userid'] = 'Идентификационный номер пользователя, которому был выдан сертификат';
$string['rearrangeelements'] = 'Изменить расположение элементов';
$string['rearrangeelementsheading'] = 'Перетащите элементы для изменения их расположения на сертификате.';
$string['receiveddate'] = 'Дата получения';
$string['refpoint'] = 'Расположение точки привязки';
$string['refpoint_help'] = 'Точка привязки - это местоположение, из которого определяются координаты элемента X и Y. Она обозначается знаком «+», который появляется в центре или по углам элемента.';
$string['replacetemplate'] = 'Заменить';
$string['requiredtimenotmet'] = 'Вам нужно провести как минимум {$a->requiredtime} минут в курсе, прежде чем сертификат станет доступным.';
$string['rightmargin'] = 'Правый отступ';
$string['rightmargin_help'] = 'Правый отступ сертификата в мм.';
$string['save'] = 'Сохранить';
$string['saveandclose'] = 'Сохранить и закрыть';
$string['saveandcontinue'] = 'Сохранить и продолжить';
$string['savechangespreview'] = 'Сохранить изменения и начать предварительный просмотр';
$string['savetemplate'] = 'Сохранить шаблон';
$string['search:activity'] = 'Пользовательский сертификат - информация об активном элементе';
$string['setprotection'] = 'Установить защиту';
$string['setprotection_help'] = 'Выберите действия, которые Вы хотите запретить выполнять над этим сертификатом другим пользователям.';
$string['showposxy'] = 'Показать позиции X и Y';
$string['showposxy_desc'] = 'Это покажет позиции X и Y при редактировании элемента, позволяя пользователю указать точное местоположение.

Данное действие не требуется, если Вы планируете использовать для этой цели только интерфейс перетаскивания.';
$string['taskemailcertificate'] = 'Управление рассылкой сертификатов по электронной почте.';
$string['templatename'] = 'Название шаблона';
$string['templatenameexists'] = 'Это имя шаблона уже используется, пожалуйста, выберите другое.';
$string['topcenter'] = 'Центр';
$string['topleft'] = 'Верхний левый';
$string['topright'] = 'Верхний правый';
$string['type'] = 'Тип';
$string['uploadimage'] = 'Загрузить изображение';
$string['uploadimagedesc'] = 'Эта ссылка переключит Вас на новую вкладку, где Вы сможете загрузить изображения. Изображения, загруженные с помощью этого метода, будут доступны на Вашем сайте для всех пользователей, которые могут создать сертификат.';
$string['verified'] = 'Подтверждено';
$string['verify'] = 'Подтвердить';
$string['verifyallcertificates'] = 'Разрешить проверку всех сертификатов';
$string['verifyallcertificates_desc'] = 'При включенном параметре любой пользователь (включая пользователей, не вошедших в систему ) может перейти по ссылке «{$a}», чтобы проверить любой сертификат на сайте, а не переходить по ссылке проверки для каждого сертификата.

Примечание: это относится только к сертификатам, где в настройках сертификата напротив «Разрешить любому лицу проверять сертификат» было установлено значение «Да».';
$string['verifycertificate'] = 'Подтвердить сертификат';
$string['verifycertificateanyone'] = 'Разрешить всем подтверждать  сертификат';
$string['verifycertificateanyone_help'] = 'Этот параметр позволяет любому пользователю, имеющему ссылку на проверку сертификата (включая пользователей, не вошедших в систему) проверить сертификат.';
$string['verifycertificatedesc'] = 'Эта ссылка переведет Вас на новую вкладку, где Вы сможете проверить сертификаты на сайте';
$string['width'] = 'Ширина';
$string['width_help'] = 'Это ширина (в мм) сертификата в формате PDF. Для справки, ширина листа формата А4 равна 210 мм, а ширина листа формата Letter - 216 мм.';
