<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'eu', branch 'MOODLE_37_STABLE'
 *
 * @package   editor_tinymce
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Helbidea';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '0';
$string['advanced:anchor_desc'] = 'Txertatu/editatu aingura';
$string['advanced:backcolor_desc'] = 'Aukeratu atzeko planoaren kolorea';
$string['advanced:block'] = 'Formatua';
$string['advanced:blockquote'] = 'Aipua';
$string['advanced:blockquote_desc'] = 'Aipua';
$string['advanced:bold_desc'] = 'Lodia (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Txertatu/ezabatu buletdun zerrenda';
$string['advanced:charmap_delta_height'] = '0';
$string['advanced:charmap_delta_width'] = '0';
$string['advanced:charmap_desc'] = 'Txertatu karaktere bereziak';
$string['advanced:cleanup_desc'] = 'Garbitu kode zaborra';
$string['advanced:clipboard_msg'] = 'Kopiatu/ebaki/itsatsi egiteko aukera ez dago Mozilla eta Firefox-n.n Nahi al duzu gai honi buruzko informazio gehiago?';
$string['advanced:code'] = 'Kodea';
$string['advanced:code_desc'] = 'Editatu HTML iturburua';
$string['advanced:colorpicker_delta_height'] = '0';
$string['advanced:colorpicker_delta_width'] = '0';
$string['advanced:copy_desc'] = 'Kopiatu';
$string['advanced:custom1_desc'] = 'Zeure deskribapen pertsonalizatua hemen';
$string['advanced:cut_desc'] = 'Ebaki';
$string['advanced:dd'] = 'Definizio-deskribapena';
$string['advanced:div'] = 'DIV';
$string['advanced_dlg:'] = '0';
$string['advanced_dlg:about_author'] = 'Egilea';
$string['advanced_dlg:about_general'] = 'Honi buruz';
$string['advanced_dlg:about_help'] = 'Laguntza';
$string['advanced_dlg:about_license'] = 'Lizentzia';
$string['advanced_dlg:about_loaded'] = 'Kargatutako pluginak';
$string['advanced_dlg:about_plugin'] = 'Plugina';
$string['advanced_dlg:about_plugins'] = 'Pluginak';
$string['advanced_dlg:about_title'] = 'TinyMCE-ri buruz';
$string['advanced_dlg:about_version'] = 'Bertsioa';
$string['advanced_dlg:accessibility_help'] = 'Irisgarritasunerako laguntza';
$string['advanced_dlg:accessibility_usage_title'] = 'Erabilera orokorra';
$string['advanced_dlg:anchor_invalid'] = 'Zehaztu ainguraren izen baliagarria.';
$string['advanced_dlg:anchor_name'] = 'Ainguraren izena';
$string['advanced_dlg:anchor_title'] = 'Txertatu/editatu aingura';
$string['advanced_dlg:charmap_title'] = 'Aukeratu karaktere berezia';
$string['advanced_dlg:charmap_usage'] = 'Erabil ezkerra eta eskuina geziak nabigatzeko.';
$string['advanced_dlg:code_title'] = 'HTML iturburuaren editorea';
$string['advanced_dlg:code_wordwrap'] = 'Itzulbiratu';
$string['advanced_dlg:colorpicker_color'] = 'Kolorea:';
$string['advanced_dlg:colorpicker_name'] = 'Izena:';
$string['advanced_dlg:colorpicker_named_tab'] = 'Izendatuak';
$string['advanced_dlg:colorpicker_named_title'] = 'Izendatutako koloreak';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Paleta';
$string['advanced_dlg:colorpicker_palette_title'] = 'Kolore-aukerak';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Hautatzailea';
$string['advanced_dlg:colorpicker_picker_title'] = 'Kolore-hautzatzailea';
$string['advanced_dlg:colorpicker_title'] = 'Aukeratu kolorea';
$string['advanced_dlg:image_align'] = 'Lerrokadura';
$string['advanced_dlg:image_align_baseline'] = 'Oinarri-lerroa';
$string['advanced_dlg:image_align_bottom'] = 'Behera';
$string['advanced_dlg:image_align_left'] = 'Ezkerrera';
$string['advanced_dlg:image_align_middle'] = 'Erdira';
$string['advanced_dlg:image_align_right'] = 'Eskuinera';
$string['advanced_dlg:image_align_textbottom'] = 'Testua behera';
$string['advanced_dlg:image_align_texttop'] = 'Testua gora';
$string['advanced_dlg:image_align_top'] = 'Gora';
$string['advanced_dlg:image_alt'] = 'Irudiaren deskribapena';
$string['advanced_dlg:image_border'] = 'Ertza';
$string['advanced_dlg:image_dimensions'] = 'Dimentsioak';
$string['advanced_dlg:image_hspace'] = 'Espazio horizontala';
$string['advanced_dlg:image_list'] = 'Irudi-zerrenda';
$string['advanced_dlg:image_src'] = 'Irudiaren URLa';
$string['advanced_dlg:image_title'] = 'Txertatu/editatu irudia';
$string['advanced_dlg:image_vspace'] = 'Espazio bertikala';
$string['advanced_dlg:invalid_color_value'] = 'Kolorearen balio ezegokia';
$string['advanced_dlg:link_is_email'] = 'Idatzi duzun URLa helbide elektronikoa dirudi, nahi al duzu beharrezko den mailto: aurrizkia gehitzea?';
$string['advanced_dlg:link_is_external'] = 'Idatzi duzun URLak kanpoko esteka dirudi, nahi al duzu beharrezko den http:// aurrizkia gehitzea?';
$string['advanced_dlg:link_list'] = 'Esteka-zerrenda';
$string['advanced_dlg:link_target'] = 'Helburua';
$string['advanced_dlg:link_target_blank'] = 'Ireki esteka leiho berrian';
$string['advanced_dlg:link_target_same'] = 'Ireki esteka leiho berean';
$string['advanced_dlg:link_title'] = 'Txertatu/editatu esteka';
$string['advanced_dlg:link_titlefield'] = 'Izenburua';
$string['advanced_dlg:link_url'] = 'Estekaren URLa';
$string['advanced:dt'] = 'Definizio-terminoa';
$string['advanced:fontdefault'] = 'Letra-mota';
$string['advanced:font_size'] = 'Letra-tamaina';
$string['advanced:forecolor_desc'] = 'Aukeratu testuaren kolorea';
$string['advanced:h1'] = '1. izenburua';
$string['advanced:h2'] = '2. izenburua';
$string['advanced:h3'] = '3. izenburua';
$string['advanced:h4'] = '4. izenburua';
$string['advanced:h5'] = '5. izenburua';
$string['advanced:h6'] = '6. izenburua';
$string['advanced:help_desc'] = 'Laguntza';
$string['advanced:help_shortcut'] = 'Sakatu ALT-F10 tresna-barrarako. Sakatu ALT-0 laguntzarako';
$string['advanced:hr_desc'] = 'Txertatu marra horizontala';
$string['advanced:image_delta_height'] = '0';
$string['advanced:image_delta_width'] = '0';
$string['advanced:image_desc'] = 'Txertatu/editatu irudia';
$string['advanced:image_props_desc'] = 'Irudiaren ezaugarriak';
$string['advanced:indent_desc'] = 'Handitu koska';
$string['advanced:italic_desc'] = 'Etzana (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'Lerrokatu erdira';
$string['advanced:justifyfull_desc'] = 'Justifikatu';
$string['advanced:justifyleft_desc'] = 'Lerrokatu ezkerrera';
$string['advanced:justifyright_desc'] = 'Lerrokatu eskuinera';
$string['advanced:link_delta_height'] = '0';
$string['advanced:link_delta_width'] = '0';
$string['advanced:link_desc'] = 'Txertatu/editatu esteka';
$string['advanced:more_colors'] = 'Kolore gehiago...';
$string['advanced:newdocument'] = 'Ziur zaude eduki guztiak ezabatu nahi dituzula?';
$string['advanced:newdocument_desc'] = 'Dokumentu berria';
$string['advanced:numlist_desc'] = 'Txertatu/ezabatu zenbatutako zerrenda';
$string['advanced:outdent_desc'] = 'Txikitu koska';
$string['advanced:paragraph'] = 'Paragrafoa';
$string['advanced:paste_desc'] = 'Itsatsi';
$string['advanced:path'] = 'Bide-izena';
$string['advanced:pre'] = 'Preformateatua';
$string['advanced:redo_desc'] = 'Berregin (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Ezabatu formatua';
$string['advanced:rich_text_area'] = 'Testu-eremu aberastua';
$string['advanced:samp'] = 'Kode-adibidea';
$string['advanced:shortcuts_desc'] = 'Irisgarritasunerako laguntza';
$string['advanced:striketrough_desc'] = 'Marratua';
$string['advanced:style_select'] = 'Estiloak';
$string['advanced:sub_desc'] = 'Azpiindizea';
$string['advanced:sup_desc'] = 'Goi-indizea';
$string['advanced:toolbar'] = 'Tresna-barra';
$string['advanced:toolbar_focus'] = 'Joan tresna-botoietara - Alt+Q, Joan editorera - Alt-Z, Joan elementuaren bide-izenera - Alt-X';
$string['advanced:underline_desc'] = 'Azpimarratua (Ctrl+U)';
$string['advanced:undo_desc'] = 'Desegin (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Kendu esteka';
$string['advanced:visualaid_desc'] = 'Erakutsi/ezkutatu gidalerroak/ezkutuko elementuak';
$string['advhr:advhr_desc'] = 'Txertatu marra horizontala';
$string['advhr:delta_height'] = '0';
$string['advhr:delta_width'] = '0';
$string['advhr_dlg:normal'] = 'Arrunta';
$string['advhr_dlg:noshade'] = 'Itzalik gabe';
$string['advhr_dlg:size'] = 'Altuera';
$string['advhr_dlg:width'] = 'Zabalera';
$string['advhr_dlg:widthunits'] = 'Unitateak';
$string['advimage:delta_height'] = '0';
$string['advimage:delta_width'] = '0';
$string['advimage_dlg:align'] = 'Lerrokatu';
$string['advimage_dlg:align_baseline'] = 'Oinarri-lerroa';
$string['advimage_dlg:align_bottom'] = 'Behera';
$string['advimage_dlg:align_left'] = 'Ezkerrera';
$string['advimage_dlg:align_middle'] = 'Erdira';
$string['advimage_dlg:align_right'] = 'Eskuinera';
$string['advimage_dlg:align_textbottom'] = 'Testua behera';
$string['advimage_dlg:align_texttop'] = 'Testua gora';
$string['advimage_dlg:align_top'] = 'Gora';
$string['advimage_dlg:alt'] = 'Irudiaren deskribapena';
$string['advimage_dlg:alt_image'] = 'Ordezko irudia';
$string['advimage_dlg:border'] = 'Ertza';
$string['advimage_dlg:classes'] = 'Motak';
$string['advimage_dlg:constrain_proportions'] = 'Proportzio murriztuak';
$string['advimage_dlg:dialog_title'] = 'Txertatu/editatu irudia';
$string['advimage_dlg:dimensions'] = 'Dimentsioak';
$string['advimage_dlg:example_img'] = 'Irudi-itxuraren aurrebista';
$string['advimage_dlg:general'] = 'Orokorra';
$string['advimage_dlg:height'] = 'Altuera';
$string['advimage_dlg:hspace'] = 'Espazio horizontala';
$string['advimage_dlg:id'] = 'ID';
$string['advimage_dlg:image_list'] = 'Irudi-zerrenda';
$string['advimage_dlg:langcode'] = 'Hizkuntza-kodea';
$string['advimage_dlg:langdir'] = 'Hizkuntzaren norabidea';
$string['advimage_dlg:list'] = 'Irudi-zerrenda';
$string['advimage_dlg:long_desc'] = 'Deskribapen luzerako esteka';
$string['advimage_dlg:ltr'] = 'Ezkerretik eskuinera';
$string['advimage_dlg:map'] = 'Irudi-mapa';
$string['advimage_dlg:misc'] = 'Denetarikoak';
$string['advimage_dlg:missing_alt'] = 'Ziur zaude irudiaren deskribapena idatzi gabe jarraitu nahi duzula? Deskribapenik gabe, agian gutxitasuna duten erabiltzaileek ezingo dute irudia eskuratu, ezta nabigatzailea testu eran erabiltzen dutenek edota orriko irudiak desgaituta dituztenek.';
$string['advimage_dlg:mouseout'] = 'sagua kanpoan modurako';
$string['advimage_dlg:mouseover'] = 'sagua gainean modurako';
$string['advimage_dlg:preview'] = 'Aurreikusi';
$string['advimage_dlg:rtl'] = 'Eskuinetik ezkerrera';
$string['advimage_dlg:src'] = 'Irudiaren URLa';
$string['advimage_dlg:style'] = 'Estiloa';
$string['advimage_dlg:swap_image'] = 'Trukatu irudia';
$string['advimage_dlg:tab_advanced'] = 'Aurreratua';
$string['advimage_dlg:tab_appearance'] = 'Itxura';
$string['advimage_dlg:tab_general'] = 'Orokorra';
$string['advimage_dlg:title'] = 'Izenburua';
$string['advimage_dlg:vspace'] = 'Espazio bertikala';
$string['advimage_dlg:width'] = 'Zabalera';
$string['advimage:image_desc'] = 'Txertatu/editatu irudia';
$string['advlink:delta_height'] = '0';
$string['advlink:delta_width'] = '0';
$string['advlink_dlg:accesskey'] = 'Laster-tekla';
$string['advlink_dlg:advanced_props'] = 'Ezaugarri aurreratuak';
$string['advlink_dlg:advanced_tab'] = 'Aurreratua';
$string['advlink_dlg:anchor_names'] = 'Aingurak';
$string['advlink_dlg:classes'] = 'Motak';
$string['advlink_dlg:encoding'] = 'Helburuaren karaktere-kodifikazioa';
$string['advlink_dlg:event_props'] = 'Ekitaldiak';
$string['advlink_dlg:events_tab'] = 'Ekitaldiak';
$string['advlink_dlg:general_props'] = 'Ezaugarri orokorrak';
$string['advlink_dlg:general_tab'] = 'Orokorra';
$string['advlink_dlg:height'] = 'Altuera';
$string['advlink_dlg:id'] = 'ID';
$string['advlink_dlg:is_email'] = 'Idatzi duzun URLa helbide elektronikoa dirudi. Nahi al duzu beharrezko den mailto: aurrizkia gehitzea?';
$string['advlink_dlg:is_external'] = 'Idatzi duzun URLak kanpoko esteka dirudi. Nahi al duzu beharrezko den http:// aurrizkia gehitzea?';
$string['advlink_dlg:langcode'] = 'Hizkuntza-kodea';
$string['advlink_dlg:langdir'] = 'Hizkuntzaren norabidea';
$string['advlink_dlg:link_list'] = 'Esteka-zerrenda';
$string['advlink_dlg:list'] = 'Esteka-zerrenda';
$string['advlink_dlg:ltr'] = 'Ezkerretik eskuinera';
$string['advlink_dlg:mime'] = 'MIME motako helburua';
$string['advlink_dlg:popup'] = 'JavaScript popup';
$string['advlink_dlg:popup_dependent'] = 'Dependentea (Mozilla/Firefox soilik)';
$string['advlink_dlg:popup_location'] = 'Erakutsi kokapen-barra';
$string['advlink_dlg:popup_menubar'] = 'Erakutsi menu-barra';
$string['advlink_dlg:popup_name'] = 'Leihoaren izena';
$string['advlink_dlg:popup_opts'] = 'Aukerak';
$string['advlink_dlg:popup_position'] = 'Kokalekua (X/Y)';
$string['advlink_dlg:popup_props'] = 'Popup-aren ezaugarriak';
$string['advlink_dlg:popup_resizable'] = 'Leihoaren tamaina aldatzen utzi';
$string['advlink_dlg:popup_return'] = 'Txertatu  \'return false\'';
$string['advlink_dlg:popup_scrollbars'] = 'Erakutsi korritze-barra';
$string['advlink_dlg:popup_size'] = 'Tamaina';
$string['advlink_dlg:popup_statusbar'] = 'Erakutsi egoera-barra';
$string['advlink_dlg:popup_tab'] = 'Popup';
$string['advlink_dlg:popup_toolbar'] = 'Erakutsi tresna-barra';
$string['advlink_dlg:popup_url'] = 'Popup-en URLa';
$string['advlink_dlg:rel'] = 'Helbururako harreman-orria';
$string['advlink_dlg:rev'] = 'Helbururako harreman-orria';
$string['advlink_dlg:rtl'] = 'Eskuinetik ezkerrera';
$string['advlink_dlg:style'] = 'Estiloa';
$string['advlink_dlg:tabindex'] = 'Tabulazio-indizea';
$string['advlink_dlg:target'] = 'Helburua';
$string['advlink_dlg:target_blank'] = 'Ireki leiho berrian';
$string['advlink_dlg:target_langcode'] = 'Helburuaren hizkuntza';
$string['advlink_dlg:target_name'] = 'Helburuaren izena';
$string['advlink_dlg:target_parent'] = 'Ireki goragoko leihoan/markoan';
$string['advlink_dlg:target_same'] = 'Ireki leiho/marko honetan';
$string['advlink_dlg:target_top'] = 'Ireki goragoko markoan (ordezkatu marko guztiak)';
$string['advlink_dlg:title'] = 'Txertatu/editatu esteka';
$string['advlink_dlg:titlefield'] = 'Izenburua';
$string['advlink_dlg:url'] = 'Estekaren URLa';
$string['advlink_dlg:width'] = 'Zabalera';
$string['advlink:link_desc'] = 'Txertatu/editatu esteka';
$string['advlist:circle'] = 'Zirkulua';
$string['advlist:def'] = 'Lehenetsitakoa';
$string['advlist:disc'] = 'Diskoa';
$string['advlist:lower_alpha'] = 'Alfa minuskula';
$string['advlist:lower_greek'] = 'Letra greko minuskula';
$string['advlist:lower_roman'] = 'Letra erromatar xehea';
$string['advlist:square'] = 'Plaza';
$string['advlist:types'] = 'Motak';
$string['advlist:upper_alpha'] = 'Alfa maiuskula';
$string['advlist:upper_roman'] = 'Letra erromatar larria';
$string['aria:rich_text_area'] = 'Testu-eremu aberastua';
$string['autosave:restore_content'] = 'Berreskuratu automatikoki gordetako edukia';
$string['autosave:unload_msg'] = 'Orri honetatik irtenez gero, egindako aldaketak galdu egindgo dira.';
$string['autosave:warning_message'] = 'Gordetako edukia berreskuratzen baduzu, editorean orain dagoen edukia galduko duzu.

Ziur zaude edukia berreskuratu nahi duzula?';
$string['availablebuttons'] = 'Eskura dauden botoiak';
$string['colors:000000'] = 'Beltza';
$string['colors:000080'] = 'Urdin iluna';
$string['colors:0000FF'] = 'Urdina';
$string['colors:003300'] = 'Berde iluna';
$string['colors:003366'] = 'Azur iluna';
$string['colors:008000'] = 'Berdea';
$string['colors:008080'] = 'Zertzeta';
$string['colors:00CCFF'] = 'Zeru kolorea';
$string['colors:00FF00'] = 'Lima';
$string['colors:00FFFF'] = 'Ura';
$string['colors:333300'] = 'Oliba berdea';
$string['colors:333333'] = 'Oso gris iluna';
$string['colors:333399'] = 'Indigoa';
$string['colors:3366FF'] = 'Errege-urdina';
$string['colors:339966'] = 'Itsas urdina';
$string['colors:33CCCC'] = 'Turkesa';
$string['colors:666699'] = 'Urdin grisaska';
$string['colors:800000'] = 'Granatea';
$string['colors:800080'] = 'Kardinal kolorea';
$string['colors:808000'] = 'Oliba';
$string['colors:808080'] = 'Grisa';
$string['colors:993300'] = 'Laranja errea';
$string['colors:993366'] = 'Marroia';
$string['colors:999999'] = 'Tarteko grisa';
$string['colors:99CC00'] = 'Berde horiska';
$string['colors:99CCFF'] = 'Zeru kolore argia';
$string['colors:C0C0C0'] = 'Zilarra';
$string['colors:CC99FF'] = 'Okarana';
$string['colors:CCFFCC'] = 'Berde argia';
$string['colors:CCFFFF'] = 'Zian argia';
$string['colors:FF0000'] = 'Gorria';
$string['colors:FF00FF'] = 'Magenta';
$string['colors:FF6600'] = 'Laranja';
$string['colors:FF9900'] = 'Anbarra';
$string['colors:FF99CC'] = 'Arrosa';
$string['colors:FFCC00'] = 'Urrea';
$string['colors:FFCC99'] = 'Mertxikondoa';
$string['colors:FFFF00'] = 'Horia';
$string['colors:FFFF99'] = 'Hori argia';
$string['colors:FFFFFF'] = 'Zuria';
$string['common:apply'] = 'Aplikatu';
$string['common:browse'] = 'Arakatu';
$string['common:cancel'] = 'Utzi';
$string['common:class_name'] = 'Mota';
$string['common:clipboard_msg'] = 'Kopiatu/ebaki/itsatsi egiteko aukera ez dago Mozilla eta Firefox-n.n Nahi al duzu gai honi buruzko informazio gehiago?';
$string['common:clipboard_no_support'] = 'Zure nabigatzaileak ez du onartzen arbelerako funtziorik, erabil ezazu teklatua.';
$string['common:close'] = 'Itxi';
$string['common:edit_confirm'] = 'WYSIWYG era erabili nahi al duzu testu-kutxa honetarako?';
$string['common:insert'] = 'Txertatu';
$string['common:invalid_data'] = 'Errorea: Baliogabeak diren balioak sartu dituzu, gorriz markatuta daude.';
$string['common:invalid_data_min'] = '{#field}-(e)k zenbaki handiago izan behar du {#min}-(e)k baino';
$string['common:invalid_data_number'] = '{#field}-(e)k zenbakia izan behar du';
$string['common:invalid_data_size'] = '{#field}-(e)k zenbakia edo ehunekoa izan behar du';
$string['common:more_colors'] = 'Kolore gehiago...';
$string['common:not_set'] = '-- Ezarri gabea --';
$string['common:popup_blocked'] = 'Sentitzen dugu baina zabaltzen diren leihoen blokeoak aplikazioaren funtzioak dakartzan leiho bat desgaitu du. Blokeo hori kendu egin behar duzu gune honetarako funtzio guztiak erabili ahal izateko.';
$string['common:update'] = 'Eguneratu';
$string['common:value'] = '(balioa)';
$string['contextmenu:align'] = 'Lerrokatzea';
$string['contextmenu:center'] = 'Erdiratu';
$string['contextmenu:full'] = 'Osoa';
$string['contextmenu:left'] = 'Ezkerra';
$string['contextmenu:right'] = 'Eskuina';
$string['customconfig'] = 'Ezarpen pertsonalizatua';
$string['customconfig_desc'] = 'Pertsonalizatutako TinyMCE ezarpen aurreratua JSON formatuan, adibidez: {"aukera1" : "balio2", "aukera2" : "balio2"}. Hemen ezarritako aukerek ezarpen estandarrak eta pluginen ezarpenak baliogabetuko dituzte.';
$string['customtoolbar'] = 'Editorearen tresna-barra';
$string['customtoolbar_desc'] = 'Lerro bakoitzak komaz banatutako botoi izen zerrenda bat dauka, erabili "wrap" taldeak bereizteko, lerro hutsak ez dira kontuan hartuko. Ikusi <a href="{$a}" target="_blank">{$a}</a> TinyMCE-ren botoi zerrenda  lehenetsia ikusteko.<br /> Lehenengo lerroa beti erakutsiko da, eta bigarren eta hirugarren lerroak erakutsi edo ezkutatu daitezke.';
$string['directionality:ltr_desc'] = 'Ezkerretik eskuinerako norabidea';
$string['directionality:rtl_desc'] = 'Eskuinetik ezkerrerako norabidea';
$string['emotions:delta_height'] = '0';
$string['emotions:delta_width'] = '0';
$string['emotions_dlg:cool'] = 'Primeran';
$string['emotions_dlg:cry'] = 'Negarrez';
$string['emotions_dlg:desc'] = 'Emotikoneak';
$string['emotions_dlg:embarassed'] = 'Lotsatuta';
$string['emotions_dlg:foot_in_mouth'] = 'Oina ahoan';
$string['emotions_dlg:frown'] = 'Triste';
$string['emotions_dlg:innocent'] = 'Errugabea';
$string['emotions_dlg:kiss'] = 'Musuak';
$string['emotions_dlg:laughing'] = 'Barrez';
$string['emotions_dlg:money_mouth'] = 'Dirua ahoan';
$string['emotions_dlg:sealed'] = 'Itsatsita';
$string['emotions_dlg:smile'] = 'Irribarrea';
$string['emotions_dlg:surprised'] = 'Harrituta';
$string['emotions_dlg:title'] = 'Txertatu emotikonea';
$string['emotions_dlg:tongue_out'] = 'Mihia atera';
$string['emotions_dlg:undecided'] = 'Zalantzan';
$string['emotions_dlg:usage'] = 'Erabil ezkerra eta eskuina geziak nabigatzeko.';
$string['emotions_dlg:wink'] = 'Begi-keinua';
$string['emotions_dlg:yell'] = 'Haserre';
$string['emotions:emotions_desc'] = 'Emotikoneak';
$string['fontselectlist'] = 'Eskura dagoen letra-tipoen zerrenda';
$string['fullpage:delta_height'] = '0';
$string['fullpage:delta_width'] = '0';
$string['fullpage:desc'] = 'Dokumentuaren ezaugarriak';
$string['fullpage_dlg:active_color'] = 'Kolore aktiboa';
$string['fullpage_dlg:add'] = 'Gehitu beste elementu bat';
$string['fullpage_dlg:add_base'] = 'Oinarrizko elementua';
$string['fullpage_dlg:add_comment'] = 'Iruzkinak';
$string['fullpage_dlg:add_link'] = 'Esteka elementua';
$string['fullpage_dlg:add_meta'] = 'Metaelementua';
$string['fullpage_dlg:add_script'] = 'Script elementua';
$string['fullpage_dlg:add_style'] = 'Estilo elementua';
$string['fullpage_dlg:add_title'] = 'Izenburu elementua';
$string['fullpage_dlg:advanced_props'] = 'Aurreratua';
$string['fullpage_dlg:advanced_tab'] = 'Aurreratua';
$string['fullpage_dlg:appearance_bgprops'] = 'Atzeko planoaren ezaugarriak';
$string['fullpage_dlg:appearance_linkprops'] = 'Estekaren koloreak';
$string['fullpage_dlg:appearance_marginprops'] = 'Marjinak';
$string['fullpage_dlg:appearance_style'] = 'Estilo-orriaren eta estiloaren ezaugarriak';
$string['fullpage_dlg:appearance_tab'] = 'Itxura';
$string['fullpage_dlg:appearance_textprops'] = 'Testuaren ezaugarriak';
$string['fullpage_dlg:author'] = 'Egilea';
$string['fullpage_dlg:base_element'] = 'Oinarrizko elementua';
$string['fullpage_dlg:bgcolor'] = 'Atzeko planoaren kolorea';
$string['fullpage_dlg:bgimage'] = 'Atzeko planoko irudia';
$string['fullpage_dlg:bottom_margin'] = 'Beheko marjina';
$string['fullpage_dlg:charset'] = 'Karaktere-multzoa';
$string['fullpage_dlg:comment_element'] = 'Iruzkina';
$string['fullpage_dlg:content'] = 'Edukia';
$string['fullpage_dlg:copyright'] = 'Copyright-a';
$string['fullpage_dlg:defer'] = 'Atzeratu';
$string['fullpage_dlg:doctypes'] = 'Dokumentu-mota';
$string['fullpage_dlg:encoding'] = 'Karaktere-kodifikazioa';
$string['fullpage_dlg:fontface'] = 'Letra-tipoa';
$string['fullpage_dlg:font_face'] = 'Letra-tipoa';
$string['fullpage_dlg:fontsize'] = 'Letra-tamaina';
$string['fullpage_dlg:font_size'] = 'Letra-tamaina';
$string['fullpage_dlg:general_props'] = 'Orokorra';
$string['fullpage_dlg:head_elements'] = 'Goiburuaren elementuak';
$string['fullpage_dlg:hover_color'] = 'Goiburuaren kolorea';
$string['fullpage_dlg:href'] = 'HREF';
$string['fullpage_dlg:hreflang'] = 'HHEF lang';
$string['fullpage_dlg:info'] = 'Informazioa';
$string['fullpage_dlg:langcode'] = 'Hizkuntza-kodea';
$string['fullpage_dlg:langdir'] = 'Hizkuntzaren norabidea';
$string['fullpage_dlg:langprops'] = 'Hizkuntza eta kodifikazioa';
$string['fullpage_dlg:language'] = 'Hizkuntza';
$string['fullpage_dlg:left_margin'] = 'Ezkerreko marjina';
$string['fullpage_dlg:link_color'] = 'Estekaren kolorea';
$string['fullpage_dlg:link_element'] = 'Esteka elementua';
$string['fullpage_dlg:ltr'] = 'Ezkerretik eskuinera';
$string['fullpage_dlg:media'] = 'Media';
$string['fullpage_dlg:meta_description'] = 'Deskribapena';
$string['fullpage_dlg:meta_element'] = 'Metaelementua';
$string['fullpage_dlg:meta_index_follow'] = 'Indexatu eta jarraitu esketak';
$string['fullpage_dlg:meta_index_nofollow'] = 'Indexatu eta ez jarraitu esketak';
$string['fullpage_dlg:meta_keywords'] = 'Hitz-gakoak';
$string['fullpage_dlg:meta_noindex_follow'] = 'Ez indexatu baina jarraitu esketak';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Ez indexatu eta ez jarraitu esketak';
$string['fullpage_dlg:meta_props'] = 'Metainformazioa';
$string['fullpage_dlg:meta_robots'] = 'Robotak';
$string['fullpage_dlg:meta_tab'] = 'Orokorra';
$string['fullpage_dlg:meta_title'] = 'Izenburua';
$string['fullpage_dlg:movedown'] = 'Mugitu behera aukeratutako elementua';
$string['fullpage_dlg:moveup'] = 'Mugitu gora aukeratutako elementua';
$string['fullpage_dlg:name'] = 'Izena';
$string['fullpage_dlg:properties'] = 'Ezaugarriak';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'Ezabatu aukeratutako elementua';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'Eskuineko marjina';
$string['fullpage_dlg:rtl'] = 'Eskuinetik ezkerrera';
$string['fullpage_dlg:script_element'] = 'Script elementua';
$string['fullpage_dlg:src'] = 'Iturburua';
$string['fullpage_dlg:style'] = 'Estiloa';
$string['fullpage_dlg:style_element'] = 'Estilo elementua';
$string['fullpage_dlg:stylesheet'] = 'Estilo orria';
$string['fullpage_dlg:target'] = 'Helburua';
$string['fullpage_dlg:textcolor'] = 'Kolorea';
$string['fullpage_dlg:text_color'] = 'Testuaren kolorea';
$string['fullpage_dlg:title'] = 'Dokumentuaren ezaugarriak';
$string['fullpage_dlg:title_element'] = 'Izenburu elementua';
$string['fullpage_dlg:top_margin'] = 'Goiko marjina';
$string['fullpage_dlg:type'] = 'Mota';
$string['fullpage_dlg:value'] = 'Balioa';
$string['fullpage_dlg:visited_color'] = 'Bisitatutakoaren kolorea';
$string['fullpage_dlg:xml_pi'] = 'XML manifestua';
$string['fullscreen:desc'] = 'Aldatu pantaila osoko ikuspegira';
$string['iespell:download'] = 'Ez da zuzentzaile ortografikoa aurkitu. Orain instalatu nahi al duzu?';
$string['iespell:iespell_desc'] = 'Egiaztatu ortografia';
$string['insertdatetime:date_fmt'] = '%Y-%m-%d';
$string['insertdatetime:day_long'] = 'Igandea,Astelehena,Asteartea,Asteazkena,Osteguna,Ostirala,Larunbata';
$string['insertdatetime:day_short'] = 'Ig,Al,Ar,Az,Og,Or,Lr';
$string['insertdatetime:insertdate_desc'] = 'Txertatu data';
$string['insertdatetime:inserttime_desc'] = 'Txertatu ordua';
$string['insertdatetime:months_long'] = 'urtarrila,otsaila,martxoa,apirila,maiatza,ekaina,uztaila,abuztua,iraila,urria,azaroa,abendua';
$string['insertdatetime:months_short'] = 'urt,ots,mar,api,mai,eka,uzt,abu,ira,urr,aza,abe';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Txandakatu posizionamendu absolutua';
$string['layer:backward_desc'] = 'Mugitu atzera';
$string['layer:content'] = 'Geruza berria...';
$string['layer:forward_desc'] = 'Mugitu aurrera';
$string['layer:insertlayer_desc'] = 'Txertatu beste geruza bat';
$string['media:delta_height'] = '0';
$string['media:delta_width'] = '0';
$string['media:desc'] = 'Txertatu/editatu enbotatutako media';
$string['media_dlg:advanced'] = 'Aurreratua';
$string['media_dlg:align'] = 'Lerrokatu';
$string['media_dlg:align_bottom'] = 'Behera';
$string['media_dlg:align_bottom_left'] = 'Azpian ezkerrean';
$string['media_dlg:align_bottom_right'] = 'Azpian eskuinean';
$string['media_dlg:align_center'] = 'Erdian';
$string['media_dlg:align_left'] = 'Ezkerrean';
$string['media_dlg:align_right'] = 'Eskuinean';
$string['media_dlg:align_top'] = 'Goian';
$string['media_dlg:align_top_left'] = 'Goian ezkerrean';
$string['media_dlg:align_top_right'] = 'Goian eskuinean';
$string['media_dlg:altsource1'] = '1 ordezko iturburua';
$string['media_dlg:altsource2'] = '2 ordezko iturburua';
$string['media_dlg:audio'] = 'HTML5 audioa';
$string['media_dlg:autogotourl'] = 'Joan URL automatikora';
$string['media_dlg:autohref'] = 'AutoHREF';
$string['media_dlg:autostart'] = 'Hasiera automatikoa';
$string['media_dlg:balance'] = 'Balantzea';
$string['media_dlg:base'] = 'Oinarria';
$string['media_dlg:baseurl'] = 'Oinarrizko URLa';
$string['media_dlg:bgcolor'] = 'Atzeko planoa';
$string['media_dlg:cache'] = 'Cachea';
$string['media_dlg:captioningid'] = 'Captioning ID';
$string['media_dlg:center'] = 'Erdian';
$string['media_dlg:class_name'] = 'Mota';
$string['media_dlg:console'] = 'Kontsola';
$string['media_dlg:constrain_proportions'] = 'Proportzio murriztuak';
$string['media_dlg:controller'] = 'Kontrolatzailea';
$string['media_dlg:controls'] = 'Kontrolak';
$string['media_dlg:correction'] = 'Zuzenketarik ez';
$string['media_dlg:currentmarker'] = 'Oraingo kalifikatzailea';
$string['media_dlg:currentposition'] = 'Oraingo kokalekua';
$string['media_dlg:defaultframe'] = 'Marko lehenetsia';
$string['media_dlg:embeddedaudio'] = 'Enbotatutako audioa';
$string['media_dlg:embedded_audio_options'] = 'Enbotatutako audio-aukerak';
$string['media_dlg:enabled'] = 'Gaituta';
$string['media_dlg:enablejavascript'] = 'Gaitu JavaScript';
$string['media_dlg:endtime'] = 'Bukaera-ordua';
$string['media_dlg:file'] = 'Fitxategia/URLa';
$string['media_dlg:flash'] = 'Flash-a';
$string['media_dlg:flash_options'] = 'Flash aukerak';
$string['media_dlg:flashvars'] = 'Flash vars';
$string['media_dlg:fullscreen'] = 'Pantaila osoa';
$string['media_dlg:general'] = 'Orokorra';
$string['media_dlg:hidden'] = 'Ezkutuan';
$string['media_dlg:href'] = 'HREF';
$string['media_dlg:hspace'] = 'H-Espazioa';
$string['media_dlg:html5_audio_options'] = 'Audio-aukerak';
$string['media_dlg:html5_video_options'] = 'HTML5 bideoaren aukerak';
$string['media_dlg:id'] = 'ID';
$string['media_dlg:iframe'] = 'Iframe';
$string['media_dlg:imagestatus'] = 'Irudiaren egoera';
$string['media_dlg:invokeurls'] = 'Deitu URLei';
$string['media_dlg:kioskmode'] = 'Kiosk modua';
$string['media_dlg:list'] = 'Zerrenda';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Errepikatu';
$string['media_dlg:maintainaspect'] = 'Mantendu itxura';
$string['media_dlg:menu'] = 'Erakutsi menua';
$string['media_dlg:mute'] = 'Mututu';
$string['media_dlg:name'] = 'Izena';
$string['media_dlg:nojava'] = 'Java-rik ez';
$string['media_dlg:numloop'] = 'Errepikapen-kopurua';
$string['media_dlg:play'] = 'Hasiera automatikoa';
$string['media_dlg:playcount'] = 'Erreprodukzio-zenbatzailea';
$string['media_dlg:playeveryframe'] = 'Erreproduzitu marko guztiak';
$string['media_dlg:poster'] = 'Posterra';
$string['media_dlg:prefetch'] = 'Aurrebilaketa';
$string['media_dlg:preload'] = 'Aurrekargatu';
$string['media_dlg:preload_auto'] = 'Erabiltzailearen nabigatzaileak erabakitzen du';
$string['media_dlg:preload_metadata'] = 'Aurrekargatu bideoen metadatuak';
$string['media_dlg:preload_none'] = 'Ez aurrekargatu';
$string['media_dlg:preview'] = 'Aurreikusi';
$string['media_dlg:progress'] = 'Aurrerapena';
$string['media_dlg:qt_options'] = 'QuickTime aukerak';
$string['media_dlg:qtsrc'] = 'QT iturburua';
$string['media_dlg:qtsrcchokespeed'] = 'Txoke-abiadura';
$string['media_dlg:qt_stream_warn'] = 'Stream bidezko RTSP baliabideak QTko jatorrizko eremuan gehitu behar dira, fitxa aurreratuan.
Jatorrizko eremuan stream bidezkoa ez den bertsio bat ere gehitu beharko litzateke.';
$string['media_dlg:quality'] = 'Kalitatea';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Tasa';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Real Media Player aukerak';
$string['media_dlg:salign'] = 'SLerrokatu';
$string['media_dlg:scale'] = 'Eskala';
$string['media_dlg:scriptcallbacks'] = 'Script callbacks';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Shockwave aukerak';
$string['media_dlg:shuffle'] = 'Nahastu';
$string['media_dlg:size'] = 'Dimentsioak';
$string['media_dlg:sound'] = 'Soinua';
$string['media_dlg:source'] = 'Iturburua';
$string['media_dlg:starttime'] = 'Hasiera-ordua';
$string['media_dlg:stretchtofit'] = 'Neurrira luzatu';
$string['media_dlg:swstretchhalign'] = 'Luzaketa H-Lerrokatzea';
$string['media_dlg:swstretchstyle'] = 'Luzaketa estiloa';
$string['media_dlg:swstretchvalign'] = 'Luzaketa V-Lerrokatzea';
$string['media_dlg:target'] = 'Helburua';
$string['media_dlg:targetcache'] = 'Helburu-cachea';
$string['media_dlg:title'] = 'Txertatu/editatu enbotatutako media';
$string['media_dlg:type'] = 'Mota';
$string['media_dlg:uimode'] = 'UI modua';
$string['media_dlg:video'] = 'HTML5 bideoa';
$string['media_dlg:volume'] = 'Bolumena';
$string['media_dlg:vspace'] = 'B-Espazioa';
$string['media_dlg:windowlessvideo'] = 'Windowless bideoa';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = 'W Modua';
$string['media_dlg:wmp_options'] = 'Windows Media Player aukerak';
$string['media:edit'] = 'Editatu enbotatutako media';
$string['nonbreaking:nonbreaking_desc'] = 'Txertatu zuriune-karaktere zatiezina';
$string['pagebreak:desc'] = 'Txertatu orri-jauzia inprimatzeko';
$string['paste_dlg:text_linebreaks'] = 'Mantendu lerro-jauziak';
$string['paste_dlg:text_title'] = 'Erabili teklatuko CTRL+V testua leihoan itsasteko.';
$string['paste_dlg:word_title'] = 'Erabili teklatuko CTRL+V teklatuan testua leihoan itsasteko';
$string['paste:paste_text_desc'] = 'Itsatsi testu lau gisa';
$string['paste:paste_word_desc'] = 'Itsatsi Word-etik';
$string['paste:plaintext_mode'] = 'Itsatsi testu laua moduan ezarrita dago. Berriro egin klik ohiko itsasteko modura itzultzeko. Edozer itsatsi ondoren ohiko itsasteko modua berrezarriko da.';
$string['paste:plaintext_mode_stick'] = 'Itsatsi testu laua moduan ezarrita dago. Berriro egin klik ohiko itsasteko modura itzultzeko.';
$string['paste:selectall_desc'] = 'Aukeratu guztia';
$string['pluginname'] = 'TinyMCE HTML editorea';
$string['preview:preview_desc'] = 'Aurrebista';
$string['print:print_desc'] = 'Inprimatu';
$string['privacy:metadata'] = 'TinyMCE HTML editorea pluginak ez du datu pertsonalik biltzen.';
$string['save:cancel_desc'] = 'Utzi aldaketak guztiak';
$string['save:save_desc'] = 'Gorde';
$string['searchreplace:delta_height'] = '0';
$string['searchreplace:delta_width'] = '0';
$string['searchreplace_dlg:allreplaced'] = 'Bilaketa-katearen agerraldi guztiak ordezkatu dira.';
$string['searchreplace_dlg:direction'] = 'Norabidea';
$string['searchreplace_dlg:down'] = 'Behera';
$string['searchreplace_dlg:findnext'] = 'Bilatu hurrengoa';
$string['searchreplace_dlg:findwhat'] = 'Zer bilatu';
$string['searchreplace_dlg:mcase'] = 'Maiuskula/minuskula';
$string['searchreplace_dlg:notfound'] = 'Bilaketa burutu da. Ez da aurkitu idatzi duzun testua.';
$string['searchreplace_dlg:replace'] = 'Ordezkatu';
$string['searchreplace_dlg:replaceall'] = 'Ordezkatu guztia';
$string['searchreplace_dlg:replace_title'] = 'Bilatu/ordezkatu';
$string['searchreplace_dlg:replacewith'] = 'Ordezkatu honekin';
$string['searchreplace_dlg:searchnext_desc'] = 'Bilatu berriro';
$string['searchreplace_dlg:search_title'] = 'Bilatu';
$string['searchreplace_dlg:up'] = 'Gora';
$string['searchreplace:replace_desc'] = 'Bilatu/ordezkatu';
$string['searchreplace:search_desc'] = 'Bilatu';
$string['settings'] = 'Ezarpen orokorrak';
$string['simple:bold_desc'] = 'Lodia (Ctrl+B)';
$string['simple:bullist_desc'] = 'Txertatu/ezabatu buletdun zerrenda';
$string['simple:cleanup_desc'] = 'Garbitu kode zaborra';
$string['simple:italic_desc'] = 'Etzana (Ctrl+I)';
$string['simple:numlist_desc'] = 'Txertatu/ezabatu ordenatutako zerrenda';
$string['simple:redo_desc'] = 'Berregin (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Marratua';
$string['simple:underline_desc'] = 'Azpimarratua (Ctrl+U)';
$string['simple:undo_desc'] = 'Desegin (Ctrl+Z)';
$string['spellchecker:desc'] = 'Aldatu zuzentzaile ortografikoa';
$string['spellchecker:ignore_word'] = 'Baztertu hitza';
$string['spellchecker:ignore_words'] = 'Baztertu guztia';
$string['spellchecker:langs'] = 'Hizkuntzak';
$string['spellchecker:learn_word'] = 'Ikasi hitza';
$string['spellchecker:menu'] = 'Zuzentzaile ortografikoaren ezarpenak';
$string['spellchecker:no_mpell'] = 'Ez da errorerik aurkitu';
$string['spellchecker:no_sug'] = 'Iradokizunik ez';
$string['spellchecker:sug'] = 'Iradokizunak';
$string['spellchecker:wait'] = 'Itxaron, mesedez...';
$string['style:delta_height'] = '0';
$string['style:delta_width'] = '0';
$string['style:desc'] = 'Editatu CSS estiloa';
$string['style_dlg:apply'] = 'Aplikatu';
$string['style_dlg:background'] = 'Atzeko planoa';
$string['style_dlg:background_attachment'] = 'Eranskina';
$string['style_dlg:background_color'] = 'Atzeko planoaren kolorea';
$string['style_dlg:background_hpos'] = 'Posizio horizontala';
$string['style_dlg:background_image'] = 'Atzeko planoko irudia';
$string['style_dlg:background_repeat'] = 'Errepikatu';
$string['style_dlg:background_tab'] = 'Atzeko planoa';
$string['style_dlg:background_vpos'] = 'Posizio bertikala';
$string['style_dlg:block'] = 'Blokea';
$string['style_dlg:block_display'] = 'Erakutsi';
$string['style_dlg:block_letterspacing'] = 'Letra arteko espazioa';
$string['style_dlg:block_tab'] = 'Blokea';
$string['style_dlg:block_text_align'] = 'Lerrokatu testua';
$string['style_dlg:block_text_indent'] = 'Kostatu testua';
$string['style_dlg:block_vertical_alignment'] = 'Lerrokadura bertikala';
$string['style_dlg:block_whitespace'] = 'Zuriunea';
$string['style_dlg:block_wordspacing'] = 'Hitz arteko espazioa';
$string['style_dlg:border'] = 'Ertza';
$string['style_dlg:border_tab'] = 'Ertza';
$string['style_dlg:bottom'] = 'Azpian';
$string['style_dlg:box'] = 'Kutxa';
$string['style_dlg:box_clear'] = 'Garbitu';
$string['style_dlg:box_float'] = 'Flotagailua';
$string['style_dlg:box_height'] = 'Altuera';
$string['style_dlg:box_tab'] = 'Kutxa';
$string['style_dlg:box_width'] = 'Zabalera';
$string['style_dlg:bullet_image'] = 'Buletaren irudia';
$string['style_dlg:clip'] = 'Clip';
$string['style_dlg:color'] = 'Kolorea';
$string['style_dlg:height'] = 'Altuera';
$string['style_dlg:left'] = 'Ezkerra';
$string['style_dlg:list'] = 'Zerrenda';
$string['style_dlg:list_tab'] = 'Zerrenda';
$string['style_dlg:list_type'] = 'Mota';
$string['style_dlg:margin'] = 'Marjina';
$string['style_dlg:overflow'] = 'Overflow';
$string['style_dlg:padding'] = 'Padding';
$string['style_dlg:placement'] = 'Kokapena';
$string['style_dlg:position'] = 'Kokalekua';
$string['style_dlg:positioning_tab'] = 'Kokatzen';
$string['style_dlg:positioning_type'] = 'Mota';
$string['style_dlg:right'] = 'Eskuina';
$string['style_dlg:same'] = 'Bera guztietan';
$string['style_dlg:style'] = 'Estiloa';
$string['style_dlg:text'] = 'Testua';
$string['style_dlg:text_blink'] = 'Keinuka';
$string['style_dlg:text_case'] = 'Maiuskula/minuskula';
$string['style_dlg:text_color'] = 'Kolorea';
$string['style_dlg:text_decoration'] = 'Dekorazioa';
$string['style_dlg:text_font'] = 'Letra-tipoa';
$string['style_dlg:text_lineheight'] = 'Lerroaren altuera';
$string['style_dlg:text_none'] = 'Bat ere ez';
$string['style_dlg:text_overline'] = 'Goi-marra';
$string['style_dlg:text_props'] = 'Testua';
$string['style_dlg:text_size'] = 'Tamaina';
$string['style_dlg:text_striketrough'] = 'Marratua';
$string['style_dlg:text_style'] = 'Estiloa';
$string['style_dlg:text_tab'] = 'Testua';
$string['style_dlg:text_underline'] = 'Azpimarratua';
$string['style_dlg:text_variant'] = 'Aldaera';
$string['style_dlg:text_weight'] = 'Pisua';
$string['style_dlg:title'] = 'Editatu CSS estiloa';
$string['style_dlg:toggle_insert_span'] = 'Txertatu luzapena aukeraketan';
$string['style_dlg:top'] = 'Gora';
$string['style_dlg:visibility'] = 'Ikusgarritasuna';
$string['style_dlg:width'] = 'Zabalera';
$string['style_dlg:zindex'] = 'Z-index';
$string['subplugintype_tinymce'] = 'Plugina';
$string['subplugintype_tinymce_plural'] = 'Pluginak';
$string['table:cell'] = 'Gelaxka';
$string['table:cell_desc'] = 'Gelaxkaren ezaugarriak';
$string['table:cellprops_delta_height'] = '0';
$string['table:cellprops_delta_width'] = '0';
$string['table:col'] = 'Zutabea';
$string['table:col_after_desc'] = 'Txertatu zutabea ondoren';
$string['table:col_before_desc'] = 'Txertatu zutabea aurretik';
$string['table:copy_row_desc'] = 'Kopiatu errenkada';
$string['table:cut_row_desc'] = 'Ebaki errenkada';
$string['table:del'] = 'Ezabatu taula';
$string['table:delete_col_desc'] = 'Ezabatu zutabea';
$string['table:delete_row_desc'] = 'Ezabatu errenkada';
$string['table:desc'] = 'Txertatu/editatu taula';
$string['table_dlg:advanced_props'] = 'Ezaugarri aurreratuak';
$string['table_dlg:advanced_tab'] = 'Aurreratua';
$string['table_dlg:align'] = 'Lerrokatu';
$string['table_dlg:align_bottom'] = 'Beheko aldea';
$string['table_dlg:align_default'] = 'Automatikoa';
$string['table_dlg:align_left'] = 'Ezkerrera';
$string['table_dlg:align_middle'] = 'Erdian';
$string['table_dlg:align_right'] = 'Eskuinera';
$string['table_dlg:align_top'] = 'Gora';
$string['table_dlg:bgcolor'] = 'Atzeko planoaren kolorea';
$string['table_dlg:bgimage'] = 'Atzeko planoko irudia';
$string['table_dlg:border'] = 'Ertza';
$string['table_dlg:bordercolor'] = 'Ertzaren kolorea';
$string['table_dlg:caption'] = 'Taularen epigrafea';
$string['table_dlg:cell_all'] = 'Eguneratu gelaxka guztiak taulan';
$string['table_dlg:cell_cell'] = 'Eguneratu oraingo gelaxka';
$string['table_dlg:cell_col'] = 'Eguneratu gelaxka guztiak zutabean';
$string['table_dlg:cell_limit'] = 'Gehienezko gelaxka-kopurua gainditu duzu: {$cells}.';
$string['table_dlg:cellpadding'] = 'Gelaxken betegarria';
$string['table_dlg:cell_row'] = 'Eguneratu gelaxka guztiak errenkadan';
$string['table_dlg:cellspacing'] = 'Gelaxka-tartea';
$string['table_dlg:cell_title'] = 'Gelaxkaren ezaugarriak';
$string['table_dlg:cell_type'] = 'Gelaxka-mota';
$string['table_dlg:colgroup'] = 'Gelaxka-taldea';
$string['table_dlg:col_limit'] = 'Gehienezko gelaxka-kopurua gainditu duzu: {$cols}.';
$string['table_dlg:cols'] = 'Zutabeak';
$string['table_dlg:frame'] = 'Markoa';
$string['table_dlg:frame_all'] = 'guztiak';
$string['table_dlg:frame_cols'] = 'zutabeak';
$string['table_dlg:frame_groups'] = 'taldeak';
$string['table_dlg:frame_none'] = 'bat ere ez';
$string['table_dlg:frame_rows'] = 'errenkadak';
$string['table_dlg:general_props'] = 'Ezaugarri orokorrak';
$string['table_dlg:general_tab'] = 'Orokorra';
$string['table_dlg:height'] = 'Altuera';
$string['table_dlg:id'] = 'ID';
$string['table_dlg:langcode'] = 'Hizkuntza-kodea';
$string['table_dlg:langdir'] = 'Hizkuntzaren norabidea';
$string['table_dlg:ltr'] = 'Ezkerretik eskuinera';
$string['table_dlg:merge_cells_title'] = 'Batu taula-gelaxkak';
$string['table_dlg:mime'] = 'Helburu MIME mota';
$string['table_dlg:missing_scope'] = 'Ez duzu ezarri esparrurik taularen goiburu gelaxkari. Ziur zaude jarraitu nahi duzula? Hori ezarri gabe, gutxitasunak dituzten erabiltzaileentzat zaila izan daiteke taularen edukia edo datuak ulertzea.';
$string['table_dlg:row_all'] = 'Eguneratu errenkada guztiak taulan';
$string['table_dlg:row_even'] = 'Eguneratu errenkada bikoitiak taulan';
$string['table_dlg:rowgroup'] = 'Errenkada-taldea';
$string['table_dlg:row_limit'] = 'Gehienezko lerro kopurua ({$rows}) gainditu duzu.';
$string['table_dlg:row_odd'] = 'Eguneratu errenkada bakoitiak taulan';
$string['table_dlg:row_row'] = 'Eguneratu oraingo errenkada';
$string['table_dlg:rows'] = 'Errenkadak';
$string['table_dlg:row_title'] = 'Errenkadaren ezaugarriak';
$string['table_dlg:rowtype'] = 'Errenkada-mota';
$string['table_dlg:rtl'] = 'Eskuinetik ezkerrera';
$string['table_dlg:rules'] = 'Arauak';
$string['table_dlg:rules_above'] = 'goian';
$string['table_dlg:rules_below'] = 'azpian';
$string['table_dlg:rules_border'] = 'ertza';
$string['table_dlg:rules_box'] = 'kutxa';
$string['table_dlg:rules_hsides'] = 'hsides';
$string['table_dlg:rules_lhs'] = 'lhs';
$string['table_dlg:rules_rhs'] = 'rhs';
$string['table_dlg:rules_void'] = 'hutsunea';
$string['table_dlg:rules_vsides'] = 'vsides';
$string['table_dlg:scope'] = 'Esparrua';
$string['table_dlg:style'] = 'Estiloa';
$string['table_dlg:summary'] = 'Laburpena';
$string['table_dlg:tbody'] = 'Gorputza';
$string['table_dlg:td'] = 'Datuak';
$string['table_dlg:tfoot'] = 'Orri-oina';
$string['table_dlg:th'] = 'Goiburua';
$string['table_dlg:thead'] = 'Goiburua';
$string['table_dlg:title'] = 'Txertatu/editatu taula';
$string['table_dlg:valign'] = 'Lerrokatze bertikala';
$string['table_dlg:width'] = 'Zabalera';
$string['table:merge_cells_delta_height'] = '0';
$string['table:merge_cells_delta_width'] = '0';
$string['table:merge_cells_desc'] = 'Batu taula-gelaxkak';
$string['table:paste_row_after_desc'] = 'Itsatsi errenkada ondoren';
$string['table:paste_row_before_desc'] = 'Itsatsi errenkada aurretik';
$string['table:props_desc'] = 'Taularen ezaugarriak';
$string['table:row'] = 'Errenkada';
$string['table:row_after_desc'] = 'Txertatu errenkada ondoren';
$string['table:row_before_desc'] = 'Txertatu errenkada aurretik';
$string['table:row_desc'] = 'Errenkadaren ezaugarriak';
$string['table:rowprops_delta_height'] = '0';
$string['table:rowprops_delta_width'] = '0';
$string['table:split_cells_desc'] = 'Zatitu batutako taula-gelaxkak';
$string['table:table_delta_height'] = '0';
$string['table:table_delta_width'] = '0';
$string['template:desc'] = 'Txertatu aurredefinitutako txantiloi-edukia';
$string['template_dlg:cdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:day_long'] = 'Igandea,Astelehena,Asteartea,Asteazkena,Osteguna,Ostirala,Larunbata';
$string['template_dlg:day_short'] = 'Ig,Al,Ar,Az,Og,Or,Lr';
$string['template_dlg:desc'] = 'Aurrezarritako txantiloiaren edukia sartu';
$string['template_dlg:desc_label'] = 'Deskribapena';
$string['template_dlg:label'] = 'Txantiloia';
$string['template_dlg:mdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:months_long'] = 'urtarrila,otsaila,martxoa,apirila,maiatza,ekaina,uztaila,abuztua,iraila,urria,azaroa,abendua';
$string['template_dlg:months_short'] = 'urt,ots,mar,api,mai,eka,uzt,abu,ira,urr,aza,abe';
$string['template_dlg:preview'] = 'Aurreikusi';
$string['template_dlg:select'] = 'Aukeratu txantiloi bat';
$string['template_dlg:title'] = 'Txantiloiak';
$string['template_dlg:warning'] = 'Kontuz: txantiloiaren aldaketak datu-galerak sor ditzake.';
$string['visualblocks:desc'] = 'Erakutsi/ezkutatu blokearen elementuak';
$string['visualchars:desc'] = 'Erakutsi/Ezkutatu ikus-kontrol karaktereak';
$string['wordcount:words'] = 'Hitzak:';
$string['xhtmlxtras:abbr_delta_height'] = '0';
$string['xhtmlxtras:abbr_delta_width'] = '0';
$string['xhtmlxtras:abbr_desc'] = 'Laburdura';
$string['xhtmlxtras:acronym_delta_height'] = '0';
$string['xhtmlxtras:acronym_delta_width'] = '0';
$string['xhtmlxtras:acronym_desc'] = 'Akronimoa';
$string['xhtmlxtras:attribs_delta_height'] = '0';
$string['xhtmlxtras:attribs_delta_width'] = '0';
$string['xhtmlxtras:attribs_desc'] = 'Txertatu/editatu atributuak';
$string['xhtmlxtras:cite_delta_height'] = '0';
$string['xhtmlxtras:cite_delta_width'] = '0';
$string['xhtmlxtras:cite_desc'] = 'Aipua';
$string['xhtmlxtras:del_delta_height'] = '0';
$string['xhtmlxtras:del_delta_width'] = '0';
$string['xhtmlxtras:del_desc'] = 'Ezabaketa';
$string['xhtmlxtras_dlg:attribs_title'] = 'Txertatu/editatu atributuak';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Atributuak';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Atributuak';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Ekitaldiak';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'Laster-tekla';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Aipua';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Mota';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Data/ordua';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Hizkuntza';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Testuaren norazkoa';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Estiloa';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'TabIndex';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Izenburua';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'Ezkerretik eskuinera';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'Eskuinetik ezkerrera';
$string['xhtmlxtras_dlg:events_tab'] = 'Ekitaldiak';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Elementuaren atributuak';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Elementuaren ekitaldiak';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Ezarpen orokorrak';
$string['xhtmlxtras_dlg:general_tab'] = 'Orokorra';
$string['xhtmlxtras_dlg:insert_date'] = 'Txertatu oraingo data/ordua';
$string['xhtmlxtras_dlg:option_ltr'] = 'Ezkerretik eskuinera';
$string['xhtmlxtras_dlg:option_rtl'] = 'Eskuinetik ezkerrera';
$string['xhtmlxtras_dlg:remove'] = 'Ezabatu';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Laburdura-elementua';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Akronimo-elementua';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Elementuaren aipua';
$string['xhtmlxtras_dlg:title_del_element'] = 'Elementuaren ezabaketa';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Elementuaren txertaketa';
$string['xhtmlxtras:ins_delta_height'] = '0';
$string['xhtmlxtras:ins_delta_width'] = '0';
$string['xhtmlxtras:ins_desc'] = 'Txertaketa';
