<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'eu', branch 'MOODLE_37_STABLE'
 *
 * @package   bigbluebuttonbn
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Laster BigBlueButton saioak izango dituzu';
$string['bbbduetimeoverstartingtime'] = 'Jarduera honen itxiera-data irekitze-data baino beranduagokoa izan behar du';
$string['bbbdurationwarning'] = 'Saio honen gehienezko iraupena %duration% minutu da.';
$string['bbbrecordallfromstartwarning'] = 'Saio hau hasieratik grabatuko da.';
$string['bbbrecordwarning'] = 'Saio hau grabatu ahalko da.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Gehitu BigBlueButton bilera-gela/saio berri bat';
$string['bigbluebuttonbn:join'] = 'Sartu BigBlueButton bilera-gela batera';
$string['bigbluebuttonbn:managerecordings'] = 'Kudeatu BigBlueButtoneko grabazioak';
$string['bigbluebuttonbn:meeting'] = 'Sortu zuzeneko bilerak egiteko gaitasuna duten instantziak';
$string['bigbluebuttonbn:recording'] = 'Sortu grabatzeko gaitasuna duten instantziak';
$string['bigbluebuttonbn:view'] = 'Ikusi bilera-gela/saio bat';
$string['calendarstarts'] = '{$a} programatuta dago hurrengo datan:';
$string['config_clienttype'] = '"Web-bezero" motarako konfigurazioa';
$string['config_clienttype_default'] = 'Lehenetsitako web-bezero mota';
$string['config_clienttype_default_description'] = 'Aukeratu ezazu Adobe Flash bezero klasikoaren eta HTML5 bezero berriaren artean.';
$string['config_clienttype_description'] = 'Ezarpen honek gela bakoitzerako Web-bezeroaren aukeraketa gaitu/desgaitzen du.';
$string['config_clienttype_editable'] = 'Web-bezeroaren aukeraketa editatu daiteke';
$string['config_clienttype_editable_description'] = 'Ezarpen honek gelaren edizio formularioan Web-bezeroaren aukeraketa (AdobeFlash/HTML5) gaitzen du.';
$string['config_extended_capabilities'] = 'Gaitasun hedatuen konfigurazioa';
$string['config_extended_capabilities_description'] = 'Gaitasun hedatuen konfigurazioa, BigBlueButton zerbitzariak eskaintzen baditu.';
$string['config_general'] = 'Ezarpen orokorrak';
$string['config_general_description'] = 'Ezarpen hauek <b>beti</b> erabiltzen dira';
$string['config_importrecordings'] = '"Grabazioen inportazioa" funtzionalitatearen ezarpenak';
$string['config_importrecordings_description'] = 'Ezarpen hauek funtzionalitate zehatzenak dira';
$string['config_importrecordings_enabled'] = 'Grabazioen inportazioa gaituta dago';
$string['config_importrecordings_enabled_description'] = 'Funtzionalitate hau eta grabazioena gaituta badaude, beste ikastaroetako grabazioak jarduera batean inportatzeko aukera egongo da.';
$string['config_importrecordings_from_deleted_enabled'] = 'Ezabatutako jardueren grabazioen inportazioa gaituta dago';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Funtzionalitate hau eta grabazioena gaituta badaude, dagoeneko ikastaroan ez dauden jardueren grabazioak inportatzeko aukera egongo da.';
$string['config_meetingevents_enabled'] = 'Egin zuzeneko ekitaldien erregistroa';
$string['config_meetingevents_enabled_description'] = 'Eman pluginari saioa amaitu ondoren zuzeneko ekitaldien onarpena eta prozesatzeko gaitasuna. (Funtzionalitate hau esperimentala da eta soilik funtzionatuko du BigBlueButton zerbitzariak post_events script-ak prozesatzeko gai bada)';
$string['config_muteonstart'] = '"Isilarazi hasieran" funtzionalitatearen ezarpenak';
$string['config_muteonstart_default'] = '"Isilarazi hasieran" gaituta dago modu lehenetsian';
$string['config_muteonstart_default_description'] = 'Gaituz gero hasieran saioa isilaraziko da.';
$string['config_muteonstart_description'] = 'Ezarpen hauen bidez interfaze grafikoaren hainbat aukera gaitu edo desgaitu eta hauen lehenetsitako balioak zehazten dira.';
$string['config_muteonstart_editable'] = '"Isilarazi hasieran" ezarpena editatu daiteke';
$string['config_muteonstart_editable_description'] = '"Isilarazi hasieran" ezarpena saioa gehitu edo eguneratzen denean editatu daiteke modu lehenetsian.';
$string['config_participant'] = 'Parte-hartzaileen ezarpenak';
$string['config_participant_description'] = 'Ezarpen hauek bileraren parte hartzaileen rol lehenetsiak zehazten dituzte.';
$string['config_participant_moderator_default'] = 'Moderatzaile lehenetsia';
$string['config_participant_moderator_default_description'] = 'Arau hau gela berri bat sortzen denean erabiltzen da modu lehenetsian.';
$string['config_presentation_default'] = '"Aldez aurretik kargatutako aurkezpena" funtzionalitatearen fitxategi lehenetsia';
$string['config_presentation_default_description'] = 'Ezarpen honen bidez BBBren saioetan modu lehenetsian erabiliko den fitxategia zehazten da "Aldez aurretik kargatutako aurkezpena" aukera gaituta badago.';
$string['config_preuploadpresentation'] = '"Aldez aurretik kargatutako aurkezpena" funtzionalitatearen ezarpenak';
$string['config_preuploadpresentation_description'] = 'Ezarpen hauen bidez interfaze grafikoaren hainbat aukera gaitu edo desgaitu eta hauen lehenetsitako balioak zehazten dira. Funtzionalitate honek soilik BigBlueButtonek Moodleren zerbitzaria erabili badezake funtzionatzen du.';
$string['config_preuploadpresentation_enabled'] = '"Aldez aurretik kargatutako aurkezpena" funtzionalitatea gaituta dago';
$string['config_preuploadpresentation_enabled_description'] = '"Aldez aurretik kargatutako aurkezpena" funtzionalitatea gaituta dago bilera-gela bat gehitu edo eguneratzen denean.';
$string['config_recording'] = '"Grabatu bilera" funtzionalitatearen ezarpenak';
$string['config_recording_all_from_start_default'] = 'Grabatu dena hasieratik';
$string['config_recording_all_from_start_default_description'] = 'Markatuz gero bilera hasieratik grabatuko da';
$string['config_recording_all_from_start_editable'] = '"Grabatu dena hasieratik" funtzionalitatea editatu daiteke';
$string['config_recording_all_from_start_editable_description'] = 'Markatuta badago interfazean hasieratik grabatzeko funtzionalitatea gaitu eta desgaitzeko aukera egongo da.';
$string['config_recording_default'] = 'Grabatzeko funtzionalitatea gaituta dago modu lehenetsian';
$string['config_recording_default_description'] = 'Gaituz gero BigBlueButtonen sortutako saioak grabatu ahalko dira.';
$string['config_recording_description'] = 'Ezarpen hauek funtzionalitate zehatzenak dira';
$string['config_recording_editable'] = 'Grabatzeko funtzionalitatea editatu daiteke';
$string['config_recording_editable_description'] = 'Markatuz gero interfazean grabatzeko funtzionalitatea gaitu eta desgaitzeko aukera egongo da.';
$string['config_recording_hide_button_default'] = 'Ezkutatu grabatzeko botoia';
$string['config_recording_hide_button_default_description'] = 'Markatuz gero grabatzeko botoia ezkutatuko da';
$string['config_recording_hide_button_editable'] = '"Ezkutatu grabatzeko botoia" funtzionalitatea editatu daiteke';
$string['config_recording_hide_button_editable_description'] = 'Markatuz gero interfazean grabatzeko botoia erakutsi eta ezkutatzeko aukera egongo da.';
$string['config_recording_icons_enabled'] = 'Grabazio-kudeaketarako ikonoak';
$string['config_recording_icons_enabled_description'] = 'Gaituz gero, grabazioa kudeatzeko panelean publikatu/ez publikatu eta ezabatu funtzionalitateentzako ikonoak agertuko dira.';
$string['config_recordingready_enabled'] = 'Bidali jakinarazpenak grabazio bat prest dagoenean';
$string['config_recordingready_enabled_description'] = 'Eman pluginari grabazioa prest dagoenean jakinarazpenak bidaltzeko gaitasuna. (Funtzionalitate hau esperimentala da eta soilik funtzionatuko du BigBlueButton zerbitzarian post_publish_recording_ready_callback script-a gaituta badago)';
$string['config_recordings'] = '"Erakutsi grabazioak" funtzionalitatearen ezarpenak';
$string['config_recordings_deleted_default'] = 'Ezabatutako jardueren grabazioak aukera gaituta modu lehenetsian';
$string['config_recordings_deleted_default_description'] = 'Gaituz gero grabazioen taulan ezabatutako jardueren grabazioak agertuko dira, baleude.';
$string['config_recordings_deleted_editable'] = '"Ezabatutako jardueren grabazioak" funtzionalitatea editatu daiteke';
$string['config_recordings_deleted_editable_description'] = 'Ezabatutako jardueren grabazioak aukeran saio bat gehitu edo eguneratzen denean editatu daiteke modu lehenetsian.';
$string['config_recordings_description'] = 'Ezarpen hauek funtzionalitate zehatzenak dira';
$string['config_recordings_general'] = 'Erakutsi grabazioen ezarpenak';
$string['config_recordings_general_description'] = 'Ezarpen hauek soilik grabazioak bistaratzen direnean erabiltzen dira';
$string['config_recordings_html_default'] = 'HTML interfazea gaituta dago modu lehenetsian';
$string['config_recordings_html_default_description'] = 'Gaituz gero grabazioen taula HTML soilean bistaratzen da modu lehenetsian.';
$string['config_recordings_html_editable'] = 'HTML interfazea funtzionalitatea editatu daiteke';
$string['config_recordings_html_editable_description'] = 'HTML interfazea funtzionalitatea saio bat gehitu edo eguneratzean editatu daiteke modu lehenetsian.';
$string['config_recordings_imported_default'] = '"Erakutsi soilik inportatutako estekak" funtzionalitatea gaituta dago modu lehenetsian';
$string['config_recordings_imported_default_description'] = 'Gaituz gero grabazioen taulan soilik grabazioen inportatutako estekak egongo dira.';
$string['config_recordings_imported_editable'] = 'Erakutsi soilik inportatutako estekak funtzionalitatea editatu daiteke';
$string['config_recordings_imported_editable_description'] = '"Erakutsi soilik inportatutako estekak" funtzionalitatea saio bat gehitu edo eguneratzen denean editatu daiteke modu lehenetsian.';
$string['config_recordings_preview_default'] = 'Aurrebista gaituta dago modu lehentsian';
$string['config_recordings_preview_default_description'] = 'Gaituz gero taulan aurkezpenen aurrebistak egongo dira.';
$string['config_recordings_preview_editable'] = 'Aurrebisten funtzionalitatea editatu daiteke.';
$string['config_recordings_preview_editable_description'] = '"Aurrebista" funtzionalitatea saio bat gehitu edo eguneratzen denean editatu daiteke.';
$string['config_recordings_sortorder'] = 'Ordenatu grabazioak behetik gora.';
$string['config_recordings_sortorder_description'] = 'Modu lehenetsian grabazioan goitik behera ordenatzen dira. Markatuz gero behetik gora ordenatuko dira.';
$string['config_recordings_validate_url'] = 'Balioztatu URLa';
$string['config_recordings_validate_url_description'] = 'Markatuz gero aurkezpenaren URLa balioztatuko da erabiltzaileari sarbidea eman aurretik.';
$string['config_scheduled'] = 'Programatutako saioen ezarpenak';
$string['config_scheduled_description'] = 'Ezarpen hauetan programatutako saioen lehenetsitako hainbat jokaera definitzen dira.';
$string['config_scheduled_duration_compensation'] = 'Denbora konpentsatzailea (minutuetan)';
$string['config_scheduled_duration_compensation_description'] = 'Iraupena kalkulatzean programatutako itxierari erantsitako minutuak.';
$string['config_scheduled_duration_enabled'] = 'Iraupenaren kalkulua funtzionalitatea gaituta dago';
$string['config_scheduled_duration_enabled_description'] = 'Programatutako saio baten iraupena hasiera eta bukaera uneen bidez kalkulatzen da.';
$string['config_scheduled_pre_opening'] = 'Hasiera aurretiko sarbidea (minutuetan)';
$string['config_scheduled_pre_opening_description'] = 'Programatutako saioa hasi baino zenbat minutu lehenago sar daitekeen bilera-gelan.';
$string['config_sendnotifications'] = '"Bidali jakinarazpenak" funtzionalitatearen ezarpenak';
$string['config_sendnotifications_description'] = 'Ezarpen hauen bidez interfaze grafikoaren hainbat aukera gaitu edo desgaitu eta hauen lehenetsitako balioak zehazten dira.';
$string['config_sendnotifications_enabled'] = '"Bidali jakinarazpenak" funtzionalitatea gaituta dago';
$string['config_sendnotifications_enabled_description'] = 'Gaituz gero jarduera editatzeko interfazean saio berri gehitu edo eguneratzen denean matrikulatutako erabiltzaileei jakinarazpenak bidaltzeko aukera gehituko da.';
$string['config_server_url'] = 'BigBlueButton zerbitzariaren URLa';
$string['config_server_url_description'] = 'Zure BigBlueButton zerbitzariaren URLaren amaiera /bigbluebutton/ izan behar da. (Lehenetsitako URL hau Blindside Networks enpresak hornitzen du probako BigBlueButton zerbitzarietarako).';
$string['config_shared_secret'] = 'BigBlueButton Sekretu Partekatua';
$string['config_shared_secret_description'] = 'Zure BigBlueButton zerbitzariaren segurtasun-eraldaketa. (Lehenetsitako eraldaketa hau Blindside Networks enpresak hornitzen du probako BigBlueButton zerbitzarietarako).';
$string['config_uidelegation_enabled'] = 'Interfaze grafikoaren ordezkaritza gaituta dago';
$string['config_uidelegation_enabled_description'] = 'Ezarpen hauen bidez BigBlueButton zerbitzariaren interfaze grafikoaren ordezkaritza gaitu edo desgaitu daiteke .';
$string['config_userlimit'] = '"Erabiltzaile-muga" funtzionalitatearen konfigurazioa';
$string['config_userlimit_default'] = 'Erabiltzaile-muga gaituta dago modu lehenetsian';
$string['config_userlimit_default_description'] = 'Bilera-gela bat sortzen den unean modu lehenetsian onartzen duen erabiltzaile kopurua. Kopurua 0 bada, ez da mugarik egongo.';
$string['config_userlimit_description'] = 'Ezarpen hauen bidez interfaze grafikoaren aukerak gaitu edo desgaitu eta hauen lehenetsitako balioak zehazten dira.';
$string['config_userlimit_editable'] = '"Erabiltzaile-muga" funtzionalitatea editatu daiteke';
$string['config_userlimit_editable_description'] = 'Erabiltzaile-mugaren balio lehenetsia bilera-gela bat gehitu edo eguneratzen denean editatu daiteke.';
$string['config_voicebridge'] = '"Ahots-zubia" funtzionalitaterako konfigurazioa';
$string['config_voicebridge_description'] = 'Ezarpen hauen bidez interfaze grafikoaren aukerak gaitu edo desgaitu eta hauen lehenetsitako balioak zehazten dira.';
$string['config_voicebridge_editable'] = 'Bileraren ahots-zubia editatu daiteke';
$string['config_voicebridge_editable_description'] = 'Bileraren ahots-zubiaren zenbakia gela bati behin betiko ezarri dakioke. Ezartzen denean, zenbaki hori ezingo da beste gela edo saio batean erabili.';
$string['config_waitformoderator'] = '"Itxaron moderatzaileari" funtzionalitatearen konfigurazioa';
$string['config_waitformoderator_cache_ttl'] = 'Itxaron moderatzaileari funtzioaren TTL cachea (segundoetan)';
$string['config_waitformoderator_cache_ttl_description'] = 'Bezero asko parte hartu ahal izateko plugin honek cachea erabiltzen du. Parametro honek definitzen du zenbat denboraz mantentzen den cachea BigBlueButton zerbitzarira hurrengo eskaria bidali arte.';
$string['config_waitformoderator_default'] = 'Itxaron moderatzaileari funtzioa gaituta dago modu lehenetsian';
$string['config_waitformoderator_default_description'] = '"Itxaron moderatzaileari" funtzionalitatea bilera gela edo saio bat sortzen denean gaituta dago modu lehenetsian.';
$string['config_waitformoderator_description'] = 'Ezarpen hauek funtzionalitate zehatzenak dira';
$string['config_waitformoderator_editable'] = '"Itxaron moderatzaileari" funtzionalitatea editatu daiteke';
$string['config_waitformoderator_editable_description'] = 'Itxaron moderatzaileari funtzioa bilera gela edo saio bat gehitu edo eguneratzen denean editatu daiteke modu lehenetsian.';
$string['config_waitformoderator_ping_interval'] = 'Itxaron moderatzaileari funtzioaren ping-a (segundoetan)';
$string['config_waitformoderator_ping_interval_description'] = '"Itxaron moderatzaileari" funtzionalitatea gaituta dagoenean, bezeroak saioaren egoera ezagutzeko [number] segundoero ping egiten du. Parametro honek definitzen du Moodle zerbitzariari egiten zaizkion eskaeren denbora tartea.';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButtonek config.php-ko aldagai global zaharkitu bat erabiltzen du. Fitxategia moldatu ezazu hurrengo bertsioetan erabilera hori ez delako onartuko.';
$string['config_warning_curl_not_installed'] = 'Funtzionalitate honek php-ren CURL hedapena instalatuta eta gaituta egotea behar du. Ezarpenetarako sarbidea soilik baldintza hau betetzean emango da.';
$string['email_body_notification_meeting_by'] = 'nork';
$string['email_body_notification_meeting_description'] = 'Deskribapena';
$string['email_body_notification_meeting_details'] = 'Xehetasunak';
$string['email_body_notification_meeting_end_date'] = 'Amaiera-data';
$string['email_body_notification_meeting_has_been'] = 'egin du';
$string['email_body_notification_meeting_start_date'] = 'Hasiera-data';
$string['email_body_notification_meeting_title'] = 'Izenburua';
$string['email_body_recording_ready_for'] = 'Honek grabatu du';
$string['email_body_recording_ready_is_ready'] = 'prest dago';
$string['email_footer_sent_by'] = 'Jakinarazpen automatiko hau bidali duen erabiltzailea:';
$string['email_footer_sent_from'] = 'ikastarotik';
$string['ends_at'] = 'Amaiera-data:';
$string['event_activity_created'] = 'Jarduera sortu da';
$string['event_activity_deleted'] = 'Jarduera ezabatu da';
$string['event_activity_updated'] = 'Jarduera eguneratu da';
$string['event_activity_viewed'] = 'Jarduera ikusi da';
$string['event_live_session'] = 'Zuzeneko saioa';
$string['event_meeting_created'] = 'Bilera-saioa sortu da';
$string['event_meeting_ended'] = 'Bilera amaitu dute';
$string['event_meeting_joined'] = 'Bileran sartu da';
$string['event_meeting_left'] = 'Bilera utzi du';
$string['event_recording_deleted'] = 'Grabazioa ezabatu da';
$string['event_recording_edited'] = 'Grabazioa editatu da';
$string['event_recording_imported'] = 'Grabazioa inportatu da';
$string['event_recording_protected'] = 'Grabazioa babestu da';
$string['event_recording_published'] = 'Grabazioa publikatu da';
$string['event_recording_unprotected'] = 'Grabazioari babesa kendu zaio';
$string['event_recording_unpublished'] = 'Grabazio publikatu gabea';
$string['event_recording_viewed'] = 'Grabazioa bistaratu da';
$string['general_error_not_allowed_to_create_instances'] = 'Erabiltzaileak ezin du inolako instantziarik sortu';
$string['general_error_unable_connect'] = 'Ezin da konexioa ezarri. Mesedez egiaztatu ezazu BigBlueButton zerbitzariaren URLa ondo dagoela eta BigBlueButton zerbitzaria martxan dagoela.';
$string['index_confirm_end'] = 'Klase birtuala amaitu nahi duzu?';
$string['index_disabled'] = 'desgaituta';
$string['index_enabled'] = 'gaituta';
$string['index_ending'] = 'Klase birtuala amaitzen ... itxaron mesedez';
$string['index_error_bbtn'] = 'BigBlueButton {$a} IDa ez da zuzena';
$string['index_error_checksum'] = 'Kontrolerako batura-errorea. Mesedez egiaztatu segurtasun-eraldaketa egokia egin duzula.';
$string['index_error_forciblyended'] = 'Ezin izan da bilera-gelara sartu eskuz amaitua izan delako.';
$string['index_error_noinstances'] = 'Ez dago BigBlueButton instantziarik';
$string['index_error_unable_display'] = 'Ezin izan dira bilera-gelak erakutsi. Mesedez egiaztatu BigBlueButton zerbitzariaren URLa ondo dagoela eta BigBlueButton zerbitzaria martxan dagoela.';
$string['index_heading'] = 'BigBlueButton gelak';
$string['index_heading_actions'] = 'Ekintzak';
$string['index_heading_group'] = 'Taldea';
$string['index_heading_moderator'] = 'Moderatzaileak';
$string['index_heading_name'] = 'Gela';
$string['index_heading_recording'] = 'Grabaketa';
$string['index_heading_users'] = 'Erabiltzaileak';
$string['index_heading_viewer'] = 'Ikusleak';
$string['indicator:cognitivedepth'] = 'BigBlueButton kognitiboa';
$string['indicator:cognitivedepth_help'] = 'Indikatzaile hau ikasleak BigBlueButton jardueran batean lortutako sakontasun kognitiboan oinarritzen da.';
$string['indicator:socialbreadth'] = 'BigBlueButton soziala';
$string['indicator:socialbreadth_help'] = 'Indikatzaile hau ikasleak BigBlueButton jardueran batean lortutako hedadura sozialean oinarritzen da.';
$string['instance_type_default'] = 'Bilera-gela/saioa grabazioarekin';
$string['instance_type_recording_only'] = 'Soilik grabazioa';
$string['instance_type_room_only'] = 'Soilik bilera-gela/saioa';
$string['mod_form_block_clienttype'] = 'Web bezeroaren teknologia';
$string['mod_form_block_clienttype_flash'] = 'Adobe Flash teknologian oinarritutako bezeroa';
$string['mod_form_block_clienttype_html5'] = 'HTML5 teknologian oinarritutako bezeroa';
$string['mod_form_block_general'] = 'Ezarpen orokorrak';
$string['mod_form_block_participants'] = 'Partaideak';
$string['mod_form_block_presentation'] = 'Aurkezpenaren edukia';
$string['mod_form_block_presentation_default'] = 'Aurkezpenaren eduki lehenetsia';
$string['mod_form_block_record'] = 'Grabazioen ezarpenak';
$string['mod_form_block_recordings'] = 'Grabazioen ikuspegia';
$string['mod_form_block_room'] = 'Bilera-gela/saioaren ezarpenak';
$string['mod_form_block_schedule'] = 'Saioen plangintza';
$string['mod_form_field_block_clienttype'] = 'Web bezeroaren teknologia';
$string['mod_form_field_closingtime'] = 'Sarreraren itxiera-data:';
$string['mod_form_field_conference_name'] = 'Bileraren izena';
$string['mod_form_field_duration'] = 'Iraupena';
$string['mod_form_field_duration_help'] = 'Bilera-gela baten iraupena ezartzeak, grabaketa amaitu baino lehen bilera-gela aktibo mantenduko den denbora-tarte maximoa adierazteko balio du';
$string['mod_form_field_instanceprofiles'] = 'Instantzia mota';
$string['mod_form_field_instanceprofiles_help'] = 'Hautatu BigBlueButton instantzia honen mota';
$string['mod_form_field_intro'] = 'Deskribapena';
$string['mod_form_field_intro_help'] = 'Bilera-gelaren deskribapen laburra';
$string['mod_form_field_muteonstart'] = 'Isilarazi hasieran';
$string['mod_form_field_name'] = 'Ikasgela birtualaren izena';
$string['mod_form_field_nosettings'] = 'Ez dago editatu daitekeen ezarpenik';
$string['mod_form_field_notification'] = 'Jakinarazi aldaketa hau matrikulatutako erabiltzaileei';
$string['mod_form_field_notification_created_help'] = 'Bidali jakinarazpen bat matrikulatutako erabiltzaile guztiei jarduera honen sorreraren berri emateko';
$string['mod_form_field_notification_help'] = 'Bidali jakinarazpen bat matrikulatutako erabiltzaile guztiei jarduera hau gehitu edo eguneratu dela jakin dezaten';
$string['mod_form_field_notification_modified_help'] = 'Bidali jakinarazpen bat matrikulatutako erabiltzaileei jarduera hau eguneratu dela jakin dezaten';
$string['mod_form_field_notification_msg_at'] = 'noiz';
$string['mod_form_field_notification_msg_created'] = 'gehitu da';
$string['mod_form_field_notification_msg_modified'] = 'eguneratu da';
$string['mod_form_field_openingtime'] = 'Sarreraren irekitze-data:';
$string['mod_form_field_participant_add'] = 'Gehitu partaidea';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderatzailea';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Ikuslea';
$string['mod_form_field_participant_list'] = 'Partaide-zerrenda';
$string['mod_form_field_participant_list_action_add'] = 'Gehitu';
$string['mod_form_field_participant_list_action_remove'] = 'Ezabatu';
$string['mod_form_field_participant_list_text_as'] = 'honela';
$string['mod_form_field_participant_list_type_all'] = 'Matrikulatutako erabiltzaile guztiak';
$string['mod_form_field_participant_list_type_owner'] = 'Jabea';
$string['mod_form_field_participant_list_type_role'] = 'Rola';
$string['mod_form_field_participant_list_type_user'] = 'Erabiltzailea';
$string['mod_form_field_record'] = 'Saioa grabatu daiteke';
$string['mod_form_field_recordallfromstart'] = 'Grabatu dena hasieratik';
$string['mod_form_field_recordhidebutton'] = 'Ezkutatu grabatzeko botoia';
$string['mod_form_field_recordings_deleted'] = 'Ezabatutako jardueren grabazioak barne ditu';
$string['mod_form_field_recordings_html'] = 'Erakutsi taula formaturik gabeko HTML-an';
$string['mod_form_field_recordings_imported'] = 'Erakutsi soilik inportatutako estekak';
$string['mod_form_field_recordings_preview'] = 'Erakutsi grabazioaren aurrebista';
$string['mod_form_field_room_name'] = 'Gelaren izena';
$string['mod_form_field_userlimit'] = 'Erabiltzaile-muga';
$string['mod_form_field_userlimit_help'] = 'Bilera batean onartutako gehienezko erabiltzaile kopurua. Ezarritako muga 0 bada ez da erabiltzaile mugarik egongo.';
$string['mod_form_field_voicebridge'] = 'Ahots-zubia [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Formatuaren errorea. 1 eta 9999 arteko zenbaki bat sartu behar duzu.';
$string['mod_form_field_voicebridge_help'] = 'Partaideek ahots konferentziara sartzeko erabiltzen duten ahots konferentzia zenbakia. 1 eta 9999 arteko zenbakia idatzi behar da. Balioa 0 bada ahots-zubi estatikoari ezikusia egingo zaio eta BigBlueButtonek ausazko zenbaki bat sortuko du. Idatzitako 4 zenbakien aurretik 7 bat gehituko da.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Balioa ez da bakarra. Zenbaki hori beste bilera-gela batean erabiltzen ari da.';
$string['mod_form_field_wait'] = 'Itxaron moderatzaileari';
$string['mod_form_field_wait_help'] = 'Ikusleek moderatzailea saioan sartu arte itxaron beharko dute bertan sartu ahal izateko';
$string['mod_form_field_welcome'] = 'Ongietorri mezua';
$string['mod_form_field_welcome_default'] = '<br>Ongietorri <b>%%CONFNAME%%(e)ra</b>!<br><br>BigBlueButton nola funtzionatzen duen ulertzeko ikusi itzazu gure <a href="event:http://www.bigbluebutton.org/content/videos"><u>bideo tutorialak</u></a>.<br><br>Ahots-zubira sartzeko sakatu entzungailuen ikonoan (goiko aldeko erdialdean). <b>Mesedez entzungailuak erabili itzazu beste erabiltzaileentzat zaratarik ez eragiteko.</b>';
$string['mod_form_field_welcome_help'] = 'BigBlueButton zerbitzariko lehenetsitako ongietorri mezua ordezkatzen du. Mezuak automatikoki ordezkatuko diren hitz-gakoak izan ditzake (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%), baita <b>...</b> edo <i></i> bezalako HTML etiketak ere.';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButton gehigarriak Moodletik denbora-errealeko online ikasgeletara estekak sortzeko aukera ematen du BigBlueButton erabiliz, urruneko hezkuntzarako kode irekiko web konferentzia sistema bat.

BigBlueButton erabiliz izenburua, deskribapena, egutegiko ekitaldia (saiora sartzeko data-tarte bat definitzeko), taldeak eta saioaren grabazioari buruzko xehetasunak ezarri ditzakezu.';
$string['modulenameplural'] = 'BigBlueButton';
$string['pluginadministration'] = 'BigBlueButton-en kudeaketa';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'BigBlueButton saioak sortzeko eta bertan sartzeko, zerbitzariarekin erabiltzaile-datuak trukatu behar dira.';
$string['privacy:metadata:bigbluebuttonbn'] = 'BigBlueButton bilera-gela edo saioaren ezaugarriak eta portaera orokorra zehazten duen konfigurazioa gordetzen du.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Plugin erabiltzean aktibatzen diren gertaerak gordetzen ditu';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Erabiltzaileak sortutako gertaera mota.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'Erabiltzailea sartu den gelaren IDa';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Bileraren edo haren grabazioaren inguruko informazio gehigarria eduki dezake barnean.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Erregistroa sortu den ordua.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'Saioa sortu duen erabiltzailearen IDa.';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Bileran parte parte hartzen duten erabiltzaileen rolen gida-lerroak. Erabiltzaile IDa gordeko da zeren baimena esleitu dakioke rolari edo erabiltzaileari.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'BigBlueButton zerbitzarian sartzen den erabiltzailearen izen osoa.';
$string['privacy:metadata:bigbluebutton:userid'] = 'BigBlueButton zerbitzarian sartzen den erabiltzailearen IDa.';
$string['removedevents'] = 'Ezabatutako ekitaldiak';
$string['removedlogs'] = 'Ezabatutako erregistro pertsonalak';
$string['removedrecordings'] = 'Ezabatutako grabazioak';
$string['removedtags'] = 'Ezabatutako etiketak';
$string['resetevents'] = 'Ezabatu gertaerak';
$string['resetlogs'] = 'Ezabatu erregistro pertsonalizatuak';
$string['resetlogs_help'] = 'Erregistroak ezabatuz gero grabazioen erreferentziak galduko dira';
$string['resetrecordings'] = 'Ezabatu grabazioak';
$string['resetrecordings_help'] = 'Grabazioak ezabatuz gero ezingo ditu inork erabili eta horrek ez du atzera bueltarik';
$string['resettags'] = 'Ezabatu etiketak';
$string['search:activity'] = 'BigBlueButton - aktibitatearen informazioa';
$string['search:tags'] = 'BigBlueButton - etiketen informazioa';
$string['started_at'] = 'Hasita';
$string['starts_at'] = 'Hasiera-data';
$string['view_conference_action_end'] = 'Amaitu saioa';
$string['view_conference_action_join'] = 'Sartu saioan';
$string['view_error_action_not_completed'] = 'Ekintza ezin da osatu';
$string['view_error_bigbluebutton'] = 'BigBlueButton-ek erroreekin erantzuten du. {$a}';
$string['view_error_create'] = 'BigBlueButton zerbitzariak errore mezuarekin erantzun du, bilera ezin izan da sortu.';
$string['view_error_current_state_not_found'] = 'Uneko egoera ezezaguna. Grabazioa ezabatu da edo BigBlueButton zerbitzaria ez da bateragarria gauzatutako ekintzarekin.';
$string['view_error_import_no_courses'] = 'Ez dago grabaketak bilatzeko ikastarorik.';
$string['view_error_import_no_recordings'] = 'Ikastaro honetan ez dago grabaziorik inportatzeko';
$string['view_error_invalid_session'] = 'Saioa amaitu da. Bueltatu jardueraren orri nagusira.';
$string['view_error_max_concurrent'] = 'Aldi berean gauzatu daitezkeen bileren baimendutako gehienezkora iritsi da.';
$string['view_error_meeting_not_running'] = 'Zerbaitek huts egin du, saioa ez dago martxan.';
$string['view_error_no_group'] = 'Oraindik ez da talderik konfiguratu. Mesedez taldeak sortu itzazu bilera-gelara sartzen saiatu baino lehen.';
$string['view_error_no_group_student'] = 'Ez zaude inongo taldetan sarturta. Mesedez jarri harremanetan zure Irakasle edo Kudeatzailearekin.';
$string['view_error_no_group_teacher'] = 'Oraindik ez da talderik konfiguratu. Mesedez taldeak sortu itzazu edo jarri zaitez harremanetan Kudeatzailearekin.';
$string['view_error_unable_join'] = 'Ezin izan da bilera-gelara sartu. Mesedez egiaztatu BigBlueButton zerbitzariaren URLa eta ziurtatu BigBlueButton zerbitzaria martxan dagoela.';
$string['view_error_unable_join_student'] = 'Ezin izan da BigBlueButton zerbitzariarekin konexiorik ezarri. Mesedez jarri harremanetan zure Irakasle edo Kudeatzailearekin.';
$string['view_error_unable_join_teacher'] = 'Ezin izan da BigBlueButton zerbitzariarekin konexiorik ezarri. Mesedez Kudeatzailearekin harremanetan jarri.';
$string['view_error_url_missing_parameters'] = 'URL honetan parametroak falta dira';
$string['view_error_userlimit_reached'] = 'Baimendutako gehienezko erabiltzaile-kopurua bete da.';
$string['view_groups_nogroups_warning'] = 'Bilera-gela taldeak erabiltzeko konfiguratu da baina ikastaro honetan ez dago talderik sortuta.';
$string['view_groups_notenrolled_warning'] = 'Bilera-gela taldeak erabiltzeko konfiguratu da baina zu ez zaude inongo taldean sartuta.';
$string['view_groups_selection'] = 'Aukera ezazu ze talderen partaide izan nahi duzun eta ekintza baieztatu ezazu';
$string['view_groups_selection_join'] = 'Sartu';
$string['view_groups_selection_warning'] = 'Talde bakoitzak bere bilera-gela du eta zu batean baino gehiagotako sarbidea duzu. Ziurtatu ezazu zuzena hautatzen duzula.';
$string['view_login_moderator'] = 'Saioan moderatzaile gisa sartzen...';
$string['view_login_viewer'] = 'Saioan ikusle gisa sartzen...';
$string['view_message_and'] = 'eta';
$string['view_message_conference_has_ended'] = 'Bilera bukatu da.';
$string['view_message_conference_in_progress'] = 'Bilera martxan dago.';
$string['view_message_conference_not_started'] = 'Bilera ez da hasi oraindik.';
$string['view_message_conference_room_ready'] = 'Bilera-gela prest dago. Orain sartu zaitezke.';
$string['view_message_conference_wait_for_moderator'] = 'Moderatzailearen zain sartu ahal izateko.';
$string['view_message_finished'] = 'Jarduera hau amaitu da.';
$string['view_message_has_joined'] = 'sartu da';
$string['view_message_have_joined'] = 'sartu dira';
$string['view_message_hour'] = 'ordu';
$string['view_message_hours'] = 'ordu';
$string['view_message_importrecordings_disabled'] = 'Grabazioak inportatzeko funtzionalitatea desgaituta dago zerbitzari honetan.';
$string['view_message_minute'] = 'minutu';
$string['view_message_minutes'] = 'minutu';
$string['view_message_moderator'] = 'moderatzailea';
$string['view_message_moderators'] = 'moderatzaileak';
$string['view_message_norecordings'] = 'Ez dago grabaziorik erakusteko.';
$string['view_message_notavailableyet'] = 'Saio hau oraindik ez dago erabilgarri.';
$string['view_message_recordings_disabled'] = 'Grabazioak desgaituta daude zerbitzari honetan. Ezin da erabili soilik grabazioa motako BigBlueButton instantziarik.';
$string['view_message_room_closed'] = 'Bilera-gela itxita dago.';
$string['view_message_room_open'] = 'Bilera-gela irekita dago.';
$string['view_message_room_ready'] = 'Bilera-gela prest dago.';
$string['view_message_session_for'] = 'saio honetarako';
$string['view_message_session_has_user'] = 'Bada';
$string['view_message_session_has_users'] = 'Badira';
$string['view_message_session_no_users'] = 'Saio honetan ez dago erabiltzailerik';
$string['view_message_session_running_for'] = 'Saio hau martxan egon da tarte honetan:';
$string['view_message_session_started_at'] = 'Saioa honen hasiera-data:';
$string['view_message_tab_close'] = 'Fitxa/leiho hau eskuz itxi behar da';
$string['view_message_times'] = 'aldiz';
$string['view_message_user'] = 'erabiltzaile';
$string['view_message_users'] = 'erabiltzaile';
$string['view_message_viewer'] = 'ikusle';
$string['view_message_viewers'] = 'ikusle';
$string['view_mobile_message_groups_not_supported'] = 'Instantzia hau taldeekin erabiltzeko gaitu da baina mobile aplikazioak ez du horrelakorik onartzen. Ireki saioa ordenagailuan talde-sostengua erabili nahi baduzu.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Orri honetan 45 segundoko muga gainditu duzu, birkargatu orria bileran sartu ahal izateko.';
$string['view_noguests'] = 'BigBlueButton ez dago bisitarientzat eskuragarri';
$string['view_nojoin'] = 'Zure uneko rolak ez du saio honetan sartzeko baimenik.';
$string['view_recording'] = 'grabatzen';
$string['view_recording_actionbar'] = 'Tresna-barra';
$string['view_recording_activity'] = 'Jarduera';
$string['view_recording_button_import'] = 'Inportatu grabazioen estekak';
$string['view_recording_button_return'] = 'Egin atzera';
$string['view_recording_course'] = 'Ikastaroa';
$string['view_recording_date'] = 'Data';
$string['view_recording_delete_confirmation'] = 'Ziur zaude {$a} ezabatu nahi duzula?';
$string['view_recording_delete_confirmation_warning_p'] = 'Grabazioak {$a} esteka ditu ikastaro edo jarduera desberdinetatik inportatuta. Grabazioa ezabatzen bada esteka horiek ere ezabatuko dira.';
$string['view_recording_delete_confirmation_warning_s'] = 'Grabazioak esteka {$a} du ikastaro edo jarduera desberdin batetik inportatuta. Grabazioa ezabatzen bada esteka hori ere ezabatuko da.';
$string['view_recording_description'] = 'Deskribapena';
$string['view_recording_duration'] = 'Iraupena';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'Grabazio formatu horren URL ezin da lortu.';
$string['view_recording_format_notes'] = 'Oharrak';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'Aurkezpena';
$string['view_recording_format_screenshare'] = 'Pantaila-partekatzea';
$string['view_recording_format_statistics'] = 'Estatistikak';
$string['view_recording_format_video'] = 'Bideoa';
$string['view_recording_import_confirmation'] = 'Ziur zaude grabazio hau inportatu nahi duzula?';
$string['view_recording_length'] = 'Luzera';
$string['view_recording_link_warning'] = 'Esteka hau beste ikastaro edo jarduera batean sortutako grabaziora lotuta dago';
$string['view_recording_list_actionbar'] = 'Tresna-bara';
$string['view_recording_list_actionbar_delete'] = 'Ezabatu';
$string['view_recording_list_actionbar_edit'] = 'Editatu';
$string['view_recording_list_actionbar_hide'] = 'Ezkutatu';
$string['view_recording_list_actionbar_import'] = 'Inportatu';
$string['view_recording_list_actionbar_protect'] = 'Pribatua egin';
$string['view_recording_list_actionbar_publish'] = 'Publikatu';
$string['view_recording_list_actionbar_show'] = 'Erakutsi';
$string['view_recording_list_actionbar_unprotect'] = 'Publikoa egin';
$string['view_recording_list_actionbar_unpublish'] = 'Des-publikatu';
$string['view_recording_list_action_delete'] = 'Ezabatzen';
$string['view_recording_list_action_edit'] = 'Eguneratzen';
$string['view_recording_list_action_play'] = 'Erreproduzitu';
$string['view_recording_list_action_process'] = 'Prozesatzen';
$string['view_recording_list_action_protect'] = 'Babesten';
$string['view_recording_list_action_publish'] = 'Publikatzen';
$string['view_recording_list_action_unprotect'] = 'Desbabesten';
$string['view_recording_list_action_unpublish'] = 'Des-publikatzen';
$string['view_recording_list_action_update'] = 'Eguneratzen';
$string['view_recording_list_activity'] = 'Jarduera';
$string['view_recording_list_course'] = 'Ikastaroa';
$string['view_recording_list_date'] = 'Data';
$string['view_recording_list_description'] = 'Deskribapena';
$string['view_recording_list_duration'] = 'Iraupena';
$string['view_recording_list_recording'] = 'Grabaketa';
$string['view_recording_meeting'] = 'Bilera';
$string['view_recording_modal_button'] = 'Aplikatu';
$string['view_recording_modal_title'] = 'Ezarri grabaziorako balioak';
$string['view_recording_name'] = 'Izena';
$string['view_recording_playback'] = 'Erreproduzitu';
$string['view_recording_preview'] = 'Aurrebista';
$string['view_recording_preview_help'] = 'Jarri kurtsorea irudi baten gainean tamaina osoan ikusteko';
$string['view_recording_publish_link_deleted'] = 'Esteka hau ezin da berriz publikatu uneko grabazioa ez dagoelako BigBlueButton zerbitzarian. Esteka kendu beharko litzateke.';
$string['view_recording_publish_link_not_published'] = 'Esteka hau ezin da berriz publikatu uneko grabazioa ez dagoelako publiko.';
$string['view_recording_recording'] = 'Grabatzen';
$string['view_recording_tags'] = 'Etiketak';
$string['view_recording_unprotect_link_deleted'] = 'Esteka honi ezin zaio babesa kendu uneko grabazioa ez dagoelako BigBlueButton zerbitzarian. Esteka kendu beharko litzateke.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Esteka honi ezin zaio babesa kendu uneko grabazioa babestuta dagoelako';
$string['view_recording_unpublish_confirmation'] = 'Ziur zaude {$a} hau des-publikatu nahi duzula?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Grabazioak {$a} esteka ditu ikastaro edo jarduera desberdinetatik inportatuta. Grabazioa des-publikatzen bada esteka horiek ere des-publikatuko dira.';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Grabazioak {$a} esteka ditu ikastaro edo jarduera desberdin batetik inportatuta. Grabazioa des-publikatzen bada esteka horiek ere des-publikatuko dira.';
$string['view_recording_yui_first'] = 'Lehenengoa';
$string['view_recording_yui_go'] = 'Joan';
$string['view_recording_yui_last'] = 'Azkena';
$string['view_recording_yui_next'] = 'Hurrengoa';
$string['view_recording_yui_page'] = 'Orria';
$string['view_recording_yui_prev'] = 'Aurrekoa';
$string['view_recording_yui_rows'] = 'Errenkadak';
$string['view_recording_yui_show_all'] = 'Erakutsi dena';
$string['view_room'] = 'Ikusi gela';
$string['view_section_title_presentation'] = 'Aurkezpenaren fitxategia';
$string['view_section_title_recordings'] = 'Grabazioak';
$string['view_warning_default_server'] = 'Moodle zerbitzari hau modu lehenetsian aurre-konfiguratuta datorren BigBlueButton probarako zerbitzaria erabiltzen ari da. Lanerako ordezkatu beharko litzateke.';
