<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'sr_lt', branch 'MOODLE_37_STABLE'
 *
 * @package   editor_tinymce
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Adresa';
$string['advanced:anchor_delta_height'] = '0';
$string['advanced:anchor_delta_width'] = '0';
$string['advanced:anchor_desc'] = 'Umetni/uredi sidro';
$string['advanced:backcolor_desc'] = 'Izaberi boju pozadine';
$string['advanced:block'] = 'Format';
$string['advanced:blockquote'] = 'Citat';
$string['advanced:blockquote_desc'] = 'Citat';
$string['advanced:bold_desc'] = 'Podebljano (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Umetni/ukloni neuređenu listu';
$string['advanced:charmap_delta_height'] = '0';
$string['advanced:charmap_delta_width'] = '0';
$string['advanced:charmap_desc'] = 'Umetni specijalni znak';
$string['advanced:cleanup_desc'] = 'Očisti kôd';
$string['advanced:clipboard_msg'] = 'Komande kopiraj/iseci/nalepi nisu dostupne u veb čitačima Mozilla i Firefox. Da li želite više informacija o ovome?';
$string['advanced:code'] = 'Kôd';
$string['advanced:code_desc'] = 'Uredi HTML izvorni kôd';
$string['advanced:colorpicker_delta_height'] = '0';
$string['advanced:colorpicker_delta_width'] = '0';
$string['advanced:copy_desc'] = 'Kopiraj';
$string['advanced:custom1_desc'] = 'Vaš namenski opis';
$string['advanced:cut_desc'] = 'Iseci';
$string['advanced:dd'] = 'Opis definicija';
$string['advanced:div'] = 'DIV';
$string['advanced_dlg:'] = '';
$string['advanced_dlg:about_author'] = 'Autor';
$string['advanced_dlg:about_general'] = 'O';
$string['advanced_dlg:about_help'] = 'Pomoć';
$string['advanced_dlg:about_license'] = 'Licenca';
$string['advanced_dlg:about_loaded'] = 'Učitani dodaci';
$string['advanced_dlg:about_plugin'] = 'Dodatak';
$string['advanced_dlg:about_plugins'] = 'Dodaci';
$string['advanced_dlg:about_title'] = 'O TinyMCE editoru';
$string['advanced_dlg:about_version'] = 'Verzija';
$string['advanced_dlg:accessibility_help'] = 'Pomoć za pristupačnost';
$string['advanced_dlg:accessibility_usage_title'] = 'Opšta upotreba';
$string['advanced_dlg:anchor_invalid'] = 'Molimo, navedite ispravan naziv sidra';
$string['advanced_dlg:anchor_name'] = 'Ime sidra';
$string['advanced_dlg:anchor_title'] = 'Umetni/uredi sidro';
$string['advanced_dlg:charmap_title'] = 'Izaberi specijalni znak';
$string['advanced_dlg:charmap_usage'] = 'Koristite strelice nalevo i nadesno za kretanje';
$string['advanced_dlg:code_title'] = 'HTML editor';
$string['advanced_dlg:code_wordwrap'] = 'Prelom teksta';
$string['advanced_dlg:colorpicker_color'] = 'Boja';
$string['advanced_dlg:colorpicker_name'] = 'Ime';
$string['advanced_dlg:colorpicker_named_tab'] = 'Imenovano';
$string['advanced_dlg:colorpicker_named_title'] = 'Imenovana boja';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Paleta';
$string['advanced_dlg:colorpicker_palette_title'] = 'Boje palete';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Birač';
$string['advanced_dlg:colorpicker_picker_title'] = 'Birač boje';
$string['advanced_dlg:colorpicker_title'] = 'Izaberi boju';
$string['advanced_dlg:image_align'] = 'Poravnanje';
$string['advanced_dlg:image_align_baseline'] = 'Osnovna linija';
$string['advanced_dlg:image_align_bottom'] = 'Dole';
$string['advanced_dlg:image_align_left'] = 'Levo';
$string['advanced_dlg:image_align_middle'] = 'Sredina';
$string['advanced_dlg:image_align_right'] = 'Desno';
$string['advanced_dlg:image_align_textbottom'] = 'Tekst dole';
$string['advanced_dlg:image_align_texttop'] = 'Tekst gore';
$string['advanced_dlg:image_align_top'] = 'Gore';
$string['advanced_dlg:image_alt'] = 'Opis slike';
$string['advanced_dlg:image_border'] = 'Ivica';
$string['advanced_dlg:image_dimensions'] = 'Dimenzija';
$string['advanced_dlg:image_hspace'] = 'Horizontalni razmak';
$string['advanced_dlg:image_list'] = 'Spisak slika';
$string['advanced_dlg:image_src'] = 'URL slike';
$string['advanced_dlg:image_title'] = 'Umetni/uredi sliku';
$string['advanced_dlg:image_vspace'] = 'Vertikalni razmak';
$string['advanced_dlg:invalid_color_value'] = 'Neispravna vrednost boje';
$string['advanced_dlg:link_is_email'] = 'Izgleda da je URL koji ste uneli adresa e-pošte. Da li želite da dodate neophodan prefiks mailto:?';
$string['advanced_dlg:link_is_external'] = 'Izgleda da je URL koji ste uneli eksternai link. Da li želite da dodate neophodan prefiks http://?';
$string['advanced_dlg:link_list'] = 'Lista linkova';
$string['advanced_dlg:link_target'] = 'Cilj';
$string['advanced_dlg:link_target_blank'] = 'Otvori link u novom prozoru';
$string['advanced_dlg:link_target_same'] = 'Otvori link u istom prozoru';
$string['advanced_dlg:link_title'] = 'Umetni/uredi link';
$string['advanced_dlg:link_titlefield'] = 'Naslov';
$string['advanced_dlg:link_url'] = 'Linka URL';
$string['advanced:dt'] = 'Definicija pojma';
$string['advanced:fontdefault'] = 'Porodica slova';
$string['advanced:font_size'] = 'Veličina fonta';
$string['advanced:forecolor_desc'] = 'Izaberi boju teksta';
$string['advanced:h1'] = 'Naslov 1';
$string['advanced:h2'] = 'Naslov 2';
$string['advanced:h3'] = 'Naslov 3';
$string['advanced:h4'] = 'Naslov 4';
$string['advanced:h5'] = 'Naslov 5';
$string['advanced:h6'] = 'Naslov 6';
$string['advanced:help_desc'] = 'Pomoć';
$string['advanced:help_shortcut'] = 'Pritisni ALT-F10 za traku sa alatkama. Pritisni ALT-0 za pomoć';
$string['advanced:hr_desc'] = 'Umetni horizontalnu liniju';
$string['advanced:image_delta_height'] = '0';
$string['advanced:image_delta_width'] = '0';
$string['advanced:image_desc'] = 'Umetni/uredi sliku';
$string['advanced:image_props_desc'] = 'Svojstva slike';
$string['advanced:indent_desc'] = 'Povećaj uvlačenje';
$string['advanced:italic_desc'] = 'Kurziv (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'Centriraj';
$string['advanced:justifyfull_desc'] = 'Potpuno poravnaj';
$string['advanced:justifyleft_desc'] = 'Poravnaj levo';
$string['advanced:justifyright_desc'] = 'Poravnaj desno';
$string['advanced:link_delta_height'] = '0';
$string['advanced:link_delta_width'] = '0';
$string['advanced:link_desc'] = 'Umetni/uredi link';
$string['advanced:more_colors'] = 'Više boja...';
$string['advanced:newdocument'] = 'Da li ste sigurni da želite da uklonite ceo sadržaj?';
$string['advanced:newdocument_desc'] = 'Novi dokument';
$string['advanced:numlist_desc'] = 'Umetni/ukloni uređenu listu';
$string['advanced:outdent_desc'] = 'Smanji uvlačenje';
$string['advanced:paragraph'] = 'Pasus';
$string['advanced:paste_desc'] = 'Nalepi';
$string['advanced:path'] = 'Putanja';
$string['advanced:pre'] = 'Preformatirano';
$string['advanced:redo_desc'] = 'Ponovi poslednju akciju (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Ukloni formatiranje';
$string['advanced:rich_text_area'] = 'Polje za tekst u RTF formatu';
$string['advanced:samp'] = 'Uzorak kôda';
$string['advanced:shortcuts_desc'] = 'Pomoć za pristupačnost';
$string['advanced:striketrough_desc'] = 'Precrtano';
$string['advanced:style_select'] = 'Stilovi';
$string['advanced:sub_desc'] = 'Subskript (indeks)';
$string['advanced:sup_desc'] = 'Superskript (eksponent)';
$string['advanced:toolbar'] = 'Traka sa alatkama';
$string['advanced:toolbar_focus'] = 'Pređi na alatke - Alt+Q, pređi na editor - Alt-Z, pređi na putanju elementa - Alt-X';
$string['advanced:underline_desc'] = 'Podvučeno (Ctrl+U)';
$string['advanced:undo_desc'] = 'Ponišri poslednju akciju (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Ukloni link';
$string['advanced:visualaid_desc'] = 'Prikaži/sakrij vođice/nevidljive elemente';
$string['advhr:advhr_desc'] = 'Umetni horizontalnu liniju';
$string['advhr:delta_height'] = 'Horizontalna linija (visina)';
$string['advhr:delta_width'] = 'Horizontalna linija (širina)';
$string['advhr_dlg:normal'] = 'Normalno';
$string['advhr_dlg:noshade'] = 'Bez senke';
$string['advhr_dlg:size'] = 'Visina';
$string['advhr_dlg:width'] = 'Širina';
$string['advhr_dlg:widthunits'] = 'Jedinice';
$string['advimage:delta_height'] = '0';
$string['advimage:delta_width'] = '0';
$string['advimage_dlg:align'] = 'Poravnanje';
$string['advimage_dlg:align_baseline'] = 'Osnovna linija';
$string['advimage_dlg:align_bottom'] = 'Dole';
$string['advimage_dlg:align_left'] = 'Levo';
$string['advimage_dlg:align_middle'] = 'Sredina';
$string['advimage_dlg:align_right'] = 'Desno';
$string['advimage_dlg:align_textbottom'] = 'Tekst dole';
$string['advimage_dlg:align_texttop'] = 'Tekst gore';
$string['advimage_dlg:align_top'] = 'Gore';
$string['advimage_dlg:alt'] = 'Opis slike';
$string['advimage_dlg:alt_image'] = 'Alternativna slika';
$string['advimage_dlg:border'] = 'Ivica';
$string['advimage_dlg:classes'] = 'Klase';
$string['advimage_dlg:constrain_proportions'] = 'Zadrži proporcije';
$string['advimage_dlg:dialog_title'] = 'Umetni/uredi sliku';
$string['advimage_dlg:dimensions'] = 'Dimenzije';
$string['advimage_dlg:example_img'] = 'Prikaz slike';
$string['advimage_dlg:general'] = 'Opšte';
$string['advimage_dlg:height'] = 'Visina';
$string['advimage_dlg:hspace'] = 'Horizontalni razmak';
$string['advimage_dlg:id'] = 'ID';
$string['advimage_dlg:image_list'] = 'Spisak slika';
$string['advimage_dlg:langcode'] = 'Jezički kôd';
$string['advimage_dlg:langdir'] = 'Smer jezika';
$string['advimage_dlg:list'] = 'Spisak slika';
$string['advimage_dlg:long_desc'] = 'Duži opis linka';
$string['advimage_dlg:ltr'] = 'Sleva nadesno';
$string['advimage_dlg:map'] = 'Mapa slike';
$string['advimage_dlg:misc'] = 'Razno';
$string['advimage_dlg:missing_alt'] = 'Da li ste sigurni da želite nastavite bez \'Opisa slika\'? Bez opisa, slika neće biti dostupna pojedinim korisnicima koji imaju probleme sa vidom, onima koji koriste tekstualni veb čitač ili onima koji su u veb čitaču isključili opciju za slike.';
$string['advimage_dlg:mouseout'] = 'za izlazak miša izvan slike';
$string['advimage_dlg:mouseover'] = 'za prelazak miša preko slike';
$string['advimage_dlg:preview'] = 'Prikaz';
$string['advimage_dlg:rtl'] = 'Zdesna nalevo';
$string['advimage_dlg:src'] = 'URL slike';
$string['advimage_dlg:style'] = 'Stil';
$string['advimage_dlg:swap_image'] = 'Izmena slike';
$string['advimage_dlg:tab_advanced'] = 'Napredno';
$string['advimage_dlg:tab_appearance'] = 'Izgled';
$string['advimage_dlg:tab_general'] = 'Opšte';
$string['advimage_dlg:title'] = 'Naslov';
$string['advimage_dlg:vspace'] = 'Vertikalni razmak';
$string['advimage_dlg:width'] = 'Širina';
$string['advimage:image_desc'] = 'Umetni/uredi sliku';
$string['advlink:delta_height'] = '0';
$string['advlink:delta_width'] = '0';
$string['advlink_dlg:accesskey'] = 'Pristupni ključ';
$string['advlink_dlg:advanced_props'] = 'Napredna svojstva';
$string['advlink_dlg:advanced_tab'] = 'Napredno';
$string['advlink_dlg:anchor_names'] = 'Sidra';
$string['advlink_dlg:classes'] = 'Klase';
$string['advlink_dlg:encoding'] = 'Odredišni kodni raspored';
$string['advlink_dlg:event_props'] = 'Događaji';
$string['advlink_dlg:events_tab'] = 'Događaji';
$string['advlink_dlg:general_props'] = 'Opšta svojstva';
$string['advlink_dlg:general_tab'] = 'Opšte';
$string['advlink_dlg:height'] = 'Visina';
$string['advlink_dlg:id'] = 'ID';
$string['advlink_dlg:is_email'] = 'Izgleda da je URL koji ste uneli adresa e-pošte. Da li želite da dodate neophodan prefiks mailto:?';
$string['advlink_dlg:is_external'] = 'Izgleda da je URL koji ste uneli eksternai link. Da li želite da dodate neophodan prefiks http://?';
$string['advlink_dlg:langcode'] = 'Jezički kôd';
$string['advlink_dlg:langdir'] = 'Smer jezika';
$string['advlink_dlg:link_list'] = 'Lista linkova';
$string['advlink_dlg:list'] = 'Lista linkova';
$string['advlink_dlg:ltr'] = 'Sleva nadesno';
$string['advlink_dlg:mime'] = 'Odredišni MIME tip';
$string['advlink_dlg:popup'] = 'JavaScript iskačući prozor';
$string['advlink_dlg:popup_dependent'] = 'Zavisno (samo za Mozilla/Firefox)';
$string['advlink_dlg:popup_location'] = 'Prikaži adresnu traku';
$string['advlink_dlg:popup_menubar'] = 'Prikažu traku menija';
$string['advlink_dlg:popup_name'] = 'Ime prozora';
$string['advlink_dlg:popup_opts'] = 'Opcije';
$string['advlink_dlg:popup_position'] = 'Položaj (X/Y)';
$string['advlink_dlg:popup_props'] = 'Svojstva iskačućeg prozora';
$string['advlink_dlg:popup_resizable'] = 'Prozor promenljive veliчine';
$string['advlink_dlg:popup_return'] = 'Umetni \'return false\\';
$string['advlink_dlg:popup_scrollbars'] = 'Prikažu kliznu traku';
$string['advlink_dlg:popup_size'] = 'Veličina';
$string['advlink_dlg:popup_statusbar'] = 'Prikaži traku statusa';
$string['advlink_dlg:popup_tab'] = 'Iskačući prozor';
$string['advlink_dlg:popup_toolbar'] = 'Prikaži traku sa alatkama';
$string['advlink_dlg:popup_url'] = 'URL adresa iskačućeg prozora';
$string['advlink_dlg:rel'] = 'Odnos stranice prema cilju';
$string['advlink_dlg:rev'] = 'Odnos cilja prema stranici';
$string['advlink_dlg:rtl'] = 'Zdesna nalevo';
$string['advlink_dlg:style'] = 'Stil';
$string['advlink_dlg:tabindex'] = 'TabIndex';
$string['advlink_dlg:target'] = 'Cilj';
$string['advlink_dlg:target_blank'] = 'Otvori u novom prozoru';
$string['advlink_dlg:target_langcode'] = 'Ciljni jezik';
$string['advlink_dlg:target_name'] = 'Ciljno ime';
$string['advlink_dlg:target_parent'] = 'Otvori u nadređenom prozoru/okviru';
$string['advlink_dlg:target_same'] = 'Otvori u ovom prozoru/okviru';
$string['advlink_dlg:target_top'] = 'Otvori u gornjem okviru (uklanja sve okvire)';
$string['advlink_dlg:title'] = 'Umetni/uredi link';
$string['advlink_dlg:titlefield'] = 'Naslov';
$string['advlink_dlg:url'] = 'URL veze';
$string['advlink_dlg:width'] = 'Širina';
$string['advlink:link_desc'] = 'Umetni/uredi link';
$string['advlist:circle'] = 'Prazan kružić';
$string['advlist:def'] = 'Podrazumevano';
$string['advlist:disc'] = 'Pun kružić (disk)';
$string['advlist:lower_alpha'] = 'Mala slova azbuke/abecede';
$string['advlist:lower_greek'] = 'Mala slova grčkog alfabeta';
$string['advlist:lower_roman'] = 'Rimski brojevi malim slovima';
$string['advlist:square'] = 'Kvadratić';
$string['advlist:types'] = 'Tipovi';
$string['advlist:upper_alpha'] = 'Velika slova azbuke/abecede';
$string['advlist:upper_roman'] = 'Rimski brojevi velikim slovima';
$string['aria:rich_text_area'] = 'Polje za tekst u RTF formatu';
$string['autosave:restore_content'] = 'Vrati automatski sačuvani tekst';
$string['autosave:unload_msg'] = 'Izmene koje ste napravili neće biti sačuvane ukoliko odeta sa ove stranie.';
$string['autosave:warning_message'] = 'Ako vratite sačuvani sadržaj, izgubićete sav sadržaj koji se trenutno nalazi u editoru.

Da li ste sigurni da želite da vratite sačuvani sadržaj?';
$string['availablebuttons'] = 'Dostupna dugmad';
$string['colors:000000'] = 'Crna';
$string['colors:000080'] = 'Tamno plava';
$string['colors:0000FF'] = 'Plava';
$string['colors:003300'] = 'Tamno zelena';
$string['colors:003366'] = 'Tamno neboplava';
$string['colors:008000'] = 'Zelena';
$string['colors:008080'] = 'Plavozelena';
$string['colors:00CCFF'] = 'Nebo plava';
$string['colors:00FF00'] = 'Žutozelena';
$string['colors:00FFFF'] = 'Akva (boja vode)';
$string['colors:333300'] = 'Tamno maslinasta';
$string['colors:333333'] = 'Veoma tamno siva';
$string['colors:333399'] = 'Indigoplava';
$string['colors:3366FF'] = 'Kraljevski plava';
$string['colors:339966'] = 'Morski zelena';
$string['colors:33CCCC'] = 'Tirkizna';
$string['colors:666699'] = 'Sivkasto plava';
$string['colors:800000'] = 'Kestenjastomrka';
$string['colors:800080'] = 'Purpurna';
$string['colors:808000'] = 'Maslinasta';
$string['colors:808080'] = 'Siva';
$string['colors:993300'] = 'Tamno narandžasta';
$string['colors:993366'] = 'Smeđa (braon)';
$string['colors:999999'] = 'Srednje siva';
$string['colors:99CC00'] = 'Žuto zelena';
$string['colors:99CCFF'] = 'Svetlo nebo plava';
$string['colors:C0C0C0'] = 'Srebrna';
$string['colors:CC99FF'] = 'Tamnoljubičasta';
$string['colors:CCFFCC'] = 'Bledozelena';
$string['colors:CCFFFF'] = 'Bledocijan (bledoplavozelena)';
$string['colors:FF0000'] = 'Crvena';
$string['colors:FF00FF'] = 'Ciklama crvena';
$string['colors:FF6600'] = 'Narandžasta';
$string['colors:FF9900'] = 'Tamnožuta (boja ćilibara)';
$string['colors:FF99CC'] = 'Ružičasta';
$string['colors:FFCC00'] = 'Zlatna';
$string['colors:FFCC99'] = 'Breskvasta';
$string['colors:FFFF00'] = 'Žuta';
$string['colors:FFFF99'] = 'Svetložuta';
$string['colors:FFFFFF'] = 'Bela';
$string['common:apply'] = 'Primeni';
$string['common:browse'] = 'Pretraži';
$string['common:cancel'] = 'Otkaži';
$string['common:class_name'] = 'Klasa';
$string['common:clipboard_msg'] = 'Komande Kopiraj/Iseci/Nalepi nisu dostupne u veb čitačima Mozilla i Firefox.. Da li želite više informacija o ovome?';
$string['common:clipboard_no_support'] = 'Trenutno nije podržano od strane vašeg Web čitača. Umesto toga koristite prečice sa tastature.';
$string['common:close'] = 'Zatvori';
$string['common:edit_confirm'] = 'Da li želite da koristite WYSIWYG režim rada za ovo tekstualno polje?';
$string['common:insert'] = 'Umetni';
$string['common:invalid_data'] = 'Greška: Unete su neispravne vrednosti, označene su crveno';
$string['common:invalid_data_min'] = '{#field} mora biti broj veći od {#min}';
$string['common:invalid_data_number'] = '{#field} mora biti broj';
$string['common:invalid_data_size'] = '{#field} mora biti broj ili procenat';
$string['common:more_colors'] = 'Više boja...';
$string['common:not_set'] = '-- Nije podešeno --';
$string['common:popup_blocked'] = 'Oprostite, ali primetili smo da Vaš Web čitač blokira iskačući prozor koji pruža funkcionalnost aplikacije. Moraćete da isključite blokiranje iskačućih prozora na ovom sajtu kako biste mogli u potpunosti da koristite ovu alatku.';
$string['common:update'] = 'Osveži';
$string['common:value'] = '(vrednost)';
$string['contextmenu:align'] = 'Poravnanje';
$string['contextmenu:center'] = 'Centar';
$string['contextmenu:full'] = 'Pun';
$string['contextmenu:left'] = 'Levo';
$string['contextmenu:right'] = 'Desno';
$string['customconfig'] = 'Korisnička podešavanja';
$string['customconfig_desc'] = 'Napredno prilagođeno podešavanje TinyMCE editora u JSON formatu, na primer: {"option1" : "value2", "option2" : "value2"}. Sve, ovde navedene, opcije će zameniti standardna podešavanja kao i podešavanja za dodatke.';
$string['customtoolbar'] = 'Traka sa alatkama editora';
$string['customtoolbar_desc'] = 'Svaka linija sadrži spisak dugmadi, razdvojenih zarezima. Koristite "prelom" kao separator grupe dugmadi. Prazne linije se ignorišu. Pogledajte <a href="{$a}" target="_blank">{$a}</a> za spisak standardnih TinyMCE dugmadi.<br />Prvi red će uvek biti prikazan, dok se vidljivost drugog i narednih redova može menjati.';
$string['directionality:ltr_desc'] = 'Smer sleva nadesno';
$string['directionality:rtl_desc'] = 'Smer zdesna nalevo';
$string['emotions:delta_height'] = '0';
$string['emotions:delta_width'] = '0';
$string['emotions_dlg:cool'] = 'Cool';
$string['emotions_dlg:cry'] = 'Plač';
$string['emotions_dlg:desc'] = 'Emotikoni';
$string['emotions_dlg:embarassed'] = 'Postiđen';
$string['emotions_dlg:foot_in_mouth'] = 'Izletelo mu';
$string['emotions_dlg:frown'] = 'Mrštenje';
$string['emotions_dlg:innocent'] = 'Nevinašce';
$string['emotions_dlg:kiss'] = 'Poljubac';
$string['emotions_dlg:laughing'] = 'Smejanje';
$string['emotions_dlg:money_mouth'] = 'Pohlepan';
$string['emotions_dlg:sealed'] = 'Ćuti kao zaliven';
$string['emotions_dlg:smile'] = 'Osmeh';
$string['emotions_dlg:surprised'] = 'Iznenađenje';
$string['emotions_dlg:title'] = 'Umetni emotikon';
$string['emotions_dlg:tongue_out'] = 'Isplažen jezik';
$string['emotions_dlg:undecided'] = 'Neodlučan';
$string['emotions_dlg:usage'] = 'Za navigaciju koristite levu i desnu strelicu.';
$string['emotions_dlg:wink'] = 'Namigivanje';
$string['emotions_dlg:yell'] = 'Vika';
$string['emotions:emotions_desc'] = 'Emotikoni';
$string['fontselectlist'] = 'Spisak dostupnih fontova';
$string['fullpage:delta_height'] = '0';
$string['fullpage:delta_width'] = '0';
$string['fullpage:desc'] = 'Svojstva dokumenta';
$string['fullpage_dlg:active_color'] = 'Aktivna boja';
$string['fullpage_dlg:add'] = 'Dodaj novi element';
$string['fullpage_dlg:add_base'] = 'Osnovni element';
$string['fullpage_dlg:add_comment'] = 'Komentar';
$string['fullpage_dlg:add_link'] = 'Link element';
$string['fullpage_dlg:add_meta'] = 'Meta element';
$string['fullpage_dlg:add_script'] = 'Skript element';
$string['fullpage_dlg:add_style'] = 'Stil element';
$string['fullpage_dlg:add_title'] = 'Element naslova';
$string['fullpage_dlg:advanced_props'] = 'Napredno';
$string['fullpage_dlg:advanced_tab'] = 'Napredno';
$string['fullpage_dlg:appearance_bgprops'] = 'Svojstva pozadine';
$string['fullpage_dlg:appearance_linkprops'] = 'Boje veze';
$string['fullpage_dlg:appearance_marginprops'] = 'Margine';
$string['fullpage_dlg:appearance_style'] = 'Opis i svojstva stilova';
$string['fullpage_dlg:appearance_tab'] = 'Izgled';
$string['fullpage_dlg:appearance_textprops'] = 'Svojstva teksta';
$string['fullpage_dlg:author'] = 'Autor';
$string['fullpage_dlg:base_element'] = 'Osnovni element';
$string['fullpage_dlg:bgcolor'] = 'Boja pozadine';
$string['fullpage_dlg:bgimage'] = 'Pozadinska slika';
$string['fullpage_dlg:bottom_margin'] = 'Donja margina';
$string['fullpage_dlg:charset'] = 'Šema kodiranja';
$string['fullpage_dlg:comment_element'] = 'Komentar';
$string['fullpage_dlg:content'] = 'Sadržaj';
$string['fullpage_dlg:copyright'] = 'Autorsko pravo';
$string['fullpage_dlg:defer'] = 'Odloži';
$string['fullpage_dlg:doctypes'] = 'Tip dokumenta';
$string['fullpage_dlg:encoding'] = 'Kodni raspored';
$string['fullpage_dlg:fontface'] = 'Porodica fonta';
$string['fullpage_dlg:font_face'] = 'Izgled fonta';
$string['fullpage_dlg:fontsize'] = 'Veličina fonta';
$string['fullpage_dlg:font_size'] = 'Veličina fonta';
$string['fullpage_dlg:general_props'] = 'Opšte';
$string['fullpage_dlg:head_elements'] = 'Elementi zaglavlja';
$string['fullpage_dlg:hover_color'] = 'Boja lebdećeg linka';
$string['fullpage_dlg:href'] = 'HREF';
$string['fullpage_dlg:hreflang'] = 'HREF lang';
$string['fullpage_dlg:info'] = 'Informacija';
$string['fullpage_dlg:langcode'] = 'Jezički kôd';
$string['fullpage_dlg:langdir'] = 'Smer jezika';
$string['fullpage_dlg:langprops'] = 'Jezik i kodni raspored';
$string['fullpage_dlg:language'] = 'Jezik';
$string['fullpage_dlg:left_margin'] = 'Leva margina';
$string['fullpage_dlg:link_color'] = 'Boja veze';
$string['fullpage_dlg:link_element'] = 'Link element';
$string['fullpage_dlg:ltr'] = 'Sleva nadesno';
$string['fullpage_dlg:media'] = 'Medij';
$string['fullpage_dlg:meta_description'] = 'Opis';
$string['fullpage_dlg:meta_element'] = 'Meta element';
$string['fullpage_dlg:meta_index_follow'] = 'Indeksiraj i sledi veze';
$string['fullpage_dlg:meta_index_nofollow'] = 'Indeksiraj i nemoj slediti veze';
$string['fullpage_dlg:meta_keywords'] = 'Ključne reči';
$string['fullpage_dlg:meta_noindex_follow'] = 'Ne indekisraj ali sledi veze';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Ne indeksira i nemoj slediti veze';
$string['fullpage_dlg:meta_props'] = 'Meta informacije';
$string['fullpage_dlg:meta_robots'] = 'Roboti';
$string['fullpage_dlg:meta_tab'] = 'Opšte';
$string['fullpage_dlg:meta_title'] = 'Naslov';
$string['fullpage_dlg:movedown'] = 'Premesti izabrani element dole';
$string['fullpage_dlg:moveup'] = 'Premesti izabrani element gore';
$string['fullpage_dlg:name'] = 'Ime';
$string['fullpage_dlg:properties'] = 'Svojstva';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'Ukloni izabrani element';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'Desna margina';
$string['fullpage_dlg:rtl'] = 'Zdesna nalevo';
$string['fullpage_dlg:script_element'] = 'Element skript';
$string['fullpage_dlg:src'] = 'Izvor';
$string['fullpage_dlg:style'] = 'Stil';
$string['fullpage_dlg:style_element'] = 'Element stil';
$string['fullpage_dlg:stylesheet'] = 'Opis stilova';
$string['fullpage_dlg:target'] = 'Cilj';
$string['fullpage_dlg:textcolor'] = 'Boja';
$string['fullpage_dlg:text_color'] = 'Boja teksta';
$string['fullpage_dlg:title'] = 'Svojstva dokumenta';
$string['fullpage_dlg:title_element'] = 'Element naslov';
$string['fullpage_dlg:top_margin'] = 'Gornja margina';
$string['fullpage_dlg:type'] = 'Tip';
$string['fullpage_dlg:value'] = 'Vrednost';
$string['fullpage_dlg:visited_color'] = 'Boja posećenog linka';
$string['fullpage_dlg:xml_pi'] = 'XML dekleracija';
$string['fullscreen:desc'] = 'Uključi/isključi prikaz preko celog ekrana';
$string['iespell:download'] = 'ieSpell nije detektovan. Da li želite da ga sada instalirate?';
$string['iespell:iespell_desc'] = 'Proveri pravopis';
$string['insertdatetime:date_fmt'] = '%Y-%m-%d';
$string['insertdatetime:day_long'] = 'Nedelja,Ponedeljak,Utorak,Sreda,Četvrtak,Petak,Subota,Nedelja';
$string['insertdatetime:day_short'] = 'Ned,Pon,Uto,Sre,Čet,Pet,Sub,Ned';
$string['insertdatetime:insertdate_desc'] = 'Umetni datum';
$string['insertdatetime:inserttime_desc'] = 'Umetni vreme';
$string['insertdatetime:months_long'] = 'januar,februar,mart,april,maj,jun,jul,avgust,septembar,oktobar,novembar,decembar';
$string['insertdatetime:months_short'] = 'Jan,Feb,Mar,Apr,Maj,Jun,Jul,Avg,Sepr,Okt,Nov,Dec';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Uključi/isključi apsolutno pozicioniranje';
$string['layer:backward_desc'] = 'Idi unazad';
$string['layer:content'] = 'Novi sloj...';
$string['layer:forward_desc'] = 'Idi unapred';
$string['layer:insertlayer_desc'] = 'Umetni novi sloj';
$string['media:delta_height'] = '0';
$string['media:delta_width'] = '0';
$string['media:desc'] = 'Umetni/uredi ugrađenu multimediju';
$string['media_dlg:advanced'] = 'Napredno';
$string['media_dlg:align'] = 'Poravnaj';
$string['media_dlg:align_bottom'] = 'Dole';
$string['media_dlg:align_bottom_left'] = 'Dole levo';
$string['media_dlg:align_bottom_right'] = 'Dole desno';
$string['media_dlg:align_center'] = 'Sredina';
$string['media_dlg:align_left'] = 'Levo';
$string['media_dlg:align_right'] = 'Desno';
$string['media_dlg:align_top'] = 'Gore';
$string['media_dlg:align_top_left'] = 'Gore levo';
$string['media_dlg:align_top_right'] = 'Gore desno';
$string['media_dlg:altsource1'] = 'Alternativni izvor 1';
$string['media_dlg:altsource2'] = 'Alternativni izvor 2';
$string['media_dlg:audio'] = 'HTML5 zvuk';
$string['media_dlg:autogotourl'] = 'Automatski prelazak na URL adresu';
$string['media_dlg:autohref'] = 'Auto HREF';
$string['media_dlg:autostart'] = 'Automatsko pokretanje';
$string['media_dlg:balance'] = 'Balans';
$string['media_dlg:base'] = 'Osnova';
$string['media_dlg:baseurl'] = 'Osnovni URL';
$string['media_dlg:bgcolor'] = 'Pozadina';
$string['media_dlg:cache'] = 'Keš';
$string['media_dlg:captioningid'] = 'ID naslova';
$string['media_dlg:center'] = 'Sredina';
$string['media_dlg:class_name'] = 'Klasa';
$string['media_dlg:console'] = 'Konzola';
$string['media_dlg:constrain_proportions'] = 'Zadrži proporcije';
$string['media_dlg:controller'] = 'Kontrolor';
$string['media_dlg:controls'] = 'Kontrole';
$string['media_dlg:correction'] = 'Bez korekcije';
$string['media_dlg:currentmarker'] = 'Trenutni obeleživač';
$string['media_dlg:currentposition'] = 'Trenutna pozicija';
$string['media_dlg:defaultframe'] = 'Podrazumevnai okvir';
$string['media_dlg:embeddedaudio'] = 'Ugrađeni zvuk';
$string['media_dlg:embedded_audio_options'] = 'Opcije za ugrađeni zvuk';
$string['media_dlg:enabled'] = 'Omogućeno';
$string['media_dlg:enablejavascript'] = 'Omogući JavaScript';
$string['media_dlg:endtime'] = 'Vreme završetka';
$string['media_dlg:file'] = 'Datoteka/URL';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Opcije za Fleš';
$string['media_dlg:flashvars'] = '.Flash promenljive';
$string['media_dlg:fullscreen'] = 'Prikaz preko celog ekrana';
$string['media_dlg:general'] = 'Opšte';
$string['media_dlg:hidden'] = 'Skriveno';
$string['media_dlg:href'] = 'HREF';
$string['media_dlg:hspace'] = 'Horizontalni razmak';
$string['media_dlg:html5_audio_options'] = 'Opcije zvuka';
$string['media_dlg:html5_video_options'] = 'HTML5 video opcije';
$string['media_dlg:id'] = 'ID';
$string['media_dlg:iframe'] = 'Iframe';
$string['media_dlg:imagestatus'] = 'Status slike';
$string['media_dlg:invokeurls'] = 'Učitaj URL-ove';
$string['media_dlg:kioskmode'] = 'Kiosk režim';
$string['media_dlg:list'] = 'Lista';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Petlja';
$string['media_dlg:maintainaspect'] = 'Sačuvaj odnos širine i visine';
$string['media_dlg:menu'] = 'Prikaži meni';
$string['media_dlg:mute'] = 'Isključi zvuk';
$string['media_dlg:name'] = 'Naziv';
$string['media_dlg:nojava'] = 'Bez Java apleta';
$string['media_dlg:numloop'] = 'Broj petlji';
$string['media_dlg:play'] = 'Automatska reprodukcija';
$string['media_dlg:playcount'] = 'Broj ponavljanja';
$string['media_dlg:playeveryframe'] = 'Prikaži svaki kadar';
$string['media_dlg:poster'] = 'Poster';
$string['media_dlg:prefetch'] = 'Prethodno preuzimanje';
$string['media_dlg:preload'] = 'Prethodno učitavanje';
$string['media_dlg:preload_auto'] = 'Neka odluči veb čitač korisnika';
$string['media_dlg:preload_metadata'] = 'Prethodno učitavanje video metapodataka';
$string['media_dlg:preload_none'] = 'Bez prethodnog učitavanja';
$string['media_dlg:preview'] = 'Prikaz';
$string['media_dlg:progress'] = 'Napredak';
$string['media_dlg:qt_options'] = 'Quicktime opcije';
$string['media_dlg:qtsrc'] = 'QT izvor';
$string['media_dlg:qtsrcchokespeed'] = 'Brzina učitavanja';
$string['media_dlg:qt_stream_warn'] = 'RTSP izvore za reprodukovanje u realnom vremenu (striming)  treba dodati u QT polje izvora u okviru kartice \'Napredno\'.
Takođe je potrebno da dodate i nestrimovanu verziju u polje izvora.';
$string['media_dlg:quality'] = 'Kvalitet';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Prosečna brzina';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Opcije za Real Media plejer';
$string['media_dlg:salign'] = 'SAlign';
$string['media_dlg:scale'] = 'Skala';
$string['media_dlg:scriptcallbacks'] = 'Skripte povratnog poziva';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Opdžije za Shockwave';
$string['media_dlg:shuffle'] = 'Izmešaj';
$string['media_dlg:size'] = 'Dimenzije';
$string['media_dlg:sound'] = 'Zvuk';
$string['media_dlg:source'] = 'Izvor';
$string['media_dlg:starttime'] = 'Vreme početka';
$string['media_dlg:stretchtofit'] = 'Razvuci da se uklopi';
$string['media_dlg:swstretchhalign'] = 'Razvuci horizontalno poravnanje';
$string['media_dlg:swstretchstyle'] = 'Način razvlačenja';
$string['media_dlg:swstretchvalign'] = 'Razvuci vertikalno poravnanje';
$string['media_dlg:target'] = 'Cilj';
$string['media_dlg:targetcache'] = 'Odabrani keš';
$string['media_dlg:title'] = 'Umetni/uredi ugrađenu multimediju';
$string['media_dlg:type'] = 'Tip';
$string['media_dlg:uimode'] = 'Režim korisničkog interfejsa';
$string['media_dlg:video'] = 'HTML5 video';
$string['media_dlg:volume'] = 'Jačina zvuka';
$string['media_dlg:vspace'] = 'Vertikalni razmak';
$string['media_dlg:windowlessvideo'] = 'Video bez prozora';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = 'WRežim';
$string['media_dlg:wmp_options'] = 'Opcije za Windows Media plejer';
$string['media:edit'] = 'Uredi ugrađenu multimediju';
$string['nonbreaking:nonbreaking_desc'] = 'Umetni znak nelomljivog razmaka';
$string['pagebreak:desc'] = 'Umetni prelom stranice za štampanje';
$string['paste_dlg:text_linebreaks'] = 'Zadrži prelome redova';
$string['paste_dlg:text_title'] = 'Upotrebite kombinaciju tastera CTRL+V da biste nalepili tekst u prozor.';
$string['paste_dlg:word_title'] = 'Upotrebite kombinaciju tastera CTRL+V da biste nalepili tekst u prozor.';
$string['paste:paste_text_desc'] = 'Nalepi kao običan tekst';
$string['paste:paste_word_desc'] = 'Prenesi iz Worda';
$string['paste:plaintext_mode'] = 'Komanda \'Nalepi\' je trenutno u režimu običnog teksta. Kliknite ponovo kako biste se vratili u normalni režim. Nakon što ubacite kopirani tekst bićete vraćeni u normalan režim.';
$string['paste:plaintext_mode_stick'] = 'Komanda \'Nalepi\' je trenutno u režimu običnog teksta. Kliknite ponovo kako biste se vratili u normalni režim.';
$string['paste:selectall_desc'] = 'Izaberi sve';
$string['pluginname'] = 'TinyMCE HTML editor';
$string['preview:preview_desc'] = 'Pregled';
$string['print:print_desc'] = 'Štampaj';
$string['privacy:metadata'] = 'Dodatak za TinyMCE HTML editor ne čuva nikakve lične podatke.';
$string['save:cancel_desc'] = 'Otkaži sve promene';
$string['save:save_desc'] = 'Sačuvaj';
$string['searchreplace:delta_height'] = '0';
$string['searchreplace:delta_width'] = '0';
$string['searchreplace_dlg:allreplaced'] = 'Sva pojavljivanja traženog teksta su zamenjena';
$string['searchreplace_dlg:direction'] = 'Smer';
$string['searchreplace_dlg:down'] = 'Dole';
$string['searchreplace_dlg:findnext'] = 'Pronađi sledeće';
$string['searchreplace_dlg:findwhat'] = 'Pronađi izraz';
$string['searchreplace_dlg:mcase'] = 'Pazi na VELIKA i mala slova';
$string['searchreplace_dlg:notfound'] = 'Pretraživanje je završeno. Traženi izraz nije mogao biti pronađen.';
$string['searchreplace_dlg:replace'] = 'Zameni';
$string['searchreplace_dlg:replaceall'] = 'Zameni sve';
$string['searchreplace_dlg:replace_title'] = 'Pronađi/zameni';
$string['searchreplace_dlg:replacewith'] = 'Zameni sa';
$string['searchreplace_dlg:searchnext_desc'] = 'Pronađi ponovo';
$string['searchreplace_dlg:search_title'] = 'Pronađi';
$string['searchreplace_dlg:up'] = 'Gore';
$string['searchreplace:replace_desc'] = 'Pronađi/zameni';
$string['searchreplace:search_desc'] = 'Pronađi';
$string['settings'] = 'Opšta podešavanja';
$string['simple:bold_desc'] = 'Podebljano (Ctrl+B)';
$string['simple:bullist_desc'] = 'Umetni/ukloni neuređenu listu';
$string['simple:cleanup_desc'] = 'Očisti kôd';
$string['simple:italic_desc'] = 'Kurziv (Ctrl+I)';
$string['simple:numlist_desc'] = 'Umetni/ukloni uređenu listu';
$string['simple:redo_desc'] = 'Ponovi poslelju akciju (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Precrtano';
$string['simple:underline_desc'] = 'Podvučeno (Ctrl+U)';
$string['simple:undo_desc'] = 'Poništi poslednju akciju (Ctrl+Z)';
$string['spellchecker:desc'] = 'Uključi/Isključi proveru pravopisa';
$string['spellchecker:ignore_word'] = 'Ignoriši reč';
$string['spellchecker:ignore_words'] = 'Ignoriši sve';
$string['spellchecker:langs'] = 'Jezici';
$string['spellchecker:learn_word'] = 'Upamti novu reč';
$string['spellchecker:menu'] = 'Podešavanje provere pravopisa';
$string['spellchecker:no_mpell'] = 'Nema pravopisnih grešaka';
$string['spellchecker:no_sug'] = 'Nema predloga';
$string['spellchecker:sug'] = 'Sugestije';
$string['spellchecker:wait'] = 'Molimo sačekajte...';
$string['style:delta_height'] = '0';
$string['style:delta_width'] = '0';
$string['style:desc'] = 'Uredi CSS stil';
$string['style_dlg:apply'] = 'Primeni';
$string['style_dlg:background'] = 'Pozadina';
$string['style_dlg:background_attachment'] = 'Prilog';
$string['style_dlg:background_color'] = 'Boja pozadine';
$string['style_dlg:background_hpos'] = 'Horizontalni položaj';
$string['style_dlg:background_image'] = 'Slika pozadine';
$string['style_dlg:background_repeat'] = 'Ponovi';
$string['style_dlg:background_tab'] = 'Pozadina';
$string['style_dlg:background_vpos'] = 'Vertikalni položaj';
$string['style_dlg:block'] = 'Blok';
$string['style_dlg:block_display'] = 'Prikaži';
$string['style_dlg:block_letterspacing'] = 'Razmak između slova';
$string['style_dlg:block_tab'] = 'Blok';
$string['style_dlg:block_text_align'] = 'Poravnanje teksta';
$string['style_dlg:block_text_indent'] = 'Uvlačenje teksta';
$string['style_dlg:block_vertical_alignment'] = 'Vertikalno poravnanje';
$string['style_dlg:block_whitespace'] = 'Belina';
$string['style_dlg:block_wordspacing'] = 'Razmak između reči';
$string['style_dlg:border'] = 'Ivica';
$string['style_dlg:border_tab'] = 'Ivica';
$string['style_dlg:bottom'] = 'Dole';
$string['style_dlg:box'] = 'Boks';
$string['style_dlg:box_clear'] = 'Očisti';
$string['style_dlg:box_float'] = 'Realan broj';
$string['style_dlg:box_height'] = 'Visina';
$string['style_dlg:box_tab'] = 'Boks';
$string['style_dlg:box_width'] = 'Širina';
$string['style_dlg:bullet_image'] = 'Slika oznake za nabrajanje';
$string['style_dlg:clip'] = 'Klip';
$string['style_dlg:color'] = 'Boja';
$string['style_dlg:height'] = 'Visina';
$string['style_dlg:left'] = 'Levo';
$string['style_dlg:list'] = 'Lista';
$string['style_dlg:list_tab'] = 'Lista';
$string['style_dlg:list_type'] = 'Tip';
$string['style_dlg:margin'] = 'Margina';
$string['style_dlg:overflow'] = 'Prekoračenje';
$string['style_dlg:padding'] = 'Udaljenost od ivice';
$string['style_dlg:placement'] = 'Postavljanje';
$string['style_dlg:position'] = 'Poѕicija';
$string['style_dlg:positioning_tab'] = 'Poѕicioniranje';
$string['style_dlg:positioning_type'] = 'Tip';
$string['style_dlg:right'] = 'Desno';
$string['style_dlg:same'] = 'Za sve isto';
$string['style_dlg:style'] = 'Stil';
$string['style_dlg:text'] = 'Teksт';
$string['style_dlg:text_blink'] = 'Trepće';
$string['style_dlg:text_case'] = 'VELIKA i mala slova';
$string['style_dlg:text_color'] = 'Boja';
$string['style_dlg:text_decoration'] = 'Dekoracija';
$string['style_dlg:text_font'] = 'Font';
$string['style_dlg:text_lineheight'] = 'Visina linije';
$string['style_dlg:text_none'] = 'Ništa';
$string['style_dlg:text_overline'] = 'Nadvučeno';
$string['style_dlg:text_props'] = 'Tekst';
$string['style_dlg:text_size'] = 'Veličina';
$string['style_dlg:text_striketrough'] = 'Precrtano';
$string['style_dlg:text_style'] = 'Stil';
$string['style_dlg:text_tab'] = 'Tekst';
$string['style_dlg:text_underline'] = 'Podvučeno';
$string['style_dlg:text_variant'] = 'Varijanta';
$string['style_dlg:text_weight'] = 'Debljina';
$string['style_dlg:title'] = 'Uredi CSS stil';
$string['style_dlg:toggle_insert_span'] = 'Umetni oznaku span za izabrani sadržaj';
$string['style_dlg:top'] = 'Gore';
$string['style_dlg:visibility'] = 'Vidljivost';
$string['style_dlg:width'] = 'Širina';
$string['style_dlg:zindex'] = 'Z-indeks';
$string['subplugintype_tinymce'] = 'Dodatak';
$string['subplugintype_tinymce_plural'] = 'Dodaci';
$string['table:cell'] = 'Ćelija';
$string['table:cell_desc'] = 'Svojstva ćelije tabele';
$string['table:cellprops_delta_height'] = '0';
$string['table:cellprops_delta_width'] = '0';
$string['table:col'] = 'Kolona';
$string['table:col_after_desc'] = 'Umetni kolonu posle';
$string['table:col_before_desc'] = 'Umetni kolonu pre';
$string['table:copy_row_desc'] = 'Kopiraj red';
$string['table:cut_row_desc'] = 'Iseci red';
$string['table:del'] = 'Obriši tabelu';
$string['table:delete_col_desc'] = 'Obriši kolonu';
$string['table:delete_row_desc'] = 'Obriši red';
$string['table:desc'] = 'Umetni/uredi tabelu';
$string['table_dlg:advanced_props'] = 'Napredna svojstva';
$string['table_dlg:advanced_tab'] = 'Napredno';
$string['table_dlg:align'] = 'Poravnanje';
$string['table_dlg:align_bottom'] = 'Dole';
$string['table_dlg:align_default'] = 'Podrazumevano';
$string['table_dlg:align_left'] = 'Levo';
$string['table_dlg:align_middle'] = 'Sredina';
$string['table_dlg:align_right'] = 'Desno';
$string['table_dlg:align_top'] = 'Gore';
$string['table_dlg:bgcolor'] = 'Boja pozadine';
$string['table_dlg:bgimage'] = 'Slika pozadine';
$string['table_dlg:border'] = 'Ivica';
$string['table_dlg:bordercolor'] = 'Boja ivice';
$string['table_dlg:caption'] = 'Naslov tabele';
$string['table_dlg:cell_all'] = 'Ažuriraj sve ćelije u tabeli';
$string['table_dlg:cell_cell'] = 'Ažuriraj tekuću ćeliju';
$string['table_dlg:cell_col'] = 'Ažuriraj sve ćelije u koloni';
$string['table_dlg:cell_limit'] = 'Premašili ste maksimalan broj ćeija {$cells}.';
$string['table_dlg:cellpadding'] = 'Razmak između sadržaja i ivica ćelije';
$string['table_dlg:cell_row'] = 'Ažuriraj sve ćelije u redu';
$string['table_dlg:cellspacing'] = 'Razmak između ćelija';
$string['table_dlg:cell_title'] = 'Svojstva ćelije tabele';
$string['table_dlg:cell_type'] = 'Tip ćelije';
$string['table_dlg:colgroup'] = 'Grupa kolona';
$string['table_dlg:col_limit'] = 'Premašili ste maksimalan broj kolona {$cols}.';
$string['table_dlg:cols'] = 'Kolone';
$string['table_dlg:frame'] = 'Okvir';
$string['table_dlg:frame_all'] = 'sve';
$string['table_dlg:frame_cols'] = 'kolone';
$string['table_dlg:frame_groups'] = 'grupe';
$string['table_dlg:frame_none'] = 'ništa';
$string['table_dlg:frame_rows'] = 'redovi';
$string['table_dlg:general_props'] = 'Opšta svojstva';
$string['table_dlg:general_tab'] = 'Opšte';
$string['table_dlg:height'] = 'Visina';
$string['table_dlg:id'] = 'ID';
$string['table_dlg:langcode'] = 'Jezički kôd';
$string['table_dlg:langdir'] = 'Smer jezika';
$string['table_dlg:ltr'] = 'Sleva nadesno';
$string['table_dlg:merge_cells_title'] = 'Spoji ćelije tabele';
$string['table_dlg:mime'] = 'Ciljni MIME tip';
$string['table_dlg:missing_scope'] = 'Da li ste sigurni da želite da nastavite bez određivanja opsega naslovne ćelije ove tabele? Bez toga nekim korisnicima sa invaliditetom može biti teško da razumeju sadržaj ili podatke prikazane u tabeli.';
$string['table_dlg:row_all'] = 'Ažuriraj sve redove u tabeli';
$string['table_dlg:row_even'] = 'Ažuriraj parne redove u tabeli';
$string['table_dlg:rowgroup'] = 'Grupa redova';
$string['table_dlg:row_limit'] = 'Premašili ste maksimalan broj redova {$rows}.';
$string['table_dlg:row_odd'] = 'Ažuriraj neparne redove u tabeli';
$string['table_dlg:row_row'] = 'Ažuriraj tekući red';
$string['table_dlg:rows'] = 'Redovi';
$string['table_dlg:row_title'] = 'Svojstva reda tabele';
$string['table_dlg:rowtype'] = 'Vrsta reda';
$string['table_dlg:rtl'] = 'Zdesna nalevo';
$string['table_dlg:rules'] = 'Pravila';
$string['table_dlg:rules_above'] = 'iznad';
$string['table_dlg:rules_below'] = 'ispod';
$string['table_dlg:rules_border'] = 'ivica';
$string['table_dlg:rules_box'] = 'boks';
$string['table_dlg:rules_hsides'] = 'gore i dole';
$string['table_dlg:rules_lhs'] = 'lhs';
$string['table_dlg:rules_rhs'] = 'rhs';
$string['table_dlg:rules_void'] = 'ni sa jedne strane';
$string['table_dlg:rules_vsides'] = 'levo i desno';
$string['table_dlg:scope'] = 'Opseg';
$string['table_dlg:style'] = 'Stil';
$string['table_dlg:summary'] = 'Kratak pregled';
$string['table_dlg:tbody'] = 'Telo';
$string['table_dlg:td'] = 'Podatak';
$string['table_dlg:tfoot'] = 'Podnožje';
$string['table_dlg:th'] = 'Zaglavlje';
$string['table_dlg:thead'] = 'Zaglavlje';
$string['table_dlg:title'] = 'Umetni/uredi tabelu';
$string['table_dlg:valign'] = 'Vertikalno poravnanje';
$string['table_dlg:width'] = 'Širina';
$string['table:merge_cells_delta_height'] = '0';
$string['table:merge_cells_delta_width'] = '0';
$string['table:merge_cells_desc'] = 'Spoji ćelije tabele';
$string['table:paste_row_after_desc'] = 'Nalepi red posle';
$string['table:paste_row_before_desc'] = 'Nalepi red posle';
$string['table:props_desc'] = 'Svojstva tabele';
$string['table:row'] = 'Red';
$string['table:row_after_desc'] = 'Umetni red posle';
$string['table:row_before_desc'] = 'Umetni red pre';
$string['table:row_desc'] = 'Svojstva reda';
$string['table:rowprops_delta_height'] = '0';
$string['table:rowprops_delta_width'] = '0';
$string['table:split_cells_desc'] = 'Razdvoji spojene ćelije tabele';
$string['table:table_delta_height'] = '0';
$string['table:table_delta_width'] = '0';
$string['template:desc'] = 'Umetni predefinisani sadržaj šablona';
$string['template_dlg:cdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:day_long'] = 'Nedelja,Ponedeljak,Utorak,Sreda,Četvrtak,Petak,Subota,Nedelja';
$string['template_dlg:day_short'] = 'Ned,Pon,Uto,Sre,Čet,Pet,Sub,Ned';
$string['template_dlg:desc'] = 'Umetni predefinisani sadržaj šablona';
$string['template_dlg:desc_label'] = 'Opis';
$string['template_dlg:label'] = 'Šablon';
$string['template_dlg:mdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:months_long'] = 'januar,februar,mart,april,maj,jun,jul,avgust,septembar,oktobar,novembar,decembar';
$string['template_dlg:months_short'] = 'Jan,Feb,Ma,Apr,Maj,Jun,Jul,Avg,Sep,Okt,Nov,Dec';
$string['template_dlg:preview'] = 'Pregled';
$string['template_dlg:select'] = 'Izaberi šablon';
$string['template_dlg:title'] = 'Šabloni';
$string['template_dlg:warning'] = 'Upozorenj: Ažuriranje jednog šablona sa drugim može dovesti do gubitka ppodataka.';
$string['visualblocks:desc'] = 'Sakrij/prikaži elemente bloka';
$string['visualchars:desc'] = 'Prikaži/sakrij vizuelne kontrolne znakove';
$string['wordcount:words'] = 'Reči:';
$string['xhtmlxtras:abbr_delta_height'] = '0';
$string['xhtmlxtras:abbr_delta_width'] = '0';
$string['xhtmlxtras:abbr_desc'] = 'Skraćenica';
$string['xhtmlxtras:acronym_delta_height'] = '0';
$string['xhtmlxtras:acronym_delta_width'] = '0';
$string['xhtmlxtras:acronym_desc'] = 'Akronim';
$string['xhtmlxtras:attribs_delta_height'] = '0';
$string['xhtmlxtras:attribs_delta_width'] = '0';
$string['xhtmlxtras:attribs_desc'] = 'Umetni/uredi atribute';
$string['xhtmlxtras:cite_delta_height'] = '0';
$string['xhtmlxtras:cite_delta_width'] = '0';
$string['xhtmlxtras:cite_desc'] = 'Citat';
$string['xhtmlxtras:del_delta_height'] = '0';
$string['xhtmlxtras:del_delta_width'] = '0';
$string['xhtmlxtras:del_desc'] = 'Brisanje';
$string['xhtmlxtras_dlg:attribs_title'] = 'Umetni /uredi atribute';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Atributi';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Atributi';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Događaji';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'Pristupni ključ';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Citat';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Klasa';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Datum/vreme';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Jezik';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Smer teksta';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Stil';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'TabIndex';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Baslov';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'Sleva nadesno';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'Zdesna nalevo';
$string['xhtmlxtras_dlg:events_tab'] = 'Događaji';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Atributi elementa';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Događaji elementa';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Opta podešavanja';
$string['xhtmlxtras_dlg:general_tab'] = 'Opšte';
$string['xhtmlxtras_dlg:insert_date'] = 'Umetni tekući datum/vreme';
$string['xhtmlxtras_dlg:option_ltr'] = 'Sleva nadesno';
$string['xhtmlxtras_dlg:option_rtl'] = 'Zdesna nalevo';
$string['xhtmlxtras_dlg:remove'] = 'Ukloni';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Element skraćenica';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Element akronim';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Element citat';
$string['xhtmlxtras_dlg:title_del_element'] = 'Element za brisanje';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Element za umetanje';
$string['xhtmlxtras:ins_delta_height'] = '0';
$string['xhtmlxtras:ins_delta_width'] = '0';
$string['xhtmlxtras:ins_desc'] = 'Umetanje';
