<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_fusion', language 'nl', branch 'MOODLE_27_STABLE'
 *
 * @package   theme_fusion
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = '<div class="clearfix">
<div class="theme_screenshot">
<h2>Fusion</h2>
<img src="fusion/pix/screenshot.jpg" />
<h3>Thema discussie forum</h3>
<p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>
<h3>Thema credits</h3>
<p><a href="http://docs.moodle.org/en/Theme_credits">http://docs.moodle.org/en/Theme_credits</a></p>
<h3>Thema documentatie</h3>
<p><a href="http://docs.moodle.org/en/Themes">http://docs.moodle.org/en/Themes</a></p>
<h3>Meld een bug</h3>
<p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
</div>

<div class="theme_description">
<h2>Beschrijving</h2>
<p>Fusion is een thema in twee kolommen, met wisselende breedte, gecodeerd voor Moodle 2.0. Het maakt gebruik van aangepaste menu\'s die op elke pagina boven de titel van de site staan. Het bevat ook een basispagina met instellingen die toelaat om het kleur van de links te veranderen, een tagline toe te voegen boven de naam van de site op de voorpagina, en om tekst toe te voegen aan de footer.</p>
<h2>Parents</h2>
<p>Dit thema bouwt voort op Base en Canvas, twee parent thema\'s die behoren tot de Moodle core. Indien je bepaalde aspecten van dit thema wil aanpassen die verder gaan dan de aangeboden instellingen, dan raden we aan om een nieuw thema aan te maken die dit en het Base thema als parent thema\'s gebruikt. Op die manier zullen alle updates van de parent thema\'s in de core ook hun weg vinden naar jouw nieuwe thema.</p>
<h2>Credits</h2>
<p>Dit ontwerp werd oorspronkelijk gemaakt door Digital Nature (hello@digitalnature.ro) voor het overgedragen werd naar Moodle door Patrick Malley (patrick@newschoollearning.com).
<h2>Licentie</h2>
<p>De licentie van dit thema, en alle andere thema\'s die zijn opgenomen in de Moodle core, vallen onder de <a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>.</p>
 </div>
</div>';
$string['configtitle'] = 'Fusion instellingen';
$string['customcss'] = 'Aangepaste CSS';
$string['customcssdesc'] = 'CSS-regels die je in deze tekstzone toevoegt, zullen op elke pagina effect hebben. Dit maakt het makkelijker om dit thema aan je wensen aan te passen.';
$string['footertext'] = 'Voettekst';
$string['footertextdesc'] = 'Maak een voetnoot of voettekst';
$string['linkcolor'] = 'Linkkleur';
$string['linkcolordesc'] = 'Stelt de linkkleur in voor het thema';
$string['pluginname'] = 'Fusion';
$string['region-side-post'] = 'Rechts';
$string['region-side-pre'] = 'Links';
$string['tagline'] = 'Tag-lijn';
$string['taglinedesc'] = 'Een korte tag-lijn tonen onder de site-naam op de startpagina<br />';
