<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'nl', branch 'MOODLE_26_STABLE'
 *
 * @package   local_moodlemobileapp
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.blog.errorloadentries'] = 'Fout bij het laden van blog-items.';
$string['addon.blog.showonlyyourentries'] = 'Toon enkel eigen items';
$string['addon.calendar.calendarevent'] = 'Kalendergebeurtenis';
$string['addon.calendar.calendarevents'] = 'Kalendergebeurtenissen';
$string['addon.calendar.calendarreminders'] = 'Kalendernotificaties';
$string['addon.calendar.currentmonth'] = 'Deze maand';
$string['addon.calendar.defaultnotificationtime'] = 'Standaard notificatietijd';
$string['addon.calendar.errorloadevent'] = 'Fout bij het laden van de gebeurtenis.';
$string['addon.calendar.errorloadevents'] = 'Fout bij het laden van de gebeurtenissen.';
$string['addon.calendar.noevents'] = 'Er zijn geen gebeurtenissen';
$string['addon.calendar.reminders'] = 'Notificaties';
$string['addon.calendar.setnewreminder'] = 'Nieuwe notificatie instellen';
$string['addon.competency.errornocompetenciesfound'] = 'Geen competenties gevonden';
$string['addon.competency.nocompetencies'] = 'Geen competenties';
$string['addon.coursecompletion.complete'] = 'Voltooi';
$string['addon.coursecompletion.couldnotloadreport'] = 'Kon het voltooiingsrapport van de cursus niet laden. Probeer later opnieuw.';
$string['addon.files.couldnotloadfiles'] = 'De bestandenlijst kon niet geladen worden.';
$string['addon.files.emptyfilelist'] = 'Er zijn geen bestanden te tonen.';
$string['addon.files.erroruploadnotworking'] = 'Jammer genoeg kun je op dit ogenblik geen bestanden uploaden naar de site.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Apparaten configureren';
$string['addon.messages.contactlistempty'] = 'De contactenlijst is leeg';
$string['addon.messages.contactname'] = 'Naam';
$string['addon.messages.deletemessage'] = 'Verwijder bericht';
$string['addon.messages.deletemessageconfirmation'] = 'Weet je zeker dat je dit bericht wil verwijderen? Het zal alleen van je berichtengeschiedenis gewist worden en zichtbaar blijven voor de gebruiker naar wie je het gestuurd hebt.';
$string['addon.messages.errordeletemessage'] = 'Fout bij het verwijderen van het bericht.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Fout bij het ophalen van contacten van de server.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Fout bij het ophalen van discussies van de server.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Fout bij het ophalen van berichten van de server.';
$string['addon.messages.errorwhileretrievingusers'] = 'Fout bij het ophalen van gebruikers van de server';
$string['addon.messages.messagenotsent'] = 'Het bericht is niet verzonden. Probeer het later opnieuw.';
$string['addon.messages.newmessages'] = 'Nieuwe berichten';
$string['addon.messages.nousersfound'] = 'Geen gebruikers gevonden';
$string['addon.messages.showdeletemessages'] = 'Toon verwijderde berichten';
$string['addon.messages.type_blocked'] = 'Geblokkeerd';
$string['addon.messages.type_offline'] = 'Offline';
$string['addon.messages.type_online'] = 'Online';
$string['addon.messages.type_search'] = 'Zoekresultaten';
$string['addon.messages.type_strangers'] = 'Anderen';
$string['addon.messages.useentertosenddescdesktop'] = 'Indien uitgeschakeld kan je Ctrl+enter gebruiken om een bericht te versturen.';
$string['addon.messages.useentertosenddescmac'] = 'Indien uitgeschakeld kan je Cmd+enter gebruiken om een bericht te versturen.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Kon bericht(en) niet verzenden naar conversatie {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Kon bericht(en) niet versturen naar gebruiker {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Accepteer de uploadvoorwaarden.';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Je kunt geen inzending toevoegen of bewerken in de app, omdat we de uploadvoorwaarden niet konden ophalen van de site.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Some beoordelingsmethodes worden nog niet door de app ondersteund en kunnen niet worden aangepast.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Je kunt niet insturen voor beoordeling omdat we de uploadvoorwaarden niet konden ophalen van de site.';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Je kunt geen inzending toesturen of bewerken in de app omdat sommige plugins bewerken nog niet ondersteunen.';
$string['addon.mod_assign.errorshowinginformation'] = 'We kunnen de instuurinformatie niet tonen.';
$string['addon.mod_assign.feedbacknotsupported'] = 'Deze feedback wordt niet ondersteund door de app en daarom is de informatie mogelijk  onvolledig.';
$string['addon.mod_assign.gradenotsynced'] = 'Cijfer niet gesynchroniseerd';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Deelnemers die niets ingestuurd hebben, worden niet getoond.';
$string['addon.mod_assign.submissionnotsupported'] = 'Deze ingestuurde opdracht wordt niet ondersteund door de app en bevat mogelijk niet alle informatie.';
$string['addon.mod_assign.userwithid'] = 'Gebruiker met Id {{id}}';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'Het cijfer van je ingeleverde opdracht is op de site gewijzigd.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'Het door de gebruiker ingestuurde bestand is gewijzigd op de site.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Fout bij het verbinden met de chat.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Fout bij het ophalen van de chatgegevens.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Fout bij het ophalen van de chatgebruikers.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Fout bij het ophalen van de berichten van de server.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Fout tijdens het versturen van het bericht.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Je moet online zijn om berichten te versturen.';
$string['addon.mod_chat.nosessionsfound'] = 'Geen sessies gevonden';
$string['addon.mod_chat.showincompletesessions'] = 'Toon onvolledige sessies';
$string['addon.mod_choice.errorgetchoice'] = 'Fout bij het ophalen van de keuzegegevens.';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% van de gebruikers kozen optie: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Jouw laatste reactie moet gesynchroniseerd worden voor ze mee in de resultaten zit.';
$string['addon.mod_data.edittagsnotsupported'] = 'Sorry, het bewerken van tags wordt niet ondersteund door de app.';
$string['addon.mod_data.errorapproving'] = 'Fout bij het goedkeuren of verwerpen van het nieuwe item.';
$string['addon.mod_data.errordeleting'] = 'Fout bij het verwijderen van het item.';
$string['addon.mod_data.gettinglocation'] = 'Locatie ophalen';
$string['addon.mod_data.locationpermissiondenied'] = 'Toestemming voor toegang tot uw locatie is geweigerd';
$string['addon.mod_data.mylocation'] = 'Mijn locatie';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Sorry, zoeken op tags wordt niet ondersteund door de app.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Feedback met CAPTCHA kan niet offline voltooid worden of wanneer dat niet geconfigureerd is of wanneer de server onbereikbaar is.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Deze feedback is bewaard om later in te sturen.';
$string['addon.mod_folder.emptyfilelist'] = 'Geen bestanden.';
$string['addon.mod_forum.errorgetforum'] = 'Fout bij het ophalen van forumgegevens';
$string['addon.mod_forum.errorgetgroups'] = 'Fout bij het ophalen van groepinstellingen.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Kon geen nieuwe discussie starten in alle groepen';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Er zijn nog geen discussies in dit forum.';
$string['addon.mod_forum.group'] = 'Groep';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} discussies';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} antwoorden';
$string['addon.mod_forum.refreshdiscussions'] = 'Discussie verversen';
$string['addon.mod_forum.refreshposts'] = 'Discussieberichten verversen';
$string['addon.mod_glossary.browsemode'] = 'Blader door items';
$string['addon.mod_glossary.byalphabet'] = 'Alfabetisch';
$string['addon.mod_glossary.byauthor'] = 'Groepeer per auteur';
$string['addon.mod_glossary.bycategory'] = 'Groepeer per categorie';
$string['addon.mod_glossary.bynewestfirst'] = 'Nieuwste eerst';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Onlangs gewijzigd';
$string['addon.mod_glossary.bysearch'] = 'Zoek';
$string['addon.mod_glossary.cannoteditentry'] = 'Kan item niet bewerken';
$string['addon.mod_glossary.entriestobesynced'] = 'Items niet gesynchroniseerd';
$string['addon.mod_glossary.entrypendingapproval'] = 'Dit item wacht op goedkeuring.';
$string['addon.mod_glossary.errorloadingentries'] = 'Fout bij het laden van de items.';
$string['addon.mod_glossary.errorloadingentry'] = 'Fout tijdens het laden van dit item.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Fout tijdens het laden van de woordenlijst.';
$string['addon.mod_glossary.noentriesfound'] = 'Geen items gevonden.';
$string['addon.mod_glossary.searchquery'] = 'Zoekopdracht';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Download H5P-bestand';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Fout bij het ophalen van H5P activiteitsgegevens.';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'Het H5P-pakket is niet gedownload. Je moet het downloaden om het te kunnen gebruiken.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'Het H5P-pakket is gewijzigd sinds de laatste download. Je moet het opnieuw downloaden om het kunnen te gebruiken.';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'Je moet online zijn om het H5P-pakket te kunnen bekijken.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Bekijk poging {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Toon beschrijving';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Deze les bevat een sprong naar een willekeurige inhoudspagina. De les kan niet gestart worden in de app zonder dat die gestart is op het web.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Deze poging kan niet meer nagekeken worden omdat er al een andere poging voltooid is.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Deze poging is voltooid in offline modus.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Er werd een offline poging gesynchroniseerd. Wil je ze bekijken?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'De poging is voltooid via de site.';
$string['addon.mod_lti.errorgetlti'] = 'Fout bij het ophalen van moduledata.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'De start-URL is niet geldig';
$string['addon.mod_lti.launchactivity'] = 'Start de activiteit';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Fout bij het laden van de pagina-inhoud.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Je kunt deze test in de app proberen, maar je moet de poging om de volgende redenen in de browser indienen:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'De test can niet ingestuurd worden om volgende redenen:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Deze poging is niet meer gesynchroniseerd sinds {{$a}}. Als je verder gewerkt hebt aan deze poging met een ander toestel na dit moment, dan kun je data verliezen.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Er is een fout opgetreden tijdens het bewaren van je antwoorden. Weet je zeker dat je de test wil verlaten?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Deze test kan niet gemaakt worden in de app omdat het gedrag ervan niet ondersteund wordt door de app:';
$string['addon.mod_quiz.errordownloading'] = 'Fout bij het downloaden van vereiste data';
$string['addon.mod_quiz.errorgetattempt'] = 'Fout bij het ophalen van de poginggegevens.';
$string['addon.mod_quiz.errorgetquestions'] = 'Fout bij het ophalen van de vragen';
$string['addon.mod_quiz.errorgetquiz'] = 'Fout bij het ophalen van de testgegevens.';
$string['addon.mod_quiz.errorparsequestions'] = 'Er is een fout opgetreden bij het lezen van de vragen. Probeer deze test in een browser.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Deze test kan niet gemaakt worden in de app omdat die enkel vragen bevat die door de app niet ondersteund worden:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Deze test kan niet gemaakt worden in de app omdat er toegangsregels in zitten die niet door de app ondersteund worden:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Er is een fout opgetreden bij het bewaren van de gegevens van de poging.';
$string['addon.mod_quiz.finishnotsynced'] = 'Klaar maar niet gesynchroniseerd';
$string['addon.mod_quiz.opentoc'] = 'Open navigatie.';
$string['addon.mod_quiz.warningattemptfinished'] = 'Offline poging is verwijderd omdat ze op de site voltooid was of niet gevonden.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Sommige offline antwoorden werden verwijderd omdat te vragen online gewijzigd werden.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'De poging is niet beëindigd omdat de offline antwoorden geweigerd werden. Bekijk je antwoorden opnieuw en stuur de poging opnieuw in.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Deze test bevat vragen die niet door de app worden ondersteund:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Fout bij het laden van de inhoud.';
$string['addon.mod_resource.openthefile'] = 'Open het bestand';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Cijfer kon niet berekend worden.';
$string['addon.mod_scorm.dataattemptshown'] = 'Deze gegevens horen bij poging nummer {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Er is een fout opgetreden tijdens het maken van een offline poging. Probeer opnieuw.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Fout bij het downloaden van SCORM: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Fout bij het ophalen van SCORM-gegevens.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Sorry, de applicatie ondersteund SCORM tot versie 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Het downloaden van SCORM-pakketten is uitgeschakeld. Neem contact op met je site-beheerder.';
$string['addon.mod_scorm.errornovalidsco'] = 'Deze SCORM heeft geen zichtbare SCO om te laden.';
$string['addon.mod_scorm.errorpackagefile'] = 'Sorry, de applicatie ondersteunt enkel ZIP-pakketten.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Er is een fout opgetreden tijdens het synchroniseren. Probeer opnieuw.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Deze poging bevat gegevens die nog niet gesynchroniseerd zijn.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Deze poging kan niet verzonden worden omdat je het maximale aantal pogingen overschreden hebt.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Deze SCORM is niet gedownload. Het zal automatisch gedownload worden als je het opent.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Deze SCORM is gewijzigd sinds de laatste download. Het zal automatisch gedownload worden wanneer je het opent.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Sommige offline gegevens van poging {{number}} zijn verwijderd omdat ze niet in een nieuwe poging konden omgezet worden.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Sommige pogingen konden niet gesynchroniseerd worden met de site omdat de laatste online-poging niet beëindigd was. Beëindig eerst de online-poging.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Sorry, er was een probleem bij het insturen van je onderzoek. Probeer opnieuw.';
$string['addon.mod_survey.errorgetsurvey'] = 'Fout bij het ophalen van onderzoeksdata.';
$string['addon.mod_survey.results'] = 'Resultaten';
$string['addon.mod_url.accessurl'] = 'Ga naar de URL';
$string['addon.mod_url.pointingtourl'] = 'URL waarnaar deze bron verwijst.';
$string['addon.mod_wiki.errorloadingpage'] = 'Er is een fout opgetreden tijdens het laden van de pagina.';
$string['addon.mod_wiki.errornowikiavailable'] = 'De wiki heeft nog geen inhoud';
$string['addon.mod_wiki.gowikihome'] = 'Ga naar de Wiki startpagina';
$string['addon.mod_wiki.subwiki'] = 'Sub-wiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Titel mag niet leeg zijn';
$string['addon.mod_wiki.viewpage'] = 'Bekijk pagina';
$string['addon.mod_wiki.wikipage'] = 'Wiki pagina';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Opdrachtstrategie {{$a}} wordt niet ondersteund';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Je moet een titel ingeven.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'De inzending is gewijzigd op de site.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'De beoordeling is gewijzigd op de site.';
$string['addon.notes.userwithid'] = 'Gebruiker met ID {{$a}}';
$string['addon.notes.warningnotenotsent'] = 'Kon notities niet toevoegen aan cursus {{course}}. {{error}}';
$string['addon.notifications.errorgetnotifications'] = 'Fout bij het ophalen van meldingen.';
$string['addon.notifications.notifications'] = 'Meldingen';
$string['addon.notifications.playsound'] = 'Speel geluid';
$string['addon.notifications.therearentnotificationsyet'] = 'Er zijn geen meldingen.';
$string['addon.storagemanager.deletecourse'] = 'Verwijder alle cursusgegevens van je toestel';
$string['addon.storagemanager.deletecourses'] = 'All cursusgegevens wissen';
$string['addon.storagemanager.deletedatafrom'] = 'Verwijder gegevens van {{name}}';
$string['addon.storagemanager.info'] = 'Bestanden die op je apparaat bewaard worden maken de app sneller en zorgen ervoor dat de app offline kan gebruikt worden. Je kunt deze bestanden veilig verwijderen als je ruimte op je toestel moet vrijmaken.';
$string['addon.storagemanager.managestorage'] = 'Beheer opslag';
$string['addon.storagemanager.storageused'] = 'Gebruikte opslagruimte:';
$string['appstoredescription'] = 'Opmerking: deze officiële Moodle app zal enkel werken als je Moodle site dit toestaat. Praat met je systeembeheerder als je problemen hebt om verbinding te maken.

Als je Moodle site hiervoor is geconfigureerd, dan kun je deze app gebruiken om:
- te bladeren door de inhoud van je cursussen, zelfs offline
- meldingen krijgen van berichten en andere gebeurtenissen
- snel mensen vinden en contacteren in je cursussen
- afbeeldingen, geluid, video en andere bestanden uploaden van je mobiele apparaat
- je cijfers bekijken
- en meer!

Bekijk http://docs.moodle.org/en/Mobile_app voor de laatste informatie hierover.

We appreciëren goede reviews over de functionaliteit die er al in zit en ook suggesties over wat er nog ontbreekt zijn welkom!

De app heeft volgende rechten nodig:
Geluid opnemen - om geluid op te nemen en dat te uploaden naar Moodle
Lezen en wijzigen van de inhoud op je SD-kaart - Inhoud van cursussen wordt gedownload naar de SD-kaart, zodat je die offline kunt bekijken
Netwerktoegang - Om met je Moodle site te kunnen verbinden en om te  te controleren of je verbonden of offline bent
Achtergrondproces - Zodat je lokale meldingen kunt ontvangen, zelfs als de app op de achtergrond loopt
Slaapstand verhinderen - zodat je altijd push-meldingen kunt ontvangen';
$string['core.android'] = 'Android';
$string['core.browser'] = 'Browser';
$string['core.cannotconnect'] = 'Kan niet verbinden';
$string['core.cannotconnecttrouble'] = 'Er zijn moeilijkheden om verbinding te maken met je site.';
$string['core.cannotconnectverify'] = '<strong>Controleer of het adres juist is.</strong>';
$string['core.cannotdownloadfiles'] = 'Bestanden downloaden is uitgeschakeld voor jouw mobiele service. Neem contact op met je systeembeheerder.';
$string['core.captureaudio'] = 'Audio opnemen';
$string['core.capturedimage'] = 'Foto genomen.';
$string['core.captureimage'] = 'Maak foto';
$string['core.capturevideo'] = 'Film opnemen';
$string['core.clearsearch'] = 'Zoekresultaten leegmaken';
$string['core.clicktoseefull'] = 'Klik hier om de volledige inhoud te zien';
$string['core.comments.commentsnotworking'] = 'Opmerkingen kunnen niet worden opgehaald';
$string['core.comments.warningcommentsnotsent'] = 'Kan reacties niet synchroniseren. {{error}}';
$string['core.confirmcanceledit'] = 'Weet je zeker dat je deze pagina wil verlaten? Alle wijzigingen zullen verloren gaan.';
$string['core.confirmgotabroot'] = 'Weet je zeker dat je terug wilt naar {{name}}?';
$string['core.confirmgotabrootdefault'] = 'Weet je zeker dat je naar de eerste pagina van het huidige tabblad wil gaan?';
$string['core.confirmleaveunknownchanges'] = 'Weet je zeker dat je deze pagina wil verlaten? Wijzigingen die niet bewaard zijn zullen verloren gaan.';
$string['core.confirmloss'] = 'Ben je zeker? Alle wijzigingen zullen verloren gaan.';
$string['core.confirmopeninbrowser'] = 'Wil je het openen in je browser?';
$string['core.contenteditingsynced'] = 'De inhoud die je aan het bewerken bent, is gesynchroniseerd.';
$string['core.contentlinks.chooseaccount'] = 'Kies account';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Kies een account om de link mee te openen.';
$string['core.contentlinks.confirmurlothersite'] = 'Deze link verwijst naar een andere site. Wil je dit openen?';
$string['core.contentlinks.errornoactions'] = 'Kon geen actie vinden om uit te voeren met deze link.';
$string['core.contentlinks.errornosites'] = 'Kon geen site vinden om deze link te behandelen.';
$string['core.contentlinks.errorredirectothersite'] = 'De redirect URL kan niet naar een andere site wijzen.';
$string['core.copiedtoclipboard'] = 'Tekst gekopieerd naar klembord';
$string['core.copytoclipboard'] = 'Kopieer naar klembord';
$string['core.course.activitydisabled'] = 'Jouw organisatie heeft deze activiteit uitgeschakeld in de mobiele app.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Jouw organisatie heeft een plugin geïnstalleerd die nog niet ondersteund wordt.';
$string['core.course.activitynotyetviewablesiteupgradeneeded'] = 'De site gebruikt de niet laatste Moodle-versie en moet worden geüpdatet. Neem contact op met de site-beheerder.';
$string['core.course.allsections'] = 'Alle secties';
$string['core.course.askadmintosupport'] = 'Neem contact op met de sitebeheerder en geef aan dat je deze activiteit met de Moodle mobile app wilt gebruiken.';
$string['core.course.availablespace'] = 'Je hebt ongeveer {{available}} vrije ruimte.';
$string['core.course.cannotdeletewhiledownloading'] = 'Bestanden kunnen niet verwijderd worden terwijl de activiteit gedownload wordt. Wacht tot de download klaar is.';
$string['core.course.confirmdeletemodulefiles'] = 'Weet je zeker dat je deze modulebestanden wil verwijderen?';
$string['core.course.confirmdownload'] = 'Je gaat {{size}}.{{availableSpace}}  downloaden. Weet je zeker dat je verder wil gaan?';
$string['core.course.confirmdownloadunknownsize'] = 'We konden de grootte van de download.{{availableSpace}} niet berekenen. Weet je zeker dat je toch wil downloaden?';
$string['core.course.confirmdownloadzerosize'] = 'Je gaat beginnen met downloaden. {{AvailableSpace}} Weet je zeker dat je wilt doorgaan?';
$string['core.course.confirmlimiteddownload'] = 'Je bent nu niet via Wi-Fi verbonden.';
$string['core.course.confirmpartialdownloadsize'] = 'Je staat op het punt om <strong>minstens</strong> {{size}}.{{availableSpace}} te downloaden. Weet je zeker dat je verder wil gaan?';
$string['core.course.contents'] = 'Inhoud';
$string['core.course.couldnotloadsectioncontent'] = 'Kon sectie-inhoud niet laden. Probeer later opnieuw.';
$string['core.course.couldnotloadsections'] = 'Kon secties niet laden. Probeer later opnieuw.';
$string['core.course.errordownloadingcourse'] = 'Fout bij het downloaden van de cursus';
$string['core.course.errordownloadingsection'] = 'Fout bij het downloaden van de sectie.';
$string['core.course.errorgetmodule'] = 'Fout bij het ophalen van activiteitsgegevens.';
$string['core.course.insufficientavailablequota'] = 'Je toestel kon geen ruimte toewijzen om deze download te bewaren. Misschien reserveert het ruimte voor app en systeem-updates. Maak eerst wat ruimte vrij.';
$string['core.course.insufficientavailablespace'] = 'Je probeert {{size}} te downloaden. Hierdoor zal je toestel onvoldoende vrije ruimte overhouden om normaal te functioneren. Maak eerst wat ruimte vrij.';
$string['core.course.manualcompletionnotsynced'] = 'Manueel voltooien niet gesynchroniseerd.';
$string['core.course.nocontentavailable'] = 'Geen inhoud beschikbaar.';
$string['core.coursenogroups'] = 'Je bent geen lid van een groep van deze cursus.';
$string['core.course.refreshcourse'] = 'Cursus vernieuwen';
$string['core.courses.cannotretrievemorecategories'] = 'Categorieën dieper dan niveau {{$a}} kunnen niet opgehaald worden.';
$string['core.courses.confirmselfenrol'] = 'Weet je zeker dat je je wil aanmelden in deze cursus?';
$string['core.courses.downloadcourses'] = 'Download cursussen';
$string['core.courses.enrolme'] = 'Meld me aan';
$string['core.courses.errorloadcategories'] = 'Er is een fout opgetreden bij het ophalen van categorieën.';
$string['core.courses.errorloadcourses'] = 'Er is een fout opgetreden tijdens het laden van de cursussen.';
$string['core.courses.errorloadplugins'] = 'De plugins, vereist door deze cursus, konden niet correct geladen worden. Herstart de app en probeer opnieuw.';
$string['core.courses.errorsearching'] = 'Er is een fout opgetreden tijdens het zoeken.';
$string['core.courses.errorselfenrol'] = 'Er is een fout opgetreden tijdens het zelf aanmelden.';
$string['core.courses.filtermycourses'] = 'Filter mijn cursussen';
$string['core.courses.notenrollable'] = 'Je kunt jezelf niet aanmelden in deze cursus.';
$string['core.courses.password'] = 'Aanmeldingssleutel';
$string['core.courses.searchcoursesadvice'] = 'Je kunt via de cursus zoekknop toegang krijgen als gast of jezelf aanmelden in cursussen die dit toestaan.';
$string['core.courses.selfenrolment'] = 'Zelf aanmelden';
$string['core.courses.totalcoursesearchresults'] = 'Totaal aantal cursusen: {{$a}}';
$string['core.course.useactivityonbrowser'] = 'Je kunt de activiteit nog steeds via de browser van je apparaat gebruiken.';
$string['core.course.warningmanualcompletionmodified'] = 'Het manueel voltooien van een activiteit werd gewijzigd op de site.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Sommige van de offline manueel aangeduide voltooiingen van cursus \'{{name}}\' zijn verwijderd. {{error}}';
$string['core.currentdevice'] = 'Huidig apparaat';
$string['core.datastoredoffline'] = 'Gegevens die bewaard werden op het toestel konden niet verstuurd worden. Ze zullen later automatisch verzonden worden.';
$string['core.deletedoffline'] = 'Offline verwijderd';
$string['core.deleting'] = 'Verwijderen.';
$string['core.desktop'] = 'Bureaublad';
$string['core.dfdaymonthyear'] = 'MM-DD-JJJJ';
$string['core.dfdayweekmonth'] = 'ddd, D, MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Verwerpen';
$string['core.dismiss'] = 'Verwijderen';
$string['core.downloaded'] = 'Gedownload';
$string['core.downloading'] = 'Downloaden';
$string['core.editor.hidetoolbar'] = 'Verberg Toolbar';
$string['core.editor.toggle'] = 'Toggle-editor';
$string['core.emptysplit'] = 'Deze pagina zal leeg verschijnen als het linker paneel leeg of aan het laden is.';
$string['core.errorchangecompletion'] = 'Er is een fout opgetreden tijdens het wijzigen van de voltooiingsstatus. Probeer opnieuw.';
$string['core.errordeletefile'] = 'Fout tijdens het verwijderen van het bestand. Probeer opnieuw.';
$string['core.errordownloading'] = 'Fout bij downloaden bestand';
$string['core.errordownloadingsomefiles'] = 'Fout bij het downloaden van modulebestanden. Sommige bestanden kunnen ontbreken.';
$string['core.errorfileexistssamename'] = 'Er is al een bestand met deze naam.';
$string['core.errorinvalidform'] = 'Het formulier bevat ongeldige gegevens. Zorg ervoor dat je alle vereiste velden hebt ingevuld en dat de gegevens geldig zijn.';
$string['core.errorinvalidresponse'] = 'Ongeldig antwoord gekregen. Contacteer je Moodle site-beheerder als het probleem zich blijft voordoen.';
$string['core.errorloadingcontent'] = 'Fout bij het laden van inhoud.';
$string['core.errorofflinedisabled'] = 'Offline browsen is uitgeschakeld op je site. Je moet verbinding hebben met het internet om de app te kunnen gebruiken.';
$string['core.erroropenfilenoapp'] = 'Fout bij het openen van het bestand: geen enkele app gevonden om dit soort bestand te openen.';
$string['core.erroropenfilenoextension'] = 'Fout bij het openen van het bestand: het bestand heeft geen extentie.';
$string['core.erroropenpopup'] = 'Deze activiteit probeert een popup te openen. Dit wordt niet ondersteund in deze app.';
$string['core.errorrenamefile'] = 'Fout bij het hernoemen van het bestand. Probeer opnieuw.';
$string['core.errorsomedatanotdownloaded'] = 'Als je deze activiteit hebt gedownload, hou er dan rekening mee dat sommige gegevens tijdens het downloadproces niet worden gedownload om redenen van prestaties en gegevensgebruik.';
$string['core.errorsync'] = 'Er is een fout opgetreden tijdens het synchroniseren. Probeer opnieuw.';
$string['core.errorsyncblocked'] = 'Deze {{$a}} kan nu niet gesynchroniseerd worden omdat er nog een ander proces anders bezig is. Probeer later opnieuw. Als het probleem blijft aanhouden, probeer dan de app te herstarten.';
$string['core.errorurlschemeinvalidsite'] = 'Deze site-URL kan niet worden geopend in deze app.';
$string['core.filenameexist'] = 'Bestandsnaam bestaat al: {{$a}}';
$string['core.fileuploader.audio'] = 'Audio';
$string['core.fileuploader.camera'] = 'Camera';
$string['core.fileuploader.confirmuploadfile'] = 'Je gaat {{size}} uploaden. Weet je zeker dat je wil verder gaan?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'We konden de grootte van de upload niet berekenen. Weet je zeker dat je wil verder gaan?';
$string['core.fileuploader.errorcapturingaudio'] = 'Fout tijdens het opnemen van audio.';
$string['core.fileuploader.errorcapturingimage'] = 'Fout bij het nemen van een foto.';
$string['core.fileuploader.errorcapturingvideo'] = 'Fout bij het maken van een video.';
$string['core.fileuploader.errorgettingimagealbum'] = 'Fout bij het ophalen van een foto uit het album.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Je moet online zijn om bestanden te kunnen uploaden.';
$string['core.fileuploader.errornoapp'] = 'Je hebt geen app geïnstalleerd om dit te kunnen doen.';
$string['core.fileuploader.errorreadingfile'] = 'Fout bij het lezen van het bestand.';
$string['core.fileuploader.errorwhileuploading'] = 'Er is een fout opgetreden tijdens het uploaden van het bestand.';
$string['core.fileuploader.file'] = 'Bestand';
$string['core.fileuploader.fileuploaded'] = 'Het uploaden van het bestand is gelukt.';
$string['core.fileuploader.maxbytesfile'] = 'Het bestand {{$a.file}} is te groot. De maximale uploadgrootte is {{$a.size}}.';
$string['core.fileuploader.photoalbums'] = 'Foto-albums';
$string['core.fileuploader.readingfile'] = 'Bestand lezen';
$string['core.fileuploader.readingfileperc'] = 'Lezen bestand: {{$a}}%';
$string['core.fileuploader.selectafile'] = 'Selecteer een bestand';
$string['core.fileuploader.uploadafile'] = 'Bestand uploaden';
$string['core.fileuploader.uploading'] = 'Aan het uploaden';
$string['core.fileuploader.uploadingperc'] = 'Uploaden: {{$a}}%';
$string['core.fileuploader.video'] = 'Video';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.h5p.errorgetemail'] = 'Fout bij het verkrijgen van de e-mail van de gebruiker. Controleer je verbinding en probeer opnieuw.';
$string['core.h5p.offlinedisabled'] = 'De site staat het downloaden van H5P-pakketten niet toe.';
$string['core.h5p.play'] = 'H5P afspelen';
$string['core.hasdatatosync'] = 'Dit {{$a}} heeft offline data om te synchroniseren.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.image'] = 'Afbeelding';
$string['core.imageviewer'] = 'Afbeeldingsviewer';
$string['core.ios'] = 'iOS';
$string['core.lastdownloaded'] = 'Laatste download';
$string['core.lastsync'] = 'Laatste synchronisatie';
$string['core.loadmore'] = 'Meer laden';
$string['core.login.authenticating'] = 'Authenticeren';
$string['core.login.changepasswordbutton'] = 'Open de wijzig wachtwoordpagina';
$string['core.login.changepasswordhelp'] = 'Contacteer je site-beheerder als je problemen hebt met het wijzigen van je wachtwoord. "Site-beheerders" zijn mensen die Moodle beheren op jouw school / universiteit / bedrijf of scholingsorganisatie. Als je niet weet wie te contacteren, spreek dan je leraar/trainer aan.';
$string['core.login.changepasswordinstructions'] = 'Je kunt je wachtwoord niet wijzigen in de app. Klik op onderstaande knop om de site te openen in een browser om je wachtwoord te wijzigen. Sluit je browser na het wijzigen van je wachtwoord, want je zult niet automatisch terug naar de app gestuurd worden.';
$string['core.login.changepasswordlogoutinstructions'] = 'Als je naar een andere site wil of wil afmelden, klik dan volgende knop:';
$string['core.login.changepasswordreconnectinstructions'] = 'Klik op volgende knop om opnieuw te verbinden met de site. (Je zult terug naar het vorige scherm gebracht worden als je je wachtwoord fout ingeeft.)';
$string['core.login.confirmdeletesite'] = 'Weet je zeker dat je de site {{sitename}} wil verwijderen?';
$string['core.login.connect'] = 'Verbinden!';
$string['core.login.connecttomoodle'] = 'Verbinden met Moodle';
$string['core.login.connecttomoodleapp'] = 'Je probeert verbinding te maken met een gewone Moodle-site. Download de officiële Moodle-app om toegang te krijgen tot deze site.';
$string['core.login.connecttoworkplaceapp'] = 'Je probeert verbinding te maken met een Moodle Workplace-site. Download de Moodle Workplace-app om toegang te krijgen tot deze site.';
$string['core.login.contactyouradministrator'] = 'Neem contact op met je site-beheerder voor meer hulp.';
$string['core.login.contactyouradministratorissue'] = 'Vraag aan je site-beheerder om volgend probleem te onderzoeken: {{$a}}';
$string['core.login.credentialsdescription'] = 'Geef je gebruikersnaam en wachtwoord op om je aan te melden';
$string['core.login.emailconfirmsentnoemail'] = '<p>Er zou een e-mail naar jouw adres verstuurd moeten zijn.</p><p>Die bevat makkelijke instructies om je registratie te voltooien.</p><p>Als je blijft problemen ondervinden, neem dan contact op met je site-beheerder.</p>';
$string['core.login.emailnotmatch'] = 'E-mailadressen komen niet overeen';
$string['core.login.erroraccesscontrolalloworigin'] = 'De Cross-Origin call die je probeerde uit te voeren,  werd geweigerd. Controleer https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = 'Er is een fout opgetreden bij het verwijderen van deze site. Probeer opnieuw.';
$string['core.login.errorexampleurl'] = 'De URL https://campus.example.edu is slechts een voorbeeld-URL, het is geen echte site. <strong> Gebruik de URL van de site van jouw school of organisatie. </strong>';
$string['core.login.errorupdatesite'] = 'Er is een fout opgetreden bij het updaten van het token van deze site.';
$string['core.login.faqcannotconnectanswer'] = 'Neem contact op met je site-beheerder.';
$string['core.login.faqcannotconnectquestion'] = 'Ik heb mijn site-adres correct getypt, maar ik kan nog steeds geen verbinding maken.';
$string['core.login.faqcannotfindmysiteanswer'] = 'Heb je de naam juist ingegeven? Het is ook mogelijk dat je site is niet opgenomen in onze lijst met publieke sites. Als je de naam niet kan vinden, geef dan je site adres in.';
$string['core.login.faqcannotfindmysitequestion'] = 'Ik kan mijn site niet vinden.';
$string['core.login.faqsetupsiteanswer'] = 'Bezoek {{$link}} om de verschillende opties te bekijken die je hebt om je eigen Moodle-site te maken.';
$string['core.login.faqsetupsitelinktitle'] = 'Begin.';
$string['core.login.faqsetupsitequestion'] = 'Ik wil mijn eigen Moodle-site opzetten.';
$string['core.login.faqtestappanswer'] = 'Om de app te testen op een Moodle-demosite, typ je "leraar" of "leerling" in het veld "Jouw site-adres" en klik je op de "Verbinden met je site" knop.';
$string['core.login.faqtestappquestion'] = 'Ik wil gewoon de app testen, wat kan ik doen?';
$string['core.login.faqwhatisurlanswer'] = '<p> Elke organisatie of school heeft een eigen aangepast adres voor hun Moodle-site. </p><p> Om het adres te vinden: </p><ol>< li> Open een webbrowser en ga naar de inlogpagina van jouw Moodle-site </li><li> Bovenaan de pagina, in de adresbalk, zie je de URL van je Moodle-site. Bijv. "campus.example.edu". {{$image}}</li><li> Kopieer het adres (kopieer niet de / login en wat daarna komt), plak het in de Moodle-app en klik op "Verbinden met je site" </li><li>Je kunt nu inloggen op je site met je gebruikersnaam en wachtwoord </li>';
$string['core.login.faqwhatisurlquestion'] = 'Wat is mijn site-adres? Hoe kan mijn site-URL vinden?';
$string['core.login.faqwhereisqrcode'] = 'Waar vind ik de QR-code?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>Als je organistatie dit ingeschakeld heeft, dan zul je een QR-code vinden onderaan je gebruikersprofielpagina.</p>{{$image}}';
$string['core.login.findyoursite'] = 'Zoek je site';
$string['core.login.helpmelogin'] = '<p>Deze app kan alleen verbinding maken met Moodle sites die mobiele toegang ingeschakeld hebben.</p><p>Als je niet kunt verbinden met je Moodle-site, neem dan contact op met je site-beheerder en vraag hem om <a href="http://docs.moodle.org/en/Mobile_app" target="_blank">http://docs.moodle.org/en/Mobile_app</a> te lezen.</p><p>Om de app in een Moodle demo site te testen, kun je <i>teacher</i> of <i>student</i> in het <i>Site-adres</i>-veld typen en op de <b>verbind-knop</b> klikken.</p>e';
$string['core.login.invalidaccount'] = 'Controleer je logingegevens of vraag je site-beheerder om de site-configuratie te controleren.';
$string['core.login.invalidmoodleversion'] = '<p>Ongeldige Moodle-versie. De Moodle app ondersteunt enkel Moodle sites {{$a}} en hoger.</p>
<p>Je kunt contact opnemen met je site-beheerders en hen vragen om hun Moodle site te upgraden.</p>
<p>"Site-beheerders" zijn de mensen die Moodle beheren voor jouw school/universiteit/bedrijf of organisatie. Als je niet weet hoe ze te bereiken, contacteer dan je leraren/trainers.</p>';
$string['core.login.invalidsite'] = 'Deze site-URL is niet geldig.';
$string['core.login.invalidtime'] = 'Ongeldige tijd';
$string['core.login.invalidvaluemax'] = 'De maximum waarde is {{$a}}';
$string['core.login.invalidvaluemin'] = 'De minimum waard eis {{$a}}';
$string['core.login.localmobileunexpectedresponse'] = 'Moodle Mobile Additional Features Check gaf een onverwacht antwoord. Je zult aanmelden via de standaard Mobile service.';
$string['core.login.loggedoutssodescription'] = 'Je moet opnieuw aanmelden. Je moet aanmelden met een browservenster.';
$string['core.login.loginbutton'] = 'Inloggen';
$string['core.login.logininsiterequired'] = 'Je dient via een browser in te loggen op je Moodle site';
$string['core.login.mobileservicesnotenabled'] = 'Mobiele diensten zijn niet geactiveerd voor jouw Moodle site. Neem contact op met de sitebeheerder als je denkt dat die zouden moeten ingeschakeld zijn.';
$string['core.login.newsitedescription'] = 'Geef de URL van je Moodle site. Merk op dat die misschien niet geconfigureerd is om met deze app te werken.';
$string['core.login.notloggedin'] = 'Je moet ingelogd zijn.';
$string['core.login.onboardingcreatemanagecourses'] = 'Maak en beheer je cursussen';
$string['core.login.onboardingenrolmanagestudents'] = 'Leerlingen aanmelden en beheren';
$string['core.login.onboardinggetstarted'] = 'Beginnen met Moodle';
$string['core.login.onboardingialreadyhaveasite'] = 'Ik heb al een Moodle site';
$string['core.login.onboardingimalearner'] = 'Ik ben een leerling';
$string['core.login.onboardingimaneducator'] = 'Ik ben een leraar';
$string['core.login.onboardingineedasite'] = 'Ik heb een Moodle site nodig';
$string['core.login.onboardingprovidefeedback'] = 'Geef me tijdig feefdback';
$string['core.login.onboardingtoconnect'] = 'Om met de Moodle App te kunnen verbinden, heb je een Moodle site nodig';
$string['core.login.onboardingwelcome'] = 'Welkom bij de Moodle App';
$string['core.login.or'] = 'OF';
$string['core.login.passwordrequired'] = 'Wachtwoord vereist';
$string['core.login.problemconnectingerror'] = 'We hebben een probleem met het verbinden met';
$string['core.login.problemconnectingerrorcontinue'] = 'Controleer of je het adres juist ingegeven hebt en probeer opnieuw.';
$string['core.login.recaptchachallengeimage'] = 'reCAPTCHA challenge afbeelding';
$string['core.login.recaptchaexpired'] = 'Verificatie verlopen. Beantwoord de beveiligingsvraag opnieuw.';
$string['core.login.recaptchaincorrect'] = 'Het antwoord op de beveiligingsvraag is fout.';
$string['core.login.reconnect'] = 'Opnieuw verbinden';
$string['core.login.reconnectdescription'] = 'Je authenticatietoken is niet geldig of is verlopen. Je moet opnieuw verbinden met de site.';
$string['core.login.reconnectssodescription'] = 'Je authenticatietoken is niet geldig of is verlopen. Je moet opnieuw verbinden met de site. Je moet je op de site aanmelden via een browservenster.';
$string['core.login.searchby'] = 'Zoeken op:';
$string['core.login.selectsite'] = 'Selecteer je site:';
$string['core.login.signupplugindisabled'] = '{{$a}} is niet geactiveerd';
$string['core.login.siteaddress'] = 'Jouw site';
$string['core.login.sitehasredirect'] = 'Je site bevat minstens één HTTP redirect. De app kan geen redirects volgen. Dit kan het probleem zijn dat je app verhindert om je site te connecteren.';
$string['core.login.siteinmaintenance'] = 'Je Moodle site staat in onderhoudsmodus';
$string['core.login.sitepolicynotagreederror'] = 'Site-beleid niet goedgekeurd.';
$string['core.login.siteurl'] = 'Site URL';
$string['core.login.siteurlrequired'] = 'De site URL is vereist, bijvoorbeeld <i>http://www.jouwmoodlesite.org</i>';
$string['core.login.stillcantconnect'] = 'Kun je nog steeds niet verbinden?';
$string['core.login.usernamerequired'] = 'Gebruikersnaam vereist';
$string['core.login.visitchangepassword'] = 'Wil je de site bezoeken om je wachtwoord te wijzigen?';
$string['core.login.webservicesnotenabled'] = 'Web services zijn niet geactiveerd op jouw Moodle site. Neem contact op met de sitebeheerder voor hulp.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Je kunt nog steeds verbinden met de site door je gebruikersnaam en wachtwoord in te geven.';
$string['core.login.yourenteredsite'] = 'Verbinden met je site';
$string['core.lostconnection'] = 'Je token is ongeldig of verlopen. Je zult opnieuw moeten verbinden met de site.';
$string['core.mainmenu.appsettings'] = 'App instellingen';
$string['core.mainmenu.changesite'] = 'Naar andere site';
$string['core.mainmenu.website'] = 'Website';
$string['core.needhelp'] = 'Hulp nodig?';
$string['core.networkerroriframemsg'] = 'Deze inhoud is niet beschikbaar offline. Maak verbinding met het internet en probeer opnieuw.';
$string['core.networkerrormsg'] = 'Er was een probleem met het verbinden met de site. Controleer je verbinding en probeer opnieuw.';
$string['core.nooptionavailable'] = 'Geen optie beschikbaar';
$string['core.nopasswordchangeforced'] = 'Je kunt niet verdergaan zonder je wachtwoord te veranderen.';
$string['core.nopermissionerror'] = 'Sorry, maar je hebt nu niet het recht om dit te doen.';
$string['core.notapplicable'] = 'n/a';
$string['core.notsent'] = 'Niet verstuurd';
$string['core.nummore'] = '{{$a}}  meer';
$string['core.openfullimage'] = 'Klik hier om de afbeelding op volledige grootte weer te geven.';
$string['core.openinbrowser'] = 'Open in browser';
$string['core.openmodinbrowser'] = 'Open {{$a}} in browser';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.pulltorefresh'] = 'Slepen om te verversen';
$string['core.qrscanner'] = 'QR-scanner';
$string['core.question.cannotdeterminestatus'] = 'Kan status niet bepalen';
$string['core.question.errorattachmentsnotsupported'] = 'De applicatie ondersteunt nog geen blijlagen bij antwoorden.';
$string['core.question.errorinlinefilesnotsupported'] = 'Deze applicatie ondersteunt het inline bewerken van bestanden nog niet.';
$string['core.question.errorquestionnotsupported'] = 'Dit vraagtype wordt nog niet ondersteund door de app: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Tik om te selecteren en tik om neer te zetten.';
$string['core.question.questionmessage'] = 'Vraag  {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Je wordt doorgestuurd naar de site.';
$string['core.removefiles'] = 'Verwijder bestanden {{$a}}';
$string['core.requireduserdatamissing'] = 'Er ontbreken vereiste gegevens in het profiel van deze gebruiker. Vul deze gegevens in op je Moodle-site en probeer opnieuw.<br>{{$a}}';
$string['core.retry'] = 'Probeer opnieuw';
$string['core.scanqr'] = 'Scan QR-code';
$string['core.searching'] = 'Zoeken';
$string['core.settings.about'] = 'Over';
$string['core.settings.appready'] = 'App klaar';
$string['core.settings.appsettings'] = 'App instellingen';
$string['core.settings.appversion'] = 'App versie';
$string['core.settings.cannotsyncoffline'] = 'Kan offline niet synchroniseren.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Kan nu niet synchroniseren omdat er volgens je huidige instellingen alleen over Wi-Fi gesynchroniseerd mag worden. Maak verbinding met een Wi-Fi-netwerk.';
$string['core.settings.colorscheme'] = 'Kleurschema';
$string['core.settings.colorscheme-auto'] = 'Automatisch (gebaseerd op systeeminstellingen)';
$string['core.settings.colorscheme-dark'] = 'Donker';
$string['core.settings.colorscheme-light'] = 'Licht';
$string['core.settings.compilationinfo'] = 'Compilatie info';
$string['core.settings.copyinfo'] = 'Kopieer apparaatinformatie op het klembord';
$string['core.settings.cordovadevicemodel'] = 'Cordova device model';
$string['core.settings.cordovadeviceosversion'] = 'Cordova device OS versie';
$string['core.settings.cordovadeviceplatform'] = 'Cordova device platform';
$string['core.settings.cordovadeviceuuid'] = 'Cordova device UUID';
$string['core.settings.cordovaversion'] = 'Cordova versie';
$string['core.settings.debugdisplaydescription'] = 'Indien ingeschakeld zal er indien mogelijk meer informatie over de fout getoond worden.';
$string['core.settings.deletesitefiles'] = 'Weet je zeker dat je de gedownloade en gecachede gegevens van de site {{sitename}} wil verwijderen? Je zult de app niet meer in offline modus kunnen gebruiken.';
$string['core.settings.deletesitefilestitle'] = 'Verwijder site-bestanden';
$string['core.settings.deviceinfo'] = 'Toestel info';
$string['core.settings.deviceos'] = 'Toestel OS';
$string['core.settings.devicewebworkers'] = 'Ondersteunde Device Web Workers';
$string['core.settings.displayformat'] = 'Schermformaat';
$string['core.settings.enabledownloadsection'] = 'Downloadsecties inschakelen';
$string['core.settings.enablefirebaseanalytics'] = 'Schakel Firebase-analyse in';
$string['core.settings.enablefirebaseanalyticsdescription'] = 'Indien ingeschakeld, verzamelt de app anoniem gegevensgebruik.';
$string['core.settings.enablerichtexteditor'] = 'Editor voor opgemaakte tekst inschakelen';
$string['core.settings.enablerichtexteditordescription'] = 'Indien ingeschakeld, zal er een tekst editor voor opgemaakte tekst getoond worden op plaatsen waar het kan.';
$string['core.settings.enablesyncwifi'] = 'Synchronisatie alleen over WI-FI toestaan.';
$string['core.settings.entriesincache'] = '{{$a}} items in cache';
$string['core.settings.errordeletesitefiles'] = 'Fout bij het verwijderen van bestanden';
$string['core.settings.errorsyncsite'] = 'Fout bij het synchroniseren van sitegegevens. Controleer je internetverbinding en probeer opnieuw.';
$string['core.settings.estimatedfreespace'] = 'Geschatte vrije ruimte';
$string['core.settings.filesystemroot'] = 'Root bestandssysteem';
$string['core.settings.fontsize'] = 'Lettergrootte';
$string['core.settings.forcedsetting'] = 'Deze instelling is afgedwongen door uw siteconfiguratie.';
$string['core.settings.localnotifavailable'] = 'Lokale meldingen beschikbaar';
$string['core.settings.locationhref'] = 'Webview URL';
$string['core.settings.navigatorlanguage'] = 'Navigatietaal';
$string['core.settings.navigatoruseragent'] = 'Navigatie userAgent';
$string['core.settings.networkstatus'] = 'Internet connectiestatus';
$string['core.settings.opensourcelicenses'] = 'Open source-licentie';
$string['core.settings.privacypolicy'] = 'Privacy-beleid';
$string['core.settings.publisher'] = 'Uitgever';
$string['core.settings.pushid'] = 'Push-notificaties ID';
$string['core.settings.reportinbackground'] = 'Fouten automatisch rapporteren';
$string['core.settings.screen'] = 'Scherminformatie';
$string['core.settings.showdownloadoptions'] = 'Toon download-opties';
$string['core.settings.siteinfo'] = 'Site info';
$string['core.settings.spaceusage'] = 'Gebruikte ruimte';
$string['core.settings.spaceusagehelp'] = 'Als u de opgeslagen informatie van de site verwijdert, worden alle offline gegevens van de site verwijderd. Met deze informatie kunt u de app offline gebruiken.';
$string['core.settings.synchronization'] = 'Synchronisatie';
$string['core.settings.synchronizenow'] = 'Nu synchroniseren';
$string['core.settings.synchronizenowhelp'] = 'Het synchroniseren van een site verzendt in afwachting van wijzigingen en alle offline activiteiten die op het apparaat zijn opgeslagen en synchroniseert bepaalde gegevens zoals berichten en meldingen.';
$string['core.settings.syncsettings'] = 'Synchronisatie-instellingen';
$string['core.settings.versioncode'] = 'Versie code';
$string['core.settings.versionname'] = 'Versie naam';
$string['core.settings.wificonnection'] = 'Wifi-verbinding';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Kies een account om het bestand in te bewaren.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Er is al een bestand met die naam. Wil je het bestaande bestand vervangen of wil je het hernoemen naar "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Er zijn geen sites bewaard. Voeg een site toe voor je een bestand deelt via de app.';
$string['core.sharedfiles.nosharedfiles'] = 'Er zijn geen gedeelde bestanden bewaard op deze site.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Je hebt geen bestanden om hier te uploaden. Als je een bestand wil uploaden vanuit een andere app, zoek dan dat bestand en klik op de \'Open in\'-knop.';
$string['core.sharedfiles.rename'] = 'Hernoem';
$string['core.sharedfiles.replace'] = 'Vervang';
$string['core.sharedfiles.sharedfiles'] = 'Gedeelde bestanden';
$string['core.sharedfiles.successstorefile'] = 'Bestand bewaard. Je kunt dit bestand nu selecteren om het te uploaden naar je privé-bestanden of het als bijlage gebruiken in activiteiten.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Sorry...';
$string['core.storingfiles'] = 'Bestanden bewaren';
$string['core.tablet'] = 'Tablet';
$string['core.tag.errorareanotsupported'] = 'Dit taggebied wordt niet ondersteund door de app.';
$string['core.tag.warningareasnotsupported'] = 'Sommige taggebieden worden niet weergegeven omdat ze niet worden ondersteund door de app.';
$string['core.thereisdatatosync'] = 'Er zijn offline {{$a}} die moeten worden gesynchroniseerd.';
$string['core.tryagain'] = 'Probeer opnieuw';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Ojee!';
$string['core.unexpectederror'] = 'Onverwachte fout. Sluit en heropen de applicatie om opnieuw te proberen.';
$string['core.unicodenotsupported'] = 'Sommige emojis worden niet ondersteund op deze site. Deze tekens zullen verwijderd worden wanneer het bericht verstuurd wordt.';
$string['core.unicodenotsupportedcleanerror'] = 'Er is lege tekst gevonden tijdens het opschonen van Unicode-tekens.';
$string['core.unknown'] = 'Onbekend';
$string['core.unzipping'] = 'Unzippen';
$string['core.updaterequired'] = 'App update vereist';
$string['core.updaterequireddesc'] = 'Update je app naar versie {{$a}}';
$string['core.user.contact'] = 'Contact';
$string['core.user.detailsnotavailable'] = 'Je kunt de details voor deze gebruiker niet bekijken.';
$string['core.user.errorloaduser'] = 'Fout bij het laden van de gebruiker.';
$string['core.user.sendemail'] = 'E-mail';
$string['core.viewcode'] = 'Bekijk code';
$string['core.vieweditor'] = 'Bekijk editor';
$string['core.viewembeddedcontent'] = 'Bekijk ingebedde inhoud';
$string['core.warningofflinedatadeleted'] = 'Offline data van {{component}} \'{{name}}\' is verwijderd. {{error}}';
$string['core.whoissiteadmin'] = '"Site-beheerders" zijn de mensen die de Moodle beheren op jouw school / universiteit / bedrijf of lerende organisatie. Als je niet weet hoe je contact met hen kunt opnemen, neem dan contact op met je leraren / docenten / trainers.';
$string['core.whoops'] = 'Oei!';
$string['core.whyisthishappening'] = 'Waarom gebeurt dit?';
$string['core.windowsphone'] = 'Windows Phone';
$string['core.wsfunctionnotavailable'] = 'De webservice is niet beschikbaar';
$string['core.youreoffline'] = 'Je bent offline';
$string['core.youreonline'] = 'Je bent terug online';
$string['pluginname'] = 'Moodle mobile taal-strings';
