<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_adaptable', language 'el', branch 'MOODLE_37_STABLE'
 *
 * @package   theme_adaptable
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutme'] = 'Σχετικά με εμένα';
$string['actingasrole'] = 'Αυτή τη στιγμή ενεργείτε με διαφορετικό ρόλο';
$string['activebreadcrumb'] = 'Χρώμα υπόβαθρου ενεργού δυναμικού μονοπατιού (μπάρας πλοήγησης)';
$string['activebreadcrumbdesc'] = 'Ορισμός του χρώματος υπόβαθρου του ενεργού δυναμικού μονοπατιού (μπάρας πλοήγησης), και του υπολοίπου της μπάρας δυναμικού μονοπατιού.';
$string['activitiesheading'] = 'Δραστηριότητες';
$string['alertaccess'] = 'Ορατότητα συναγερμικής ειδοποίησης';
$string['alertaccessadmins'] = 'Ορατό σε διαχειριστές';
$string['alertaccessglobal'] = 'Ορατό σε οποιονδήποτε';
$string['alertaccessprofile'] = 'Προσθήκη περιορισμού προσαρμοσμένου πεδίου προφίλ';
$string['alertaccessusers'] = 'Ορατό σε συνδεδεμένους χρήστες';
$string['alertannounce'] = 'Ανακοίνωση';
$string['alertannouncedesc'] = 'Εμφάνιση μιας ανακοίνωσης στο κουτί συναγερμικών ειδοποιήσεων.';
$string['alertbackgroundcolorinfo'] = 'Χρώμα υπόβαθρου πληροφοριών';
$string['alertbackgroundcolorinfodesc'] = 'Χρώμα υπόβαθρου των κουτιών συναγερμικών ειδοποιήσεων τύπου πληροφόρησης';
$string['alertbackgroundcolorsuccess'] = 'Χρώμα υπόβαθρου ανακοίνωσης';
$string['alertbackgroundcolorsuccessdesc'] = 'Χρώμα υπόβαθρου των κουτιών συναγερμικών ειδοποιήσεων τύπου ανακοίνωσης';
$string['alertbackgroundcolorwarning'] = 'Χρώμα υπόβαθρου προειδοποίησης';
$string['alertbackgroundcolorwarningdesc'] = 'Χρώμα υπόβαθρου των κουτιών συναγερμικής ειδοποίησης τύπου προειδοποίησης';
$string['alertbordercolorinfo'] = 'Χρώμα περιγράμματος πληροφοριών';
$string['alertbordercolorinfodesc'] = 'Χρώμα περιγράμματος των κουτιών συναγερμικής ειδοποίησης τύπου πληροφόρησης';
$string['alertbordercolorsuccess'] = 'Χρώμα περιγράμματος ανακοίνωσης';
$string['alertbordercolorsuccessdesc'] = 'Χρώμα περιγράμματος των κουτιών συναγερμικής ειδοποίησης τύπου ανακοίνωσης';
$string['alertbordercolorwarning'] = 'Χρώμα περιγράμματος προειδοποίησης';
$string['alertbordercolorwarningdesc'] = 'Χρώμα περιγράμματος των κουτιών συναγερμικής ειδοποίησης τύπου προειδοποίησης';
$string['alertcolorinfo'] = 'Χρώμα πληροφοριών';
$string['alertcolorinfodesc'] = 'Χρώμα εικονιδίου των κουτιών συναγερμικής ειδοποίησης τύπου πληροφόρησης';
$string['alertcolorsheading'] = 'Προσαρμογή των κουτιών συναγερμικής ειδοποίησης στην κορυφή';
$string['alertcolorsheadingdesc'] = 'Ορισμός χρωμάτων και εικονιδίου.';
$string['alertcolorsuccess'] = 'Χρώμα ανακοίνωσης';
$string['alertcolorsuccessdesc'] = 'Χρώμα εικονιδίου των κουτιών συναγερμικής ειδοποίησης τύπου ανακοίνωσης';
$string['alertcolorwarning'] = 'Χρώμα προειδοποίησης';
$string['alertcolorwarningdesc'] = 'Χρώμα εικονιδίου των κουτιών συναγερμικής ειδοποίησης τύπου ανακοίνωσης';
$string['alertcount'] = 'Πλήθος συναγερμικών ειδοποιήσεων';
$string['alertcountdesc'] = 'Ο αριθμός των συναγερμικών ειδοποιήσεων προς εμφάνιση στην περιοχή επεξεργασίας παρακάτω.';
$string['alertdisabled'] = 'Απενεργοποίηση';
$string['alertdisabledesc'] = 'Απενεργοποίηση αυτής της συναγερμικής ειδοποίησης.';
$string['alerthiddencourse'] = 'Προειδοποίηση μαθήματος σε απόκρυψη';
$string['alerthiddencoursedesc'] = 'Εμφάνιση συναγερμικής ειδοποίησης σε σελίδα μαθήματος αν είναι σε απόκρυψη';
$string['alerthiddencoursetext-1'] = 'Το μάθημα αυτό είναι σε απόκρυψη και οι μαθητές δεν έχουν πρόσβαση.';
$string['alerthiddencoursetext-2'] = 'Κάντε κλικ εδώ για ενημέρωση ρυθμίσεων';
$string['alerticoninfo'] = 'Εικονίδιο πληροφοριών';
$string['alerticonsuccess'] = 'Εικονίδιο ανακοίνωσης';
$string['alerticonwarning'] = 'Εικονίδιο προειδοποίησης';
$string['alertinfo'] = 'Πληροφορίες';
$string['alertinfodesc'] = 'Εμφάνιση πληροφοριών στο κουτί συναγερμικών ειδοποιήσεων.';
$string['alertkeyvalue'] = 'Κλειδί συναγερμικής ειδοποίησης';
$string['alertsettings'] = 'Κουτί συναγερμικής ειδοποίησης {$a}';
$string['alertsettingscourse'] = 'Ρυθμίσεις συναγερμικής ειδοποίησης μαθήματος';
$string['alertsettingsgeneral'] = 'Γενικές ρυθμίσεις συναγερμικής ειδοποίησης';
$string['alerttext'] = 'Κείμενο συναγερμικής ειδοποίησης';
$string['alerttextdesc'] = 'Δώστε το κείμενο προς εμφάνιση στο κουτί συναγερμικών ειδοποιήσεων';
$string['alerttype'] = 'Τύπος κουτιού συναγερμικής ειδοποίησης';
$string['alertwarning'] = 'Προειδοποίηση';
$string['alertwarningdesc'] = 'Εμφάνιση μιας προειδοποίησης στο κουτί συναγερμικών ειδοποιήσεων.';
$string['analyticscount'] = 'Πλήθος αναλυτικών';
$string['analyticscountdesc'] = 'Ο αριθμός των πεδίων αναλυτικής που θα εμφανίζονται στην περιοχή επεξεργασίας παρακάτω.';
$string['analyticsprofilefield'] = 'Όνομα προσαρμοσμένου πεδίου προφίλ=Τιμή (προαιρετικά)';
$string['analyticssettings'] = 'Αναλυτική';
$string['analyticstext'] = 'Αναγνωριστικό Αναλυτικής';
$string['analyticstextdesc'] = 'Δώστε αναγνωριστικό Αναλυτικών Google';
$string['anonymizega'] = 'Ανωνυμοποίηση της IP διεύθυνσης του χρήστη';
$string['anonymizegadesc'] = 'Ανωνυμοποίηση της διεύθυνσης IP του χρήστη που αποστέλλεται στο Google Analytics';
$string['answered'] = 'Απαντήθηκε';
$string['attempted'] = 'Έγινε προσπάθεια';
$string['backcolor'] = 'Χρώμα υπόβαθρου';
$string['backcolordesc'] = 'Ορισμός χρώματος υπόβαθρου.';
$string['bcustyle'] = 'Στυλ BCU';
$string['beta'] = 'ΕΚΔΟΣΗ ΑΝΑΠΤΥΞΗΣ. ΝΑ ΜΗΝ ΧΡΗΣΙΜΟΠΟΙΕΙΤΑΙ ΣΕ ΧΩΡΟΥΣ ΠΑΡΑΓΩΓΗΣ.';
$string['blockbackgroundcolor'] = 'Χρώμα υπόβαθρου μπλοκ';
$string['blockbackgroundcolordesc'] = 'Ορισμός χρώματος υπόβαθρου για όλα τα μπλοκ.';
$string['blockbordercolor'] = 'Χρώμα περιγράμματος μπλοκ';
$string['blockbordercolordesc'] = 'Ορισμός χρώματος περιγράμματος μπλοκ';
$string['blocklayoutbuilder'] = 'Περιοχές μπλοκ αρχικής σελίδας';
$string['blocklayoutbuilderdesc'] = 'Παρακάτω μπορείτε να δημιουργήσετε τη δική σας διάταξη για τις περιοχές μπλοκ στην πρώτη σελίδα.<br/>
Για να προσθέσετε περιεχόμενο σε αυτές τις περιοχές, θα χρειαστεί να <strong> ενεργοποιήσετε την επεξεργασία στην πρώτη σελίδα του Moodle</strong>.<br/>
Στη συνέχεια, μπορείτε να αρχίσετε να σύρετε / αποθέσετε μπλοκ στις περιοχές που δημιουργείτε!';
$string['blocklayoutlayoutcheck'] = 'Έλεγχος διάταξης';
$string['blocksettings'] = 'Ρυθμίσεις μπλοκ';
$string['breadcrumb'] = 'Δυναμικό μονοπάτι';
$string['breadcrumbbackgroundcolor'] = 'Χρώμα υπόβαθρου δυναμικού μονοπατιού';
$string['breadcrumbbackgroundcolordesc'] = 'Ορισμός του χρώματος υπόβαθρου του δυναμικού μονοπατιού (μπάρας πλοήγησης).';
$string['breadcrumbdisplay'] = 'Εμφάνιση δυναμικού μονοπατιού';
$string['breadcrumbdisplaydesc'] = 'Ορισμός της εμφάνισης του τι θα πρέπει να βρίσκεται στην περιοχή δυναμικού μονοπατιού (μπάρας πλοήγησης) σε ένα μάθημα.';
$string['breadcrumbhome'] = 'Αρχική σελίδα δυναμικού μονοπατιού';
$string['breadcrumbhomedesc'] = 'Εμφάνιση δυναμικού μονοπατιού (μπάρας πλοήγησης) αρχικής σελίδας ως εικονίδιο ή ως κείμενο.';
$string['breadcrumbhomeicon'] = 'Εικονίδιο';
$string['breadcrumbhometext'] = 'Κείμενο';
$string['breadcrumbseparator'] = 'Διαχωριστικό του δυναμικού μονοπατιού (μπάρας πλοήγησης)';
$string['breadcrumbtextcolor'] = 'Χρώμα κειμένου του δυναμικού μονοπατιού (μπάρας πλοήγησης)';
$string['breadcrumbtextcolordesc'] = 'Ορισμός του χρώματος κειμένου του δυναμικού μονοπατιού (μπάρας πλοήγησης).';
$string['breadcrumbtitle'] = 'Όνομα μαθήματος του δυναμικού μονοπατιού (μπάρας πλοήγησης)';
$string['breadcrumbtitledesc'] = 'Ορισμός της κατάστασης λειτουργίας εμφάνισης του τίτλου του μαθήματος στο δυναμικό μονοπάτι (μπάρας πλοήγησης).';
$string['bs4all'] = 'Πολύ μικρό - Πολύ μεγάλο';
$string['bs4extralarge'] = 'Μόνο πολύ μεγάλο';
$string['bs4large'] = 'Μεγάλο - Πολύ μεγάλο';
$string['bs4medium'] = 'Μεσαίο - Πολύ μεγάλο';
$string['bs4none'] = 'Κανένα';
$string['bs4small'] = 'Μικρό - Πολύ μεγάλο';
$string['buttoncancelbackgroundcolor'] = 'Χρώμα υπόβαθρου για το πλήκτρο «Άκυρο»';
$string['buttoncancelbackgroundcolordesc'] = 'Χρώμα υπόβαθρου για το πλήκτρο «Άκυρο». Πληκτρολογήστε <i>διαφανές</i> στο πλαίσιο για διαφάνεια.';
$string['buttoncancelcolor'] = 'Χρώμα πλήκτρου «Άκυρο»';
$string['buttoncolor'] = 'Χρώμα πλήκτρου';
$string['buttoncolorcancel'] = 'Ακύρωση χρώματος πλήκτρου';
$string['buttoncolordesc'] = 'Το χρώμα των κύριων πλήκτρων που χρησιμοποιούνται σε όλο τον ιστότοπο.';
$string['buttoncolordesccancel'] = 'Χρώμα υπόβαθρου για το πλήκτρο ακύρωσης.<br />Πληκτρολογήστε transparent στο πλαίσιο για διαφάνεια.';
$string['buttoncolordescscnd'] = 'Το χρώμα των δευτερευόντων πλήκτρων που χρησιμοποιούνται σε ολόκληρο τον ιστότοπο.';
$string['buttoncolorscnd'] = 'Χρώμα δευτερευόντων πλήκτρων';
$string['buttondesc'] = 'Μεταβολή της εμφάνισης των κουμπιών που χρησιμοποιούνται σε αυτό το αισθητικό θέμα.';
$string['buttondropshadow'] = 'Να πέφτει μια διακοσμητική σκιά στη βάση του πλήκτρου';
$string['buttondropshadowdesc'] = 'Εμφάνιση της διακοσμητικής σκιάς (σκίασης) στη βάση του πλήκτρου.';
$string['buttonhovercolor'] = 'Χρώμα πλήκτρου (κατά την αιώρηση)';
$string['buttonhovercolorcancel'] = 'Χρώμα πλήκτρου ακύρωσης (κατά την αιώρηση)';
$string['buttonhovercolordesc'] = 'Το χρώμα το οποίο παίρνει το πλήκτρο όταν το βελάκι του ποντικιού περνάει (αιωρείται) πάνω από το πλήκτρο.';
$string['buttonhovercolordesccancel'] = 'Το χρώμα το οποίο παίρνει το πλήκτρο ακύρωσης όταν το βελάκι του ποντικιού περνάει (αιωρείται) πάνω από το πλήκτρο. <br />Πληκτρολογήστε transparent στο πλαίσιο για διαφάνεια.';
$string['buttonlogincolor'] = 'Χρώμα πλήκτρου σύνδεσης';
$string['buttonlogincolordesc'] = 'Το χρώμα του πλήκτρου σύνδεσης.';
$string['buttonsettings'] = 'Πλήκτρα';
$string['buttonsettingsheading'] = 'Προσαρμογή των πλήκτρων αυτού του αισθητικού θέματος.';
$string['buttontextcolor'] = 'Χρώμα κειμένου πλήκτρου';
$string['buttontextcolordesc'] = 'Το χρώμα του κειμένου που χρησιμοποιείται στα πλήκτρα';
$string['colorsettings'] = 'Χρώματα';
$string['configtitle'] = 'Προσαρμόσιμο';
$string['contributed'] = 'Συνεισφερόμενο';
$string['course'] = 'Μάθημα';
$string['courses'] = 'Μαθήματα';
$string['coursesettings'] = 'Μορφότυποι μαθήματος';
$string['coursesettingsheading'] = 'Ρυθμίσεις μορφότυπων μαθήματος';
$string['coursetitlefullname'] = 'Πλήρες όνομα μαθήματος';
$string['coursetitlemaxwidth'] = 'Μέγιστο μήκος τίτλου μαθήματος';
$string['customcss'] = 'Προσαρμοσμένο CSS';
$string['customcssdesc'] = 'Οποιουσδήποτε κανόνες CSS προσθέτετε σε αυτή την περιοχή κειμένου, θα αντικατοπτρίζονται σε κάθε σελίδα, διευκολύνοντας έτσι την προσαρμογή αυτού του αισθητικού θέματος.';
$string['customcssjssettings'] = 'Προσαρμοσμένα CSS & JS';
$string['customfontheadername'] = 'Προσαρμοσμένη γραμματοσειρά κεφαλίδας';
$string['customfontname'] = 'Προσαρμοσμένη κύρια γραμματοσειρά';
$string['customfonttitlename'] = 'Προσαρμοσμένη γραμματοσειρά τίτλου';
$string['dashblocklayoutbuilder'] = 'Περιοχές Μπλοκ Ταμπλό';
$string['dashblocklayoutbuilderdesc'] = 'Παρακάτω μπορείτε να δημιουργήσετε τη δική σας διάταξη για τις περιοχές μπλοκ στη σελίδα του Ταμπλό.
Για να προσθέσετε περιεχόμενο σε αυτές τις περιοχές, θα χρειαστεί να <strong>ενεργοποιήσετε την επεξεργασία, στη σελίδα του ταμπλό του Moodle</strong>.
Στη συνέχεια, μπορείτε να αρχίσετε να μεταφέρετε/αποθέσετε μπλοκ στις περιοχές που δημιουργείτε!';
$string['dashblocklayoutlayoutrow'] = 'Γραμμή Περιοχής Μπλοκ Ταμπλό';
$string['dashblocklayoutlayoutrowdesc'] = 'Προσθήκη / ορισμός διάταξης για τη γραμμή περιοχής μπλοκ στη σελίδα του Ταμπλό.';
$string['dashblocksabovecontent'] = 'Εμφάνιση πάνω από το κύριο περιεχόμενο';
$string['dashblocksbelowcontent'] = 'Εμφάνιση κάτω από το κύριο περιεχόμενο';
$string['dashblocksenabled'] = 'Ενεργοποίηση περιοχής προσαρμοσμένου μπλοκ στη σελίδα του Ταμπλό';
$string['dashblocksenableddesc'] = 'Μπορείτε να ενεργοποιήσετε / απενεργοποιήσετε περιοχές προσαρμοσμένου μπλοκ στη σελίδα του Ταμπλό.
Μπορείτε να μεταφέρετε και να αποθέσετε μπλοκ στις περιοχές που δημιουργήσατε.';
$string['dashboardblockregionsettings'] = 'Δόμηση Περιοχής Μπλοκ Ταμπλό';
$string['deprecated'] = 'ΠΑΡΩΧΗΜΕΝΗ ΕΚΔΟΣΗ MOODLE. ΜΗ ΧΡΗΣΙΜΟΠΟΙΕΙΤΕ ΤΟ ΠΡΟΣΘΕΤΟ ADAPTABLE ΣΕ ΑΥΤΌ ΤΟΝ ΙΣΤΟΤΟΠΟ.';
$string['disabled'] = 'Ανενεργό';
$string['disablemenuscoursepagesdesc'] = 'Η ενεργοποίηση αυτής της επιλογής θα περιορίσει την εμφάνιση των κορυφαίων μενού στις σελίδες του ιστοτόπου, στην αρχική σελίδα και στο ταμπλό (Αρχική Σελίδα Μου) κλπ. και δεν θα εμφανίζονται σε σελίδες μαθημάτων';
$string['discardbuttontext'] = 'Άκυρο';
$string['displaygrades'] = 'Εμφάνιση βαθμών';
$string['displaygradesdesc'] = 'Εμφάνιση του στοιχείου βαθμοί στο μενού';
$string['displaylogin'] = 'Εμφάνιση σύνδεσης';
$string['displayloginbox'] = 'Κουτί σύνδεσης';
$string['displayloginbutton'] = 'Πλήκτρο';
$string['displaylogindesc'] = 'Επιλέξτε πως να εμφανίζεται το πλαίσιο σύνδεσης στην επικεφαλίδα.';
$string['displayloginno'] = 'Χωρίς πλαίσιο σύνδεσης';
$string['displayparticipants'] = 'Εμφάνιση συμμετεχόντων';
$string['displayparticipantsdesc'] = 'Εμφάνιση του στοιχείου συμμετέχοντες στο μενού';
$string['dividingline'] = 'Διαχωρίζουσα γραμμή στην επικεφαλίδα';
$string['dividingline2'] = 'Διαχωρίζουσα γραμμή στο υποσέλιδο';
$string['dividingline2desc'] = 'Το χρώμα για την διαχωρίζουσα γραμμή στο υποσέλιδο';
$string['dividinglinedesc'] = 'Το χρώμα για την διαχωρίζουσα γραμμή στην επικεφαλίδα';
$string['draft'] = 'Χωρίς δημοσίευση στους μαθητές';
$string['due'] = 'Οφείλεται {$a}';
$string['emoticonsize'] = 'Μέγεθος φατσούλας';
$string['emoticonsizedesc'] = 'Ορισμός του ύψους και του πλάτους της φατσούλας Moodle.';
$string['enablealert'] = 'Ενεργοποίηση κουτιού συναγερμικών ειδοποιήσεων {$a}';
$string['enablealertcoursepages'] = 'Ενεργοποίηση κουτιού συναγερμικών ειδοποιήσεων στις σελίδες μαθήματος';
$string['enablealertdesc'] = 'Ενεργοποίηση κουτιού συναγερμικών ειδοποιήσεων {$a}';
$string['enablealerts'] = 'Ενεργοποίηση/Απενεργοποίηση συναγερμικών ειδοποιήσεων';
$string['enablealertsdesc'] = 'Ενεργοποίηση/απενεργοποίηση συναγερμικών ειδοποιήσεων στον ιστότοπό σας';
$string['enablealertstriptags'] = 'Αφαιρέστε αυτόματα τις ετικέτες html από τις συναγερμικές ειδοποιήσεις';
$string['enableanalytics'] = 'Ενεργοποίηση αναλυτικής Google';
$string['enableanalyticsdesc'] = 'Ενεργοποίηση ρυθμίσεων αναλυτικών Google στον ιστότοπό σας';
$string['enablebadges'] = 'Διακριτικά';
$string['enableblog'] = 'Ενεργοποίησε Τα Ιστολόγιά μου';
$string['enableblogdesc'] = 'Εμφάνισε ένα σύνδεσμο προς την σελίδα ιστολογίων του χρήστη';
$string['enablegrades'] = 'Βαθμοί';
$string['enablehomeredirectdesc'] = 'Ενεργοποίηση ανακατεύθυνσης redirect= 0 στην αρχική σελίδα. Αυτό προορίζεται για χρήση σε ιστοτόπους όπου η Αρχική Σελίδα είναι η προεπιλεγμένη αρχική σελίδα. Αποτρέπει την ανακατεύθυνση των χρηστών που πατάνε στο σύνδεσμο «Αρχική Σελίδα» πίσω στην Αρχική Σελίδα / Ταμπλό';
$string['enablemy'] = 'Ταμπλό';
$string['enablemydesc'] = 'Εμφάνιση ενός συνδέσμου στην σελίδα του Ταμπλό';
$string['enablemyhomedesc'] = 'Εμφάνιση ενός συνδέσμου στο {$a}';
$string['enablemysitesdesc'] = 'Εμφάνιση μιας πτυσσόμενης λίστας με τα μαθήματα ενός χρήστη';
$string['enablenote'] = 'Οι Ειδοποιήσεις μου';
$string['enablenotedesc'] = 'Εμφάνιση ενός συνδέσμου προς την σελίδα ειδοποιήσεων χρήστη';
$string['enableposts'] = 'Οι αναρτήσεις μου';
$string['enablepostsdesc'] = 'Εμφάνιση ενός συνδέσμου προς την σελίδα των δικών μου αναρτήσεων χρήστη';
$string['enablepref'] = 'Οι Προτιμήσεις μου';
$string['enableprivatefiles'] = 'Ιδιωτικά αρχεία';
$string['enableprofile'] = 'Προφίλ χρήστη';
$string['enableprofiledesc'] = 'Εμφάνιση ενός συνδέσμου προς το προφίλ χρήστη';
$string['enableshowhideblocks'] = 'Ενεργοποίηση Εμφάνιση/Απόκρυψη μπλοκ';
$string['enableshowhideblocksdesc'] = 'Επιτρέπει στους χρήστες να εμφανίζουν/αποκρύπτουν όλα τα μπλοκ.';
$string['enabletickermy'] = 'Ενεργοποίηση της στήλης ειδήσεων στην Αρχική Σελίδα / Ταμπλό;';
$string['enabletickermydesc'] = 'Επιλέξτε για να ενεργοποιήσετε τη στήλη ειδήσεων στην Αρχική Σελίδα / Ταμπλό.';
$string['events'] = 'Γεγονότα';
$string['expandable'] = 'Αναπτύξιμος';
$string['favicon'] = 'Αγαπ.εικονίδιο';
$string['favicondesc'] = 'Ανέβασμα αγαπ.εικονιδίου για χρήση στον ιστότοπό σας.';
$string['feedbackavailable'] = 'Διαθέσιμη ανατροφοδότηση';
$string['fontblockheadercolor'] = 'Χρώμα γραμματοσειράς επικεφαλίδας μπλοκ';
$string['fontblockheadercolordesc'] = 'Ορισμός του χρώματος των γραμματοσειρών μπλοκ επικεφαλίδων Moodle. Χρησιμοποιήστε δεκαεξαδικό κώδικα χρωμάτων HTML. Σημειώστε ότι αυτό επηρεάζει επίσης το χρώμα εικονιδίου.';
$string['fontblockheadersize'] = 'Μέγεθος γραμματοσειράς επικεφαλίδας μπλοκ';
$string['fontblockheaderweight'] = 'Βαρύτητα γραμματοσειράς επικεφαλίδας μπλοκ';
$string['fontcolor'] = 'Κυρίως χρώμα γραμματοσειράς';
$string['fontcolordesc'] = 'Ορισμός του χρώματος της γραμματοσειράς στο αισθητικό θέμα. Χρησιμοποιήστε δεκαεξαδικό κώδικα χρωμάτων HTML.';
$string['fontheadercolor'] = 'Χρώμα γραμματοσειράς επικεφαλίδων';
$string['fontheadercolordesc'] = 'Ορισμός του χρώματος της γραμματοσειράς επικεφαλίδων στο αισθητικό θέμα. Χρησιμοποιήστε δεκαεξαδικό κώδικα χρωμάτων HTML.';
$string['fontheadername'] = 'Γραμματοσειρά επικεφαλίδων';
$string['fontname'] = 'Κύρια γραμματοσειρά';
$string['fontsettings'] = 'Γραμματοσειρές';
$string['fontsize'] = 'Μέγεθος κύριας γραμματοσειράς';
$string['fonttitlecolorcoursedesc'] = 'Ορισμός του χρώματος της γραμματοσειράς τίτλου μαθήματος στο αισθητικό θέμα. Χρησιμοποιήστε δεκαεξαδικό κώδικα χρωμάτων HTML.';
$string['fonttitlecolordesc'] = 'Ορισμός του χρώματος γραμματοσειράς του τίτλου ιστοτόπου και του τίτλου μαθήματος, στο αισθητικό θέμα. Χρησιμοποιήστε δεκαεξαδικό κώδικα χρωμάτων HTML.';
$string['fonttitlename'] = 'Γραμματοσειρά τίτλου ιστοτόπου/μαθήματος';
$string['fonttitlesize'] = 'Μέγεθος γραμματοσειράς τίτλου ιστοτόπου/μαθήματος';
$string['footerbkcolor'] = 'Χρώμα υπόβαθρου υποσέλιδου';
$string['footerbkcolordesc'] = 'Ορισμός του χρώματος υπόβαθρου υποσέλιδου';
$string['footerblocksplacement1'] = 'Σε όλο τον ιστότοπο';
$string['footerblocksplacement2'] = 'Μόνο αρχική σελίδα';
$string['footerblocksplacement3'] = 'Ποτέ';
$string['footercontent'] = 'Τμήμα περιεχομένου υποσέλιδου';
$string['footercontentdesc'] = 'Προσθήκη περιεχομένου στο τμήμα υποσέλιδου';
$string['footerdesc'] = 'Προσθήκη ενός τίτλου για το τμήμα υποσέλιδου';
$string['footerheader'] = 'Τίτλος τμήματος υποσέλιδου';
$string['footerlinkcolor'] = 'Χρώμα συνδέσμου μπλοκ υποσέλιδου';
$string['footerlinkcolordesc'] = 'Χρώμα συνδέσμου μπλοκ υποσέλιδου.';
$string['footersettings'] = 'Υποσέλιδο';
$string['footertextcolor'] = 'Χρώμα κειμένου υποσέλιδου';
$string['footertextcolordesc'] = 'Το χρώμα του κειμένου στο υποσέλιδο. Χρησιμοποιήστε δεκαεξαδικό κώδικα χρωμάτων HTML.';
$string['footnote'] = 'Υποσημείωση';
$string['footnotedesc'] = 'Προσθήκη κειμένου στο υποσέλιδο';
$string['forumheaderbackgroundcolordesc'] = 'Χρώμα υπόβαθρου για ανάρτηση σε φόρουμ';
$string['frnt-footer'] = 'Τα μπλοκ σε αυτή την περιοχή θα είναι ορατά μόνο σε διαχειριστές';
$string['frontpagealertsettings'] = 'Κουτί συναγερμικής ειδοποίησης';
$string['frontpageblocksenableddesc'] = 'Μπορείτε να ενεργοποιήσετε / απενεργοποιήσετε περιοχές προσαρμοσμένων μπλοκ στην πρώτη σελίδα.
Μπορείτε να μεταφέρετε και να αποθέσετε μπλοκ στις περιοχές που δημιουργήσατε.';
$string['frontpagecoursesettings'] = 'Λίστα μαθημάτων αρχικής σελίδας';
$string['frontpagerenderer'] = 'Πλαίσια μαθημάτων αρχικής σελίδας';
$string['frontpagerendererdefaultimage'] = 'Προεπιλεγμένη εικόνα μαθήματος';
$string['frontpagerendereroption1'] = 'Πλακίδια';
$string['frontpagerendereroption2'] = 'Πλακίδια με επικάλυψη';
$string['frontpagerendereroption3'] = 'Προεπιλογή Moodle';
$string['frontpagesettingsheading'] = 'Απόδοση αρχικής σελίδας';
$string['frontpagetiles1'] = '1 πλακίδιο';
$string['frontpagetiles2'] = '2 πλακίδια';
$string['frontpagetiles3'] = '3 πλακίδια';
$string['frontpagetiles4'] = '4 πλακίδια';
$string['frontpagetiles6'] = '6 πλακίδια';
$string['fullscreenwidth'] = 'Πλάτος πλήρους οθόνης.';
$string['headerbgimage'] = 'Εικόνα υπόβαθρου';
$string['headersettings'] = 'Επικεφαλίδα';
$string['help'] = 'Βοήθεια';
$string['helptitle'] = 'Βοήθεια';
$string['hide'] = 'Απόκρυψη';
$string['hidefootersocial'] = 'Εμφάνιση κοινωνικών δικτύων';
$string['hideinforum'] = 'Απόκρυψη βοήθειας και εργαλείων στα φόρουμ';
$string['home'] = 'Αρχική';
$string['homebk'] = 'Εικόνα υπόβαθρου αρχικής σελίδας';
$string['homebkdesc'] = 'Ανέβασμα μιας εικόνας που θα γίνει η εικόνα υπόβαθρου στην αρχική σελίδα.';
$string['infobox'] = 'Πλαίσιο πληροφοριών αρχικής σελίδας';
$string['infobox2'] = 'Πλαίσιο δευτερευόντων πληροφοριών αρχικής σελίδας';
$string['infoiconcolor'] = 'Χρώμα εικονιδίου βοήθειας';
$string['infoiconcolordesc'] = 'Ορισμός του χρώματος εικονιδίου πληροφοριών/βοήθειας που χρησιμοποιείται από τις αναδυόμενες συμβουλές εργαλείου.';
$string['jssection'] = 'Τμήμα Javascript';
$string['jssectiondesc'] = 'Προσθήκη κώδικα javascript στον ιστότοπο.';
$string['jssectionrestricteddashboardonly'] = 'Συμπερίληψη Javascript μόνο στη σελίδα του ταμπλό';
$string['jssectionrestricteddashboardonlydesc'] = 'Εμφάνιση javascript μόνο στη σελίδα του ταμπλό. Διαφορετικά, εμφανίζεται σε ολόκληρο τον ιστότοπο.';
$string['jumpto'] = 'Μεταπήδηση σε...';
$string['layoutaddcontentdesc1'] = 'Έχετε ρυθμίσει';
$string['layoutcheck'] = 'Έλεγχος της διάταξής σας';
$string['layoutcount1'] = 'Μπορείτε να ορίσετε ένα μέγιστο από';
$string['layoutcount2'] = 'περιοχές μπλοκ. Χρησιμοποιείτε αυτή τη στιγμή:';
$string['layoutdesc'] = 'Ορίστε την προεπιλεγμένη διάταξη που βλέπουν οι χρήστες.';
$string['layoutmobilesettings'] = 'Ρυθμίσεις κινητών';
$string['layoutmobilesettingsdesc'] = 'Τροποποίηση ρυθμίσεων για κινητές συσκευές';
$string['layoutsettings'] = 'Διάταξη';
$string['leftblocks'] = 'Αριστερή πλευρά';
$string['linkcolor'] = 'Χρώμα συνδέσμου';
$string['linkcolordesc'] = 'Ορισμός του χρώματος συνδέσμων, στο αισθητικό θέμα. Χρησιμοποιήστε δεκαεξαδικό κώδικα χρωμάτων HTML.';
$string['linkhover'] = 'Χρώμα αιώρησης συνδέσμου';
$string['linkhoverdesc'] = 'Ορισμός του χρώματος συνδέσμων (κατά την αιώρηση), στο αισθητικό θέμα. Χρησιμοποιήστε δεκαεξαδικό κώδικα χρωμάτων HTML.';
$string['linksmenu'] = 'Μενού συνδέσμων';
$string['loadingcolor'] = 'Φόρτωση χρώματος';
$string['loginbgimage'] = 'Εικόνα υπόβαθρου';
$string['loginbgimagedesc'] = 'Προσθήκη μιας εικόνας υπόβαθρου στην σελίδα πλήρους μεγέθους.';
$string['logindesc'] = 'Προσαρμογή της σελίδας σύνδεσης προσθέτοντας μια εικόνα υπόβαθρου και κείμενα πάνω και κάτω από το πλαίσιο σύνδεσης.';
$string['loginplaceholder'] = 'Όνομα χρήστη';
$string['logo'] = 'Λογότυπο';
$string['menusdesc'] = '';
$string['mobilesettings'] = 'Ρυθμίσεις κινητών';
$string['myblogs'] = 'Τα Ιστολόγιά μου';
$string['mysites'] = 'Τα Μαθήματά μου';
$string['mysitesdisabled'] = 'Απενεργοποίηση';
$string['mysitessortoverrideprofilefieldscohort'] = 'Εμφάνιση μαθημάτων που βρέθηκαν σε πεδία προφίλ + σύνολα χρηστών στην πρώτη λίστα, οι άλλες στο υπομενού';
$string['passwordplaceholder'] = 'Κωδικός πρόσβασης';
$string['people'] = 'Συμμετέχοντες';
$string['piwikenabled'] = 'Ενεργοποιημένο';
$string['propertiesproperty'] = 'Ιδιότητα';
$string['propertiesreturn'] = 'Επιστροφή';
$string['propertiessub'] = 'Ρυθμίσεις τρέχοντος αισθητικού θέματος';
$string['propertiesvalue'] = 'Τιμή';
$string['putpropertiesadded'] = 'Προστέθηκε:';
$string['putpropertieschanged'] = 'Άλλαξε:';
$string['putpropertiesfrom'] = 'από';
$string['putpropertiesheading'] = 'Εισαγωγή ρυθμίσεων αισθητικού θέματος';
$string['putpropertiesvalue'] = '->';
$string['putpropertyproperties'] = 'Ιδιότητες';
$string['putpropertyreport'] = 'Αναφορά:';
$string['putpropertyversion'] = 'έκδοση:';
$string['region-frnt-footer'] = 'Υποσέλιδο';
$string['region-frnt-market-a'] = 'Περιοχή 1 σελίδας';
$string['region-frnt-market-b'] = 'Περιοχή 2 σελίδας';
$string['region-frnt-market-c'] = 'Περιοχή 3 σελίδας';
$string['region-frnt-market-d'] = 'Περιοχή 4 σελίδας';
$string['region-frnt-market-e'] = 'Περιοχή 5 σελίδας';
$string['region-frnt-market-f'] = 'Περιοχή 6 σελίδας';
$string['region-frnt-market-g'] = 'Περιοχή 7 σελίδας';
$string['region-frnt-market-h'] = 'Περιοχή 8 σελίδας';
$string['region-frnt-market-i'] = 'Περιοχή 9 σελίδας';
$string['region-frnt-market-j'] = 'Περιοχή 10 σελίδας';
$string['region-frnt-market-k'] = 'Περιοχή 11 σελίδας';
$string['region-frnt-market-l'] = 'Περιοχή 12 σελίδας';
$string['region-frnt-market-m'] = 'Περιοχή 13 σελίδας';
$string['region-frnt-market-n'] = 'Περιοχή 14 σελίδας';
$string['region-frnt-market-o'] = 'Περιοχή 15 σελίδας';
$string['region-frnt-market-p'] = 'Περιοχή 16 σελίδας';
$string['region-frnt-market-q'] = 'Περιοχή 17 σελίδας';
$string['region-frnt-market-r'] = 'Περιοχή 18 σελίδας';
$string['region-frnt-market-s'] = 'Περιοχή 19 σελίδας';
$string['region-frnt-market-t'] = 'Περιοχή 20 σελίδας';
$string['regionmaincolor'] = 'Χρώμα κύριας περιοχής';
$string['regionmaincolordesc'] = 'Ορισμός του χρώματος υπόβαθρου για την κύρια περιοχή';
$string['region-middle'] = 'Μέση';
$string['region-my-tab-one-a'] = 'Περιοχή 1 καρτέλας σελίδας ταμπλό';
$string['region-my-tab-two-a'] = 'Περιοχή 2 καρτέλας σελίδας ταμπλό';
$string['region-side-post'] = 'Δεξιά';
$string['region-side-pre'] = 'Αριστερά';
$string['responsivecoursetitle'] = 'Τίτλος ιστοτόπου / μαθήματος';
$string['responsiveheader'] = 'Κύρια επικεφαλίδα';
$string['responsivelogo'] = 'Λογότυπο';
$string['responsivepagefooter'] = 'Υποσέλιδο';
$string['responsivesearchicon'] = 'Εμφάνιση εικονιδίου αναζήτησης';
$string['responsivesearchicondesc'] = 'Εμφάνιση εικονιδίου αναζήτησης σε συσκευές με μικρή οθόνη.';
$string['responsivesectionnav'] = 'Πλοήγηση δραστηριότητας / τμήματος';
$string['responsiveslider'] = 'Ολισθητήρας αρχικής σελίδας';
$string['responsivesocial'] = 'Εικονίδια κοινωνικών δικτύων';
$string['rightblocks'] = 'Δεξιά πλευρά';
$string['savebuttontext'] = 'Αποθήκευση αλλαγών';
$string['searchcourses'] = 'Αναζήτηση μαθημάτων';
$string['selectionbackground'] = 'Χρώμα υπόβαθρου επιλογής';
$string['selectiontext'] = 'Χρώμα κειμένου επιλογής';
$string['settingsanalytics'] = 'Αναλυτική';
$string['settingsblockicons'] = 'Εικονίδια';
$string['settingsborders'] = 'Περιθώρια';
$string['settingscolors'] = 'Χρώματα';
$string['settingsfonts'] = 'Γραμματοσειρές';
$string['settingsforumheading'] = 'Φόρουμ';
$string['show'] = 'Εμφάνιση';
$string['sitetitlecoursesenabled'] = 'Ενεργοποιημένο - εμφάνιση τίτλου ιστοτόπου και τίτλων μαθημάτων στις σελίδες μαθήματος';
$string['sliderimage'] = 'Εικόνα ολισθητήρα';
$string['slideshowdesc'] = 'Ανέβασμα των εικόνων και προσθήκη των συνδέσμων & της περιγραφής για την κυκλική εναλλαγή στην αρχική σελίδα.';
$string['slideshowsettings'] = 'Παρουσίαση διαφανειών';
$string['slideshowsettingsheading'] = 'Προσαρμογή της κυκλικής εναλλαγής εικόνων στην αρχική σελίδα. Δείτε τη διάταξη <a href="./../theme/adaptable/pix/layout.png" target="_blank">εδώ</a>';
$string['smallscreenhidebreadcrumb'] = 'Απόκρυψη πλοήγησης Beadcrumb';
$string['smallscreenhidebreadcrumbdesc'] = 'Απόκρυψη της πλοήγησης Beadcrumb σε συσκευές μικρής οθόνης.';
$string['smallscreenshowsearchicon'] = 'Εμφάνιση εικονιδίου αναζήτησης';
$string['smallscreenshowsearchicondesc'] = 'Εμφάνιση εικονιδίου αναζήτησης σε συσκευές μικρής οθόνης.';
$string['socialheading'] = 'Ρυθμίσεις κοινωνικών εικονιδίων';
$string['socialiconlist'] = 'Λίστα κοινωνικών εικονιδίων';
$string['socialorsearch'] = 'Χρήση πλαισίου αναζήτησης ή κοινωνικών εικονιδίων';
$string['socialorsearchnone'] = 'Κανένα';
$string['socialorsearchsocial'] = 'Εμφάνιση κοινωνικών εικονιδίων στην επικεφαλίδα';
$string['socialsize'] = 'Ορισμός του μεγέθους γραμματοσειράς στα κοινωνικά εικονίδια';
$string['socialtargetdesc'] = 'Πως θέλετε να ανοίγουν οι σύνδεσμοι κοινωνικών δικτύων (στο ίδιο ή σε νέο παράθυρο)';
$string['socialwallbackgroundcolor'] = 'Χρώμα υπόβαθρου';
$string['socialwallbordercolor'] = 'Χρώμα περιγράμματος';
$string['socialwallbordertopstyle'] = 'Στυλ περιγράμματος';
$string['socialwallborderwidth'] = 'Πλάτος περιγράμματος';
$string['standard'] = '1170εικονοστοιχεία';
$string['standardview'] = 'Τυπική εμφάνιση';
$string['static'] = 'Στατικό';
$string['stickynavbar'] = 'Αυτοκόλλητη μπάρα πλοήγησης στην κορυφή';
$string['stylecover'] = 'Εξώφυλλο';
$string['stylestretch'] = 'Παραμόρφωση';
$string['submitted'] = 'Υποβλήθηκε';
$string['tabbedlayoutcoursepage'] = 'Διάταξη με καρτέλες σελίδας μαθήματος';
$string['tabbedlayoutcoursepagelink'] = 'Σύνδεσμος μαθήματος διάταξης με καρτέλες σελίδας μαθήματος';
$string['tabbedlayoutcoursepagetabcolorselected'] = 'Επιλεγμένο χρώμα καρτέλας για σελίδα μαθήματος';
$string['tabbedlayoutcoursepagetabcolorselecteddesc'] = 'Επιλογή του χρώματος για την επιλεγμένη αυτή τη στιγμή καρτέλα.';
$string['tabbedlayoutcoursepagetabcolorunselecteddesc'] = 'Επιλογή του χρώματος για οποιαδήποτε άλλη καρτέλα.';
$string['tabbedlayoutdashboardtabcolorselected'] = 'Επιλεγμένο χρώμα καρτέλας για το Ταμπλό';
$string['tabbedlayoutdashboardtabcolorselecteddesc'] = 'Επιλογή του χρώματος για την επιλεγμένη αυτή τη στιγμή καρτέλα.';
$string['tabbedlayoutdashboardtabcolorunselected'] = 'Αποεπιλεγμένο χρώμα καρτέλας για το Ταμπλό';
$string['tabbedlayoutdashboardtabcolorunselecteddesc'] = 'Επιλογή του χρώματος για οποιαδήποτε άλλη καρτέλα.';
$string['tabbedlayoutheading'] = 'Προσαρμόσιμη διάταξη με καρτέλες';
$string['tabbedlayouttablabelcourse'] = 'Περιεχόμενο μαθήματος';
$string['tabbedlayouttablabelcourse1'] = 'Καρτέλα 1';
$string['tabbedlayouttablabelcourse2'] = 'Καρτέλα 2';
$string['tabbedlayouttablabeldashboard'] = 'Περιεχόμενο ταμπλό';
$string['tabbedlayouttablabeldashboard1'] = 'Καρτέλα 1';
$string['tabbedlayouttablabeldashboard2'] = 'Καρτέλα 2';
$string['targetnewwindow'] = 'Νέο παράθυρο';
$string['targetsamewindow'] = 'Ίδιο παράθυρο';
$string['thiscourse'] = 'Τρέχον μάθημα';
$string['ticker'] = 'Ανακοινώσεις';
$string['tickerdefault'] = 'Κανένα στοιχείο νέων προς εμφάνιση';
$string['tickerfullscreen'] = 'Πλάτος πλήρους οθόνης';
$string['tickertextprofilefield'] = 'Όνομα προσαρμοσμένου πεδίου προφίλ=Τιμή (προαιρετικά)';
$string['tickerwidth'] = 'Σταθερό πλάτος';
$string['tilesshowallcontacts'] = 'Εμφάνιση όλων των επαφών μαθήματος';
$string['tilesshowallcontactsdesc'] = 'Εμφάνιση όλων των επαφών μαθήματος ή μόνο μίας';
$string['tilesshowcontacts'] = 'Εμφάνιση επαφών μαθήματος';
$string['tilesshowcontactsdesc'] = 'Εμφάνιση/απόκρυψη επαφών μαθήματος';
$string['toolsmenudesc'] = 'Προσθήκη ενός πτυσσόμενου μενού στην κύρια μπάρα πλοήγησης';
$string['toolsmenufield'] = 'Προσαρμοσμένο πεδίο προφίλ Όνομα=Τιμή (προαιρετικά)';
$string['toolsmenuheading'] = 'Μενού εργαλείων';
$string['toolsmenulabel'] = 'Μενού εργαλείων';
$string['toolsmenulabel2'] = 'Εργαλεία 2';
$string['toolsmenuscount'] = 'Πλήθος μενού εργαλείων';
$string['toolsmenuscountdesc'] = 'Ορισμός του αριθμού των μενού εργαλείων που θέλετε να προσθέσετε στην κύρια μπάρα πλοήγησης';
$string['toolsmenutitle'] = 'Τίτλος μενού εργαλείων';
$string['toolsmenutitledefault'] = 'Εργαλεία';
$string['usermenu'] = 'Μενού χρήστη';
$string['usernameposition'] = 'Τοποθέτηση ονόματος χρήστη';
$string['usernamepositiondesc'] = 'Ορισμός της τοποθέτησης του ονόματος χρήστη, «Αριστερά» ή «Δεξιά».';
$string['usersettings'] = 'Προφίλ χρήστη';
$string['usersettingsdesc'] = 'Ορισμός ρυθμίσεων για το προφίλ χρήστη.';
$string['wide'] = 'Πλήρης οθόνη';
$string['xofyanswered'] = '{$a->completed} από {$a->participants} απαντήθηκαν';
$string['xofyattempted'] = '{$a->completed} από {$a->participants} προσπαθήθηκαν';
$string['xofysubmitted'] = '{$a->completed} από {$a->participants} υποβλήθηκαν';
