<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'el', branch 'MOODLE_37_STABLE'
 *
 * @package   bigbluebuttonbn
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Έχετε επερχόμενες συνόδους ιστοδιάσκεψης bigbluebuttonbn';
$string['bbbduetimeoverstartingtime'] = 'Η οφειλόμενη ημερομηνία για αυτή την δραστηριότητα πρέπει να είναι μετά την ημερομηνία έναρξης';
$string['bbbdurationwarning'] = 'Η μέγιστη διάρκεια αυτής της συνόδου είναι % duration% λεπτά.';
$string['bbbrecordallfromstartwarning'] = 'Η σύνοδος καταγράφεται από την έναρξη.';
$string['bbbrecordwarning'] = 'Αυτή η σύνοδος μπορεί να καταγράφεται.';
$string['bigbluebuttonbn'] = 'Ιστοδιάσκεψη BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Προσθήκη νέου δωματίου/δραστηριότητας ιστοδιάσκεψης bigbluebuttonbn';
$string['bigbluebuttonbn:join'] = 'Ένταξη σε μια συνάντηση ιστοδιάσκεψης bigbluebuttonbn';
$string['bigbluebuttonbn:managerecordings'] = 'Διαχείριση εγγραφών (ήχου/βίντεο) ιστοδιάσκεψης bigbluebuttonbn';
$string['bigbluebuttonbn:meeting'] = 'Δημιουργία στιγμιότυπων με δυνατότητες ζωντανών συναντήσεων';
$string['bigbluebuttonbn:recording'] = 'Δημιουργία στιγμιότυπων με δυνατότητες εγγραφών (ήχου/βίντεο)';
$string['bigbluebuttonbn:view'] = 'Εμφάνιση δωματίου/δραστηριότητας';
$string['calendarstarts'] = '{$a} προγραμματίστηκε για';
$string['config_clienttype'] = 'Ρυθμίσεις για τον τύπο «Web Client»';
$string['config_clienttype_default'] = 'Προεπιλεγμένος τύπος πελάτη Ιστού';
$string['config_clienttype_default_description'] = 'Επιλέξτε ανάμεσα στο κλασικό πρόγραμμα-πελάτη Adobe Flash ή στο νέο HTML5.';
$string['config_clienttype_description'] = 'Αυτή η ρύθμιση ενεργοποιεί/απενεργοποιεί την επιλογή του προγράμματος-πελάτη Ιστού για κάθε δωμάτιο.';
$string['config_clienttype_editable'] = 'Η επιλογή για πελάτη (λογισμικού) ιστού μπορεί να τροποποιηθεί';
$string['config_clienttype_editable_description'] = 'Αυτή η επιλογή ενεργοποιεί τη δυνατότητα του Web Client (AdobeFlash/HTML5) από τη φόρμα επεξεργασίας του δωματίου.';
$string['config_extended_capabilities'] = 'Ρυθμίσεις για προχωρημένες δυνατότητες';
$string['config_extended_capabilities_description'] = 'Ρυθμίσεις για προχωρημένες δυνατότητες όταν τις προσφέρει ο εξυπηρετητής του BigBlueButton';
$string['config_general'] = 'Γενικές ρυθμίσεις';
$string['config_general_description'] = 'Αυτές οι ρυθμίσεις χρησιμοποιούνται <b>πάντα</b>';
$string['config_importrecordings'] = 'Ρυθμίσεις για το χαρακτηριστικό «Εισαγωγή εγγραφών»';
$string['config_importrecordings_description'] = 'Αυτές οι ρυθμίσεις είναι για συγκεκριμένα χαρακτηριστικά';
$string['config_importrecordings_enabled'] = 'Εισαγωγή εγγραφών ενεργοποιημένη';
$string['config_importrecordings_enabled_description'] = 'Όταν αυτή και η επιλογή για καταγραφή είναι ενεργές, τότε είναι δυνατό να γίνει εισαγωγή εγγραφών από διαφορετικά μαθήματα στην δραστηριότητα.';
$string['config_importrecordings_from_deleted_enabled'] = 'Εισαγωγή εγγραφών από διαγραμμένες δραστηριότητες ενεργοποιημένη';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Όταν αυτό και η επιλογή για εισαγωγή καταγραφών είναι ενεργή, τότε είναι εφικτή η εισαγωγή καταγραφών από δραστηριότητες που δεν βρίσκονται πλεόν στο μάθημα.';
$string['config_meetingevents_enabled'] = 'Καταχώρηση ζωντανών γεγονότων';
$string['config_meetingevents_enabled_description'] = 'Ενεργοποίηση του πρόσθετου για αποδοχή και επεξεργασία ζωντανών γεγονότων μετά τη λήξη της συνεδρίας. (Αυτή η δυνατότητα είναι πειραματική και θα λειτουργεί μόνο εάν ο διακομιστής BigBlueButton είναι σε θέση να επεξεργάζεται σενάρια post_events)';
$string['config_muteonstart'] = 'Ρυθμίσεις για τη δυνατότητα «Σίγαση κατά την έναρξη»';
$string['config_muteonstart_default'] = 'Ενεργοποίηση της δυνατότητας «Σίγαση κατά την έναρξη» από προεπιλογή';
$string['config_muteonstart_default_description'] = 'Εάν ενεργοποιηθεί θα ισχύει για τη σύνοδο «Σίγαση κατά την έναρξη».';
$string['config_muteonstart_editable'] = 'Η δυνατότητα «Σίγαση κατά την έναρξη» μπορεί να αλλάξει';
$string['config_participant'] = 'Διαμόρφωση συμμετέχοντα';
$string['config_participant_moderator_default'] = 'Συντονιστής από προεπιλογή';
$string['config_preuploadpresentation_enabled'] = 'Ενεργοποίηση δυνατότητας προ-ανάρτησης της παρουσίασης';
$string['config_recording'] = 'Ρυθμίσεις για την λειτουργία «Εγγραφή συνάντησης»';
$string['config_recording_all_from_start_default'] = 'Εγγραφή όλων από την αρχή';
$string['config_recording_all_from_start_default_description'] = 'Αν επιλεγεί, η συνάντηση θα καταγραφεί από την αρχή';
$string['config_recording_all_from_start_editable'] = 'Η δυνατότητα καταγραφής όλων από την αρχή μπορεί να τροποποιηθεί';
$string['config_recording_all_from_start_editable_description'] = 'Αν επιλεγεί, η διεπαφή θα περιλαμβάνει επιλογή για ενεργοποίηση και απενεργοποίηση της δυνατότητας καταγραφής όλων από την αρχή.';
$string['config_recording_default'] = 'Η δυνατότητα καταγραφής θα είναι ενεργοποιημένη από προεπιλογή';
$string['config_recording_description'] = 'Αυτές οι ρυθμίσεις είναι για συγκεκριμένα χαρακτηριστικά';
$string['config_recording_editable'] = 'Η δυνατότητα καταγραφής μπορεί να τροποποιηθεί';
$string['config_recording_hide_button_default'] = 'Απόκρυψη πλήκτρου εγγραφής';
$string['config_recording_hide_button_default_description'] = 'Εάν επιλεγεί, το πλήκτρο για εγγραφή θα είναι σε απόκρυψη';
$string['config_recording_hide_button_editable'] = 'Η δυνατότητα απόκρυψης του κουμπιού μπορεί να τροποποιηθεί';
$string['config_recording_icons_enabled'] = 'Εικονίδια για διαχείριση εγγραφών';
$string['config_recordingready_enabled'] = 'Αποστολή ενημερώσεων όταν μια καταγραφή είναι έτοιμη';
$string['config_recordings_deleted_default'] = 'Εισαγωγή εγγραφών από διαγραμμένες δραστηριότητες ενεργοποιημένη από προεπιλογή';
$string['config_recordings_description'] = 'Αυτές οι ρυθμίσεις είναι για συγκεκριμένα χαρακτηριστικά';
$string['config_recordings_general'] = 'Εμφάνιση ρυθμίσεων εγγραφών';
$string['config_recordings_general_description'] = 'Αυτές οι ρυθμίσεις χρησιμοποιούνται μόνο όταν εμφανίζονται εγγραφές';
$string['config_recordings_imported_default'] = 'Εμφάνιση μόνο εισαχθέντων συνδέσμων, ενεργοποιημένη από προεπιλογή';
$string['config_recordings_imported_editable'] = 'Η λειτουργία εμφάνισης μόνο εισαχθέντων συνδέσμων, μπορεί να τροποποιηθεί';
$string['config_recordings_preview_default'] = 'Η προεπισκόπηση είναι ενεργοποιημένη από προεπιλογή';
$string['config_recordings_preview_default_description'] = 'Αν ενεργοποιηθεί, τότε ο πίνακας θα περιλαμβάνει προεπισκόπηση της παρουσίασης.';
$string['config_recordings_preview_editable'] = 'Η λειτουργία προεπισκόπησης μπορεί να αλλάξει';
$string['config_recordings_sortorder'] = 'Ταξινόμηση των καταγραφών σε αύξουσα σειρά.';
$string['config_recordings_validate_url'] = 'Επικύρωση διεύθυνσης URL';
$string['config_recordings_validate_url_description'] = 'Αν επιλεγεί, ο σύνδεσμος αναπαραγωγής θα πρέπει να επιβεβαιωθεί/επικυρωθεί προτού οι χρήστες θα έχουν πρόσβαση σε αυτόν.';
$string['config_scheduled'] = 'Ρυθμίσεις για «Χρονοπρογραμματισμένες συνόδους»';
$string['config_scheduled_duration_enabled'] = 'Υπολογισμός διάρκειας ενεργοποιημένος';
$string['config_scheduled_pre_opening'] = 'Προσβάσιμο πριν την ώρα έναρξης (λεπτά)';
$string['config_sendnotifications'] = 'Ρυθμίσεις για τη λειτουργία «Αποστολή ειδοποιήσεων»';
$string['config_sendnotifications_description'] = 'Αυτές οι ρυθμίσεις ενεργοποιούν ή απενεργοποιούν επιλογές στην διεπαφή χρήστη και ορίζουν επίσης προεπιλεγμένες τιμές για τις επιλογές αυτές.';
$string['config_sendnotifications_enabled'] = 'Αποστολή ειδοποιήσεων ενεργοποιημένη';
$string['config_server_url'] = 'Διεύθυνση URL εξυπηρετητή ιστοδιασκέψεων BigBlueButton';
$string['config_server_url_description'] = 'Η διεύθυνση URL του εξυπηρετητή ιστοδιασκέψεων BigBlueButton πρέπει να τελειώνει σε /bigbluebutton/. (Αυτή η προεπιλεγμένη διεύθυνση είναι για έναν εξυπηρετητή BigBlueButton που παρέχεται από την εταιρία Blindside Networks και που μπορεί να χρησιμοποιηθεί για δοκιμές.)';
$string['config_shared_secret'] = 'Κοινόχρηστο μυστικό ιστοδιάσκεψης BigBlueButton';
$string['config_shared_secret_description'] = 'Το «αλάτι» ασφαλείας (εμπλουτισμός κωδικού) του εξυπηρετητή σας ιστοδιασκέψεων BigBlueButton. (Αυτό το προεπιλεγμένο «αλάτι» είναι για έναν εξυπηρετητή BigBlueButton που παρέχεται από την εταιρία Blindside Networks και που μπορεί να χρησιμοποιηθεί για δοκιμές.)';
$string['config_uidelegation_enabled'] = 'Η αποστολή UI (διεπαφής χρήστη) ενεργοποιήθηκε';
$string['config_uidelegation_enabled_description'] = 'Αυτές οι ρυθμίσεις ενεργοποιούν ή απενεργοποιούν την αποστολή UI (διεπαφή χρήστη) στον εξυπηρετητή BigBlueButton';
$string['config_userlimit'] = 'Ρυθμίσεις για το χαρακτηριστικό «Όριο χρηστών»';
$string['config_userlimit_default'] = 'Το Όριο χρηστών είναι ενεργοποιημένο από προεπιλογή';
$string['config_userlimit_default_description'] = 'Ο αριθμός των χρηστών που επιτρέπονται σε μια σύνοδο από προεπιλογή όταν δημιουργείται ένα νέο δωμάτιο ή διάσκεψη. Αν ο αριθμός είναι ορισμένος σε 0, δεν θα υπάρχει κανένα όριο.';
$string['config_userlimit_description'] = 'Αυτές οι ρυθμίσεις ενεργοποιούν ή απενεργοποιούν επιλογές στην διεπαφή χρήστη και επίσης ορίζουν προεπιλεγμένες τιμές για αυτές τις επιλογές.';
$string['config_userlimit_editable'] = 'Ο χαρακτηριστικό ορίου χρηστών μπορεί να τροποποιηθεί';
$string['config_voicebridge'] = 'Ρυθμίσεις για το χαρακτηριστικό «Γέφυρα φωνής»';
$string['config_waitformoderator'] = 'Ρυθμίσεις για το χαρακτηριστικό «Αναμονή για συντονιστή»';
$string['config_waitformoderator_default'] = 'Αναμονή για συντονιστή ενεργοποιημένη από προεπιλογή';
$string['config_waitformoderator_description'] = 'Αυτές οι ρυθμίσεις είναι για συγκεκριμένα χαρακτηριστικά';
$string['email_body_notification_meeting_by'] = 'από';
$string['email_body_notification_meeting_description'] = 'Περιγραφή';
$string['email_body_notification_meeting_details'] = 'Λεπτομέρειες';
$string['email_body_notification_meeting_end_date'] = 'Ημερομηνία λήξης';
$string['email_body_notification_meeting_has_been'] = 'έχει';
$string['email_body_notification_meeting_start_date'] = 'Ημερομηνία έναρξης';
$string['email_body_notification_meeting_title'] = 'Τίτλος';
$string['email_body_recording_ready_for'] = 'Εγγραφή για';
$string['email_body_recording_ready_is_ready'] = 'είναι έτοιμη';
$string['email_footer_sent_by'] = 'Αυτό το μήνυμα αυτόματης ειδοποίησης στάλθηκε από';
$string['email_footer_sent_from'] = 'από το μάθημα';
$string['ends_at'] = 'Τελειώνει';
$string['event_activity_created'] = 'Η δραστηριότητα δημιουργήθηκε';
$string['event_activity_deleted'] = 'Η δραστηριότητα διαγράφηκε';
$string['event_activity_updated'] = 'Η δραστηριότητα ενημερώθηκε';
$string['event_activity_viewed'] = 'Η δραστηριότητα εμφανίστηκε';
$string['event_live_session'] = 'Ζωντανό γεγονός συνόδου';
$string['event_meeting_created'] = 'Η σύσκεψη BigBlueButtonBN δημιουργήθηκε';
$string['event_meeting_ended'] = 'Η σύσκεψη BigBlueButtonBN έληξε απότομα';
$string['event_meeting_joined'] = 'Έγινε ένταξη στη σύσκεψη BigBlueButtonBN';
$string['event_meeting_left'] = 'Αποχώρηση από τη σύσκεψη BigBlueButtonBN';
$string['event_recording_deleted'] = 'Η εγγραφή διαγράφηκε';
$string['event_recording_edited'] = 'Η εγγραφή τροποποιήθηκε';
$string['event_recording_imported'] = 'Η εγγραφή εισήχθη';
$string['event_recording_protected'] = 'Η εγγραφή προστατεύεται';
$string['event_recording_published'] = 'Η ηχογράφηση δημοσιεύθηκε';
$string['event_recording_unprotected'] = 'Η εγγραφή δεν προστατεύεται πλέον';
$string['event_recording_unpublished'] = 'Η ηχογράφηση δεν δημοσιεύεται πλέον';
$string['event_recording_viewed'] = 'Η εγγραφή εμφανίστηκε';
$string['index_confirm_end'] = 'Θέλετε να τερματίσετε την εικονική τάξη;';
$string['index_disabled'] = 'απενεργοποιημένο';
$string['index_enabled'] = 'ενεργοποιημένο';
$string['index_ending'] = 'Τερματισμός της εικονικής αίθουσας διδασκαλίας... Παρακαλώ, περιμένετε';
$string['index_error_checksum'] = 'Παρουσιάστηκε ένα σφάλμα αθροίσματος ελέγχου. Βεβαιωθείτε ότι πληκτρολογήσατε το σωστό αλάτι (εμπλουτισμό κωδικού).';
$string['index_error_forciblyended'] = 'Δεν είναι δυνατή η ένταξη σε αυτή τη σύσκεψη επειδή έχει τερματιστεί χειροκίνητα.';
$string['index_error_unable_display'] = 'Δεν είναι δυνατή η εμφάνιση των συναντήσεων. Παρακαλούμε ελέγξτε τη διεύθυνση URL του εξυπηρετητή ιστοδιασκέψεων BigBlueButton ΚΑΙ ελέγξτε αν ο εξυπηρετητής λειτουργεί.';
$string['index_heading'] = 'Δωμάτια ιστοδιάσκεψης BigBlueButton';
$string['index_heading_actions'] = 'Ενέργειες';
$string['index_heading_group'] = 'Ομάδα';
$string['index_heading_moderator'] = 'Συντονιστές';
$string['index_heading_name'] = 'Δωμάτιο';
$string['index_heading_recording'] = 'Εγγραφή ήχου/βίντεο';
$string['index_heading_users'] = 'Χρήστες';
$string['index_heading_viewer'] = 'Θεατές';
$string['indicator:cognitivedepth'] = 'Βάθος κατανόησης BigBlueButtonBN';
$string['indicator:cognitivedepth_help'] = 'Αυτός ο δείκτης βασίζεται στο βάθος κατανόησης που επιτεύχθηκε από τον μαθητή σε μια δραστηριότητα BigBlueButtonBN.';
$string['indicator:socialbreadth'] = 'Κοινωνικό εύρος BigBlueButtonBN';
$string['indicator:socialbreadth_help'] = 'Αυτός ο δείκτης βασίζεται στο κοινωνικό εύρος που επιτεύχθηκε από τον μαθητή σε έναν πόρο BigBlueButtonBN.';
$string['instance_type_default'] = 'Δωμάτιο/Δραστηριότητα με εγγραφές ήχου/βίντεο';
$string['instance_type_recording_only'] = 'Μόνο εγγραφές';
$string['instance_type_room_only'] = 'Δωμάτιο/Δραστηριότητα μόνο';
$string['mod_form_block_clienttype'] = 'Τεχνολογία πελάτη Ιστού';
$string['mod_form_block_clienttype_flash'] = 'Πελάτης που βασίζεται σε τεχνολογία Adobe Flash';
$string['mod_form_block_clienttype_html5'] = 'Πελάτης που βασίζεται σε τεχνολογία HTML5';
$string['mod_form_block_general'] = 'Γενικές ρυθμίσεις';
$string['mod_form_block_participants'] = 'Συμμετέχοντες';
$string['mod_form_block_presentation'] = 'Περιεχόμενο παρουσίασης';
$string['mod_form_block_presentation_default'] = 'Προεπιλεγμένο περιεχόμενο παρουσίασης';
$string['mod_form_block_record'] = 'Ρυθμίσεις εγγραφής ήχου/βίντεο';
$string['mod_form_block_recordings'] = 'Ρυθμίσεις εγγραφής ήχου/βίντεο';
$string['mod_form_block_room'] = 'Ρυθμίσεις για Δραστηριότητα/Δωμάτιο';
$string['mod_form_block_schedule'] = 'Χρονοδιάγραμμα για την σύνοδο';
$string['mod_form_field_block_clienttype'] = 'Τεχνολογία πελάτη Ιστού';
$string['mod_form_field_closingtime'] = 'Κλείσιμο ένταξης';
$string['mod_form_field_conference_name'] = 'Όνομα της διάσκεψης';
$string['mod_form_field_duration'] = 'Διάρκεια';
$string['mod_form_field_duration_help'] = 'Ο καθορισμός της διάρκειας μιας συνάντησης θα καθορίσει το μέγιστο χρόνο διατήρησης ζωντανής της σύσκεψης πριν από τη λήξη της εγγραφής ήχου/βίντεο.';
$string['mod_form_field_instanceprofiles'] = 'Τύπος στιγμιότυπου';
$string['mod_form_field_instanceprofiles_help'] = 'Επιλέξτε τον τύπο για αυτό το στιγμιότυπο ιστοδιάσκεψης BigBlueButtonBN.';
$string['mod_form_field_intro'] = 'Περιγραφή';
$string['mod_form_field_intro_help'] = 'Μια σύντομη περιγραφή για το δωμάτιο ή την διάσκεψη.';
$string['mod_form_field_muteonstart'] = 'Σίγαση στην έναρξη';
$string['mod_form_field_name'] = 'Όνομα εικονικής αίθουσας διδασκαλίας';
$string['mod_form_field_notification'] = 'Αποστολή ειδοποίησης';
$string['mod_form_field_notification_modified_help'] = 'Αποστολή ειδοποίησης σε όλους τους εγγεγραμμένους χρήστες για να μάθουν ότι αυτή η δραστηριότητα έχει ενημερωθεί';
$string['mod_form_field_notification_msg_at'] = 'στις';
$string['mod_form_field_notification_msg_created'] = 'προστέθηκε';
$string['mod_form_field_notification_msg_modified'] = 'τροποποιήθηκε';
$string['mod_form_field_openingtime'] = 'Άνοιγμα ένταξης';
$string['mod_form_field_participant_add'] = 'Προσθήκη συμμετέχοντα';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Συντονιστής';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Θεατής';
$string['mod_form_field_participant_list'] = 'Λίστα συμμετεχόντων';
$string['mod_form_field_participant_list_action_add'] = 'Προσθήκη';
$string['mod_form_field_participant_list_action_remove'] = 'Διαγραφή';
$string['mod_form_field_participant_list_text_as'] = 'ως';
$string['mod_form_field_participant_list_type_all'] = 'Όλοι οι χρήστες είναι εγγεγραμμένοι';
$string['mod_form_field_participant_list_type_owner'] = 'Ιδιοκτήτης';
$string['mod_form_field_participant_list_type_role'] = 'Ρόλος';
$string['mod_form_field_participant_list_type_user'] = 'Χρήστης';
$string['mod_form_field_record'] = 'Μπορεί να γίνει εγγραφή της συνόδου';
$string['mod_form_field_recordallfromstart'] = 'Εγγραφή όλων από την αρχή';
$string['mod_form_field_recordhidebutton'] = 'Απόκρυψη πλήκτρου εγγραφής';
$string['mod_form_field_recordings_deleted'] = 'Συμπερίληψη εγγραφών από διαγραμμένες δραστηριότητες';
$string['mod_form_field_recordings_html'] = 'Εμφάνιση του πίνακα σε απλή html';
$string['mod_form_field_recordings_imported'] = 'Εμφάνιση μόνο των εισαγόμενων συνδέσμων';
$string['mod_form_field_recordings_preview'] = 'Εμφάνιση προεπισκόπησης εγγραφής';
$string['mod_form_field_room_name'] = 'Όνομα δωματίου';
$string['mod_form_field_userlimit'] = 'Όριο χρηστών';
$string['mod_form_field_userlimit_help'] = 'Μέγιστο όριο χρηστών που επιτρέπεται σε μια σύσκεψη. Αν το όριο έχει οριστεί σε 0, ο αριθμός των χρηστών θα είναι απεριόριστος.';
$string['mod_form_field_voicebridge'] = 'Γέφυρα φωνής [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Σφάλμα μορφότυπου. Θα πρέπει να εισαγάγετε έναν αριθμό μεταξύ 1 και 9999.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Μη μοναδική τιμή. Αυτός ο αριθμός χρησιμοποιείται από ένα άλλο δωμάτιο ή διάσκεψη.';
$string['mod_form_field_wait'] = 'Αναμονή για συντονιστή';
$string['mod_form_field_wait_help'] = 'Οι θεατές πρέπει να περιμένουν μέχρι να μπει ένας συντονιστής πριν να μπουν';
$string['mod_form_field_welcome'] = 'Μήνυμα καλωσορίσματος';
$string['modulename'] = 'Ιστοδιάσκεψη BigBlueButtonBN';
$string['modulename_help'] = 'Το άρθρωμα Ιστοδιάσκεψη BigBlueButtonBN (σύστημα ιστοδιάσκεψης «μεγάλο μπλε πλήκτρο» από την εταιρία Blindside Networks) σας επιτρέπει να δημιουργείτε μέσα από τις συνδέσεις του Moodle συνδέσμους προς αίθουσες διδασκαλίας εντός σύνδεσης σε πραγματικό χρόνο χρησιμοποιώντας το BigBlueButton, ένα σύστημα ανοιχτού κώδικα διασκέψεων μέσω ιστού για εξ αποστάσεως εκπαίδευση.

Χρησιμοποιώντας το BigBlueButtonBN μπορείτε να καθορίσετε τον τίτλο, την περιγραφή, την καταχώρηση ημερολογίου (που δίνει ένα εύρος ημερομηνιών για ένταξη στη σύνοδο), τις ομάδες και τις λεπτομέρειες σχετικά με την εγγραφή της συνόδου εντός σύνδεσης.';
$string['modulename_link'] = 'ΙστοδιάσκεψηBigBlueButtonBN/προβολή';
$string['modulenameplural'] = 'Ιστοδιασκέψεις BigBlueButtonBN';
$string['pluginadministration'] = 'Διαχείριση BigBlueButton';
$string['pluginname'] = 'Ιστοδιάσκεψη BigBlueButtonBN';
$string['privacy:metadata:bigbluebutton'] = 'Για τη δημιουργία και την ένταξη σε συνόδους BigBlueButton, χρειάζεται ανταλλαγή δεδομένων με τον εξυπηρετητή.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Αποθηκεύει γεγονότα προκληθέντα κατά την χρήση του πρόσθετου.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Ο τύπος του γεγονότος που προκλήθηκε από τον χρήστη.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'Το αναγνωριστικό συνάντησης στην οποία είχε ο χρήστης πρόσβαση.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Ο χρόνος στον οποίο οι καταγραφές δημιουργήθηκαν.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'Το αναγνωριστικό χρήστη του χρήστη που προκάλεσε το γεγονός.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'Το πλήρες όνομα του χρήστη που αποκτά πρόσβαση στον εξυπηρετητή BigBlueButton.';
$string['privacy:metadata:bigbluebutton:userid'] = 'Το αναγνωριστικό χρήστη του χρήστη που αποκτά πρόσβαση στον εξυπηρετητή BigBlueButton.';
$string['removedevents'] = 'Διαγραμμένα γεγονότων';
$string['removedlogs'] = 'Διαγραμμένες προσαρμοσμένες καταγραφές';
$string['removedrecordings'] = 'Διαγραμμένες εγγραφές ήχου/βίντεο';
$string['removedtags'] = 'Διαγραμμένες ετικέτες';
$string['resetevents'] = 'Διαγραμμένα γεγονότα';
$string['resetlogs'] = 'Διαγραφή προσαρμοσμένων καταγραφών';
$string['resetlogs_help'] = 'Διαγραφή των καταγραφών θα προκαλέσει απώλεια των μέσων πρόσβασης (αναφορών) στις εγγραφές ήχου/βίντεο';
$string['resetrecordings'] = 'Διαγραφή εγγραφών ήχου/βίντεο';
$string['resetrecordings_help'] = 'Διαγραφή των εγγραφών ήχου/βίντεο θα τις κάνει μη προσβάσιμες από οπουδήποτε και δεν μπορεί να αναρεθεί';
$string['resettags'] = 'Διαγραφή ετικετών';
$string['search:activity'] = 'BigBlueButtonBN - πληροφορίες δραστηριότητας';
$string['search:tags'] = 'BigBlueButtonBN - πληροφορίες ετικετών';
$string['started_at'] = 'Ξεκίνησε';
$string['starts_at'] = 'Ξεκινά';
$string['view_conference_action_end'] = 'Τέλος συνόδου';
$string['view_conference_action_join'] = 'Ένταξη στη σύνοδο';
$string['view_error_action_not_completed'] = 'Η ενέργεια δεν μπορούσε να ολοκληρωθεί';
$string['view_error_bigbluebutton'] = 'Το BigBlueButton αποκρίθηκε με σφάλμα. {$a}';
$string['view_error_create'] = 'Ο εξυπηρετητής BigBlueButton απάντησε με ένα μήνυμα σφάλματος, δεν είναι δυνατή η δημιουργία της συνάντησης.';
$string['view_error_import_no_courses'] = 'Δεν υπάρχουν μαθήματα για να ερευνηθούν για εγγραφές ήχου/βίντεο';
$string['view_error_import_no_recordings'] = 'Δεν υπάρχουν εγγραφές σε αυτό το μάθημα προς εισαγωγή';
$string['view_error_invalid_session'] = 'Η σύνοδος έχει λήξει. Μεταβείτε στην κύρια σελίδα της δραστηριότητας.';
$string['view_error_max_concurrent'] = 'Έχει συμπληρωθεί ο επιτρεπόμενος αριθμός ταυτόχρονων συναντήσεων.';
$string['view_error_meeting_not_running'] = 'Κάτι δεν πήγε καλά. Η συνάντηση δεν λαμβάνει χώρα.';
$string['view_error_no_group'] = 'Δεν έχουν διαμορφωθεί ακόμα ομάδες. Παρακαλούμε ρυθμίστε τις ομάδες πριν προσπαθήσετε να ενταχθείτε στη σύσκεψη.';
$string['view_error_no_group_student'] = 'Δεν έχετε εγγραφεί σε μια ομάδα. Παρακαλούμε, επικοινωνήστε με τον Διδάσκοντα ή τον Διαχειριστή σας.';
$string['view_error_no_group_teacher'] = 'Δεν υπάρχει καμία διαμορφωμένη ομάδα ακόμη. Παρακαλούμε, ρυθμίστε ομάδες ή επικοινωνήστε με τον Διαχειριστή.';
$string['view_error_unable_join'] = 'Δεν είναι δυνατή η ένταξή σας στη συνάντηση. Παρακαλούμε ελέγξτε τη διεύθυνση URL του εξυπηρετητή BigBlueButton ΚΑΙ ελέγξτε αν ο εξυπηρετητής BigBlueButton εκτελείται.';
$string['view_error_unable_join_student'] = 'Δεν είναι δυνατή η σύνδεση με τον εξυπηρετητή BigBlueButton. Παρακαλούμε, επικοινωνήστε με τον διδάσκοντά σας ή το διαχειριστή.';
$string['view_error_unable_join_teacher'] = 'Δεν είναι δυνατή η σύνδεση με τον εξυπηρετητή BigBlueButton. Παρακαλούμε, επικοινωνήστε με τον διαχειριστή.';
$string['view_error_url_missing_parameters'] = 'Λείπουν παράμετροι από αυτή τη διεύθυνση URL';
$string['view_error_userlimit_reached'] = 'Ο αριθμός των χρηστών που επιτρέπεται σε μια συνάντηση έχει συμπληρωθεί.';
$string['view_groups_selection'] = 'Επιλέξτε την ομάδα στην οποία θέλετε να ενταχθείτε και επιβεβαιώστε την ενέργεια';
$string['view_groups_selection_join'] = 'Ένταξη';
$string['view_login_moderator'] = 'Σύνδεση ως συντονιστής...';
$string['view_login_viewer'] = 'Σύνδεση ως θεατής...';
$string['view_message_and'] = 'και';
$string['view_message_conference_has_ended'] = 'Η διάσκεψη αυτή έχει τελειώσει.';
$string['view_message_conference_in_progress'] = 'Αυτή η διάσκεψη είναι σε εξέλιξη.';
$string['view_message_conference_not_started'] = 'Αυτή η διάσκεψη δεν έχει ξεκινήσει ακόμα.';
$string['view_message_conference_room_ready'] = 'Αυτό το δωμάτιο διάσκεψης είναι έτοιμο. Μπορείτε να ενταχθείτε τώρα στην σύνοδο.';
$string['view_message_conference_wait_for_moderator'] = 'Αναμονή για να ενταχθεί ένας συντονιστής.';
$string['view_message_finished'] = 'Η δραστηριότητα αυτή έχει τελειώσει.';
$string['view_message_has_joined'] = 'έχει ενταχθεί';
$string['view_message_have_joined'] = 'έχουν ενταχθεί';
$string['view_message_hour'] = 'ώρα';
$string['view_message_hours'] = 'ώρες';
$string['view_message_minute'] = 'λεπτό';
$string['view_message_minutes'] = 'λεπτά';
$string['view_message_moderator'] = 'συντονιστής';
$string['view_message_moderators'] = 'συντονιστές';
$string['view_message_norecordings'] = 'Δεν υπάρχει καμία εγγραφή ήχου/βίντεο.';
$string['view_message_notavailableyet'] = 'Αυτή η σύνοδος δεν είναι ακόμη διαθέσιμη.';
$string['view_message_room_closed'] = 'Αυτό το δωμάτιο έχει κλείσει.';
$string['view_message_room_open'] = 'Αυτό το δωμάτιο είναι ανοιχτό.';
$string['view_message_room_ready'] = 'Αυτό το δωμάτιο είναι έτοιμο.';
$string['view_message_session_for'] = 'την σύνοδο για';
$string['view_message_session_has_user'] = 'Υπάρχει';
$string['view_message_session_has_users'] = 'Υπάρχουν';
$string['view_message_session_no_users'] = 'Δεν υπάρχουν χρήστες σε αυτή τη σύνοδο';
$string['view_message_session_running_for'] = 'Αυτή η σύνοδος τρέχει εδώ και';
$string['view_message_session_started_at'] = 'Αυτή η σύνοδος ξεκίνησε στις';
$string['view_message_tab_close'] = 'Αυτή η καρτέλα/παράθυρο πρέπει να κλείσει χειροκίνητα';
$string['view_message_times'] = 'φορές';
$string['view_message_user'] = 'χρήστης';
$string['view_message_users'] = 'χρήστες';
$string['view_message_viewer'] = 'θεατής';
$string['view_message_viewers'] = 'θεατές';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Έχετε υπερβεί τα 45 δευτερόλεπτα σε αυτή τη σελίδα. Παρακαλώ, ξαναφορτώστε τη σελίδα για να ενταχθείτε σωστά στη διάσκεψη.';
$string['view_noguests'] = 'Το BigBlueButtonBN δεν είναι ανοιχτό για επισκέπτες';
$string['view_nojoin'] = 'Δεν είστε σε έναν ρόλο που επιτρέπεται να ενταχθεί σε αυτήν την σύνοδο.';
$string['view_recording'] = 'Εγγραφή ήχου/βίντεο';
$string['view_recording_actionbar'] = 'Γραμμή εργαλείων';
$string['view_recording_activity'] = 'Δραστηριότητα';
$string['view_recording_button_import'] = 'Εισαγωγή συνδέσμων εγγραφών';
$string['view_recording_button_return'] = 'Επιστροφή';
$string['view_recording_course'] = 'Μάθημα';
$string['view_recording_date'] = 'Ημερομηνία';
$string['view_recording_delete_confirmation'] = 'Σίγουρα θέλετε να διαγράψετε αυτήν την {$a};';
$string['view_recording_description'] = 'Περιγραφή';
$string['view_recording_duration'] = 'Διάρκεια';
$string['view_recording_duration_min'] = 'λεπτά';
$string['view_recording_format_notes'] = 'Σημειώσεις';
$string['view_recording_format_podcast'] = 'podcast';
$string['view_recording_format_presentation'] = 'παρουσίαση';
$string['view_recording_format_screenshare'] = 'διαμοιρασμόςοθόνης';
$string['view_recording_format_statistics'] = 'στατιστικά';
$string['view_recording_format_video'] = 'βίντεο';
$string['view_recording_import_confirmation'] = 'Σίγουρα να εισαχθεί αυτή η εγγραφή;';
$string['view_recording_length'] = 'Μήκος';
$string['view_recording_link'] = 'εισαχθείς σύνδεσμος';
$string['view_recording_link_warning'] = 'Αυτός είναι ένας σύνδεσμος που δείχνει σε μια εγγραφή που δημιουργήθηκε σε ένα διαφορετικό μάθημα ή δραστηριότητα';
$string['view_recording_list_actionbar'] = 'Γραμμή εργαλείων';
$string['view_recording_list_actionbar_delete'] = 'Διαγραφή';
$string['view_recording_list_actionbar_edit'] = 'Επεξεργασία';
$string['view_recording_list_actionbar_hide'] = 'Απόκρυψη';
$string['view_recording_list_actionbar_import'] = 'Εισαγωγή';
$string['view_recording_list_actionbar_protect'] = 'Να γίνει ιδιωτικό';
$string['view_recording_list_actionbar_publish'] = 'Δημοσίευση';
$string['view_recording_list_actionbar_show'] = 'Εμφάνιση';
$string['view_recording_list_actionbar_unprotect'] = 'Δημοσίευση';
$string['view_recording_list_actionbar_unpublish'] = 'Παύση δημοσίευσης';
$string['view_recording_list_action_delete'] = 'Διαγραφή';
$string['view_recording_list_action_edit'] = 'Ενημέρωση';
$string['view_recording_list_action_play'] = 'Αναπαραγωγή';
$string['view_recording_list_action_process'] = 'Επεξεργασία';
$string['view_recording_list_action_protect'] = 'Προστασία...';
$string['view_recording_list_action_publish'] = 'Δημοσίευση';
$string['view_recording_list_action_unprotect'] = 'Λήψη προστασίας';
$string['view_recording_list_action_unpublish'] = 'Παύση δημοσίευσης';
$string['view_recording_list_action_update'] = 'Ενημέρωση';
$string['view_recording_list_activity'] = 'Δραστηριότητα';
$string['view_recording_list_course'] = 'Μάθημα';
$string['view_recording_list_date'] = 'Ημερομηνία';
$string['view_recording_list_description'] = 'Περιγραφή';
$string['view_recording_list_duration'] = 'Διάρκεια';
$string['view_recording_list_recording'] = 'Εγγραφή ήχου/βίντεο';
$string['view_recording_meeting'] = 'Συνάντηση';
$string['view_recording_modal_button'] = 'Εφαρμογή';
$string['view_recording_modal_title'] = 'Ορισμός τιμών για εγγραφή';
$string['view_recording_name'] = 'Όνομα';
$string['view_recording_playback'] = 'Αναπαραγωγή';
$string['view_recording_preview'] = 'Προεπισκόπηση';
$string['view_recording_recording'] = 'Εγγραφή';
$string['view_recording_tags'] = 'Ετικέτες';
$string['view_recording_yui_first'] = 'Πρώτο';
$string['view_recording_yui_go'] = 'Μετάβαση';
$string['view_recording_yui_last'] = 'Τελευταία';
$string['view_recording_yui_next'] = 'Επόμενη';
$string['view_recording_yui_page'] = 'Σελίδα';
$string['view_recording_yui_prev'] = 'Προηγούμενη';
$string['view_recording_yui_rows'] = 'Γραμμές';
$string['view_recording_yui_show_all'] = 'Εμφάνιση όλων';
$string['view_room'] = 'Εμφάνιση δωματίου';
$string['view_section_title_presentation'] = 'Αρχείο παρουσίασης';
$string['view_section_title_recordings'] = 'Εγγραφές';
$string['view_warning_default_server'] = 'Αυτός ο εξυπηρετητής Moodle κάνει χρήση του δοκιμαστικού εξυπηρετητή BigBlueButton που έρχεται προ-ρυθμισμένος ως προεπιλογή. Θα πρέπει να αντικατασταθεί για παραγωγικό περιβάλλον.';
