<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'attendance', language 'el', branch 'MOODLE_37_STABLE'
 *
 * @package   attendance
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['absenteereport'] = 'Αναφορά απουσιών';
$string['acronym'] = 'Ακρώνυμο';
$string['add'] = 'Προσθήκη';
$string['addedrecip'] = 'Προστέθηκε {$a} νέος παραλήπτης';
$string['addedrecips'] = 'Προστέθηκαν {$a} νέοι παραλήπτες';
$string['addmultiplesessions'] = 'Πολλαπλές συνεδρίες';
$string['addsession'] = 'Προσθήκη συνόδου';
$string['adduser'] = 'Προσθήκη χρήστη';
$string['addwarning'] = 'Προσθήκη προειδοποίησης';
$string['Afull'] = 'Απουσία';
$string['all'] = 'Όλα';
$string['allcourses'] = 'Όλα τα μαθήματα';
$string['allpast'] = 'Όλα τα περασμένα';
$string['allsessions'] = 'Όλες οι συνεδρίες';
$string['attendance:addinstance'] = 'Προσθήκη νέας δραστηριότητας παρουσιών';
$string['attendance_already_submitted'] = 'Η παρουσία σας έχει ήδη δηλωθεί.';
$string['attendance:canbelisted'] = 'Εμφανίζεται στη λίστα ονομάτων';
$string['attendance:changeattendances'] = 'Αλλαγές στις παρουσίες';
$string['attendance:changepreferences'] = 'Γίνεται αλλαγή προτιμήσεων';
$string['attendancedata'] = 'Δεδομένα παρουσιών';
$string['attendance:export'] = 'Εξαγωγή Αναφορών';
$string['attendanceforthecourse'] = 'Παρουσίες για το μάθημα';
$string['attendancegrade'] = 'Βαθμός παρουσιών';
$string['attendance:manageattendances'] = 'Διαχείριση παρουσιών';
$string['attendance:managetemporaryusers'] = 'Διαχείριση προσωρινών χρηστών';
$string['attendance_no_status'] = 'Καμία έγκυρη κατάσταση δεν είναι διαθέσιμη - ίσως είναι πολύ αργά για καταχώρηση παρουσιών.';
$string['attendancenotset'] = 'Θα πρέπει να δηλώσετε τις παρουσίες σας';
$string['attendancenotstarted'] = 'Οι παρουσίες δεν έχουν ξεκινήσει ακόμα για αυτό το μάθημα';
$string['attendancepercent'] = 'Ποσοστό % παρουσιών';
$string['attendancereport'] = 'Αναφορά παρουσιών';
$string['attendanceslogged'] = 'Καταγραμμένες παρουσίες';
$string['attendancestaken'] = 'Δηλωθείσες παρουσίες';
$string['attendancesuccess'] = 'Οι παρουσίες δηλώθηκαν με επιτυχία';
$string['attendance:takeattendances'] = 'Δηλώσεις παρουσιών';
$string['attendanceupdated'] = 'Οι παρουσίες ενημερώθηκαν με επιτυχία';
$string['attendance:view'] = 'Εμφάνιση παρουσιών';
$string['attendance:viewreports'] = 'Εμφάνιση αναφορών';
$string['attendance:viewsummaryreports'] = 'Εμφάνιση περιληπτικών αναφορών μαθήματος';
$string['attendance:warningemails'] = 'Μπορεί να γίνει εγγραφή σε μηνύματα ηλε.ταχυδρομείου σχετικά με απόντες μαθητές';
$string['attrecords'] = 'Εγγραφές παρουσιών';
$string['autoassignstatus'] = 'Αυτόματη επιλογή της ανώτατης διαθέσιμης κατάστασης';
$string['autoassignstatus_help'] = 'Αν αυτό επιλεγεί, θα αποδίδεται αυτόματα στους μαθητές ο υψηλότερος διαθέσιμος βαθμός.';
$string['automark'] = 'Αυτόματη βαθμολόγηση';
$string['automarkall'] = 'Ναι';
$string['automarkclose'] = 'Ορισμός ως μη επισημασμένου στο τέλος της συνόδου';
$string['automarktask'] = 'Έλεγχος για συνόδους παρουσιών που απαιτούν αυτόματη βαθμολόγηση';
$string['autorecorded'] = 'αυτόματη εγγραφή συστήματος';
$string['averageattendance'] = 'Μέσος αριθμός παρουσιών';
$string['averageattendancegraded'] = 'Μέσος αριθμός παρουσιών';
$string['backtoparticipants'] = 'Πίσω στην λίστα συμμετεχόντων';
$string['below'] = 'Κάτω από {$a}%';
$string['calclose'] = 'Κλείσιμο';
$string['calendarevent'] = 'Δημιουργία γεγονότος ημερολογίου για σύνοδο';
$string['caleventcreated'] = 'Το γεγονός ημερολογίου για σύνοδο, δημιουργήθηκε με επιτυχία';
$string['caleventdeleted'] = 'Το γεγονός ημερολογίου για σύνοδο, διαγράφηκε με επιτυχία';
$string['calmonths'] = 'Ιανουάριος,Φεβρουάριος,Μάρτιος,Απρίλιος,Μάιος,Ιούνιος,Ιούλιος,Αύγουστος,Σεπτέμβριος,Οκτώβριος,Νοέμβριος,Δεκέμβριος';
$string['calshow'] = 'Επιλογή ημερομηνίας';
$string['caltoday'] = 'Σήμερα';
$string['calweekdays'] = 'Κυ,Δε,Τρ,Τε,Πε,Πα,Σα';
$string['cannottakeforgroup'] = 'Δεν είναι εφικτή η δήλωση παρουσιών για την ομάδα «{$a}»';
$string['categoryreport'] = 'Αναφορά κατηγορίας μαθημάτων';
$string['changeattendance'] = 'Αλλαγή παρουσιών';
$string['changeduration'] = 'Αλλαγή διάρκειας';
$string['changesession'] = 'Αλλαγή συνόδου';
$string['checkweekdays'] = 'Επιλογή ημερών εβδομάδας που πέφτουν μέσα το επιλεγμένο χρονικό διάστημα συνόδου.';
$string['closed'] = 'Αυτή η σύνοδος δεν είναι αυτή τη στιγμή διαθέσιμη για αυτο-βαθμολόγηση';
$string['column'] = 'στήλη';
$string['columns'] = 'στήλες';
$string['commonsession'] = 'Όλοι οι μαθητές';
$string['commonsessions'] = 'Όλοι οι μαθητές';
$string['confirm'] = 'Επιβεβαίωση';
$string['confirmcolumnmappings'] = 'Επιβεβαίωση αντιστοιχήσεων στηλών';
$string['confirmdeleteuser'] = 'Είστε σίγουροι ότι θέλετε να διαγράψετε τον χρήστη «{$a->fullname}» ({$a->email});<br/>
Όλες οι εγγραφές παρουσιών τους θα διαγραφούν μόνιμα.';
$string['copyfrom'] = 'Αντιγραφή δεδομένων παρουσιών από';
$string['countofselected'] = 'Πλήθος επιλεγέντων';
$string['course'] = 'Μάθημα';
$string['coursemessage'] = 'Μήνυμα προς χρήστες μαθήματος';
$string['courseshortname'] = 'Σύντομο όνομα μαθήματος';
$string['coursesummary'] = 'Περιληπτική αναφορά μαθήματος';
$string['createmultiplesessions'] = 'Δημιουργία πολλαπλών συνόδων';
$string['createonesession'] = 'Δημιουργία μιας συνόδου για το μάθημα';
$string['csvdelimiter'] = 'Διαχωριστικό CSV';
$string['currentlyselectedusers'] = 'Επιλεγμένοι χρήστες αυτή τη στιγμή';
$string['date'] = 'Ημερομηνία';
$string['days'] = 'Ημέρες';
$string['defaultdisplaymode'] = 'Προεπιλεγμένη κατάσταση εμφάνισης';
$string['defaults'] = 'Προεπιλογές';
$string['defaultsessionsettings'] = 'Προεπιλεγμένες ρυθμίσεις συνόδου';
$string['defaultsessionsettings_help'] = 'Αυτές οι ρυθμίσεις ορίζουν τις προεπιλογές για όλες τις νέες συνόδους';
$string['defaultsettings'] = 'Προεπιλεγμένες ρυθμίσεις παρουσιών';
$string['defaultsettings_help'] = 'Αυτές οι ρυθμίσεις ορίζουν τις προεπιλογές για όλες τις νέες παρουσίες';
$string['defaultstatus'] = 'Η προεπιλεγμένη κατάσταση ορίστηκε';
$string['defaultsubnet'] = 'Προεπιλεγμένη διεύθυνση δικτύου';
$string['defaultview'] = 'Προεπιλεγμένη εμφάνιση κατά την σύνδεση';
$string['defaultview_desc'] = 'Αυτή είναι η προεπιλεγμένη εμφάνιση στους διδάσκοντες κατά την πρώτη σύνδεση.';
$string['defaultwarnings'] = 'Η προεπιλεγμένη προειδοποίηση ορίστηκε';
$string['defaultwarningsettings'] = 'Ρυθμίσεις προεπιλεγμένης προειδοποίησης';
$string['defaultwarningsettings_help'] = 'Αυτές οι ρυθμίσεις ορίζουν τις προεπιλογές για όλες τις νέες προειδοποιήσεις';
$string['delete'] = 'Διαγραφή';
$string['deletecheckfull'] = 'Είστε απολύτως σίγουροι ότι θέλετε πλήρη διαγραφή του {$a}, συμπεριλαμβανομένων όλων των δεδομένων χρήστη;';
$string['deletedgroup'] = 'Η ομάδα που συσχετίζεται με αυτή τη σύνοδο έχει διαγραφεί';
$string['deletehiddensessions'] = 'Διαγραφή όλων των κρυφών συνόδων';
$string['deletelogs'] = 'Διαγραφή δεδομένων παρακολούθησης/απουσιών';
$string['deleteselected'] = 'Διαγραφή επιλεγμένων';
$string['deletesession'] = 'Διαγραφή συνόδου';
$string['deletesessions'] = 'Διαγραφή όλων των συνόδων';
$string['deleteuser'] = 'Διαγραφή χρήστη';
$string['deletewarningconfirm'] = 'Σίγουρα θέλετε διαγραφή αυτής της προειδοποίησης;';
$string['deletingsession'] = 'Διαγράφονται συνεδρίες για το μάθημα';
$string['deletingstatus'] = 'Διαγραφή κατάστασης για το μάθημα';
$string['description'] = 'Περιγραφή';
$string['display'] = 'Εμφάνιση';
$string['displaymode'] = 'Κατάσταση λειτουργίας εμφάνισης';
$string['donotusepaging'] = 'Να μην γίνει σελιδοποίηση';
$string['downloadexcel'] = 'Λήψη σε μορφότυπο Excel';
$string['downloadooo'] = 'Λήψη σε μορφότυπο OpenOffice';
$string['downloadtext'] = 'Λήψη σε μορφότυπο κειμένου';
$string['duration'] = 'Διάρκεια';
$string['editsession'] = 'Τροποποίηση συνόδου';
$string['edituser'] = 'Επεξεργασία χρήστη';
$string['Efull'] = 'Δικαιολογημένος';
$string['emailcontent'] = 'Περιεχόμενο μηνύματος ηλε.ταχυδρομείου';
$string['emailcontent_help'] = 'Όταν μια προειδοποίηση αποστέλλεται σε έναν μαθητή, το περιεχόμενο του μηνύματος λαμβάνεται από αυτό το πεδίο. Τα ακόλουθα ονόματα πεδίων (μπαλαντέρ) μπορούν να χρησιμοποιηθούν:
<ul>
<li>%coursename%</li>
<li>%userfirstname%</li>
<li>%userlastname%</li>
<li>%userid%</li>
<li>%warningpercent%</li>
<li>%attendancename%</li>
<li>%cmid%</li>
<li>%numtakensessions%</li>
<li>%points%</li>
<li>%maxpoints%</li>
<li>%percent%</li>
</ul>';
$string['emailsubject'] = 'Θέμα μηνύματος ηλε.ταχυδρομείου';
$string['emailsubject_default'] = 'Προειδοποίηση παρουσιών/απουσιών';
$string['emailsubject_help'] = 'Όταν μια προειδοποίηση αποστέλλεται σε έναν μαθητή, το θέμα του μηνύματος λαμβάνεται από αυτό το πεδίο.';
$string['emailuser'] = 'Χρήστης διεύθυνσης ηλε.ταχυδρομείου';
$string['emailuser_help'] = 'Αν ελεγχθεί, μια προειδοποίηση αποστέλλεται στον μαθητή.';
$string['enablecalendar'] = 'Δημιουργία γεγονότων ημερολογίου';
$string['enablewarnings'] = 'Ενεργοποίηση προειδοποιήσεων';
$string['enablewarnings_desc'] = 'Αυτό επιτρέπει τον ορισμό προειδοποιήσεων για παρουσίες (σε μαθήματα) και ειδοποιήσεις μέσω ηλε.ταχυδρομείου σε χρήστες όταν οι παρουσίες πέφτουν κάτω από το καθορισμένο όριο.<br/><strong>ΠΡΟΕΙΔΟΠΟΙΗΣΗ: Πρόκειται για μια νέα λειτουργία και δεν έχει δοκιμαστεί εκτενώς. Παρακαλούμε χρησιμοποιήστε με δική σας ευθύνη και παρέχετε ανατροφοδότηση μέσω των φόρουμ του Moodle, αν θεωρείτε ότι λειτουργεί καλά.</strong>';
$string['encoding'] = 'Κωδικοποίηση';
$string['endofperiod'] = 'Τέλος περιόδου';
$string['endtime'] = 'Τέλος χρόνου συνόδου';
$string['enrolmentend'] = 'Η εγγραφή του χρήστη λήγει {$a}';
$string['enrolmentstart'] = 'Η εγγραφή του χρήστη ξεκινά {$a}';
$string['enrolmentsuspended'] = 'Η εγγραφή έχει ανασταλεί';
$string['enterpassword'] = 'Δώστε κωδικό πρόσβασης';
$string['error:coursehasnoattendance'] = 'Το μάθημα με το σύντομο όνομα {$a} δεν έχει δραστηριότητες με παρουσίες.';
$string['error:coursenotfound'] = 'Αδυναμία εύρεσης μαθήματος με σύντομο όνομα {$a}.';
$string['errorgroupsnotselected'] = 'Επιλέξτε μία ή περισσότερες ομάδες';
$string['errorinaddingsession'] = 'Σφάλμα κατά την προσθήκη συνόδου';
$string['erroringeneratingsessions'] = 'Σφάλμα κατά τη δημιουργία συνόδων';
$string['error:qrcode'] = 'Για χρήση κωδικού QR οι μαθητές πρέπει να επιτρέπεται να καταγράφουν δική τους παρουσία! Παράλειψη.';
$string['error:sessioncourseinvalid'] = 'Ένα μάθημα της συνόδου είναι μη έγκυρο! Παράλειψη.';
$string['error:sessiondateinvalid'] = 'Μία ημερομηνία της συνόδου είναι μη έγκυρη! Παράλειψη.';
$string['error:sessionendinvalid'] = 'Μία ημερομηνία λήξης της συνόδου είναι μη έγκυρη! Παράλειψη.';
$string['error:sessionstartinvalid'] = 'Μία ημερομηνία έναρξης της συνόδου είναι μη έγκυρη! Παράλειψη.';
$string['eventdurationupdated'] = 'Ενημερώθηκε η διάρκεια της συνόδου';
$string['eventreportviewed'] = 'Η αναφορά παρουσιών εμφανίστηκε';
$string['eventscreated'] = 'Τα γεγονότα ημερολογίου δημιουργήθηκαν';
$string['eventsdeleted'] = 'Τα γεγονότα ημερολογίου διαγράφηκαν';
$string['eventsessionadded'] = 'Η σύνοδος προστέθηκε';
$string['eventsessiondeleted'] = 'Η σύνοδος διαγράφηκε';
$string['eventsessionipshared'] = 'Διένεξη διευθύνσεων IP αυτο-επισήμανσης παρουσιών';
$string['eventsessionsimported'] = 'Η σύνοδος εισήχθη';
$string['eventsessionupdated'] = 'Η σύνοδος ενημερώθηκε';
$string['eventstatusadded'] = 'Η κατάσταση προστέθηκε';
$string['eventstatusupdated'] = 'Η κατάσταση ενημερώθηκε';
$string['eventstudentattendancesessionsviewed'] = 'Η αναφορά συνόδου εμφανίστηκε';
$string['eventtaken'] = 'Οι παρουσίες λήφθηκαν';
$string['eventtakenbystudent'] = 'Οι παρουσίες λήφθηκαν από μαθητή';
$string['export'] = 'Εξαγωγή';
$string['extrarestrictions'] = 'Επιπλέον περιορισμοί';
$string['formattexttype'] = 'Μορφοποίηση';
$string['from'] = 'από:';
$string['gradebookexplanation'] = 'Βαθμός στο βαθμολόγιο';
$string['graded'] = 'Βαθμολογημένες σύνοδοι';
$string['gridcolumns'] = 'Στήλες πλέγματος';
$string['group'] = 'Ομάδα συμμετεχόντων';
$string['groups'] = 'Ομάδες';
$string['groupsession'] = 'Ομάδα μαθητών';
$string['hiddensessions'] = 'Σύνοδοι σε απόκρυψη';
$string['hiddensessionsdeleted'] = 'Όλες οι σύνοδοι σε απόκρυψη διαγράφηκαν';
$string['hideextrauserdetails'] = 'Απόκρυψη επιπλέον λεπτομερειών χρήστη';
$string['hidensessiondetails'] = 'Απόκρυψη λεπτομερειών συνόδου';
$string['identifyby'] = 'Αναγνώριση χρήστη από';
$string['import'] = 'Εισαγωγή';
$string['importfile'] = 'Εισαγωγή αρχείου';
$string['importfile_help'] = 'Εισαγωγή αρχείου';
$string['importsessions'] = 'Εισαγωγή συνόδων';
$string['includeabsentee'] = 'Συμπερίληψη συνόδου κατά τον υπολογισμό αναφοράς απόντων';
$string['includeabsentee_help'] = 'Εάν επιλεγεί, αυτή η σύνοδος θα συμπεριληφθεί στους υπολογισμούς αναφοράς απόντων.';
$string['includeall'] = 'Επιλογή όλων των συνόδων';
$string['includenottaken'] = 'Συμπερίληψη συνόδων στις οποίες δεν έγινε καμία προσπάθεια';
$string['includeqrcode'] = 'Συμπερίληψη κωδικού QR';
$string['includeremarks'] = 'Συμπερίληψη παρατηρήσεων';
$string['incorrectpasswordshort'] = 'Λανθασμένος κωδικός πρόσβασης! Η παρουσία δεν καταχωρήθηκε.';
$string['indetail'] = 'Με λεπτομέρειες...';
$string['invalidaction'] = 'Πρέπει να επιλεγεί μια ενέργεια';
$string['invalidimportfile'] = 'Ο μορφότυπος αρχείου είναι μη έγκυρος.';
$string['invalidsessionenddate'] = 'Αυτή η ημερομηνία δεν μπορεί να είναι νωρίτερα από την ημερομηνία συνόδου';
$string['invalidsessionendtime'] = 'Ο χρόνος λήξης δεν μπορεί να είναι αργότερα από τον χρόνο έναρξης';
$string['invalidstatus'] = 'Έχετε επιλέξει μια μη έγκυρη κατάσταση. Παρακαλούμε, δοκιμάστε ξανά.';
$string['iptimemissing'] = 'Μη έγκυρη τιμή λεπτών για αποδέσμευση';
$string['jumpto'] = 'Μεταπήδηση προς';
$string['keepsearching'] = 'Συνέχιση αναζήτησης';
$string['Lfull'] = 'Αργοπορία';
$string['maxpossible'] = 'Μέγιστο δυνατό';
$string['maxpossiblepercentage'] = 'Μέγιστο πιθανό ποσοστό';
$string['maxpossiblepoints'] = 'Μέγιστοι πιθανοί πόντοι';
$string['maxwarn'] = 'Μέγιστος αριθμός προειδοποιήσεων ηλε.ταχυδρομείου';
$string['maxwarn_help'] = 'Ο μέγιστος αριθμός φορών που πρέπει να αποσταλεί μια προειδοποίηση (αποστέλλεται μόνο μία προειδοποίηση ανά σύνοδο)';
$string['mergeuser'] = 'Συγχώνευση χρήστη';
$string['modulename'] = 'Παρουσία';
$string['modulenameplural'] = 'Παρουσίες';
$string['months'] = 'Μήνες';
$string['moreattendance'] = 'Οι παρουσίες δηλώθηκαν με επιτυχία για αυτή τη σελίδα';
$string['moveleft'] = 'Μετακίνηση αριστερά';
$string['moveright'] = 'Μετακίνηση δεξιά';
$string['multisessionexpanded'] = 'Οι πολλαπλές σύνοδοι επεκτάθηκαν';
$string['multisessionexpanded_desc'] = 'Εμφάνιση των ρυθμίσεων «Πολλαπλές σύνοδοι» σε ανάπτυξη από προεπιλογή όταν δημιουργούνται νέες σύνοδοι.';
$string['mustselectusers'] = 'Πρέπει να επιλεγούν χρήστες προς εξαγωγή';
$string['newdate'] = 'Νέα ημερομηνία';
$string['newduration'] = 'Νέα διάρκεια';
$string['newstatusset'] = 'Νέο σετ καταστάσεων';
$string['noattendanceusers'] = 'Δεν είναι δυνατό να εξαχθούν δεδομένα καθώς δεν έχουν εγγραφεί καθόλου μαθητές στο μάθημα.';
$string['noattforuser'] = 'Δεν υπάρχουν εγγραφές παρουσιών για τον χρήστη';
$string['noautomark'] = 'Απενεργοποιημένο';
$string['nodescription'] = 'Κανονική σύνοδος τάξης';
$string['noeventstoreset'] = 'Δεν υπάρχουν καθόλου γεγονότα ημερολογίου που να απαιτούν ενημέρωση.';
$string['nogroups'] = 'Δεν μπορούν να προστεθούν σύνοδοι ομάδων. Δεν υπάρχουν ομάδες στο μάθημα.';
$string['noguest'] = 'Οι επισκέπτες δεν μπορούν να δουν τις παρουσίες';
$string['noofdaysabsent'] = 'Αριθμός ημερών απουσίας';
$string['noofdaysexcused'] = 'Αριθμός δικαιολογημένων ημερών απουσίας';
$string['noofdayslate'] = 'Αριθμός ημερών καθυστερημένης προσέλευσης';
$string['noofdayspresent'] = 'Αριθμός ημερών παρουσίας';
$string['nosessiondayselected'] = 'Δεν επιλέχθηκε καμία ημέρα συνόδου';
$string['nosessionexists'] = 'Δεν υπάρχει καμία σύνοδος για αυτό το μάθημα';
$string['nosessionsselected'] = 'Δεν επιλέχθηκε καμία σύνοδος';
$string['notfound'] = 'Δεν βρέθηκε δραστηριότητα παρουσιών σε αυτό το μάθημα!';
$string['notifytask'] = 'Αποστολή προειδοποιήσεων στους χρήστες';
$string['notmember'] = 'μη&nbsp;μέλος';
$string['numsessions'] = 'Αριθμός συνόδων';
$string['olddate'] = 'Παλιά ημερομηνία';
$string['onlyselectedusers'] = 'Εξαγωγή συγκεκριμένων χρηστών';
$string['overallsessions'] = 'Σε όλες τις συνόδους';
$string['oversessionstaken'] = 'Στις συνόδους που παρακολουθήθηκαν';
$string['pageof'] = 'Σελίδα {$a->page} από {$a->numpages}';
$string['participant'] = 'Συμμετέχοντας';
$string['password'] = 'Κωδικός πρόσβασης';
$string['passwordgrp'] = 'Κωδικός πρόσβασης μαθητή';
$string['passwordrequired'] = 'Πρέπει να δώσετε τον κωδικό πρόσβασης συνόδου πριν να μπορείτε να υποβάλετε την παρουσία σας';
$string['percentage'] = 'Ποσοστό';
$string['percentageallsessions'] = 'Ποσοστό επί όλων των συνόδων';
$string['percentagesessionscompleted'] = 'Ποσοστό επί όλων των συνόδων στις οποίες έγινε προσπάθεια';
$string['Pfull'] = 'Παρών';
$string['pluginadministration'] = 'Διαχείριση παρουσιών';
$string['pluginname'] = 'Παρουσίες';
$string['points'] = 'Πόντοι';
$string['pointsallsessions'] = 'Πόντοι επί όλων των συνόδων';
$string['pointssessionscompleted'] = 'Πόντοι επί των συνόδων για τις οποίες έγινε προσπάθεια';
$string['preventsharedip'] = 'Παρεμπόδιση χρήσης ίδιας διεύθυνσης IP από περισσότερους από έναν μαθητές';
$string['preventsharedip_help'] = 'Παρεμπόδιση μαθητών από την χρήση της ίδιας συσκευής (ταυτοποίηση μέσω διεύθυνσης IP) για λήψη παρουσίας για λογαριασμό άλλων μαθητων.';
$string['preventsharediptime'] = 'Χρόνος για να επιτρέπεται επανα-χρησιμοποίηση μιας διεύθυνσης IP (σε λεπτά)';
$string['preventsharediptime_help'] = 'Να επιτρέπεται να χρησιμοποιηθεί ξανά μια διεύθυνση IP για δήλωση παρουσίας σε αυτή την σύνοδο μόνο αφού περάσει αυτό το ελάχιστο χρονικό διάστημα.';
$string['privacy:metadata:attendancelog'] = 'Καταγραφές των εγγραφών παρουσιών χρήστη.';
$string['privacy:metadata:attendancesessions'] = 'Σύνοδοι στις οποίες θα εγγραφούν οι παρουσίες.';
$string['privacy:metadata:attendancewarningdone'] = 'Καταγραφές προειδοποιήσεων που στάλθηκαν σε χρήστες σχετικά με τις εγγραφές παρουσιών τους.';
$string['privacy:metadata:duration'] = 'Διάρκεια συνόδου σε δευτερόλεπτα';
$string['privacy:metadata:groupid'] = 'Το αναγνωριστικό ομάδας που συσχετίζεται με την σύνοδο.';
$string['privacy:metadata:ipaddress'] = 'Η διεύθυνση IP από την οποία σημειώθηκε η παρουσία.';
$string['privacy:metadata:lasttaken'] = 'Χρονοσφραγίδα του πότε σημειώθηκε τελευταία φορά παρουσία σε σύνοδο.';
$string['privacy:metadata:lasttakenby'] = 'Αναγνωριστικό χρήστη του τελευταίου χρήστη που σημείωσε παρουσία σε αυτή τη σύνοδο.';
$string['privacy:metadata:notifyid'] = 'Το αναγνωριστικό της παρουσίας σε σύνοδο με την οποία σχετίζεται η προειδοποίηση.';
$string['privacy:metadata:remarks'] = 'Σχόλια σχετικά με την παρουσία του χρήστη.';
$string['privacy:metadata:sessdate'] = 'Χρονοσφραγίδα του πότε αρχίζει η σύνοδος.';
$string['privacy:metadata:sessionid'] = 'Αναγνωριστικό παρουσίας σε σύνοδο.';
$string['privacy:metadata:statusid'] = 'Αναγνωριστικό κατάστασης παρουσίας μαθητή.';
$string['privacy:metadata:statusset'] = 'Σετ κατάστασης στο οποίο ανήκει το αναγνωριστικό κατάστασης.';
$string['privacy:metadata:studentid'] = 'Το αναγνωριστικό μαθητή για τον οποίο γίνεται εγγραφή παρουσιών.';
$string['privacy:metadata:takenby'] = 'Το αναγνωριστικό χρήστη του χρήστη που δήλωσε παρουσία για τον μαθητή.';
$string['privacy:metadata:timemodified'] = 'Χρονοσφραγίδα του πότε τροποποιήθηκε τελευταία η σύνοδος.';
$string['privacy:metadata:timesent'] = 'Χρονοσφραγίδα του πότε στάλθηκε η προειδοποίηση.';
$string['privacy:metadata:timetaken'] = 'Χρονοσφραγίδα του πότε λήφθηκε η παρουσία για τον μαθητή.';
$string['privacy:metadata:userid'] = 'Αναγνωριστικό χρήστη στον οποίο θα σταλεί προειδοποίηση.';
$string['processingfile'] = 'Επεξεργασία αρχείου';
$string['qrcode'] = 'Κωδικός QR';
$string['qr_cookie_error'] = 'Η σύνοδος QR έχει λήξει.';
$string['qr_pass_wrong'] = 'Ο κωδικός πρόσβασης QR είναι λανθασμένος ή έχει λήξει.';
$string['randompassword'] = 'Τυχαίος κωδικός πρόσβασης';
$string['remark'] = 'Παρατήρηση για: {$a}';
$string['remarks'] = 'Παρατηρήσεις';
$string['repeatasfollows'] = 'Επανάληψη της παραπάνω συνόδου ως ακολούθως';
$string['repeatevery'] = 'Επανάληψη κάθε';
$string['repeaton'] = 'Επανάληψη στις';
$string['repeatuntil'] = 'Επανάληψη μέχρι';
$string['report'] = 'Αναφορά';
$string['required'] = 'Απαιτείται*';
$string['requiredentry'] = 'Προσωρινός οδηγός βοήθειας συγχώνευσης χρηστών';
$string['requiresubnet'] = 'Να απαιτείται διεύθυνση δικτύου';
$string['resetcalendar'] = 'Επαναρχικοποίηση ημερολογίου';
$string['resetstatuses'] = 'Επαναρχικοποίηση καταστάσεων στην προεπιλογή';
$string['restoredefaults'] = 'Επαναφορά προεπιλογών';
$string['resultsperpage'] = 'Αποτελέσματα ανά σελίδα';
$string['resultsperpage_desc'] = 'Αριθμός μαθητών που εμφανίζονται σε μια σελίδα';
$string['rotateqrcode'] = 'Περιστροφή κωδικού QR';
$string['save'] = 'Αποθήκευση παρουσιών';
$string['search:activity'] = 'Παρουσίες- πληροφορίες δραστηριότητας';
$string['session'] = 'Σύνοδος';
$string['sessionadded'] = 'Η σύνοδος προστέθηκε με επιτυχία';
$string['sessionalreadyexists'] = 'Υπάρχει ήδη σύνοδος για αυτή την ημερομηνία';
$string['sessiondate'] = 'Ημερομηνία';
$string['sessiondays'] = 'Ημέρες συνόδου';
$string['sessiondeleted'] = 'Η σύνοδος διαγράφηκε με επιτυχία';
$string['sessionexist'] = 'Η σύνοδος δεν προστέθηκε (υπήρχε ήδη)!';
$string['sessiongenerated'] = 'Μία σύνοδος δημιουργήθηκε με επιτυχία';
$string['session_help'] = 'Σύνοδος';
$string['sessions'] = 'Σύνοδοι';
$string['sessionscompleted'] = 'Σύνοδοι με παρουσία';
$string['sessionsgenerated'] = '{$a} σύνοδοι παρήχθησαν με επιτυχία';
$string['sessionsids'] = 'Αναγνωριστικά συνόδων:';
$string['sessionsnotfound'] = 'Δεν υπάρχει καμία σύνοδος στο επιλεγμένο χρονικό διάστημα';
$string['sessionstartdate'] = 'Ημερομηνία έναρξης συνόδου';
$string['sessionstotal'] = 'Συνολικός αριθμός συνόδων';
$string['sessiontype'] = 'Τύπος';
$string['sessiontypeshort'] = 'Τύπος';
$string['sessionunknowngroup'] = 'Μια σύνοδος καθορίζει άγνωστη ομάδα/-ες: {$a}';
$string['sessionupdated'] = 'Η σύνοδος ενημερώθηκε με επιτυχία';
$string['setallstatuses'] = 'Ορισμός κατάστασης για όλους του χρήστες';
$string['setallstatusesto'] = 'Ορισμός κατάστασης για όλους του χρήστες σε «{$a}»';
$string['set_by_student'] = 'Αυτο-εγγραφή';
$string['setperiod'] = 'Καθορισμένος χρόνος σε λεπτά για αποδέσμευση IP';
$string['settings'] = 'Ρυθμίσεις';
$string['setunmarked'] = 'Ορίζεται αυτόματα εάν δεν επισημανθεί';
$string['setunmarked_help'] = 'Εάν ενεργοποιηθεί στην σύνοδο, να ορίζεται αυτή η κατάσταση εάν ο μαθητής δεν έχει επισημάνει την παρουσία του.';
$string['showdefaults'] = 'Εμφάνιση προεπιλεγμένων';
$string['showduration'] = 'Εμφάνιση διάρκειας';
$string['showextrauserdetails'] = 'Εμφάνιση επιπλέον λεπτομερειών χρήστη';
$string['showqrcode'] = 'Εμφάνιση κωδικού QR';
$string['showsessiondescriptiononreport'] = 'Εμφάνιση περιγραφής συνόδου στην αναφορά';
$string['showsessiondetails'] = 'Εμφάνιση λεπτομερειών συνόδου';
$string['sortedgrid'] = 'Ταξινομημένο πλέγμα';
$string['sortedlist'] = 'Ταξινομημένη λίστα';
$string['startofperiod'] = 'Έναρξη περιόδου';
$string['starttime'] = 'Χρόνος έναρξης';
$string['status'] = 'Κατάσταση';
$string['statusall'] = 'όλα';
$string['statusdeleted'] = 'Η κατάσταση διαγράφηκε';
$string['statuses'] = 'Καταστάσεις';
$string['statusset'] = 'Ορισμός κατάστασης {$a}';
$string['statussetsettings'] = 'Ορισμένη κατάσταση';
$string['statusunselected'] = 'μη επιλεγμένο';
$string['strftimedm'] = '%b %d';
$string['strftimedmy'] = '%d %b %Y';
$string['strftimedmyhm'] = '%d %b %Y %I.%M%p';
$string['strftimedmyw'] = '<nobr>%a %d %b %Y</nobr>';
$string['strftimeh'] = '%I%p';
$string['strftimehm'] = '%I:%M%p';
$string['strftimeshortdate'] = '%d.%m.%Y';
$string['studentavailability'] = 'Διαθέσιμη για μαθητές (λεπτά)';
$string['studentid'] = 'Αναγνωριστικό μαθητή';
$string['studentmarked'] = 'Η παρουσία σας σε αυτή τη σύνοδο έχει καταγραφεί.';
$string['studentmarking'] = 'Εγγραφή μαθητή';
$string['studentpassword'] = 'Κωδικός πρόσβασης μαθητή';
$string['studentrecordingexpanded'] = 'Εγγραφή ήχου/βίντεο χρήστη ανεπτυγμένη';
$string['studentrecordingexpanded_desc'] = 'Εμφάνιση των ρυθμίσεων «Εγγραφή ήχου/βίντεο μαθητή» ως ανεπτυγμένων από προεπιλογή κατά την δημιουργία νέων συνόδων.';
$string['studentscanmark'] = 'Επιτρέπει στους μαθητές να καταγράφουν τις δικές τους παρουσίες σε μαθήματα';
$string['studentscanmark_desc'] = 'Εάν επιλεγεί, οι διδάσκοντες θα μπορούν να επιτρέπουν στους μαθητές να βαθμολογούν τις δικές τους παρουσίες σε μάθημα.';
$string['studentscanmark_help'] = 'Εάν επιλεγεί, οι μαθητές θα είναι σε θέση να αλλάξουν την δική τους κατάσταση παρουσιών μαθήματος για την συνεδρία.';
$string['studentscanmarksessiontime'] = 'Οι μαθητές καταγράφουν τις παρουσίες τους κατά τη διάρκεια της συνόδου';
$string['studentscanmarksessiontime_desc'] = 'Αν επιλεγεί, οι μαθητές μπορούν μόνο να καταγράφουν τις παρουσίες τους κατά τη διάρκεια της συνόδου.';
$string['studentscanmarksessiontimeend'] = 'Τέλος συνόδου (λεπτά)';
$string['submitattendance'] = 'Υποβολή παρουσιών';
$string['subnet'] = 'Υποδίκτυο';
$string['subnetactivitylevel'] = 'Επιτρέπει ρυθμίσεις υποδικτύου σε επίπεδο δραστηριότητας';
$string['summary'] = 'Περίληψη';
$string['tactions'] = 'Ενέργεια';
$string['takeattendance'] = 'Δήλωση παρουσιών';
$string['takensessions'] = 'Σύνοδοι με παρουσία';
$string['tcreated'] = 'Δημιουργήθηκε';
$string['tempaddform'] = 'Προσθήκη προσωρινού χρήστη';
$string['tempexists'] = 'Υπάρχει ήδη ένας προσωρινός χρήστης με αυτή τη διεύθυνση ηλε.ταχυδρομείου';
$string['temptable'] = 'Λίστα προσωρινών χρηστών';
$string['tempuser'] = 'Προσωρινός χρήστης';
$string['tempusermerge'] = 'Συγχώνευση προσωρινού χρήστη';
$string['tempusers'] = 'Προσωρινοί χρήστες';
$string['tempusersedit'] = 'Επεξεργασία προσωρινού χρήστη';
$string['tempuserslist'] = 'Προσωρινοί χρήστες';
$string['thirdpartyemails'] = 'Ειδοποίηση των άλλων χρηστών';
$string['thirdpartyemailsubject'] = 'Προειδοποίηση παρουσιών';
$string['thirdpartyemailtext'] = 'Το ποσοστό των παρουσιών του/της {$a->firstname} {$a->lastname} στο μάθημα {$a->coursename} {$a->aname} είναι μικρότερο από {$a->warningpercent} ({$a->percent})';
$string['thirdpartyemailtextfooter'] = 'Λαμβάνετε αυτό διότι ο διδάσκων αυτού του μαθήματος έχει προσθέσει την διεύθυνση ηλε.ταχυδρομείου σας στην λίστα των παραληπτών';
$string['thiscourse'] = 'Αυτό το μάθημα';
$string['time'] = 'Ώρα';
$string['timeahead'] = 'Δεν μπορούν να δημιουργηθούν πολλαπλές σύνοδοι που ξεπερνούν τον ένα χρόνο. Παρακαλούμε, ρυθμίστε/προσαρμόστε τις ημερομηνίες αρχής και τέλους.';
$string['to'] = 'προς:';
$string['triggered'] = 'Κοινοποίηση πρώτα';
$string['tuseremail'] = 'Διεύθυνση ηλε.ταχυδρομείου';
$string['tusername'] = 'Πλήρες όνομα';
$string['ungraded'] = 'Μη βαθμολογημένες σύνοδοι';
$string['unknowngroup'] = 'Άγνωστη ομάδα';
$string['update'] = 'Ενημέρωση';
$string['usedefaultsubnet'] = 'Χρήση προεπιλογής';
$string['usemessageform'] = 'ή χρησιμοποιήστε την παρακάτω φόρμα για να στείλετε ένα μήνυμα στους επιλεγμένους μαθητές';
$string['userexists'] = 'Υπάρχει ήδη ένας πραγματικός χρήστης με αυτή τη διεύθυνση ηλε.ταχυδρομείου';
$string['users'] = 'Χρήστες προς εξαγωγή';
$string['usestatusset'] = 'Η κατάσταση ορίστηκε';
$string['variable'] = 'μεταβλητή';
$string['variablesupdated'] = 'Οι μεταβλητές ενημερώθηκαν με επιτυχία';
$string['versionforprinting'] = 'έκδοση για εκτύπωση';
$string['viewmode'] = 'Κατάσταση λειτουργίας προβολής';
$string['warnafter'] = 'Αριθμός των συνόδων που λαμβάνονται πριν από την προειδοποίηση';
$string['warningdeleted'] = 'Η προειδοποίηση διαγράφηκε';
$string['warningpercent'] = 'Προειδοποίηση αν το ποσοστό πέσει κάτω από';
$string['warningpercent_help'] = 'Μια προειδοποίηση θα προκληθεί όταν το συνολικό ποσοστό πέσει κάτω από αυτόν τον αριθμό.';
$string['warnings'] = 'Οι προειδοποιήσεις ορίστηκαν';
$string['warningthreshold'] = 'Κατώφλι προειδοποίησης';
$string['warningupdated'] = 'Οι προειδοποιήσεις ενημερώθηκαν';
$string['week'] = 'εβδομάδα/-ες';
$string['weeks'] = 'Εβδομάδες';
$string['youcantdo'] = 'Δεν μπορείτε να κάνετε τίποτα';
