<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'congrea', language 'fr', branch 'MOODLE_37_STABLE'
 *
 * @package   congrea
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['absentsessionuser'] = 'Aucun utilisateur présent dans cette session';
$string['absentuser'] = 'Aucun utilisateur présent dans cette session';
$string['addsessions'] = 'Ajouter une session';
$string['afterkeysavemsg'] = 'Clef API et clef secrète Congrea fournies et enregistrées avec succès';
$string['alreadyhave'] = 'Vous avez déjà configuré votre API et votre clef secrète';
$string['apikey'] = 'Votre clef API est';
$string['askplaymsg'] = '<span id="askplaymsg"> "Téléchargement en cours, appuyez sur Lecture pour commencer </span>"';
$string['askQuestion'] = 'Questions et Réponses';
$string['askQuestion_help'] = 'Si elle est activée, cette option permet à l\'enseignant et aux étudiants d\'utiliser la fonction "Poser une question"';
$string['attendeerecording'] = 'Enregistrement des étudiants';
$string['attendeerecording_help'] = 'Si elle est activée, cette option permet d\'enregistrer les activités de l\'étudiant pendant une session.';
$string['attendencereport'] = 'Etat des présences';
$string['audio'] = 'Audio';
$string['audio_help'] = 'Si cette option est activée, l\'audio de tous les étudiants sera activé par défaut.';
$string['audiolatency'] = 'Latence audio';
$string['audiotest'] = 'Test de l\'audio';
$string['cannotsavekey'] = 'Impossible d\'enregistrer la clef API ou la clef secrète';
$string['cgallowoverride'] = 'Permettre de passer outre';
$string['cgallowoverride_help'] = 'Si elle est activée, cette option permet d\'outrepasser les réglages dans les paramètres d\'activité à l\'intérieur du cours.';
$string['cgapi'] = 'Clef API Congrea';
$string['cgapid'] = 'Clef API';
$string['cgrecording'] = 'Enregistrement de la session';
$string['cgrecordingd'] = 'Si cette option est activée, vous pouvez choisir d\'autoriser l\'enregistrement automatique des sessions dans vos activités Congrea.';
$string['cgrecording_help'] = 'Si cette option est activée, elle permet l\'enregistrement automatique de vos sessions Congrea pour cette activité.';
$string['cgsecret'] = 'Clef secrète Congrea';
$string['cgsecretd'] = 'Entrez votre clef secrète Congrea';
$string['cgsecretdv'] = 'Clef secrète :';
$string['closebeforeopen'] = 'La session Congrea n\'a pu être enregistrée. Vous avez indiqué une date de fermeture avant la date d\'ouverture.';
$string['closenotset'] = 'Vous devez préciser une heure de fermeture.';
$string['closesameopen'] = 'Les heures d\'ouverture et de fermeture des sessions ne doivent pas être les mêmes';
$string['closetime'] = 'Sessions fermées';
$string['colorpicker'] = 'Sélecteur de couleurs personnalisés';
$string['colorpickerd'] = 'Choisissez votre couleur personnalisée';
$string['configuredheading'] = '<h4>Congrea est configuré, vous pouvez commencer à l\'utiliser dès maintenant.</h4>';
$string['conflictsdate'] = 'Créneau horaire non disponible';
$string['congrea'] = 'Congrea';
$string['congrea:addinstance'] = 'Ajoutez une nouvelle session Congrea';
$string['congrea:attendance'] = 'Etat des présences';
$string['congreadocument'] = 'Vous avez déjà téléchargé ceci';
$string['congrea:dorecording'] = 'Téléchargez l\'enregistrement';
$string['congreafieldset'] = 'Exemple de type de champ personnalisé';
$string['congreagenerald'] = 'Clef API Congrea';
$string['congreaname'] = 'Nom de votre session Congrea';
$string['congreaname_help'] = 'Il s\'agit d\'une salle de classe en ligne en temps réel qui permet une interaction participative entre les étudiants et fournit des outils de communication asynchrones tels que le tableau blanc, le chat et le partage d\'écran.';
$string['congrea:playrecording'] = 'Lire l\'enregistrement';
$string['congreapoll'] = 'Question de sondage Congrea';
$string['congrea:pollreport'] = 'Résultat du sondage Congrea';
$string['congrea:quizreport'] = 'Résultat du quiz Congrea';
$string['congrea:recordingdelete'] = 'Supprimer de l\'enregistrement';
$string['congrearecseeting'] = 'Enregristrement de la session Congrea';
$string['congrea:sessionedit'] = 'Editer la session';
$string['congrea:sessionesetting'] = 'Paramètres de la session';
$string['congreatiming'] = 'Durée de la classe virtuelle : <b> {$a->timestart} </b> to <b> {$a->endtime} </b>';
$string['congrea:view'] = 'Vue Congrea';
$string['coursesactivity'] = 'Activité de cours (Événements par cours)';
$string['customsetting'] = 'Paramètres personnalisés';
$string['datacenter'] = 'Choisir un centre de stockage de données';
$string['datacenter_help'] = 'Choisir le nom du centre de stockage de données';
$string['deletepolloption'] = 'L\'opération de suppression n\'a pas abouti';
$string['deleterecordingfile'] = 'Êtes-vous sûr de vouloir supprimer le fichier enregistré <br> "{$a}"?';
$string['deleteschedule'] = 'Êtes-vous sûr de vouloir supprimer ?';
$string['disable'] = 'Désactivé';
$string['disableAudio'] = 'Désactiver l\'audio';
$string['disablespeaker'] = 'Couper le son';
$string['displaymode'] = 'Mode d\'affichage';
$string['domain'] = 'URL du domaine';
$string['domain_help'] = 'Saisir votre nom de domaine';
$string['downloadsession'] = 'Merci de patienter pendant le téléchargement de l\'enregistrement.';
$string['editingschedule'] = 'Modifier une session programmée';
$string['email'] = 'Adresse de courriel';
$string['email_help'] = 'Entrez votre adresse de courriel';
$string['enable'] = 'Activé';
$string['enableAudio'] = 'Rétablir le son';
$string['enablerecording'] = 'Enregistrement de la session';
$string['enablerecording_help'] = 'Si activée, cette option permet l\'enregistrement automatique de toutes les sessions sur le site.';
$string['enablespeaker'] = 'Activer l\'audio';
$string['enrolteacher'] = 'Inscrivez un enseignant à ce cours';
$string['errorcurl'] = 'Une erreur s\'est produite dans l\'obtention des détails du plan. Veuillez actualiser la page.';
$string['errordurationlimit'] = 'Vous avez saisi une durée de session non valable. Elle doit être supérieure à 10 minutes et inférieure à 24 heures.';
$string['errortimeduration'] = 'Vous avez saisi une durée de session non valable. Elle doit être supérieure à 10 minutes et inférieure à 24 heures.';
$string['esessiondate'] = 'Vous avez saisi une date ou une heure non valable.';
$string['event'] = 'Événement';
$string['eventsbymonth'] = 'Événements par mois ({$a})';
$string['eventsmosttriggered'] = 'Les événements les plus déclenchés';
$string['filter'] = 'Choisissez un filtre';
$string['filter_help'] = 'Choisissez un filtre';
$string['firstname'] = 'Prénom';
$string['firstname_help'] = 'Saisissez votre prénom';
$string['freeplan'] = 'Pour obtenir le plan gratuit de Congrea, cliquez <a href="../mod/congrea/getkeyindex.php"><strong>here</strong></a>';
$string['from'] = 'de :';
$string['fromsessiondate'] = 'Heure de début de la session';
$string['fromsessiondate_help'] = 'Sélectionnez la date et l\'heure de la session';
$string['generalsection'] = 'Paramètres';
$string['generate'] = 'Générez';
$string['getformheading'] = 'Obtenez le plan gratuit Congrea';
$string['getkey'] = 'Clef API Congrea';
$string['graphic:view'] = 'Voir le graphique des événements';
$string['hourssetting'] = 'Vous avez saisi une date ou une heure non valable. Assurez-vous que la durée totale de la session ne dépasse pas 10 heures.';
$string['httpserror'] = 'Attention !  Le protocole HTTPS (certificat SSL) est nécessaire pour Congrea. Il est détecté qu\'actuellement Moodle ne fonctionne pas sur https et donc certaines fonctionnalités de Congrea peuvent ne pas fonctionner.';
$string['indvprogress'] = 'Tâche en cours';
$string['invalidkey'] = '<div class="alert alert-warning alert-block fade in">Clef API ou clef secrète invalide ou manquante</div>';
$string['joinroom'] = 'Rejoignez la salle de classe virtuelle';
$string['keyis'] = 'Clef API :';
$string['lastname'] = 'Surnom';
$string['lastname_help'] = 'Entrez votre nom.';
$string['liverun'] = 'En ligne - Utiliser le serveur vidya.io';
$string['menu'] = 'Rapport graphique des événements';
$string['message'] = '<div class="alert alert-warning alert-block fade in"> Obtenez gratuitement le plan Congrea API / clef secrète pour votre domaine.  Si vous avez déjà des clef API Congrea, mettez à jour et configurez Congrea <a href="../../admin/settings.php?section=modsettingcongrea"><strong>ici</strong></a></div>';
$string['min'] = 'Minutes';
$string['missingdatacenter'] = 'Nom du centre de stockage de données manquant';
$string['missingdomain'] = 'Nom de domaine manquant';
$string['missingprivacy'] = 'Obligation d\'accepter les politiques de confidentialité.';
$string['missingterms'] = 'Lisez les conditions générales et cochez la case.';
$string['modulename'] = 'Congrea';
$string['modulename_help'] = 'Utilisez le module Congrea pour un apprentissage en ligne en temps réel.  Le module Congrea vous permet de participer à l\'apprentissage synchrone, ce qui signifie que l\'enseignant et les étudiants sont connectés à l\'environnement d\'apprentissage virtuel et interagissent entre eux en même temps.
Ce module fournit aux étudiants des outils de communication asynchrone, tels que le tableau blanc et les capacités de chat';
$string['modulenameplural'] = 'Congreas';
$string['newsessionadded'] = 'Un nouvel horaire est créé dans l\'emploi du temps.';
$string['noattempt'] = 'Pas de tentative de la part d\'un utilisateur';
$string['nofetchplandetails'] = 'Impossible d\'obtenir les détails de votre plan. Veuillez réessayer !';
$string['nopolldata'] = 'Pas de données à enregistrer';
$string['nopollresult'] = 'Impossible d\'enregistrer le résultat du sondage';
$string['nopollsave'] = 'Impossible d\'enregistrer le sondage';
$string['noquizattempt'] = 'Pas de tentative de la part d\'un utilisateur';
$string['noquizreport'] = 'Aucune donnée disponible.';
$string['noreport'] = 'Aucune donnée disponible.';
$string['nosession'] = 'Aucune session n\'est disponible à l\'affichage.';
$string['notenrol'] = 'Aucun utilisateur n\'est inscrit à ce cours';
$string['notsavekey'] = 'La clef API de Congrea est manquante. Aller aux <a href="{$a}">Paramètres de Congrea</a> pour la saisir.';
$string['notsession'] = '<h2>Aucune session n\'est disponible.</h2>';
$string['noupcomingsession'] = 'Il n\'y a pas de sessions à venir.';
$string['nouser'] = 'Nom d\'utilisateur non trouvé';
$string['opentime'] = 'Sessions ouvertes';
$string['overallprogress'] = 'Progression générale';
$string['overrideheading'] = 'Paramètres d\'annulation';
$string['percentage'] = 'Pourcentage';
$string['play'] = 'Lecture';
$string['pluginadministration'] = 'Administration de Congrea';
$string['pluginname'] = 'Congrea';
$string['polldelete'] = 'La suppression du sondage a échoué, essayez à nouveau';
$string['polloptiondeletefailed'] = 'La suppression a échoué, essayez à nouveau';
$string['pollreport'] = 'Résultat du sondage';
$string['pollretrievefail'] = 'Impossible de récupérer le sondage, essayez à nouveau';
$string['pollupdatefail'] = 'La mise à jour du sondage a échoué, essayez à nouveau';
$string['preset'] = 'Couleur prédéfinie';
$string['presetd'] = 'Sélectionner une couleur prédéfinie';
$string['pressalways'] = 'Toujours appuyer pour parler';
$string['pressAlwaysToSpeak'] = 'Toujours appuyer pour parler';
$string['pressonce'] = 'Appuyer une fois pour parler';
$string['privacy'] = 'J\'accepte la <a href=\'https://www.congrea.com/documents-for-foreign-customers/#5e886344a0508-0\' target=\'_blank\'>politique de protection de la vie privée</a>.';
$string['privacy_help'] = 'Cochez la case pour accepter la politique de protection de la vie privée.';
$string['proposedspeed'] = 'Vitesse proposée';
$string['psession'] = 'Sessions enregistrées';
$string['pushtotalk'] = 'Appuyez pour parler';
$string['pushtotalk_help'] = 'Si l\'option est activée, une option supplémentaire afin de testât l\'audio apparaîtra.';
$string['qaAnswer'] = 'Réponse';
$string['qaAnswer_help'] = 'Si cette option est activée, elle permet aux étudiants de répondre à la question affichée sur le panneau "Posez la question"';
$string['qaComment'] = 'Commentaire';
$string['qaComment_help'] = 'Si cette option est activée, elle permet aux étudiants de commenter les réponses et autres commentaires';
$string['qaMarkNotes'] = 'Signet et notes';
$string['qaMarkNotes_help'] = 'Si cette option est activée, elle permet à l\'enseignant et aux étudiants d\'ajouter un signet privé et une note';
$string['qaUpvote'] = 'Vote';
$string['qaUpvote_help'] = 'Si cette option est activée, elle permet aux étudiants de voter pour les questions et réponses';
$string['quantity'] = 'quantité';
$string['questionsanswersettings'] = 'Réglages des questions et réponses';
$string['quizreport'] = 'Rapport du quiz';
$string['recAllowattendeeAVcontrol'] = 'Contrôle de l\'étudiant sur l\'enregistrement audiovisuel';
$string['recAllowattendeeAVcontrol_help'] = 'Si elle est activée, elle permet aux étudiants de contrôler leur enregistrement audiovisuel, c\'est-à-dire qu\'ils peuvent à tout moment arrêter et démarrer leur propre enregistrement audiovisuel pendant une session en direct.';
$string['recAllowpresentorAVcontrol'] = 'Contrôle de l\'enseignement sur l\'enregistrement audiovisuel';
$string['recAllowpresentorAVcontrol_help'] = 'Si elle est activée, cette option permet à l\'enseignant de contrôler l\'enregistrement audiovisuel, c\'est-à-dire que l\'enseignant peut à tout moment arrêter et démarrer l\'enregistrement audiovisuel d\'une session entière pendant une session en direct.';
$string['recattendeeav'] = 'Enregistrement audiovisuel des étudiants';
$string['recattendeeav_help'] = 'Si elle est activée, cette option permet aux étudiants d\'effectuer un enregistrement audiovisuel pendant la session, c\'est-à-dire que toutes les données binaires telles que l\'audio, la vidéo et le partage d\'écran seront enregistrées dans l\'enregistrement de la session.';
$string['recordedsessions'] = 'Sessions enregistrées';
$string['recordingcontrol'] = 'Contrôle de l\'enregistrement';
$string['recordingsection'] = 'Réglages de l\'enregistrement';
$string['recShowPresentorRecordingStatus'] = 'Statut d\'enregistrement visible par l\'enseignant';
$string['recShowPresentorRecordingStatus_help'] = 'Si cette option est activée, elle permet à l\'enseignant de connaître l\'état de l\'enregistrement, c\'est-à-dire qu\'il peut savoir en permanence si la session est enregistrée ou non sur son écran Congrea';
$string['repeatevery'] = 'Répéter chaque semaine et créer les autres sessions';
$string['repeaton'] = 'Répétition';
$string['repeatsession'] = 'Répéter les sessions';
$string['repeatsessions'] = 'Si vous souhaitez programmer plusieurs sessions';
$string['repeattype'] = 'Type de répétition';
$string['repeattype_help'] = 'Type de répétition';
$string['replay'] = 'Regarder à nouveau';
$string['replay_message'] = 'Merci d\'avoir regardé.';
$string['secretis'] = 'Clef secrète :';
$string['selectcolor'] = 'Sélectionnez une couleur';
$string['selectcolor_help'] = 'Choisissez la couleur pour votre classe';
$string['selectdays'] = 'Sélectionnez les jours';
$string['selectteacher'] = 'Choisir un enseignant';
$string['selectteacher_help'] = 'Désignez un enseignant pour cette session.';
$string['sessionareport'] = 'Rapport de participation à la session';
$string['sessionclosed'] = 'La salle de classe n\'est pas encore ouverte';
$string['sessiondate'] = 'Date de la session';
$string['sessionedited'] = 'Session(s) mise(s) à jour.';
$string['sessionenddate'] = 'Date de fin de session';
$string['sessionenddate_help'] = 'Date de fin de session';
$string['sessionendmsg'] = 'La session a été clôturée. Vous pouvez maintenant fermer votre navigateur.';
$string['sessionsettings'] = 'Programmer une session';
$string['sessionsschedule'] = 'Calendrier des sessions';
$string['sevendays'] = '7 sessions';
$string['showAttendeeRecordingStatus'] = 'Enregistrement de la visibilité du statut de l\'étudiant';
$string['showAttendeeRecordingStatus_help'] = 'Si elle est activée, cette option permet aux étudiants de voir l\'état de l\'enregistrement, c\'est-à-dire qu\'ils seront informés en permanence de l\'enregistrement ou non de la session sur leur écran Congrea.';
$string['silencedetect'] = 'Détection des silences';
$string['srecordingsection_help'] = '<b>Paramètres Étudiant</b> - Ces paramètres auront une incidence sur les droits d\'enregistrement des élèves.';
$string['studentaudio'] = 'Audio de l\'étudiant';
$string['studentaudio_help'] = 'Si elle est activée, cette option permet aux étudiants de fournir leur entrée audio pendant la session.';
$string['studentgc'] = 'Chat de groupe';
$string['studentgc_help'] = 'Si elle est activée, cette option permet aux étudiants de participer à des discussions de groupe pendant la session.';
$string['studentm'] = 'Gestion des caractéristiques';
$string['studentm_help'] = 'Gestion des caractéristiques';
$string['studentpc'] = 'Chat privé';
$string['studentpc_help'] = 'Si elle est activée, cette option permet aux étudiants d\'avoir un chat privé, c\'est-à-dire une discussion en tête-à-tête avec les participants pendant la session.';
$string['studentvideo'] = 'Vidéo de l\'étudiant';
$string['studentvideo_help'] = 'Si elle est activée, cette option permet aux étudiant d\'activer leur vidéo pendant la session.';
$string['submiterror'] = 'Erreur :';
$string['supportupgrade'] = 'Pour obtenir de l\'aide et changer votre plan Congrea, visitez <a href="https://www.congrea.com/" target= "_blank">www.congrea.com</a>';
$string['teachername'] = 'Enseignant : {$a->firstname} {$a->lastname}';
$string['terms'] = 'J\'accepte les <a href=\'https://www.congrea.com/documents-for-foreign-customers/#5e88631ac6b7c-1\' target=\'_blank\'>conditions générales</a>.';
$string['terms_help'] = 'Lisez les conditions générales et cochez la case correspondante.';
$string['testingbrowser'] = 'Tester la compatibilité des navigateurs';
$string['testinginternetspeed'] = 'Tester la vitesse de l\'Internet';
$string['testingmichrophone'] = 'Test du microphone';
$string['testingspeaker'] = 'Test des haut-parleurs';
$string['testingwebcam'] = 'Tester la connexion de la webcam';
$string['thirtydays'] = '30 sessions';
$string['threemonth'] = '90 sessions';
$string['time'] = 'Temps :';
$string['timeduration'] = 'Durée en minutes';
$string['timeduration_help'] = 'Sélectionnez la durée de la session qui doit être supérieure à 10 minutes et inférieure à 24 heures.';
$string['todaynosession'] = 'Aucune session aujourd\'hui. Voir ci-dessous les prochaines sessions';
$string['tosessiondate'] = 'Heure de fin de la session';
$string['tosessiondate_help'] = 'Choisissez l\'heure de fin de la session qui ne doit pas dépasser une durée totale de 10 heures.';
$string['totalprogress'] = 'Progression totale';
$string['tpAudioTest'] = 'Test de l\'audio';
$string['trecordingsection_help'] = '<b>Réglages de l\'enseignant</b> - These settings will affect the recording rights of teacher.';
$string['trimRecordings'] = 'Editer l\'enregistrement';
$string['trimRecordings_help'] = 'Si elle est activée, cette option permet d\'arrêter/découper l\'enregistrement de la session lorsque le système audiovisuel a été désactivé, c\'est-à-dire lorsque l\'enseignant a arrêté l\'enregistrement audiovisuel pendant la session et que cette durée particulière ne sera pas enregistrée ou découpée de l\'enregistrement de la session.';
$string['unsupportedfiletype'] = 'Type de fichier non valide, seuls les enregistrements de session Congrea {.vcp} sont pris en charge.';
$string['upcomingsession'] = 'Prochaines sessions';
$string['updated'] = 'Enregistrement réussi.';
$string['uploadedsession'] = 'Votre session est terminée, vous pouvez maintenant fermer la fenêtre. <br /> Ou
                                  fermer ce popup pour démarrer une nouvelle session.';
$string['uploadedsessionOk'] = 'Cliquez sur « OK » pour commencer une nouvelle session.';
$string['uploadrecordedfile'] = 'Télécharger la session enregistrée';
$string['uploadsession'] = 'Veuillez attendre que le traitement soit terminé.';
$string['userlist'] = 'Visibilité de la liste des utilisateurs';
$string['userlist_help'] = 'Si elle est activée, cette option permet aux étudiants de consulter la liste des participants pendant une session.';
$string['usersactivity'] = 'Activité de l\'utilisateur (Événements par utilisateur)';
$string['video'] = 'Vidéo';
$string['video_help'] = 'Si cette option est activée, la vidéo de tous les étudiants sera activée par défaut.';
$string['videoquality'] = 'Qualité de la vidéo';
$string['waitmsgconnect'] = 'Veuillez patienter. L\'application essaie de se connecter.';
$string['week'] = 'semaine(s)';
$string['wrongkey'] = 'La clef API Congrea est fausse. Allez à <a href="{$a}">Réglages Congrea</a> pour la configurer à nouveau.';
