<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'sr_cr', branch 'MOODLE_37_STABLE'
 *
 * @package   hvp
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Акција';
$string['addedandupdatedpp'] = 'Додато нових H5P библиотека: {$a->%new}, и ажурирано старих: {$a->%old}.';
$string['addedandupdatedps'] = 'Додато нових H5P библиотека: {$a->%new}, и ажурирана {$a->%old} стара.';
$string['addedandupdatedsp'] = 'Додата {$a->%new} нова H5P библиотека, и ажурирано старих: {$a->%old}.';
$string['addedandupdatedss'] = 'Додата {$a->%new} нова H5P библиотека, и ажурирана {$a->%old} стара.';
$string['addednewlibraries'] = 'Додато нових H5P библиотека: {$a->%new}';
$string['addednewlibrary'] = 'Додата {$a->%new} нова H5P библиотека.';
$string['additionalinfo'] = 'Додатне информације';
$string['additionallicenseinfo'] = 'Све додатне информације о лиценци';
$string['addlibraries'] = 'Додај библиотеке';
$string['ajaxfailed'] = 'Покушај учитавања података није успео';
$string['anunexpectedsave'] = 'Догодило се нешто неочекивано. Нисмо успели да сачувамо овај интерактивни садржај.';
$string['attribution'] = 'Ауторство 4.0';
$string['attributionnc'] = 'Ауторство - Некомерцијална лиценца 4.0';
$string['attributionncnd'] = 'Ауторство - Некомерцијална лиценца - Без прерада 4.0';
$string['attributionncsa'] = 'Ауторство - Некомерцијална лиценца - Делити под истим условима 4.0';
$string['attributionnd'] = 'Ауторство - Лиценца - Без прерада 4.0';
$string['attributionsa'] = 'Ауторство - Лиценца - Делити под истим условима 4.0';
$string['author'] = 'Аутор';
$string['authorcomments'] = 'Коментари аутора';
$string['authorcommentsdescription'] = 'Коментари за уредника интерактивног садржаја (овај текст неће бити објављен као део информације о ауторским правима)';
$string['authorname'] = 'Име аутора';
$string['authorrole'] = 'Улога аутора';
$string['by'] = 'од стране';
$string['cancellabel'] = 'Откажи';
$string['ccattribution'] = 'Ауторство (CC BY)';
$string['ccattributionnc'] = 'Ауторство - Некомерцијална лиценца (CC BY-NC)';
$string['ccattributionncnd'] = 'Ауторство - Некомерцијална лиценца - Без прерада (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Ауторство - Некомерцијална лиценца - Делити под истим условима (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Ауторство - Лиценца - Без прерада (CC BY-ND)';
$string['ccattributionsa'] = 'Ауторство - Лиценца - Делити под истим условима (CC BY-SA)';
$string['ccpdd'] = 'Посвећеност јавном власништву (CC0)';
$string['ccpdm'] = 'Ознака јавног власништва (PDM)';
$string['changedby'] = 'Променио/ла';
$string['changedescription'] = 'Опис промене';
$string['changelog'] = 'Измене записа';
$string['changeplaceholder'] = 'Фотографија изрезана, текст промењен, итд.';
$string['close'] = 'Затвори';
$string['confirmdialogbody'] = 'Потврдите да желите да наставите. Ова акција је неповратна.';
$string['confirmdialogheader'] = 'Потврди акцију';
$string['confirmlabel'] = 'Потврди';
$string['contentchanged'] = 'Овај интерактивни садржај је промењен од када сте га последњи пут користили.';
$string['contentstatefrequency'] = 'Учесталост снимања статуса интерактивног садржаја';
$string['contentstatefrequency_help'] = 'Временски период, у секундама, колико често желите да корисници аутоматски чувају свој напредак. Повећајте овај број ако имате проблема са великим бројем AJAX захтева.';
$string['contenttype'] = 'Тип интерактивног садржаја';
$string['contenttypecacheheader'] = 'Кеш интерактивног садржаја';
$string['copyright'] = 'Права коришћења';
$string['copyrightinfo'] = 'Информације о ауторским правима';
$string['copyrightstring'] = 'Ауторска права';
$string['copyrighttitle'] = 'Погледајте информације о ауторским правима за овај интерактивни садржај.';
$string['couldnotcopy'] = 'Није могуће копирати датотеку';
$string['couldnotsave'] = 'Није могуће сачувати датотеку';
$string['create'] = 'Креирај';
$string['creativecommons'] = 'Creative Commons';
$string['ctcachebuttonlabel'] = 'Ажурирајте кеш интерактивног садржаја';
$string['ctcacheconnectionfailed'] = 'Није могуће успоставити комуникацију са H5P чвориштем. Молимо, покушајте поново касније.';
$string['ctcachedescription'] = 'Ако водите рачуна да кеш интерактивних садржаја буде ажуран онда ћете моћи да прегледате, преузмете и користите најновије библиотеке. Ово се разликује од ажурирања самих библиотека.';
$string['ctcachelastupdatelabel'] = 'Последња промена';
$string['ctcacheneverupdated'] = 'Никад';
$string['ctcachenolibraries'] = 'Ниједан тип интерактивног садржаја није преузет са H5P чворишта. Молимо, покушајте поново касније.';
$string['ctcachesuccess'] = 'Кеш библиотеке је успешно ажуриран!';
$string['ctcachetaskname'] = 'Ажурирајте кеш интерактивног садржаја';
$string['currentpage'] = 'Страница $current од $total';
$string['dataviewreportlabel'] = 'Прикажи одговоре';
$string['date'] = 'Датум';
$string['disablefileextensioncheck'] = 'Онемогући проверу екстензије датотеке';
$string['disablefileextensioncheckwarning'] = 'Упозорење! Онемогућавање провере екстензије датотеке може да има последице по безбедност система, јер омогућава постављање PHP датотека. То би омогућило нападачима да покрену злонамерни кôд на вашем сајту. Проверите да ли знате тачно коју датотеку постављате.';
$string['disablefullscreen'] = 'Онемогући приказ преко целог екрана';
$string['disablehubconfirmationmsg'] = 'Да ли и даље желите да омогућите чвориште?';
$string['disablehubdescription'] = 'Препоручује се да ова опција буде омогућена. H5P чвориште обезбеђује једноставан интерфејс за преузимање нових типова интерактивног садржаја и ажурирање постојећих. Убудуће, ова опција ће, такође, олакшати дељење и поновно коришћење интерактивних садржаја. Ако је ова опција онемогућена, интерактивне садржаје ћете морати да инсталирати и ажурирати путем образаца за постављање датотека.';
$string['displayoptionalwaysshow'] = 'Увек прикажи';
$string['displayoptionauthoroff'] = 'Контролисано од стране аутора, стандардно искључено';
$string['displayoptionauthoron'] = 'Контролисано од стране аутора, стандардно укључено';
$string['displayoptiondownloadalways'] = 'Увек';
$string['displayoptiondownloadnever'] = 'Никад';
$string['displayoptiondownloadpermission'] = 'Само ако корисник има овлашћења да извезе H5P';
$string['displayoptionnevershow'] = 'Никад не приказуј';
$string['displayoptionpermissions'] = 'Прикажи само ако корисник има овлашћења да извезе H5P';
$string['displayoptionpermissionsembed'] = 'Прикажи само ако корисник има овлашћења да угради H5P';
$string['displayoptions'] = 'Опције приказа';
$string['download'] = 'Преузми';
$string['downloadfailed'] = 'Преузимање затражене библиотеке није успело.';
$string['downloadtitle'] = 'Преузмите овај интерактивни садржај као H5P датотеку.';
$string['editor'] = 'Едитор';
$string['embed'] = 'Угради';
$string['embedloginfailed'] = 'Немате приступ овом интерактивном садржају. Покушајте да се пријавите.';
$string['embedtitle'] = 'Прикажи уграђени кôд за овај интерактивни садржај.';
$string['empty'] = 'Нема доступних резултата';
$string['enableabout'] = 'Дугме ”О H5P”';
$string['enablecopyright'] = 'Дугме за ауторска права';
$string['enabledlrscontenttypes'] = 'Омогућите LRS зависан интераткиван садржај';
$string['enabledlrscontenttypes_help'] = 'Омогућава коришћење интерактивних садржаја који се ослањају  на LRS (Learning Record Store) како би функционисали исправно, као што је интерактивни садржај Упитник (Questionnaire).';
$string['enabledownload'] = 'Дозволи преузимање';
$string['enableembed'] = 'Угради дугме';
$string['enableframe'] = 'Прикажи траку акције и оквир';
$string['enablehublabel'] = 'Користи H5P чвориште';
$string['enablejavascript'] = 'Омогући JavaScript.';
$string['enablesavecontentstate'] = 'Сними статус интерактивног садржаја';
$string['enablesavecontentstate_help'] = 'Аутоматски се снима тренутно стање интерактивних садржаја за сваког корисника. То значи да корисник може да настави тамо где је стао.';
$string['failedtodownloadh5p'] = 'Није могуће преузети тражени H5P.';
$string['filenotfoundonserver'] = 'Датотека није пронађена на серверу. Проверите подешавања за постављање датотека.';
$string['filenotimage'] = 'Датотека није слика';
$string['filetypenotallowed'] = 'Тип датотеке није дозвољен.';
$string['finished'] = 'Завршено';
$string['fullscreen'] = 'Приказ преко целог екрана';
$string['gpl'] = 'General Public License v3';
$string['h5pfile'] = 'H5P датотека';
$string['h5ptitle'] = 'Посетите H5P.org како бисте пронашли више интересантних садржаја.';
$string['hide'] = 'Сакриј';
$string['hideadvanced'] = 'Сакриј напредна подешавања';
$string['hubcommunicationdisabled'] = 'Комуникација са H5P чвориштем је онемогућена јер је један или више H5P услова није испуњен.';
$string['hubisdisabled'] = 'Чвориште је онемогућено. Можете га поново омогућити у H5P подешавањима.';
$string['hubisdisableduploadlibraries'] = 'H5P чвориште је онемогућено док се овај проблем не реши. И даље можете поставити библиотеке преко странице "H5P библиотеке".';
$string['hubsettingsheader'] = 'Типови интерактивних садржаја';
$string['hvp:addinstance'] = 'Креирање нових H5P активности';
$string['hvp:getcachedassets'] = 'Потребно за преглед активности H5P активности';
$string['hvp:getembedcode'] = 'Приказ H5P кôда за уграђивање када је подешена опција \'контролисано путем овлашћења\'';
$string['hvp:getexport'] = 'Преузимање h5p датотеке када је подешена опција \'контролисано путем овлашћења\'';
$string['hvp:installrecommendedh5plibraries'] = 'Инсталирање нових безбедних типова H5P интерактивног садржаја које препоручује H5P.org';
$string['hvp:manage'] = 'Уређивање постојећих H5P активности';
$string['hvp:restrictlibraries'] = 'Ограничавање приступа одређеним типовима H5P интерактивног садржаја';
$string['hvp:savecontentuserdata'] = 'Чува податке о напредовању корисника за H5P активности';
$string['hvp:saveresults'] = 'Чува резултате из завршених H5P активности';
$string['hvp:updatelibraries'] = 'Инсталирање нових H5P типова интерактивног садржаја или ажурирање постојећих';
$string['hvp:userestrictedlibraries'] = 'Коришћење ограничених типова H5P интерактивног садржаја';
$string['hvp:view'] = 'Види и ступа у интеракцију са H5P активностима';
$string['hvp:viewallresults'] = 'Приказ свих резултата за завршених H5P активности';
$string['hvp:viewresults'] = 'Приказ сопствених резултата за завршене H5P активности';
$string['installdenied'] = 'Немате дозволу да инсталирате типове интерактивног садржаја. Обратите се администратору свог сајта.';
$string['installedlibraries'] = 'Инсталиране библиотеке';
$string['intro'] = 'Увод';
$string['invalidaudioformat'] = 'Неисправан формат аудио датотеке. Користите mp3 или wav.';
$string['invalidcontentfolder'] = 'Неисправан директоријум интерактивног садржаја';
$string['invalidcontenttype'] = 'Изабрани тип интерактивног садржаја није исправан.';
$string['invalidfieldtype'] = 'Неисправан тип датотеке';
$string['invalidfile'] = 'Датотеке "{$a->%filename}" није дозвољена. Дозвољене су само датотеке са следећим екстензијама: {$a->%files-allowed}.';
$string['invalidh5ppost'] = 'Није могуће послати H5P.';
$string['invalidimageformat'] = 'Неисправан формат графичке датотеке. Користите jpg, png или gif.';
$string['invalidlanguagefile'] = 'Неисправна језичка датотека {$a->%file} у библиотеци {$a->%library}';
$string['invalidlanguagefile2'] = 'Неисправна језичка датотека {$a->%languageFile} је укључена у библиотеку {$a->%name}';
$string['invalidlibrary'] = 'Неисправна библиотека';
$string['invalidlibrarydata'] = 'Добијени неисправни подаци за {$a->%property} у {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Добијени неисправни подаци за {$a->%property} у {$a->%library}. Очекивани су Булови логички оператори.';
$string['invalidlibraryname'] = 'Неисправан назив библиотеке: {$a->%name}';
$string['invalidlibrarynamed'] = 'Библиотека H5P {$a->%library} која се користи у интерактивном садржају није исправна';
$string['invalidlibraryoption'] = 'Недопуштена опција {$a->%option} in {$a->%library}';
$string['invalidlibraryproperty'] = 'Није могуће очитати својство {$a->%property} у {$a->%library}';
$string['invalidmainjson'] = 'Недостаје исправна главна h5p.json датотека';
$string['invalidmultiselectoption'] = 'Неисправно изабрана опција при избору више опција';
$string['invalidparameters'] = 'Неисправни параметри';
$string['invalidselectoption'] = 'Неисправно изабрана опција при избору опције';
$string['invalidsemanticsjson'] = 'Неисправна датотека semantics.json је укључена у датотеку {$a->%name}';
$string['invalidsemanticstype'] = 'H5P интерна грешка: непознати тип интерактивног садржаја "{$a->@type}" у семантици. Садржај се уклања!';
$string['invalidstring'] = 'Добијени стринг није исправан према правилима коришћења регуларних израза (regexp) у семантици (value: "{$a->%value}", regexp: "{$a->%regexp}").';
$string['invalidtoken'] = 'Неисправан безбедносни жетон';
$string['invalidvideoformat'] = 'Неисправан формат видео датотеке. Користите mp4 или webm.';
$string['invalidxapiresult'] = 'Нису пронађени xAPI резултати за дату комбинацију интерактивног садржаја и ID ознаке корисника';
$string['javascriptloading'] = 'Сачекајте да се покрене JavaScript...';
$string['libraries'] = 'H5P библиотеке';
$string['librarydirectoryerror'] = 'Назив директоријума библиотеке мора да се поклапа са machineName или machineName-majorVersion.minorVersion (из датотеке library.json). (Директоријум: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['librarylistactions'] = 'Акције';
$string['librarylistinstancedependencies'] = 'Зависности инстанце';
$string['librarylistinstances'] = 'Инстанце';
$string['librarylistlibrarydependencies'] = 'Зависности библиотеке';
$string['librarylistrestricted'] = 'Ограничено';
$string['librarylisttitle'] = 'Наслов';
$string['librarynotselected'] = 'Морате да изаберете тип интерактивног садржаја.';
$string['license'] = 'Лиценца';
$string['licenseCC010'] = 'CC0 1.0 Универзална лиценца (CC0 1.0) Посвећеност јавном власништву';
$string['licenseCC010U'] = 'CC0 1.0 Универзална лиценца';
$string['licenseCC10'] = '1.0 Нелокализована лиценца';
$string['licenseCC20'] = '2.0 Нелокализована лиценца';
$string['licenseCC25'] = '2.5 Нелокализована лиценца';
$string['licenseCC30'] = '3.0 Нелокализована лиценца';
$string['licenseCC40'] = '4.0 Међународна лиценца';
$string['licensee'] = 'Носилац лиценце';
$string['licenseextras'] = 'Додаци лиценце';
$string['licenseGPL'] = 'Општа јавна лиценца';
$string['licenseV1'] = 'Верзија 1';
$string['licenseV2'] = 'Верзија 2';
$string['licenseV3'] = 'Верзија 3';
$string['licenseversion'] = 'Верзија лиценце';
$string['loadingdata'] = 'Учитавање података';
$string['lookforupdates'] = 'Потражите нове верзије H5P-а';
$string['maximumgrade'] = 'Максимална оцена';
$string['maximumgradeerror'] = 'Унесите исправан позитивни цео број као максималан број поена који се може освојити за ову активност';
$string['maxpostsizetoosmall'] = 'Вредност вашег PHP подешавање за максималну величину поста (post_max_size) је премала. Са тренутним подешавањима, нећете моћи да поставите датотке које су веће од {$a->%number} MB. То може бити проблем када покушавате да поставите H5P активности, слике и видео записе. Повећајте ово подешавање на вредност већу од 5 MB.';
$string['maxscore'] = 'Максималан резултат';
$string['maxuploadsizetoosmall'] = 'Вредност вашег PHP подешавање за максималну величину датотеке за постављање (upload_max_filesize) је премала. Са тренутним подешавањима, нећете моћи да поставите датотке које су веће од {$a->%number} MB. То може бити проблем када покушавате да поставите H5P активности, слике и видео записе. Повећајте ово подешавање на вредност већу од 5 MB.';
$string['missingcontentfolder'] = 'Недостаје исправан директоријум интерактивног садржаја';
$string['missingcontentuserdata'] = 'Грешка: није могуће пронаћи корисничке податке за интерактивни садржај';
$string['missingcoreversion'] = 'Систем није могао да инсталира <em>{$a->%component}</em> компоненту из пакета; систем захтева новију верзију H5P додатка. Овај сајт тренутно користи верзију {$a->%current}, док је верзија која се захтева {$a->%required} или новија. Инсталирајте нову верзију додатка, а затим покушајте поново.';
$string['missingdependency'] = 'Недостаје зависност {$a->@dep} коју захтева {$a->@lib}.';
$string['missinglibrary'] = 'Недостаје неопходна библиотека {$a->@library}';
$string['missinglibraryfile'] = 'Датотека "{$a->%file}" недостаје у библиотеци: "{$a->%name}"';
$string['missinglibraryjson'] = 'Није могуће пронаћи library.json датотеку са исправном библиотеком {$a->%name}';
$string['missinglibraryproperty'] = 'Неопходно својство {$a->%property} недостаје у {$a->%library}';
$string['missingmbstring'] = 'PHP екстензија mbstring није учитана. H5P захтева ову екстензију како би исправно функционисано';
$string['missingparameters'] = 'Недостају параметри';
$string['missinguploadpermissions'] = 'Имајте на уму да у датотеци која је постављена  могу да постоје библиотеке, али вама није дозвољено да поставите нове библиотеке. Контактирајте администратора у вези са овим.';
$string['modulename'] = 'Интерактивни садржај';
$string['modulename_help'] = 'Модул активност H5P омогућава да креирате интерактивне садржаје, као што су интерактивни видео клипови, скупови питања, питања ”превуци и спусти”, питања вишеструког избора, презентације и још много тога.

Поред тога што представља ауторски алат за креирање богатог мултимедијалног садржаја, H5P вам пружа могућност да увезете и извезете H5P датотеке, како бисте их ефикасно поново користили и делили садржаје са другима.

Интеракције и њихови резултати се прате помоћу xAPI спецификације и доступни су у књизи оцена вашег Moodlea. Имајте на уму, да корисници са прогамерским вештинама могу да варају у H5P интеракцијама и да остваре максималан резултат а да притом не знају тачне одговоре. Због тога H5P не треба користити за проверу знања, поготово не сумативну.

Интерактивни H5P садржај додајете тако што креирате нови садржај користећи уграђени алат за креирање или тако што на сервер постављате H5P датотеке које сте пронашли на другим H5P сајтовима.';
$string['modulenameplural'] = 'Интерактивни садржај';
$string['nextpage'] = 'Следећа страница';
$string['noanswersubmitted'] = 'Овај корисник још није послао одговор на H5P';
$string['nocontent'] = 'Није могуће пронаћи или парсирати content.json датотеку';
$string['nocontenttype'] = 'Није наведен тип интерактивног садржаја.';
$string['nocopyright'] = 'Нема информација о ауторским правима за овај интерактивни садржај';
$string['nodata'] = 'Не постоје доступни подаци који одговарају вашим критеријумима.';
$string['noextension'] = 'Датотека коју сте поставили није исправан HTML5 пакет (нема екстензију датотеке .h5p).';
$string['noh5ps'] = 'Не постоји интерактивни садржај доступан за овај курс.';
$string['nojson'] = 'Главна h5p.json датотека није исправна';
$string['noparameters'] = 'Нема параметара';
$string['noparse'] = 'Није могуће парсирати главна h5p.json датотеку';
$string['nopermissiontogettranslations'] = 'Немате овлашћења за преузимање превода';
$string['nopermissiontorestrict'] = 'Немате овлашћења да ограничите библиотеке.';
$string['nopermissiontosavecontentuserdata'] = 'Немате овлашћења да сачувате корисничке податке за интерактивни садржај.';
$string['nopermissiontosaveresult'] = 'Немате овлашћења да сачувате резултате за овај интерактивни садржај.';
$string['nopermissiontoupgrade'] = 'Немате овлашћења да надоградите библиотеке.';
$string['nopermissiontouploadcontent'] = 'Немате овлашћења да поставите интерактивни садржај овде.';
$string['nopermissiontouploadfiles'] = 'Немате овлашћења да поставите датотеке овде.';
$string['nopermissiontoviewcontenttypes'] = 'Немате овлашћења да видите типове интерактивних садржаја.';
$string['nopermissiontoviewresult'] = 'Немате овлашћења да видите резултате за овај интерактивни садржај.';
$string['nosuchlibrary'] = 'Не постоји таква библиотека';
$string['notapplicable'] = 'N/A - није примењиво';
$string['nounzip'] = 'Датотека коју сте поставили није исправан HTML5 пакет (није могуће распаковати га).';
$string['noversionattribution'] = 'Ауторство';
$string['noversionattributionnc'] = 'Ауторство - Некомерцијална лиценца';
$string['noversionattributionncnd'] = 'Ауторство - Некомерцијална лиценца - Без прерада';
$string['noversionattributionncsa'] = 'Ауторство - Некомерцијална лиценца - Делити под истим условима';
$string['noversionattributionnd'] = 'Ауторство - Лиценца - Без прерада';
$string['noversionattributionsa'] = 'Ауторство - Лиценца - Делити под истим условима';
$string['nowriteaccess'] = 'Откривен је проблем са приступом за уписивање на серверу. Проверите да ли ваш сервер може да уписује у ваш директоријум са подацима.';
$string['noziparchive'] = 'Ваша PHP верзија не подржава ZipArchive.';
$string['oldphpversion'] = 'Ваша PHP верзија је застарела. H5P захтева верзију 5.2. како би исправно функционисано. Препоручује се верзија 5.6 или новија.';
$string['olduploadoldcontent'] = 'Покушавате да поставите старију верзију H5P садржаја. Надоградите интерактивни садржај на серверу на којем се налази и покушајте поново да га поставите или укључите H5P чвориште како би сервер аутоматски надоградио интерактивни садржај.';
$string['onlyupdate'] = 'Ажурирај само постојеће библиотеке';
$string['options'] = 'Опције';
$string['originator'] = 'Креатор';
$string['pd'] = 'Јавно власништво';
$string['pddl'] = 'Посвећеност јавном власништву и лиценца';
$string['pdm'] = 'Ознака јавног власништва';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['postmessagerequired'] = 'За приступ датој крајњој тачки потребна је порука';
$string['previouspage'] = 'Претходна страница';
$string['privacy:metadata:core_files'] = 'H5P активност чува датотеке које су постављене као део H5P садржаја.';
$string['privacy:metadata:core_grades'] = 'H5P активност чува оцене корисника који су одговорили на H5P садржај.';
$string['privacy:metadata:hvp_content_user_data'] = 'Описује тренутно стање у којем се налази интерактивни садржај за корисника. Користи се за враћање интерактивног садржаја у претходно стање.';
$string['privacy:metadata:hvp_content_user_data:data'] = 'Кориснички подаци који се чувају.';
$string['privacy:metadata:hvp_content_user_data:data_id'] = 'Идентификатор типа података.';
$string['privacy:metadata:hvp_content_user_data:delete_on_content_change'] = 'Ознака (заставица) која обележава да ли податке треба обрисати када се интерактивни садржај промени.';
$string['privacy:metadata:hvp_content_user_data:hvp_id'] = 'ID ознака H5P садржаја којем подаци припадају.';
$string['privacy:metadata:hvp_content_user_data:id'] = 'ID ознака везе између интерактивног садржаја и корисничких података.';
$string['privacy:metadata:hvp_content_user_data:preloaded'] = 'Ознака (заставица) која обележава да ли податке треба унапред учитати у интерактивни садржај.';
$string['privacy:metadata:hvp_content_user_data:sub_content_id'] = 'Подсадржај H5P, 0 ако ово није подсадржај.';
$string['privacy:metadata:hvp_content_user_data:user_id'] = 'ID ознака корисника којем подаци припадају.';
$string['privacy:metadata:hvp_events'] = 'Праћење записа';
$string['privacy:metadata:hvp_events:content_id'] = 'ID ознака интерактивног садржаја на којем је извршена акција. 0 ако је реч о новом интерактивном садржају или ако нема садржаја.';
$string['privacy:metadata:hvp_events:content_title'] = 'Наслов интерактивног садржаја';
$string['privacy:metadata:hvp_events:created_at'] = 'Време када је догађај креиран.';
$string['privacy:metadata:hvp_events:id'] = 'Јединствени ID ознака догађаја.';
$string['privacy:metadata:hvp_events:library_name'] = 'Библиотека на коју догађај утиче.';
$string['privacy:metadata:hvp_events:library_version'] = 'Верзија библиотека на коју догађај утиче.';
$string['privacy:metadata:hvp_events:sub_type'] = 'Подврста догађаја, акције или догађаја.';
$string['privacy:metadata:hvp_events:type'] = 'Врста догађаја';
$string['privacy:metadata:hvp_events:user_id'] = 'ID ознака корисника који је извео акцију.';
$string['privacy:metadata:hvp_xapi_results'] = 'Чува xAPI догађаје у H5P садржају.';
$string['privacy:metadata:hvp_xapi_results:additionals'] = 'Додатне информације које H5P може да пошаље.';
$string['privacy:metadata:hvp_xapi_results:content_id'] = 'ID ознака интерактивног садржаја на којем је догађај изведен.';
$string['privacy:metadata:hvp_xapi_results:correct_responses_pattern'] = 'Шаблон тачног одговора';
$string['privacy:metadata:hvp_xapi_results:description'] = 'Опис, задатак или питање интерактивног садржаја на којем је изведена акција.';
$string['privacy:metadata:hvp_xapi_results:id'] = 'Јединствена ID ознака xAPI догађаја.';
$string['privacy:metadata:hvp_xapi_results:interaction_type'] = 'Тип интеракције.';
$string['privacy:metadata:hvp_xapi_results:max_score'] = 'Максимална резултат који се може постићи за овај догађај.';
$string['privacy:metadata:hvp_xapi_results:parent_id'] = 'ID ознака матичног садржаја којем припада интерактивни садржај на којем је овај догађај изведен. Нула ако матични садржај не постоји.';
$string['privacy:metadata:hvp_xapi_results:raw_score'] = 'Постигнут резултат за догађај.';
$string['privacy:metadata:hvp_xapi_results:response'] = 'Одговор који је корисник послао.';
$string['privacy:metadata:hvp_xapi_results:user_id'] = 'ID ознака корисника који је извео акцију.';
$string['question'] = 'Питање';
$string['removeoldlogentries'] = 'Уклоните старе H5P записе';
$string['removeoldmobileauthentries'] = 'Уклоните старе H5P';
$string['removetmpfiles'] = 'Уклоните старе H5P привремене датотеке';
$string['reportingquestionsremaininglabel'] = 'питања која остају да буду оцењена';
$string['reportingscaledscoredelimiter'] = ',';
$string['reportingscaledscorelabel'] = 'Резултат у дневнику оцена:';
$string['reportingscoredelimiter'] = 'од';
$string['reportingscorelabel'] = 'Резултат:';
$string['reportnotsupported'] = 'Није подржан';
$string['reportsubmitgradelabel'] = 'Пошаљи оцену';
$string['resizescript'] = 'Укључите овај скрипт на свом сајту ако желите динамичку промену величине уграђеног интерактивног садржаја:';
$string['reuse'] = 'Поновно коришћење';
$string['reveal'] = 'Откриј';
$string['reviseserversetupandretry'] = 'Када ревидирате подешавања вашег сервера, можете поново омогућити комуникацију са H5P чвориштем у H5P подешавањима.';
$string['score'] = 'Резултат';
$string['search'] = 'Претражи';
$string['sendusagestatistics'] = 'Дајте свој допринос статистици коришћења';
$string['sendusagestatistics_help'] = 'Статистички подаци о коришћењу аутоматски ће бити прослеђени како би помогли програмерима да боље разумеју како се H5P користи и како би се одредиле потенцијалне области побољшања. Прочитајте више о томе који се <a {$a}>подаци прикупљају на h5p.org</a>.';
$string['settings'] = 'H5P подешавања';
$string['showadvanced'] = 'Прикажи напредна подешавања';
$string['showless'] = 'Прикажи мање';
$string['showmore'] = 'Прикажи више';
$string['sitecouldnotberegistered'] = 'Сајт није могао бити регистрован на H5P чворишту. Обратите се администратору сајта.';
$string['sitekey'] = 'Кључ сајта';
$string['sitekeydescription'] = 'Кључ сајта је јединствени тајни кључ који служи за идентификацију овог сајта на чворишту.';
$string['sitekeyregistered'] = 'Добили сте јединствени кључ који вас идентификује на чворишту приликом преузимања нових верзија и исправки. Кључ је доступан на страници "H5P подешавања".';
$string['size'] = 'Величина';
$string['source'] = 'Извор';
$string['sslnotenabled'] = 'Ваш сервер нема укључен SSL. SSL треба да укључити како би се обезбедила безбедна веза са H5P чвориштем.';
$string['startingover'] = 'Започећете из почетка';
$string['sublevel'] = 'Подниво';
$string['successfullyregisteredwithhub'] = 'Ваш сајт је успешно регистрован на H5P чворишту.';
$string['thumbnail'] = 'Умањена верзија слика';
$string['title'] = 'Наслов';
$string['unabletocreatedir'] = 'Није могуће креирати директоријум.';
$string['unabletogetfieldtype'] = 'Није могуће преузети тип поља.';
$string['undisclosed'] = 'Неоткривено';
$string['updatedlibraries'] = 'Ажурирано старих H5P библиотека {$a->%old}.';
$string['updatedlibrary'] = 'Ажурирана {$a->%old} H5P библиотека.';
$string['updatelibraries'] = 'Ажурирај све библиотеке';
$string['upgrade'] = 'Надогради H5P';
$string['upgradebuttonlabel'] = 'Надогради';
$string['upgradedone'] = 'Успешно сте надоградили {$a} инстанцу/е/и садржаја';
$string['upgradeerror'] = 'Дошло је до грешке приликом обраде параметара:';
$string['upgradeerrorcontent'] = 'Није могуће надоградити интерактивни садржај %id:';
$string['upgradeerrordata'] = 'Није могуће учитати податке за библиотеку %lib.';
$string['upgradeerrormissinglibrary'] = 'Недостаје обавезна библиотека %lib.';
$string['upgradeerrornotsupported'] = 'Параметри садрже %used који није подржан.';
$string['upgradeerrorparamsbroken'] = 'Параметри су неисправни.';
$string['upgradeerrorscript'] = 'Није могуће учитати скрипт за надоградњу за %lib.';
$string['upgradeerrortoohighversion'] = 'Параметри садрже %used док су подржани само %supported или новије верзије.';
$string['upgradeheading'] = 'Надогради интерактивни садржај {$a}';
$string['upgradeinprogress'] = 'Надоградња на %ver...';
$string['upgradeinvalidtoken'] = 'Грешка: неисправан безбедносни жетон!';
$string['upgradelibrarycontent'] = 'Надогради садржај библиотеке';
$string['upgradelibrarymissing'] = 'Грешка: ваша библиотека недостаје!';
$string['upgrademessage'] = 'Намеравате да надоградите {$a} инстанцу/е/и садржаја. Молимо, изаберите верзију за надоградњу.';
$string['upgradenoavailableupgrades'] = 'Не постоје доступна надоградње за ову библиотеку.';
$string['upgradenothingtodo'] = 'Не постоје инстанце интерактивног садржаја за надоградњу.';
$string['upgradereturn'] = 'Повратак';
$string['upload'] = 'Постави';
$string['uploadlibraries'] = 'Постави библиотеке';
$string['uploadsizelargerthanpostsize'] = 'Вредност вашег PHP подешавање за максималну величину датотеке за постављање  (upload_max_filesize) је мања од вредности подешавање за максималну величину поста (post_max_size). Познато је да ово узрокује проблеме у неким инсталацијама.';
$string['user'] = 'Корисник';
$string['validatingh5pfailed'] = 'Провера исправности h5p пакета није успела.';
$string['validationfailed'] = 'Тражени H5P није био исправан';
$string['viewreportlabel'] = 'Извештај';
$string['welcomecommunity'] = 'Надамо се да ћете уживати у H5P-у и да ћете се придружити  нашој растућој заједници путем наших  <a {$a->forums}>форума</a> и причаонице <a {$a->gitter}>H5P на Gitter платформи</a>';
$string['welcomecontactus'] = 'Уколико имате било какве повратне информације, не устручавајте се да <a {$a}>нас контактирате</a>. Ми све повратне информације узимамо веома озбиљно и посвећени смо томе да H5P буде бољи сваки дан!';
$string['welcomegettingstarted'] = 'Да бисте започели коришћењем H5P-а и Moodlea погледајте наш <a {$a->moodle_tutorial}>водич</a>. Такође, погледајте, инспирације ради, <a {$a->example_content}>пример интерактивног садржаја</a> на H5P.org.<br>Како бисте лакше користили H5P инсталирани су најпопуларнији типови садржаја!';
$string['welcomeheader'] = 'Добро дошли у H5P свет!';
$string['wrongversion'] = 'Верзија H5P библиотеке {$a->%machineName} коришћена у овом садржају није исправна. Интерактивни садржај садржи {$a->%contentLibrary}, али би требало да буде {$a->%semanticsLibrary}.';
$string['year'] = 'Година';
$string['years'] = 'Година/e';
$string['yearsfrom'] = 'Године (од)';
$string['yearsto'] = 'Године (до)';
