<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'qbehaviour_deferredcbm', language 'no', branch 'MOODLE_37_STABLE'
 *
 * @package   qbehaviour_deferredcbm
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accuracy'] = 'Nøyaktighet';
$string['accuracyandbonus'] = 'Nøyaktighet + bonus';
$string['assumingcertainty'] = 'Du valgte ingen grad av sikkerhet. Antar: {$a}.';
$string['averagecbmmark'] = 'Gjennomsnittlig CBM-vurdering';
$string['basemark'] = 'Base mark {$a}';
$string['breakdownbycertainty'] = 'Brutt ned etter grad av sikkerhet';
$string['cbmbonus'] = 'CBM bonus';
$string['cbmgradeexplanation'] = 'For CBM, vil karakteren over vises relativt til maksimum for alt riktig ved C=1.';
$string['cbmgrades'] = 'CBM karakterer';
$string['cbmgrades_help'] = 'Det er foreløpig ikke noen god norsk oversettelse av "Certainty Based Marking"(CBM), men dette handler om at svarene som avgis også må merkes med grad av sikkerhet på om avgitt svar er korrekt.

C=1 er med liten av grad av sikkerhet og svarer du riktig her får du 100% riktig svar. Du kan få opptil 300% bedömning om dette er kombinert med høy grad av sikkerhet (C=3)

Misoppfattelser med høy grad av sikkerhet kan derfor lede til mye dårligere bedømming enn avgitte svar som er merket med liten grad av sikkerhet. Dette kan tilogmed føre til negative karakterer.

**Nøyaktighet** er en prosentverdi av sikkerheten vektet mot maksimum oppnåelig for hvert spørsmål.

Hvis du skiller mellom grad av sikkerhet på hvert spørsmål kan du derfor oppnå en bedre karakter enn om du tilsynelatende er like sikker på alt.
Dette reflekteres i en  **CBM Bonus**. **Nøyaktivitet** + **CBM Bonus** er et bedre mål på kunnskap enn bare **Nøyaktighet**.
Misoppfattelser kan føre til negativ bonus, og vil derfor fungere godt som et varsel om at en bør se nærmere på hva en vet og ikke vet.';
$string['cbmmark'] = 'CBM karakter {$a}';
$string['certainty'] = 'Grad av sikkerhet';
$string['certainty1'] = 'Ikke veldig (mindre enn 67%)';
$string['certainty-1'] = 'Vet ikke';
$string['certainty2'] = 'Ganske (mer enn 67%)';
$string['certainty3'] = 'Veldig (mer enn 80%)';
$string['certainty_help'] = 'CBM krever at du angir hvor sikker du er på svaret ditt. De tilgjengelige nivåene er:

Certainty level     | C=1 (Ikke veldig) | C=2 (Ganske) | C=3 (Veldig sikker)
------------------- | ------------ | --------- | ----------------
Poeng hvis korrekt     |   1          |    2      |      3
Poeng hvis feil      |   0          |   -2      |     -6
Sannsynlighet for korrekt svar|  <67%        | 67-80%    |    >80%

De beste karakterene oppnås ved å vedkjenne usikkerhet. om du for eksempel tror det er mer en 1/3 sannsynlighet for feil svar, burde du velge "Ikke veldig" og unngå negativ poeng på spørsmålet.';
$string['certaintyshort1'] = 'Ikke veldig sikker';
$string['certaintyshort-1'] = 'Vet ikke';
$string['certaintyshort2'] = 'Ganske sikker';
$string['certaintyshort3'] = 'Veldig sikker';
$string['dontknow'] = 'Vet ikke';
$string['foransweredquestions'] = 'Resultatet for kun de {$a} besvarte spørsmålene';
$string['forentirequiz'] = 'Resultatet for hele quizen ({$a} spørsmål)';
$string['howcertainareyou'] = 'Grad av sikkerhet {$a->help}: {$a->choices}';
$string['judgementok'] = 'OK';
$string['judgementsummary'] = 'Reponser: {$a->responses}. Nøyaktighet: {$a->fraction}. (Optimalt spenn {$a->idealrangelow} til {$a->idealrangehigh}). Du har {$a->judgement} med denne graden av sikkerhet.';
$string['noquestions'] = 'Ingen svar';
$string['overconfident'] = 'For selvsikker';
$string['pluginname'] = 'Utsatt tilbakemelding med CBM';
$string['privacy:metadata'] = 'Modulen "Utsatt tilbakemelding med CBM" lagrer ikke noen persondata.';
$string['slightlyoverconfident'] = 'Litt for selvsikker';
$string['slightlyunderconfident'] = 'Litt for lite selvsikker';
$string['underconfident'] = 'For lite selvsikker';
$string['weightx'] = 'Vekting {$a}';
