<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'plagiarism_turnitinsim', language 'no', branch 'MOODLE_37_STABLE'
 *
 * @package   plagiarism_turnitinsim
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessoptions'] = 'Studenttilgang';
$string['accessoptions_help'] = 'Studenter vil få tilgang til likhetsrapporten for innsendingen sin etter at den er produsert.';
$string['accessstudents'] = 'La studenter få se likhetsrapporter';
$string['addtoindex'] = 'Indekser alle innsendinger';
$string['code'] = 'Kode';
$string['connecttest'] = 'Test Turnitin-forbindelsen';
$string['connecttestfailed'] = 'Tilkoblingstesten mislyktes.';
$string['connecttestsuccess'] = 'Tilkoblingstesten var vellykket';
$string['dbexport'] = 'Databaseeksport';
$string['dbexporttable'] = 'Eksporter {$a} data';
$string['defaultsettings'] = 'Standardinnstillinger';
$string['errortoolarge'] = 'Denne filen vil ikke bli sendt til Turnitin fordi den overskrider maksimal tillatt størrelse på {$a}';
$string['eulaaccept'] = 'Jeg godtar Turnitins lisensavtale';
$string['eulaaccepted'] = 'Takk for at du godtok den nye Turnitin lisensavtalen. Alle fremtidige innsendinger vil nå bli sendt til Turnitin for behandling.';
$string['eulaalreadyaccepted'] = 'Du har allerede godkjent Turnitins nyeste sluttbrukeravtale.';
$string['euladecline'] = 'Jeg avviser Turnitins lisensavtale';
$string['euladeclined'] = 'Innsendingene dine vil ikke bli sendt til Turnitin, siden du ikke har godkjent Turnitins lisensavtale for sluttbrukere.';
$string['eulaheader'] = 'Turnitin lisensavtale for sluttbrukere';
$string['eulalink'] = 'For at denne innsendingen skal sendes til Turnitin, må du godta <a href="#" class="eula_link">Turnitins lisensavtale for sluttbrukere</a>.';
$string['eulalinkgeneric'] = 'Hvis du vil at noen av de fremtidige innsendingene dine skal sendes til Turnitin, må du godta <a href="{$a}" target="_blank">Turnitins lisensavtale for sluttbrukere</a>.';
$string['eulalinkmodal'] = 'For at denne innsendingen skal sendes til Turnitin, må du godta <a href="#" class="eula_link">Turnitins lisensavtale for sluttbrukere</a>.';
$string['eulanotrequired'] = 'Du trenger ikke å godkjenne Turnitins sluttbrukeravtale.';
$string['excludebiblio'] = 'Bibliografi';
$string['excludeoptions'] = 'Utelukk fra likhetsrapporter';
$string['excludeoptions_help'] = 'De valgte alternativene vil ikke bli vist som en match i likhetsrapporter.';
$string['excludequotes'] = 'Anførselstegn';
$string['faultcode'] = 'Feilkode';
$string['getwebhookfailure:message'] = 'Det er kanskje et problem med en webhook du har registrert hos Turnitin for plagiat-plugin. Den planlagte oppgaven for å kontrollere den kunne ikke koble til Turnitin. Sjekk loggfilene.';
$string['getwebhookfailure:subject'] = 'Turnitin webhook-kontroll mislyktes';
$string['indexoptions'] = 'Innsendingsindeksering';
$string['indexoptions_help'] = 'Indekserte innsendinger vil være tilgjengelige for sammenligning i likhetsrapporter.';
$string['invalidtablename'] = 'Tabell {$a} kunne ikke eksporteres';
$string['line'] = 'Linje';
$string['loadingcv'] = 'Laster Turnitin Viewer';
$string['message'] = 'Melding';
$string['messageprovider:digital_receipt_instructor'] = 'Instruktørens digitale Turnitin-kvittering';
$string['messageprovider:digital_receipt_student'] = 'Studentens digitale Turnitin-kvittering';
$string['messageprovider:get_webhook_failure'] = 'Turnitin webhook-kontroll mislyktes';
$string['messageprovider:new_eula'] = 'Ny utgave av Turnitins lisensavtale er frigitt';
$string['neweula:message'] = 'Turnitin har frigitt en ny lisensavtale. Klikk <a href="{$a}">her</a> for mer informasjon.';
$string['neweula:subject'] = 'Turnitin har frigitt ny utgave av lisensavtalen';
$string['pluginname'] = 'Turnitin integritets-plugin';
$string['pluginsetup'] = 'Oppsett';
$string['privacy:metadata:plagiarism_turnitinsim_client'] = 'For å sende inn noe til Turnitin, må spesifikke brukerdata utveksles mellom Moodle og Turnitin. For mer informasjon omkring Moodle-plugin og personvernforordningen GDPR, gå til https://help.turnitin.com/feedback-studio/moodle/moodle-plugins-and-gdpr.htm';
$string['privacy:metadata:plagiarism_turnitinsim_client:firstname'] = 'Brukerens fornavn sendes til Turnitin når Turnitin Viewer startes slik at brukeren kan identifiseres.';
$string['privacy:metadata:plagiarism_turnitinsim_client:lastname'] = 'Brukerens etternavn sendes til Turnitin når Turnitin Viewer startes slik at brukeren kan identifiseres.';
$string['privacy:metadata:plagiarism_turnitinsim_client:submission_content'] = 'Legg merke til at innholdet i en fil/innsending sendes til Turnitin for behandling.';
$string['privacy:metadata:plagiarism_turnitinsim_client:submission_filename'] = 'Navnet på den innsendte filen sendes til Turnitin slik at den er identifiserbar.';
$string['privacy:metadata:plagiarism_turnitinsim_client:submission_title'] = 'Tittelen på innsendingen er sendt til Turnitin slik at den er identifiserbar.';
$string['privacy:metadata:plagiarism_turnitinsim_sub'] = 'Informasjon som kobler en Moodle-innsending til en Turnitin-innsending.';
$string['privacy:metadata:plagiarism_turnitinsim_sub:identifier'] = 'En hash som brukes av Moodle for å identifisere den innsendte filen.';
$string['privacy:metadata:plagiarism_turnitinsim_sub:itemid'] = 'ID som identifiserer innsendingen for den relevante modultypen.';
$string['privacy:metadata:plagiarism_turnitinsim_sub:overallscore'] = 'Innsendingens totale likhetsscore.';
$string['privacy:metadata:plagiarism_turnitinsim_sub:submittedtime'] = 'Et tidsstempel som indikerer når brukerens innsending ble sendt til Turnitin.';
$string['privacy:metadata:plagiarism_turnitinsim_sub:turnitinid'] = 'ID brukt av Turnitin som referanse til innsendingen.';
$string['privacy:metadata:plagiarism_turnitinsim_sub:userid'] = 'ID til brukeren som har gjort innsendingen.';
$string['privacy:metadata:plagiarism_turnitinsim_users'] = 'Informasjon som kobler en Moodle-bruker til en Turnitin-bruker.';
$string['privacy:metadata:plagiarism_turnitinsim_users:lasteulaaccepted'] = 'Den siste versjonen av Turnitin lisensavtale som brukeren godtok.';
$string['privacy:metadata:plagiarism_turnitinsim_users:lasteulaacceptedlang'] = 'Språket som brukeren sist godtok Turnitin lisensavtale på.';
$string['privacy:metadata:plagiarism_turnitinsim_users:lasteulaacceptedtime'] = 'Et tidsstempel som indikerer når brukeren sist godtok Turnitins lisensavtale.';
$string['privacy:metadata:plagiarism_turnitinsim_users:turnitinid'] = 'ID brukt av Turnitin som referanse til brukeren.';
$string['privacy:metadata:plagiarism_turnitinsim_users:userid'] = 'ID til brukeren som har gjort innsendingen.';
$string['queuedrafts'] = 'Behandle kladdeinnsendinger';
$string['queuedrafts_help'] = 'Legg merke til at kladdeinnsendinger ikke blir indeksert i Turnitin for å kontrolleres mot';
$string['receiptsinstructor:message'] = 'En innsending med tittelen <strong>{$a->submission_title}</strong> som ble gjort til modulen <strong>{$a->module_name}</strong> i klassen <strong>{$a->course_fullname}</strong> har blitt sendt til Turnitin.<br /><br />Innsendings-ID: <strong>{$a->submission_id}</strong><br />Innsendingsdato: <strong>{$a->submission_date}</strong>';
$string['receiptsinstructor:subject'] = 'Innsending sendt til Turnitin';
$string['receiptstudent:message'] = 'Kjære {$a->firstname} {$a->lastname},<br /><br />filen <strong>{$a->submission_title}</strong> til modulen <strong>{$a->module_name}</strong> i klassen <strong>{$a->course_fullname}</strong> har blitt sendt til Turnitin den <strong>{$a->submission_date}</strong>.';
$string['receiptstudent:subject'] = 'Dette er din digitale Turnitin-kvittering';
$string['reportgen0'] = 'Umiddelbart';
$string['reportgen1'] = 'Umiddelbart og produser på nytt på forfallsdato';
$string['reportgen2'] = 'Forfallsdato';
$string['reportgenoptions'] = 'Produser likhetsrapporter';
$string['reportgenoptions_help'] = '<strong>Umiddelbart:</strong> Likhetsrapporter blir produsert umiddelbart etter at filen er sendt inn.<br/><br/><strong>Tidsfrist:</strong> Likhetsrapporter blir bare produsert på  oppgavens forfallsdato.<br/><br/><strong>Umiddelbart og på forfallsdato:</strong> En likhetsrapport blir opprettet umiddelbart etter filen er sendt inn.';
$string['resubmittoturnitin'] = 'Send til Turnitin en gang til';
$string['savesuccess'] = 'Endringer lagret';
$string['settingslearnmore'] = 'Finn ut mer om Turnitin-innstillinger';
$string['submissiondisplayerror:cannotextracttext'] = 'Rapporten er ikke tilgjengelig';
$string['submissiondisplayerror:cannotextracttext_help'] = 'En rapport kunne ikke produseres for denne innsendingen. Dette kan være fordi denne filtypen ikke kan produsere en rapport eller at det ikke er nok tekst.';
$string['submissiondisplayerror:corruptfile'] = 'Ødelagt fil';
$string['submissiondisplayerror:corruptfile_help'] = 'Filen som er lastet opp synes å være ødelagt.';
$string['submissiondisplayerror:eulanotaccepted'] = 'Lisensavtalen er ikke godtatt';
$string['submissiondisplayerror:eulanotaccepted_help'] = 'Innsenderen må godta Turnitins lisensavtale før innsendingen kan kontrolleres for likhet.';
$string['submissiondisplayerror:filelocked'] = 'Filen er låst';
$string['submissiondisplayerror:filelocked_help'] = 'Den opplastede filen krever et passord for å kunne åpnes.';
$string['submissiondisplayerror:generic'] = 'Filen ble ikke sendt til Turnitin';
$string['submissiondisplayerror:generic_help'] = 'Denne filen har ikke blitt sendt til Turnitin. Snakk med systemansvarlige';
$string['submissiondisplayerror:notsent'] = 'Filen ble ikke sendt til Turnitin';
$string['submissiondisplayerror:notsent_help'] = 'Denne filen har ikke blitt sendt til Turnitin fordi Turnitin ikke var aktivert på tidspunktet for innsending. Endre eller last opp innsendingen din på nytt hvis du vil at den skal sendes til Turnitin.';
$string['submissiondisplayerror:processingerror'] = 'Behandlingsfeil';
$string['submissiondisplayerror:processingerror_help'] = 'En uspesifisert feil oppstod under behandling av innsendingene.';
$string['submissiondisplayerror:toolarge'] = 'Filen er for stor';
$string['submissiondisplayerror:toolarge_help'] = 'Denne filen er for stor til å sende til Turnitin. For å kontrollere originaliteten, send inn en fil som er under 100 MB.';
$string['submissiondisplayerror:toolittletext'] = 'Ikke nok tekst';
$string['submissiondisplayerror:toolittletext_help'] = 'Innsendingen har ikke nok tekst til å produsere en likhetsrapport (en innsending må minst inneholde 20 ord)';
$string['submissiondisplayerror:toomanypages'] = 'For mange sider';
$string['submissiondisplayerror:toomanypages_help'] = 'Innsendingen har for mange sider til å produsere en likhetsrapport (en innsending kan ikke inneholde mer enn 400 sider)';
$string['submissiondisplayerror:toomuchtext'] = 'For mye tekst';
$string['submissiondisplayerror:toomuchtext_help'] = 'Innsendingen har for mye tekst til å produsere en likhetsrapport (etter at uttrukket tekst er konvertert til UTF-8, må innsendingen inneholde mindre enn {$a} med tekst)';
$string['submissiondisplayerror:unknown'] = 'Det var en feil med innsendingen din';
$string['submissiondisplayerror:unknown_help'] = 'Det var en ukjent feil med innsendingen din og denne filen har ikke blitt sendt til Turnitin. Snakk med systemansvarlige.';
$string['submissiondisplayerror:unsupportedfiletype'] = 'Filtype som ikke støttes';
$string['submissiondisplayerror:unsupportedfiletype_help'] = 'Filtypen som ble lastet opp støttes ikke.';
$string['submissiondisplaystatus:awaitingeula'] = 'Venter på lisensavtalen';
$string['submissiondisplaystatus:cannotextracttext'] = 'Rapporten er ikke tilgjengelig';
$string['submissiondisplaystatus:error'] = 'Feil';
$string['submissiondisplaystatus:notsent'] = 'Ikke sendt';
$string['submissiondisplaystatus:pending'] = 'Venter';
$string['submissiondisplaystatus:queued'] = 'Satt i kø';
$string['submissiondisplaystatus:unknown'] = 'Ukjent feil';
$string['taskadminupdate'] = 'Oppdater den lokale konfigurasjonen for Turnitin integritets-plugin';
$string['taskgetreportscores'] = 'Hent rapportscore for Turnitin integritets-plugin';
$string['taskoutputenabledfeaturesnotretrieved'] = 'Turnitins aktiverte funksjoner kunne ikke hentes';
$string['taskoutputenabledfeaturesretrievalfailure'] = 'Kall av Turnitin aktiverte funksjoner mislyktes';
$string['taskoutputenabledfeaturesretrieved'] = 'Turnitins aktiverte funksjoner ble hentet';
$string['taskoutputfailedconnection'] = 'Det oppstod et problem med tilkoblingen til Turnitin-API-en';
$string['taskoutputfailedcvlaunchurl'] = 'Det oppstod et problem med å be om en start-URL for Turnitin Viewer fra Turnitin-API-en for innsendings-ID: {$a}';
$string['taskoutputfailedreportrequest'] = 'Det oppstod et problem med å få opprettet en originalitetsrapport fra Turnitin-API-en for innsendings-ID: {$a}';
$string['taskoutputfailedscorerequest'] = 'Det oppstod et problem med å få en originalitetsrapportscore fra Turnitin-API-en for innsendings-ID: {$a}';
$string['taskoutputfailedupload'] = 'Det oppstod et problem med å laste opp en fil til Turnitin-API-en for innsendings-ID: {$a}';
$string['taskoutputfileuploaded'] = 'Fil som er lastet opp til Turnitin-innsending: {$a}';
$string['taskoutputlatesteulanotretrieved'] = 'Siste lisensavtaleversjon kunne ikke hentes';
$string['taskoutputlatesteularetrievalfailure'] = 'Siste kall av lisensavtaleversjon var mislykket.';
$string['taskoutputlatesteularetrieved'] = 'Lisensavtaleversjon {$a} ble hentet.';
$string['taskoutputpluginnotconfigured'] = 'Oppgaven til {$a} kunne ikke kjøres siden Turnitins integritets-plugin ikke er konfigurert.<br/>Gå til siden for plugin-konfigurering i Site Administration for å legge inn din Turnitin API-legitimasjon.';
$string['taskoutputsubmissioncreated'] = 'Innsending opprettet i Turnitin: {$a}';
$string['taskoutputsubmissionnotcreatedeula'] = 'Innsendingen kunne ikke opprettes i Turnitin fordi innsenderen ikke har godtatt lisensavtalen.';
$string['taskoutputsubmissionnotcreatedgeneral'] = 'Innsendingen kunne ikke opprettes i Turnitin. Sjekk loggfilene.';
$string['taskoutputwebhookcreated'] = 'Webhook er opprettet. Turnitin vil sende tilbakekall til {$a}';
$string['taskoutputwebhookcreationfailure'] = 'Forespørselen om å opprette en webhook var mislykket. Sjekk loggfilene.';
$string['taskoutputwebhookdeleted'] = 'Webhook {$a} er slettet.';
$string['taskoutputwebhookdeletefailure'] = 'Webhook kunne ikke slettes. Sjekk loggfilene.';
$string['taskoutputwebhooknotcreated'] = 'Webhook kunne ikke opprettes. Sjekk loggfilene.';
$string['taskoutputwebhooknotdeleted'] = 'Webhook {$a} kunne ikke slettes.';
$string['taskoutputwebhooknotretrieved'] = 'Webhook {$a} kunne ikke hentes. En ny webhook vil bli opprettet';
$string['taskoutputwebhookretrievalfailure'] = 'Webhook {$a} hentekall mislyktes.';
$string['taskoutputwebhookretrieved'] = 'Webhook {$a} ble hentet. Webhook er aktiv.';
$string['tasksendqueuedsubmissions'] = 'Send filer i kø fra Turnitin integritets-plugin';
$string['turnitinapikey'] = 'Turnitin API-nøkkel';
$string['turnitinapiurl'] = 'Turnitin API-URL';
$string['turnitinconfig'] = 'Plugin-konfigurering';
$string['turnitinenablelogging'] = 'Aktiver diagnosemodus';
$string['turnitinfeatures'] = 'Turnitin integritetsfunksjoner';
$string['turnitinfeatures::eulanotrequired'] = 'Brukere trenger ikke godta Turnitins lisensavtale';
$string['turnitinfeatures::eularequired'] = 'Alle brukere må godta Turnitins lisensavtale';
$string['turnitinfeatures::header'] = 'Turnitin integritetsfunksjoner';
$string['turnitinfeatures::moreinfo'] = 'For mer informasjon om de aktiverte funksjonene og pakkene som er tilgjengelige fra Turnitin, se <a href="http://www.turnitin.com" target="_blank">http://www.turnitin.com</a>.';
$string['turnitinfeatures::repositories'] = 'Lagersteder som det er sjekket mot:';
$string['turnitinfeatures::viewoptions'] = 'Turnitin Viewer-alternativer:';
$string['turnitinhideidentity'] = 'Skjul studentens identitet for Turnitin';
$string['turnitinmodenabled'] = 'Aktiver Turnitin Integrity for {$a}';
$string['turnitinpluginenabled'] = 'Aktiver Turnitin';
$string['turnitinpluginsettings'] = 'Innstillinger for Turnitin integritets-plugin';
$string['turnitinsim'] = 'Turnitin integritets-plugin';
$string['turnitinsim:enable'] = 'Aktiver Turnitin Integrity';
$string['turnitinsiminternet'] = 'Kontroller mot internettinnhold';
$string['turnitinsimprivate'] = 'Kontroller mot privat innhold';
$string['turnitinsim:viewfullreport'] = 'Vis originalitetsrapport';
$string['turnitinviewermatchsubinfo'] = 'La instruktører innenfor institusjonen få se innsendingsinformasjon for interne matcher';
$string['turnitinviewersavechanges'] = 'Lagre endringene i visningsprogrammet';
$string['turnitinviewerviewfullsource'] = 'La instruktører innenfor institusjonen få se hele teksten i innsendinger for interne matcher';
$string['viewapilog'] = 'Vis API-logger fra {$a}';
$string['viewerpermissionferpa'] = 'De følgende tillatelsene påvirker hvordan data kan deles på tvers av institusjonen. Disse dataene er fullt og helt institusjonens ansvar, så tenk på om de fullt ut følger institusjonens retningslinjer for studentopplysninger når du stiller inn disse tillatelsene.';
$string['viewerpermissionoptions'] = 'Tillatelser for visningsprogrammet';
$string['viewlogs'] = 'Logger';
$string['webhook_description'] = 'Webhook for {$a}';
$string['webhookincorrectsignature'] = 'Webhook tilbakekall mislykket fordi signaturen er feil';
