<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'ru', branch 'MOODLE_37_STABLE'
 *
 * @package   quiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Вы можете просмотреть этот тест, но в случае реальной попытки, Вы были бы заблокированы по следующей причине:';
$string['action'] = 'Действие';
$string['activityoverview'] = 'У Вас есть незаконченные тесты';
$string['adaptive'] = 'Обучающий режим';
$string['adaptive_help'] = 'Если параметр включен, то в рамках одной попытки прохождения теста будет разрешено несколько попыток ответа на вопрос. Так, например, в случае неверного ответа, студент сможет сразу попытаться ответить снова. При этом в зависимости от настройки «Начислять штрафы», за каждую неправильную попытку могут вычитаться штрафные баллы.';
$string['add'] = 'Добавить';
$string['addaquestion'] = 'новый  вопрос';
$string['addarandomquestion'] = 'случайный вопрос';
$string['addarandomquestion_help'] = 'При добавлении случайного вопроса в тест вставляется вопрос,  случайно выбираемый из указанной в тесте категории. Это означает, что разные студенты могут получить различные наборы вопросов, и, если разрешено несколько попыток прохождения теста, то каждая попытка может содержать новый набор вопросов.';
$string['addarandomselectedquestion'] = 'Добавить случайно выбранный вопрос ...';
$string['addasection'] = 'заголовок нового раздела';
$string['adddescriptionlabel'] = 'Добавить описание';
$string['addingquestion'] = 'Добавление вопроса';
$string['addingquestions'] = '<p>На этой стороне страницы Вы можете управлять базой своих вопросов. Для удобства организации вопросы хранятся в категориях и могут использоваться в любом тесте Вашего курса или даже в нескольких курсах при условии, что категория является «опубликованной».</p>
<p>После выбора или создания категории для вопросов, Вы сможете создавать или редактировать вопросы. Вы можете выбрать любые из этих вопросов, чтобы добавить их в созданный тест на другой стороне страницы.</p>';
$string['addmoreoverallfeedbacks'] = 'Добавить {no} поля отзывов';
$string['addnewgroupoverride'] = 'Добавить переопределение группы';
$string['addnewpagesafterselected'] = 'Добавить новые страницы после выбранных вопросов';
$string['addnewquestionsqbank'] = 'Добавить вопросы в категорию {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Добавить переопределение пользователя';
$string['addpagebreak'] = 'Добавить разрыв страницы';
$string['addpagehere'] = 'Добавить страницу здесь';
$string['addquestion'] = 'Добавить вопрос';
$string['addquestionfrombankatend'] = 'Добавить в конец вопрос из банка';
$string['addquestionfrombanktopage'] = 'Добавить из банка вопросов на страницу {$a}';
$string['addquestions'] = 'Добавить вопросы';
$string['addquestionstoquiz'] = 'Добавить вопрос в текущий тест';
$string['addrandom'] = 'Добавить случайные вопросы: {$a}';
$string['addrandom1'] = '<< Добавить';
$string['addrandom2'] = 'случайные вопросы';
$string['addrandomfromcategory'] = 'Добавить случайные вопросы из категории:';
$string['addrandomquestion'] = 'Добавить случайный вопрос';
$string['addrandomquestionatend'] = 'Добавить в конец случайный вопрос';
$string['addrandomquestiontopage'] = 'Добавить случайный вопрос на страницу {$a}';
$string['addrandomquestiontoquiz'] = 'Добавить случайный вопрос в тест {$a}';
$string['addselectedquestionstoquiz'] = 'Добавить выбранные вопросы в тест';
$string['addselectedtoquiz'] = 'Добавить выбранное в тест';
$string['addtoquiz'] = 'Добавить в тест';
$string['affectedstudents'] = 'Исправлено: {$a}';
$string['aftereachquestion'] = 'После добавления каждого вопроса';
$string['afternquestions'] = 'После добавления вопросов: {$a}';
$string['age'] = 'время создания';
$string['allattempts'] = 'Все попытки';
$string['allinone'] = 'Не ограничено';
$string['allowreview'] = 'Разрешить просмотр попыток';
$string['alreadysubmitted'] = 'Вы уже использовали эту попытку';
$string['alternativeunits'] = 'Альтернативные единицы измерения';
$string['alwaysavailable'] = 'Всегда доступен';
$string['analysisoptions'] = 'Параметры анализа';
$string['analysistitle'] = 'Таблица «Анализ теста»';
$string['answer'] = 'Ответ';
$string['answered'] = 'Отвечено';
$string['answerhowmany'] = 'Один или несколько ответов?';
$string['answers'] = 'Ответы';
$string['answersingleno'] = 'Допускается несколько ответов';
$string['answersingleyes'] = 'Только один ответ';
$string['answertoolong'] = 'Ответ слишком длинный после строки {$a} (максимальное количество символов - 255)';
$string['anytags'] = 'Любые теги';
$string['aon'] = 'Формат AON';
$string['areyousureremoveselected'] = 'Вы уверены, что хотите удалить все выбранные вопросы?';
$string['asshownoneditscreen'] = 'Как показано на экране редактирования';
$string['attempt'] = 'Попытка {$a}';
$string['attemptalreadyclosed'] = 'Эта попытка уже была закончена.';
$string['attemptclosed'] = 'Попытка еще не закрыта';
$string['attemptduration'] = 'Затраченное время';
$string['attemptedon'] = 'Время попытки';
$string['attempterror'] = 'Вам не разрешено пройти тест по следующей причине: {$a}';
$string['attempterrorcontentchange'] = 'Этот предварительный просмотр теста больше не существует. (При редактировании теста  предварительные просмотры всех ранее выполненных попыток автоматически удаляются.)';
$string['attempterrorcontentchangeforuser'] = 'Эта попытка теста больше не существует.';
$string['attempterrorinvalid'] = 'Неверный ID попытки теста';
$string['attemptfirst'] = 'Первая попытка';
$string['attemptincomplete'] = 'Эта попытка ({$a}) еще не закончена.';
$string['attemptlast'] = 'Последняя попытка';
$string['attemptnumber'] = 'Попытка';
$string['attemptquiznow'] = 'Начать тестирование';
$string['attemptreviewtitle'] = '{$a}: просмотр попытки';
$string['attemptreviewtitlepaged'] = '{$a->name}: просмотр попытки (страница {$a->currentpage} из {$a->totalpages})';
$string['attempts'] = 'Попытки';
$string['attemptsallowed'] = 'Количество попыток';
$string['attemptsdeleted'] = 'Попытки тестирования удалены';
$string['attemptselection'] = 'Выберите попытки каждого пользователя для анализа';
$string['attemptsexist'] = 'Вы больше не можете добавлять или удалять вопросы: этот тест уже имеет попытки ответа';
$string['attempts_help'] = 'Общее количество разрешенных попыток (не количество дополнительных попыток).';
$string['attemptsnum'] = 'Попыток: {$a}';
$string['attemptsnumthisgroup'] = 'Попыток: {$a->total} ({$a->group} из этой группы)';
$string['attemptsnumyourgroups'] = 'Попыток: {$a->total} ({$a->group} из Ваших групп)';
$string['attemptsonly'] = 'Показывать только студентов с попытками';
$string['attemptstate'] = 'Состояние';
$string['attemptstillinprogress'] = 'Выполняющиеся попытки';
$string['attemptsummarytitle'] = '{$a}: сводка по попыткам';
$string['attemptsunlimited'] = 'Не ограничено';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (страница {$a->currentpage} из {$a->totalpages})';
$string['autosaveperiod'] = 'Период автосохранения';
$string['autosaveperiod_desc'] = 'Ответы студентов могут автоматически сохраняться во время попыток прохождения теста. Ответы сохраняются каждый раз при изменении ответа, а также по истечении этого периода. Данное значение — компромисс: малое значение задержки увеличивает нагрузку на сервер, но снижает вероятность потери работ студентов. Если Вы собираетесь существенно уменьшить период задержки, то нужно постепенно снижать это значение  и следить за нагрузкой сервера. Если нагрузка становится слишком высокой, снова увеличьте задержку. Для отключения автосохранения задайте период, равный 0.';
$string['back'] = 'Вернуться к просмотру вопроса';
$string['backtocourse'] = 'Вернуться к курсу';
$string['backtoquestionlist'] = 'Вернуться к списку вопросов';
$string['backtoquiz'] = 'Вернуться к редактированию теста';
$string['basicideasofquiz'] = 'Основные идеи создания теста';
$string['bestgrade'] = 'Лучший результат';
$string['bothattempts'] = 'Показывать всех студентов (в т.ч. не пытавшихся пройти тест)';
$string['browsersecurity'] = 'Безопасность браузера';
$string['browsersecurity_help'] = 'Если выбран «Полноэкранный режим с защитой JavaScript», то:

* Тест запустится, только если в браузере студента будет включен JavaScript
* Тест откроется на весь экран в окне, которое будет расположено поверх других окон и не будет содержать элементы навигации
* Студенты не смогут использовать такие возможности, как копирование и вставка';
$string['calculated'] = 'Вычисляемый';
$string['calculatedquestion'] = '«Вычисляемый вопрос» не поддерживается на строке {$a}. Вопрос будет игнорирован.';
$string['cannotcreatepath'] = 'Не удалось создать путь ({$a})';
$string['cannoteditafterattempts'] = 'Вы не можете добавить или удалить вопросы, потому что уже были попытки пройти этот тест. ({$a})';
$string['cannotfindprevattempt'] = 'Не удалось найти предыдущие попытки';
$string['cannotfindquestionregard'] = 'Не удалось получить вопросы для переоценивания!';
$string['cannotinsert'] = 'Не удалось добавить вопрос';
$string['cannotinsertrandomquestion'] = 'Не удалось вставить новый случайный вопрос!';
$string['cannotloadquestion'] = 'Не удалось загрузить варианты вопроса';
$string['cannotloadtypeinfo'] = 'Невозможно загрузить информацию специфического типа вопроса';
$string['cannotopen'] = 'Не удалось экспортировать файл ({$a})';
$string['cannotremoveallsectionslots'] = 'Вы выбрали все вопросы под заголовком раздела {$a}. Не разрешается удалять все вопросы под заголовком раздела.';
$string['cannotremoveslots'] = 'Не возможно удалить вопросы';
$string['cannotrestore'] = 'Невозможно восстановить сеансы вопроса';
$string['cannotreviewopen'] = 'Вы не можете просмотреть эту попытку, так как она еще не закрыта.';
$string['cannotsavelayout'] = 'Не удалось сохранить расположение';
$string['cannotsavenumberofquestion'] = 'Не удалось сохранить количество вопросов на странице';
$string['cannotsavequestion'] = 'Не удается сохранить список вопросов';
$string['cannotsetgrade'] = 'Не удалось установить новую максимальную оценку для теста';
$string['cannotsetsumgrades'] = 'Не удалось установить сумму оценок';
$string['cannotstartgradesmismatch'] = 'Не удается начать попытку в этом тесте. Тест должен оцениваться до {$a->grade}, но ни один из вопросов в тесте не оценивается. Это может быть задано на странице «Редактирование теста».';
$string['cannotstartmissingquestion'] = 'Не удается начать попытку в этом тесте. Тест включает в себя вопрос, который не существует.';
$string['cannotstartnoquestions'] = 'Не удается начать попытку в этом тесте. Тест еще не создан. Нет добавленных вопросов.';
$string['cannotwrite'] = 'Не удалась запись в экспортируемый файл ({$a})';
$string['canredoquestions'] = 'Разрешить повторный ответ в попытке';
$string['canredoquestions_desc'] = 'Если параметр включен, то после ответа студентов на конкретный вопрос они увидят кнопку «Повторно ответить на вопрос». Это позволяет им выбрать другой вариант ответа на этот же вопрос, не завершая весь тест и не начиная новую попытку. Такая возможность в основном полезна для тренировочных тестов.

Эта настройка влияет только на те вопросы и поведение (например, немедленный отзыв или интерактивный с несколькими попытками), где возможно завершение студентом вопроса до того, как попытка будет отправлена.';
$string['canredoquestions_help'] = 'Если параметр включен, то после ответа студентов на конкретный вопрос они увидят кнопку «Повторно ответить на вопрос». Это позволяет им выбрать другой вариант ответа на этот же вопрос, не завершая весь тест и не начиная новую попытку. Такая возможность в основном полезна для тренировочных тестов.

Эта настройка влияет только на те вопросы и поведение (например, немедленный отзыв или интерактивный с несколькими попытками), где возможно завершение студентом вопроса до того, как попытка будет отправлена.';
$string['canredoquestionsyes'] = 'Студенты могут повторно выбрать другой вариант ответа на любой завершенный вопрос';
$string['caseno'] = 'Нет, регистр не важен';
$string['casesensitive'] = 'Чувствительность ответа к регистру';
$string['caseyes'] = 'Да, регистр важен';
$string['categoryadded'] = 'Категория «{$a}» была добавлена';
$string['categorydeleted'] = 'Категория «{$a}» была удалена';
$string['categorynoedit'] = 'Вы не можете редактировать категорию «{$a}».';
$string['categoryupdated'] = 'Категория была успешно обновлена';
$string['close'] = 'Закрыть окно';
$string['closebeforeopen'] = 'Невозможно обновить тест. Дата окончания теста раньше даты начала.';
$string['closed'] = 'Закрыто';
$string['closepreview'] = 'Закрыть просмотр';
$string['closereview'] = 'Закрыть обзор';
$string['comment'] = 'Комментарий';
$string['commentorgrade'] = 'Оставить комментарий или исправить оценку';
$string['comments'] = 'Комментарии';
$string['completedon'] = 'Завершен';
$string['completionattemptsexhausted'] = 'Или все доступные попытки завершены';
$string['completionattemptsexhausteddesc'] = 'Завершено, если все имевшиеся попытки исчерпаны';
$string['completionattemptsexhausted_help'] = 'Тест помечается завершенным, когда студент исчерпал максимальное количество попыток.';
$string['completionpass'] = 'Требуется проходной балл';
$string['completionpassdesc'] = 'Студент должен получить проходную оценку, чтобы завершить этот элемент курса.';
$string['completionpass_help'] = 'При включенном параметре эта деятельность считается завершенной, если студент получает проходной балл, заданный в журнале оценок.';
$string['configadaptive'] = 'Если вы выберете «Да» для этого параметра, то студенту будет разрешено ответить на вопрос несколько раз, даже в рамках одной попытки пройти тест.';
$string['configattemptsallowed'] = 'Ограничение количества попыток пройти тест.';
$string['configdecimaldigits'] = 'Число знаков после запятой при отображении оценок.';
$string['configdecimalplaces'] = 'Количество цифр после запятой при отображении оценок теста.';
$string['configdecimalplacesquestion'] = 'Количество цифр после запятой при отображении оценки отдельного вопроса.';
$string['configdelay1'] = 'Если Вы установите время задержки после первой попытки, то студент должен выждать это время перед началом новой попытки теста.';
$string['configdelay1st2nd'] = 'Если вы установите здесь время задержки, то студент не сможет начать свою вторую попытку, пока с момента окончания его первой попытки не пройдет это время.';
$string['configdelay2'] = 'Если Вы установите здесь время задержки, то студент должен выждать это время перед началом третьей или последующих попыток теста.';
$string['configdelaylater'] = 'Если вы установите здесь время задержки, то студент не может начать свою третью, четвертую и последующие попытки, пока с момента окончания предыдущей его попытки не пройдет это время.';
$string['configeachattemptbuildsonthelast'] = 'Если разрешены несколько попыток, то каждая новая попытка содержит результаты предыдущей попытки.';
$string['configgrademethod'] = 'Если разрешены несколько попыток, то какой метод должен быть использован при расчете итоговой оценки студента.';
$string['configintro'] = 'Установленные здесь значения  определяют значения по умолчанию, использующиеся в форме настроек при создании нового теста. Вы также можете выбрать, какие из параметров теста относятся к дополнительным настройкам.';
$string['configmaximumgrade'] = 'Оценка по умолчанию, к которой приводится оценка теста при отображении.';
$string['confignavmethod'] = 'При свободной навигации на вопросы можно отвечать в любом порядке. При последовательной навигации ответы на вопросы должны быть в строгой последовательности.';
$string['confignewpageevery'] = 'При добавлении вопросов в тест разрывы страниц будут вставлены автоматически в соответствии с этими настройками.';
$string['configoutcomesadvanced'] = 'При включенном параметре в форме редактирования теста «Результаты» относятся к дополнительным настройкам.';
$string['configpenaltyscheme'] = 'Штраф вычитается за каждый неверный ответ при обучающем режиме.';
$string['configpopup'] = 'Принудительно открывать тест во всплывающем окне и использовать  возможности JavaScript для ограничения копирования, вставки и т.п. во время прохождения теста.';
$string['configrequirepassword'] = 'Студенты должны будут ввести пароль перед прохождением теста.';
$string['configrequiresubnet'] = 'Студенты смогут пройти тест только на этих компьютерах.';
$string['configreviewoptions'] = 'Эти параметры определяют, какую информацию пользователи могут видеть при просмотре попытки теста или отчетов теста.';
$string['configshowblocks'] = 'Показывать блоки во время попыток теста.';
$string['configshowuserpicture'] = 'Показывать на экране фотографию пользователя во время прохождения теста.';
$string['configshufflewithin'] = 'Если Вы включите этот параметр, то варианты ответов в вопросах будут располагаться в случайном порядке при каждой попытке пройти тест. При этом необходимо, чтобы этот параметр также был включен в настройках вопроса.';
$string['configtimelimit'] = 'Ограничение времени теста по умолчанию (в минутах). 0 означает -  без ограничения времени.';
$string['configtimelimitsec'] = 'Ограничение времени теста по умолчанию (в секундах). 0 означает, что время не ограничено.';
$string['configurerandomquestion'] = 'Настроить вопрос';
$string['confirmclose'] = 'После отправки Вы больше не сможете изменить свои ответы на эту попытку.';
$string['confirmremovequestion'] = 'Вы уверены, что хотите удалить этот вопрос {$a}?';
$string['confirmremovesectionheading'] = 'Вы уверены, что хотите удалить заголовок раздела «{$a}»?';
$string['confirmserverdelete'] = 'Вы уверены, что хотите удалить сервер <b>{$a}</b> из списка?';
$string['connectionerror'] = 'Сетевое подключение потеряно. (Автосохранение не удалось).

Запишите все ответы, введенные на этой странице в последние несколько минут, затем попробуйте подключиться заново.

После того, как соединение будет восстановлено, Ваши ответы должны быть сохранены и это сообщение исчезнет.';
$string['connectionok'] = 'Сетевое подключение восстановлено. Вы можете уверенно продолжать.';
$string['containercategorycreated'] = 'Эта категория создана для хранения всех исходных категорий, перемещенных на уровень сайта по причинам, указанным ниже';
$string['continueattemptquiz'] = 'Продолжить последнюю попытку';
$string['continuepreview'] = 'Продолжить последний просмотр';
$string['copyingfrom'] = 'Копирование вопроса \'{$a}\'';
$string['copyingquestion'] = 'Копирование вопроса';
$string['correct'] = 'Верно';
$string['correctanswer'] = 'Правильный ответ';
$string['correctanswerformula'] = 'Формула правильного ответа';
$string['correctansweris'] = 'Правильный ответ: {$a}';
$string['correctanswerlength'] = 'Количество значащих цифр';
$string['correctanswers'] = 'Правильные ответы';
$string['correctanswershows'] = 'Правильный ответ показывается';
$string['corrresp'] = 'Правильный ответ';
$string['countdown'] = 'Обратный отсчет';
$string['countdownfinished'] = 'Тест закрывается. Вы должны отправить ответы сейчас.';
$string['countdowntenminutes'] = 'Тест закрывается через 10 минут.';
$string['coursetestmanager'] = 'Формат Course Test Manager';
$string['createcategoryandaddrandomquestion'] = 'Создать категорию и добавить случайный вопрос';
$string['createfirst'] = 'Вы должны сначала создать несколько вопросов типа «Короткий ответ»';
$string['createmultiple'] = 'Добавить в тест несколько случайных вопросов';
$string['createnewquestion'] = 'Создать новый вопрос';
$string['createquestionandadd'] = 'Создать новый вопрос и добавить в тест.';
$string['custom'] = 'Пользовательский формат';
$string['dataitemneed'] = 'Вы должны добавить по меньшей мере один набор вариантов, чтобы получить корректный вопрос';
$string['datasetdefinitions'] = 'Определения наборов данных многократного пользования в категории {$a}';
$string['datasetnumber'] = 'Численное значение';
$string['daysavailable'] = 'Доступно дней';
$string['decimaldigits'] = 'Количество знаков после запятой';
$string['decimalplaces'] = 'Десятичных знаков в оценках';
$string['decimalplaces_help'] = 'Этот параметр определяет количество цифр после запятой при отображении оценок. Он используется только для отображения оценок, а не для хранения их в базе данных или внутренних расчетов, которые производятся с полной точностью.';
$string['decimalplacesquestion'] = 'Десятичных знаков в оценках вопроса';
$string['decimalplacesquestion_help'] = 'Эта опция указывает число десятичных знаков после запятой, отображаемых в оценках за отдельные вопросы.';
$string['decimalpoints'] = 'Знаков после запятой';
$string['default'] = 'По умолчанию';
$string['defaultgrade'] = 'Оценка по умолчанию для вопроса';
$string['defaultinfo'] = 'Категория по умолчанию для вопросов.';
$string['delay1'] = 'Задержка по времени между первой и второй попытками';
$string['delay1st2nd'] = 'Принудительная задержка между первой и второй попытками';
$string['delay1st2nd_help'] = 'Если включено, то студент должен будет выждать указанное время перед началом второй попытки пройти тест.';
$string['delay2'] = 'Задержка по времени между последующими попытками';
$string['delaylater'] = 'Принудительная задержка между последующими попытками';
$string['delaylater_help'] = 'Если включено, то студент должен будет выждать указанное время перед началом третьей попытки и последующих попыток пройти тест.';
$string['deleteattemptcheck'] = 'Вы уверены, что хотите полностью удалить эти попытки?';
$string['deleteselected'] = 'Удалить выбранные';
$string['deletingquestionattempts'] = 'Удаление попыток ответа на вопрос';
$string['description'] = 'Описание';
$string['disabled'] = 'Отключено';
$string['displayoptions'] = 'Параметры просмотра';
$string['donotuseautosave'] = 'Не использовать автосохранение';
$string['download'] = 'Нажмите «Продолжить», чтобы загрузить файл экспортируемой категории.';
$string['downloadextra'] = '(файл также сохраняется в файлах курса в папке /backupdata/quiz)';
$string['dragtoafter'] = 'После {$a}';
$string['dragtostart'] = 'В начало';
$string['duplicateresponse'] = 'Ответы были проигнорированы, так как ранее вы дали аналогичный ответ.';
$string['eachattemptbuildsonthelast'] = 'Каждая попытка основывается на предыдущей';
$string['eachattemptbuildsonthelast_help'] = 'Если разрешено использовать несколько попыток и этот параметр включен, то в каждой новой попытке будут содержаться результаты предыдущих попыток. Это позволит выполнить тест за несколько попыток.';
$string['editcategories'] = 'Редактировать категории';
$string['editcategory'] = 'Редактировать категорию';
$string['editcatquestions'] = 'Редактировать вопросы в категории';
$string['editingquestion'] = 'Редактирование вопроса';
$string['editingquiz'] = 'Редактирование теста';
$string['editingquiz_help'] = 'Основные идеи создания теста:

* Тест содержит одну или несколько страниц
* Все вопросы содержатся в банке вопросов, структурированном по категориям
* Случайные вопросы - при каждой новой попытке студент будет получать разные вопросы, разные студенты также будут получать разные вопросы.';
$string['editingquizx'] = 'Редактирование теста: {$a}';
$string['editmaxmark'] = 'Редактировать максимальный балл';
$string['editoverride'] = 'Редактировать переопределение';
$string['editqcats'] = 'Редактировать категории вопросов';
$string['editquestion'] = 'Редактировать вопрос';
$string['editquestions'] = 'Редактировать вопросы';
$string['editquiz'] = 'Редактировать тест';
$string['editquizquestions'] = 'Редактировать вопросы теста';
$string['emailconfirmbody'] = 'Уважаемый(ая) {$a->username}.

Благодарим за выполнение теста «{$a->quizname}» в курсе «{$a->coursename}» ({$a->submissiontime}).

Это сообщение подтверждает, что Ваши ответы получены.

Тест доступен по адресу {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Спасибо за отправку ответов на тест «{$a->quizname}»';
$string['emailconfirmsubject'] = 'Подтверждение выполнения: {$a->quizname}';
$string['emailnotifybody'] = 'Уважаемый(ая) {$a->username}.

{$a->studentname} выполнил(а) «{$a->quizname}» ({$a->quizurl}) в курсе «{$a->coursename}».

Вы можете ознакомиться с ответами: {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} выполнил(а) тест {$a->quizname}. Подробности по ссылке {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} завершил(а) {$a->quizname}';
$string['emailoverduebody'] = 'Уважаемый(ая) {$a->studentname}.

Вы начали попытку теста «{$a->quizname}» в курсе «{$a->coursename}», но не отправили ее. Попытка должна была быть отправлена до {$a->attemptduedate}.

Если Вы хотите представить свою попытку для оценивания, то перейдите на {$a->attemptsummaryurl} и нажмите кнопку «Отправить». Вы должны сделать это до {$a->attemptgraceend}, иначе эта попытка не будет зачтена.';
$string['emailoverduesmall'] = 'Вы не отправили свою попытку теста «{$a->quizname}». Если Вы еще хотите отправить свою попытку, то перейдите на {$a->attemptsummaryurl} до {$a->attemptgraceend}.';
$string['emailoverduesubject'] = 'Просроченная попытка теста: {$a->quizname}';
$string['empty'] = 'Пусто';
$string['enabled'] = 'Разрешено';
$string['endtest'] = 'Закончить попытку...';
$string['erroraccessingreport'] = 'Вы не можете получить доступ к этому отчету';
$string['errorinquestion'] = 'Ошибка в вопросе';
$string['errormissingquestion'] = 'Ошибка: В системе нет вопроса № {$a}';
$string['errornotnumbers'] = 'Ошибка: Ответы должны быть числовыми';
$string['errorunexpectedevent'] = 'Непредвиденное событие с кодом {$a->event} найдено для вопроса {$a->questionid} в попытке {$a->attemptid}.';
$string['essay'] = 'Эссе';
$string['essayquestions'] = 'Вопросы эссе';
$string['eventattemptdeleted'] = 'Попытка теста удалена';
$string['eventattemptpreviewstarted'] = 'Начата попытка предварительного просмотра теста';
$string['eventattemptreviewed'] = 'Завершенная попытка теста просмотрена';
$string['eventattemptsummaryviewed'] = 'Сводка попытки теста просмотрена';
$string['eventattemptviewed'] = 'Попытка теста просмотрена';
$string['eventeditpageviewed'] = 'Страница редактирования теста просмотрена';
$string['eventoverridecreated'] = 'Переопределение теста создано';
$string['eventoverridedeleted'] = 'Переопределение теста удалено';
$string['eventoverrideupdated'] = 'Переопределение теста обновлено';
$string['eventquestionmanuallygraded'] = 'Вопрос оценен вручную';
$string['eventquizattemptabandoned'] = 'Попытка теста брошена';
$string['eventquizattemptstarted'] = 'Начата попытка теста';
$string['eventquizattemptsubmitted'] = 'Попытка теста завершена и отправлена на оценку';
$string['eventquizattempttimelimitexceeded'] = 'Превышено ограничение времени на попытку теста';
$string['eventreportviewed'] = 'Отчет по тесту просмотрен';
$string['everynquestions'] = 'Каждые {$a} вопроса(ов)';
$string['everyquestion'] = 'Каждый вопрос';
$string['everythingon'] = 'Включить всё';
$string['existingcategory'] = 'Существующая категория';
$string['exportcategory'] = 'экспортировать категорию';
$string['exporterror'] = 'Во время экспорта произошла ошибка';
$string['exportingquestions'] = 'Вопросы экспортируются в файл';
$string['exportname'] = 'Имя файла';
$string['exportquestions'] = 'Экспортировать вопросы в файл';
$string['extraattemptrestrictions'] = 'Дополнительные ограничения на попытки';
$string['false'] = 'Неверно';
$string['feedback'] = 'Отзыв';
$string['feedbackerrorboundaryformat'] = 'Оценка должна быть ограничена или процентом, или числом. Введенное вами значение {$a} недопустимо.
';
$string['feedbackerrorboundaryoutofrange'] = 'Диапазон границ оценки должен быть от 0% до 100%. Введенное Вами значение {$a} не попадает в этот диапазон.';
$string['feedbackerrorjunkinboundary'] = 'Вы должны заполнить все поля границ оценок.
';
$string['feedbackerrorjunkinfeedback'] = 'Вы должны заполнить поле отзыва, не оставляя никаких промежутков.';
$string['feedbackerrororder'] = 'Оценки отзыва должны идти по порядку, сначала - наивысшая. Введенное Вами значение {$a} не подходит.';
$string['file'] = 'Файл';
$string['fileformat'] = 'Формат файла';
$string['fillcorrect'] = 'Отобразить ответы';
$string['filloutnumericalanswer'] = 'Необходимо дать, по меньшей мере, один возможный ответ и погрешность. Первый совпадающий ответ будет использоваться для определения балла и отзыва. Если Вы в конце представите некий отзыв без ответа, то он будет показан тем студентам, чьи ответы не соответствует ни одному из вариантов.';
$string['filloutoneanswer'] = 'Вам необходимо указать хотя бы один возможный ответ. Пустые ответы не будут использоваться. Символ «*» можно использовать как шаблон, соответствующий любым символам. Первый соответствующий ответ будет использоваться для определения оценки и отзыва.';
$string['filloutthreequestions'] = 'Вы должны заполнить не менее трех вопросов с соответствующими ответами. Можно предоставить дополнительные неправильные ответы, задав ответ с пустым вопросом. Варианты с пустыми полями вопросов и ответов будут проигнорированы.';
$string['fillouttwochoices'] = 'Необходимо заполнить не менее двух вариантов. Пустые варианты не будут использоваться.';
$string['finishattemptdots'] = 'Закончить попытку...';
$string['finishreview'] = 'Закончить обзор';
$string['forceregeneration'] = 'создать новые значения';
$string['formatnotfound'] = 'Формат импорта/экспорта {$a} не найден';
$string['formulaerror'] = 'Ошибки в формуле!';
$string['fractionsaddwrong'] = 'Положительные оценки в сумме не составляют 100%. <br />Их сумма {$a}%.<br /> Вы хотите вернуться и исправить этот вопрос?';
$string['fractionsnomax'] = 'Один из ответов должен быть оценен в 100%, чтобы за этот вопрос можно было получить оценку. Вы хотите вернуться и исправить вопрос?';
$string['fromfile'] = 'из файла:';
$string['functiondisabledbysecuremode'] = 'В настоящее время эта функция отключена';
$string['generalfeedback'] = 'Общий отзыв';
$string['generalfeedback_help'] = 'Общий отзыв к вопросу - это некоторый текст, который отображается после попытки прохождения теста. В отличие от отзыва для конкретного варианта ответа, который зависит от выбранного ответа, общий отзыв отображается всегда один и тот же.';
$string['graceperiod'] = 'Льготный период отправки.';
$string['graceperiod_desc'] = 'Если параметр «При истечении времени» установлен в «В льготный период разрешить отправку, не изменяя никаких ответов», это разрешенная по умолчанию продолжительность дополнительного времени.';
$string['graceperiod_help'] = 'Если параметр «При истечении времени» установлен в «В льготный период разрешить отправку, не изменяя никаких ответов», это разрешенная по умолчанию продолжительность дополнительного времени.';
$string['graceperiodmin'] = 'Продление отправки, сек';
$string['graceperiodmin_desc'] = 'В самом конце теста возможна потенциальная проблема. С одной стороны, мы хотим дать возможность студентам работать вплоть до последней секунды - с помощью таймера, который автоматически отправляет попытку теста по истечении времени теста. С другой стороны, сервер может оказаться перегруженным, и обработка ответов займет некоторое время. Поэтому, мы принимаем ответы в течение заданного времени после завершения времени теста, чтобы не наказывать студента из-за медленного сервера. Однако, студент может воспользоваться и использовать эти секунды, чтобы ответить на тест. Вы должны выбрать компромиссное значение, учитывая производительность вашего сервера во время теста.';
$string['graceperiodtoosmall'] = 'Льготный период должен быть больше, чем {$a}.';
$string['grade'] = 'Оценка';
$string['gradeall'] = 'Оценить все';
$string['gradeaverage'] = 'Средняя оценка';
$string['gradeboundary'] = 'Граница оценки';
$string['gradeessays'] = 'Оценить Эссе';
$string['gradehighest'] = 'Высшая оценка';
$string['grademethod'] = 'Метод оценивания';
$string['grademethod_help'] = 'Если разрешены несколько попыток прохождения теста, то для расчета итоговой оценки могут использоваться следующие методы:

* Лучшая оценка из всех попыток
* Средняя оценка из всех попыток
* Первая попытка (все прочие попытки не учитываются).
* Последняя попытка (все прочие попытки не учитываются).';
$string['gradesdeleted'] = 'Оценки теста удалены';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'Проходная оценка не может быть равна нулю, так как у этого теста задан метод завершения, требующий прохождения оценки. Установите ненулевое значение.';
$string['gradetopassnotset'] = 'Для этого теста не задана проходная оценка, поэтому вы не можете использовать этот параметр. Вместо него используйте установку требуемой оценки.';
$string['gradingdetails'] = 'Баллов за ответ: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'С учетом предыдущих штрафов набрано <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Данный ответ повлек штраф {$a}.';
$string['gradingdetailszeropenalty'] = 'Данный ответ не повлек штрафа.';
$string['gradingmethod'] = 'Метод оценивания: {$a}';
$string['groupoverrides'] = 'Переопределение групп';
$string['groupoverridesdeleted'] = 'Переопределения группы удалены';
$string['groupsnone'] = 'Нет групп, к которым вы можете получить доступ.';
$string['guestsno'] = 'Извините, гость не может видеть и проходить тест';
$string['hidebreaks'] = 'Скрыть разделители страниц';
$string['hidereordertool'] = 'Скрыть инструмент перегруппировки вопросов';
$string['history'] = 'История ответов:';
$string['howquestionsbehave_desc'] = 'Установка по умолчанию режима вопросов теста.';
$string['imagedisplay'] = 'Картинка для показа';
$string['importcategory'] = 'Категория импорта';
$string['importerror'] = 'Во время импорта произошла ошибка';
$string['importfilearea'] = 'Импорт из файла, уже имеющегося в файлах курса';
$string['importfileupload'] = 'Импортировать из файла...';
$string['importfromthisfile'] = 'Импортировать из этого файла';
$string['import_help'] = 'Эта функция позволяет импортировать вопросы из внешних текстовых файлов.

Если ваш файл содержит не-ASCII символы, то он должен использовать кодировку UTF-8. Будьте особенно осторожны с файлами, созданными в пакете Microsoft Office, так как они обычно используют специальную кодировку, которая не может быть обработана корректно.

Возможен импорт и экспорт в форматах подключенных ресурсов. Другие дополнительные форматы могут быть доступны в Базе данных модулей и плагинов.';
$string['importingquestions'] = 'Вопросы из файла {$a} импортированы';
$string['importmax10error'] = 'В этом вопросе ошибка. Вы не можете указывать более 10 ответов';
$string['importmaxerror'] = 'В этом вопросе ошибка. Вы указали слишком много ответов';
$string['importquestions'] = 'Импорт вопросов из файла';
$string['inactiveoverridehelp'] = '* Студенту не назначена правильная группа или роль для попытки прохождения теста';
$string['incorrect'] = 'Неверно';
$string['indicator:cognitivedepth'] = 'Тест: познавательный аспект';
$string['indicator:cognitivedepth_help'] = 'Этот показатель основан на глубине познания, достигнутой студентом при работе с элементом курса «Тест».';
$string['indicator:socialbreadth'] = 'Тест: социальный аспект';
$string['indicator:socialbreadth_help'] = 'Этот показатель основан на широте общения, которая может быть достигнута студентом при работе с элементом Тест.';
$string['indivresp'] = 'Ответы участников по каждому вопросу';
$string['info'] = 'Вступление';
$string['infoshort'] = 'Инфо';
$string['initialnumfeedbacks'] = 'Исходное число полей общего отзыва';
$string['initialnumfeedbacks_desc'] = 'При создании нового теста будет создано это количество пустых полей общего отзыва. Как только тест будет создан, форма покажет количество необходимых полей для числа отзывов в тесте. Этот параметр не может быть меньше 1.';
$string['inprogress'] = 'В процессе';
$string['introduction'] = 'Вступление';
$string['invalidattemptid'] = 'Нет попытки с таким ID';
$string['invalidcategory'] = 'ID категории не корректен';
$string['invalidoverrideid'] = 'Неверный ID переопределения';
$string['invalidquestionid'] = 'Неверный ID вопроса ';
$string['invalidquizid'] = 'Неверный ID теста';
$string['invalidsource'] = 'Источник не принимается как допустимый';
$string['invalidsourcetype'] = 'Недопустимый тип источника';
$string['invalidstateid'] = 'Неверный ID состояния';
$string['lastanswer'] = 'Вашим последним ответом было';
$string['layout'] = 'Расположение';
$string['layoutasshown'] = 'Располагать на странице как отображено.';
$string['layoutasshownwithpages'] = 'Располагать на странице как отображено. <small>(Каждые {$a} вопроса(ов) автоматически располагать на новой странице.)</small>';
$string['layoutshuffledandpaged'] = 'Вопросы располагаются в случайном порядке, с {$a} вопросами на странице.';
$string['layoutshuffledsinglepage'] = 'Вопросы в случайном порядке, все на одной странице.';
$string['link'] = 'Ссылка';
$string['listitems'] = 'Список элементов в тесте';
$string['literal'] = 'Символ';
$string['loadingquestionsfailed'] = 'Не удалось загрузить вопросы: {$a}';
$string['makecopy'] = 'Сохранить как новый вопрос';
$string['managetypes'] = 'Управлять типами вопросов и серверами';
$string['manualgradequestion'] = 'Вручную оценить ответ на вопрос «{$a->question}» в тесте «{$a->quiz}», данный пользователем {$a->user}';
$string['manualgrading'] = 'Оценить вручную';
$string['mark'] = 'Отправить';
$string['markall'] = 'Отправить страницу';
$string['marks'] = 'Баллы';
$string['marks_help'] = 'Количество баллов за каждый вопрос и итоговый балл за попытку.';
$string['match'] = 'На соответствие';
$string['matchanswer'] = 'Соответствующий ответ';
$string['matchanswerno'] = 'Соответствующий ответ {$a}';
$string['max'] = 'Максимум';
$string['maxmark'] = 'Максимальный балл';
$string['messageprovider:attempt_overdue'] = 'Предупреждения, когда попытка теста становится просроченной';
$string['messageprovider:confirmation'] = 'Подтверждения прохождения тестов';
$string['messageprovider:submission'] = 'Уведомления о попытках прохождения тестов';
$string['min'] = 'Минимум';
$string['minutes'] = 'мин.';
$string['missingcorrectanswer'] = 'Должен быть определен правильный ответ';
$string['missingitemtypename'] = 'Отсутствующее имя';
$string['missingquestion'] = 'Этот вопрос не существует';
$string['modulename'] = 'Тест';
$string['modulename_help'] = 'Элемент курса «Тест» позволяет преподавателю создавать тесты, состоящие из вопросов разных типов: Множественный выбор, Верно/неверно, На соответствие, Короткий ответ, Числовой.

Можно создать тест с несколькими попытками, с перемешивающимися вопросами или случайными вопросами, выбирающимися из банка вопросов. Может быть задано ограничение времени.

Каждая попытка оценивается автоматически, за исключением вопросов Эссе, и оценка записывается в журнал оценок.

Можно выбрать, будут ли подсказки, отзыв и правильные ответы и когда они будут показаны студентам.

Тесты могут быть использованы

* В экзаменах курса
* Как мини-тесты для прочитанных заданий или в конце темы
* В итоговом экзамене, используя вопросы из промежуточных экзаменов
* Для обеспечения немедленного отзыва о работе
* Для самооценки';
$string['modulenameplural'] = 'Тесты';
$string['moveselectedonpage'] = 'Переместить выбранные вопросы на страницу: {$a}';
$string['multichoice'] = 'Множественный выбор';
$string['multipleanswers'] = 'Выберите хотя бы один ответ.';
$string['mustbesubmittedby'] = 'Эта попытка должна быть отправлена до {$a}.';
$string['name'] = 'Название';
$string['navigatenext'] = 'Следующая страница';
$string['navigateprevious'] = 'Предыдущая страница';
$string['navmethod'] = 'Метод навигации';
$string['navmethod_free'] = 'Свободный';
$string['navmethod_help'] = 'При включении последовательной навигации студент должен пройти тест по порядку, он не может вернуться к предыдущим страницам или посмотреть следующие.';
$string['navmethod_seq'] = 'Последовательный';
$string['navnojswarning'] = 'Предупреждение: эти ссылки не сохранят ваши ответы. Используйте кнопку внизу страницы.';
$string['neverallononepage'] = 'Никогда, все вопросы на одной странице';
$string['newattemptfail'] = 'Ошибка: Нельзя начать новую попытку';
$string['newcategory'] = 'Новая категория';
$string['newpage'] = 'С новой страницы';
$string['newpageevery'] = 'Автоматически начинать с новой страницы';
$string['newpage_help'] = 'Длинные тесты имеет смысл разбивать на несколько страниц с ограниченным числом вопросов на каждой. При добавлении вопросов в тест разрывы страниц будут добавляться автоматически в соответствии с этой настройкой. В дальнейшем разрывы страниц могут быть перемещены вручную на странице редактирования.';
$string['newsectionheading'] = 'Новый заголовок';
$string['noanswers'] = 'Не было выбрано ни одного ответа!';
$string['noattempts'] = 'Не было попыток пройти тест';
$string['noattemptsfound'] = 'Попытки не найдены';
$string['noattemptstoshow'] = 'Нет попыток';
$string['nocategory'] = 'Категория не верна или не определена';
$string['noclose'] = 'Нет даты закрытия';
$string['nocommentsyet'] = 'Коментариев еще нет';
$string['noconnection'] = 'Нет связи с веб-службой, которая должна обрабатывать этот вопрос. Свяжитесь с Вашим администратором.';
$string['nodataset'] = 'пусто - это не шаблон';
$string['nodatasubmitted'] = 'Данные не были отправлены.';
$string['noessayquestionsfound'] = 'Оцениваемых вручную вопросов не найдено';
$string['nogradewarning'] = 'Этот тест не оценивается, таким образом вы не можете задать общий отзыв, различный для разных оценок.';
$string['nomoreattempts'] = 'У Вас больше нет попыток';
$string['none'] = 'Нет';
$string['noopen'] = 'Нет даты начала';
$string['nooverridedata'] = 'Вы должны изменить по меньшей мере одну из настроек теста.';
$string['nopossibledatasets'] = 'Нет доступных наборов данных';
$string['noquestionintext'] = 'Текст вопроса не содержит вложенных ответов';
$string['noquestions'] = 'Пока не добавлено ни одного вопроса';
$string['noquestionsfound'] = 'Не найдено ни одного вопроса';
$string['noquestionsinquiz'] = 'В этом тесте нет вопросов.';
$string['noquestionsnotinuse'] = 'Этот случайный вопрос не используется, так как его категория пуста.';
$string['noquestionsonpage'] = 'Пустая страница';
$string['noresponse'] = 'Нет ответов';
$string['noreview'] = 'Вам не разрешен просмотр этого теста.';
$string['noreviewattempt'] = 'Вам не разрешен просмотр этой попытки.';
$string['noreviewshort'] = 'Не разрешается';
$string['noreviewuntil'] = 'Вы не можете просмотреть этот тест до {$a}';
$string['noreviewuntilshort'] = 'Доступные {$a}';
$string['noscript'] = 'Чтобы продолжить, включите в своем браузере JavaScript!';
$string['notavailabletostudents'] = 'Примечание: В настоящий момент этот тест недоступен студентам';
$string['notenoughrandomquestions'] = 'В категории {$a->category} недостаточно вопросов, чтобы создать вопрос {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Было указано недостаточное количество подвопросов!<br />Вы хотите вернуться к редактированию вопроса?';
$string['notimedependentitems'] = 'Элементы с заданным временем в настоящее время не поддерживаются модулем «Тест». Для решения этой проблемы можно установить лимит времени для всего теста. Вы хотите выбрать другой элемент (или, все-таки, использовать текущий)?';
$string['notyetgraded'] = 'Еще не оценено';
$string['notyetviewed'] = 'Еще не рассмотрено';
$string['notyourattempt'] = 'Это не Ваша попытка!';
$string['noview'] = 'Вошедшему в систему пользователю не разрешено просматривать этот тест';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} выполнил(и) попыток: {$a->attemptnum} ';
$string['numattemptsmade'] = 'Выполнено попыток сдачи теста: {$a} ';
$string['numberabbr'] = '№';
$string['numerical'] = 'Числовой';
$string['numquestionsx'] = 'Вопросы: {$a}';
$string['oneminute'] = '1 минута';
$string['onlyteachersexport'] = 'Только преподаватели могут экспортировать вопросы';
$string['onlyteachersimport'] = 'Только преподаватели с правом редактирования могут импортировать вопросы';
$string['onthispage'] = 'Эта страница';
$string['open'] = 'Не отвечено';
$string['openafterclose'] = 'Не удалось обновить тест. Вы указали дату открытия после даты закрытия.';
$string['openclosedatesupdated'] = 'Обновлены даты открытия и закрытия теста';
$string['optional'] = 'необязательно';
$string['orderandpaging'] = 'Порядок и распределение';
$string['orderandpaging_help'] = 'Номера 10, 20, 30, ... напротив вопросов указывают на порядок вопросов. Номера увеличиваются с шагом 10, чтобы оставить место для дополнительных вопросов, которые могут быть вставлены позже. Чтобы изменить порядок вопросов, измените их номера и нажмите кнопку «Изменить порядок вопросов».

Чтобы добавить разрывы страниц после определенных вопросов, отметьте эти вопросы флажками, нажмите кнопку «Добавить новые страницы после выбранных вопросов».

Для расположения на страницах заданного количества вопросов нажмите кнопку «Распределить» и выберите желаемое количество вопросов на странице.';
$string['orderingquiz'] = 'Порядок и распределение';
$string['orderingquizx'] = 'Порядок и распределение: {$a}';
$string['outcomesadvanced'] = '«Результаты» относятся к дополнительным настройкам';
$string['outof'] = '{$a->grade} из {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} из {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Итоговый отзыв';
$string['overallfeedback_help'] = 'Итоговый отзыв - это текст, который отображается после прохождения попытки теста. Текст итогового отзыва может зависеть от полученной оценки при указании дополнительных границ оценок (в процентах или в виде числа).';
$string['overdue'] = 'Срок закончился';
$string['overduehandling'] = 'При истечении времени';
$string['overduehandlingautoabandon'] = 'Попытки должны быть отправлены до истечения времени, иначе они не учитываются';
$string['overduehandlingautosubmit'] = 'Открытые попытки отправляются автоматически';
$string['overduehandling_desc'] = 'Что должно произойти по умолчанию, если студент не отправит попытку теста до истечения времени.';
$string['overduehandlinggraceperiod'] = 'В льготный период разрешить отправку, не изменяя никаких ответов';
$string['overduehandling_help'] = 'Этот параметр определяет, что произойдет, если студент не отправит попытку теста до истечения заданного времени. Если студент в это время активно работает над тестом, то таймер обратного отсчета всегда автоматически отправит его попытку. Но если студент вышел из системы, то этот параметр определяет, что произойдет.';
$string['overduemustbesubmittedby'] = 'Эта попытка уже просрочена. Если Вы хотите, чтобы этот тест был оценен, необходимо отправить его {$a}. Если Вы не отправите попытку, то она не будет оценена.';
$string['override'] = 'Переопределение';
$string['overridedeletegroupsure'] = 'Вы уверены, что хотите удалить переопределение группы {$a}?';
$string['overridedeleteusersure'] = 'Вы уверены, что хотите удалить переопределение пользователя {$a}?';
$string['overridegroup'] = 'Переопределение группы';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Переопределения';
$string['overrideuser'] = 'Переопределение пользователя';
$string['overrideusereventname'] = '{$a->quiz} - Переопределение';
$string['page-mod-quiz-attempt'] = 'Страница попыток теста';
$string['page-mod-quiz-edit'] = 'Редактировать страницу теста';
$string['page-mod-quiz-report'] = 'Страница всех отчетов теста';
$string['page-mod-quiz-review'] = 'Страница просмотра попыток теста';
$string['page-mod-quiz-summary'] = 'Сводная страница попыток теста';
$string['page-mod-quiz-view'] = 'Страница информации теста';
$string['page-mod-quiz-x'] = 'Любая страница теста';
$string['pageshort'] = 'Стр.';
$string['pagesize'] = 'Размер страницы';
$string['parent'] = 'Доступные категории';
$string['parentcategory'] = 'Родительская категория';
$string['parsingquestions'] = 'Получение вопроса  из импортируемого файла';
$string['partiallycorrect'] = 'Частично верно';
$string['penalty'] = 'Штраф';
$string['penaltyscheme'] = 'Начислять штрафы';
$string['penaltyscheme_help'] = 'Если включено, то за неверный ответ из итогового балла вопроса начисляется штраф. Размер штрафа указан в настройках вопроса. Этот параметр применяется только в обучающем режиме.
';
$string['percentcorrect'] = 'Процент правильных';
$string['pleaseclose'] = 'Ваш запрос был выполнен. Теперь Вы можете закрыть это окно';
$string['pluginadministration'] = 'Управление тестом';
$string['pluginname'] = 'Тест';
$string['popup'] = 'Отображать тест в «защищенном» окне';
$string['popupblockerwarning'] = 'Эта часть теста находится в безопасном режиме, это означает, что Вы должны выполнить тест в «защищенном» окне. Пожалуйста, отключите блокировку всплывающих окон. Спасибо.';
$string['popupnotice'] = 'Студенты увидят этот тест в «защищенном» окне';
$string['preprocesserror'] = 'Во время предварительной обработки произошла ошибка!';
$string['preview'] = 'Просмотр';
$string['previewquestion'] = 'Просмотр вопроса';
$string['previewquiz'] = 'Предварительный просмотр теста «{$a}»';
$string['previewquiznow'] = 'Начать просмотр теста';
$string['previous'] = 'Предыдущее состояние';
$string['privacy:metadata:core_question'] = 'Модуль «Тест» хранит информацию об использовании вопросов в подсистеме core_question.';
$string['privacy:metadata:quiz'] = 'Тест использует отчеты о тесте';
$string['privacy:metadata:quizaccess'] = 'Тест использует правила доступа к тесту.';
$string['privacy:metadata:quiz_attempts'] = 'Подробности о каждой попытке теста.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'Номер попытки.';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'Текущая страница, на которой находится пользователь.';
$string['privacy:metadata:quiz_attempts:preview'] = 'Является ли это предварительным просмотром теста.';
$string['privacy:metadata:quiz_attempts:state'] = 'Текущее состояние попытки.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'Сумма оценок в попытке.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'Время проверки состояния.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'Время завершения попытки.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'Время обновления попытки.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'Время оффлайн обновления попытки.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'Время начала попытки.';
$string['privacy:metadata:quiz_grades'] = 'Подробная информация об общей оценке этого теста.';
$string['privacy:metadata:quiz_grades:grade'] = 'Общая оценка для этого теста.';
$string['privacy:metadata:quiz_grades:quiz'] = 'Тест, который был оценен.';
$string['privacy:metadata:quiz_grades:timemodified'] = 'Время, когда оценка была изменена.';
$string['privacy:metadata:quiz_grades:userid'] = 'Пользователь, который был оценен.';
$string['privacy:metadata:quiz_overrides'] = 'Подробная информация о переопределениях для этого теста';
$string['privacy:metadata:quiz_overrides:quiz'] = 'Тест с переопределением информации';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'Новое время закрытия теста.';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'Новое время ограничения для теста.';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'Новое время открытия теста.';
$string['privacy:metadata:quiz_overrides:userid'] = 'Пользователь переопределяется';
$string['publish'] = 'Опубликовать';
$string['publishedit'] = 'Вы должны иметь разрешение в открытом курсе на изменение или добавление вопросов в эту категорию';
$string['qbrief'] = 'В. {$a}';
$string['qname'] = 'название';
$string['qti'] = 'Формат IMS QTI';
$string['qtypename'] = 'тип, название';
$string['question'] = 'Вопрос';
$string['questionbank'] = 'из банка вопросов';
$string['questionbankmanagement'] = 'Управление Банком вопросов';
$string['questionbehaviour'] = 'Свойства вопроса';
$string['questioncats'] = 'Категории вопросов';
$string['questiondeleted'] = 'Этот вопрос был удален. Пожалуйста, свяжитесь с вашим учителем';
$string['questiondependencyadd'] = 'Нет ограничений на то, когда на вопрос «{$a->thisq}» может быть дан ответ • Нажмите, чтобы изменить';
$string['questiondependencyfree'] = 'Нет ограничений на этот вопрос';
$string['questiondependencyremove'] = 'На вопрос «{$a->thisq}» нельзя ответить, пока на предыдущий вопрос «{$a->previousq}» не будет дан ответ • Нажмите, чтобы изменить';
$string['questiondependsonprevious'] = 'На этот вопрос нельзя ответить, пока не будет дан ответ на предыдущий вопрос.';
$string['questioninuse'] = 'Вопрос \'{$a->questionname}\' в данный момент используется в следующих тестах: <br />{$a->quiznames}.<br /> Этот вопрос будет удален только из списка категорий, но не из указанных тестов.';
$string['questionmissing'] = 'Вопрос для этого сеанса отсутствует';
$string['questionname'] = 'Название вопроса';
$string['questionnonav'] = '<span class="accesshide">Вопрос </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Информация </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Вопрос {$a} не был загружен из базы данных';
$string['questionorder'] = 'Порядок вопросов';
$string['questionposition'] = 'Новая позиция в списке для вопроса {$a}';
$string['questions'] = 'Вопросы';
$string['questionsetpreview'] = 'Предварительный просмотр набора вопросов';
$string['questionsinclhidden'] = 'Вопросы (включая скрытые)';
$string['questionsinthisquiz'] = 'Вопросы этого теста';
$string['questionsmatchingfilter'] = 'Вопросы, соответствующие этому фильтру: {$a}';
$string['questionsperpage'] = 'Вопросов на одной странице';
$string['questionsperpageselected'] = 'Вопросы на странице были распределены и в настоящее время зафиксированы. В результате управление распределением было отключено. Вы можете изменить это в {$a}.';
$string['questionsperpagex'] = 'Вопросов на странице: {$a}';
$string['questiontext'] = 'Содержание вопроса';
$string['questiontextisempty'] = '[Пустой текст вопроса]';
$string['questiontype'] = 'Тип вопроса {$a}';
$string['questiontypesetupoptions'] = 'Установка параметров для типов вопросов:';
$string['quiz:addinstance'] = 'Добавлять новый тест';
$string['quiz:attempt'] = 'Проходить тестирование';
$string['quizavailable'] = 'Последний срок сдачи: {$a}';
$string['quizclose'] = 'Окончание тестирования';
$string['quizclosed'] = 'Тестирование закончено: {$a}';
$string['quizcloses'] = 'Тест закрывается';
$string['quizcloseson'] = 'Тестирование будет окончено в {$a}';
$string['quiz:deleteattempts'] = 'Удалять попытки тестирования';
$string['quiz:emailconfirmsubmission'] = 'Получать сообщение с подтверждением при отправке теста';
$string['quiz:emailnotifysubmission'] = 'Получать сообщение с извещением о попытках прохождения теста';
$string['quiz:emailwarnoverdue'] = 'Получать уведомление о том, что попытка становится просроченной и должна быть отправлена.';
$string['quizeventcloses'] = '{$a} закрывается';
$string['quizeventopens'] = '{$a} открывается';
$string['quiz:grade'] = 'Оценивать тест вручную';
$string['quiz:ignoretimelimits'] = 'Игнорировать ограничение времени в тестах';
$string['quizisclosed'] = 'Этот тест закрыт';
$string['quizisclosedwillopen'] = 'Тест закрыт (открывается {$a})';
$string['quizisopen'] = 'Этот тест открыт';
$string['quizisopenwillclose'] = 'Тест открыт (закрывается {$a})';
$string['quiz:manage'] = 'Управлять тестами';
$string['quiz:manageoverrides'] = 'Управлять переопределениями для теста';
$string['quiznavigation'] = 'Навигация по тесту';
$string['quizopen'] = 'Начало тестирования';
$string['quizopenclose'] = 'Даты открытия и закрытия';
$string['quizopenclose_help'] = 'Студенты смогут начать свою попытку(ки) после времени  открытия теста и они должны завершить свои попытки перед временем его закрытия.';
$string['quizopened'] = 'Этот тест открыт.';
$string['quizopenedon'] = '	
Этот тест был начат {$a}';
$string['quizopens'] = 'Тест открывается';
$string['quizopenwillclose'] = 'Этот тест открыт, закроется {$a}';
$string['quizordernotrandom'] = 'Вопросы теста не перемешиваются';
$string['quizorderrandom'] = '* Вопросы теста перемешиваются';
$string['quiz:preview'] = 'Осуществлять предварительный просмотр тестов';
$string['quiz:regrade'] = 'Переоценивать попытки тестирования';
$string['quiz:reviewmyattempts'] = 'Просматривать свои попытки';
$string['quizsettings'] = 'Настройки теста';
$string['quiztimer'] = 'Таймер теста';
$string['quiz:view'] = 'Посматривать информацию о тесте';
$string['quiz:viewreports'] = 'Посматривать отчеты теста';
$string['quizwillopen'] = 'Этот тест откроется {$a}';
$string['random'] = 'Случайный вопрос';
$string['randomcreate'] = 'Создать случайные вопросы';
$string['randomediting'] = 'Редактирование случайного вопроса';
$string['randomfromcategory'] = 'Случайный вопрос из категории:';
$string['randomfromexistingcategory'] = 'Случайный вопрос из существующей категории';
$string['randomfromunavailabletag'] = '{$a} (недоступно)';
$string['randomnosubcat'] = 'Вопросы только из этой категории, но не из ее подкатегорий.';
$string['randomnumber'] = 'Количество случайных вопросов';
$string['randomquestion'] = 'Случайный вопрос';
$string['randomquestion_help'] = 'Случайный вопрос - это способ вставить в тест случайно выбранный вопрос из указанной категории или по заданному тегу.';
$string['randomquestiontags'] = 'Теги';
$string['randomquestiontags_help'] = 'Вы можете дополнительно ограничить критерии выбора, указав здесь несколько тегов вопросов.

«Случайные» вопросы будут выбраны из вопросов, имеющих все эти теги.';
$string['randomquestionusinganewcategory'] = 'Случайный вопрос из новой категории';
$string['randomwithsubcat'] = 'Вопросы из этой категории и ее подкатегорий.';
$string['readytosend'] = 'Вы собираетесь отправить тест на проверку. Вы уверены?';
$string['reattemptquiz'] = 'Пройти тест заново';
$string['recentlyaddedquestion'] = 'Недавно добавленный вопрос!';
$string['recurse'] = 'Включать также вопросы из  подкатегорий';
$string['redoesofthisquestion'] = '? Другие вопросы, на которые можно дать ответ здесь: {$a}';
$string['redoquestion'] = 'Попробуйте другой вопрос, подобный этому';
$string['regrade'] = 'Переоценить все попытки';
$string['regradecomplete'] = 'Все попытки были заново оценены';
$string['regradecount'] = '{$a->changed} из {$a->attempt} оценки были изменены';
$string['regradedisplayexplanation'] = 'Попытки, которые изменились после переоценивания, отображаются в виде гиперссылок на страницу просмотра вопроса
';
$string['regradenotallowed'] = 'Вы не имеете прав для переоценивания этого теста';
$string['regradingquestion'] = 'Переоценивание «{$a}».';
$string['regradingquiz'] = 'Переоценивание теста «{$a}»';
$string['remove'] = 'Удалить';
$string['removeallgroupoverrides'] = 'Удалить все переопределения групп';
$string['removeallquizattempts'] = 'Удалить все попытки прохождения теста';
$string['removealluseroverrides'] = 'Удалить все переопределения пользователей';
$string['removeemptypage'] = 'Удалить пустую страницу';
$string['removepagebreak'] = 'Удалить разрыв страницы';
$string['removeselected'] = 'Удалить выбранное';
$string['rename'] = 'Переименовать';
$string['renderingserverconnectfailed'] = 'Сервер {$a} не обработал запрос RQP. Проверьте правильность адреса (URL).';
$string['reorderquestions'] = 'Упорядочить вопросы';
$string['reordertool'] = 'Показать инструмент перестановки вопросов';
$string['repaginate'] = 'Распределить по {$a} вопросов на страницу';
$string['repaginatecommand'] = 'Распределить';
$string['repaginatenow'] = 'Распределить сейчас';
$string['replace'] = 'Заменить';
$string['replacementoptions'] = 'Параметры замены';
$string['report'] = 'Отчеты';
$string['reportanalysis'] = 'Анализ теста';
$string['reportattemptsfrom'] = 'Попытки от';
$string['reportattemptsthatare'] = 'Попытки, которые';
$string['reportdisplayoptions'] = 'Отображать варианты';
$string['reportfullstat'] = 'Детальная статистика';
$string['reportmulti_percent'] = 'Множественные проценты';
$string['reportmulti_q_x_student'] = 'Множественные выборы студентов';
$string['reportmulti_resp'] = 'Индивидуальные ответы';
$string['reportmustselectstate'] = 'Вы должны выбрать хотя бы одно состояние.';
$string['reportnotfound'] = 'Неизвестный отчет ({$a})';
$string['reportoverview'] = 'Краткий обзор';
$string['reportregrade'] = 'Переоценить попытку';
$string['reportresponses'] = 'Ответы подробнее';
$string['reports'] = 'Отчеты';
$string['reportshowonly'] = 'Показать только попытки';
$string['reportshowonlyfinished'] = 'Показывать не более одной законченной попытки каждого пользователя ({$a})';
$string['reportsimplestat'] = 'Упрощенная статистика';
$string['reportusersall'] = 'все пользователи, имеющие попытки теста';
$string['reportuserswith'] = 'записанные пользователи, имеющие попытки теста';
$string['reportuserswithorwithout'] = 'записанные пользователи, имеющие или не имеющие попыток теста';
$string['reportuserswithout'] = 'записанные пользователи, не имеющие попыток теста';
$string['reportwhattoinclude'] = 'Что включить в отчет';
$string['requirepassword'] = 'Необходим пароль';
$string['requirepassword_help'] = 'Если пароль задан, то студент должен будет ввести его перед попыткой прохождения теста.';
$string['requiresubnet'] = 'Необходим сетевой адрес';
$string['requiresubnet_help'] = 'Вы можете разрешить доступ к тесту только из определенных подсетей локальной сети или Интернета, задав разделенный запятыми список частичных или полных IP-адресов. Это может быть особенно полезно, если вы хотите, чтобы тест можно было пройти только из определенной аудитории.

';
$string['response'] = 'Ответ';
$string['responses'] = 'Свои ответы';
$string['results'] = 'Результаты';
$string['returnattempt'] = 'Вернуться к попытке';
$string['reuseifpossible'] = 'повторно использовать ранее удаленные';
$string['reverttodefaults'] = 'Вернуться к тесту по умолчанию';
$string['review'] = 'Просмотр';
$string['reviewafter'] = 'Разрешить просмотр после того, как тест будет закрыт';
$string['reviewalways'] = 'Разрешить просмотр в любое время';
$string['reviewattempt'] = 'Просмотр попытки';
$string['reviewbefore'] = 'Разрешить просмотр пока тест открыт';
$string['reviewclosed'] = 'После того, как тест будет закрыт';
$string['reviewduring'] = 'Во время попытки';
$string['reviewimmediately'] = 'Сразу после попытки';
$string['reviewnever'] = 'Запретить просмотр';
$string['reviewofattempt'] = 'Просмотр попытки {$a}';
$string['reviewofpreview'] = 'Обзор результатов предварительного просмотра';
$string['reviewofquestion'] = 'Пересмотреть ответ на вопрос «{$a->question}» в тесте «{$a->quiz}», данный пользователем {$a->user}';
$string['reviewopen'] = 'Позже, но только пока тест открыт';
$string['reviewoptions'] = 'Студенты могут просматривать';
$string['reviewoptionsheading'] = 'Настройки просмотра';
$string['reviewoptionsheading_help'] = 'Эти параметры определяют, какую информацию студенты могут видеть, когда они просматривают попытки теста или видят отчеты теста.

**При попытке** - параметр важен только для некоторых режимов вопросов, которые могут отображать отзыв во время попытки, например «интерактивный с несколькими попытками».

**Сразу после попытки** параметр применяется в течение первых двух минут после нажатия кнопки «Отправить всё и завершить тест».

**Позже, но пока тест открыт** - через 2 минуты после попытки и до даты закрытия теста.

**После закрытия теста** - после даты закрытия теста. Если тест не имеет даты закрытия, то просмотр невозможен.';
$string['reviewoverallfeedback'] = 'Итоговый отзыв к тесту';
$string['reviewoverallfeedback_help'] = 'Итоговый отзыв дается по окончании попытки в зависимости от оценки студента.';
$string['reviewresponse'] = 'Просмотр ответа';
$string['reviewresponsetoq'] = 'Просмотр ответа (вопрос {$a})';
$string['reviewthisattempt'] = 'Просмотр своих ответов этой попытки';
$string['rqp'] = 'Отдаленный вопрос';
$string['rqps'] = 'Отдаленные вопросы';
$string['sameasoverall'] = 'То же, что для общей оценки';
$string['save'] = 'Сохранить';
$string['saveandedit'] = 'Сохранить изменения и редактировать вопросы';
$string['saveattemptfailed'] = 'Не удалось сохранить эту попытку теста.';
$string['savedfromdeletedcourse'] = 'Сохранено из удаленного курса «{$a}»';
$string['savegrades'] = 'Сохранить оценки';
$string['savemyanswers'] = 'Сохранить мои ответы';
$string['savenosubmit'] = 'Сохранить, но не отправлять';
$string['saveoverrideandstay'] = 'Сохранить и ввести следующее переопределение';
$string['savequiz'] = 'Сохранить этот тест';
$string['saving'] = 'Сохранение';
$string['savingnewgradeforquestion'] = 'Сохранение новой оценки для вопроса ID {$a}.';
$string['savingnewmaximumgrade'] = 'Сохранение новой максимальной оценки.';
$string['score'] = 'Набрано баллов';
$string['scores'] = 'Баллы';
$string['search:activity'] = 'Тест — информация об элементе курса';
$string['sectionheadingedit'] = 'Редактировать заголовок «{$a}»';
$string['sectionheadingremove'] = 'Удалить заголовок «{$a}»';
$string['seequestions'] = '(См. вопросы)';
$string['select'] = 'Выбор';
$string['selectall'] = 'Выбрать все';
$string['selectcategory'] = 'Выбрать категорию';
$string['selectedattempts'] = 'Выбранные попытки';
$string['selectmultipleitems'] = 'Выберите несколько элементов';
$string['selectmultipletoolbar'] = 'Выберите несколько панелей инструментов';
$string['selectnone'] = 'Убрать выделение';
$string['selectquestiontype'] = '- Выберите тип вопроса -';
$string['serveradded'] = 'Сервер добавлен';
$string['serveridentifier'] = 'Определитель';
$string['serverinfo'] = 'Информация о сервере';
$string['servers'] = 'Серверы';
$string['serverurl'] = 'Адрес сервера';
$string['settingsoverrides'] = 'Настройки переопределений';
$string['shortanswer'] = 'Короткий ответ';
$string['show'] = 'Показать';
$string['showall'] = 'Отображать все вопросы на одной странице';
$string['showblocks'] = 'Отображать блоки во время прохождения теста';
$string['showblocks_help'] = 'Если установлено значение «Да», то обычные блоки будут отображаться во время прохождения теста';
$string['showbreaks'] = 'Отображать разрывы страниц';
$string['showcategorycontents'] = 'Показать вопросы категории {$a->arrow}';
$string['showcorrectanswer'] = 'Показывать правильные ответы?';
$string['showdetailedmarks'] = 'Отображать баллы для каждого вопроса';
$string['showeachpage'] = 'Показать одну страницу';
$string['showfeedback'] = 'Показывать отзыв после ответа?';
$string['showinsecurepopup'] = 'Использовать «защищенное» всплывающее окно при прохождении теста';
$string['showlargeimage'] = 'Большое изображение';
$string['shownoattempts'] = 'Показать студентов, не сделавших ни одной попытки';
$string['shownoattemptsonly'] = 'Показать только студентов, не сделавших ни одной попытки';
$string['shownoimage'] = 'Нет изображения';
$string['showreport'] = 'Показать отчет';
$string['showsmallimage'] = 'Маленькое изображение';
$string['showteacherattempts'] = 'Показать попытки преподавателя';
$string['showuserpicture'] = 'Показать фотографию пользователя';
$string['showuserpicture_help'] = 'Если параметр включен, то имя и фотография студента будут отображаться на экране во время прохождения теста и на странице просмотра, что позволит контролировать, кто именно проходит тест.';
$string['shuffle'] = 'Перемешать';
$string['shuffleanswers'] = 'Случайный порядок ответов';
$string['shuffledrandomly'] = 'Случайное перемешивание';
$string['shufflequestions'] = 'Перемешать';
$string['shufflequestions_help'] = 'Если параметр включен, то каждый раз при попытке прохождения теста вопросы в этом разделе будут случайным образом перемешаны.

Это усложнит студентам обмен ответами между собой, но также усложнит для них обсуждение конкретного вопроса с учителем.';
$string['shufflewithin'] = 'Случайный порядок ответов';
$string['shufflewithin_help'] = 'Если включено, то варианты ответов каждого вопроса будут случайным образом перемешиваться каждый раз, когда студент будет начинать новую попытку при условии соответствующей настройки для каждого отдельного вопроса. Этот параметр применяется только для типов вопросов с вариантами ответов («Множественный выбор» и «На соответствие»).';
$string['singleanswer'] = 'Выберите один ответ.';
$string['sortage'] = 'Сортировать по времени создания';
$string['sortalpha'] = 'Сортировать по названию';
$string['sortquestionsbyx'] = 'Сортировать вопросы по: {$a}';
$string['sortsubmit'] = 'Сортировать вопросы';
$string['sorttypealpha'] = 'Сортировать по типу, названию';
$string['specificapathnotonquestion'] = 'Указанный путь файла не к заданному вопросу';
$string['specificquestionnotonquiz'] = 'Указанный вопрос не в заданном тесте';
$string['startagain'] = 'Начать заново';
$string['startattempt'] = 'Начать попытку';
$string['startedon'] = 'Тест начат';
$string['startnewpreview'] = 'Начать новый просмотр';
$string['stateabandoned'] = 'Не отправленные';
$string['statefinished'] = 'Завершенные';
$string['statefinisheddetails'] = 'Отправлено {$a}';
$string['stateinprogress'] = 'В процессе';
$string['statenotloaded'] = 'Структура вопроса {$a} не была загружена из базы данных';
$string['stateoverdue'] = 'Просроченные';
$string['stateoverduedetails'] = 'Должны быть представлены {$a}';
$string['status'] = 'Состояние';
$string['stoponerror'] = 'Закончить обработку при ошибке';
$string['submitallandfinish'] = 'Отправить всё и завершить тест';
$string['subneterror'] = 'Извините, этот тест доступен для прохождения только на определенных компьютерах. На Вашем компьютере тест пройти нельзя.';
$string['subnetnotice'] = 'Этот тест доступен только на некоторых компьютерах. Ваш компьютер не находится в разрешенной зоне. Тем не менее, поскольку Вы являетесь учителем, вы можете просмотреть тест.';
$string['subplugintype_quiz'] = 'Отчет';
$string['subplugintype_quizaccess'] = 'Правило доступа';
$string['subplugintype_quizaccess_plural'] = 'Правила доступа';
$string['subplugintype_quiz_plural'] = 'Отчеты';
$string['substitutedby'] = 'будет замещен';
$string['summaryofattempt'] = 'Результат попытки';
$string['summaryofattempts'] = 'Результаты ваших предыдущих попыток';
$string['temporaryblocked'] = 'Вам временно запрещено проходить тест.<br />Вы можете предпринять следующую попытку не ранее, чем:';
$string['theattempt'] = 'Попытка';
$string['theattempt_help'] = 'Может ли вообще студент просматривать попытку тестирования.';
$string['time'] = 'Время';
$string['timecompleted'] = 'Завершено';
$string['timedelay'] = 'Вам запрещено проходить тест, т.к. еще не прошел установленный срок после прохождения другого теста.';
$string['timeleft'] = 'Оставшееся время';
$string['timelimit'] = 'Ограничение времени';
$string['timelimitexeeded'] = 'Извините, время закончилось!';
$string['timelimit_help'] = 'Если включено, то ограничение по времени устанавливается на начальной странице теста и отсчет таймера отображается в блоке навигации теста.';
$string['timestr'] = '%d/%m/%y в %H:%M:%S';
$string['timesup'] = 'Время закончилось!';
$string['timetaken'] = 'Прошло времени';
$string['timing'] = 'Синхронизация';
$string['tofile'] = 'добавить в файл';
$string['tolerance'] = 'Погрешность';
$string['toomanyrandom'] = 'Заданное количество случайных вопросов больше, чем содержится в категории!';
$string['top'] = 'Главная';
$string['totalmarksx'] = 'Итоговый балл: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Всего вопросов в категории: {$a}.';
$string['true'] = 'Верно';
$string['truefalse'] = 'Верно/Неверно';
$string['type'] = 'Тип';
$string['unfinished'] = 'не закончен';
$string['ungraded'] = 'Не оценено';
$string['unit'] = 'Единица измерения';
$string['unknowntype'] = 'В строке {$a} неподдерживаемый тип вопроса. Вопрос будет проигнорирован.';
$string['updateoverdueattemptstask'] = 'Обновление просроченных попыток теста';
$string['updatesettings'] = 'Обновить настройки теста';
$string['updatingatttemptgrades'] = 'Обновление оценок попыток.';
$string['updatingfinalgrades'] = 'Обновление итоговых оценок.';
$string['updatingthegradebook'] = 'Обновление журнала оценок.';
$string['upgradesure'] = '<div>В частности модуль тест выполнит обширное изменение таблиц теста, и эта модернизация еще не достаточно проверена. Перед продолжением Вам настоятельно рекомендуется сделать копию таблиц своей базы данных.</div>';
$string['upgradingquizattempts'] = 'Обновление попыток теста: тест {$a->done}/{$a->outof} (ID теста {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Обновление очень старых попыток теста: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Эта категория была перемещена на уровень сайта, поскольку вопросы этой опубликованной категории используются в других курсах.';
$string['useroverrides'] = 'Переопределение пользователей';
$string['useroverridesdeleted'] = 'Переопределения пользователя удалены';
$string['usersnone'] = 'Нет студентов, имеющих доступ к этому тесту';
$string['validate'] = 'Подтвердить';
$string['viewallanswers'] = 'Посмотреть завершенные попытки ({$a})';
$string['viewallreports'] = 'Посмотреть отчет по {$a} попыткам';
$string['viewed'] = 'Просмотрено';
$string['warningmissingtype'] = '<b>Этот вопрос относится к типу, который еще не поддерживается вашей системой Moodle.<br /> Пожалуйста, свяжитесь с администратором Moodle.</b>';
$string['wheregrade'] = 'Где моя оценка?';
$string['wildcard'] = 'Шаблон';
$string['windowclosing'] = 'Это окно скоро закроется.';
$string['withsummary'] = 'с суммарной статистикой';
$string['wronguse'] = 'Вы не можете использовать эту страницу таким образом';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Для выполнения теста вы должны записаться на этот курс';
$string['yourfinalgradeis'] = 'Ваша итоговая оценка за этот тест: {$a}';
