<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'es', branch 'MOODLE_37_STABLE'
 *
 * @package   hvp
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Acción';
$string['addedandupdatedpp'] = 'Se agregaron {$a->%new} nuevas bibliotecas H5P y se actualizaron {$a->%old} antiguas.';
$string['addedandupdatedps'] = 'Se agregaron {$a->%new} nuevas bibliotecas H5P y se actualizó {$a->%old} antigua.';
$string['addedandupdatedsp'] = 'Se agregó {$a->%new} nueva biblioteca H5P y se actualizaron {$a->%old} antiguas.';
$string['addedandupdatedss'] = 'Se agregó {$a->%new} nueva biblioteca H5P y se actualizó {$a->%old} antigua.';
$string['addednewlibraries'] = 'Se agregaron {$a->%new} nuevas bibliotecas H5P.';
$string['addednewlibrary'] = 'Se agregó {$a->%new} nueva biblioteca H5P.';
$string['additionalinfo'] = 'Información adicional';
$string['additionallicenseinfo'] = 'Cualquier información adicional sobre la licencia';
$string['addlibraries'] = 'Agregar bibliotecas';
$string['ajaxfailed'] = 'Error al cargar datos.';
$string['anunexpectedsave'] = 'Algo inesperado sucedió. No hemos podido guardar este contenido.';
$string['attribution'] = 'Atribución 4.0';
$string['attributionnc'] = 'Atribución - No comercial 4.0';
$string['attributionncnd'] = 'Atribución - No comercial - No derivados 4.0';
$string['attributionncsa'] = 'Atribución - No comercial - Compartir por igual 4.0';
$string['attributionnd'] = 'Atribución - No derivados 4.0';
$string['attributionsa'] = 'Atribución - Compartir por igual 4.0';
$string['author'] = 'Autor';
$string['authorcomments'] = 'Comentarios de autores';
$string['authorcommentsdescription'] = 'Comentarios para el editor del contenido (este texto no se publicará como parte de la información de derechos de autor)';
$string['authorname'] = 'Nombre del autor';
$string['authorrole'] = 'Rol del autor';
$string['by'] = 'por';
$string['cancellabel'] = 'Cancelar';
$string['ccattribution'] = 'Atribución (CC BY)';
$string['ccattributionnc'] = 'Atribución-NoComercial (CC BY-NC)';
$string['ccattributionncnd'] = 'Atribución-NoComercial-NoDerivs (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Atribución-NoComercial-ShareAlike (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Atribución-NoDerivs (CC BY-ND)';
$string['ccattributionsa'] = 'Atribución-ShareAlike (CC BY-SA)';
$string['ccpdd'] = 'Dedicación Dominio Público (CC0)';
$string['ccpdm'] = 'Marcado Dominio Público (PDM)';
$string['changedby'] = 'Cambiado por';
$string['changedescription'] = 'Descripción del Cambio';
$string['changelog'] = 'Registro de cambios';
$string['changeplaceholder'] = 'Foto recortada, texto cambiado, etc.';
$string['close'] = 'Cerrar';
$string['completionpass'] = 'Requerir calificación aprobatoria';
$string['completionpassdesc'] = 'El estudiante debe lograr una calificación aprobatoria para completar esta actividad';
$string['completionpass_help'] = 'Si se habilita, esta actividad es considerada completada cuando el estudiante recibe una calificación aprobatoria (según sea especificada en la sección de Calificación de las configuraciones de H5P) o mayor.';
$string['confirmdialogbody'] = 'Por favor confirme que desea continuar. Esta acción no es reversible.';
$string['confirmdialogheader'] = 'Confirmar acción';
$string['confirmlabel'] = 'Confirmar';
$string['connectionlost'] = 'Conexión perdida. Los resultados se almacenarán y se enviarán cuando recupere la conexión.';
$string['connectionreestablished'] = 'Conexión restablecida.';
$string['contentchanged'] = 'Este contenido ha cambiado desde la última vez que lo usaste.';
$string['contentcopied'] = 'El contenido se copia en el portapapeles';
$string['contentstatefrequency'] = 'Guardar frecuencia de estado de contenido';
$string['contentstatefrequency_help'] = 'En segundos, ¿con qué frecuencia desea que el usuario guarde automáticamente su progreso? Aumenta este número si tienes problemas con muchas solicitudes ajax';
$string['contenttype'] = 'Tipo de contenido';
$string['contenttypecacheheader'] = 'Caché de tipo de contenido';
$string['copyright'] = 'Derechos de uso';
$string['copyrightinfo'] = 'Información Copyright';
$string['copyrightstring'] = 'Copyright';
$string['copyrighttitle'] = 'Ver información Copyright para este contenido.';
$string['couldnotcopy'] = 'No se pudo copiar el archivo.';
$string['couldnotparsejsonfromzip'] = 'No se puede analizar JSON desde el paquete: %fileName';
$string['couldnotparsepostdata'] = 'No se han podido analizar los datos de la publicación.';
$string['couldnotreadfilefromzip'] = 'No se puede leer el archivo del paquete: %fileName';
$string['couldnotsave'] = 'No se pudo guardar el archivo.';
$string['create'] = 'Crear';
$string['creativecommons'] = 'Creative Commons';
$string['ctcachebuttonlabel'] = 'Actualizar Cache de tipo de contenido';
$string['ctcacheconnectionfailed'] = 'No se pudo comunicar con el Hub H5P. Por favor, inténtelo de nuevo más tarde.';
$string['ctcachedescription'] = 'Asegurarse de que la caché de tipo de contenido esté actualizada le garantizará que pueda ver, descargar y usar las últimas bibliotecas. Esto es diferente de actualizar las bibliotecas.';
$string['ctcachelastupdatelabel'] = 'Ultima atualización';
$string['ctcacheneverupdated'] = 'Nunca';
$string['ctcachenolibraries'] = 'No se recibieron tipos de contenido del Hub H5P. Por favor, inténtelo de nuevo más tarde.';
$string['ctcachesuccess'] = '¡El caché de la biblioteca se actualizó con éxito!';
$string['ctcachetaskname'] = 'Actualizar el cache del tipo de contenido';
$string['currentpage'] = 'Página $current de $total';
$string['dataviewreportlabel'] = 'Ver respuestas';
$string['date'] = 'Fecha';
$string['disablefileextensioncheck'] = 'Deshabilitar verificación de la extensión del archivo';
$string['disablefileextensioncheckwarning'] = '¡Advertencia! Deshabilitar la verificación de la extensión del archivo puede tener implicaciones de seguridad, ya que permite la carga de archivos php. Eso a su vez podría hacer posible que los atacantes ejecuten código malicioso en su sitio. Por favor, asegúrese de saber exactamente lo que está cargando.';
$string['disablefullscreen'] = 'Deshabilitar pantalla completa';
$string['disablehubconfirmationmsg'] = '¿Aún quiere habilitar el hub?';
$string['disablehubdescription'] = 'Se recomienda encarecidamente mantener esta opción habilitada. El Hub H5P proporciona una interfaz sencilla para obtener nuevos tipos de contenido y mantener actualizados los tipos de contenido existentes. En el futuro, también será más fácil compartir y reutilizar el contenido. Si esta opción está desactivada, deberá instalar y actualizar los tipos de contenido a través de los formularios de carga de archivos.';
$string['displayoptionalwaysshow'] = 'Mostrar siempre';
$string['displayoptionauthoroff'] = 'Controlado por el autor, por defecto esta deshabilitado';
$string['displayoptionauthoron'] = 'Controlado por el autor, por defecto esta habilitado';
$string['displayoptiondownloadalways'] = 'Siempre';
$string['displayoptiondownloadnever'] = 'Nunca';
$string['displayoptiondownloadpermission'] = 'Solo si el usuario tiene permisos para exportar H5P';
$string['displayoptionnevershow'] = 'Nunca mostrar';
$string['displayoptionpermissions'] = 'Mostrar solo si el usuario tiene permisos de exportar H5P';
$string['displayoptionpermissionsembed'] = 'Mostrar solo si el usuario tiene permisos de incrustar H5P';
$string['displayoptions'] = 'Opciones de pantalla';
$string['download'] = 'Descargar';
$string['downloadfailed'] = 'La descarga de la biblioteca solicitada falló.';
$string['downloadtitle'] = 'Descargue este contenido como un archivo H5P.';
$string['editor'] = 'Editor';
$string['emailconfirmbody'] = 'Hola {$a->username},

Gracias por enviar tus respuestas a \'{$a->hvpname}\' en el curso \'{$a->coursename}\'.

Este mensaje confirma que tus respuestas han sido guardadas.

Puedes acceder a este H5P en {$a->hvpurl}.';
$string['emailconfirmsmall'] = 'Gracias por enviar tus respuestas a \'{$a->hvpname}\\';
$string['emailconfirmsubject'] = 'Confirmación de envío: {$a->hvpname}';
$string['emailnotifybody'] = 'Hola {$a->username},

{$a->studentname} ha completado \'{$a->hvpname}\' ({$a->hvpurl}) en el curso \'{$a->coursename}\'.

Puedes revisar este intento en {$a->hvpreporturl}.';
$string['emailnotifysmall'] = '{$a->studentname} ha completado {$a->hvpname}. Mira en {$a->hvpreporturl}';
$string['emailnotifysubject'] = '{$a->studentname} ha completado {$a->hvpname}';
$string['embed'] = 'Incrustar';
$string['embedloginfailed'] = 'Tú no tienes acceso a este contenido. Intenta iniciar sesión.';
$string['embedtitle'] = 'Ver el código embebido para este contenido.';
$string['empty'] = 'No hay resultados disponibles';
$string['enableabout'] = 'Acerca del botón H5P';
$string['enablecopyright'] = 'Botón Copyright';
$string['enabledlrscontenttypes'] = 'Habilitar tipos de contenido LRS dependientes';
$string['enabledlrscontenttypes_help'] = 'Permite utilizar tipos de contenido que dependen de un Almacén de Aprendizaje para funcionar correctamente, como el tipo de contenido cuestionario.';
$string['enabledownload'] = 'Botón descargar';
$string['enableembed'] = 'Botón Embebido';
$string['enableframe'] = 'Mostrar barra de acción y marco';
$string['enablehublabel'] = 'Usar H5P Hub';
$string['enablejavascript'] = 'Por favor active JavaScript.';
$string['enablesavecontentstate'] = 'Guardar estado de contenido';
$string['enablesavecontentstate_help'] = 'Guarde automáticamente el estado actual del contenido interactivo para cada usuario. Esto significa que el usuario puede continuar donde lo dejó.';
$string['failedtodownloadh5p'] = 'Error al bajar el H5P solicitado.';
$string['fileexceedsmaxsize'] = 'Uno de los archivos del paquete excede el tamaño máximo permitido. (%file %used > %max)';
$string['filenotfoundonserver'] = 'Archivo no encontrado en el servidor. Compruebe la configuración de carga de archivos.';
$string['filenotimage'] = 'El archivo no es una imagen.';
$string['filetypenotallowed'] = 'El tipo de archivo no está permitido.';
$string['finished'] = 'Terminado';
$string['fullscreen'] = 'Pantalla completa';
$string['gpl'] = 'Licencia Pública General v3';
$string['gradetopassmustbeset'] = 'La calificación aprobatoria no puede ser cero porque esta actividad H5P tiene su método de finalización configurado para requerir calificación aprobatoria. Por favor configure un valor diferente de cero.';
$string['gradetopassnotset'] = 'Esta actividad H5P aun no tiene configurada una calificación aprobatoria. Puede ser configurada en la sección de Calificación de las configuraciones de la actividad H5P.';
$string['h5pfile'] = 'Archivo H5P';
$string['h5ptitle'] = 'Visite H5P.org para ver más contenido interesante.';
$string['hide'] = 'Ocultar';
$string['hideadvanced'] = 'Ocultar avanzado';
$string['hubcommunicationdisabled'] = 'La comunicación del hub H5P se ha deshabilitado porque uno o más requisitos de H5P fallaron.';
$string['hubisdisabled'] = 'El hub está deshabilitado. Puede volver a habilitarlo en la configuración de H5P.';
$string['hubisdisableduploadlibraries'] = 'El hub H5P se ha deshabilitado hasta que este problema se pueda resolver. Todavía puede cargar bibliotecas a través de la página "Bibliotecas H5P".';
$string['hubsettingsheader'] = 'Tipos de contenido';
$string['hvp:addinstance'] = 'Crear nuevas actividades H5P';
$string['hvp:emailconfirmsubmission'] = 'Obtener un mensaje de confirmación cuando envía';
$string['hvp:emailnotifysubmission'] = 'Obtener un mensaje de notificación cuando un intento es enviado';
$string['hvp:getcachedassets'] = 'Necesario para ver las actividades H5P';
$string['hvp:getembedcode'] = 'Ver código de inserción H5P cuando la opción \'controlado por permiso\' está configurada';
$string['hvp:getexport'] = 'Descargar el archivo .h5p cuando la opción \'controlado por permiso\' está configurada';
$string['hvp:installrecommendedh5plibraries'] = 'Instale nuevos tipos de contenido H5P seguros recomendados por H5P.org';
$string['hvp:manage'] = 'Editar las actividades H5P existentes';
$string['hvp:restrictlibraries'] = 'Restringir el acceso a ciertos tipos de contenido H5P';
$string['hvp:savecontentuserdata'] = 'Guardar el progreso del usuario para las actividades H5P';
$string['hvp:saveresults'] = 'Guardar los resultados de las actividades H5P completadas';
$string['hvp:updatelibraries'] = 'Instalar nuevos tipos de contenido H5P o actualizar los existentes';
$string['hvp:userestrictedlibraries'] = 'Utilice tipos de contenido H5P restringidos';
$string['hvp:view'] = 'Ver e interactuar con las actividades de H5P';
$string['hvp:viewallresults'] = 'Ver todos los resultados de las actividades H5P completadas';
$string['hvp:viewresults'] = 'Ver resultados propios para actividades H5P completadas';
$string['installdenied'] = 'No tienes permiso para instalar tipos de contenido. Póngase en contacto con el administrador de su sitio.';
$string['installedlibraries'] = 'Bibliotecas instaladas';
$string['intro'] = 'Introducción';
$string['invalidaudioformat'] = 'Formato del archivo de audio no válido. Utilice mp3 o wav.';
$string['invalidcontentfolder'] = 'Carpeta de contenido no válida';
$string['invalidcontenttype'] = 'El tipo de contenido elegido no es válido.';
$string['invalidfieldtype'] = 'Tipo de campo no válido.';
$string['invalidfile'] = 'El archivo "{$a->%filename}" no está permitido. Solo se permiten archivos con las siguientes extensiones: {$a->%files-allowed}.';
$string['invalidh5ppost'] = 'No se pudo publicar el H5P.';
$string['invalidimageformat'] = 'Formato de archivo de imagen no válido. Utilice jpg, png o gif.';
$string['invalidlanguagefile'] = 'Archivo de idioma no válido {$a->%file} en la biblioteca {$a->%library}';
$string['invalidlanguagefile2'] = 'Archivo de idioma no válido {$a->%languageFile} ha sido incluido en la biblioteca {$a->%name}';
$string['invalidlibrary'] = 'Biblioteca no válida';
$string['invalidlibrarydata'] = 'Datos no válidos proporcionados por {$a->%property} en {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Datos no válidos proporcionados por {$a->%property} en {$a->%library}. Se esperaba un booleano.';
$string['invalidlibraryname'] = 'Nombre de biblioteca no válido: {$a->%name}';
$string['invalidlibrarynamed'] = 'La biblioteca H5P {$a->%library} usada en el contenido no es válida';
$string['invalidlibraryoption'] = 'Opción ilegal {$a->%option} en {$a->%library}';
$string['invalidlibraryproperty'] = 'No se puede leer la propiedad {$a->%property} en {$a->%library}';
$string['invalidmainjson'] = 'Falta un archivo h5p.json principal válido';
$string['invalidmultiselectoption'] = 'Opción escogida no válida en la selección múltiple.';
$string['invalidparameters'] = 'Parámetros no válidos';
$string['invalidselectoption'] = 'Opción escogida no válida en selección.';
$string['invalidsemanticsjson'] = 'El archivo semantics.json no válido se ha incluido en la biblioteca {$a->%name}';
$string['invalidsemanticstype'] = 'Error interno de H5P: tipo de contenido desconocido "{$a->@type}" en las semánticas. ¡Eliminando el contenido!';
$string['invalidstring'] = 'La cadena dada no es válida de acuerdo con la expresión regular en las semánticas. (valor: \\"{$a->%value}\\", Expresión regular: \\"{$a->%regexp}\\")';
$string['invalidtoken'] = 'Token de seguridad no válido.';
$string['invalidvideoformat'] = 'Formato de archivo de vídeo no válido. Utilice mp4 o webm.';
$string['invalidxapiresult'] = 'No se encontraron resultados de xAPI para la combinación de contenido e identificación de usuario dada';
$string['javascriptloading'] = 'Esperando JavaScript ...';
$string['libraries'] = 'Bibliotecas H5P';
$string['librarydirectoryerror'] = 'El nombre del directorio de la biblioteca debe coincidir con machineName o machineName-majorVersion.minorVersion (de library.json). (Directorio: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['librarylistactions'] = 'Acciones';
$string['librarylistinstancedependencies'] = 'Dependencias de instancia';
$string['librarylistinstances'] = 'Instancias';
$string['librarylistlibrarydependencies'] = 'Dependencias de la biblioteca';
$string['librarylistrestricted'] = 'Restringido';
$string['librarylisttitle'] = 'Título';
$string['librarynotselected'] = 'Debe seleccionar un tipo de contenido.';
$string['license'] = 'Licencia';
$string['licenseCC010'] = 'CC0 1.0 Universal (CC0 1.0) Public Domain Dedication';
$string['licenseCC010U'] = 'CC0 1.0 Universal';
$string['licenseCC10'] = '1.0 Genérica';
$string['licenseCC20'] = '2.0 Genérica';
$string['licenseCC25'] = '2.5 Genérica';
$string['licenseCC30'] = '3.0 Unported';
$string['licenseCC40'] = '4.0 Internacional';
$string['licensee'] = 'Licenciatario';
$string['licenseextras'] = 'Extras de licencia';
$string['licenseGPL'] = 'Licencia Pública General';
$string['licenseV1'] = 'Versión 1';
$string['licenseV2'] = 'Versión 2';
$string['licenseV3'] = 'Versión 3';
$string['licenseversion'] = 'Versión de la licencia';
$string['loadingdata'] = 'Cargando datos.';
$string['lookforupdates'] = 'Buscar actualizaciones de H5P';
$string['maximumgrade'] = 'Nota máxima';
$string['maximumgradeerror'] = 'Por favor introduzca un número entero positivo válido como máxima puntuación disponible para esta actividad';
$string['maxpostsizetoosmall'] = 'Su tamaño máximo de publicación de PHP es bastante pequeño. Con su configuración actual, no puede cargar archivos con un tamaño mayor a {$a->%number} MB. Esto podría ser un problema al intentar cargar H5Ps, imágenes y videos. Por favor considere aumentarla a más de 5MB';
$string['maxscore'] = 'Máxima Puntuación';
$string['maxuploadsizetoosmall'] = 'El tamaño máximo de carga de PHP es bastante pequeño. Con su configuración actual, no puede cargar archivos con un tamaño mayor a {$a->%number} MB. Esto podría ser un problema al intentar cargar H5Ps, imágenes y videos. Por favor considere aumentarla a más de 5MB.';
$string['messageprovider:confirmation'] = 'Confirmación de tus envíos H5P';
$string['messageprovider:submission'] = 'Notificación de envíos H5P';
$string['missingcontentfolder'] = 'Falta una carpeta de contenido válida';
$string['missingcontentuserdata'] = 'Error: no se pudieron encontrar los datos del usuario';
$string['missingcoreversion'] = 'El sistema no pudo instalar el componente <em>{$a->%component}</em> del paquete, requiere una versión más reciente de la extensión H5P. Este sitio está ejecutando actualmente la versión {$a->%current}, mientras que la versión requerida es {$a->%required} o superior. Debes considerar actualizar y luego intentarlo de nuevo.';
$string['missingdependency'] = 'Falta la dependencia {$a->@dep} requerida por {$a->@lib}.';
$string['missinglibrary'] = 'Falta la biblioteca {$a->@library}';
$string['missinglibraryfile'] = 'Falta el archivo "{$a->%file}" en la biblioteca: "{$a->%name}"';
$string['missinglibraryjson'] = 'No se pudo encontrar el archivo library.json con formato json válido para la biblioteca {$a->%name}';
$string['missinglibraryproperty'] = 'Falta la propiedad {$a->%property} de {$a->%library}';
$string['missingmbstring'] = 'La extensión mbstring de PHP no está cargada. H5P necesita esto para funcionar correctamente';
$string['missingparameters'] = 'Faltan parámetros';
$string['missinguploadpermissions'] = 'Tenga en cuenta que pueden existir librerías en el paquete que usted subió, pero usted no tiene permitido subir nuevas librerías. Póngase en contacto con el administrador del sitio a este respecto.';
$string['modulename'] = 'Contenido interactivo';
$string['modulename_help'] = 'El módulo de actividad H5P le permite crear contenido interactivo, tal como Videos Interactivos, Conjuntos de Preguntas, Preguntas de Arrastrar y Soltar, Preguntas de Opción Múltiple, Presentaciones y mucho más.

Además de ser una herramienta de autoría para contenido enriquecido, H5P le permite importar y exportar archivos H5P para re-utilizar efectivamente y compartir contenido.

Las interacciones con el usuario y los puntajes son monitoreados usando xAPI y están disponibles mediante el Libro de Calificaciones de Moodle. Tenga en cuenta que es actualmente posible para personas con habilidades de programación el hacer trampa en interacciones H5P y obtener el puntaje completo sin saber las respuestas correctas. H5Ps no deben usarse  para exámenes sumativos o similares.

Usted añade contenido interactivo H5P al crear contenido usando la herramienta de autoría incluida o al subir archivos H5P encontrados en otros sitios con H5P.';
$string['modulenameplural'] = 'Contenido interactivo';
$string['nextpage'] = 'Siguiente página';
$string['noanswersubmitted'] = 'Este usuario aún no ha enviado una respuesta al H5P';
$string['nocontent'] = 'No se pudo encontrar o analizar el archivo content.json';
$string['nocontenttype'] = 'No se especificó ningún tipo de contenido.';
$string['nocopyright'] = 'No hay información de copyright disponible para este contenido.';
$string['nodata'] = 'No hay datos disponibles que coincidan con sus criterios.';
$string['noextension'] = 'El archivo que subió no es un paquete HTML5 válido (No tiene la extensión .h5p)';
$string['noh5ps'] = 'No hay contenido interactivo disponible para este curso.';
$string['nojson'] = 'El archivo principal h5p.json no es válido';
$string['nombstringexteension'] = 'La extensión PHP mbstring no está cargada. H5P necesita que funcione correctamente';
$string['noparameters'] = 'Sin parámetros';
$string['noparse'] = 'No se pudo analizar el archivo principal h5p.json';
$string['nopermissiontogettranslations'] = 'Usted no tiene permisos para recuperar traducciones';
$string['nopermissiontorestrict'] = 'No tienes permiso para restringir bibliotecas.';
$string['nopermissiontosavecontentuserdata'] = 'No tiene permiso para guardar datos de usuario.';
$string['nopermissiontosaveresult'] = 'No tiene permiso para guardar resultados de este contenido.';
$string['nopermissiontoupgrade'] = 'No tienes permiso para actualizar bibliotecas.';
$string['nopermissiontouploadcontent'] = 'No tienes permiso para subir contenido aquí.';
$string['nopermissiontouploadfiles'] = 'No tienes permiso para subir archivos aquí.';
$string['nopermissiontoviewcontenttypes'] = 'No tienes permiso para ver los tipos de contenido.';
$string['nopermissiontoviewresult'] = 'No tiene permiso para ver los resultados de este contenido.';
$string['nosuchlibrary'] = 'No hay tal biblioteca';
$string['notapplicable'] = 'NO disponible';
$string['nounzip'] = 'El archivo que cargó no es un paquete HTML5 válido (no podemos descomprimirlo)';
$string['noversionattribution'] = 'Atribución';
$string['noversionattributionnc'] = 'Atribución-NoComercial';
$string['noversionattributionncnd'] = 'Atribución-NoComercial-NoDerivadas';
$string['noversionattributionncsa'] = 'Atribución-NoComercial-CompartirIgual';
$string['noversionattributionnd'] = 'Atribución-NoDerivadas';
$string['noversionattributionsa'] = 'Atribución-CompartirIgual';
$string['nowriteaccess'] = 'Se detectó un problema con el acceso de escritura del servidor. Asegúrese de que su servidor pueda escribir en su carpeta de datos.';
$string['noziparchive'] = 'Su versión de PHP no es compatible con ZipArchive.';
$string['offlinedialogbody'] = 'No hemos podido enviarle información sobre la finalización de esta tarea. Por favor, compruebe su conexión a Internet.';
$string['offlinedialogheader'] = 'Se ha perdido la conexión con el servidor';
$string['offlinedialogretrybuttonlabel'] = 'Vuelva a intentarlo ahora';
$string['offlinedialogretrymessage'] = 'Reintentando en :num.....';
$string['offlinesuccessfulsubmit'] = 'Resultados presentados con éxito.';
$string['oldphpversion'] = 'Su versión de PHP está desactualizada. H5P requiere la versión 5.2 para funcionar correctamente. Se recomienda la versión 5.6 o posterior.';
$string['olduploadoldcontent'] = 'Usted está intentando subir contenido de una versión más antigua de H5P. Por favor actualice el contenido en el servidor de donde se originó e intente subirlo nuevamente o active el Hub H5P para que haga que este servidor lo actualice para usted automáticamente.';
$string['onlyupdate'] = 'Sólo actualizar las bibliotecas existentes';
$string['options'] = 'Opciones';
$string['originator'] = 'Autor';
$string['pd'] = 'Dominio Público';
$string['pddl'] = 'Licencia y Dedicación de Dominio Público';
$string['pdm'] = 'Marca de Dominio Público';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['postmessagerequired'] = 'Se requiere un mensaje post para acceder al endpoint';
$string['previouspage'] = 'Pagina anterior';
$string['privacy:metadata:core_files'] = 'La actividad H5P almacena archivos que se han cargado como parte del contenido de H5P.';
$string['privacy:metadata:core_grades'] = 'La actividad H5P almacena las calificaciones de los usuarios que han respondido al contenido H5P.';
$string['privacy:metadata:hvp_content_user_data'] = 'Describe el estado actual en que se encuentra el contenido para un usuario. Se utiliza para restaurar el contenido a un estado anterior.';
$string['privacy:metadata:hvp_content_user_data:data'] = 'Datos de usuario que fueron almacenados.';
$string['privacy:metadata:hvp_content_user_data:data_id'] = 'Identificador de tipo de datos.';
$string['privacy:metadata:hvp_content_user_data:delete_on_content_change'] = 'Marca que determina si los datos deben eliminarse cuando cambia el contenido.';
$string['privacy:metadata:hvp_content_user_data:hvp_id'] = 'ID del contenido H5P al que pertenecen los datos.';
$string['privacy:metadata:hvp_content_user_data:id'] = 'ID de la relación de datos de usuario de contenido.';
$string['privacy:metadata:hvp_content_user_data:preloaded'] = 'Marca que determina si los datos deben precargarse en el contenido.';
$string['privacy:metadata:hvp_content_user_data:sub_content_id'] = 'Subcontenido de H5P, 0 si esto no es subcontenido.';
$string['privacy:metadata:hvp_content_user_data:user_id'] = 'ID del usuario al que pertenecen los datos.';
$string['privacy:metadata:hvp_events'] = 'Realiza un seguimiento de los eventos H5P registrados.';
$string['privacy:metadata:hvp_events:content_id'] = 'ID de contenido en el que se realizó la acción, 0 si es nuevo o no tiene contenido.';
$string['privacy:metadata:hvp_events:content_title'] = 'Título del contenido.';
$string['privacy:metadata:hvp_events:created_at'] = 'Hora en que se creó el evento.';
$string['privacy:metadata:hvp_events:id'] = 'ID único del evento.';
$string['privacy:metadata:hvp_events:library_name'] = 'Biblioteca a la que afectó el evento.';
$string['privacy:metadata:hvp_events:library_version'] = 'Versión de la biblioteca a la que afectó el evento.';
$string['privacy:metadata:hvp_events:sub_type'] = 'Subtipo de evento, o acción del evento.';
$string['privacy:metadata:hvp_events:type'] = 'Tipo de evento.';
$string['privacy:metadata:hvp_events:user_id'] = 'ID del usuario que realizó la acción.';
$string['privacy:metadata:hvp_xapi_results'] = 'Almacena eventos xAPI en contenido H5P.';
$string['privacy:metadata:hvp_xapi_results:additionals'] = 'Información adicional que el H5P puede enviar.';
$string['privacy:metadata:hvp_xapi_results:content_id'] = 'ID del contenido en el que se realizó el evento.';
$string['privacy:metadata:hvp_xapi_results:correct_responses_pattern'] = 'Patrón de respuesta correcto.';
$string['privacy:metadata:hvp_xapi_results:description'] = 'Descripción, tarea o pregunta del contenido sobre el que se realizó la acción.';
$string['privacy:metadata:hvp_xapi_results:id'] = 'ID único del evento xAPI.';
$string['privacy:metadata:hvp_xapi_results:interaction_type'] = 'Tipo de interacción.';
$string['privacy:metadata:hvp_xapi_results:max_score'] = 'Puntuación máxima que se puede obtener en el evento.';
$string['privacy:metadata:hvp_xapi_results:parent_id'] = 'ID del padre del contenido en el que se realizó este evento. Nulo si no tiene padre.';
$string['privacy:metadata:hvp_xapi_results:raw_score'] = 'Puntuación alcanzada para el evento.';
$string['privacy:metadata:hvp_xapi_results:response'] = 'Respuesta que el usuario envió.';
$string['privacy:metadata:hvp_xapi_results:user_id'] = 'ID del usuario que realizó la acción.';
$string['question'] = 'Pregunta';
$string['removeoldlogentries'] = 'Eliminar entradas de registro H5P antiguas';
$string['removeoldmobileauthentries'] = 'Quitar las entradas antiguas de autenticación móvil H5P';
$string['removetmpfiles'] = 'Eliminar archivos temporales H5P viejos';
$string['reportingquestionsremaininglabel'] = 'preguntas restantes para calificar';
$string['reportingscaledscoredelimiter'] = ',';
$string['reportingscaledscorelabel'] = 'Puntuación del libro de calificaciones:';
$string['reportingscoredelimiter'] = 'de';
$string['reportingscorelabel'] = 'Puntuación:';
$string['reportnotsupported'] = 'No soportado';
$string['reportsubmitgradelabel'] = 'Enviar calificación';
$string['resizescript'] = 'Incluya este script en su sitio web si desea un dimensionamiento dinámico del contenido incrustado:';
$string['resubmitscores'] = 'Intentar enviar los resultados almacenados.';
$string['reuse'] = 'Reutilizar';
$string['reusecontent'] = 'Reutilizar contenido';
$string['reusedescription'] = 'Reutilice este contenido.';
$string['reveal'] = 'Revelar';
$string['reviseserversetupandretry'] = 'Cuando haya revisado la configuración de su servidor, puede volver a habilitar la comunicación del hub H5P en la Configuración H5P.';
$string['score'] = 'Puntuación';
$string['search'] = 'Buscar';
$string['sendusagestatistics'] = 'Contribuir con las estadísticas de uso';
$string['sendusagestatistics_help'] = 'Los números de estadísticas de uso se comunicarán automáticamente para ayudar a los desarrolladores a comprender mejor cómo se usa H5P y para determinar las áreas potenciales de mejora. Lea más sobre qué datos de <a {$a}> se recopilan en h5p.org </a>.';
$string['settings'] = 'Configuración de H5P';
$string['showadvanced'] = 'Mostrar avanzado';
$string['showless'] = 'Mostrar menos';
$string['showmore'] = 'Mostrar más';
$string['sitecouldnotberegistered'] = 'El sitio no se pudo registrar con el hub. Por favor, póngase en contacto con el administrador de su sitio.';
$string['sitekey'] = 'Clave del sitio';
$string['sitekeydescription'] = 'La clave del sitio es una clave secreta que identifica de forma exclusiva este sitio con el Hub.';
$string['sitekeyregistered'] = 'Se le ha proporcionado una clave única que lo identifica con el hub cuando recibe nuevas actualizaciones. La clave está disponible para verla en la página "Configuración de H5P".';
$string['size'] = 'Tamaño';
$string['source'] = 'Fuente';
$string['sslnotenabled'] = 'Su servidor no tiene SSL habilitado. SSL debe estar habilitado para garantizar una conexión segura con el hub H5P.';
$string['startingover'] = 'Vas a empezar de nuevo.';
$string['sublevel'] = 'Subnivel';
$string['successfullyregisteredwithhub'] = 'Su sitio fue registrado exitosamente con el Hub H5P.';
$string['thumbnail'] = 'Miniatura';
$string['title'] = 'Título';
$string['unabletocreatedir'] = 'No se puede crear directorio.';
$string['unabletogetfieldtype'] = 'No se puede obtener el tipo de campo.';
$string['undisclosed'] = 'No revelado';
$string['unpackedfilesexceedsmaxsize'] = 'El tamaño total de los archivos descomprimidos excede el tamaño máximo permitido. (%used > %max)';
$string['updatedlibraries'] = 'Bibliotecas H5P {$a->%old} actualizadas.';
$string['updatedlibrary'] = 'Bibliotecas H5P {$a->%old} actualizadas.';
$string['updatelibraries'] = 'Actualizar todas las bibliotecas';
$string['upgrade'] = 'Actualizar H5P';
$string['upgradebuttonlabel'] = 'Actualizar';
$string['upgradedone'] = 'Ha actualizado con éxito {$a} instancia(s) de contenido.';
$string['upgradeerror'] = 'Ocurrió un error al procesar los parámetros:';
$string['upgradeerrorcontent'] = 'No se pudo actualizar el contenido %id:';
$string['upgradeerrordata'] = 'No se pudieron cargar los datos para la biblioteca %lib.';
$string['upgradeerrormissinglibrary'] = 'Falta la biblioteca %lib.';
$string['upgradeerrornotsupported'] = 'Los parámetros contienen %used que no es compatible.';
$string['upgradeerrorparamsbroken'] = 'Los parámetros están rotos.';
$string['upgradeerrorscript'] = 'No se pudo cargar el script de actualizaciones para %lib.';
$string['upgradeerrortoohighversion'] = 'Los parámetros contienen %used mientras que solo soporta %supported o anterior.';
$string['upgradeheading'] = 'Actualizar el contenido de {$a}';
$string['upgradeinprogress'] = 'Actualizando a %ver ...';
$string['upgradeinvalidtoken'] = 'Error: ¡Token de seguridad no válido!';
$string['upgradelibrarycontent'] = 'Actualizar el contenido de la biblioteca';
$string['upgradelibrarymissing'] = 'Error: ¡Falta tu biblioteca!';
$string['upgrademessage'] = 'Está a punto de actualizar {$a} instancia(s) de contenido. Por favor seleccione la versión de actualización.';
$string['upgradenoavailableupgrades'] = 'No hay actualizaciones disponibles para esta biblioteca.';
$string['upgradenothingtodo'] = 'No hay instancias de contenido para actualizar.';
$string['upgradereturn'] = 'Regresar';
$string['upload'] = 'Subir';
$string['uploadlibraries'] = 'Subir bibliotecas';
$string['uploadsizelargerthanpostsize'] = 'El tamaño máximo de carga de PHP es mayor que el tamaño máximo de publicación. Se sabe que esto causa problemas en algunas instalaciones.';
$string['user'] = 'Usuario';
$string['validatingh5pfailed'] = 'La validación del paquete H5P falló.';
$string['validationfailed'] = 'El H5P solicitado no era válido.';
$string['viewreportlabel'] = 'Informe';
$string['welcomecommunity'] = 'Esperamos que disfrute de H5P y se involucre en nuestra creciente comunidad a través de nuestros <a {$a->forums}> foros </a>.';
$string['welcomecontactus'] = 'Si tiene algún comentario, no dude en <a {$a}> contactarnos </a>. ¡Nos tomamos muy en serio los comentarios y nos dedicamos a mejorar H5P cada día!';
$string['welcomegettingstarted'] = 'Para empezar con H5P y Moodle échale un vistazo a nuestro <a {$a->moodle_tutorial}>tutorial</a> y revisa el <a {$a->example_content}>contenido de ejemplo</a> en H5P.org para que te sirva de guía.<br>¡Para su comodidad ya se han instalado los contenidos más populares!';
$string['welcomeheader'] = '¡Bienvenido al mundo de H5P!';
$string['wrongversion'] = 'La versión de la biblioteca H5P {$a->%machineName} utilizada en este contenido no es válida. El contenido contiene {$a->%contentLibrary}, pero debe ser {$a->%semanticsLibrary}.';
$string['year'] = 'Año';
$string['years'] = 'Año(s)';
$string['yearsfrom'] = 'Años (desde)';
$string['yearsto'] = 'Años (hasta)';
