<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_recordrtc', language 'pt', branch 'MOODLE_37_STABLE'
 *
 * @package   qtype_recordrtc
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['audio'] = 'Áudio';
$string['audiobitrate'] = 'Bitrate do áudio';
$string['audiobitrate_desc'] = 'Qualidade da gravação do áudio - Taxa de bits (maior número significa maior qualidade)';
$string['err_closesquarebrackets'] = 'Falta(m) parêntese(s) reto(s) de fecho. {$a->format}';
$string['err_opensquarebrackets'] = 'Falta(m) parêntese(s) reto(s) de abertura. {$a->format}';
$string['err_placeholderformat'] = 'O formato do espaço reservado é [[title:audio]], onde title é uma string (que pode conter letras, hífens e underscore).';
$string['err_placeholderincorrectformat'] = 'O espaço reservado para a multimédia não está no formato correto. {$a->format}';
$string['err_placeholdermediatype'] = '"{$a->text}" não é um tipo de multimédia válido. Para o tipo de multimédia, use a string "audio". {$a->format}';
$string['err_placeholdertitle'] = '"{$a->text}" não é um título válido. Para o título, use uma string adequada. {$a->format}';
$string['err_placeholdertitlecase'] = '"{$a->text}" não é um título válido. Os títulos apenas podem conter letras minúsculas. {$a->format}';
$string['err_placeholdertitleduplicate'] = '"{$a->text}" foi usado mais do que uma vez. Cada título deve ser diferente.';
$string['err_placeholdertitlelength'] = '"{$a->text}" excede o tamanho máximo de {$a->maxlength} para um título. {$a->format}';
$string['err_timelimit'] = 'A duração máxima de gravação não pode ser superior a {$a}.';
$string['err_timelimitpositive'] = 'A duração máxima de gravação tem de ser superior a 0.';
$string['filex'] = 'Ficheiro {$a}';
$string['gumabort'] = 'Aconteceu algo estranho que impediu o uso da webcam/microfone';
$string['gumabort_title'] = 'Algo aconteceu';
$string['gumnotallowed'] = 'O utilizador deve permitir que o navegador aceda à webcam/microfone';
$string['gumnotallowed_title'] = 'Permissões incorretas';
$string['gumnotfound'] = 'Não existe dispositivo de entrada ligado ou ativado';
$string['gumnotfound_title'] = 'Dispositivo em falta';
$string['gumnotreadable'] = 'Algo está a impedir o navegador de aceder à webcam/microfone';
$string['gumnotreadable_title'] = 'Erro de hardware';
$string['gumnotsupported'] = 'O seu navegador não suporta gravação numa ligação insegura e deve fechar o módulo';
$string['gumnotsupported_title'] = 'Não existe suporte para ligação insegura';
$string['gumoverconstrained'] = 'A webcam/microfone atual não pode produzir um fluxo com as restrições necessárias';
$string['gumoverconstrained_title'] = 'Problema com restrições';
$string['gumsecurity'] = 'O seu navegador não suporta gravação numa ligação insegura e deve fechar o módulo';
$string['gumsecurity_title'] = 'Não existe suporte para ligação insegura';
$string['gumtype'] = 'Tentou obter fluxo da webcam/microfone, mas nenhuma restrição foi especificada';
$string['gumtype_title'] = 'Nenhuma restrição especificada';
$string['insecurewarning'] = 'O seu navegador não permitirá que este módulo funcione, a menos que seja usado via HTTPS.';
$string['insecurewarningtitle'] = 'Ligação insegura';
$string['mediatype'] = 'Tipo de multimédia';
$string['mediatype_dec'] = 'Atualmente, apenas funciona com áudio. O vídeo será adicionado em breve.';
$string['mediatype_help'] = 'O aluno está a ser solicitado para gravar um áudio ou um vídeo.';
$string['nearingmaxsize'] = 'Atingiu o limite máximo de tamanho para carregamento de ficheiros';
$string['nearingmaxsize_title'] = 'Gravação parada';
$string['norecording'] = 'Nenhuma gravação';
$string['nowebrtc'] = 'O seu navegador ainda não oferece suporte ou é um suporte limitado às tecnologias WebRTC e, por isso, não pode ser usado com este tipo de pergunta. Mude ou atualize o seu navegador.';
$string['nowebrtctitle'] = 'WebRTC não suportado';
$string['pleaserecordsomethingineachpart'] = 'Grave uma resposta para cada parte da pergunta.';
$string['pluginname'] = 'Gravar áudio';
$string['pluginnameadding'] = 'A adicionar uma pergunta de gravação de áudio';
$string['pluginnameediting'] = 'A editar uma pergunta de gravação de áudio';
$string['pluginname_help'] = 'Os alunos respondem gravando um áudio diretamente no navegador web, que pode ser avaliado manualmente.';
$string['pluginnamesummary'] = 'Os alunos respondem gravando um áudio diretamente no navegador web, que pode ser avaliado manualmente.';
$string['privacy:metadata'] = 'O módulo Tipo de pergunta de gravação de áudio não armazena quaisquer dados pessoais.';
$string['recordagain'] = 'Gravar de novo';
$string['recordingfailed'] = 'Ocorreu um erro ao gravar. Tente novamente.';
$string['startrecording'] = 'Iniciar gravação';
$string['stoprecording'] = 'Parar gravação';
$string['timelimit'] = 'Duração máxima de gravação';
$string['timelimit_desc'] = 'Duração máxima que o autor de uma pergunta pode definir para a gravação.';
$string['timelimit_help'] = 'Duração máxima de uma gravação que o aluno pode fazer. Quando a duração atingir este valor, a gravação será interrompida automaticamente. Existe um limite máximo para o valor que pode ser definido aqui. Se necessitar de mais tempo, contacte um administrador.';
$string['uploadaborted'] = 'Cancelado';
$string['uploadcomplete'] = 'Gravação guardada';
$string['uploadfailed'] = 'Ocorreu um erro ao guardar a gravação.';
$string['uploadfailed404'] = 'Ocorreu um erro ao guardar a gravação: provavelmente o ficheiro é muito grande';
$string['uploadpreparing'] = 'A preparar para guardar...';
$string['uploadprogress'] = 'A guardar gravação ({$a})...';
$string['video'] = 'Vídeo';
$string['videobitrate'] = 'Bitrate do vídeo';
$string['videobitrate_desc'] = 'Qualidade da gravação do vídeo - Taxa de bits (maior número significa maior qualidade)';
