<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'format_tiles', language 'pt', branch 'MOODLE_37_STABLE'
 *
 * @package   format_tiles
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addsections'] = 'Adicionar mosaicos';
$string['admintools'] = 'Ferramentas de administração';
$string['all'] = 'Tudo';
$string['allcomplete'] = 'Tudo concluído';
$string['allcoursescomplypalette'] = 'Todas as disciplinas permitem mosaicos coloridos. Não foi efetuada qualquer reposição. Certifique-se de guardar as alterações das cores permitidas antes de efetuar a reposição.';
$string['allowlabelconversion'] = 'Conversão de separadores em páginas';
$string['allowlabelconversion_desc'] = 'Se ativar esta opção, os professores editores terão a opção de converter o separador numa página, nas configurações de edição de cada separador. Esta funcionalidade ainda está em fase experimental.';
$string['allowphototiles'] = 'Permitir mosaicos com imagens';
$string['allowphototiles_desc'] = 'Se ativar esta opção, os professores poderão carregar uma imagem para servir de fundo do mosaico. Poderão continuar a usar ícones na mesma disciplina. Se desativada, apenas os ícones de mosaicos serão permitidos e as configurações das imagens dos mosaicos que estão abaixo serão ignoradas.';
$string['allowsubtilesview'] = 'Permitir vista de sub-mosaicos';
$string['allowsubtilesview_desc'] = 'Permitir o uso de uma configuração da disciplina que, se selecionada, permite mostrar dentro de cada mosaico as atividades (exceto separadores) como sub-mosaicos, em vez da lista de atividades/recursos';
$string['alternativelink'] = 'hiperligação alternativa';
$string['asfraction'] = 'Mostrar como fração';
$string['aspectratiotootallorwide'] = 'A imagem enviada foi guardada, mas verifique, uma vez que pode ser <strong>{$a->tallorwide}</strong>. Se não lhe parecer correto, recorte-a para dimensões de paisagem e carregue-a novamente. Por exemplo, 200 largura x 300 altura é suficiente.';
$string['aspercentagedial'] = 'Mostrar como % num círculo';
$string['assumedatastoreconsent'] = 'Assumir consentimento para o armazenamento local do navegador';
$string['assumedatastoreconsent_desc'] = 'Se ativar esta opção, a caixa de diálogo a solicitar consentimento para armazenar os dados no armazenamento local do navegador <b>não</b> será mostrada ao utilizador';
$string['basecolour'] = 'Cor dos mosaicos';
$string['basecolour_help'] = 'A cor que será aplicada a todos os mosaicos desta disciplina';
$string['blockedpopup'] = 'O seu navegador bloqueou uma janela pop-up. Por favor, permita janelas pop-up neste site ou clique na hiperligação abaixo para visitar o site nesta janela';
$string['blockedpopuptitle'] = 'Janela pop-up bloqueada';
$string['brandcolour'] = 'Cor';
$string['browserstorage'] = 'Armazenamento do navegador';
$string['changedcolour'] = 'A cor do mosaico foi redefinida para a predefinição da disciplina {$a}';
$string['clickiffailstoload'] = 'Clique se a página não carregar';
$string['close'] = 'Fechar';
$string['collapse'] = 'Colapsar secção';
$string['collapsesections'] = 'Colapsar tudo';
$string['colourblue'] = 'Azul';
$string['colourdarkgreen'] = 'Verde escuro';
$string['colourgreen'] = 'Verde';
$string['colourlightblue'] = 'Azul claro';
$string['colourname_descr'] = 'Exibe o nome da cor (o nome geralmente não é visível pelos utilizadores - veem uma amostra colorida)';
$string['colournamegeneral'] = 'Exibir nome da cor acima';
$string['colourpurple'] = 'Roxo';
$string['colourred'] = 'Vermelho';
$string['colours'] = 'Cores';
$string['complete'] = 'concluído';
$string['complete-n-auto'] = 'Item não concluído. Será marcado como concluído quando forem verificados os critérios de conclusão. Não pode ser alterado manualmente.';
$string['complete-y-auto'] = 'Item concluído. Foi marcado como concluído porque estão verificados os critérios de conclusão. Não pode ser alterado manualmente.';
$string['completion_help'] = 'Um visto à direita de uma atividade pode ser usado para indicar quando a atividade está concluída (caso contrário, será mostrado um círculo vazio).
Dependendo da configuração, o visto pode aparecer automaticamente quando concluir a atividade de acordo com as condições estabelecidas pelo professor.<br><br>
Noutros casos, pode clicar no círculo vazio quando achar que concluiu a atividade e o símbolo mudará para uma marca verde sólida. (Se clicar novamente, remove o visto.)';
$string['completionswitchhelp'] = '<p>Selecionou a \'Verificação da conclusão\' em cada mosaico. Por isso, foi alterado a \'Verificação da conclusão > Ativar verificação da conclusão\' para "Sim" (ver mais abaixo nesta página).</p>
<p>Além disso, é necessário ativar a verificação da conclusão para <b>cada item</b> que está a ser verificado. Por exemplo, para um PDF, clique em \'Editar configurações\', procure \'Conclusão da atividade\' e escolha a configuração desejada.</p>
<p>Também pode alterar em <b>massa</b>, conforme explicado na <a href="https://docs.moodle.org/35/en/Activity_completion_settings" target="_blank">explicação detalhada de verificação de conclusão em moodle.org</a></p>';
$string['completionwarning'] = 'A \'Verificação da conclusão\' está ativada ao nível da disciplina, mas ao nível da atividade individual, nenhum item tem a \'Verificação da conclusão\' ativada, por isso não há nada para verificar.';
$string['completionwarning_changeinbulk'] = 'Alteração em massa';
$string['completionwarning_help'] = 'É necessário ativar a \'Verificação da conclusão\' nos itens individuais editando-os (em Conclusão da atividade > Verificação da conclusão) ou pode alterar em massa em Administração da disciplina >  Conclusão da disciplina > Editar em massa a conclusão de atividades';
$string['contact'] = 'Contactar';
$string['contactdeveloper'] = 'Contacto';
$string['contents'] = 'Conteúdo';
$string['converttopage'] = 'Converter para página';
$string['converttopage_confirm'] = 'Tem a certeza? Não é possível anular (terá que criar novamente o separador manualmente, se necessário).';
$string['courseshowtileprogress'] = 'Progresso em cada mosaico';
$string['courseshowtileprogress_error'] = 'A \'Verificação da conclusão > Ativar verificação da conclusão\' está definida como "Não" (ver mais abaixo nesta página), e por isso, está em conflito com esta configuração. Se pretende mostrar o progresso nos mosaicos, defina como "Sim" a \'Verificação da conclusão > Ativar verificação da conclusão\'. Caso contrário, defina esta configuração como \'Não\'.';
$string['courseshowtileprogress_help'] = '<p>Quando selecionado, o progresso do utilizador nas atividades será mostrado em cada mosaico, como uma <em>fração</em> (por exemplo, \'Progresso 2/10\', significa que 2 de 10 atividades estão concluídas) ou como uma <em>percentagem</em> num círculo.</p><p>Só pode ser usado se a nas configurações abaixo, a opção \'Verificação da conclusão > Ativar verificação da conclusão\' estiver definida como "Sim".</p><p>Se não houver atividades a verificar a conclusão dentro de um determinado mosaico, o indicador não será exibido nesse mosaico.</p>';
$string['courseusebarforheadings'] = 'Enfatizar cabeçalhos com separador colorido';
$string['courseusebarforheadings_help'] = 'Mostra um separador colorido à esquerda do cabeçalho da disciplina sempre que um estilo de cabeçalho for selecionado no editor de texto';
$string['courseusesubtiles'] = 'Mostrar atividades como sub-mosaicos';
$string['courseusesubtiles_help'] = 'Em cada mosaico, as atividades são mostradas como sub-mosaicos, em vez de uma lista de atividades/recursos ao longo da página. Não se aplica aos separadores que não serão mostrados como sub-mosaicos, por isso, podem ser usados como títulos entre mosaicos.';
$string['currentsection'] = 'Este mosaico';
$string['customcss'] = 'CSS personalizado';
$string['customcssdesc'] = 'CSS a aplicar à secção de conteúdo da disciplina enquanto é usado este formato da disciplina. O código não será validado, por isso, tenha atenção para inserir código válido. Por exemplo: <p>.section { color: red; }</p><p>li.activity.subtile.resource.pdf { background-color: orange !important; }</p>';
$string['datapref'] = 'Preferência dos dados';
$string['datapreferror'] = 'A funcionalidade de preferência dos dados só estará disponível se o JavaScript estiver ativo no seu navegador. Caso contrário, o armazenamento de dados não poderá ser ativado.';
$string['dataprefquestion'] = '<p>Para tornar a navegação mais fácil e mais rápida, são armazenadas informações funcionais no seu navegador, como por exemplo, o conteúdo do último mosaico que abriu. Esta informação permanecerá na sua máquina por um curto período de tempo, caso visite a página novamente. Não será usada para rastreio. Pretende dar consentimento?</p><p>Lembraremos a sua escolha até limpar o histórico de navegação do seu navegador. Selecionar \'Não\' pode resultar num carregamento mais lento das páginas.</p>';
$string['defaultthiscourse'] = 'Predefinido';
$string['defaulttilecolour'] = 'Cor predefinida do mosaico';
$string['defaulttileicon'] = 'Ícone do mosaico';
$string['defaulttileicon_help'] = 'O ícone que selecionar será usado em <em>todos</em> os mosaicos desta disciplina. Cada mosaico pode ter um ícone diferente, caso seja selecionado na configuração ao nível do mosaico.';
$string['deleteimage'] = 'Apagar imagem';
$string['deletesection'] = 'Apagar mosaico';
$string['developedby'] = '"Mosaicos" desenvolvido por {$a}';
$string['developer'] = 'Programador';
$string['disabledbyadmin'] = 'Desativado pelo administrador do site';
$string['displayfilterbar'] = 'Barra de filtro';
$string['displayfilterbar_error'] = 'A menos que já tenha configurado os resultados da aprendizagem para esta disciplina, só é possível mostrar a barra de filtro com base no número de mosaicos e não com base nos resultados. Crie alguns resultados e depois volte a configurar. Veja';
$string['displayfilterbar_help'] = '<p>Quando selecionado, será mostrada automaticamente uma matriz de botões acima dos mosaicos da disciplina, na qual os utilizadores podem clicar para filtrar mosaicos para determinados intervalos</p><p>Quando for selecionado \'Com base no número de mosaicos\', será mostrada uma série de botões, por exemplo, um botão para os mosaicos 1-4, um botão para os mosaicos 5-8, etc.</p><p>Quando for selecionado \'Com base nos resultados da disciplina\', haverá um botão para cada resultado da aprendizagem da disciplina. A cada mosaico pode ser atribuído um determinado resultado (e, portanto, um determinado botão) na página de configuração do mosaico.</p>';
$string['displaytitle_mod_doc'] = 'Documento Word';
$string['displaytitle_mod_html'] = 'Página Web';
$string['displaytitle_mod_jpeg'] = 'Imagem';
$string['displaytitle_mod_mp3'] = 'Áudio';
$string['displaytitle_mod_mp4'] = 'Vídeo';
$string['displaytitle_mod_pdf'] = 'PDF';
$string['displaytitle_mod_ppt'] = 'Apresentação Powerpoint';
$string['displaytitle_mod_txt'] = 'Texto';
$string['displaytitle_mod_xls'] = 'Folha de cálculo';
$string['displaytitle_mod_zip'] = 'ZIP';
$string['documentation'] = 'Documentação';
$string['documentationurl'] = 'URL da documentação';
$string['documentationurl_descr'] = 'URL da documentação acerca do formato Mosaicos.';
$string['download'] = 'Descarregar';
$string['editsectionname'] = 'Editar nome do mosaico';
$string['embeddedurlerror'] = 'Se o site externo se recusar a ligar na janela acima, use isto:';
$string['entersection'] = 'Entrar na secção';
$string['existingimage'] = 'Imagem deste mosaico';
$string['expand'] = 'Expandir secção';
$string['expandall'] = 'Expandir tudo';
$string['expandsections'] = 'Mostrar tudo (atividades e recursos de todas as secções)';
$string['experimentalsetting'] = '(configuração experimental)';
$string['fileaddedtobottom'] = 'Ficheiro adicionado ao final da secção';
$string['filenoshowtext'] = 'Se o ficheiro não aparecer aqui, use os botões à direita para descarregar ou visualizar numa nova janela';
$string['filterboth'] = 'Mostrar botões com base no número de mosaicos e nos resultados da disciplina';
$string['filternumbers'] = 'Mostrar botões com base no número de mosaicos';
$string['filteroutcomes'] = 'Mostrar botões com base nos resultados da disciplina';
$string['filteroutcomesrestore'] = 'A disciplina original usou os resultados na barra de filtros, que ainda não são suportados durante o processo de restauro. Por isso, a configuração da barra de filtro foi alterada na disciplina restaurada. Se pretende usar os resultados para filtrar mosaicos na disciplina restaurada, configure novamente os resultados da aprendizagem. A disciplina original não foi alterada.';
$string['fittilestowidth'] = 'Ajustar mosaicos à largura do ecrã';
$string['fittilestowidth_desc'] = 'Se ativar esta opção, quando um utilizador acede a uma disciplina através de um dispositivo não móvel, o carregamento dos mosaicos é atrasado em meio segundo, enquanto é calculada a melhor estrutura. Por exemplo, evitar um mosaico por linha, mosaicos centrados no ecrã. Isto só acontecerá no primeiro acesso à disciplina numa determinada sessão e será lembrado durante toda a sessão ou até que o utilizador ajuste o tamanho do ecrã.';
$string['folderdisplayerror'] = 'As pastas configuradas para mostrar o conteúdo online não são compatíveis com o formato de sub-mosaicos. Por isso, a <a href="{$a}">pasta</a> foi alterada para permitir a exibição numa página separada';
$string['followthemecolour'] = 'Forçar o uso da cor do tema';
$string['followthemecolour_desc'] = 'Se ativar esta opção, os professores não poderão escolher as cores, através deste módulo, e todas as cores dos mosaicos configuradas abaixo serão ignoradas. Em vez disso, será feita uma tentativa de obter a cor principal personalizada do tema e usá-la.';
$string['guidance'] = 'Instruções';
$string['height'] = 'altura';
$string['hidden'] = 'Oculto';
$string['hide'] = 'Ocultar';
$string['hidefromothers'] = 'Ocultar mosaico';
$string['highlightoff'] = 'Retirar destaque';
$string['home'] = 'Página inicial da disciplina';
$string['hovercolour'] = 'Cor do mosaico ao passar o rato';
$string['hovercolour_descr'] = 'Cor dos mosaicos ao passar o rato por cima';
$string['icontitle-address-book-o'] = 'Lista de contactos';
$string['icontitle-assessment_graded'] = 'Avaliação A+';
$string['icontitle-assessment_timer'] = 'Temporizador da avaliação';
$string['icontitle-asterisk'] = 'Asterisco';
$string['icontitle-award-solid'] = 'Condecoração';
$string['icontitle-balance-scale'] = 'Balança em equilíbrio';
$string['icontitle-bar-chart'] = 'Gráfico de Barras';
$string['icontitle-bell-o'] = 'Sino';
$string['icontitle-binoculars'] = 'Binóculos';
$string['icontitle-bitcoin'] = 'Bitcoin';
$string['icontitle-book'] = 'Livro';
$string['icontitle-bookmark-o'] = 'Marcador';
$string['icontitle-briefcase'] = 'Pasta de documentos';
$string['icontitle-building'] = 'Edifício';
$string['icontitle-bullhorn'] = 'Megafone';
$string['icontitle-bullseye'] = 'Alvo';
$string['icontitle-calculator'] = 'Calculadora';
$string['icontitle-calendar'] = 'Calendário';
$string['icontitle-calendar-check-o'] = 'Marcações no calendário';
$string['icontitle-check'] = 'Verificado';
$string['icontitle-child'] = 'Criança';
$string['icontitle-clock-o'] = 'Relógio';
$string['icontitle-clone'] = 'Clone';
$string['icontitle-cloud-download'] = 'Nuvem (descarregar)';
$string['icontitle-cloud-upload'] = 'Nuvem (carregar)';
$string['icontitle-comment-o'] = 'Comentário';
$string['icontitle-comments-o'] = 'Comentários';
$string['icontitle-compass'] = 'Bússola';
$string['icontitle-diamond'] = 'Diamante';
$string['icontitle-dollar'] = 'Dólar';
$string['icontitle-euro'] = 'Euro';
$string['icontitle-exclamation-triangle'] = 'Triângulo com exclamação';
$string['icontitle-feed'] = 'Feed';
$string['icontitle-file-text-o'] = 'Ficheiro de texto';
$string['icontitle-film'] = 'Filme';
$string['icontitle-flag-checkered'] = 'Bandeira (quadriculada)';
$string['icontitle-flag-o'] = 'Bandeira';
$string['icontitle-flash'] = 'Flash';
$string['icontitle-flask'] = 'Balão de vidro';
$string['icontitle-flipchart'] = 'Tela de apresentação';
$string['icontitle-frown-o'] = 'Triste';
$string['icontitle-gavel'] = 'Martelo do juiz';
$string['icontitle-gbp'] = 'Libra esterlina';
$string['icontitle-globe'] = 'Globo';
$string['icontitle-handshake-o'] = 'Aperto de mãos';
$string['icontitle-headphones'] = 'Auscultadores';
$string['icontitle-heartbeat'] = 'Batimento cardiaco';
$string['icontitle-history'] = 'Histórico';
$string['icontitle-home'] = 'Casa';
$string['icontitle-id-card-o'] = 'Cartão de identificação';
$string['icontitle-info'] = 'Informação';
$string['icontitle-jigsaw'] = 'Puzzle';
$string['icontitle-key'] = 'Chave';
$string['icontitle-laptop'] = 'Computador portátil';
$string['icontitle-life-buoy'] = 'Boia salva-vida';
$string['icontitle-lightbulb-o'] = 'Lâmpada';
$string['icontitle-line-chart'] = 'Gráfico de linha';
$string['icontitle-list'] = 'Lista (pontos)';
$string['icontitle-list-ol'] = 'Lista (números)';
$string['icontitle-location-arrow'] = 'Seta de localização';
$string['icontitle-map-marker'] = 'Marcador de mapa';
$string['icontitle-map-o'] = 'Mapa';
$string['icontitle-map-signs'] = 'Placas de direção';
$string['icontitle-microphone'] = 'Microfone';
$string['icontitle-mobile-phone'] = 'Telemóvel';
$string['icontitle-mortar-board'] = 'Cartola de finalista';
$string['icontitle-music'] = 'Música';
$string['icontitle-newspaper-o'] = 'Jornal';
$string['icontitle-number_1'] = 'Número 1';
$string['icontitle-number_10'] = 'Número 10';
$string['icontitle-number_2'] = 'Número 2';
$string['icontitle-number_3'] = 'Número 3';
$string['icontitle-number_4'] = 'Número 4';
$string['icontitle-number_5'] = 'Número 5';
$string['icontitle-number_6'] = 'Número 6';
$string['icontitle-number_7'] = 'Número 7';
$string['icontitle-number_8'] = 'Número 8';
$string['icontitle-number_9'] = 'Número 9';
$string['icontitle-pencil-square-o'] = 'Lápis num quadro';
$string['icontitle-person'] = 'Pessoa';
$string['icontitle-pie-chart'] = 'Gráfico circular';
$string['icontitle-podcast'] = 'Podcast';
$string['icontitle-puzzle-piece'] = 'Peça de puzzle';
$string['icontitle-question-circle'] = 'Interrogação em círculo';
$string['icontitle-random'] = 'Aleatório';
$string['icontitle-refresh'] = 'Atualizar';
$string['icontitle-road'] = 'Estrada';
$string['icontitle-search'] = 'Lupa';
$string['icontitle-sliders'] = 'Controlos deslizantes';
$string['icontitle-smile-o'] = 'Sorriso';
$string['icontitle-star'] = 'Estrela (preenchida)';
$string['icontitle-star-half-o'] = 'Estrela (semi-preenchida)';
$string['icontitle-star-o'] = 'Estrela (sem sombra)';
$string['icontitle-survey'] = 'Pesquisa';
$string['icontitle-tags'] = 'Etiquetas';
$string['icontitle-tasks'] = 'Tarefas';
$string['icontitle-television'] = 'Televisão';
$string['icontitle-thinking-person'] = 'Pessoa com lâmpada';
$string['icontitle-thumbs-o-down'] = 'Polegar para baixo';
$string['icontitle-thumbs-o-up'] = 'Polegar para cima';
$string['icontitle-trophy'] = 'Troféu';
$string['icontitle-umbrella'] = 'Guarda-chuva';
$string['icontitle-university'] = 'Universidade';
$string['icontitle-user-o'] = 'Utilizador';
$string['icontitle-users'] = 'Pessoas';
$string['icontitle-volume-up'] = 'Altifalante';
$string['icontitle-wrench'] = 'Chave inglesa';
$string['imagecannotbeused'] = 'A imagem não pode ser usada';
$string['imagedeletedfrom'] = 'A imagem de "{$a}" foi apagada';
$string['imagesavedfor'] = 'Imagem guardada para o mosaico {$a}';
$string['imagesize'] = 'Tamanho da imagem';
$string['items'] = 'itens';
$string['jsactivate'] = 'Ativar navegação animada';
$string['jsdeactivate'] = 'Desativar navegação animada';
$string['jsdeactivated'] = 'Desativou a navegação animada';
$string['jsmaxstoreditems'] = 'Máximo de itens do conteúdo no armazenamento da sessão do navegador';
$string['jsmaxstoreditems_desc'] = 'Quando os utilizadores estiverem na página principal dos mosaicos, o navegador armazenará o HTML do próprio ecrã da visão global dos mosaicos e o conteúdo de cada mosaico, até ao número máximo de itens aqui selecionado. Permite uma resposta mais rápida quando clica noutro mosaico. Configurar para um valor muito alto pode fazer com que o armazenamento do navegador fique cheio (embora, até ao momento, não tenha sido um problema)';
$string['jsnavsettings'] = 'Navegação com JavaScript';
$string['jsreactivated'] = 'Ativou a navegação animada. Esta funcionalidade pode resultar numa navegação mais rápida. Requer o JavaScript ativado.';
$string['jsstoredcontentdeletemins'] = 'Conteúdo armazenado da sessão é apagado após (minutos)';
$string['jsstoredcontentdeletemins_desc'] = 'Após clicar em cada mosaico, e para manter espaço livre para o HTML atual, o navegador do utilizador executará uma limpeza e <em>apagará</em> do armazenamento da sessão todo o conteúdo mais antigo que este intervalo de tempo (baseado em que já não é atual, e que, de qualquer modo, será necessário obter uma nova cópia do servidor)';
$string['jsstoredcontentexpirysecs'] = 'Conteúdo armazenado da sessão expira após (segundos)';
$string['jsstoredcontentexpirysecs_desc'] = 'Quando um utilizador clica num mosaico, se o conteúdo do mosaico no armazenamento da sessão do navegador for mais antigo, o conteúdo é mostrado, mas será feita uma solicitação ao servidor, em segundo plano, para obter uma nova cópia para atualizar o conteúdo. Isto permite atualizações subsequentes da disciplina depois do navegador armazenar a cópia. Se o conteúdo armazenado for mais recente, será assumido que está atualizado e será mostrado, sem solicitação ao servidor';
$string['labelconverted'] = 'Separador convertido';
$string['links'] = 'Hiperligações';
$string['loading'] = 'A carregar';
$string['modalmodules'] = 'Módulos modais';
$string['modalmodules_desc'] = 'Iniciar estes módulos da disciplina numa janela modal';
$string['modalresources'] = 'Recursos modais';
$string['modalresources_desc'] = 'Abrir estes recursos numa janela modal';
$string['modalwindows'] = 'Janelas modais';
$string['newsectionname'] = 'Novo nome para o tópico {$a}';
$string['nexttopic'] = 'Tópico seguinte';
$string['noconnectionerror'] = 'Erro ao carregar o conteúdo. Verifique a sua ligação à internet';
$string['nojswarning'] = 'O seu navegador parece não suportar Javascript ou está desativado. Uma interface melhorada está disponível se ativar o Javascript';
$string['none'] = 'Nenhum';
$string['notcomplete'] = 'Não concluído';
$string['notrecommended'] = 'Não recomendado';
$string['notregistered'] = 'Este módulo Mosaicos ainda não está registado no site do programador do módulo.';
$string['novaliddefaultcolour'] = 'Nenhuma cor válida foi definida para cor predefinida do mosaico';
$string['ok'] = 'OK';
$string['other'] = 'Outros';
$string['outcomes'] = 'Resultados da aprendizagem';
$string['outcomesunavailable'] = 'Resultados da aprendizagem não disponíveis';
$string['overall'] = 'Global';
$string['overallprogress'] = 'Conclusão da atividade - progresso global';
$string['overallprogressshort'] = 'Progresso global';
$string['photoguidance_desc'] = '<p>Carregue uma imagem no formato <strong>paisagem</strong>. A largura deve ser cerca de 1,35 vezes a altura. Por exemplo, 270 de largura x 200 de altura é um bom tamanho. Não é necessário ser exato.</p>
<p>As imagens no formato retrato não coincidirão com a forma do mosaico. Imagens grandes serão escaladas e compactadas, se necessário, após o carregamento.</p>';
$string['photolibrary'] = 'Galeria de imagens';
$string['photolibrary_desc'] = 'Imagens carregadas ou usadas recentemente. Para usar uma imagem como fundo de um mosaico, clique na imagem pretendida. Para fazer o carregamento de uma nova, use o separador acima "Carregar nova imagem".';
$string['phototilesaltstyle'] = 'Estilo alternativo da imagem do mosaico';
$string['phototilesaltstyle_desc'] = 'Se não ativar esta opção (valor predefinido), os mosaicos com imagens exibirão o título na parte superior do bloco. O estilo alternativo mostra o título na parte inferior';
$string['phototilesettings'] = 'Imagem do mosaico';
$string['phototiletitletransarency'] = 'Transparência do título no mosaico com imagem';
$string['phototiletitletransarency_desc'] = 'A sobreposição do título num mosaico com imagem pode ter um fundo ligeiramente transparente (30% é o valor predefinido) ou uma cor de fundo sólida (0%)';
$string['phototitletitlelineheight'] = 'Altura da linha do título';
$string['phototitletitlepadding'] = 'Preenchimento da linha vertical do título';
$string['picknewicon'] = 'Escolher novo ícone';
$string['picknewiconphoto'] = 'Escolher novo ícone ou imagem de fundo';
$string['pluginname'] = 'Formato Mosaicos';
$string['previoustopic'] = 'Tópico anterior';
$string['privacy:metadata:preference:format_tiles_stopjsnav'] = 'Se o utilizador desativou, ou não, a navegação animada com Javascript.';
$string['privacypolicy'] = 'Politica de privacidade';
$string['progress'] = 'Progresso';
$string['reactivate'] = 'reativar';
$string['register'] = 'Registar';
$string['registeragreeprivacy'] = 'Concordo com a {$a->privacypolicylink} do programador do módulo';
$string['registerclicktocomplete'] = 'Clique em OK para concluir o processo';
$string['registeredthanks'] = 'O módulo está registado. Obrigado.';
$string['registeremailno'] = 'Não, eu não pretendo receber qualquer e-mail';
$string['registeremailyes'] = 'Sim, pretendo receber notificações ocasionais de atualizações e outras informações';
$string['registerintro1'] = 'Gostaríamos muito de ficar em contacto! Ao registar o módulo:';
$string['registerintro2'] = 'está a suportar o desenvolvimento futuro deste módulo';
$string['registerintro3'] = 'pode receber notificações de atualizações importantes e planos futuros';
$string['registerintro4'] = 'pode sugerir novas funcionalidades para o módulo.';
$string['registerintro5'] = 'Os seus dados serão mantidos em sigilo pelo programador, conforme estabelecido na política de privacidade. Obrigado pelo seu apoio!';
$string['registermissingemail'] = 'Por favor, preencha o seu endereço de e-mail (selecionou abaixo a opção "Sim" para receber e-mails)';
$string['registerpickemailpref'] = 'Por favor, selecione a sua preferência de e-mail';
$string['registerpolicyagreedlinktext'] = 'Política de privacidade e contrato de processamento de dados';
$string['registrationdeferred'] = 'Obrigado. Estamos a tentar registar o módulo (processo de registo ainda está incompleto).';
$string['reopenlastsection'] = 'Reabrir o último mosaico visitado';
$string['reopenlastsection_desc'] = 'Se ativar esta opção, se o utilizador visitar a disciplina mais tarde, será reaberta a última secção que estava aberta';
$string['resetallcoursecolours'] = 'Repor todas as cores';
$string['resetcolours'] = 'Reposição das cores';
$string['resetcolours_desc'] = 'Clique no botão acima para repor a cor dos mosaicos de todas as disciplinas que não tenham uma das cores abaixo. As disciplinas serão alteradas para a cor predefinida do mosaico definida abaixo. Pode utilizar esta ferramenta depois de ter alterado a paleta de cores abaixo, mas certifique-se de <strong>guardar as alterações</strong> das cores abaixo antes de repor. Tenha cuidado, uma vez que esta ação pode mudar a cor de muitas disciplinas!';
$string['revealcontents'] = 'Mostrar conteúdo';
$string['section0name'] = 'Geral';
$string['sectionerrorstring'] = 'A sua sessão pode ter expirado. Tente atualizar esta página.';
$string['sectionerrortitle'] = 'Erro ao carregar conteúdo';
$string['sectionname'] = 'Mosaico';
$string['sectionnumber'] = 'Secção/Número do mosaico';
$string['selected'] = 'Selecionado';
$string['setavailabletilecolours'] = 'Cores permitidas para mosaicos (todo o site)';
$string['settings'] = 'Configurações do formato dos mosaicos';
$string['show'] = 'Mostrar';
$string['showalltiles'] = 'Mostrar todos os mosaicos';
$string['showfromothers'] = 'Mostrar mosaico';
$string['showoverallprogress'] = 'Mostrar indicador do progresso global';
$string['showoverallprogress_desc'] = 'Mostrar o indicador "% do progresso global" no canto superior direito da disciplina (o valor mostrado representa o somatório da % de conclusão de cada mosaico, com base na conclusão das atividades e não na conclusão da disciplina)';
$string['showprogresssphototiles_desc'] = 'Se ativar esta opção, o progresso do aluno (por exemplo, \'Progresso 2/10\') será mostrado nos mosaicos com imagens';
$string['showseczerocoursewide'] = 'Mostrar a secção zero acima de todas as secções';
$string['showseczerocoursewide_desc'] = 'Se ativar esta opção, a secção zero (a secção de topo) será mostrada na página inicial da disciplina e no topo de <b>todas as páginas das secções da disciplina</b> (ou seja, no topo do conteúdo de cada mosaico). Se desativada (recomendado), será mostrada apenas na página inicial da disciplina';
$string['showseparatewin'] = 'Mostrar ficheiro numa janela separada';
$string['sitename'] = 'Nome do site';
$string['snapwarning'] = 'É possível editar a disciplina no formato Mosaicos usando outro tema e, em seguida, mudar para o tema Snap assim que terminar a edição.';
$string['snapwarning_help'] = 'Configurações_Tema#Permitir_temas_utilizador';
$string['subtileszeczerotoggled'] = 'Secção de topo alterna entre o formato de lista e o formato de sub-mosaicos';
$string['sureresetcolours'] = 'Tem a certeza de que pretende repor as cores do mosaico da disciplina para os valores predefinidos? Isto afetará {$a} disciplinas';
$string['tilecolourgeneral'] = 'Paleta de cores - cor';
$string['tilecolourgeneral_descr'] = 'Estas configurações definem as cores que o administrador disponibilizará aos professores para aplicarem nas disciplinas. Para desativar a cor existente, defina a cor para preto (#000000). Se alterar as cores aqui, nenhuma alteração será feita nas disciplinas já existentes, até à próxima vez que o professor tente alterar a cor do mosaico. Até lá, apenas as cores definidas aqui estarão disponíveis para os professores.';
$string['tilecolourschanged'] = 'As cores dos mosaicos foram redefinidas. Todos os mosaicos têm cores em conformidade com as cores abaixo.';
$string['tileicon'] = 'Ícone a mostrar (apenas este mosaico)';
$string['tileicon_help'] = 'O item aqui selecionado substituirá, apenas neste mosaico, o ícone do mosaico definido ao nível da disciplina.';
$string['tileicons'] = 'Ícones dos mosaicos';
$string['tileoutcome'] = 'Resultados da aprendizagem para este mosaico';
$string['tileoutcome_help'] = 'Se selecionar um resultado da aprendizagem para este mosaico, poderá mostrar, nas configurações da disciplina, um conjunto de <em>botões de filtro</em>, um para cada resultado da aprendizagem, que filtram os mosaicos a mostrar de acordo com o resultado que lhes foi atribuído';
$string['tileselecttip'] = 'Não tem que se preocupar em usar este formulário para alterar o ícone de um mosaico. Uma maneira mais fácil, na disciplina, é clicar no ícone que pretende alterar (com o modo de edição ativado)';
$string['tilesformatregistration'] = 'Registo do módulo';
$string['tip'] = 'Ajuda';
$string['togglecompletion'] = 'Clique para alternar o estado da conclusão';
$string['tootall'] = 'muito alta para o mosaico';
$string['toowide'] = 'muito larga para o mosaico';
$string['transparenttitleadjustments'] = 'Ajustes da transparência dos mosaicos';
$string['transparenttitleadjustments_desc'] = 'Em mosaicos com imagens e com o fundo do título transparente, dependendo do seu tema, pode ser ajustado para garantir que as linhas transparentes do título não se sobreponham quando se encaixam.
Tenha em atenção que estes valores também variam um pouco entre navegadores. Valores sugeridos para o Chrome: temas baseados em Boost e Clean: 30.5 e 4 | Adaptável: 32 e 4 | Moove: 32 e 2 | Remui: 32 e 2,5';
$string['uploadnewphoto'] = 'Carregar nova imagem';
$string['uploadnewphoto_help'] = 'Carregar uma imagem para ser usada neste mosaico';
$string['usejavascriptnav'] = 'Usar navegação com Javascript na página principal da disciplina';
$string['usejavascriptnav_desc'] = 'Se ativar esta opção, o utilizador ao clicar num mosaico da página principal da visão global da disciplina e se o Javascript estiver ativo, o JS será usado para fazer a transição para o conteúdo do mosaico. O conteúdo do mosaico será armazenado localmente no navegador de acordo com as outras configurações abaixo. Se desativada, o JS não será usado e será utilizada a navegação normal e as configurações do JS abaixo serão ignoradas.';
$string['usejseditingexpandcollapse'] = 'Modo de edição - usar JavaScript para expandir/colapsar mosaicos';
$string['usejseditingexpandcollapse_desc'] = 'Se ativar esta opção, no modo de edição, um professor pode expandir e colapsar a edição dos mosaicos com transições animadas. O conteúdo do mosaico será carregado como expandido, sem recarregar a página.';
$string['usejsnavforsinglesection'] = 'Usar navegação JS na página de secção única';
$string['usejsnavforsinglesection_desc'] = 'Se ativar esta opção, qualquer chamada para uma página de secção única (& secção = xx) será manipulada com Javascript, iniciando a página principal da disciplina animada para abrir na secção solicitada via JS, em vez de chamar a página de secção única do PHP no estilo antigo';
$string['usesubtilesseczero'] = 'Usar sub-mosaicos na secção de topo';
$string['usesubtilesseczero_help'] = 'Se ativar esta opção, na secção de topo da disciplina serão usados sub-mosaicos, bem como em todos os mosaicos. Uma vez que os sub-mosaicos ocupam muito espaço no topo da disciplina, talvez seja melhor não ativar para que todos os itens da secção de topo possam ser mostrados no formato de lista normal.';
$string['width'] = 'largura';
