<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_adaptable', language 'pt_br', version '3.5'.
 *
 * @package     theme_adaptable
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actingasrole'] = 'Você está atualmente acessando com outro papel';
$string['activebreadcrumb'] = 'Cor de fundo para o item ativo na navegação estrutural';
$string['activebreadcrumbdesc'] = 'Definir a cor de fundo para o item ativo e o restante da barra de navegação estrutural.';
$string['alertaccess'] = 'Alertar Visibilidade';
$string['alertaccessadmins'] = 'Visível para administradores';
$string['alertaccessdesc'] = 'Defina o tipo de restrição de acesso para a visibilidade da caixa de alerta. Nota: se estiver usando "Adicionar restrição de campo de perfil personalizado", será necessário adicionar valores para os campos de perfil abaixo.';
$string['alertaccessglobal'] = 'Visível para todos';
$string['alertaccessprofile'] = 'Adicionar restrição ao campo de perfil personalizado';
$string['alertaccessusers'] = 'Visível para usuários logados';
$string['alertannounce'] = 'Anúncio';
$string['alertannouncedesc'] = 'Exibir um anúncio na Caixa de Alerta';
$string['alertbackgroundcolorinfo'] = 'Cor de fundo para Informações';
$string['alertbackgroundcolorinfodesc'] = 'Cor de fundo das caixas de alerta do tipo Informação';
$string['alertbackgroundcolorsuccess'] = 'Cor de fundo de Anúncios';
$string['alertbackgroundcolorsuccessdesc'] = 'Cor de fundo de caixas de alerta do tipo Anúncio';
$string['alertbackgroundcolorwarning'] = 'Cor de fundo de Avisos';
$string['alertbackgroundcolorwarningdesc'] = 'Cor de fundo de caixas de alerta do tipo Aviso';
$string['alertbordercolorinfo'] = 'Cor de borda de Informações';
$string['alertbordercolorinfodesc'] = 'Cor de borda de caixas de alerta do tipo Informação';
$string['alertbordercolorsuccess'] = 'Cor de borda de Anúncios';
$string['alertbordercolorsuccessdesc'] = 'Cor da Borda das caixas de alerta do tipo Anúncio';
$string['alertbordercolorwarning'] = 'Cor da Borda de Aviso';
$string['alertbordercolorwarningdesc'] = 'Cor da borda das caixas de alerta do tipo Aviso';
$string['alertcolorinfo'] = 'Cor de Informações';
$string['alertcolorinfodesc'] = 'Cor do ícone das caixas de alerta do tipo Informação';
$string['alertcolorsheading'] = 'Customizar Caixas de Alerta superiores';
$string['alertcolorsheadingdesc'] = 'Configurar cores e ícone.';
$string['alertcolorsuccess'] = 'Cor de Anúncios';
$string['alertcolorsuccessdesc'] = 'Cor do ícone das caixas de alerta do tipo Anúncio';
$string['alertcolorwarning'] = 'Cor de Avisos';
$string['alertcolorwarningdesc'] = 'Cor do ícone de caixas de alertas do tipo Aviso';
$string['alertcount'] = 'Contagem de alertas';
$string['alertcountdesc'] = 'O número de alertas a serem mostrados na área de edição abaixo';
$string['alertdesc'] = 'Digite e personalize um texto a ser exibido no topo do site como um alerta. É possível definir mais de um alerta para segmentar diferentes tipos de usuários. Você também tem a opção de exibir alertas em todo o site ou apenas nas páginas iniciais.<br/><br/> <strong>Observação: </strong>agora também é possível exibir alertas nas páginas do curso para avisar os professores de que os cursos estão ocultos.';
$string['alertdisabled'] = 'Desabilitado';
$string['alertdisabledesc'] = 'Desabilitar este alerta.';
$string['alerthiddencourse'] = 'Alerta de curso oculto';
$string['alerthiddencoursedesc'] = 'Mostrar alerta na página do curso, caso esteja oculto';
$string['alerthiddencoursetext-1'] = 'Este curso está oculto e não pode ser acessado por estudantes';
$string['alerthiddencoursetext-2'] = 'Clique aqui para atualizar as configurações';
$string['alerticoninfo'] = 'Ícone de Informações';
$string['alerticoninfodesc'] = 'Defina o <a href="http://fortawesome.github.io/Font-Awesome/icons/">Ícone do Font Awesome</a> que será utilizado nas caixas de alerta do tipo Informação. Digite o nome do ícone sem o prefixo "fa-".';
$string['alerticonsuccess'] = 'Ícone de Anúncios';
$string['alerticonsuccessdesc'] = 'Defina o <a href="http://fortawesome.github.io/Font-Awesome/icons/">Ícone do Font Awesome</a> que será utilizado nas caixas de alerta do tipo Anúncio. Digite o nome do ícone sem o prefixo "fa-".';
$string['alerticonwarning'] = 'Ícone de Aviso';
$string['alerticonwarningdesc'] = 'Defina o <a href="http://fortawesome.github.io/Font-Awesome/icons/">Ícone do Font Awesome</a> que será utilizado nas caixas de alerta do tipo Aviso. Digite o nome do ícone sem o prefixo "fa-".';
$string['alertinfo'] = 'Informação';
$string['alertinfodesc'] = 'Exibir informações na Caixa de Alerta.';
$string['alertkeyvalue'] = 'Chave de alerta';
$string['alertkeyvalue_details'] = 'A chave que identifica esse alerta, a partir de alertas anteriores. Se você alterar isso, todos os usuários que descartaram o alerta anteriormente o verão novamente. Se você alterar o alerta, provavelmente desejará alterar isso para garantir que todos os usuários o vejam.';
$string['alertprofilefield'] = 'Nome do campo de perfil personalizado = valor (opcional)';
$string['alertprofilefielddesc'] = 'Adicionar regra de acesso usado para campo de perfil personalizado, por exemplo: usertype = student';
$string['alertsettings'] = 'Caixa de Alerta {$a}';
$string['alertsettingscourse'] = 'Configurações de Alertas do Curso';
$string['alertsettingsgeneral'] = 'Configurações Gerais de Alertas';
$string['alertsettingsheading'] = 'Personalize a caixa de alerta superior. Veja o layout <a href="./../theme/adaptable/pix/layout.png" target="_blank">aqui</a>';
$string['alerttext'] = 'Texto de Alerta';
$string['alerttextdesc'] = 'Digite o texto para exibir na caixa de alerta';
$string['alerttype'] = 'Tipo de Caixa de Alerta';
$string['alerttypedesc'] = 'Selecione o tipo de alerta: info (azul), aviso (amarelo) ou anúncio (verde)';
$string['alertwarning'] = 'Aviso';
$string['alertwarningdesc'] = 'Exibe um aviso na caixa de alerta.';
$string['analyticscount'] = 'Contagem do Analytics';
$string['analyticscountdesc'] = 'O número de campos de análise a serem mostrados na área de edição abaixo.';
$string['analyticsprofilefield'] = 'Nome do campo de perfil personalizado=valor (opcional)';
$string['analyticsprofilefielddesc'] = 'Adicionar regra de acesso usando campo de perfil personalizado, por exemplo: usertype=student';
$string['analyticssettings'] = 'Analytics';
$string['analyticssettingsdesc'] = 'Você pode configurar vários códigos para o Google Analytics e atribuí-los aos campos do perfil do usuário. Ou você pode usar o Matomo, o analytics de código aberto.';
$string['analyticssettingsheading'] = 'Configurar o Google Analytics e / ou o Matomo';
$string['analyticstext'] = 'ID do Analytics';
$string['analyticstextdesc'] = 'Digite o ID do Google Analytics';
$string['anonymizega'] = 'Tornar anônimo o IP do usuário';
$string['anonymizegadesc'] = 'Tornar anônimo o envio de IP do usuário para o Google Analytics';
$string['answered'] = 'Respondido';
$string['attempted'] = 'Tentativa';
$string['backcolor'] = 'Cor do fundo';
$string['backcolordesc'] = 'Selecione a cor do fundo.';
$string['bcustyle'] = 'Estilo BCU';
$string['beta'] = 'Versão de desenvolvimento. Não use em sites de produção.';
$string['blockbackgroundcolor'] = 'Cor de fundo do bloco.';
$string['blockbackgroundcolordesc'] = 'Defina a cor de fundo para todos os blocos.';
$string['blockbordercolor'] = 'Cor da borda do bloco';
$string['blockbordercolordesc'] = 'Defina a cor da borda do bloco.';
$string['blockheaderbackgroundcolor'] = 'A cor de fundo do titulo do bloco';
$string['blockheaderbackgroundcolordesc'] = 'Defina a cor de fundo do cabeçalho de todos os blocos.';
$string['blockheaderborderbottom'] = 'Espessura da borda inferior do cabeçalho do bloco';
$string['blockheaderborderbottomdesc'] = 'Definir a espessura da borda inferior dos cabeçalhos de bloco';
$string['blockheaderborderleft'] = 'Espessura da borda esquerda do cabeçalho do bloco';
$string['blockheaderborderleftdesc'] = 'Definir a espessura da borda esquerda dos cabeçalhos de bloco';
$string['blockheaderborderright'] = 'Espessura da borda direita do cabeçalho do bloco';
$string['blockheaderborderrightdesc'] = 'Definir a espessura da borda direita dos cabeçalhos de bloco';
$string['blockheaderbordertop'] = 'Espessura da borda superior do cabeçalho do bloco';
$string['blockheaderbordertopdesc'] = 'Define a espessura da borda superior dos cabeçalhos de bloco';
$string['blockheaderbordertopstyle'] = 'Estilo da borda dos cabeçalhos de blocos';
$string['blockheaderbordertopstyledesc'] = 'Definir o estilo da borda dos cabeçalhos de bloco';
$string['blockheaderbottomradius'] = 'Raio inferior do cabeçalho do bloco';
$string['blockheaderbottomradiusdesc'] = 'Defina o raio do bloco de cabeçalho inferior para obter um efeito curvo/arredondado';
$string['blockheadercolor'] = 'Cor da fonte do cabeçalho do bloco';
$string['blockheadercolordesc'] = 'Defina a cor da fonte do cabeçalho do bloco.';
$string['blockheadertopradius'] = 'Raio superior do cabeçalho do bloco';
$string['blockheadertopradiusdesc'] = 'Defina o raio do bloco do cabeçalho superior para obter um efeito curvo/arredondado';
$string['blockicons'] = 'Ícones dos blocos';
$string['blockiconsdesc'] = 'Defina isto para mostrar ícones de bloco na área de cabeçalho do bloco.';
$string['blockiconsheadersize'] = 'Tamanho dos ícones dos cabeçalhos de blocos';
$string['blockiconsheadersizedesc'] = 'Defina o tamanho do ícone da fonte usado no cabeçalho dos blocos do Moodle. Selecione um valor na lista.';
$string['blocklayoutbuilder'] = 'Regiões de Bloco da Página Principal';
$string['blocklayoutbuilderdesc'] = 'Abaixo você pode criar seu próprio layout para regiões de bloco na página principal.
Para adicionar conteúdo a essas regiões, você precisará <strong>ativar a edição na página principal do Moodle</strong>.
Então você pode começar a arrastar/soltar blocos nas regiões que você criar!';
$string['blocklayoutlayoutcheck'] = 'Verifique seu layout';
$string['blocklayoutlayoutcheckdesc'] = 'Use a ferramenta abaixo para verificar o número de blocos que você usou e ver uma representação de seu novo layout.';
$string['blocklayoutlayoutcount1'] = 'Você pode definir um máximo de';
$string['blocklayoutlayoutcount2'] = 'regiões de bloco. Você está usando atualmente:';
$string['blocklayoutlayoutrow'] = 'Linha de região de bloco';
$string['blocklayoutlayoutrowdesc'] = 'Adicionar / definir o layout para a linha de região de bloco na página principal.';
$string['blockmainborderbottom'] = 'Espessura da borda inferior do bloco principal';
$string['blockmainborderbottomdesc'] = 'Definir a espessura da borda inferior da área do bloco principal';
$string['blockmainborderleft'] = 'Espessura da borda esquerda do bloco principal';
$string['blockmainborderleftdesc'] = 'Definir a espessura da borda esquerda da área do bloco principal';
$string['blockmainborderright'] = 'Espessura da borda direita do bloco principal';
$string['blockmainborderrightdesc'] = 'Definir a espessura da borda direita da área do bloco principal';
$string['blockmainbordertop'] = 'Espessura da borda superior do bloco principal';
$string['blockmainbordertopdesc'] = 'Definir a espessura da borda superior da área do bloco principal';
$string['blockmainbordertopstyle'] = 'Estilo de borda do bloco principal';
$string['blockmainbordertopstyledesc'] = 'Definir o estilo da borda da área de conteúdo do bloco';
$string['blockmainbottomradius'] = 'Raio inferior do bloco principal';
$string['blockmainbottomradiusdesc'] = 'Defina o raio inferior da área do bloco principal para obter um efeito curvo / arredondado';
$string['blockmaintopradius'] = 'Raio superior do bloco principal';
$string['blockmaintopradiusdesc'] = 'Defina o raio superior da área do bloco principal para obter um efeito curvo / arredondado';
$string['blockregionbackground'] = 'Cor de fundo da região de bloco';
$string['blockregionbackgrounddesc'] = 'Cor de fundo do componente que contém layouts de bloco personalizados na página principal';
$string['blocksettings'] = 'Configurações do Bloco';
$string['blockside'] = 'Localização dos Blocos';
$string['blocksidedesc'] = 'Controlar se os blocos aparecem à esquerda ou à direita da página';
$string['breadcrumb'] = 'Cor de fundo da trilha de navegação';
$string['breadcrumbdesc'] = 'Defina a cor do plano de fundo da trilha de navegação.';
$string['breadcrumbhome'] = 'Início da trilha de navegação';
$string['breadcrumbhomedesc'] = 'Exibe o início da trilha de navegação como um ícone ou como um texto.';
$string['breadcrumbhomeicon'] = 'Ícone';
$string['breadcrumbhometext'] = 'Texto';
$string['breadcrumbseparator'] = 'Separador de trilha de navegação';
$string['breadcrumbseparatordesc'] = 'Defina o <a href="https://fortawesome.github.io/Font-Awesome/icons/" target="_blank">Ícone Font Awesome</a> para ser usado como separador de itens na trilha de navegação. insira o nome do ícone sem o prefixo fa-.';
$string['breadcrumbtextcolor'] = 'Cor do texto da trilha de navegação';
$string['breadcrumbtextcolordesc'] = 'Definir a cor do texto da trilha de navegação';
$string['breadcrumbtitle'] = 'Nome do curso na trilha de navegação';
$string['breadcrumbtitledesc'] = 'Definir o modo de exibição do nome do curso na trilha de navegação';
$string['breadcrumbtitlefullname'] = 'Nome Completo do Curso';
$string['breadcrumbtitleshortname'] = 'Nome Curto / Código do Curso';
$string['buttoncancelbackgroundcolor'] = 'Cor de fundo para o botão Cancelar';
$string['buttoncancelbackgroundcolordesc'] = 'Cor de fundo para o botão Cancelar. Digite <i>transparent</i> na caixa para transparência.';
$string['buttoncancelcolor'] = 'Cor do botão Cancelar';
$string['buttoncancelcolordesc'] = 'Escolha a cor para o botão Cancelar.';
$string['buttoncolor'] = 'Cor do Botão';
$string['buttoncolordesc'] = 'A cor dos principais botões usados em todo o site.';
$string['buttondesc'] = 'Altere a aparência dos botões usados neste tema.';
$string['buttondropshadow'] = 'Sombra na parte inferior do botão';
$string['buttondropshadowdesc'] = 'Mostre uma sombra (sombreamento) na parte inferior do botão.';
$string['buttonhovercolor'] = 'Cor do botão (quando receber foco)';
$string['buttonhovercolordesc'] = 'A cor do botão quando você passar o mouse sobre ele.';
$string['buttonlogincolor'] = 'Cor do botão de login';
$string['buttonlogincolordesc'] = 'A cor do botão de Login.';
$string['buttonloginheight'] = 'Definir altura para o botão de Login';
$string['buttonloginheightdesc'] = 'Funciona somente se estiver usando um formulário de login no cabeçalho superior';
$string['buttonloginhovercolor'] = 'Cor do botão de login quando selecionado';
$string['buttonloginhovercolordesc'] = 'A cor do botão de login ao passar o mouse';
$string['buttonloginmargintop'] = 'Definir margem superior para o botão de Login';
$string['buttonloginmargintopdesc'] = 'Permitir alterar o espaçamento/posição do botão de login';
$string['buttonloginpadding'] = 'Definir margem interna para o botão Entrar';
$string['buttonloginpaddingdesc'] = 'Número maior = botão maior';
$string['buttonlogintextcolor'] = 'Cor do texto do botão de login';
$string['buttonlogintextcolordesc'] = 'A cor do texto usado no botão de login.';
$string['buttonradius'] = 'Definir Raio do Botão';
$string['buttonradiusdesc'] = 'Raio mais alto = botões curvos, raio mais baixo = botões quadrados';
$string['buttonsettings'] = 'Botões';
$string['buttonsettingsheading'] = 'Personalizar os botões deste tema.';
$string['buttontextcolor'] = 'Cor de texto do botão';
$string['buttontextcolordesc'] = 'A cor do texto usada nos botões';
$string['cachedef_userdata'] = 'Um cache de sessão usado para armazenar dados específicos do usuário.';
$string['colordesc'] = 'Você pode selecionar as cores que gostaria de usar em todo o tema. Use Hex ou qualquer outra notação padrão. Como opção alternativa, você pode usar transparente e herdado como um valor';
$string['colorsettings'] = 'Cores';
$string['colorsettingsheading'] = 'Modificar as cores principais usadas em todo o tema.';
$string['configtitle'] = 'Adaptable';
$string['course'] = 'Curso';
$string['coursepageactivitybottomblockregionheading'] = 'Região de bloco inferior personalizada da atividade do curso';
$string['coursepageactivitybottomblockregionheadingdesc'] = 'Uma região de bloco personalizada que aparece após o final das atividades.';
$string['coursepageblockactivitybottomenabled'] = 'Habilitar região de bloco inferior da atividade na página do curso';
$string['coursepageblockactivitybottomenableddesc'] = 'Habilitar esta região em todas as páginas do curso.';
$string['coursepageblocklayoutbuilder'] = 'Áreas de Bloco da Página do Curso';
$string['coursepageblocklayoutbuilderdesc'] = 'Abaixo, você pode criar seu próprio layout para regiões de bloco na página do curso.
Para adicionar conteúdo nessas regiões, você precisará <strong>ativar a edição, na página do curso do Moodle</strong>.
Então você pode começar a arrastar/soltar blocos nas regiões que criar!';
$string['coursepageblocklayoutlayoutbottomrow'] = 'Página do Curso - Linha Inferior de Área de Bloco';
$string['coursepageblocklayoutlayoutbottomrowdesc'] = 'Adicionar / definir o layout para linha de área de bloco na página do Curso.';
$string['coursepageblocklayoutlayouttoprow'] = 'Página do Curso - Linha Superior de Área de Bloco';
$string['coursepageblocklayoutlayouttoprowdesc'] = 'Adicionar / definir o layout para linha de área de bloco na página do Curso.';
$string['coursepageblockregionsettings'] = 'Página do Curso - Construtor de Área de Bloco';
$string['coursepageblocksenabled'] = 'Habilitar áreas de bloco personalizadas na página do Curso';
$string['coursepageblocksenableddesc'] = 'Você pode habilitar / desabilitar regiões de bloco personalizadas (superior e inferior) na página Curso.
Em seguida, você pode arrastar e soltar blocos nas regiões que criou';
$string['coursepageblocksliderenabled'] = 'Habilitar região de bloco para um slider personalizado na página do curso';
$string['coursepageblocksliderenableddesc'] = 'Habilitar esta região em todas as páginas do curso.';
$string['coursepageheaderhidesitetitle'] = 'Ocultar o título do site nas páginas dos cursos';
$string['coursepageheaderhidesitetitledesc'] = 'Ocultar o título do site, logomarca e barra de busca nas páginas dos cursos. Use em conjunto com a configuração de altura do cabeçalho para mostrar um cabeçalho menor nas páginas dos cursos.';
$string['coursepagenewssliderblockregionheading'] = 'Região de bloco personalizada para slider de notícias';
$string['coursepagenewssliderblockregionheadingdesc'] = 'Uma região de bloco personalizada projetada para uso com o slider de notícias que faz parte do pacote Adaptable UI. Essa região aparece acima das atividades na página do Curso. Para adicionar um bloco slider de notícias, primeiro instale o <strong><a href="https://moodle.org/plugins/block_news_slider">Slider de notícias do Adaptable UI</a></strong> e configure-o para aparecer na região "Página do Curso - Região do slider" em todas as páginas do curso.';
$string['coursepagesidebarinfooterenabled'] = 'Mover a barra lateral para o rodapé na página Curso';
$string['coursepagesidebarinfooterenableddesc'] = 'Mover a barra lateral para o rodapé para ampliar o layout de página do curso.';
$string['coursepagesidebarinfooterenabledsection'] = 'Configurações comuns';
$string['coursepagesidebarinfooterenabledsectiondesc'] = 'Configurações comuns para a maioria dos formatos de curso.';
$string['coursesectionactivityassignbgcolor'] = 'Cor de fundo da atividade Tarefa';
$string['coursesectionactivityassignleftbordercolor'] = 'Atividade Tarefa - cor da borda esquerda';
$string['coursesectionactivityassignleftbordercolordesc'] = 'Definir a cor da borda esquerda.';
$string['coursesectionactivitybordercolor'] = 'Seção do Curso - Cor da Borda Inferior da Atividade';
$string['coursesectionactivitybordercolordesc'] = 'Definir a cor da borda inferior da atividade da seção do curso.';
$string['coursesectionactivityborderstyle'] = 'Seção do Curso - Estilo da Borda Inferior da Atividade';
$string['coursesectionactivityborderstyledesc'] = 'Definir o estilo da borda inferior da atividade da seção do curso.';
$string['coursesectionactivityborderwidth'] = 'Seção do Curso - Largura da Borda Inferior da Atividade';
$string['coursesectionactivityborderwidthdesc'] = 'Definir a largura da borda que aparece na parte inferior de uma atividade da seção do curso.';
$string['coursesectionactivitycolors'] = 'Seção do Curso - Opções da Atividade';
$string['coursesectionactivityforumbgcolor'] = 'Cor de fundo da atividade fórum';
$string['coursesectionactivityforumleftbordercolor'] = 'Atividade Fórum - Cor exibida na borda esquerda da atividade';
$string['coursesectionactivityforumleftbordercolordesc'] = 'Define a cor da borda esquerda';
$string['coursesectionactivityfurtherinformation'] = 'Página do curso -  mais informações';
$string['coursesectionactivityfurtherinformationassign'] = 'Mostrar informações da Tarefa';
$string['coursesectionactivityfurtherinformationassigndesc'] = 'Mostrar informações da Tarefa, como data limite, status do envio. Para professores / administradores, mostre o número de envios.';
$string['coursesectionactivityfurtherinformationchoice'] = 'Mostrar informações da Escolha';
$string['coursesectionactivityfurtherinformationchoicedesc'] = 'Mostrar informações da escolha, como o status do envio. Para professores / administradores, mostra o número de envios.';
$string['coursesectionactivityfurtherinformationdata'] = 'Mostrar informações da Base de dados';
$string['coursesectionactivityfurtherinformationdatadesc'] = 'Mostrar informações dos dados, como o status do envio. Para professores / administradores, mostra o número de envios.';
$string['coursesectionactivityfurtherinformationfeedback'] = 'Mostrar informações da Pesquisa';
$string['coursesectionactivityfurtherinformationfeedbackdesc'] = 'Mostrar informações da pesquisa, com o status do envio. Para professores / administradores, mostra o número de envios.';
$string['coursesectionactivityfurtherinformationlesson'] = 'Mostrar informação da lição';
$string['coursesectionactivityfurtherinformationlessondesc'] = 'Mostrar informações da lição, como o status do envio. Para professores / administradores, mostra o número de envios.';
$string['coursesectionactivityfurtherinformationquiz'] = 'Mostrar informação do questionário';
$string['coursesectionactivityfurtherinformationquizdesc'] = 'Mostrar informações do questionário, como o status do envio. Para professores / administradores, mostra o número de envios.';
$string['coursesectionactivityiconsize'] = 'Seção do Curso - Tamanho do Ícone da Atividade';
$string['coursesectionactivityiconsizedesc'] = 'Configura p tamanho do ícone para as atividades (ex. um valor de 16px irá configurá-lo em 16px x 16px';
$string['coursesectionactivityleftborderwidth'] = 'Seção do Curso - Largura da Borda Esquerda da Atividade';
$string['coursesectionactivityleftborderwidthdesc'] = 'Definir a largura da borda que aparece à esquerda de uma atividade na seção do curso.';
$string['coursesectionactivitymarginbottom'] = 'Espaçamento da margem inferior da atividade';
$string['coursesectionactivitymarginbottomdesc'] = 'Espaçamento da margem inferior entre as atividades.';
$string['coursesectionactivitymargintop'] = 'Espaçamento da margem superior da atividade';
$string['coursesectionactivitymargintopdesc'] = 'Espaçamento da margem superior entre as atividades.';
$string['coursesectionactivityquizbgcolor'] = 'Cor de fundo da atividade Questionário';
$string['coursesectionactivityquizleftbordercolor'] = 'Cor da exibição da borda esquerda da atividade Questionário';
$string['coursesectionactivityquizleftbordercolordesc'] = 'Definir a cor da borda esquerda.';
$string['coursesectionactivityuseadaptableicons'] = 'Usar o Conjunto de Ícones do Adaptable';
$string['coursesectionactivityuseadaptableiconsdesc'] = 'Ative isso para usar os ícones do Adaptable. Se desativado, certifique-se de remover os diretórios adaptable/pix_plugins e adaptable/pix_core/f para usar os ícones padrão do Moodle.';
$string['coursesectionbgcolor'] = 'Seção do curso - Fundo';
$string['coursesectionbgcolordesc'] = 'Definir a cor de fundo da seção do curso';
$string['coursesectionbordercolor'] = 'Seção do Curso - Cor da Borda';
$string['coursesectionbordercolordesc'] = 'Definir a cor da borda da seção do curso';
$string['coursesectionborderradius'] = 'Seção do Curso - Raio da Borda';
$string['coursesectionborderradiusdesc'] = 'Definir o raio das bordas da seção do curso (cantos arredondados)';
$string['coursesectionborderstyle'] = 'Seção do Curso - Estilo da Borda';
$string['coursesectionborderstyledesc'] = 'Definir o estilo da borda da seção do curso';
$string['coursesectionborderwidth'] = 'Seção do Curso - Largura da borda';
$string['coursesectionborderwidthdesc'] = 'Definir a largura da borda da seção do curso';
$string['coursesectionheaderbg'] = 'Seção do Curso - Fundo do Título';
$string['coursesectionheaderbgdesc'] = 'Definir a cor de fundo do título da seção do curso';
$string['coursesectionheaderbordercolor'] = 'Seção do Curso - Estilo da Borda do Título';
$string['coursesectionheaderbordercolordesc'] = 'Definir a cor da borda do título da seção do curso (somente a borda inferior é usada porque a estrutura externa também possui borda)';
$string['coursesectionheaderborderradiusbottom'] = 'Seção do Curso - Raio da Borda Inferior do Título';
$string['coursesectionheaderborderradiusbottomdesc'] = 'Definir o raio inferior das bordas do título da seção do curso (cantos arredondados)';
$string['coursesectionheaderborderradiustop'] = 'Seção do Curso - Raio da Borda Superior do Título';
$string['coursesectionheaderborderradiustopdesc'] = 'Definir o raio superior das bordas do título da seção do curso (cantos arredondados)';
$string['coursesectionheaderborderstyle'] = 'Seção do Curso - Estilo da Borda do Título';
$string['coursesectionheaderborderstyledesc'] = 'Definir o estilo da borda do título da seção do curso (somente a borda inferior é usada porque a estrutura externa também possui borda)';
$string['coursesectionheaderborderwidth'] = 'Seção do Curso - Largura da Borda do Título';
$string['coursesectionheaderborderwidthdesc'] = 'Definir a largura da borda do título da seção do curso (somente a borda inferior é usada porque a estrutura externa também possui borda)';
$string['coursesettings'] = 'Formatos de curso';
$string['coursesettingsdesc'] = 'Personalize alguns dos formatos de curso Moodle mais usados para se ajustar ao design principal.';
$string['coursesettingsheading'] = 'Configuracões dos Formatos de Curso';
$string['coursetitlemaxwidth'] = 'Tamanho Máximo do Título do Curso';
$string['coursetitlemaxwidthdesc'] = 'Defina o número máximo de caracteres da área de título do curso';
$string['currentcolor'] = 'Seção Atual do Curso -  Cor de Destaque';
$string['currentcolordesc'] = 'Defina a cor de destaque para a seção atual do curso';
$string['customcss'] = 'CSS personalizado';
$string['customcssdesc'] = 'Todas as regras CSS adicionadas nesta área de texto serão refletidas em todas as páginas, facilitando a personalização desse tema.';
$string['customcssjssettings'] = 'CSS & JS Personalizados';
$string['customfontheadername'] = 'Fonte do cabeçalho personalizada';
$string['customfontname'] = 'Personalizar a fonte padrão';
$string['customfonttitlename'] = 'Personalizar a fonte do título';
$string['dashblocklayoutbuilder'] = 'Painel - Regiões de blocos';
$string['dashblocklayoutbuilderdesc'] = 'Abaixo, você pode criar seu próprio layout para regiões de bloco na página Painel.
Para adicionar conteúdo nessas regiões, você precisará <strong>ativar a edição na página de painel do Moodle</strong>.
Então você pode começar a arrastar/soltar blocos nas regiões que criar!';
$string['dashblocklayoutlayoutrow'] = 'Linha de Região de Bloco do Painel';
$string['dashblocklayoutlayoutrowdesc'] = 'Adicionar / definir o layout da linha de região de bloco na página Painel.';
$string['dashblocksenabled'] = 'Habilitar região de bloco personalizada na página Painel';
$string['dashblocksenableddesc'] = 'Você pode ativar / desativar regiões de bloco personalizadas na página Painel.
Em seguida, você pode arrastar e soltar blocos nas regiões que você criou';
$string['dashboardblockregionsettings'] = 'Construtor de Região de Bloco do Painel';
$string['deprecated'] = 'NÃO USE ADATABLE NESTE SITE. VERSÃO DO MOODLE DESCONTINUADA.';
$string['disablecustommenu'] = 'Desativar Menus Personalizados';
$string['disablecustommenudesc'] = 'Desativar os menus personalizados do Moodle na barra de navegação (ainda será renderizada em outros temas que você possa ter instalado)';
$string['disabled'] = 'Desabilitado';
$string['disablemenuscoursepages'] = 'Desabilitar os menus nas páginas do curso';
$string['disablemenuscoursepagesdesc'] = 'Ativar esta opção limitará a exibição dos menus principais às páginas do site, à página inicial e ao painel, e não será exibida em nenhuma página de curso';
$string['discardbuttontext'] = 'Cancelar';
$string['displaygrades'] = 'Mostrar Notas';
$string['displaygradesdesc'] = 'Mostrar o item Notas no menu';
$string['displaylogin'] = 'Tela de Login';
$string['displayloginbox'] = 'Caixa de login';
$string['displayloginbutton'] = 'Botão';
$string['displayloginno'] = 'Sem usuário';
$string['displayparticipants'] = 'Mostrar Participantes';
$string['displayparticipantsdesc'] = 'Mostrar o item Participantes no menu';
$string['dividingline'] = 'Linha divisória no cabeçalho';
$string['dividingline2'] = 'Linha divisória no rodapé';
$string['dividingline2desc'] = 'A cor da linha divisória no rodapé';
$string['dividinglinedesc'] = 'A cor da linha divisória no cabeçalho';
$string['draft'] = 'Oculto para estudantes';
$string['due'] = 'Data de entrega {$a}';
$string['editfont'] = 'Cor da fonte do botão Editar e Personalizar esta página';
$string['editfontdesc'] = 'Definir a cor da fonte do botão Editar e Personalizar esta página';
$string['edithorizontalpadding'] = 'Definir margem interna horizontal dos botões de edição';
$string['editoffbk'] = 'Fundo do botão Ativar edição e Personalizar esta página quando desativados';
$string['editoffbkdesc'] = 'Definir a cor de fundo do botão Ativar edição e Personalizar esta página quando estiverem desativados';
$string['editonbk'] = 'Fundo do botão Ativar edição e Personalizar esta página';
$string['editonbkdesc'] = 'Definir a cor de fundo do botão Ativar edição e Personalizar esta página';
$string['editverticalpadding'] = 'Definir margem interna vertical dos botões de edição';
$string['emoticonsize'] = 'Tamanho dos emoticons';
$string['emoticonsizedesc'] = 'Definir a altura e a largura dos emoticons do moodle.';
$string['enablealert'] = 'Habilitar Caixa de Alerta {$a}';
$string['enablealertcoursepages'] = 'Habilitar Caixa de alerta nas Páginas do Curso';
$string['enablealertcoursepagesdesc'] = 'Ativar esta opção exibirá a caixa de alerta superior nas páginas dos cursos';
$string['enablealertdesc'] = 'Habilitar Caixa de Alerta {$a}';
$string['enablealerts'] = 'Habilitar / Desabilitar Alertas';
$string['enablealertsdesc'] = 'Habilitar / desabilitar alertas no seu site';
$string['enablealertstriptags'] = 'Retirar automaticamente as tags html dos alertas';
$string['enablealertstriptagsdesc'] = 'Habilitar limpará automaticamente as mensagens de alerta, Desabilitar permitirá que você use html/links nas mensagens, mas você precisará limpar manualmente na visualização html';
$string['enableanalytics'] = 'Habilitar o Google Analytics';
$string['enableanalyticsdesc'] = 'Habilitar as configurações do Google Analytics no seu site Moodle';
$string['enableavailablecourses'] = 'Mostrar "Cursos Disponíveis"';
$string['enableavailablecoursesdesc'] = 'Mostrar o texto "Cursos disponíveis" na página principal';
$string['enablebadges'] = 'Emblemas';
$string['enablebadgesdesc'] = 'Mostrar um link para os emblemas dos usuários';
$string['enableblog'] = 'Habilitar meus Blogs';
$string['enableblogdesc'] = 'Mostrar um link para a página de blogs dos usuários';
$string['enablecalendar'] = 'Calendário do Usuário';
$string['enablecalendardesc'] = 'Mostrar um link para o calendário dos usuários';
$string['enableeditprofile'] = 'Editar Perfil';
$string['enableeditprofiledesc'] = 'Mostrar um link para editar o perfil dos usuários';
$string['enableeventsdesc'] = 'Mostrar um link para o calendário';
$string['enablefeed'] = 'Meu Feedback';
$string['enablefeeddesc'] = 'Exibir um link para os usuários da página "Meu feeedback"- Observação: isso requer instalação adicional: <a href="https://moodle.org/plugins/report_myfeedback" target="blank">Plugin My Feedback</a>';
$string['enablegrades'] = 'Notas';
$string['enablegradesdesc'] = 'Mostrar um link para as notas dos usuários';
$string['enableheading'] = 'Cabeçalho - Título do Curso';
$string['enableheadingdesc'] = 'Definir o modo de exibição do título do curso no cabeçalho quando o título padrão do site Moodle estiver habilitado.';
$string['enablehomedesc'] = 'Mostrar um link para a página principal';
$string['enablehomeredirect'] = 'Habilitar Página Inicial redirect=0';
$string['enablehomeredirectdesc'] = '';
$string['enablemenus'] = 'Habilitar Menus';
$string['enablemenusdesc'] = 'É recomendável que você deixe isso desativado, se os menus não estão em uso, por razões de desempenho';
$string['enablemyhomedesc'] = 'Mostrar um link para {$a}';
$string['enablemysitesdesc'] = 'Mostrar um menu com os cursos dos usuários';
$string['enablemysitesrestriction'] = 'Restringir o menu de cursos do usuário para um campo personalizado do perfil';
$string['enablemysitesrestrictiondesc'] = 'Restringir o menu suspenso de cursos do usuário por um campo de perfil personalizado. Por exemplo. usertype=staff';
$string['enablenavbarwhenloggedout'] = 'Habilitar barra de navegação quando estiver desconectado';
$string['enablenavbarwhenloggedoutdesc'] = 'Mostra a barra de navegação mesmo quando desconectado. Limitado apenas ao menu Ajuda e Ferramentas.';
$string['enablenote'] = 'Minhas Notificações';
$string['enablenotedesc'] = 'Mostrar um link para a página de notificações do usuário';
$string['enableposts'] = 'Meus Posts';
$string['enablepostsdesc'] = 'Mostrar um link para a página Meus Posts';
$string['enablepref'] = 'Minhas Preferências';
$string['enableprefdesc'] = 'Mostrar um link para a página de preferências do usuário';
$string['enableprivatefiles'] = 'Arquivos Privados';
$string['enableprivatefilesdesc'] = 'Mostrar um link para os arquivos privados dos usuários';
$string['enableprofile'] = 'Perfil';
$string['enableprofiledesc'] = 'Mostrar um link para o perfil dos usuários';
$string['enablesavecanceloverlay'] = 'Habilitar Salvar mu / Cancelar sobreposição nas páginas de configurações';
$string['enablesearchbox'] = 'Ativa a caixa de busca';
$string['enablesearchboxdesc'] = 'Mostra uma caixa de busca no cabeçalho';
$string['enableshowhideblocks'] = 'Habilitar Mostrar e Ocultar Blocos';
$string['enableshowhideblocksdesc'] = 'Permitir que os usuários mostrem/ocultem todos blocos.';
$string['enabletoolsmenus'] = 'Habilitar Menus de Ferramentas';
$string['enabletoolsmenusdesc'] = 'Se os menus não estão sendo utilizados, é recomendado que você deixe isso desativado por razões de desempenho.';
$string['enablezoom'] = 'Habilitar o Zoom';
$string['events'] = 'Eventos';
$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'Envie um favicon para ser usado no seu site';
$string['feedbackavailable'] = 'Feedback disponível';
$string['fontblockheadercolor'] = 'Cor da Fonte do Cabeçalho dos Blocos';
$string['fontblockheadercolordesc'] = 'Defina a cor da fonte do cabeçalho dos blocos do moodle, use o código hexadecimal html. Observe que isso também afeta a cor do ícone.';
$string['fontblockheadersize'] = 'Tamanho da fonte do cabeçalho dos blocos';
$string['fontblockheadersizedesc'] = 'Definir o tamanho da fonte usada no cabeçalho dos blocos do moodle. Selecione um valor da lista.';
$string['fontblockheaderweight'] = 'Peso da fonte dos cabeçalhos dos blocos';
$string['fontblockheaderweightdesc'] = 'Definir o peso da fonte usado nos cabeçalhos dos blocos. Selecione um valor de 100 a 900, dependendo da fonte selecionada.';
$string['fontcolor'] = 'Cor principal da fonte';
$string['fontcolordesc'] = 'Definir a cor da fonte no tema, use o código hexadecimal html.';
$string['fontdesc'] = 'Você pode selecionar as fontes do Google que você gostaria de usar em todo o tema. Selecione o subconjunto necessário (o latim está sempre incluído) e insira o peso correto da fonte ou a fonte não será exibida.';
$string['fontheadercolor'] = 'Cor da fonte do cabeçalho';
$string['fontheadercolordesc'] = 'Defina a cor da fonte do cabeçalho no tema, use o código hexadecimal html.';
$string['fontheadername'] = 'Fonte dos cabeçalhos';
$string['fontheadernamedesc'] = 'Selecionar a fonte padrão ou uma<a href="https://www.google.com/fonts" target="_blank">Fonte do Google</a> usada no texto e cabeçalhos dos blocos.';
$string['fontheaderweight'] = 'Peso da fonte dos cabeçalhos';
$string['fontheaderweightdesc'] = 'Peso da fonte dos cabeçalhos usado no site. Selecione um valor de 100 a 900, dependendo da fonte selecionada.';
$string['fontname'] = 'Fonte principal';
$string['fontnamedesc'] = 'Selecionar a fonte padrão ou uma<a href="https://www.google.com/fonts" target="_blank">Fonte do Google</a> usada no site.';
$string['fontsettings'] = 'Fontes';
$string['fontsettingsheading'] = 'Modificar as fontes usadas em todo o tema.';
$string['fontsize'] = 'Tamanho da fonte principal';
$string['fontsizedesc'] = 'Selecione o tamanho da fonte padrão (em porcentagem) usado em todo o site.';
$string['fontsubset'] = 'Subconjunto de fontes do Google';
$string['fontsubsetdesc'] = 'Selecionar outro subconjunto de caracteres que não o latino para aplicar a todas as fontes. O subconjunto latino já está incluído por padrão.';
$string['fonttitlecolor'] = 'Cor da fonte do título do site / curso';
$string['fonttitlecolorcourse'] = 'Cor da fonte do título do curso';
$string['fonttitlecolorcoursedesc'] = 'Definir a cor da fonte do título do curso no tema, use o código hexadecimal html.';
$string['fonttitlecolordesc'] = 'Definir a cor da fonte do título do site e do título do curso no tema, use o código hexadecimal html.';
$string['fonttitlename'] = 'Fonte do título do Site / Curso';
$string['fonttitlenamedesc'] = 'Selecione a fonte padrão ou a<a href="https://www.google.com/fonts" target="_blank">Fonte do Google</a> usada no título do  site e nos títulos dos cursos.';
$string['fonttitlesize'] = 'Título do Site / Curso - Tamanho da fonte';
$string['fonttitlesizedesc'] = 'Tamanho da fonte do título do site e do título do curso usado no site. Selecione um valor da lista.';
$string['fonttitleweight'] = 'Título do Site / Curso - Peso da fonte';
$string['fonttitleweightdesc'] = 'Definir o peso da fonte usada no título do site e nos títulos dos cursos. Selecione um valor de 100 a 900, dependendo da fonte selecionada.';
$string['fontweight'] = 'Peso da fonte principal';
$string['fontweightdesc'] = 'Peso da fonte usado no site. Selecione um valor de 100 a 900, dependendo da fonte selecionada.';
$string['footerbkcolor'] = 'Cor de fundo do rodapé';
$string['footerbkcolordesc'] = 'Definir a cor de fundo do rodapé.';
$string['footerblocksplacement'] = 'Rodapé - Local dos Blocos';
$string['footerblocksplacement1'] = 'Em todo o site';
$string['footerblocksplacement2'] = 'Apenas na Página Inicial';
$string['footerblocksplacement3'] = 'Nunca';
$string['footerblocksplacementdesc'] = 'Controlar onde os blocos superiores do rodapé são exibidos. Todo o site é o padrão.';
$string['footercontent'] = 'Rodapé - Conteúdo da Secão';
$string['footercontentdesc'] = 'Adicionar conteúdo para a seção de rodapé';
$string['footerdesc'] = 'Adicionar um título para a seção de rodapé';
$string['footerheader'] = 'Rodapé - Título da Secão';
$string['footerlayoutrow'] = 'Construtor de Layout do Rodapé';
$string['footerlayoutrowdesc'] = 'Crie seu layout para as regiões de blocos de rodapé.';
$string['footerlinkcolor'] = 'Cor do link nos blocos do rodapé';
$string['footerlinkcolordesc'] = 'Definir a cor do link nos blocos do rodapé.';
$string['footersettings'] = 'Rodapé';
$string['footersettingsheading'] = 'Definir o conteúdo que deve aparecer no rodapé. Veja o layout <a href="./../theme/adaptable/pix/layout.png" target="_blank">aqui</a>';
$string['footertextcolor'] = 'Cor do texto do rodapé';
$string['footertextcolor2'] = 'Cor do texto do rodapé inferior';
$string['footertextcolor2desc'] = 'Cor do texto do rodapé inferior.';
$string['footertextcolordesc'] = 'A cor do texto no rodapé, use o código hexadecimal html.';
$string['footnote'] = 'Nota de rodapé';
$string['footnotedesc'] = 'Adicionar texto ao rodapé';
$string['forumbodybackgroundcolor'] = 'Fórum - Fundo do corpo da postagem';
$string['forumbodybackgroundcolordesc'] = 'Cor de fundo para uma postagem no fórum';
$string['forumheaderbackgroundcolor'] = 'Fórum - Fundo do título da postagem';
$string['forumheaderbackgroundcolordesc'] = 'Cor de fundo para o título de uma postagem no fórum';
$string['frnt-footer'] = 'Blocos nesta área só será visível para os usuários administradores.';
$string['frontpagealertsettings'] = 'Caixa de alerta';
$string['frontpageblockregionsettings'] = 'Construtor de Região de Bloco';
$string['frontpageblocksenabled'] = 'Habilitar a região de bloco personalizada na página principal';
$string['frontpageblocksenableddesc'] = 'Você pode habilitar / desabilitar regiões de bloco personalizadas na página principal.
Em seguida, você pode arrastar e soltar blocos nas regiões que criou';
$string['frontpageblocksettings'] = 'Blocos de Marketing';
$string['frontpagecoursesettings'] = 'Lista de cursos da página principal';
$string['frontpagedesc'] = 'Configurar a maneira como as caixas dos curso são renderizadas na página principal.';
$string['frontpagemarketenabled'] = 'Habilitar os Blocos de Marketing';
$string['frontpagemarketenableddesc'] = 'Definir os blocos de marketing na página principal.';
$string['frontpagemarketoption'] = 'Escolha o estilo para blocos de marketing';
$string['frontpagemarketoptiondesc'] = 'Você pode aplicar estilos diferentes aos blocos de marketing.
Nota: O estilo BCU foi projetado para funcionar com imagens na parte superior do bloco.';
$string['frontpagerenderer'] = 'Caixas de Curso na Página Principal';
$string['frontpagerendererdefaultimage'] = 'Imagem padrão de curso';
$string['frontpagerendererdesc'] = 'Controlar a maneira como as caixas dos cursos na página principal são renderizadas.';
$string['frontpagerendereroption1'] = 'Blocos';
$string['frontpagerendereroption2'] = 'Blocos com sobreposição';
$string['frontpagerendereroption3'] = 'Padrão do Moodle';
$string['frontpagesettingsheading'] = 'Renderização da Página Principal';
$string['frontpageslidersettings'] = 'Slider da Página Principal';
$string['fullscreen'] = 'Tela cheia';
$string['fullscreenwidth'] = 'Largura da tela cheia.';
$string['fullscreenwidthdesc'] = 'Definir a largura máxima do tema quando estiver no modo de tela cheia / zoom.';
$string['genericsettingsdescription'] = 'Aqui você pode encontrar várias configurações para adicionar seu próprio código CSS e JavaScript ao tema.';
$string['genericsettingsheading'] = 'Aplicar suas próprias modificações';
$string['googleanalyticssettings'] = 'Google Analytics';
$string['googleanalyticssettingsdesc'] = 'Você pode configurar vários códigos para o Google Analytics e atribuí-los a campos de perfil de usuário.';
$string['googleanalyticssettingsheading'] = 'Configure o Google Analytics para o seu site';
$string['headerbgimage'] = 'Imagem de fundo';
$string['headerbkcolor'] = 'Cor de fundo do cabeçalho superior';
$string['headerbkcolor2'] = 'Cor de fundo do cabeçalho inferior';
$string['headerbkcolordesc'] = 'Definir a cor de fundo do cabeçalho superior';
$string['headerdesc'] = 'Carregue seu favicon, logotipo, defina o formulário de login no cabeçalho, ajuste os títulos no cabeçalho.<br />
Você pode definir o tamanho da fonte e os estilos dos títulos na página de configurações <a href="./../admin/settings.php?section=theme_adaptable_font">Fontes</a>.';
$string['headernavbarhelpheading'] = 'Links de Ajuda e Opções';
$string['headernavbarhelpheadingdesc'] = 'Opções para links do menu de ajuda.';
$string['headernavbarmycoursesheading'] = 'Menu Meus Cursos';
$string['headernavbarthiscourseheading'] = 'Menu Este Curso';
$string['headernavbarthiscourseheadingdesc'] = 'Neste menu, o estudante pode acessar diretamente todas as atividades do curso, a lista de participantes e suas notas.';
$string['headersettings'] = 'Cabeçalho';
$string['headersettingsheading'] = 'Personalize o cabeçalho deste tema. Veja o layout <a href="./../theme/adaptable/pix/layout.png" target="_blank">aqui</a>';
$string['headertextcolor'] = 'A cor do texto e link dos blocos do cabeçalho superior';
$string['headertextcolor2'] = 'A cor do texto e do link dos blocos do cabeçalho inferior';
$string['headertextcolor2desc'] = 'Definir a cor do texto e do link dos blocos do cabeçalho inferior.';
$string['headertextcolordesc'] = 'Definir a cor do texto e do link dos blocos do cabeçalho superior.';
$string['help'] = 'Ajuda';
$string['helptargetdesc'] = 'Deseja que o link de ajuda seja aberto em uma nova janela?';
$string['helptitle'] = 'Ajuda';
$string['helptitle2'] = 'Segundo link de ajuda';
$string['hiddencourses'] = 'Cursos Ocultos';
$string['hide'] = 'Ocultar';
$string['hideblocks'] = 'Ocultar blocos';
$string['hidefootersocial'] = 'Mostrar ícones de rede social';
$string['hidefootersocialdesc'] = 'Mostre ícones de redes sociais no rodapé abaixo dos blocos.';
$string['hideinforum'] = 'Ocultar Ajuda e Ferramentas nos Fóruns';
$string['home'] = 'Início';
$string['homebk'] = 'Imagem de fundo da página principal';
$string['infoboxfullscreen'] = 'Caixa de informação em tela cheia';
$string['infoboxfullscreendesc'] = 'Ativar esta opção fará com que a caixa de informação fique em tela cheia.';
$string['jssection'] = 'Seção Javascript';
$string['jssectiondesc'] = 'Adicionar código javascript para o site';
$string['jssectionrestricted'] = 'Seção - Javascript Condicional';
$string['jssectionrestricteddashboardonly'] = 'Incluir Javascript apenas na página do painel';
$string['jssectionrestricteddashboardonlydesc'] = 'Mostrar o javascript apenas na página do painel. Caso contrário, isso será mostrado em todo o site.';
$string['jssectionrestricteddesc'] = 'Adicionar código javascript condicionalmente ao site com base em um campo de perfil personalizado. Este javascript aparecerá apenas se essa condição for atendida.';
$string['jssectionrestrictedprofilefield'] = 'Seção - Campo de perfil personalizado da seção Javascript';
$string['jssectionrestrictedprofilefielddesc'] = 'Mostrar o javascript acima SOMENTE quando o usuário corresponder ao valor do campo de perfil personalizado, por exemplo: faculty=fbl.';
$string['jumpto'] = 'Ir para...';
$string['layoutaddcontent'] = 'Satisfeito com seu layout? Agora adicione conteúdo aos seus blocos:';
$string['layoutaddcontentdesc1'] = 'Você configurou';
$string['layoutaddcontentdesc2'] = 'blocos de marketing. Se você estiver satisfeito com este layout, adicione conteúdo aos blocos abaixo.
Se você não estiver satisfeito, use o construtor de layout acima para fazer alterações <br />';
$string['layoutcheck'] = 'Verificar seu layout';
$string['layoutcheckdesc'] = 'Use a ferramenta abaixo para verificar o número de blocos que você usou e ver uma representação do seu novo layout.';
$string['layoutcount1'] = 'Você pode definir no máximo';
$string['layoutcount2'] = 'regiões de bloco. Atualmente, você está usando:';
$string['layoutdesc'] = 'Definir o layout padrão que os usuários visualizam.';
$string['layoutsettings'] = 'Layout';
$string['layoutsettingsheading'] = 'Controlar a aparência do layout do site';
$string['leftblocks'] = 'Lado esquerdo';
$string['linkcolor'] = 'Cor do Link';
$string['linkcolordesc'] = 'Definir a cor dos links no tema, use o código hexadecimal html.';
$string['linkhover'] = 'Cor do Link ao passar o mouse';
$string['linkhoverdesc'] = 'Definir a cor dos links (ao passar o mouse) no tema, use o código hexadecimal html.';
$string['linksmenu'] = 'Menu de Links';
$string['loadingcolor'] = 'Cor do Carregamento';
$string['loadingcolordesc'] = 'A cor da barra de carregamento na parte superior da página';
$string['loadtime'] = 'Página carregada em';
$string['loginplaceholder'] = 'Identificação do usuário';
$string['logintextbutton'] = 'Entrar';
$string['logo'] = 'Logo';
$string['maincolor'] = 'Cor principal';
$string['maincolordesc'] = 'Cor principal para blocos e rodapé.';
$string['maincoursepage'] = 'Página Principal do Curso';
$string['market'] = 'Bloco de Marketing';
$string['marketblockbordercolor'] = 'Cor da linha de borda do bloco de marketing';
$string['marketblockbordercolordesc'] = 'Definir a cor da linha de borda do bloco de marketing';
$string['marketblocksbackgroundcolor'] = 'Cor de fundo da região de blocos de marketing';
$string['marketblocksbackgroundcolordesc'] = 'Definir a cor de fundo da região de blocos de marketing';
$string['marketdesc'] = 'Adicionar html ao bloco de marketing (consulte o arquivo <a href="./../theme/adaptable/README.txt" target="_blank">README</a> para obter informações e dicas adicionais).';
$string['marketingbuilderdesc'] = 'Use a ferramenta abaixo para configurar seus blocos de marketing. Uma vez definidas, as configurações do bloco aparecerão mais abaixo na página.';
$string['marketingbuilderheading'] = 'Construtor de Layout de Bloco de Marketing';
$string['marketingsettings'] = 'Blocos de Marketing';
$string['marketingsettingsheading'] = 'Personalize os blocos de marketing que aparecem na página principal. Veja o layout <a href="./../theme/adaptable/pix/layout.png" target="_blank">aqui</a>';
$string['marketlayoutrow'] = 'Linha do Bloco de Marketing';
$string['marketlayoutrowdesc'] = 'Adicionar / definir o layout para a linha do bloco de marketing na página principal';
$string['menubkcolor'] = 'Cor de fundo do Menu Principal';
$string['menubkcolordesc'] = 'Definir a cor de fundo do Menu Principal';
$string['menubordercolor'] = 'Cor da borda inferior do Menu Principal';
$string['menubordercolordesc'] = 'Definir a cor da borda inferior do Menu Principal';
$string['menufontcolor'] = 'Cor da fonte do Menu Principal';
$string['menufontcolordesc'] = 'Define a cor do Menu Principal';
$string['menufontsize'] = 'Tamanho da fonte da barra de navegação';
$string['menufontsizedesc'] = 'Definir o tamanho da fonte usada na barra de navegação principal.';
$string['menuhovercolor'] = 'Cor do Menu Principal quando passar o mouse';
$string['menuhovercolordesc'] = 'Definir a cor do Menu Principal quando passar o mouse';
$string['menuoverrideprofilefield'] = 'Nome do campo de perfil personalizado';
$string['menusession'] = 'Armazenar detalhes de acesso na sessão';
$string['menusessionttl'] = 'Minutos para armazenar regras de acesso em sessão';
$string['menusessionttldesc'] = 'De quantos em quantos minutos as regras de acesso ao menu são atualizadas na sessão dos usuários.';
$string['menusettings'] = 'Menus do Cabeçalho';
$string['menusettingsheading'] = 'Personalizar os menus no cabeçalho acima do cabeçalho deste tema.';
$string['menusheadingvisibility'] = 'Configurações gerais para a visibilidade do Menu Superior';
$string['menusheadingvisibilitydesc'] = 'As configurações a seguir permitem controlar onde os menus são exibidos e, opcionalmente, permitir que os usuários personalizem suas configurações';
$string['menustitledesc'] = 'Os menus Ferramentas (na barra de navegação) e Superior (cabeçalho superior) podem ser restritos com base nos campos de perfil personalizados (opcional). Para adicionar uma restrição, digite o nome do campo do perfil e o valor esperado. A estrutura de menus segue o formato padrão do Moodle:
<pre>
Comunidade Moodle|https://moodle.org
-Suporte gratuito do Moodle|https://moodle.org/support
-Desenvolvimento do Moodle|https://moodle.org/development
--Moodle Docs|http: //docs.moodle.org|Moodle Docs
--German Moodle Docs | http: //docs.moodle.org/de|Documentação em alemão|de
Moodle.com|http://moodle.com/
</pre>';
$string['messagepopupbackground'] = 'Cor de fundo do pop-up de mensagens';
$string['messagepopupbackgrounddesc'] = 'Definir a cor de fundo do cabeçalho do pop-up de mensagens.';
$string['messagepopupcolor'] = 'Cor do texto do pop-up de mensagens';
$string['messagepopupcolordesc'] = 'Defina a cor do texto do cabeçalho do pop-up de mensagens.';
$string['messagingbackgroundcolor'] = 'Cor de fundo da janela principal de mensagens';
$string['messagingbackgroundcolordesc'] = 'Definir a cor de fundo da janela principal das mensagens.';
$string['mobilemenubkcolor'] = 'Cor de fundo do menu para dispositivos móveis';
$string['mobilemenubkcolordesc'] = 'Definir a cor de fundo do menu principal em dispositivos móveis (recolhido)';
$string['moodledocs'] = 'Link da Documentação do Moodle';
$string['moodledocsdesc'] = 'Mostrar o link da Documentação do Moodle no rodapé.';
$string['msgbadgecolor'] = 'Cor de fundo da mensagem do emblema';
$string['msgbadgecolordesc'] = 'Defina a cor de fundo do emblema/balão das mensagens no cabeçalho (exibe o número de mensagens não lidas)';
$string['myblogs'] = 'Meus Blogs';
$string['mycoursesmenulimit'] = 'Limite do Meu Menu de Cursos';
$string['mycoursesmenulimitdesc'] = 'Ajustar o número máximo de cursos que aparecem no menu suspenso Meus cursos. 0 mostrará todos os cursos.';
$string['mysites'] = 'Meus Cursos';
$string['mysitesdisabled'] = 'Desabilitar';
$string['mysitesexclude'] = 'Habilitar excluindo cursos ocultos';
$string['mysitesinclude'] = 'Habilitar incluindo cursos ocultos';
$string['mysitesmaxlength'] = 'Tamanho Máximo de Meus Cursos';
$string['mysitesmaxlengthdesc'] = 'Ajuste o tamanho máximo dos nomes dos cursos no menu Meus cursos para otimizar.';
$string['mysitesmenudisplay'] = 'Mostrar menu Meus Cursos';
$string['mysitesmenudisplaydesc'] = 'Escolha o texto a ser exibido para um item de menu e ao passar o mouse.';
$string['mysitesmenudisplayfullnamefullnameonhover'] = 'Mostrar título completo do curso e título completo ao passar o mouse.';
$string['mysitesmenudisplayfullnamenohover'] = 'Mostrar o nome completo do curso e nenhum texto ao passar o mouse.';
$string['mysitesmenudisplayshortcodefullnameonhover'] = 'Mostrar código curto e nome completo do curso ao passar o mouse.';
$string['mysitesmenudisplayshortcodenohover'] = 'Mostrar o nome breve do curso e nenhum texto ao passar o mouse.';
$string['mysitessortoverride'] = 'Habilitar a ordenação personalizada de Meus Cursos';
$string['mysitessortoverridefielddesc'] = 'Lista delimitada por vírgula de campos ou sequências de perfil a serem verificados nos códigos de acesso do curso';
$string['mysitessortoverrideoff'] = 'Mostrar todos os cursos inscritos em uma simples lista horizontal';
$string['mysitessortoverrideprofilefields'] = 'Mostrar os cursos encontrados nos campos de perfil na primeira lista, os outros no submenu';
$string['navbarcachetime'] = 'Tempo de cache da barra de navegação';
$string['navbarcachetimedesc'] = 'O número de minutos que a barra de navegação fica armazenada em cache.';
$string['navbardesc'] = 'Permite que você controle todos os elementos que aparecem na barra de navegação.';
$string['navbardisplayicons'] = 'Mostrar ícones';
$string['navbardisplayiconsdesc'] = 'Mostra os ícones ao lado dos títulos do menu principal';
$string['navbardisplaysubmenuarrow'] = 'Mostrar a seta do submenu';
$string['navbardisplaysubmenuarrowdesc'] = 'Exibir a seta do submenu (voltada para baixo) quando um cabeçalho de menu tiver opções de submenu.';
$string['navbardropdownborderradius'] = 'Arredondamento da borda do menu suspenso';
$string['navbardropdownborderradiusdesc'] = 'Controla o raio da borda dos menus suspensos (por exemplo, cantos arredondados).';
$string['navbardropdowntransitiontime'] = 'Tempo de transição da barra de navegação';
$string['navbardropdowntransitiontimedesc'] = 'Tempo de efeito de transição da barra de navegação em segundos. Fornece um efeito de animação de aparecimento gradual ao passar o mouse sobre um menu que possui submenus.';
$string['navbarmenusettingsdesc'] = 'Permitir que você adicione um menu na barra de navegação';
$string['navbarsettingsheading'] = 'Personalizar a barra de navegação';
$string['newmenu'] = 'Menu Suspenso do Topo';
$string['newmenudesc'] = 'Configurar os links a serem mostrados em um menu de cabeçalho superior.';
$string['newmenufield'] = 'Campo de perfil personalizado Nome=Valor (opcional)';
$string['newmenufielddesc'] = 'Adicionar regra de acesso usando o campo de perfil personalizado, por exemplo: usertype=student';
$string['newmenuheading'] = 'Menu Superior';
$string['newmenurequirelogin'] = 'Autenticação obrigatória';
$string['newmenurequirelogindesc'] = 'Se habilitado, este menu estará visível apenas para usuários autenticados';
$string['newmenutitle'] = 'Título do Menu Superior';
$string['newmenutitledefault'] = 'Menu';
$string['newmenutitledesc'] = 'O título da lista suspensa que aparecerá no cabeçalho do seu site';
$string['nextsection'] = 'Próxima seção';
$string['noenrolments'] = 'Nenhuma matrícula encontrada.';
$string['nostyle'] = 'Sem estilo';
$string['notanswered'] = 'Sem resposta';
$string['notattempted'] = 'Sem tentativa';
$string['notcontributed'] = 'Sem contribuição';
$string['notsubmitted'] = 'Sem envio';
$string['overdue'] = 'Em atraso';
$string['pageheaderheight'] = 'Altura do cabeçalho da página';
$string['pageheaderheightdesc'] = 'Define a altura da área principal do cabeçalho (contendo logotipo e títulos)';
$string['passwordplaceholder'] = 'Senha';
$string['pastcourses'] = 'Últimos cursos';
$string['people'] = 'Pessoas';
$string['piwikenabled'] = 'Habilitado';
$string['piwikenableddesc'] = 'Habilitar o monitorament do Matomo para o Moodle.';
$string['piwiksettings'] = 'Matomo (formalmente Piwik) Analytics';
$string['piwiksettingsdesc'] = 'Gere URL limpo para monitoramento avançado.';
$string['piwiksettingsheading'] = 'Configurar Matomo';
$string['piwiksiteid'] = 'ID do Site';
$string['piwiksiteiddesc'] = 'Digite o ID do seu site.';
$string['piwiksiteurl'] = 'URL do Matomo';
$string['piwiktrackadmindesc'] = 'Habilitar o monitoramento de usuários Admin (não recomendado)';
$string['pluginname'] = 'Adaptable';
$string['privacy:metadata'] = 'Adaptable não armazena nenhuma informação privada do usuário';
$string['properties'] = 'Importar / Exportar configurações';
$string['propertiesexport'] = 'Exportar propriedades como uma string JSON';
$string['propertiesproperty'] = 'Propriedade';
$string['propertiesreturn'] = 'Voltar';
$string['propertiessub'] = 'Configurações atuais do tema';
$string['propertiesvalue'] = 'Valor';
$string['putpropertiesadded'] = 'Adicionado:';
$string['putpropertieschanged'] = 'Alterado:';
$string['putpropertiesdesc'] = 'Cole a sequência JSON e \'Salvar alterações\'. Atenção! Não valida valores de configuração e executa um \'Limpar todos os caches\'.';
$string['putpropertiesfrom'] = 'de';
$string['putpropertiesheading'] = 'Importar configurações do tema';
$string['putpropertiesignored'] = 'Ignorado:';
$string['putpropertiesname'] = 'Importar propriedades';
$string['putpropertiesreportfiles'] = 'Lembre-se de enviar os seguintes arquivos para suas configurações:';
$string['putpropertiessettingsreport'] = 'Relatório de configurações:';
$string['putpropertiesunchanged'] = 'Sem alteração:';
$string['putpropertiesvalue'] = '->';
$string['putpropertyproperties'] = 'Propriedades';
$string['putpropertyreport'] = 'Relatório:';
$string['putpropertyversion'] = 'versão:';
$string['region-course-bottom-a'] = 'Página do curso região inferior 5';
$string['region-course-bottom-b'] = 'Página do curso região inferior 6';
$string['region-course-bottom-c'] = 'Página do curso região inferior 7';
$string['region-course-bottom-d'] = 'Página do curso região inferior 8';
$string['region-course-top-a'] = 'Página do curso região superior 1';
$string['region-course-top-b'] = 'Página do curso região superior 2';
$string['region-course-top-c'] = 'Página do curso região superior 3';
$string['region-course-top-d'] = 'Página do curso região superior 4';
$string['region-frnt-footer'] = 'Rodapé';
$string['region-frnt-market-a'] = 'Região 1 da página';
$string['region-frnt-market-b'] = 'Região 2 da página';
$string['region-frnt-market-c'] = 'Região 3 da página';
$string['region-frnt-market-d'] = 'Região 4 da página';
$string['region-frnt-market-e'] = 'Região 5 da página';
$string['region-frnt-market-f'] = 'Região 6 da página';
$string['region-frnt-market-g'] = 'Região 7 da página';
$string['region-frnt-market-h'] = 'Região 8 da página';
$string['region-frnt-market-i'] = 'Região 9 da página';
$string['region-frnt-market-j'] = 'Região 10 da página';
$string['region-frnt-market-k'] = 'Região 11 da página';
$string['region-frnt-market-l'] = 'Região 12 da página';
$string['region-frnt-market-m'] = 'Região 13 da página';
$string['region-frnt-market-n'] = 'Região 14 da página';
$string['region-frnt-market-o'] = 'Região 15 da página';
$string['region-frnt-market-p'] = 'Região 16 da página';
$string['region-frnt-market-q'] = 'Região 17 da página';
$string['region-frnt-market-r'] = 'Região 18 da página';
$string['region-frnt-market-s'] = 'Região 19 da página';
$string['region-frnt-market-t'] = 'Região 20 da página';
$string['region-middle'] = 'Meio';
$string['region-news-slider-a'] = 'Página do Curso - região do slider';
$string['region-side-post'] = 'Direita';
$string['region-side-pre'] = 'Esquerda';
$string['regionmaincolor'] = 'Cor da região principal';
$string['reopened'] = 'Reaberto';
$string['rightblocks'] = 'Lado direito';
$string['savebuttontext'] = 'Salvar mudanças';
$string['searchboxpadding'] = 'Preenchimento da caixa de busca';
$string['searchcourses'] = 'Buscar cursos';
$string['sectionheadingcolor'] = 'Cor de texto do título da Seção';
$string['sectionheadingcolordesc'] = 'Definir a cor de texto do título da Seção';
$string['selectionbackground'] = 'Cor de fundo do texto selecionado';
$string['selectionbackgrounddesc'] = 'Definir a cor de fundo do texto quando um texto for selecionado na tela.';
$string['selectiontext'] = 'Cor do texto selecionado';
$string['selectiontextdesc'] = 'Definir a cor do texto quando um texto for selecionado na tela.';
$string['settingsalertbox'] = 'Caixa de Alerta';
$string['settingsanalytics'] = 'Analytics';
$string['settingsblockicons'] = 'Ícones';
$string['settingsborders'] = 'Bordas';
$string['settingsbreadcrumbcolors'] = 'Cores da trilha de navegação';
$string['settingscolors'] = 'Cores';
$string['settingsfonts'] = 'Fontes';
$string['settingsfootercolors'] = 'Cores do rodapé';
$string['settingsforumheading'] = 'Fórum';
$string['settingsheadercolors'] = 'Cores do Cabeçalho';
$string['settingsinfoboxcolors'] = 'Cores da Caixa de Informação';
$string['settingsmaincolors'] = 'Cores Principais';
$string['settingsmarketingcolors'] = 'Cores do Bloco de Marketing';
$string['settingsmessagescolors'] = 'Cores do Popup de Mensagens';
$string['settingsnavbarcolors'] = 'Cores da barra de navegação (navbar)';
$string['settingstopicsweeks'] = 'Tópicos / Semanas';
$string['show'] = 'Mostrar';
$string['showblocks'] = 'Mostrar blocos';
$string['showfooterblocks'] = 'Mostrar blocos do rodapé';
$string['showfooterblocksdesc'] = 'Mostrar / esconder os quatro blocos configuráveis do rodapé';
$string['showyourprogress'] = 'Mostrar o rótulo \'Seu Progresso\'';
$string['side-post1'] = 'barra lateral no rodapé';
$string['sitetitle'] = 'Mostrar o título do site';
$string['sitetitlecoursesdisabled'] = 'Desabilitado - mostra somente os títulos dos cursos nas páginas dos cursos';
$string['sitetitlecoursesenabled'] = 'Habilitado - mostra o título do site e os títulos dos cursos nas páginas dos cursos';
$string['sitetitlecustom'] = 'Usar o título do site personalizado (digite na caixa de texto abaixo)';
$string['sitetitledefault'] = 'Usar o título do site Moodle (nome do site)';
$string['sitetitlemaxwidth'] = 'Largura Máxima do Título do Site';
$string['sitetitlemaxwidthdesc'] = 'Defina a largura máxima da área do título do site';
$string['sitetitleoff'] = 'Desabilitar o título do site';
$string['sitetitletext'] = 'Título do site';
$string['slider2h3bgcolor'] = 'Cor de Fundo do H3 do Slider 2';
$string['slider2h3bgcolordesc'] = 'Escolher a cor de fundo que você quer para a tag H3 do Slider 2';
$string['slider2h3color'] = 'Cor do Texto do H3 do Slider 2';
$string['slider2h3colordesc'] = 'Escolher a cor do texto que você quer para a tag H3 do Slider 2';
$string['slider2h4bgcolor'] = 'Cor de Fundo do H4 do Slider 2';
$string['slider2h4bgcolordesc'] = 'Escolher a cor de fundo que você quer para a tag H4 do Slider 2';
$string['slider2h4color'] = 'Cor do Texto do H4 do Slider 2';
$string['slider2h4colordesc'] = 'Escolher a cor do texto que você quer para a tag H4 do Slider 2';
$string['slidercaption'] = 'Subtítulo do Slider';
$string['slidercaptiondesc'] = 'Adicionar um subtítulo para seu slide';
$string['slidercount'] = 'Contador do Slider';
$string['slidercountdesc'] = 'Selecione quantos slides você deseja adicionar <strong>e clique em SALVAR</strong> para carregar os campos de entrada de dados';
$string['sliderenabled'] = 'Habilitar Slider';
$string['sliderenableddesc'] = 'Habilitar um Slider na parte superior da sua página principal';
$string['sliderfullscreen'] = 'Slider em tela cheia';
$string['sliderfullscreendesc'] = 'Marque esta caixa para mostrar o slider em tela cheia (largura de 100%)';
$string['sliderimage'] = 'Foto do Slider';
$string['sliderimagedesc'] = 'Adicionar uma imagem ao seu slide. O tamanho recomendado é 1600px x 400px ou superior.';
$string['slidermarginbottom'] = 'Margem abaixo do slider';
$string['slidermarginbottomdesc'] = 'Definir o tamanho da margem abaixo do slider.';
$string['slidermargintop'] = 'Margem acima do slider';
$string['slidermargintopdesc'] = 'Definir o tamanho da margem acima do slider.';
$string['slideroption2'] = 'Escolher o Tipo de Slider';
$string['slideroption2a'] = 'Cor de fundo da seta da opção 2 do slider';
$string['slideroption2adesc'] = 'Definir a cor de fundo da seta da opção 2 do slider';
$string['slideroption2colordesc'] = 'Definir uma cor de fundo para o texto de envio na opção de estilo do slider';
$string['slideroption2desc'] = 'Escolha o Tipo de Slider <strong>e clique em SALVAR</strong> para ver as configurações de cores do slider escolhido';
$string['slideroption2snippet'] = '<p>Exemplo de HTML para Legendas de Sliders: </p>
<pre>
<div class = "span6 col-sm-6">
<h3>Pixels e código feitos à mão </h3><h4>para a comunidade Moodle</h4>
<a href="#" class="submit"> Por favor, favorite nosso tema! </a>
</pre>';
$string['slideroption2submitcolor'] = 'Texto de envio do Slider 2';
$string['slideroption2submitcolordesc'] = 'Definir uma cor de fundo para o texto de envio na cor da opção 2 do estilo do controle deslizante';
$string['sliderstyle1'] = 'Slider estilo 1';
$string['sliderstyle2'] = 'Slider estilo 2';
$string['slidersubmitbgcolor'] = 'Slider 1 Enviar bg';
$string['slidersubmitbgcolordesc'] = 'Escolha a cor de fundo do botão de envio do Slider 1';
$string['slidersubmitcolor'] = 'Slider 1 - Texto do Envio';
$string['slidersubmitcolordesc'] = 'Escolha a cor do texto do botão de envio do Slider 1';
$string['slideshowdesc'] = 'Carregar as imagens, adicione os links e a descrição do carrossel na primeira página.';
$string['slideshowsettings'] = 'Slideshow';
$string['slideshowsettingsheading'] = 'Personalizar o carrossel na primeira página. Veja o layout <a href="./../theme/adaptable/pix/layout.png" target="_blank">aqui</a>';
$string['socialheading'] = 'Configurações do Ícone Social';
$string['socialicondesc'] = 'Definir um ícone FontAwesome, por exemplo: fa-facebook';
$string['socialiconlist'] = 'Lista de Ícones Sociais';
$string['socialiconlistdesc'] = 'Insira uma lista delimitada para configurar os ícones / links sociais que você precisa, usando o formato: url|title|icon';
$string['socialorsearch'] = 'Usa barra de busca ou icones de redes sociais';
$string['socialorsearchnone'] = 'Nenhum';
$string['socialorsearchsearch'] = 'Exibir caixa de pesquisa no cabeçalho';
$string['socialorsearchsocial'] = 'Exibir ícones sociais no cabeçalho';
$string['socialpaddingtop'] = 'Ajustar o preenchimento acima dos ícones sociais (altera a posição vertical)';
$string['socialsearchicon'] = 'Pesquisar Moodle';
$string['socialsearchicondesc'] = 'Habilite para colocar um link de pesquisa ao lado de ícones sociais (como usando a caixa de pesquisa de todo o site de desabilitações sociais)';
$string['socialsettings'] = 'Cabeçalho Social';
$string['socialsize'] = 'Definir o tamanho da fonte dos ícones sociais';
$string['socialsizemobile'] = 'Definir o tamanho da fonte dos ícones sociais no celular';
$string['socialtarget'] = 'Alvo de abertura do Link Sociais';
$string['socialtargetdesc'] = 'Como você gostaria que os links sociais fossem abertos (mesma ou nova janela)';
$string['socialtitledesc'] = 'Você pode desativar a caixa de pesquisa em todo o site e ativar os ícones / links sociais em seu lugar.
Para configurar os ícones, insira uma lista limitada no campo "Social Icon List" abaixo.
Isso deve estar no formato:

url | título | ícone

Por exemplo:
<pre>
https://example.com/course/search.php|Pesquisa Moodle | fa-search
https://facebook.com/|Facebook|fa-facebook-square
https://twitter.com/|Twitter|fa-twitter-square
https: //instagram.com | Instagram | fa-instagram
https: //example.com | Meu site | fa-globe
</ pre>
Para referência, você pode encontrar a lista completa de ícones <a href="https://fortawesome.github.io/Font-Awesome/icons/"> Fonte de Ícones AQUI </a>';
$string['socialwall'] = 'Mural Social';
$string['socialwallactionlinkcolor'] = 'Cor do link de ação';
$string['socialwallactionlinkcolordesc'] = 'A cor dos links de ação no Mural Social.';
$string['socialwallbackgroundcolor'] = 'Cor de Fundo';
$string['socialwallbackgroundcolordesc'] = 'A cor de fundo de um curso Painel Social.';
$string['socialwallbordercolor'] = 'Cor da borda';
$string['socialwallbordertopstyle'] = 'Estilo da borda';
$string['socialwallborderwidth'] = 'Largura da borda';
$string['socialwallheading'] = 'Configurações do Painel Social';
$string['socialwallsectionradius'] = 'Arredondamento da borda';
$string['standardview'] = 'Visualização padrão';
$string['submitted'] = 'Enviado';
$string['targetnewwindow'] = 'Nova janela';
$string['targetsamewindow'] = 'Mesma janela';
$string['thiscourse'] = 'Este curso';
$string['ticker'] = 'Avisos';
$string['tickerdefault'] = 'Não há notícias para exibir';
$string['tickerfullscreen'] = 'Largura da tela cheia';
$string['tickertextprofilefield'] = 'Campo de perfil personalizado Nome=Valor (opcional)';
$string['tickertextprofilefielddesc'] = 'Adicionar regra de acesso usando o campo de perfil personalizado, por exemplo: usertype=student';
$string['tickerwidth'] = 'Largura Fixa';
$string['tilesbordercolor'] = 'Tiles - Cor da borda das caixas do curso';
$string['tilesbordercolordesc'] = 'Tiles - Definir a cor da borda das caixas do curso';
$string['tilescontactstitle'] = 'Mostrar o papel dos contatos do curso';
$string['tilescontactstitledesc'] = 'Mostrar / ocultar o papel de um contato do curso. Se não for exibida, uma imagem será exibida antes de cada contato';
$string['tilesshowallcontacts'] = 'Mostrar todos os contatos do curso';
$string['tilesshowallcontactsdesc'] = 'Mostrar todos os contatos do curso ou apenas um';
$string['tilesshowcontacts'] = 'Mostrar contatos do curso';
$string['tilesshowcontactsdesc'] = 'Mostrar / esconder contatos do curso';
$string['toolsmenu'] = 'Menu Suspenso de Ferramentas';
$string['toolsmenu2'] = '2º menu de Ferramentas';
$string['toolsmenu2desc'] = 'Você pode configurar os links para serem exibidos em um menu de ferramentas. Cada linha consiste em algum texto de menu, um URL de link (opcional), um título de dica (opcional) e um código de idioma ou lista de códigos separados por vírgula (opcional, para exibir a linha apenas para usuários do idioma especificado), separados por caracteres de pipe. Você pode definir uma estrutura usando hífens. Por exemplo:
<pre>
Comunidade Moodle|https: //moodle.org
-Suporte gratuito do Moodle|https: //moodle.org/support
-Desenvolvimento do Moodle|https: //moodle.org/development
--Moodle Docs|http: //docs.moodle.org|Moodle Docs
--German Moodle Docs|http: //docs.moodle.org/de| Documentação em alemão |de
Moodle.com|http: //moodle.com/
</pre>';
$string['toolsmenudesc'] = 'Adicione um menu suspenso à barra de navegação principal';
$string['toolsmenufield'] = 'Campo de perfil personalizado Nome=Valor (opcional)';
$string['toolsmenufielddesc'] = 'Adicionar regra de acesso usando o campo de perfil personalizado, por exemplo: usertype=student';
$string['toolsmenuheading'] = 'Menu de Ferramentas';
$string['toolsmenuheadingdesc'] = 'Você pode configurar links para serem exibidos em um menu de ferramentas (na barra de navegação principal).
 O formato é semelhante ao utilizado para os menus personalizados do Moodle, mas permite adicionar fa icons aos itens de menu:
<pre>
<span class="fa-video-camera"></span>Gravar Tela | http: //google.co.uk | Gravar Tela
<span class="fa fa-picture-o"></span>ThinkStock | http: //google.co.uk | ThinkStock
<span class="fa-clock-o"></span>Ex. do Relógio | http: //google.co.uk | Ex. do Relógio
</pre> <br />';
$string['toolsmenulabel'] = 'Menu de Ferramentas';
$string['toolsmenulabel2'] = 'Ferramentas 2';
$string['toolsmenuscount'] = 'Número de Menus de ferramentas';
$string['toolsmenuscountdesc'] = 'Definir o número de menus de ferramentas que você deseja adicionar à barra de navegação principal';
$string['toolsmenutitle'] = 'Título do Menu de Ferramentas';
$string['toolsmenutitledefault'] = 'Ferramentas';
$string['toolsmenutitledesc'] = 'Adicione o título do menu que você gostaria de exibir na barra de navegação principal';
$string['topicsweeks'] = 'Formato do curso Tópicos/Semanas';
$string['topicsweeksdesc'] = 'Definir os estilos para o formato de curso Tópicos/Semanas';
$string['topmenufontsize'] = 'Tamanho da fonte do menu superior';
$string['topmenufontsizedesc'] = 'Ajustar o tamanho da fonte dos menus do top';
$string['topmenuscount'] = 'Número de menus no topo';
$string['topmenuscountdesc'] = 'Definir o número de menus principais que você deseja adicionar ao cabeçalho do tema';
$string['usernav'] = 'Cabeçalho do Usuário';
$string['usernavdesc'] = 'Permite controlar todos os elementos que aparecem na lista suspensa de navegação do usuário.';
$string['usernavheading'] = 'Personalizar o menu suspenso de navegação do usuário';
$string['viewselect'] = 'Padrão para visualização em tela cheia.';
$string['viewselectdesc'] = 'Tornar a visualização padrão do site em tela cheia (quando a opção de zoom estiver em uso).';
$string['xofyanswered'] = '{$a->completed} de {$a->participants} Respondido';
$string['xofyattempted'] = '{$a->completed} de {$a->participants} Tentativas';
$string['xofycontributed'] = '{$a->completed} de {$a->participants} Contribuído';
$string['xofysubmitted'] = '{$a->completed} de {$a->participants} enviado';
$string['xungraded'] = '{$a} não avaliado';
