<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'fr', version '3.5'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.blog.errorloadentries'] = 'Erreur lors du chargement des articles de blog.';
$string['addon.blog.showonlyyourentries'] = 'N\'afficher que vos articles';
$string['addon.calendar.calendarevent'] = 'Événement de calendrier';
$string['addon.calendar.calendarevents'] = 'Événements du calendrier';
$string['addon.calendar.calendarreminders'] = 'Rappels du calendrier';
$string['addon.calendar.currentmonth'] = 'Mois actuel';
$string['addon.calendar.defaultnotificationtime'] = 'Heure de notification par défaut';
$string['addon.calendar.errorloadevent'] = 'Erreur de chargement de l\'événement';
$string['addon.calendar.errorloadevents'] = 'Erreur de chargement des événements';
$string['addon.calendar.noevents'] = 'Il n\'y a pas d\'événement';
$string['addon.calendar.reminders'] = 'Rappels';
$string['addon.calendar.setnewreminder'] = 'Nouveau rappel';
$string['addon.competency.errornocompetenciesfound'] = 'Aucune compétence trouvée';
$string['addon.competency.nocompetencies'] = 'Aucune compétence';
$string['addon.coursecompletion.complete'] = 'Terminer';
$string['addon.coursecompletion.couldnotloadreport'] = 'Impossible de charger le rapport d\'achèvement de cours. Veuillez essayer plus tard.';
$string['addon.files.couldnotloadfiles'] = 'La liste des fichiers n\'a pas pu être chargée.';
$string['addon.files.emptyfilelist'] = 'Aucun fichier à afficher.';
$string['addon.files.erroruploadnotworking'] = 'Il n\'est actuellement pas possible de déposer des fichiers sur votre site.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Configurer les appareils';
$string['addon.messages.contactlistempty'] = 'La liste des contacts est vide';
$string['addon.messages.contactname'] = 'Nom du contact';
$string['addon.messages.deletemessage'] = 'Supprimer le message';
$string['addon.messages.deletemessageconfirmation'] = 'Voulez-vous vraiment supprimer ce message ? Il ne sera supprimé que de votre historique de messagerie et continuera d\'être visible par l\'utilisateur qui a envoyé ou reçu le message.';
$string['addon.messages.errordeletemessage'] = 'Erreur lors de la suppression du message.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Erreur lors de la récupération de contacts depuis le serveur.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Erreur lors de la récupération de discussions depuis le serveur.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Erreur lors de la récupération de messages depuis le serveur.';
$string['addon.messages.errorwhileretrievingusers'] = 'Error lors de la récupération des utilisateurs depuis le serveur.';
$string['addon.messages.messagenotsent'] = 'Ce message n\'a pas été envoyé. Veuillez essayer plus tard.';
$string['addon.messages.newmessages'] = 'Nouveaux messages';
$string['addon.messages.nousersfound'] = 'Aucun utilisateur trouvé';
$string['addon.messages.showdeletemessages'] = 'Afficher les messages supprimés';
$string['addon.messages.type_blocked'] = 'Bloqué';
$string['addon.messages.type_offline'] = 'Hors connexion';
$string['addon.messages.type_online'] = 'En ligne';
$string['addon.messages.type_search'] = 'Résultats de recherche';
$string['addon.messages.type_strangers'] = 'Autres';
$string['addon.messages.useentertosenddescdesktop'] = 'Si ce réglage est désactivé, vous pouvez utiliser Ctrl+Entrée pour envoyer le message.';
$string['addon.messages.useentertosenddescmac'] = 'Si ce réglage est désactivé, vous pouvez utiliser Cmd+Entrée pour envoyer le message.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Impossible d\'envoyer le(s) message(s) à la conversation {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Impossible d\'envoyer de message à l\'utilisateur {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Veuillez accepter les conditions d\'envoi.';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Vous ne pouvez ni ajouter ni modifier de données dans l\'app, car la déclaration de remise n\'a pas pu être récupérée depuis le site.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Certaines méthodes d\'évaluations ne sont pas encore supportées par l\'app et ne peuvent pas être modifiées.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Vous ne pouvez pas déposer de travail à évaluer dans l\'app, car il n\'est actuellement pas possible de récupérer la déclaration de remise.';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Vous ne pouvez ni ajouter ni modifier de données dans l\'app, car certains plugins ne permettent pas la modification.';
$string['addon.mod_assign.errorshowinginformation'] = 'Il n\'est pas possible d\'afficher les informations de remise.';
$string['addon.mod_assign.feedbacknotsupported'] = 'Le feedback n\'est pas supporté par l\'app et pourrait ne pas contenir la totalité des informations.';
$string['addon.mod_assign.gradenotsynced'] = 'Note non synchronisée';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Les participants qui n\'ont pas encore remis de travail ne sont pas affichés.';
$string['addon.mod_assign.submissionnotsupported'] = 'Le remise de documents n\'est pas supportée par l\'app et pourrait ne pas contenir la totalité des informations.';
$string['addon.mod_assign.syncblockedusercomponent'] = 'note utilisateur';
$string['addon.mod_assign.userwithid'] = 'Utilisateur d\'ID {{id}}';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'La note a été modifiée sur le site.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'Le travail remis par l\'utilisateur a été modifié sur le site.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Erreur lors de la connexion au chat.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Erreur lors de l\'obtention des données de chat.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Erreur lors de l\'obtention des usagers du chat.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Erreur lors de la récupération de messages sur le serveur.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Erreur lors de l\'envoi du message.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Vous devez être en ligne pour envoyer des messages.';
$string['addon.mod_chat.nosessionsfound'] = 'Aucune session trouvée';
$string['addon.mod_chat.showincompletesessions'] = 'Afficher les sessions incomplètes';
$string['addon.mod_choice.errorgetchoice'] = 'Erreur lors de l\'obtention des données du choix.';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}} % des participants ont choisi l\'option : {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Votre dernière réponse doit être synchronisée pour être inclue dans les résultats.';
$string['addon.mod_data.edittagsnotsupported'] = 'La modification des tags n\'est pas supportée par l\'app.';
$string['addon.mod_data.errorapproving'] = 'Erreur lors de l\'approbation ou de la désapprobation de la fiche.';
$string['addon.mod_data.errordeleting'] = 'Erreur lors de suppression de la fiche.';
$string['addon.mod_data.gettinglocation'] = 'Obtention de l\'emplacement';
$string['addon.mod_data.locationnotenabled'] = 'La localisation n\'est pas active';
$string['addon.mod_data.locationpermissiondenied'] = 'L\'autorisation d\'accès à votre localisation a été refusée.';
$string['addon.mod_data.mylocation'] = 'Mon emplacement';
$string['addon.mod_data.searchbytagsnotsupported'] = 'La recherche par tags n\'est pas supportée par l\'app.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Le feedback avec CAPTCHA ne peut pas être terminé hors connexion, ou s\'il n\'est pas configuré, ou si le serveur est arrêté.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Ce feedback a été enregistré pour être remis plus tard.';
$string['addon.mod_folder.emptyfilelist'] = 'Aucun fichier à afficher.';
$string['addon.mod_forum.errorgetforum'] = 'Erreur de récupération des données de forum.';
$string['addon.mod_forum.errorgetgroups'] = 'Erreur lors de l\'obtention des réglages de groupe.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Impossible de créer une nouvelle discussion dans tous les groupes.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Il n\'y a pas encore de discussion dans ce forum.';
$string['addon.mod_forum.group'] = 'Groupe';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} discussions';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} réponses';
$string['addon.mod_forum.refreshdiscussions'] = 'Rafraîchir les discussions';
$string['addon.mod_forum.refreshposts'] = 'Actualiser les messages';
$string['addon.mod_glossary.browsemode'] = 'Parcourir les articles';
$string['addon.mod_glossary.byalphabet'] = 'Alphabétiquement';
$string['addon.mod_glossary.byauthor'] = 'Grouper par auteur';
$string['addon.mod_glossary.bycategory'] = 'Grouper par catégorie';
$string['addon.mod_glossary.bynewestfirst'] = 'Les plus récents en premier';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Modifiés récemment';
$string['addon.mod_glossary.bysearch'] = 'Rechercher';
$string['addon.mod_glossary.cannoteditentry'] = 'Impossible de modifier l\'article';
$string['addon.mod_glossary.entriestobesynced'] = 'Articles à synchroniser';
$string['addon.mod_glossary.entrypendingapproval'] = 'Cet article est en attente d\'approbation';
$string['addon.mod_glossary.errorloadingentries'] = 'Une erreur est survenue lors du chargement des articles.';
$string['addon.mod_glossary.errorloadingentry'] = 'Une erreur est survenue lors du chargement de l\'article.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Une erreur est survenue lors du chargement du glossaire.';
$string['addon.mod_glossary.noentriesfound'] = 'Aucun article trouvé.';
$string['addon.mod_glossary.searchquery'] = 'Texte recherché';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Télécharger le fichier H5P';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Erreur lors de la récupération des données d\'activité H5P.';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'Le paquetage H5P n\'est pas téléchargé. Vous devez le télécharger avant de l\'utiliser.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'Le paquetage H5P a été modifié depuis son dernier téléchargement. Vous devez de nouveua le télécharger avant de l\'utiliser.';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'Vous devez être en ligne pour consulter le paquetage H5P.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Consulter la tentative {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Afficher la description';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Cette leçon comporte un saut vers une page aléatoire. Elle ne peut être effectuée dans l\'app avant d\'avoir été commencée dans un navigateur.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Cette tentative ne peut plus être relue, car une autre tentative a été terminée.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Cette tentative a été terminée localement.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Une tentative locale a été synchronisée. Voulez-vous la relire ?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}} : {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}} : {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Cette tentative a été terminée dans un navigateur.';
$string['addon.mod_lti.errorgetlti'] = 'Erreur lors de l\'obtention des données du module.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'L\'URL de lancement n\'est pas valide.';
$string['addon.mod_lti.launchactivity'] = 'Lancer l\'activité';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Erreur lors du chargement du contenu de la page.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Vous pouvez répondre à ce test dans l\'app, mais vous devrez envoyer la tentative avec un navigateur, pour les raisons suivantes :';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Cette tentative de test ne peut pas être envoyée pour les raisons suivantes :';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'La tentative n\'a pas été synchronisée depuis {{$a}}. Si entretemps vous avez continué cette tentative avec un autre appareil, vous risquez de perdre des données.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Une erreur est survenu lors de l\'enregistrement des réponses. Voulez-vous vraiment quitter le test ?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Ce test ne peut être effectué dans l\'app, car le comportement de question n\'est pas supporté par l\'app :';
$string['addon.mod_quiz.errordownloading'] = 'Erreur lors du téléchargement des données requises.';
$string['addon.mod_quiz.errorgetattempt'] = 'Erreur lors de l\'obtention des données de tentative.';
$string['addon.mod_quiz.errorgetquestions'] = 'Erreur lors de l\'obtention des questions.';
$string['addon.mod_quiz.errorgetquiz'] = 'Erreur lors de l\'obtention des données du test.';
$string['addon.mod_quiz.errorparsequestions'] = 'Une erreur est survenue lors de la lecture des questions. Veuillez faire ce test dans un navigateur web.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Ce test ne peut être effectué dans l\'app, car il ne contient que des questions qui ne sont pas supportées :';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Ce test ne peut être effectué dans l\'app, car il contient des règles d\'accès qui ne sont pas supportées :';
$string['addon.mod_quiz.errorsaveattempt'] = 'Une erreur est survenue lors de l\'enregistrement des données de tentative.';
$string['addon.mod_quiz.finishnotsynced'] = 'Terminé, mais pas synchronisé';
$string['addon.mod_quiz.opentoc'] = 'Ouvrir la navigation';
$string['addon.mod_quiz.warningattemptfinished'] = 'Tentative locale écartée, car elle a été terminée sur le site web ou n\'a pas été trouvée.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Certaines réponses faites hors connexion ont été écartées, car les questions ont été modifiées.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Tentative non terminée, car certaines réponses faites hors connexion ont été écartées. Veuillez revoir vos réponses et envoyer à nouveau votre tentative.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Ce test contient des questions qui ne sont pas supportées par l\'app :';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Erreur lors du chargement du contenu';
$string['addon.mod_resource.openthefile'] = 'Ouvrir le fichier';
$string['addon.mod_scorm.cannotcalculategrade'] = 'La note n\'a pas pu être calculée.';
$string['addon.mod_scorm.dataattemptshown'] = 'Ces données appartiennent à la tentative numéro {{number}}';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Une erreur est survenue lors de la création d\'une tentative hors connexion. Veuillez réessayer.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Erreur de téléchargement SCORM : « {{name}} »';
$string['addon.mod_scorm.errorgetscorm'] = 'Erreur de récupération des données SCORM.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Désolé, l\'application ne supporte que SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Le téléchargement des paquetages SCORM est désactivé. Veuillez contacter l\'administrateur de la plateforme.';
$string['addon.mod_scorm.errornovalidsco'] = 'Ce paquetage SCORM n\'a pas de SCO visible à charger.';
$string['addon.mod_scorm.errorpackagefile'] = 'L\'application ne supporte que les paquetages ZIP.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Une erreur est survenue lors de la synchronisation. Veuillez réessayer.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Cette tentative comporte des données non synchronisées.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Cette tentative ne peut pas être envoyée, car vous avez dépassé le nombre maximum de tentatives.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Ce paquetage SCORM n\'est pas téléchargé. Il sera téléchargé automatiquement dès que vous l\'ouvrirez.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Ce paquetage SCORM a été modifié depuis son dernier téléchargement. Il sera téléchargé automatiquement dès que vous l\'ouvrirez.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Des données locales de la tentative {{number}} ont été supprimées, car elles n\'ont pas pu être intégrées dans une nouvelle tentative.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Certaines tentatives n\'ont pas pu être synchronisées avec la plateforme, car la dernière tentative en ligne n\'est pas terminée. Veuillez d\'abord finir votre tentative en ligne.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Un problème est survenu lors de l\'envoi de votre consultation. Veuillez essayer à nouveau.';
$string['addon.mod_survey.errorgetsurvey'] = 'Erreur lors de l\'obtention des données de la consultation.';
$string['addon.mod_survey.results'] = 'Résultats';
$string['addon.mod_url.accessurl'] = 'Accéder à l\'URL';
$string['addon.mod_url.pointingtourl'] = 'URL vers laquelle cette ressource dirige.';
$string['addon.mod_wiki.errorloadingpage'] = 'Une erreur est survenue lors du chargement de la page.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Ce wiki n\'a pas encore de contenu.';
$string['addon.mod_wiki.gowikihome'] = 'Vers la première page du wiki';
$string['addon.mod_wiki.subwiki'] = 'Sous-wiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Le titre ne doit pas être vide';
$string['addon.mod_wiki.viewpage'] = 'Consulter la page';
$string['addon.mod_wiki.wikipage'] = 'Page wiki';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Stratégie d\'évaluation {{$a}} non supportée';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Veuillez indiquer un titre.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'Le travail remis a été modifié sur la plateforme.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'L\'évaluation a été modifiée sur la plateforme.';
$string['addon.notes.userwithid'] = 'Utilisateur d\'ID {{id}}';
$string['addon.notes.warningnotenotsent'] = 'Impossible d\'ajouter d\'annotation au cours {{course}}. {{error}}';
$string['addon.notifications.errorgetnotifications'] = 'Erreur lors de la récupération des notifications.';
$string['addon.notifications.notifications'] = 'Notifications';
$string['addon.notifications.playsound'] = 'Jouer le son';
$string['addon.notifications.therearentnotificationsyet'] = 'Aucune notification.';
$string['addon.storagemanager.deletecourse'] = 'Enlever de l\'appareil toutes les données du cours';
$string['addon.storagemanager.deletecourses'] = 'Télécharger les données de tous les cours';
$string['addon.storagemanager.deletedatafrom'] = 'Enlever de l\'appareil les données de {{name}}';
$string['addon.storagemanager.info'] = 'Le stockage de fichiers sur votre appareil rend le travail plus rapide et permet d\'utiliser l\'app hors ligne. Vous pouvez enlever des fichiers en toute sécurité pour libérer de la place de stockage.';
$string['addon.storagemanager.managestorage'] = 'Gérer le stockage';
$string['addon.storagemanager.storageused'] = 'Stockage utilisé :';
$string['appstoredescription'] = 'Remarque : cette app mobile officielle Moodle ne fonctionne qu\'avec les plateformes Moodle qui ont été configurées adéquatement dans ce but. Veuillez contacter l\'administrateur de votre plateforme Moodle si vous avez des difficultés à vous connecter.

Si votre plateforme Moodle a été configurée adéquatement, vous pouvez utiliser cette app pour :

– consulter le contenu de vos cours, même hors connexion ;
– recevoir des notifications instantanées des messages et autres événements ;
– trouver rapidement et contacter d\'autres personnes de vos cours ;
– déposer des images, sons, vidéos et autres fichiers à partir de votre appareil mobile ;
– consulter vos notes ;
– et bien plus encore !

Veuillez consulter http://docs.moodle.org/en/Mobile_app (en anglais) pour les informations les plus récentes.

Nous apprécions vraiment les bonnes critiques sur les fonctionnalités existantes ainsi que toute suggestion sur ce que vous aimeriez pouvoir faire avec cette app.';
$string['core.browser'] = 'Navigateur';
$string['core.cannotconnect'] = 'Connexion impossible';
$string['core.cannotconnecttrouble'] = 'Il y a des difficultés pour vous connecter à votre site.';
$string['core.cannotconnectverify'] = '<strong>Veuillez vérifier si l\'adresse est correcte.</strong>';
$string['core.cannotdownloadfiles'] = 'Le téléchargement de fichiers est désactivé. Veuillez contacter l\'administrateur de la plateforme.';
$string['core.cannotopeninapp'] = 'Ce fichier pourrait ne pas fonctionner comme attendu sur cet appareil. Voulez-vous quand même l\'ouvrir ?';
$string['core.cannotopeninappdownload'] = 'Ce fichier pourrait ne pas fonctionner comme attendu sur cet appareil. Voulez-vous quand même le télécharger ?';
$string['core.captureaudio'] = 'Enregistrer un son';
$string['core.capturedimage'] = 'Photo prise';
$string['core.captureimage'] = 'Prendre une photo';
$string['core.capturevideo'] = 'Enregistrer une vidéo';
$string['core.clearsearch'] = 'Effacer la recherche';
$string['core.clearstoreddata'] = 'Supprimer le stockage {{$a}} ?';
$string['core.clicktoseefull'] = 'Cliquer pour voir tout le contenu.';
$string['core.comments.commentsnotworking'] = 'Les commentaires ne peuvent pas être récupérés';
$string['core.comments.warningcommentsnotsent'] = 'Impossible de synchroniser les commentaires. {{error}}';
$string['core.confirmcanceledit'] = 'Voulez-vous vraiment quitter cette page ? Toutes vos modifications seront perdues.';
$string['core.confirmgotabroot'] = 'Voulez-vous vraiment revenir à {{name}} ?';
$string['core.confirmgotabrootdefault'] = 'Voulez-vous vraiment aller sur la page initiale de l\'onglet actuel ?';
$string['core.confirmleaveunknownchanges'] = 'Voulez-vous vraiment quitter cette page ? Les modifications non enregistrées seront perdues.';
$string['core.confirmloss'] = 'Vraiment ? Toutes les modifications seront perdues.';
$string['core.confirmopeninbrowser'] = 'Voulez-vous l\'ouvrir dans un navigateur ?';
$string['core.contenteditingsynced'] = 'Le contenu que vous modifiez a été synchronisé.';
$string['core.contentlinks.chooseaccount'] = 'Sélectionner un compte';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Sélectionner un compte avec lequel ouvrir le lien.';
$string['core.contentlinks.confirmurlothersite'] = 'Ce lien provient d\'un autre site. Voulez-vous l\'ouvrir ?';
$string['core.contentlinks.errornoactions'] = 'Impossible de trouver une action à effectuer avec ce lien.';
$string['core.contentlinks.errornosites'] = 'Impossible de trouver un site pour traiter ce lien.';
$string['core.contentlinks.errorredirectothersite'] = 'L\'URL de redirection ne peut pas pointer vers un site différent.';
$string['core.copiedtoclipboard'] = 'Texte copié dans le presse-papier';
$string['core.copytoclipboard'] = 'Copier dans le presse-papiers';
$string['core.course.activitydisabled'] = 'Votre institution a désactivé cette activité dans l\'App mobile.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Votre institution a installé un plugin qui n\'est pas encore supporté.';
$string['core.course.activitynotyetviewablesiteupgradeneeded'] = 'L\'installation Moodle de votre institution doit être mise à jour.';
$string['core.course.allsections'] = 'Toutes les sections';
$string['core.course.askadmintosupport'] = 'Veuillez contacter l\'administrateur de la plateforme et l\'informer que vous désirez utiliser cette activité avec l\'app mobile Moodle.';
$string['core.course.availablespace'] = 'Vous avez actuellement environ {{available}} de place disponible.';
$string['core.course.cannotdeletewhiledownloading'] = 'Les fichiers ne peuvent pas être supprimées lorsque l\'activité est en téléchargement. Veuillez attendre la fin du téléchargement pour terminer.';
$string['core.course.confirmdeletemodulefiles'] = 'Voulez-vous vraiment supprimer ces fichiers de module ?';
$string['core.course.confirmdeletestoreddata'] = 'Voulez-vous vraiment supprimer les données enregistrées ?';
$string['core.course.confirmdownload'] = 'Vous allez télécharger {{size}}. {{availableSpace}} Voulez-vous vraiment continuer ?';
$string['core.course.confirmdownloadunknownsize'] = 'Il n\'a pas été possible de calculer la taille du téléchargement. {{availableSpace}} Voulez-vous vraiment continuer ?';
$string['core.course.confirmdownloadzerosize'] = 'Vous allez télécharger{{availableSpace}} Voulez-vous vraiment continuer&nbsp;?';
$string['core.course.confirmlimiteddownload'] = 'Vous n\'êtes actuellement pas connecté au Wi-Fi.';
$string['core.course.confirmpartialdownloadsize'] = 'Vous allez télécharger <strong>au moins</strong> {{size}}. {{availableSpace}} Voulez-vous vraiment continuer ?';
$string['core.course.contents'] = 'Contenus';
$string['core.course.couldnotloadsectioncontent'] = 'Impossible de charger le contenu de la section. Veuillez essayer plus tard.';
$string['core.course.couldnotloadsections'] = 'Impossible de charger les sections. Veuillez essayer plus tard.';
$string['core.course.errordownloadingcourse'] = 'Erreur lors du téléchargement du cours.';
$string['core.course.errordownloadingsection'] = 'Erreur lors du téléchargement de la section.';
$string['core.course.errorgetmodule'] = 'Erreur lors de l\'obtention des données du module.';
$string['core.course.insufficientavailablequota'] = 'Votre appareil n\'a pas pu faire de la place pour enregistrer ce téléchargement. Il est possible qu\'il réserve de la place pour des mise à jour d\'apps et du système. Veuillez libérer de la place de stockage.';
$string['core.course.insufficientavailablespace'] = 'Vous essayez de télécharger {{size}}. Il ne restera alors plus assez de place sur votre appareil pour qu\'il fonctionne correctement.  Veuillez libérer de la place de stockage.';
$string['core.course.manualcompletionnotsynced'] = 'Achèvement manuel non synchronisé.';
$string['core.course.nocontentavailable'] = 'Aucun contenu disponible actuellement.';
$string['core.course.refreshcourse'] = 'Actualiser le cours';
$string['core.course.useactivityonbrowser'] = 'Vous pouvez continuer à l\'utiliser avec le navigateur de votre appareil.';
$string['core.course.warningmanualcompletionmodified'] = 'L\'achèvement manuel d\'une activité a été modifié sur le site.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Certains achèvement manuels hors ligne du cours « {{name}} » ont été supprimés. {{error}}';
$string['core.coursenogroups'] = 'Vous n\'êtes membre d\'aucun groupe dans ce cours.';
$string['core.courses.cannotretrievemorecategories'] = 'Les catégories de niveau plus grand que {{$a}} ne peuvent pas être chargées.';
$string['core.courses.confirmselfenrol'] = 'Voulez-vous vraiment vous inscrire dans ce cours ?';
$string['core.courses.downloadcourses'] = 'Télécharger les cours';
$string['core.courses.enrolme'] = 'M\'inscrire';
$string['core.courses.errorloadcategories'] = 'Une erreur est survenue lors du chargement des catégories.';
$string['core.courses.errorloadcourses'] = 'Une erreur est survenue lors du chargement des cours.';
$string['core.courses.errorloadplugins'] = 'Les plugins requis par ce cours n\'ont pas pu être chargés correctement. Veuillez recharger l\'app et essayer à nouveau.';
$string['core.courses.errorsearching'] = 'Une erreur est survenue durant la recherche.';
$string['core.courses.errorselfenrol'] = 'Une erreur est survenue durant l\'auto-inscription.';
$string['core.courses.filtermycourses'] = 'Filtrer mes cours';
$string['core.courses.notenrollable'] = 'Vous ne pouvez pas vous inscrire vous-même à ce cours.';
$string['core.courses.password'] = 'Clef d\'inscription';
$string['core.courses.searchcoursesadvice'] = 'Veuillez utiliser le bouton de recherche de cours pour accéder anonymement à des cours ou vous inscrire vous-même à des cours qui le permettent.';
$string['core.courses.selfenrolment'] = 'Auto-inscription';
$string['core.courses.totalcoursesearchresults'] = 'Nombre de cours : {{$a}}';
$string['core.currentdevice'] = 'Appareil actuel';
$string['core.datastoredoffline'] = 'Données stockées sur l\'appareil, car elles n\'ont pas pu être envoyées. Elles seront automatiquement envoyées ultérieurement.';
$string['core.deletedoffline'] = 'Supprimé en local';
$string['core.deleting'] = 'Suppression';
$string['core.desktop'] = 'Bureau';
$string['core.dfdaymonthyear'] = 'DD-MM-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'hh[:]mm';
$string['core.discard'] = 'Ignorer';
$string['core.dismiss'] = 'Rejeter';
$string['core.downloaded'] = 'Téléchargé';
$string['core.downloading'] = 'Téléchargement en cours';
$string['core.editor.hidetoolbar'] = 'Cacher la barre d\'outils§';
$string['core.editor.toggle'] = 'Activer/désactiver l\'éditeur';
$string['core.emptysplit'] = 'Cette page paraîtra vide si le panneau de gauche est vide ou en cours de chargement.';
$string['core.errorchangecompletion'] = 'Une erreur est survenue lors du changement de l\'état d\'achèvement. Veuillez essayer à nouveau.';
$string['core.errordeletefile'] = 'Erreur lors de la suppression du fichier. Veuillez essayer à nouveau.';
$string['core.errordownloading'] = 'Erreur lors du téléchargement du fichier.';
$string['core.errordownloadingsomefiles'] = 'Erreur lors du téléchargement de fichiers. Certains fichiers peuvent être manquants.';
$string['core.errorfileexistssamename'] = 'Un fichier de même nom est déjà présent.';
$string['core.errorinvalidform'] = 'Le formulaire comporte des données non valides. Veuillez vous assurer que tous les champs requis sont renseignés et que les données sont valides.';
$string['core.errorinvalidresponse'] = 'Réponse reçue non valide. Veuillez contacter l\'administrateur de votre plateforme si l\'erreur persiste.';
$string['core.errorloadingcontent'] = 'Erreur lors du chargement du contenu.';
$string['core.errorofflinedisabled'] = 'La consultation hors ligne est désactivée sur votre site. Vous devez vous connecter à Internet pour utiliser l\'app.';
$string['core.erroropenfilenoapp'] = 'Erreur lors de l\'ouverture du fichier : aucune app trouvée pour ouvrir ce type de fichier.';
$string['core.erroropenfilenoextension'] = 'Erreur lors de l\'ouverture du fichier : le nom du fichier n\'a pas d\'extension.';
$string['core.erroropenpopup'] = 'Cette activité essaie d\'ouvrir dans une fenêtre surgissante. Ceci n\'est pas supporté dans l\'app.';
$string['core.errorrenamefile'] = 'Erreur lors du renommage du fichier. Veuillez essayer à nouveau.';
$string['core.errorsomedatanotdownloaded'] = 'Si vous avez téléchargé cette activité, veuillez prendre note que certaines données ne sont pas téléchargées pour des raisons de performance et d\'utilisation de données.';
$string['core.errorsync'] = 'Une erreur est survenue lors de la synchronisation. Veuillez essayer plus tard.';
$string['core.errorsyncblocked'] = 'Ce {{$a}} ne peut pas être synchronisé maintenant en raison d\'une tâche en cours. Veuillez essayer plus tard. Si le problème persiste, veuillez relancer l\'app.';
$string['core.errorurlschemeinvalidscheme'] = 'Cette URL est censée être utilisée dans une autre app : {{$a}}';
$string['core.errorurlschemeinvalidsite'] = 'Cette URL ne peut pas être ouverte dans cette app.';
$string['core.filenameexist'] = 'Le nom de fichier existe déjà : {{$a}}';
$string['core.fileuploader.audio'] = 'Audio';
$string['core.fileuploader.camera'] = 'Caméra';
$string['core.fileuploader.confirmuploadfile'] = 'Vous allez déposer {{size}}. Voulez-vous vraiment continuer ?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Impossible de calculer la taille du fichier à dépasser. Voulez-vous malgré tout continuer ?';
$string['core.fileuploader.errorcapturingaudio'] = 'Erreur lors de l\'enregistrement audio.';
$string['core.fileuploader.errorcapturingimage'] = 'Erreur lors de la capture de l\'image.';
$string['core.fileuploader.errorcapturingvideo'] = 'Erreur lors de la capture vidéo.';
$string['core.fileuploader.errorgettingimagealbum'] = 'Erreur lors de la récupération de l\'image de l\'album.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Vous devez être en ligne pour déposer des fichiers.';
$string['core.fileuploader.errornoapp'] = 'Vous n\'avez pas d\'app installée pour effectuer cette action.';
$string['core.fileuploader.errorreadingfile'] = 'Erreur de lecture du fichier.';
$string['core.fileuploader.errorwhileuploading'] = 'Une erreur est survenue lors du dépôt du fichier.';
$string['core.fileuploader.file'] = 'Fichier';
$string['core.fileuploader.fileuploaded'] = 'Le fichier a été déposé.';
$string['core.fileuploader.maxbytesfile'] = 'Le fichier {{$a.file}} est trop gros. La taille maximale permise est de {{$a.size}}.';
$string['core.fileuploader.photoalbums'] = 'Albums photos';
$string['core.fileuploader.readingfile'] = 'Lecture du fichier';
$string['core.fileuploader.readingfileperc'] = 'Lecture du fichier : {{$a}} %';
$string['core.fileuploader.selectafile'] = 'Choisir un fichier';
$string['core.fileuploader.uploadafile'] = 'Déposer un fichier';
$string['core.fileuploader.uploading'] = 'Envoi';
$string['core.fileuploader.uploadingperc'] = 'Dépôt en cours : {{$a}} %';
$string['core.fileuploader.video'] = 'Vidéo';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.h5p.errorgetemail'] = 'Erreur lors de l\'obtention du courriel de l\'utilisateur. Veuillez vérifier votre connexion et réessayer.';
$string['core.h5p.offlinedisabled'] = 'Le site ne permet pas le téléchargement des paquet H5P.';
$string['core.h5p.play'] = 'Lire H5P';
$string['core.hasdatatosync'] = 'Ce {{$a}} a des données locales à synchroniser.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.image'] = 'Image';
$string['core.imageviewer'] = 'Lecteur d\'images';
$string['core.lastdownloaded'] = 'Dernier téléchargement';
$string['core.lastsync'] = 'Dernière synchronisation';
$string['core.loadmore'] = 'Charger plus';
$string['core.login.authenticating'] = 'Authentification';
$string['core.login.changepasswordbutton'] = 'Ouvrir la page de changement de mot de passe';
$string['core.login.changepasswordhelp'] = 'Si vous rencontrez des problèmes lors du changement de mot de passe, veuillez contacter l\'administrateur de votre site. Si vous ne savez pas comment le contacter, veuillez contacter votre enseignant.';
$string['core.login.changepasswordinstructions'] = 'Il n\'est pas possible de changer votre mot de passe dans l\'app. Veuillez cliquer le bouton ci-dessous pour ouvrir le site dans un navigateur, afin de changer votre mot de passe. N\'oubliez pas de fermer votre navigateur après avoir changé de mot de passe, car vous ne serez pas redirigé vers l\'app.';
$string['core.login.changepasswordlogoutinstructions'] = 'Si vous préférez changer de site ou vous déconnecter, veuillez cliquer le bouton ci-dessous&nbsp;:';
$string['core.login.changepasswordreconnectinstructions'] = 'Veuillez cliquer le bouton ci-dessous pour vous reconnecter au site. Si vous n\'avez pas réussi à changer votre mot de passe, vous retournerez à l\'écran précédent.';
$string['core.login.confirmdeletesite'] = 'Voulez-vous vraiment supprimer la plateforme {{sitename}} ?';
$string['core.login.connect'] = 'Connecter !';
$string['core.login.connecttomoodle'] = 'Connexion à Moodle';
$string['core.login.connecttomoodleapp'] = 'Vous tentez de vous connecter à un site Moodle standard. Veuillez télécharger l\'app Moodle officielle pour y accéder.';
$string['core.login.connecttoworkplaceapp'] = 'Vous tentez de vous connecter à un site Moodle Workplace. Veuillez télécharger l\'app Moodle Workplace pour y accéder.';
$string['core.login.contactyouradministrator'] = 'Veuillez contacter l\'administrateur de la plateforme pour plus d\'aide.';
$string['core.login.contactyouradministratorissue'] = 'Veuillez demander à l\'administrateur de la plateforme de vérifier l\'élément suivant : {{$a}}';
$string['core.login.credentialsdescription'] = 'Veuillez fournir votre nom d\'utilisateur et votre mot de passe pour vous connecter.';
$string['core.login.emailconfirmsentnoemail'] = '<p>Un courriel a été envoyé à votre adresse.</p><p>Il contient des instructions simples à effectuer pour terminer votre enregistrement.</p><p>Si vous rencontrez des difficultés, veuillez contacte l\'administrateur du site.';
$string['core.login.emailnotmatch'] = 'Les adresses de courriel ne correspondent pas';
$string['core.login.erroraccesscontrolalloworigin'] = 'La tentative d\'appel « Cross-Origin » que vous avez effectuée a été rejetée. Veuillez consulter https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = 'Une erreur est survenue lors de la suppression de la plateforme. Veuillez essayer plus tard.';
$string['core.login.errorexampleurl'] = 'L\'URL https://campus.example.edu est seulement un exemple d\'adresse et n\'est pas un véritable site. <strong>Veuillez indiquer l\'URL du site de votre école ou de votre institution.</strong>';
$string['core.login.errorqrnoscheme'] = 'Cette URL n\'est pas une URL de connexion valide.';
$string['core.login.errorupdatesite'] = 'Une erreur est survenue lors de la mise à jour du jeton du site.';
$string['core.login.faqcannotconnectanswer'] = 'Veuillez contacter votre administrateur';
$string['core.login.faqcannotconnectquestion'] = 'J\'ai saisi correctement l\'adresse de mon site mais ne peux toujours pas me connecter.';
$string['core.login.faqcannotfindmysiteanswer'] = 'Avez-vous saisi le nom correctement ? Il est aussi possible que votre site n\'est pas dans notre répertoire des sites publics. Si vous ne pouvez pas le trouver, saisissez directement l\'adresse de votre site.';
$string['core.login.faqcannotfindmysitequestion'] = 'Je ne trouve pas mon site.';
$string['core.login.faqsetupsiteanswer'] = 'Visitez le lien {{$link}} pour voir les différentes possibilités de créer votre propre site Moodle.';
$string['core.login.faqsetupsitelinktitle'] = 'Commencer.';
$string['core.login.faqsetupsitequestion'] = 'Je souhaite configurer mon propre site Moodle.';
$string['core.login.faqtestappanswer'] = 'Pour tester l\'app avec un site Moodle de démonstration, tapez « teacher » ou « student » dans le champ « Votre site » et tapotez le bouton « Connexion à votre site ».';
$string['core.login.faqtestappquestion'] = 'Je souhaite simplement tester l\'app ; comment faire ?';
$string['core.login.faqwhatisurlanswer'] = '<p>Chaque institution possède sa propre adresse unique ou URL pour son site Moodle. Pour trouver cette adresse :</p><ol><li>ouvrez un navigateur et allez sur la page de donnexion de votre Moodle ;</li><li>tout en haut de la page, dans la barre d\'adresse, est indiquée l\'URL de votre site Moodle, p.ex. « campus.exemple.fr » ;<br />{{$image}}</li><li>copiez l\'adresse (sans « /login » et ce qui suit), collez-la dans l\'app Moodle, puis tapotez « Connexion à votre site » ;</li><li>vous pouvez maintenant vous connecter à votre site avec votre nom d\'utilisateur et votre mot de passe.</li>';
$string['core.login.faqwhatisurlquestion'] = 'Quelle est l\'adresse de mon site ? Comment trouver son URL ?';
$string['core.login.faqwhereisqrcode'] = 'Où trouver le code QR ?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>Si votre institution l\'a activé, vous trouverez un code QR au bas de votre page de profil sur son site web.</p>{{$image}}';
$string['core.login.findyoursite'] = 'Trouver votre site';
$string['core.login.helpmelogin'] = 'Il y a plusieurs milliers de sites Moodle dans le monde. Cette app peut uniquement se connecter aux sites Moodle qui ont activé l\'accès via l\'app mobile.</p><p>Si vous n\'arrivez pas à vous connecter, veuillez contacter l\'administrateur de votre site Moodle et lui demander de lire <a href="https://docs.moodle.org/fr/App_Moodle" target="_blank">https://docs.moodle.org/fr/App_Moodle</a></p><p>Pour tester l\'app avec un site Moodle de démonstration, tapez <i>teacher</i> ou <i>student</i> dans le champ <i>Adresse du site</i> et tapotez sur le bouton <b>Connexion</b>.</p>';
$string['core.login.invalidaccount'] = 'Veuillez vérifier vos données de connexion ou demander à l\'administrateur de votre site de vérifier sa configuration.';
$string['core.login.invalidmoodleversion'] = '<p>Version de Moodle non valide. L\'app Moodle ne fonctionne qu\'avec Moodle {{$a}} ou une version ultérieure.</p>
<p>Veuillez contacter l\'administrateur de votre site et lui demander de mettre à jour son système Moodle.</p>';
$string['core.login.invalidsite'] = 'Cette URL n\'est pas valide.';
$string['core.login.invalidtime'] = 'Temps non valide';
$string['core.login.invalidvaluemax'] = 'La valeur maximale est {{$a}}';
$string['core.login.invalidvaluemin'] = 'La valeur minimale est {{$a}}';
$string['core.login.localmobileunexpectedresponse'] = 'La vérification des fonctionnalités additionnelles de Moodle Mobile a envoyé une réponse inattendue. Vous allez être connecté au moyen du service mobile standard.';
$string['core.login.loggedoutssodescription'] = 'Veuillez vous ré-authentifier en vous connectant au site au moyen d\'un navigateur web.';
$string['core.login.loginbutton'] = 'Se connecter';
$string['core.login.logininsiterequired'] = 'Vous devez vous connecter au moyen d\'un navigateur.';
$string['core.login.mobileservicesnotenabled'] = 'Les Services Moodle ne sont pas activés sur votre site. Veuillez contacter l\'administrateur de votre site si vous pensez qu\'ils devraient être activés.';
$string['core.login.notloggedin'] = 'Vous devez être connecté.';
$string['core.login.onboardingcreatemanagecourses'] = 'Créer & gérer vos cours';
$string['core.login.onboardingenrolmanagestudents'] = 'Inscrire & gérer vos étudiants';
$string['core.login.onboardinggetstarted'] = 'Commencer avec Moodle';
$string['core.login.onboardingialreadyhaveasite'] = 'J\'ai déjà un site Moodle';
$string['core.login.onboardingimalearner'] = 'Je suis un étudiant';
$string['core.login.onboardingimaneducator'] = 'Je suis un enseignant';
$string['core.login.onboardingineedasite'] = 'J\'ai besoin d\'un site Moodle';
$string['core.login.onboardingprovidefeedback'] = 'Fournir un feedback';
$string['core.login.onboardingtoconnect'] = 'Vous devez avoir un site Moodle pour utiliser l\'App Moodle';
$string['core.login.onboardingwelcome'] = 'Bienvenue dans l\'App Moodle !';
$string['core.login.or'] = 'OU';
$string['core.login.passwordrequired'] = 'Mot de passe requis';
$string['core.login.recaptchachallengeimage'] = 'Image reCAPTCHA';
$string['core.login.recaptchaexpired'] = 'Vérification échue. Veuillez de nouveau répondre à la question de sécurité.';
$string['core.login.recaptchaincorrect'] = 'La réponse à la question de sécurité est incorrecte.';
$string['core.login.reconnect'] = 'Reconnecter';
$string['core.login.reconnectdescription'] = 'Votre jeton d\'authentification est non valide ou échu. Veuillez vous reconnecter à la plateforme.';
$string['core.login.reconnectssodescription'] = 'Votre jeton d\'authentification est non valide ou échu. Veuillez vous reconnecter à la plateforme, en vous connectant dans un navigateur.';
$string['core.login.searchby'] = 'Rechercher par :';
$string['core.login.selectsite'] = 'Veuillez sélectionner votre site :';
$string['core.login.signupplugindisabled'] = '{{$a}} n\'est pas activée.';
$string['core.login.signuprequiredfieldnotsupported'] = 'Le formulaire d\'inscription comprend un champ personnalisé non supporté par l\'app. Veuillez créer votre compte au moyen d\'un navigateur.';
$string['core.login.siteaddress'] = 'Votre site';
$string['core.login.sitehasredirect'] = 'Votre site contient au moins une redirection HTTP. L\'app ne peut pas suivre les redirections. C\'est sans doute la raison empêche l\'app de se connecter à votre site.';
$string['core.login.siteinmaintenance'] = 'Votre site est en mode de maintenance';
$string['core.login.sitepolicynotagreederror'] = 'Règlement du site pas accepté.';
$string['core.login.siteurl'] = 'URL du site';
$string['core.login.siteurlrequired'] = 'URL du site requis, p. ex. <i>http://www.votre_moodle.fr</i> ou <i>https://www.votre_moodle.fr</i>';
$string['core.login.stillcantconnect'] = 'Toujours impossible de se connecter ?';
$string['core.login.usernamerequired'] = 'Nom d\'utilisateur requis';
$string['core.login.visitchangepassword'] = 'Voulez-vous vraiment visiter le site pour modifier votre mot de passe ?';
$string['core.login.webservicesnotenabled'] = 'Votre site web semble ne pas avoir activé les services Web. Veuillez contacter l\'administrateur de votre site pour de l\'aide.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Vous pouvez malgré tout vous connecter à votre site en saisissant votre nom d\'utilisateur et votre mot de passe.';
$string['core.login.yourenteredsite'] = 'Connexion à votre site';
$string['core.lostconnection'] = 'Votre jeton n\'est pas valide ou est échu. Veuillez vous reconnecter à la plateforme.';
$string['core.mainmenu.changesite'] = 'Changer de plateforme';
$string['core.mainmenu.website'] = 'Site web';
$string['core.needhelp'] = 'Avez-vous besoin d\'aide ?';
$string['core.networkerroriframemsg'] = 'Ce contenu n\'est pas disponible hors ligne. Veuillez vous connecter à Internet et ressayer.';
$string['core.networkerrormsg'] = 'Un problème est survenu lors de la connexion au site. Veuillez vérifier votre connexion et essayer à nouveau.';
$string['core.nooptionavailable'] = 'Aucune option disponible';
$string['core.nopasswordchangeforced'] = 'Vous ne pouvez pas continuer sans changer votre mot de passe.';
$string['core.nopermissionerror'] = 'Vous n\'avez pas l\'autorisation de faire cela';
$string['core.notapplicable'] = 'n/a';
$string['core.notsent'] = 'Pas envoyé';
$string['core.nummore'] = '{{$a}} de plus';
$string['core.openfile'] = 'Ouvrir le fichier';
$string['core.openfullimage'] = 'Cliquer ici pour afficher l\'image en pleine grandeur';
$string['core.openinbrowser'] = 'Ouvrir dans le navigateur';
$string['core.openmodinbrowser'] = 'Ouvrir {{$a}} dans le navigateur';
$string['core.percentagenumber'] = '{{$a}} %';
$string['core.pulltorefresh'] = 'Tirer pour actualiser';
$string['core.qrscanner'] = 'Lecteur code QR';
$string['core.question.cannotdeterminestatus'] = 'Impossible de déterminer le statut';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'Votre site ne supporte pas encore la possibilité de joindre des fichiers aux réponses.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'Votre site ne supporte pas encore la modification des fichiers intégrés.';
$string['core.question.errorquestionnotsupported'] = 'Ce type de question n\'est pas supporté par l\'app : {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Tapoter pour sélectionner, puis tapoter pour déposer.';
$string['core.question.questionmessage'] = 'Question {{$a}} : {{$b}}';
$string['core.redirectingtosite'] = 'Vous allez être redirigé vers le site.';
$string['core.removefiles'] = 'Supprimer les fichiers {{$a}}';
$string['core.requireduserdatamissing'] = 'Il manque certaines données au profil de cet utilisateur. Veuillez compléter ces données dans votre plateforme et essayer à nouveau.<br />{{$a}}';
$string['core.retry'] = 'Essayer à nouveau';
$string['core.scanqr'] = 'Lire le code QR';
$string['core.searching'] = 'Recherche';
$string['core.settings.about'] = 'À propos';
$string['core.settings.appsettings'] = 'Réglages de l\'app';
$string['core.settings.appversion'] = 'Version de l\'app';
$string['core.settings.cannotsyncloggedout'] = 'Ce site ne peut pas être synchronisé, car vous en êtes déconnecté. Veuillez essayer à nouveau lorsque vous y serez connecté.';
$string['core.settings.cannotsyncoffline'] = 'Impossible de synchroniser hors connexion.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Impossible de synchroniser car les réglages ne permettent la synchronisation que lorsque une connexion Wi-Fi est établie. Veuillez vous connecter à un réseau Wi-Fi.';
$string['core.settings.colorscheme'] = 'Thème de couleur';
$string['core.settings.colorscheme-auto'] = 'Automatique (basé sur les réglages système)';
$string['core.settings.colorscheme-dark'] = 'Sombre';
$string['core.settings.colorscheme-light'] = 'Clair';
$string['core.settings.compilationinfo'] = 'Info de compilation';
$string['core.settings.copyinfo'] = 'Copier les infos de l\'appareil dans le presse-papier';
$string['core.settings.cordovadevicemodel'] = 'Modèle Cordova Device';
$string['core.settings.cordovadeviceosversion'] = 'Version OS Cordova Device';
$string['core.settings.cordovadeviceplatform'] = 'Plateforme Cordova Device';
$string['core.settings.cordovadeviceuuid'] = 'UUID Cordova Device';
$string['core.settings.cordovaversion'] = 'Version Cordova';
$string['core.settings.debugdisplaydescription'] = 'Si ce réglage est activé, les dialogues d\'erreur afficheront plus d\'informations sur l\'erreur, dans la mesure du possible.';
$string['core.settings.deletesitefiles'] = 'Voulez-vous vraiment supprimer les fichiers téléchargés depuis le site « {{sitename}} » ?';
$string['core.settings.deletesitefilestitle'] = 'Supprimer les fichiers du site';
$string['core.settings.deviceinfo'] = 'Info sur l\'appareil';
$string['core.settings.deviceos'] = 'Système d\'exploitation de l\'appareil';
$string['core.settings.displayformat'] = 'Format d\'affichage';
$string['core.settings.enabledownloadsection'] = 'Activer le téléchargement des sections';
$string['core.settings.enablefirebaseanalytics'] = 'Activer les statistiques Firebase';
$string['core.settings.enablefirebaseanalyticsdescription'] = 'Si ce réglage est activé, l\'app collectera des données d\'usage anonymes.';
$string['core.settings.enablerichtexteditor'] = 'Activer l\'éditeur WYSIWYG';
$string['core.settings.enablerichtexteditordescription'] = 'Si ce réglage est activé, un éditeur WYSIWYG sera affiché aux emplacements permis.';
$string['core.settings.enablesyncwifi'] = 'Ne permettre la synchronisation que sur Wi-Fi';
$string['core.settings.entriesincache'] = '{{$a}} éléments en cache';
$string['core.settings.errordeletesitefiles'] = 'Erreur lors de la suppression des fichiers du site.';
$string['core.settings.errorsyncsite'] = 'Erreur de synchronisation des données. Veuillez vérifier votre connexion internet et essayer plus tard.';
$string['core.settings.estimatedfreespace'] = 'Espace libre estimé';
$string['core.settings.filesystemroot'] = 'Racine du système de fichiers';
$string['core.settings.fontsize'] = 'Corps du texte';
$string['core.settings.forcedsetting'] = 'Ce réglage est imposé par la configuration de votre site.';
$string['core.settings.localnotifavailable'] = 'Notifications locales disponibles';
$string['core.settings.locationhref'] = 'URL webview';
$string['core.settings.navigatorlanguage'] = 'Langue du navigateur';
$string['core.settings.navigatoruseragent'] = 'UserAgent du navigateur';
$string['core.settings.networkstatus'] = 'Statut de la connexion internet';
$string['core.settings.opensourcelicenses'] = 'Licences Open Source';
$string['core.settings.privacypolicy'] = 'Politique de confidentialité';
$string['core.settings.publisher'] = 'Éditeur';
$string['core.settings.pushid'] = 'Identifiant de notifications push';
$string['core.settings.reportinbackground'] = 'Annoncer les erreurs automatiquement';
$string['core.settings.screen'] = 'Infos écran';
$string['core.settings.showdownloadoptions'] = 'Afficher les options de téléchargement';
$string['core.settings.siteinfo'] = 'Infos site';
$string['core.settings.spaceusage'] = 'Espace utilisé';
$string['core.settings.spaceusagehelp'] = 'La suppression des infos enregistrées du site supprimera toutes les données hors ligne du site. Ces infos vous permettent d\'utiliser l\'app lorsque vous êtes hors ligne.';
$string['core.settings.synchronization'] = 'Synchronisation';
$string['core.settings.synchronizenow'] = 'Synchroniser maintenant';
$string['core.settings.synchronizenowhelp'] = 'La synchronisation envoie au site les modifications en attente et les données de toutes les activités hors ligne enregistrées sur l\'appareil et synchronise d\'autres données telles que les messages et les notifications.';
$string['core.settings.syncsettings'] = 'Réglages de synchronisation';
$string['core.settings.wificonnection'] = 'Connexion WiFi';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Veuillez choisir un compte dans lequel enregistrer le fichier.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Un fichier de ce nom existe déjà. Voulez-vous remplacer le fichier existant ou le renommer en « {{$a}} » ?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Aucun site n\'est enregistré. Veuillez ajouter un site avant de partager un fichier avec l\'app.';
$string['core.sharedfiles.nosharedfiles'] = 'Il n\'y a pas de fichier partagé sur ce site.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Il n\'y a pas de fichier à déposer ici. Si vous voulez déposer un fichier à partir d\'une autre app, localiser le fichier et tapoter « Ouvrir dans ».';
$string['core.sharedfiles.rename'] = 'Renommer';
$string['core.sharedfiles.replace'] = 'Remplacer';
$string['core.sharedfiles.sharedfiles'] = 'Fichiers partagés';
$string['core.sharedfiles.successstorefile'] = 'Fichier enregistré. Vous pouvez maintenant le sélectionner pour le déposer dans vos fichiers privés ou le joindre à des activités.';
$string['core.sizetb'] = 'To';
$string['core.sorry'] = 'Désolé…';
$string['core.storingfiles'] = 'Stockage des fichiers';
$string['core.tablet'] = 'Tablette';
$string['core.tag.errorareanotsupported'] = 'Cette zone de tag n\'est pas supportée par l\'app.';
$string['core.tag.warningareasnotsupported'] = 'Certaines zones de tag ne sont pas affichées, car elles ne sont pas supportées par l\'app.';
$string['core.thereisdatatosync'] = 'Il y a des {{$a}} locales à synchroniser.';
$string['core.tryagain'] = 'Essayer encore';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Aïe !';
$string['core.unexpectederror'] = 'Erreur inattendue. Veuillez fermer et rouvrir l\'app et réessayer.';
$string['core.unicodenotsupported'] = 'Certains emojis ne sont pas supportés sur ce site. Ils seront supprimés avant l\'envoi.';
$string['core.unicodenotsupportedcleanerror'] = 'Un texte vide a été rencontré lors du nettoyage des caractères Unicode.';
$string['core.unknown'] = 'Inconnu';
$string['core.unzipping'] = 'Décompression';
$string['core.updaterequired'] = 'Mise à jour de l\'app requise';
$string['core.updaterequireddesc'] = 'Veuillez mettre à jour l\'app à la versiopn {{$a}}';
$string['core.user.contact'] = 'Contact';
$string['core.user.detailsnotavailable'] = 'Vous n\'avez pas accès aux informations de cet utilisateur.';
$string['core.user.errorloaduser'] = 'Erreur lors du chargement de l\'utilisateur.';
$string['core.user.sendemail'] = 'Courriel';
$string['core.viewcode'] = 'Afficher le code';
$string['core.vieweditor'] = 'Afficher l\'éditeur';
$string['core.viewembeddedcontent'] = 'Afficher le contenu intégré';
$string['core.warningofflinedatadeleted'] = 'Des données locales de {{component}} « {{name}} » ont été supprimées. {{error}}';
$string['core.whoissiteadmin'] = 'Les administrateurs du site sont des personnes qui gèrent la plateforme Moodle de votre institution (école/université/entreprise). Si vous ne savez pas comment les contacter, demandez à vos enseignants/formateurs.';
$string['core.whoops'] = 'Oups !';
$string['core.whyisthishappening'] = 'Que se passe-t-il ?';
$string['core.wsfunctionnotavailable'] = 'Le service web n\'est pas disponible.';
$string['core.youreoffline'] = 'Vous êtes hors ligne';
$string['core.youreonline'] = 'Vous êtes de nouveau en ligne';
$string['pluginname'] = 'Chaînes de caractères de Moodle Mobile';
