<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'eu', version '3.5'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.blog.errorloadentries'] = 'Errorea blogeko sarrerak kargatzean.';
$string['addon.blog.showonlyyourentries'] = 'Zure sarrerak soilik erakutsi';
$string['addon.calendar.calendarevent'] = 'Egutegiko ekitaldia';
$string['addon.calendar.calendarevents'] = 'Egutegiko ekitaldiak';
$string['addon.calendar.calendarreminders'] = 'Egutegiko gogorarazpenak';
$string['addon.calendar.currentmonth'] = 'Hilabete honetan';
$string['addon.calendar.defaultnotificationtime'] = 'Berezko jakinarazpen-ordua';
$string['addon.calendar.errorloadevent'] = 'Errorea gertakaria kargatzean.';
$string['addon.calendar.errorloadevents'] = 'Errorea gertakariak kargatzean.';
$string['addon.calendar.noevents'] = 'Ez dago ekitaldirik';
$string['addon.calendar.reminders'] = 'Gogorarazpenak';
$string['addon.calendar.setnewreminder'] = 'Zehaztu gogorarazpen berri bat';
$string['addon.competency.errornocompetenciesfound'] = 'Ez da gaitasunik aurkitu';
$string['addon.competency.nocompetencies'] = 'Gaitasunik ez';
$string['addon.coursecompletion.complete'] = 'Osoa';
$string['addon.coursecompletion.couldnotloadreport'] = 'Ezin izan da ikastaro-osaketaren txostena kargatu. Mesedez saiatu beranduago.';
$string['addon.files.couldnotloadfiles'] = 'Ezin izan da fitxategien zerrenda kargatu.';
$string['addon.files.emptyfilelist'] = 'Ez dago fitxategirik erakusteko.';
$string['addon.files.erroruploadnotworking'] = 'Zoritxarrez une honetan ezin dira fitxategiak zure gunera igo.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Gailuak konfiguratu';
$string['addon.messages.contactlistempty'] = 'Kontaktu zerrenda hutsik dago';
$string['addon.messages.contactname'] = 'Kontaktuaren izena';
$string['addon.messages.deletemessage'] = 'Ezabatu mezua';
$string['addon.messages.deletemessageconfirmation'] = 'Ziur zaude mezu hau ezabatu nahi duzula? Mezua zure mezuen historiatik baino ez da ezabatuko eta bidali edo jaso zuten beste erabiltzaileek oraindik ikusgai izango dute.';
$string['addon.messages.errordeletemessage'] = 'Errorea mezua ezabatzean.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Errore bat gertatu da kontaktuak zerbitzaritik jasotzean.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Errore bat gertatu da elkarrizketak zerbitzaritik jasotzean.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Errore bat gertatu da mezuak zerbitzaritik jasotzean.';
$string['addon.messages.errorwhileretrievingusers'] = 'Errorea erabiltzaileak zerbitzaritik jasotzerakoan';
$string['addon.messages.messagenotsent'] = 'Mezua ez da bidali. Mesedez, saiatu beranduago.';
$string['addon.messages.newmessages'] = 'Mezu beriak';
$string['addon.messages.nousersfound'] = 'Ez da erabiltzailerik aurkitu';
$string['addon.messages.showdeletemessages'] = 'Erakutsi ezabatutako mezuak';
$string['addon.messages.type_blocked'] = 'Blokeatuta';
$string['addon.messages.type_offline'] = 'Lineaz kanpo';
$string['addon.messages.type_online'] = 'Online';
$string['addon.messages.type_search'] = 'Bilaketaren emaitzak';
$string['addon.messages.type_strangers'] = 'Beste batzuk';
$string['addon.messages.useentertosenddescdesktop'] = 'Desgaituz gero, Ctrl+Enter erabili dezakezu mezua bidaltzeko.';
$string['addon.messages.useentertosenddescmac'] = 'Desgaituz gero, Cmd+Enter erabili dezakezu mezua bidaltzeko.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Ezin izan d(ir)a mezua(k) {{conversation}} elkarrizketara bidali. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Ezin izan d(ir)a mezua(k) bidali {{user}} erabiltzaileari. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Mesedez onartu bidalketa-adierazpena.';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Ezin duzu bidalketa aplikazioan gehitu edo editatu ezin izan dugulako guneko bidalketa-adierazpena berreskuratu.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Kalifikazio-metodo batzuk oraindik ez daude aplikazioan onartuta eta ezin dira aldatu .';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Ezin duzu aplikazioan bidalketa bat egin ezin izan dugulako guneko bidalketa-adierazpena berreskuratu.';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Ezin duzu bidalketa aplikazioan gehitu edo editatu gehigarri batzuk ez dutelako editatzea onartzen.';
$string['addon.mod_assign.errorshowinginformation'] = 'Ezin da bidalketaren informazioa erakutsi.';
$string['addon.mod_assign.feedbacknotsupported'] = 'Feedback hau ez da aplikazioan onartzen eta baliteke informazio guztia jasota ez egotea.';
$string['addon.mod_assign.gradenotsynced'] = 'Kalifikazioa ez da sinkronizatu';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Bidalketarik egin ez duten ikasleak ez dira erakusten.';
$string['addon.mod_assign.submissionnotsupported'] = 'Bidalketa hau ez da aplikazioan onartzen eta baliteke informazio guztia jasota ez egotea.';
$string['addon.mod_assign.syncblockedusercomponent'] = 'erabiltzaile-kalifikazioa';
$string['addon.mod_assign.userwithid'] = '{{id}} IDa duen erabiltzailea';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'Bidalketaren kalifikazioa gunean aldatua izan da.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'Erabiltzailearen bidalketa gunean aldatua izan da.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Errorea txatera konektatzean.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Errorea txataren datuak eskuratzean.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Errorea txataren erabiltzaileak eskuratzean.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Errore bat gertatu da zerbitzaritik mezuak ekartzean.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Errorea mezua bidaltzean.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Online egon behar zara mezuak bidali ahal izateko.';
$string['addon.mod_chat.nosessionsfound'] = 'Ez da saiorik aurkitu';
$string['addon.mod_chat.showincompletesessions'] = 'Erakutsi osatu gabeko saioak';
$string['addon.mod_choice.errorgetchoice'] = 'Errorea kontsultaren datuak eskuratzean.';
$string['addon.mod_choice.responsesresultgraphdescription'] = 'Erabiltzaileen %{{number}}-ak aukera hau aukeratu zuten: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Zure azken erantzuna sinkronizatu behar da emaitzetan kontuan hartu ahal izateko.';
$string['addon.mod_data.edittagsnotsupported'] = 'Sentitzen dugu, etiketak ezin dira aplikaziotik editatu.';
$string['addon.mod_data.errorapproving'] = 'Errorea sarrera onartu edo baztertzean.';
$string['addon.mod_data.errordeleting'] = 'Errore bat gertatu da sarrera ezabatzean.';
$string['addon.mod_data.gettinglocation'] = 'Kokapena eskuratzen';
$string['addon.mod_data.locationnotenabled'] = 'Kokapena ez dago gaituta';
$string['addon.mod_data.locationpermissiondenied'] = 'Zure kokapena eskuratzeko baimena ukatua izan da.';
$string['addon.mod_data.mylocation'] = 'Nire kokapena';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Sentitzen dugu, aplikazioan ezin da etiketen bidezko bilaketak egin.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'CAPTCHA-dun feedback-ak ezin dira lineaz kanpo osatu, ezta konfiguratuta ez badaude edo zerbitzaria eskuragarri ez badago ere.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Feedback hau beranduago bidaltzeko gorde da.';
$string['addon.mod_folder.emptyfilelist'] = 'Ez dago fitxategirik erakusteko.';
$string['addon.mod_forum.errorgetforum'] = 'Errorea foroko datuak jasotzean.';
$string['addon.mod_forum.errorgetgroups'] = 'Errorea talde-ezarpenak eskuratzean.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Ezin izan da sortu eztabaida berria talde guztietan.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Oraindik ez dago elkarrizketarik foro honetan.';
$string['addon.mod_forum.group'] = 'Taldea';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} elkarrizketa';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} erantzun';
$string['addon.mod_forum.refreshdiscussions'] = 'Freskatu eztabaidak';
$string['addon.mod_forum.refreshposts'] = 'Freskatu eztabaidetako mezuak';
$string['addon.mod_glossary.browsemode'] = 'Aztertu sarrerak';
$string['addon.mod_glossary.byalphabet'] = 'Alfabetikoki';
$string['addon.mod_glossary.byauthor'] = 'Taldekatu egilearen arabera';
$string['addon.mod_glossary.bycategory'] = 'Taldekatu kategoriaren arabera';
$string['addon.mod_glossary.bynewestfirst'] = 'Berrienak lehenago';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Duela gutxi eguneratuak';
$string['addon.mod_glossary.bysearch'] = 'Bilatu';
$string['addon.mod_glossary.cannoteditentry'] = 'Ezin da sarrera editatu';
$string['addon.mod_glossary.entriestobesynced'] = 'Sinkronizatu beharreko sarrerak';
$string['addon.mod_glossary.entrypendingapproval'] = 'Sarrera hau onarpenaren zain dago.';
$string['addon.mod_glossary.errorloadingentries'] = 'Errore bat gertatu da sarrerak kargatzean.';
$string['addon.mod_glossary.errorloadingentry'] = 'Errore bat gertatu da sarrera kargatzean.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Errore bat gertatu da glosategia kargatzean.';
$string['addon.mod_glossary.noentriesfound'] = 'Ez da sarrerarik aurkitu';
$string['addon.mod_glossary.searchquery'] = 'Egin bilaketa';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Jaitsi H5P fitxategia';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Errorea H5P jardueraren datuak eskuratzean.';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'H5P paketea ez dago deskargatuta. Erabili ahal izateko aurretik jaitsi beharko duzu.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'H5P paketea aldatua izan da azkenengoz jaitsi zenuenetik. Erabili ahal izateko aurretik berriz jaitsi beharko duzu.';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'Online egon behar duzu H5P paketea ikusi ahal izateko.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Ikusi {{$a}} saiakera';
$string['addon.mod_imscp.showmoduledescription'] = 'Deskribapena erakutsi';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Ikasgai honek ausazko eduki-orri baterako jauzia dauka. Ezin da aplikazioan saiakerarik egin aurretik web nabigatzailean hasi ezean.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Saiakera hau ezin da berrikusi dagoeneko beste saiakera bat amaitu delako.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Saiakera hau lineaz kanpo bukatu zen.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Lineaz kanpoko saiakera bat sinkronizatu da. Berrikusi nahi duzu?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Saiakera gunean bukatu zen.';
$string['addon.mod_lti.errorgetlti'] = 'Errorea moduluaren datuak eskuratzean.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'Hasierako URLa ez da baliagarria';
$string['addon.mod_lti.launchactivity'] = 'Abiarazi jarduera';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Errorea orriaren edukia kargatzean.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Galdetegi hau erantzuten saiatu zaitezke, baina saiakera nabigatzaile batetik bidali beharko duzu hurrengo arrazoiak direla eta:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Galdetegi honen saiakera ezin da bidali hurrengo arrazoiak direla eta:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Saiakera hau ez da {{$a}}-tik sinkronizatu. Ordutik beste gailu batean saiakerarekin jarraitu baduzu datuak galdu ahal zenitzakeen.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Errorea gertatu da erantzunak gordetzen ari zirenean. Ziur zaude galdetegia utzi nahi duzula?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Galdetegi hau ezin da aplikazioan erantzun galderen jokaera ez dagoelako aplikazioan onartua:';
$string['addon.mod_quiz.errordownloading'] = 'Errorea behar diren datuak deskargatzean.';
$string['addon.mod_quiz.errorgetattempt'] = 'Errorea saiakeraren datuak eskuratzean.';
$string['addon.mod_quiz.errorgetquestions'] = 'Errorea galderak eskuratzean.';
$string['addon.mod_quiz.errorgetquiz'] = 'Errorea galdetegiaren datuak eskuratzean.';
$string['addon.mod_quiz.errorparsequestions'] = 'Errorea gertatu da galderak irakurtzean. Mesedez galdetegia nabigatzailean egiten saiatu.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Galdetegi hau ezin da aplikazioan erantzun aplikazioan onartzen ez diren galdera-motak baino ez dituelako:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Galdetegi hau ezin da aplikazioan erantzun bertan onartzen ez diren sarbide-arauak dituelako:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Errorea gertatu da saiakeraren datuak gordetzean.';
$string['addon.mod_quiz.finishnotsynced'] = 'Bukatua baina sinkronizatu gabe.';
$string['addon.mod_quiz.opentoc'] = 'Ireki nabigazioa gainean.';
$string['addon.mod_quiz.warningattemptfinished'] = 'Lineaz kanpoko saiakera baztertu da gunean bukatu delako edo ez delako aurkitu.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Lineaz kanpoko galdera batzuk baztertu dira galderak online aldatu direlako';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Saiakera ez da bukatu lineaz kanpoko galdera batzuk baztertu direlako. Mesedez zure erantzunak berrikusi eta saiakera berriz bidali.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Galdetegi honek aplikazioan onartzen ez diren galderak ditu:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Errorea edukia kargatzean.';
$string['addon.mod_resource.openthefile'] = 'Ireki fitxategia';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Ezin izan da kalifikazioa kalkulatu.';
$string['addon.mod_scorm.dataattemptshown'] = 'Datu hauek {{number}} saiakerakoak dira.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Errorea gertatu da lineaz kanpoko saiakera berria sortzean. Mesedez, saiatu berriz.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Errorea SCORMa jaistean: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Errorea SCORM datuak eskuratzean.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Barkatu, aplikazioak SCORM 1.2 besterik ez du onartzen.';
$string['addon.mod_scorm.errornotdownloadable'] = 'SCORM paketeen deskarga desgaituta dago.Mesedez jarri harremanetan zure guneko kudeatzailearekin.';
$string['addon.mod_scorm.errornovalidsco'] = 'SCORM pakete honek ez du kargatzeko SCOrik ikusgai.';
$string['addon.mod_scorm.errorpackagefile'] = 'Barkatu, aplikazioak ZIP paketeak besterik ez du onartzen.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Errorea gertatu da sinkronizatzean. Mesedez, saiatu berriz.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Saiakera honek sinkronizatu gabeko datuak dauzka.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Saiakera hau ezin da bidali dagoeneko gehienezko saiakera-kopurua gainditu duzulako.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'SCORM pakete hau ez dago aurretik jaitsita. Automatikoki jaitsiko da irekitzen duzunean.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'SCORM pakete hau eguneratua izan da azkenekoz jaitsi zenuenetik. Automatikoki jaitsiko da irekitzen duzunean.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = '{{number}}. saiakeraren lineaz kanpoko datu batzuk ezabatu dira ezin izan direlako saiakera berri gisa hartu.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Saiakera batzuk ezin izan dira gunearekin sinkronizatu azken online saiakera ez delako oraindik bukatu. Mesedez, bukatu online saiakera aurretik.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Barkatu, baina arazo bat egon da zure hausnarketa bidaltzean. Mesedez saiatu berriz.';
$string['addon.mod_survey.errorgetsurvey'] = 'Errorea hausnarketaren datuak eskuratzean.';
$string['addon.mod_survey.results'] = 'Emaitzak';
$string['addon.mod_url.accessurl'] = 'URLan sartu';
$string['addon.mod_url.pointingtourl'] = 'Baliabideak estekatzen duen URLa';
$string['addon.mod_wiki.errorloadingpage'] = 'Errore bat gertatu da orria kargatzean.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Wiki honek oraindik ez du edukirik.';
$string['addon.mod_wiki.gowikihome'] = 'Joan wikiaren lehen orrira';
$string['addon.mod_wiki.subwiki'] = 'Azpiwikia';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Izenburua ezin da hutsik egon';
$string['addon.mod_wiki.viewpage'] = 'Ikusi orria';
$string['addon.mod_wiki.wikipage'] = 'Wiki orria';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Ez da {{$a}} ebaluazio-estrategia onartzen';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Izenburu bat idatzi behar duzu.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'Bidalketa gunean aldatu izan da.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'Bidalketa gunean aldatu izan da.';
$string['addon.notes.userwithid'] = '{{id}} IDa duen erabiltzailea';
$string['addon.notes.warningnotenotsent'] = 'Ezin izan da {{course}} ikastaroan oharrak gehitu. {{error}}';
$string['addon.notifications.errorgetnotifications'] = 'Errore bat gertatu da jakinarazpenak jasotzean.';
$string['addon.notifications.notifications'] = 'Jakinarazpenak';
$string['addon.notifications.playsound'] = 'Erreproduzitu soinua';
$string['addon.notifications.therearentnotificationsyet'] = 'Ez dago jakinarazpenik.';
$string['addon.storagemanager.deletecourse'] = 'Garbitu ikastaro guztietako datuak';
$string['addon.storagemanager.deletecourses'] = 'Garbitu ikastaro guztien datuak';
$string['addon.storagemanager.deletedatafrom'] = 'Garbitu {{name}}-(e)ko datuak';
$string['addon.storagemanager.info'] = 'Zure gailuan gordetako fitxategiek aplikazioaren funtzionamendua azkartzen dute eta aplikazioa lineaz kanpo ere erabiltzeko aukera ematen dizute. Zure gailuan lekua egin behar baduzu fitxategi hauek arazorik gabe garbitu ditzakezu.';
$string['addon.storagemanager.managestorage'] = 'Kudeatu biltegiratzea';
$string['addon.storagemanager.storageused'] = 'Erabilitako biltegiratze-lekua:';
$string['appstoredescription'] = 'OHARRA: Moodle Mobile app ofizial honek berau baimentzeko konfiguratuta dauden Moodle guneetan SOILIK funtzionatuko du. Mesedez hitz egin zure Moodle kudeatzailearekin  konektatzeko arazoak badituzu.

Zure Moodle gunea ondo konfiguratuta badago app hau erabili ahal duzu:

- zure ikastaroen edukiak arakatu, baita lineaz kanpo ere
- mezu eta bestelako ekitaldien berehalako jakinarazpenak jaso
- zure ikastaroetako jendea aurkitu eta beraiekin harremanetan jarri
- irudiak, audio fitxategiak, bideoak eta bestelako fitxategiak zure gailu mugikorretik igo
- zure ikastaroko kalifikazioak ikusi
- eta gehiago!

Mesedez jo http://docs.moodle.org/en/Mobile_app helbidera informazio eguneratua aurkitzeko.

Funtzionalitateari buruzko edozein kritika benetan eskertuko dugu, baita app honek egin beharko lukeen bestelako gauzen inguruko zuen iradokizunak ere!

App honek hurrengo baimenak behar ditu:
Audioa grabatu - Audio-fitxategiak grabatu eta Moodlera igo ahal izateko
SD txarteleko edukiak irakurri eta aldatu - Edukiak SD txartelera jaisten dira gero lineaz kanpo ikusgai izan ahal izateko
Sarerako sarbidea - Zure Moodle gunearekin konektatuta zauden konprobatzeko, bestela lineaz kanpoko modua erabiltzeko
Abiaraztean martxan jarri - Jakinarazpen lokalak jaso ahal izateko baita aplikazioa atzeko planoan martxan dagoenean ere
Telefonoa lotan jartzea ekidin - push jakinarazpenak edozein unetan jaso ahal izateko';
$string['core.browser'] = 'Nabigatzailea';
$string['core.cannotconnect'] = 'Ezin izan da konektatu';
$string['core.cannotconnecttrouble'] = 'Arazoak ditugu zure gunera konektatzeko.';
$string['core.cannotconnectverify'] = '<strong>Helbidea ondo dagoela egiaztatu ezazu.</strong>';
$string['core.cannotdownloadfiles'] = 'Fitxategiak jaistea ezgaituta dago. Mesedez,  jar zaitez harremanetan zure guneko kudeatzailearekin.';
$string['core.cannotopeninapp'] = 'Baliteke fitxategi hau gailu honetan behar bezala ez ibiltzea. Ireki nahi duzu hala ere?';
$string['core.cannotopeninappdownload'] = 'Baliteke fitxategi hau gailu honetan behar bezala ez ibiltzea. Jaitsi nahi duzu hala ere?';
$string['core.captureaudio'] = 'Grabatu audioa';
$string['core.capturedimage'] = 'Argazkia atera da.';
$string['core.captureimage'] = 'Atera argazkia';
$string['core.capturevideo'] = 'Grabatu bideoa';
$string['core.clearsearch'] = 'Bilaketa garbia';
$string['core.clearstoreddata'] = 'Garbitu biltegia {{$a}}';
$string['core.clicktoseefull'] = 'Klik egin eduki guztiak ikusteko.';
$string['core.comments.commentsnotworking'] = 'Iruzkinak ezin dira eskuratu';
$string['core.comments.warningcommentsnotsent'] = 'Ezin izan dira iruzkinak sinkronizatu. {{error}}';
$string['core.confirmcanceledit'] = 'Ziur zaude orri hau utzi nahi duzula? Aldaketa guztiak galduko dira.';
$string['core.confirmgotabroot'] = 'Ziur zaude {{name}}-(e)ra itzuli nahi duzula?';
$string['core.confirmgotabrootdefault'] = 'Ziur zaude oraingo fitxaren hasiera-orrira joan nahi duzula?';
$string['core.confirmleaveunknownchanges'] = 'Ziur zaude orri hau utzi nahi duzula? Gorde gabeko aldaketak dituzu eta galdu egingo dira.';
$string['core.confirmloss'] = 'Ziur zaude? Aldaketa guztiak galdu egingo dira.';
$string['core.confirmopeninbrowser'] = 'Nabigatzailean ireki nahi duzu?';
$string['core.contenteditingsynced'] = 'Editatzen ari zaren edukiak sinkronizatu dira.';
$string['core.contentlinks.chooseaccount'] = 'Aukeratu kontua';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Aukeratu esteka zabaltzeko erabiliko den kontua.';
$string['core.contentlinks.confirmurlothersite'] = 'Esteka hau beste gune batekoa da. Ireki nahi duzu?';
$string['core.contentlinks.errornoactions'] = 'Ezin izan da ekintzarik aurkitu esteka hau irekitzeko.';
$string['core.contentlinks.errornosites'] = 'Ezin izan da gunerik aurkitu esteka hau irekitzeko.';
$string['core.contentlinks.errorredirectothersite'] = 'URLak gune ezberdin batera berbideratzea ez dago baimenduta.';
$string['core.copiedtoclipboard'] = 'Testua arbelean kopiatu da';
$string['core.copytoclipboard'] = 'Kopiatu arbelera';
$string['core.course.activitydisabled'] = 'Zure erakundeak jarduera hau mobile aplikazioan desgaitu du.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Zure erakundeak oraindik aplikazioean onartzen ez den gehigarri bat instalatuta dauka..';
$string['core.course.activitynotyetviewablesiteupgradeneeded'] = 'Zure erakundeko Moodle instalazioak eguneraketa bat behar du.';
$string['core.course.allsections'] = 'Atal guztiak';
$string['core.course.askadmintosupport'] = 'Jarri harremanetan zure guneko kudeatzailearekin eta esaiozu jarduera hau Moodle Mobile aplikazioan erabili nahi duzula.';
$string['core.course.availablespace'] = 'Une honetan {{available}} libre inguru dituzu.';
$string['core.course.cannotdeletewhiledownloading'] = 'Fitxategiak ezin dira ezabatu jarduera deskargatzen ari den bitartean. Itxaron ezazu mesedez deskarga amaitu arte.';
$string['core.course.confirmdeletemodulefiles'] = 'Ziur zaude modulu honetako fitxategiak ezabatu nahi dituzula?';
$string['core.course.confirmdeletestoreddata'] = 'Ziur zaude gordetako datuak ezabatu nahi dituzula?';
$string['core.course.confirmdownload'] = '{{size}} jaistear zaude.{{availableSpace}}  Ziur zaude aurrera egin nahi duzula?';
$string['core.course.confirmdownloadunknownsize'] = 'Ezin izan dugu deskargaren tamaina kalkulatu.{{availableSpace}}  Ziur zaude jaitsi nahi duzula?';
$string['core.course.confirmdownloadzerosize'] = 'Deskargatzen hastear zaude.{{availableSpace}} Ziur zaude jarraitu nahi duzula?';
$string['core.course.confirmlimiteddownload'] = 'Une honetan ez zaude Wi-Fira konektatuta.';
$string['core.course.confirmpartialdownloadsize'] = '<strong>Gutxienez</strong> {{size}} jaistera zoaz.{{availableSpace}}  Ziur zaude jarraitu nahi duzula?';
$string['core.course.contents'] = 'Edukiak';
$string['core.course.couldnotloadsectioncontent'] = 'Ezin izan da ataleko edukia kargatu. Saiatu beranduago mesedez.';
$string['core.course.couldnotloadsections'] = 'Ezin izan dira atalak kargatu. Saiatu beranduago mesedez.';
$string['core.course.errordownloadingcourse'] = 'Errorea ikastaroa jaistean.';
$string['core.course.errordownloadingsection'] = 'Errorea atala jaistean.';
$string['core.course.errorgetmodule'] = 'Errore bat gertatu da jardueraren datuak eskuratzean.';
$string['core.course.insufficientavailablequota'] = 'Zure gailuak ez du deskarga hau gordetzeko haina leku libre eskuragarri. Baliteke app eta sistemaren eguneraketentzako lekua erreserbatuta egotea. Deskarga egin aurretik lekua egin ezazu, mesedez.';
$string['core.course.insufficientavailablespace'] = '{{size}} deskargatzen saiatzen ari zara. Honek zure gailua normal funtzionatzeko behar duen lekurik gabe utziko luke. Deskarga egin aurretik lekua egin ezazu, mesedez.';
$string['core.course.manualcompletionnotsynced'] = 'Eskuzko osatzea ez da sinkronizatu.';
$string['core.course.nocontentavailable'] = 'Ez dago edukirik eskuragarri momentu honetan.';
$string['core.course.refreshcourse'] = 'Freskatu ikastaroa';
$string['core.course.useactivityonbrowser'] = 'Hala ere zure gailuko nabigatzailea erabilita erabil dezakezu.';
$string['core.course.warningmanualcompletionmodified'] = 'Jardueraren eskuzko osatzea gunean aldatua izan da.';
$string['core.course.warningofflinemanualcompletiondeleted'] = '\'{{name}}\' ikastaroaroko lineaz kanpoko eskuzko osatze batzuk ezabatuak izan dira. {{error}}';
$string['core.coursenogroups'] = 'Ez zara ikastaro honetako inongo taldeko kide.';
$string['core.courses.cannotretrievemorecategories'] = '{{$a}}. maila baino sakonagoko kategoriak ezin dira eskuratu.';
$string['core.courses.confirmselfenrol'] = 'Ziur zaude ikastaro honetan izena eman nahi duzula?';
$string['core.courses.downloadcourses'] = 'Jaitsi ikastaroak';
$string['core.courses.enrolme'] = 'Matrikulatu nazazu';
$string['core.courses.errorloadcategories'] = 'Errore bat gertatu da kategoriak kargatzean.';
$string['core.courses.errorloadcourses'] = 'Errore bat gertatu da ikastaroak kargatzean.';
$string['core.courses.errorloadplugins'] = 'Ikastaro honek behar dituen pluginak ezin izan dira behar bezala kargatu. Mesedez aplikazioa berriz kargatu ezazu eta ondoren berriz saiatu zaitez.';
$string['core.courses.errorsearching'] = 'Errorea gertatu da bilatzean.';
$string['core.courses.errorselfenrol'] = 'Errore bat gertatu da matrikulazio automatikoa egitean';
$string['core.courses.filtermycourses'] = 'Nire ikastaroak iragazi';
$string['core.courses.notenrollable'] = 'Ezin duzu zeure burua ikastaro honetan matrikulatu.';
$string['core.courses.password'] = 'Matrikulazio-giltza';
$string['core.courses.searchcoursesadvice'] = 'Bilatu ikastaroak botoia erabil dezakezu ikastaroak topatu eta bisitari gisa sartu edo bertan matrikulatzeko ikastaroak baimentzen badu.';
$string['core.courses.selfenrolment'] = 'Matrikulazio automatikoa';
$string['core.courses.totalcoursesearchresults'] = 'Ikastaroak guztira: {{$a}}';
$string['core.currentdevice'] = 'Oraingo gailua';
$string['core.datastoredoffline'] = 'Informazioa gailuan gorde da ezin izan delako bidali. Beranduago automatikoki bidaliko da.';
$string['core.deletedoffline'] = 'Lineaz kanpo ezabatu da';
$string['core.deleting'] = 'Ezabatzen';
$string['core.desktop'] = 'Mahaigaina';
$string['core.dfdaymonthyear'] = 'YYYY-MM-DD';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Baztertu';
$string['core.dismiss'] = 'Baztertu';
$string['core.downloaded'] = 'Deskargatuta';
$string['core.downloading'] = 'Jaisten';
$string['core.editor.hidetoolbar'] = 'Ezkutatu tresna-barra';
$string['core.editor.toggle'] = 'Etengailuaren editorea';
$string['core.emptysplit'] = 'Orri hau hutsik agertuko da ezkerreko panela hutsik badago edo kargatzen ari bada.';
$string['core.errorchangecompletion'] = 'Errorea gertatu da osaketa-egoera aldatzean. Mesedez saiatu berriz.';
$string['core.errordeletefile'] = 'Errorea fitxategia ezabatzean. Mesedez, saiatu berriz.';
$string['core.errordownloading'] = 'Errorea fitxategia jaistean.';
$string['core.errordownloadingsomefiles'] = 'Errore bat gertatu da moduluaren fitxategiak jaistean. Fitxategi batzuk falta daitezke.';
$string['core.errorfileexistssamename'] = 'Dagoeneko badago izen hori duen fitxategi bat.';
$string['core.errorinvalidform'] = 'Formularioak baliozkoak ez diren datuak dauzka. Mesedez egiaztatu derrigorrezko eremuak bete dituzula eta datuak egokiak direla.';
$string['core.errorinvalidresponse'] = 'Erantzun baliogabea jaso da. Errorea iraunkorra bada mesedez jar zaitez harremanetan zure guneko kudeatzailearekin .';
$string['core.errorloadingcontent'] = 'Errorea edukia kargatzean.';
$string['core.errorofflinedisabled'] = 'Lineaz kanpoko nabigazioa desgaituta dago zure gunean. Aplikazioa erabiltzeko Internetera konektaturik egon behar duzu.';
$string['core.erroropenfilenoapp'] = 'Errorea fitxategia irekitzean: ez da aurkitu fitxategi mota hau irekitzeko aplikaziorik.';
$string['core.erroropenfilenoextension'] = 'Errorea fitxategia irekitzean: fitxategiak ez dauka luzapenik.';
$string['core.erroropenpopup'] = 'Jarduera hau leiho berri bat zabaltzen saiatzen ari da. Hau ez da app honetan onartzen.';
$string['core.errorrenamefile'] = 'Errorea izena berrizendatzean. Mesedez, saiatu berriz.';
$string['core.errorsomedatanotdownloaded'] = 'Jarduera hau jaitsi baduzu, kontuan izan zenbait datu ez direla deskaraga-prozesuan jaisten errendimendu eta datuen erabilera arrazoiak direla eta.';
$string['core.errorsync'] = 'Errorea gertatu da sinkronizatzean. Mesedez, saiatu berriz.';
$string['core.errorsyncblocked'] = '{{$a}} hau ezin izan da orain sinkronizatu prozesu bat martxan dagoelako. Mesedez, saiatu berriz beranduago. Arazoa errepikatzen bada, saiatu aplikazioa berrabiarazten.';
$string['core.errorurlschemeinvalidscheme'] = 'URL hau beste aplikazio batean erabiltzeko da: {{$a}}.';
$string['core.errorurlschemeinvalidsite'] = 'Gunearen URL hau ezin da aplikazio honetan ireki.';
$string['core.filenameexist'] = 'Fitxategi-izena dagoeneko existitzen da: {{$a}}';
$string['core.fileuploader.audio'] = 'Audioa';
$string['core.fileuploader.camera'] = 'Kamera';
$string['core.fileuploader.confirmuploadfile'] = '{{size}} igotzear zaude. Ziur zaude aurrera egin nahi duzula?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Ezin izan dugu igotzera zoazenaren tamaina kalkulatu. Ziur zaude jarraitu nahi duzula?';
$string['core.fileuploader.errorcapturingaudio'] = 'Errorea audioa kapturatzean';
$string['core.fileuploader.errorcapturingimage'] = 'Errorea irudia kapturatzean';
$string['core.fileuploader.errorcapturingvideo'] = 'Errorea bideoa kapturatzean';
$string['core.fileuploader.errorgettingimagealbum'] = 'Errorea irudia bildumatik jasotzean.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Online egon behar zara fitxategiak igotzeko.';
$string['core.fileuploader.errornoapp'] = 'Ez daukazu ekintza hau burutzeko aplikazioik instalatuta.';
$string['core.fileuploader.errorreadingfile'] = 'Errorea fitxategia irakurtzean.';
$string['core.fileuploader.errorwhileuploading'] = 'Errorea gertatu da fitxategia igotzean.';
$string['core.fileuploader.file'] = 'Fitxategia';
$string['core.fileuploader.fileuploaded'] = 'Fitxategia ondo igo da.';
$string['core.fileuploader.maxbytesfile'] = '{{$a.file}} fitxategia oso handia da. Igo ditzakezun fitxategien gehienezko tamaina {{$a.size}} da.';
$string['core.fileuploader.photoalbums'] = 'Argazki-bildumak';
$string['core.fileuploader.readingfile'] = 'Fitxategia irakurtzen';
$string['core.fileuploader.readingfileperc'] = 'Fitxategia irakurtzen: %{{$a}}';
$string['core.fileuploader.selectafile'] = 'Aukeratu fitxategi bat';
$string['core.fileuploader.uploadafile'] = 'Igo fitxategia';
$string['core.fileuploader.uploading'] = 'Igotzen';
$string['core.fileuploader.uploadingperc'] = 'Igotzen: %{{$a}}';
$string['core.fileuploader.video'] = 'Bideoa';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.h5p.errorgetemail'] = 'Errorea erabiltzailearen helbide elektronikoa eskuratzean. Egiaztatu ezazu zure konexioa eta berriz saiatu zaitez.';
$string['core.h5p.offlinedisabled'] = 'Guneak ez du H5P paketeen deskarga baimentzen.';
$string['core.h5p.play'] = 'Erreproduzitu H5P';
$string['core.hasdatatosync'] = '{{$a}} honek sinkronizatu beharreko lineaz kanpoko informazioa du.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.image'] = 'Irudia';
$string['core.imageviewer'] = 'Irudi ikuskatzailea';
$string['core.lastdownloaded'] = 'Azkenik jaitsita';
$string['core.lastsync'] = 'Azken sinkronizazioa';
$string['core.loadmore'] = 'Kargatu gehiago';
$string['core.login.authenticating'] = 'Egiaztatzen';
$string['core.login.changepasswordbutton'] = 'Ireki pasahitza aldatzeko orria';
$string['core.login.changepasswordhelp'] = 'Pasahitza aldatzerakoan arazoak badituzu, jarri harremanetan mesedez zure guneko kudeatzailearekin. "Guneko Kudeatzaileak" zure eskola/unibertsitate/enpresa edo hezkuntza erakundean Moodle kudeatzen dutenak dira. Ez badakizu nola jarri harremanetan eurekin galdetu zure irakasle edo trebatzaileei.';
$string['core.login.changepasswordinstructions'] = 'Ezin duzu pasahitza aplikaziotik aldatu. Egin klik mesedez hurrengo botoian gunea nabigatzaile batean ireki eta bertatik pasahitza aldatzeko. Kontuan izan pasahitza aldatu ondoren ez zarela aplikaziora automatikoki bideratua izango eta beraz aplikaziora itzultzeko nabigatzailea itxi beharko duzu.';
$string['core.login.changepasswordlogoutinstructions'] = 'Gunea aldatu edo saioa amaitu nahi baduzu, egin klik hurrengo botoian:';
$string['core.login.changepasswordreconnectinstructions'] = 'Egin klik hurrengo botoian gunera berriz konektatzeko. (Kontuan izan pasahitza aldatzea lortu ez baduzu aurreko pantailara itzuliko zarela)';
$string['core.login.confirmdeletesite'] = 'Ziur zaude {{sitename}} gunea ezabatu nahi duzula?';
$string['core.login.connect'] = 'Konektatu!';
$string['core.login.connecttomoodle'] = 'Konektatu Moodlera';
$string['core.login.connecttomoodleapp'] = 'Moodle gune arrunt batera konektatzen saiatzen ari zara. Jaitsi ezazu mesedez Moodle aplikazio ofiziala Moodle gune horretara sartzeko.';
$string['core.login.connecttoworkplaceapp'] = 'Moodle Workplace gune batera konektatzen saiatzen ari zara. Jaitsi ezazu mesedez Moodle Workplace aplikazioa Moodle gune horretara sartzeko.';
$string['core.login.contactyouradministrator'] = 'Zure guneko kudeatzailearekin harremanetan jarri laguntza gehiagorako.';
$string['core.login.contactyouradministratorissue'] = 'Mesedez, eskatu zure guneko kudeatzaileari hurrengo arazoa ikuskatu dezala: {{$a}}';
$string['core.login.credentialsdescription'] = 'Mesedez saioa hasteko zure sartu erabiltzaile eta pasahitza.';
$string['core.login.emailconfirmsentnoemail'] = '<p>Zure helbidera e-posta mezu bat bidali da.</p><p>Bertan erregistroa amaitzeko argibide errazak aurkituko dituzu.</p><p>Arazoekin jarraitzen baduzu jarri zaitez harremanetan zure guneko kudeatzailearekin.</p>';
$string['core.login.emailnotmatch'] = 'E-posta helbideak ez datoz bat';
$string['core.login.erroraccesscontrolalloworigin'] = 'Saiatzen ari zaren cross-origin deia ez da onartu. Ikusi mesedez https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = 'Errorea gertatu da gunea ezabatzean. Mesedez saiatu beranduago.';
$string['core.login.errorexampleurl'] = 'https://campus.adibidea.eus URLa adibide bat baino ez da, ez da benetako gune bat. <strong>Erabili ezazu mesedez zure eskola edo erakundearen gunearen URLa.</strong>';
$string['core.login.errorqrnoscheme'] = 'URL hau ez da saioa hasteko URL baliagarria.';
$string['core.login.errorupdatesite'] = 'Errore bat gertatu da guneko token-a eguneratzean.';
$string['core.login.faqcannotconnectanswer'] = 'Jarri zaitez harremanetan mesedez zure guneko kudeatzailearekin.';
$string['core.login.faqcannotconnectquestion'] = 'Nire guneko helbidea ondo idatzi dut baina ezin dut konektatu.';
$string['core.login.faqcannotfindmysiteanswer'] = 'Izena ondo idatzi duzu? Baliteke zure gunea gure gune publikoen direktorioan ez egotea. Aurkitu gabe jarraitzen baduzu, horren ordez zure guneko helbidea idatzi ezazu.';
$string['core.login.faqcannotfindmysitequestion'] = 'Ezin dut nire gunea aurkitu.';
$string['core.login.faqsetupsiteanswer'] = 'Egin klik {{$link}} zure Moodle gunea sortzeko eskura dituzun aukera ezberdinak ezagutzeko.';
$string['core.login.faqsetupsitelinktitle'] = 'Hasi zaitez.';
$string['core.login.faqsetupsitequestion'] = 'Nire Moodle gunea martxan jarri nahi dut.';
$string['core.login.faqtestappanswer'] = 'Aplikazioa Moodle Demo Gunean probatzeko, idatzi ezazu "teacher" edo "student" "Zure gunea" eremuan eta egin klik "Konektatu zure gunera" botoian.';
$string['core.login.faqtestappquestion'] = 'Aplikazioa probatu baino ez dut egin nahi, hori egin al dezaket?';
$string['core.login.faqwhatisurlanswer'] = '<p>Erakunde bakoitzak bere Moodle gunerako helbide bakarra edo URLa dauka. Helbidea aurkitzeko:</p>
<ol>
<li>Ireki web-nabigatzaile bat eta joan Moodle gunearen hasiera-orrira.</li>
<li>Leihoaren goiko aldean, helbide-barran, zure Moodle gunearen helbidea ikusiko duzu. Adibidez "campus.adibidea.eus".<br>{{$image}}</li>
<li>Kopiatu ezazu helbide hori (ez kopiatu /login eta horren atzetik dagoena), itsatsi ezazu Moodle aplikazioan eta egin klik "Konektatu zure gunera" botoian</li>
<li>Orain zure gunean sartu ahalko zara zure erabiltzaile-izena eta pasahitza erabilita.</li>
</ol>';
$string['core.login.faqwhatisurlquestion'] = 'Zein da nire gunearen helbidea? Nola aurkitu dezaket nire gunearen URLa?';
$string['core.login.faqwhereisqrcode'] = 'Non aurkitu dezaket QR kodea?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>Zure erakundeak gaitu badu, QR kodea zure profil-orriaren webgunearen azpiko aldean aurkituko duzu.</p>{{$image}}';
$string['core.login.findyoursite'] = 'Aurkitu zure gunea';
$string['core.login.helpmelogin'] = '<p>Mundu osoan milaka Moodle gune dago. App honek soilik Mobile sarbidea espresuki gaitu duten guneetara konektatu daiteke.</p><p>Zure Moodle gunera ezin bazara konektatu zure guneko kudeatzailearekin harremanetan jarri beharko zara eta eskatu <a href="http://docs.moodle.org/en/Mobile_app" target="_blank">http://docs.moodle.org/en/Mobile_app</a> irakurtzeko</p><p>Aplikazioa probetarako Moodle ingurunean probatzeko idatzi <i>teacher</i> edo <i>student</i> <i>Gunearen helbidea</i> eremuan eta egin klik <b>Konektatu! botoian</b>.</p>';
$string['core.login.invalidaccount'] = 'Zure erabiltzaile eta pasahitza egiaztatu itzazu edo zure guneko administratzaileari guneko ezarpenak egiaztatzeko eskatu.';
$string['core.login.invalidmoodleversion'] = '<p>Moodle bertsio baliogabea. Moodle aplikazioak soilik {{$a}} bertsiotik aurrerakoak onartzen ditu.</p>
<p>Zure guneko kudeatzaileekin harremanetan jarri zaitezke zuen Moodle sistema eguneratu dezaten eskatzeko.</p>
<p>"Guneko Kudeatzaileak" zure eskola/unibertsitate/enpresa edo hezkuntza erakundean Moodle kudeatzen dutenak dira. Ez badakizu nola jarri harremanetan eurekin galdetu zure irakasle edo trebatzaileei.</p>';
$string['core.login.invalidsite'] = 'Guneko URLa ez da zuzena';
$string['core.login.invalidtime'] = 'Ordu baliogabea';
$string['core.login.invalidvaluemax'] = 'Gehieneko balioa {{$a}} da.';
$string['core.login.invalidvaluemin'] = 'Gutxieneko balioa {{$a}} da.';
$string['core.login.localmobileunexpectedresponse'] = 'Moodle Mobile-ko Funtzio Aurreratuen kontrolak ezusteko erantzuna eman du. Mobile zerbitzu estandarra erabilita autentifikatuko zaitugu.';
$string['core.login.loggedoutssodescription'] = 'Berriz autentifikatu behar duzua. Gunean nabigatzaile leiho baten bitartez hasi behar duzu saioa.';
$string['core.login.loginbutton'] = 'Sartu';
$string['core.login.logininsiterequired'] = 'Gunean web-nabigatzaile baten bidez sartu behar zara.';
$string['core.login.mobileservicesnotenabled'] = 'Mobile bidezko sarbidea gaitu gabe dago zure gunean. Mesedez, jar zaitez harremanetan guneko kudeatzailearekin, mobile sarbidea gaitu behar dela uste baduzu.';
$string['core.login.notloggedin'] = 'Autentifikaturik egon behar duzu.';
$string['core.login.onboardingcreatemanagecourses'] = 'Sortu eta kudeatu zure ikastaroak';
$string['core.login.onboardingenrolmanagestudents'] = 'Matrikulatu eta kudeatu zure ikasleak';
$string['core.login.onboardinggetstarted'] = 'Moodlekin hasi zaitez';
$string['core.login.onboardingialreadyhaveasite'] = 'Dagoeneko Moodle gune bat daukat';
$string['core.login.onboardingimalearner'] = 'Ikaslea naiz';
$string['core.login.onboardingimaneducator'] = 'Hezitzailea naiz';
$string['core.login.onboardingineedasite'] = 'Moodle gune bat behar dut';
$string['core.login.onboardingprovidefeedback'] = 'Eman feedbacka';
$string['core.login.onboardingtoconnect'] = 'Moodle aplikaziora konektatzeko Moodle gune bat beharko duzu';
$string['core.login.onboardingwelcome'] = 'Ongi etorria Moodle aplikaziora!';
$string['core.login.or'] = 'EDO';
$string['core.login.passwordrequired'] = 'Pasahitza behar da';
$string['core.login.recaptchachallengeimage'] = 'reCAPTCHA erronkaren irudia';
$string['core.login.recaptchaexpired'] = 'Egiaztatzea iraungitu da. Erantzun berriz ere segurtasun-galdera.';
$string['core.login.recaptchaincorrect'] = 'Segurtasun-galderaren erantzuna okerra  da.';
$string['core.login.reconnect'] = 'Berriz konektatu';
$string['core.login.reconnectdescription'] = 'Zure autentikazio-token-a ez da baliozkoa edo iraungitu da. Gunera berriz konektatu beharko zara.';
$string['core.login.reconnectssodescription'] = 'Zure autentikazio-token-a ez da baliozkoa edo iraungitu da. Gunera berriz konektatu beharko duzu. Gunean web-nabigatzaile baten bidez sartu behar duzu.';
$string['core.login.searchby'] = 'Bilatu honen arabera:';
$string['core.login.selectsite'] = 'Aukeratu mesedez zure gunea:';
$string['core.login.signupplugindisabled'] = '{{$a}} ez dago gaituta.';
$string['core.login.signuprequiredfieldnotsupported'] = 'Sarbide-formularioak aplikazioak onartzen ez duen beharrezko eremu pertsonalizatua dauka. Zure kontua web nabigatzaile batetik sortu ezazu, mesedez.';
$string['core.login.siteaddress'] = 'Zure gunea';
$string['core.login.sitehasredirect'] = 'Zure gunean HTTP berbideraketaren bat dauka. Aplikazioak ezin ditu berbideraketak jarraitu, hau izan daiteke zure gunera konektatzea ekiditen duen arazoa.';
$string['core.login.siteinmaintenance'] = 'Zure gunea mantenu-moduan dago';
$string['core.login.sitepolicynotagreederror'] = 'Ez da guneko politika onartu.';
$string['core.login.siteurl'] = 'Gunearen URLa';
$string['core.login.siteurlrequired'] = 'Gunearen URLa behar da, <i>http://www.zuremoodlegunea.eus</i> adibidez';
$string['core.login.stillcantconnect'] = 'Oraindik ezin zara konektatu?';
$string['core.login.usernamerequired'] = 'Erabiltzailea behar da';
$string['core.login.visitchangepassword'] = 'Gunera joan nahi duzu pasahitza aldatzeko?';
$string['core.login.webservicesnotenabled'] = 'Zure guneak web zerbitzuak gaitu gabe dauzka. Laguntza eskuratzeko zure guneko kudeatzailearekin harremanetan jarri zaitez.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Bestela gunera zure erabiltzaile-izen eta pasahitza erabiliz sartu zaitezke.';
$string['core.login.yourenteredsite'] = 'Konektatu zure gunera';
$string['core.lostconnection'] = 'Zure autentikazio-token-a ez da baliozkoa edo iraungitu da. Gunera berriz konektatu beharko duzu.';
$string['core.mainmenu.changesite'] = 'Aldatu gunea';
$string['core.mainmenu.website'] = 'Webgunea';
$string['core.needhelp'] = 'Laguntzarik behar duzu?';
$string['core.networkerroriframemsg'] = 'Eduki hau ez dago eskuragarri lineaz kanpo. Internetera konektatu zaitez eta ondoren saiatu zaitez berriro, mesedez.';
$string['core.networkerrormsg'] = 'Arazo bat izan da gunearekin konektatzerakoan. Mesedez egiaztatu zure konexioa eta ondoren berriz saiatu zaitez.';
$string['core.nooptionavailable'] = 'Ez dago eskuragarri dagoen aukerarik';
$string['core.nopasswordchangeforced'] = 'Ezin duzu jarraitu zure pasahitza aldatu gabe.';
$string['core.nopermissionerror'] = 'Sentitzen dugu, baina une honetan ez duzu hori egiteko baimenik.';
$string['core.notapplicable'] = 'e/a';
$string['core.notsent'] = 'Bidali gabea';
$string['core.nummore'] = '{{$a}} gehiago';
$string['core.openfile'] = 'Ireki fitxategia';
$string['core.openfullimage'] = 'Klik egin hemen irudia jatorrizko tamainan ikusteko.';
$string['core.openinbrowser'] = 'Ireki nabigatzailean';
$string['core.openmodinbrowser'] = 'Ireki {{$a}} nabigatzailean';
$string['core.percentagenumber'] = '%{{$a}}';
$string['core.pulltorefresh'] = 'Sakatu freskatzeko';
$string['core.qrscanner'] = 'QR eskanerra';
$string['core.question.cannotdeterminestatus'] = 'Ezin izan da egoera zehaztu.';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'Zure guneak oraindik ez du baimentzen erantzunei fitxategiak eranstea.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'Zure guneak oraindik ez du baimentzen txertatutako fitxategiak editatzea.';
$string['core.question.errorquestionnotsupported'] = 'Galdera mota hau ez dago aplikazioan onartuta: {{$a}}';
$string['core.question.howtodraganddrop'] = 'Sakatu aukeratzeko eta ondoren sakatu ezabatzeko.';
$string['core.question.questionmessage'] = '{{$a}} galdera: {{$b}}';
$string['core.redirectingtosite'] = 'Gunera berbideratua izango zara.';
$string['core.removefiles'] = 'Ezabatu fitxategiak {{$a}}';
$string['core.requireduserdatamissing'] = 'Erabiltzaile honek beharrezkoak diren profileko datuak bete gabe ditu. Mesedez, bete itzazu datu hauek zure gunean eta saiatu berriz.<br>{{$a}}';
$string['core.retry'] = 'Berriz saiatu';
$string['core.scanqr'] = 'Eskaneatu QR kodea';
$string['core.searching'] = 'Bilatzen';
$string['core.settings.about'] = 'Honi buruz';
$string['core.settings.appsettings'] = 'Aplikazioaren ezarpenak';
$string['core.settings.appversion'] = 'Aplikazioaren bertsioa';
$string['core.settings.cannotsyncloggedout'] = 'Gune hau ezin da sinkronizatu saioa itxi duzulako. Saiatu zaitez berriz ere gunean saioa hasi ondoren.';
$string['core.settings.cannotsyncoffline'] = 'Ezin da sinkronizatu lineaz kanpo.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Ezin da sinkronizatu oraingo ezarpenek sinkronizazio Wi-Fi bidez konektaturik egonda soilik baimentzen dutelako. Mesedez konektatu Wi-Fi sare batera.';
$string['core.settings.colorscheme'] = 'Kolore-eskema';
$string['core.settings.colorscheme-auto'] = 'Automatikoa (sistemako ezarpenetan oinarritutakoa)';
$string['core.settings.colorscheme-dark'] = 'Iluna';
$string['core.settings.colorscheme-light'] = 'Argia';
$string['core.settings.compilationinfo'] = 'Konpilazioaren informazioa';
$string['core.settings.copyinfo'] = 'Kopiatu gailuaren informazioa arbelean';
$string['core.settings.cordovadevicemodel'] = 'Cordova device eredua';
$string['core.settings.cordovadeviceosversion'] = 'Cordova device SE bertsioa';
$string['core.settings.cordovadeviceplatform'] = 'Cordova device plataforma';
$string['core.settings.cordovadeviceuuid'] = 'Cordova device uuid';
$string['core.settings.cordovaversion'] = 'Cordova bertsioa';
$string['core.settings.debugdisplaydescription'] = 'Gaituz gero, ahal denean errore-mezuek errorearen inguruko informazio gehiago erakutsiko dute.';
$string['core.settings.deletesitefiles'] = 'Ziur zaude \'{{sitename}}\' gunetik jaitsitako fitxategiak eta cache-ko datuak ezabatu nahi dituzula? Hori eginez gero ezingo duzu aplikazioa offline moduan erabili.';
$string['core.settings.deletesitefilestitle'] = 'Ezabatu guneko fitxategiak';
$string['core.settings.deviceinfo'] = 'Gailuaren informazioa';
$string['core.settings.deviceos'] = 'Gailuaren SEa';
$string['core.settings.displayformat'] = 'Erakusteko modua';
$string['core.settings.enabledownloadsection'] = 'Gaitu gaien deskarga';
$string['core.settings.enablefirebaseanalytics'] = 'Gaitu Firebase analytics';
$string['core.settings.enablefirebaseanalyticsdescription'] = 'Gaituz gero, aplikazioak erabilera-datuak anonimoki bilduko ditu.';
$string['core.settings.enablerichtexteditor'] = 'Gaitu testu-editorea';
$string['core.settings.enablerichtexteditordescription'] = 'Gaituz gero, testu-editorea erakutsiko da edukia sartu ahal den lekuetan.';
$string['core.settings.enablesyncwifi'] = 'Baimendu sinkronizazioa Wi-Fi bidezko konexioa dagoenean soilik';
$string['core.settings.entriesincache'] = '{{$a}} sarrera cache-an';
$string['core.settings.errordeletesitefiles'] = 'Errorea fitxategiak ezabatzean.';
$string['core.settings.errorsyncsite'] = 'Errorea guneko datuak sinkronizatzean. Mesedez, egiaztatu zure interneterako konexioa eta saiatu berriz.';
$string['core.settings.estimatedfreespace'] = 'Estimatutako leku librea';
$string['core.settings.filesystemroot'] = 'Fitxategi-sistemaren jatorria';
$string['core.settings.fontsize'] = 'Testuaren tamaina';
$string['core.settings.forcedsetting'] = 'Ezarpen hau zure gunearen konfigurazioak behartutakoa da.';
$string['core.settings.localnotifavailable'] = 'Jakinarazpen lokalak eskuragarri';
$string['core.settings.locationhref'] = 'Web view URLa';
$string['core.settings.navigatorlanguage'] = 'Nabigatzailearen hizkuntza';
$string['core.settings.navigatoruseragent'] = 'Nabigatzailearen userAgent-a';
$string['core.settings.networkstatus'] = 'Internet konexioaren egoera';
$string['core.settings.opensourcelicenses'] = 'Kode Irekiko Lizentziak';
$string['core.settings.privacypolicy'] = 'Pribatutasun politika.';
$string['core.settings.publisher'] = 'Editorea';
$string['core.settings.pushid'] = 'Push jakinarazpenaren IDa';
$string['core.settings.reportinbackground'] = 'Erroreak automatikoki jakinarazi';
$string['core.settings.screen'] = 'Pantailako informazioa';
$string['core.settings.showdownloadoptions'] = 'Erakutsi deskargatzeko aukerak';
$string['core.settings.siteinfo'] = 'Gunearen informazioa';
$string['core.settings.spaceusage'] = 'Lekuaren erabilera';
$string['core.settings.spaceusagehelp'] = 'Gordetako guneko informazioa ezabatuta bertako lineaz kanpoko datuak ezabatuko dira. Informazio horrek aplikazioa konexiorik gabe erabiltzea ahalbidetzen dizu.';
$string['core.settings.synchronization'] = 'Sinkronizazioa';
$string['core.settings.synchronizenow'] = 'Sinkronizatu orain';
$string['core.settings.synchronizenowhelp'] = 'Gune bat sinkronizatuta zain dauden aldaketak eta gailuan gordetako lineaz kanpoko jarduerak bidaliko ditu eta mezu eta jakinarazpenen moduko datuak sinkronizatuko ditu.';
$string['core.settings.syncsettings'] = 'Sinkronizazioaren ezarpenak';
$string['core.settings.wificonnection'] = 'WiFi konexioa';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Aukeratu kontua fitxategiak bertan gordetzeko.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Dagoeneko fitxategi bat dago izen horrekin. Existitzen den fitxategi hori ordezkatu edo "{{$a}}" gisa berrizendatu nahi duzu ?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Ez dago gunerik gordeta. Mesedez gehitu gune bat aplikazioaren bitartez fitxategi bat partekatu aurretik.';
$string['core.sharedfiles.nosharedfiles'] = 'Ez dago partekatutako fitxategirik gune honetan.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Ez duzu igotzeko fitxategirik hemen. Beste app baten bitartez fitxategia igo nahi baduzu, fitxategia aurkitu eta ondoren \'Ireki honekin\' botoia sakatu.';
$string['core.sharedfiles.rename'] = 'Aldatu izena';
$string['core.sharedfiles.replace'] = 'Ordeztu';
$string['core.sharedfiles.sharedfiles'] = 'Partekatutako fitxategiak';
$string['core.sharedfiles.successstorefile'] = 'Fitxategia ondo gorde da. Orain fitxategi hau aukeratu dezakezu zure gune pribatura igo edo jarduera batean erabiltzeko.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Barkatu...';
$string['core.storingfiles'] = 'Fitxategiak gordetzen';
$string['core.tablet'] = 'Tablet-a';
$string['core.tag.errorareanotsupported'] = 'Etiketa-eremu hau ez da aplikazioan onartzen.';
$string['core.tag.warningareasnotsupported'] = 'Etiketa-eremu batzuk ez dira erakusten aplikazioan onartzen ez direlako.';
$string['core.thereisdatatosync'] = 'Lineaz-kanpoko {{$a}} daude sinkronizatzeko .';
$string['core.tryagain'] = 'Saiatu berriz';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Oh oh!';
$string['core.unexpectederror'] = 'Ezusteko errore bat gertatu da. Mesedez aplikazioa itxi eta berriz ireki ondoren berriz saiatu zaitez.';
$string['core.unicodenotsupported'] = 'Emoji batzuk ez dira gune honetan onartzen. Mezua karaktere horiek kenduta bidaliko da.';
$string['core.unicodenotsupportedcleanerror'] = 'Testu hutsa aurkitu da Unicode karaktereak ezabatzean.';
$string['core.unknown'] = 'Ezezaguna';
$string['core.unzipping'] = 'Erauzten';
$string['core.updaterequired'] = 'Aplikazioa eguneratu behar da';
$string['core.updaterequireddesc'] = 'Mesedez zure aplikazioa {{$a}} bertsiora eguneratu ezazu';
$string['core.user.contact'] = 'Kontaktua';
$string['core.user.detailsnotavailable'] = 'Erabiltzaile honen xehetasunak ez daude zuretzat eskuragarri';
$string['core.user.errorloaduser'] = 'Errorea erabiltzailea kargatzean.';
$string['core.user.sendemail'] = 'E-posta';
$string['core.viewcode'] = 'Ikusi kodea';
$string['core.vieweditor'] = 'Ikusi editorea';
$string['core.viewembeddedcontent'] = 'Ikusi txertatutako edukia';
$string['core.warningofflinedatadeleted'] = '\'{{name}}\' {{component}}-aren lineaz kanpoko informazioa ezabatua izan da. {{error}}';
$string['core.whoissiteadmin'] = '"Guneko Kudeatzaileak" zure eskola/unibertsitate/enpresa edo hezkuntza erakundearen Moodlea kudeatzen dutenak dira. Eurekin harremanetan nola jarri ez badakizu, jarri harremanetan zure irakasle edo hezitzaileekin.';
$string['core.whoops'] = 'Ups!';
$string['core.whyisthishappening'] = 'Zergatik ari da hau gertatzen?';
$string['core.wsfunctionnotavailable'] = 'Web-zerbitzu funtzioa ez dago eskuragarri.';
$string['core.youreoffline'] = 'Lineaz kanpo zaude';
$string['core.youreonline'] = 'Berriz ere on-line zaude';
$string['pluginname'] = 'Moodle Mobile hizkuntza-kateak';
