<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'atto_styles', language 'pt', version '3.5'.
 *
 * @package     atto_styles
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['config'] = 'Configuração de Estilos';
$string['config_desc'] = 'Configuração dos estilos do widget no Atto em formato JSON.
<hr />
Por exemplo:<br />
{<br />
    "title": "Blue box",<br />
    "type": "block",<br />
    "classes": "box blue"<br />
},{<br />
    "title": "Red text",<br />
    "type": "inline",<br />
    "classes": "red"<br />
}<br />
<hr />
O atributo <em>title</em> define o nome para o estilo dentro do widget de estilos do Atto.
<br />
<br />
O título também pode suportar o filtro Moodle Multilíngue (se ativado), mas as aspas adicionais terão de ser precedidas de uma barra invertida.<br />
Por favor, consulte o ficheiro README na pasta do módulo para um exemplo.<br />
<hr />
O atributo <em>type</em> pode conter um dos dois valores: "block" ou "inline".<br />
<br />
"block" irá criar uma \'div tag\' com a(s) classe(s) especificada(s) e irá funcionar como um elemento de bloco padrão. Isto irá afetar o elemento de bloco atual e pode ser aplicado não apenas ao texto selecionado no momento.<br />
<br />
"Inline" cria uma \'span tag\' com a(s) classe(s) especificada(s) e irá funcionar como um elemento inline padrão. Isto será aplicado apenas ao texto selecionado no momento.
<hr />
O atributo <em>classes</em> é o nome da classe CSS que será aplicada ao bloco / texto inline.<br />
<br />
Podem ser definidas várias classes para cada item, separados por um espaço. Todas serão aplicadas ao bloco / texto inline. <br />
<br />
As definições de classe CSS não podem ser definidas dentro deste módulo. Terá que adicionar as definições da classe CSS no seu tema ou nas configurações HTML adicionais do Moodle.
<hr />
Nas instalações Moodle com temas baseados em Bootstrap (especialmente no Tema <em>More</em> e no Tema <em>Clean</em>, também poderá criar estilos com classes CSS bootstrap em vez de definir as suas próprias classes.
<br /><br />
Por exemplo:<br />
{<br />
    "title": "Hero unit box",<br />
    "type": "block",<br />
    "classes": "hero-unit"<br />
},{<br />
    "title": "Well",<br />
    "type": "block",<br />
    "classes": "well"<br />
},{<br />
    "title": "Info text",<br />
    "type": "inline",<br />
    "classes": "label label-info"<br />
},{<br />
    "title": "Warning text",<br />
    "type": "inline",<br />
    "classes": "label label-warning"<br />
}<br /><br />
Para mais informações sobre classes bootstrap, visite as hiperligações abaixo na documentação Bootstrap 2.3:
<ul>
<li><a href="http://getbootstrap.com/2.3.2/components.html#labels-badges">Bootstrap labels and badges</a></li>
<li><a href="http://getbootstrap.com/2.3.2/components.html#alerts">Bootstrap alerts</a></li>
<li><a href="http://getbootstrap.com/2.3.2/components.html#misc">Bootstrap helper classes</a></li>
</ul>';
$string['nostyle'] = 'Sem estilo';
$string['pluginname'] = 'Estilos';
$string['privacy:metadata'] = 'O módulo Estilos para Atto não armazena quaisquer dados pessoais.';
$string['settings'] = 'Definições de Estilos';
