<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodleorg', language 'it', version '3.5'.
 *
 * @package     local_moodleorg
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutdemosite'] = 'Il nostro sito demo è una installazione completa di Moodle con  corsi di esempio che potete provare con il ruolo di docente, studente oppure di amministratore. Non aver timore di fare tutte le prove che vuoi, ogni ora il sito viene ripristinato nel suo stato originario.';
$string['aboutdemositetitle'] = 'Sito demo';
$string['aboutintro'] = 'Moodle è un Open Source Course Management System (CMS), noto anche come  Learning Management System (LMS) o Virtual Learning Environment (VLE). Moodle si è diffuso moltissimo tra i formatori di tutto il mondo come efficace strumento di creazione e conduzione di corsi on line. Per funzionare, Moodle ha bisogno di essere installato su un web server, "in house" oppure presso una società di hosting.';
$string['aboutoverview'] = '<p>L\'obiettivo principale del progetto Moodle è quello di fornire ai formatori i migliori strumenti per gestire e diffondere l\'apprendimento, tuttavia è possibile usare Moodle per molti altri scopi:</p>
<ul>
<li>Le caratteristiche di Moodle permettono di utilizzarlo sia in installazioni molto grandi, con centinaia di migliaia di studenti, sia per soddisfare le esigenze di una piccola scuola o di un formatore indipendente.</li>
<li>Molte istituzioni usano Moodle come ambiente per corsi interamente on line mentre altre lo utilizzano per supportare corsi in presenza (blended learning).</li>
<li>Molti utenti usano i moduli di attività di Moodle (come Forum, Wiki, Database, etc) per costruire comunità di apprendimento (nella tradizione del costruttivismo sociale) mentre altri preferiscono usare Moodle come strumento di distribuzione di contenuti (come ad esempio i pacchetti SOCRM) e valutare l\'apprendimento attraverso quiz e compiti.</li>
</ul>';
$string['aboutoverviewtitle'] = 'Cosa è Moodle?';
$string['aboutstatistics'] = 'Moodle è liberamente scaricabile e la sua registrazione e totalmente volontaria, pertanto non ci è possibile sapere con esattezza quanti stanno usando Moodle. Ciononostante, sulla base delle informazioni dei siti che si registrano, rendiamo disponibili alcuni interessanti dati accompagnati da grafici visualizzabili nella pagina delle Statistiche.';
$string['aboutstatisticsheading'] = 'Statistiche su Moodle';
$string['aboutstatisticstitle'] = 'Moodle.org: Statistiche su Moodle';
$string['activeusers24hours'] = 'Utenti che si sono collegati nelle ultime 24 ore:';
$string['activeuserspastmonth'] = 'Utenti che si sono collegati nel mese scorso:';
$string['browsegittitle'] = 'Il nostro codice sorgente';
$string['cachedef_frontpagecolumn'] = 'Colonne pagina home';
$string['cachedef_usefulposts'] = 'Post utili';
$string['communities'] = 'Communities';
$string['communitiesmy'] = 'Le mie community';
$string['community'] = 'Community';
$string['communityadministration'] = 'Gestione community';
$string['communitycurrent'] = 'Community corrente';
$string['communityenrolme'] = 'Diventa membro di questa community';
$string['communityenrolmentoptions'] = 'Partecipare ad una community';
$string['communityintro'] = 'Moodle ha una comunità di utenti molto ampia che su moodle.org conta oltre <a href="http://moodle.org/userpics">{$a->usercount} utenti registrati</a> provenienti da <a href="http://moodle.org/sites">{$a->countrycount} nazioni</a>href="http://download.moodle.org/lang16/">{$a->langcount} lingue</a> e <a href="http://download.moodle.org/lang16/">{$a->langcount} lingue</a>';
$string['communityjoinbyyourself'] = 'Partecipa';
$string['communityjoinbyyourselfas'] = 'Partecipa come {$a->rolename}';
$string['communitynoguestaccess'] = 'Gli ospiti non possono accedere a questa community, per favore autenticati.';
$string['communitynotenrollable'] = 'Non puoi diventare da solo membro di questa community. Per favore contatta il community facilitator';
$string['communitysomeallowguest'] = 'Alcune community sono aperte agli ospiti';
$string['communityunenrolme'] = 'Abbandona la community {$a}';
$string['conferencecenter'] = 'Moodle Conference Center';
$string['connectedsites'] = 'Alcuni siti Moodle sono collegati a moodle.org attraverso il Moodle Networking. Una volta autenticati su moodle.org puoi accedere anche questi siti.';
$string['contactbugs'] = 'E\' possibile segnalare problemi riscontrati in Moodle o nel sito moodle.org inserendo un bug sul Moodle Tracker';
$string['contactbugstitle'] = 'Segnala un bug';
$string['contactintro'] = 'Selezionate la modalità preferita per contattarci:';
$string['contactlogin'] = 'Per qualsiasi altra richiesta, autenticatevi e utilizzate il form che apparirà in questa pagina..';
$string['contactmoodlecom'] = 'Per richieste commerciali, sulla licenza, sul trademark, o per richieste di sviluppo particolari, per favore rivolgesi all\'Help Desk su <a href="http://moodle.com/">Moodle.com</a>';
$string['contactmoodlecomhelpdesk'] = 'Moodle.com Helpdesk';
$string['contactmoodlecomtitle'] = 'Moodle.com';
$string['contactmoodleorgemail'] = 'Se incontrate difficoltà per la conferma dell\'account su moodle.org, inviate una mail a questo indirizzo:';
$string['contactmoodleorglogin'] = 'Collegati adesso';
$string['contactmoodleorgother'] = 'Per altre richieste, per favore utilizzate il form sottostante:';
$string['contactmoodleorgtitle'] = 'Moodle.org';
$string['contactsecurity'] = 'Le segnalazioni di problemi sulla sicurezza dovrebbero essere inserite nel tracker, fornendo l\'appropriato livello di importanza.';
$string['contactsent'] = 'Il tuo messaggio è stato inviato via email al Moodle Community Manager';
$string['contactsupport'] = 'Per ottenere supporto sull\'uso di Moodle, è disponibile la nostra pagina di supporto con un elenco di moltissime utili risorse.';
$string['contactsupporttitle'] = 'Supporto';
$string['developerlist'] = 'Elenco degli sviluppatori con accesso in scrittura';
$string['developermeetings'] = 'Developer meeting';
$string['developers'] = 'Lo sviluppo di Moodle è guidato dal team core di Moodle.com, con l\'aituo di centinaia di sviluppatori di tutto il mondo. Moltio di questi sviluppatori hanno la responsabilità di specifici moduli e plugin di Moodle.';
$string['developerstitle'] = 'Sviluppatori';
$string['developmentdocs'] = 'La gran parte della documentazione è reperibile in Moodle Docs, dove è anche possibile trovare specifiche, brainstorming, procedure, standard e guide per l\'utente.';
$string['developmentdocstitle'] = 'Documentazione per sviluppatori';
$string['developmentintro'] = 'Puntiamo ad un processo di sviluppo aperto e trasparente per consentire a tutta la comunità di contribuire. Gli sviluppatori PHP sono i benvenuti ma è possibile contribuire anche attraverso discussioni, test, feedback e documentazione.';
$string['developmenttracker'] = 'Tutti i problemi relativi allo sviluppo (bug, nuove caratteristiche, miglioramenti) sono registrati e gestiti nel Moodle Tracker. Puoi vedere in ogni momento chi sta lavorando a cosa e contribuire alle discussioni. Se stai cercando problemi particolari, cerca prima nel Tracker e se trovi il tuo problema assicurati di <strong>votare</strong>: i problemi più votati vengono risolti prima di altri.';
$string['donations'] = 'Moodle è libero da qualsiasi obbligo finanziario, ciononostante molti tra gli appartenenti alla comunità hanno donato al progetto, aiutando a retribuire gli sviluppatori che fanno vivere Moodle.';
$string['donationsmoney'] = 'Puoi anche contribuire donando denaro direttamente al fondo. Il denaro ricevuto verrò utilizzato per trasformare le funzionalità desiderate in progetti realizzabili inseriti nella roadmap di sviluppo. Puoi donare tramite carta di credito nella valuta preferita usando il pulsante PayPal qui sotto.<br /><br />Coloro che donano un cifra superiore a 10$ potranno inserire il loro nome in questa pagina per un anno. Ricorda di premere il pulsante "continua" subito dopo la donazione per accedere al form dove potrai inserire i dati che compariranno nella pagina.';
$string['donationsservices'] = 'Se hai bisgono di servizi Moodle, come supporto, installazione, hosting, sviluppo di codice, realizzazione di corsi e consulenza, puoi contatatre il tuo <a href="http://moodle.com/">Moodle Partner from moodle.com</a> autorizzato. (Puoi vedere i loro banner su questo sito). I Partner versano una percentuale fissa di loro introiti al fondo di sviluppo Moodle, gestito dal Moodle Trust, realizzando un circolo virtuoso.';
$string['donationstitle'] = 'Donazioni';
$string['donationstrust'] = 'Moodle dispone di un fondo per lo sviluppo gestito dal Moodle Trust tramite il quale vengono retribuiti programmatori che la sviluppano Moodle e che finanzia le spese fi gestione di moodle.org';
$string['downloadcore'] = 'Il nostro metodo principale di distribuzione è attraverso i seguenti pacchetti core. I pacchetti core includono una serie di moduli mantenuti ed aggiornati dagli sviluppatori core di Moodle: sono particolarmente indicati per installare Moodle su qualunque sistema dove il PHP è già disponibile.';
$string['downloadcoretitle'] = 'Pacchetti Moodle standard';
$string['downloadintro'] = 'Moodle è open source in accordo alla <a href="http://docs.moodle.org/dev/License">Licenza GPL</a>. Qualsiasi cosa da noi realizzata è liberamente disponibile per il download.';
$string['downloadlang'] = 'Nella attuale versione di Moodle, l\'installazione di language pack è stata automatizzata ed è reperibile nele opzioni di amministrazione. Per alcune  versioni obsolete di Moodle è necessario scaricare i language pack manualmente.';
$string['downloadlangtitle'] = 'Language pack';
$string['downloadlogotitle'] = 'Loghi Moodle';
$string['downloadmac'] = 'Se non disponi di un web server già pronto, questi pacchetti all-in-one facilitano l\'installazione di Moodle su Mac OS X';
$string['downloadmactitle'] = 'Moodle per Mac OS X';
$string['downloadmodules'] = 'Sfoglia il nostro vasto database di moduli e plugin extra per espandere le funzionalità core di Moodle.';
$string['downloadmodulestitle'] = 'Plugin';
$string['downloadthemes'] = 'L\'aspetto di Moodle può essere cambiato a piacimento usando i temi. Abbiamo un database di temi creati e resi disponibili dagli stessi utenti di Moodle.';
$string['downloadthemestitle'] = 'Temi';
$string['downloadviagitcvs'] = 'Ulteriori modi per scaricare Moodle: <a href="http://docs.moodle.org/en/Git_for_Administrators">tramite Git</a> oppure <a href="http://docs.moodle.org/22/en/CVS_for_Administrators">tramite CVS</a>.';
$string['downloadwin'] = 'Se non disponi di un web server già pronto, questi pacchetti all-in-one facilitano l\'installazione di Moodle Moodle su Microsoft Windows';
$string['downloadwintitle'] = 'Moodle per Windows';
$string['erroradminonly'] = 'Solo gli amministratori hannoa accesso a questa interfaccia';
$string['erroralreadyvoted'] = 'Hai già votato per {$a}';
$string['errormaxmessages'] = 'Ci dispiace ma non è possibile inviare più di 3 messaggi.';
$string['errornomainnews'] = 'Non è stato possibile trovare né creare un forum news per il sito';
$string['errorsendingmail'] = 'Si è verificato un errore durante l\'invio del messaggio. Per favore riprova più tardi o contatta l\'amministratore del sito.';
$string['events'] = 'Anche se siamo specializzati nella formazione on line, è pur sempre piacevole incontrarsi! Esplora questi link per ottenere maggiori informazioni sulle conferenze (che noi chiamiamo MoodleMoot) ed altri eventi.';
$string['eventstitle'] = 'Eventi';
$string['feed_events'] = 'Eventi';
$string['feed_events_more'] = 'Ulteriori eventi';
$string['feed_news'] = 'Annunci';
$string['feed_news_more'] = 'Visualizza tutti gli annunci';
$string['feed_resources'] = 'Risorse';
$string['feed_useful'] = 'Post utili';
$string['feed_useful_more'] = 'Ulteriori post';
$string['focusbox_community'] = 'Discussioni di community';
$string['focusbox_community_text'] = 'Partecipa alle discussioni e condividi idee e soluzioni con Moodler di tutto il mondo';
$string['focusbox_community_viewall'] = 'Elenco delle community';
$string['focusbox_future'] = 'Contribuisci a disegnare il futuro di Moodle';
$string['focusbox_future_text'] = 'Scopri di più e aiuta a fare la differenza';
$string['focusbox_settingup'] = 'Installazione';
$string['focusbox_settingup_own'] = 'In proprio';
$string['focusbox_settingup_partner'] = 'Con un Moodle Partner';
$string['focusbox_teaching'] = 'Formare con Moodle';
$string['focusbox_teaching_text'] = 'Esplora l\'ampia gamma di caratteristiche e risorse';
$string['focusbox_theproject'] = 'Il progetto Moodle';
$string['focusbox_theproject_stats'] = 'Statistiche';
$string['focusbox_theproject_text'] = 'Approfondisci il progetto Moodle e la nostra partnership aperta e collaborativa';
$string['focusbox_uptodate'] = 'Rimani aggiornato';
$string['focusbox_uptodate_text'] = 'Novità, aggiornamenti e informazioni su Moodle provenienti tutto il mondo.';
$string['frontpagewelcome1'] = 'Moodle è un Open Source Course Management System (CMS), noto anche come Learning Management System (LMS) o Virtual Learning Environment (VLE). Moodle è una applicazione web libera che i formatori possono utilizzare per creare siti di formazione efficaci.';
$string['frontpagewelcome2'] = 'Moodle.org è il nostro sito di comunità dove si discute e si realizza Moodle. Utilizza i menù per esplorare il sito ed unirti alla comunità!';
$string['frontpagewelcometitle'] = 'Benvenuto nella comunità di Moodle!';
$string['generaldeveloperforum'] = 'Forum generale degli sviluppatori';
$string['graphpopulation'] = 'Utenti di Moodle.org';
$string['graphregistrationmap'] = 'Mappa delle registrazioni Moodle';
$string['graphregistrationmapdesc'] = 'I 10 siti registrati più grandi presenti in {$a} nazioni';
$string['graphusersites'] = 'Numero di utenti per sito Moodle';
$string['heroslide_community_description'] = 'Benvenuto nella community Moodle dove potrai scoprire il valore di un impegno aperto e collaborativo di uno dei gruppi open source più grande al mondo';
$string['heroslide_community_headline'] = 'Guidato dalla community, supportato globalmente';
$string['heroslide_community_slidecontrol'] = 'Guidato da una community globale';
$string['heroslide_global_description'] = 'Con oltre 95 lingue disponibili, a Moodle si affidano aziende ed istituzioni di tutte le dimensioni, con milioni di utenti in tutto il mondo';
$string['heroslide_global_headline'] = 'Alimentiamo ambienti di apprendimento in tutto il mondo';
$string['heroslide_global_slidecontrol'] = 'Alimentiamo ambienti di apprendimento in tutto il mondo';
$string['heroslide_link_demo'] = 'Demo';
$string['heroslide_link_features'] = 'Caratteristiche';
$string['heroslide_link_sites'] = 'Siti registrati';
$string['heroslide_link_stats'] = 'Statistiche';
$string['heroslide_link_stories'] = 'Ulteriori informazioni';
$string['heroslide_power_description'] = 'L\'ambiente di apprendimento globale che ti aiuta a creare esperienze formative e collaborative di successo.';
$string['heroslide_power_headline'] = 'Potente. Sicuro. Open source.';
$string['heroslide_power_slidecontrol'] = 'Un completo ambiente di apprendimento open source';
$string['heroslide_story_description'] = '“Leading in technology enabled learning enables us to facilitate student discovery, creativity and opportunity.” - Professore Darrel Evans, Pro Vice-Chancellor (Learning and Teaching), Università di Monash';
$string['heroslide_story_headline'] = 'Miglioriamo ovunque la formazione e l\'apprendimento';
$string['heroslide_story_slidecontrol'] = 'Storie di Moodle da tutto il mondo';
$string['jobs'] = 'Visita il nostro database di opportunità di lavoro su Moodle.';
$string['logoinfo'] = 'Il nome Moodle™ è un marchio registrato del Moodle Trust.

Se intendi utilizzare il nome e/o il logo per pubblicizzare servizi Moodle (ad esempio hosting Moodle, supporto Moodle, certificazione Moodle, personalizzazioni Moodle, sviluppo corsi per Moodle, temi per Moodle, integrazioni con Moodle, istallazione Moodle, eccetera) oppure se intendi usare il nome come nome di un pacchetto software, allora devi ottenere un\'autorizzazione scritta dal Moodle Trust tramite il [moodle.com helpdesk](http://moodle.com/helpdesk/), in accordo alle normative sui marchi registrati.

Non ci sono limitazioni all\'uso del nome Moodle in altri contesti (ad esempio se usi Moodle per i tuoi corsi è possibile riferirsi al nome liberamente). Se hai dubbi per casi particolari, contattaci tramite il [moodle.com helpdesk](http://moodle.com/helpdesk/). Saremo lieti di fornirti l\'autorizzazione se del caso oppure ti aiuteremo a modificare l\'utilizzo del nome.';
$string['logotitle'] = 'Logo Moodle';
$string['moodledocs'] = 'Moodle Docs';
$string['moodlepartner_corporate'] = 'Formazione coprorate';
$string['moodlepartner_other'] = 'Altri settori';
$string['moodlepartner_school'] = 'Scuole';
$string['moodlepartner_university'] = 'Università';
$string['mycoursesintro'] = 'Questi sono i "corsi" di questo sito di comunità ai quali sei iscritto. Ogni corsi contiene uno o più forum.';
$string['nameabout'] = 'Informazioni';
$string['nameaboutmoodle'] = 'Informazioni';
$string['namecommercial'] = 'Servizi commerciali';
$string['namecommunity'] = 'Comunità';
$string['namecontact'] = 'Contatti';
$string['namedevelopment'] = 'Sviluppo';
$string['namedocumentation'] = 'Documentazione';
$string['namedownloads'] = 'Download';
$string['nameevents'] = 'Eventi';
$string['nameforums'] = 'Forum';
$string['namemycourses'] = 'I miei corsi';
$string['namenetwork'] = 'Siti collegati';
$string['namenews'] = 'Notizie';
$string['namesecurity'] = 'Notizie sulla sicurezza';
$string['namesupport'] = 'Supporto';
$string['networkinfo'] = 'I siti Moodle che seguono sono collegati via Moodle networking e puoi autenticarti da questo sito.';
$string['networkintro'] = 'I siti che sguono sono collegati a moode.org tramite il Moodle Networking e Potete accedervi direttamente da questo sito.';
$string['networktitle'] = 'Siti collegati';
$string['newregistrations'] = 'Nuove registarzioni';
$string['newstitle'] = 'Annunci';
$string['noenrolledcoursesyet'] = 'Al momento non sei iscritto in nessun corso presente in questo sito';
$string['partnerslogan'] = 'Il progetto Moodle è supportato in tutto il mondo da 60 Moodle Partner certificati. <br/><a href="http://moodle.com/partners/about/">Scopri di più</a> sul programma Moodle Partner program e <a href="http://moodle.com/partners">trova un Moodle Partner</a> vicino a te.';
$string['permalink'] = 'Permalink';
$string['pluginname'] = 'Sito Moodle.org';
$string['popularissues'] = 'Problemi più gettonati';
$string['recentlyratedposts'] = 'Post valutati recentemente';
$string['recentpart'] = 'Questa pagina mostra alcune delle persone che stanno usando moodle.org';
$string['registeredsites'] = 'Moodle è Open Source e quindi non ci sono obblighi da parte di nessuno di informare che sta usando Moodle. Ciononostante, molti siti Moodle preferiscono registrarsi in modo da consentirci di avere un elenco.';
$string['registeredsitestitle'] = 'Siti registrati';
$string['registereduserslastday'] = 'Nuovi utenti nelle ultime 24 ore:';
$string['registereduserstotal'] = 'Totale utenti registrati:';
$string['registrationgraphalt'] = 'Storico di tutte le registrazioni di siti Moodle';
$string['registrationgraphdesc'] = 'Per assicurare l\'attendibilità delle statistiche, eseguiamo un <a href="http://docs.moodle.org/en/Usage">controllo periodico di tutti i siti</a> per essere sicuri che esistano. Di tanto in tanto è possibile che si verifichino riduzioni di numero.';
$string['registrationslast6months'] = 'Utenti registrati nei 6 mesi scorsi:';
$string['registrationstotal'] = 'Utenti registrati ad oggi:';
$string['roadmap'] = 'Moodle Roadmap';
$string['rssdescription'] = 'Post recenti o utili provenienti da moodle.org';
$string['rsstitle'] = 'Post dai forum di Moodle.org';
$string['searchmoodleorg'] = 'Cerca su moodle.org';
$string['securitytitle'] = 'Annunci di sicurezza';
$string['shop'] = 'Vuoi mostrare la tua appartenenza alla community? Visita il nostro negozio dove  trovare magliette, tazze e tanti altri oggetti.';
$string['social-facebook-moodle'] = 'Pagina Moodle ufficiale su Facebook';
$string['social-googleplus-community'] = 'Pagina Moodle ufficiale della community su Google+';
$string['social-googleplus-moodle'] = 'Pagina Moodle ufficiale su Google+';
$string['social-linkedin-moodle'] = 'Pagina Moodle ufficiale su Linkedin';
$string['social-twitter-moodle'] = 'Annunci Moodle ufficiali, news Moodle aggregate da Planet Moodle e Moodle buzz, forum post utili.';
$string['social-twitter-moodledev'] = 'Novità e aggiornamenti sullo sviluppo di Moodle';
$string['social-twitter-moodlehq'] = 'Tweet dal Moodle HQ';
$string['social-twitter-moodlejobs'] = 'Offerte di lavoro su Moodle';
$string['social-twitter-moodlenet'] = 'Corsi e contenuti Moodle condivisi';
$string['social-twitter-moodleplugins'] = 'Plugin rilasciati di recente';
$string['social-twitter-moodleresearch'] = 'Novità ed aggiornamenti sulla conferenza annuale Moodle Reaserch e altre ricerche su Moodle';
$string['social-twitter-moodlesecurity'] = 'Annunci Moodle sulla sicurezza';
$string['social-twitter-moodlesites'] = 'Aggiornamenti sullo stato dei siti e dei servizi del Moodle HQ';
$string['social-twitter-moodlethemes'] = 'Temi rilasciati di recente';
$string['social-youtube-moodle'] = 'Canale Moodle ufficiale su Youtube';
$string['socialinfo'] = 'Ci trovi su molti siti di social media per rafforzare la conoscenza del progetto Moodle e condividere le ultime novità del mondo Moodle. Seguici per rimanere aggiornato e incontrare altri membri della community!';
$string['socialtitle'] = 'Social media';
$string['statscountries'] = 'Nazioni';
$string['statscourses'] = 'Corsi';
$string['statsenrolments'] = 'Inscrizioni';
$string['statsposts'] = 'Interventi forum';
$string['statsquestions'] = 'Domande';
$string['statsresources'] = 'Risorse';
$string['statsteachers'] = 'Docenti';
$string['statsusers'] = 'Utenti';
$string['supportbooks'] = 'Un elenco di libri su Moodle disponibili per l\'acquisto';
$string['supportcommercial'] = 'I Moodle Partner sono Certified Services Provider che possono aiutarti a ad implementare il tuo Moodle in tutto il mondo';
$string['supportdocs1'] = 'Moodle Docs rappresenta un ottimo punto di partenza, in particolare ti suggeriamo di leggere le nostre Frequently Asked Questions (FAQ).';
$string['supportdocs2'] = 'Un buon sistema per accedere alla documentazione è l\'uso del link "Documentazione di Moodle per questa pagina" presente in fondo alle pagine del tuo sito Moodle.';
$string['supportdocsfaq'] = 'Frequently Asked Questions';
$string['supportdocslang'] = 'Moodle Docs in altre lingue';
$string['supportforums'] = 'La nostra comunità di utilizzatori comunica tramite i forum presenti nei diversi "corsi" accesi in questo sito Moodle. Per intervenire in un forum devi "iscriverti" nel corso dove il forum è presente (l\'iscrizione è gratuita).';
$string['supportforumsenglish'] = 'I forum principali di discussione e di supporto tra utenti e sviluppatori si svolgono in lingua inglese:';
$string['supportforumsenglishname'] = 'Usare Moodle';
$string['supportforumslang'] = 'Il forum principale per i Moodlers (in inglese) si trova qui:';
$string['supportforumslangname'] = 'Moodle Lounge';
$string['supportforumslangurl'] = 'http://moodle.org/course/view.php?id=55';
$string['supportforumslist'] = 'Abbiamo molti altri forum, in diverse lingue:';
$string['supportforumslistname'] = 'Elenco dei corsi';
$string['supportintro'] = 'Non sei solo! Sono disponibili tanti modi per ottenere aiuto su Moodle';
$string['top10countriesbyregistration'] = 'Top 10 nazioni per numero di registrazioni';
$string['top10sitesbycourses'] = 'Top 10 siti per numero di corsi';
$string['top10sitesbyusers'] = 'Top 10 siti per numero di utenti';
$string['url-about'] = 'http://docs.moodle.org/en/About_Moodle';
$string['url-standards'] = 'http://docs.moodle.org/en/Standards';
$string['versionsused'] = 'Versioni utilizzate';
