<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_shoehorn', language 'es_mx', version '3.5'.
 *
 * @package     theme_shoehorn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accordion'] = 'Usar acordeón de bloques de regiones laterales';
$string['accordion_desc'] = 'Habilite esta opción para usar la funcionalidad de acordeón para las regiones laterales. Nota: Desabilita el orillar.';
$string['always'] = 'Siempre';
$string['antigravity'] = 'Regresar arriba';
$string['blocktitleunknown'] = 'Título del bloque desconocido';
$string['cdnfonts'] = 'Letras de red de suministro de contenido de ser posible';
$string['cdnfonts_desc'] = 'Usar letras de red de suministro de contenido de ser posible. Así se vuelve una fuente CDN disponible.';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Calzador (Shoehorn)</h2>
<p><img class="img-polaroid" src="shoehorn/pix/Shoehorn_logo.png" /></p>
</div>
<div class="well">
<h3>Acerca de</h3>
<div class="lead"><p>Calzador (Shoehorn) es un tema basado en Bootstrap v3 que tiene muchas características innovadoras:</p>
<ul>
<li>Declaratoria de copyright hecha a la medida.</li>
<li>Mensaje de página de ingreso hecho a la medida.</li>
<li>Menú de pie de página dinámico y personalizable.</li>
<li>Signos de íconos sociales dinámicos con colores correctos de íconos.</li>
<li>Deslizador de portada que puede deshabiltarse para tabletas /  teléfonos, reduciendo el ancho de banda.</li>
<li>Bloques de pie de página.</li>
<li>Banco de imágenes para almacenar imágenes que Usted puede usar en cualquier lugar en el sitio.</li>
<li>Control individual sobre: deslizadores de la portada, puntos de publicidad y páginas del sitio con:</li>
<ul>
<li>Estado de \'Borrador\' / \'Publicado\'.</li>
<li>Visibilidad \'antes de ingresar\', \'después de ingresar\' o \'siempre\'.</li>
<li>Configurar visibilidad de solamente idioma específico.</li>
</ul><li>Puntos de publicidad.</li>
<li>Bloques al fondo de la página.</li>
<li>Páginas del sitio que Usted puede personalizar con su propio contenido.</li>
<li>Navagación por deslizador del contenido del curso con la configuración del diseño del curso en \'Una sección por página\'.</li>
</ul>
<h3>Padres</h3>
<p>Este tema está basado en el tema de Arranque (Bootstrap), que fue creado para Moodle 2.6 por: Bas Brands, David Scotson y muchos otros contribuyentes.</p>
<h3>Créditos del tema</h3>
<p>Autor: G J Barnard - <a href="//about.me/gjbarnard" target="_blank">Acerca.de.mí</a> - <a href="//moodle.org/user/profile.php?id=442195">Perfil en Moodle</a> - <a href="//uk.linkedin.com/in/gjbarnard">Linkedin</a></p>
<h3>Reporte un problema:</h3>
<p><a href="//github.com/gjb2048/moodle-theme_shoehorn/issues">Problemas con Shoehorn.</a></p>
<h3>Más información</h3>
<p><a href="shoehorn/Readme.md">Como usar este tema.</a></p>
</div></div>';
$string['compactnavbar'] = 'Barrra de Navegación compacta';
$string['compactnavbar_desc'] = 'Barra de navegación compacta';
$string['configtitle'] = 'Shoelace (Agujeta)';
$string['copyright'] = 'Copyright';
$string['copyright_desc'] = 'Declaración de Copyright, dejar vacío si no hubiera.';
$string['coursecontentsearch'] = 'Búscar contenidos del curso';
$string['coursecontentsearchdesc'] = 'Habilitar buscar en contenidos del curso en la página del \'Tablero\'. Solamente funciona cuando Shoehorn no está en \'\\$CFG->themedir\'.';
$string['coursetiles'] = 'Usar mosaicos de curso';
$string['coursetiles_desc'] = 'Usar mosaicos de curso para actividades y recursos';
$string['credit'] = 'El tema Shoehorn (Calzador) para Moodle es desarrollado y mantenido por';
$string['customcss'] = 'CSS personalizado';
$string['customcss_desc'] = 'Las reglas CSS que añada en esta área se reflejarán en todas las páginas, haciendo más fácil la personalización del tema.';
$string['displaymycourses'] = 'Mostrar mis cursos';
$string['displaymycourses_desc'] = 'Mostrar sus cursos en la página de \'Mi hogar\'.';
$string['displaymycoursesmenu'] = 'Mostrar menú de mis cursos';
$string['displaymycoursesmenu_desc'] = 'Mostrar el menú de mis cursos en la barra de navegación con el título dado.';
$string['docking'] = 'Usar orillar';
$string['docking_desc'] = 'Habilite esta opción para usar orillamiento';
$string['draft'] = 'Borrador';
$string['editonmainpage'] = 'Por favor edite en la página principal del curso';
$string['eightyfivepercent'] = '85%';
$string['eightypercent'] = '80%';
$string['enter'] = 'Escriba';
$string['fifteenpercent'] = '15%';
$string['fiftypercent'] = '50%';
$string['fifyfivepercent'] = '5%';
$string['findcoursecontent'] = 'Contenido del curso';
$string['fitvids'] = 'Usar FitVids';
$string['fitvidsdesc'] = 'Habilite FitVids (fitvidsjs.com) para hacer responsivos sus videos incrustados. Cuando FitVids está activado, si Usted quiere que un video sea excluido, entonces añada \'class="fitvidsignore"\' a la marca \'iframe\' en el modo HTML del editor. Por ejemplo: \'iframe class="fitvidsignore" width="420" height="315" src="//www.youtube.com/embed/enmEmym85xc" frameborder="0" allowfullscreen=""></iframe\'.';
$string['fivepercent'] = '5%';
$string['fontawesome'] = 'Usar la letra de íconos FontAwesome';
$string['fontawesome_desc'] = 'Habilite esta opción para usar la letra de íconos FontAwesome.';
$string['fontfileeotbody'] = 'Archivo de tipo de letra EOT para el Texto';
$string['fontfileeotheading'] = 'Archivo de tipo de letra EOT para Encabezado (\'\'Heading\'\')';
$string['fontfileotfbody'] = 'Archivo de tipo de letra OTF para el Texto';
$string['fontfileotfheading'] = 'Archivo de tipo de letra OTF para Encabezado (\'\'Heading\'\')';
$string['fontfilesvgbody'] = 'Archivo de tipo de letra SVG  para el Texto';
$string['fontfilesvgheading'] = 'Archivo de tipo de letra SVG para Encabezado (\'\'Heading\'\')';
$string['fontfilettfbody'] = 'Archivo de tipo de letra TTF para el Texto';
$string['fontfilettfheading'] = 'Archivo de tipo de letra TTF para Encabezado (\'\'Heading\'\')';
$string['fontfilewoffbody'] = 'Archivo de tipo de letra WOFF para el Texto';
$string['fontfilewoffheading'] = 'Archivo de tipo de letra WOFF para Encabezado (\'\'Heading\'\')';
$string['fontfilewofftwobody'] = 'Archivo de tipo de letra WOFF2 para el Texto';
$string['fontfilewofftwoheading'] = 'Archivo de tipo de letra WOFF2 para Encabezado (\'\'Heading\'\')';
$string['fontheadingdesc'] = 'Seleccione y escriba los tipos de letra (\'\'fonts\'\') que Usted desea usar en su entorno Moodle.';
$string['fontheadingsub'] = 'Configuraciones de Tipos de letras (\'\'fonts\'\')';
$string['fontnamebody'] = '\'\'Font\'\' para texto';
$string['fontnamebodydesc'] = 'Escriba el nombre exacto del tipo de letra (\'\'font\'\') a usar para el demás texto.';
$string['fontnameheading'] = '\'\'Font\'\' del encabezado';
$string['fontnameheadingdesc'] = 'Escriba el nombre exacto del tipo de letra (\'\'font\'\') a usar para encabezados.';
$string['fontsettings'] = 'Font';
$string['footerbottomcolour'] = 'Fondo del pie de página';
$string['footerbottomcolourdesc'] = 'Color de fondo del pie de página';
$string['footermenu'] = 'Menú del pie de página';
$string['footermenu_desc'] = 'Cero o más líneas representan los enlaces a poner en el menú del pie de página.<br>
Formato de  name|url|title|lang en donde título e idioma son opcionales<br>
Si la URL está prefijada con [[site]] entonces el dominio del sitio será sustituido; por ejemplo. [[site]]/about.html se vuelve http://mimoodle/about.html o http://mimoodle/subcarpeta/about.html si Moodle estuviera en una sub-carpeta en su dominio.<br>
El título es el texto que se mostrará cuando al enlace se le pase el ratón encima.<br>
El idioma es para solamente mostrarlo en ese idioma.<br>
Por ejemplo:<br>
About|http://misitioweb/about.html|Acerca de mi sitio<br>
About|[[site]]/about.html|Acerca de mi sitio<br>
Anleitung|http://mimoodle/anleitung.html|Wie man mit dieser Website verwenden.|de<br>
Home|//mimoodle/index.php';
$string['footertextcolour'] = 'Texto del pie de página';
$string['footertextcolourdesc'] = 'Color del texto del pie de página';
$string['footertopcolour'] = 'Superior del pie de página';
$string['footertopcolourdesc'] = 'Color de la parte superior del pie de página.';
$string['fortyfivepercent'] = '45%';
$string['fortypercent'] = '40%';
$string['four'] = 'Cuatro';
$string['frontpagenumberofslides'] = 'Número de deslizadores de portada';
$string['frontpagenumberofslides_desc'] = 'Número de imágenes en el deslizador de la portada.';
$string['frontpageslidecaptiontext'] = 'Texto de subtítulos de imagen {$a->slide}';
$string['frontpageslidecaptiontext_desc'] = 'El texto de subtítulos para la imagen {$a->slide}';
$string['frontpageslidecaptiontitle'] = 'Texto de subtítulos de imagen {$a->slide}';
$string['frontpageslidecaptiontitle_desc'] = 'El texto de subtítulos para la imagen {$a->slide}';
$string['frontpageslidedisplay'] = 'Estatus de imagen {$a->slide}';
$string['frontpageslidedisplay_desc'] = 'Cuando mostrar la imagen {$a->slide}.';
$string['frontpageslideimage'] = 'Imagen de imagen {$a->slide}';
$string['frontpageslideimage_desc'] = 'La imagen para la imagen {$a->slide}';
$string['frontpageslidelang'] = 'Idioma para la imagen {$a->slide}';
$string['frontpageslidelang_desc'] = 'Idioma de imagen número {$a->slide}. Para ver más idiomas, instale paquetes de idioma en \'{$a->url}\'. Configure a \'todos\' para todos los idiomas.';
$string['frontpagesliderheading'] = 'Deslizador de Portada';
$string['frontpagesliderheadingdesc'] = 'Presente su portafolios con imágenes que contengan una imagen, URL o texto. Para cambiar el número de imágenes cambie el \'Número de imágenes en Portada\' inferior y guarde la página para actualizarla. La mejor altura para una imagen es de 500 pixeles, ya que este es el espacio máximo para resolución de pantalla mayor a 1200 pixeles de ancho. Las dimensiones son calculadas después basándose en el espacio disponible y la proporción de la imagen.';
$string['frontpagesliderheadingsub'] = 'Presentar su portafolio con imágenes en la portada';
$string['frontpageslidermobile'] = 'Mostrar deslizador de Portada en dispositivos móviles';
$string['frontpageslidermobile_desc'] = 'Muestra el deslizador de Portada en dispositivos móviles.';
$string['frontpageslidersettingspageheading'] = 'Imagen {$a->slide}';
$string['frontpagesliderspeed'] = 'Configurar la velocidad de transición del deslizador en ms';
$string['frontpagesliderspeed_desc'] = 'Configurar la velocidad de transición del deslizador en milisegundos. Configure a 0 para control manual.';
$string['frontpageslidertablet'] = 'Mostrar deslizador de portada en tableta';
$string['frontpageslidertablet_desc'] = 'Mostrar el deslizador de portada en  dispositivos tabletas.';
$string['frontpageslidestatus'] = 'Estatus de imagen {$a->slide}';
$string['frontpageslidestatus_desc'] = 'Configure a \'Borrador\' cuando Usted esté creando la imagen y en \'Publicada\' cuando Usted quiera que se vea, tomando en cuenta las configuraciones para mostrar y el  idioma.';
$string['frontpageslideurl'] = 'URL de imagen {$a->slide}';
$string['frontpageslideurl_desc'] = 'La URL para imagen {$a->slide}';
$string['generalsettings'] = 'General';
$string['gotobottom'] = 'Ir al fondo de la página';
$string['iewarning'] = 'Calzador (Shoehorn) requiere Internet Explorer 10+, Usted está usando IE{$a->ieversion}, actualícelo por favor.';
$string['imagebankheading'] = 'Banco de imágenes';
$string['imagebankheadingdesc'] = 'Para cambiar el número de imágenes disponibles en el banco de imágenes, cambie el \'Número de imágenes en el banco de imágenes\' debajo y guarde la página para actualizarla.,';
$string['imagebankheadingsub'] = 'Usar imágenes en cualquier parte al emplear el banco de imágenes.';
$string['imagebankimage'] = 'Imagen';
$string['imagebankimage_desc'] = 'URL de imagen a copiar: \'{$a->imagedesc}\' y usar, por ejemplo, insertarla en un editor HTML.';
$string['inversenavbar'] = 'Invertir Barra de Navegación';
$string['inversenavbar_desc'] = 'Alterna el texto y el fondo de la Barra de Navegación en la parte superior de la página.';
$string['landfallhorizontalquiz'] = 'Diseño horizontal';
$string['landfallhorizontalquiz_desc'] = 'Configurar el examen a que tenga un diseño horizontal.';
$string['landfallpages'] = 'Todas las páginas';
$string['landfallpages_desc'] = 'Aspecto de todas las páginas exceptuando la portada.';
$string['landfallpagesbackgroundimage'] = 'Imagen del fondo de todas las páginas';
$string['landfallpagesbackgroundimage_desc'] = 'Configurar la imagen del fondo de todas las páginas.';
$string['landfallpagescontenttransparency'] = 'Transparencia del contenido de todas las páginas';
$string['landfallpagescontenttransparency_desc'] = 'Configurar la transparencia del contenido de todas las páginas.';
$string['landfcolours'] = 'Colores';
$string['landfcolours_desc'] = 'Configuraciones de colores.';
$string['landffontpage'] = 'Portada';
$string['landffontpage_desc'] = 'Configuraciones del aspecto de la Portada.';
$string['landffrontpagebackgroundimage'] = 'Imagen del fondo de la Portada';
$string['landffrontpagebackgroundimage_desc'] = 'Configurar la imagen del fondo de la Portada.';
$string['landffrontpagecontenttransparency'] = 'Transparencia del contenido de la Portada';
$string['landffrontpagecontenttransparency_desc'] = 'Configurar la transparencia del contenido de la Portada';
$string['landfheading'] = 'Configuraciones del aspecto';
$string['landfheadingdesc'] = 'Cambiar varios aspectos del aspecto con estas configuraciones.';
$string['landfheadingsub'] = 'Cambiar varios aspectos del aspecto con estas configuraciones.';
$string['landflayout'] = 'Diseño';
$string['landflayoutbutton'] = 'Bloque, Contenido, Bloque';
$string['landflayoutdesc'] = 'Orden del diseño. Segunda área de bloque solamente si se especifica en \'config.php\'.';
$string['landflayoutheading_desc'] = 'Configuraciones del diseño';
$string['landflayoutstep'] = 'Contenido, Bloque, Bloque';
$string['landfquiz'] = 'Examen';
$string['landfquiz_desc'] = 'Configuraciones del aspecto y apariencia del examen.';
$string['langpack_urlname'] = 'Paquetes de idioma';
$string['linkcolour'] = 'Enlace';
$string['linkcolourdesc'] = 'Color del enlace';
$string['loggedin'] = 'Ingresado';
$string['loggedinas'] = 'Usted está ingresado como un \'{$a}\', regresar a mi rol normal';
$string['loggedout'] = 'Salido';
$string['loginbackgroundchangerfade'] = 'Configurar la disolvencia de transición de imagen en ms';
$string['loginbackgroundchangerfade_desc'] = 'Configurar la disolvencia de transición de imagen en milisegundos';
$string['loginbackgroundchangerheading'] = 'Cambiador de imagen del fondo de página para ingresar';
$string['loginbackgroundchangerheadingdesc'] = 'Para cambiar el número de imágenes, caambie el \'Número de imágenes\' inferior y guarde la página para actualizarla.';
$string['loginbackgroundchangerheadingsub'] = 'Haga diferente la página para ingresar al cambiarle las imágenes del fondo.';
$string['loginbackgroundchangerimage'] = 'Imagen {$a->image}';
$string['loginbackgroundchangerimage_desc'] = 'La imagen {$a->image}';
$string['loginbackgroundchangermobile'] = 'Mostrar cambiador de imagen del fondo en móvil';
$string['loginbackgroundchangermobile_desc'] = 'Mostrar el cambiador de imagen del fondo en dispositivos móviles';
$string['loginbackgroundchangernumberofimages'] = 'Número de imágenes';
$string['loginbackgroundchangernumberofimages_desc'] = 'Número de imágenes en el cambiador de imágenes del fondo.';
$string['loginbackgroundchangerspeed'] = 'Configurar la velocidad de transición de imágenes en ms';
$string['loginbackgroundchangerspeed_desc'] = 'Configurar la velocidad de transición de imágenes en milisegundos.';
$string['loginbackgroundchangertablet'] = 'Mostrar cambiador de imagen del fondo en tableta';
$string['loginbackgroundchangertablet_desc'] = 'Mostrar el cambiador de imagen del fondo en dispositivos de tableta.';
$string['loginmessage'] = 'El mensaje de ingreso';
$string['loginmessage_desc'] = 'Breve mensaje de ingreso a mostrar. Déjelo vacío para usar la cadena de caracteres \'theloginmessage\' contenida en el paquete del idioma. Aquí puede Usted usar la funcionalidad multi-idioma de Moodle.';
$string['loginpage'] = 'Página de ingreso';
$string['loginpage_desc'] = 'Configuraciones de la página de ingreso';
$string['logo'] = 'Logo';
$string['logo_desc'] = 'Por favor, suba aquí su logo personalizado si quisiera añadirlo al encabezado.<br>
Si la altura de su logo fuera mayor de 75 pixeles, añada la siguiente regla CSS a la caja de texto de CSS personalizado inferior.<br>
a.logo {height: 100px;} o cualquier altura en pixeles que tenga su logo.';
$string['marketingspotcontent'] = 'Contenido del Bloque Publicitario {$a->spot}.';
$string['marketingspotcontent_desc'] = 'Contenido del Bloque Publicitario número {$a->spot}.';
$string['marketingspotdisplay'] = 'Estatus del Bloque Publicitario {$a->spot}';
$string['marketingspotdisplay_desc'] = 'Cuando mostrar el Bloque Publicitario {$a->spot}.';
$string['marketingspotheading'] = 'Encabezado del Bloque Publicitario {$a->spot}';
$string['marketingspotheading_desc'] = 'Encabezado del Bloque Publicitario número {$a->spot}.';
$string['marketingspotlang'] = 'Idioma del Bloque Publicitario {$a->spot}';
$string['marketingspotlang_desc'] = 'Bloque Publicitario {$a->spot}. Para ver más idiomas, instale paquetes de idioma en  \'{$a->url}\'. Configure a  \'todos\' para todos los idiomas.';
$string['marketingspotsettingspageheading'] = 'Bloque Publicitario {$a->spot}';
$string['marketingspotsheading'] = 'Bloques Publicitarios';
$string['marketingspotsheadingdesc'] = 'Para cambiar el número de bloques publicitarios, cambie el \'Número de Bloques Publicitarios\' debajo y guarde la página para actualizarla.';
$string['marketingspotsheadingsub'] = 'Anuncie su sitio con bloques publicitarios';
$string['marketingspotstatus'] = 'Estatus del Bloque Publicitario {$a->spot}';
$string['marketingspotstatus_desc'] = 'Configure a \'Borrador\' cuando Usted esté creando el promocional y \'Publicado\' cuando Usted quiera que se vea, tomando en cuenta las configuraciones de visualización e idioma.';
$string['myclasses'] = 'Mis clases';
$string['mycourses'] = 'Mis cursos';
$string['mymodules'] = 'Mis módulos';
$string['mysubjects'] = 'Mis asuntos';
$string['myunits'] = 'Mis unidades';
$string['navbarbackgroundcolour'] = 'Fondo de Barra de Navegación';
$string['navbarbackgroundcolourdesc'] = 'Color del fondo de la Barra de Navegación.';
$string['navbarbordercolour'] = 'Orilla de la Barra de Navegación';
$string['navbarbordercolourdesc'] = 'Color de la orilla de la Barra de Navegación';
$string['navbarfixedtop'] = 'Barra de Navegación fija arriba';
$string['navbarfixedtop_desc'] = 'Fijar la Barra de Navegación el la parte superior de la página.';
$string['navbartextcolour'] = 'Texto de la Barra de Navegación';
$string['navbartextcolourdesc'] = 'Color del texto de la Barra de Navegación';
$string['ninetyfivepercent'] = '95%';
$string['ninetypercent'] = '90%';
$string['noenrolments'] = 'Sin inscripciones actuales';
$string['none'] = 'ninguno/a';
$string['nosectionstoshow'] = 'Sin secciones para mostrar';
$string['numberofimagebankimages'] = 'Número de imágenes en el banco de imágenes';
$string['numberofimagebankimages_desc'] = 'Número de imágenes que Usted quiere en el banco de imágenes.';
$string['numberofmarketingspots'] = 'Número de Bloques Publicitarios';
$string['numberofmarketingspots_desc'] = 'Número de Bloques Publicitarios que desea añadir';
$string['numberofsitepages'] = 'Número de páginas del sitio';
$string['numberofsitepages_desc'] = 'Número de páginas del sitio a añadir. Se añadirá automáticamente un enlace al menú del pie de página.';
$string['numberofsociallinks'] = 'Número de enlaces a redes sociales';
$string['numberofsociallinks_desc'] = 'Número de enlaces a redes sociales que Usted quiere añadir.';
$string['numpagebottomblocks'] = 'Número máximo de bloques por fila en el fondo de la página';
$string['numpagebottomblocks_desc'] = 'El número máximo de bloques por fila en el fondo de la página.';
$string['one'] = 'Uno';
$string['onehundredpercent'] = '100%';
$string['pagebottomcolour'] = 'Fondo de la página';
$string['pagebottomcolourdesc'] = 'Color del fondo de la página';
$string['pageheadertextcolour'] = 'Color del texto del encabezado de página';
$string['pageheadertextcolourdesc'] = 'Color del texto del encabezado de página. No tieneaya una imagen de fondo. efecto alguno donde h';
$string['pagenotdisplayedcontent'] = 'La página del sitio número {$a->pageid} noha sido configurada para el criterio actual; pídale a un administrador que revise las configuraciones para el tema.';
$string['pagenotdisplayedcontentnotitle'] = 'La página del sitio número {$a->pageid} no tiene título; pídale a un administrador que revise las configuraciones para el tema.';
$string['pagenotdisplayedcontentnotpublished'] = 'La página del sitio número {$a->pageid} no ha sido publicada; pídale a un administrador que revise las configuraciones para el tema.';
$string['pagenotdisplayedtitle'] = 'Página del sitio número {$a->pageid} no mostrada';
$string['pagetopcolour'] = 'Parte superior de la página';
$string['pagetopcolourdesc'] = 'Color de la parte superior de la página.';
$string['people'] = 'Gente';
$string['pluginname'] = 'Shoehorn (Calzador)';
$string['published'] = 'Publicado';
$string['readme_desc'] = 'Por favor haga click en \'{$a->url}\' para mucha información acerca de Calzador (Shoehorn).';
$string['readme_title'] = 'Léame de Calzador (Shoehorn)';
$string['region-footer-post'] = 'Pie de página derecho';
$string['region-footer-pre'] = 'Pie de página izquierdo';
$string['region-page-bottom'] = 'Fondo de la página';
$string['region-side-post'] = 'Derecha';
$string['region-side-pre'] = 'Izquierda';
$string['returntosection'] = 'Regresar a sección {$a->section}';
$string['seventyfivepercent'] = '75%';
$string['seventypercent'] = '70%';
$string['showloginmessage'] = 'Mostrar mensaje de ingreso';
$string['showloginmessage_desc'] = 'Mostrar un mensaje breve de ingreso justamente debajo del título de \'Ingresar\'. Esto no se pretende que remplace al \'';
$string['showloginmessage_urllink'] = 'https://docs.moodle.org/all/es/Gestionando_autenticación#Instrucciones';
$string['showloginmessage_urlname'] = 'Instrucciones para ingresar';
$string['showoldmessages'] = 'Mostrar mensajes antiguos';
$string['showoldmessagesdesc'] = 'Mostrar mensajes antiguos en el menú de mensajes.';
$string['sitepage'] = 'Página del sitio';
$string['sitepagecontent'] = 'Contenido de página del sitio {$a->pageid}';
$string['sitepagecontent_desc'] = 'Contenido de página del sitio número {$a->pageid}';
$string['sitepagedisplay'] = 'Estatus de página del sitio {$a->pageid}';
$string['sitepagedisplay_desc'] = 'Cuando mostrar la página del sitio {$a->pageid}.';
$string['sitepageheading'] = 'Encabezado de página del sitio {$a->pageid}';
$string['sitepageheading_desc'] = 'Encabezado de página del sitio número {$a->pageid}';
$string['sitepagelang'] = 'Idioma de página del sitio {$a->pageid}';
$string['sitepagelang_desc'] = 'Idioma de página de sitio número {$a->pageid}. Para ver más idiomas, instale paquetes de idioma en \'{$a->url}\'. Configure a \'todos\' para todos los idiomas.';
$string['sitepagesettingspageheading'] = 'Página del sitio {$a->pageid}';
$string['sitepagesheading'] = 'Páginas del sitio';
$string['sitepagesheadingdesc'] = 'Para cambiar el número de páginas del sitio cambie el \'Número de páginas del sitio\' inferior y guarde la página para actualizarla.';
$string['sitepagesheadingsub'] = 'Describa su sitio con páginas del sitio';
$string['sitepagestatus'] = 'Estatus de página del sitio {$a->pageid}';
$string['sitepagestatus_desc'] = 'Configure a \'Borrador\' cuando Usted esté creando la página y en \'Publicada\' cuando Usted quiera que se vea, tomando en cuenta las configuraciones de visualización e idioma.';
$string['sitepagetitle'] = 'Título de página del sitio {$a->pageid}';
$string['sitepagetitle_desc'] = 'Título de página del sitio número {$a->pageid}';
$string['sixtyfivepercent'] = '65%';
$string['sixtypercent'] = '60%';
$string['socialheading'] = 'Redes sociales';
$string['socialheadingdesc'] = 'Proporcione enlaces directos a sus redes sociales. Para cambiar el número de redes sociales, cambie el \'Número de enlaces a redes sociales\' inferior y guarde la página para actualizarla.';
$string['socialheadingsub'] = 'Junte seguidores con redes sociales';
$string['socialnetworkicon'] = 'Ícono para redes sociales';
$string['socialnetworkicon_desc'] = 'Ícono de red social número';
$string['socialnetworklink'] = 'Enlace a redes sociales';
$string['socialnetworklink_desc'] = 'Ícono de red social número';
$string['socialsignpost'] = 'Use el señalizador';
$string['socialsignpost_desc'] = 'Habilite esta opción para usar el señalizador para rodear los íconos sociales.';
$string['styleguide'] = 'Guía de estilo';
$string['styleguidesub'] = 'Guía de estilo de Bootstrap V3.3.6';
$string['syntaxhelpfive'] = 'Por ejemplo:';
$string['syntaxhelpfour'] = 'Alias de Brocha';
$string['syntaxhelpone'] = 'Añada el html \'{$a->html}\' tal resumen del curso en modo HTML.';
$string['syntaxhelpseven'] = 'Más información al respecto';
$string['syntaxhelpsix'] = 'se vuelve:';
$string['syntaxhelpthree'] = 'Nombre de Brocha';
$string['syntaxhelptwo'] = 'Entonces, cuando edite (por ejemplo, una etiqueta), rodee su código con una marca)  \'pre\' y añada  class="brush: alias" en donde \'alias\' es uno de los siguientes:';
$string['syntaxhighlight'] = 'Actiivar resaltado de sintaxis';
$string['syntaxhighlight_desc'] = 'Actiivar resaltado de sintaxis en cursos. Una página de ayuda se añadirá al menú del pie de página de los cursos.';
$string['syntaxhighlightpage'] = 'Ayuda de resaltado de sintaxis';
$string['syntaxsummary'] = '<pre class="sh"></pre>';
$string['tenpercent'] = '10%';
$string['textcolour'] = 'Texto';
$string['textcolourdesc'] = 'Color del texto.';
$string['theloginmessage'] = 'Ingrese aquí empleando su nombre_de_usuario y contraseña';
$string['thirtyfivepercent'] = '35%';
$string['thirtypercent'] = '30%';
$string['thiscourse'] = 'Este curso';
$string['three'] = 'Tres';
$string['togglenavigation'] = 'Alternar navegación';
$string['twentyfivepercent'] = '25%';
$string['twentypercent'] = '20%';
$string['two'] = 'Dos';
$string['unknownrole'] = 'rol desconocido';
$string['unknownsitepage'] = 'Pagina desconocida de sitio número';
$string['unknownsitepagecontent'] = 'La página del sitio número {$a->pageid} no es conocida; pídale a un administrador que revise las configuraciones para el tema.';
$string['unreadnewnotification'] = 'Nueva notificación';
$string['userload'] = 'Carga del usuario';
$string['userloaddesc'] = 'Gráfico de la carga del usuario';
$string['userloadpostfix'] = 'm';
$string['zeropercent'] = '0%';
